-- MariaDB dump 10.17  Distrib 10.4.11-MariaDB, for Win64 (AMD64)
--
-- Host: localhost    Database: ferreteriaalejandra
-- ------------------------------------------------------
-- Server version	10.4.11-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `billetes`
--

DROP TABLE IF EXISTS `billetes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `billetes` (
  `bil_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bil_nombre` varchar(45) NOT NULL DEFAULT '',
  `bil_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `bil_valor` float NOT NULL DEFAULT 0,
  `bil_usu_crea` varchar(45) DEFAULT NULL,
  `bil_usu_modifica` varchar(45) DEFAULT NULL,
  `bil_usu_activa` varchar(45) DEFAULT NULL,
  `bil_orden` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`bil_codi`),
  UNIQUE KEY `Index_bil_nombre` (`bil_nombre`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `billetes`
--

LOCK TABLES `billetes` WRITE;
/*!40000 ALTER TABLE `billetes` DISABLE KEYS */;
INSERT INTO `billetes` VALUES (1,'200 SOLES',1,200,'etorres','etorres','',1),(2,'100 SOLES',1,100,'etorres','etorres',NULL,2),(3,'50 SOLES',1,50,'etorres','etorres',NULL,3),(4,'20 SOLES',1,20,'etorres','etorres',NULL,4),(5,'10 SOLES',1,10,'etorres','etorres',NULL,5),(6,'5 SOLES',1,5,'etorres','etorres',NULL,6),(7,'2 SOLES',1,2,'etorres','etorres',NULL,7),(8,'1 SOL',1,1,'etorres','etorres',NULL,8),(9,'50 CENTIMOS',1,0.5,'etorres','etorres',NULL,9),(10,'20 CENTIMOS',1,0.2,'etorres','etorres',NULL,10),(11,'10 CENTIMOS',1,0.1,'etorres','etorres',NULL,11),(12,'5 CENTIMOS',1,0.05,'etorres','etorres',NULL,12),(13,'1 CENTIMO',1,0.01,'etorres','etorres',NULL,13);
/*!40000 ALTER TABLE `billetes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `caja`
--

DROP TABLE IF EXISTS `caja`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `caja` (
  `caj_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `caj_fecha` date DEFAULT NULL,
  `caj_fechahora` datetime DEFAULT NULL,
  `caj_usu_nombre` varchar(45) NOT NULL DEFAULT '',
  `caj_cerrada` int(10) unsigned NOT NULL DEFAULT 0,
  `caj_anotaciones` text DEFAULT NULL,
  `caj_monto_inicial` float NOT NULL DEFAULT 0,
  `caj_idtrans` varchar(45) DEFAULT NULL,
  `caj_numero` varchar(45) DEFAULT NULL,
  `usu_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `usu_nombre_fk` varchar(45) NOT NULL DEFAULT '',
  `caj_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `caj_monto_final` float NOT NULL DEFAULT 0,
  `caj_fechahora_cierre` datetime DEFAULT NULL,
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `caj_monto_final_bouchers` float NOT NULL DEFAULT 0,
  `caj_monto_final_notas` float NOT NULL DEFAULT 0,
  PRIMARY KEY (`caj_codi`),
  UNIQUE KEY `Index_caj_numero` (`caj_numero`),
  KEY `Index_caj_usu_nombre` (`caj_usu_nombre`),
  KEY `Index_caj_cerrada` (`caj_cerrada`),
  KEY `Index_caj_idtrans` (`caj_idtrans`),
  KEY `Index_usu_codi_fk` (`usu_codi_fk`),
  KEY `Index_emp_codi_fk` (`emp_codi_fk`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `caja`
--

LOCK TABLES `caja` WRITE;
/*!40000 ALTER TABLE `caja` DISABLE KEYS */;
INSERT INTO `caja` VALUES (1,'2021-09-09','2021-09-09 06:22:09','etorres',0,'',0,'16311865238418360350','CAJA0000001',2,'etorres',1,0,NULL,1,0,0);
/*!40000 ALTER TABLE `caja` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `caja_detalle`
--

DROP TABLE IF EXISTS `caja_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `caja_detalle` (
  `cajdet_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `caj_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `bil_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `cantidad_billetes` int(10) unsigned NOT NULL DEFAULT 0,
  `cajdet_apertura_cierre` varchar(10) DEFAULT NULL,
  `cajdet_monto` float NOT NULL DEFAULT 0,
  PRIMARY KEY (`cajdet_codi`),
  KEY `FK_caja_detalle_1` (`caj_codi_fk`),
  KEY `FK_caja_detalle_2` (`bil_codi_fk`),
  CONSTRAINT `FK_caja_detalle_1` FOREIGN KEY (`caj_codi_fk`) REFERENCES `caja` (`caj_codi`),
  CONSTRAINT `FK_caja_detalle_2` FOREIGN KEY (`bil_codi_fk`) REFERENCES `billetes` (`bil_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `caja_detalle`
--

LOCK TABLES `caja_detalle` WRITE;
/*!40000 ALTER TABLE `caja_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `caja_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `comprobante_serie`
--

DROP TABLE IF EXISTS `comprobante_serie`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `comprobante_serie` (
  `comser_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `comtip_codigo_fk` varchar(45) NOT NULL DEFAULT '',
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `comser_serie` char(4) CHARACTER SET ucs2 NOT NULL DEFAULT '',
  `comser_correlativo` int(10) unsigned NOT NULL DEFAULT 0,
  `comser_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `comser_usu_crea` varchar(45) DEFAULT NULL,
  `comser_usu_modifica` varchar(45) DEFAULT NULL,
  `comser_usu_activa` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`comser_codi`),
  KEY `Index_comtip_codigo_fk` (`comtip_codigo_fk`),
  KEY `Index_emp_codi_fk` (`emp_codi_fk`),
  KEY `Index_comser_estado` (`comser_estado`),
  CONSTRAINT `FK_comprobante_serie_comprobante_tipo` FOREIGN KEY (`comtip_codigo_fk`) REFERENCES `comprobante_tipo` (`comtip_codigo`),
  CONSTRAINT `FK_comprobante_serie_empresas` FOREIGN KEY (`emp_codi_fk`) REFERENCES `empresas` (`emp_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `comprobante_serie`
--

LOCK TABLES `comprobante_serie` WRITE;
/*!40000 ALTER TABLE `comprobante_serie` DISABLE KEYS */;
INSERT INTO `comprobante_serie` VALUES (1,'01',1,'F001',1,1,'','ACAMPOS',NULL),(2,'03',1,'B001',1,1,'','ACAMPOS',NULL),(3,'07',1,'F001',1,1,'','ACAMPOS',NULL),(4,'07',1,'B001',1,1,'','ACAMPOS',NULL),(21,'08',1,'F001',1,1,'','ACAMPOS',NULL),(22,'08',1,'B001',1,1,'','ACAMPOS',NULL);
/*!40000 ALTER TABLE `comprobante_serie` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `comprobante_tipo`
--

DROP TABLE IF EXISTS `comprobante_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `comprobante_tipo` (
  `comtip_codigo` char(2) NOT NULL DEFAULT '',
  `comtip_nombre` varchar(45) NOT NULL DEFAULT '',
  PRIMARY KEY (`comtip_codigo`),
  UNIQUE KEY `Index_comtip_nombre` (`comtip_nombre`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `comprobante_tipo`
--

LOCK TABLES `comprobante_tipo` WRITE;
/*!40000 ALTER TABLE `comprobante_tipo` DISABLE KEYS */;
INSERT INTO `comprobante_tipo` VALUES ('03','BOLETA'),('01','FACTURA'),('07','NOTA DE CREDITO'),('08','NOTA DE DEBITO');
/*!40000 ALTER TABLE `comprobante_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `configuraciones`
--

DROP TABLE IF EXISTS `configuraciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `configuraciones` (
  `con_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `con_igv` float DEFAULT NULL,
  `con_dolar` float DEFAULT NULL,
  `con_pagocompra` int(10) unsigned DEFAULT NULL,
  `con_cobropedido` int(10) unsigned DEFAULT NULL,
  `con_aperturacaja` int(10) unsigned DEFAULT NULL,
  `con_cierrecaja` int(10) unsigned DEFAULT NULL,
  `con_usu_modifica` varchar(45) DEFAULT NULL,
  `con_mediopago` int(11) unsigned DEFAULT NULL,
  `con_operaciontipo` int(11) unsigned DEFAULT NULL,
  `con_documentotipo` int(11) unsigned DEFAULT NULL,
  `con_operaciontipo_compra` int(10) unsigned DEFAULT NULL,
  `con_documentotipo_compra` int(10) unsigned DEFAULT NULL,
  `con_token` varchar(45) NOT NULL,
  `con_prdfam_codi_icbper` int(10) unsigned DEFAULT NULL,
  `con_icbper_monto` float DEFAULT NULL,
  `con_pagonotacredito` int(10) unsigned DEFAULT NULL,
  `con_operaciontipo_notacredito` int(10) unsigned DEFAULT NULL,
  `con_documentotipo_notacredito` int(10) unsigned DEFAULT NULL,
  `con_cobronotadebito` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`con_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `configuraciones`
--

LOCK TABLES `configuraciones` WRITE;
/*!40000 ALTER TABLE `configuraciones` DISABLE KEYS */;
INSERT INTO `configuraciones` VALUES (1,18,3.35,12,11,13,14,'ACAMPOS',1,4,11,1,10,'ALEJANDRA2021',0,0.3,19,12,5,18);
/*!40000 ALTER TABLE `configuraciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `correlativos`
--

DROP TABLE IF EXISTS `correlativos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `correlativos` (
  `cor_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cor_pedido` int(10) unsigned NOT NULL DEFAULT 0,
  `cor_compra` int(10) unsigned NOT NULL DEFAULT 0,
  `cor_almacen` int(10) unsigned NOT NULL DEFAULT 0,
  `cor_caja` int(10) unsigned NOT NULL DEFAULT 0,
  `cor_caja_cierre` int(10) unsigned NOT NULL DEFAULT 0,
  `cor_cotizacion` int(10) unsigned NOT NULL DEFAULT 0,
  `cor_persona` int(10) unsigned NOT NULL DEFAULT 0,
  `cor_presupuesto` int(10) unsigned NOT NULL DEFAULT 0,
  `cor_inasistencia` int(10) unsigned NOT NULL DEFAULT 0,
  `cor_requerimiento_compra` int(10) unsigned NOT NULL DEFAULT 0,
  `cor_requerimiento_interno` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`cor_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `correlativos`
--

LOCK TABLES `correlativos` WRITE;
/*!40000 ALTER TABLE `correlativos` DISABLE KEYS */;
INSERT INTO `correlativos` VALUES (1,1,1,1,1,2,1,16,1,1,1,1);
/*!40000 ALTER TABLE `correlativos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cotizaciones`
--

DROP TABLE IF EXISTS `cotizaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cotizaciones` (
  `cot_codi` int(11) NOT NULL AUTO_INCREMENT,
  `cot_fecha` date DEFAULT NULL,
  `cot_numero` varchar(45) DEFAULT NULL,
  `per_codi_fk` int(11) DEFAULT NULL,
  `cot_estado` int(11) NOT NULL DEFAULT 1,
  `cot_fechahora` datetime DEFAULT NULL,
  `cot_anotaciones` text DEFAULT NULL,
  `cot_usu_crea` varchar(45) NOT NULL DEFAULT '',
  `cot_usu_modifica` varchar(45) NOT NULL DEFAULT '',
  `cot_usu_activa` varchar(45) NOT NULL DEFAULT '',
  `idtrans` varchar(45) DEFAULT NULL,
  `cot_situacion` int(10) unsigned NOT NULL DEFAULT 0,
  `cot_igv_porcentaje` float NOT NULL DEFAULT 18,
  `cot_dias` int(11) NOT NULL DEFAULT 5,
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `cot_origen` int(10) unsigned NOT NULL DEFAULT 0,
  `cot_otra_direccion` text DEFAULT NULL,
  `cot_cadena_datos` text DEFAULT NULL,
  `cot_autoriza_web` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`cot_codi`),
  UNIQUE KEY `Index_cot_numero` (`cot_numero`),
  KEY `Index_per_codi_fk` (`per_codi_fk`),
  KEY `Index_cot_estado` (`cot_estado`),
  KEY `Index_idtrans` (`idtrans`),
  KEY `Index_cot_situacion` (`cot_situacion`),
  KEY `Index_emp_codi_fk` (`emp_codi_fk`),
  CONSTRAINT `FK_cotizaciones_empresas` FOREIGN KEY (`emp_codi_fk`) REFERENCES `empresas` (`emp_codi`),
  CONSTRAINT `FK_cotizaciones_personas` FOREIGN KEY (`per_codi_fk`) REFERENCES `personas` (`per_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cotizaciones`
--

LOCK TABLES `cotizaciones` WRITE;
/*!40000 ALTER TABLE `cotizaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `cotizaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cotizaciones_detalle`
--

DROP TABLE IF EXISTS `cotizaciones_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cotizaciones_detalle` (
  `cotdet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `cotdet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `cotdet_precio` float NOT NULL DEFAULT 0,
  `cotdet_cantidad` float NOT NULL DEFAULT 0,
  `cot_codi_fk` int(11) NOT NULL DEFAULT 0,
  `idtrans` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`cotdet_codi`),
  KEY `fk_cotizaciones_detalle_cotizaciones1_idx` (`cot_codi_fk`),
  KEY `fk_cotizaciones_detalle_productos1_idx` (`prd_codi_fk`),
  KEY `fk_cotizaciones_detalle_unidades_medida1_idx` (`unimed_codi_fk`),
  CONSTRAINT `fk_cotizaciones_detalle_cotizaciones1` FOREIGN KEY (`cot_codi_fk`) REFERENCES `cotizaciones` (`cot_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_cotizaciones_detalle_productos1` FOREIGN KEY (`prd_codi_fk`) REFERENCES `productos` (`prd_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_cotizaciones_detalle_unidades_medida1` FOREIGN KEY (`unimed_codi_fk`) REFERENCES `unidades_medida` (`unimed_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cotizaciones_detalle`
--

LOCK TABLES `cotizaciones_detalle` WRITE;
/*!40000 ALTER TABLE `cotizaciones_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `cotizaciones_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `creditos_evaluacion_persona`
--

DROP TABLE IF EXISTS `creditos_evaluacion_persona`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `creditos_evaluacion_persona` (
  `creevaper_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `creevaper_ape_paterno` varchar(45) NOT NULL DEFAULT '',
  `creevaper_ape_materno` varchar(45) NOT NULL DEFAULT '',
  `creevaper_nombres` varchar(95) NOT NULL DEFAULT '',
  `creevaper_nacionalidad` varchar(45) NOT NULL DEFAULT '',
  `creevaper_estado_civil` varchar(45) NOT NULL DEFAULT '',
  `creevaper_fecha_nac` date DEFAULT NULL,
  `creevaper_direccion` varchar(145) NOT NULL DEFAULT '',
  `creevaper_direccion_numero` varchar(45) NOT NULL DEFAULT '',
  `creevaper_distrito` int(10) unsigned NOT NULL DEFAULT 0,
  `creevaper_provincia` int(10) unsigned NOT NULL DEFAULT 0,
  `creevaper_departamento` int(10) unsigned NOT NULL DEFAULT 0,
  `creevaper_documento_tipo` varchar(45) NOT NULL DEFAULT '',
  `creevaper_documento_numero` varchar(45) NOT NULL DEFAULT '',
  `creevaper_ruc` varchar(45) NOT NULL DEFAULT '',
  `creevaper_grado` varchar(45) NOT NULL DEFAULT '',
  `creevaper_profesion` varchar(45) NOT NULL DEFAULT '',
  `creevaper_telefono_fijo` varchar(45) NOT NULL DEFAULT '',
  `creevaper_telefono_celular` varchar(45) NOT NULL DEFAULT '',
  `creevaper_email` varchar(145) NOT NULL DEFAULT '',
  `creevaper_actividad_comercial` varchar(145) NOT NULL DEFAULT '',
  `creevaper_fecha_actividad` date DEFAULT NULL,
  `creevaper_condicion_local` varchar(145) NOT NULL DEFAULT '',
  `creevaper_ubicacion_local` varchar(245) NOT NULL DEFAULT '',
  `creevaper_ventas_mes` float NOT NULL DEFAULT 0,
  `creevaper_ventas_ano` float NOT NULL DEFAULT 0,
  `creevaper_credito_pendiente` char(2) NOT NULL DEFAULT '',
  `creevaper_entidad_acreedora` varchar(145) NOT NULL DEFAULT '',
  `creevaper_nro_trabajadores` int(10) unsigned NOT NULL DEFAULT 0,
  `creevaper_ciclo_pago` varchar(45) NOT NULL DEFAULT '',
  `creevaper_visita_domiciliaria` char(2) NOT NULL DEFAULT '',
  `per_codi_fk` int(10) unsigned DEFAULT NULL,
  `creevaper_sueldo_mes` float NOT NULL DEFAULT 0,
  `creevaper_valor_dia` float NOT NULL DEFAULT 0,
  `creevaper_fecha_actividad_fin` date DEFAULT NULL,
  `creevaper_condicion_activo` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`creevaper_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `creditos_evaluacion_persona`
--

LOCK TABLES `creditos_evaluacion_persona` WRITE;
/*!40000 ALTER TABLE `creditos_evaluacion_persona` DISABLE KEYS */;
/*!40000 ALTER TABLE `creditos_evaluacion_persona` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cuentas_contables`
--

DROP TABLE IF EXISTS `cuentas_contables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cuentas_contables` (
  `cc_codi` int(11) NOT NULL AUTO_INCREMENT,
  `cc_nombre` varchar(245) NOT NULL DEFAULT '',
  `cc_tipo` char(10) NOT NULL DEFAULT 'E',
  `cc_estado` int(11) NOT NULL DEFAULT 1,
  `cc_abreviatura` varchar(45) DEFAULT NULL,
  `cc_usu_crea` varchar(45) DEFAULT NULL,
  `cc_usu_modifica` varchar(45) DEFAULT NULL,
  `cc_usu_activa` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`cc_codi`),
  UNIQUE KEY `Index_cc_tipo` (`cc_tipo`),
  KEY `Index_cc_estado` (`cc_estado`),
  KEY `Index_cc_nombre` (`cc_nombre`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=619 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cuentas_contables`
--

LOCK TABLES `cuentas_contables` WRITE;
/*!40000 ALTER TABLE `cuentas_contables` DISABLE KEYS */;
INSERT INTO `cuentas_contables` VALUES (1,'CAJA M.N.                                         ','101101',1,NULL,NULL,NULL,NULL),(2,'CAJA M.E.                                         ','101102',1,NULL,NULL,NULL,NULL),(3,'FONDOS FIJOS M.N.                                 ','102101',1,NULL,NULL,NULL,NULL),(4,'FONDOS FIJOS M.E.                                 ','102102',1,NULL,NULL,NULL,NULL),(5,'EFECTIVO EN TRANSITO M.N.                         ','103101',1,NULL,NULL,NULL,NULL),(6,'EFECTIVO EN TRANSITO M.E.                         ','103102',1,NULL,NULL,NULL,NULL),(7,'CHEQUES EN TRANSITO M.N.                          ','103201',1,NULL,NULL,NULL,NULL),(8,'CHEQUES EN TRANSITO M.E.                          ','103202',1,NULL,NULL,NULL,NULL),(9,'BANCO DE CREDITO                                  ','104101',1,NULL,NULL,NULL,NULL),(10,'BANCO CONTINENTAL                                 ','104103',1,NULL,NULL,NULL,NULL),(11,'BANCO DE CREDITO M.E.                             ','105102',1,NULL,NULL,NULL,NULL),(12,'FACTURAS POR COBRAR EMITIDAS CARTERA TERCEROS M.N.','121201',1,NULL,NULL,NULL,NULL),(13,'FACTURAS POR COBRAR EMITIDAS CARTERA TERCEROS M.E.','121202',1,NULL,NULL,NULL,NULL),(14,'ANTICIPOS DE CLIENTES TERCEROS M.N.               ','122101',1,NULL,NULL,NULL,NULL),(15,'ANTICIPOS DE CLIENTES TERCEROS M.E.               ','122102',1,NULL,NULL,NULL,NULL),(16,'LETRAS POR COBRAR EN CARTERA TERCEROS M.N.        ','123201',1,NULL,NULL,NULL,NULL),(17,'LETRAS POR COBRAR EN CARTERA TERCEROS US          ','123202',1,NULL,NULL,NULL,NULL),(18,'LETRAS POR COBRAR EN COBRANZA TERCEROS MN         ','123301',1,NULL,NULL,NULL,NULL),(19,'LETRAS POR COBRAR EN COBRANZA TERCEROS ME         ','123302',1,NULL,NULL,NULL,NULL),(20,'LETRAS POR COBRAR EN DESCUENTO TERCEROS MN        ','123401',1,NULL,NULL,NULL,NULL),(21,'LETRAS POR COBRAR EN DESCUENTO TERCEROS ME        ','123402',1,NULL,NULL,NULL,NULL),(22,'FACT. POR COBRAR  NO EMITIDA RELACIONADA  MN      ','131111',1,NULL,NULL,NULL,NULL),(23,'FACT. POR COBRAR  NO EMITIDA RELACIONADA  ME      ','131112',1,NULL,NULL,NULL,NULL),(24,'FACT. POR COBRAR EMITIDAS EN CARTERA RELAC. MN    ','131211',1,NULL,NULL,NULL,NULL),(25,'FACT. POR COBRAR EMITIDAS EN CARTERA RELAC. ME    ','131212',1,NULL,NULL,NULL,NULL),(26,'ANTICIPOS RECIBIDOS RELACIONADAS   M.N.           ','132111',1,NULL,NULL,NULL,NULL),(27,'ANTICIPOS RECIBIDOS RELACIONADAS   M.E.           ','132112',1,NULL,NULL,NULL,NULL),(28,'LETRAS POR COBRAR EN CARTERA RELACIONADA MN       ','133111',1,NULL,NULL,NULL,NULL),(29,'LETRAS POR COBRAR EN CARTERA RELACIONADA ME       ','133112',1,NULL,NULL,NULL,NULL),(30,'PRESTAMOS DE PERSONAL EMPLEADOS M.N.              ','141101',1,NULL,NULL,NULL,NULL),(31,'PRESTAMOS DE PERSONAL EMPLEADOS M.E.              ','141102',1,NULL,NULL,NULL,NULL),(32,'PRESTAMOS DE PERSONAL OBREROS M.N.                ','141111',1,NULL,NULL,NULL,NULL),(33,'PRESTAMOS DE PERSONAL OBREROS M.E.                ','141112',1,NULL,NULL,NULL,NULL),(34,'ENTREGAS A RENDIR CUENTA DE PERSONAL M.N.         ','141301',1,NULL,NULL,NULL,NULL),(35,'ENTREGAS A RENDIR CUENTA DE PERSONAL M.E.         ','141302',1,NULL,NULL,NULL,NULL),(36,'PRESTAMOS ACCIONISTAS (O SOCIOS) PARTICIPANTES M.N','142201',1,NULL,NULL,NULL,NULL),(37,'PRESTAMOS ACCIONISTAS (O SOCIOS) PARTICIPANTES M.E','142202',1,NULL,NULL,NULL,NULL),(38,'COBRANZA DIVERSAS PRESTAMOS C/GARANTIA TERCEROS MN','161101',1,NULL,NULL,NULL,NULL),(39,'COBRANZA DIVERSAS PRESTAMOS C/GARANTIA TERCEROS ME','161102',1,NULL,NULL,NULL,NULL),(40,'COBRANZA DIVERSAS PRESTAMOS S/GARANTIA TERCEROS MN','161111',1,NULL,NULL,NULL,NULL),(41,'COBRANZA DIVERSAS PRESTAMOS S/GARANTIA TERCEROS ME','161112',1,NULL,NULL,NULL,NULL),(42,'PAGOS A CUENTA DEL IMPUESTO A LA RENTA            ','167101',1,NULL,NULL,NULL,NULL),(43,'PAGOS A CUENTA DE ITAN                            ','167201',1,NULL,NULL,NULL,NULL),(44,'IGV POR ACREDITAR EN COMPRAS                      ','167301',1,NULL,NULL,NULL,NULL),(45,'IGV POR ACREDITAR NO DOMICILIADOS                 ','167401',1,NULL,NULL,NULL,NULL),(46,'OBRAS POR IMPUESTOS                               ','167501',1,NULL,NULL,NULL,NULL),(47,'COBRANZA DIVERSAS PTMOS.C/GARANTIA RELAC.MN       ','171111',1,NULL,NULL,NULL,NULL),(48,'COBRANZA DIVERSAS PTMOS.C/GARANTIA RELAC.ME       ','171112',1,NULL,NULL,NULL,NULL),(49,'COBRANZA DIVERSAS PTMOS.S/GARANTIA RELACIONADA MN ','171211',1,NULL,NULL,NULL,NULL),(50,'COBRANZA DIVERSAS PTMOS.S/GARANTIA RELACIONADA ME ','171212',1,NULL,NULL,NULL,NULL),(51,'COSTOS FINANCIEROS M.N.                           ','181101',1,NULL,NULL,NULL,NULL),(52,'COSTOS FINANCIEROS M.E.                           ','181102',1,NULL,NULL,NULL,NULL),(53,'MERCADERIAS - COSTO                               ','201111',1,NULL,NULL,NULL,NULL),(54,'MERCADERIAS - VALOR RAZONABLE                     ','201141',1,NULL,NULL,NULL,NULL),(55,'PRODUCTOS TERMINADOS-COSTO                        ','211111',1,NULL,NULL,NULL,NULL),(56,'PRODUCTOS TERMINADOS-COSTO DE FINANCIAMIENTO      ','211131',1,NULL,NULL,NULL,NULL),(57,'PRODUCTOS TERMINADOS-VALOR RAZONABLE              ','211141',1,NULL,NULL,NULL,NULL),(58,'SERVICIOS TERMINADOS-COSTO                        ','215111',1,NULL,NULL,NULL,NULL),(59,'SUBPRODUCTOS                                      ','221101',1,NULL,NULL,NULL,NULL),(60,'DESECHOS Y DESPERDICIOS                           ','222101',1,NULL,NULL,NULL,NULL),(61,'PRODUCTOS EN PROCESO-COSTO                        ','231111',1,NULL,NULL,NULL,NULL),(62,'PRODUCTOS EN PROCESO-COSTO DE FINANCIAMIENTO      ','231131',1,NULL,NULL,NULL,NULL),(63,'EXISTENCIAS DE SERVICIOS EN PROCESO-COSTO         ','235111',1,NULL,NULL,NULL,NULL),(64,'MATERIAS PRIMAS-COSTO                             ','241101',1,NULL,NULL,NULL,NULL),(65,'MATERIAS PRIMAS-VALOR RAZONABLE                   ','241141',1,NULL,NULL,NULL,NULL),(66,'MATERIALES AUXILIARES                             ','251101',1,NULL,NULL,NULL,NULL),(67,'ENVASES                                           ','261101',1,NULL,NULL,NULL,NULL),(68,'MATERIAS PRIMAS POR RECIBIR                       ','284101',1,NULL,NULL,NULL,NULL),(69,'DESVALORIZACION MERCADERIAS-COSTO                 ','291111',1,NULL,NULL,NULL,NULL),(70,'DESVAL.PROD.TERMINADO-COSTO                       ','292111',1,NULL,NULL,NULL,NULL),(71,'DESVAL.PROD.TERMINADO-COSTO DE FINANCIACION       ','292131',1,NULL,NULL,NULL,NULL),(72,'DESVAL.INVENTARIO DE SERVICIOS TERMINADO-COSTO    ','292511',1,NULL,NULL,NULL,NULL),(73,'DESVALORIZACION  MATERIAS PRIMAS-COSTO            ','295111',1,NULL,NULL,NULL,NULL),(74,'PLANTA PRODUCTORA EN PRODUCCION-COSTO             ','330111',1,NULL,NULL,NULL,NULL),(75,'PLANTA PRODUCTORA EN PRODUCCION-REVALUACION       ','330121',1,NULL,NULL,NULL,NULL),(76,'PLANTA PRODUCTORA EN PROD.-COSTO DE FINANCIACION  ','330131',1,NULL,NULL,NULL,NULL),(77,'PLANTA PRODUCTORA EN PRODUCCION-VALOR RAZONABLE   ','330141',1,NULL,NULL,NULL,NULL),(78,'PLANTA PRODUCTORA EN DESARROLLO-COSTO             ','330211',1,NULL,NULL,NULL,NULL),(79,'PLANTA PRODUCTORA EN DESARROLLO-REVALUACION       ','330221',1,NULL,NULL,NULL,NULL),(80,'PLANTA PROD. EN DESARROLLO-COSTO DE FINANCIACION  ','330231',1,NULL,NULL,NULL,NULL),(81,'PLANTA PRODUCTORA EN DESARROLLO-VALOR RAZONABLE   ','330241',1,NULL,NULL,NULL,NULL),(82,'TERRENOS-COSTO                                    ','331111',1,NULL,NULL,NULL,NULL),(83,'TERRENOS-REVALUACION                              ','331121',1,NULL,NULL,NULL,NULL),(84,'EDIFICACIONES-COSTO                               ','332111',1,NULL,NULL,NULL,NULL),(85,'EDIFICACIONES-REVALUACION                         ','332121',1,NULL,NULL,NULL,NULL),(86,'EDIFICACIONES-COSTO DE FINANCIACION               ','332131',1,NULL,NULL,NULL,NULL),(87,'INSTALACIONES-COSTO                               ','332411',1,NULL,NULL,NULL,NULL),(88,'INSTALACIONES-REVALUACION                         ','332421',1,NULL,NULL,NULL,NULL),(89,'INSTALACIONES-COSTO DE FINANCIACION               ','332431',1,NULL,NULL,NULL,NULL),(90,'MEJORAS EN LOS LOCALES ARRENDADOS -COSTO          ','332511',1,NULL,NULL,NULL,NULL),(91,'MEJORAS EN LOS LOCALES ARRENDADOS -REVALUACION    ','332521',1,NULL,NULL,NULL,NULL),(92,'MEJORAS EN LOS LOCALES ARRENDADOS-COSTO DE FINAN  ','332531',1,NULL,NULL,NULL,NULL),(93,'MAQUINARIAS Y EQUIPOS DE EXPLOTACION-COSTO        ','333111',1,NULL,NULL,NULL,NULL),(94,'MAQUINARIAS Y EQUIPOS DE EXPLOTACION-REVALUAC     ','333121',1,NULL,NULL,NULL,NULL),(95,'MAQUINARIAS Y EQUIPOS DE EXPLOTACION-COSTO DE FINA','333131',1,NULL,NULL,NULL,NULL),(96,'VEHICULOS MOTORIZADOS-COSTO                       ','334111',1,NULL,NULL,NULL,NULL),(97,'VEHICULOS MOTORIZADOS-REVALUACION                 ','334121',1,NULL,NULL,NULL,NULL),(98,'VEHICULOS NO MOTORIZADOS-COSTO                    ','334211',1,NULL,NULL,NULL,NULL),(99,'VEHICULOS NO MOTORIZADOS-REVALUACION              ','334221',1,NULL,NULL,NULL,NULL),(100,'MUEBLES-COSTO                                     ','335111',1,NULL,NULL,NULL,NULL),(101,'MUEBLES-REVALUACION                               ','335121',1,NULL,NULL,NULL,NULL),(102,'ENSERES-COSTO                                     ','335211',1,NULL,NULL,NULL,NULL),(103,'ENSERES-REVALUACION                               ','335221',1,NULL,NULL,NULL,NULL),(104,'EQUIPO COMPUTO-COSTO                              ','336111',1,NULL,NULL,NULL,NULL),(105,'EQUIPO COMPUTO-REVALUACION                        ','336121',1,NULL,NULL,NULL,NULL),(106,'EQUIPO DE COMUNICACIËN-COSTO                      ','336211',1,NULL,NULL,NULL,NULL),(107,'EQUIPO DE COMUNICACIËN-REVALUACION                ','336221',1,NULL,NULL,NULL,NULL),(108,'EQUIPO DE SEGURIDAD-COSTO                         ','336311',1,NULL,NULL,NULL,NULL),(109,'EQUIPO DE SEGURIDAD-REVALUACION                   ','336321',1,NULL,NULL,NULL,NULL),(110,'EQUIPO DE MEDIO AMBIENTE-COSTO                    ','336411',1,NULL,NULL,NULL,NULL),(111,'EQUIPO DE MEDIO AMBIENTE-REVALUACION              ','336421',1,NULL,NULL,NULL,NULL),(112,'OTROS EQUIPOS-COSTO                               ','336911',1,NULL,NULL,NULL,NULL),(113,'OTROS EQUIPOS-REVALUACION                         ','336921',1,NULL,NULL,NULL,NULL),(114,'EDIFICACIONES EN CURSO-COSTO                      ','339211',1,NULL,NULL,NULL,NULL),(115,'EDIFICACIONES EN CURSO-COSTO DE FINANCIACION      ','339221',1,NULL,NULL,NULL,NULL),(116,'MAQUINARIA EN MONTAJE-COSTO                       ','339311',1,NULL,NULL,NULL,NULL),(117,'MAQUINARIA EN MONTAJE-COSTO DE FINANCIACION       ','339321',1,NULL,NULL,NULL,NULL),(118,'LICENCIAS DE PROGRAMAS -COSTO                     ','341211',1,NULL,NULL,NULL,NULL),(119,'PATENTES-COSTO                                    ','342111',1,NULL,NULL,NULL,NULL),(120,'APLICACIONES INFORMATICAS-COSTO                   ','343111',1,NULL,NULL,NULL,NULL),(121,'FORMULAS-COSTO                                    ','345111',1,NULL,NULL,NULL,NULL),(122,'OTROS ACTIVOS INTANGIBLES-COSTO                   ','349111',1,NULL,NULL,NULL,NULL),(123,'IMPUESTO A LA RENTA DIFERIDO - PATRIMONIO         ','371101',1,NULL,NULL,NULL,NULL),(124,'IMPUESTO A LA RENTA DIFERIDO - RESULTADOS         ','371201',1,NULL,NULL,NULL,NULL),(125,'DEPREC.EDIFICACIONES - COSTO                      ','391111',1,NULL,NULL,NULL,NULL),(126,'DEPREC.EDIFICACIONES - REVALUACION                ','391121',1,NULL,NULL,NULL,NULL),(127,'DEPREC.EDIFICACIONES - COSTO DE FINANCIACION      ','391131',1,NULL,NULL,NULL,NULL),(128,'DEP.ACUM.PROP.PLANTA Y EQUIP.COSTO-PLANTA PRODUC  ','395201',1,NULL,NULL,NULL,NULL),(129,'DEP.ACUM.PROP.PLANTA Y EQUIP.COSTO-EDIFICACIONES  ','395211',1,NULL,NULL,NULL,NULL),(130,'DEP.ACUM.PROP.PLANTA Y EQUIP.COSTO-INSTALACIONES  ','395221',1,NULL,NULL,NULL,NULL),(131,'DEP.ACUM.PROP.PLANTA Y EQ.COSTO-MEJORAS LOC.ARREND','395231',1,NULL,NULL,NULL,NULL),(132,'DEP.ACUM.PROP.PLANTA Y EQ.COSTO-MAQ.Y EQUIP.EXPLOT','395241',1,NULL,NULL,NULL,NULL),(133,'DEP.ACUM.PROP.PLANTA Y EQ.COSTO-UNID. DE TRANSP   ','395251',1,NULL,NULL,NULL,NULL),(134,'DEP.ACUM.PROP.PLANTA Y EQ.COSTO-MUEBLES Y ENSERES ','395261',1,NULL,NULL,NULL,NULL),(135,'DEP.ACUM.PROP.PLANTA Y EQ.COSTO-EQUIP. DIVERSOS   ','395271',1,NULL,NULL,NULL,NULL),(136,'DEP.ACUM.PROP.PLANTA Y EQ.COSTO-HERRAMIENTAS      ','395281',1,NULL,NULL,NULL,NULL),(137,'DEP.ACUM.PROP.PLANTA Y EQUIP.COSTO-UNID. DE REEMP.','395291',1,NULL,NULL,NULL,NULL),(138,'DEP.ACUM.PROP.PLANTA Y EQUIP.REV.-PLANTA PRODUCT. ','395301',1,NULL,NULL,NULL,NULL),(139,'DEP.ACUM.PROP.PLANTA Y EQUIP.REV.-EDIFICACIONES   ','395311',1,NULL,NULL,NULL,NULL),(140,'DEP.ACUM.PROP.PLANTA Y EQUIP.REV.-INSTALACIONES   ','395321',1,NULL,NULL,NULL,NULL),(141,'DEP.ACUM.PROP.PLANTA Y EQ.REV.-MEJORAS LOC.ARRENDA','395331',1,NULL,NULL,NULL,NULL),(142,'DEP.ACUM.PROP.PLANTA Y EQ.REV.MAQ.Y EQUIP. DE EXPL','395341',1,NULL,NULL,NULL,NULL),(143,'DEP.ACUM.PROP.PLANTA Y EQ.REV.-UNID. DE TRANSPORTE','395351',1,NULL,NULL,NULL,NULL),(144,'DEP.ACUM.PROP.PLANTA Y EQ.REV.-MUEBLES Y ENSERES  ','395361',1,NULL,NULL,NULL,NULL),(145,'DEP.ACUM.PROP.PLANTA Y EQUIP.REV.-EQUIPOS DIVERSOS','395371',1,NULL,NULL,NULL,NULL),(146,'DEP.ACUM.PROP.PLANTA Y EQ.REV.HERR.Y UNID.REEM.FIN','395381',1,NULL,NULL,NULL,NULL),(147,'DEP.ACUM.PROP.PLANTA Y EQ.COSTO FINAN.-PLANTA PRO ','395401',1,NULL,NULL,NULL,NULL),(148,'DEP.ACUM.PROP.PLANTA Y EQ.COSTO FINAN.-EDIFICAC   ','395411',1,NULL,NULL,NULL,NULL),(149,'DEP.ACUM.PROP.PLAN.Y EQ.COSTO FINAN.-MAQ.Y EQ.DE E','395421',1,NULL,NULL,NULL,NULL),(150,'DEP.ACUM.PROP.PLAN. Y EQ.V.RAZON.-PLANTA PROD.    ','395501',1,NULL,NULL,NULL,NULL),(151,'AMORT.ACUM.INTANG.-COSTO-CONC.DEREC.LICEN.Y OTROS ','396111',1,NULL,NULL,NULL,NULL),(152,'AMORT.ACUM.INTANG.-COSTO-PATENTES Y PROP.INDUS.   ','396121',1,NULL,NULL,NULL,NULL),(153,'AMORT.ACUM.INTANG.-COSTO-PROGR.DE COMPU.(SOFTWARE)','396131',1,NULL,NULL,NULL,NULL),(154,'AMORT.ACUM.INTANG.-COSTO-DE EXPLO.Y DESARROLLO    ','396141',1,NULL,NULL,NULL,NULL),(155,'AMORT.ACUM.INTANG.-COSTO-FORM.DISEÐ.Y PROTOT.     ','396151',1,NULL,NULL,NULL,NULL),(156,'AMORT.ACUM.INTANG.-COSTO-OTROS ACTIV.INTANGIBLES  ','396191',1,NULL,NULL,NULL,NULL),(157,'AMORT.ACUM.INTANG.-REVAL.-CONC.DERECH.LICEN.YOTROS','396211',1,NULL,NULL,NULL,NULL),(158,'AMORT.ACUM.INTANG.-REVAL.-PATENTES Y PROP.INDUS.  ','396221',1,NULL,NULL,NULL,NULL),(159,'AMORT.ACUM.INTANG.-REVAL.-PROGR.DE COMP.(SOFTWARE)','396231',1,NULL,NULL,NULL,NULL),(160,'AMORT.ACUM.INTANG.-REVAL.-COSTO DE EXPLO.Y DESARRO','396241',1,NULL,NULL,NULL,NULL),(161,'AMORT.ACUM.INTANG.-REVAL.-FORM.DISEÐ.Y PROTOT.    ','396251',1,NULL,NULL,NULL,NULL),(162,'AMORT.ACUM.INTANG.-REVAL.-OTROS ACTIV.INTANGIBLES ','396291',1,NULL,NULL,NULL,NULL),(163,'AMORT.ACUM.INTANG.-COSTO DE FINANC.-EXPLORACION   ','396341',1,NULL,NULL,NULL,NULL),(164,'AMORT.ACUM.INTANG.-COSTO DE FINANC.-DESARROLLO    ','396351',1,NULL,NULL,NULL,NULL),(165,'IGV - CUENTA PROPIA                               ','401111',1,NULL,NULL,NULL,NULL),(166,'IGV - SERVICIOS PRESTADOS POR NO DOMICILIADOS     ','401121',1,NULL,NULL,NULL,NULL),(167,'IGV - REGIMEN DE PERCEPCIONES                     ','401131',1,NULL,NULL,NULL,NULL),(168,'IGV - REGIMEN DE RETENCIONES                      ','401141',1,NULL,NULL,NULL,NULL),(169,'IGV - IMPORTACIONES                               ','401151',1,NULL,NULL,NULL,NULL),(170,'IGV - DESTINADO A OPERACIONES NO GRAVADAS         ','401161',1,NULL,NULL,NULL,NULL),(171,'IGV - DESTINADO A OPERACIONES COMUNES             ','401171',1,NULL,NULL,NULL,NULL),(172,'DERECHOS ARANCELARIOS                             ','401511',1,NULL,NULL,NULL,NULL),(173,'RENTA DE TERCERA CATEGORIA                        ','401711',1,NULL,NULL,NULL,NULL),(174,'RENTA DE CUARTA CATEGORIA                         ','401721',1,NULL,NULL,NULL,NULL),(175,'RENTA DE QUINTA CATEGORIA                         ','401731',1,NULL,NULL,NULL,NULL),(176,'RENTA DE NO DOMICILIADO                           ','401741',1,NULL,NULL,NULL,NULL),(177,'IMPUESTO A LAS TRANSACCIONES FINANCIERAS          ','401811',1,NULL,NULL,NULL,NULL),(178,'ESSALUD                                           ','403101',1,NULL,NULL,NULL,NULL),(179,'ACCIDENTES DE TRABAJO                             ','403102',1,NULL,NULL,NULL,NULL),(180,'ONP                                               ','403201',1,NULL,NULL,NULL,NULL),(181,'CONTRIBUCION AL SENATI                            ','403301',1,NULL,NULL,NULL,NULL),(182,'CONTRIBUCION AL SENCICO                           ','403401',1,NULL,NULL,NULL,NULL),(183,'CONASEV                                           ','403901',1,NULL,NULL,NULL,NULL),(184,'IMPUESTO PREDIAL                                  ','406151',1,NULL,NULL,NULL,NULL),(185,'LICENCIA DE APERTURA DE ESTABLECIMIENTOS          ','406311',1,NULL,NULL,NULL,NULL),(186,'SERVICIOS PUBLICOS O ARBITRIOS                    ','406341',1,NULL,NULL,NULL,NULL),(187,'SUELDOS                                           ','411101',1,NULL,NULL,NULL,NULL),(188,'SALARIOS                                          ','411102',1,NULL,NULL,NULL,NULL),(189,'GRATIFICACIONES EMPLEADOS                         ','411401',1,NULL,NULL,NULL,NULL),(190,'GRATIFICACIONES OBREROS                           ','411402',1,NULL,NULL,NULL,NULL),(191,'VACACIONES EMPLEADOS                              ','411501',1,NULL,NULL,NULL,NULL),(192,'VACACIONES OBREROS                                ','411502',1,NULL,NULL,NULL,NULL),(193,'PARTICIPACIONES DE EMPLEADOS                      ','413101',1,NULL,NULL,NULL,NULL),(194,'PARTICIPACIONES DE OBREROS                        ','413102',1,NULL,NULL,NULL,NULL),(195,'C.T.S. EMPLEADOS                                  ','415101',1,NULL,NULL,NULL,NULL),(196,'C.T.S. OBREROS                                    ','415102',1,NULL,NULL,NULL,NULL),(197,'ADMINISTRADORAS DE FONDOS DE PENSIONES            ','417101',1,NULL,NULL,NULL,NULL),(198,'FACTURAS EMITIDAS POR PAGAR M.N. TERCEROS         ','421201',1,NULL,NULL,NULL,NULL),(199,'FACTURAS EMITIDAS POR PAGAR M.E. TERCEROS         ','421202',1,NULL,NULL,NULL,NULL),(200,'DETRACCIONES POR PAGAR MN                         ','421203',1,NULL,NULL,NULL,NULL),(201,'ANTICIPOS A PROVEEDORES M.N.                      ','422101',1,NULL,NULL,NULL,NULL),(202,'ANTICIPOS A PROVEEDORES M.E.                      ','422102',1,NULL,NULL,NULL,NULL),(203,'LETRAS POR PAGAR M.N. TERCEROS                    ','423101',1,NULL,NULL,NULL,NULL),(204,'LETRAS POR PAGAR M.E. TERCEROS                    ','423102',1,NULL,NULL,NULL,NULL),(205,'HONORARIOS POR PAGAR M.N.                         ','424101',1,NULL,NULL,NULL,NULL),(206,'HONORARIOS POR PAGAR M.E.                         ','424102',1,NULL,NULL,NULL,NULL),(207,'FACTURAS NO EMITIDAS POR PAGAR RELACIONADAS M.N.  ','431101',1,NULL,NULL,NULL,NULL),(208,'FACTURAS NO EMITIDAS POR PAGAR RELACIONADAS M.E.  ','431102',1,NULL,NULL,NULL,NULL),(209,'FACTURAS EMITIDAS POR PAGAR M.N. RELACIONADAS     ','431201',1,NULL,NULL,NULL,NULL),(210,'FACTURAS EMITIDAS POR PAGAR M.E. RELACIONADAS     ','431202',1,NULL,NULL,NULL,NULL),(211,'ANTICIPOS OTORGADOS M.N. RELACIONADAS             ','432101',1,NULL,NULL,NULL,NULL),(212,'ANTICIPOS OTORGADOS M.E. RELACIONADAS             ','432102',1,NULL,NULL,NULL,NULL),(213,'LETRAS POR PAGAR M.N. RELACIONADAS                ','433101',1,NULL,NULL,NULL,NULL),(214,'LETRAS POR PAGAR M.E. RELACIONADAS                ','433102',1,NULL,NULL,NULL,NULL),(215,'HONORARIOS POR PAGAR M.N. RELACIONADAS            ','434101',1,NULL,NULL,NULL,NULL),(216,'HONORARIOS POR PAGAR M.E. RELACIONADAS            ','434102',1,NULL,NULL,NULL,NULL),(217,'PRESTAMOS ACCIONISTAS CORTO PLAZO M.N.            ','441111',1,NULL,NULL,NULL,NULL),(218,'PRESTAMOS ACCIONISTAS CORTO PLAZO M.E.            ','441112',1,NULL,NULL,NULL,NULL),(219,'PRESTAMOS ACCIONISTAS LARGO PLAZO M.N.            ','441121',1,NULL,NULL,NULL,NULL),(220,'PRESTAMOS ACCIONISTAS LARGO PLAZO M.E.            ','441122',1,NULL,NULL,NULL,NULL),(221,'INSTITUCIONES FINANCIERAS M.N.                    ','451101',1,NULL,NULL,NULL,NULL),(222,'INSTITUCIONES FINANCIERAS M.E.                    ','451102',1,NULL,NULL,NULL,NULL),(223,'LEASING M.N.                                      ','452101',1,NULL,NULL,NULL,NULL),(224,'LEASING M.E.                                      ','452102',1,NULL,NULL,NULL,NULL),(225,'LEASEBACK M.N.                                    ','452111',1,NULL,NULL,NULL,NULL),(226,'LEASEBACK M.E.                                    ','452112',1,NULL,NULL,NULL,NULL),(227,'CONFIRMING M.N.                                   ','454901',1,NULL,NULL,NULL,NULL),(228,'CONFIRMING M.E.                                   ','454902',1,NULL,NULL,NULL,NULL),(229,'FACTORING M.N.                                    ','454911',1,NULL,NULL,NULL,NULL),(230,'FACTORING M.E.                                    ','454912',1,NULL,NULL,NULL,NULL),(231,'RECLAMACIONES DE TERCEROS M.N.                    ','461101',1,NULL,NULL,NULL,NULL),(232,'RECLAMACIONES DE TERCEROS M.E.                    ','461102',1,NULL,NULL,NULL,NULL),(233,'PRESTAMOS RECIBIDOS M.N. RELACIONADAS             ','471101',1,NULL,NULL,NULL,NULL),(234,'PRESTAMOS RECIBIDOS M.E. RELACIONADAS             ','471102',1,NULL,NULL,NULL,NULL),(235,'IMPUESTO A LA RENTA DIFERIDO - PATRIMONIO         ','491101',1,NULL,NULL,NULL,NULL),(236,'IMPUESTO A LA RENTA DIFERIDO - RESULTADOS         ','491201',1,NULL,NULL,NULL,NULL),(237,'ACCIONES                                          ','501101',1,NULL,NULL,NULL,NULL),(238,'ACCIONES DE INVERSION                             ','501111',1,NULL,NULL,NULL,NULL),(239,'PARTICIPACIONES                                   ','501201',1,NULL,NULL,NULL,NULL),(240,'PRIMAS (DESCUENTO) DE ACCIONES                    ','521101',1,NULL,NULL,NULL,NULL),(241,'APORTES                                           ','522101',1,NULL,NULL,NULL,NULL),(242,'RESERVAS                                          ','522201',1,NULL,NULL,NULL,NULL),(243,'ACREENCIAS                                        ','522301',1,NULL,NULL,NULL,NULL),(244,'UTILIDADES                                        ','522401',1,NULL,NULL,NULL,NULL),(245,'GANANCIA ACTIVOS O PASIVOS FINANCIEROS            ','563101',1,NULL,NULL,NULL,NULL),(246,'PERDIDA ACTIVOS O PASIVOS FINANCIEROS             ','563201',1,NULL,NULL,NULL,NULL),(247,'GANANCIA ACTIVOS O PASIVOS MANT. PARA NEGOC       ','565101',1,NULL,NULL,NULL,NULL),(248,'PERDIDA   ACTIVOS O PASIVOS MANT. PARA NEGOC      ','565201',1,NULL,NULL,NULL,NULL),(249,'ADQUISICION DIRECTA                               ','571111',1,NULL,NULL,NULL,NULL),(250,'ARRENDAMIENTO FINANCIERO                          ','571121',1,NULL,NULL,NULL,NULL),(251,'ADQUISICION DIRECTA                               ','571211',1,NULL,NULL,NULL,NULL),(252,'ARRENDAMIENTO FINANCIERO                          ','571221',1,NULL,NULL,NULL,NULL),(253,'EXCEDENTE DE REVALUACION INTANGIBLES              ','571301',1,NULL,NULL,NULL,NULL),(254,'EXCEDENTE DE REVAL. ACT. POR DER.DE USO-ARREND.FIN','571401',1,NULL,NULL,NULL,NULL),(255,'RESERVA LEGAL                                     ','582101',1,NULL,NULL,NULL,NULL),(256,'UTILIDADES ACUMULADAS                             ','591101',1,NULL,NULL,NULL,NULL),(257,'PERDIDAS ACUMULADAS                               ','592101',1,NULL,NULL,NULL,NULL),(258,'MERCADERIAS                                       ','601101',1,NULL,NULL,NULL,NULL),(259,'MERCADERIAS IMPORTADAS                            ','601102',1,NULL,NULL,NULL,NULL),(260,'MATERIAS PRIMAS                                   ','602101',1,NULL,NULL,NULL,NULL),(261,'MATERIALES AUXILIARES                             ','603101',1,NULL,NULL,NULL,NULL),(262,'SUMINISTROS                                       ','603201',1,NULL,NULL,NULL,NULL),(263,'REPUESTOS                                         ','603301',1,NULL,NULL,NULL,NULL),(264,'ENVASES                                           ','604101',1,NULL,NULL,NULL,NULL),(265,'EMBALAJES                                         ','604201',1,NULL,NULL,NULL,NULL),(266,'TRANSPORTE MERCADERIAS                            ','609111',1,NULL,NULL,NULL,NULL),(267,'SEGUROS MERCADERIAS                               ','609121',1,NULL,NULL,NULL,NULL),(268,'DERECHOS ADUANEROS MERCADERIAS                    ','609131',1,NULL,NULL,NULL,NULL),(269,'COMISIONES MERCADERIAS                            ','609141',1,NULL,NULL,NULL,NULL),(270,'OTROS COSTOS VINCULADOS CON LAS COMPRAS DE MERCADE','609191',1,NULL,NULL,NULL,NULL),(271,'MERCADERIAS                                       ','611101',1,NULL,NULL,NULL,NULL),(272,'MATERIAS PRIMAS                                   ','612101',1,NULL,NULL,NULL,NULL),(273,'MATERIALES AUXILIARES                             ','613101',1,NULL,NULL,NULL,NULL),(274,'SUMINISTROS                                       ','613201',1,NULL,NULL,NULL,NULL),(275,'REPUESTOS                                         ','613301',1,NULL,NULL,NULL,NULL),(276,'ENVASES                                           ','614101',1,NULL,NULL,NULL,NULL),(277,'EMBALAJES                                         ','614201',1,NULL,NULL,NULL,NULL),(278,'SUELDOS                                           ','621101',1,NULL,NULL,NULL,NULL),(279,'SALARIOS                                          ','621102',1,NULL,NULL,NULL,NULL),(280,'COMISIONES                                        ','621201',1,NULL,NULL,NULL,NULL),(281,'REMUNERACIONES EN ESPECIE                         ','621301',1,NULL,NULL,NULL,NULL),(282,'GRATIFICACIONES                                   ','621401',1,NULL,NULL,NULL,NULL),(283,'VACACIONES                                        ','621501',1,NULL,NULL,NULL,NULL),(284,'REFRIGERIOS                                       ','622101',1,NULL,NULL,NULL,NULL),(285,'INDEMNIZACIONES EMPLEADOS                         ','623101',1,NULL,NULL,NULL,NULL),(286,'INDEMNIZACIONES OBREROS                           ','623102',1,NULL,NULL,NULL,NULL),(287,'REGIMEN DE PRESTACIONES DE SALUD                  ','627101',1,NULL,NULL,NULL,NULL),(288,'REGIMEN DE PENSIONES                              ','627201',1,NULL,NULL,NULL,NULL),(289,'SEGURO DE VIDA                                    ','627401',1,NULL,NULL,NULL,NULL),(290,'COMPENSACION POR TIEMPO DE SERVICIO EMPLEADOS     ','629101',1,NULL,NULL,NULL,NULL),(291,'COMPENSACION POR TIEMPO DE SERVICIO OBREROS       ','629102',1,NULL,NULL,NULL,NULL),(292,'TRANSPORTE DE CARGA                               ','631111',1,NULL,NULL,NULL,NULL),(293,'PASAJES TERRESTRES                                ','631121',1,NULL,NULL,NULL,NULL),(294,'PASAJES AEREOS                                    ','631122',1,NULL,NULL,NULL,NULL),(295,'ALOJAMIENTO                                       ','631301',1,NULL,NULL,NULL,NULL),(296,'ALIMENTACION                                      ','631401',1,NULL,NULL,NULL,NULL),(297,'PEAJES                                            ','631601',1,NULL,NULL,NULL,NULL),(298,'ADMINISTRATIVA                                    ','632101',1,NULL,NULL,NULL,NULL),(299,'LEGAL Y TRIBUTARIA                                ','632201',1,NULL,NULL,NULL,NULL),(300,'AUDITORIA Y CONTABLE                              ','632301',1,NULL,NULL,NULL,NULL),(301,'MERCADOTECNIA                                     ','632401',1,NULL,NULL,NULL,NULL),(302,'MEDIOAMBIENTAL                                    ','632501',1,NULL,NULL,NULL,NULL),(303,'INVESTIGACION Y DESARROLLO                        ','632601',1,NULL,NULL,NULL,NULL),(304,'PRODUCCION                                        ','632701',1,NULL,NULL,NULL,NULL),(305,'OTROS                                             ','632901',1,NULL,NULL,NULL,NULL),(306,'PROPIEDADES DE INVERSION                          ','634101',1,NULL,NULL,NULL,NULL),(307,'ACTIVOS POR DERECHO DE USO-FINANCIERO             ','634211',1,NULL,NULL,NULL,NULL),(308,'PROPIEDAD PLANTA Y EQUIPO                         ','634301',1,NULL,NULL,NULL,NULL),(309,'ACTIVOS POR DERECHO DE USO-OPERATIVO              ','634321',1,NULL,NULL,NULL,NULL),(310,'INTANGIBLES                                       ','634401',1,NULL,NULL,NULL,NULL),(311,'ACTIVOS BIOLOGICOS                                ','634501',1,NULL,NULL,NULL,NULL),(312,'ALQUILERES TERRENOS                               ','635101',1,NULL,NULL,NULL,NULL),(313,'ALQUILERES EDIFICACIONES                          ','635201',1,NULL,NULL,NULL,NULL),(314,'ALQUILERES MAQUINARIAS Y EQUIPOS DE EXPLOTACION   ','635301',1,NULL,NULL,NULL,NULL),(315,'ALQUILERES EQUIPO DE TRANSPORTE                   ','635401',1,NULL,NULL,NULL,NULL),(316,'ALQUILERES MUEBLES Y ENSERES                      ','635501',1,NULL,NULL,NULL,NULL),(317,'ALQUILERES EQUIPOS DIVERSOS                       ','635601',1,NULL,NULL,NULL,NULL),(318,'ENERGIA ELECTRICA                                 ','636101',1,NULL,NULL,NULL,NULL),(319,'GAS                                               ','636201',1,NULL,NULL,NULL,NULL),(320,'AGUA                                              ','636301',1,NULL,NULL,NULL,NULL),(321,'TELEFONO                                          ','636401',1,NULL,NULL,NULL,NULL),(322,'INTERNET                                          ','636501',1,NULL,NULL,NULL,NULL),(323,'RADIO                                             ','636601',1,NULL,NULL,NULL,NULL),(324,'CABLE                                             ','636701',1,NULL,NULL,NULL,NULL),(325,'PUBLICIDAD                                        ','637101',1,NULL,NULL,NULL,NULL),(326,'GASTOS BANCARIOS                                  ','639101',1,NULL,NULL,NULL,NULL),(327,'IMPUESTO GENERAL A LAS VENTAS                     ','641101',1,NULL,NULL,NULL,NULL),(328,'IMPUESTO SELECTIVO AL CONSUMO                     ','641102',1,NULL,NULL,NULL,NULL),(329,'IMPUESTO A LAS TRANSACCIONES FINANCIERAS-ITF      ','641201',1,NULL,NULL,NULL,NULL),(330,'IMPUESTO TEMPORAL A LOS ACTIVOS NETOS-ITAN        ','641301',1,NULL,NULL,NULL,NULL),(331,'IMPUESTO A LOS JUEGOS DE CASINO Y MAQUINAS TRAGAMO','641401',1,NULL,NULL,NULL,NULL),(332,'REGALIAS MINERAS                                  ','641501',1,NULL,NULL,NULL,NULL),(333,'CANONES                                           ','641601',1,NULL,NULL,NULL,NULL),(334,'OTROS                                             ','641901',1,NULL,NULL,NULL,NULL),(335,'IMPUESTO PREDIAL                                  ','643101',1,NULL,NULL,NULL,NULL),(336,'ARBITRIOS MUNICIPALES Y SEGURIDAD CIUDADANA       ','643201',1,NULL,NULL,NULL,NULL),(337,'IMPUESTO AL PATRIMONIO VEHICULAR                  ','643301',1,NULL,NULL,NULL,NULL),(338,'LICENCIA DE FUNCIONAMIENTO                        ','643401',1,NULL,NULL,NULL,NULL),(339,'OTROS GOBIERNO LOCAL                              ','643901',1,NULL,NULL,NULL,NULL),(340,'CONTRIBUCION AL SENCICO                           ','644201',1,NULL,NULL,NULL,NULL),(341,'OTROS                                             ','644301',1,NULL,NULL,NULL,NULL),(342,'INTERESES                                         ','645101',1,NULL,NULL,NULL,NULL),(343,'INTERESES-FRACCIONAMIENTO                         ','645201',1,NULL,NULL,NULL,NULL),(344,'MULTAS                                            ','645301',1,NULL,NULL,NULL,NULL),(345,'COSTAS Y OTROS                                    ','645401',1,NULL,NULL,NULL,NULL),(346,'SEGURO DE VIDA                                    ','651101',1,NULL,NULL,NULL,NULL),(347,'SEGURO SOAT                                       ','651102',1,NULL,NULL,NULL,NULL),(348,'CONACO Y CAMARA DE COMERCIO                       ','653101',1,NULL,NULL,NULL,NULL),(349,'INVERSIONES INMOBILIARIAS                         ','655111',1,NULL,NULL,NULL,NULL),(350,'PROPIEDADES DE INVERSION                          ','655121',1,NULL,NULL,NULL,NULL),(351,'ACTIVOS POR DERECHO DE USO-ARREDAM.FINANCIERO     ','655131',1,NULL,NULL,NULL,NULL),(352,'PROPIEDAD  PLANTA Y EQUIPO                        ','655141',1,NULL,NULL,NULL,NULL),(353,'INTANGIBLES                                       ','655151',1,NULL,NULL,NULL,NULL),(354,'ACTIVOS BIOLOGICOS                                ','655161',1,NULL,NULL,NULL,NULL),(355,'PROPIEDADES DE INVERSION                          ','655211',1,NULL,NULL,NULL,NULL),(356,'ACTIVOS ADQUIRIDOS EN ARRENDAMIENTO FINANCIERO    ','655221',1,NULL,NULL,NULL,NULL),(357,'PROPIEDAD  PLANTA Y EQUIPO                        ','655231',1,NULL,NULL,NULL,NULL),(358,'INTANGIBLES                                       ','655241',1,NULL,NULL,NULL,NULL),(359,'ACTIVOS BIOLOGICOS                                ','655251',1,NULL,NULL,NULL,NULL),(360,'DONACIONES                                        ','659101',1,NULL,NULL,NULL,NULL),(361,'SANCIONES ADMINISTRATIVAS                         ','659201',1,NULL,NULL,NULL,NULL),(362,'UTILES DE ESCRITORIO                              ','659301',1,NULL,NULL,NULL,NULL),(363,'COMBUSTIBLES                                      ','659302',1,NULL,NULL,NULL,NULL),(364,'UTILES DE LIMPIEZA                                ','659303',1,NULL,NULL,NULL,NULL),(365,'OTROS GASTOS DE GESTION                           ','659304',1,NULL,NULL,NULL,NULL),(366,'PRESTAMOS DE INSTITUCIONES FINANCIERAS            ','671101',1,NULL,NULL,NULL,NULL),(367,'PRESTAMOS DE OTRAS ENTIDADES                      ','671102',1,NULL,NULL,NULL,NULL),(368,'INTERESES Y GASTOS DE PAGARES                     ','673111',1,NULL,NULL,NULL,NULL),(369,'GASTOS CONFIRMING/FACTORING/COMPAS                ','673121',1,NULL,NULL,NULL,NULL),(370,'OTRAS CARGAS FINANCIERAS                          ','673301',1,NULL,NULL,NULL,NULL),(371,'PERDIDA POR DIFERENCIA DE CAMBIO                  ','676101',1,NULL,NULL,NULL,NULL),(372,'DEPREC.PROP.INVER.INMOB.-COSTO                    ','681111',1,NULL,NULL,NULL,NULL),(373,'DEPREC.PROP.INVER.INMOB.-REVALUACION              ','681121',1,NULL,NULL,NULL,NULL),(374,'DEPREC.PROP.INVER.INMOB.-COSTO DE FINANCIACION    ','681131',1,NULL,NULL,NULL,NULL),(375,'DEPREC.ACT.DER.USO-ARRE.FIN.EDIFIC.-COSTO         ','682111',1,NULL,NULL,NULL,NULL),(376,'DEPREC.ACT.DER.USO-ARRE.FIN.EDIFIC.-REVALUACION   ','682112',1,NULL,NULL,NULL,NULL),(377,'DEPREC.ACT.DER.USO-ARRE.FIN.EDIFIC.-COSTO FINAN   ','682113',1,NULL,NULL,NULL,NULL),(378,'DEPREC.ACT.DER.USO-ARRE.FIN.EDIFIC.-COSTO         ','682211',1,NULL,NULL,NULL,NULL),(379,'DEPREC.ACT.DER.USO-ARRE.FIN.EDIFIC.-REVALUACION   ','682212',1,NULL,NULL,NULL,NULL),(380,'DEPREC.ACT.DER.USO-ARRE.FIN.EDIFIC.-COSTO FINAN   ','682213',1,NULL,NULL,NULL,NULL),(381,'DEPREC.ACT.DER.USO-ARRE.FIN.MAQ.Y EQ. EXPL.-COSTO ','682221',1,NULL,NULL,NULL,NULL),(382,'DEPREC.ACT.DER.USO-ARRE.FIN.MAQ.Y EQ. EXPL.-REVALU','682222',1,NULL,NULL,NULL,NULL),(383,'DEPREC.ACT.DER.USO-ARRE.FIN.MAQ.Y EQ. EXPL.-C.FINA','682223',1,NULL,NULL,NULL,NULL),(384,'DEPREC.ACT.DER.USO-ARRE.FIN.UNID.DE TRANSP.-COSTO ','682231',1,NULL,NULL,NULL,NULL),(385,'DEPREC.ACT.DER.USO-ARRE.FIN.UNID.DE TRANSP.-REVAL ','682232',1,NULL,NULL,NULL,NULL),(386,'DEPREC.ACT.DER.USO-ARRE.FIN.EQUIP.DIVER.-COSTO    ','682251',1,NULL,NULL,NULL,NULL),(387,'DEPREC.ACT.DER.USO-ARRE.FIN.EQUIP.DIVER.-REVALUAC ','682252',1,NULL,NULL,NULL,NULL),(388,'DEPREC.ACT.DER.USO-ARRE.OPER.EDIFICAC.-COSTO      ','683111',1,NULL,NULL,NULL,NULL),(389,'DEPREC.ACT.DER.USO-ARRE.OPER.EDIFICAC.-REVALUACION','683112',1,NULL,NULL,NULL,NULL),(390,'DEPREC.ACT.DER.USO-ARRE.OPER.MAQ.EQ.DE EXPL.-COSTO','683121',1,NULL,NULL,NULL,NULL),(391,'DEPREC.ACT.DER.USO-ARRE.OPER.MAQ.EQ.DE EXPL.-REVAL','683122',1,NULL,NULL,NULL,NULL),(392,'DEPREC.ACT.DER.USO-ARRE.OPER.UNID.DE TRANSP.-COSTO','683131',1,NULL,NULL,NULL,NULL),(393,'DEPREC.ACT.DER.USO-ARRE.OPER.UNID.DE TRANSP.-REVAL','683132',1,NULL,NULL,NULL,NULL),(394,'DEPREC.ACT.DER.USO-ARRE.OPER.EQUIP.DIVER.-COSTO   ','683151',1,NULL,NULL,NULL,NULL),(395,'DEPREC.ACT.DER.USO-ARRE.OPER.EQUIP.DIVER.-REVALUA ','683152',1,NULL,NULL,NULL,NULL),(396,'DEPREC.DE PPyE.COSTO-PLANTAS PRODUCTORAS          ','684101',1,NULL,NULL,NULL,NULL),(397,'DEPREC.DE PPyE.COSTO-EDIFICACIONES                ','684111',1,NULL,NULL,NULL,NULL),(398,'DEPREC.DE PPyE.COSTO-MAQ. Y EQ. DE EXPLOTACION    ','684121',1,NULL,NULL,NULL,NULL),(399,'DEPREC.DE PPyE.COSTO-UNIDADES DE TRANSPORTE       ','684131',1,NULL,NULL,NULL,NULL),(400,'DEPREC.DE PPyE.COSTO-MUEBLES Y ENSERES            ','684141',1,NULL,NULL,NULL,NULL),(401,'DEPREC.DE PPyE.COSTO-EQUIPOS DIVERSOS             ','684151',1,NULL,NULL,NULL,NULL),(402,'DEPREC.DE PPyE.COSTO-HERRAM. Y UNID.DE REEMPLAZO  ','684161',1,NULL,NULL,NULL,NULL),(403,'DEPREC.DE PPyE.REVAL.-PLANTAS PRODUCTORAS         ','684201',1,NULL,NULL,NULL,NULL),(404,'DEPREC.DE PPyE.REVAL.-EDIFICACIONES               ','684211',1,NULL,NULL,NULL,NULL),(405,'DEPREC.DE PPyE.REVAL.-MAQ.Y EQUIP.DE EXPLOTACION  ','684221',1,NULL,NULL,NULL,NULL),(406,'DEPREC.DE PPyE.REVAL.-UNIDADES DE TRANSPORTE      ','684231',1,NULL,NULL,NULL,NULL),(407,'DEPREC.DE PPyE.REVAL.-MUEBLES Y ENSERES           ','684241',1,NULL,NULL,NULL,NULL),(408,'DEPREC.DE PPyE.REVAL.-EQUIPOS DIVERSOS            ','684251',1,NULL,NULL,NULL,NULL),(409,'DEPREC.DE PPyE.REVAL.-HERRAM.Y UNID.DE REEMPLAZO  ','684261',1,NULL,NULL,NULL,NULL),(410,'DEPREC.DE PPyE.COSTO FINANC.-PLANTAS PRODUCTORAS  ','684301',1,NULL,NULL,NULL,NULL),(411,'DEPREC.DE PPyE.COSTO FINANC.-EDIFICACIONES        ','684311',1,NULL,NULL,NULL,NULL),(412,'DEPREC.DE PPyE.COSTO FINANC.-MAQ.Y EQ.DE EXPLOTAC ','684321',1,NULL,NULL,NULL,NULL),(413,'DEPREC.-COSTO-ACTIVOS BIOLOGICOS DE ORIGEN ANIMAL ','685111',1,NULL,NULL,NULL,NULL),(414,'DEPREC.-COSTO-ACTIVOS BIOLOGICOS DE ORIGEN VEGETAL','685121',1,NULL,NULL,NULL,NULL),(415,'DEPREC.-COSTO FIN.-ACT.BIOLOGICOS DE ORIGEN ANIMAL','685211',1,NULL,NULL,NULL,NULL),(416,'DEPREC.-COSTO FIN.-ACT.BIOLOGICOS DE ORIGEN VEGETA','685221',1,NULL,NULL,NULL,NULL),(417,'AMORTIZ.COSTO-CONCESIONES  LICENCIAS Y OTROS DEREC','686111',1,NULL,NULL,NULL,NULL),(418,'AMORTIZ.COSTO-PATENTES Y PROPIEDAD INDUSTRIAL     ','686121',1,NULL,NULL,NULL,NULL),(419,'AMORTIZ.COSTO-PROGRAMAS DE COMPUTADORA (SOFTWARE) ','686131',1,NULL,NULL,NULL,NULL),(420,'AMORTIZ.COSTO-COSTO DE EXPLORACION Y DESARROLLO   ','686141',1,NULL,NULL,NULL,NULL),(421,'AMORTIZ.COSTO-FORMULAS  DISEÐOS Y PROTOTIPOS      ','686151',1,NULL,NULL,NULL,NULL),(422,'AMORTIZ.COSTO-OTROS ACTIVOS INTANGIBLES           ','686191',1,NULL,NULL,NULL,NULL),(423,'AMORTIZ.REVAL.-CONCESIONES  LICENCIAS Y OTROS DERE','686211',1,NULL,NULL,NULL,NULL),(424,'AMORTIZ.REVAL.-PATENTES Y PROPIEDAD INDUSTRIAL    ','686221',1,NULL,NULL,NULL,NULL),(425,'AMORTIZ.REVAL.-PROGRAMAS DE COMPUTADORA (SOFTWARE)','686231',1,NULL,NULL,NULL,NULL),(426,'AMORTIZ.REVAL.-COSTOS DE EXPLORACION Y DESARROLLO ','686241',1,NULL,NULL,NULL,NULL),(427,'AMORTIZ.REVAL.-FORMULAS  DISEÐOS Y PROTOTIPOS     ','686251',1,NULL,NULL,NULL,NULL),(428,'AMORTIZ.REVAL.-OTROS ACTIVOS INTANGIBLES          ','686291',1,NULL,NULL,NULL,NULL),(429,'COBR.DUDOSA-CTAS POR COBRAR COMERCIALES -TERCEROS ','687111',1,NULL,NULL,NULL,NULL),(430,'COBR.DUDOSA-CTAS POR COBRAR COMERCIALES-RELACIONAD','687121',1,NULL,NULL,NULL,NULL),(431,'COBR.DUDOSA-CTAS POR COBRAR AL PER.ACC.(SOCIOS)DIR','687131',1,NULL,NULL,NULL,NULL),(432,'COBR.DUDOSA-CTAS POR COBRAR DIVERSAS -TERCEROS    ','687141',1,NULL,NULL,NULL,NULL),(433,'COBR.DUDOSA-CUENTAS POR COBRAR DIVER.-RELACIONADAS','687151',1,NULL,NULL,NULL,NULL),(434,'DESVAL.DE INVER. A SER MANTENIDAS HASTA EL VENCIM ','687311',1,NULL,NULL,NULL,NULL),(435,'DESVAL.INSTRUM.REPRES.FINAN.PATRIMONIAL DE DERECHO','687321',1,NULL,NULL,NULL,NULL),(436,'DESVAL.DE PROPIEDAD DE INVER.-EDIFICACIONES       ','688121',1,NULL,NULL,NULL,NULL),(437,'DESVAL.DE PROPIEDAD DE INVER.-INVERSIONES EN CURSO','688131',1,NULL,NULL,NULL,NULL),(438,'DESVAL.ACT.POR DER.DE USO-PLANTA PRODUCT.EN PRODUC','688201',1,NULL,NULL,NULL,NULL),(439,'DESVAL.ACT.POR DER.DE USO-PLANTA PRODUCT.EN DESARR','688211',1,NULL,NULL,NULL,NULL),(440,'DESVAL.ACT.POR DER.DE USO-TERRENOS                ','688221',1,NULL,NULL,NULL,NULL),(441,'DESVAL.ACT.POR DER.DE USO-EDIFICACIONES           ','688231',1,NULL,NULL,NULL,NULL),(442,'DESVAL.ACT.POR DER.DE USO-MAQUIN.Y EQUIP.DE EXPLOT','688241',1,NULL,NULL,NULL,NULL),(443,'DESVAL.ACT.POR DER.DE USO-UNIDADES DE TRANSPORTE  ','688251',1,NULL,NULL,NULL,NULL),(444,'DESVAL.ACT.POR DER.DE USO-MUEBLES Y ENSERES       ','688261',1,NULL,NULL,NULL,NULL),(445,'DESVAL.ACT.POR DER.DE USO-EQUIPOS DIVERSOS        ','688271',1,NULL,NULL,NULL,NULL),(446,'DESVAL.ACT.POR DER.DE USO-HERRAM.Y UNID.DE REEMPLA','688281',1,NULL,NULL,NULL,NULL),(447,'DESVAL.DE PPyE.-PLANTA PRODUCTORA EN PRODUCCION   ','688301',1,NULL,NULL,NULL,NULL),(448,'DESVAL.DE PPyE.-PLANTA PRODUCTORA EN DESARROLLO   ','688311',1,NULL,NULL,NULL,NULL),(449,'DESVAL.DE PPyE.-TERRENOS                          ','688321',1,NULL,NULL,NULL,NULL),(450,'DESVAL.DE PPyE.-EDIFICACIONES                     ','688331',1,NULL,NULL,NULL,NULL),(451,'DESVAL.DE PPyE.-MAQUIN. Y EQUIPOS DE EXPLOTACION  ','688341',1,NULL,NULL,NULL,NULL),(452,'DESVAL.DE PPyE.-UNIDADES DE TRANSPORTE            ','688351',1,NULL,NULL,NULL,NULL),(453,'DESVAL.DE PPyE.-MUEBLES Y ENSERES                 ','688361',1,NULL,NULL,NULL,NULL),(454,'DESVAL.DE PPyE.-EQUIPOS DIVERSOS                  ','688371',1,NULL,NULL,NULL,NULL),(455,'DESVAL.DE PPyE.-HERRAM.Y UNIDADES DE REEMPLAZO    ','688381',1,NULL,NULL,NULL,NULL),(456,'DESVAL.CONCESIONES LICENCIAS Y OTROS DERECHOS     ','688411',1,NULL,NULL,NULL,NULL),(457,'DESVAL. PATENTES Y PROPIEDAD INDUSTRIAL           ','688421',1,NULL,NULL,NULL,NULL),(458,'DESVAL.PROGRAMAS DE COMPUTADORA (SOFTWARE)        ','688431',1,NULL,NULL,NULL,NULL),(459,'DESVAL.COSTOS DE EXPLORACION Y DESARROLLO         ','688441',1,NULL,NULL,NULL,NULL),(460,'DESVAL.FORMULAS  DISEÐOS Y PROTOTIPOS             ','688451',1,NULL,NULL,NULL,NULL),(461,'DESVAL.OTROS ACTIVOS INTANGIBLES                  ','688461',1,NULL,NULL,NULL,NULL),(462,'DESVAL.PLUSVALIA MERCANTIL                        ','688471',1,NULL,NULL,NULL,NULL),(463,'DESVAL.ACTIVOS BIOLOGICOS DE ORIGEN ANIMAL        ','688511',1,NULL,NULL,NULL,NULL),(464,'DESVAL.ACTIVOS BIOLOGICOS DE ORIGEN VEGETAL       ','688521',1,NULL,NULL,NULL,NULL),(465,'PROVISION PARA LITIGIOS - COSTO                   ','689111',1,NULL,NULL,NULL,NULL),(466,'PROVISION PARA LITIGIOS - ACTUALIZACION FINANCIERA','689121',1,NULL,NULL,NULL,NULL),(467,'PROV.POR DESM.  RETIRO O REHAB.INMOV-COSTO        ','689211',1,NULL,NULL,NULL,NULL),(468,'PROV.POR DESM.  RETIRO O REHAB.INMOV-ACTUAL.FINAN.','689221',1,NULL,NULL,NULL,NULL),(469,'PROVISION PARA REESTRUCTURACIONES                 ','689311',1,NULL,NULL,NULL,NULL),(470,'PROV.PROTECC.Y REMEDIACION DEL MEDIO AMB-COSTO    ','689411',1,NULL,NULL,NULL,NULL),(471,'PROV.PROTECC.Y REMEDIACION DEL MEDIO AMB-ACT. FIN.','689421',1,NULL,NULL,NULL,NULL),(472,'PROVISION PARA GARANTIAS - COSTO                  ','689611',1,NULL,NULL,NULL,NULL),(473,'PROVISION PARA GARANTIAS - ACTUALIZACION FINAN    ','689621',1,NULL,NULL,NULL,NULL),(474,'PROV.POR ACT.DERECHO DE USO ARREND.OPER.-COSTO    ','689711',1,NULL,NULL,NULL,NULL),(475,'PROV.POR ACT.DERECHO DE USO ARREND.OPER.-ACT.FIN  ','689721',1,NULL,NULL,NULL,NULL),(476,'OTRAS PROVISIONES                                 ','689911',1,NULL,NULL,NULL,NULL),(477,'MERCADERIAS -EXPORTACION TERCEROS                 ','691111',1,NULL,NULL,NULL,NULL),(478,'MERCADERIAS -EXPORTACION RELACIONADAS             ','691121',1,NULL,NULL,NULL,NULL),(479,'MERCADERIAS VENTA LOCAL TERCEROS                  ','691211',1,NULL,NULL,NULL,NULL),(480,'MERCADERIAS VENTA LOCAL RELACIONADAS              ','691221',1,NULL,NULL,NULL,NULL),(481,'PRODUCTOS TERMINADOS - EXPORTACION TERCEROS       ','692111',1,NULL,NULL,NULL,NULL),(482,'PRODUCTOS TERMINADOS - EXPORTACION RELACIONADAS   ','692121',1,NULL,NULL,NULL,NULL),(483,'PRODUCTOS TERMINADOS - VENTA LOCALTERCEROS        ','692211',1,NULL,NULL,NULL,NULL),(484,'PRODUCTOS TERMINADOS - VENTA LOCAL RELACIONADAS   ','692221',1,NULL,NULL,NULL,NULL),(485,'COSTOS DE FINANCIACION - PROD.TERMINADOS TERCEROS ','692311',1,NULL,NULL,NULL,NULL),(486,'COSTOS DE FINANCIACION - PROD.TERMINADOS RELAC.   ','692321',1,NULL,NULL,NULL,NULL),(487,'COSTOS DE PRODUCCION NO ABSORBIDO - PRODUCTOS TERM','692411',1,NULL,NULL,NULL,NULL),(488,'COSTO DE INEFICIENCIA - PRODUCTOS TERMINADOS      ','692511',1,NULL,NULL,NULL,NULL),(489,'SERVICIOS - EXPORTACION TERCEROS                  ','693111',1,NULL,NULL,NULL,NULL),(490,'SERVICIOS - EXPORTACION RELACIONADAS              ','693121',1,NULL,NULL,NULL,NULL),(491,'SERVICIOS - LOCAL TERCEROS                        ','693211',1,NULL,NULL,NULL,NULL),(492,'SERVICIOS - LOCAL RELACIONADAS                    ','693221',1,NULL,NULL,NULL,NULL),(493,'SUB PRODUCTOS TERCEROS                            ','694111',1,NULL,NULL,NULL,NULL),(494,'SUB PRODUCTOS RELACIONADAS                        ','694121',1,NULL,NULL,NULL,NULL),(495,'DESECHOS Y DESPERDICIOS TERCEROS                  ','694211',1,NULL,NULL,NULL,NULL),(496,'DESECHOS Y DESPERDICIOS RELACIONADAS              ','694221',1,NULL,NULL,NULL,NULL),(497,'MERCADERIAS VENTAS DE EXPORTACION TERCEROS        ','701111',1,NULL,NULL,NULL,NULL),(498,'MERCADERIAS VENTAS DE EXPORTACION RELACIONADAS    ','701121',1,NULL,NULL,NULL,NULL),(499,'MERCADERIAS VENTA LOCAL TERCEROS                  ','701211',1,NULL,NULL,NULL,NULL),(500,'MERCADERIAS VENTA LOCAL RELACIONADAS              ','701221',1,NULL,NULL,NULL,NULL),(501,'PROD.TERMINADOS -VENTA EXPORTACION TERCEROS       ','702111',1,NULL,NULL,NULL,NULL),(502,'PROD. TERMINADOS -VENTA EXPORTACION  RELACIONADAS ','702121',1,NULL,NULL,NULL,NULL),(503,'PRODUCTOSTERMINADOS - VENTA LOCAL TERCEROS        ','702211',1,NULL,NULL,NULL,NULL),(504,'PRODUCTOSTERMINADOS - VENTA LOCAL RELACIONADAS    ','702221',1,NULL,NULL,NULL,NULL),(505,'SERVICIOS - EXPORTACION  TERCEROS                 ','703111',1,NULL,NULL,NULL,NULL),(506,'SERVICIOS - EXPORTACION  RELACIONADAS             ','703121',1,NULL,NULL,NULL,NULL),(507,'SERVICIOS - LOCAL TERCEROS                        ','703211',1,NULL,NULL,NULL,NULL),(508,'SERVICIOS - LOCAL RELACIONADAS                    ','703221',1,NULL,NULL,NULL,NULL),(509,'SUB PRODUCTOS - TERCEROS                          ','704111',1,NULL,NULL,NULL,NULL),(510,'SUB PRODUCTOS - RELACIONADAS                      ','704121',1,NULL,NULL,NULL,NULL),(511,'DESECHOS Y DESPERDICIOS - TERCEROS                ','704211',1,NULL,NULL,NULL,NULL),(512,'DESECHOS Y DESPERDICIOS - RELACIONADAS            ','704221',1,NULL,NULL,NULL,NULL),(513,'MERCADERIAS - VENTA DE EXPORTACION TERCEROS       ','709111',1,NULL,NULL,NULL,NULL),(514,'MERCADERIAS - VENTA DE EXPORTACION RELACIONADAS   ','709121',1,NULL,NULL,NULL,NULL),(515,'MERCADERIAS - VENTA LOCAL  TERCEROS               ','709211',1,NULL,NULL,NULL,NULL),(516,'MERCADERIAS - VENTA LOCAL  RELACIONADAS           ','709221',1,NULL,NULL,NULL,NULL),(517,'PRODUCTOS TERMINADOS VENTA DE EXPORTACION TERCEROS','709311',1,NULL,NULL,NULL,NULL),(518,'PROD. TERMINADOS VENTA DE EXPORTACION RELACIONADAS','709321',1,NULL,NULL,NULL,NULL),(519,'PRODUCTOS TERMINADOS - VENTA LOCAL TERCEROS       ','709411',1,NULL,NULL,NULL,NULL),(520,'PRODUCTOS TERMINADOS - VENTA LOCAL RELACIONADAS   ','709421',1,NULL,NULL,NULL,NULL),(521,'INVENTARIOS DE SERVICIOS RECHAZADOS TERCEROS      ','709511',1,NULL,NULL,NULL,NULL),(522,'INVENTARIOS DE SERVICIOS RECHAZADOS RELACIONADOS  ','709521',1,NULL,NULL,NULL,NULL),(523,'SUBPRODUCTOS  DESECHOS Y DESPERDICIOS-TERCEROS    ','709611',1,NULL,NULL,NULL,NULL),(524,'SUBPRODUCTOS  DESECHOS Y DESPERDICIOS-RELACIONADAS','709621',1,NULL,NULL,NULL,NULL),(525,'VARIACION PRODUCTOS TERMINADOS                    ','711101',1,NULL,NULL,NULL,NULL),(526,'VARIACION SUBPRODUCTOS                            ','712101',1,NULL,NULL,NULL,NULL),(527,'VARIACION DESECHOS Y DESPERDICIOS                 ','712201',1,NULL,NULL,NULL,NULL),(528,'VARIACION PRODUCTOS EN PROCESO DE MANUFACTURA     ','713101',1,NULL,NULL,NULL,NULL),(529,'VARIACION ENVASES                                 ','714101',1,NULL,NULL,NULL,NULL),(530,'VARIACION EMBALAJES                               ','714201',1,NULL,NULL,NULL,NULL),(531,'INVENTARIOS DE SERVICIOS EN PROCESO               ','715101',1,NULL,NULL,NULL,NULL),(532,'PROPIEDADES DE INVERSION EDIFICACIONES            ','721101',1,NULL,NULL,NULL,NULL),(533,'PLANTA PRODUCTORA                                 ','722001',1,NULL,NULL,NULL,NULL),(534,'EDIFICACIONES                                     ','722101',1,NULL,NULL,NULL,NULL),(535,'MAQUINARIAS Y OTROS EQUIPOS DE EXPLOTACION        ','722201',1,NULL,NULL,NULL,NULL),(536,'MAQUINARIAS Y OTROS EQUIPOS DE EXPLOTACION        ','722301',1,NULL,NULL,NULL,NULL),(537,'MUEBLES Y ENSERES                                 ','722401',1,NULL,NULL,NULL,NULL),(538,'EQUIPOS DIVERSOS                                  ','722501',1,NULL,NULL,NULL,NULL),(539,'PROGRAMAS DE COMPUTADORA (SOFTWARE)               ','723101',1,NULL,NULL,NULL,NULL),(540,'COSTOS DE EXPLORACION Y DESARROLLO                ','723201',1,NULL,NULL,NULL,NULL),(541,'FORMULAS  DISEÐOS Y PROTOTIPOS                    ','723301',1,NULL,NULL,NULL,NULL),(542,'ACTIVOS BIOLOGICOS EN DESARROLLO DE ORIGEN ANIMAL ','724111',1,NULL,NULL,NULL,NULL),(543,'ACTIVOS BIOLOGICOS EN DESARROLLO DE ORIGEN VEGETAL','724211',1,NULL,NULL,NULL,NULL),(544,'PLANTAS PRODUCTORAS EN DESARROLLO                 ','725111',1,NULL,NULL,NULL,NULL),(545,'EDIFICACIONES                                     ','725121',1,NULL,NULL,NULL,NULL),(546,'PLANTAS PRODUCTORAS EN DESARROLLO                 ','725211',1,NULL,NULL,NULL,NULL),(547,'EDIFICACIONES                                     ','725221',1,NULL,NULL,NULL,NULL),(548,'MAQUINARIAS Y OTROS EQUIPOS DE EXPLOTACION        ','725231',1,NULL,NULL,NULL,NULL),(549,'DESC.REBAJAS Y BONIF. OBTENIDOS TERCEROS          ','731101',1,NULL,NULL,NULL,NULL),(550,'DESC.REBAJAS Y BONIF. OBTENIDOS RELACIONADAS      ','731201',1,NULL,NULL,NULL,NULL),(551,'DESC.REBAJAS Y BONIF. CONCEDIDOS TERCEROS         ','741101',1,NULL,NULL,NULL,NULL),(552,'DESC.REBAJAS Y BONIF. CONCEDIDOS RELACIONADAS     ','741201',1,NULL,NULL,NULL,NULL),(553,'SERVICIOS EN BENEFICIO DEL PERSONAL               ','751101',1,NULL,NULL,NULL,NULL),(554,'COMISIONES Y CORRETAJES                           ','752101',1,NULL,NULL,NULL,NULL),(555,'REGALIAS                                          ','753101',1,NULL,NULL,NULL,NULL),(556,'ALQUILERES PLANTAS PRODUCTORAS                    ','754001',1,NULL,NULL,NULL,NULL),(557,'ALQUILERES TERRENOS                               ','754101',1,NULL,NULL,NULL,NULL),(558,'ALQUILERES EDIFICACIONES                          ','754201',1,NULL,NULL,NULL,NULL),(559,'ALQUILERES MAQUINARIAS Y EQUIPOS DE EXPLOTACION   ','754301',1,NULL,NULL,NULL,NULL),(560,'ALQUILERES EQUIPO DE TRANSPORTE                   ','754401',1,NULL,NULL,NULL,NULL),(561,'ALQUILERES EQUIPOS DIVERSOS                       ','754501',1,NULL,NULL,NULL,NULL),(562,'RECUPERACION - CUENTAS DE COBRANZA DUDOSA         ','755101',1,NULL,NULL,NULL,NULL),(563,'RECUPERACION - DESVALORIZACION DE INVENTARIOS     ','755201',1,NULL,NULL,NULL,NULL),(564,'RECUPERACION - DESVALORIZACION DE INVERSIONES MOBI','755301',1,NULL,NULL,NULL,NULL),(565,'INVERSIONES MOBILIARIAS                           ','756101',1,NULL,NULL,NULL,NULL),(566,'PROPIEDADES DE INVERSION                          ','756201',1,NULL,NULL,NULL,NULL),(567,'ACTIVOS ADQUIRIDOS EN ARRENDAMIENTO FINANCIERO    ','756301',1,NULL,NULL,NULL,NULL),(568,'PROPIEDAD  PLANTA Y EQUIPO                        ','756401',1,NULL,NULL,NULL,NULL),(569,'INTANGIBLES                                       ','756501',1,NULL,NULL,NULL,NULL),(570,'ACTIVOS BIOLOGICOS                                ','756601',1,NULL,NULL,NULL,NULL),(571,'RECUPERACION DE DETERIORO DE PROPIEDADES DE INVER ','757101',1,NULL,NULL,NULL,NULL),(572,'REC. DE DETERIORO DE PROPIEDAD  PLANTA Y EQUIPO   ','757201',1,NULL,NULL,NULL,NULL),(573,'RECUPERACION DE DETERIORO DE INTANGIBLES          ','757301',1,NULL,NULL,NULL,NULL),(574,'RECUPERACION DE DETERIORO DE ACTIVOS BIOLOGICOS   ','757401',1,NULL,NULL,NULL,NULL),(575,'SUBSIDIOS GUBERNAMENTALES                         ','759101',1,NULL,NULL,NULL,NULL),(576,'RECLAMOS AL SEGURO                                ','759201',1,NULL,NULL,NULL,NULL),(577,'DONACIONES                                        ','759301',1,NULL,NULL,NULL,NULL),(578,'DEVOLUCIONES TRIBUTARIAS                          ','759401',1,NULL,NULL,NULL,NULL),(579,'OTROS INGRESOS DE GESTION                         ','759901',1,NULL,NULL,NULL,NULL),(580,'PROPIEDAD DE INVERSION                            ','761311',1,NULL,NULL,NULL,NULL),(581,'PROPIEDA  PLANTA Y EQUIPO                         ','761321',1,NULL,NULL,NULL,NULL),(582,'INTANGIBLES                                       ','761331',1,NULL,NULL,NULL,NULL),(583,'ACTIVOS BIOLOGICOS                                ','761341',1,NULL,NULL,NULL,NULL),(584,'ACTIVO INMOVILIZADO                               ','762111',1,NULL,NULL,NULL,NULL),(585,'ACTIVOS BIOLOGICOS                                ','762211',1,NULL,NULL,NULL,NULL),(586,'GANANCIA POR INSTRUMENTO FINANCIERO DERIVADO      ','771101',1,NULL,NULL,NULL,NULL),(587,'INTERESES FINANCIEROS                             ','772101',1,NULL,NULL,NULL,NULL),(588,'CUENTAS POR COBRAR COMERCIALES TERCEROS           ','772201',1,NULL,NULL,NULL,NULL),(589,'PRESTAMOS OTORGADOS TERCEROS                      ','772301',1,NULL,NULL,NULL,NULL),(590,'INVERSIONES A SER MANTENIDAS HASTA EL VENCIMIENTO ','772401',1,NULL,NULL,NULL,NULL),(591,'INSTRUMENTOS FINANCIEROS REPRESENTATIVOS DE DERECH','772501',1,NULL,NULL,NULL,NULL),(592,'DIVIDENDOS                                        ','773101',1,NULL,NULL,NULL,NULL),(593,'INGRESOS EN OPERACIONES DE FACTORAJE (FACTORING)  ','774101',1,NULL,NULL,NULL,NULL),(594,'DESCUENTOS OBTENIDOS POR PRONTO PAGO              ','775101',1,NULL,NULL,NULL,NULL),(595,'GANANCIA POR DIFERENCIA DE CAMBIO                 ','776101',1,NULL,NULL,NULL,NULL),(596,'INVERSIONES MANTENIDAS PARA NEGOCIACION           ','777101',1,NULL,NULL,NULL,NULL),(597,'OTRAS INVERSIONES                                 ','777201',1,NULL,NULL,NULL,NULL),(598,'OTRAS                                             ','777301',1,NULL,NULL,NULL,NULL),(599,'PARTIC.EN RES.DE SUBS.Y ASOC.BAJO EL MET.VAL.PATRI','778101',1,NULL,NULL,NULL,NULL),(600,'INGRESOS POR PARTICIPACIONES EN NEGOCIOS CONJUNTOS','778201',1,NULL,NULL,NULL,NULL),(601,'OTROS INGRESOS FINANCIEROS                        ','779101',1,NULL,NULL,NULL,NULL),(602,'CARGAS CUBIERTAS POR PROVISIONES                  ','781101',1,NULL,NULL,NULL,NULL),(603,'CARGAS IMPUTABLES A CUENTAS DE COSTOS Y GASTOS    ','791101',1,NULL,NULL,NULL,NULL),(604,'CARGAS IMPUTABLES A CUENTAS DE COSTOS Y GASTOS    ','792111',1,NULL,NULL,NULL,NULL),(605,'MARGEN COMERCIAL                                  ','801101',1,NULL,NULL,NULL,NULL),(606,'PRODUCCION DE BIENES                              ','811101',1,NULL,NULL,NULL,NULL),(607,'VALOR AGREGADO                                    ','821101',1,NULL,NULL,NULL,NULL),(608,'EXCEDENTE BRUTO (INSUFICIENCIA BRUTA) DE EXPLOTACI','831101',1,NULL,NULL,NULL,NULL),(609,'RESULTADO DE EXPLOTACION                          ','841101',1,NULL,NULL,NULL,NULL),(610,'RESULTADO ANTES DE IMPUESTO A LAS GANANCIAS       ','851101',1,NULL,NULL,NULL,NULL),(611,'IMPUESTO A LAS GANANCIAS - CORRIENTE              ','881101',1,NULL,NULL,NULL,NULL),(612,'UTILIDAD                                          ','891101',1,NULL,NULL,NULL,NULL),(613,'COSTO DE PRODUCCION                               ','901101',1,NULL,NULL,NULL,NULL),(614,'COSTO DE SERVICIOS                                ','911101',1,NULL,NULL,NULL,NULL),(615,'GASTOS DE ADMINISTRACION                          ','941101',1,NULL,NULL,NULL,NULL),(616,'GASTOS DE VENTAS                                  ','951101',1,NULL,NULL,NULL,NULL),(617,'GASTOS FINANCIEROS                                ','971101',1,NULL,NULL,NULL,NULL),(618,'PERDIDA POR DIFERENCIA DE CAMBIO                  ','976101',1,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cuentas_contables` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cuotas`
--

DROP TABLE IF EXISTS `cuotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cuotas` (
  `cuo_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ordcom_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `cuo_fechahora` datetime DEFAULT NULL,
  `cuo_fecha_cuota` date DEFAULT NULL,
  `cuo_monto` float NOT NULL DEFAULT 0,
  `cuo_estado_pago` int(10) unsigned NOT NULL DEFAULT 0,
  `cuo_estado` int(10) unsigned NOT NULL DEFAULT 0,
  `cuo_tipo` varchar(45) NOT NULL DEFAULT 'CUOTA',
  `cuo_descripcion` text DEFAULT NULL,
  PRIMARY KEY (`cuo_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cuotas`
--

LOCK TABLES `cuotas` WRITE;
/*!40000 ALTER TABLE `cuotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `cuotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `direcciones`
--

DROP TABLE IF EXISTS `direcciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `direcciones` (
  `dir_codi` int(11) NOT NULL AUTO_INCREMENT,
  `dir_descripcion` longtext NOT NULL,
  `dir_detalle` longtext DEFAULT NULL,
  `dir_estado` int(11) NOT NULL DEFAULT 1,
  `dirtip_codi_fk` int(11) NOT NULL,
  `per_codi_fk` int(11) NOT NULL,
  PRIMARY KEY (`dir_codi`),
  KEY `fk_direcciones_direcciones_tipo1_idx` (`dirtip_codi_fk`),
  KEY `fk_direcciones_personas1_idx` (`per_codi_fk`),
  CONSTRAINT `fk_direcciones_direcciones_tipo1` FOREIGN KEY (`dirtip_codi_fk`) REFERENCES `direcciones_tipo` (`dirtip_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_direcciones_personas1` FOREIGN KEY (`per_codi_fk`) REFERENCES `personas` (`per_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `direcciones`
--

LOCK TABLES `direcciones` WRITE;
/*!40000 ALTER TABLE `direcciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `direcciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `direcciones_tipo`
--

DROP TABLE IF EXISTS `direcciones_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `direcciones_tipo` (
  `dirtip_codi` int(11) NOT NULL AUTO_INCREMENT,
  `dirtip_nombre` varchar(80) NOT NULL,
  `dirtip_estado` varchar(45) NOT NULL DEFAULT '1',
  PRIMARY KEY (`dirtip_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `direcciones_tipo`
--

LOCK TABLES `direcciones_tipo` WRITE;
/*!40000 ALTER TABLE `direcciones_tipo` DISABLE KEYS */;
INSERT INTO `direcciones_tipo` VALUES (1,'COMERCIAL','1'),(2,'VIVIENDA','1'),(3,'DESPACHO','1');
/*!40000 ALTER TABLE `direcciones_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `documento_pago`
--

DROP TABLE IF EXISTS `documento_pago`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documento_pago` (
  `docpag_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `docpag_nombre` varchar(45) NOT NULL DEFAULT '',
  `docpag_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `comtip_codigo_fk` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`docpag_codi`),
  UNIQUE KEY `Index_docpag_nombre` (`docpag_nombre`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documento_pago`
--

LOCK TABLES `documento_pago` WRITE;
/*!40000 ALTER TABLE `documento_pago` DISABLE KEYS */;
INSERT INTO `documento_pago` VALUES (1,'NOTA DE VENTA',1,'00'),(2,'BOLETA',1,'03'),(3,'FACTURA',1,'01');
/*!40000 ALTER TABLE `documento_pago` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `documento_tipo`
--

DROP TABLE IF EXISTS `documento_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documento_tipo` (
  `doctip_codi` int(11) NOT NULL AUTO_INCREMENT,
  `doctip_nombre` varchar(145) DEFAULT NULL,
  `doctip_estado` int(11) NOT NULL DEFAULT 1,
  `doctip_abreviatura` varchar(45) DEFAULT NULL,
  `doctip_usu_crea` varchar(45) DEFAULT NULL,
  `doctip_usu_modifica` varchar(45) DEFAULT NULL,
  `doctip_usu_activa` varchar(45) DEFAULT NULL,
  `doctip_documentado` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`doctip_codi`),
  UNIQUE KEY `Index_doctip_nombre` (`doctip_nombre`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documento_tipo`
--

LOCK TABLES `documento_tipo` WRITE;
/*!40000 ALTER TABLE `documento_tipo` DISABLE KEYS */;
INSERT INTO `documento_tipo` VALUES (1,'FACTURA',1,'01',NULL,'LSANCHEZ',NULL,1),(2,'BOLETA',1,'03',NULL,'LSANCHEZ',NULL,1),(3,'RECIBO',1,NULL,NULL,NULL,NULL,0),(4,'GUIA DE REMISION',1,'09',NULL,'LSANCHEZ',NULL,0),(5,'NOTA DE CREDITO',1,'07',NULL,'LSANCHEZ',NULL,1),(6,'NOTA DE DEBITO',1,'08',NULL,'LSANCHEZ',NULL,1),(7,'BOLETO DE DEPOSITO',1,NULL,NULL,NULL,NULL,0),(8,'CHEQUE',1,NULL,NULL,NULL,NULL,0),(9,'PAGARE',1,NULL,NULL,NULL,NULL,0),(10,'ORDEN DE COMPRA',1,NULL,NULL,NULL,NULL,0),(11,'ORDEN DE PEDIDO',1,NULL,NULL,NULL,NULL,0),(12,'NOTA DE VENTA',1,NULL,NULL,NULL,NULL,0),(13,'REQUERIMIENTO INTERNO',1,'-','etorres','etorres',NULL,0),(14,'OPERACION DE ALMACEN',1,'-','etorres',NULL,NULL,0);
/*!40000 ALTER TABLE `documento_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `empresas`
--

DROP TABLE IF EXISTS `empresas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `empresas` (
  `emp_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `emp_nom` varchar(45) NOT NULL DEFAULT '',
  `emp_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `emp_direccion` text DEFAULT NULL,
  `emp_telefono` varchar(45) DEFAULT NULL,
  `emp_ciudad` varchar(45) DEFAULT NULL,
  `emp_usu_crea` varchar(45) DEFAULT NULL,
  `emp_usu_modifica` varchar(45) DEFAULT NULL,
  `emp_usu_activa` varchar(45) DEFAULT NULL,
  `emprai_codi_fk` int(11) NOT NULL DEFAULT 0,
  `emp_exonerado_igv` varchar(45) NOT NULL DEFAULT '0',
  PRIMARY KEY (`emp_codi`),
  UNIQUE KEY `Index_emp_nom` (`emp_nom`),
  KEY `Index_emp_estado` (`emp_estado`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `empresas`
--

LOCK TABLES `empresas` WRITE;
/*!40000 ALTER TABLE `empresas` DISABLE KEYS */;
INSERT INTO `empresas` VALUES (1,'IMPORTACIONES ALEJANDRA S.A.C.',1,'IMPORTACIONES & SERVICIOS GENERALES ALEJANDRA S.A.C.','Teléfono: 958878371','CHICLAYO','etorres','',NULL,1,'');
/*!40000 ALTER TABLE `empresas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `empresas_cuentas_corrientes`
--

DROP TABLE IF EXISTS `empresas_cuentas_corrientes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `empresas_cuentas_corrientes` (
  `empcta_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `empcta_banco` varchar(245) NOT NULL DEFAULT '',
  `empcta_nro_cuenta` varchar(145) NOT NULL DEFAULT '',
  `empcta_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `empcta_fechahora` datetime DEFAULT NULL,
  `empcta_usu_crea` varchar(145) DEFAULT NULL,
  `empcta_usu_modifica` varchar(145) DEFAULT NULL,
  PRIMARY KEY (`empcta_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `empresas_cuentas_corrientes`
--

LOCK TABLES `empresas_cuentas_corrientes` WRITE;
/*!40000 ALTER TABLE `empresas_cuentas_corrientes` DISABLE KEYS */;
/*!40000 ALTER TABLE `empresas_cuentas_corrientes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `empresas_raiz`
--

DROP TABLE IF EXISTS `empresas_raiz`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `empresas_raiz` (
  `emprai_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `emprai_razon_social` varchar(240) NOT NULL DEFAULT '',
  `emprai_nombre_comercial` varchar(240) NOT NULL DEFAULT '',
  `emprai_ruc` varchar(45) NOT NULL DEFAULT '',
  `emprai_estado` int(10) unsigned NOT NULL DEFAULT 0,
  `emprai_facturacion_electronica` int(10) unsigned NOT NULL DEFAULT 0,
  `emprai_direccion` varchar(245) NOT NULL DEFAULT '',
  `emprai_web` varchar(245) NOT NULL,
  `emprai_email` varchar(245) NOT NULL,
  PRIMARY KEY (`emprai_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `empresas_raiz`
--

LOCK TABLES `empresas_raiz` WRITE;
/*!40000 ALTER TABLE `empresas_raiz` DISABLE KEYS */;
INSERT INTO `empresas_raiz` VALUES (1,'IMPORTACIONES & SERVICIOS GENERALES ALEJANDRA S.A.C.','IMPORTACIONES & SERVICIOS GENERALES ALEJANDRA S.A.C.','20607028614',1,1,'AV. LUIS GONZALES URB. SAN LUIS - CHICLAYO - CHICLAYO - LAMBAYEQUE ','','importacionesale2@gmail.com');
/*!40000 ALTER TABLE `empresas_raiz` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `guia_remision`
--

DROP TABLE IF EXISTS `guia_remision`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `guia_remision` (
  `gui_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gui_nro_comprobante` varchar(45) NOT NULL DEFAULT '',
  `tra_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `traemp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `gui_fecha_emision` date DEFAULT NULL,
  `gui_fecha_traslado` date DEFAULT NULL,
  `gui_punto_partida` varchar(245) NOT NULL DEFAULT '',
  `gui_punto_llegada` varchar(245) NOT NULL DEFAULT '',
  `gui_destinatario` varchar(245) NOT NULL DEFAULT '',
  `mot_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `opealm_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `gui_marca_placa` varchar(245) NOT NULL DEFAULT '',
  `gui_observacion` varchar(245) NOT NULL DEFAULT '',
  `gui_numero` varchar(45) NOT NULL DEFAULT '',
  `veh_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`gui_codi`),
  KEY `Index_gui_nro_comprobante` (`gui_nro_comprobante`),
  KEY `Index_gui_numero` (`gui_numero`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `guia_remision`
--

LOCK TABLES `guia_remision` WRITE;
/*!40000 ALTER TABLE `guia_remision` DISABLE KEYS */;
/*!40000 ALTER TABLE `guia_remision` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inasistencias`
--

DROP TABLE IF EXISTS `inasistencias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inasistencias` (
  `ina_codi` int(11) NOT NULL AUTO_INCREMENT,
  `ina_fechahora` datetime DEFAULT NULL,
  `ina_fecha` date DEFAULT NULL,
  `ina_numero` varchar(45) DEFAULT NULL,
  `per_codi_fk` int(11) DEFAULT NULL,
  `ina_estado` int(11) NOT NULL DEFAULT 1,
  `ina_anulado` int(11) NOT NULL DEFAULT 0,
  `ina_monto_dia` float NOT NULL DEFAULT 0,
  `ina_cantidad_dia` float NOT NULL DEFAULT 0,
  `ina_anotaciones` text DEFAULT NULL,
  `ina_usu_crea` varchar(45) DEFAULT NULL,
  `ina_usu_modifica` varchar(45) DEFAULT NULL,
  `ina_usu_activa` varchar(45) DEFAULT NULL,
  `idtrans` varchar(45) DEFAULT NULL,
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`ina_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inasistencias`
--

LOCK TABLES `inasistencias` WRITE;
/*!40000 ALTER TABLE `inasistencias` DISABLE KEYS */;
/*!40000 ALTER TABLE `inasistencias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `marcas`
--

DROP TABLE IF EXISTS `marcas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `marcas` (
  `mar_codi` int(11) NOT NULL AUTO_INCREMENT,
  `mar_nombre` varchar(45) NOT NULL DEFAULT '',
  `mar_estado` int(11) NOT NULL DEFAULT 1,
  `mar_abreviatura` varchar(45) DEFAULT NULL,
  `mar_usu_crea` varchar(45) DEFAULT NULL,
  `mar_usu_modifica` varchar(45) DEFAULT NULL,
  `mar_usu_activa` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`mar_codi`),
  UNIQUE KEY `Index_mar_nombre` (`mar_nombre`),
  KEY `Index_mar_estado` (`mar_estado`)
) ENGINE=InnoDB AUTO_INCREMENT=237 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `marcas`
--

LOCK TABLES `marcas` WRITE;
/*!40000 ALTER TABLE `marcas` DISABLE KEYS */;
INSERT INTO `marcas` VALUES (1,'ACEROS AREQUIPA',1,'ACE AQP','','',''),(2,'PACASMAYO',1,NULL,'','',''),(4,'CELIMA',1,'','','',''),(5,'TREBOL',1,'','','',''),(6,'SOL',1,'','','',''),(7,'YURA',1,'','','',''),(8,'VENCEDOR',1,'','','',''),(9,'REX',1,'','','',''),(10,'ACEROMIN',1,'','','',''),(11,'AMERICAN COLOR',1,'','','',''),(12,'SHERWIN WILLIAMS',1,'SW','','',''),(13,'SIDER PERU',1,'SP','','',''),(14,'PLASTICA 2',1,'PLASTICA','','',''),(15,'LARK',1,'LARK','','',''),(16,'CERÁMICOS LAMBAYEQUE',1,'C.LAMB','','',''),(17,'PRODAC',1,'PRODAC','','',''),(18,'ITAL',1,'ITAL','','',''),(19,'SOL DEL NORTE',1,'SN','','',''),(21,'NORTON',1,'NORTON','','',''),(22,'REFINADO PARA CONSTRUCCION',1,'REF. CONST.','','',''),(23,'EPS',1,'EPS','','',''),(24,'OATEY',1,'OATEY','','',''),(25,'SCHUBER',1,'SCHUBER','','',''),(26,'BELLOTA',1,'BELLOTA','','',''),(27,'VOLCAN',1,'VOLCAN','','',''),(28,'TRUPER',1,'TRUPER','','',''),(29,'GUOZU',1,'GUOZU','','',''),(30,'DE CONCHAN',1,'DE CONCHAN','','',''),(31,'BAMBAMARCA 2',1,'BAMB.','','',''),(32,'BAMBAMARCA',1,'BAMB.','','',''),(33,'FIBRAFORTE',1,'FIBRAF.','','',''),(34,'TECNOFAN',1,'TECNOFAN','','',''),(35,'MOCHICA',1,'MOCHICA','','',''),(36,'ND',1,'ND','','',''),(37,'SANIFE',1,'SANIFE','','',''),(38,'TITOMA',1,'TITOMA','','',''),(39,'CAPIRURI',1,'CAPIRURI','','',''),(40,'PCP',1,'PCP','','',''),(41,'PRETUL',1,'PRETU','','',''),(42,'NICOL',1,'NICOL','','',''),(43,'C&A',1,'C&A','','',''),(44,'KBA ELECTRIC',1,'KBA','','',''),(46,'CIL',1,'CIL','','',''),(47,'PRIMOR',1,'','','',''),(48,'PLASTICA',1,'PLAS','','',''),(49,'BAYER',1,'BAYER','','',''),(50,'PAVCO',1,'PAV','','',''),(51,'BELLSAFE',1,'BELLSAF','','',''),(52,'QUIVER',1,'QUIV','','',''),(53,'HERLY',1,'HERLY','','',''),(54,'SAFETYFENCE',1,'SAFETY','','',''),(55,'SANDFLEX',1,'SANDF','','',''),(57,'TECHO PLUS ',1,'TECHO PLUS','','',''),(58,'BADAC',1,'BADAC','','',''),(59,'SIKA ',1,'SIKA ','','',''),(60,'VIRUTEX',1,'VIRUTEX','','',''),(61,'MAT-TIGRE',1,'MAT-TIGRE','','',''),(62,'WILLYS PLAST',1,'WILLYS','','',''),(63,'ETERNIT',1,'ETERNIT','','',''),(64,'VIPSA PLAST',1,'VIPSAPLAS','','',''),(65,'CONCYSSA',1,'CONCY','','',''),(66,'INDECO',1,'','','',''),(67,'TOP LIGHT',1,'','','',''),(68,'HOME LIGHT',1,'','','',''),(69,'CERESITA',1,'','','',''),(70,'ANYPSA',1,'','','',''),(71,'BEST LIGHT',1,'','','',''),(72,'FAVINSA',1,'','','',''),(73,'SUPER CHAVIN',1,'','','',''),(74,'YASELL',1,'YASELL','','',''),(75,'FOSET',1,'FOSET','','',''),(76,'TRAMONTINA',1,'TRAMONTINA','','',''),(77,'PHELIX',1,'PHELIX','','',''),(78,'ORO PLAST',1,'OROP','','',''),(79,'VAINSA',1,'VAIN','','',''),(80,'SERVICPLAST',1,'SERPL','','',''),(81,'BTICINO',1,'TICINO','','',''),(82,'FORDUIT',1,'FORDUIT','','',''),(83,'VENICE',1,'VEN','','',''),(84,'ABRACOL',1,'ABRA','','',''),(85,'IDEACE GATO ',1,'IDGATO','','',''),(86,'PEGASUS',1,'PEG','','',''),(87,'SEGUSA',1,'SEGUSA','','',''),(88,'COMFER',1,'COM','','',''),(89,'GENERAL - ELECTRIC',1,'G.E','','',''),(90,'MASTER',1,'MAS','','',''),(91,'PUNTO AZUL',1,'PAZUL','','',''),(92,'SUPERCITO',1,'SUPER','','',''),(93,'CASCO',1,'CASCO','','',''),(94,'ROTOPLAST',1,'ROT','','',''),(95,'ECOLUX',1,'ECOLUX','','',''),(96,'FSL',1,'FSL','','',''),(97,'NEWSPARK',1,'NEWSPARK','','',''),(98,'FERRAWYY',1,'FERRAWYY','','',''),(99,'APACHE',1,'APACHE','','',''),(100,'UYUSTOOLS',1,'UYUSTOOLS','','',''),(101,'QUISQUEYA',1,'QUISQUEYA','','',''),(102,'TUMI',1,'TUMI','','',''),(103,'TORO',1,'TORO','','',''),(104,'HUDE',1,'HUDE','','',''),(105,'ITALIANA',1,'ITALY','','',''),(106,'BISA',1,'BISA','','',''),(107,'BODY GUARD',1,'BODY','','',''),(108,'STANLEY',1,'STANLEY','','',''),(109,'BOSH',1,'BOSH','','',''),(110,'AGUILA',1,'AGUILA','','',''),(111,'QHUNA',1,'QHUNA','','',''),(112,'LUPUNA',1,'LUPUNA','','',''),(113,'ULTRAPACK',1,'ULTRA','','',''),(114,'CLUTE',1,'CLUTE','','',''),(115,'TECSEG',1,'TEC','','',''),(116,'TEC',1,'TEC','','',''),(117,'ANSELL',1,'ANSELL','','',''),(118,'CANTOL',1,'CANTOL','','',''),(119,'PORJE',1,'PORJE','','',''),(120,'SINYE',1,'SINYE','','',''),(121,'TEMPLE',1,'TEMPLE','','',''),(122,'POLIFLOR',1,'POL','','',''),(123,'HERMEX',1,'HERMEX','','',''),(124,'SONCA SE',1,'SONCASE','','',''),(125,'SONCA',1,'SONCA','','',''),(126,'ULIX',1,'ULIX','','',''),(127,'3M',1,'3M','','',''),(128,'OFERTON',1,'OFERTON','','',''),(129,'PANTER',1,'PANTER','','',''),(130,'TORTUGON',1,'TORTUGON','','',''),(131,'PATO',1,'PATO','','',''),(132,'PARACAS',1,'PAR','','',''),(133,'CPP',1,'CPP','','',''),(134,'THOR',1,'THOR','','',''),(135,'VIKINGO',1,'VIKI','','',''),(136,'FAUCET',1,'FAUCET','','',''),(137,'CATALEYA',1,'CATA','','',''),(138,'KAMASA',1,'KAMASA','','',''),(139,'SOUDAL',1,'SOUDAL','','',''),(140,'ARATY',1,'ARATY','','',''),(141,'CELSA',1,'CELSA','','',''),(142,'MEJIA',1,'MEJIA','','',''),(143,'XACE',1,'XACE','','',''),(144,'INYECTOPLAST',1,'INYECT','','',''),(145,'TUBOCOL',1,'TUBOCOL','','',''),(146,'AFRICANO',1,'AFRICANO','','',''),(147,'HYDRA',1,'HYDRA','','',''),(148,'BILDER',1,'BILDER','','',''),(149,'MSK',1,'MSK','','',''),(150,'LORETO',1,'LORETO','','',''),(151,'CLORINDA',1,'CLORINDA','','',''),(152,'FAVINSUR',1,'FAVI','','',''),(153,'DEXTER',1,'DEX','','',''),(154,'ULTRACRAF',1,'ULTRA','','',''),(156,'BLACK DECKER',1,'B&D','','',''),(157,'LADRINORTE',1,'LADRINORTE','','',''),(158,'INDUPLAST',1,'INDUP','','',''),(159,'INCCO',1,'INCCO','','',''),(160,'TOOLTECH',1,'TOOLTECH','','',''),(161,'FST',1,'FST','','',''),(162,'VELSALIT',1,'VELSA','','',''),(163,'IRRIPLAST',1,'IRRIPLAST','','',''),(164,'VIR',1,'VIR','','',''),(165,'VALMAX',1,'VALMAX','','',''),(166,'METUSA',1,'METUSA','','',''),(167,'FORTE',1,'FORTE','','',''),(168,'ASAKI',1,'ASAKI','','',''),(169,'ADRIANO',1,'ADRIANO','','',''),(170,'DENACET',1,'DENACET','','',''),(171,'TEKNO',1,'TEK','','',''),(195,'STANDARD',1,'','','',''),(196,'PAJARITA',1,'','','',''),(197,'KLINGSPOR',1,'KLINGSPOR','','',''),(198,'KNAUF',1,'KNAUF','','',''),(199,'ALPEN',1,'ALPEN','','',''),(202,'KLINSGPOR',1,'','','',''),(203,'ITALGRIF',1,'ITAL','','',''),(204,'BARCO',1,'','','',''),(205,'PEDROLLO',1,'PEDROLLO','','',''),(206,'WINFLEX',1,'WINFLEX','','',''),(207,'ETERNA',1,'','','',''),(208,'LEGRAND',1,'','','',''),(209,'WAILEC',1,'WAILEC','','',''),(210,'KHOR',1,'','','',''),(211,'HEFESTO',1,'','','',''),(212,'VITTESSE',1,'','','',''),(213,'ITALOCK',1,'','','',''),(214,'XTREME',1,'XTREME','','',''),(215,'2M',1,'2M','','',''),(216,'DKASA',1,'DKASA','','',''),(218,'SEVILLA',1,'','','',''),(219,'TUPLAST',1,'TUPLAST','','',''),(220,'ABRALIT',1,'ABRA','','',''),(221,'STAR',1,'','','',''),(222,'SWIFT',1,'','','',''),(224,'PROTEX',1,'','','',''),(225,'EUROTOOLS',1,'EURO','','',''),(226,'GENEBRE',1,'','','',''),(227,'DUKE',1,'','','',''),(228,'ULTRAPEG',1,'ULTRA','','',''),(229,'JPC',1,'','','',''),(230,'VITALE',1,'VITALE','','',''),(231,'TIGRE',1,'TIGRE','','',''),(234,'PEGAFAN',1,'','','',''),(235,'FIORI',1,'FIORI','','',''),(236,'ASCR',1,'ASCR','','','');
/*!40000 ALTER TABLE `marcas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `masterpack`
--

DROP TABLE IF EXISTS `masterpack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `masterpack` (
  `mp_codi` int(11) NOT NULL AUTO_INCREMENT,
  `mp_nombre` varchar(200) NOT NULL DEFAULT '',
  `mp_estado` int(11) NOT NULL DEFAULT 1,
  `mp_abreviatura` varchar(45) DEFAULT NULL,
  `mp_usu_crea` varchar(45) DEFAULT NULL,
  `mp_usu_modifica` varchar(45) DEFAULT NULL,
  `mp_usu_activa` varchar(45) DEFAULT NULL,
  `mp_cantidad` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`mp_codi`),
  UNIQUE KEY `Index_mp_nombre` (`mp_nombre`),
  KEY `Index_mp_estado` (`mp_estado`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `masterpack`
--

LOCK TABLES `masterpack` WRITE;
/*!40000 ALTER TABLE `masterpack` DISABLE KEYS */;
INSERT INTO `masterpack` VALUES (1,'UNIDAD',1,'','etorres',NULL,NULL,1),(2,'MAYORISTA 100',1,'','etorres',NULL,NULL,100);
/*!40000 ALTER TABLE `masterpack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `medios_pago`
--

DROP TABLE IF EXISTS `medios_pago`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `medios_pago` (
  `medpag_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `medpag_nombre` varchar(45) NOT NULL DEFAULT '',
  `medpag_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `medpag_abreviatura` varchar(45) DEFAULT NULL,
  `medpag_usu_crea` varchar(45) DEFAULT NULL,
  `medpag_usu_modifica` varchar(45) DEFAULT NULL,
  `medpag_usu_activa` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`medpag_codi`),
  UNIQUE KEY `Index_medpag_nombre` (`medpag_nombre`),
  KEY `Index_medpag_estado` (`medpag_estado`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `medios_pago`
--

LOCK TABLES `medios_pago` WRITE;
/*!40000 ALTER TABLE `medios_pago` DISABLE KEYS */;
INSERT INTO `medios_pago` VALUES (1,'EFECTIVO',1,'','','',''),(2,'CHEQUE',1,'','','',''),(3,'TRANSFERENCIA ELECTRONICA',1,'','','',''),(4,'TARJETA DE CREDITO',1,'','','',''),(5,'CUENTA CORRIENTE',1,'','','',''),(6,'NOTA DE CREDITO',1,'N CREDITO','','','');
/*!40000 ALTER TABLE `medios_pago` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `motivos_traslado`
--

DROP TABLE IF EXISTS `motivos_traslado`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `motivos_traslado` (
  `mot_codi` int(11) NOT NULL AUTO_INCREMENT,
  `mot_nombre` varchar(145) NOT NULL DEFAULT '',
  `mot_estado` int(11) NOT NULL DEFAULT 1,
  `mot_abreviatura` varchar(45) DEFAULT NULL,
  `mot_usu_crea` varchar(45) DEFAULT NULL,
  `mot_usu_modifica` varchar(45) DEFAULT NULL,
  `mot_usu_activa` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`mot_codi`),
  UNIQUE KEY `Index_mot_nombre` (`mot_nombre`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `motivos_traslado`
--

LOCK TABLES `motivos_traslado` WRITE;
/*!40000 ALTER TABLE `motivos_traslado` DISABLE KEYS */;
INSERT INTO `motivos_traslado` VALUES (1,'VENTA',1,'','etorres',NULL,NULL),(2,'VENTA SUJETA A CONFIRMACION DEL COMPRADOR',1,'','etorres',NULL,NULL),(3,'COMPRA',1,'','etorres',NULL,NULL),(4,'CONSIGNACIÓN',1,'','etorres',NULL,NULL),(5,'DEVOLUCIÓN',1,'','etorres',NULL,NULL),(6,'TRASLADO ENTRE ESTABLECIMIENTOS DE LA MISMA EMPRESA',1,'','etorres','etorres',NULL),(7,'TRASLADO DE BIENES PARA TRANSFORMACIÓN',1,'','etorres',NULL,NULL),(8,'RECOJO DE BIENES TRANSFORMADOS',1,'','etorres',NULL,NULL),(9,'TRASLADO POR EMISOR ITINERANTE DE COMPROBANTE DE PAGO',1,'','etorres',NULL,NULL),(10,'TRASLADO ZONA PRIMARIA',1,'','etorres',NULL,NULL),(11,'IMPORTACIÓN',1,'','etorres',NULL,NULL),(12,'EXPORTACIÓN',1,'','etorres',NULL,NULL),(13,'OTROS',1,'','etorres',NULL,NULL),(14,'EXHIBICIÓN',1,NULL,'etorres',NULL,NULL),(15,'EXTRACCIÓN',1,NULL,'etorres',NULL,NULL),(16,'DEMOSTRACIÓN',1,NULL,'etorres',NULL,NULL),(17,'VENTA CON ENTREGA A TERCEROS',1,NULL,'etorres',NULL,NULL);
/*!40000 ALTER TABLE `motivos_traslado` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nota_credito`
--

DROP TABLE IF EXISTS `nota_credito`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nota_credito` (
  `notcre_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `notcre_numero` varchar(45) NOT NULL DEFAULT '',
  `notcre_txt_generado` int(10) unsigned NOT NULL DEFAULT 0,
  `notcre_codigohast` varchar(245) DEFAULT NULL,
  `notcre_timbrexml` int(10) unsigned NOT NULL DEFAULT 0,
  `notcre_firma` text NOT NULL,
  `notcre_timbreweb` int(10) unsigned NOT NULL DEFAULT 0,
  `ordped_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `notcre_fecha` date DEFAULT NULL,
  `notcre_serie` varchar(45) NOT NULL DEFAULT '',
  `notcre_fechahora` datetime DEFAULT NULL,
  `notcretip_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `notcre_detalle` text DEFAULT NULL,
  `notcre_descuento` float NOT NULL DEFAULT 0,
  `notcre_timbrerpta` int(10) unsigned NOT NULL DEFAULT 0,
  `notcre_detallerpta` text NOT NULL,
  `notcre_flg_ose` int(10) unsigned NOT NULL DEFAULT 0,
  `notcre_caj_numero` varchar(11) DEFAULT NULL,
  `notcre_usu_crea` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`notcre_codi`),
  UNIQUE KEY `Index_notcre_numero` (`notcre_numero`),
  KEY `Index_notcre_txt_generado` (`notcre_txt_generado`),
  KEY `Index_notcre_timbrexml` (`notcre_timbrexml`),
  KEY `Index_notcre_timbreweb` (`notcre_timbreweb`),
  KEY `Index_ordped_codi_fk` (`ordped_codi_fk`),
  KEY `Index_notcre_serie` (`notcre_serie`),
  KEY `Index_notcretip_codi_fk` (`notcretip_codi_fk`),
  KEY `Index_notcre_timbrerpta` (`notcre_timbrerpta`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nota_credito`
--

LOCK TABLES `nota_credito` WRITE;
/*!40000 ALTER TABLE `nota_credito` DISABLE KEYS */;
/*!40000 ALTER TABLE `nota_credito` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nota_credito_compra`
--

DROP TABLE IF EXISTS `nota_credito_compra`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nota_credito_compra` (
  `notcrecom_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `notcrecom_numero` varchar(45) NOT NULL DEFAULT '',
  `ordcom_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `notcrecom_fecha` date DEFAULT NULL,
  `notcrecom_serie` varchar(45) NOT NULL DEFAULT '',
  `notcrecom_fechahora` datetime DEFAULT NULL,
  `notcretip_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `notcrecom_detalle` text DEFAULT NULL,
  `notcrecom_descuento` float NOT NULL DEFAULT 0,
  `notcrecom_estado` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`notcrecom_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nota_credito_compra`
--

LOCK TABLES `nota_credito_compra` WRITE;
/*!40000 ALTER TABLE `nota_credito_compra` DISABLE KEYS */;
/*!40000 ALTER TABLE `nota_credito_compra` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nota_credito_tipo`
--

DROP TABLE IF EXISTS `nota_credito_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nota_credito_tipo` (
  `notcretip_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `notcretip_codigo` varchar(45) NOT NULL DEFAULT '',
  `notcretip_nombre` varchar(245) NOT NULL DEFAULT '',
  `notcretip_estado` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`notcretip_codi`),
  UNIQUE KEY `Index_notcretip_codigo` (`notcretip_codigo`),
  UNIQUE KEY `Index_notcretip_nombre` (`notcretip_nombre`),
  KEY `Index_notcretip_estado` (`notcretip_estado`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nota_credito_tipo`
--

LOCK TABLES `nota_credito_tipo` WRITE;
/*!40000 ALTER TABLE `nota_credito_tipo` DISABLE KEYS */;
INSERT INTO `nota_credito_tipo` VALUES (1,'01','ANULACIÓN DE OPERACIÓN',1),(2,'02','ANULACIÓN POR ERROR EN EL RUC',1),(3,'03','CORRECCIÓN POR ERROR EN LA DESCRIPCIÓN',1),(4,'04','DESCUENTO GLOBAL',0),(5,'05','DESCUENTO POR ITEM',1),(6,'06','DEVOLUCIÓN TOTAL',1),(7,'07','DEVOLUCIÓN POR ITEM',1),(8,'08','BONIFICACIÓN',0),(9,'09','DISMINUCIÓN EN EL VALOR',0),(10,'10','OTROS CONCEPTOS',0);
/*!40000 ALTER TABLE `nota_credito_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nota_debito`
--

DROP TABLE IF EXISTS `nota_debito`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nota_debito` (
  `notdeb_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `notdeb_numero` varchar(45) NOT NULL DEFAULT '',
  `notdeb_txt_generado` int(10) unsigned NOT NULL DEFAULT 0,
  `notdeb_codigohast` varchar(245) DEFAULT NULL,
  `notdeb_timbrexml` int(10) unsigned NOT NULL DEFAULT 0,
  `notdeb_firma` text DEFAULT NULL,
  `notdeb_timbreweb` int(10) unsigned NOT NULL DEFAULT 0,
  `ordped_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `notdeb_fecha` date DEFAULT NULL,
  `notdeb_serie` varchar(45) NOT NULL DEFAULT '',
  `notdeb_fechahora` datetime DEFAULT NULL,
  `notdebtip_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `notdeb_detalle` text DEFAULT NULL,
  `notdeb_descuento` float NOT NULL DEFAULT 0,
  `notdeb_timbrerpta` int(10) unsigned NOT NULL DEFAULT 0,
  `notdeb_detallerpta` text NOT NULL,
  `notdeb_flg_ose` int(10) unsigned NOT NULL DEFAULT 0,
  `notdeb_caj_numero` varchar(11) DEFAULT NULL,
  `notdeb_usu_crea` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`notdeb_codi`),
  UNIQUE KEY `Index_notdeb_numero` (`notdeb_numero`),
  KEY `Index_notdeb_txt_generado` (`notdeb_txt_generado`),
  KEY `Index_notdeb_timbrexml` (`notdeb_timbrexml`),
  KEY `Index_notdeb_timbreweb` (`notdeb_timbreweb`),
  KEY `Index_ordped_codi_fk` (`ordped_codi_fk`),
  KEY `Index_notdeb_serie` (`notdeb_serie`),
  KEY `Index_notdebtip_codi_fk` (`notdebtip_codi_fk`),
  KEY `Index_notdeb_timbrerpta` (`notdeb_timbrerpta`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nota_debito`
--

LOCK TABLES `nota_debito` WRITE;
/*!40000 ALTER TABLE `nota_debito` DISABLE KEYS */;
/*!40000 ALTER TABLE `nota_debito` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nota_debito_tipo`
--

DROP TABLE IF EXISTS `nota_debito_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nota_debito_tipo` (
  `notdebtip_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `notdebtip_codigo` varchar(45) NOT NULL DEFAULT '',
  `notdebtip_nombre` varchar(45) NOT NULL DEFAULT '',
  `notdebtip_estado` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`notdebtip_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nota_debito_tipo`
--

LOCK TABLES `nota_debito_tipo` WRITE;
/*!40000 ALTER TABLE `nota_debito_tipo` DISABLE KEYS */;
INSERT INTO `nota_debito_tipo` VALUES (1,'01','INTERESES POR MORA',1),(2,'02','AUMENTO EN EL VALOR',1),(3,'03','PENALIDADES',0);
/*!40000 ALTER TABLE `nota_debito_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `operacion_almacen`
--

DROP TABLE IF EXISTS `operacion_almacen`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operacion_almacen` (
  `opealm_codi` int(11) NOT NULL AUTO_INCREMENT,
  `opealm_fechahora` datetime DEFAULT NULL,
  `opealm_fecha` date DEFAULT NULL,
  `opetip_codi_fk` int(11) NOT NULL DEFAULT 0,
  `per_codi_fk` int(11) DEFAULT NULL,
  `doctip_codi_fk` int(11) DEFAULT NULL,
  `opealm_anotaciones` text DEFAULT NULL,
  `opealm_numero` varchar(45) DEFAULT NULL,
  `idtrans` varchar(45) DEFAULT NULL,
  `opealm_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `doc_numero` varchar(45) DEFAULT NULL,
  `opealm_usu_crea` varchar(45) DEFAULT NULL,
  `opealm_usu_modifica` varchar(45) DEFAULT NULL,
  `opealm_usu_activa` varchar(45) DEFAULT NULL,
  `ordpedcom_numero` varchar(45) DEFAULT NULL,
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `emp_codi_destino` int(11) NOT NULL DEFAULT 0,
  `opealm_codi_origen` int(11) NOT NULL DEFAULT 0,
  `opealm_fecha_documento` date DEFAULT NULL,
  `reqint_codi_fk` int(10) unsigned DEFAULT NULL,
  `opealm_documentado` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`opealm_codi`),
  UNIQUE KEY `Index_opealm_numero` (`opealm_numero`) USING BTREE,
  KEY `fk_operacion_almacen_operacion_tipo1_idx` (`opetip_codi_fk`),
  KEY `fk_operacion_almacen_personas1_idx` (`per_codi_fk`),
  KEY `fk_operacion_almacen_documento_tipo1_idx` (`doctip_codi_fk`),
  KEY `Index_idtrans` (`idtrans`),
  KEY `Index_opealm_estado` (`opealm_estado`),
  KEY `Index_doc_numero` (`doc_numero`),
  KEY `Index_ordpedcom_numero` (`ordpedcom_numero`),
  KEY `Index_emp_codi_fk` (`emp_codi_fk`),
  CONSTRAINT `fk_operacion_almacen_documento_tipo1` FOREIGN KEY (`doctip_codi_fk`) REFERENCES `documento_tipo` (`doctip_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_operacion_almacen_operacion_tipo1` FOREIGN KEY (`opetip_codi_fk`) REFERENCES `operacion_tipo` (`opetip_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_operacion_almacen_personas1` FOREIGN KEY (`per_codi_fk`) REFERENCES `personas` (`per_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `operacion_almacen`
--

LOCK TABLES `operacion_almacen` WRITE;
/*!40000 ALTER TABLE `operacion_almacen` DISABLE KEYS */;
/*!40000 ALTER TABLE `operacion_almacen` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `operacion_almacen_detalle`
--

DROP TABLE IF EXISTS `operacion_almacen_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operacion_almacen_detalle` (
  `opealmdet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `opealmdet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `opealmdet_cantidad` float DEFAULT NULL,
  `opealm_codi_fk` int(11) DEFAULT NULL,
  `idtrans` varchar(45) DEFAULT NULL,
  `opealmdet_cantidad_disponible` float NOT NULL DEFAULT 0,
  `mp_codi_fk_alm` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`opealmdet_codi`),
  KEY `fk_operacion_almacen_detalle_operacion_almacen1_idx` (`opealm_codi_fk`),
  KEY `fk_operacion_almacen_detalle_productos1_idx` (`prd_codi_fk`),
  KEY `Index_unimed_codi_fk` (`unimed_codi_fk`),
  KEY `Index_idtrans` (`idtrans`),
  CONSTRAINT `FK_operacion_almacen_detalle_unidad` FOREIGN KEY (`unimed_codi_fk`) REFERENCES `unidades_medida` (`unimed_codi`),
  CONSTRAINT `fk_operacion_almacen_detalle_operacion_almacen1` FOREIGN KEY (`opealm_codi_fk`) REFERENCES `operacion_almacen` (`opealm_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_operacion_almacen_detalle_productos1` FOREIGN KEY (`prd_codi_fk`) REFERENCES `productos` (`prd_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `operacion_almacen_detalle`
--

LOCK TABLES `operacion_almacen_detalle` WRITE;
/*!40000 ALTER TABLE `operacion_almacen_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `operacion_almacen_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `operacion_caja`
--

DROP TABLE IF EXISTS `operacion_caja`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operacion_caja` (
  `opecaj_codi` int(11) NOT NULL AUTO_INCREMENT,
  `opecaj_fechahora` datetime DEFAULT NULL,
  `opecaj_fecha` date DEFAULT NULL,
  `opecaj_numero` varchar(45) DEFAULT NULL,
  `per_codi_fk` int(11) DEFAULT NULL,
  `opecajtip_codi_fk` int(11) NOT NULL DEFAULT 0,
  `opecaj_estado` int(11) NOT NULL DEFAULT 1,
  `opecaj_anulado` int(11) NOT NULL DEFAULT 0,
  `opecaj_monto` float NOT NULL DEFAULT 0,
  `opecaj_anotaciones` text DEFAULT NULL,
  `opecaj_usu_crea` varchar(45) DEFAULT NULL,
  `opecaj_usu_modifica` varchar(45) DEFAULT NULL,
  `opecaj_usu_activa` varchar(45) DEFAULT NULL,
  `idtrans` varchar(45) DEFAULT NULL,
  `medpag_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `caj_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `pre_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `cc_codi_fk` int(10) unsigned DEFAULT NULL,
  `opecaj_tipo_de_nota` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`opecaj_codi`),
  UNIQUE KEY `Index_opecaj_numero` (`opecaj_numero`) USING BTREE,
  KEY `fk_operacion_caja_personas1_idx` (`per_codi_fk`),
  KEY `Index_opecajtip_codi_fk` (`opecajtip_codi_fk`),
  KEY `Index_opecaj_estado` (`opecaj_estado`),
  KEY `Index_opecaj_anulado` (`opecaj_anulado`),
  KEY `Index_medpag_codi_fk` (`medpag_codi_fk`),
  KEY `Index_idtrans` (`idtrans`),
  KEY `Index_emp_codi_fk` (`emp_codi_fk`),
  KEY `Index_caj_codi_fk` (`caj_codi_fk`),
  CONSTRAINT `FK_operacion_caja_caja` FOREIGN KEY (`caj_codi_fk`) REFERENCES `caja` (`caj_codi`),
  CONSTRAINT `FK_operacion_caja_caja_tipo` FOREIGN KEY (`opecajtip_codi_fk`) REFERENCES `operacion_caja_tipo` (`opecajtip_codi`),
  CONSTRAINT `FK_operacion_caja_medio_pago` FOREIGN KEY (`medpag_codi_fk`) REFERENCES `medios_pago` (`medpag_codi`),
  CONSTRAINT `fk_operacion_caja_personas1` FOREIGN KEY (`per_codi_fk`) REFERENCES `personas` (`per_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `operacion_caja`
--

LOCK TABLES `operacion_caja` WRITE;
/*!40000 ALTER TABLE `operacion_caja` DISABLE KEYS */;
/*!40000 ALTER TABLE `operacion_caja` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `operacion_caja_detalle`
--

DROP TABLE IF EXISTS `operacion_caja_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operacion_caja_detalle` (
  `opecajdet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `opecajdet_fechahora` datetime DEFAULT NULL,
  `opecajdet_fecha` date DEFAULT NULL,
  `opecaj_codi_fk` int(11) DEFAULT NULL,
  `opecajtip_codi_fk` int(11) NOT NULL,
  `opecajdet_monto` float DEFAULT NULL,
  `opecajdet_eliminado` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`opecajdet_codi`),
  KEY `fk_operacion_caja_detalle_operacion_caja1_idx` (`opecaj_codi_fk`),
  KEY `fk_operacion_caja_detalle_operacion_caja_tipo1_idx` (`opecajtip_codi_fk`),
  CONSTRAINT `fk_operacion_caja_detalle_operacion_caja1` FOREIGN KEY (`opecaj_codi_fk`) REFERENCES `operacion_caja` (`opecaj_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_operacion_caja_detalle_operacion_caja_tipo1` FOREIGN KEY (`opecajtip_codi_fk`) REFERENCES `operacion_caja_tipo` (`opecajtip_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `operacion_caja_detalle`
--

LOCK TABLES `operacion_caja_detalle` WRITE;
/*!40000 ALTER TABLE `operacion_caja_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `operacion_caja_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `operacion_caja_tipo`
--

DROP TABLE IF EXISTS `operacion_caja_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operacion_caja_tipo` (
  `opecajtip_codi` int(11) NOT NULL AUTO_INCREMENT,
  `opecajtip_nombre` varchar(145) NOT NULL DEFAULT '',
  `opecajtip_tipo` char(10) NOT NULL DEFAULT 'E',
  `opecajtip_estado` int(11) NOT NULL DEFAULT 1,
  `opecajtip_abreviatura` varchar(45) DEFAULT NULL,
  `opecajtip_usu_crea` varchar(45) DEFAULT NULL,
  `opecajtip_usu_modifica` varchar(45) DEFAULT NULL,
  `opecajtip_usu_activa` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`opecajtip_codi`),
  UNIQUE KEY `Index_opecajtip_nombre` (`opecajtip_nombre`),
  KEY `Index_opecajtip_tipo` (`opecajtip_tipo`),
  KEY `Index_opecajtip_estado` (`opecajtip_estado`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `operacion_caja_tipo`
--

LOCK TABLES `operacion_caja_tipo` WRITE;
/*!40000 ALTER TABLE `operacion_caja_tipo` DISABLE KEYS */;
INSERT INTO `operacion_caja_tipo` VALUES (1,'PAGO DE SALARIOS','SALIDA',1,NULL,NULL,NULL,NULL),(2,'PAGO A PROVEEDORES','SALIDA',1,NULL,NULL,NULL,NULL),(3,'COBRANZAS','INGRESO',1,NULL,NULL,NULL,NULL),(4,'PAGO DE SERVICIOS','SALIDA',1,NULL,NULL,NULL,NULL),(5,'PRESTAMO DE TERCEROS','INGRESO',1,'',NULL,NULL,NULL),(7,'PRESTAMO A TERCEROS','SALIDA',1,'',NULL,NULL,NULL),(8,'OTROS INGRESOS','INGRESO',1,'',NULL,NULL,NULL),(9,'OTRAS SALIDAS','SALIDA',1,'',NULL,NULL,NULL),(10,'PAGO DE BONIFICACIONES','SALIDA',1,'',NULL,NULL,NULL),(11,'COBRO DE ORDEN DE PEDIDO','INGRESO',1,'','etorres','etorres',NULL),(12,'PAGO DE ORDEN DE COMPRA','SALIDA',1,'','etorres',NULL,NULL),(13,'INGRESO POR APERTURA DE CAJA','INGRESO',1,'','etorres',NULL,NULL),(14,'SALIDA POR CIERRE DE CAJA','SALIDA',1,'','etorres2',NULL,NULL),(15,'SERVICIO DE TRANSPORTE ','SALIDA',1,'','ROSIMAR',NULL,NULL),(16,'DEPOSITO BANCARIO','SALIDA',1,'','LRIMARACHIN',NULL,NULL),(17,'PAGO DE DESESTIBA','SALIDA',1,'DESEST','ROSIMAR1',NULL,NULL),(18,'COBRO DE NOTA DE DEBITO','INGRESO',1,'','etorres',NULL,NULL),(19,'PAGO DE NOTA DE CREDITO','SALIDA',1,'','etorres',NULL,NULL);
/*!40000 ALTER TABLE `operacion_caja_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `operacion_tipo`
--

DROP TABLE IF EXISTS `operacion_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operacion_tipo` (
  `opetip_codi` int(11) NOT NULL AUTO_INCREMENT,
  `opetip_nombre` varchar(100) DEFAULT NULL,
  `opetip_estado` int(11) NOT NULL DEFAULT 1,
  `opetip_tipo` char(10) NOT NULL DEFAULT 'S',
  `opetip_abreviatura` varchar(45) DEFAULT NULL,
  `opetip_usu_crea` varchar(45) DEFAULT NULL,
  `opetip_usu_modifica` varchar(45) DEFAULT NULL,
  `opetip_usu_activa` varchar(45) DEFAULT NULL,
  `mot_codi_fk_equivalente` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`opetip_codi`),
  UNIQUE KEY `Index_opetip_nombre` (`opetip_nombre`),
  KEY `Index_opetip_estado` (`opetip_estado`),
  KEY `Index_opetip_tipo` (`opetip_tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `operacion_tipo`
--

LOCK TABLES `operacion_tipo` WRITE;
/*!40000 ALTER TABLE `operacion_tipo` DISABLE KEYS */;
INSERT INTO `operacion_tipo` VALUES (1,'COMPRA',1,'INGRESO','02',NULL,'LSANCHEZ',NULL,3),(2,'INGRESO POR TRASLADO',1,'INGRESO','11',NULL,'LSANCHEZ',NULL,6),(3,'SALIDA POR TRASLADO',1,'SALIDA','11',NULL,'LSANCHEZ','etorres',6),(4,'VENTA',1,'SALIDA','01',NULL,'LSANCHEZ',NULL,1),(5,'INGRESO POR DONACIÓN',1,'INGRESO','09',NULL,'LSANCHEZ',NULL,13),(6,'SALIDA POR DESCARTE',1,'SALIDA','12',NULL,'LSANCHEZ',NULL,13),(7,'SALIDA POR CONVERSIÓN DE UNIDADES',1,'SALIDA','01','etorres','LSANCHEZ',NULL,13),(8,'INGRESO POR CONVERSIÓN DE UNIDADES',1,'INGRESO','02','etorres','LSANCHEZ',NULL,13),(9,'INVENTARIO INICIAL',1,'INGRESO','16','ROSIMAR','LSANCHEZ',NULL,13),(10,'SALIDA POR TRASLADO ENTRE ALMACENES',1,'SALIDA','11','etorres','LSANCHEZ',NULL,6),(11,'INGRESO POR TRASLADO ENTRE ALMACENES',1,'INGRESO','21','etorres','LSANCHEZ',NULL,6),(12,'INGRESO POR NOTA DE CREDITO',1,'INGRESO','05','etorres','LSANCHEZ',NULL,0),(13,'SALIDA POR MARKETING',1,'SALIDA','10','LSANCHEZ','LSANCHEZ',NULL,0),(14,'SALIDA POR INVENTARIO INICIAL',1,'SALIDA','16','LSANCHEZ3','LSANCHEZ',NULL,0);
/*!40000 ALTER TABLE `operacion_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orden_compra`
--

DROP TABLE IF EXISTS `orden_compra`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orden_compra` (
  `ordcom_codi` int(11) NOT NULL AUTO_INCREMENT,
  `ordcom_fechahora` datetime DEFAULT NULL,
  `ordcom_fecha` date DEFAULT NULL,
  `ordcom_numero` varchar(45) DEFAULT NULL,
  `per_codi_fk` int(11) NOT NULL DEFAULT 0,
  `pagtip_codi_fk` int(11) DEFAULT NULL,
  `ordcom_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `idtrans` varchar(45) DEFAULT NULL,
  `ordcom_anotaciones` text DEFAULT NULL,
  `ordcom_usu_crea` varchar(45) DEFAULT NULL,
  `ordcom_usu_modifica` varchar(45) DEFAULT NULL,
  `ordcom_usu_activa` varchar(45) DEFAULT NULL,
  `docpag_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `ordcom_docpagnum` varchar(45) DEFAULT NULL,
  `ordcom_igv_porcentaje` float NOT NULL DEFAULT 18,
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `req_codi_fk` int(10) unsigned DEFAULT NULL,
  `ordcom_fecha_vence` date DEFAULT NULL,
  `ordcom_percepcion` float NOT NULL DEFAULT 0,
  `ordcom_tipo` int(10) unsigned NOT NULL DEFAULT 1,
  `ordcom_cc_codi_fk` int(10) unsigned DEFAULT NULL,
  `ordcom_isc` float NOT NULL DEFAULT 0,
  `ordcom_dolar` float NOT NULL DEFAULT 0,
  `ordcom_flete` float NOT NULL DEFAULT 0,
  PRIMARY KEY (`ordcom_codi`),
  UNIQUE KEY `Index_ordcom_numero` (`ordcom_numero`),
  KEY `fk_orden_pago_tipo1_idx` (`pagtip_codi_fk`),
  KEY `fk_orden_personas1_idx` (`per_codi_fk`),
  KEY `Index_ordcom_estado` (`ordcom_estado`),
  KEY `Index_idtrans` (`idtrans`),
  KEY `Index_docpag_codi_fk` (`docpag_codi_fk`),
  KEY `Index_ordcom_docpagnum` (`ordcom_docpagnum`),
  CONSTRAINT `FK_orden_compra_documento_pago` FOREIGN KEY (`docpag_codi_fk`) REFERENCES `documento_pago` (`docpag_codi`),
  CONSTRAINT `fk_orden_pago_tipo1` FOREIGN KEY (`pagtip_codi_fk`) REFERENCES `pago_tipo` (`pagtip_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_orden_personas1` FOREIGN KEY (`per_codi_fk`) REFERENCES `personas` (`per_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orden_compra`
--

LOCK TABLES `orden_compra` WRITE;
/*!40000 ALTER TABLE `orden_compra` DISABLE KEYS */;
/*!40000 ALTER TABLE `orden_compra` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orden_compra_almacen`
--

DROP TABLE IF EXISTS `orden_compra_almacen`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orden_compra_almacen` (
  `ordcomalm_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ordcom_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `opealm_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `ordcomalm_fechahora` datetime DEFAULT NULL,
  PRIMARY KEY (`ordcomalm_codi`),
  KEY `Index_ordcom_codi_fk` (`ordcom_codi_fk`),
  KEY `Index_opealm_codi_fk` (`opealm_codi_fk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orden_compra_almacen`
--

LOCK TABLES `orden_compra_almacen` WRITE;
/*!40000 ALTER TABLE `orden_compra_almacen` DISABLE KEYS */;
/*!40000 ALTER TABLE `orden_compra_almacen` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orden_compra_caja`
--

DROP TABLE IF EXISTS `orden_compra_caja`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orden_compra_caja` (
  `ordcomcaj_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ordcom_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `opecaj_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `ordcomcaj_fechahora` datetime DEFAULT NULL,
  PRIMARY KEY (`ordcomcaj_codi`),
  KEY `Index_opecaj_codi_fk` (`opecaj_codi_fk`),
  KEY `Index_ordcom_codi_fk` (`ordcom_codi_fk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orden_compra_caja`
--

LOCK TABLES `orden_compra_caja` WRITE;
/*!40000 ALTER TABLE `orden_compra_caja` DISABLE KEYS */;
/*!40000 ALTER TABLE `orden_compra_caja` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orden_compra_detalle`
--

DROP TABLE IF EXISTS `orden_compra_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orden_compra_detalle` (
  `ordcomdet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `ordcomdet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `ordcomdet_precio` float NOT NULL DEFAULT 0,
  `ordcomdet_cantidad` float NOT NULL DEFAULT 0,
  `ordcom_codi_fk` int(11) DEFAULT NULL,
  `idtrans` varchar(45) DEFAULT NULL,
  `ordcomdet_igv` float NOT NULL DEFAULT 0,
  `ordcomdet_isc` float NOT NULL DEFAULT 0,
  `ordcomdet_percepcion` float NOT NULL DEFAULT 0,
  `ordcomdet_igv_afectado` int(10) unsigned NOT NULL DEFAULT 0,
  `ordcomdet_isc_afectado` int(10) unsigned NOT NULL DEFAULT 0,
  `ordcomdet_cantidad_devolver` int(10) unsigned NOT NULL DEFAULT 0,
  `ordcomdet_cantidad_devolver_temporal` float NOT NULL DEFAULT 0,
  `ordcomdet_precio_descuento` float NOT NULL DEFAULT 0,
  `ordcomdet_precio_descuento_temporal` float NOT NULL DEFAULT 0,
  `ordcomdet_flete_unitario` float NOT NULL DEFAULT 0,
  PRIMARY KEY (`ordcomdet_codi`),
  KEY `fk_orden_compra_detalle_orden1_idx` (`ordcom_codi_fk`),
  KEY `Index_prd_codi_fk` (`prd_codi_fk`),
  KEY `Index_unimed_codi_fk` (`unimed_codi_fk`),
  KEY `Index_idtrans` (`idtrans`),
  CONSTRAINT `FK_orden_compra_detalle_productos` FOREIGN KEY (`prd_codi_fk`) REFERENCES `productos` (`prd_codi`),
  CONSTRAINT `FK_orden_compra_detalle_unidades` FOREIGN KEY (`unimed_codi_fk`) REFERENCES `unidades_medida` (`unimed_codi`),
  CONSTRAINT `fk_orden_compra_detalle_orden1` FOREIGN KEY (`ordcom_codi_fk`) REFERENCES `orden_compra` (`ordcom_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orden_compra_detalle`
--

LOCK TABLES `orden_compra_detalle` WRITE;
/*!40000 ALTER TABLE `orden_compra_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `orden_compra_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orden_pedido`
--

DROP TABLE IF EXISTS `orden_pedido`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orden_pedido` (
  `ordped_codi` int(11) NOT NULL AUTO_INCREMENT,
  `ordped_fechahora` datetime DEFAULT NULL,
  `ordped_fecha` date DEFAULT NULL,
  `ordped_numero` varchar(45) DEFAULT NULL,
  `per_codi_fk` int(11) NOT NULL DEFAULT 0,
  `doctip_codi_fk` int(11) NOT NULL,
  `pagtip_codi_fk` int(11) NOT NULL DEFAULT 0,
  `idtrans` varchar(45) DEFAULT NULL,
  `ordped_anotaciones` text DEFAULT NULL,
  `ordped_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `ordped_usu_crea` varchar(45) DEFAULT NULL,
  `ordped_usu_modifica` varchar(45) DEFAULT NULL,
  `ordped_usu_activa` varchar(45) DEFAULT NULL,
  `docpag_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `ordped_docpagnum` varchar(45) DEFAULT NULL,
  `cot_codi_fk` int(10) unsigned DEFAULT NULL,
  `ordped_igv_porcentaje` float NOT NULL DEFAULT 18,
  `ordped_fecha_documento` date DEFAULT NULL,
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `ordped_dias_credito` int(10) unsigned NOT NULL DEFAULT 0,
  `ordped_dias_credito_ampliacion` int(10) unsigned NOT NULL DEFAULT 0,
  `ordped_txt_generado` int(10) unsigned NOT NULL DEFAULT 0,
  `codigohast` varchar(245) NOT NULL DEFAULT '',
  `timbrexml` int(10) unsigned NOT NULL DEFAULT 0,
  `firma` text DEFAULT NULL,
  `timbreweb` int(10) unsigned NOT NULL DEFAULT 0,
  `ordped_facturacion_electronica` int(10) unsigned NOT NULL DEFAULT 0,
  `ordped_observacion` text DEFAULT NULL,
  `medpag_codi_fk` int(11) DEFAULT NULL,
  `timbrerpta` int(10) unsigned NOT NULL DEFAULT 0,
  `detallerpta` text NOT NULL,
  `flg_ose` int(10) unsigned NOT NULL DEFAULT 0,
  `ordped_caj_numero` varchar(11) DEFAULT NULL,
  `ordped_efectivo` float NOT NULL DEFAULT 0,
  `ordped_cambio` float NOT NULL DEFAULT 0,
  PRIMARY KEY (`ordped_codi`),
  KEY `fk_orden_pedido_documento_tipo1_idx` (`doctip_codi_fk`),
  KEY `fk_orden_pedido_pago_tipo1_idx` (`pagtip_codi_fk`),
  KEY `fk_orden_pedido_personas1_idx` (`per_codi_fk`),
  KEY `Index_idtrans` (`idtrans`),
  KEY `Index_ordped_estado` (`ordped_estado`),
  KEY `Index_docpag_codi_fk` (`docpag_codi_fk`),
  KEY `Index_emp_codi_fk` (`emp_codi_fk`),
  KEY `Index_ordped_docpagnum` (`ordped_docpagnum`),
  KEY `Index_cot_codi_fk` (`cot_codi_fk`),
  KEY `Index_ordped_txt_generado` (`ordped_txt_generado`),
  KEY `Index_timbrexml` (`timbrexml`),
  KEY `Index_timbrerpta` (`timbrerpta`),
  KEY `Index_ordped_numero` (`ordped_numero`) USING BTREE,
  CONSTRAINT `FK_orden_pedido_empresas` FOREIGN KEY (`emp_codi_fk`) REFERENCES `empresas` (`emp_codi`),
  CONSTRAINT `fk_orden_pedido_documento_tipo1` FOREIGN KEY (`doctip_codi_fk`) REFERENCES `documento_tipo` (`doctip_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_orden_pedido_pago_tipo1` FOREIGN KEY (`pagtip_codi_fk`) REFERENCES `pago_tipo` (`pagtip_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_orden_pedido_personas1` FOREIGN KEY (`per_codi_fk`) REFERENCES `personas` (`per_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orden_pedido`
--

LOCK TABLES `orden_pedido` WRITE;
/*!40000 ALTER TABLE `orden_pedido` DISABLE KEYS */;
/*!40000 ALTER TABLE `orden_pedido` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orden_pedido_almacen`
--

DROP TABLE IF EXISTS `orden_pedido_almacen`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orden_pedido_almacen` (
  `ordpedalm_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ordped_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `opealm_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `ordpedalm_fechahora` datetime DEFAULT NULL,
  PRIMARY KEY (`ordpedalm_codi`),
  KEY `Index_ordped_codi_fk` (`ordped_codi_fk`),
  KEY `Index_opealm_codi_fk` (`opealm_codi_fk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orden_pedido_almacen`
--

LOCK TABLES `orden_pedido_almacen` WRITE;
/*!40000 ALTER TABLE `orden_pedido_almacen` DISABLE KEYS */;
/*!40000 ALTER TABLE `orden_pedido_almacen` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orden_pedido_caja`
--

DROP TABLE IF EXISTS `orden_pedido_caja`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orden_pedido_caja` (
  `ordpedcaj_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ordped_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `opecaj_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `ordpedcaj_fechahora` datetime DEFAULT NULL,
  PRIMARY KEY (`ordpedcaj_codi`),
  KEY `Index_opecaj_codi_fk` (`opecaj_codi_fk`),
  KEY `Index_ordped_codi_fk` (`ordped_codi_fk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orden_pedido_caja`
--

LOCK TABLES `orden_pedido_caja` WRITE;
/*!40000 ALTER TABLE `orden_pedido_caja` DISABLE KEYS */;
/*!40000 ALTER TABLE `orden_pedido_caja` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orden_pedido_detalle`
--

DROP TABLE IF EXISTS `orden_pedido_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orden_pedido_detalle` (
  `ordpeddet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `ordpeddet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `ordpeddet_precio` float NOT NULL DEFAULT 0,
  `ordpeddet_cantidad` float NOT NULL DEFAULT 0,
  `ordped_codi_fk` int(11) NOT NULL DEFAULT 0,
  `idtrans` varchar(45) DEFAULT NULL,
  `ordpeddet_observaciones` text DEFAULT NULL,
  `idtrans_nuevo` varchar(45) DEFAULT NULL,
  `ordpeddet_precio_catalogo` float NOT NULL DEFAULT 0,
  `ordpeddet_icbper_monto_unitario` float NOT NULL DEFAULT 0,
  `ordpeddet_cantidad_devolver` float NOT NULL DEFAULT 0,
  `ordpeddet_cantidad_devolver_temporal` float NOT NULL DEFAULT 0,
  `ordpeddet_igv_afectado` int(10) unsigned NOT NULL DEFAULT 0,
  `ordpeddet_precio_descuento` float NOT NULL DEFAULT 0,
  `ordpeddet_precio_descuento_temporal` float NOT NULL DEFAULT 0,
  `ordpeddet_precio_aumento` float NOT NULL DEFAULT 0,
  `ordpeddet_precio_aumento_temporal` float NOT NULL DEFAULT 0,
  `ordpeddet_detraccion_afectado` int(10) unsigned NOT NULL DEFAULT 0,
  `ordpeddet_detraccion_porcentaje` float NOT NULL DEFAULT 0,
  PRIMARY KEY (`ordpeddet_codi`),
  KEY `fk_orden_pedido_detalle_orden_pedido1_idx` (`ordped_codi_fk`),
  CONSTRAINT `fk_orden_pedido_detalle_orden_pedido1` FOREIGN KEY (`ordped_codi_fk`) REFERENCES `orden_pedido` (`ordped_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orden_pedido_detalle`
--

LOCK TABLES `orden_pedido_detalle` WRITE;
/*!40000 ALTER TABLE `orden_pedido_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `orden_pedido_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pago_tipo`
--

DROP TABLE IF EXISTS `pago_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pago_tipo` (
  `pagtip_codi` int(11) NOT NULL AUTO_INCREMENT,
  `pagtip_nombre` varchar(145) DEFAULT NULL,
  `pagtip_estado` int(11) DEFAULT NULL,
  `pagtip_caja_automatica` int(10) unsigned NOT NULL DEFAULT 0,
  `pagtip_almacen_automatico` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`pagtip_codi`),
  UNIQUE KEY `Index_pagtip_nombre` (`pagtip_nombre`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pago_tipo`
--

LOCK TABLES `pago_tipo` WRITE;
/*!40000 ALTER TABLE `pago_tipo` DISABLE KEYS */;
INSERT INTO `pago_tipo` VALUES (1,'CONTADO',1,1,1),(2,'CREDITO',1,0,1),(3,'CONTRA ENTREGA',1,0,0),(4,'PAGO ADELANTADO',1,1,0),(5,'PAGO CON CANJE',1,0,1);
/*!40000 ALTER TABLE `pago_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personas`
--

DROP TABLE IF EXISTS `personas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `personas` (
  `per_codi` int(11) NOT NULL AUTO_INCREMENT,
  `per_nombre_comercial` varchar(200) DEFAULT NULL,
  `per_razon_social` varchar(200) DEFAULT NULL,
  `per_ruc` varchar(15) DEFAULT NULL,
  `per_nombre` varchar(200) DEFAULT NULL,
  `per_apellido` varchar(200) DEFAULT NULL,
  `per_email` varchar(50) DEFAULT NULL,
  `per_credito` int(11) NOT NULL DEFAULT 0,
  `pertip_codi_fk` int(11) DEFAULT NULL,
  `per_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `per_telefono1` varchar(100) DEFAULT NULL,
  `per_telefono2` varchar(100) DEFAULT NULL,
  `per_direccion1` text DEFAULT NULL,
  `per_direccion2` text DEFAULT NULL,
  `percar_codi_fk` int(10) unsigned DEFAULT NULL,
  `per_usu_crea` varchar(45) DEFAULT NULL,
  `per_usu_modifica` varchar(45) DEFAULT NULL,
  `per_usu_activa` varchar(45) DEFAULT NULL,
  `per_idtrans` varchar(45) DEFAULT NULL,
  `per_importe_credito` float NOT NULL DEFAULT 0,
  `per_importe_sobregiro` float NOT NULL DEFAULT 0,
  `per_codigo` varchar(8) NOT NULL DEFAULT '0',
  `per_ruc_dni_tipo` int(10) unsigned NOT NULL DEFAULT 0,
  `per_clave` varchar(45) DEFAULT NULL,
  `prctip_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`per_codi`),
  UNIQUE KEY `Index_per_codigo` (`per_codigo`) USING BTREE,
  KEY `fk_personas_personas_tipo1_idx` (`pertip_codi_fk`),
  KEY `Index_per_nombre_comercial` (`per_nombre_comercial`),
  KEY `Index_per_razon_social` (`per_razon_social`),
  KEY `Index_per_ruc` (`per_ruc`),
  KEY `Index_per_nombre` (`per_nombre`),
  KEY `Index_per_apellido` (`per_apellido`),
  KEY `Index_per_credito` (`per_credito`),
  KEY `Index_per_ruc_dni_tipo` (`per_ruc_dni_tipo`),
  KEY `Index_per_idtrans` (`per_idtrans`),
  CONSTRAINT `fk_personas_personas_tipo1` FOREIGN KEY (`pertip_codi_fk`) REFERENCES `personas_tipo` (`pertip_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personas`
--

LOCK TABLES `personas` WRITE;
/*!40000 ALTER TABLE `personas` DISABLE KEYS */;
INSERT INTO `personas` VALUES (1,'PUBLICO','PUBLICO','00000001','','','',0,2,1,'','','','',NULL,'','',NULL,'14721535769777905102',0,0,'00000001',1,NULL,0),(14,'EDUARDO TORRES','','10167545985','EDUARDO ALFONSO','TORRES LUNA','edtledu@gmail.com',0,1,1,'954618004','','Ca.Las hiedras #355 - Chiclayo  ','',15,NULL,'',NULL,NULL,0,0,'00000014',0,NULL,0),(15,'ALEX CAMPOS QUISPE','','71566401','ALEX','CAMPOS QUISPE','',0,1,1,'','','','',14,'etorres',NULL,NULL,NULL,0,0,'00000015',1,NULL,0);
/*!40000 ALTER TABLE `personas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personas_cargo`
--

DROP TABLE IF EXISTS `personas_cargo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `personas_cargo` (
  `percar_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `percar_nombre` varchar(145) NOT NULL DEFAULT '',
  `percar_estado` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`percar_codi`),
  UNIQUE KEY `Index_percar_nombre` (`percar_nombre`),
  KEY `Index_percar_estado` (`percar_estado`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personas_cargo`
--

LOCK TABLES `personas_cargo` WRITE;
/*!40000 ALTER TABLE `personas_cargo` DISABLE KEYS */;
INSERT INTO `personas_cargo` VALUES (1,'GERENTE GENERAL',1),(2,'VENDEDOR',1),(3,'JEFE DE ALMACEN',1),(4,'SECRETARIA',1),(5,'REPARTIDOR',1),(6,'CAJERO',1),(7,'JEFE DE COBRANZAS',1),(8,'JEFE DE VENTAS',1),(9,'COBRADOR',1),(10,'OBRERO',1),(11,'AYUDANTE',1),(12,'PRACTICANTE',1),(13,'DIGITADOR',1),(14,'OTRO',1),(15,'STAFF',1),(16,'PERSONAL ADMINISTRATIVO',1),(17,'TRANSPORTISTA',1),(18,'CONTADOR',1),(19,'ADMINISTRADOR',1),(20,'SUPERVISOR',1);
/*!40000 ALTER TABLE `personas_cargo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personas_tipo`
--

DROP TABLE IF EXISTS `personas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `personas_tipo` (
  `pertip_codi` int(11) NOT NULL AUTO_INCREMENT,
  `pertip_nombre` varchar(80) NOT NULL DEFAULT '',
  `pertip_estado` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`pertip_codi`),
  UNIQUE KEY `Index_pertip_nombre` (`pertip_nombre`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personas_tipo`
--

LOCK TABLES `personas_tipo` WRITE;
/*!40000 ALTER TABLE `personas_tipo` DISABLE KEYS */;
INSERT INTO `personas_tipo` VALUES (1,'EMPLEADO',1),(2,'CLIENTE',1),(3,'PROVEEDOR',1);
/*!40000 ALTER TABLE `personas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `precios`
--

DROP TABLE IF EXISTS `precios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `precios` (
  `prc_codi` int(11) NOT NULL AUTO_INCREMENT,
  `prc_precio` float NOT NULL DEFAULT 0,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `prd_codi_fk` int(11) NOT NULL DEFAULT 0,
  `prctip_codi_fk` int(11) DEFAULT NULL,
  `prc_estado` int(10) unsigned NOT NULL DEFAULT 0,
  `prc_defecto` int(10) unsigned NOT NULL DEFAULT 0,
  `prc_usu_crea` varchar(45) DEFAULT NULL,
  `prc_usu_modifica` varchar(45) DEFAULT NULL,
  `prc_usu_activa` varchar(45) DEFAULT NULL,
  `prc_costo` float NOT NULL DEFAULT 0,
  `prc_equivalente` int(10) unsigned NOT NULL DEFAULT 1,
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`prc_codi`),
  KEY `fk_precios_productos1_idx` (`prd_codi_fk`),
  KEY `fk_precios_unidades_medida1_idx` (`unimed_codi_fk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `precios`
--

LOCK TABLES `precios` WRITE;
/*!40000 ALTER TABLE `precios` DISABLE KEYS */;
/*!40000 ALTER TABLE `precios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `precios_tipo`
--

DROP TABLE IF EXISTS `precios_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `precios_tipo` (
  `prctip_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `prctip_nombre` varchar(100) NOT NULL DEFAULT '',
  `prctip_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `prctip_abreviatura` varchar(45) DEFAULT NULL,
  `prctip_usu_crea` varchar(45) DEFAULT NULL,
  `prctip_usu_modifica` varchar(45) DEFAULT NULL,
  `prctip_usu_activa` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`prctip_codi`),
  UNIQUE KEY `Index_prctip_nombre` (`prctip_nombre`),
  KEY `Index_prctip_estado` (`prctip_estado`),
  KEY `Index_prctip_abreviatura` (`prctip_abreviatura`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `precios_tipo`
--

LOCK TABLES `precios_tipo` WRITE;
/*!40000 ALTER TABLE `precios_tipo` DISABLE KEYS */;
INSERT INTO `precios_tipo` VALUES (1,'MAYORISTA',0,NULL,NULL,NULL,''),(2,'MINORISTA',1,NULL,NULL,NULL,NULL),(3,'MERCADO',0,'',NULL,'etorres2',''),(4,'OFERTA',0,'OFER',NULL,NULL,''),(5,'FERRETERIA',1,'FERR','LSANCHEZ',NULL,NULL),(6,'BONIFICACION',1,'BON','LSANCHEZ',NULL,NULL);
/*!40000 ALTER TABLE `precios_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `presentacion`
--

DROP TABLE IF EXISTS `presentacion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `presentacion` (
  `prs_codi` int(11) NOT NULL AUTO_INCREMENT,
  `prs_nombre` varchar(200) NOT NULL DEFAULT '',
  `prs_estado` int(11) NOT NULL DEFAULT 1,
  `prs_abreviatura` varchar(45) DEFAULT NULL,
  `prs_usu_crea` varchar(45) DEFAULT NULL,
  `prs_usu_modifica` varchar(45) DEFAULT NULL,
  `prs_usu_activa` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`prs_codi`),
  UNIQUE KEY `Index_prs_nombre` (`prs_nombre`),
  KEY `Index_prs_estado` (`prs_estado`)
) ENGINE=InnoDB AUTO_INCREMENT=109 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `presentacion`
--

LOCK TABLES `presentacion` WRITE;
/*!40000 ALTER TABLE `presentacion` DISABLE KEYS */;
INSERT INTO `presentacion` VALUES (1,'BOTELLA 1LT',1,'BT.1LT','','',''),(2,'BOLSA 45Kg.',1,'','','',''),(3,'LATA 500ml.',1,'','','',''),(4,'BOTELLA 500ml.',1,'','','',''),(5,'BOLSA 100 unid.',1,'','','',''),(7,'BOLSA 25Kg.',1,'','','',''),(8,'TARRO',1,'','','',''),(9,'BLOQUE',1,'','','',''),(10,'BOLSA 42.5Kg.',1,'BLS 42.5Kg.','','',''),(11,'BOLSA 10Kg.',1,'BLS 10Kg.','','',''),(12,'BOLSA 15Kg.',1,'BLS 15Kg.','','',''),(13,'CAJA 30Kg.',1,'CAJA 30Kg.','','',''),(16,'ROLLO',1,'ROLLO','','',''),(17,'-',1,'-','','',''),(18,'CAJA 25Kg.',1,'CAJ. 25Kg.','','',''),(19,'VUELTA',1,'VUELTA','','',''),(20,'BOLSA 20Kg.',1,'BOLS 20Kg.','','',''),(21,'TONELADA',1,'TN','','',''),(22,'HOJA',1,'HOJA','','',''),(23,'MILLAR',1,'MILL','','',''),(24,'UNIDAD',1,'UND','','',''),(25,'ATADO 25 UND',1,'AT25','','',''),(26,'ATADO 10 UND',1,'AT10','','',''),(27,'ATADO 50 UND',1,'AT50','','',''),(28,'BOLSA 1Kg.',1,'BLS 1Kg.','','',''),(29,'PAQUETE 36 UND',1,'PAQ36','','',''),(30,'PAQUETE 64 UND',1,'PAQ64','','',''),(31,'PAQUETE 56 UND',1,'PAQ56','','',''),(32,'PAQUETE 88 UND',1,'PAQ88','','',''),(33,'ROLLO DE 10 MT',1,'ROLL 10 MT','','',''),(34,'ROLLO DE 30 MT',1,'ROLL 30MT','','',''),(35,'ROLLO 100 MT',1,'ROLL 100MT','','',''),(36,'CAJA 12 UND',1,'CAJ12','','',''),(37,'CAJA 100 UND',1,'CAJ100','','',''),(38,'METRO CUBICO',1,'M3','','',''),(39,'GALON 4LT',1,'GL 4LT','','',''),(40,'ENPAQUE 8 UND',1,'ENP 8UND','','',''),(41,'--',1,'-','','',''),(42,'CAJA 6 UND',1,'CAJ 6 UND','','',''),(43,'ENPAQUE 6 UND',1,'ENP 6UND','','',''),(44,'CAJA 10 UND',1,'CAJ 10UND','','',''),(45,'ROLLO 20MT',1,'ROLL 20MT','','',''),(46,'ROLLO 50 MT',1,'ROLL 50MT','','',''),(47,'BOLSA 3.80 KG',1,'','','',''),(48,'CAJA 3UND',1,'CAJ 3','','',''),(49,'CAJA DE 2UND',1,'CAJ 2','','',''),(50,'ROLLO 200 MT',1,'ROLLX200MT','','',''),(51,'CAJA 25 UND',1,'CJA 25UND','','',''),(52,'CAJA 50 UND',1,'CJA 50 UND','','',''),(53,'ROLLO 25 MT',1,'ROLL 25MT','','',''),(54,'CAJA DE 36 UND',1,'36 UND','','',''),(55,'CAJA DE 72 UND',1,'72 UND','','',''),(56,'CAJA DE 4 UND',1,'4 UND','','',''),(57,'CAJA 02 UND',1,'CAJ02','','',''),(58,'GALON 1LT',1,'GAL1','','',''),(59,'BOLSA 5KG',1,'BLS 5KG','','',''),(60,'GALON 3LT',1,'GL 3LT','','',''),(61,'METRO CUADRADO',1,'M2','','',''),(62,'CAJA 20 UND',1,'CAJA20','','',''),(63,'CAJA 05 UND',1,'CAJA05','','',''),(64,'SIKA 3 --',1,'SIKA3','','',''),(65,'SIKA 3',1,'SIKA3','','',''),(66,'SIKA 3 -',1,'SIKA3','','',''),(67,'BALDE 20L',1,'BALDE','','',''),(68,'BALDE 4L',1,'BAL4L','','',''),(69,'BOLSA 4KG',1,'BLS 4KG','','',''),(70,'ROLLO 5KG',1,'R5KG','','',''),(71,'ROLLO 10KG',1,'R10KG','','',''),(72,'ROLLO 20KG',1,'R20KG','','',''),(73,'CONO',1,'CONO','','',''),(74,'MADEJA',1,'MADEJA','','',''),(75,'CAJA 400 UND',1,'CAJA 400','','',''),(76,'BOLSA 500 UND',1,'BLS500','','',''),(77,'CAJA 1000 UND',1,'','','',''),(78,'CILINDRO 200 LT',1,'','','',''),(79,'BOTELLA 1/4 LT',1,'BOT','','',''),(80,'BALDE 4KG',1,'','','',''),(81,'BOLSA 25 unidades',1,'BOL25','','',''),(82,'BOLSA 50 unid.',1,'','','',''),(83,'BOLSA 30 unid.',1,'','','',''),(84,'BOLSA 20 unid.',1,'','','',''),(85,'BOLSA 10 unid.',1,'','','',''),(86,'CAJA 30 unida.',1,'','','',''),(87,'CAJA 18 unid',1,'','','',''),(88,'BOLSA 40 unid',1,'','','',''),(89,'BOLSA 24 UNID',1,'','','',''),(90,'BOLSA 12 UNID',1,'','','',''),(91,'ROLLO 1KG',1,'','','',''),(92,'CAJA 45 UNID',1,'','','',''),(93,'CAJA 80 UNID',1,'','','',''),(94,'CAJA 180 UNID',1,'','','',''),(95,'CAJA 60 UNID',1,'','','',''),(96,'CAJA 20 UNI',1,'','','',''),(97,'ROLLO DE 16.4 MT',1,'','','',''),(98,'ROLLO 30KG',1,'','','',''),(99,'SACO DE 50KG',1,'SACO 50KG','','',''),(100,'ROLLO X METRO',1,'METRO','','',''),(101,'ROLLO X KILO',1,'KILO','','',''),(102,'PAQUETE 50 UND',1,'','','',''),(103,'PAQUETE 38 UND',1,'','','',''),(104,'SACO X 200 UND',1,'','','',''),(105,'ROLLO 45.5 MT',1,'ROLL','','',''),(106,'BOLSA 30KG',1,'','','',''),(107,'METRO',1,'MT','','',''),(108,'BALDE 4GL',1,'BALDE','','','');
/*!40000 ALTER TABLE `presentacion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `presupuestos`
--

DROP TABLE IF EXISTS `presupuestos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `presupuestos` (
  `pre_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pre_fechahora` datetime DEFAULT NULL,
  `pre_fecha` date DEFAULT NULL,
  `pre_numero` varchar(45) DEFAULT NULL,
  `per_codi_fk` int(11) DEFAULT NULL,
  `opecajtip_codi_fk` int(11) NOT NULL DEFAULT 0,
  `pre_estado` int(11) NOT NULL DEFAULT 1,
  `pre_anulado` int(11) NOT NULL DEFAULT 0,
  `pre_monto` float NOT NULL DEFAULT 0,
  `pre_anotaciones` text DEFAULT NULL,
  `pre_usu_crea` varchar(45) DEFAULT NULL,
  `pre_usu_modifica` varchar(45) DEFAULT NULL,
  `pre_usu_activa` varchar(45) DEFAULT NULL,
  `idtrans` varchar(45) DEFAULT NULL,
  `medpag_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `caj_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`pre_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `presupuestos`
--

LOCK TABLES `presupuestos` WRITE;
/*!40000 ALTER TABLE `presupuestos` DISABLE KEYS */;
/*!40000 ALTER TABLE `presupuestos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `productos`
--

DROP TABLE IF EXISTS `productos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `productos` (
  `prd_codi` int(11) NOT NULL AUTO_INCREMENT,
  `prd_nombre` varchar(200) NOT NULL DEFAULT '',
  `prd_abreviatura` varchar(45) DEFAULT NULL,
  `mar_codi_fk` int(11) NOT NULL DEFAULT 0,
  `prs_codi_fk` int(11) NOT NULL,
  `prdfam_codi_fk` int(11) NOT NULL,
  `prd_estado` int(11) DEFAULT NULL,
  `prd_codigo` varchar(45) DEFAULT NULL,
  `prd_usu_crea` varchar(45) DEFAULT NULL,
  `prd_usu_modifica` varchar(45) DEFAULT NULL,
  `prd_usu_activa` varchar(45) DEFAULT NULL,
  `prd_preciocosto` float NOT NULL DEFAULT 0,
  `prd_unidad_minima` int(10) unsigned NOT NULL DEFAULT 0,
  `prd_stock_minimo` int(10) unsigned NOT NULL DEFAULT 0,
  `prd_peso` float NOT NULL DEFAULT 0,
  `id_fk` int(10) unsigned DEFAULT NULL,
  `prd_descripcion` text DEFAULT NULL,
  `prd_descuento_limite` float NOT NULL DEFAULT 0,
  `prd_catalogo_defecto` int(10) unsigned NOT NULL DEFAULT 0,
  `prd_id_trans` varchar(45) DEFAULT NULL,
  `mp_codi_fk` int(10) unsigned DEFAULT NULL,
  `prd_afecto_igv` int(10) unsigned NOT NULL DEFAULT 0,
  `prd_afecto_isc` int(10) unsigned NOT NULL DEFAULT 0,
  `prd_afecto_detraccion` int(10) unsigned NOT NULL DEFAULT 0,
  `prd_detraccion_porcentaje` float NOT NULL DEFAULT 0,
  PRIMARY KEY (`prd_codi`),
  UNIQUE KEY `Index_prd_nombre` (`prd_nombre`),
  KEY `fk_productos_presentacion_idx` (`prs_codi_fk`),
  KEY `fk_productos_marcas1_idx` (`mar_codi_fk`),
  KEY `fk_productos_productos_familia1_idx` (`prdfam_codi_fk`),
  KEY `Index_prd_abreviatura` (`prd_abreviatura`),
  KEY `Index_prd_estado` (`prd_estado`),
  KEY `Index_prd_codigo` (`prd_codigo`),
  CONSTRAINT `fk_productos_marcas1` FOREIGN KEY (`mar_codi_fk`) REFERENCES `marcas` (`mar_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_productos_presentacion` FOREIGN KEY (`prs_codi_fk`) REFERENCES `presentacion` (`prs_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_productos_productos_familia1` FOREIGN KEY (`prdfam_codi_fk`) REFERENCES `productos_familia` (`prdfam_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=2402 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `productos`
--

LOCK TABLES `productos` WRITE;
/*!40000 ALTER TABLE `productos` DISABLE KEYS */;
INSERT INTO `productos` VALUES (3,'CEMENTO EXTRAFORTE TIPO ICO PACASMAYO','',2,10,1,1,'10003','','',NULL,0,8,1,42.5,NULL,'',0,0,NULL,1,0,0,0,0),(5,'ALAMBRE RECOCIDO N°16 PRODAC','',17,16,11,1,'10005','','','',0,3,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(9,'CEMENTO MS ANT. FORTIMAX PACASMAYO','',2,10,1,1,'10009','','','',0,8,1,42.5,NULL,'',0,0,NULL,1,0,0,0,0),(10,'CEMENTO MOCHICA TIPO GU PACASMAYO','',35,10,1,1,'10010','','',NULL,0,8,1,42.5,NULL,'',0,0,NULL,1,0,0,0,0),(11,'CEMENTO MOCHICA MS ANT PACASMAYO','',35,10,1,1,'10011','','','',0,8,1,42.5,NULL,'',0,0,NULL,1,0,0,0,0),(12,'YESO REFINADO CONSTR. 10Kg.','',22,11,2,1,'10012','','',NULL,0,8,1,10,NULL,NULL,0,0,NULL,1,0,0,0,0),(13,'YESO REFINADO CONSTR. 15Kg.','',22,12,2,1,'10013','','','',0,8,1,15,NULL,NULL,0,0,NULL,1,0,0,0,0),(14,'YESO REFINADO CONSTR. 20Kg.','',22,20,2,1,'10014','','',NULL,0,8,1,20,NULL,NULL,0,0,NULL,1,0,0,0,0),(15,'BARRA CONSTRUCCION 6MMX9MT SIDERPERU','',13,24,15,1,'10015','','','',0,5,1,1.94,NULL,'',0,0,NULL,1,0,0,0,0),(16,'BARRA CONSTRUCCION 8MMX9MT SIDERPERU','',13,24,15,1,'10016','','',NULL,0,5,1,3.47,NULL,'',0,0,NULL,1,0,0,0,0),(17,'BARRA CONSTRUCCION 3/8X9MT SIDERPERU','',13,24,15,1,'10017','','','',0,5,1,4.81,NULL,'',0,0,NULL,1,0,0,0,0),(18,'CEMENTO TIPO I PACASMAYO','',2,10,1,1,'10018','','',NULL,0,8,1,42.5,NULL,'',0,0,NULL,1,0,0,0,0),(19,'BARRA CONSTRUCCION 12MMX9MT SIDERPERU','',13,24,15,1,'10019','','',NULL,0,5,1,7.69,NULL,'',0,0,NULL,1,0,0,0,0),(21,'BARRA CONSTRUCCION 1/2X9MT SIDERPERU','',13,24,15,1,'10021','','',NULL,0,5,1,8.62,NULL,'',0,0,NULL,1,0,0,0,0),(22,'BARRA CONSTRUCCION 5/8X9MT SIDERPERU','',13,24,15,1,'10022','','',NULL,0,5,1,13.33,NULL,'',0,0,NULL,1,0,0,0,0),(23,'CALAMINA 0.14X3.60 ACEROS AREQUIPA','',1,22,319,1,'10023','','',NULL,0,5,1,3.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(24,'CALAMINA 0.22X1.80 SIDERPERU','',13,22,318,0,'10024','','','',0,5,1,3,NULL,NULL,0,0,NULL,1,0,0,0,0),(25,'CALAMINA 0.22X3.60 SIDERPERU','',13,22,318,0,'10025','','','',0,5,1,6,NULL,NULL,0,0,NULL,1,0,0,0,0),(26,'CALAMINA 0.25X1.80 SIDERPERU','',13,22,318,0,'10026','','','',0,5,1,3,NULL,NULL,0,0,NULL,1,0,0,0,0),(27,'CALAMINA 0.30X1.80 SIDERPERU','',13,22,318,0,'10027','','','',0,5,1,3.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(28,'CALAMINA 0.30X3.60 SIDERPERU','',13,22,318,0,'10028','','','',0,5,1,7,NULL,NULL,0,0,NULL,1,0,0,0,0),(29,'CALAMINA 0.14X1.80 ACEROS AREQUIPA','',1,22,319,1,'10029','','',NULL,0,5,1,1.72,NULL,NULL,0,0,NULL,1,0,0,0,0),(30,'CALAMINA 0.22X1.80 ACEROS AREQUIPA','',1,22,319,1,'10030','','','',0,5,1,2.75,NULL,NULL,0,0,NULL,1,0,0,0,0),(31,'CALAMINA 0.22X3.60 ACEROS AREQUIPA','',1,22,319,1,'10031','','','',0,5,1,5.5,NULL,'',0,0,NULL,1,0,0,0,0),(32,'CALAMINA 0.14X1.80 IMPORTADA','',36,22,4,1,'10032','','','',0,5,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(33,'CALAMINA 0.25 X 3.60 PRODAC','',17,22,350,0,'10033','','','',0,5,1,2.9,NULL,NULL,0,0,NULL,1,0,0,0,0),(39,'CLAVO C/C 1/2X19 PRODAC','',17,28,29,1,'10039','','',NULL,0,3,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(40,'CLAVO C/C 1X16 PRODAC','',17,13,29,1,'10040','','',NULL,0,3,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(41,'CLAVO C/C 1.1/2X15 PRODAC','',17,13,29,1,'10041','','',NULL,0,3,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(42,'CLAVO C/C 2X12 PRODAC','',17,13,29,1,'10042','','',NULL,0,3,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(43,'CLAVO C/C 2.1/2X10 PRODAC','',17,13,29,1,'10043','','',NULL,0,3,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(44,'CLAVO C/C 3X9 PRODAC','',17,13,29,1,'10044','','',NULL,0,3,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(45,'CLAVO C/C 4X7 PRODAC','',17,13,29,1,'10045','','',NULL,0,3,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(46,'CLAVO C/C 5X6 PRODAC','',17,13,29,1,'10046','','',NULL,0,3,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(47,'CLAVO C/C 6X4 PRODAC','',17,13,29,1,'10047','','',NULL,0,3,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(48,'CLAVO C/C 7X4 PRODAC','',17,13,29,1,'10048','','',NULL,0,3,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(49,'CLAVO CALAMINERO 2X9 PRODAC','',17,18,29,0,'10049','','','',0,3,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(50,'GRAPA 1X8 PRODAC','',17,13,248,1,'10050','','',NULL,0,3,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(51,'LADRILLO PANDERETA LARK','',15,23,314,1,'10051','','',NULL,0,5,1,1.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(52,'LADRILLO PANDERETA CERAM. LAMB','',16,23,314,1,'10052','','',NULL,0,5,1,1.7,NULL,NULL,0,0,NULL,1,0,0,0,0),(53,'LADRILLO PANDERETA CERAM. SOL DEL NORTE','',19,23,314,1,'10053','','',NULL,0,5,1,2,NULL,NULL,0,0,NULL,1,0,0,0,0),(54,'LADRILLO KING KONG STANDAR LARK','',15,23,313,1,'10054','','',NULL,0,5,1,2.8,NULL,'',0,0,NULL,1,0,0,0,0),(55,'LADRILLO KING KONG STANDAR CERAM. LAMB','',16,23,313,1,'10055','','',NULL,0,5,1,2.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(56,'LADRILLO KING KONG TIPO IV LARK','',15,23,313,1,'10056','','',NULL,0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(57,'LADRILLO KING KONG TIPO IV CERAM. LAMB','',16,23,313,1,'10057','','',NULL,0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(58,'LADRILLO PASTELERO LARK','',15,23,317,1,'10058','','',NULL,0,5,1,2.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(59,'LADRILLO PANDERETON LARK','',15,23,314,1,'10059','','',NULL,0,5,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(60,'LADRILLO TECHO 08X30X30 LARK','',15,23,8,1,'10060','','',NULL,0,5,1,4.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(61,'LADRILLO TECHO 12X30X30 LARK','',15,23,8,1,'10061','','',NULL,0,5,1,6.5,NULL,'',0,0,NULL,1,0,0,0,0),(62,'LADRILLO TECHO 15X30X30 LARK','',15,23,8,1,'10062','','',NULL,0,5,1,7.8,NULL,'',0,0,NULL,1,0,0,0,0),(63,'LADRILLO TECHO 20X30X30 LARK','',15,23,8,1,'10063','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(64,'BARRA CONSTRUCCION 3/4X9MT SIDERPERU','',13,24,15,1,'10064','','',NULL,0,5,1,19.61,NULL,'',0,0,NULL,1,0,0,0,0),(65,'BARRA CONSTRUCCION 1X9MT SIDERPERU','',13,24,15,1,'10065','','',NULL,0,5,1,34.48,NULL,'',0,0,NULL,1,0,0,0,0),(66,'TUBO PVC AG C10 SP 1/2X5MT PLASTICA','',48,24,81,1,'10066','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(67,'TUBO PVC AG C10 SP 3/4X5MT PLASTICA','',48,25,81,1,'10067','','',NULL,0,5,1,0.53,NULL,'',0,0,NULL,1,0,0,0,0),(68,'TUBO PVC AG C10 SP 1X5MT PLASTICA','',48,25,81,1,'10068','','',NULL,0,5,1,1.5,NULL,'',0,0,NULL,1,0,0,0,0),(69,'TUBO PVC AG C10 SP 1.1/2X5MT PLASTICA','',48,26,81,1,'10069','','',NULL,0,5,1,2.4,NULL,'',0,0,NULL,1,0,0,0,0),(70,'TUBO PVC AG C10 SP 2X5MT PLASTICA','',48,26,81,1,'10070','','',NULL,0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(71,'TUBO PVC AG C10 SP 2.1/2X5MT PLASTICA','',48,26,81,1,'10071','','',NULL,0,5,1,6,NULL,NULL,0,0,NULL,1,0,0,0,0),(72,'TUBO PVC AG C10 SP 3X5MT PLASTICA','',48,26,81,1,'10072','','',NULL,0,5,1,8,NULL,NULL,0,0,NULL,1,0,0,0,0),(73,'TUBO PVC SAL 2X3MT PLASTICA','',48,26,79,1,'10073','','',NULL,0,5,1,1.05,NULL,'',0,0,NULL,1,0,0,0,0),(74,'TUBO PVC SAL 4X3MT PLASTICA','',48,26,79,1,'10074','','',NULL,0,5,1,0.75,NULL,'',0,0,NULL,1,0,0,0,0),(75,'TUBO PVC ISO ALCA C-4/S-25 160MM UFX6MT PLASTICA','',48,24,92,1,'10075','','',NULL,0,5,1,14.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(76,'TUBO PVC ISO ALCA C-4/S-25 200MM UFX6MT PLASTICA','',48,24,92,1,'10076','','',NULL,0,5,1,22,NULL,NULL,0,0,NULL,1,0,0,0,0),(77,'TUBO PVC SAL 3X3MT PLASTICA','',48,26,79,1,'10077','','',NULL,0,5,1,1.55,NULL,'',0,0,NULL,1,0,0,0,0),(78,'OCRE EXTRAFUERTE T/130 ROJO BAYER','',49,28,56,1,'10078','','',NULL,0,5,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(79,'OCRE T/130 ROJO BAYER ECONOMICO','',49,28,56,1,'10079','','',NULL,0,5,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(80,'CURVA PVC SEL 3/4 PLASTICA','',48,24,17,1,'10080','','',NULL,0,5,1,0.01,NULL,'',0,0,NULL,1,0,0,0,0),(81,'CAÑO JARDINERO PVC 1/2 LIV. NARANJA PCP','',40,89,24,1,'10081','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(82,'CURVA PVC SEL 5/8 PLASTICA','',48,24,17,1,'10082','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(83,'LLANTA SOLIDA 4.00-8 NEGRO','',36,24,12,1,'10083','','',NULL,0,5,1,2.9,NULL,NULL,0,0,NULL,1,0,0,0,0),(85,'LLANTA TRACTOR 4.00-8 VOLCAN','',27,24,12,1,'10085','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(86,'LLANTA NEUMATICA 4.00-8 VOLCAN','',27,24,12,1,'10086','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(87,'ARO C/RODAJE ROJO EJE 15 MM','',36,24,12,1,'10087','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(88,'LLANTA TRACTOR 3.50-8 VOLCAN','',27,24,12,1,'10088','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(89,'CODO PVC AG SP 1/2X90° PLASTICA','',48,82,86,1,'10089','','',NULL,0,5,1,0.02,NULL,NULL,0,0,NULL,1,0,0,0,0),(90,'CODO PVC AG SP 1/2X45° PLASTICA','',48,82,86,1,'10090','','',NULL,0,5,1,0.01,NULL,'',0,0,NULL,1,0,0,0,0),(92,'CODO PVC AG SP 3/4X90° PLASTICA','',48,82,86,1,'10092','','',NULL,0,5,1,0.03,NULL,NULL,0,0,NULL,1,0,0,0,0),(93,'CODO PVC AG SP 3/4X45° PLASTICA','',48,82,86,1,'10093','','',NULL,0,5,1,0.03,NULL,NULL,0,0,NULL,1,0,0,0,0),(94,'CODO PVC AG SP 1X90° PLASTICA','',48,81,86,1,'10094','','',NULL,0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(95,'CODO PVC AG SP 1X45° PLASTICA','',48,81,86,1,'10095','','','',0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(96,'CODO PVC AG SP 1.1/2X90° PLASTICA','',48,24,86,1,'10096','','',NULL,0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(97,'CODO PVC AG SP 1.1/2X45° PLASTICA','',48,24,86,1,'10097','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(98,'CODO PVC AG SP 2X90° PLASTICA','',48,24,86,1,'10098','','',NULL,0,5,1,0.25,NULL,'',0,0,NULL,1,0,0,0,0),(99,'TEE PVC 1/2 AG SP PLASTICA','',48,81,90,1,'10099','','',NULL,0,5,1,0.03,NULL,NULL,0,0,NULL,1,0,0,0,0),(100,'TEE PVC 3/4 AG SP PLASTICA','',48,81,90,1,'10100','','',NULL,0,5,1,0.03,NULL,'',0,0,NULL,1,0,0,0,0),(101,'TEE PVC 1 AG SP PLASTICA','',48,81,90,1,'10101','','',NULL,0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(102,'TEE PVC 1.1/2 AG SP PLASTICA','',48,24,90,1,'10102','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(103,'TEE PVC 2 AG SP PLASTICA','',48,62,90,1,'10103','','',NULL,0,5,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(104,'BASE DE CACHIMBA PVC 160MMX4 ND','',36,24,57,1,'10104','','',NULL,0,5,1,0.45,NULL,NULL,0,0,NULL,1,0,0,0,0),(105,'BASE DE CACHIMBA PVC 200MMX160MM ND','',36,24,57,1,'10105','','',NULL,0,5,1,0.55,NULL,NULL,0,0,NULL,1,0,0,0,0),(106,'CODO PVC ALCA. ISO 160MMX90° ND','',36,24,97,1,'10106','','',NULL,0,5,1,0.95,NULL,NULL,0,0,NULL,1,0,0,0,0),(107,'CODO PVC ALCA. ISO 160MMX45° ND','',36,24,97,1,'10107','','',NULL,0,5,1,0.65,NULL,NULL,0,0,NULL,1,0,0,0,0),(108,'CODO PVC ALCA. ISO 200MMX90° ND','',36,24,97,1,'10108','','',NULL,0,5,1,2,NULL,'',0,0,NULL,1,0,0,0,0),(109,'ALAMBRE RECOCIDO N°08 PRODAC','',17,16,11,1,'10109','','','',0,3,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(110,'CODO PVC SAL 2X90° PLASTICA','',48,24,84,1,'10110','','',NULL,0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(111,'CODO PVC SAL 2X45° PLASTICA','',48,24,84,1,'10111','','',NULL,0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(112,'CODO PVC SAL 3X90° PLASTICA','',48,24,84,1,'10112','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(113,'CODO PVC SAL 3X45° PLASTICA','',48,24,84,1,'10113','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(114,'CODO PVC SAL 4X90° PLASTICA','',48,24,84,1,'10114','','','',0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(115,'CODO PVC SAL 4X45° PLASTICA','',48,24,84,1,'10115','','','',0,5,1,0.2,NULL,'',0,0,NULL,1,0,0,0,0),(116,'CODO PVC SAL 4X2 PLASTICA','',48,86,84,1,'10116','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(118,'TEE PVC SAL 2X2 PLASTICA','',14,24,88,1,'10118','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(120,'TEE PVC SAL 3X3 PLASTICA','',14,24,88,1,'10120','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(121,'TEE PVC SAL 4X2 PLASTICA','',14,92,88,1,'10121','','',NULL,0,5,1,0.45,NULL,'',0,0,NULL,1,0,0,0,0),(122,'TEE PVC SAL 4X4 PLASTICA','',14,51,88,1,'10122','','',NULL,0,5,1,0.45,NULL,NULL,0,0,NULL,1,0,0,0,0),(124,'TEE SANITARIA PVC SAL 4 PLASTICA','',14,24,88,1,'10124','','',NULL,0,5,1,50,NULL,'',0,0,NULL,1,0,0,0,0),(125,'YEE PVC SAL 2X2 PLASTICA','',14,24,20,1,'10125','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(126,'YEE PVC SAL 4X2 PLASTICA','',48,24,20,1,'10126','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(127,'YEE PVC SAL 3X3 PLASTICA','',48,24,20,1,'10127','','',NULL,0,5,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(128,'YEE PVC SAL 4X4 PLASTICA','',14,24,20,1,'10128','','',NULL,0,5,1,0.5,NULL,'',0,0,NULL,1,0,0,0,0),(129,'REDUCCION PVC SAP INTERNA 1x1/2 NICOLL ND','',42,24,21,1,'10129','','','',0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(130,'REDUCCION PVC SAP 1x3/4 NICOL','',42,24,21,1,'10130','','',NULL,0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(131,'REDUCCION PVC SAP 1.1/4x1 NICOLL','',42,24,21,1,'10131','','',NULL,0,5,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(132,'TEE PVC ALCAN.ISO S25160MMX160MM UF ND','',36,24,99,1,'10132','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(133,'REDUCCION PVC SAP 1.1/2 X1 NICOL','',42,24,21,1,'10133','','',NULL,0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(134,'REDUCCION PVC SAP 2x1 NICOLL','',42,24,21,1,'10134','','',NULL,0,5,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(135,'CLAVO CALAMINERO 2.1/2X9 PRODAC','',17,18,29,1,'10135','','','',0,3,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(136,'REDUCCION PVC SAP 3/4x1/2 NICOLL','',42,24,21,1,'10136','','',NULL,0,5,1,0.025,NULL,'',0,0,NULL,1,0,0,0,0),(137,'REDUCCION PVC SAL 3x2 PLASTICA','',14,86,21,1,'10137','','',NULL,0,5,1,0.07,NULL,'',0,0,NULL,1,0,0,0,0),(138,'REDUCCION PVC SAL 4x2 PLASTICA','',14,24,21,1,'10138','','','',0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(139,'REDUC. PVC SAL ISO S25 160MMX4 ND','',36,24,21,1,'10139','','',NULL,0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(141,'REDUC. PVC ISO S25 200MMX160MM ND','',36,24,21,1,'10141','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(142,'PEGAMENTO REG. PVC1/32GL(4ONZ) OATEY','',24,24,23,1,'10142','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(143,'PEGAMENTO REG. PVC1/16 GL(8ONZ) OATEY','',24,24,23,1,'10143','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(144,'PEGAMENTO REG. PVC1/8 GL(16ONZ) OATEY','',24,24,23,1,'10144','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(145,'PEGAMENTO REG. PVC1/4 GL(32ONZ) OATEY','',24,24,23,1,'10145','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(149,'REDUCCION PVC SAP 2x1.1/2 NICOLL','',42,24,21,1,'10149','','',NULL,0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(150,'REDUCCION PVC SAP 2.1/2x1.1/2 NICOL','',42,24,21,1,'10150','','',NULL,0,5,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(151,'CAJA OCTAGONAL PVC 4X4 PLASTICA','',14,24,22,1,'10151','','',NULL,0,5,1,0.03,NULL,'',0,0,NULL,1,0,0,0,0),(152,'CAJA RECTANGU. PVC 4X4 PLASTICA','',14,37,22,1,'10152','','',NULL,0,5,1,0.025,NULL,NULL,0,0,NULL,1,0,0,0,0),(153,'LUBRICANTE DE EMPALME PVC ND','',36,24,41,1,'10153','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(154,'TRIPLAY 4MMX1.22X2.44 CAPIRURI','',39,24,40,1,'10154','','',NULL,0,5,1,6,NULL,'',0,0,NULL,1,0,0,0,0),(155,'ADAPTADOR UPR PVC 1/2 PLASTICA','',14,24,43,1,'10155','','',NULL,0,5,1,0.04,NULL,NULL,0,0,NULL,1,0,0,0,0),(156,'ADAPTADOR UPR MIXTO 1/2 PLASTICA','',14,24,43,0,'10156','','','',0,5,1,0.04,NULL,NULL,0,0,NULL,1,0,0,0,0),(157,'ADAPTADOR UPR PVC C-10 1 PLASTICA','',14,81,43,1,'10157','','',NULL,0,5,1,0.07,NULL,'',0,0,NULL,1,0,0,0,0),(159,'ADAPTADOR UPR PVC C-10 3/4 PLASTICA','',14,24,43,1,'10159','','',NULL,0,5,1,0.06,NULL,'',0,0,NULL,1,0,0,0,0),(160,'TECNOPORT 2.40X1.20X1 EPS','',23,103,16,1,'10160','','',NULL,0,5,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(161,'TECNOPORT 2.40X1.20X1/2 EPS','',23,32,16,1,'10161','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(162,'LIJA DE FIERRO K200 60#9X11 NORTON','',21,24,185,1,'10162','','',NULL,0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(163,'PALANA CUCHARA LIVIANA BELLOTA','',26,24,25,0,'10163','','','',0,5,1,1.65,NULL,'',0,0,NULL,1,0,0,0,0),(164,'PALANA RECTA 5558 MA M/M CLS BELLOTA','',26,24,25,1,'10164','','','',0,5,1,2.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(165,'PALANA DERECHA SEMI. FIL BLANCO BELLOTA','',26,24,25,0,'10165','','','',0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(166,'ZAPAPICO A/P SIN MANGO BELLOTA','',26,24,26,1,'10166','','',NULL,0,5,1,2,NULL,NULL,0,0,NULL,1,0,0,0,0),(167,'ZAPAPICO A/P CON MANGO BELLOTA','',26,24,26,0,'10167','','','',0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(168,'CARRETILLA  ROJA 5670-5.5 BELLOTA','',26,24,27,0,'10168','','','',0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(175,'CARRETILLA BUGI AZUL TRUPER','',28,24,27,0,'10175','','','',0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(176,'CARRETILLA BLANCA PESADA VOLCAN','',27,24,27,1,'10176','','','',0,5,1,10,NULL,NULL,0,0,NULL,1,0,0,0,0),(177,'TECNOPORT TECHO 12X1.20X30 EPS','',23,30,16,1,'10177','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(178,'TECNOPORT TECHO 15X1.20X30 EPS','',23,31,16,1,'10178','','',NULL,0,5,1,0.35,NULL,'',0,0,NULL,1,0,0,0,0),(179,'HOJA SIERRA 12/300MM SANDFLEX','',55,37,32,1,'10179','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(181,'VALVULA JARDINERO CRO 1/2 C23146 PRETUL','',41,24,24,1,'10181','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(183,'LLAVE DE PASO ROSCADO PVC 3/4 NICOLL-D','',42,24,58,1,'10183','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(184,'LLAVE DE PASO ROSCADO PVC 3/4 PSD PCP ','',40,24,58,0,'10184','','','',0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(185,'LLAVE DE PASO ROSCADO PVC 3/4 C&A','',43,24,58,1,'10185','','',NULL,0,5,1,0.07,NULL,'',0,0,NULL,1,0,0,0,0),(186,'TABLERO PVC 3P/1LLAVES C/RIEL MIXTO KBA','',44,24,59,1,'10186','','',NULL,0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(187,'TABLERO PVC 5P/2LLAVES C/RIEL EMPOT KBA','',44,24,59,1,'10187','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(188,'CINTA AISLANTE 5YDS TECNOFAN','',34,24,35,1,'10188','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(189,'CINTA AISLANTE 20YDS ECO. TECNOFAN','',34,24,35,1,'10189','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(190,'LLAVE DE PASO ROSCADO PVC 1/2 NICOLL-D','',42,24,58,1,'10190','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(191,'WINCHA 3 MT C-21607 PRETUL','',41,24,60,1,'10191','','',NULL,0,5,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(192,'WINCHA 3 MT M/ERGON.SCHUBERT','',25,24,60,1,'10192','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(193,'WINCHA 5 MT C-21608 PRETUL','',41,24,60,1,'10193','','',NULL,0,5,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(194,'WINCHA 5 MT PROF. DJ TOOLS','',25,24,60,1,'10194','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(195,'VALVULA JARDINERO CRO 1/2  SCHUBERT','',25,24,24,1,'10195','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(196,'VALVULA BOTADERO CRO 1/2 LIV. C&A','',43,24,24,1,'10196','','',NULL,0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(200,'SUMIDERO 2 BRONCE ND','',36,24,37,1,'10200','','',NULL,0,5,1,0.06,NULL,NULL,0,0,NULL,1,0,0,0,0),(201,'SUMIDERO 4 BRONCE ND','',36,24,37,1,'10201','','',NULL,0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(202,'TRAMPA PVC SAL 2 + DESAGUE LAVATORIO C/H TITOMA','',38,24,38,1,'10202','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(203,'TRAMPA BOT Y DESAGUE PVC P/LAV. 1/4 SANIFE','',37,24,38,1,'10203','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(204,'CURVA PVC SEL 1 NICOLL','',42,24,17,1,'10204','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(206,'CODO 1/2 GALVANIZADO ND','',36,24,101,1,'10206','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(207,'ALAMBRE PUAX200MT SINCHI PRODAC','',17,16,33,1,'10207','','',NULL,0,11,1,8,NULL,'',0,0,NULL,1,0,0,0,0),(208,'CODO 1/2 BRONCE C&A','',43,24,96,1,'10208','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(209,'TAPON HEMBRA 1/2 INDUPLAST','',158,24,47,1,'10209','','','',0,5,1,0.01,NULL,'',0,0,NULL,1,0,0,0,0),(210,'TAPON MACHO ROSCADO PVC AG 1/2 PLASTICA','',14,82,47,1,'10210','','',NULL,0,5,1,0.01,NULL,'',0,0,NULL,1,0,0,0,0),(211,'TAPON HEMBRA CON ROSCA 1/2 MATUSITA','',14,24,47,1,'10211','','',NULL,0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(212,'UNION UNVERSAL PVC 1/2 PLASTICA ','',14,82,172,1,'10212','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(213,'UNION DOBLE ROSCA PVC AG SP 1/2 PLASTICA','',14,24,44,1,'10213','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(214,'UNION SIMPLE PVC AG SP 1/2 PLASTICA','',14,82,44,1,'10214','','',NULL,0,5,1,0.025,NULL,NULL,0,0,NULL,1,0,0,0,0),(215,'UNION SIMPLE PVC AG SP 3/4 PLASTICA','',14,82,44,1,'10215','','',NULL,0,5,1,0.015,NULL,NULL,0,0,NULL,1,0,0,0,0),(216,'UNION MIXTA PVC AG 1/2 PLASTICA','',14,24,44,1,'10216','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(217,'UNION PVC AG SP 1 PLASTICA','',14,81,44,1,'10217','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(218,'UNION PVC AG SP 1.1/2 PLASTICA','',14,24,44,1,'10218','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(219,'TEE SANITARIA PVC SAL 2 PLASTICA','',14,24,88,1,'10219','','',NULL,0,5,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(220,'TEE SANITARIA PVC SAL 4X2 PLASTICA ','',14,24,88,1,'10220','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(221,'TECNOPORT TECHO 08X1.20X30 EPS','',23,32,16,1,'10221','','',NULL,0,5,1,0.25,NULL,'',0,0,NULL,1,0,0,0,0),(222,'REGISTRO 2 BRONCE ND','',36,24,36,1,'10222','','',NULL,0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(223,'REGISTRO 4 BRONCE ND','',36,24,36,1,'10223','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(224,'ANILLO P/TUBO ALCANTARILLADO 160MM - NICOOL','',36,24,61,1,'10224','','',NULL,0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(225,'ANILLO P/TUBO ALCANTARILLADO 200MM NICOLL','',36,24,61,1,'10225','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(226,'PALANA DERECHA M/P VOLCAN','',27,24,25,0,'10226','','','',0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(227,'PALANA DERECHA M/M  PULIDA VOLCAN','',27,24,25,0,'10227','','','',0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(228,'MALLA OLIMPICA AWG-08 VOLCAN','',36,33,181,0,'10228','','','',0,13,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(229,'MALLA GALVANIZADA PESADA 1/2 - 18 VOLCAN','',27,34,48,1,'10229','','','',0,13,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(230,'GUANTE ANTICORDE LATEX NEGRO/ROJO CLUTE','',114,24,62,1,'10230','','',NULL,0,19,1,0.25,NULL,'',0,0,NULL,1,0,0,0,0),(231,'CASCO SEGURIDAD AZUL SEGUSA','',87,24,63,1,'10231','','',NULL,0,5,1,0.5,NULL,'',0,0,NULL,1,0,0,0,0),(232,'MANGUERA 5/8 QUIVER REFORZADA','',52,35,64,1,'10232','','',NULL,0,13,1,11,NULL,NULL,0,0,NULL,1,0,0,0,0),(233,'MANGUERA 5/8 HERLY REFORZADA','',53,35,64,1,'10233','','',NULL,0,13,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(234,'MANGUERA 3/4 QUIVER REFORZADA','',52,35,64,1,'10234','','',NULL,0,13,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(235,'MANGUERA 1 QUIVER REFORZADA','',52,35,64,1,'10235','','',NULL,0,13,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(236,'MANGUERA AUTOMOTRIZ 3/8 QUIVER','',52,35,64,1,'10236','','',NULL,0,13,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(237,'MANGUERA POLITILENO 5/8 NEGRO QUIVER','',52,35,176,0,'10237','','','',0,13,1,0.08,NULL,NULL,0,0,NULL,1,0,0,0,0),(239,'MANGUERA POLITILENO 3/4 NEGRO QUIVER','',52,35,176,0,'10239','','','',0,13,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(240,'MANGUERA 1/4 QUIVER REFORZADA','',52,35,64,1,'10240','','',NULL,0,13,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(241,'CINTA PELIGRO 200MT AMARILLO','',36,16,65,1,'10241','','',NULL,0,11,1,2.7,NULL,'',0,0,NULL,1,0,0,0,0),(242,'MALLA SEGURIDAD NARANJA X METRO SCHUBERT','',25,105,376,1,'10242','','',NULL,0,13,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(243,'ASPERSOR 5 BOQUILLAS QUIVER','',52,24,66,1,'10243','','',NULL,0,5,1,0.12,NULL,'',0,0,NULL,1,0,0,0,0),(244,'ASPERSOR PRIMO 3/4 QUIVER','',52,24,66,1,'10244','','',NULL,0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(245,'ASPERSOR PLASTICO 3/4 QUIVER','',52,24,66,1,'10245','','',NULL,0,5,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(246,'CHALECO REPORTERO AZUL- M  ND','',36,24,67,1,'10246','','',NULL,0,5,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(247,'CHALECO REPORTERO NARANJ - M ND','',36,24,67,1,'10247','','',NULL,0,5,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(248,'CHALECO REPORTERO VERD- B - MED ND','',36,24,67,1,'10248','','',NULL,0,5,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(249,'CASCO SEGURIDAD BLANCO SEGUSA','',87,24,63,1,'10249','','',NULL,0,5,1,0.5,NULL,'',0,0,NULL,1,0,0,0,0),(250,'CASCO SEGURIDAD AMARILLO SEGUSA','',87,24,63,1,'10250','','',NULL,0,5,1,0.5,NULL,'',0,0,NULL,1,0,0,0,0),(251,'LENTE DE SEGURIDAD TRANSP.SPIDER','',36,36,68,1,'10251','','',NULL,0,5,1,0.03,NULL,'',0,0,NULL,1,0,0,0,0),(252,'LENTE DE SEGURIAD OSCURO SESPRO','',36,36,68,1,'10252','','',NULL,0,5,1,0.03,NULL,'',0,0,NULL,1,0,0,0,0),(253,'CHALECO BÁSICO C/CINTA REFLECTIVA CLUTE','',114,24,67,1,'10253','','',NULL,0,5,1,0.4,NULL,'',0,0,NULL,1,0,0,0,0),(254,'CHALECO REPORTERO 24 NARANJA ND','',36,24,67,1,'10254','','',NULL,0,5,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(255,'ARENA GRUESA DE CONCHAN','',36,38,71,1,'10255','','',NULL,0,9,1,30,NULL,NULL,0,0,NULL,1,0,0,0,0),(256,'ARENA FINA DE CONCHAN','',36,38,71,0,'10256','','','',0,9,1,30,NULL,NULL,0,0,NULL,1,0,0,0,0),(257,'CALAMINA TRANS. 1.80 X 0.84 M BLANCO FIBRAFORTE','',33,24,72,1,'10257','','',NULL,0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(258,'CALAMINA TRANSPARENTE 3.60 X 0.84 M FIBRAFORTE','',33,24,72,1,'10258','','',NULL,0,5,1,3,NULL,'',0,0,NULL,1,0,0,0,0),(259,'CALAMINA TRANSPARENTE 1.80 X 0.84 TECHO PLUS','',57,24,72,1,'10259','','',NULL,0,5,1,1.2,NULL,'',0,0,NULL,1,0,0,0,0),(260,'CARRETILLA BUGI AZUL BADAC','',58,24,27,0,'10260','','','',0,5,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(261,'LIJA DE FIERRO K200 80#9X11 NORTON','',21,24,185,1,'10261','','',NULL,0,5,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(262,'LLAVE DE PASO ROSCADO PVC 1/2 C&A','',43,24,58,1,'10262','','',NULL,0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(263,'PIEDRA CHANCADA','',36,38,73,1,'10263','','',NULL,0,9,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(264,'PIEDRA DE BASE ENTERA','',36,38,73,1,'10264','','',NULL,0,16,1,1200,NULL,'',0,0,NULL,1,0,0,0,0),(265,'CONFITILLO','',36,38,49,1,'10265','','',NULL,0,9,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(266,'SIKA 1 X 4LT','',59,39,45,1,'10266','','',NULL,0,5,1,5,NULL,'',0,0,NULL,1,0,0,0,0),(267,'CINTA TEFLON 1/2 C&A','',25,40,74,1,'10267','','',NULL,0,5,1,0.0071,NULL,'',0,0,NULL,1,0,0,0,0),(268,'CINTA TEFLON CPVC 1/2 CYA','',43,40,74,1,'10268','','',NULL,0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(269,'TUBO CPVC AQUATHERM ASTM 1/2 PLAST','',48,24,93,1,'10269','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(270,'TEE CPVC AQUATH ASTM 1/2 PLAST','',48,88,100,1,'10270','','','',0,5,1,0.2,NULL,'',0,0,NULL,1,0,0,0,0),(271,'CODO CPVC AQUAT ASTM 1/2 x 90PLAST','',48,88,98,1,'10271','','','',0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(272,'CAJA CONCRETO PARA AGUA ND','',36,24,114,1,'10272','','',NULL,0,5,1,60,NULL,NULL,0,0,NULL,1,0,0,0,0),(273,'CAJA CONCRETO DESAGUE','',36,24,114,1,'10273','','',NULL,0,5,1,145.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(274,'TUBO PVC AG C.10 1/2X5MT NICOLL','',42,24,82,1,'10274','','',NULL,0,5,1,0.5,NULL,'',0,0,NULL,1,0,0,0,0),(275,'TUBO PVC SAL 2X3MT NICOLL','',42,24,80,1,'10275','','',NULL,0,5,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(276,'TUBO PVC SAL 4X3MT NICOLL','',42,24,80,1,'10276','','',NULL,0,5,1,2.51,NULL,'',0,0,NULL,1,0,0,0,0),(278,'TUBO PVC SEL 3/4X3MT PLASTICA','',48,24,83,1,'10278','','',NULL,0,5,1,0.35,NULL,'',0,0,NULL,1,0,0,0,0),(279,'TUBO PVC SEL 5/8X3MT PLASTICA','',48,24,83,1,'10279','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(280,'POR SERVICIO DE TRANSPORTE','',36,17,75,1,'10280','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(281,'LADRILLO SUPER KIN KON CERAM LAMB','',16,24,315,1,'10281','','',NULL,0,5,1,8.4,NULL,'',0,0,NULL,1,0,0,0,0),(282,'LADRILLO ARTESANAL BAMBAMARCA','',36,24,316,1,'10282','','',NULL,0,5,1,3.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(283,'GUANTE ANTICORTE LARGO TRUPER','',28,42,62,1,'10283','','',NULL,0,19,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(284,'CLAVO C/C ACERO GALV. 3.5 X 65MM (2.1/2 plg) BILDER','',148,28,77,1,'10284','','',NULL,0,3,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(285,'CLAVO C/C ACERO GALV. 4.0 X 2.7MM (1.1/2) BILDER','',148,28,77,1,'10285','','',NULL,0,3,1,0.003,NULL,'',0,0,NULL,1,0,0,0,0),(286,'CLAVO C/C ACERO GALV. 4 X 75MM (3 plg) BILDER','',148,28,77,1,'10286','','',NULL,0,3,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(287,'CINTA EMPAQUE TRANSP. 40MT PRETUL','',41,43,78,1,'10287','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(288,'CINTA EMPAQUE TRANSP. 150MT PRETUL','',41,43,78,1,'10288','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(289,'CINTA TEFLON 1/2x7MT TRUPER','',28,44,74,0,'10289','','','',0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(290,'CINTA TEFLON 1/2x13MT TRUPER','',28,44,74,0,'10290','','','',0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(291,'CINTA AISL. NEGRA 9MT PRETUL','',41,43,35,1,'10291','','',NULL,0,5,1,0.033,NULL,NULL,0,0,NULL,1,0,0,0,0),(292,'CINTA AISL. NEGRA 18MT PRETUL','',41,43,35,1,'10292','','',NULL,0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(293,'MALLA OLIMPICA AWG-10 VOLCAN','',27,45,181,1,'10293','','',NULL,0,13,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(294,'ESCOBA HUDE','',104,24,102,1,'10294','','',NULL,0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(295,'TAPON PVC SAL 2 NICOLL','',42,24,47,1,'10295','','',NULL,0,5,1,0.01,NULL,'',0,0,NULL,1,0,0,0,0),(296,'CLAVO C/C ACERO GALV. 3.5 X 50MM (2 plg)BILDER','',148,28,77,1,'10296','','',NULL,0,3,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(297,'TRAMPA PVC 2 C/REGIS. 3/4 MAT-TIGRE','',61,24,38,1,'10297','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(298,'TRAMPA PVC 2 MAT-TIGRE','',61,62,38,1,'10298','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(299,'CODO PVC AG MIXTO C-10 1/2 PLASTICA','',48,5,86,1,'10299','','',NULL,0,5,1,0.02,NULL,NULL,0,0,NULL,1,0,0,0,0),(300,'CODO PVC SAL 2X90° NICOLL','',42,104,85,1,'10300','','',NULL,0,5,1,0.075,NULL,'',0,0,NULL,1,0,0,0,0),(301,'CODO PVC SAL 4X90° NICOLL','',42,24,85,1,'10301','','',NULL,0,5,1,0.31,NULL,'',0,0,NULL,1,0,0,0,0),(302,'TEE PVC SAL 4X4 NICOLL','',42,24,89,1,'10302','','',NULL,0,5,1,0.41,NULL,NULL,0,0,NULL,1,0,0,0,0),(303,'TEE PVC SAL 2X2 NICOLL','',42,24,89,1,'10303','','',NULL,0,5,1,0.124,NULL,NULL,0,0,NULL,1,0,0,0,0),(304,'CAJA RECTANGULAR PVC ORO PLAST','',78,24,174,1,'10304','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(305,'NIPLE PVC AG C/R 1/2X1.1/2 MAT-TIGRE','',14,24,76,1,'10305','','',NULL,0,5,1,0.03,NULL,NULL,0,0,NULL,1,0,0,0,0),(306,'NIPLE PVC AG C/R 1 MAT-TIGRE','',61,24,76,1,'10306','','',NULL,0,5,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(307,'NIPLE PVC AG C/R 1.1/2 MAT-TIGRE','',61,24,76,1,'10307','','',NULL,0,5,1,0.01,NULL,'',0,0,NULL,1,0,0,0,0),(308,'NIPLE PVC AG C/R 2 MAT-TIGRE','',61,24,76,1,'10308','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(309,'BUSHING 3/4 X 1/2 MAT-TIGRE','',61,24,103,1,'10309','','',NULL,0,5,1,0.03,NULL,NULL,0,0,NULL,1,0,0,0,0),(310,'NIPLE PVC AG C/R 3/4 MAT-TIGRE','',61,82,76,1,'10310','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(311,'COMBA C/M 8LB GUOZU','',29,24,53,1,'10311','','',NULL,0,5,1,4,NULL,NULL,0,0,NULL,1,0,0,0,0),(312,'COMBA C/M 6LB BELLOTA','',26,24,53,1,'10312','','',NULL,0,5,1,3,NULL,NULL,0,0,NULL,1,0,0,0,0),(313,'COMBA C/M 10LB BELLOTA','',26,24,53,1,'10313','','',NULL,0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(314,'BARRETA EXAGONAL BELLOTA','',26,24,52,1,'10314','','',NULL,0,5,1,10.9,NULL,NULL,0,0,NULL,1,0,0,0,0),(315,'BARRETA AGRICOLA BELLOTA','',26,24,52,1,'10315','','',NULL,0,5,1,9,NULL,'',0,0,NULL,1,0,0,0,0),(316,'PALANA RECTA PUÑO Y TRUPER','',28,24,25,1,'10316','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(317,'PALANA CUCHARA PUÑO Y TRUPER','',28,24,25,1,'10317','','',NULL,0,5,1,1.95,NULL,NULL,0,0,NULL,1,0,0,0,0),(318,'CUTTER 5 ECONÓMICA TRUPER','',28,24,104,0,'10318','','','',0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(319,'CARRETILLA 5.5 LLANTA REFOR. TRUPER','',28,24,27,1,'10319','','',NULL,0,5,1,10,NULL,'',0,0,NULL,1,0,0,0,0),(320,'CARRETILLA KIDS TRUPÉR','',28,24,27,1,'10320','','',NULL,0,5,1,5.85,NULL,'',0,0,NULL,1,0,0,0,0),(321,'TANQUE 1100 LT ARENA ETERNIT','',63,24,105,1,'10321','','',NULL,0,5,1,15,NULL,'',0,0,NULL,1,0,0,0,0),(322,'TANQUE 1100 LT NEGRO ETERNIT','',63,24,105,1,'10322','','',NULL,0,5,1,15,NULL,'',0,0,NULL,1,0,0,0,0),(323,'TUBO PVC SEL 1X3MT PLASTICA','',48,24,83,1,'10323','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(325,'MARCO Y TAPA TERMO. CAJA AGUA S/VISOR YASELL','',74,24,106,1,'10325','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(326,'PEGAMENTO REG. PVC1/32 GL NICOLL','',42,36,109,1,'10326','','',NULL,0,5,1,0.112,NULL,NULL,0,0,NULL,1,0,0,0,0),(327,'DISCO C/F 4.1/2 NORTON','',21,24,107,1,'10327','','',NULL,0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(328,'CODO PVC SAL 2X45° NICOLL','',42,104,85,1,'10328','','',NULL,0,5,1,0.073,NULL,'',0,0,NULL,1,0,0,0,0),(329,'CODO PVC SAL 4X45° NICOLL','',42,24,85,1,'10329','','',NULL,0,5,1,0.246,NULL,'',0,0,NULL,1,0,0,0,0),(330,'TEE PVC SAL 4X2 NICOLL','',42,24,89,1,'10330','','',NULL,0,5,1,0.314,NULL,NULL,0,0,NULL,1,0,0,0,0),(331,'YEE PVC SAL 4X2 NICOLL','',42,24,108,1,'10331','','',NULL,0,5,1,0.33,NULL,NULL,0,0,NULL,1,0,0,0,0),(332,'UNION MIXTA PVC1/2 NICOLL','',42,24,116,0,'10332','','','',0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(333,'PEGAMENTO REG. PVC1/16 GL NICOLL','',42,24,109,1,'10333','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(334,'PEGAMENTO REG. PVC1/8 GL NICOLL','',42,24,109,1,'10334','','',NULL,0,5,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(335,'PEGAMENTO REG. PVC1/4 GL NICOLL','',42,24,109,1,'10335','','',NULL,0,5,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(336,'PEGAMENTO REG. PVC 1 GL NICOLL','',42,24,109,1,'10336','','',NULL,0,5,1,6,NULL,'',0,0,NULL,1,0,0,0,0),(337,'TEE SANITARIA PVC SAL 2 NICOL','',42,24,89,1,'10337','','',NULL,0,5,1,0.12,NULL,NULL,0,0,NULL,1,0,0,0,0),(338,'REDUC. SAL 4X3 NICOLL','',42,24,110,0,'10338','','','',0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(339,'CODO PVC C/R 1/2X90 NICOLL','',42,82,87,1,'10339','','',NULL,0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(340,'TEE PVC AG 1/2 NICOLL','',42,84,91,1,'10340','','',NULL,0,5,1,0.044,NULL,'',0,0,NULL,1,0,0,0,0),(341,'TAPON PVC PRES AG 3/4 NICOLL','',42,24,112,1,'10341','','',NULL,0,5,1,0.01,NULL,'',0,0,NULL,1,0,0,0,0),(342,'TAPON PVC PRES AG 1 NICOLL','',42,24,112,1,'10342','','',NULL,0,5,1,0.01,NULL,'',0,0,NULL,1,0,0,0,0),(343,'CAJA RECTANGU. PVC 4X2 NICOLL','',42,24,113,1,'10343','','',NULL,0,5,1,0.03,NULL,NULL,0,0,NULL,1,0,0,0,0),(344,'CAJA OCTAG. PVC 4X4 NICOLL','',42,24,113,1,'10344','','',NULL,0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(345,'TUBO PVC SEL 3/4X3MT NICOLL','',42,24,115,1,'10345','','',NULL,0,5,1,0.339,NULL,NULL,0,0,NULL,1,0,0,0,0),(346,'CURVA PVC SEL 3/4 NICOLL','',42,24,17,1,'10346','','',NULL,0,5,1,0.01,NULL,'',0,0,NULL,1,0,0,0,0),(347,'CODO PVC AG SP 1/2X90° NICOLL','',42,83,87,1,'10347','','',NULL,0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(349,'UNION PVC SAL SIMPLE 4 NICOLL','',42,87,44,1,'10349','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(350,'CAJA OCTAGONAL PVC ORO PLAST','',78,24,174,1,'10350','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(351,'VALVULA CROM. JARDINERA 1/2 PCP','',40,24,24,1,'10351','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(352,'LLAVE DE PASO ROSCADO PVC 1/2 CONCYSSA','',65,5,58,1,'10352','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(353,'VALVULA BOTADERO CRO 1/2 PSD. SCHUBERT','',25,36,24,1,'10353','','',NULL,0,5,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(354,'TAPON REJILLA 2 BRONCE ND','',36,24,119,1,'10354','','',NULL,0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(355,'TANQUE 2500 LT NEGRO ETERNIT','',63,24,105,1,'10355','','',NULL,0,5,1,25,NULL,NULL,0,0,NULL,1,0,0,0,0),(356,'TANQUE PE ARENA 1100 LT C/ACC COMPL NICOLL','',42,24,120,1,'10356','','',NULL,0,5,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(357,'TEE PVC C/R 1/2 AG SP NICOLL','',42,24,91,1,'10357','','',NULL,0,5,1,0.02,NULL,'',0,0,NULL,1,0,0,0,0),(358,'YEE PVC SAL 2X2 NICOLL','',42,24,108,1,'10358','','',NULL,0,5,1,0.147,NULL,NULL,0,0,NULL,1,0,0,0,0),(359,'YEE PVC SAL 4X4 NICOLL','',42,24,108,1,'10359','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(360,'CODO PVC SAL 4X2 NICOLL','',42,24,85,1,'10360','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(361,'REDUCCION PVC SAL 4X2 NICOLL','',42,24,110,1,'10361','','','',0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(362,'REDUCCION PVC SAL 4X3 NICOLL','',42,24,110,1,'10362','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(363,'TUBO PVC SAL 3X3MT NICOLL','',42,24,80,1,'10363','','',NULL,0,5,1,1.7,NULL,'',0,0,NULL,1,0,0,0,0),(364,'TAPA CONCRETO CAJA DESAG. ND','',36,24,122,1,'10364','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(365,'CUERPO CONCRETO CAJA DESAG. ND','',36,24,123,1,'10365','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(366,'BASE CONCRETO CAJA DESAG. ND','',36,24,124,1,'10366','','',NULL,0,5,1,61,NULL,'',0,0,NULL,1,0,0,0,0),(367,'ADAPTADOR UPR PVC 1/2 NICOLL','',42,81,125,1,'10367','','',NULL,0,5,1,0.04,NULL,NULL,0,0,NULL,1,0,0,0,0),(368,'CISTERNA DE AGUA','',36,24,126,1,'10368','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(369,'GALLINAZA','',36,24,127,1,'10369','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(370,'BONIFICACION PANETON NICOLL','',42,24,128,1,'10370','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(371,'LADRILLO SUPER KIN KON SOL DEL NORTE','',19,24,315,1,'10371','','',NULL,0,5,1,8.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(372,'ALAMBRON 6MM SIDERPERU','',13,19,129,1,'10372','','',NULL,0,12,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(373,'TANQUE 600 LT NEGRO ETERNIT','',63,24,105,1,'10373','','','',0,5,1,10,NULL,NULL,0,0,NULL,1,0,0,0,0),(374,'MARTILLO CABEZA CONICA  29MM TRUPER','',28,24,130,1,'10374','','',NULL,0,5,1,0.6,NULL,'',0,0,NULL,1,0,0,0,0),(375,'MARTILLO CABEZA CONICA 27MM TRUPER','',28,24,130,1,'10375','','',NULL,0,5,1,0.65,NULL,'',0,0,NULL,1,0,0,0,0),(376,'COMBA OCTAG. 2 LBS C/MANGO TRUPER','',28,24,53,1,'10376','','',NULL,0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(377,'DISCO CORTE D 7 plg TRUPER','',28,24,107,1,'10377','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(378,'MANGO PARA ZAPAPICO','',36,24,131,1,'10378','','',NULL,0,5,1,0.95,NULL,NULL,0,0,NULL,1,0,0,0,0),(379,'COMBA C/M 3LB BELLOTA','',26,24,53,1,'10379','','',NULL,0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(380,'COMBA C/M 8LB BELLOTA','',26,24,53,1,'10380','','',NULL,0,5,1,4,NULL,NULL,0,0,NULL,1,0,0,0,0),(381,'COMBA C/M 2LB GUOZU','',29,24,53,1,'10381','','',NULL,0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(382,'COMBA C/M 4LB GUOZU','',29,24,53,1,'10382','','',NULL,0,5,1,2,NULL,NULL,0,0,NULL,1,0,0,0,0),(383,'COMBA C/M 6LB GUOZU','',29,24,53,1,'10383','','',NULL,0,5,1,3,NULL,NULL,0,0,NULL,1,0,0,0,0),(384,'BARRETA EXAGONAL GUOZU','',29,24,52,1,'10384','','',NULL,0,5,1,10.9,NULL,NULL,0,0,NULL,1,0,0,0,0),(385,'COMBA C/M 10LB GUOZU','',29,24,53,1,'10385','','',NULL,0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(386,'COMBA C/M 12LB GUOZU','',29,24,53,1,'10386','','',NULL,0,5,1,6,NULL,NULL,0,0,NULL,1,0,0,0,0),(387,'COMBA C/M 14LB GUOZU','',29,24,53,1,'10387','','',NULL,0,5,1,7,NULL,NULL,0,0,NULL,1,0,0,0,0),(388,'COMBA C/M 16LB GUOZU','',29,24,53,1,'10388','','',NULL,0,5,1,8,NULL,NULL,0,0,NULL,1,0,0,0,0),(389,'RASTRILLO C/M 14 DIENTES GOUZU','',36,24,132,1,'10389','','',NULL,0,5,1,0.2,NULL,'',0,0,NULL,1,0,0,0,0),(390,'RASTRILLO C/M 16 DIENTES GOUZU','',36,24,132,1,'10390','','',NULL,0,5,1,0.55,NULL,'',0,0,NULL,1,0,0,0,0),(391,'UNION CPVC SIMPLE 1/2 PLASTICA ','',48,24,44,1,'10391','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(392,'CALAMINA 0.20X1.80 SIDERPERU','',13,24,318,0,'10392','','','',0,5,1,2.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(393,'DISCO CORTE DE 7 X 1/16 NORTON','',21,36,107,1,'10393','','',NULL,0,5,1,0.4,NULL,'',0,0,NULL,1,0,0,0,0),(394,'MARCO DE TAPA CONCRE. DESAGUE ND','',36,24,133,1,'10394','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(395,'ARCO DE SIERRA 12 plg PRETUL','',41,24,134,0,'10395','','','',0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(396,'PALANA T-2000 CUCHARA T.ESPAÑOL TRUPER','',28,24,25,1,'10396','','',NULL,0,5,1,1.7,NULL,'',0,0,NULL,1,0,0,0,0),(397,'COMBA OCTAG. 10 LBS C/MANGO TRUPER','',28,24,53,1,'10397','','',NULL,0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(398,'COMBA OCTAG. 14 LBS C/MANGO TRUPER','',28,24,53,1,'10398','','',NULL,0,5,1,7,NULL,NULL,0,0,NULL,1,0,0,0,0),(399,'COMBA OCTAG. 16 LBS C/MANGO TRUPER','',28,24,53,1,'10399','','',NULL,0,5,1,8,NULL,NULL,0,0,NULL,1,0,0,0,0),(400,'COMBA OCTAG. 20 LBS C/MANGO TRUPER','',28,24,53,1,'10400','','',NULL,0,5,1,10,NULL,NULL,0,0,NULL,1,0,0,0,0),(401,'PALANA T-2000 RECTA PERU TRUPER','',28,24,25,1,'10401','','',NULL,0,5,1,1.7,NULL,'',0,0,NULL,1,0,0,0,0),(402,'PALANA RECTA M/PLASTICO TRUPER','',28,24,25,1,'10402','','',NULL,0,5,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(403,'CAMARA LLANTA DE CARRETILLA TRUPER','',28,24,135,1,'10403','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(404,'ALICATE UNIVERSAL T200-8X TRUPER','',28,24,136,1,'10404','','',NULL,0,5,1,0.5,NULL,'',0,0,NULL,1,0,0,0,0),(405,'CEMENTO TIPO V PACASMAYO','',2,10,1,0,'10405','','','',0,8,1,42.5,NULL,'',0,0,NULL,1,0,0,0,0),(406,'PLASTICO 2.00 MTS  DOBLE ANCHO X KILOGRAMO','',36,101,137,1,'10406','','',NULL,0,3,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(407,'MALLA GALVANIZADA CUADRADA 1/2 - BWG23 C&A','',43,34,48,1,'10407','','',NULL,0,13,1,0.43,NULL,'',0,0,NULL,1,0,0,0,0),(408,'CABLE SOLIDO TW-80 14 AWG INDECO','',66,35,251,1,'10408','','','',0,13,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(409,'CABLE SOLIDO TW-80 12 AWG INDECO','',66,35,251,1,'10409','','','',0,13,1,0.06,NULL,'',0,0,NULL,1,0,0,0,0),(410,'CORDON MELLIZO CTM 2X20 AWG INDECO','',66,35,139,0,'10410','','','',0,13,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(411,'CORDON MELLIZO CTM 2X18 AWG INDECO','',66,35,139,1,'10411','','',NULL,0,13,1,0.04,NULL,NULL,0,0,NULL,1,0,0,0,0),(412,'CORDON MELLIZO CTM 2X16 AWG INDECO','',66,35,139,1,'10412','','',NULL,0,13,1,0.03,NULL,NULL,0,0,NULL,1,0,0,0,0),(413,'INTERRUPTOR SIMPLE P/EMPOTRAR TOP LIGHT','',67,36,140,0,'10413','','','',0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(414,'INTERRUPTOR TRIPLE P/EMPOTRAR HOME LIGHT','',68,36,140,1,'10414','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(415,'TOMACORRIENTE SIMPLE P/SOBREPONER -BEST LIGHT','',71,36,142,0,'10415','','','',0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(416,'TOMACORRIENTE DOBLE P/EMPOTRAR HOME LIGHT','',68,36,142,1,'10416','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(417,'TOMACORRIENTE TRIPLE P/SOBREPONER C/SALIDA TIERRA HOME LIGHT','',68,36,142,1,'10417','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(418,'SOCATE P/EMPOTRAR HOME LIGHT','',68,44,143,1,'10418','','','',0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(419,'SOCATE COLGANTE HOME LIGHT','',68,36,143,1,'10419','','',NULL,0,5,1,0.01,NULL,'',0,0,NULL,1,0,0,0,0),(420,'FOCO AHOR/ 3U-27W-HOME LIGHT','',68,37,144,0,'10420','','','',0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(421,'INTERRUPTOR MIXTO P/EMPOTRAR- HOME LIGHT','',68,36,140,1,'10421','','',NULL,0,5,1,0.5,NULL,'',0,0,NULL,1,0,0,0,0),(422,'CANALETA 10X10 1/4 Pulg. C/ADESIVO HOME LIGHT','',68,27,145,1,'10422','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(423,'CANALETA 10X15 1/2 Pulg. C/ADESIVO HOME LIGHT','',68,27,145,1,'10423','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(424,'CANALETA 10X20 3/4 Pulg. C/ADESIVO HOME LIGHT','',68,25,145,1,'10424','','',NULL,0,5,1,0.11,NULL,'',0,0,NULL,1,0,0,0,0),(425,'CANALETA 14X24 1 Pulg. C/ADESIVO HOME LIGHT','',68,25,145,1,'10425','','',NULL,0,5,1,0.12,NULL,'',0,0,NULL,1,0,0,0,0),(426,'LLAVE DUCHA CROMADA FAVINSA','',72,24,146,1,'10426','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(427,'TOMACORRIENTE TRIPLE P/EMPOTRAR- HOME LIGHT','',68,36,142,1,'10427','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(428,'PINTURA LATEX PROFESIONAL BLANCO GL 4LT CERESITA','',69,39,147,0,'10428','','','',0,5,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(429,'IMPRIMANTE MAESTRO GAL 4LT ANYPSA','',70,39,148,0,'10429','','','',0,18,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(430,'IMPRIMANTE BOLSA X 3.80 Kg. SUPER CHAVIN','',73,47,149,1,'10430','','',NULL,0,5,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(431,'CALAMINA TRANS. 1.80 X 0.84 M AMBAR FIBRAFORTE','',33,24,72,1,'10431','','','',0,5,1,1.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(432,'CALAMINA TRANS. 1.80 X 0.84 M CELESTE FIBRAFORTE','',33,24,72,1,'10432','','',NULL,0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(433,'CALAMINA TRANS. 1.80 X 0.84 M VD LIMON FIBRAFORTE','',33,24,72,1,'10433','','',NULL,0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(434,'TUBO PVC AG C10 SP 1X5MT NICOLL','',42,25,82,1,'10434','','',NULL,0,5,1,1.6,NULL,'',0,0,NULL,1,0,0,0,0),(435,'TUBO PVC AG C10 SP 3/4X5MT NICOLL','',42,25,82,1,'10435','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(436,'UNION MIXTA PVC AG 3/4 MAT-TIGRE','',61,5,44,1,'10436','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(437,'ALICATE UNIVERSAL T200-9X TRUPE','',28,24,136,1,'10437','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(438,'MARCO Y TAPA TERMO. CAJA AGUA C/VISOR YASELL','',74,24,106,1,'10438','','',NULL,0,5,1,1.45,NULL,'',0,0,NULL,1,0,0,0,0),(439,'MARCO Y TAPA TERMO. CAJA AGUA S/VISOR CONCYSSA','',65,24,106,1,'10439','','',NULL,0,5,1,1.45,NULL,'',0,0,NULL,1,0,0,0,0),(440,'LLAVE CORPORATION DN 1/2 CONCYSSA','',65,24,58,1,'10440','','',NULL,0,5,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(441,'PISTOLA PINTAR BAJA PRESION, 50PSI TRUPER','',28,24,150,1,'10441','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(442,'PLANCHA EMPASTAR M/PLAST 6 REMACH TRUPER','',28,24,151,1,'10442','','',NULL,0,5,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(443,'PLANCHA EMPASTAR M/MADERA 6 REMACH TRUPER','',28,24,151,1,'10443','','',NULL,0,5,1,0.45,NULL,'',0,0,NULL,1,0,0,0,0),(444,'PLANCHA D/BATIR 9 PRETUL','',41,24,322,1,'10444','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(445,'PALANA CAJUELERA CUCHARA TRUPER - KIDS','',28,24,153,1,'10445','','',NULL,0,5,1,0.75,NULL,'',0,0,NULL,1,0,0,0,0),(446,'INFLADOR MANUAL 23 plg TRUPER','',28,24,154,1,'10446','','',NULL,0,5,1,0.75,NULL,'',0,0,NULL,1,0,0,0,0),(447,'RODILLO FELPA ASPERA 9 plgX 1 plg TRUPER','',28,24,155,1,'10447','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(448,'WINCHA CONTRA IMPACTO 3M TRUPER','',28,24,60,0,'10448','','','',0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(449,'WINCHA CONTRA IMPACTO 5M TRUPER','',28,24,60,1,'10449','','','',0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(450,'WINCHA CONTRA IMPACTO 8M TRUPER','',28,24,60,1,'10450','','',NULL,0,5,1,0.4,NULL,'',0,0,NULL,1,0,0,0,0),(451,'DISCO CORTE D 4 plg TRUPER','',28,24,107,1,'10451','','',NULL,0,5,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(452,'ALICATE UNIVERSAL 8 plg PRETUL','',41,24,136,1,'10452','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(453,'BROCHA C/M PLASTICO 3 plg TRUPER','',28,24,156,1,'10453','','',NULL,0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(454,'BROCHA C/M PLASTICO 3 plg PRETUL','',41,24,156,1,'10454','','',NULL,0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(455,'PELA CABLES 6 plg TRUPER','',28,24,157,1,'10455','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(456,'DUCHA REG. CABEZA ABS 3 plg FOSET','',75,24,159,0,'10456','','','',0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(457,'CURVA PVC AG 1/2 PLASTICA','',48,24,160,1,'10457','','',NULL,0,5,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(458,'CURVA PVC AG 3/4 NICOLL','',42,24,160,1,'10458','','',NULL,0,5,1,0.01,NULL,'',0,0,NULL,1,0,0,0,0),(459,'TAPON PVC SAL 4 NICOL','',42,24,47,1,'10459','','',NULL,0,5,1,0.29,NULL,'',0,0,NULL,1,0,0,0,0),(460,'TAPON PVC ALCAN SAL 6 NARANJA ND','',36,24,47,1,'10460','','',NULL,0,5,1,0.2,NULL,'',0,0,NULL,1,0,0,0,0),(461,'SIKA 1 EN POLVO X 1KG','',59,28,45,1,'10461','','',NULL,0,5,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(462,'LIJA DE FIERRO K200 40#9X11 NORTON','',21,24,185,1,'10462','','',NULL,0,5,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(463,'ADAPTADOR UPR PVC C-10 1.1/2 ND','',36,24,43,1,'10463','','',NULL,0,5,1,0.06,NULL,'',0,0,NULL,1,0,0,0,0),(464,'ADAPTADOR UPR PVC 2 PLASTICA','',14,24,43,1,'10464','','',NULL,0,5,1,0.06,NULL,NULL,0,0,NULL,1,0,0,0,0),(465,'ADAPTADOR UPR PVC 2.1/2 PLASTICA','',14,24,43,1,'10465','','',NULL,0,5,1,0.06,NULL,NULL,0,0,NULL,1,0,0,0,0),(466,'ADAPTADOR UPR PVC 3 PLASTICA','',14,24,43,1,'10466','','',NULL,0,5,1,0.06,NULL,NULL,0,0,NULL,1,0,0,0,0),(467,'REDUCCION PVC SAP 1.1/2x1/2 NICOL','',42,24,21,1,'10467','','',NULL,0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(468,'REDUCCION PVC SAP 1.1/2x3/4 NICOL','',14,24,21,1,'10468','','',NULL,0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(469,'REDUCCION PVC SAP 2x1/2 NICOL','',42,24,21,1,'10469','','',NULL,0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(470,'REDUCCION PVC SAP 2x3/4 NICOLL','',42,24,21,1,'10470','','',NULL,0,5,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(471,'CANASTILLA  PVC AG 3 X 2 ND','',36,24,161,1,'10471','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(472,'BASE DE CACHIMBA PVC 160MMX160MM ND','',36,24,57,1,'10472','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(473,'CODO PVC ALCA. ISO 160MMX45° CACHIMBA ND','',36,24,97,1,'10473','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(474,'CARRETILLA BUGI AZUL PRODAC','',17,24,27,0,'10474','','','',0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(475,'MALLA GALVANIZADA  HEXAGON 1/2  TARAJEO C&A','',43,34,48,1,'10475','','','',0,13,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(476,'RODILLO P/PINTAR 9 plg SCHUBERT','',25,24,155,1,'10476','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(477,'MALLA GALVANIZADA 1/2 - C.20 PRODAC','',17,34,48,1,'10477','','',NULL,0,13,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(478,'ADAPTADOR CPVC UPR  1/2 PLASTICA','',14,24,43,1,'10478','','',NULL,0,5,1,0.03,NULL,NULL,0,0,NULL,1,0,0,0,0),(479,'YEE PVC AG. 3/4 NICOLL','',42,24,162,1,'10479','','',NULL,0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(480,'YEE PVC AG. 1 NICOLL','',42,24,162,1,'10480','','',NULL,0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(481,'TEE PVC ALCAN.160MMX 4 NICOLL','',42,24,89,1,'10481','','',NULL,0,5,1,0.8,NULL,'',0,0,NULL,1,0,0,0,0),(482,'CURVA PVC AG 1 NICOLL','',42,24,160,1,'10482','','',NULL,0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(483,'CACHIMBA PVC ALCAN. 160MMX110MM NICOLL','',42,24,57,1,'10483','','',NULL,0,5,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(484,'CODO PVC ALCAN. 110MMX45 NICOLL','',42,24,97,1,'10484','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(485,'CARRETILLA  ROJA 5670-6 BELLOTA','',26,24,27,0,'10485','','','',0,5,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(486,'CARRETILLA GRIS 5673-5.5 BELLOTA','',26,24,27,1,'10486','','',NULL,0,5,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(487,'CARRETILLA GRIS 5673-6 BELLOTA','',26,24,27,0,'10487','','','',0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(488,'MALLA ACERO 1/16 PRODAC','',17,24,48,1,'10488','','',NULL,0,13,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(489,'CALAMINA 0.20X3.60 SIDERPERU','',13,24,318,1,'10489','','','',0,5,1,5.6,NULL,NULL,0,0,NULL,1,0,0,0,0),(490,'TUBO PVC ISO ALCA C-4/S-25 110MM UFX6MT PLASTICA','',14,24,92,1,'10490','','',NULL,0,5,1,7,NULL,NULL,0,0,NULL,1,0,0,0,0),(491,'MANGUERA DUPLEX 5/8 PESADA QUIVER','',52,35,175,1,'10491','','',NULL,0,13,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(492,'MANGUERA DUPLEX 3/4 PESADA QUIVER','',52,35,175,1,'10492','','',NULL,0,13,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(493,'MANGUERA DUPLEX 1 PESADA QUIVER','',52,35,175,1,'10493','','',NULL,0,13,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(494,'MANGUERA 5/8 PESADA TRAMONTINA','',76,35,177,1,'10494','','',NULL,0,13,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(495,'TABLERO PVC 2P/1LLAVE MAGNETICA EMPOT.  KBA','',44,24,59,1,'10495','','',NULL,0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(496,'TABLERO PVC 6P/3LLAVE MAGNETICA EMPOT.  KBA','',44,24,59,1,'10496','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(497,'TOMACORRIENTE SIMPLE P/SOBREPONER- HOME LIGHT','',68,44,142,1,'10497','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(499,'INTERRUPTOR DOBLE P/EMPOTRAR HOME LIGHT','',68,44,140,1,'10499','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(500,'ANILLO P/TUBO ALCANTARILLADO 110MM NICOLL','',42,24,61,1,'10500','','',NULL,0,5,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(501,'ALAMBRE PUAX200MT ANDINO PLUS PRODAC','',17,35,33,1,'10501','','',NULL,0,11,1,7,NULL,'',0,0,NULL,1,0,0,0,0),(502,'ALAMBRE PUAX200MT MOTO PRODAC','',17,16,33,1,'10502','','',NULL,0,11,1,10,NULL,'',0,0,NULL,1,0,0,0,0),(503,'TEE PVC ALCAN.110MMX110MM UF NICOLL','',42,24,99,1,'10503','','',NULL,0,5,1,0.7,NULL,'',0,0,NULL,1,0,0,0,0),(504,'CODO PVC ALCAN. 110MMX90 UF NICOLL','',42,24,97,1,'10504','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(505,'CONO PVC NARANJA 28 plg 5LB CLUTE','',36,24,164,1,'10505','','',NULL,0,5,1,2.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(506,'RASTRILLO S/M 16D TRAMONTINA','',76,36,132,1,'10506','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(507,'TUBO PVC AG C10 SP 1.1/2X5MT NICOLL','',42,24,82,1,'10507','','',NULL,0,5,1,2.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(508,'TUBO PVC AG C10 SP 2X5MT NICOLL','',42,24,82,1,'10508','','',NULL,0,5,1,4.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(510,'UNION MIXTA PVC AG 1/2 NICOLL','',42,24,116,1,'10510','','',NULL,0,5,1,0.024,NULL,'',0,0,NULL,1,0,0,0,0),(511,'YEE PVC SAL 3X3 NICOLL','',42,24,108,1,'10511','','',NULL,0,5,1,0.23,NULL,NULL,0,0,NULL,1,0,0,0,0),(521,'TEE SANITARIA PVC SAL 4 NICOLL','',42,24,89,1,'10521','','',NULL,0,5,1,0.56,NULL,NULL,0,0,NULL,1,0,0,0,0),(522,'TUBO PVC AG C7.5 SP 1.1/2X5MT NICOLL','',42,26,82,1,'10522','','','',0,5,1,1.97,NULL,NULL,0,0,NULL,1,0,0,0,0),(523,'TUBO PVC AG C 7.5  SP 1.1/2X5MT NICOLL','',42,24,82,1,'10523','','','',0,5,1,1.97,NULL,'',0,0,NULL,1,0,0,0,0),(524,'TUBO PVC AG C7.5 SP 2X5MT NICOLL','',42,26,82,1,'10524','','',NULL,0,5,1,2.94,NULL,NULL,0,0,NULL,1,0,0,0,0),(525,'TUBO PVC AG C7.5 SP 2.1/2X5MT PLASTICA','',14,24,81,1,'10525','','',NULL,0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(526,'TUBO PVC ISO ALCA C-4/S-25 110MM UFX6MT NICOLL','',42,26,92,1,'10526','','',NULL,0,5,1,7,NULL,'',0,0,NULL,1,0,0,0,0),(527,'TUBO PVC ISO ALCA C-4/S-25 160MM UFX6MT NICOLL','',42,24,92,1,'10527','','',NULL,0,5,1,14.4,NULL,'',0,0,NULL,1,0,0,0,0),(528,'COMBA OCTAG. 4 LBS C/MANGO TRUPER','',28,24,53,1,'10528','','',NULL,0,5,1,3.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(529,'BADILEJO P/ALBAÑIL DE 6¨PRETUL','',41,24,152,1,'10529','','',NULL,0,5,1,1.36,NULL,'',0,0,NULL,1,0,0,0,0),(530,'MANGUERA NIVEL 1/4-INDUS-TRUPER','',28,35,178,1,'10530','','',NULL,0,13,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(531,'COMBA OCTAG. 3 LBS C/MANGO TRUPER','',28,24,53,1,'10531','','',NULL,0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(532,'GATA HIDRAULICA 32TON-TRUPER ','',28,24,165,1,'10532','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(533,'TIRALINEAS PLASTICO 30M - TRUPER','',28,24,166,1,'10533','','',NULL,0,5,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(534,'ESCALERA DE TIJERA TIPO III- F/VIDRIO TRUPER','',28,24,167,1,'10534','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(535,'LENTE DE SEGURIDAD- GRIS- PRETUL','',41,43,68,1,'10535','','',NULL,0,5,1,0.03,NULL,'',0,0,NULL,1,0,0,0,0),(536,'TIJERA PARA HOJALATERO 8¨- TRUPER','',28,48,168,1,'10536','','',NULL,0,5,1,0.35,NULL,'',0,0,NULL,1,0,0,0,0),(537,'ESPATULAS 4¨ FLEXIBLE, PRETUL ','',41,43,169,0,'10537','','','',0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(538,'LENTE DE SEGURIDAD- TRANSP- PRETUL','',41,43,68,1,'10538','','',NULL,0,5,1,0.03,NULL,'',0,0,NULL,1,0,0,0,0),(539,'ESPATULA MANGO DE MADERA 3¨¨-TRUPER','',28,43,169,1,'10539','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(540,'ALICATE UNIVERSAL PROFES. 7¨-TRUPER','',28,43,136,1,'10540','','',NULL,0,5,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(541,'ESPATULA MANGO DE PLASTICO  3¨-PRETUL','',41,43,169,0,'10541','','','',0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(542,'DISCO DE DIAMANTE P/ CERAMICO-TRUPER','',28,49,107,1,'10542','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(543,'CUTTER 6- TRUPER','',28,42,104,1,'10543','','',NULL,0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(544,'FOCO AHORR.  ESPIRAL 18W LUZ BLANCA PHELIX','',77,24,144,0,'10544','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(545,'FOCO AHORR.  ESPIRAL 36W LUZ BLANCA PHELIX','',77,24,144,0,'10545','','','',0,5,1,1.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(546,'FOCO AHORR.  ESPIRAL 42W LUZ BLANCA PHELIX','',77,24,144,0,'10546','','','',0,5,1,0.12,NULL,NULL,0,0,NULL,1,0,0,0,0),(547,'FOCO AHORR.  ESPIRAL 85W LUZ BLANCA PHELIX','',77,24,144,1,'10547','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(548,'LLAVE DUCHA CROMADA VAINSA','',79,24,146,1,'10548','','',NULL,0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(549,'LLAVE DUCHA ACRILICA VAINSA','',79,24,146,1,'10549','','',NULL,0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(550,'TABLERO PVC 2P/1LLAVES C/RIEL XACE','',143,24,59,1,'10550','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(551,'TABLERO PVC 4P/2LLAVES C/RIEL SERVICPLAST','',80,24,59,1,'10551','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(552,'TABLERO PVC 6P/3LLAVES C/RIEL SERVICPLAS','',80,24,59,1,'10552','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(553,'TABLERO PVC 8P/4LLAVES C/RIEL SERVICPLAST','',80,24,59,1,'10553','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(554,'TOMACORRIENTE DOBLE P/EMPOT AP1212 BTICINO','',81,62,142,1,'10554','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(555,'TOMACORRIENTE SIMPLE P/EMPOT AP1112 BTICINO','',81,24,142,1,'10555','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(556,'INTERRUPTOR SIMPLE C/MUT P/EMPOT AP1101 BTICINO','',81,24,140,1,'10556','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(557,'INTERRUPTOR DOBLE C/MUT P/EMPOTAP 1201 BTICINO','',81,24,140,1,'10557','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(558,'INTERRUPTOR DOBLE P/EMPOT. AP1200 BTICINO','',81,24,140,1,'10558','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(559,'INTERRUPTOR SIMPLE P/SOBREPONER HOME LIGTH','',68,44,140,1,'10559','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(560,'ENCHUFE NEGRO PLANO HOME LIGHT','',68,24,170,1,'10560','','',NULL,0,5,1,0.012,NULL,NULL,0,0,NULL,1,0,0,0,0),(561,'TAPON HEMBRA 1/2 MATUSITA','',61,82,47,1,'10561','','',NULL,0,5,1,0.01,NULL,'',0,0,NULL,1,0,0,0,0),(562,'CALAMINA 0.22 X 3.60 PRODAC','',17,24,350,1,'10562','','','',0,5,1,5.6,NULL,NULL,0,0,NULL,1,0,0,0,0),(563,'TUBO PVC SAL 4X3MT FORDUIT','',82,26,171,1,'10563','','',NULL,0,5,1,2.42,NULL,NULL,0,0,NULL,1,0,0,0,0),(564,'UNION UNIVERSAL PVC 1/2 NICOLL','',42,94,172,1,'10564','','',NULL,0,5,1,0.29,NULL,'',0,0,NULL,1,0,0,0,0),(565,'VALVULA CHECK BRONCE 1/2 VENICE','',83,36,173,1,'10565','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(566,'BROCHA C/M PLASTICO 6 plg PRETUL','',41,24,156,1,'10566','','',NULL,0,5,1,0.12,NULL,'',0,0,NULL,1,0,0,0,0),(567,'BROCHA C/M PLASTICO 6 plg TRUPER','',28,24,156,1,'10567','','',NULL,0,5,1,0.12,NULL,'',0,0,NULL,1,0,0,0,0),(568,'CINTA EMPAQUE TRANSP. 150MT TRUPER','',28,24,78,1,'10568','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(569,'CINTA EMPAQUE TRANSP. 50MT TRUPER','',28,24,78,1,'10569','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(570,'CINTA AISL. NEGRA 18MT TRUPER','',28,26,35,0,'10570','','','',0,5,1,0.012,NULL,NULL,0,0,NULL,1,0,0,0,0),(571,'CINTA AISL. ROJA 18MT TRUPER','',28,26,35,1,'10571','','',NULL,0,5,1,0.012,NULL,NULL,0,0,NULL,1,0,0,0,0),(572,'MANGUERA POLITILENO 32MM(1 plg) PN 8 C/LINEA X 100MTS','',52,35,176,1,'10572','','',NULL,0,13,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(573,'MANTA ARPILLERA 2X200 MT NEGRO ND','',36,50,180,1,'10573','','',NULL,0,13,1,30,NULL,NULL,0,0,NULL,1,0,0,0,0),(574,'MALLA RASCHEL 80% NEGRO/VERDE PRODAC','',17,35,179,0,'10574','','','',0,13,1,11.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(575,'MALLA RASCHEL 80% VERDE PRODAC','',17,35,179,0,'10575','','','',0,13,1,11.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(576,'MALLA RASCHEL 65% SOMBRA VERDE PRODAC','',17,35,179,0,'10576','','','',0,13,1,11.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(577,'MALLA RASCHEL 90% SOMBRA /VERDE PRODAC','',17,35,179,1,'10577','','',NULL,0,13,1,12.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(578,'MALLA RASCHEL 95% NEGRO/VERDE PRODAC','',17,35,179,0,'10578','','','',0,13,1,12.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(579,'LIJA DE AGUA N°60 ABRACOL','',84,24,182,1,'10579','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(580,'LIJA DE AGUA N°80 ABRACOL','',84,24,182,1,'10580','','',NULL,0,5,1,0.012,NULL,NULL,0,0,NULL,1,0,0,0,0),(581,'LIJA DE AGUA N°100 KLINGSPOR','',197,24,182,1,'10581','','',NULL,0,5,1,0.012,NULL,'',0,0,NULL,1,0,0,0,0),(582,'LIJA DE AGUA N°120 KLINGSPOR','',197,24,182,1,'10582','','',NULL,0,5,1,0.012,NULL,'',0,0,NULL,1,0,0,0,0),(583,'LIJA DE AGUA N°150 KLINGSPOR','',197,24,182,1,'10583','','',NULL,0,5,1,0.012,NULL,'',0,0,NULL,1,0,0,0,0),(584,'LIJA DE AGUA N°180 KLINGSPOR','',197,24,182,1,'10584','','',NULL,0,5,1,0.012,NULL,'',0,0,NULL,1,0,0,0,0),(585,'LIJA DE AGUA N°220 ABRACOL','',84,24,182,1,'10585','','',NULL,0,5,1,0.012,NULL,NULL,0,0,NULL,1,0,0,0,0),(586,'LIJA DE AGUA N°240 ABRACOL','',84,24,182,1,'10586','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(587,'LIJA DE AGUA N°280 ABRACOL','',84,24,182,1,'10587','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(588,'LIJA DE AGUA N°320 ABRACOL','',84,24,182,1,'10588','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(589,'LIJA DE AGUA N°360 ABRACOL','',84,24,182,1,'10589','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(590,'LIJA DE AGUA N°400 ABRACOL','',84,24,182,1,'10590','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(591,'LIJA DE AGUA N°600 ABRACOL','',84,24,182,1,'10591','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(592,'LIJA DE AGUA N°1000 ABRACOL','',84,24,182,1,'10592','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(593,'LIJA DE AGUA N°1200 ABRACOL','',84,24,182,1,'10593','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(594,'LIJA DE AGUA N°1500 ABRACOL','',84,24,182,1,'10594','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(595,'LIJA DE AGUA N°2000 ABRACOL','',84,24,182,1,'10595','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(596,'LIJA DE AGUA N°2500 ABRACOL','',84,24,182,1,'10596','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(597,'LIJA DE AGUA OMEGA N°100 ABRACOL','',84,24,183,1,'10597','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(598,'LIJA DE AGUA OMEGA N°120 ABRACOL','',84,24,183,1,'10598','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(599,'LIJA DE AGUA OMEGA N°150 ABRACOL','',84,24,183,1,'10599','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(600,'LIJA DE AGUA OMEGA N°180 ABRACOL','',84,24,183,1,'10600','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(601,'LIJA DE AGUA OMEGA N°220 ABRACOL','',84,24,183,1,'10601','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(602,'LIJA DE AGUA OMEGA N°240 ABRACOL','',84,24,183,1,'10602','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(603,'LIJA DE AGUA OMEGA N°280 ABRACOL','',84,24,183,1,'10603','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(604,'LIJA DE AGUA OMEGA N°320 ABRACOL','',84,24,183,1,'10604','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(605,'LIJA DE AGUA OMEGA N°360 ABRACOL','',84,24,183,1,'10605','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(606,'LIJA DE AGUA OMEGA N°400 ABRACOL','',84,24,183,1,'10606','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(607,'LIJA DE AGUA OMEGA N°600 ABRACOL','',84,24,183,1,'10607','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(608,'LIJA ABRA-PLUS-BLUE N°80 ABRACOL','',84,24,184,1,'10608','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(609,'LIJA ABRA-PLUS-BLUE N°150 ABRACOL','',84,24,184,1,'10609','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(610,'LIJA ABRA-PLUS-BLUE N°240 ABRACOL','',84,24,184,1,'10610','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(611,'LIJA ABRA-PLUS-BLUE N°280 ABRACOL','',84,24,184,1,'10611','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(612,'LIJA ABRA-PLUS-BLUE N°400 ABRACOL','',84,24,184,1,'10612','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(613,'LIJA  DE FIERRO N°30 ABRACOL','',84,24,185,1,'10613','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(614,'LIJA  DE FIERRO N°40 KLINGSPOR','',197,24,185,1,'10614','','',NULL,0,5,1,0.01,NULL,'',0,0,NULL,1,0,0,0,0),(615,'LIJA  DE FIERRO N°120 KLINGSPOR','',197,24,185,1,'10615','','',NULL,0,5,1,0.01,NULL,'',0,0,NULL,1,0,0,0,0),(616,'DISCO CORTE METAL INOX 4.1/2X1.0MM ABRACOL','',84,51,186,1,'10616','','',NULL,0,5,1,0.015,NULL,NULL,0,0,NULL,1,0,0,0,0),(617,'DISCO CORTE METAL FINO 4.1/2 X 1.0MM ABRACOL','',84,52,186,1,'10617','','',NULL,0,5,1,0.015,NULL,NULL,0,0,NULL,1,0,0,0,0),(618,'LIJA  DE FIERRO N°60 KLINGSPOR','',197,24,185,1,'10618','','',NULL,0,5,1,0.01,NULL,'',0,0,NULL,1,0,0,0,0),(619,'DISCO CORTE METAL INOX 7 plg X 1.6MM ABRACOL','',84,24,186,1,'10619','','',NULL,0,5,1,0.18,NULL,NULL,0,0,NULL,1,0,0,0,0),(620,'DISCO CORTE METAL FINO 7 plg X 1.6MM ABRACOL','',84,24,186,1,'10620','','',NULL,0,5,1,0.18,NULL,NULL,0,0,NULL,1,0,0,0,0),(621,'DISCO DIAMANTADO CONTINUO 4.1/2 ABRACOL','',84,24,187,1,'10621','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(622,'DISCO DIAMANTADO SEGMENTADO 7 plg ABRACOL','',84,24,187,1,'10622','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(623,'LIJA  DE FIERRO N°100 KLINGSPOR','',197,24,185,1,'10623','','','',0,5,1,0.01,NULL,'',0,0,NULL,1,0,0,0,0),(624,'LIJA  DE FIERRO N°150 KLINGSPOR','',197,24,185,1,'10624','','',NULL,0,5,1,0.01,NULL,'',0,0,NULL,1,0,0,0,0),(625,'DISCO DIAMANTADO OMEGA TURBO 4.1/2 ABRACOL','',84,24,187,1,'10625','','',NULL,0,5,1,0.52,NULL,NULL,0,0,NULL,1,0,0,0,0),(626,'LIJA  DE FIERRO N°180 KLINGSPOR','',197,24,185,1,'10626','','',NULL,0,5,1,0.01,NULL,'',0,0,NULL,1,0,0,0,0),(627,'DISCO TRONZADORA 14 plgX1/8 X 1 A 30T KLINGSPOR','',197,24,188,1,'10627','','',NULL,0,5,1,0.85,NULL,NULL,0,0,NULL,1,0,0,0,0),(628,'TELA ESMERIL MULTI FLEX 8 plg N°120 ABRACOL','',84,53,189,1,'10628','','',NULL,0,13,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(629,'TELA ESMERIL MULTI FLEX 12 plg N°60 ABRACOL','',84,53,189,1,'10629','','',NULL,0,13,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(630,'TELA ESMERIL MULTI FLEX 12 plg N°80 ABRACOL','',84,53,189,1,'10630','','',NULL,0,13,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(631,'TELA ESMERIL MULTI FLEX 12 plg N°150 ABRACOL','',84,53,189,1,'10631','','',NULL,0,13,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(632,'TELA ESMERIL MULTI FLEX 24 plg N°60 ABRACOL','',84,53,189,1,'10632','','',NULL,0,13,1,0.56,NULL,NULL,0,0,NULL,1,0,0,0,0),(633,'CHAPA MASTER 21 DER GRIS- IDEACE GATO ','',85,24,190,1,'10633','','',NULL,0,5,1,0.7,NULL,NULL,0,0,NULL,1,0,0,0,0),(634,'RUEDA ESMERIL GRIS (A) 6 plgX3/4 N° 24 ABRACOL','',84,24,191,1,'10634','','',NULL,0,5,1,1.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(635,'RUEDA ESMERIL GRIS (A) 6 plgX3/4 N° 60 ABRACOL','',84,24,191,1,'10635','','',NULL,0,5,1,1.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(636,'RUEDA ESMERIL GRIS (A) 6 plgX1 N° 24 ABRACOL','',84,24,191,1,'10636','','',NULL,0,5,1,1.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(637,'CHAPA MASTER 64 DER GRIS- IDEACE GATO ','',85,24,190,1,'10637','','',NULL,0,5,1,0.7,NULL,NULL,0,0,NULL,1,0,0,0,0),(638,'RUEDA ESMERIL GRIS (A) 6 plgX1 N° 60 ABRACOL','',84,24,191,1,'10638','','',NULL,0,5,1,1.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(639,'RUEDA ESMERIL BLANCO (AA) 6 plgX1 N° 60 ABRACOL','',84,24,191,1,'10639','','',NULL,0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(640,'RUEDA ESMERIL BLANCO (AA) 6 plgX3/4 N° 60 ABRACOL','',84,24,191,1,'10640','','',NULL,0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(641,'CHAPA FORTALEZA BRONCE- IDEACE GATO ','',85,24,190,1,'10641','','',NULL,0,5,1,0.7,NULL,NULL,0,0,NULL,1,0,0,0,0),(642,'CHAPA BLINDADA 868 DER VA- IDEACE GATO ','',85,24,190,1,'10642','','',NULL,0,5,1,0.7,NULL,NULL,0,0,NULL,1,0,0,0,0),(643,'CHAPA CANDADO PUERTA CORREDIZA- IDEACE GATO ','',85,24,190,1,'10643','','',NULL,0,5,1,0.7,NULL,NULL,0,0,NULL,1,0,0,0,0),(644,'CANDADO DE LATON 30MM-IDEACE GATO','',85,24,192,1,'10644','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(645,'CANDADO DE LATON 40MM-IDEACE GATO','',85,24,192,1,'10645','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(646,'CANDADO DE LATON TIPO BARRIL 40MM-IDEACE GATO','',85,24,192,1,'10646','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(647,'CANDADO DE LATON TIPO BARRIL 50MM-IDEACE GATO','',85,24,192,1,'10647','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(648,'CANDADO DE LATON TIPO BARRIL 60MM-IDEACE GATO','',85,24,192,1,'10648','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(649,'BIODIGESTOR 750 LT C/ACC NICOLL','',42,24,193,1,'10649','','',NULL,0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(650,'CALAMINA TRANS. 1.80X0.84X 1.75MM FIBRAFORTE','',33,24,72,1,'10650','','','',0,5,1,2.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(651,'PALANA CUCHARA M/MADERA TRAMONTINA','',76,24,25,0,'10651','','','',0,5,1,1.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(652,'PICO A/P CON MANGO','',26,24,26,1,'10652','','',NULL,0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(653,'CLAVO CALAMINERO 2X9 C/JEBE PRODAC','',17,18,29,0,'10653','','','',0,3,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(654,'PALANA DERECHA M/ PLAST TRAMONTINA','',76,24,25,0,'10654','','','',0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(655,'PALANA DERECHA F/BLANCO CASCO','',93,24,25,0,'10655','','','',0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(656,'BOTA JEBE T/39 XTREME','',214,24,194,1,'10656','','',NULL,0,19,1,0.5,NULL,'',0,0,NULL,1,0,0,0,0),(657,'BOTA JEBE T/40 PEGASUS','',86,24,194,0,'10657','','','',0,19,1,2,NULL,NULL,0,0,NULL,1,0,0,0,0),(658,'BOTA JEBE T/41 XTREME','',214,24,194,1,'10658','','',NULL,0,19,1,2,NULL,'',0,0,NULL,1,0,0,0,0),(659,'PEGAMENTO REG. CPVC1/32GL(4ONZ) OATEY','',24,24,23,1,'10659','','',NULL,0,5,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(660,'TUBO PVC SAL 2X3MT FORDUIT','',82,24,171,1,'10660','','',NULL,0,5,1,1.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(661,'TUBO PVC AG C.10 1/2X5MT FORDUIT','',82,24,195,1,'10661','','',NULL,0,5,1,0.6,NULL,'',0,0,NULL,1,0,0,0,0),(662,'ACERO CORRUGADO fy=4200 Kg/cm GRADO 60 SIDERPERU','',13,19,15,1,'10662','','',NULL,0,3,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(663,'FOCO AHOR/T ESPIRAL 36W LUZ DIA TOP LIGHT','',67,37,144,0,'10663','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(664,'FOCO AHOR/T ESPIRAL 42W LUZ DIA TOP LIGHT','',67,37,144,0,'10664','','','',0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(665,'FOCO AHOR/T ESPIRAL 85W LUZ DIA TOP LIGHT','',67,37,144,1,'10665','','',NULL,0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(666,'DESARMADOR INTER. 3X60MM SCHUBERT','',25,36,196,1,'10666','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(667,'LLAVE DE PASO CPVC 1/2 P/SOLDAR PCP','',40,36,58,1,'10667','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(668,'TAPON CPVC 1/2 S/PRES. HEMBRA MAT-TIGRE','',61,5,47,1,'10668','','',NULL,0,5,1,0.005,NULL,'',0,0,NULL,1,0,0,0,0),(669,'ASPERSOR CIRCULAR 1/2 N°14 PCP','',40,44,66,1,'10669','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(670,'CASCO SEGURIDAD NARANJA SEGUSA','',87,25,63,1,'10670','','',NULL,0,5,1,0.5,NULL,'',0,0,NULL,1,0,0,0,0),(671,'CASCO SEGURIDAD ROJO SEGUSA','',87,25,63,1,'10671','','',NULL,0,5,1,0.5,NULL,'',0,0,NULL,1,0,0,0,0),(672,'ASPERSOR PLASTICO DOS VIAS-TRUPER','',28,24,66,1,'10672','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(673,'ASPERSOR PLAST-AMARILLO- DOS VIAS-PRETUL','',41,24,66,1,'10673','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(674,'ASPERSOR PLASTICO GIRATORIO-PRETUL','',41,24,66,1,'10674','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(675,'ASPERSOR PLAST-VERDE- DOS VIAS-PRETUL','',41,24,66,1,'10675','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(676,'MARTILLO CABEZA CONICA 25MM TRUPER','',28,24,130,1,'10676','','',NULL,0,5,1,0.6,NULL,'',0,0,NULL,1,0,0,0,0),(677,'CAJA P/AGUA CONCYSSA','',65,24,114,1,'10677','','',NULL,0,5,1,10,NULL,NULL,0,0,NULL,1,0,0,0,0),(678,'BIODIGESTOR 1600 LT C/ACC ETERNIT','',63,24,193,1,'10678','','',NULL,0,5,1,30,NULL,'',0,0,NULL,1,0,0,0,0),(679,'CAPOTIN M/LARGA ND','',36,24,197,1,'10679','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(680,'PONCHO DE AGUA PVC VERDE CLUTE','',114,24,198,1,'10680','','',NULL,0,5,1,0.2,NULL,'',0,0,NULL,1,0,0,0,0),(681,'CODO CPVC AQUAT ASTM 1/2 x 45PLAST','',48,24,98,1,'10681','','',NULL,0,5,1,0.01,NULL,'',0,0,NULL,1,0,0,0,0),(682,'UNION UNIVERSAL CPVC 1/2 PLASTICA','',48,24,172,1,'10682','','',NULL,0,5,1,0.01,NULL,'',0,0,NULL,1,0,0,0,0),(683,'TUBO CPVC AQUATHERM ASTM 3/4 PLAST','',48,24,93,1,'10683','','',NULL,0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(684,'CODO CPVC AQUAT ASTM 3/4 x 90PLAST','',48,24,98,1,'10684','','',NULL,0,5,1,0.002,NULL,NULL,0,0,NULL,1,0,0,0,0),(685,'CODO CPVC AQUAT ASTM 3/4 x 45PLAST','',48,24,98,1,'10685','','',NULL,0,5,1,0.02,NULL,NULL,0,0,NULL,1,0,0,0,0),(686,'TEE CPVC AQUATH ASTM 3/4 NICOLL','',42,24,100,1,'10686','','',NULL,0,5,1,0.03,NULL,'',0,0,NULL,1,0,0,0,0),(687,'UNION CPVC SIMPLE 3/4 PLASTICA ','',48,24,44,1,'10687','','',NULL,0,5,1,0.002,NULL,NULL,0,0,NULL,1,0,0,0,0),(688,'ADAPTADOR CPVC UPR  3/4 PLASTICA','',48,24,43,1,'10688','','',NULL,0,5,1,0.02,NULL,'',0,0,NULL,1,0,0,0,0),(689,'UNION UNIVERSAL CPVC 3/4 PLASTICA','',48,24,172,1,'10689','','',NULL,0,5,1,0.02,NULL,'',0,0,NULL,1,0,0,0,0),(690,'CACHIMBA COMPLETA PVC 200MMX160MM ND','',42,24,57,1,'10690','','',NULL,0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(691,'TUBO PVC ISO ALCA C-4/S-25 200MM UFX6MT NICOLL','',42,24,92,1,'10691','','',NULL,0,5,1,22,NULL,'',0,0,NULL,1,0,0,0,0),(692,'AFIRMADO DE CANTERA','',36,38,199,1,'10692','','','',0,16,1,1200,NULL,NULL,0,0,NULL,1,0,0,0,0),(693,'TEE PVC 3/4 AG SP NICOLL','',42,85,91,1,'10693','','',NULL,0,5,1,0.02,NULL,NULL,0,0,NULL,1,0,0,0,0),(694,'TEE PVC 1 AG SP NICOLL','',42,24,91,1,'10694','','',NULL,0,5,1,0.098,NULL,'',0,0,NULL,1,0,0,0,0),(695,'CODO PVC AG SP 1.1/2X90° NICOLL','',42,95,87,1,'10695','','',NULL,0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(696,'CODO PVC AG SP 2X90° NICOLL','',42,86,87,1,'10696','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(697,'CODO PVC AG SP 3/4x90° NICOLL','',42,84,87,1,'10697','','',NULL,0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(699,'TEE PVC AG 1.1/2 NICOLL','',42,24,91,1,'10699','','',NULL,0,5,1,0.161,NULL,'',0,0,NULL,1,0,0,0,0),(700,'TEE PVC AG 2 NICOLL','',42,62,91,1,'10700','','',NULL,0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(701,'CODO PVC AG MIXTO C-10 1/2 NICOLL','',42,24,87,1,'10701','','',NULL,0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(703,'UNION SIMPLE PVC AG 1/2 NICOLL','',42,24,116,1,'10703','','',NULL,0,5,1,0.015,NULL,NULL,0,0,NULL,1,0,0,0,0),(704,'UNION MIXTA PVC 3/4 NICOLL','',42,24,116,1,'10704','','',NULL,0,5,1,0.019,NULL,NULL,0,0,NULL,1,0,0,0,0),(705,'TAPON PVC PRES AG 1/2 NICOLL','',42,24,112,1,'10705','','',NULL,0,5,1,0.01,NULL,'',0,0,NULL,1,0,0,0,0),(706,'CODO PVC AG SP 1 x90° NICOLL','',42,24,87,1,'10706','','',NULL,0,5,1,0.086,NULL,NULL,0,0,NULL,1,0,0,0,0),(707,'DISCO DESBASTE METAL OMEGA 4 1/2 x 1/4 plg ABRACOL','',84,24,186,1,'10707','','',NULL,0,5,1,0.001,NULL,NULL,0,0,NULL,1,0,0,0,0),(708,'DISCO DESBASTE INOX 4 1/2 x 1/4 plg ABRACOL','',84,24,107,1,'10708','','',NULL,0,5,1,0.001,NULL,NULL,0,0,NULL,1,0,0,0,0),(709,'DISCO DESBASTE METAL 7 x 1/4 plg ABRACOL','',84,24,186,1,'10709','','',NULL,0,5,1,0.4,NULL,'',0,0,NULL,1,0,0,0,0),(710,'TUBO PVC SEL SAP 1X3MT PLASTICA','',48,26,83,1,'10710','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(711,'TUBO PVC AG C10 SP 2.1/2X5MT NICOLL','',42,26,82,1,'10711','','',NULL,0,5,1,6,NULL,'',0,0,NULL,1,0,0,0,0),(712,'GUANTE LATEX P/LIMPIEZA TRUPER','',28,42,374,1,'10712','','',NULL,0,19,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(713,'MOPAS BLANCAS DE LANA- ABRACOL','',84,24,200,1,'10713','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(714,'BOTA JEBE T/42 XTREME','',214,24,194,1,'10714','','',NULL,0,19,1,0.5,NULL,'',0,0,NULL,1,0,0,0,0),(715,'CODO PVC SAL 3X90° NICOLL','',42,24,85,1,'10715','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(716,'LADRILLO KING KONG STANDAR CERAM. SOL DEL NORTE','',19,24,313,1,'10716','','',NULL,0,5,1,2.8,NULL,'',0,0,NULL,1,0,0,0,0),(717,'REEMBOLSO','',36,24,201,1,'10717','','',NULL,0,5,1,0,NULL,'',0,0,NULL,1,1,0,0,0),(718,'ALAMBRE RECOCIDO N°16 COMFER','',88,16,215,1,'10718','','',NULL,0,3,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(719,'ALAMBRE RECOCIDO N°08 COMFER','',88,16,215,1,'10719','','',NULL,0,3,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(720,'UNION REPARACION PVC 200MM NICOLL','',42,24,202,1,'10720','','',NULL,0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(721,'CODO PVC ALCAN. 110MMX45 P/CACHIMBA UF NICOLL','',42,24,97,1,'10721','','',NULL,0,5,1,0.5,NULL,'',0,0,NULL,1,0,0,0,0),(722,'CODO PVC ALCA. ISO 160MMX90° UF NICOLL','',42,24,97,1,'10722','','',NULL,0,5,1,2,NULL,NULL,0,0,NULL,1,0,0,0,0),(723,'CODO PVC ALCA. ISO 160MMX45° UF NICOLL','',42,24,97,1,'10723','','',NULL,0,5,1,2,NULL,NULL,0,0,NULL,1,0,0,0,0),(724,'UNION REPARACION PVC 160MM UF NICOLL','',42,24,202,1,'10724','','',NULL,0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(725,'TOMACORRIENTE TRIPLE P/SOBREPONER-HOME LIGHT','',68,36,142,1,'10725','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(726,'INTERRUPTOR SIMPLE P/EMPOTRAR-HOME LIGTH ','',68,36,140,1,'10726','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(727,'INTERRUPTOR SIMPLE C/MUT P/EMP 3 VIAS- HOME LIGHT','',68,36,140,1,'10727','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(728,'TOMACORRIENTE SIMPLE P/EMPOTRAR- HOME LIGHT','',68,36,142,1,'10728','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(729,'INTERRUPTOR DOBLE C/MUT P/EMP 4 VIAS- HOME LIGHT','',68,36,140,1,'10729','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(730,'SALIDA PARA CABLE-HOME LIGHT','',68,36,203,1,'10730','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(731,'SOCATE P/EMPOTRAR MOD.OVAL- HOME LIGHT','',68,36,143,1,'10731','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(733,'FOCO AHOR/ ESPIRAL-27W- HOME LIGTH','',68,24,144,0,'10733','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(734,'FOCO AHOR/ ESPIRAL-45W- HOME LIGTH','',68,24,144,1,'10734','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(735,'INTERRUPTOR COLGANTE - HOME LIGHT','',68,36,140,1,'10735','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(736,'FOCO AHOR/ESPIRAL-85W-HOME LIGHT','',68,24,144,0,'10736','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(737,'FOCO AHOR/ ESPIRAL-36W- HOME LIGTH','',68,24,144,1,'10737','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(738,'TOMACORRIENTE DOBLE P/EMPOT C/SALIDA A TIERRA- HOME LIGHT','',68,36,142,1,'10738','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(739,'UNION SIMPLE PVC 3/4 NICOLL','',42,24,116,1,'10739','','',NULL,0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(740,'UNION SIMPLE PVC 1 NICOLL','',42,81,116,1,'10740','','',NULL,0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(741,'GUANTE DE ALGODON CON PTO PVC PRETUL','',41,44,62,1,'10741','','',NULL,0,19,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(742,'FOCO AHOR/ 3U-36W-HOME LIGHT','',68,24,144,0,'10742','','','',0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(743,'ADAPTADOR UNIVERSAL C/SALIDA TIERRA HOME LIGTH','',68,24,205,1,'10743','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(744,'FLUORESCENTE LED CIRCULAR 20W E27 - HOME LIGTH','',68,24,206,1,'10744','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(745,'CUCHILLA TERMOMAG. KG RIEL DIN 2P 20A G.E.','',89,24,207,1,'10745','','',NULL,0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(746,'CUCHILLA TERMOMAG. KG RIEL DIN 2P 32A G.E.','',89,24,207,1,'10746','','',NULL,0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(747,'CUCHILLA TERMOMAG. KG RIEL DIN 2P 40A G.E.','',89,24,207,1,'10747','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(748,'EXTENSION C/3 TOMAS C/FOCO D/NEON 5MT HOME-LIGHT','',68,24,208,1,'10748','','',NULL,0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(749,'GUANTE JEBE CALIBRE 35 T-9 MASTER','',90,24,209,1,'10749','','',NULL,0,19,1,0.2,NULL,'',0,0,NULL,1,0,0,0,0),(750,'TUBO PVC AG C.10 75MM UF NICOLL','',42,24,82,1,'10750','','',NULL,0,5,1,8,NULL,NULL,0,0,NULL,1,0,0,0,0),(751,'ANILLO P/TUBO AG 75MM NICOLL','',42,24,61,1,'10751','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(752,'HORMIGON DE RIO','',36,38,71,1,'10752','','',NULL,0,16,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(753,'MASCARILLA ANTI POLVO','',36,24,210,1,'10753','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(754,'TEE 1/2 GALVANIZADO ND','',36,24,211,1,'10754','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(755,'CINCEL PUNTA EXAGONAL ND','',36,24,212,1,'10755','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(756,'CINCEL PUNTA PLANA ND','',36,24,212,1,'10756','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(757,'PLASTICO 0.80 AZUL X KILOGRAMO ND','',36,101,137,1,'10757','','',NULL,0,3,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(758,'TAPON HEMBRA CON ROSCA 1/2 NICOLL','',42,24,112,1,'10758','','',NULL,0,5,1,0.01,NULL,'',0,0,NULL,1,0,0,0,0),(759,'TEE CPVC AQUATH 1/2 NICOLL','',42,24,100,1,'10759','','',NULL,0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(760,'TUBO CPVC AQUATHERM 1/2 NICOLL','',42,24,93,1,'10760','','',NULL,0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(761,'TEE PVC SAL 3X3 NICOLL','',42,24,89,1,'10761','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(762,'CODO PVC SAL 3X45° NICOLL','',42,24,85,1,'10762','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(763,'CACHIMBA PVC INY 200MM X 160MM X 45° NICOLL','',42,24,57,1,'10763','','',NULL,0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(764,'TECNOPORT 2.40X1.20X 2 EPS','',23,24,16,1,'10764','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(765,'CLAVO C/C 2X12 COMFER','',88,13,213,1,'10765','','','',0,3,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(766,'CLAVO C/C 2.1/2X10 COMFER','',88,13,213,1,'10766','','','',0,3,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(767,'CLAVO C/C 3X9 COMFER','',88,13,213,1,'10767','','','',0,3,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(768,'CLAVO C/C 4X7 COMFER','',88,13,213,1,'10768','','','',0,3,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(769,'CLAVO C/C 5X6 COMFER','',88,13,213,1,'10769','','','',0,3,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(770,'CLAVO C/C 6X4 COMFER','',88,13,213,1,'10770','','','',0,3,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(771,'CLAVO C/C 7X4 COMFER','',88,13,213,1,'10771','','','',0,3,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(772,'CLAVO C/C 8X2 COMFER','',88,13,213,1,'10772','','','',0,3,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(773,'SOLDADURA 1/8 plg PUNTO AZUL','',91,18,214,1,'10773','','',NULL,0,3,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(774,'SOLDADURA 1/8 plg SUPERCITO','',92,28,214,1,'10774','','',NULL,0,3,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(775,'DISCO DIAMANTADO TURBO 7 plg ABRACOL','',84,24,107,1,'10775','','',NULL,0,5,1,0.35,NULL,'',0,0,NULL,1,0,0,0,0),(776,'DISCO DIAMANTADO CONTINUO 7 plg ABRACOL','',84,24,107,1,'10776','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(777,'TANQUE 2500 LT ARENA ETERNIT','',63,24,105,1,'10777','','',NULL,0,5,1,25,NULL,NULL,0,0,NULL,1,0,0,0,0),(778,'UNION MIXTA PVC AG 1 NICOLL','',42,24,116,1,'10778','','',NULL,0,5,1,0.01,NULL,'',0,0,NULL,1,0,0,0,0),(779,'ADAPTADOR UPR PVC 1 NICOLL','',42,24,125,1,'10779','','',NULL,0,5,1,0.02,NULL,NULL,0,0,NULL,1,0,0,0,0),(780,'TRAMPA PVC 2  CR 3/4 NICOLL','',42,24,38,1,'10780','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(781,'TRAMPA PVC 2 SR - NICOLL','',42,24,38,1,'10781','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(782,'TUBO CPVC AQUATHERM 3/4 NICOLL','',42,24,93,1,'10782','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(783,'DISCO DIAMANTADO SEGMENTADO 4 plg ABRACOL','',84,24,187,1,'10783','','',NULL,0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(784,'RECOGEDOR DE METAL ND','',36,24,216,1,'10784','','',NULL,0,5,1,2,NULL,NULL,0,0,NULL,1,0,0,0,0),(785,'CLAVO C/C 8X4 PRODAC','',17,13,29,1,'10785','','',NULL,0,3,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(786,'WINCHA PROFES. CONTRA IMPACTO 3M TRUPER','',28,24,60,1,'10786','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(787,'WINCHA PROFES. CONTRA IMPACTO 5M TRUPER','',28,24,60,1,'10787','','',NULL,0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(788,'BADILEJO P/ALBAÑIL DE 7¨PRETUL','',41,24,152,1,'10788','','',NULL,0,5,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(789,'LLAVE DIAMANTADA P/CAJA DE AGUA ND','',36,24,217,1,'10789','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(790,'TEE PVC C/R 1 AG SP NICOLL','',42,24,91,1,'10790','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(791,'LLAVE DE PASO DBLE-UNION C/R- PVC 1/2 NICOLL-D','',42,24,58,1,'10791','','',NULL,0,5,1,0.12,NULL,NULL,0,0,NULL,1,0,0,0,0),(792,'LLAVE DE PASO DBLE-UNION C/R- PVC 3/4 NICOLL-D','',42,24,58,1,'10792','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(793,'LLAVE DE PASO DBLE-UNION C/R- PVC 1¨ NICOLL-D','',42,24,58,1,'10793','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(794,'CLAVO CALAMINERO 2X9 C/JEBE PRODAC 2','',17,18,29,0,'10794','','','',0,3,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(795,'LLANTA ARMADA DE CARRETILLA REFORZADA TRUPER','',28,24,12,1,'10795','','',NULL,0,5,1,3,NULL,NULL,0,0,NULL,1,0,0,0,0),(796,'BIODIGESTOR 1300 LT C/ACC ROTOPLAST','',94,24,193,1,'10796','','',NULL,0,5,1,20,NULL,'',0,0,NULL,1,0,0,0,0),(797,'GRUÑA DE CANTO /TRUPER','',28,42,218,1,'10797','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(798,'CINTA PELIGRO / TRUPER','',28,24,65,1,'10798','','',NULL,0,11,1,0.005,NULL,'',0,0,NULL,1,0,0,0,0),(799,'BROCHA C/M PLASTICO 4 plg TRUPER','',28,24,156,1,'10799','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(800,'ALICATE UNIVERSAL 8 plg NICOLL','',42,24,136,1,'10800','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(801,'EXTENSION UNIVERSAL AMARILLO-15 metros/ ECOLUX','',95,24,208,1,'10801','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(802,'EXTENSION-3 metros/ ECOLUX','',95,24,208,1,'10802','','',NULL,0,5,1,0.5,NULL,'',0,0,NULL,1,0,0,0,0),(803,'FOCO LED 5 WATT / FSL','',96,24,219,0,'10803','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(804,'FOCO LED 7 WATT / FSL','',96,24,219,0,'10804','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(805,'FOCO LED 9 WATT / FSL','',96,24,219,1,'10805','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(806,'FOCO LED 13 WATT / FSL','',96,24,219,0,'10806','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(807,'FOCO LED 16 WATT / FSL','',96,24,219,0,'10807','','','',0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(808,'FOCO LED TIPO PLATO 22 WATT / FSL','',96,24,219,1,'10808','','','',0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(809,'FOCO LED DE EMERGENCIA 12W ND','',36,24,334,1,'10809','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(810,'GUANTE ANTICORTE / FERRAWYY','',98,24,62,1,'10810','','',NULL,0,19,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(811,'LLAVE DUCHA ACRILICA RUBINETTO','',36,24,146,1,'10811','','',NULL,0,5,1,0.5,NULL,'',0,0,NULL,1,0,0,0,0),(812,'DISCO CORTE METAL 4.1/2 X 3/64- UYUSTOOLS','',100,24,107,1,'10812','','',NULL,0,5,1,0.005,NULL,NULL,0,0,NULL,1,0,0,0,0),(813,'DISCO CORTE METAL  7 plg - UYUSTOOLS','',100,24,107,1,'10813','','',NULL,0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(814,'DISCO TRONZADORA 14 plg - UYUSTOOLS','',100,24,188,1,'10814','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(815,'DISCO LIJA FLAP- UYUSTOOLS','',100,24,107,0,'10815','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(816,'FOCO LED  SPIRAL 18W - PHELIX ','',77,24,219,1,'10816','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(817,'FOCO LED  SPIRAL 36W - PHELIX ','',77,24,219,0,'10817','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(818,'FOCO LED  SPIRAL 85W - PHELIX ','',77,24,219,1,'10818','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(819,'CALAMINA 0.25X3.60 SIDERPERU','',13,24,318,0,'10819','','','',0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(820,'CALAMINA TRANSPARENTE 3.60 X 0.84 TECHO PLUS','',57,24,72,1,'10820','','',NULL,0,5,1,2.4,NULL,'',0,0,NULL,1,0,0,0,0),(821,'CEMENTO TIPO I USO ESTRUC. QUISQUEYA','',101,10,1,0,'10821','','','',0,8,1,42.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(822,'ARCO DE SIERRA DE SOLERA 12 plg PRETUL','',41,24,134,1,'10822','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(823,'GRUÑA DE CENTRO /TRUPER','',28,42,218,1,'10823','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(824,'TIERRA NEGRA DE CULTIVO ','',36,38,220,1,'10824','','',NULL,0,16,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(825,'DISCO MADERA 4.1/2 X 115MM- HEFESTO','',211,24,221,1,'10825','','',NULL,0,5,1,0.2,NULL,'',0,0,NULL,1,0,0,0,0),(826,'DISCO MADERA 7.1/4 X 180MM- HEFESTO','',211,24,221,1,'10826','','',NULL,0,5,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(827,'FOCO LED 3 WATT / FSL','',96,44,219,1,'10827','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(828,'REDUCCION PVC SAP 3/4x1/2 ROSCA EXT MAT-TIGRE','',61,24,21,1,'10828','','',NULL,0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(829,'RODILLO BLANCO 9 plg TORO','',103,24,155,1,'10829','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(830,'RODILLO BLANCO 12 plg TORO','',103,24,155,1,'10830','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(831,'RODILLO MELON 9 plg TORO','',103,24,155,1,'10831','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(832,'RODILLO MELON 12 plg TORO','',103,24,155,1,'10832','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(833,'ENTENSION TELESCOPICA ALUM. P/ RODILLO','',36,24,222,1,'10833','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(834,'LLAVE DE PASO ROSCADO  1/2 ITALIANA','',105,24,58,1,'10834','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(835,'VALVULA FIV JARDINERA 1/2 STANDAR ITALIANA','',105,24,24,1,'10835','','',NULL,0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(836,'VALVULA FIV-CHECK SWING 1/2 ITALIANA','',105,24,173,1,'10836','','',NULL,0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(837,'VALVULA FIV-CHECK SWING 3/4 ITALIANA','',105,24,173,1,'10837','','',NULL,0,5,1,0.45,NULL,NULL,0,0,NULL,1,0,0,0,0),(838,'BISAGRA FIERRO PES. 4X3 C/T BISA','',106,24,223,1,'10838','','','',0,5,1,0.2,NULL,'',0,0,NULL,1,0,0,0,0),(839,'BISAGRA FIERRO PES. 3.1/2 X 2.1/4 C/T BISA','',106,24,223,1,'10839','','','',0,5,1,0.2,NULL,'',0,0,NULL,1,0,0,0,0),(840,'BISAGRA FIERRO PES. 3 X 2 C/T BISA','',106,24,223,0,'10840','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(841,'BISAGRA ALUM. PES. 3 X 2 C/T BISA','',106,24,223,0,'10841','','','',0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(842,'BISAGRA ALUM. PES. 3.1/2 X 2.1/4 C/T BISA','',106,24,223,0,'10842','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(843,'BISAGRA ALUM. PES. 4 X 3 C/T BISA','',106,24,223,0,'10843','','','',0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(844,'CANDADO BRONCE 30MM BODY GUARD','',107,24,192,1,'10844','','',NULL,0,5,1,0.4,NULL,'',0,0,NULL,1,0,0,0,0),(845,'CANDADO BRONCE 40MM BODY GUARD','',107,24,192,1,'10845','','',NULL,0,5,1,0.45,NULL,'',0,0,NULL,1,0,0,0,0),(846,'CANDADO BRONCE 50MM BODY GUARD','',107,24,192,1,'10846','','',NULL,0,5,1,0.5,NULL,'',0,0,NULL,1,0,0,0,0),(847,'CANDADO BRONCE  60MM STANLEY','',108,24,192,1,'10847','','',NULL,0,5,1,0.6,NULL,'',0,0,NULL,1,0,0,0,0),(848,'DISCO MADERA 7.1/4 40D BOSH','',109,24,221,1,'10848','','',NULL,0,5,1,0.7,NULL,NULL,0,0,NULL,1,0,0,0,0),(849,'DISCO MADERA DIAMAN. P/ AMOL 4.1/2 BOSH','',109,24,221,1,'10849','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(850,'WINCHA TOUGHCASE 3MT/10  - STANLEY','',108,24,60,1,'10850','','',NULL,0,5,1,0.5,NULL,'',0,0,NULL,1,0,0,0,0),(851,'WINCHA TOUGHCASE 5MT/16 FTX19MM - STANLEY','',108,24,60,1,'10851','','',NULL,0,5,1,0.5,NULL,'',0,0,NULL,1,0,0,0,0),(852,'WINCHA TOUGHCASE 8MT/26 FTX25MM - STANLEY','',108,24,60,1,'10852','','',NULL,0,5,1,0.6,NULL,'',0,0,NULL,1,0,0,0,0),(853,'MARTILLO PULIDO 27MM STANLEY','',108,24,130,1,'10853','','',NULL,0,5,1,0.65,NULL,NULL,0,0,NULL,1,0,0,0,0),(854,'ARCO DE SIERRA 12 plg STANLEY','',108,24,134,0,'10854','','','',0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(855,'BROCHA NYLON 1/2 TUMI','',102,24,156,1,'10855','','',NULL,0,5,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(856,'BROCHA NYLON 3/4 TUMI','',102,24,156,1,'10856','','',NULL,0,5,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(857,'BROCHA NYLON 1 plg TUMI','',102,24,156,1,'10857','','',NULL,0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(858,'BROCHA NYLON 1.1/2 TUMI','',102,24,156,1,'10858','','',NULL,0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(859,'BROCHA NYLON 2 plg TUMI','',102,24,156,1,'10859','','',NULL,0,5,1,0.2,NULL,'',0,0,NULL,1,0,0,0,0),(860,'BROCHA NYLON 2.1/2 TUMI','',102,24,156,1,'10860','','',NULL,0,5,1,0.25,NULL,'',0,0,NULL,1,0,0,0,0),(861,'BROCHA NYLON 3 plg TUMI','',102,24,156,1,'10861','','',NULL,0,5,1,0.25,NULL,'',0,0,NULL,1,0,0,0,0),(862,'BROCHA NYLON 4 plg TUMI','',102,24,156,1,'10862','','',NULL,0,5,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(863,'BROCHA NYLON 5 plg TUMI','',102,24,156,1,'10863','','',NULL,0,5,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(865,'BROCHA NYLON 6 plg TUMI','',102,24,156,1,'10865','','',NULL,0,5,1,0.35,NULL,'',0,0,NULL,1,0,0,0,0),(866,'BROCHA NYLON 2 plg AGUILA','',110,24,156,1,'10866','','',NULL,0,5,1,0.2,NULL,'',0,0,NULL,1,0,0,0,0),(867,'BROCHA NYLON 3 plg AGUILA','',110,24,156,1,'10867','','',NULL,0,5,1,0.25,NULL,'',0,0,NULL,1,0,0,0,0),(868,'BROCHA NYLON 4 plg AGUILA','',110,24,156,1,'10868','','',NULL,0,5,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(869,'BROCHA NYLON ANGULAR 2 plg TUMI','',102,24,156,1,'10869','','',NULL,0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(870,'BROCHA NYLON BARNIS 2 plg TUMI','',102,24,156,1,'10870','','',NULL,0,5,1,0.2,NULL,'',0,0,NULL,1,0,0,0,0),(871,'BROCHA NYLON BARNIS 4 plg TUMI','',102,24,156,1,'10871','','',NULL,0,5,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(872,'BROCHA NYLON ESPECIAL 4 plg TUMI','',102,24,156,1,'10872','','',NULL,0,5,1,0.35,NULL,'',0,0,NULL,1,0,0,0,0),(873,'BROCHA NYLON PROFESIONAL 5 plg TUMI','',102,24,156,1,'10873','','',NULL,0,5,1,0.35,NULL,'',0,0,NULL,1,0,0,0,0),(874,'TUBO PVC AG C.10 3/4X5MT FORDUIT','',82,24,195,1,'10874','','',NULL,0,5,1,1.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(875,'TUBO PVC AG C.10 1X5MT FORDUIT','',82,25,195,1,'10875','','',NULL,0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(876,'CEMENTO TIPO I QHUNA','',111,10,1,0,'10876','','','',0,8,1,42.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(877,'LLANTA SOLIDA 3.50-8 VOLCAN NEGRO','',27,24,12,1,'10877','','',NULL,0,5,1,2.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(878,'LLANTA SOLIDA 3.50-8  ROJO ND','',27,24,12,1,'10878','','',NULL,0,5,1,2.5,NULL,'',0,0,NULL,1,0,0,0,0),(879,'ENCHUFE MACHO C/TIERRA FERRAWYY','',98,51,170,1,'10879','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(880,'CALAMINA 0.26 X0.84X3.60 TRAPEZOIDAL ROJO','',36,24,224,1,'10880','','',NULL,0,5,1,6.42,NULL,NULL,0,0,NULL,1,0,0,0,0),(881,'TRIPLAY 4MMX1.22X2.44 LUPUNA','',112,24,40,0,'10881','','','',0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(883,'CINTA EMBALAJE X 200 YARDS  ULTRAPACK','',113,55,78,1,'10883','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(884,'CINTA EMBALAJE X 400 YARDS  ULTRAPACK','',113,54,78,1,'10884','','',NULL,0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(885,'STRECHS FILL #20 ULTRAPACK','',113,56,225,1,'10885','','',NULL,0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(886,'CINTA EMBALAJE X 70 YARDS V/COLORES ULTRAPACK','',113,55,78,1,'10886','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(887,'NIVEL TORPEDO MAGNETICO 9`` TRUPER','',28,24,226,1,'10887','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(888,'OCRE VERDE OXI BAYER','',49,28,56,1,'10888','','',NULL,0,5,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(889,'OCRE NEGRO OXI BAYER','',49,28,56,1,'10889','','',NULL,0,5,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(890,'CEMENTO BLANCO ND','',49,28,1,1,'10890','','',NULL,0,3,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(891,'TRAPO INDUSTRIAL ND','',36,2,227,1,'10891','','',NULL,0,3,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(892,'ASFALTO LIQUIDO RC-250 ND','',36,39,228,1,'10892','','',NULL,0,6,1,2.9,NULL,NULL,0,0,NULL,1,0,0,0,0),(893,'CACHIMBA COMPLETA PVC 250MMX160MM ND','',36,24,57,1,'10893','','',NULL,0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(894,'LLAVE DE PASO PVC  1/2 ECO. NARANJA PCP','',40,89,58,1,'10894','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(895,'LLAVE DE PASO PVC  1/2 PSD. AZUL PCP','',40,36,58,1,'10895','','',NULL,0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(896,'LLAVE DE PASO DOB. UNION ROSC. 1/2 PCP','',40,90,58,1,'10896','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(897,'COBERTURA DE SUPER. TR-4 DE ALUZINC  0.30X1.05X6M ND','',36,24,229,1,'10897','','',NULL,0,5,1,5.6,NULL,NULL,0,0,NULL,1,0,0,0,0),(898,'TUBO PVC ISO ALCA C-4/S-25 250MM UFX6MT NICOLL','',42,24,92,1,'10898','','',NULL,0,5,1,30,NULL,'',0,0,NULL,1,0,0,0,0),(899,'TANQUE PE ARENA 600 LT C/ACC COMPL NICOLL','',42,24,120,1,'10899','','',NULL,0,5,1,18,NULL,'',0,0,NULL,1,0,0,0,0),(900,'TUBO PVC ISO ALCA C-4/S-25 315MM UFX6MT NICOLL','',42,24,92,1,'10900','','',NULL,0,5,1,40,NULL,NULL,0,0,NULL,1,0,0,0,0),(901,'TUBO PVC AG C10 SP 3X5MT NICOLL','',42,24,82,1,'10901','','',NULL,0,5,1,6,NULL,NULL,0,0,NULL,1,0,0,0,0),(902,'CODO PVC AG SP 3X90° ERA','',36,24,87,1,'10902','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(903,'UNION UNIVERSAL PVC 3 ERA','',36,24,172,1,'10903','','',NULL,0,5,1,2,NULL,'',0,0,NULL,1,0,0,0,0),(904,'ADAPTADOR UPR PVC 3 ERA','',36,24,43,1,'10904','','',NULL,0,5,1,0.6,NULL,NULL,0,0,NULL,1,0,0,0,0),(905,'NIPLE PVC AG C/R 3 ERA','',36,24,76,1,'10905','','',NULL,0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(906,'TAPON PVC SAL 3 NICOL','',42,24,47,1,'10906','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(907,'TAPON PVC ALCAN SAL 8 NARANJA ND','',42,24,47,1,'10907','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(908,'TUBO PVC AG C10 SP 4X5MT PLASTICA','',14,24,81,1,'10908','','',NULL,0,5,1,9.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(909,'TUBO PVC AG C7.5 SP 2X5MT PLASTICA','',14,24,81,1,'10909','','',NULL,0,5,1,3.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(910,'ZAPAPICO SIN MANGO CASCO','',93,42,26,0,'10910','','','',0,5,1,2.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(911,'ZAPAPICO CON MANGO CASCO','',93,42,26,0,'10911','','','',0,5,1,3.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(912,'CHALECO PESADO C/CINTA REFLECTIVA SM','',36,24,67,1,'10912','','',NULL,0,5,1,0.45,NULL,'',0,0,NULL,1,0,0,0,0),(913,'TAPON DE OIDO CAJITA SM','',36,24,47,1,'10913','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(914,'BARBIQUEJO NACIONAL NEGRO','',36,24,230,1,'10914','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(915,'ZAPATO MEDIO SUPERIOR P/A T/38 SM','',36,57,231,1,'10915','','',NULL,0,19,1,1.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(916,'ZAPATO MEDIO SUPERIOR P/A T/39 SM','',36,57,231,1,'10916','','',NULL,0,19,1,1.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(917,'ZAPATO MEDIO SUPERIOR P/A T/40 SM','',36,57,231,1,'10917','','',NULL,0,19,1,1.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(918,'ZAPATO MEDIO SUPERIOR P/A T/41 SM','',36,57,231,1,'10918','','',NULL,0,19,1,1.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(919,'ZAPATO MEDIO SUPERIOR P/A T/42 SM','',36,57,231,1,'10919','','',NULL,0,19,1,1.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(920,'ZAPATO SEGURIDAD  P/A 552 T/38 TECSEG ','',115,57,231,1,'10920','','',NULL,0,19,1,1.45,NULL,NULL,0,0,NULL,1,0,0,0,0),(921,'ZAPATO SEGURIDAD  P/A 552 T/39 TECSEG','',115,57,231,1,'10921','','',NULL,0,19,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(922,'ZAPATO SEGURIDAD  P/A 552 T/40 TECSEG ','',115,57,231,1,'10922','','',NULL,0,19,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(923,'ZAPATO SEGURIDAD  P/A 552 T/41 TECSEG ','',115,57,231,1,'10923','','',NULL,0,19,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(924,'ZAPATO SEGURIDAD  P/A 552 T/42 TECSEG ','',115,57,231,1,'10924','','',NULL,0,19,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(925,'PALANA CUCHARA PEQUEÑA M/P GUOZU','',29,24,25,1,'10925','','',NULL,0,5,1,2.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(926,'PALANA RECTA PEQUEÑA M/P GUOZU','',29,24,25,1,'10926','','',NULL,0,5,1,2.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(927,'PANTALON DRIL AZUL T/M TEC','',116,24,232,1,'10927','','',NULL,0,5,1,0.35,NULL,'',0,0,NULL,1,0,0,0,0),(928,'PANTALON DRIL AZUL T/L TEC','',116,24,232,1,'10928','','',NULL,0,5,1,0.35,NULL,'',0,0,NULL,1,0,0,0,0),(929,'POLO PLOMO MANGA LARGA 30/1 T/M SM','',36,24,234,1,'10929','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(930,'POLO PLOMO MANGA LARGA 30/1 T/L SM','',36,24,234,1,'10930','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(931,'GUANTE BADANA ARTESANAL SM','',36,57,62,1,'10931','','',NULL,0,19,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(932,'GUANTE BADANA BLANCO IMP. TECSEG','',115,57,62,1,'10932','','',NULL,0,19,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(933,'MASCARILLA TRIANGULAR  TIPO AS SM','',36,24,210,1,'10933','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(934,'MASCARILLA DE SEGURIDAD POLVO 1 VIA 303 SM','',36,24,210,1,'10934','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(935,'MASCARILLA DE SEGURIDAD POLVO 2 VIA 304 SM','',36,24,210,1,'10935','','',NULL,0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(936,'MASCARILLA DE SEGURIDAD ANTIGAS 2 VIA 306 SM','',36,24,210,1,'10936','','',NULL,0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(937,'POLO PLOMO MANGA LARGA 30/1 T/S SM','',36,24,234,1,'10937','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(938,'PANTALON JEAN T/L SM','',36,24,232,1,'10938','','',NULL,0,5,1,0.65,NULL,NULL,0,0,NULL,1,0,0,0,0),(939,'PANTALON JEAN T/M SM','',36,24,232,1,'10939','','',NULL,0,5,1,0.65,NULL,NULL,0,0,NULL,1,0,0,0,0),(940,'GUANTE ANTICORDE LATEX NEGRO/AZUL ANSELL','',117,36,62,1,'10940','','',NULL,0,19,1,0.35,NULL,'',0,0,NULL,1,0,0,0,0),(941,'PANTALON JEAN T/S SM','',36,24,232,1,'10941','','',NULL,0,5,1,0.65,NULL,NULL,0,0,NULL,1,0,0,0,0),(942,'REDUCCION PVC SAP 3/4x1/2 ND','',42,24,235,0,'10942','','','',0,5,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(943,'REDUCCION PVC SAP 1x1/2 NICOLL','',42,24,235,1,'10943','','','',0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(944,'REDUCCION PVC SAP 1x3/4 NICOLL','',42,24,235,0,'10944','','','',0,5,1,0.17,NULL,NULL,0,0,NULL,1,0,0,0,0),(945,'CODO PVC AG SP 1/2X45° NICOLL','',42,83,87,1,'10945','','',NULL,0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(946,'CODO PVC ALCAN. 315MMX45 UF NICOLL','',42,24,97,1,'10946','','',NULL,0,5,1,7,NULL,NULL,0,0,NULL,1,0,0,0,0),(947,'ANILLO P/TUBO ALCANTARILLADO 315MM NICOLL','',42,24,61,1,'10947','','',NULL,0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(948,'ACIDO DOMESTICO NO FISCALIZADO','',36,58,236,1,'10948','','',NULL,0,5,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(949,'TORTOL 1/2 TRUPER','',28,24,237,1,'10949','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(950,'PLANCHA EMPASTAR M/MADERA 11 DENTADA TRUPER','',28,24,151,1,'10950','','',NULL,0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(951,'BADILEJO P/ALBAÑIL DE 8¨PRETUL','',41,24,152,1,'10951','','',NULL,0,5,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(952,'WINCHA LARGA 50M METALICA CARCASA PLAST. TRUPER','',28,24,60,1,'10952','','',NULL,0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(953,'DISCO CONCRETO 4.1/2 TRUPER','',28,24,187,1,'10953','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(954,'DISCO CONCRETO 7 TRUPER','',28,24,187,1,'10954','','',NULL,0,5,1,0.45,NULL,NULL,0,0,NULL,1,0,0,0,0),(955,'CINTA AISL. AMARILLA 18MT TRUPER','',28,24,35,1,'10955','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(956,'CARRETILLA 6ft ROJA LLANTA REFOR.TRUPER ','',28,24,27,0,'10956','','','',0,5,1,10,NULL,NULL,0,0,NULL,1,0,0,0,0),(957,'CARRETILLA 5.5 LLANTA IMPONCHABLE TRUPER','',28,24,27,0,'10957','','','',0,5,1,10,NULL,'',0,0,NULL,1,0,0,0,0),(958,'CINTA EMBALAJE PEQUEÑA 15 YARDS  ULTRAPACK','',113,24,78,1,'10958','','',NULL,0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(959,'SOMBRERO VENTILACION 2 TERM. NICOLL','',42,37,238,1,'10959','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(960,'CEMENTO ULTRA ARMADO PACASMAYO','',2,10,1,1,'10960','','',NULL,0,8,1,42.5,NULL,'',0,0,NULL,1,0,0,0,0),(961,'CERRADURA MAXIMA 1000 CANTOL','',118,24,240,1,'10961','','',NULL,0,5,1,2,NULL,NULL,0,0,NULL,1,0,0,0,0),(962,'CERRADURA SUPER 900 CANTOL','',118,24,240,1,'10962','','',NULL,0,5,1,2,NULL,NULL,0,0,NULL,1,0,0,0,0),(963,'CERRADURA SUPER 800 CANTOL','',118,24,240,1,'10963','','',NULL,0,5,1,2,NULL,NULL,0,0,NULL,1,0,0,0,0),(964,'CERRADURA SUPER 700 CANTOL','',118,24,240,1,'10964','','',NULL,0,5,1,2,NULL,NULL,0,0,NULL,1,0,0,0,0),(965,'CERRADURA CLASICA 250 CANTOL','',118,24,240,1,'10965','','',NULL,0,5,1,2,NULL,NULL,0,0,NULL,1,0,0,0,0),(966,'PERILLA T-BOLA 90 P/DORM. BRON-QUEMADO CANTOL','',118,24,241,1,'10966','','',NULL,0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(967,'PERILLA T-BOLA 30 P/DORM. AC-PULIDO CANTOL','',118,24,241,1,'10967','','',NULL,0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(968,'PERILLA T-BOLA 60 P/DORM. ACER-INOXIDABLE CANTO','',118,24,241,1,'10968','','',NULL,0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(969,'CANDADO 25MM PORJE','',119,24,192,1,'10969','','',NULL,0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(970,'CANDADO 32MM PORJE','',119,24,192,1,'10970','','',NULL,0,5,1,0.2,NULL,'',0,0,NULL,1,0,0,0,0),(971,'CANDADO 38MM PORJE','',119,24,192,1,'10971','','',NULL,0,5,1,0.2,NULL,'',0,0,NULL,1,0,0,0,0),(972,'CANDADO 50MM PORJE','',119,24,192,1,'10972','','',NULL,0,5,1,0.45,NULL,'',0,0,NULL,1,0,0,0,0),(973,'DESARMADOR INTERCAM. PROF. 203 SINYE','',120,24,196,1,'10973','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(974,'DESARMADOR INTERCAM. PROF. 107- 4 plg SINYE','',120,24,196,1,'10974','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(975,'DESARMADOR INTERCAM. PROF. 107- 6 plg SINYE','',120,24,196,1,'10975','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(976,'DESARMADOR INTERCAM. PROF. 107- 8 plg SINYE','',120,24,196,1,'10976','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(977,'PINTURA BOLSA 5KG APROX SUPER BLANCA TEMPLE','',121,59,149,1,'10977','','',NULL,0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(978,'PINTURA BOLSA 25KG APROX SUPER BLANCA TEMPLE','',121,7,149,1,'10978','','',NULL,0,5,1,25,NULL,NULL,0,0,NULL,1,0,0,0,0),(979,'OCRE AZUL OXI BAYER','',49,28,56,1,'10979','','',NULL,0,5,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(980,'OCRE EXTRA. T/130 AZUL ULTRAMAR BAYER','',49,28,56,1,'10980','','',NULL,0,5,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(981,'THINNER ACRILICO GL 3LT CATALEYA','',137,60,242,1,'10981','','',NULL,0,5,1,3,NULL,'',0,0,NULL,1,0,0,0,0),(982,'MALLA GALVANIZADA 1/2 - 18 PLATIFICADA PRODAC','',17,34,48,0,'10982','','','',0,13,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(983,'LIMA TRIANGULAR BELLOTA','',26,24,54,1,'10983','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(984,'MALLA MOSQUITERO VERDE 1.20X30 MTS','',36,34,243,1,'10984','','',NULL,0,13,1,0.2,NULL,'',0,0,NULL,1,0,0,0,0),(985,'CIZALLA DE 30`` BELLOTA','',26,24,244,1,'10985','','',NULL,0,5,1,2.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(986,'WINCHA 3 MT BELLOTA','',26,43,60,1,'10986','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(987,'WINCHA 5 MT BELLOTA','',26,42,60,1,'10987','','',NULL,0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(988,'LLANTA ARO BLANCO COMPLETA','',36,24,12,1,'10988','','',NULL,0,5,1,3,NULL,NULL,0,0,NULL,1,0,0,0,0),(989,'LLANTA ARO ROJO COMPLETA','',36,24,12,1,'10989','','',NULL,0,5,1,3,NULL,NULL,0,0,NULL,1,0,0,0,0),(990,'LLANTA PISTERA 3.5-8 ND','',36,24,12,1,'10990','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(991,'LLANTA COCO 3.5-8 S/CAMARA ND','',36,24,12,1,'10991','','',NULL,0,5,1,0.5,NULL,'',0,0,NULL,1,0,0,0,0),(992,'CARRETILLA VERDE PESADA VOLCAN','',27,24,27,1,'10992','','',NULL,0,5,1,10,NULL,'',0,0,NULL,1,0,0,0,0),(993,'DISCO CONCRETO 7 BELLOTA','',26,24,187,1,'10993','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(994,'ZAQUETA PLASTICA','',36,24,245,1,'10994','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(995,'CIZALLA DE 30 plg TRUPER','',28,24,244,1,'10995','','',NULL,0,5,1,2.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(996,'CARRETILLA 5ft  ROJA LLANT. REF. PRETUL','',41,24,27,1,'10996','','','',0,5,1,8,NULL,'',0,0,NULL,1,0,0,0,0),(997,'BISAGRA 3 plg ACERO PULIDO HERMEX','',123,44,223,1,'10997','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(998,'BISAGRA 3.1/2 plg ACERO PULIDO HERMEX','',123,44,223,1,'10998','','',NULL,0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(999,'BISAGRA 4 plg ACERO PULIDO HERMEX','',123,44,223,1,'10999','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1000,'BISAGRA 3 plg ACERO LATONADO HERMEX','',123,44,223,1,'11000','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1001,'BISAGRA 3.1/2 plg ACERO LATONADO HERMEX','',123,44,223,1,'11001','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1002,'BISAGRA 4 plg ACERO LATONADO HERMEX','',123,44,223,1,'11002','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1003,'BISAGRA 3 plg ACERO INOXIDABLE HERMEX','',123,44,223,1,'11003','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1004,'BISAGRA 3.1/2 plg ACERO INOXIDABLE HERMEX','',123,44,223,1,'11004','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1005,'BISAGRA 4 plg ACERO INOXIDABLE HERMEX','',123,44,223,1,'11005','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1006,'CABLE ACERO 1/2 ALMA CAÑAMO TIPO BOA CASCO','',93,50,246,0,'11006','','','',0,13,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(1007,'CABLE ACERO 3/8 ALMA CAÑAMO TIPO BOA CASCO','',93,50,246,0,'11007','','','',0,13,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1008,'CABLE ACERO 1/4 ALMA CAÑAMO TIPO BOA CASCO','',93,50,246,0,'11008','','','',0,13,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1009,'GRAPA P/CABLE G 1/2 plg CASCO','',93,24,248,1,'11009','','',NULL,0,5,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(1010,'GRAPA P/CABLE G 3/8 plg CASCO','',93,24,248,1,'11010','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1011,'GRAPA P/CABLE G 1/4 plg CASCO','',93,24,248,1,'11011','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1012,'TEMPLADORES P/CABLE 1/2 Plg CASCO','',93,24,247,1,'11012','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1013,'TEMPLADORES P/CABLE 3/8 Plg CASCO','',93,24,247,1,'11013','','',NULL,0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(1014,'TEMPLADORES P/CABLE 1/4 Plg CASCO','',93,24,247,1,'11014','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1015,'PEGAMENTO REG. PVC 1/32 AZUL GL(4 ONZ) OATEY','',24,51,23,1,'11015','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1016,'ADOQUIN 10X20X 08 COLOR NATURAL PACASMAYO','',2,61,249,1,'11016','','',NULL,0,28,1,175,NULL,NULL,0,0,NULL,1,0,0,0,0),(1017,'INTERRUPTOR SIMPLE P/EMPOTRAR AP1100 BTICINO','',81,62,140,1,'11017','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1022,'TOMACORRIENTE TRIPLE P/EMPOT AP 1312 BTICINO','',81,51,142,1,'11022','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1023,'TOMACORRIENTE UNIV DOBLE P/TIERRA AP 1222 BTICINO','',81,51,142,1,'11023','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1025,'WALL SOCKET P/EMPOT BTICINO','',81,62,143,1,'11025','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1026,'TOMACORRIENTE TRIPLE UNIV S/PON P96 BTICINO','',81,62,142,1,'11026','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1027,'INTERRUPTOR SIMPLE SOBREPONER P52 BTICINO','',81,62,140,1,'11027','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1028,'CUCHILLA TERMOMAG DIN 2PX16A BTICINO','',81,63,207,1,'11028','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1029,'CUCHILLA TERMOMAG DIN 2PX20A BTICINO','',81,63,207,1,'11029','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1030,'CUCHILLA TERMOMAG DIN 2PX25A BTICINO','',81,63,207,1,'11030','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1031,'CUCHILLA TERMOMANG DIN 2PX32A BTICINO','',81,63,207,1,'11031','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1032,'CUCHILLA TERMOMAG DIN 2PX40A BTICINO','',81,63,207,1,'11032','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1033,'CUCHILLA TERMOMAG DIN 3P X 25A BTICINO','',81,24,207,1,'11033','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1034,'SIKA 3 ACELERENTE X 4 LT','',59,39,45,1,'11034','','',NULL,0,5,1,5,NULL,'',0,0,NULL,1,0,0,0,0),(1035,'SIKASIL UNIVERSAL 280 ML TRANSPARENTE','',59,36,45,1,'11035','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1036,'CUCHILLA TERMOMAG DIN3PX32A BTICINO','',81,63,207,1,'11036','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1037,'CUCHILLA TERMOMAG DIN 3PX40A BTICINO','',81,63,207,1,'11037','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1038,'EXTENSION 3TOMAS/ 5 METROS A5 SONCA SE','',124,62,208,1,'11038','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1039,'EXTENSION 3TOMAS/10METROS A10 SONCA SE','',124,62,208,1,'11039','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1040,'LINTERNA 1W LED SONCA','',125,36,250,1,'11040','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1041,'LINTERNA 3W LED SONCA','',125,36,250,1,'11041','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1044,'LLAVE DE PASO ROSCADO 1  NICCOL','',42,37,58,1,'11044','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1045,'ADAPTADOR UPR PVC 3/4 NICOLL','',42,24,125,1,'11045','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1046,'TEE PVC ALCAN.ISO S25160MMX160MM ND','',36,24,99,1,'11046','','',NULL,0,5,1,1.75,NULL,'',0,0,NULL,1,0,0,0,0),(1047,'FOCO LED 5 WATT / SONCA','',125,24,219,1,'11047','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1048,'CABLE TW-80 14 AWG 7 HILOS INDECO','',66,35,251,1,'11048','','',NULL,0,13,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(1049,'CABLE THW-90 14 AWG 7 HILOS INDECO','',66,35,251,1,'11049','','',NULL,0,13,1,0.08,NULL,'',0,0,NULL,1,0,0,0,0),(1050,'CABLE TW-80 12 AWG 7 HILOS INDECO','',66,35,251,1,'11050','','',NULL,0,13,1,0.07,NULL,'',0,0,NULL,1,0,0,0,0),(1051,'CABLE THW-90 12 AWG 7 HILOS INDECO','',66,35,251,1,'11051','','',NULL,0,13,1,0.08,NULL,'',0,0,NULL,1,0,0,0,0),(1052,'FOCO AHORR.  ESPIRAL 65W LUZ BLANCA ULIX','',126,52,144,0,'11052','','','',0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1053,'FOCO LED 7W BOLA PHELIX','',77,24,219,1,'11053','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1054,'FOCO LED 9W BOLA PHELIX','',77,24,219,1,'11054','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1055,'FOCO LED 13W BOLA PHELIX','',77,24,219,1,'11055','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1056,'FOCO LED 15W BOLA PHELIX','',77,24,219,1,'11056','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1057,'CINTA AISLANTE GRANDE 3M','',127,37,35,1,'11057','','',NULL,0,5,1,0.08,NULL,NULL,0,0,NULL,1,0,0,0,0),(1058,'CINTA AISLANTE PEQUEÑA 3M','',127,37,35,1,'11058','','',NULL,0,5,1,0.08,NULL,NULL,0,0,NULL,1,0,0,0,0),(1059,'MACHETE 22 PLG PPN BELLOTA','',26,36,252,1,'11059','','',NULL,0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1060,'CODO PVC AG SP 3/4x45° NICOLL','',42,84,87,1,'11060','','',NULL,0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1061,'CODO PVC AG SP 1 x 45° NICOLL','',42,24,87,1,'11061','','',NULL,0,5,1,0.89,NULL,NULL,0,0,NULL,1,0,0,0,0),(1062,'PEGAMENTO P/CERAMICO BLACO FLEXIBLE OFERTON','',128,7,253,1,'11062','','',NULL,0,8,1,23,NULL,NULL,0,0,NULL,1,0,0,0,0),(1063,'WINCHA FIBRA/VIDRIO LARGA 50M T/CRUCETA TRUPER','',28,24,60,1,'11063','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1064,'WINCHA FIBRA/VIDRIO LARGA 100M T/CRUCETA TRUPER','',28,24,60,1,'11064','','',NULL,0,5,1,1.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1065,'DISCO DIAMANTADO CONTINUO 4.1/2 HEFESTO','',100,36,187,1,'11065','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1066,'SIKA 1 X 20LT','',59,67,45,1,'11066','','',NULL,0,5,1,25,NULL,'',0,0,NULL,1,0,0,0,0),(1067,'BOTA JEBE T/40 XTREME','',214,24,194,1,'11067','','',NULL,0,19,1,0.5,NULL,'',0,0,NULL,1,0,0,0,0),(1068,'PALANA RECTA  M/ PLASTICO SCHUBERT','',25,24,25,0,'11068','','','',0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1069,'PALANA DERECHA M/PLASTICO CASCO','',93,24,25,0,'11069','','','',0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1070,'BATEA P/MEZCLAR','',36,24,254,1,'11070','','',NULL,0,5,1,5,NULL,'',0,0,NULL,1,0,0,0,0),(1071,'HILO PARA ALBAÑILERIA 0.40MM X 100MT PRETUL','',41,24,255,1,'11071','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1072,'WINCHA LARGA 30M METALICA  CARCASA PLAST. TRUPER','',28,24,60,1,'11072','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1073,'TIJERA PARA HOJALATERO 12¨- TRUPER','',28,24,168,1,'11073','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1074,'LENTE DE SEGURIDAD- GRIS- TRUPER','',28,36,68,1,'11074','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1075,'LENTE DE SEGURIDAD- TRANSP- TRUPER','',28,36,68,1,'11075','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1076,'CALAMINA 0.23 X0.84X1.80 TRAPEZOIDAL ROJO','',130,24,224,1,'11076','','','',0,5,1,2.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1077,'CALAMINA 0.23 X0.84X3.60 TRAPEZOIDAL ROJO','',130,24,224,1,'11077','','','',0,5,1,4.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(1078,'TEE PVC ALCAN.ISO S25 200MMX200MM ND','',36,24,99,1,'11078','','',NULL,0,5,1,4,NULL,NULL,0,0,NULL,1,0,0,0,0),(1079,'TEE PVC ALCAN.ISO S25 200MMX200MM UF ND','',36,24,99,1,'11079','','',NULL,0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1080,'YEE PVC ALCAN.ISO S25 160MMX160MM ND','',36,24,256,1,'11080','','',NULL,0,5,1,3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1081,'PINTURA LATEX PATO BLANCO 4LT CPP','',133,68,147,1,'11081','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1082,'PINTURA LATEX PATO BLANCO 20LT CPP','',133,67,147,1,'11082','','',NULL,0,5,1,29.7,NULL,'',0,0,NULL,1,0,0,0,0),(1083,'PINTURA LATEX PATO ALMENDRA 4LT CPP','',133,68,147,1,'11083','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1084,'PINTURA LATEX PATO BLANCO HUMO 4LT CPP','',133,68,147,1,'11084','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1085,'PINTURA LATEX PATO COLONIAL 4LT CPP','',133,68,147,1,'11085','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1086,'PINTURA LATEX PATO FLAMENCO 4LT CPP','',133,68,147,1,'11086','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1087,'PINTURA LATEX PATO FRAMBUESA SILVESTRE 4LT CPP','',133,68,147,1,'11087','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1088,'PINTURA LATEX PATO CASTAÑO 4LT CPP','',133,68,147,1,'11088','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1089,'PINTURA LATEX PATO CERAMICO 4LT CPP','',133,68,147,1,'11089','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1090,'PINTURA LATEX PATO ROJO TEJA 4LT CPP','',133,68,147,1,'11090','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1091,'PINTURA LATEX PATO CANELO 4LT CPP','',133,68,147,1,'11091','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1092,'PINTURA LATEX PATO TABACO 4LT CPP','',133,68,147,1,'11092','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1093,'PINTURA LATEX PATO CAPUCHINO 4LT CPP','',133,68,147,1,'11093','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1094,'PINTURA LATEX PATO CAFE PARIS 4LT CPP','',133,68,147,1,'11094','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1095,'PINTURA LATEX PATO FASCINACION 4LT CPP','',133,68,147,1,'11095','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1096,'PINTURA LATEX PATO CELESTE 4LT CPP','',133,68,147,1,'11096','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1097,'PINTURA LATEX PATO AZUL CALIPSO 4LT CPP','',133,68,147,1,'11097','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1098,'PINTURA LATEX PATO AZUL NOCTURNO 4LT CPP','',133,68,147,1,'11098','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1099,'PINTURA LATEX PATO CREMA 4LT CPP','',133,68,147,1,'11099','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1100,'PINTURA LATEX PATO AMARILLO CROMO 4LT CPP','',133,68,147,1,'11100','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1101,'PINTURA LATEX PATO AMARILLO LIMON 4LT CPP','',133,68,147,1,'11101','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1102,'PINTURA LATEX PATO MARFIL 4LT CPP','',133,68,147,1,'11102','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1103,'PINTURA LATEX PATO MARACUYA 4LT CPP','',133,68,147,1,'11103','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1104,'PINTURA LATEX PATO AMARILLO OCRE 4LT CPP','',133,68,147,1,'11104','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1105,'PINTURA LATEX PATO MAIZ 4LT CPP','',133,68,147,1,'11105','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1106,'PINTURA LATEX PATO BEIGE 4LT CPP','',133,68,147,1,'11106','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1107,'PINTURA LATEX PATO DELICIA 4LT CPP','',133,68,147,1,'11107','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1108,'PINTURA LATEX PATO SACHA 4LT CPP','',133,68,147,1,'11108','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1109,'PINTURA LATEX PATO VERDE NILO 4LT CPP','',133,68,147,1,'11109','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1110,'PINTURA LATEX PATO SABILA 4LT CPP','',133,68,147,1,'11110','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1111,'PINTURA LATEX PATO VERDE CACTUS 4LT CPP','',133,68,147,1,'11111','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1112,'PINTURA LATEX PATO VERDE JAEN 4LT CPP','',133,68,147,1,'11112','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1113,'PINTURA LATEX PATO VERDE ESMERALDA 4LT CPP','',133,68,147,1,'11113','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1114,'PINTURA LATEX PATO VERDE JAMAICA 4LT CPP','',133,68,147,1,'11114','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1115,'PINTURA LATEX PATO VERDE TENNIS 4LT CPP','',133,68,147,1,'11115','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1116,'PINTURA LATEX PATO VERDE PERA 4LT CPP','',133,68,147,1,'11116','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1117,'PINTURA LATEX PATO NARANJA CORAL 4LT CPP','',133,68,147,1,'11117','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1118,'PINTURA LATEX PATO ACUARELA 4LT CPP','',133,68,147,1,'11118','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1119,'PINTURA LATEX PATO NARANJA DULCE 4LT CPP','',133,68,147,1,'11119','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1120,'PINTURA LATEX PATO ARTICO 4LT CPP','',133,68,147,1,'11120','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1121,'PINTURA LATEX PATO GRIS CLARO 4LT CPP','',133,68,147,1,'11121','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1122,'PINTURA LATEX PATO GRIS PERLA 4LT CPP','',133,68,147,1,'11122','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1123,'PINTURA LATEX SATINADO BLANCO 4LT CPP','',133,68,257,1,'11123','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1124,'PINTURA LATEX SATINADO BLANCO 20LT CPP','',133,68,257,1,'11124','','',NULL,0,5,1,23,NULL,'',0,0,NULL,1,0,0,0,0),(1125,'PINTURA LATEX SATINADO BLANCO HUESO 4LT CPP','',133,68,257,1,'11125','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1126,'PINTURA LATEX SATINADO BLANCO PERLA 4LT CPP','',133,68,257,1,'11126','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1127,'PINTURA LATEX SATINADO BLANCO HUMO 4LT CPP','',133,68,257,1,'11127','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1128,'PINTURA LATEX SATINADO ROSADO NATURAL 4LT CPP','',133,68,257,1,'11128','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1129,'PINTURA LATEX SATINADO ROSA FRANCESA 4LT CPP','',133,68,257,1,'11129','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1130,'PINTURA LATEX SATINADO MELON 4LT CPP','',133,68,257,1,'11130','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1131,'PINTURA LATEX SATINADO SALMON 4LT CPP','',133,68,257,1,'11131','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1132,'PINTURA LATEX SATINADO ROJO TEJA 4LT CPP','',133,68,257,1,'11132','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1133,'PINTURA LATEX SATINADO MARRON SEVILLANO 4LT CPP','',133,68,257,1,'11133','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1134,'PINTURA LATEX SATINADO CANELO 4LT CPP','',133,68,257,1,'11134','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1135,'PINTURA LATEX SATINADO TABACO MEDIO 4LT CPP','',133,68,257,1,'11135','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1136,'PINTURA LATEX SATINADO CRAYOLA 4LT CPP','',133,68,257,1,'11136','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1137,'PINTURA LATEX SATINADO GRANADA 4LT CPP','',133,68,257,1,'11137','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1138,'PINTURA LATEX SATINADO GROSELLA 4LT CPP','',133,68,257,1,'11138','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1139,'PINTURA LATEX SATINADO AZUL CIELO 4LT CPP','',133,68,257,1,'11139','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1140,'PINTURA LATEX SATINADO AZUL MAREA 4LT CPP','',133,68,257,1,'11140','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1141,'PINTURA LATEX SATINADO INDIGO 4LT CPP','',133,68,257,1,'11141','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1142,'PINTURA LATEX SATINADO LIRIO 4LT CPP','',133,68,257,1,'11142','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1143,'PINTURA LATEX SATINADO LILA 4LT CPP','',133,68,257,1,'11143','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1144,'PINTURA LATEX SATINADO AZUL MAYA 4LT CPP','',133,68,257,1,'11144','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1145,'PINTURA LATEX SATINADO CREMA 4LT CPP','',133,68,257,1,'11145','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1146,'PINTURA LATEX SATINADO MARFIL 4LT CPP','',133,68,257,1,'11146','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1147,'PINTURA LATEX SATINADO MARGARITA 4LT CPP','',133,68,257,1,'11147','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1148,'PINTURA LATEX SATINADO LUCUMA 4LT CPP','',133,68,257,1,'11148','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1149,'PINTURA LATEX SATINADO MOSTAZA 4LT CPP','',133,68,257,1,'11149','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1150,'PINTURA LATEX SATINADO MARACUYA 4LT CPP','',133,68,257,1,'11150','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1151,'PINTURA LATEX SATINADO CHAMAYA 4LT CPP','',133,68,257,1,'11151','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1152,'PINTURA LATEX SATINADO AMARILLO OCRE 4LT CPP','',133,68,257,1,'11152','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1153,'PINTURA LATEX SATINADO BEIGE 4LT CPP','',133,68,257,1,'11153','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1154,'PINTURA LATEX SATINADO VERDE CLARO 4LT CPP','',133,68,257,1,'11154','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1155,'PINTURA LATEX SATINADO HIERBA BUENA 4LT CPP','',133,68,257,1,'11155','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1156,'PINTURA LATEX SATINADO VERDE CACTUS 4LT CPP','',133,68,257,1,'11156','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1157,'PINTURA LATEX SATINADO BAMBU 4LT CPP','',133,68,257,1,'11157','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1158,'PINTURA LATEX SATINADO VERDE TENNIS 4LT CPP','',133,68,257,1,'11158','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1159,'PINTURA LATEX SATINADO EUCALIPTO 4LT CPP','',133,68,257,1,'11159','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1160,'PINTURA LATEX SATINADO MOKA 4LT CPPUNI','',133,68,257,1,'11160','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1161,'PINTURA LATEX SATINADO SUNSET 4LT CPP','',133,68,257,1,'11161','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1162,'PINTURA LATEX SATINADO BENGALA 4LT CPP','',133,68,257,1,'11162','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1163,'PINTURA LATEX SATINADO MANDARINO 4LT CPP','',133,68,257,1,'11163','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1164,'PINTURA LATEX SATINADO VIOLETA AFRICANA 4LT CPP','',133,68,257,1,'11164','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1165,'PINTURA LATEX SATINADO ARENA 4LT CPP','',133,68,257,1,'11165','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1166,'PINTURA LATEX SATINADO GRIS CALIDO 4LT CPP','',133,68,257,1,'11166','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1167,'PINTURA LATEX SATINADO GRIS CLARO 4LT CPP','',133,68,257,1,'11167','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1168,'PINTURA LATEX SATINADO GRIS HORIZONTE 4LT CPP','',133,68,257,1,'11168','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1169,'SELLADOR  150 BLANCO 4LT CPP','',133,68,258,1,'11169','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1170,'PASTA FINA P/MUROS BLANCO 4LT CPP','',133,68,259,1,'11170','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1171,'IMPRIMANTE BLANCO 1GL CPP','',133,68,148,1,'11171','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1172,'IMPRIMANTE BLANCO 20LT CPP','',133,67,148,1,'11172','','',NULL,0,5,1,30,NULL,'',0,0,NULL,1,0,0,0,0),(1173,'TEKNOCOLA ULTRA 4KG','',116,80,260,1,'11173','','',NULL,0,5,1,4,NULL,'',0,0,NULL,1,0,0,0,0),(1174,'TEKNOCOLA ULTRA 1KG','',116,96,260,1,'11174','','',NULL,0,5,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(1175,'LACA SELLADORA 1GL CLASICA PARACAS','',132,39,261,1,'11175','','',NULL,0,5,1,6.2,NULL,'',0,0,NULL,1,0,0,0,0),(1176,'PLANCHA FRAGUADORA 7X15 ND','',36,24,262,1,'11176','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1177,'PLANCHA FRAGUADORA 7X25 ND','',36,24,262,1,'11177','','',NULL,0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(1178,'PLANCHA FRAGUADORA 11X23 ND','',36,24,262,1,'11178','','',NULL,0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(1179,'PLANCHA FRAGUADORA16X26 ND','',36,24,262,1,'11179','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1180,'MANGUERA NIVEL 3/8-INDUS-TRUPER','',28,35,178,1,'11180','','',NULL,0,13,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1181,'WINCHA LARGA 20M METALICA  CARCASA PLAST. TRUPER','',28,24,60,1,'11181','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1182,'RAFIA ND','',36,24,263,1,'11182','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1183,'PINTURA SPRAY BLANCO MATE THOR','',134,24,264,1,'11183','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1184,'PINTURA SPRAY BLANCO BRILLANTE THOR','',134,24,264,1,'11184','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1185,'PINTURA SPRAY NEGRO BRILLANTE THOR','',134,24,264,1,'11185','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1186,'PINTURA SPRAY NEGRO MATE THOR','',134,24,264,1,'11186','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1187,'PINTURA SPRAY ROJO THOR','',134,24,264,1,'11187','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1188,'PINTURA SPRAY ROJO BRILLANTE THOR','',134,24,264,1,'11188','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1189,'PINTURA SPRAY LACA TRANSPARENTE THOR','',134,24,264,1,'11189','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1190,'PINTURA SPRAY AZUL BRILLANTE THOR','',134,24,264,1,'11190','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1191,'PINTURA SPRAY AZUL CIELO THOR','',134,24,264,1,'11191','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1192,'PINTURA SPRAY AZUL VIOLETA BRILLANTE THOR','',134,24,264,1,'11192','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1193,'PINTURA SPRAY VERDE CLARO THOR','',134,24,264,1,'11193','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1194,'PINTURA SPRAY VERDE OSCURO THOR','',134,24,264,1,'11194','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1195,'PINTURA SPRAY VERDE DORADO THOR','',134,24,264,1,'11195','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1196,'PINTURA SPRAY VERDE PLATA THOR','',134,24,264,1,'11196','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1197,'PINTURA SPRAY PLATA BRILLANTE THOR','',134,24,264,1,'11197','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1198,'PINTURA SPRAY AMARILLO THOR','',134,24,264,1,'11198','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1199,'PINTURA SPRAY AMARILLO CREMA THOR','',134,24,264,1,'11199','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1200,'PINTURA SPRAY PLATA THOR','',134,24,264,1,'11200','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1201,'PINTURA SPRAY BRONCE THOR','',134,24,264,1,'11201','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1202,'PINTURA SPRAY ANTIOXIDO ROJO THOR','',134,24,264,1,'11202','','',NULL,0,5,1,0.25,NULL,'',0,0,NULL,1,0,0,0,0),(1203,'PINTURA SPRAY ANTICORROSIVO GRIS THOR','',134,24,264,1,'11203','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1204,'BRAZO D/DUCHA ANTI CALCAREO REDONDA 4.5 FAUCET','',136,24,159,1,'11204','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1205,'BRAZO D/DUCHA X/SISTEMA LIMPIANTE VIKINGO','',135,24,159,1,'11205','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1206,'CLAVO C/C ACERO 2.7 X 30MM (1.1/4) BILDER','',148,28,77,1,'11206','','',NULL,0,3,1,0.003,NULL,'',0,0,NULL,1,0,0,0,0),(1207,'SIFAN EXTENSIBLE BLANCO, C/ RENAJE CROMADO 1.1/4 VIKINGO','',135,24,265,1,'11207','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1208,'CANDADO DORADO 25MM VIKINGO','',135,24,192,1,'11208','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1209,'CANDADO DORADO 30MM VIKINGO','',135,24,192,1,'11209','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1210,'CANDADO DORADO 40MM VIKINGO','',135,24,192,1,'11210','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1211,'CANDADO DORADO 50MM VIKINGO','',135,24,192,1,'11211','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1212,'MASILLA DE PARED CATALEYA','',137,28,266,1,'11212','','',NULL,0,3,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1213,'MASILLA DE MADERA CATALEYA','',137,28,266,1,'11213','','',NULL,0,3,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1215,'LIMPIA VIDRIO CATALEYA','',137,24,267,1,'11215','','',NULL,0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1216,'AMBIENTADOR ROSAS CATALEYA','',137,24,268,1,'11216','','',NULL,0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1217,'AMBIENTADOR BOUQUET CATALEYA','',137,24,268,1,'11217','','',NULL,0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1218,'LIMPIA TODO CATALEYA','',137,24,269,1,'11218','','',NULL,0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1219,'DRIZA POLIPROPILENO 1/4 (ROLLO APROX 200M - 5KG)','',36,70,270,1,'11219','','',NULL,0,3,1,0.12,NULL,'',0,0,NULL,1,0,0,0,0),(1220,'DRIZA POLIPROPILENO 5/16 (ROLLO APROX 290M - 10KG)','',36,71,270,1,'11220','','',NULL,0,3,1,0.035,NULL,'',0,0,NULL,1,0,0,0,0),(1221,'DRIZA POLIPROPILENO 3/8 (ROLLO APROX 20M - 20KG)','',36,72,270,1,'11221','','',NULL,0,3,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(1222,'CORDEL DE ALGODON 18 ND','',36,73,271,1,'11222','','',NULL,0,13,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1223,'CORDEL DE ALGODON 24 ND','',36,73,271,1,'11223','','',NULL,0,13,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1224,'CORDEL DE ALGODON 120 ND','',36,73,271,1,'11224','','',NULL,0,13,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1225,'CORDEL DE ALGODON 12 ND','',36,74,271,1,'11225','','',NULL,0,13,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1226,'REGLA  ALUMINIO 3.1/4 X 1.1/2 X 6MT ND','',36,24,272,1,'11226','','',NULL,0,5,1,8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1227,'TUBO MULTIFUNCION  RECARG. SR-200T SONCA','',125,24,273,1,'11227','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1228,'LINTERNA EMERGENCIA RECARG. 24 LED-SMD LED SONCA','',125,24,274,1,'11228','','',NULL,0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(1229,'LINTERNA EMERGENCIA RECARG. 66 LED-SMD LED SONCA','',125,24,274,1,'11229','','',NULL,0,5,1,0.7,NULL,NULL,0,0,NULL,1,0,0,0,0),(1230,'SUPRESOR DE PICOS 2MT SONCA','',125,24,275,1,'11230','','',NULL,0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(1231,'FROTACHO PLASTICO 24X40 ND','',36,24,276,1,'11231','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1232,'FROTACHO PLASTICO 12X08 ND','',36,24,276,1,'11232','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1233,'FROTACHO PLASTICO 10X15 ND','',36,24,276,1,'11233','','',NULL,0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1234,'FROTACHO PLASTICO 06X29 ND','',36,24,276,1,'11234','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1235,'FROTACHO PLASTICO 09X36 ND','',36,24,276,1,'11235','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1236,'FROTACHO PLASTICO 08X40 ND','',36,24,276,1,'11236','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1237,'FROTACHO PLASTICO 17X24 ND','',36,24,276,1,'11237','','',NULL,0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(1238,'DISCO CORTE FIERRO 4.1/2 3M','',127,24,107,1,'11238','','',NULL,0,5,1,0.03,NULL,'',0,0,NULL,1,0,0,0,0),(1239,'DISCO CORTE FIERRO 7 plg 3M','',127,24,107,1,'11239','','',NULL,0,5,1,0.07,NULL,NULL,0,0,NULL,1,0,0,0,0),(1240,'CINTA MASKING 1/2 - 40YDX12MM 3M','',127,24,277,1,'11240','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1241,'CINTA MASKING 3/4 - 40YDX18MM 3M','',127,24,277,1,'11241','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1242,'CINTA MASKING 1 - 40YDX24MM 3M','',127,24,277,1,'11242','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1243,'CINTA MASKING 1.1/2 - 40YDX36MM 3M','',127,24,277,1,'11243','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1244,'CINTA MASKING 2 - 40YDX48MM 3M','',127,24,277,1,'11244','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1245,'TUBO PVC AG C7.5 SP 2.1/2X5MT NICOLL','',42,26,82,1,'11245','','',NULL,0,5,1,3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1246,'TUBO PVC AG C7.5 SP 1.1/2X5MT PLASTICA','',14,26,81,1,'11246','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1247,'TUBO PVC AG C10 SP 1.1/4X5MT PLASTICA 2','',14,26,81,0,'11247','','','',0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1248,'TUBO PVC AG C10 SP 1.1/4X5MT PLASTICA','',14,26,81,1,'11248','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1249,'DISCO DIAMANTADO 9 plg 230 GRIS SEGMEN. KAMASA','',138,24,187,1,'11249','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1250,'SUMIDERO 2 CROMADO SEVILLA','',218,24,37,1,'11250','','',NULL,0,5,1,0.08,NULL,'',0,0,NULL,1,0,0,0,0),(1251,'SUMIDERO 4 CROMADO ND','',36,24,37,1,'11251','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1252,'SIKAFLEX 11FC PLUS GRIS X 300ML','',59,24,278,1,'11252','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1253,'SOUDAFLEX 40FC GRIS 300ML SOUDAL','',139,24,279,1,'11253','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1254,'TAPA CIEGA OCTAGONAL ND','',36,24,283,1,'11254','','',NULL,0,5,1,0.02,NULL,NULL,0,0,NULL,1,0,0,0,0),(1255,'TAPA CIEGA RECTANGULAR ND','',36,24,283,1,'11255','','',NULL,0,5,1,0.02,NULL,NULL,0,0,NULL,1,0,0,0,0),(1256,'HILO PARA ALBAÑILERIA 0.90MMX100 MT VERDE ARATY','',140,24,255,1,'11256','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1257,'HILO PARA ALBAÑILERIA 1MMX100 MT VERDE ARATY','',140,24,255,1,'11257','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1258,'DISCO LIJA FLAP GR40 115MM KAMASA','',138,24,284,1,'11258','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1259,'DISCO LIJA FLAP GR60 115MM KAMASA','',138,24,284,1,'11259','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1260,'DISCO LIJA FLAP GR80 115MM KAMASA','',138,24,284,1,'11260','','',NULL,0,5,1,0.12,NULL,NULL,0,0,NULL,1,0,0,0,0),(1261,'CORDON MELLIZO 2X18 AWG CELSA','',141,35,139,0,'11261','','','',0,13,1,0.02,NULL,NULL,0,0,NULL,1,0,0,0,0),(1262,'NIVEL PLATICO 10 plg KAMASA ','',138,24,226,1,'11262','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1263,'NIVEL PLATICO 14 plg KAMASA ','',138,24,226,1,'11263','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1264,'CLAVO C/C ACERO 4.5 X 100MM (4 plg) BILDER','',148,28,77,1,'11264','','',NULL,0,3,1,0.003,NULL,'',0,0,NULL,1,0,0,0,0),(1265,'CAJA DE PASE 100X100X70 - 4X4X2 XACE','',143,24,280,1,'11265','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1266,'TRAMPA PVC 2 SAL CR 3/4 INYECTOPLAST','',144,24,38,1,'11266','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1267,'PEGAMENTO 28ML(1/64) TUBOCOL','',145,24,23,0,'11267','','','',0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1268,'UNION GALVANIZADA 1/2 ND','',36,24,281,1,'11268','','',NULL,0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1269,'PEGAMENTO DE CONTACTO 150ML 1/32 AFRICANO','',146,24,282,1,'11269','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1270,'CODO GALVANIZADO 3/4 ND','',36,24,101,1,'11270','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1271,'TRAMPA CORRUGADA UNV. C/DES. 1.1/4 VIKINGO','',135,24,38,1,'11271','','',NULL,0,5,1,0.2,NULL,'',0,0,NULL,1,0,0,0,0),(1272,'LIMPIATODO FLORAL 1LT AROMA LIMON','',36,1,269,1,'11272','','',NULL,0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1273,'LIMPIATODO FLORAL 1LT AROMA LAVANDA','',36,1,269,1,'11273','','',NULL,0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1274,'LIMPIATODO FLORAL 1LT AROMA FLORES','',36,1,269,1,'11274','','',NULL,0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1275,'LIMPIATODO FLORAL 1LT AROMA BEBE','',36,1,269,1,'11275','','',NULL,0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1276,'LIMPIATODO FLORAL 1LT AROMA TULIPAN','',36,1,269,1,'11276','','',NULL,0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1277,'LIMPIATODO FLORAL GL 3.5L AROMA LIMON','',36,39,269,1,'11277','','',NULL,0,5,1,3.5,NULL,'',0,0,NULL,1,0,0,0,0),(1278,'LIMPIATODO FLORAL GL 3.5L AROMA LAVANDA','',36,39,269,1,'11278','','',NULL,0,5,1,3.5,NULL,'',0,0,NULL,1,0,0,0,0),(1279,'LIMPIATODO FLORAL GL 3.5L AROMA FLORES','',36,39,269,1,'11279','','',NULL,0,5,1,3.5,NULL,'',0,0,NULL,1,0,0,0,0),(1280,'LIMPIATODO FLORAL GL 3.5L AROMA BEBE','',36,39,269,1,'11280','','',NULL,0,5,1,3.5,NULL,'',0,0,NULL,1,0,0,0,0),(1281,'LIMPIATODO FLORAL GL 3.5L AROMA TULIPAN','',36,39,269,1,'11281','','',NULL,0,5,1,3.5,NULL,'',0,0,NULL,1,0,0,0,0),(1282,'TANQUE 2500 LT AZUL ETERNIT','',63,24,105,1,'11282','','',NULL,0,5,1,25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1283,'SIKADUR 32 X 1KG','',59,28,286,1,'11283','','',NULL,0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1284,'LLANTA SIN CAMARA REFORZADA TRUPER','',28,24,12,1,'11284','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1285,'TAPA CIEGA RECTANGULAR HOME LIGHT','',68,24,283,1,'11285','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1286,'PERNO AUTOPERFORANTE 10X3/4 BILDER','',148,75,287,1,'11286','','',NULL,0,5,1,0.005,NULL,'',0,0,NULL,1,0,0,0,0),(1287,'PERNO AUTOPERFORANTE 10X1 BILDER','',148,75,287,1,'11287','','',NULL,0,5,1,0.005,NULL,'',0,0,NULL,1,0,0,0,0),(1288,'TARUGO NARANJA ND','',36,76,289,1,'11288','','',NULL,0,5,1,0.001,NULL,NULL,0,0,NULL,1,0,0,0,0),(1289,'STOVE BOLTS 5/32 X 1.1/2 MSK','',149,77,288,1,'11289','','',NULL,0,5,1,0.002,NULL,NULL,0,0,NULL,1,0,0,0,0),(1293,'CIZALLA DE 24`` BELLOTA','',26,24,244,1,'11293','','',NULL,0,5,1,2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1294,'TRIPLAY 18MMX1.22X2.44 LUPUNA','',112,24,40,1,'11294','','',NULL,0,5,1,10,NULL,NULL,0,0,NULL,1,0,0,0,0),(1295,'NIVEL METALICO 24 plg KAMASA ','',138,24,226,1,'11295','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1296,'THINNER ACRILICO 5GL POLIFLOR','',122,24,242,1,'11296','','',NULL,0,5,1,20,NULL,'',0,0,NULL,1,0,0,0,0),(1297,'SERVICIO POR DESESTIBA','',36,24,291,1,'11297','','',NULL,0,23,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(1298,'ANILLO P/TUBO ALCANTARILLADO 250MM NICOLL','',42,24,61,1,'11298','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1299,'RECOGEDOR ECONOMICO','',36,24,216,1,'11299','','',NULL,0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(1300,'RECOGEDOR LORETO','',36,24,216,1,'11300','','',NULL,0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(1301,'ESCOBA LUCERITO','',36,24,102,1,'11301','','',NULL,0,5,1,0.65,NULL,NULL,0,0,NULL,1,0,0,0,0),(1302,'ESCOBA ESCOBAZA','',36,24,102,1,'11302','','',NULL,0,5,1,0.65,NULL,NULL,0,0,NULL,1,0,0,0,0),(1303,'ESCOBA CLORINDA','',151,24,102,1,'11303','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1304,'PALO DE ESCOBA','',36,24,292,1,'11304','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1305,'TRAPO YUTE','',36,24,293,1,'11305','','',NULL,0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(1306,'LLAVE LAVATORIO COCINA PESAD. M/CRUCETA APACHE','',99,24,294,1,'11306','','',NULL,0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(1307,'LLAVE LAVATORIO COCINA PESAD. M/ACRILICO FAVINSUR','',152,24,294,1,'11307','','',NULL,0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(1308,'TUBO DE ABASTO VINILO 40CM 1/2 X 1/2 HYDRA','',147,24,51,1,'11308','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1309,'TUBO DE ABASTO VINILO 40CM 1/2 X 7/8 HYDRA','',147,24,51,1,'11309','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1310,'CANDADO LATON 25MM DEXTER','',153,24,192,1,'11310','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1311,'CANDADO DORADO 20MM JPC','',229,24,192,1,'11311','','',NULL,0,5,1,0.2,NULL,'',0,0,NULL,1,0,0,0,0),(1312,'CANDADO DORADO 25MM JPC','',229,24,192,1,'11312','','',NULL,0,5,1,0.25,NULL,'',0,0,NULL,1,0,0,0,0),(1313,'CANDADO DORADO 32MM JPC','',229,24,192,1,'11313','','',NULL,0,5,1,0.4,NULL,'',0,0,NULL,1,0,0,0,0),(1314,'LLAVE LAVATORIO COCINA P/CHICO FLEX. Z C&A','',43,24,294,1,'11314','','','',0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(1315,'UNION UNIVERSAL PVC 1 C&A','',43,24,172,1,'11315','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1316,'UNION UNIVERSAL PVC 1.1/2 C&A','',43,24,172,1,'11316','','',NULL,0,5,1,0.13,NULL,NULL,0,0,NULL,1,0,0,0,0),(1317,'TRIZ 3 GR','',36,24,295,1,'11317','','',NULL,0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1318,'CUCHILLA TERMOMAG. KG RIEL DIN 2P 25A G.E.','',89,24,207,1,'11318','','',NULL,0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(1319,'REDUC. PVC SAL ISO S25 110MMX4 ND','',36,24,21,1,'11319','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1320,'TUBO PVC SEL 1X3MT NICOLL','',42,24,115,1,'11320','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1321,'CLAVO C/C 3/4X17 PRODAC','',17,13,29,1,'11321','','',NULL,0,3,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(1322,'DISCO C/F 4.1/2 DWAL','',36,24,107,1,'11322','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1323,'DISCO C/F 7 DWAL','',36,24,107,1,'11323','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1324,'DISCO TRONZADORA 14 plg  DWAL','',36,24,107,1,'11324','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1325,'DISCO DIAMANTADO P/CONCRETO 4.1/2 ASAKI','',36,24,187,1,'11325','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1326,'DISCO DIAMANTADO P/CONCRETO 7 ADRIANO','',36,24,187,1,'11326','','',NULL,0,5,1,0.35,NULL,'',0,0,NULL,1,0,0,0,0),(1327,'TABLERO PVC 3P/1LLAVES C/RIEL XACE','',143,24,59,1,'11327','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1328,'TABLERO PVC 5P/2LLAVES C/RIEL KADISA','',36,24,59,1,'11328','','',NULL,0,5,1,0.25,NULL,'',0,0,NULL,1,0,0,0,0),(1329,'TABLERO PVC 12P/6LLAVES C/RIEL XACE','',143,24,59,1,'11329','','',NULL,0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(1330,'CAJA RECTANGULAR PVC OMEGA','',36,24,174,1,'11330','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1331,'ARENA GRUESA DE PATAPO','',36,38,71,0,'11331','','','',0,16,1,1000,NULL,NULL,0,0,NULL,1,0,0,0,0),(1332,'SIKA 1 X 200LT','',59,67,45,1,'11332','','',NULL,0,5,1,215,NULL,NULL,0,0,NULL,1,0,0,0,0),(1333,'SIKAFLEX 11FC PLUS GRIS X 600ML','',59,24,278,1,'11333','','',NULL,0,5,1,0.7,NULL,NULL,0,0,NULL,1,0,0,0,0),(1334,'SIKADUR 32 X 5KG','',59,59,286,1,'11334','','',NULL,0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1335,'SIKA FILL TECHO 3 X 4LT','',59,68,296,1,'11335','','',NULL,0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1336,'SIKA FILL TECHO 3 X 20LT','',59,67,296,1,'11336','','',NULL,0,5,1,22,NULL,NULL,0,0,NULL,1,0,0,0,0),(1337,'SIKA ANTISOLS X 4LT','',59,68,297,1,'11337','','',NULL,0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1338,'SIKA ANTISOLS X 20LT','',59,67,297,1,'11338','','',NULL,0,5,1,22,NULL,NULL,0,0,NULL,1,0,0,0,0),(1339,'SIKA PEGA ENCHAPE BLANCO FLEXIBLE X 25KG','',59,7,298,1,'11339','','',NULL,0,5,1,25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1340,'SIKA PEGA ENCHAPE GRIS X 25KG','',59,7,298,1,'11340','','',NULL,0,5,1,25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1341,'SIKAMENT PLASTIFICANTE 290 N X 4LT','',59,68,299,1,'11341','','',NULL,0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1342,'SIKAMENT PLASTIFICANTE 290 N X 20LT','',59,67,299,1,'11342','','',NULL,0,5,1,22,NULL,NULL,0,0,NULL,1,0,0,0,0),(1343,'PINTURA LATEX PATO AZUL ELECTRICO 4LT CPP','',133,68,147,1,'11343','','',NULL,0,5,1,5.75,NULL,NULL,0,0,NULL,1,0,0,0,0),(1344,'PINTURA LATEX PATO VIOLETA 4LT CPP','',133,68,147,1,'11344','','',NULL,0,5,1,5.75,NULL,NULL,0,0,NULL,1,0,0,0,0),(1345,'MALLA OLIMPICA AWG-10 PRODAC','',17,45,181,1,'11345','','',NULL,0,13,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1346,'LADRILLO TECHO 15X30X30 CERAM. LAMBAYEQUE','',16,24,8,1,'11346','','',NULL,0,5,1,7.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1347,'LADRILLO TECHO 12X30X30 CERAM. LAMBAYEQUE','',16,24,8,1,'11347','','',NULL,0,5,1,6.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1348,'SIKA 3 ACELERENTE X 20 LT','',59,67,45,1,'11348','','',NULL,0,5,1,22,NULL,NULL,0,0,NULL,1,0,0,0,0),(1349,'SEÑALIZACION EXTINTOR','',36,24,300,1,'11349','','',NULL,0,5,1,0.005,NULL,NULL,0,0,NULL,1,0,0,0,0),(1350,'SEÑALIZACION SALIDA DERECHA','',36,24,300,1,'11350','','',NULL,0,5,1,0.005,NULL,NULL,0,0,NULL,1,0,0,0,0),(1351,'SEÑALIZACION SALIDA IZQUIERDA','',36,24,300,1,'11351','','',NULL,0,5,1,0.005,NULL,NULL,0,0,NULL,1,0,0,0,0),(1352,'SEÑALIZACION INGRESO','',36,24,300,1,'11352','','',NULL,0,5,1,0.005,NULL,NULL,0,0,NULL,1,0,0,0,0),(1353,'SEÑALIZACION  ZONA SEGURA  EN CASO DE SISMO','',36,24,300,1,'11353','','',NULL,0,5,1,0.005,NULL,NULL,0,0,NULL,1,0,0,0,0),(1354,'SEÑALIZACION BOTIQUIN DE 22.5X15CM','',36,24,300,1,'11354','','',NULL,0,5,1,0.005,NULL,NULL,0,0,NULL,1,0,0,0,0),(1355,'EXTINTOR 6KG NORMADO ABC POLVO QUIMICO KAZO','',36,24,208,1,'11355','','',NULL,0,5,1,6,NULL,NULL,0,0,NULL,1,0,0,0,0),(1356,'BOTIQUIN MADERA 20X30 CM IMPLE','',36,24,302,1,'11356','','',NULL,0,5,1,3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1357,'BOTIQUIN DE PRIMEROS AUXILIOS','',36,24,302,1,'11357','','',NULL,0,5,1,4,NULL,NULL,0,0,NULL,1,0,0,0,0),(1358,'CONO PVC NARANJA 36 plg CLUTE','',36,24,164,1,'11358','','',NULL,0,5,1,2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1359,'CINTA PELIGRO 200MT ROJO','',36,16,65,1,'11359','','',NULL,0,11,1,5,NULL,'',0,0,NULL,1,0,0,0,0),(1360,'CONO PVC NARANJA 18 plg 3LB CLUTE','',36,24,164,1,'11360','','',NULL,0,5,1,2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1361,'CORTAVIENTO NARANJA','',36,24,303,1,'11361','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1362,'CORTAVIENTO AZUL','',36,24,303,1,'11362','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1363,'TAPON DE OIDO BOLSA SM','',36,24,47,1,'11363','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1364,'ZAPAPICO 5LB SIN MANGO TRUPER','',28,24,26,1,'11364','','',NULL,0,5,1,3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1365,'MARTILLO 20 ONZ  29MM S/PULIR TRAMONTINA','',76,24,130,1,'11365','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1366,'COMBA C/M 6LB C&A','',43,24,53,1,'11366','','',NULL,0,5,1,3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1367,'CIZALLA DE 18`` UYUSTOOLS','',100,24,244,1,'11367','','',NULL,0,5,1,2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1368,'CIZALLA DE 24`` UYUSTOOLS','',100,24,244,1,'11368','','',NULL,0,5,1,3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1369,'BROCHA C/M PLASTICO 2 plg PRETUL','',41,24,156,1,'11369','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1370,'BROCHA C/M PLASTICO 5 plg PRETUL','',41,24,156,1,'11370','','',NULL,0,5,1,0.25,NULL,'',0,0,NULL,1,0,0,0,0),(1371,'BROCHA C/M PLASTICO 4 plg PRETUL','',41,24,156,1,'11371','','',NULL,0,5,1,0.25,NULL,'',0,0,NULL,1,0,0,0,0),(1372,'DESARMADOR PLANO 3/16 X 6 plg PRETUL','',41,24,196,1,'11372','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1373,'DESARMADOR PLANO 3/16 X 4 plg PRETUL','',41,24,196,1,'11373','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1374,'DESARMADOR CRUZ 3/16 X 6 plg PRETUL','',41,24,196,1,'11374','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1375,'DESARMADOR CRUZ 3/16 X 4 plg PRETUL','',41,24,196,1,'11375','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1376,'AMOLADORA G720 BLACK DECKER','',156,24,304,1,'11376','','',NULL,0,5,1,0.7,NULL,NULL,0,0,NULL,1,0,0,0,0),(1377,'NIVEL 18 plg PROFESIONAL TRUPER','',28,24,226,1,'11377','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1378,'NIVEL 24 plg PROFESIONAL TRUPER','',28,24,226,1,'11378','','','',0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(1379,'NIVEL 36 plg PROFESIONAL TRUPER','',28,24,226,1,'11379','','',NULL,0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(1380,'NIVEL 14 plg PRETUL','',41,24,226,1,'11380','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1381,'NIVEL 18 plg PRETUL','',41,24,226,1,'11381','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1382,'NIVEL 24 plg PRETUL','',41,24,226,1,'11382','','','',0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(1383,'SEÑALIZACION SERVICIOS HIGIENICOS','',36,24,300,1,'11383','','',NULL,0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1384,'SEÑALIZACION USO OBL. CASCO DE SEGURIDAD','',36,24,300,1,'11384','','',NULL,0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1385,'SEÑALIZACION RIESGO ELECTRICO','',36,24,300,1,'11385','','',NULL,0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1386,'SEÑALIZACION SONRIA LO ESTAMOS FILMANDO','',36,24,300,1,'11386','','',NULL,0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1387,'PALETA DE SEGURIDAD PARE/SIGA','',36,24,305,1,'11387','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1388,'DISCO DIAM. CONTINUO 7´X7/8´ NORTON CLASS','',21,24,187,1,'11388','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1389,'DISCO DIAM. SEGMEN 7´X7/8´ NORTON CLASS','',21,24,187,1,'11389','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1390,'DISCO DIAM. TURBO 4-1/2 plgX7/8´ NORTON CLASS','',21,24,187,1,'11390','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1391,'LADRILLO KING KONG STANDAR LADRINORTE','',157,24,313,1,'11391','','',NULL,0,5,1,2.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1392,'TRIPLAY 18MMX1.22X2.44 FENOLICO','',36,24,40,1,'11392','','',NULL,0,5,1,12,NULL,'',0,0,NULL,1,0,0,0,0),(1393,'COMBA OCTAG. 12 LBS C/MANGO TRUPER','',28,24,53,1,'11393','','',NULL,0,5,1,6,NULL,NULL,0,0,NULL,1,0,0,0,0),(1394,'TANQUE 1100 LT AZUL ETERNIT','',63,24,105,1,'11394','','',NULL,0,5,1,15,NULL,'',0,0,NULL,1,0,0,0,0),(1395,'VALVULA FIV-CHECK SWING 1/2 SCHUBERT','',25,24,173,1,'11395','','',NULL,0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(1396,'NIPLE PVC AG C/R 1/2X1.1/2 NICOL','',42,24,76,1,'11396','','',NULL,0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(1397,'DISCO P/PULIR PISO 4.1/2 FST','',161,24,306,1,'11397','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1398,'DISCO DIAMANTADO SEGMENT. 4.1/2 HEFESTO','',36,24,187,1,'11398','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1399,'DISCO DIAMANTADO SEGMEN. 7 plg HEFESTO','',36,24,187,1,'11399','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1400,'ESCUADRA AMARILLA 10 plg ND','',36,24,307,1,'11400','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1401,'DESARMADOR INTERCAM. PROF. 107- 5 plg SINYE','',120,24,196,1,'11401','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1402,'PLANCHA D/BATIR 8 TOOLTECH','',160,24,322,1,'11402','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1403,'ESPATULA M/GOMA 3 plg TOOLTECH','',160,24,169,1,'11403','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1404,'ESPATULA M/GOMA 4 plg TOOLTECH','',160,24,169,1,'11404','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1405,'ESPATULA M/GOMA 5 plg TOOLTECH','',160,24,169,1,'11405','','',NULL,0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1406,'GUANTE INDUSTRIAL CORTE INCCO','',159,24,62,1,'11406','','',NULL,0,19,1,0.2,NULL,'',0,0,NULL,1,0,0,0,0),(1407,'WINCHA NEGRA 3MT X 16 INCCO','',159,36,60,1,'11407','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1408,'WINCHA NEGRA 5MT X 19 INCCO','',159,36,60,1,'11408','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1409,'WINCHA NEGRA 5MT X 25 INCCO','',159,36,60,1,'11409','','',NULL,0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1410,'BROCA P/CONCRETO 6MM (1/4) INCCO','',159,24,308,1,'11410','','',NULL,0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1411,'BROCA P/CONCRETO 8MM (5/16) INCCO','',159,24,308,1,'11411','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1412,'BROCA P/CONCRETO 10MM (3/8) INCCO','',159,24,308,1,'11412','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1413,'BROCA P/CONCRETO 12MM (1/2) INCCO','',159,24,308,1,'11413','','',NULL,0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(1414,'UNION CPVC SIMPLE 1/2 NICOLL','',42,24,44,1,'11414','','',NULL,0,5,1,0.03,NULL,NULL,0,0,NULL,1,0,0,0,0),(1415,'TEMPLE FINO SINOLIT BLANCO CAJA 25KG CPP','',133,18,309,1,'11415','','',NULL,0,5,1,25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1416,'PASTA FINA P/MUROS BLANCO 20LT CPP','',133,67,259,1,'11416','','',NULL,0,5,1,22,NULL,'',0,0,NULL,1,0,0,0,0),(1417,'TEKNOCOLA EXTRA 4KG ','',116,80,260,1,'11417','','',NULL,0,5,1,5.75,NULL,NULL,0,0,NULL,1,0,0,0,0),(1418,'SELLADOR  150 BLANCO 20LT CPP','',133,67,258,1,'11418','','','',0,5,1,22,NULL,NULL,0,0,NULL,1,0,0,0,0),(1419,'PINTURA LATEX PATO ROJO 4LT CPP','',133,68,147,1,'11419','','',NULL,0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1420,'PINTURA LATEX SATINADO MOCHICA 4LT CPP','',133,68,257,1,'11420','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1421,'PINTURA LATEX SATINADO LIRIO AZUL 4LT CPP','',133,68,257,1,'11421','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1422,'PINTURA LATEX SATINADO AZUL BOHEMIO 4LT CPP','',133,68,257,1,'11422','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1423,'PINTURA LATEX SATINADO ROJO 4LT CPP','',133,68,257,1,'11423','','',NULL,0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1424,'INTERRUPTOR SIMPLE C/MUT P/EMP 3 VIAS- DELUXE HOME LIGHT','',68,36,140,1,'11424','','',NULL,0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1425,'SOCATE P/EMPOTRAR DELUXE HOME LIGHT','',68,44,143,1,'11425','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1426,'TOMACORRIENTE DOBLE P/EMPOT C/SALIDA A TIERRA- DELUXE HOME LIGHT','',68,36,142,1,'11426','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1427,'INTERRUPTOR DOBLE P/EMPOT DELUXE HOME LIGHT','',68,24,140,1,'11427','','',NULL,0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1428,'CABLE VULACNIZADO 2X14 NLT INDECO','',66,35,310,1,'11428','','',NULL,0,13,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(1429,'CABLE VULACNIZADO 2X12 NLT INDECO','',66,35,310,1,'11429','','',NULL,0,13,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(1430,'CUCHILLA TERMOMAG DIN 2PX63A BTICINO','',81,44,207,1,'11430','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1431,'ALCOHOL 96° 1L ENVASADO','',36,1,311,1,'11431','','',NULL,0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1432,'ALCOHOL PURO 96° 500 ML ND','',36,4,311,1,'11432','','',NULL,0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1433,'ALCOHOL PURO 96° 1000 ML ND','',36,1,311,1,'11433','','',NULL,0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1434,'TANQUE 600 LT ARENA ETERNIT','',63,24,105,1,'11434','','','',0,5,1,10,NULL,NULL,0,0,NULL,1,0,0,0,0),(1435,'TEMPLE FINO BLANCO CAJA 25KG VELSALIT','',162,18,312,1,'11435','','','',0,5,1,25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1436,'TEMPLE FINO BLANCO BOLSA 5KG VELSALIT','',162,59,312,1,'11436','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1437,'COLA SINTETICA 1KG SACHET VELSALIT','',162,28,260,1,'11437','','','',0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1438,'LADRILLO TECHO 12X30X30 CER. SOL DEL NORTE','',19,24,8,1,'11438','','','',0,5,1,6.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1439,'MANGUERA POLITILENO 20MM(1/2) PN 8 C/LINEA X100MTS','',52,35,176,1,'11439','','','',0,13,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(1440,'MANGUERA POLITILENO 25MM(3/4) PN 8 C/LINEA X 100MTS','',52,35,176,1,'11440','','','',0,13,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(1441,'MANGUERA POLITILENO 50MM(1.1/2) PN 8 C/ LINEA X 100MTS','',52,35,176,1,'11441','','','',0,13,1,0.25,NULL,'',0,0,NULL,1,0,0,0,0),(1442,'MANGUERA POLITILENO 63MM(2 plg) PN 8 C/LINEA X 100MTS','',52,35,176,1,'11442','','','',0,13,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(1443,'ENLACE UNION 20MM(1/2) x 20MM(1/2) PN16 IRRIPLAST','',163,24,320,1,'11443','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1444,'ENLACE UNION 25MM(3/4) x 25MM(3/4) PN16 IRRIPLAST','',163,24,320,1,'11444','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1445,'ENLACE UNION 32MM(1 plg) x 32MM(1 plg) PN16 IRRIPLAST','',163,24,320,1,'11445','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1446,'ENLACE UNION 50MM(1.1/2) x 50MM(1.1/2) PN16 IRRIPLAST','',163,24,320,1,'11446','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1447,'VALVULA DE PVC ROSCA HEMBRA 3/4 IRRIPLAST','',163,24,24,1,'11447','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1448,'VALVULA DE PVC ROSCA HEMBRA 1 IRRIPLAST','',163,24,24,1,'11448','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1449,'VALVULA DE PVC ROSCA HEMBRA 1.1/2 IRRIPLAST','',163,24,24,1,'11449','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1450,'ADAPTADOR R/MACHO 25MM(3/4) X 3/4 PN16 IRRIPLAST','',163,24,44,1,'11450','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1451,'ADAPTADOR R/MACHO 32MM(1) X 1 PN16 IRRIPLAST','',163,24,43,1,'11451','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1452,'ADAPTADOR R/MACHO 50MM(1.1/2) X 1.1/2 PN16 IRRIPLAST','',163,24,43,1,'11452','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1453,'TEE 25MM(3/4)X 25MM(3/4) X 25MM(3/4) PN16 IRRIPLAST','',163,24,19,1,'11453','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1454,'TEE 32MM(1)X 32MM(1) X 32MM(1) PN16 IRRIPLAST','',163,24,19,1,'11454','','','',0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1455,'TEE 50MM(1.1/2)X 50MM(1.1/2) X 50MM(1.1/2) PN16 IRRIPLAST','',163,24,19,1,'11455','','','',0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1456,'TAPON 25MM(3/4) PN16 IRRIPLAST','',163,24,47,1,'11456','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1457,'TAPON 32MM(1) PN16 IRRIPLAST','',163,24,47,1,'11457','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1458,'TAPON 50MM(1.1/2) PN16 IRRIPLAST','',163,24,47,1,'11458','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1459,'PINTURA LATEX PATO MELON 4LTS CPP','',133,68,147,1,'11459','','','',0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1461,'PINTURA LATEX PATO BLANCO HUMO 20 LTS CPP','',133,67,147,1,'11461','','','',0,5,1,29.7,NULL,'',0,0,NULL,1,0,0,0,0),(1462,'PINTURA LATEX PATO CELESTE 20LTS CPP','',133,67,147,1,'11462','','','',0,5,1,29.7,NULL,'',0,0,NULL,1,0,0,0,0),(1463,'PINTURA LATEX PATO CREMA 20 LTS CPP','',133,67,147,1,'11463','','','',0,5,1,5.75,NULL,'',0,0,NULL,1,0,0,0,0),(1464,'PINTURA LATEX PATO MARFIL 20 LTS CPP','',133,67,147,1,'11464','','','',0,5,1,29.7,NULL,'',0,0,NULL,1,0,0,0,0),(1465,'PINTURA LATEX SATINADO MARFIL 20 LT CPP','',133,67,257,1,'11465','','','',0,5,1,29.7,NULL,'',0,0,NULL,1,0,0,0,0),(1466,'VALVULA JARDIN PESADA 1/2 PALAN.VIR','',164,24,24,1,'11466','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1467,'UNION UNIVERSAL PVC 3/4 C&A','',43,24,172,1,'11467','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1468,'LLAVE LAVATORIO MUEBLE MODELO-A C&A','',43,24,294,1,'11468','','','',0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(1469,'LLAVE LAVATORIO MUEBLE MODELO-D C&A','',43,24,294,1,'11469','','','',0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(1470,'LLAVE LAVATORIO MUEBLE MODELO-Z C&A','',43,24,294,1,'11470','','','',0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(1471,'VALVULA CHECK SWING 1/2 VALMAX','',165,24,173,1,'11471','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1472,'VALVULA CHECK SWING 3/4 VALMAX','',165,24,173,1,'11472','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1473,'VALVULA CHECK SWING 1 VALMAX','',165,24,173,1,'11473','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1474,'DRIZA POLIPROPILENO 1/8 (ROLLO APROX 196M - 1KG)','',36,91,270,1,'11474','','','',0,3,1,0.005,NULL,'',0,0,NULL,1,0,0,0,0),(1475,'DRIZA POLIPROPILENO 3/16 (ROLLO APROX 350M - 5KG)','',36,70,270,1,'11475','','','',0,3,1,0.014,NULL,'',0,0,NULL,1,0,0,0,0),(1476,'RESPIRADOR KN95 5 CAPAS C&A','',43,24,321,1,'11476','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1477,'GUANTE LARGO REF. 14 plg P/SOLDAR C&A','',43,24,62,1,'11477','','','',0,19,1,0.2,NULL,'',0,0,NULL,1,0,0,0,0),(1478,'RODILLO P/PINTAR 3 plg C&A','',43,24,155,1,'11478','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1479,'PALANA RECTA PESADA C&A','',43,24,25,1,'11479','','','',0,5,1,0.6,NULL,NULL,0,0,NULL,1,0,0,0,0),(1480,'PLANCHA EMPASTAR LISA M/GOMA 5X11 C&A','',43,24,151,1,'11480','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1481,'PLANCHA D/BATIR M/GOMA 7 plg C&A','',43,24,322,1,'11481','','','',0,5,1,0.25,NULL,'',0,0,NULL,1,0,0,0,0),(1482,'MALLA GALVANIZADA 1/2 - BWG18 PLATIFICADA C&A','',43,34,48,1,'11482','','','',0,13,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(1483,'UNION PVC SAL SIMPLE 2 NICOLL','',42,93,118,1,'11483','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1484,'CLAVO C/C ACERO GALV. 4.5 X 90MM (3.5 plg) BILDER','',148,28,77,1,'11484','','','',0,3,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(1485,'FOCO LED 18W BOLA PHELIX','',77,52,219,1,'11485','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1486,'LLAVE DE PASO CPVC 3/4 P/SOLDAR PCP','',40,24,58,1,'11486','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1487,'TRAMPA PVC 2 plg C/REGISTRO METUSA','',166,24,38,1,'11487','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1488,'ANILLO DE CERA C/GUIA P/INODORO METUSA','',166,24,323,1,'11488','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1489,'TUBO DE ABASTO TRENZ VINILO 40CM 1/2 X 7/8 METUSA','',166,24,51,1,'11489','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1490,'TUBO DE ABASTO TRENZ POLIET 40CM 1/2 X 1/2 METUSA','',166,24,51,1,'11490','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1491,'TUBO DE ABASTO TRENZ POLIET 40CM 1/2 X 7/8 METUSA','',166,24,51,1,'11491','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1492,'EXTENSION C/3 TOMAS C/FOCO D/NEON 7.5MT HOME-LIGHT','',68,24,208,1,'11492','','','',0,5,1,0.4,NULL,'',0,0,NULL,1,0,0,0,0),(1493,'EXTENSION C/3 TOMAS C/FOCO D/NEON 10MT HOME-LIGHT','',68,24,208,1,'11493','','','',0,5,1,0.6,NULL,NULL,0,0,NULL,1,0,0,0,0),(1494,'EXTENSION C/3 TOMAS C/FOCO D/NEON 15MT HOME-LIGHT','',68,19,208,1,'11494','','','',0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1495,'EXTENSION C/3 TOMAS C/FOCO D/NEON 20MT HOME-LIGHT','',68,24,208,1,'11495','','','',0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1496,'MASCARILLA DESC. 3 PLIEGUES C&A','',43,52,210,1,'11496','','','',0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1501,'MALLA GALVANIZADA 1/2 - BWG23 PLATIFICADA C&A','',43,34,48,1,'11501','','','',0,13,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(1502,'LLAVE DE PASO ROSCADO 3/4 plg  IRRIPLAST','',163,24,58,1,'11502','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1503,'LLAVE DE PASO ROSCADO 1 plg  IRRIPLAST','',163,24,58,1,'11503','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1504,'LLAVE DE PASO ROSCADO 1.1/2 plg  IRRIPLAST','',163,24,58,1,'11504','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1505,'MANTA ARPILLERA 2X200 MT BLANCO ND','',36,50,180,1,'11505','','','',0,13,1,30,NULL,NULL,0,0,NULL,1,0,0,0,0),(1506,'NIVEL 14 plg PROFESIONAL TRUPER','',28,24,226,1,'11506','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1507,'PLOMADA #1 DE ZINC PRETUL','',41,24,324,1,'11507','','','',0,5,1,0.5,NULL,'',0,0,NULL,1,0,0,0,0),(1508,'HILO PARA ALBAÑILERIA 0.80MM X 100MT PRETUL','',41,24,255,1,'11508','','','',0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1509,'HILO PARA ALBAÑILERIA 1MM X 100MT PRETUL','',41,24,255,1,'11509','','','',0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1510,'TOMACORRIENTE DOBLE C/SAL TIERRA P/SOBREP. HOME LIGHT','',68,44,142,1,'11510','','','',0,5,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(1511,'CANDADO SIN 8 F70 FORTE','',167,24,327,1,'11511','','','',0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(1512,'CANDADO SIN 8 F40 FORTE','',167,24,327,1,'11512','','','',0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1513,'CANDADO SIN 8 F25 FORTE','',167,24,327,1,'11513','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1514,'CANDADO SIN 8 F30 FORTE','',167,24,327,1,'11514','','','',0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1515,'CANDADO SIN 8 F20 FORTE','',167,24,327,1,'11515','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1516,'CERRADURA CLÁSICA 226 DORADA FORTE','',167,24,326,1,'11516','','','',0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1517,'CANDADO SIN 8 F50 FORTE','',167,24,327,1,'11517','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1518,'CANDADO SIN 8 F60 FORTE','',167,24,327,1,'11518','','','',0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(1519,'CERRADURA BÚNKER 220 DORADA FORTE','',167,24,326,1,'11519','','','',0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1520,'CANDADO CON 8 F50 FORTE','',167,24,327,1,'11520','','','',0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(1521,'CANDADO CON 8 F60 FORTE','',167,24,327,1,'11521','','','',0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(1522,'CANDADO CON 8 F70 FORTE','',167,24,327,1,'11522','','','',0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(1523,'CERRADURA BÚNKER 230 DORADA FORTE','',167,24,326,1,'11523','','','',0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1524,'CERRADURA BLINDADA 740 METAL NEGRA FORTE','',167,24,326,1,'11524','','','',0,5,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(1525,'CERRADURA CALIFORNIA DORADA 1040 FORTE','',167,24,326,1,'11525','','','',0,5,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(1526,'POMO DORM AI-007 FORTE ','',167,24,325,1,'11526','','','',0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1527,'POMO DORM BP-007 FORTE','',167,24,325,1,'11527','','','',0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1528,'CERRADURA CLÁSICA 240 DORADA FORTE','',167,24,326,1,'11528','','','',0,5,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(1529,'CERRADURA BÚNKER 240 DORADA FORTE','',167,24,326,1,'11529','','','',0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1530,'CERRADURA BÚNKER 240 NEGRA FORTE','',167,24,326,1,'11530','','','',0,5,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(1531,'TANQUE CISTERNA 1350 LT C/ACC AZUL ETERNIT','',63,24,105,1,'11531','','','',0,5,1,20,NULL,NULL,0,0,NULL,1,0,0,0,0),(1532,'TANQUE CISTERNA 2500 LT C/ACC AZUL ETERNIT','',63,24,105,1,'11532','','','',0,5,1,35,NULL,NULL,0,0,NULL,1,0,0,0,0),(1533,'ALDABA NACIONAL 2 plg ND','',36,24,329,1,'11533','','','',0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1534,'ALDABA NACIONAL 2.1/2 plg ND','',36,24,329,1,'11534','','','',0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1535,'ALDABA NACIONAL 3 plg ND','',36,24,329,1,'11535','','','',0,5,1,0.07,NULL,'',0,0,NULL,1,0,0,0,0),(1536,'ALDABA NACIONAL 4 plg ND','',36,24,329,1,'11536','','','',0,5,1,0.07,NULL,'',0,0,NULL,1,0,0,0,0),(1537,'PICAPORTE BLISTER 3 plg VITALE','',230,24,331,1,'11537','','','',0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(1538,'PICAPORTE BLISTER 4 plg VITALE','',230,24,331,1,'11538','','','',0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(1539,'ESCOBILLA DE FIERRO 6 HILERAS ND','',36,24,332,1,'11539','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1540,'PERNO COCHE 1/4 X 1 plg C/TUERCA ND','',36,24,333,1,'11540','','','',0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1541,'PERNO COCHE 1/4 X 1.1/2 plg C/TUERCA ND','',36,24,333,1,'11541','','','',0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1542,'PERNO COCHE 1/4 X 2 plg C/TUERCA ND','',36,24,333,1,'11542','','','',0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1543,'PERNO COCHE 1/4 X 2.1/2 plg C/TUERCA ND','',36,24,333,1,'11543','','','',0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1544,'PERNO COCHE 1/4 X 3 plg C/TUERCA ND','',36,24,333,1,'11544','','','',0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1545,'PERNO COCHE 1/4 X 3.1/2 plg C/TUERCA ND','',36,24,333,1,'11545','','','',0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1546,'PERNO COCHE 1/4 X 4 plg C/TUERCA ND','',36,24,333,1,'11546','','','',0,5,1,0.06,NULL,NULL,0,0,NULL,1,0,0,0,0),(1547,'TORNILLO  P/AGLOMERADO M- 3X16 BARCO','',204,24,328,1,'11547','','','',0,5,1,0.0005,NULL,NULL,0,0,NULL,1,0,0,0,0),(1548,'TORNILLO  P/AGLOMERADO M- 3X20 BARCO','',36,24,328,1,'11548','','','',0,5,1,0.0005,NULL,NULL,0,0,NULL,1,0,0,0,0),(1549,'TORNILLO P/AGLOMERADO M-4X25 BARCO','',204,24,328,1,'11549','','','',0,5,1,0.0005,NULL,NULL,0,0,NULL,1,0,0,0,0),(1550,'TORNILLO P/AGLOMERADO M-4X40 BARCO','',204,24,328,1,'11550','','','',0,5,1,0.0005,NULL,NULL,0,0,NULL,1,0,0,0,0),(1551,'ESCUADRA LIVIANA 10 plgDENACET','',170,24,307,1,'11551','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1552,'ESCUADRA LIVIANA 12 plgDENACET','',170,24,307,1,'11552','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1553,'ESCUADRA PESADA 10 plgASAKI','',168,24,307,1,'11553','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1554,'ESCUADRA PESADA 12 plgASAKI','',168,24,307,1,'11554','','','',0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1555,'PERNO AUTOPERFORANTE 10X1.1/2 BILDER','',148,75,287,1,'11555','','','',0,5,1,0.005,NULL,'',0,0,NULL,1,0,0,0,0),(1556,'ABRAZADERA 1/2 LUZ','',36,24,335,1,'11556','','','',0,5,1,0.005,NULL,NULL,0,0,NULL,1,0,0,0,0),(1557,'ABRAZADERA 3/4 LUZ - 1/2 AGUA','',36,24,335,1,'11557','','','',0,5,1,0.008,NULL,NULL,0,0,NULL,1,0,0,0,0),(1558,'ABRAZADERA 1 LUZ - 3/4 AGUA','',36,24,335,1,'11558','','','',0,5,1,0.09,NULL,NULL,0,0,NULL,1,0,0,0,0),(1559,'ABRAZADERA 2 LUZ - 1.1/2 AGUA','',36,24,335,1,'11559','','','',0,5,1,0.12,NULL,'',0,0,NULL,1,0,0,0,0),(1560,'ABRAZADERA 4 AGUA','',36,24,335,1,'11560','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1561,'PLOMADA ALBAÑIL PEQUEÑA','',36,24,324,1,'11561','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1562,'PLOMADA ALBAÑIL GRANDE','',36,24,324,1,'11562','','','',0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1563,'PLOMADA ALBAÑIL BARRILITO','',36,24,324,0,'11563','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1564,'GUANTE ANTICORDE LATEX PLOMO ADRIANO','',169,24,62,1,'11564','','','',0,19,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(1565,'PROTECTOR FACIAL NICOLL','',42,24,336,1,'11565','','','',0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(1566,'PINTURA LATEX SATINADO VERDE PERMANENTE 4LT CPP','',133,68,257,1,'11566','','','',0,5,1,5.1,NULL,'',0,0,NULL,1,0,0,0,0),(1567,'PINTURA LATEX SATINADO CREMA 20LT CPPUNI','',133,67,257,1,'11567','','','',0,5,1,23,NULL,'',0,0,NULL,1,0,0,0,0),(1568,'PINTURA LATEX SATINADO GRIS HORIZONTE 20LT CPP','',133,67,257,1,'11568','','','',0,5,1,23,NULL,'',0,0,NULL,1,0,0,0,0),(1569,'PINTURA LATEX SATINADO GRIS CLARO 20LT CPP','',133,67,257,1,'11569','','','',0,5,1,23,NULL,'',0,0,NULL,1,0,0,0,0),(1570,'PINTURA LATEX SATINADO BLANCO HUESO 20 LT CPP','',133,67,257,1,'11570','','','',0,5,1,23,NULL,'',0,0,NULL,1,0,0,0,0),(1571,'IMPRIMANTE BLANCO 5GL BOLSA CPP','',133,7,148,NULL,'11571','','',NULL,0,5,1,25,NULL,'',0,0,NULL,1,0,0,0,0),(1572,'TANQUE PE ARENA 2700 LT C/ACC COMPL NICOLL','',42,24,120,1,'11572','','','',0,5,1,20,NULL,NULL,0,0,NULL,1,0,0,0,0),(1573,'BARNIZ MARINO 1 GL TEKNO','',171,39,337,1,'11573','','','',0,5,1,4.5,NULL,'',0,0,NULL,1,0,0,0,0),(1574,'LACA SELLADORA CLASICA 1/4 GL PARACAS','',132,58,261,1,'11574','','','',0,5,1,1.5,NULL,'',0,0,NULL,1,0,0,0,0),(1575,'LACA PIROXILINA CRISTAL 1/4 GL PARACAS','',132,58,338,1,'11575','','','',0,5,1,1.5,NULL,'',0,0,NULL,1,0,0,0,0),(1576,'BARNIZ MARINO 1/4 GL TEKNO','',171,58,337,1,'11576','','','',0,5,1,1.5,NULL,'',0,0,NULL,1,0,0,0,0),(1577,'TEKNOCOLA PACK CLASICA 1KG ','',171,28,260,1,'11577','','','',0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1578,'TEKNOCOLA PACK CLASICA 4KG ','',171,80,260,1,'11578','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1579,'TINTE AL ALCOHOL AÑEJO 1/4 LT PARACAS','',132,79,339,1,'11579','','','',0,5,1,0.5,NULL,'',0,0,NULL,1,0,0,0,0),(1580,'TINTE AL ALCOHOL CARAMELO 1/4 LT PARACAS','',132,79,339,1,'11580','','','',0,5,1,0.5,NULL,'',0,0,NULL,1,0,0,0,0),(1581,'BARNIZ D/D A5. 1L FRASCO','',171,1,337,1,'11581','','','',0,5,1,1.5,NULL,'',0,0,NULL,1,0,0,0,0),(1582,'REDUCTOR D/D. 1/4 GL TEKNO','',171,58,339,1,'11582','','','',0,5,1,1.5,NULL,'',0,0,NULL,1,0,0,0,0),(1583,'TINTE AL ALCOHOL CAOBA 1/4 LT PARACAS','',132,79,339,1,'11583','','','',0,5,1,1.5,NULL,'',0,0,NULL,1,0,0,0,0),(1584,'BARNIZ MARINO TRANSPARENTE 1GL PARACAS','',132,39,337,1,'11584','','','',0,5,1,5,NULL,'',0,0,NULL,1,0,0,0,0),(1585,'ALCOHOL GEL SPRAY 100ML NEX','',97,24,311,1,'11585','','','',0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1586,'LAVATORIO COCINA 1 POZA CON ESCURRIDOR ND','',36,24,340,1,'11586','','','',0,5,1,3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1587,'PINTURA LATEX SATINADO AMARILLO 4LT CPP','',133,68,257,1,'11587','','','',0,5,1,5.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1588,'TINTE AL ALCOHOL ROBLE 1/4 LT PARACAS ','',132,79,339,1,'11588','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1589,'TINTE AL ALCOHOL NOGAL 1/4 LT PARACAS ','',132,79,339,1,'11589','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1590,'TINTE AL ALCOHOL CEDRO 1/4 LT PARACAS ','',132,79,339,1,'11590','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1591,'LACA PIROXILINA CRISTAL 1GL PARACAS','',132,39,338,1,'11591','','','',0,5,1,5.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1592,'BARNIZ MARINO TRANSPARENTE 1/4 GL PARACAS','',132,39,337,1,'11592','','','',0,5,1,1.3,NULL,'',0,0,NULL,1,0,0,0,0),(1593,'PRODUCTO D/D B5. 1 L FRASCO','',36,1,339,1,'11593','','','',0,5,1,1.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1594,'TEKNOCOLA EXTRA 1KG ','',171,28,260,1,'11594','','','',0,5,1,0.6,NULL,NULL,0,0,NULL,1,0,0,0,0),(1595,'ESMALTE SINTETICO PINTOR NEGRO 1 GL CPP','',133,39,341,1,'11595','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1596,'ESMALTE SINTETICO PINTOR BLANCO 1 GL CPP','',133,39,341,1,'11596','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1597,'ESMALTE SINTETICO PINTOR VERDE OSCURO 1 GL CPP','',133,39,341,1,'11597','','','',0,5,1,5,NULL,'',0,0,NULL,1,0,0,0,0),(1598,'ESMALTE SINTETICO PINTOR VERDE ESMERALDA 1 GL CPP','',133,39,341,1,'11598','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1599,'ESMALTE SINTETICO PINTOR CATERPILLAR 1 GL CPP','',133,39,341,1,'11599','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1600,'ESMALTE SINTETICO PINTOR AMARILLO CAT 1 GL CPP','',133,39,341,1,'11600','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1601,'ESMALTE SINTETICO PINTOR AMARILLO CROMO 1 GL CPP','',133,39,341,1,'11601','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1602,'ESMALTE SINTETICO PINTOR MARFIL 1 GL CPP','',133,39,341,1,'11602','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1603,'ESMALTE SINTETICO PINTOR AMARILLO ORO 1 GL CPP','',133,39,341,1,'11603','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1604,'ESMALTE SINTETICO PINTOR CREMA 1 GL CPP','',133,39,341,1,'11604','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1605,'ESMALTE SINTETICO PINTOR VERDE NILO 1 GL CPP','',133,39,341,1,'11605','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1606,'ESMALTE SINTETICO PINTOR AZUL ELECTRICO 1 GL CPP','',133,39,341,1,'11606','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1607,'ESMALTE SINTETICO PINTOR VERDE CROMO 1 GL CPP','',133,39,341,1,'11607','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1608,'ESMALTE SINTÉTICO PINTOR ALUMINIO 1GL CPP','',133,39,341,1,'11608','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1609,'ESMALTE SINTÉTICO PINTOR CELESTE 1GL CPP','',133,39,341,1,'11609','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1610,'ESMALTE SINTÉTICO PINTOR GRANATE 1GL CPP','',133,39,341,1,'11610','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1611,'ESMALTE SINTÉTICO PINTOR ROSADO 1GL CPP','',133,39,341,1,'11611','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1612,'ESMALTE SINTÉTICO PINTOR GRIS NIEBLA 1GL CPP','',133,39,341,1,'11612','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1613,'ESMALTE SINTÉTICO PINTOR BLANCO HUMO 1GL CPP','',133,39,341,1,'11613','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1614,'ESMALTE SINTÉTICO PINTOR GRIS PERLA 1GL CPP','',133,39,341,1,'11614','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1615,'ESMALTE SINTÉTICO PINTOR NOGAL 1GL CPP','',133,39,341,1,'11615','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1616,'ESMALTE SINTÉTICO PINTOR GRIS OSCURO 1GL CPP','',133,39,341,1,'11616','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1617,'ESMALTE SINTÉTICO PINTOR ROJO OXIDO 1GL CPP','',133,39,341,1,'11617','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1618,'ESMALTE SINTÉTICO PINTOR ROJO MANDARIN 1GL CPP','',133,39,341,1,'11618','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1619,'ESMALTE SINTÉTICO PINTOR AMARILLO LUCERO 1GL CPP','',133,39,341,1,'11619','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1620,'ESMALTE SINTÉTICO PINTOR AMARILLO M.D 1GL CPP','',133,39,341,1,'11620','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1621,'ESMALTE SINTÉTICO PINTOR AZUL NAVAL 1GL CPP','',133,39,341,1,'11621','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1622,'ESMALTE SINTÉTICO PINTOR BAYO 1GL CPP','',133,39,341,1,'11622','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1623,'ESMALTE SINTÉTICO PINTOR AZUL ULTRAMAR 1GL CPP','',133,39,341,1,'11623','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1624,'ESMALTE SINTÉTICO PINTOR BERMELLON 1GL CPP','',133,39,341,1,'11624','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1625,'ESMALTE SINTÉTICO PINTOR NARANJA 1GL CPP','',133,39,341,1,'11625','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1630,'ESMALTE SINTÉTICO PINTOR AZUL MARINO 1GL CPP','',133,39,341,1,'11630','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1631,'ESMALTE SINTÉTICO PINTOR CAOBA 1GL CPP','',133,39,341,1,'11631','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1632,'ESMALTE SECADO RAPIDO ALUMINIO 1/4 GL VENCEDOR','',8,58,341,1,'11632','','','',0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1633,'ESMALTE SECADO RÁPIDO NEGRO 1/4 GL VENCEDOR','',8,58,341,1,'11633','','','',0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1634,'ESMALTE SECADO RAPIDO BLANCO 1/4 GL VENCEDOR','',8,58,341,1,'11634','','','',0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1635,'ESMALTE SINTÉTICO PINTOR GRANATE 1/4 GL CPP','',133,58,341,1,'11635','','','',0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1636,'ESMALTE SINTÉTICO PINTOR VERDE CROMO 1/4 GL CPP','',133,58,341,1,'11636','','','',0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1637,'ESMALTE SINTÉTICO PINTOR ROJO OXIDO 1/4 GL CPP','',133,58,341,1,'11637','','','',0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1638,'ESMALTE SINTÉTICO PINTOR ALUMINIO 1/4 GL CPP','',133,58,341,1,'11638','','','',0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1639,'ESMALTE SINTÉTICO PINTOR BAYO 1/4 GL CPP','',133,58,341,1,'11639','','','',0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1640,'ESMALTE SINTÉTICO PINTOR NEGRO 1/4 GL CPP','',133,24,341,1,'11640','','','',0,5,1,1.5,NULL,'',0,0,NULL,1,0,0,0,0),(1641,'ESMALTE SINTÉTICO PINTOR BLANCO 1/4 GL CPP','',133,58,341,1,'11641','','','',0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1642,'ESMALTE SECADO RAPIDO ALUMINIO 1 GL VENCEDOR','',8,39,341,1,'11642','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1643,'ESMALTE SECADO RAPIDO AMARILLO 1 GL VENCEDOR','',8,39,341,1,'11643','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1644,'ESMALTE SECADO RAPIDO AZUL 1 GL VENCEDOR','',8,39,341,1,'11644','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1645,'ESMALTE SECADO RAPIDO BAYO 1 GL VENCEDOR ','',8,39,341,1,'11645','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1646,'ESMALTE SECADO RAPIDO BLANCO 1 GL VENCEDOR','',8,39,341,1,'11646','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1647,'ESMALTE SECADO RAPIDO BLANCO HUMO 1 GL VENCEDOR','',8,39,341,1,'11647','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1648,'ESMALTE SECADO RAPIDO  MARFIL 1 GL VENCEDOR','',8,39,341,1,'11648','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1649,'ESMALTE SECADO RAPIDO  NEGRO 1 GL VENCEDOR','',8,39,341,1,'11649','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1650,'ESMALTE SECADO RAPIDO ROJO BERMELLON 1 GL VENCEDOR ','',8,39,341,1,'11650','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1651,'ESMALTE SECADO RAPIDO  VERDE 1 GL VENCEDOR','',8,39,341,1,'11651','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1652,'THINNER ACRILICO PREMIUN 1LT CPP','',133,58,242,1,'11652','','','',0,5,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(1653,'THINNER ACRILICO PREMIUN 3LT CPP','',133,60,242,1,'11653','','','',0,5,1,3,NULL,'',0,0,NULL,1,0,0,0,0),(1654,'THINNER EXTRA ACRILICO  1LT VENCEDOR','',8,58,242,1,'11654','','','',0,5,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(1655,'THINNER EXTRA ACRILICO  3LT VENCEDOR','',8,60,242,1,'11655','','','',0,5,1,3,NULL,'',0,0,NULL,1,0,0,0,0),(1656,'ZENACRYL BASE ZINCROMATO 55BZ VERDE1GLS','',133,39,342,1,'11656','','','',0,5,1,5,NULL,'',0,0,NULL,1,0,0,0,0),(1657,'ANTICORROSIVO STANDARD BLANCO 1 GL','',195,39,343,1,'11657','','','',0,5,1,5,NULL,'',0,0,NULL,1,0,0,0,0),(1658,'ANTICORROSIVO STANDARD GRIS 1 GL','',195,39,343,1,'11658','','','',0,5,1,5,NULL,'',0,0,NULL,1,0,0,0,0),(1659,'ANTICORROSIVO STANDARD ROJO OXIDO 1 GL','',195,39,343,1,'11659','','','',0,5,1,5,NULL,'',0,0,NULL,1,0,0,0,0),(1660,'ANTICORROSIVO STANDARD NEGRO 1 GL','',195,39,343,1,'11660','','','',0,5,1,5,NULL,'',0,0,NULL,1,0,0,0,0),(1661,'LLAVE DE PASO CORPORATION 1/2 PCP','',40,24,58,1,'11661','','','',0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1662,'HOZ DENTADA LA PAJARITA N°000 150/1','',196,24,344,1,'11662','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1663,'CARRETILLA AZUL FERRAWYY','',98,24,27,1,'11663','','','',0,5,1,10,NULL,'',0,0,NULL,1,0,0,0,0),(1666,'PEGAMENTO REG. PVC 1/16 AZUL GL(8 ONZ) OATEY','',24,51,23,1,'11666','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1667,'PEGAMENTO REG. PVC 1/8 AZUL GL(16 ONZ) OATEY','',24,51,23,1,'11667','','','',0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1668,'PEGAMENTO REG. PVC 1/4 AZUL GL(32 ONZ) OATEY','',24,36,23,1,'11668','','','',0,5,1,1,NULL,'',0,1,NULL,1,0,0,0,0),(1669,'CIZALLA DE 14 plg TRUPER','',28,24,244,1,'11669','','','',0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1670,'CIZALLA DE 18 plg TRUPER','',28,24,244,1,'11670','','','',0,5,1,1.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1671,'CIZALLA DE 24 plg TRUPER','',28,24,244,1,'11671','','','',0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1672,'INFLADOR MANUAL 60 PSI TRUPER','',28,24,154,1,'11672','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1673,'APLICADOR DE SILICONA TRUPER','',28,24,345,1,'11673','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1674,'PLOMADA TOPOGRAFO TRUPER','',28,24,346,1,'11674','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1675,'ESQUINERO PVC INYECT. 30CM ND','',36,24,347,1,'11675','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1676,'FRAGUADORA INYECTADA. 20X9 ND','',36,24,262,1,'11676','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1677,'FRAGUADORA INYECTADA. 22X11 ND','',36,24,262,1,'11677','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1678,'BROCA P/FIERRO 1/8 (3.17MM) ALPEN','',199,24,348,1,'11678','','','',0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(1679,'BROCA P/FIERRO 5/32 (3.97MM) ALPEN','',199,24,348,1,'11679','','','',0,5,1,0.05,NULL,'',0,0,NULL,1,0,0,0,0),(1680,'BROCA P/FIERRO 3/16 (4.76MM) ALPEN','',199,24,348,1,'11680','','','',0,5,1,0.08,NULL,'',0,0,NULL,1,0,0,0,0),(1681,'BROCA P/FIERRO 1/4 (6.35MM) ALPEN','',199,24,348,1,'11681','','','',0,5,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(1682,'BROCA P/FIERRO 5/16 (7.94MM) ALPEN','',199,24,348,1,'11682','','','',0,5,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(1683,'BROCA P/FIERRO 3/8 (9.52MM) ALPEN','',199,24,348,1,'11683','','','',0,5,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(1684,'BROCA P/FIERRO 1/2 (12.7MM) ALPEN','',199,24,348,1,'11684','','','',0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(1685,'SILICONA CARTUCHO 1000 C/TRANSP KNAUF','',198,24,349,1,'11685','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1686,'UNION UNIVERSAL PVC 2 C&A','',43,24,172,1,'11686','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1687,'VALVULA JARDINERO CRO 1/2  C&A','',43,24,24,1,'11687','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1688,'DESARMADOR INTERC. M/ERGON 6 X 100MM C&A','',43,24,196,1,'11688','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1689,'ESMALTE SINTÉTICO PINTOR CAOBA 1/4 GL CPP','',133,58,341,1,'11689','','','',0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1690,'ESMALTE SECADO RAPIDO BLANCO HUMO 1/4 GL VENCEDOR','',8,58,341,1,'11690','','','',0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1691,'TINTE AL ALCOHOL AMARILLO 1/4 LT PARACAS ','',132,79,339,1,'11691','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1692,'CALAMINA TRANS. 3.60 X 0.84 M VD LIMON FIBRAFORTE','',33,24,72,1,'11692','','','',0,5,1,3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1693,'CALAMINA TRANS. 3.60 X 0.84 M CELESTE FIBRAFORTE','',33,24,72,1,'11693','','','',0,5,1,3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1694,'CALAMINA TRANS. 3.60 X 0.84 M AMBAR FIBRAFORTE','',33,24,72,1,'11694','','','',0,5,1,3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1695,'CALAMINA 0.30 X 3.60 PRODAC','',17,24,350,1,'11695','','','',0,5,1,7.33,NULL,'',0,0,NULL,1,0,0,0,0),(1696,'TUBO PVC SEL 5/8X3MT NICOLL','',42,24,115,1,'11696','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1697,'ASPERSOR PLASTICO 1/2 plg 3 SALIDAS  QUIVER','',52,24,66,1,'11697','','','',0,5,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(1698,'FRAGUADORA INYECTADA. 15X9 ND','',36,24,262,1,'11698','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1699,'FRAGUADORA INYECTADA. 21X16 ND','',36,24,262,1,'11699','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1700,'ESQUINERO PVC INYECT. 20CM ND','',36,24,347,1,'11700','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1701,'TEMPLE BLANCO 25KG PATO','',131,18,312,1,'11701','','','',0,5,1,25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1702,'WINCHA 8 MT BELLOTA','',26,24,60,1,'11702','','','',0,5,1,0.35,NULL,NULL,0,0,NULL,1,0,0,0,0),(1703,'CARRETILLA T/BUGGY LLANTA REFOR. 5.5 C&A','',43,24,27,1,'11703','','','',0,5,1,10,NULL,'',0,0,NULL,1,0,0,0,0),(1704,'LLANTA ARMADA P/CARRETILLA REFORZADA C&A','',43,24,12,1,'11704','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1705,'BANDEJA PARA DESINFECCION POLIPLAST','',122,24,352,1,'11705','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1706,'PROTECTOR FACIAL C&A','',43,24,336,1,'11706','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1707,'LIJA DE FIERRO N°80 KLINGSPOR','',197,24,185,1,'11707','','','',0,5,1,0.01,NULL,NULL,0,0,NULL,1,0,0,0,0),(1708,'MALLA GALVANIZADA REFOR CUADR. 1/2 X 16.4MT - BWG19 C&A','',43,97,48,1,'11708','','','',0,13,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1709,'VALVULA DE BOLA 3/4 LISA NICOLL','',42,24,58,1,'11709','','','',0,5,1,0.35,NULL,'',0,0,NULL,1,0,0,0,0),(1710,'BROCA P/FIERRO 5/8 ALPEN','',199,24,348,1,'11710','','','',0,5,1,0.2,NULL,'',0,0,NULL,1,0,0,0,0),(1711,'BROCA P/FIERRO 3/4 ALPEN','',199,24,348,1,'11711','','','',0,5,1,0.4,NULL,'',0,0,NULL,1,0,0,0,0),(1712,'BROCA P/CONCRETO 3MM-1/8 ALPEN','',199,24,308,1,'11712','','','',0,5,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(1713,'BROCA P/CONCRETO 4MM-5/32 ALPEN','',199,24,308,1,'11713','','','',0,5,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(1714,'BROCA P/CONCRETO 5MM-3/16 ALPEN','',199,24,308,1,'11714','','','',0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(1715,'BROCA P/CONCRETO 6.5MM-1/4 ALPEN','',199,24,308,1,'11715','','','',0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(1716,'BROCA P/CONCRETO 8MM-5/16 ALPEN','',199,24,308,1,'11716','','','',0,5,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(1717,'BROCA P/CONCRETO 10MM-3/8 ALPEN','',199,24,308,1,'11717','','','',0,5,1,0.2,NULL,'',0,0,NULL,1,0,0,0,0),(1718,'BROCA P/CONCRETO 13MM-1/2 ALPEN','',199,24,308,1,'11718','','','',0,5,1,0.2,NULL,'',0,0,NULL,1,0,0,0,0),(1719,'WINCHA 8 MT C-21609 PRETUL','',41,24,60,1,'11719','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1723,'MEZCLADORA DUCHA 02 LLAVES LIV. VAINSA','',79,24,353,1,'11723','','','',0,5,1,0.7,NULL,NULL,0,0,NULL,1,0,0,0,0),(1724,'LLAVE LAVATORIO PICO GANZO ACRIL. LIV. VAINSA','',79,24,294,1,'11724','','','',0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1725,'LLAVE LAVATORIO PICO GANZO CROM. LIV. ITALGRIF','',203,24,294,1,'11725','','','',0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1726,'LLAVE DUCHA CROMADA LIV. ITALGRIF','',203,24,146,1,'11726','','','',0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1727,'LLAVE LAVATORIO MUEBLE CROM. ITALGRIF','',203,24,294,1,'11727','','','',0,5,1,0.6,NULL,NULL,0,0,NULL,1,0,0,0,0),(1728,'PLOMADA #2 DE ZINC PRETUL','',41,24,324,1,'11728','','','',0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(1729,'ESCUADRA PESADA 10 plg TRUPER','',28,24,307,1,'11729','','','',0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1730,'ESCUADRA PESADA 12 plg TRUPER','',28,24,307,1,'11730','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1731,'BISAGRA 2.1/2 plg ACERO PULIDO HERMEX','',123,44,223,1,'11731','','','',0,5,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(1736,'BISAGRA 2 plg ACERO PULIDO HERMEX','',123,44,223,1,'11736','','','',0,5,1,0.05,NULL,NULL,0,0,NULL,1,0,0,0,0),(1737,'PALETA PLASTICA INYECTADA 26.5 X 40 C/COCADA','',36,24,354,1,'11737','','','',0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1738,'PALETA PLASTICA INYECTADA 17 X 25 C/COCADA','',36,24,354,1,'11738','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1739,'PALETA PLASTICA INYECTADA 17 X 25 LISA','',36,24,354,1,'11739','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1740,'PALETA PLASTICA INYECTADA 20 X 30 LISA','',36,24,354,1,'11740','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1741,'PALETA PLASTICA INYECTADA 15 X 20 C/COCADA','',36,24,354,1,'11741','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1742,'PALETA PLASTICA INYECTADA 15 X 20 LISA','',36,24,354,1,'11742','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1743,'DRIZA POLIPROPILENO 1/2 MT','',36,71,270,1,'11743','','','',0,13,1,0.09,NULL,'',0,0,NULL,1,0,0,0,0),(1744,'DRIZA POLIPROPILENO 5/8 MT','',36,71,270,1,'11744','','','',0,13,1,0.125,NULL,'',0,0,NULL,1,0,0,0,0),(1745,'DRIZA POLIPROPILENO 1 plg (ROLLO APROX 100M - 10KG)','',36,98,270,1,'11745','','','',0,3,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(1746,'DRIZA TRENZADA 1 plg (ROLLO APROX 100M - 30KG)','',36,98,270,1,'11746','','','',0,3,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(1747,'DRIZA TRENZADA 5/16 plg (ROLLO APROX 100M - 10KG)','',36,71,270,1,'11747','','','',0,3,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(1748,'LENTE DE SEGURIDAD MARCO AZUL TRANSP. CLUTE','',114,36,68,1,'11748','','','',0,5,1,0.03,NULL,'',0,0,NULL,1,0,0,0,0),(1749,'REGISTRO 4 CROMADO ND','',36,24,36,1,'11749','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1750,'CALAMINA 0.30 X0.84X3.60 TRAPEZOIDAL ROJO','',36,24,224,1,'11750','','','',0,5,1,8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1751,'ALICATE UNIVERSAL T201-8X TRUPER','',28,24,136,1,'11751','','','',0,5,1,0.25,NULL,'',0,0,NULL,1,0,0,0,0),(1752,'BROCHA C/M PLASTICO 1.1/2 plg PRETUL','',41,24,156,1,'11752','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1753,'BROCHA C/M PLASTICO 2.1/2 plg PRETUL','',41,24,156,1,'11753','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1754,'TOMACORRIENTE DOBLE P/EMPOTRAR - DELUXE HOME LIGHT','',68,24,142,1,'11754','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1755,'BARRA CONSTRUCCION 6MMX9MT ACEROS AREQUIPA','',1,24,15,1,'11755','','','',0,5,1,1.94,NULL,NULL,0,0,NULL,1,0,0,0,0),(1756,'TUBO DE ABASTO 40CM PVC 1/2 X 1/2 PCP','',40,24,51,1,'11756','','','',0,5,1,0.12,NULL,NULL,0,0,NULL,1,0,0,0,0),(1757,'TUBO DE ABASTO 40CM PVC 1/2 X 7/8 PCP','',40,24,51,1,'11757','','','',0,5,1,0.12,NULL,NULL,0,0,NULL,1,0,0,0,0),(1758,'CADENA GALVANIZADA 1/8 X 3MM C&A','',43,99,355,1,'11758','','','',0,13,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1759,'CADENA GALVANIZADA 5/32 X 4MM C&A','',43,99,355,1,'11759','','','',0,13,1,0.32,NULL,NULL,0,0,NULL,1,0,0,0,0),(1760,'CADENA GALVANIZADA 3/16 X 5MM C&A','',43,99,355,1,'11760','','','',0,13,1,0.5,NULL,'',0,0,NULL,1,0,0,0,0),(1761,'CADENA GALVANIZADA 1/4 X 6MM C&A','',43,99,355,1,'11761','','','',0,13,1,0.8,NULL,'',0,0,NULL,1,0,0,0,0),(1762,'REDUCCION PVC SAP 3/4x1/2 ROSCA INTER. MAT-TIGRE','',61,24,21,1,'11762','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1763,'ESPATULA 5¨ FLEXIBLE, PETRUL','',41,24,169,1,'11763','','','',0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1764,'ESPATULA 4 plgFLEXIBLE, PETRUL','',41,24,169,1,'11764','','','',0,5,1,0.08,NULL,'',0,0,NULL,1,0,0,0,0),(1765,'ESPATULA 3 plgFLEXIBLE, PETRUL','',41,24,169,1,'11765','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1766,'ESPATULA 2 plgFLEXIBLE, PETRUL','',41,24,169,1,'11766','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1767,'ALICATE UNIVERSAL 7 plg PRETUL','',41,24,136,1,'11767','','','',0,5,1,0.4,NULL,'',0,0,NULL,1,0,0,0,0),(1768,'LLAVE DE PASO PVC 3 plgC/ROSCA C&A','',43,24,58,1,'11768','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1769,'VALVULA CHECK SWING HORIZONTAL 1.1/2´VALMAX','',165,24,173,1,'11769','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1770,'VALVULA CHECK SWING HORIZONTAL  2´VALMAX','',165,24,173,1,'11770','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1771,'PERNO AUTOPERFORANTE 10X2 BILDER','',148,75,287,1,'11771','','','',0,5,1,0.005,NULL,'',0,0,NULL,1,0,0,0,0),(1772,'TORNILLO P/AGLOMERADO M-6 X 70 BARCO','',204,24,356,1,'11772','','','',0,5,1,0.02,NULL,NULL,0,0,NULL,1,0,0,0,0),(1773,'TORNILLO P/AGLOMERADO M-6 X 80 BARCO','',204,24,356,1,'11773','','','',0,5,1,0.02,NULL,NULL,0,0,NULL,1,0,0,0,0),(1774,'TORNILLO P/AGLOMERADO M-6 X 90 BARCO','',204,24,356,1,'11774','','','',0,5,1,0.02,NULL,NULL,0,0,NULL,1,0,0,0,0),(1775,'TORNILLO P/AGLOMERADO M-6 X 100 BARCO','',204,24,356,1,'11775','','','',0,5,1,0.04,NULL,NULL,0,0,NULL,1,0,0,0,0),(1778,'TORNILLO P/AGLOMERADO M-4 X 50 BARCO','',204,24,356,1,'11778','','','',0,5,1,0.02,NULL,NULL,0,0,NULL,1,0,0,0,0),(1779,'ALCAYATA .ACERO GALV. 3.7X50MM (2 plg) - MEJIA','',142,24,357,1,'11779','','','',0,5,1,0.002,NULL,NULL,0,0,NULL,1,0,0,0,0),(1780,'ALCAYATA .ACERO GALV. 4.3X60MM (2.1/2) - MEJIA','',142,24,357,1,'11780','','','',0,5,1,0.002,NULL,NULL,0,0,NULL,1,0,0,0,0),(1781,'ALCAYATA .ACERO GALV. 4.3X75MM (3 plg) - MEJIA','',142,24,357,1,'11781','','','',0,5,1,0.002,NULL,NULL,0,0,NULL,1,0,0,0,0),(1782,'ALCAYATA .ACERO GALV. 4.5X100MM (4 plg) - MEJIA','',142,24,357,1,'11782','','','',0,5,1,0.002,NULL,NULL,0,0,NULL,1,0,0,0,0),(1795,'TRIPLAY 6MM X 1.22 X 2.44 OKUME','',112,24,40,1,'11795','','','',0,5,1,8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1796,'TRIPLAY 8MM X 1.22 X 2.44 OKUME','',112,24,40,1,'11796','','','',0,5,1,11,NULL,NULL,0,0,NULL,1,0,0,0,0),(1797,'RODILLO AMARILLO 12 plg TORO','',103,24,155,0,'11797','','','',0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(1798,'RODILLO AMARILLO 9 plg TORO','',103,24,155,0,'11798','','','',0,5,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(1799,'ELECTROBOMBA CENTRIF. CPM 650 DE 1.5HP 1.1/4X1 1-60HZ PEDROLLO','',205,24,358,1,'11799','','','',0,5,1,20,NULL,NULL,0,0,NULL,1,0,0,0,0),(1800,'PLASTICO 2.00 MTS (1.7 MT X 1KG) DOBLE ANCHO X METRO','',36,100,137,1,'11800','','','',0,13,1,0.15,NULL,'',0,0,NULL,1,0,0,0,0),(1801,'PLASTICO 0.80 (7MT X 1KG) AZUL X METRO ND','',36,100,137,1,'11801','','','',0,13,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(1802,'ABRAZADERA 3 AGUA','',36,24,335,1,'11802','','','',0,5,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(1803,'PALETA D/MADERA 6X12 ND','',36,24,363,1,'11803','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1804,'PALETA D/MADERA 6X24 ND','',36,24,363,1,'11804','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1805,'PALETA D/MADERA 7X30 ND','',36,24,363,1,'11805','','','',0,5,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(1806,'HACHA 8134- 3LBS BELLOTA','',26,24,359,1,'11806','','','',0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1807,'HACHA  OJO REDONDO 8129M- 5LBS BELLOTA','',26,24,359,1,'11807','','','',0,5,1,2.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1808,'MACHETE SABLE 127H PPN 17 plg 60/1 BELLOTA','',26,24,252,1,'11808','','','',0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1809,'AGUARRAZ GL X 4LT','',36,39,360,1,'11809','','','',0,5,1,3.5,NULL,'',0,0,NULL,1,0,0,0,0),(1810,'CUCHILLA TERMOMAG DIN 2PX16A SONCA','',125,63,207,1,'11810','','','',0,5,1,0.25,NULL,NULL,0,0,NULL,1,0,0,0,0),(1811,'CUCHILLA TERMOMAG DIN 2PX20A SONCA','',125,63,207,1,'11811','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1812,'CUCHILLA TERMOMAG DIN 2PX25A SONCA','',125,63,207,1,'11812','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1813,'CUCHILLA TERMOMAG DIN 2PX32A SONCA','',125,63,207,1,'11813','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1814,'TRAMPA  PVC  C/REGISTRO 1.1/4 - 1.1/2 METUSA','',166,24,38,1,'11814','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1815,'PIEDRA TALLADA E=0.10M','',36,61,73,1,'11815','','','',0,28,1,0,NULL,NULL,0,0,NULL,1,0,0,0,0),(1816,'TANQUE NEGRO 250 LT ROTOPLAST','',94,24,105,1,'11816','','','',0,5,1,10,NULL,NULL,0,0,NULL,1,0,0,0,0),(1817,'ARCO DE SIERRA ECONOMICO 12 ´ND plg','',36,24,134,1,'11817','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1818,'LLAVE MIXTA 10MM  plgND plg','',36,24,362,1,'11818','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1819,'LLAVE MIXTA 11MM  plgND plg','',36,24,362,1,'11819','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1820,'LLAVE MIXTA 12MM  plgND plg','',36,24,362,1,'11820','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1821,'LLAVE MIXTA 13MM  plgND plg','',36,24,362,1,'11821','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1822,'LLAVE MIXTA 14MM  plgND plg','',36,24,362,1,'11822','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1823,'LLAVE MIXTA 15MM  plgND plg','',36,24,362,1,'11823','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1824,'LLAVE MIXTA 17MM  plgND plg','',36,24,362,1,'11824','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1825,'LLAVE MIXTA 19MM  plgND plg','',36,24,362,1,'11825','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1826,'DISCO LIJA FLAT GR40 115MM HEFESTO','',36,24,284,1,'11826','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1827,'DISCO LIJA FLAP GR60 115MM HEFESTO','',36,24,284,1,'11827','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1828,'DISCO LIJA FLAP GR80 115MM HEFESTO','',36,24,284,1,'11828','','','',0,5,1,0.1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1829,'PLANCHA EMPASTAR M/MADERA 11 X 5 (10 REMACH) TRUPER','',28,24,151,1,'11829','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1830,'ARCO DE CIERRA 4539-30 BELLOTA','',26,24,134,1,'11830','','','',0,5,1,0.3,NULL,'',0,0,NULL,1,0,0,0,0),(1905,'MALLA SEGURIDAD NARANJA X ROLLO - SCHUBERT','',25,46,376,0,'11905','','','',0,13,1,3,NULL,'',0,0,NULL,1,0,0,0,0),(1906,'PALETA D/MADERA 26X42 ND','',36,24,363,1,'11906','','','',0,5,1,1.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1907,'PALETA D/MADERA 24X40 ND','',36,24,363,1,'11907','','','',0,5,1,1.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1908,'PALETA PLASTICA 24 X 38 ND','',36,24,354,1,'11908','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1909,'PALETA PLASTICA 22 X 36 ND','',36,24,354,1,'11909','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1910,'FROTACHO PLATICO 20 X 30 ND','',36,24,276,1,'11910','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1911,'FROTACHO PLASTICO 15X20 ND','',36,24,276,1,'11911','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1912,'FROTACHO PLASTICO 12X24 ND','',36,24,276,1,'11912','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1913,'FROTACHO PLASTICO 12X18 ND','',36,24,276,1,'11913','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1914,'FROTACHO PLASTICO 10X20 ND','',36,24,276,1,'11914','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1915,'FROTACHO PLASTICO 08X38 ND','',36,24,276,1,'11915','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1916,'FROTACHO PLASTICO 06X30 ND','',36,24,276,1,'11916','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1917,'FROTACHO PLASTICO 08X12 ND','',36,24,276,1,'11917','','','',0,5,1,0.15,NULL,NULL,0,0,NULL,1,0,0,0,0),(1918,'TIRALINEAS PLASTICO ND','',36,24,166,1,'11918','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1919,'ESCOBA SUPER DALIA VIRUTEX','',60,24,102,1,'11919','','','',0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(1920,'CALAMINA 0.30X1.80 ACEROS AREQUIPA','',1,24,319,1,'11920','','','',0,5,1,3.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1921,'DISCO TRONZADORA 14 plgX1/8 X 1 A 30T ABRACOL','',84,24,188,1,'11921','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1922,'LLAVE LAVATORIO MUEBLE MODELO-B C&A','',43,24,294,1,'11922','','','',0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(1923,'LLAVE LAVATORIO MUEBLE MODELO-C C&A','',43,24,294,1,'11923','','','',0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(1924,'LLAVE LAVATORIO COCINA P/GANSO FLEXIBLE Z C&A','',43,24,294,1,'11924','','','',0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1925,'TECNOPORT 2.40X1.20X3/4 EPS','',23,102,16,1,'11925','','','',0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1926,'EXTENSION C/3 TOMAS C/FOCO D/NEON 3MT HOME-LIGHT','',68,24,208,1,'11926','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1927,'LLAVE DE PASO ROSCADO PVC 1 plg C&A','',43,24,58,1,'11927','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1928,'LLAVE DE PASO ROSCADO PVC 1.1/2 C&A','',43,24,58,1,'11928','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1929,'LLAVE DE PASO ROSCADO PVC 2 plg C&A','',43,24,58,1,'11929','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1930,'MALLA GALVANIZADA CUADRADA 3/8 - BWG22 C&A','',43,34,48,1,'11930','','','',0,13,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1931,'SIKARAPID 1 X 4 LT','',59,24,365,1,'11931','','','',0,5,1,4,NULL,NULL,0,0,NULL,1,0,0,0,0),(1932,'SIKARAPID 3 PE X 4 LT','',59,24,45,1,'11932','','','',0,5,1,4,NULL,NULL,0,0,NULL,1,0,0,0,0),(1933,'SIKACEM ACELERANTE PE  X 4 LT','',59,24,364,1,'11933','','','',0,5,1,4,NULL,NULL,0,0,NULL,1,0,0,0,0),(1934,'SIKACEM ACELERANTE PE  X 20 LT','',59,24,364,1,'11934','','','',0,5,1,22,NULL,NULL,0,0,NULL,1,0,0,0,0),(1935,'LAMPARA DE TECHO 2 FOCOS E14 CAS. BONITA','',36,24,366,1,'11935','','','',0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1936,'LAMPARA DE ESCRITORIO LED HC','',36,24,366,1,'11936','','','',0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1937,'MEZCLADORA DUCHA MOD. CALES  - TINA D´ACQUA','',36,24,353,1,'11937','','','',0,5,1,2,NULL,'',0,0,NULL,1,0,0,0,0),(1938,'MEZCLADORA DUCHA MOD. PETRA  - TINA D´ACQUA','',36,24,353,1,'11938','','','',0,5,1,3,NULL,'',0,0,NULL,1,0,0,0,0),(1939,'MEZCLADORA DUCHA MOD. MAELLA D´ACQUA','',36,24,353,1,'11939','','','',0,5,1,1,NULL,'',0,0,NULL,1,0,0,0,0),(1940,'FOCO DICROICO BLANCO GRANDE C/FOCO 5W','',36,24,367,1,'11940','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1941,'FOCO DICROICO BLANCO PEQ. C/FOCO 5W','',36,24,367,1,'11941','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1942,'FOCO DICROICO NIQUEL PEQ. C/FOCO 5W','',36,24,367,1,'11942','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1943,'CODO PVC ALCA. ISO 200MMX90° UF ND','',36,24,97,1,'11943','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1944,'CODO PVC ALCA. ISO 200MMX45° ND','',36,24,97,1,'11944','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1945,'CODO PVC ALCA. ISO 200MMX45° UF ND','',36,24,97,1,'11945','','','',0,5,1,5,NULL,NULL,0,0,NULL,1,0,0,0,0),(1946,'AGUARRAZ X 1LT','',36,24,360,1,'11946','','','',0,5,1,1,NULL,NULL,0,0,NULL,1,0,0,0,0),(1947,'ANTICORROSIVO GRIS 1 GL CPP','',133,39,343,1,'11947','','','',0,5,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(1948,'ANTICORROSIVO ROJO OXIDO 1 GL CPP','',133,39,343,0,'11948','','','',0,5,1,0,NULL,'',0,0,NULL,1,0,0,0,0),(1949,'ESMALTE PATO ALUMINIO 1GL CPP','',133,39,368,1,'11949','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1950,'ESMALTE PATO VERDE CROMO 1GL CPP','',133,39,368,1,'11950','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1951,'ESMALTE PATO ROJO OXIDO 1GL CPP','',133,39,368,1,'11951','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1952,'ESMALTE PATO AMARILLO MEDIO 1GL CPP','',133,39,368,1,'11952','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1953,'ESMALTE PATO AZUL ELECTRICO 1GL CPP','',133,39,368,1,'11953','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1954,'ESMALTE PATO AZUL NAVAL 1GL CPP','',133,39,368,1,'11954','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1955,'ESMALTE PATO BLANCO HUMO 1GL CPP','',133,39,368,1,'11955','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1956,'ESMALTE PATO DORADO 1GL CPP','',133,39,368,1,'11956','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1957,'ESMALTE PATO ROSADO 1GL CPP','',133,39,368,1,'11957','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1958,'ESMALTE PATO VERDE NILO 1GL CPP','',133,39,368,1,'11958','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1959,'ESMALTE PATO GRIS OSCURO 1GL CPP','',133,39,368,1,'11959','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1960,'ESMALTE PATO CELESTE 1GL CPP','',133,39,368,1,'11960','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1961,'ESMALTE PATO AZUL ULTRAMAR 1GL CPP','',133,39,368,1,'11961','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1962,'ESMALTE PATO NEGRO 1GL CPP','',133,39,368,1,'11962','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1963,'ESMALTE PATO AMARILLO CAT 1GL CPP','',133,39,368,1,'11963','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1964,'ESMALTE PATO CATERPILLAR 1GL CPP','',133,39,368,1,'11964','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1965,'ESMALTE PATO NARANJA 1GL CPP','',133,39,368,1,'11965','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1966,'ESMALTE PATO ROJO BERMELLON 1GL CPP','',133,39,368,1,'11966','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1967,'ESMALTE PATO CAOBA 1GL CPP','',133,39,368,1,'11967','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1968,'ESMALTE PATO NOGAL 1GL CPP','',133,39,368,1,'11968','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1969,'ESMALTE PATO AZUL TONER 1GL CPP','',133,39,368,1,'11969','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1970,'ESMALTE PATO VERDE TONER 1GL CPP','',133,39,368,1,'11970','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1971,'ESMALTE PATO ROJO TONER 1GL CPP','',133,39,368,1,'11971','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1972,'ESMALTE PATO GUINDA TONER 1GL CPP','',133,39,368,1,'11972','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1973,'ESMALTE PATO VIOLETA 1GL CPP','',133,39,368,1,'11973','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1974,'ESMALTE PATO VERDE ESMERALDA 1GL CPP','',133,39,368,1,'11974','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1975,'ESMALTE PATO VERDE OSCURO 1GL CPP','',133,39,368,1,'11975','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1976,'ESMALTE PATO AZUL  ATLANTICO 1GL CPP','',133,39,368,1,'11976','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1977,'ESMALTE PATO AZUL MARINO 1GL CPP','',133,39,368,1,'11977','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1978,'ESMALTE PATO CREMA 1GL CPP','',133,39,368,1,'11978','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1979,'ESMALTE PATO BLANCO 1GL CPP','',133,39,368,1,'11979','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1980,'ESMALTE PATO BAYO 1GL CPP','',133,39,368,1,'11980','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1981,'ESMALTE PATO ROBLE 1GL CPP','',133,39,368,1,'11981','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1982,'ESMALTE PATO ROJO TOLUIDINA 1GL CPP','',133,39,368,1,'11982','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1983,'ESMALTE PATO GRIS CLARO 1GL CPP','',133,39,368,1,'11983','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1984,'ESMALTE PATO MARFIL 1GL CPP','',133,39,368,1,'11984','','','',0,5,1,3.8,NULL,NULL,0,0,NULL,1,0,0,0,0),(1985,'WINCHA PASACABLE ACERO 5MT WINFLEX','',206,24,369,1,'11985','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1986,'WINCHA PASACABLE ACERO 10MT WINFLEX','',206,24,369,1,'11986','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1987,'WINCHA PASACABLE ACERO 15MT WINFLEX','',206,24,369,1,'11987','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1988,'WINCHA PASACABLE ACERO 20MT WINFLEX','',206,24,369,1,'11988','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1989,'WINCHA PASACABLE ACERO 25MT WINFLEX','',62,24,369,1,'11989','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1990,'WINCHA PASACABLE ACERO 30MT WINFLEX','',206,24,369,1,'11990','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1991,'WINCHA PASACABLE NYLON 5MT WINFLEX','',206,24,369,1,'11991','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1992,'WINCHA PASACABLE NYLON 10MT WINFLEX','',206,24,369,1,'11992','','','',0,5,1,0.2,NULL,NULL,0,0,NULL,1,0,0,0,0),(1993,'WINCHA PASACABLE NYLON 15MT WINFLEX','',206,24,369,1,'11993','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1994,'WINCHA PASACABLE NYLON 20MT WINFLEX','',206,24,369,1,'11994','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1995,'WINCHA PASACABLE NYLON 25MT WINFLEX','',206,24,369,1,'11995','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1996,'WINCHA PASACABLE NYLON 30MT WINFLEX','',206,24,369,1,'11996','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1997,'TABLA LIJADORA  MANUAL ND 10X20','',206,24,370,1,'11997','','','',0,5,1,0.2,NULL,'',0,0,NULL,1,0,0,0,0),(1998,'TABLA LIJADORA DE PARED 20X22 ND','',206,24,370,1,'11998','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(1999,'PALETA D/MADERA 22X36 ND','',36,24,363,1,'11999','','','',0,5,1,0.5,NULL,NULL,0,0,NULL,1,0,0,0,0),(2000,'PALETA D/MADERA 20X30 ND','',36,24,363,1,'12000','','','',0,5,1,0.4,NULL,NULL,0,0,NULL,1,0,0,0,0),(2001,'PALETA D/MADERA18X27 ND','',36,24,363,1,'12001','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(2002,'PALETA D/MADERA 17X25 ND','',36,24,363,1,'12002','','','',0,5,1,0.3,NULL,NULL,0,0,NULL,1,0,0,0,0),(2003,'PALETA D/MADERA 8X36 ND','',36,24,363,1,'12003','','','',0,5,1,0.2,NULL,'',0,0,NULL,1,0,0,0,0),(2004,'CABLE TW-80 10 AWG 7 HILOS INDECO','',66,35,251,1,'12004','','','',0,13,1,0.1,NULL,'',0,0,NULL,1,0,0,0,0),(2006,'LADRILLO TECHO 15X30X30 CER. SOL DEL NORTE','',19,24,8,1,'12006','','','',0,5,1,0,NULL,NULL,0,0,'16083930586484761298',1,0,0,0,0),(2007,'PALANA CUCHARA 5501-4 MAP.CL M/P CLS BELLOTA','',26,24,25,1,'12007','','','',0,5,1,1.65,NULL,'',0,1,'16085942311131247472',1,0,0,0,0),(2008,'PALETA D/MADERA 18X30 ND','',36,24,363,1,'12008','','','',0,5,1,1.25,NULL,'',0,0,'16086465346940900492',1,0,0,0,0),(2009,'GUANTE JEBE CALIBRE 35 T-9  ETERNA','',207,24,209,1,'12009','','','',0,19,1,0,NULL,'',0,0,'16086465717259092405',1,0,0,0,0),(2010,'PLANCHA FRAGUADORA 15X9 ND','',36,24,262,1,'12010','','','',0,5,1,0,NULL,'',0,0,'16086476478587265042',1,0,0,0,0),(2011,'PLANCHA FRAGUADORA 20X7 ND','',36,24,262,1,'12011','','','',0,5,1,0.1,NULL,'',0,0,'16086477227756847109',1,0,0,0,0),(2012,'PLANCHA FRAGUADORA 20X9 ND','',36,24,262,1,'12012','','','',0,5,1,0.15,NULL,'',0,0,'16086477872177841623',1,0,0,0,0),(2013,'CUCHILLA TERMOMAG RX3 2X32A 10KA/2 LEGRAND','',208,24,207,1,'12013','','','',0,5,1,0,NULL,NULL,0,0,'16086478037254423446',1,0,0,0,0),(2014,'PLANCHA FRAGUADORA 22X11 ND','',36,24,262,1,'12014','','','',0,5,1,0.15,NULL,'',0,0,'16086478236958226642',1,0,0,0,0),(2015,'PLANCHA FRAGUADORA 21X16 ND','',36,24,262,1,'12015','','','',0,5,1,0.25,NULL,'',0,0,'16086478639196600535',1,0,0,0,0),(2016,'PLANCHA FRAGUADORA 28X16 ND','',36,24,262,1,'12016','','','',0,5,1,0,NULL,NULL,0,0,'16086479001773006184',1,0,0,0,0),(2017,'GUANTE JEBE CALIBRE 35 T-9.5 MASTER','',90,24,209,1,'12017','','','',0,19,1,0.2,NULL,'',0,0,'16086484334147455514',1,0,0,0,0),(2018,'CONCRETO PREMEZCLADO 210-I-H67-A5','',36,38,371,1,'12018','','','',0,16,1,0,NULL,NULL,0,0,'16086645572334066498',1,0,0,0,0),(2019,'GUANTE JEBE CALIBRE 35 T-9.5  ETERNA','',207,24,209,1,'12019','','','',0,19,1,0,NULL,'',0,0,'16087552658991242541',1,0,0,0,0),(2021,'FOCO LED 20W BOTELLA WAILEC','',209,37,219,1,'12021','','','',0,5,1,0.1,NULL,'',0,0,'16092742744035225391',1,0,0,0,0),(2022,'INTERRUPTOR MIXTO P/EMPOTRAR- LUXURY HOME LIGHT','',68,36,140,1,'12022','','','',0,5,1,0,NULL,NULL,0,0,'16092818807160503969',1,0,0,0,0),(2023,'TOMACORRIENTE TRIPLE P/EMPOTRAR- ELEGANT HOME LIGHT','',68,36,142,1,'12023','','','',0,5,1,0,NULL,NULL,0,0,'16092824434314532158',1,0,0,0,0),(2024,'LLAVE LAVATORIO COCINA P/GANSO FLEX. GRIS/NEGRO C&A','',43,24,294,1,'12024','','','',0,5,1,0.45,NULL,'',0,0,'16092826441934983735',1,0,0,0,0),(2025,'MEZCLADORA DUCHA SEVILLA KHOR','',210,24,353,1,'12025','','','',0,5,1,0.85,NULL,'',0,0,'16092834971475142034',1,0,0,0,0),(2026,'MEZCLADORA DUCHA MALAGA KHOR','',210,24,353,1,'12026','','','',0,5,1,0,NULL,NULL,0,0,'16092836349616627767',1,0,0,0,0),(2027,'CALAMINA 0.14X3.60 IMPORTADA','',36,24,4,1,'12027','','','',0,5,1,0,NULL,NULL,0,0,'16097682762874258004',1,0,0,0,0),(2028,'CALAMINA 0.22X1.80 IMPORTADA','',36,24,4,1,'12028','','','',0,5,1,0,NULL,NULL,0,0,'16097683168214253149',1,0,0,0,0),(2029,'CALAMINA 0.22X3.60 IMPORTADA','',36,24,4,1,'12029','','','',0,5,1,0,NULL,NULL,0,0,'16097683485657920205',1,0,0,0,0),(2030,'YESO REFINADO CONSTRUCCION X KG','',36,28,2,1,'12030','','','',0,3,1,0,NULL,NULL,0,0,'16097708456587348973',1,0,0,0,0),(2031,'PICAPORTE ACERO 4 CE-031 VITTESSE','',212,24,331,1,'12031','','','',0,5,1,0,NULL,'',0,0,'16099461805123191036',1,0,0,0,0),(2032,'PICAPORTE DORADO 3 CE-022 ITALOCK','',213,24,331,1,'12032','','','',0,5,1,0.1,NULL,'',0,0,'16099462531526018701',1,0,0,0,0),(2033,'PICAPORTE DORADO 4 CE-023 ITALOCK','',213,24,331,1,'12033','','','',0,5,1,0.1,NULL,'',0,0,'1609946357671441257',1,0,0,0,0),(2034,'ZAPATO SEGURIDAD  P/A 552 T/37 TECSEG','',115,49,231,1,'12034','','','',0,19,1,1,NULL,'',0,0,'16099483964440283043',1,0,0,0,0),(2035,'LENTE DE SEGURIDAD MARCO AZUL OSCURO CLUTE','',114,36,68,1,'12035','','','',0,5,1,0.03,NULL,'',0,0,'1610296842213254498',1,0,0,0,0),(2036,'CHALECO REPORTERO NARANJ - S ND','',36,24,67,1,'12036','','','',0,5,1,0.3,NULL,'',0,0,'16102980162774110477',1,0,0,0,0),(2037,'CHALECO REPORTERO NARANJ - L ND','',36,24,67,1,'12037','','','',0,5,1,0.3,NULL,'',0,1,'16102981944313879470',1,0,0,0,0),(2038,'CHALECO REPORTERO NARANJ - XL','',36,24,67,1,'12038','','','',0,5,1,0.3,NULL,'',0,0,'1610298299217040162',1,0,0,0,0),(2039,'CHALECO REPORTERO AZUL- S ND','',36,24,67,1,'12039','','','',0,5,1,0.3,NULL,'',0,0,'16102988834559518764',1,0,0,0,0),(2040,'CHALECO REPORTERO AZUL- L  ND','',36,24,67,1,'12040','','','',0,5,1,0.3,NULL,'',0,0,'16102989582247956168',1,0,0,0,0),(2041,'CHALECO REPORTERO AZUL- XL  ND','',36,24,67,1,'12041','','','',0,5,1,0.3,NULL,'',0,0,'16102990075833482267',1,0,0,0,0),(2042,'CALAMINA 0.20X1.80 ACEROS AREQUIPA','',1,24,319,1,'12042','','','',0,5,1,2.3,NULL,NULL,0,0,'16104843465345740675',1,0,0,0,0),(2043,'TUBO PVC SAL 2-4 VARIOS DEFEC.','',36,24,80,1,'12043','','','',0,5,1,0.3,NULL,NULL,0,0,'16106425982867597560',1,0,0,0,0),(2044,'TUBO PVC SEL 1X3MT TUPLAST','',219,24,379,1,'12044','','','',0,5,1,0.3,NULL,'',0,0,'16106427884131826048',1,0,0,0,0),(2045,'REDUCCION CPVC AG 3/4x1/2 FOSET','',36,24,21,1,'12045','','','',0,5,1,0,NULL,'',0,0,'16108137579264694751',1,0,0,0,0),(2046,'COMBA OCTAG. 6 LBS C/MANGO TRUPER','',28,24,53,1,'12046','','','',0,5,1,3,NULL,NULL,0,0,'16113349751485985861',1,0,0,0,0),(2047,'UNION UNIVERSAL CPVC 3/4 PAVCO','',50,24,172,1,'12047','','','',0,5,1,0.15,NULL,'',0,0,'16113457423719980682',1,0,0,0,0),(2048,'TAPON CPVC 3/4 S/PRES. HEMBRA NICOLL','',42,24,47,1,'12048','','','',0,5,1,0.05,NULL,NULL,0,0,'16113459699885111157',1,0,0,0,0),(2049,'UNION CPVC SIMPLE 3/4 NICOLL','',42,24,44,1,'12049','','','',0,5,1,0.06,NULL,NULL,0,0,'16113465063198204793',1,0,0,0,0),(2050,'CODO CPVC AQUAT ASTM 1/2X90 NICOLL','',42,24,98,1,'12050','','','',0,5,1,0.05,NULL,NULL,0,0,'16113468253821742549',1,0,0,0,0),(2051,'YESO CERAMICO X 15 KG','',36,12,2,1,'12051','','','',0,8,1,15,NULL,NULL,0,0,'16113509493894874262',1,0,0,0,0),(2052,'PANTALON DRIL NARANJA T/M TEC','',116,24,232,1,'12052','','','',0,5,1,0.3,NULL,'',0,0,'16115832029411812647',1,0,0,0,0),(2053,'PANTALON DRIL NARANJA T/L TEC','',116,24,232,1,'12053','','','',0,5,1,0.3,NULL,NULL,0,0,'16115832514917304475',1,0,0,0,0),(2054,'PANTALON DRIL NARANJA T/XL TEC','',116,24,232,1,'12054','','','',0,5,1,0.3,NULL,NULL,0,0,'16115832884231000856',1,0,0,0,0),(2055,'PANTALON DRIL AZUL T/XL TEC','',116,24,232,1,'12055','','','',0,5,1,0.3,NULL,NULL,0,0,'16115838709556201090',1,0,0,0,0),(2056,'BOTA JEBE T/38 XTREME','',214,24,194,1,'12056','','','',0,19,1,0.5,NULL,'',0,0,'16115851324593920154',1,0,0,0,0),(2057,'CALAMINA 0.25 X0.82 X3.60 TRAPEZOIDAL ROJO','',36,24,224,1,'12057','','','',0,5,1,2.45,NULL,'',0,0,'16116108948360206509',1,0,0,0,0),(2058,'PANTALON DRIL AZUL T/S TEC','',116,24,232,1,'12058','','','',0,5,1,0.3,NULL,'',0,0,'16117807865976751673',1,0,0,0,0),(2059,'POLO NARANJA MANGA LARGA 30/1 T/S','',36,24,234,1,'12059','','','',0,5,1,0.25,NULL,'',0,0,'16117856813291827133',1,0,0,0,0),(2060,'POLO NARANJA MANGA LARGA 30/1 T/M','',36,24,234,1,'12060','','','',0,5,1,0.25,NULL,'',0,0,'16117857646621132403',1,0,0,0,0),(2061,'POLO NARANJA MANGA LARGA 30/1 T/L','',36,24,234,1,'12061','','','',0,5,1,0.25,NULL,'',0,0,'16117858414178117991',1,0,0,0,0),(2062,'POLO NARANJA MANGA LARGA 30/1 T/XL','',36,24,234,1,'12062','','','',0,5,1,0.25,NULL,'',0,0,'16117858844125297927',1,0,0,0,0),(2063,'BOTA JEBE T/43 XTREME','',214,24,194,1,'12063','','','',0,19,1,0,NULL,'',0,0,'16117861004085264117',1,0,0,0,0),(2064,'MANGO PARA LAMPA','',36,24,131,1,'12064','','','',0,5,1,2,NULL,NULL,0,0,'16118527917740410282',1,0,0,0,0),(2065,'ALAMBRE RECOCIDO N°16 ACEROS AREQ','',1,16,375,1,'12065','','','',0,3,1,1,NULL,'',0,0,'16119537252952697093',1,0,0,0,0),(2066,'LLAVE DUCHA CROMADA RUBINETTO','',36,24,146,1,'12066','','','',0,5,1,0.3,NULL,'',0,0,'16119553558612334101',1,0,0,0,0),(2067,'ZAPAPICO SIN MANGO ULTRACRAF','',36,24,26,1,'12067','','','',0,5,1,2.2,NULL,NULL,0,0,'16120194062875235059',1,0,0,0,0),(2069,'TUBO PVC AG C7.5 SP 3X5MT NICOLL','',42,26,82,1,'12069','','','',0,5,1,6,NULL,'',0,0,'16120218741122852538',1,0,0,0,0),(2070,'BARRA CONSTRUCCION 4.7MMX8.8MT SIDERPERU','',13,24,15,1,'12070','','','',0,5,1,1.2,NULL,NULL,0,0,'16121888178532488505',1,0,0,0,0),(2071,'PLANCHA BATIR M/MADERA 7 plg C&A','',43,24,322,1,'12071','','','',0,5,1,0.25,NULL,NULL,0,0,'16122996205773639196',1,0,0,0,0),(2072,'BADILEJO P/ALBAÑIL  M/MADERA 7¨C&A','',43,24,152,1,'12072','','','',0,5,1,0.25,NULL,NULL,0,0,'16122999132414368653',1,0,0,0,0),(2073,'MANGUERA REFORZ.TRANSP. 3/8X100M ¨2M¨','',215,35,178,1,'12073','','','',0,13,1,0,NULL,'',0,0,'16123003512535816525',1,0,0,0,0),(2074,'MANGUERA REFORZ.TRANSP. 1/4X100M ¨2M¨','',215,35,178,1,'12074','','','',0,13,1,0,NULL,'',0,0,'16123005157017603743',1,0,0,0,0),(2075,'GUANTE CORRUGADO TALLA S- ¨DKASA¨','',216,24,374,1,'12075','','','',0,19,1,0.15,NULL,'',0,0,'16123007964831459553',1,0,0,0,0),(2076,'GUANTE CORRUGADO TALLA M- ¨DKASA¨','',216,24,374,1,'12076','','','',0,19,1,0.15,NULL,'',0,0,'16123010679258373938',1,0,0,0,0),(2077,'GUANTE CONVENIENTE TALLA S- ¨DKASA¨','',216,24,374,1,'12077','','','',0,19,1,0.15,NULL,'',0,0,'16123012753108637898',1,0,0,0,0),(2078,'GUANTE CONVENIENTE TALLA M- ¨DKASA¨','',216,24,374,1,'12078','','','',0,19,1,0.15,NULL,'',0,0,'16123014698183080869',1,0,0,0,0),(2079,'GUANTE DOMESTICO TALLA S- ¨DKASA¨','',216,24,374,1,'12079','','','',0,19,1,0.15,NULL,'',0,0,'16123015529731669626',1,0,0,0,0),(2080,'GUANTE DOMESTICO TALLA M- ¨DKASA¨','',216,24,374,1,'12080','','','',0,19,1,0.15,NULL,'',0,0,'16123016041896039897',1,0,0,0,0),(2081,'ESCOBA ESCOBON 41CM ¨HUDE¨','',104,24,102,1,'12081','','','',0,5,1,0.35,NULL,NULL,0,0,'16123017612846657040',1,0,0,0,0),(2082,'ESCOBA HOGAREÑA 34CM ¨HUDE¨','',104,24,102,1,'12082','','','',0,5,1,0.35,NULL,NULL,0,0,'16123019733977434901',1,0,0,0,0),(2083,'RECOGEDOR SUPER RESISTENTE ¨HUDE¨','',104,24,216,1,'12083','','','',0,5,1,0.25,NULL,NULL,0,0,'16123021044439767905',1,0,0,0,0),(2084,'SET ECO(BALDE 10LT C/ESCUR+MOPA+PALO) ¨HUDE¨','',104,24,373,1,'12084','','','',0,5,1,1.25,NULL,NULL,0,0,'16123023257649398911',1,0,0,0,0),(2085,'PINTURA SPRAY NEGRO BRILLANTE 400ML ¨C&A¨','',43,24,264,1,'12085','','','',0,5,1,30,NULL,NULL,0,0,'16123027796336746879',1,0,0,0,0),(2086,'PINTURA SPRAY SILVER 400ML ¨C&A¨','',43,24,264,1,'12086','','','',0,5,1,0.3,NULL,NULL,0,0,'16123028556654997166',1,0,0,0,0),(2087,'PINTURA SPRAY DEEP VIOLETA 400ML ¨C&A¨','',43,24,264,1,'12087','','','',0,5,1,0.3,NULL,NULL,0,1,'16123029231998316033',1,0,0,0,0),(2088,'PINTURA SPRAY BLANCO BRILLANTE 400ML ¨C&A¨','',43,24,264,1,'12088','','','',0,5,1,0.3,NULL,NULL,0,0,'16123031092025636328',1,0,0,0,0),(2089,'PINTURA SPRAY VERDE IRLANDES 400ML ¨C&A¨','',43,24,264,1,'12089','','','',0,5,1,0.3,NULL,NULL,0,0,'16123031927440522891',1,0,0,0,0),(2090,'PINTURA SPRAY AZUL CLARO 400ML ¨C&A¨','',43,24,264,1,'12090','','','',0,5,1,0.3,NULL,'',0,1,'16123032532295208387',1,0,0,0,0),(2091,'PINTURA SPRAY MEDIUM BLUE 400ML ¨C&A¨','',43,24,264,1,'12091','','','',0,5,1,0.3,NULL,NULL,0,0,'1612303709284826108',1,0,0,0,0),(2092,'PINTURA SPRAY MEDIUM GRAY 400ML ¨C&A¨','',43,24,264,1,'12092','','','',0,5,1,0.3,NULL,NULL,0,0,'16123037803598380777',1,0,0,0,0),(2093,'PINTURA SPRAY ALUMINIO 400ML ¨C&A¨','',43,24,264,1,'12093','','','',0,5,1,0.3,NULL,NULL,0,0,'16123038355241084754',1,0,0,0,0),(2094,'PINTURA SPRAY DORADO 400ML ¨C&A¨','',43,24,264,1,'12094','','','',0,5,1,0.3,NULL,NULL,0,1,'16123039274991418882',1,0,0,0,0),(2095,'PINTURA SPRAY PEACH RED 400ML ¨C&A¨','',43,24,264,1,'12095','','','',0,5,1,0.3,NULL,NULL,0,0,'16123040206731263350',1,0,0,0,0),(2096,'PINTURA SPRAY CELESTE 400ML ¨C&A¨','',43,24,264,1,'12096','','','',0,5,1,0.3,NULL,NULL,0,0,'16123040705862447064',1,0,0,0,0),(2097,'PINTURA SPRAY CELESTE CIELO 400ML ¨C&A¨','',43,24,264,1,'12097','','','',0,5,1,0.3,NULL,NULL,0,0,'16123041398326354471',1,0,0,0,0),(2098,'PINTURA SPRAY AMARILLO LIMON 400ML ¨C&A¨','',43,24,264,1,'12098','','','',0,5,1,0.3,NULL,NULL,0,0,'1612304218423114815',1,0,0,0,0),(2099,'PINTURA SPRAY VERDE HOJA 400ML ¨C&A¨','',43,24,264,1,'12099','','','',0,5,1,0.3,NULL,NULL,0,0,'16123043481705376640',1,0,0,0,0),(2100,'PINTURA SPRAY CATERPILLAR MD 400ML ¨C&A¨','',43,24,264,1,'12100','','','',0,5,1,0.3,NULL,'',0,0,'16123044172183408512',1,0,0,0,0),(2101,'PINTURA SPRAY JADE GREEN 400ML ¨C&A¨','',43,24,264,1,'12101','','','',0,5,1,0.3,NULL,NULL,0,0,'16123044922724361047',1,0,0,0,0),(2102,'PINTURA SPRAY NARANJA 400ML ¨C&A¨','',43,24,264,1,'12102','','','',0,5,1,0.3,NULL,NULL,0,0,'16123045601998980159',1,0,0,0,0),(2103,'PINTURA SPRAY MARRON 400ML ¨C&A¨','',43,24,264,1,'12103','','','',0,5,1,0.3,NULL,NULL,0,0,'1612304648574835823',1,0,0,0,0),(2104,'PINTURA SPRAY GRIS 400ML ¨C&A¨','',43,24,264,1,'12104','','','',0,5,1,0.3,NULL,NULL,0,0,'16123047132988929268',1,0,0,0,0),(2105,'PINTURA SPRAY CAFE 400ML ¨C&A¨','',43,24,264,1,'12105','','','',0,5,1,0.3,NULL,NULL,0,0,'16123048204779668807',1,0,0,0,0),(2106,'PINTURA SPRAY AZUL MARINO 400ML ¨C&A¨','',43,24,264,1,'12106','','','',0,5,1,0.3,NULL,NULL,0,0,'16123049095584184145',1,0,0,0,0),(2107,'PINTURA SPRAY AZUL HONDA 400ML ¨C&A¨','',43,24,264,1,'12107','','','',0,5,1,0.3,NULL,NULL,0,0,'16123049771177824173',1,0,0,0,0),(2108,'PINTURA SPRAY ROJO BRILLANTE 400ML ¨C&A¨','',43,24,264,1,'12108','','','',0,5,1,0.3,NULL,NULL,0,0,'16123050401088227827',1,0,0,0,0),(2109,'PINTURA SPRAY CROMO PREMIUN 400ML ¨C&A¨','',43,24,264,1,'12109','','','',0,5,1,0.3,NULL,NULL,0,0,'16123051129457043450',1,0,0,0,0),(2110,'PINTURA SPRAY ORO PREMIUN 400ML ¨C&A¨','',43,24,264,1,'12110','','','',0,5,1,0.3,NULL,NULL,0,0,'16123051794215067416',1,0,0,0,0),(2111,'PINTURA SPRAY SILVER GRAY 400ML ¨C&A¨','',43,24,264,1,'12111','','','',0,5,1,0.3,NULL,NULL,0,0,'16123052952660281014',1,0,0,0,0),(2114,'CALAMINA 0.30X3.60 ACEROS AREQUIPA','',1,24,319,1,'12114','','','',0,5,1,7,NULL,'',0,0,'16129050844984466761',1,0,0,0,0),(2115,'WAYPE PAÑO','',36,99,377,1,'12115','','','',0,3,1,1,NULL,NULL,0,0,'16129059243588477834',1,0,0,0,0),(2116,'OCRE AMARILLO OXI BAYER','',36,28,56,1,'12116','','','',0,5,1,1,NULL,'',0,0,'16129104139939592610',1,0,0,0,0),(2117,'DRIZA POLIPROPILENO 3/4 (ROLLO APROX 80M - 10KG)','',36,71,270,1,'12117','','','',0,3,1,0.125,NULL,'',0,0,'16131453265630818121',1,0,0,0,0),(2118,'ALAMBRE RECOCIDO N°08 ACEROS AREQ','',1,16,375,1,'12118','','','',0,3,1,1,NULL,'',0,0,'16131699108515405845',1,0,0,0,0),(2119,'LLAVE DUCHA ACRILICA FAME 1/4 GIRO SAF-1A SEVILLA','',218,24,146,1,'12119','','','',0,5,1,0.25,NULL,NULL,0,0,'16134255238876180076',1,0,0,0,0),(2120,'LLAVE DUCHA ACRILICA FAME GIRO COMPL. SAF-1 SEVILLA','',218,24,146,1,'12120','','','',0,5,1,0.25,NULL,NULL,0,0,'1613425586112614854',1,0,0,0,0),(2121,'MALLA MOSQUITERO VERDE 0.90X30 MTS','',36,34,243,1,'12121','','','',0,13,1,0.2,NULL,NULL,0,0,'16135972668553568944',1,0,0,0,0),(2122,'TRIPLAY 4MMX1.22X2.44 OKUME','',112,24,40,1,'12122','','','',0,5,1,6,NULL,NULL,0,0,'16136019024974470119',1,0,0,0,0),(2123,'TOMACORRIENTE SIMPLE P/EMPOT 1208-1100-96 BTICINO','',81,44,142,1,'12123','','','',0,5,1,0,NULL,NULL,0,0,'1613764171281709554',1,0,0,0,0),(2124,'TUBO PVC AG C/R C.10 1/2X5MT TUPLAST','',219,24,378,1,'12124','','','',0,5,1,0.5,NULL,NULL,0,0,'16137690267623844238',1,0,0,0,0),(2125,'TUBO PVC AG C/R C.10 3/4X5MT TUPLAST','',219,24,378,1,'12125','','','',0,5,1,0.5,NULL,'',0,0,'16137691643786391600',1,0,0,0,0),(2126,'TUBO PVC AG C/R C.10 1X5MT TUPLAST','',219,24,378,1,'12126','','','',0,5,1,1.5,NULL,'',0,0,'16137692614859863320',1,0,0,0,0),(2130,'CEMENTO EXTRAFORTE TIPO ICO X KG PACASMAYO','',2,10,1,1,'12130','','','',0,3,1,1,NULL,'',0,0,'16140303729377054753',1,0,0,0,0),(2132,'REDUCCION PVC SAP 21/2x1/2 NICOLL','',42,24,21,1,'12132','','','',0,5,1,0,NULL,'',0,0,'1614099557556791879',1,0,0,0,0),(2133,'OCRE EXTRA. T/130 VERDE BAYER','',49,28,56,1,'12133','','','',0,5,1,0,NULL,NULL,0,0,'16141984768132774877',1,0,0,0,0),(2134,'CALAMINA TRANS. 1.80 X 0.84 M VERDE OSCURO FIBRAFORTE','',33,24,72,1,'12134','','','',0,5,1,1.5,NULL,NULL,0,0,'16142622752812112944',1,0,0,0,0),(2136,'LIJA DE AGUA N°150 ABRACOL','',84,24,182,1,'12136','','','',0,5,1,0.01,NULL,NULL,0,0,'16143480638537552741',1,0,0,0,0),(2137,'LIJA DE AGUA N°100 ABRACOL','',84,24,182,1,'12137','','','',0,5,1,0.01,NULL,NULL,0,0,'16143481616370576489',1,0,0,0,0),(2140,'LIJA DE MADERA N°150 ABRALIT','',220,24,183,1,'12140','','','',0,5,1,0.01,NULL,NULL,0,0,'16143518572539485215',1,0,0,0,0),(2141,'LIJA DE MADERA  N°80 ABRALIT','',220,24,183,1,'12141','','','',0,5,1,0.01,NULL,NULL,0,0,'16143519453777672867',1,0,0,0,0),(2142,'LIJA  DE FIERRO N°50 ABRACOL','',84,24,185,1,'12142','','','',0,5,1,0.01,NULL,NULL,0,0,'16143533495776568381',1,0,0,0,0),(2143,'LIJA  DE FIERRO N°150 ABRACOL','',84,24,185,1,'12143','','','',0,5,1,0.01,NULL,NULL,0,0,'1614353403502124282',1,0,0,0,0),(2144,'LIJA  DE FIERRO N°180 ABRACOL','',84,24,185,1,'12144','','','',0,5,1,0.01,NULL,NULL,0,0,'16143534483087382685',1,0,0,0,0),(2146,'DISCO COPA DE ALAMBRE TRENZADO 4X5/8 ABRACOL','',84,24,107,NULL,'12146','','',NULL,0,5,1,0.5,NULL,NULL,0,0,'16144397422812933734',1,0,0,0,0),(2149,'BASE DE CACHIMBA PVC 250MMX160MM ND','',36,24,57,1,'12149','','','',0,5,1,0.55,NULL,NULL,0,0,'16144404194370293688',1,0,0,0,0),(2151,'TEE PVC ALCAN.ISO S25160MMX4 UF ND','',36,24,99,0,'12151','','','',0,5,1,1.5,NULL,NULL,0,0,'16144414444471017146',1,0,0,0,0),(2153,'CODO PVC ALCAN. 110MMX90 ND','',36,24,97,1,'12153','','','',0,5,1,0.25,NULL,NULL,0,0,'16144427728923223119',1,0,0,0,0),(2154,'CODO PVC ALCA. ISO 160MMX90° UF P/CACHIMBA','',36,24,97,1,'12154','','','',0,5,1,0.3,NULL,NULL,0,0,'16144430338800426647',1,0,0,0,0),(2156,'ADAPTADOR UPR PVC C-10 1.1/2  MATUSITA','',36,24,43,1,'12156','','','',0,5,1,0.02,NULL,NULL,0,0,'1614618238257056079',1,0,0,0,0),(2157,'ADAPTADOR UPR PVC C-10 1 ND','',36,24,43,1,'12157','','','',0,5,1,0.02,NULL,'',0,0,'161461835762574921',1,0,0,0,0),(2158,'UNION DOBLE ROSCA PVC AG SP 1/2 PAVCO','',50,24,44,1,'12158','','','',0,5,1,0.2,NULL,NULL,0,0,'16146300421879709274',1,0,0,0,0),(2159,'NIPLE PVC AG C/R 1/2X2  NICOL','',42,24,76,1,'12159','','','',0,5,1,0.01,NULL,NULL,0,1,'1614636727929939104',1,0,0,0,0),(2160,'CURVA PVC AG 1.1/2 NICOLL','',42,24,160,1,'12160','','','',0,5,1,0.02,NULL,'',0,0,'16146369984528570862',1,0,0,0,0),(2161,'BASE CONCRETO 65X40(8X6)','',36,24,124,1,'12161','','','',0,5,1,61,NULL,NULL,0,0,'16146995177244311344',1,0,0,0,0),(2164,'CLAVO C/C ACERO 2.7 X 30MM (1.1/4)XUNDAD BILDER','',148,24,77,1,'12164','','','',0,5,1,0.001,NULL,NULL,0,0,'16147193757123056658',1,0,0,0,0),(2165,'CLAVO C/C ACERO 4.5 X 100MM (4 plg)X UNIDAD BILDER','',148,24,77,1,'12165','','','',0,5,1,0.001,NULL,NULL,0,0,'16147194759929476646',1,0,0,0,0),(2167,'CLAVO C/C ACERO GALV. 3.5 X 50MM (2 plg)X UNIDAD BILDER','',148,24,77,1,'12167','','','',0,5,1,0.001,NULL,NULL,0,0,'16147195743799521650',1,0,0,0,0),(2168,'CLAVO C/C ACERO GALV. 3.5 X 65MM (2.1/2 plg)X UNIDAD  BILDER','',148,24,77,1,'12168','','','',0,5,1,0.001,NULL,NULL,0,0,'16147196595030247090',1,0,0,0,0),(2169,'CLAVO C/C ACERO GALV. 4 X 75MM (3 plg)X UNIDAD  BILDER','',148,24,77,1,'12169','','','',0,5,1,0.001,NULL,NULL,0,0,'16147197706245198919',1,0,0,0,0),(2170,'CLAVO C/C ACERO GALV. 4.0 X 2.7MM (1.1/2) X UNIDAD BILDER','',148,24,77,1,'12170','','','',0,5,1,0.001,NULL,NULL,0,0,'16147198639143245577',1,0,0,0,0),(2171,'CLAVO C/C ACERO GALV. 4.5 X 90MM (3.5 plg)X UNIDADAD BILDER','',148,24,77,1,'12171','','','',0,5,1,0.001,NULL,NULL,0,0,'16147199695542236762',1,0,0,0,0),(2172,'CURVA PVC AG 1/2 NICOLL','',42,24,160,1,'12172','','','',0,5,1,0.02,NULL,'',0,0,'16147885185371257161',1,0,0,0,0),(2173,'MEZCLADORA DUCHA MONOCOMANDO MOD. DELUXE D´ACQUA','',170,24,353,1,'12173','','','',0,5,1,0.5,NULL,NULL,0,0,'16148017139671581883',1,0,0,0,0),(2174,'MEZCLADORA COCINA ITALGRIF','',203,24,353,1,'12174','','','',0,5,1,2,NULL,NULL,0,0,'16148076619542484804',1,0,0,0,0),(2175,'JALADOR MOD. 2636 ND','',36,24,380,1,'12175','','','',0,5,1,0.1,NULL,NULL,0,0,'16148079826980001146',1,0,0,0,0),(2176,'JALADOR MOD. 2378 ND','',36,24,380,1,'12176','','','',0,5,1,0.1,NULL,'',0,0,'16148092989044781398',1,0,0,0,0),(2177,'JALADOR MOD. 3071 ND','',36,24,380,1,'12177','','','',0,5,1,0.1,NULL,NULL,0,0,'16148093745154943882',1,0,0,0,0),(2178,'JALADOR MOD. 3102 ND','',36,24,380,1,'12178','','','',0,5,1,0.1,NULL,NULL,0,0,'1614809414408049373',1,0,0,0,0),(2179,'JALADOR MOD. 2416 ND','',36,24,380,1,'12179','','','',0,5,1,0.1,NULL,NULL,0,0,'16148094789123789001',1,0,0,0,0),(2180,'JALADOR MOD. 2815 ND','',36,24,380,1,'12180','','','',0,5,1,0.1,NULL,NULL,0,0,'16148095345693176152',1,0,0,0,0),(2181,'JALADOR MOD. 3084 ND','',36,24,380,1,'12181','','','',0,5,1,0.1,NULL,'',0,0,'16148095826388266618',1,0,0,0,0),(2182,'JALADOR MOD. 3114 ND','',36,24,380,1,'12182','','','',0,5,1,0.1,NULL,NULL,0,0,'16148096143066681664',1,0,0,0,0),(2183,'JALADOR MOD. 2695 ND','',36,24,380,1,'12183','','','',0,5,1,0.1,NULL,NULL,0,0,'16148096474472389654',1,0,0,0,0),(2184,'JALADOR MOD. 2601 ND','',36,24,380,1,'12184','','','',0,5,1,0.1,NULL,NULL,0,0,'16148096949908183715',1,0,0,0,0),(2185,'JALADOR MOD. 2920 ND','',36,24,380,1,'12185','','','',0,5,1,0.1,NULL,NULL,0,0,'16148097265052690433',1,0,0,0,0),(2186,'JALADOR MOD. 2750 ND','',36,24,380,1,'12186','','','',0,5,1,0.1,NULL,NULL,0,0,'16148097792998452863',1,0,0,0,0),(2187,'PERILLA MOD. 7808 ND','',36,24,241,1,'12187','','','',0,5,1,0.05,NULL,NULL,0,0,'16148099739982367029',1,0,0,0,0),(2188,'PERILLA MOD. 7263 ND','',36,24,241,1,'12188','','','',0,5,1,0.05,NULL,NULL,0,0,'16148100037454869563',1,0,0,0,0),(2189,'REPUESTO LLAVE LAVATORIO','',36,24,382,1,'12189','','','',0,5,1,0.05,NULL,NULL,0,0,'16148107008973537336',1,0,0,0,0),(2190,'PERILLA MOD. 7034 ND','',36,24,241,1,'12190','','','',0,5,1,0.05,NULL,NULL,0,0,'16148879041602293633',1,0,0,0,0),(2191,'PERILLA MOD. 9544 ND','',36,24,241,1,'12191','','','',0,5,1,0.05,NULL,NULL,0,0,'161488804928665926',1,0,0,0,0),(2192,'PERILLA MOD. 5350 ND','',36,24,241,1,'12192','','','',0,5,1,0.05,NULL,NULL,0,0,'16148881356904298494',1,0,0,0,0),(2193,'PERILLA MOD. 7867 ND','',36,24,241,1,'12193','','','',0,5,1,0.05,NULL,NULL,0,0,'16148881985450988151',1,0,0,0,0),(2194,'JALADOR MOD. 2962 ND','',36,24,380,1,'12194','','','',0,5,1,0.05,NULL,NULL,0,0,'16148883022494690730',1,0,0,0,0),(2195,'JALADOR MOD. 2637 ND','',36,24,380,1,'12195','','','',0,5,1,0.05,NULL,NULL,0,0,'16148883675115652667',1,0,0,0,0),(2196,'JALADOR MOD. 2696 ND','',36,24,380,1,'12196','','','',0,5,1,0.05,NULL,NULL,0,0,'16148884794822241383',1,0,0,0,0),(2197,'JALADOR MOD. 3128 ND','',36,24,380,1,'12197','','','',0,5,1,0.05,NULL,NULL,0,0,'16148887943095506189',1,0,0,0,0),(2198,'JALADOR MOD. 3004  ND','',36,24,380,1,'12198','','','',0,5,1,0.05,NULL,NULL,0,0,'16148888598021621691',1,0,0,0,0),(2201,'LLAVE LAVATORIO COCINA ELECTRICO ZH - D11','',36,24,294,1,'12201','','','',0,5,1,0.5,NULL,'',0,0,'1614889826805797340',1,0,0,0,0),(2202,'LAVADERO DE ACERO INOX 01 POZA AISI 430 - EMPOTRAR TRAMONTINA','',76,24,340,1,'12202','','','',0,5,1,2.35,NULL,'',0,0,'16149841333468018952',1,0,0,0,0),(2203,'LAVADERO DE ACERO INOX 02 POZAS AISI 304  - TRAMONTINA','',76,24,340,1,'12203','','','',0,5,1,4.2,NULL,'',0,0,'16149842679561722943',1,0,0,0,0),(2204,'LLAVE LAVATORIO COCINA ELECTRICO ZH - D12','',36,24,294,1,'12204','','','',0,5,1,0.5,NULL,'',0,0,'1615217770706475277',1,0,0,0,0),(2205,'LLAVE LAVATORIO COCINA ELECTRICO GH-01','',36,24,294,1,'12205','','','',0,5,1,0.5,NULL,'',0,0,'16152180269147712903',1,0,0,0,0),(2206,'TUBO PVC AG C10 SP 4X5MT EUROTUBO','',95,24,81,1,'12206','','','',0,5,1,10,NULL,NULL,0,0,'16153968995954851702',1,0,0,0,0),(2207,'CEPILLO HISOPO 1X1/4 ONDULADO','',1,24,383,1,'12207','','','',0,5,1,0,NULL,'',0,0,'16154921971411798063',1,0,0,0,0),(2208,'SIERRA CALADORA MADERA AA310T','',1,24,32,1,'12208','','','',0,5,1,0,NULL,'',0,0,'16154923565678874136',1,0,0,0,0),(2209,'WINCHA 3MT ACEROS AREQUIPA','',1,24,60,1,'12209','','','',0,5,1,0.1,NULL,'',0,0,'16154925337270265842',1,0,0,0,0),(2210,'PICO A/P SIN MANGO BELLOTA','',26,24,26,1,'12210','','','',0,5,1,1.5,NULL,NULL,0,0,'16154928334876761171',1,0,0,0,0),(2211,'ESTRIBO COLUMNA 18X18CM - 6MM','',1,24,384,1,'12211','','','',0,5,1,0,NULL,'',0,0,'16154928864761031307',1,0,0,0,0),(2212,'ESCOBILLA  MANUAL 5-C ALAMBRE RECTO C/MANGO','',1,24,332,1,'12212','','','',0,5,1,0,NULL,'',0,0,'16154931275416772288',1,0,0,0,0),(2213,'SEÑALIZACION PELIGRO DE MUERTE','',36,24,300,1,'12213','','','',0,5,1,0.01,NULL,NULL,0,0,'16154972333134129545',1,0,0,0,0),(2214,'SEÑALIZACION POSO  A TIERRA','',36,24,300,1,'12214','','','',0,5,1,0.01,NULL,NULL,0,0,'16154973012698290151',1,0,0,0,0),(2215,'SEÑALIZACION USO OBL. LENTE DE SEGURIDAD','',36,24,300,1,'12215','','','',0,5,1,0.01,NULL,NULL,0,0,'16154974124410788837',1,0,0,0,0),(2218,'TABLERO EMPOTRABLE DE 18P ND','',36,24,59,1,'12218','','','',0,5,1,0,NULL,'',0,0,'16156555951206133944',1,0,0,0,0),(2219,'CAJA DE PASO PVC DE 10X10 CM A-095','',221,24,280,1,'12219','','','',0,5,1,0.1,NULL,'',0,0,'16156563362769246633',1,0,0,0,0),(2220,'CAJA DE PASO PVC DE 20X20 CM A-081','',221,24,280,1,'12220','','','',0,5,1,0.3,NULL,'',0,0,'16156565209966900987',1,0,0,0,0),(2222,'ALDABA NACIONAL 5 plg ND','',36,24,329,1,'12222','','','',0,5,1,0.07,NULL,'',0,0,'16156567121597747021',1,0,0,0,0),(2223,'GRAPA P/CABLE N.8','',36,52,248,1,'12223','','','',0,5,1,0,NULL,'',0,0,'16156577861088128045',1,0,0,0,0),(2224,'GRAPA P/CABLE N.10','',36,52,248,1,'12224','','','',0,5,1,0,NULL,'',0,0,'16156580346019646396',1,0,0,0,0),(2225,'LLAVE MIXTA 21MM  plgND plg','',36,24,362,1,'12225','','','',0,5,1,0,NULL,NULL,0,0,'16156587859214152498',1,0,0,0,0),(2226,'RODILLO BLANCO 7 plg TORO','',103,24,155,1,'12226','','','',0,5,1,0,NULL,NULL,0,0,'16158184513583987997',1,0,0,0,0),(2229,'TABLERO PARA  ADOSAR 2P SWIFT','',222,24,59,1,'12229','','','',0,5,1,0,NULL,'',0,0,'16158212294191714616',1,0,0,0,0),(2230,'TABLERO PARA EMPOTRAR 4P SWIFT','',222,24,59,1,'12230','','','',0,5,1,0,NULL,'',0,0,'16158213594370957297',1,0,0,0,0),(2231,'TABLERO PARA EMPOTRAR 6P SWIFT','',222,24,59,1,'12231','','','',0,5,1,0,NULL,'',0,0,'16158214347563057520',1,0,0,0,0),(2232,'TABLERO PARA EMPOTRAR 8P SWIFT','',222,24,59,1,'12232','','','',0,5,1,0,NULL,'',0,0,'16158215121878526326',1,0,0,0,0),(2233,'TABLERO PARA EMPOTRAR 12P SWIFT','',222,24,59,1,'12233','','','',0,5,1,0,NULL,'',0,0,'16158215856467044968',1,0,0,0,0),(2234,'TABLERO PARA EMPOTRAR 18P SWIFT','',222,24,59,1,'12234','','','',0,5,1,0,NULL,'',0,0,'16158216433268338737',1,0,0,0,0),(2235,'BADILEJO P/ALBAÑIL  M/GOMA 7¨C&A','',43,24,152,1,'12235','','','',0,5,1,0.35,NULL,'',0,0,'16158221727334982475',1,0,0,0,0),(2236,'GEL CONDUCTIVO 5KG THOR','',134,24,385,1,'12236','','','',0,5,1,0,NULL,NULL,0,0,'16158222719745765086',1,0,0,0,0),(2237,'CAJA REGISTROPUESTA TIERRA C/TAPA PVC - PARA RAYOS','',36,24,386,1,'12237','','','',0,5,1,0,NULL,NULL,0,0,'16158224625147155267',1,0,0,0,0),(2238,'GUANTE JEBE CALIBRE 35 T- 9 PROTEX','',224,24,62,1,'12238','','','',0,19,1,0.2,NULL,'',0,0,'16158250539852664597',1,0,0,0,0),(2239,'RODILLO MELON 7 plg TORO','',103,24,155,1,'12239','','','',0,5,1,0,NULL,'',0,0,'16158363728133684426',1,0,0,0,0),(2240,'VARILLA DE COBRE 5/8 plgX2.40 MT','',36,24,387,1,'12240','','','',0,5,1,0,NULL,'',0,0,'16158379895820069699',1,0,0,0,0),(2241,'CONECTOR 5/8 plg COBREADO','',36,24,388,1,'12241','','','',0,5,1,0,NULL,NULL,0,0,'16158381574173247312',1,0,0,0,0),(2242,'BENTONITA SODICA SACO X 30KG','',36,106,389,1,'12242','','','',0,8,1,30,NULL,NULL,0,0,'16158386222846502376',1,0,0,0,0),(2243,'PALANA CAJUELERA DERECHA TRUPER - KIDS','',28,24,153,1,'12243','','','',0,5,1,0.7,NULL,'',0,0,'16159244683609726833',1,0,0,0,0),(2244,'POLO ROJO MANGA LARGA 30/1 T/M','',36,24,234,1,'12244','','','',0,5,1,0.25,NULL,'',0,0,'16164509648702271716',1,0,0,0,0),(2245,'POLO ROJO MANGA LARGA 30/1 T/L','',36,24,234,1,'12245','','','',0,5,1,0.25,NULL,'',0,0,'16164510275532060315',1,0,0,0,0),(2246,'CHALECO REPORTERO ROJO - S  ND','',36,24,67,1,'12246','','','',0,5,1,0,NULL,NULL,0,0,'16164520545360065601',1,0,0,0,0),(2247,'CHALECO REPORTERO ROJO - M  ND','',36,24,67,1,'12247','','','',0,5,1,0,NULL,NULL,0,0,'16164520902135059818',1,0,0,0,0),(2248,'CHALECO REPORTERO ROJO - L  ND','',36,24,67,1,'12248','','','',0,5,1,0,NULL,NULL,0,0,'16164521324877489580',1,0,0,0,0),(2249,'CHALECO REPORTERO ROJO - XL  ND','',36,24,67,1,'12249','','','',0,5,1,0,NULL,NULL,0,0,'16164521944001122380',1,0,0,0,0),(2250,'ESPATULA M/GOMA 5 plg EUROTOOLS','',225,24,169,1,'12250','','','',0,5,1,0.15,NULL,'',0,0,'16165344189436948433',1,0,0,0,0),(2251,'LLAVE LAVATORIO COCINA P/GANSO 68575 - GENEBRE','',226,24,294,1,'12251','','','',0,5,1,0.5,NULL,'',0,0,'16165345998483850483',1,0,0,0,0),(2252,'LLAVE LAVATORIO MUEBLE 1007 04 - GENEBRE','',226,24,294,1,'12252','','','',0,5,1,0.4,NULL,'',0,0,'16165349738580428578',1,0,0,0,0),(2253,'DUCHA REG. CABEZA  ITALICA T-47 SEVILLA','',218,24,159,1,'12253','','','',0,5,1,0,NULL,'',0,0,'16165354069176004933',1,0,0,0,0),(2254,'TUBO DE ABASTO INOX 1/2X40CM - GENEBRE','',226,24,51,1,'12254','','','',0,5,1,0.1,NULL,'',0,0,'16165366536986040818',1,0,0,0,0),(2255,'TUBO DE ABASTO INOX 7/8X40CM - GENEBRE','',226,24,51,1,'12255','','','',0,5,1,0.1,NULL,'',0,0,'16165367347135618742',1,0,0,0,0),(2256,'DUCHA REG. CABEZA  DREYFUSS GRIS  T-172 SEVILLA','',218,24,159,1,'12256','','','',0,5,1,0,NULL,NULL,0,0,'16165369593617768227',1,0,0,0,0),(2257,'DUCHA REG. CABEZA  MASAJE ZORRITOS  235300CP SEVILLA','',218,24,159,1,'12257','','','',0,5,1,0,NULL,NULL,0,0,'16165371274420131341',1,0,0,0,0),(2258,'BRAZO D/DUCHA ESPAÑOLA 30CMS SH-7702 SEVILLA','',218,24,159,1,'12258','','','',0,5,1,0,NULL,NULL,0,0,'16165373159833040229',1,0,0,0,0),(2259,'LLAVE DE PASO PVC C/R 1/2 DUKE','',227,24,58,1,'12259','','','',0,5,1,0,NULL,NULL,0,0,'16165378746646603982',1,0,0,0,0),(2260,'VALVULA JARDIN  PVC NARANJA PEPE - SEVILLA','',218,24,24,1,'12260','','','',0,5,1,0,NULL,NULL,0,0,'16165382077068867417',1,0,0,0,0),(2261,'BALANZA ELECTRONICA DE 300KG PLATAFORMA','',36,24,390,1,'12261','','','',0,5,1,10,NULL,NULL,0,0,'16165941828224351912',1,0,0,0,0),(2262,'GANCHO EXHIBIDOR 15 CM','',36,24,391,1,'12262','','','',0,5,1,0.02,NULL,NULL,0,0,'16165945959532266205',1,0,0,0,0),(2263,'GANCHO EXHIBIDOR 20 CM','',36,24,391,1,'12263','','','',0,5,1,0.01,NULL,'',0,0,'16165947807115836802',1,0,0,0,0),(2264,'ALCANTARILLA SP MP-68 CIRC 24 plgX1.80 MM SIDERPERU','',13,107,392,1,'12264','','','',0,13,1,36.71,NULL,NULL,0,0,'16166053048804982346',1,0,0,0,0),(2265,'ALCANTARILLA SP MP-68 CIRC 36 plgX2.00 MM SIDERPERU','',13,107,392,1,'12265','','','',0,13,1,56.2,NULL,'',0,0,'16166053939635414416',1,0,0,0,0),(2266,'PEGAMENTO AMARILLO PVC 1/32 ULTRAPEG','',228,37,23,1,'12266','','','',0,5,1,0.05,NULL,NULL,0,0,'16167736444248637763',1,0,0,0,0),(2267,'PEGAMENTO AMARILLO PVC 1/64  ULTRAPEG','',228,37,23,1,'12267','','','',0,5,1,0.02,NULL,'',0,0,'16167738062896653625',1,0,0,0,0),(2268,'CABLE CONCENTRICO 2X4MM2 INDECO','',66,16,393,1,'12268','','','',0,13,1,3,NULL,'',0,0,'16167787499415473200',1,0,0,0,0),(2269,'CABLE VULACNIZADO 2X16 NLT INDECO','',66,35,310,1,'12269','','','',0,13,1,0.3,NULL,NULL,0,0,'16167789196849047778',1,0,0,0,0),(2270,'PINTURA LATEX SATINADO AZUL 4LT CPP','',133,68,257,1,'12270','','','',0,5,1,4.7,NULL,'',0,0,'16168641597658944027',1,0,0,0,0),(2271,'PERILLA MOD. 7271 ND','',36,24,241,1,'12271','','','',0,5,1,0,NULL,NULL,0,0,'16171254331551656696',1,0,0,0,0),(2272,'PERILLA MOD. 7239 ND','',36,24,241,1,'12272','','','',0,5,1,0,NULL,NULL,0,0,'16171254864698147704',1,0,0,0,0),(2273,'CANDADO DORADO 38MM JPC','',229,24,192,1,'12273','','','',0,5,1,0.15,NULL,'',0,0,'16172203413277837886',1,0,0,0,0),(2274,'CANDADO DORADO 50MM JPC','',229,24,192,1,'12274','','','',0,5,1,0.25,NULL,'',0,0,'16172204579393429994',1,0,0,0,0),(2276,'CANDADO DORADO 63MM JPC','',229,24,192,1,'12276','','','',0,5,1,0.45,NULL,'',0,0,'16172205146988836270',1,0,0,0,0),(2277,'CANDADO DORADO 75MM JPC','',229,24,192,1,'12277','','','',0,5,1,0.65,NULL,'',0,0,'16172205657038970333',1,0,0,0,0),(2278,'NIPLE PVC AG C/R 1X2 NICOL','',42,24,76,1,'12278','','','',0,5,1,0,NULL,NULL,0,0,'1617229923865382075',1,0,0,0,0),(2279,'REDUCCION PVC SAP 3x2 NICOL','',42,24,21,1,'12279','','','',0,5,1,0.07,NULL,'',0,0,'16172305691518334079',1,0,0,0,0),(2280,'CURVA PVC SEL 5/8 NICOL','',42,24,17,1,'12280','','','',0,5,1,0.01,NULL,'',0,0,'16172308428458732598',1,0,0,0,0),(2281,'ALCANTARILLA SP MP-68 CIRC 48 plgX2.50 MM SIDERPERU','',13,107,392,1,'12281','','','',0,13,1,0,NULL,'',0,0,'16172926928710918456',1,0,0,0,0),(2282,'YEE PVC SAL 4X3 PAVCO','',50,24,394,1,'12282','','','',0,5,1,0.3,NULL,'',0,0,'16173005835793792638',1,0,0,0,0),(2283,'CALAMINA 0.14 X 3.60 PRODAC','',17,24,350,1,'12283','','','',0,5,1,0,NULL,NULL,0,0,'16176361892712275221',1,0,0,0,0),(2284,'CALAMINA 0.14 X 1.80 PRODAC','',17,24,350,1,'12284','','','',0,5,1,1.5,NULL,'',0,0,'16176362456882011246',1,0,0,0,0),(2285,'CODO HDPE PN-16 50MM(1.1/2) X 90 IRRIPLAST','',163,24,18,1,'12285','','','',0,5,1,0.15,NULL,NULL,0,0,'16178057687699906190',1,0,0,0,0),(2286,'FOCO LED 12W BOLA - SWIFT','',222,24,219,1,'12286','','','',0,5,1,0.05,NULL,'',0,0,'16178152319327184925',1,0,0,0,0),(2287,'CERRADURA BLINDADA 900 DORADA FORTE','',167,24,326,1,'12287','','','',0,5,1,2,NULL,'',0,0,'16178234584212491471',1,0,0,0,0),(2288,'BUSHING 1/2 X 1/2 NICOLL','',42,24,103,1,'12288','','','',0,5,1,0.05,NULL,NULL,0,0,'16178269896493511065',1,0,0,0,0),(2291,'DRIZA POLIPROPILENO 5/8 ROLLO APROX 110M - 10KG','',36,71,270,1,'12291','','','',0,3,1,0.035,NULL,'',0,0,'16182497475700427347',1,0,0,0,0),(2292,'DRIZA POLIPROPILENO 1/2 ROLLO APROX 110M - 10KG','',36,71,270,1,'12292','','','',0,3,1,0.09,NULL,'',0,0,'16182498507662831486',1,0,0,0,0),(2293,'MALLA SEGURIDAD NARANJA X ROLLO SCHUBERT','',25,105,376,1,'12293','','','',0,11,1,0,NULL,NULL,0,0,'16183283317002240256',1,0,0,0,0),(2294,'PALETA D/MADERA 6X30 ND','',36,24,363,1,'12294','','','',0,5,1,0.3,NULL,'',0,0,'16184085625165044832',1,0,0,0,0),(2295,'PALETA D/MADERA 15X25 ND','',36,24,363,1,'12295','','','',0,5,1,0.4,NULL,'',0,0,'16184086676958345514',1,0,0,0,0),(2298,'PALETA D/MADERA 25X40 ND','',36,24,363,1,'12298','','','',0,5,1,0.5,NULL,'',0,0,'16184088391459515876',1,0,0,0,0),(2299,'PALETA D/MADERA 20X36 ND','',36,24,363,1,'12299','','','',0,5,1,0.5,NULL,'',0,0,'16184090091182500262',1,0,0,0,0),(2300,'PALETA D/MADERA 19X30 ND','',36,24,363,1,'12300','','','',0,5,1,0.5,NULL,'',0,0,'16184090694931279906',1,0,0,0,0),(2301,'PALETA D/MADERA 8X40 ND','',36,24,363,1,'12301','','','',0,5,1,0.4,NULL,'',0,0,'16184091535320426119',1,0,0,0,0),(2302,'PINTURA LATEX PATO/SATINADO VARIOS DEFEC.CPP','',36,68,147,1,'12302','','','',0,5,1,5.75,NULL,NULL,0,0,'16184392813658860805',1,0,0,0,0),(2303,'MALLA GALVANIZADA  1/2X1/2X3X100X25GS- BWG - PLATIFICADA APACHE','',99,34,48,1,'12303','','','',0,13,1,0.3,NULL,'',0,0,'16185170515681535842',1,0,0,0,0),(2304,'ALICATE UNIVERSAL T200-7X TRUPER','',28,24,136,1,'12304','','','',0,5,1,0.3,NULL,'<p>ALICATE 7&quot; TRUPER</p>',0,0,'16186046463849324107',1,0,0,0,0),(2305,'ALICATE UNIVERSAL T201-7X TRUPER','',28,24,136,1,'12305','','','',0,5,1,0.25,NULL,'',0,0,'16186047018001489718',1,0,0,0,0),(2306,'WINCHA GLOBAL PLUS 1 X 8 MT STANLEY','',108,24,60,1,'12306','','','',0,5,1,0.6,NULL,'',0,0,'16189375547318246176',1,0,0,0,0),(2307,'WINCHA GLOBAL PLUS 3/4 X 5 MT STANLEY','',108,24,60,1,'12307','','','',0,5,1,0.5,NULL,'',0,0,'16189378285223771073',1,0,0,0,0),(2308,'WINCHA GLOBAL PLUS 1/2 X 3 MT STANLEY','',108,24,60,1,'12308','','','',0,5,1,0.5,NULL,'',0,0,'16189379197651217872',1,0,0,0,0),(2309,'ADOQUIN 10X20X 04 COLOR NATURAL PACASMAYO','',2,61,249,1,'12309','','','',0,28,1,90,NULL,NULL,0,0,'16190218429413791240',1,0,0,0,0),(2310,'GUANTE ANTICORTE NYLON ROJO - EUROTOOLS','',225,24,62,1,'12310','','','',0,19,1,0,NULL,'',0,0,'16191106987235974042',1,0,0,0,0),(2311,'PINTURA LATEX SATINADO BLANCO 4GL CPP','',133,108,257,1,'12311','','','',0,5,1,0,NULL,'',0,0,'16191864897456760478',1,0,0,0,0),(2312,'PINTURA LATEX PATO MARFIL 4GL CPP','',133,108,147,1,'12312','','','',0,5,1,0,NULL,'',0,0,'16191866435172017315',1,0,0,0,0),(2313,'DRIZA POLIPROPILENO 1/4 X MT','',36,70,270,1,'12313','','','',0,13,1,0.001,NULL,'',0,0,'16192091742410951801',1,0,0,0,0),(2314,'DRIZA POLIPROPILENO 1/8 MT','',36,91,270,1,'12314','','','',0,13,1,0.02,NULL,'',0,0,'16192097881813563167',1,0,0,0,0),(2315,'DRIZA POLIPROPILENO 1 plgMT','',36,98,270,1,'12315','','','',0,13,1,0.2,NULL,NULL,0,0,'16192099992026022085',1,0,0,0,0),(2316,'DRIZA POLIPROPILENO 3/16 MT','',36,70,270,1,'12316','','','',0,13,1,0.014,NULL,'',0,0,'16192104556302375454',1,0,0,0,0),(2317,'DRIZA POLIPROPILENO 3/4 MT','',36,71,270,1,'12317','','','',0,13,1,0.125,NULL,NULL,0,0,'16192106902501933896',1,0,0,0,0),(2318,'DRIZA POLIPROPILENO 3/8  MT','',36,72,270,1,'12318','','','',0,13,1,0.05,NULL,'',0,0,'16192108236907798077',1,0,0,0,0),(2319,'DRIZA POLIPROPILENO 5/16 MT','',36,71,270,1,'12319','','','',0,13,1,0.035,NULL,'',0,0,'16192110235164216022',1,0,0,0,0),(2320,'DRIZA TRENZADA 1 plg MT','',36,98,270,1,'12320','','','',0,13,1,0.3,NULL,NULL,0,0,'16192113549542096722',1,0,0,0,0),(2321,'DRIZA TRENZADA 5/16 plg MT','',36,71,270,NULL,'12321','','',NULL,0,13,1,0,NULL,NULL,0,0,'16192115004244471566',1,0,0,0,0),(2322,'LIMA RT-8 plg C/MANGO - BELLOTA','',26,24,54,1,'12322','','','',0,5,1,0,NULL,NULL,0,0,'16192122734183619642',1,0,0,0,0),(2324,'DRIZA POLIPROPILENO 5/32 (ROLLO APROX150MT)','',36,91,270,1,'12324','','','',0,3,1,0.1,NULL,'',0,0,'16192161395278041226',1,0,0,0,0),(2325,'DRIZA POLIPROPILENO 5/32','',36,91,270,1,'12325','','','',0,13,1,0.02,NULL,'',0,0,'16192704965157600172',1,0,0,0,0),(2326,'PICAPORTE BLISTER 2 plg VITALE','',230,24,331,1,'12326','','','',0,5,1,0.15,NULL,'',0,0,'16192861565241688717',1,0,0,0,0),(2327,'PICAPORTE BLISTER 2.1/2 plg VITALE','',230,24,331,1,'12327','','','',0,5,1,0.15,NULL,'',0,0,'16192862261109602196',1,0,0,0,0),(2328,'PEGAMENTO REG. PVC 1 GL OATEY','',24,24,23,1,'12328','','','',0,5,1,6,NULL,'',0,0,'16194456193460851465',1,0,0,0,0),(2329,'PICAPORTE BLISTER 5 plg VITALE','',230,24,331,1,'12329','','','',0,5,1,0.15,NULL,'',0,0,'16194464145655266318',1,0,0,0,0),(2330,'TIRALINEAS METAL  - PALOMA','',36,24,166,1,'12330','','','',0,5,1,0,NULL,'',0,0,'16194474651573714118',1,0,0,0,0),(2332,'TIRALINEAS METAL 9M - PALOMA','',36,24,166,0,'12332','','','',0,5,1,0,NULL,'',0,0,'16194475468787212360',1,0,0,0,0),(2333,'GRUÑA DE CANTO /TIGRE','',231,24,218,1,'12333','','','',0,5,1,0.2,NULL,'',0,0,'16194493347245063293',1,0,0,0,0),(2334,'GRUÑA DE CENTRO /TIGRE','',231,24,218,1,'12334','','','',0,5,1,0.2,NULL,NULL,0,0,'16194494385802642672',1,0,0,0,0),(2335,'HILO PARA ALBAÑILERIA 0.80MMX100 MT VERDE ARATY','',140,24,255,1,'12335','','','',0,5,1,0,NULL,'',0,0,'1619539592218500331',1,0,0,0,0),(2336,'TIZAS DE COLORES ANTIALERGICAS','',36,24,395,1,'12336','','','',0,5,1,0,NULL,'',0,0,'16195636197600567547',1,0,0,0,0),(2337,'ALCANTARILLA SP MP-68 CIRC 60 plgX3.00 MM  SIDERPERU','',13,107,392,1,'12337','','','',0,13,1,133.65,NULL,'',0,1,'16200824547401768879',1,0,0,0,0),(2338,'TABLA LIJADORA DE PARED 20X23 ND','',36,24,370,1,'12338','','','',0,5,1,0.3,NULL,'',0,0,'16201647582846587062',1,0,0,0,0),(2339,'PALO DE RASTRILLO','',36,24,132,1,'12339','','','',0,5,1,0,NULL,NULL,0,0,'16201649331294554583',1,0,0,0,0),(2340,'MARTILLO 25MM S/PULIR TRAMONTINA','',76,24,130,1,'12340','','','',0,5,1,0.5,NULL,'',0,0,'16202511876611135817',1,0,0,0,0),(2341,'MARTILLO 27MM S/PULIR TRAMONTINA','',76,24,130,1,'12341','','','',0,5,1,0.5,NULL,'',0,0,'16202512403254448664',1,0,0,0,0),(2342,'LLAVE DE PASO DOB. UNION ROSC. 3/4  DUKE','',227,24,58,1,'12342','','','',0,5,1,0.25,NULL,'',0,0,'16202519853109706420',1,0,0,0,0),(2343,'LLAVE DE PASO DOB. UNION ROSC. 1 plg DUKE','',227,24,58,1,'12343','','','',0,5,1,0.3,NULL,'',0,0,'16202522471085519152',1,0,0,0,0),(2344,'VALVULA JARDINERO  1/2  DUKE','',227,24,24,1,'12344','','','',0,5,1,0,NULL,NULL,0,0,'16202524989124941389',1,0,0,0,0),(2345,'LLAVE DE PASO PVC  3/4   PCP','',40,24,58,1,'12345','','','',0,5,1,0.35,NULL,'',0,0,'16202528268266685846',1,0,0,0,0),(2346,'LLAVE DE PASO PVC  1 plg   PCP','',40,24,58,1,'12346','','','',0,5,1,0.45,NULL,NULL,0,0,'16202529307350147038',1,0,0,0,0),(2347,'LLAVE DUCHA GOL - SEVILLA','',218,24,146,1,'12347','','','',0,5,1,0.4,NULL,'',0,0,'16202531822830894549',1,0,0,0,0),(2348,'MEZCLADORA DUCHA CLARITA - SEVILLA','',218,24,353,1,'12348','','','',0,5,1,0.85,NULL,'',0,0,'16202533628748804821',1,0,0,0,0),(2349,'FOCO LED 7W BOLA - SWIFT','',222,24,219,1,'12349','','','',0,5,1,0,NULL,NULL,0,0,'16203314072205595923',1,0,0,0,0),(2350,'PALETA D/MADERA 10X40 ND','',36,24,363,1,'12350','','','',0,5,1,0,NULL,'',0,0,'16204204115545463773',1,0,0,0,0),(2351,'PERILLA MOD. 7107 ND','',36,24,241,1,'12351','','','',0,5,1,0,NULL,NULL,0,0,'16204212943436246054',1,0,0,0,0),(2352,'BOLEADOR PVC 10X20 ND','',36,24,396,1,'12352','','','',0,5,1,0,NULL,NULL,0,0,'16204222372902724866',1,0,0,0,0),(2353,'MANGO PARA ZAPAPICO CUBIERTO CON PVC','',36,24,131,1,'12353','','','',0,5,1,0,NULL,'',0,0,'16204226069446172338',1,0,0,0,0),(2354,'PALETA D/MADERA 8X38 ND','',36,24,363,1,'12354','','','',0,5,1,0,NULL,'',0,0,'16204960605387828671',1,0,0,0,0),(2355,'CINTA EMBALAJE X 70 YARDS ULTRAPACK','',113,24,78,1,'12355','','','',0,5,1,0.15,NULL,NULL,0,0,'16209147807871447877',1,0,0,0,0),(2356,'CINTA EMBALAJE X 100 YARDS  ULTRAPACK','',113,24,78,1,'12356','','','',0,5,1,0.2,NULL,NULL,0,0,'16209149696885911004',1,0,0,0,0),(2357,'CINTA MASKING 1.1/2 - 40 YD X36MM PEGAFAN','',234,24,277,1,'12357','','','',0,5,1,0.2,NULL,NULL,0,0,'16209160403033810559',1,0,0,0,0),(2358,'ANILLO DE CERA P/INODORO ND','',36,24,323,1,'12358','','','',0,5,1,0,NULL,'',0,0,'16209330033559328149',1,0,0,0,0),(2359,'ASIENTO DE BAÑO  STANDARD BLANCO PP FIORI','',235,24,397,1,'12359','','','',0,5,1,0,NULL,'',0,0,'16209335276744445307',1,0,0,0,0),(2360,'ESTANQUE BLANCO RAPID JET PLUS - TREBOL','',5,24,398,1,'12360','','','',0,5,1,0,NULL,'',0,0,'16209343271493051717',1,0,0,0,0),(2361,'ESTANQUE PREMIUM RAPID JET BLANCO PULSADOR - TREBOL','',5,24,398,1,'12361','','','',0,5,1,0,NULL,'',0,0,'16209344774573930582',1,0,0,0,0),(2362,'LAVATORIO BLANCO MANCORA - TREBOL','',5,24,399,1,'12362','','','',0,5,1,0,NULL,'',0,0,'16209348119891589453',1,0,0,0,0),(2363,'PEDESTAL BLANCO UNIVERSAL - TREBOL','',5,24,400,1,'12363','','','',0,5,1,0,NULL,'',0,0,'16209350138305668588',1,0,0,0,0),(2364,'KIT PERNO DE ANCLAJE P/INODORO VARIOS','',36,24,401,1,'12364','','','',0,5,1,0,NULL,'',0,0,'16209352684189137933',1,0,0,0,0),(2365,'TAZA BLANCO RAPID JET PLUS - TREBOL','',5,24,402,1,'12365','','','',0,5,1,0,NULL,'',0,0,'16209356103004034107',1,0,0,0,0),(2366,'TAZA PREMIUM RAPID JET BLANCO C/ASIENTO - TREBOL','',5,24,402,1,'12366','','','',0,5,1,0,NULL,'',0,0,'16209358061708507779',1,0,0,0,0),(2367,'TUBO DE ABASTO 1/2 IMPORTANDO','',36,24,51,1,'12367','','','',0,5,1,0,NULL,NULL,0,0,'16209360191831812419',1,0,0,0,0),(2368,'TUBO DE ABASTO 7/8 IMPORTANDO','',36,24,51,1,'12368','','','',0,5,1,0,NULL,NULL,0,0,'16209361174948902602',1,0,0,0,0),(2369,'KIT UÑAS C/PERNO ZINCADA VARIOS','',36,24,333,1,'12369','','','',0,5,1,0,NULL,'',0,0,'16209389078646921342',1,0,0,0,0),(2370,'CINTA MASKING 1`` X 30 YD X48MM PEGAFAN','',234,24,277,1,'12370','','','',0,5,1,0,NULL,'',0,0,'16210356196098082053',1,0,0,0,0),(2372,'CINTA MASKING 1/2 X 30 YD X90MM PEGAFAN','',234,24,277,1,'12372','','','',0,5,1,0,NULL,NULL,0,0,'16211016024640777120',1,0,0,0,0),(2373,'CINTA MASKING 3/4 X 30 YD X60MM PEGAFAN','',234,24,277,1,'12373','','','',0,5,1,0,NULL,NULL,0,0,'16211016975372965810',1,0,0,0,0),(2374,'CINTA MASKING 2`` X 30 YD X24MM PEGAFAN','',234,24,277,1,'12374','','','',0,5,1,0,NULL,NULL,0,0,'16211017881569473580',1,0,0,0,0),(2375,'CABEZA D/DUCHA 1/2 CROMADA C&A','',43,24,159,1,'12375','','','',0,5,1,0,NULL,NULL,0,0,'16212611458557637205',1,0,0,0,0),(2377,'TRANPA BOTELLA PVC P/LAVATORIO SANIFE','',37,24,38,1,'12377','','','',0,5,1,0.3,NULL,'',0,0,'1621290236249644284',1,0,0,0,0),(2378,'TIRAFON 1/4X2 ZINCADO','',236,24,403,1,'12378','','','',0,5,1,0.005,NULL,'',0,0,'16212904852936267797',1,0,0,0,0),(2380,'LLAVE DE PASO LISA PVC 3/4 NICOLL-D','',42,24,58,1,'12380','','','',0,5,1,0.1,NULL,NULL,0,0,'16213754736258388187',1,0,0,0,0),(2381,'VALVULA  DE INGRESO INOD.T/BAJO 7/8 SANIFE','',37,24,24,1,'12381','','','',0,5,1,0.005,NULL,NULL,0,0,'16213760057052415192',1,0,0,0,0),(2382,'ADAPTADOR CPVC UPR  1/2 NICOLL','',42,24,43,1,'12382','','','',0,5,1,0.05,NULL,NULL,0,0,'16213760922279540213',1,0,0,0,0),(2383,'PLANCHA POLICARBONATO TRANSPARENTE 6MM 11.60X2.10 MT ND','',36,24,404,1,'12383','','','',0,5,1,0,NULL,NULL,0,0,'16214441955368427317',1,0,0,0,0),(2384,'PLANCHA D/BATIR 6 PRETUL','',41,24,322,1,'12384','','','',0,5,1,0.3,NULL,NULL,0,0,'16215255067170039301',1,0,0,0,0),(2385,'PLANCHA D/BATIR 7 PRETUL','',41,24,322,1,'12385','','','',0,5,1,0.3,NULL,NULL,0,0,'16215256201796061176',1,0,0,0,0),(2386,'PLANCHA D/BATIR 8 PRETUL','',41,24,322,1,'12386','','','',0,5,1,0.3,NULL,NULL,0,0,'16215256957122938903',1,0,0,0,0),(2387,'PLOMADA #1 LATON CON CENTRO TRUPER','',28,24,324,1,'12387','','','',0,5,1,0.5,NULL,'',0,0,'16215267953355701785',1,0,0,0,0),(2388,'PLOMADA #3  LATON CON CENTRO TRUPER','',28,24,324,1,'12388','','','',0,5,1,0.4,NULL,'',0,0,'16215268795739346099',1,0,0,0,0),(2389,'PLOMADA #3 DE ZINC PRETUL','',41,24,324,1,'12389','','','',0,5,1,0.4,NULL,NULL,0,0,'16215271015140907973',1,0,0,0,0),(2390,'CUTTER 6 PLASTICO 18MM PRETUL','',41,24,104,1,'12390','','','',0,5,1,0.02,NULL,'',0,0,'16215278366320743650',1,0,0,0,0),(2391,'ZAPAPICO JARDINERO 16 plg BELLOTA','',26,24,26,1,'12391','','','',0,5,1,0,NULL,NULL,0,0,'16215283257050010849',1,0,0,0,0),(2392,'CUCHILLA TERMOMAG  DIFERENCIAL 2X25A BTICINO','',81,24,207,1,'12392','','','',0,5,1,0.5,NULL,'',0,0,'16215401033571795888',1,0,0,0,0),(2393,'PROTECTOR FACIAL REYPLAST','',36,24,336,1,'12393','','','',0,5,1,0,NULL,NULL,0,0,'16215409942674709772',1,0,0,0,0),(2394,'GUANTE JEBE CALIBRE 35 T-10 MASTER','',90,24,62,1,'12394','','','',0,19,1,0.2,NULL,'',0,0,'16215447524925822251',1,0,0,0,0);
/*!40000 ALTER TABLE `productos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `productos_codigos_proveedor`
--

DROP TABLE IF EXISTS `productos_codigos_proveedor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `productos_codigos_proveedor` (
  `prdcod_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `prd_codi_fk` int(10) unsigned DEFAULT NULL,
  `prdcod_codigo1` varchar(45) DEFAULT NULL,
  `prdcod_codigo2` varchar(45) DEFAULT NULL,
  `prdcod_codigo3` varchar(45) DEFAULT NULL,
  `prdcod_codigo4` varchar(45) DEFAULT NULL,
  `prdcod_codigo5` varchar(45) DEFAULT NULL,
  `prdcod_codigo6` varchar(45) DEFAULT NULL,
  `prdcod_codigo7` varchar(45) DEFAULT NULL,
  `prdcod_codigo8` varchar(45) DEFAULT NULL,
  `prdcod_codigo9` varchar(45) DEFAULT NULL,
  `prdcod_codigo10` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`prdcod_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `productos_codigos_proveedor`
--

LOCK TABLES `productos_codigos_proveedor` WRITE;
/*!40000 ALTER TABLE `productos_codigos_proveedor` DISABLE KEYS */;
/*!40000 ALTER TABLE `productos_codigos_proveedor` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `productos_familia`
--

DROP TABLE IF EXISTS `productos_familia`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `productos_familia` (
  `prdfam_codi` int(11) NOT NULL AUTO_INCREMENT,
  `prdfam_nombre` varchar(200) NOT NULL DEFAULT '',
  `prdfam_estado` int(11) NOT NULL DEFAULT 1,
  `prdfam_abreviatura` varchar(20) DEFAULT NULL,
  `prdfam_usu_crea` varchar(45) DEFAULT NULL,
  `prdfam_usu_modifica` varchar(45) DEFAULT NULL,
  `prdfam_usu_activa` varchar(45) DEFAULT NULL,
  `prdfam_muestra_detalle` int(11) NOT NULL DEFAULT 0,
  `prdfam_descripcion` text DEFAULT NULL,
  `prdfam_codi_fk_padre` int(10) unsigned NOT NULL DEFAULT 0,
  `prdfam_codigo` char(3) NOT NULL DEFAULT '',
  `prdfam_id_trans` varchar(45) DEFAULT NULL,
  `tipexi_codi_fk` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`prdfam_codi`),
  UNIQUE KEY `Index_prdfam_nombre` (`prdfam_nombre`) USING BTREE,
  KEY `Index_prdfam_estado` (`prdfam_estado`)
) ENGINE=InnoDB AUTO_INCREMENT=405 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `productos_familia`
--

LOCK TABLES `productos_familia` WRITE;
/*!40000 ALTER TABLE `productos_familia` DISABLE KEYS */;
INSERT INTO `productos_familia` VALUES (1,'CEMENTO',1,'CEM','','','',0,'',0,'101',NULL,1),(2,'YESO',1,'YE','','','',0,NULL,0,'102',NULL,1),(4,'CALAMINA IMPORTADA',1,'CAL IM','','','',0,NULL,0,'104',NULL,1),(5,'FIERRO',1,'','','','',0,NULL,0,'105',NULL,1),(8,'LADRILLO TECHO',1,'LAD TECH','','','',0,NULL,0,'108',NULL,1),(9,'PINTURA',1,'','','','',0,NULL,0,'109',NULL,1),(10,'TUBO',1,'TB','','','',0,NULL,0,'110',NULL,1),(11,'ALAMBRE PRODAC',1,'ALAMPRO','','','',0,NULL,0,'111',NULL,1),(12,'LLANTAS',1,'','','','',0,NULL,0,'112',NULL,1),(14,'LIJA',1,'LIJA','','','',0,NULL,0,'114',NULL,1),(15,'BARRA CONSTRUCCIÓN.',1,'BARRA CONSTR.','','','',0,'',0,'115',NULL,1),(16,'TECNOPORT',1,'TECNOPORT','','','',0,NULL,0,'116',NULL,1),(17,'CURVA',1,'CURVA','','','',0,NULL,0,'117',NULL,1),(18,'CODO',1,'CODO','','','',0,NULL,0,'118',NULL,1),(19,'TEE',1,'TEE','','','',0,NULL,0,'119',NULL,1),(20,'YEE SAL PLASTICA',1,'YSALPLAS','','','',0,NULL,0,'120',NULL,1),(21,'REDUCCION',1,'RED.','','','',0,NULL,0,'121',NULL,1),(22,'CAJA SEL PLASTICA',1,'CAJPLA','','','',0,NULL,0,'122',NULL,1),(23,'PEGAMENTO',1,'PEG.','','','',0,NULL,0,'123',NULL,1),(24,'VALVULA',1,'VALVULA','','','',0,NULL,0,'124',NULL,1),(25,'PALANA',1,'PALANA','','','',0,NULL,0,'125',NULL,1),(26,'ZAPAPICO',1,'ZAPAPICO','','','',0,NULL,0,'126',NULL,1),(27,'CARRETILLA',1,'CARRETILLA','','','',0,'',0,'127',NULL,1),(29,'CLAVO PRODAC',1,'CLAVO PRO','','','',0,NULL,0,'129',NULL,1),(32,'SIERRA',1,'SIERRA','','','',0,NULL,0,'132',NULL,1),(33,'ALAMBRE DE PUA',1,'ALAM. PUA','','','',0,'',0,'133',NULL,1),(35,'CINTA AISLANTE',1,'CTA. AISL','','','',0,NULL,0,'135',NULL,1),(36,'REGISTRO',1,'REG.','','','',0,NULL,0,'136',NULL,1),(37,'SUMIDERO',1,'SUM.','','','',0,NULL,0,'137',NULL,1),(38,'TRAMPA',1,'TRAM','','','',0,NULL,0,'138',NULL,1),(39,'LLAVE CHORRO',1,'LLAV. CH.','','','',0,NULL,0,'139',NULL,1),(40,'TRIPLAY',1,'TRIPLAY','','','',0,NULL,0,'140',NULL,1),(41,'LUBRICANTE',1,'LUBR.','','','',0,NULL,0,'141',NULL,1),(42,'BASE DE CACHIMBA',1,'BAS. CACHIMBA','','','',0,NULL,0,'142',NULL,1),(43,'ADAPTADOR',1,'ADAP.','','','',0,'',0,'143',NULL,1),(44,'UNION',1,'UNION','','','',0,NULL,0,'144',NULL,1),(45,'SIKA',1,'SIKA','','','',0,NULL,0,'145',NULL,1),(46,'TEFLON',1,'TEFLON','','','',0,NULL,0,'146',NULL,1),(47,'TAPON',1,'TAPON','','','',0,NULL,0,'147',NULL,1),(48,'MALLA GALVANIZADA',1,'MALL GAL','','','',0,NULL,0,'148',NULL,1),(49,'CONFITILLO',1,'CONFITILLO','','','',0,NULL,0,'149',NULL,1),(50,'TAPA',1,'TAPA','','','',0,NULL,0,'150',NULL,1),(51,'TUBO ABASTOS',1,'TB. ABASTOS','','','',0,NULL,0,'151',NULL,1),(52,'BARRETA',1,'BARRETA','','','',0,NULL,0,'152',NULL,1),(53,'COMBA',1,'COMBA','','','',0,'',0,'153',NULL,1),(54,'LIMA',1,'LIMA','','','',0,NULL,0,'154',NULL,1),(56,'OCRE',1,'OCRE','','','',0,NULL,0,'156',NULL,1),(57,'CACHIMBA',1,'CACH','','','',0,'',0,'157',NULL,1),(58,'LLAVE DE PASO',1,'LLPAS','','','',0,NULL,0,'158',NULL,1),(59,'TABLERO',1,'TBLRO','','','',0,NULL,0,'159',NULL,1),(60,'WINCHA',1,'WCHA','','','',0,NULL,0,'160',NULL,1),(61,'ANILLO ALCANTARILLADO',1,'ANIL','','','',0,'',0,'161',NULL,1),(62,'GUANTE',1,'GUAN','','','',0,NULL,0,'162',NULL,1),(63,'CASCO',1,'CAS','','','',0,'',0,'163',NULL,1),(64,'MANGUERA REFORZADA',1,'MANG. REF','','','',0,NULL,0,'164',NULL,1),(65,'CINTA PELIGRO',1,'CINTAPEL','','','',0,'',0,'165',NULL,1),(66,'ASPERSOR',1,'ASPER','','','',0,NULL,0,'166',NULL,1),(67,'CHALECO',1,'CHAL','','','',0,'',0,'167',NULL,1),(68,'LENTE',1,'LENTE','','','',0,NULL,0,'168',NULL,1),(71,'AGREGADOS',1,'AGRE','','','',0,NULL,0,'171',NULL,1),(72,'CALAMINA TRANSPARENTE',1,'CALTRANS','','','',0,NULL,0,'172',NULL,1),(73,'PIEDRA',1,'PIEDRA','','','',0,NULL,0,'173',NULL,1),(74,'TEFLON 2',1,'TEFLON','','','',0,NULL,0,'174',NULL,1),(75,'FLETE',1,'FLETE','','','',1,NULL,0,'175',NULL,1),(76,'NIPLE',1,'NIPLE','','','',0,NULL,0,'176',NULL,1),(77,'CLAVO ACERO',1,'CLAVAC','','','',0,NULL,0,'177',NULL,1),(78,'CINTA EMPAQUE',1,'CINTA EMP.','','','',0,NULL,0,'178',NULL,1),(79,'TUBO SAL PLASTICA',1,'TB SAL PLAS','','','',0,NULL,0,'179',NULL,1),(80,'TUBO SAL NICOL',1,'TB SAL NIC','','','',0,NULL,0,'180',NULL,1),(81,'TUBO AG PLASTICA',1,'TB AG PLAS','','','',0,NULL,0,'181',NULL,1),(82,'TUBO AG NICOL',1,'TB AG NIC','','','',0,NULL,0,'182',NULL,1),(83,'TUBO SEL PLASTICA',1,'TB SEL PLAS','','','',0,NULL,0,'183',NULL,1),(84,'CODO SAL PLASTICA',1,'COD SAL PLAS','','','',0,NULL,0,'184',NULL,1),(85,'CODO SAL NICOL',1,'COD SAL NIC','','','',0,NULL,0,'185',NULL,1),(86,'CODO AG PLASTICA',1,'COD AG PLAS','','','',0,NULL,0,'186',NULL,1),(87,'CODO AG NICOL',1,'COD AG NIC','','','',0,NULL,0,'187',NULL,1),(88,'TEE SAL PLASTICA',1,'T SAL PLAS','','','',0,NULL,0,'188',NULL,1),(89,'TEE SAL NICOL',1,'T SAL NIC','','','',0,NULL,0,'189',NULL,1),(90,'TEE AG PLASTICA',1,'T AG PLAS','','','',0,NULL,0,'190',NULL,1),(91,'TEE AG NICOL',1,'T AG NIC','','','',0,NULL,0,'191',NULL,1),(92,'TUBO ALCANTARILLADO',1,'TB ALCAN PLAS','','','',0,NULL,0,'192',NULL,1),(93,'TUBO CPVC',1,'TB CPVC','','','',0,NULL,0,'193',NULL,1),(94,'CODO SEL PLASTICA',1,'COD SEL PLAS','','','',0,NULL,0,'194',NULL,1),(96,'CODO BRONCE',1,'COD BRON','','','',0,NULL,0,'196',NULL,1),(97,'CODO ALCANTARILLADO',1,'COD ALCAN','','','',0,NULL,0,'197',NULL,1),(98,'CODO CPVC',1,'COD CPVC','','','',0,NULL,0,'198',NULL,1),(99,'TEE ALCANTARILLADO',1,'T ALCAN','','','',0,NULL,0,'199',NULL,1),(100,'TEE CPVC',1,'T CPVC','','','',0,NULL,0,'200',NULL,1),(101,'CODO GALVANIZADO',1,'COD GALV','','','',0,NULL,0,'201',NULL,1),(102,'ESCOBA',1,'ESCOB','','','',0,NULL,0,'202',NULL,1),(103,'BUSHING',1,'BUSH','','','',0,NULL,0,'203',NULL,1),(104,'CUTTER',1,'CUT','','','',0,NULL,0,'204',NULL,1),(105,'TANQUE ETERNIT',1,'TANQ ET','','','',0,'',0,'205',NULL,1),(106,'TAPA CAJA AGUA',1,'TAPA','','','',0,NULL,0,'206',NULL,1),(107,'DISCO',1,'DISCO','','','',0,NULL,0,'207',NULL,1),(108,'YEE SAL NICOL',1,'YNIC','','','',0,NULL,0,'208',NULL,1),(109,'PEGAMENTO NICOL',1,'PEGNIC','','','',0,NULL,0,'209',NULL,1),(110,'REDUCCION SAL NICOL',1,'REDNIC','','','',0,NULL,0,'210',NULL,1),(111,'TEE SANITARIA NICOL',1,'TSANNIC','','','',0,NULL,0,'211',NULL,1),(112,'TAPON AG NICOL',1,'TAPNIC','','','',0,NULL,0,'212',NULL,1),(113,'CAJA SEL NICOL',1,'CAJNIC','','','',0,NULL,0,'213',NULL,1),(114,'CAJA CONCRETO',1,'CAJCON','','','',0,NULL,0,'214',NULL,1),(115,'TUBO SEL NICOL',1,'TBSELNIC','','','',0,NULL,0,'215',NULL,1),(116,'UNION AG NICOL',1,'UNINIC','','','',0,NULL,0,'216',NULL,1),(117,'CURVA SEL NICOL',1,'CURNIC','','','',0,NULL,0,'217',NULL,1),(118,'UNION SAL NICOL',1,'UNINIC','','','',0,NULL,0,'218',NULL,1),(119,'TAPON REJILLA',1,'TAPREJ','','','',0,NULL,0,'219',NULL,1),(120,'TANQUE NICOL',1,'TAN NIC','','','',0,NULL,0,'220',NULL,1),(121,'REDUCCION SAL NICOL 2',1,'REDNIC','','','',0,NULL,0,'221',NULL,1),(122,'TAPA CONCRETO',1,'TP CONCRETO','','','',0,NULL,0,'222',NULL,1),(123,'CUERPO CONCRETO',1,'CPO CTO','','','',0,NULL,0,'223',NULL,1),(124,'BASE CONCRETO',1,'BAS CTO','','','',0,NULL,0,'224',NULL,1),(125,'ADAPTADOR NICOL',1,'ADAP NIC','','','',0,NULL,0,'225',NULL,1),(126,'AGUA',1,'AGUA','','','',0,NULL,0,'226',NULL,1),(127,'GALLINAZA',1,'GALL','','','',0,NULL,0,'227',NULL,1),(128,'BONIFICACION',1,'BONI','','','',0,NULL,0,'228',NULL,1),(129,'ALAMBRON',1,'ALAM','','','',0,NULL,0,'229',NULL,1),(130,'MARTILLO',1,'MARTILLO','','','',0,NULL,0,'230',NULL,1),(131,'MANGO',1,'MANGO','','','',0,NULL,0,'231',NULL,1),(132,'RASTRILLO',1,'RAST','','','',0,NULL,0,'232',NULL,1),(133,'MARCO',1,'MARCO','','','',0,NULL,0,'233',NULL,1),(134,'ARCO DE SIERRA',1,'ARCO','','','',0,NULL,0,'234',NULL,1),(135,'CAMARA',1,'CAMARA','','','',0,NULL,0,'235',NULL,1),(136,'ALICATE',1,'ALI','','','',0,'',0,'236',NULL,1),(137,'PLASTICO',1,'PLASTICO','','','',0,NULL,0,'237',NULL,1),(138,'ALAMBRE SOLIDO',1,'ALAM SOL','','','',0,NULL,0,'238',NULL,1),(139,'CORDON MELLIZO',1,'CORDON','','','',0,NULL,0,'239',NULL,1),(140,'INTERRUPTOR',1,'INTERR','','','',0,NULL,0,'240',NULL,1),(142,'TOMACORRIENTE',1,'TOMACO','','','',0,NULL,0,'242',NULL,1),(143,'SOCATE',1,'SOCAT','','','',0,NULL,0,'243',NULL,1),(144,'FOCO AHORRADOR',1,'FOCO','','','',0,NULL,0,'244',NULL,1),(145,'CANALETA',1,'CANALETA','','','',0,NULL,0,'245',NULL,1),(146,'LLAVE DUCHA',1,'LLAVDUCHA','','','',0,NULL,0,'246',NULL,1),(147,'PINTURA LATEX',1,'PINT LATEX','','','',0,NULL,0,'247',NULL,1),(148,'IMPRIMANTE',1,'IMPRI','','','',0,NULL,0,'248',NULL,1),(149,'PINTURA BOLSA',1,'PINT BLS','','','',0,NULL,0,'249',NULL,1),(150,'PISTOLA  PINTAR',1,'PISTOLA','','','',0,NULL,0,'250',NULL,1),(151,'PLANCHA EMPASTAR',1,'EMPASTAR','','','',0,NULL,0,'251',NULL,1),(152,'BADILEJO',1,'BADILEJO','','','',0,'',0,'252',NULL,1),(153,'PALANA CAJUELERA',1,'CAJUELERA','','','',0,NULL,0,'253',NULL,1),(154,'INFLADOR',1,'INFLADOR','','','',0,NULL,0,'254',NULL,1),(155,'RODILLO',1,'RODILLO','','','',0,NULL,0,'255',NULL,1),(156,'BROCHA',1,'BROCHA','','','',0,'',0,'256',NULL,1),(157,'PELA CABLES',1,'PELA CABLES','','','',0,NULL,0,'257',NULL,1),(158,'REGADERA',1,'REGADERA','','','',0,NULL,0,'258',NULL,1),(159,'DUCHA',1,'DUCHA','','','',0,NULL,0,'259',NULL,1),(160,'CURVA AGUA',1,'CURVA AG','','','',0,NULL,0,'260',NULL,1),(161,'CANASTILLA',1,'CANASTILLA','','','',0,NULL,0,'261',NULL,1),(162,'YEE AGUA',1,'YAG','','','',0,NULL,0,'262',NULL,1),(163,'CAJA P/CUCHILLA',1,'CAJ/CUCH','','','',0,NULL,0,'263',NULL,1),(164,'CONO',1,'CONO','','','',0,'',0,'264',NULL,1),(165,'GATA',1,'GAT','','','',0,NULL,0,'265',NULL,1),(166,'TIRALINEAS',1,'TLINEAS','','','',0,NULL,0,'266',NULL,1),(167,'ESCALERAS',1,'ESC','','','',0,NULL,0,'267',NULL,1),(168,'TIJERAS',1,'TIJERAS','','','',0,NULL,0,'268',NULL,1),(169,'ESPATULAS',1,'ESP','','','',0,NULL,0,'269',NULL,1),(170,'ENCHUFE',1,'ENCH','','','',0,NULL,0,'270',NULL,1),(171,'TUBO SAL FORDUIT',1,'TBFOR','','','',0,NULL,0,'271',NULL,1),(172,'UNION UNIVERSAL',1,'UNU','','','',0,NULL,0,'272',NULL,1),(173,'VALVULA CHECK',1,'VCHECK','','','',0,NULL,0,'273',NULL,1),(174,'CAJA SEL OROPLAST',1,'CAJE','','','',0,NULL,0,'274',NULL,1),(175,'MANGUERA DUPLEX',1,'MANG DUPLEX','','','',0,NULL,0,'275',NULL,1),(176,'MANGUERA POLITILENO',1,'MANG. POL','','','',0,NULL,0,'276',NULL,1),(177,'MANGUERA PESADA',1,'MANG. PES','','','',0,NULL,0,'277',NULL,1),(178,'MANGUERA INDUSTRIAL',1,'MANG. IND','','','',0,NULL,0,'278',NULL,1),(179,'MALLA RASCHEL',1,'MALL RAS','','','',0,NULL,0,'279',NULL,1),(180,'MANTA ARPILLERA',1,'MAN ARP','','','',0,NULL,0,'280',NULL,1),(181,'MALLA OLIMPICA',1,'MALL OL','','','',0,NULL,0,'281',NULL,1),(182,'LIJA DE AGUA',1,'LIJAG','','','',0,NULL,0,'282',NULL,1),(183,'LIJA DE MADERA',1,'LIAGM','','','',0,NULL,0,'283',NULL,1),(184,'LIJA BLUE ',1,'LBLUE','','','',0,NULL,0,'284',NULL,1),(185,'LIJA DE FIERRO ',1,'LIJAF','','','',0,NULL,0,'285',NULL,1),(186,'DISCO METAL',1,'DCO MET','','','',0,NULL,0,'286',NULL,1),(187,'DISCO CONCRETO',1,'DCO DIAM','','','',0,NULL,0,'287',NULL,1),(188,'DISCO TRONZADORA',1,'DCO TRON','','','',0,NULL,0,'288',NULL,1),(189,'TELA ESMERIL',1,'TEL ESM','','','',0,NULL,0,'289',NULL,1),(190,'CHAPA',1,'CHAP','','','',0,NULL,0,'290',NULL,1),(191,'RUEDA ESMERIL',1,'RUE ESM','','','',0,NULL,0,'291',NULL,1),(192,'CANDADO ',1,'CAND','','','',0,NULL,0,'292',NULL,1),(193,'BIODIGESTOR',1,'BIOD','','','',0,NULL,0,'293',NULL,1),(194,'BOTA JEBE',1,'BOT','','','',0,NULL,0,'294',NULL,1),(195,'TUBO AG FORDUIT',1,'TB AG F','','','',0,NULL,0,'295',NULL,1),(196,'DESARMADOR',1,'DESAR','','','',0,NULL,0,'296',NULL,1),(197,'CAPOTIN',1,'CAP','','','',0,NULL,0,'297',NULL,1),(198,'PONCHO DE AGUA',1,'PONC','','','',0,NULL,0,'298',NULL,1),(199,'AFIRMADO ',1,'','','','',0,NULL,0,'299',NULL,1),(200,'MOPAS DE LANA ',1,'MOPAS','','','',0,NULL,0,'300',NULL,1),(201,'CARTA FIANZA',1,'CARTFIAN','','','',1,NULL,0,'301',NULL,1),(202,'UNION CORREDIZA',1,'UNION CORR','','','',0,NULL,0,'302',NULL,1),(203,'SALIDA PARA CABLE',1,'SCA','','','',0,NULL,0,'303',NULL,1),(204,'INTERRUPTOR MIXTO ',1,'INTMIXTO','','','',0,NULL,0,'304',NULL,1),(205,'ADAPTADOR UNIVERSAL',1,'ADAPUN','','','',0,NULL,0,'305',NULL,1),(206,'FLUORESCENTE',1,'FLUO','','','',0,NULL,0,'306',NULL,1),(207,'CUCHILLA TERMOMAGNETICA',1,'CUCHTER','','','',0,'',0,'307',NULL,1),(208,'EXTENSION',1,'EX','','','',0,NULL,0,'308',NULL,1),(209,'GUANTE JEBE',1,'GUAN JEB','','','',0,NULL,0,'309',NULL,1),(210,'MASCARILLA',1,'MAS','','','',0,NULL,0,'310',NULL,1),(211,'TEE GALVANIZADA',1,'TGAL','','','',0,NULL,0,'311',NULL,1),(212,'CINCEL',1,'CINCEL','','','',0,NULL,0,'312',NULL,1),(213,'CLAVO COMFER',1,'CLAVO COM','','','',0,NULL,0,'313',NULL,1),(214,'SOLDADURA',1,'SOLD','','','',0,NULL,0,'314',NULL,1),(215,'ALAMBRE COMFER',1,'ALAMCOM','','','',0,NULL,0,'315',NULL,1),(216,'RECOGEDOR',1,'RECOGEDOR','','','',0,NULL,0,'316',NULL,1),(217,'LLAVE CAJA DE AGUA',1,'LLVE AG','','','',0,NULL,0,'317',NULL,1),(218,'GRUÑA',1,'GRUÑA','','','',0,NULL,0,'318',NULL,1),(219,'FOCO LED',1,'FLED','','','',0,NULL,0,'319',NULL,1),(220,'TIERRA',1,'TIERRA','','','',0,NULL,0,'320',NULL,1),(221,'DISCO MADERA',1,'DISCMAD','','','',0,NULL,0,'321',NULL,1),(222,'EXTENSION TELESCOPICA',1,'EXT','','','',0,NULL,0,'322',NULL,1),(223,'BISAGRA',1,'BISA','','','',0,'',0,'323',NULL,1),(224,'CALAMINA TRAPEZOIDAL',1,'CAL TRAP','','','',0,'',0,'324',NULL,1),(225,'STRECHS FILL',1,'STRECHS','','','',0,NULL,0,'325',NULL,1),(226,'NIVEL',1,'NIVEL','','','',0,NULL,0,'326',NULL,1),(227,'TRAPO INDUSTRIAL',1,'TRAP IN','','','',0,NULL,0,'327',NULL,1),(228,'ASFALTO',1,'ASFALTO','','','',0,NULL,0,'328',NULL,1),(229,'ALUZINC',1,'ALUZINC','','','',0,NULL,0,'329',NULL,1),(230,'BARBIQUEJO',1,'BARBIQUEJO','','','',0,NULL,0,'330',NULL,1),(231,'ZAPATO',1,'ZAPATO','','','',0,NULL,0,'331',NULL,1),(232,'PANTALON',1,'PANTALON','','','',0,NULL,0,'332',NULL,1),(234,'POLO',1,'POLO','','','',0,NULL,0,'334',NULL,1),(235,'REDUCCION AG NICOLL',1,'REDAGN','','','',0,NULL,0,'335',NULL,1),(236,'ACIDO DOMESTICO',1,'ACIDO','','','',0,NULL,0,'336',NULL,1),(237,'TORTOL',1,'TORTOL','','','',0,NULL,0,'337',NULL,1),(238,'SOMBRERO DE VENTILACION',1,'SOM VEN','','','',0,NULL,0,'338',NULL,1),(239,'REEMBOLSO',1,'REEMBOLSO','','','',1,NULL,0,'339',NULL,1),(240,'CERRADURAS CANTOL',1,'CERRCAN','','','',0,NULL,0,'340',NULL,1),(241,'PERILLA',1,'PERILLAS','','','',0,'',0,'341',NULL,1),(242,'THINNER',1,'THINNER','','','',0,NULL,0,'342',NULL,1),(243,'MALLA MOSQUITERO',1,'MALL MOS','','','',0,NULL,0,'343',NULL,1),(244,'CIZALLA',1,'CIZALLA','','','',0,'',0,'344',NULL,1),(245,'ZAQUETA',1,'ZAQ','','','',0,NULL,0,'345',NULL,1),(246,'CABLE ACERO',1,'CAB ACERO','','','',0,NULL,0,'346',NULL,1),(247,'TEMPLADORES',1,'TEMPLADORES','','','',0,NULL,0,'347',NULL,1),(248,'GRAPA',1,'GRAPA','','','',0,NULL,0,'348',NULL,1),(249,'ADOQUIN',1,'ADOQUIN','','','',0,NULL,0,'349',NULL,1),(250,'LINTERNA',1,'LINTERNA','','','',0,NULL,0,'350',NULL,1),(251,'CABLE ELECTRICO',1,'CABLE','','','',0,NULL,0,'351',NULL,1),(252,'MACHETE',1,'MACHETE','','','',0,NULL,0,'352',NULL,1),(253,'PEGAMENTO CERAMICA',1,'PEGCER','','','',0,NULL,0,'353',NULL,1),(254,'BATEA MEZCLAR',1,'BATEA','','','',0,NULL,0,'354',NULL,1),(255,'HILO ALBAÑIL',1,'HALBAÑIL','','','',0,NULL,0,'355',NULL,1),(256,'YEE ALCANTARILLADO',1,'YEE AL','','','',0,NULL,0,'356',NULL,1),(257,'PINTURA SATINADA',1,'PINT SAT','','','',0,NULL,0,'357',NULL,1),(258,'SELLADOR',1,'SELL','','','',0,NULL,0,'358',NULL,1),(259,'PASTA FINA',1,'PASTA','','','',0,NULL,0,'359',NULL,1),(260,'TECNOKOLA',1,'KOLA','','','',0,NULL,0,'360',NULL,1),(261,'LACA SELLADORA',1,'LACA SELL','','','',0,NULL,0,'361',NULL,1),(262,'FRAGUADORA',1,'FRAGUA','','','',0,NULL,0,'362',NULL,1),(263,'RAFIA',1,'RAFIA','','','',0,NULL,0,'363',NULL,1),(264,'PINTURA SPRAY',1,'PINSPRAY','','','',0,NULL,0,'364',NULL,1),(265,'SIFAN',1,'SIFAN','','','',0,NULL,0,'365',NULL,1),(266,'MASILLA',1,'MASILLA','','','',0,NULL,0,'366',NULL,1),(267,'LIMPIA VIDRIO',1,'LIMV','','','',0,NULL,0,'367',NULL,1),(268,'AMBIENTADOR',1,'AMBIENTADOR','','','',0,NULL,0,'368',NULL,1),(269,'LIMPIA TODO',1,'LIMPT','','','',0,NULL,0,'369',NULL,1),(270,'DRIZA',1,'DRIZA','','','',0,NULL,0,'370',NULL,1),(271,'CORDEL',1,'CORDEL','','','',0,NULL,0,'371',NULL,1),(272,'REGLA ALUMINIO',1,'REGLA','','','',0,NULL,0,'372',NULL,1),(273,'TUBO MULTIFUNCION',1,'TB MULTI','','','',0,NULL,0,'373',NULL,1),(274,'LINTERNA EMERGENCIA',1,'LEMERG','','','',0,NULL,0,'374',NULL,1),(275,'SUPRESOR DE PICOS',1,'SUPRE','','','',0,NULL,0,'375',NULL,1),(276,'FROTACHO',1,'FROTACHO','','','',0,NULL,0,'376',NULL,1),(277,'CINTA MASKING',1,'CTA MAS','','','',0,NULL,0,'377',NULL,1),(278,'SIKAFLEX',1,'SIKAFLEX','','','',0,NULL,0,'378',NULL,1),(279,'SOUDAFLEX',1,'SOUDAFLEX','','','',0,NULL,0,'379',NULL,1),(280,'CAJA DE PASE',1,'CAJPAS','','','',0,NULL,0,'380',NULL,1),(281,'UNION GALVANIZADA',1,'UNGAL','','','',0,NULL,0,'381',NULL,1),(282,'AFRICANO',1,'AFRICANO','','','',0,NULL,0,'382',NULL,1),(283,'TAPA CIEGA',1,'TAPA CIEGA','','','',0,NULL,0,'383',NULL,1),(284,'DISCO FLAP',1,'DISCO FLA','','','',0,NULL,0,'384',NULL,1),(285,'DESINFECTANTES',1,'DESINF','','','',0,NULL,0,'385',NULL,1),(286,'SIKADUR',1,'SIKADUR','','','',0,NULL,0,'386',NULL,1),(287,'AUTOPERPORANTE',1,'AUTOPERFORANTE','','','',0,'',0,'387',NULL,1),(288,'STOVE BOLTS',1,'STOVE','','','',0,NULL,0,'388',NULL,1),(289,'TARUGO',1,'TARUGO','','','',0,NULL,0,'389',NULL,1),(291,'DESESTIBA',1,'DESESTIBA','','','',1,NULL,0,'391',NULL,1),(292,'PALO DE ESCOBA',1,'PALO ESCOBA','','','',0,NULL,0,'392',NULL,1),(293,'TRAPO YUTE',1,'TRAPYU','','','',0,NULL,0,'393',NULL,1),(294,'LLAVE LAVATORIO',1,'LLAVELA','','','',0,NULL,0,'394',NULL,1),(295,'TRIZ',1,'TRIZ','','','',0,NULL,0,'395',NULL,1),(296,'SIKA FILL',1,'SIKA FILL','','','',0,NULL,0,'396',NULL,1),(297,'SIKA ANTISOL',1,'SIKA ANT','','','',0,NULL,0,'397',NULL,1),(298,'SIKA PEGA ENCHAPE',1,'SIK ENCH','','','',0,NULL,0,'398',NULL,1),(299,'SIKAMENT',1,'SIKAMENT','','','',0,NULL,0,'399',NULL,1),(300,'SEÑALIZACION',1,'SEÑAL','','','',0,NULL,0,'400',NULL,1),(301,'EXTINTOR',1,'EXTINTOR','','','',0,NULL,0,'401',NULL,1),(302,'BOTIQUIN',1,'BOTIQUIN','','','',0,NULL,0,'402',NULL,1),(303,'CORTAVIENTO',1,'CORTAV','','','',0,NULL,0,'403',NULL,1),(304,'AMOLADORA',1,'AMOL','','','',0,NULL,0,'404',NULL,1),(305,'PALETA DE SEGURIDAD',1,'PALETASEG','','','',0,NULL,0,'405',NULL,1),(306,'DISCO PULIR',1,'DISCO PULIR','','','',0,NULL,0,'406',NULL,1),(307,'ESCUADRA',1,'ESCUADRA','','','',0,NULL,0,'407',NULL,1),(308,'BROCA CONCRETO',1,'BROCACON','','','',0,NULL,0,'408',NULL,1),(309,'SINOLIT',1,'SIN','','','',0,NULL,0,'409',NULL,1),(310,'CABLE VULCANIZADO',1,'CAB V','','','',0,NULL,0,'410',NULL,1),(311,'ALCOHOL',1,'ALCOHOL','','','',0,NULL,0,'411',NULL,1),(312,'TEMPLE FINO',1,'TEMPLE','','','',0,NULL,0,'412',NULL,1),(313,'LADRILLO KIN KON 18 HUECOS',1,'LAD 18 HUECOS','','','',0,NULL,0,'413',NULL,1),(314,'LADRILLO PANDERETA',1,'LAD PAN','','','',0,NULL,0,'414',NULL,1),(315,'LADRILLO SUPER KIN KON',1,'LAD SUPER K','','','',0,NULL,0,'415',NULL,1),(316,'LADRILLO ARTESANAL',1,'LAD ART','','','',0,NULL,0,'416',NULL,1),(317,'LADRILLO PASTELERO',1,'LAD PAST','','','',0,NULL,0,'417',NULL,1),(318,'CALAMINA SIDERPERU',1,'CAL SIDER','','','',0,NULL,0,'418',NULL,1),(319,'CALAMINA ACEROS AREQ',1,'CAL ACEROS','','','',0,NULL,0,'419',NULL,1),(320,'ENLACE UNION',1,'ENL UN','','','',0,NULL,0,'420',NULL,1),(321,'RESPIRADOR',1,'RESP','','','',0,NULL,0,'421',NULL,1),(322,'PLANCHA BATIR',1,'BATIR','','','',0,NULL,0,'422',NULL,1),(323,'ANILLO DE CERA',1,'ANILLCERA','','','',0,'',0,'423',NULL,1),(324,'PLOMADA',1,'PLOMADA','','','',0,NULL,0,'424',NULL,1),(325,'POMO FORTE',1,'POMO','','','',0,NULL,0,'425',NULL,1),(326,'CERRADURAS FORTE',1,'CERRFOR','','','',0,NULL,0,'426',NULL,1),(327,'CANDADO FORTE',1,'CANDFOR','','','',0,'',0,'427',NULL,1),(328,'TORNILLO SPAX',1,'TORSPAX','','','',0,NULL,0,'428',NULL,1),(329,'ALDABA',1,'ALDABA','','','',0,'',0,'429',NULL,1),(331,'PICAPORTE',1,'PICAPORTE','','','',0,NULL,0,'431',NULL,1),(332,'ESCOBILLA FIERRO',1,'ESCOBF','','','',0,NULL,0,'432',NULL,1),(333,'PERNO COCHE',1,'PERCOCHE','','','',0,NULL,0,'433',NULL,1),(334,'FOCO EMERGENCIA',1,'FOCEM','','','',0,NULL,0,'434',NULL,1),(335,'ABRAZADERA',1,'ABRAZADERA','','','',0,'',0,'435',NULL,1),(336,'PROTECTOR FACIAL',1,'PROTECF','','','',0,NULL,0,'436',NULL,1),(337,'BARNIZ',1,'BAR','','','',0,'',0,'437',NULL,1),(338,'LACA PIROXILINA',1,'LACPI','','','',0,NULL,0,'438',NULL,1),(339,'TINTE',1,'TIN','','','',0,NULL,0,'439',NULL,1),(340,'LAVATORIO COCINA',1,'LAVCOC','','','',0,NULL,0,'440',NULL,1),(341,'ESMALTE  PINTOR',1,'ESMPINT','','','',0,NULL,0,'441',NULL,1),(342,'ZENACRYL',1,'ZEN','','','',0,NULL,0,'442',NULL,1),(343,'ANTICORROSIVO',1,'ANT','','','',0,'',0,'443',NULL,1),(344,'HOZ',1,'HOZ','','','',0,NULL,0,'444',NULL,1),(345,'APLICADOR DE SILICONA',1,'APLICA','','','',0,NULL,0,'445',NULL,1),(346,'PLOMO TOPOGRAFO',1,'TOPOGRAFO','','','',0,NULL,0,'446',NULL,1),(347,'ESQUINERO PVC',1,'ESQUINERO','','','',0,NULL,0,'447',NULL,1),(348,'BROCA FIERRO',1,'BROCAF','','','',0,NULL,0,'448',NULL,1),(349,'SILICONA',1,'SILICONA','','','',0,NULL,0,'449',NULL,1),(350,'CALAMINA PRODAC',1,'CALPRO','','','',0,NULL,0,'450',NULL,1),(352,'BANDEJA PARA DESINFECCION',1,'BAND','','','',0,NULL,0,'452',NULL,1),(353,'MEZCLADORA DUCHA',1,'MEZCLAD','','','',0,NULL,0,'453',NULL,1),(354,'PALETA PLASTICA',1,'PALETAPLA','','','',0,NULL,0,'454',NULL,1),(355,'CADENA GALVANIZADA',1,'CADENAGAL','','','',0,NULL,0,'455',NULL,1),(356,'TORNILLO BARCO',1,'TORBARCO','','','',0,NULL,0,'456',NULL,1),(357,'ALCAYATA ',1,'ALCAYATA','','','',0,NULL,0,'457',NULL,1),(358,'ELECTROBOMBA',1,'ELECTRO','','','',0,NULL,0,'458',NULL,1),(359,'HACHA',1,'','','','',0,NULL,0,'459',NULL,1),(360,'AGUARRAZ',1,'AGUARRAZ','','','',0,NULL,0,'460',NULL,1),(361,'TANQUE ROTOPLAST',1,'TANROT','','','',0,NULL,0,'461',NULL,1),(362,'LLAVE MIXTA',1,'','','','',0,NULL,0,'462',NULL,1),(363,'PALETA MADERA',1,'','','','',0,NULL,0,'463',NULL,1),(364,'SIKACEM',1,'SIKACEM','','','',0,NULL,0,'464',NULL,1),(365,'SIKARAPID',1,'SIKARAPID','','','',0,NULL,0,'465',NULL,1),(366,'LAMPARA',1,'LAMPARA','','','',0,NULL,0,'466',NULL,1),(367,'FOCO DICROICO',1,'FOCODIC','','','',0,NULL,0,'467',NULL,1),(368,'ESMALTE PATO',1,'ESMPAT','','','',0,NULL,0,'468',NULL,1),(369,'WINCHA PASACABLE',1,'PASACABLE','','','',0,NULL,0,'469',NULL,1),(370,'TABLA LIJADORA',1,'TABLIJ','','','',0,NULL,0,'470',NULL,1),(371,'CONCRETO PREMEZCLADO',1,'','','','',0,NULL,0,'471','16086644388802151870',1),(372,'CONCRETO',1,'','','','',0,NULL,0,'472','16086644904123271579',1),(373,'SET LIMPIEZA',1,'','','','',0,'',0,'473','16123022305111730153',1),(374,'GUANTE LATEX',1,'','','','',0,NULL,0,'474','16123715773242305075',1),(375,'ALAMBRE ACEROS',1,'','','','',0,'',0,'475','16124733859023496758',1),(376,'MALLA SEGURIDAD',1,'','','','',0,NULL,0,'476','16128832982321241731',1),(377,'WAYPE',1,'','','','',0,NULL,0,'477','16129052964934136863',1),(378,'TUBO AG TUPLAST',1,'','','','',0,'',0,'478','16137681449640492303',1),(379,'TUBO SEL TUPLAST',1,'','','','',0,NULL,0,'479','1613769424799143503',1),(380,'JALADOR',1,'','','','',0,NULL,0,'480','16148079149732372591',1),(382,'REPUESTO',1,'','','','',0,NULL,0,'482','16148106619270302696',1),(383,'CEPILLO HISOPO',1,'','','','',0,NULL,0,'483','16154919519904684318',1),(384,'ESTRIBO COLUMNA',1,'','','','',0,NULL,0,'484','16154920235262484300',1),(385,'GEL CONDUCTIVO',1,'','','','',0,NULL,0,'485','1615822005212887460',1),(386,'CAJA REGISTROPUESTA TIERRA',1,'','','','',0,NULL,0,'486','16158221551922435967',1),(387,'VARILLA  COBRE',1,'','','','',0,NULL,0,'487','16158377321223629848',1),(388,'CONECTOR',1,'','','','',0,NULL,0,'488','16158380636605657654',1),(389,'BENTONITA',1,'','','','',0,NULL,0,'489','16158382895308341162',1),(390,'BALANZA',1,'','','','',0,NULL,0,'490','16165939348112779219',1),(391,'GANCHO ',1,'','','','',0,'',0,'491','16165942503335012971',1),(392,'ALCANTARILLA',1,'','','','',0,'',0,'492','16166040169483191415',1),(393,'CONCENTRICO',1,'','','','',0,NULL,0,'493','16167785732579831528',1),(394,'YEE SAL PAVCO',1,'','','','',0,NULL,0,'494','16173007114730804978',1),(395,'TIZA',1,'','','','',0,NULL,0,'495','16195635084295993365',1),(396,'BOLEADOR',1,'','','','',0,NULL,0,'496','16204221104983806489',1),(397,'ASIENTO DE BAÑO',1,'','','','',0,NULL,0,'497','16209331799634793758',1),(398,'ESTANQUE',1,'','','','',0,NULL,0,'498','1620934184675159136',1),(399,'LAVATORIO',1,'','','','',0,NULL,0,'499','16209346325108767117',1),(400,'PEDESTAL ',1,'','','','',0,NULL,0,'500','16209349191704884717',1),(401,'PERNO DE ANCLAJE',1,'','','','',0,NULL,0,'501','16209351138392986558',1),(402,'TAZA',1,'','','','',0,NULL,0,'502','16209353719059243237',1),(403,'TIRAFON',1,'','','','',0,NULL,0,'503','16212900535086689615',1),(404,'POLICARBONATO',1,'','','','',0,NULL,0,'504','16214440223179936800',1);
/*!40000 ALTER TABLE `productos_familia` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `promociones`
--

DROP TABLE IF EXISTS `promociones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `promociones` (
  `prom_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `prom_nombre` varchar(100) NOT NULL DEFAULT '',
  `prom_estado` int(10) unsigned NOT NULL DEFAULT 0,
  `prom_abreviatura` varchar(45) DEFAULT NULL,
  `prom_usu_crea` varchar(45) DEFAULT NULL,
  `prom_usu_modifica` varchar(45) DEFAULT NULL,
  `prom_usu_activa` varchar(45) DEFAULT NULL,
  `prom_activado` int(10) unsigned NOT NULL DEFAULT 0,
  `prom_fecha_inicio` date DEFAULT NULL,
  `prom_fecha_fin` date DEFAULT NULL,
  PRIMARY KEY (`prom_codi`),
  UNIQUE KEY `Index_prom_nombre` (`prom_nombre`),
  KEY `Index_prom_estado` (`prom_estado`),
  KEY `Index_prom_abreviatura` (`prom_abreviatura`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `promociones`
--

LOCK TABLES `promociones` WRITE;
/*!40000 ALTER TABLE `promociones` DISABLE KEYS */;
/*!40000 ALTER TABLE `promociones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `promociones_detalle`
--

DROP TABLE IF EXISTS `promociones_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `promociones_detalle` (
  `promdet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `promdet_precio` float NOT NULL DEFAULT 0,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `prd_codi_fk` int(11) NOT NULL DEFAULT 0,
  `prctip_codi_fk` int(11) DEFAULT NULL,
  `promdet_estado` int(10) unsigned NOT NULL DEFAULT 0,
  `promdet_defecto` int(10) unsigned NOT NULL DEFAULT 0,
  `promdet_usu_crea` varchar(45) DEFAULT NULL,
  `promdet_usu_modifica` varchar(45) DEFAULT NULL,
  `promdet_usu_activa` varchar(45) DEFAULT NULL,
  `promdet_costo` float NOT NULL DEFAULT 0,
  `promdet_equivalente` int(10) unsigned NOT NULL DEFAULT 1,
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `prom_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `promdet_cantidad` float NOT NULL DEFAULT 0,
  `promdet_precio_promocion` float NOT NULL DEFAULT 0,
  PRIMARY KEY (`promdet_codi`),
  KEY `fk_promociones_productos1_idx` (`prd_codi_fk`),
  KEY `fk_promociones_unidades_medida1_idx` (`unimed_codi_fk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `promociones_detalle`
--

LOCK TABLES `promociones_detalle` WRITE;
/*!40000 ALTER TABLE `promociones_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `promociones_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `requerimientos`
--

DROP TABLE IF EXISTS `requerimientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `requerimientos` (
  `req_codi` int(11) NOT NULL AUTO_INCREMENT,
  `req_fecha` date DEFAULT NULL,
  `req_numero` varchar(45) DEFAULT NULL,
  `per_codi_fk` int(11) DEFAULT NULL,
  `req_estado` int(11) NOT NULL DEFAULT 1,
  `req_fechahora` datetime DEFAULT NULL,
  `req_anotaciones` text DEFAULT NULL,
  `req_usu_crea` varchar(45) NOT NULL DEFAULT '',
  `req_usu_modifica` varchar(45) NOT NULL DEFAULT '',
  `req_usu_activa` varchar(45) NOT NULL DEFAULT '',
  `idtrans` varchar(45) DEFAULT NULL,
  `req_situacion` int(10) unsigned NOT NULL DEFAULT 0,
  `req_igv_porcentaje` float NOT NULL DEFAULT 18,
  `req_dias` int(11) NOT NULL DEFAULT 5,
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `req_origen` int(10) unsigned NOT NULL DEFAULT 0,
  `req_otra_direccion` text DEFAULT NULL,
  `req_cadena_datos` text DEFAULT NULL,
  `req_autoriza_web` int(10) unsigned NOT NULL DEFAULT 0,
  `req_fecha_entrega` date DEFAULT NULL,
  PRIMARY KEY (`req_codi`),
  UNIQUE KEY `Index_req_numero` (`req_numero`),
  KEY `Index_per_codi_fk` (`per_codi_fk`),
  KEY `Index_req_estado` (`req_estado`),
  KEY `Index_idtrans` (`idtrans`),
  KEY `Index_req_situacion` (`req_situacion`),
  KEY `Index_emp_codi_fk` (`emp_codi_fk`),
  CONSTRAINT `FK_requerimientos_empresas` FOREIGN KEY (`emp_codi_fk`) REFERENCES `empresas` (`emp_codi`),
  CONSTRAINT `FK_requerimientos_personas` FOREIGN KEY (`per_codi_fk`) REFERENCES `personas` (`per_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `requerimientos`
--

LOCK TABLES `requerimientos` WRITE;
/*!40000 ALTER TABLE `requerimientos` DISABLE KEYS */;
/*!40000 ALTER TABLE `requerimientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `requerimientos_detalle`
--

DROP TABLE IF EXISTS `requerimientos_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `requerimientos_detalle` (
  `reqdet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `reqdet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `reqdet_precio` float NOT NULL DEFAULT 0,
  `reqdet_cantidad` float NOT NULL DEFAULT 0,
  `req_codi_fk` int(11) NOT NULL DEFAULT 0,
  `idtrans` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`reqdet_codi`),
  KEY `fk_requerimientos_detalle_1_idx` (`req_codi_fk`),
  KEY `fk_requerimientos_detalle_productos1_idx` (`prd_codi_fk`),
  KEY `fk_requerimientos_detalle_unidades_medida1_idx` (`unimed_codi_fk`),
  CONSTRAINT `fk_requerimientos_detalle_1` FOREIGN KEY (`req_codi_fk`) REFERENCES `requerimientos` (`req_codi`),
  CONSTRAINT `fk_requerimientos_detalle_productos1` FOREIGN KEY (`prd_codi_fk`) REFERENCES `productos` (`prd_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_requerimientos_detalle_unidades_medida1` FOREIGN KEY (`unimed_codi_fk`) REFERENCES `unidades_medida` (`unimed_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `requerimientos_detalle`
--

LOCK TABLES `requerimientos_detalle` WRITE;
/*!40000 ALTER TABLE `requerimientos_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `requerimientos_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `requerimientos_internos`
--

DROP TABLE IF EXISTS `requerimientos_internos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `requerimientos_internos` (
  `reqint_codi` int(11) NOT NULL AUTO_INCREMENT,
  `reqint_fecha` date DEFAULT NULL,
  `reqint_numero` varchar(45) DEFAULT NULL,
  `per_codi_fk` int(11) DEFAULT NULL,
  `reqint_estado` int(11) NOT NULL DEFAULT 1,
  `reqint_fechahora` datetime DEFAULT NULL,
  `reqint_anotaciones` text DEFAULT NULL,
  `reqint_usu_crea` varchar(45) NOT NULL DEFAULT '',
  `reqint_usu_modifica` varchar(45) NOT NULL DEFAULT '',
  `reqint_usu_activa` varchar(45) NOT NULL DEFAULT '',
  `idtrans` varchar(45) DEFAULT NULL,
  `reqint_situacion` int(10) unsigned NOT NULL DEFAULT 0,
  `reqint_igv_porcentaje` float NOT NULL DEFAULT 18,
  `reqint_dias` int(11) NOT NULL DEFAULT 5,
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `reqint_origen` int(10) unsigned NOT NULL DEFAULT 0,
  `reqint_otra_direccion` text DEFAULT NULL,
  `reqint_cadena_datos` text DEFAULT NULL,
  `reqint_autoriza_web` int(10) unsigned NOT NULL DEFAULT 0,
  `reqint_fecha_entrega` date DEFAULT NULL,
  `emp_codi_fk_proveedora` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`reqint_codi`),
  UNIQUE KEY `Index_reqint_numero` (`reqint_numero`),
  KEY `Index_per_codi_fk` (`per_codi_fk`),
  KEY `Index_reqint_estado` (`reqint_estado`),
  KEY `Index_idtrans` (`idtrans`),
  KEY `Index_reqint_situacion` (`reqint_situacion`),
  KEY `Index_emp_codi_fk` (`emp_codi_fk`),
  CONSTRAINT `FK_requerimientos_internos_empresas` FOREIGN KEY (`emp_codi_fk`) REFERENCES `empresas` (`emp_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `requerimientos_internos`
--

LOCK TABLES `requerimientos_internos` WRITE;
/*!40000 ALTER TABLE `requerimientos_internos` DISABLE KEYS */;
/*!40000 ALTER TABLE `requerimientos_internos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `requerimientos_internos_detalle`
--

DROP TABLE IF EXISTS `requerimientos_internos_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `requerimientos_internos_detalle` (
  `reqintdet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `reqintdet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `reqintdet_precio` float NOT NULL DEFAULT 0,
  `reqintdet_cantidad` float NOT NULL DEFAULT 0,
  `reqint_codi_fk` int(11) NOT NULL DEFAULT 0,
  `idtrans` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`reqintdet_codi`),
  KEY `fk_requerimientos_internos_detalle_1_idx` (`reqint_codi_fk`),
  KEY `fk_requerimientos_internos_detalle_productos1_idx` (`prd_codi_fk`),
  KEY `fk_requerimientos_internos_detalle_unidades_medida1_idx` (`unimed_codi_fk`),
  CONSTRAINT `fk_requerimientos_internos_detalle_1` FOREIGN KEY (`reqint_codi_fk`) REFERENCES `requerimientos_internos` (`reqint_codi`),
  CONSTRAINT `fk_requerimientos_internos_detalle_productos1` FOREIGN KEY (`prd_codi_fk`) REFERENCES `productos` (`prd_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_requerimientos_internos_detalle_unidades_medida1` FOREIGN KEY (`unimed_codi_fk`) REFERENCES `unidades_medida` (`unimed_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `requerimientos_internos_detalle`
--

LOCK TABLES `requerimientos_internos_detalle` WRITE;
/*!40000 ALTER TABLE `requerimientos_internos_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `requerimientos_internos_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `telefonos`
--

DROP TABLE IF EXISTS `telefonos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `telefonos` (
  `tel_codi` int(11) NOT NULL AUTO_INCREMENT,
  `tel_numero` varchar(45) DEFAULT NULL,
  `teltip_codi_fk` int(11) NOT NULL,
  `per_codi_fk` int(11) NOT NULL,
  `tel_estado` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`tel_codi`),
  KEY `fk_telefonos_telefonos_tipo1_idx` (`teltip_codi_fk`),
  KEY `fk_telefonos_personas1_idx` (`per_codi_fk`),
  CONSTRAINT `fk_telefonos_personas1` FOREIGN KEY (`per_codi_fk`) REFERENCES `personas` (`per_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_telefonos_telefonos_tipo1` FOREIGN KEY (`teltip_codi_fk`) REFERENCES `telefonos_tipo` (`teltip_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `telefonos`
--

LOCK TABLES `telefonos` WRITE;
/*!40000 ALTER TABLE `telefonos` DISABLE KEYS */;
/*!40000 ALTER TABLE `telefonos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `telefonos_tipo`
--

DROP TABLE IF EXISTS `telefonos_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `telefonos_tipo` (
  `teltip_codi` int(11) NOT NULL AUTO_INCREMENT,
  `teltip_nombre` varchar(80) DEFAULT NULL,
  `teltip_estado` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`teltip_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `telefonos_tipo`
--

LOCK TABLES `telefonos_tipo` WRITE;
/*!40000 ALTER TABLE `telefonos_tipo` DISABLE KEYS */;
INSERT INTO `telefonos_tipo` VALUES (1,'CASA',1),(2,'OFICINA',1),(3,'PERSONAL',1);
/*!40000 ALTER TABLE `telefonos_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `temporal_cotizacion_pedido_detalle`
--

DROP TABLE IF EXISTS `temporal_cotizacion_pedido_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `temporal_cotizacion_pedido_detalle` (
  `cotdet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `cotdet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `cotdet_precio` float NOT NULL DEFAULT 0,
  `cotdet_cantidad` float NOT NULL DEFAULT 0,
  `cot_codi_fk` int(11) NOT NULL DEFAULT 0,
  `idtrans` varchar(45) DEFAULT NULL,
  `cotdet_codi_fk` int(10) unsigned DEFAULT NULL,
  `idtrans_temporal` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`cotdet_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `temporal_cotizacion_pedido_detalle`
--

LOCK TABLES `temporal_cotizacion_pedido_detalle` WRITE;
/*!40000 ALTER TABLE `temporal_cotizacion_pedido_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `temporal_cotizacion_pedido_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `temporal_operacion_almacen_detalle`
--

DROP TABLE IF EXISTS `temporal_operacion_almacen_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `temporal_operacion_almacen_detalle` (
  `opealmdet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `opealmdet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `opealmdet_cantidad` float DEFAULT NULL,
  `opealm_codi_fk` int(11) DEFAULT NULL,
  `idtrans` varchar(45) DEFAULT NULL,
  `opealmdet_codi_fk` int(10) unsigned DEFAULT NULL,
  `opealmdet_cantidad_disponible` float NOT NULL DEFAULT 0,
  `idtrans_temporal` varchar(45) DEFAULT NULL,
  `mp_codi_fk_alm` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`opealmdet_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `temporal_operacion_almacen_detalle`
--

LOCK TABLES `temporal_operacion_almacen_detalle` WRITE;
/*!40000 ALTER TABLE `temporal_operacion_almacen_detalle` DISABLE KEYS */;
INSERT INTO `temporal_operacion_almacen_detalle` VALUES (1,'2021-10-03 15:58:20',11,8,NULL,NULL,'16332946623100631571',NULL,0,'16332946623100631571',1);
/*!40000 ALTER TABLE `temporal_operacion_almacen_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `temporal_orden_compra_detalle`
--

DROP TABLE IF EXISTS `temporal_orden_compra_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `temporal_orden_compra_detalle` (
  `ordcomdet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `ordcomdet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `ordcomdet_precio` float NOT NULL DEFAULT 0,
  `ordcomdet_cantidad` float NOT NULL DEFAULT 0,
  `ordcom_codi_fk` int(11) DEFAULT NULL,
  `idtrans` varchar(45) DEFAULT NULL,
  `ordcomdet_codi_fk` int(10) unsigned DEFAULT NULL,
  `idtrans_temporal` varchar(45) DEFAULT NULL,
  `ordcomdet_igv` float NOT NULL DEFAULT 0,
  `ordcomdet_isc` float NOT NULL DEFAULT 0,
  `ordcomdet_percepcion` float NOT NULL DEFAULT 0,
  `ordcomdet_igv_afectado` int(10) unsigned NOT NULL DEFAULT 0,
  `ordcomdet_isc_afectado` int(10) unsigned NOT NULL DEFAULT 0,
  `ordcomdet_cantidad_devolver` float NOT NULL DEFAULT 0,
  `ordcomdet_cantidad_devolver_temporal` float NOT NULL DEFAULT 0,
  `ordcomdet_precio_descuento` float NOT NULL DEFAULT 0,
  `ordcomdet_precio_descuento_temporal` float NOT NULL DEFAULT 0,
  PRIMARY KEY (`ordcomdet_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `temporal_orden_compra_detalle`
--

LOCK TABLES `temporal_orden_compra_detalle` WRITE;
/*!40000 ALTER TABLE `temporal_orden_compra_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `temporal_orden_compra_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `temporal_orden_pedido_detalle`
--

DROP TABLE IF EXISTS `temporal_orden_pedido_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `temporal_orden_pedido_detalle` (
  `ordpeddet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `ordpeddet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `ordpeddet_precio` float NOT NULL DEFAULT 0,
  `ordpeddet_cantidad` float NOT NULL DEFAULT 0,
  `ordped_codi_fk` int(11) NOT NULL DEFAULT 0,
  `idtrans` varchar(45) DEFAULT NULL,
  `ordpeddet_codi_fk` int(10) unsigned DEFAULT NULL,
  `idtrans_temporal` varchar(45) DEFAULT NULL,
  `ordpeddet_observaciones` text DEFAULT NULL,
  PRIMARY KEY (`ordpeddet_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `temporal_orden_pedido_detalle`
--

LOCK TABLES `temporal_orden_pedido_detalle` WRITE;
/*!40000 ALTER TABLE `temporal_orden_pedido_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `temporal_orden_pedido_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `temporal_requerimiento_detalle`
--

DROP TABLE IF EXISTS `temporal_requerimiento_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `temporal_requerimiento_detalle` (
  `reqdet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `reqdet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `reqdet_precio` float NOT NULL DEFAULT 0,
  `reqdet_cantidad` float NOT NULL DEFAULT 0,
  `req_codi_fk` int(11) NOT NULL DEFAULT 0,
  `idtrans` varchar(45) DEFAULT NULL,
  `reqdet_codi_fk` int(10) unsigned DEFAULT NULL,
  `idtrans_temporal` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`reqdet_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `temporal_requerimiento_detalle`
--

LOCK TABLES `temporal_requerimiento_detalle` WRITE;
/*!40000 ALTER TABLE `temporal_requerimiento_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `temporal_requerimiento_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `temporal_requerimiento_interno_detalle`
--

DROP TABLE IF EXISTS `temporal_requerimiento_interno_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `temporal_requerimiento_interno_detalle` (
  `reqintdet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `reqintdet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `reqintdet_precio` float NOT NULL DEFAULT 0,
  `reqintdet_cantidad` float NOT NULL DEFAULT 0,
  `reqint_codi_fk` int(11) NOT NULL DEFAULT 0,
  `idtrans` varchar(45) DEFAULT NULL,
  `reqintdet_codi_fk` int(10) unsigned DEFAULT NULL,
  `idtrans_temporal` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`reqintdet_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `temporal_requerimiento_interno_detalle`
--

LOCK TABLES `temporal_requerimiento_interno_detalle` WRITE;
/*!40000 ALTER TABLE `temporal_requerimiento_interno_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `temporal_requerimiento_interno_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tipos_existencias`
--

DROP TABLE IF EXISTS `tipos_existencias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tipos_existencias` (
  `tipexi_codi` int(11) NOT NULL AUTO_INCREMENT,
  `tipexi_nombre` varchar(45) NOT NULL DEFAULT '',
  `tipexi_estado` int(11) NOT NULL DEFAULT 1,
  `tipexi_abreviatura` varchar(45) DEFAULT NULL,
  `tipexi_usu_crea` varchar(45) DEFAULT NULL,
  `tipexi_usu_modifica` varchar(45) DEFAULT NULL,
  `tipexi_usu_activa` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`tipexi_codi`),
  UNIQUE KEY `Index_tipexi_nombre` (`tipexi_nombre`),
  KEY `Index_tipexi_estado` (`tipexi_estado`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tipos_existencias`
--

LOCK TABLES `tipos_existencias` WRITE;
/*!40000 ALTER TABLE `tipos_existencias` DISABLE KEYS */;
INSERT INTO `tipos_existencias` VALUES (1,'MERCADERIAS',1,'01','etorres',NULL,NULL),(2,'PRODUCTOS TERMINADOS',1,'02','etorres',NULL,NULL),(3,'MATERIAS PRIMAS',1,'03','etorres',NULL,NULL),(4,'ENVASES',1,'04','etorres',NULL,NULL),(5,'MATERIALES AUXILIARES',1,'05','etorres',NULL,NULL),(6,'SUMINISTROS',1,'06','etorres',NULL,NULL),(7,'REPUESTOS',1,'07','etorres',NULL,NULL),(8,'EMBALAJES',1,'08','etorres',NULL,NULL),(9,'SUBPRODUCTOS',1,'09','etorres',NULL,NULL),(10,'DESECHOS Y DESPERDICIOS',1,'10','etorres',NULL,NULL),(11,'OTROS 1',1,'91','etorres',NULL,NULL),(12,'OTROS 2',1,'92','etorres',NULL,NULL),(13,'OTROS 3',1,'93','etorres',NULL,NULL),(14,'OTROS 4',1,'94','etorres',NULL,NULL),(15,'OTROS 5',1,'95','etorres',NULL,NULL),(16,'OTROS 6',1,'96','etorres',NULL,NULL),(17,'OTROS 7',1,'97','etorres',NULL,NULL),(18,'OTROS 8',1,'98','etorres',NULL,NULL),(19,'OTROS',1,'99','etorres','etorres',NULL);
/*!40000 ALTER TABLE `tipos_existencias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transportistas`
--

DROP TABLE IF EXISTS `transportistas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transportistas` (
  `tra_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tra_apellido_nombre` varchar(245) NOT NULL DEFAULT '',
  `tra_ruc_dni` varchar(200) NOT NULL DEFAULT '',
  `tra_direccion` varchar(145) NOT NULL DEFAULT '',
  `tra_telefono` varchar(145) NOT NULL DEFAULT '',
  `tra_licencia_conducir` varchar(145) NOT NULL DEFAULT '',
  `tra_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `tra_usu_crea` varchar(45) NOT NULL DEFAULT '',
  `tra_usu_modifica` varchar(45) NOT NULL DEFAULT '',
  `tra_usu_activa` varchar(45) NOT NULL DEFAULT '',
  `traemp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`tra_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transportistas`
--

LOCK TABLES `transportistas` WRITE;
/*!40000 ALTER TABLE `transportistas` DISABLE KEYS */;
/*!40000 ALTER TABLE `transportistas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transportistas_empresa`
--

DROP TABLE IF EXISTS `transportistas_empresa`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transportistas_empresa` (
  `traemp_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `traemp_nombre` varchar(245) NOT NULL DEFAULT '',
  `traemp_ruc_dni` varchar(20) NOT NULL DEFAULT '',
  `traemp_direccion` varchar(245) NOT NULL DEFAULT '',
  `traemp_telefono` varchar(100) NOT NULL DEFAULT '',
  `traemp_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `traemp_usu_crea` varchar(45) NOT NULL DEFAULT '',
  `traemp_usu_modifica` varchar(45) NOT NULL DEFAULT '',
  `traemp_usu_activa` varchar(45) NOT NULL DEFAULT '',
  PRIMARY KEY (`traemp_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transportistas_empresa`
--

LOCK TABLES `transportistas_empresa` WRITE;
/*!40000 ALTER TABLE `transportistas_empresa` DISABLE KEYS */;
/*!40000 ALTER TABLE `transportistas_empresa` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ubdepartamento`
--

DROP TABLE IF EXISTS `ubdepartamento`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ubdepartamento` (
  `idDepa` int(5) NOT NULL DEFAULT 0,
  `departamento` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`idDepa`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ubdepartamento`
--

LOCK TABLES `ubdepartamento` WRITE;
/*!40000 ALTER TABLE `ubdepartamento` DISABLE KEYS */;
INSERT INTO `ubdepartamento` VALUES (1,'AMAZONAS'),(2,'ANCASH'),(3,'APURIMAC'),(4,'AREQUIPA'),(5,'AYACUCHO'),(6,'CAJAMARCA'),(7,'CALLAO'),(8,'CUSCO'),(9,'HUANCAVELICA'),(10,'HUANUCO'),(11,'ICA'),(12,'JUNIN'),(13,'LA LIBERTAD'),(14,'LAMBAYEQUE'),(15,'LIMA'),(16,'LORETO'),(17,'MADRE DE DIOS'),(18,'MOQUEGUA'),(19,'PASCO'),(20,'PIURA'),(21,'PUNO'),(22,'SAN MARTIN'),(23,'TACNA'),(24,'TUMBES'),(25,'UCAYALI');
/*!40000 ALTER TABLE `ubdepartamento` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ubdistrito`
--

DROP TABLE IF EXISTS `ubdistrito`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ubdistrito` (
  `idDist` int(5) NOT NULL DEFAULT 0,
  `distrito` varchar(50) DEFAULT NULL,
  `idProv` int(5) DEFAULT NULL,
  PRIMARY KEY (`idDist`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ubdistrito`
--

LOCK TABLES `ubdistrito` WRITE;
/*!40000 ALTER TABLE `ubdistrito` DISABLE KEYS */;
INSERT INTO `ubdistrito` VALUES (1,'CHACHAPOYAS',1),(2,'ASUNCION',1),(3,'BALSAS',1),(4,'CHETO',1),(5,'CHILIQUIN',1),(6,'CHUQUIBAMBA',1),(7,'GRANADA',1),(8,'HUANCAS',1),(9,'LA JALCA',1),(10,'LEIMEBAMBA',1),(11,'LEVANTO',1),(12,'MAGDALENA',1),(13,'MARISCAL CASTILLA',1),(14,'MOLINOPAMPA',1),(15,'MONTEVIDEO',1),(16,'OLLEROS',1),(17,'QUINJALCA',1),(18,'SAN FRANCISCO DE DAGUAS',1),(19,'SAN ISIDRO DE MAINO',1),(20,'SOLOCO',1),(21,'SONCHE',1),(22,'LA PECA',2),(23,'ARAMANGO',2),(24,'COPALLIN',2),(25,'EL PARCO',2),(26,'IMAZA',2),(27,'JUMBILLA',3),(28,'CHISQUILLA',3),(29,'CHURUJA',3),(30,'COROSHA',3),(31,'CUISPES',3),(32,'FLORIDA',3),(33,'JAZAN',3),(34,'RECTA',3),(35,'SAN CARLOS',3),(36,'SHIPASBAMBA',3),(37,'VALERA',3),(38,'YAMBRASBAMBA',3),(39,'NIEVA',4),(40,'EL CENEPA',4),(41,'RIO SANTIAGO',4),(42,'LAMUD',5),(43,'CAMPORREDONDO',5),(44,'COCABAMBA',5),(45,'COLCAMAR',5),(46,'CONILA',5),(47,'INGUILPATA',5),(48,'LONGUITA',5),(49,'LONYA CHICO',5),(50,'LUYA',5),(51,'LUYA VIEJO',5),(52,'MARIA',5),(53,'OCALLI',5),(54,'OCUMAL',5),(55,'PISUQUIA',5),(56,'PROVIDENCIA',5),(57,'SAN CRISTOBAL',5),(58,'SAN FRANCISCO DEL YESO',5),(59,'SAN JERONIMO',5),(60,'SAN JUAN DE LOPECANCHA',5),(61,'SANTA CATALINA',5),(62,'SANTO TOMAS',5),(63,'TINGO',5),(64,'TRITA',5),(65,'SAN NICOLAS',6),(66,'CHIRIMOTO',6),(67,'COCHAMAL',6),(68,'HUAMBO',6),(69,'LIMABAMBA',6),(70,'LONGAR',6),(71,'MARISCAL BENAVIDES',6),(72,'MILPUC',6),(73,'OMIA',6),(74,'SANTA ROSA',6),(75,'TOTORA',6),(76,'VISTA ALEGRE',6),(77,'BAGUA GRANDE',7),(78,'CAJARURO',7),(79,'CUMBA',7),(80,'EL MILAGRO',7),(81,'JAMALCA',7),(82,'LONYA GRANDE',7),(83,'YAMON',7),(84,'HUARAZ',8),(85,'COCHABAMBA',8),(86,'COLCABAMBA',8),(87,'HUANCHAY',8),(88,'INDEPENDENCIA',8),(89,'JANGAS',8),(90,'LA LIBERTAD',8),(91,'OLLEROS',8),(92,'PAMPAS',8),(93,'PARIACOTO',8),(94,'PIRA',8),(95,'TARICA',8),(96,'AIJA',9),(97,'CORIS',9),(98,'HUACLLAN',9),(99,'LA MERCED',9),(100,'SUCCHA',9),(101,'LLAMELLIN',10),(102,'ACZO',10),(103,'CHACCHO',10),(104,'CHINGAS',10),(105,'MIRGAS',10),(106,'SAN JUAN DE RONTOY',10),(107,'CHACAS',11),(108,'ACOCHACA',11),(109,'CHIQUIAN',12),(110,'ABELARDO PARDO LEZAMETA',12),(111,'ANTONIO RAYMONDI',12),(112,'AQUIA',12),(113,'CAJACAY',12),(114,'CANIS',12),(115,'COLQUIOC',12),(116,'HUALLANCA',12),(117,'HUASTA',12),(118,'HUAYLLACAYAN',12),(119,'LA PRIMAVERA',12),(120,'MANGAS',12),(121,'PACLLON',12),(122,'SAN MIGUEL DE CORPANQUI',12),(123,'TICLLOS',12),(124,'CARHUAZ',13),(125,'ACOPAMPA',13),(126,'AMASHCA',13),(127,'ANTA',13),(128,'ATAQUERO',13),(129,'MARCARA',13),(130,'PARIAHUANCA',13),(131,'SAN MIGUEL DE ACO',13),(132,'SHILLA',13),(133,'TINCO',13),(134,'YUNGAR',13),(135,'SAN LUIS',14),(136,'SAN NICOLAS',14),(137,'YAUYA',14),(138,'CASMA',15),(139,'BUENA VISTA ALTA',15),(140,'COMANDANTE NOEL',15),(141,'YAUTAN',15),(142,'CORONGO',16),(143,'ACO',16),(144,'BAMBAS',16),(145,'CUSCA',16),(146,'LA PAMPA',16),(147,'YANAC',16),(148,'YUPAN',16),(149,'HUARI',17),(150,'ANRA',17),(151,'CAJAY',17),(152,'CHAVIN DE HUANTAR',17),(153,'HUACACHI',17),(154,'HUACCHIS',17),(155,'HUACHIS',17),(156,'HUANTAR',17),(157,'MASIN',17),(158,'PAUCAS',17),(159,'PONTO',17),(160,'RAHUAPAMPA',17),(161,'RAPAYAN',17),(162,'SAN MARCOS',17),(163,'SAN PEDRO DE CHANA',17),(164,'UCO',17),(165,'HUARMEY',18),(166,'COCHAPETI',18),(167,'CULEBRAS',18),(168,'HUAYAN',18),(169,'MALVAS',18),(170,'CARAZ',26),(171,'HUALLANCA',26),(172,'HUATA',26),(173,'HUAYLAS',26),(174,'MATO',26),(175,'PAMPAROMAS',26),(176,'PUEBLO LIBRE',26),(177,'SANTA CRUZ',26),(178,'SANTO TORIBIO',26),(179,'YURACMARCA',26),(180,'PISCOBAMBA',27),(181,'CASCA',27),(182,'ELEAZAR GUZMAN BARRON',27),(183,'FIDEL OLIVAS ESCUDERO',27),(184,'LLAMA',27),(185,'LLUMPA',27),(186,'LUCMA',27),(187,'MUSGA',27),(188,'OCROS',21),(189,'ACAS',21),(190,'CAJAMARQUILLA',21),(191,'CARHUAPAMPA',21),(192,'COCHAS',21),(193,'CONGAS',21),(194,'LLIPA',21),(195,'SAN CRISTOBAL DE RAJAN',21),(196,'SAN PEDRO',21),(197,'SANTIAGO DE CHILCAS',21),(198,'CABANA',22),(199,'BOLOGNESI',22),(200,'CONCHUCOS',22),(201,'HUACASCHUQUE',22),(202,'HUANDOVAL',22),(203,'LACABAMBA',22),(204,'LLAPO',22),(205,'PALLASCA',22),(206,'PAMPAS',22),(207,'SANTA ROSA',22),(208,'TAUCA',22),(209,'POMABAMBA',23),(210,'HUAYLLAN',23),(211,'PAROBAMBA',23),(212,'QUINUABAMBA',23),(213,'RECUAY',24),(214,'CATAC',24),(215,'COTAPARACO',24),(216,'HUAYLLAPAMPA',24),(217,'LLACLLIN',24),(218,'MARCA',24),(219,'PAMPAS CHICO',24),(220,'PARARIN',24),(221,'TAPACOCHA',24),(222,'TICAPAMPA',24),(223,'CHIMBOTE',25),(224,'CACERES DEL PERU',25),(225,'COISHCO',25),(226,'MACATE',25),(227,'MORO',25),(228,'NEPE&Ntilde;A',25),(229,'SAMANCO',25),(230,'SANTA',25),(231,'NUEVO CHIMBOTE',25),(232,'SIHUAS',26),(233,'ACOBAMBA',26),(234,'ALFONSO UGARTE',26),(235,'CASHAPAMPA',26),(236,'CHINGALPO',26),(237,'HUAYLLABAMBA',26),(238,'QUICHES',26),(239,'RAGASH',26),(240,'SAN JUAN',26),(241,'SICSIBAMBA',26),(242,'YUNGAY',27),(243,'CASCAPARA',27),(244,'MANCOS',27),(245,'MATACOTO',27),(246,'QUILLO',27),(247,'RANRAHIRCA',27),(248,'SHUPLUY',27),(249,'YANAMA',27),(250,'ABANCAY',28),(251,'CHACOCHE',28),(252,'CIRCA',28),(253,'CURAHUASI',28),(254,'HUANIPACA',28),(255,'LAMBRAMA',28),(256,'PICHIRHUA',28),(257,'SAN PEDRO DE CACHORA',28),(258,'TAMBURCO',28),(259,'ANDAHUAYLAS',29),(260,'ANDARAPA',29),(261,'CHIARA',29),(262,'HUANCARAMA',29),(263,'HUANCARAY',29),(264,'HUAYANA',29),(265,'KISHUARA',29),(266,'PACOBAMBA',29),(267,'PACUCHA',29),(268,'PAMPACHIRI',29),(269,'POMACOCHA',29),(270,'SAN ANTONIO DE CACHI',29),(271,'SAN JERONIMO',29),(272,'SAN MIGUEL DE CHACCRAMPA',29),(273,'SANTA MARIA DE CHICMO',29),(274,'TALAVERA',29),(275,'TUMAY HUARACA',29),(276,'TURPO',29),(277,'KAQUIABAMBA',29),(278,'ANTABAMBA',30),(279,'EL ORO',30),(280,'HUAQUIRCA',30),(281,'JUAN ESPINOZA MEDRANO',30),(282,'OROPESA',30),(283,'PACHACONAS',30),(284,'SABAINO',30),(285,'CHALHUANCA',31),(286,'CAPAYA',31),(287,'CARAYBAMBA',31),(288,'CHAPIMARCA',31),(289,'COLCABAMBA',31),(290,'COTARUSE',31),(291,'HUAYLLO',31),(292,'JUSTO APU SAHUARAURA',31),(293,'LUCRE',31),(294,'POCOHUANCA',31),(295,'SAN JUAN DE CHAC&Ntilde;A',31),(296,'SA&Ntilde;AYCA',31),(297,'SORAYA',31),(298,'TAPAIRIHUA',31),(299,'TINTAY',31),(300,'TORAYA',31),(301,'YANACA',31),(302,'TAMBOBAMBA',32),(303,'COTABAMBAS',32),(304,'COYLLURQUI',32),(305,'HAQUIRA',32),(306,'MARA',32),(307,'CHALLHUAHUACHO',32),(308,'CHINCHEROS',33),(309,'ANCO-HUALLO',33),(310,'COCHARCAS',33),(311,'HUACCANA',33),(312,'OCOBAMBA',33),(313,'ONGOY',33),(314,'URANMARCA',33),(315,'RANRACANCHA',33),(316,'CHUQUIBAMBILLA',34),(317,'CURPAHUASI',34),(318,'GAMARRA',34),(319,'HUAYLLATI',34),(320,'MAMARA',34),(321,'MICAELA BASTIDAS',34),(322,'PATAYPAMPA',34),(323,'PROGRESO',34),(324,'SAN ANTONIO',34),(325,'SANTA ROSA',34),(326,'TURPAY',34),(327,'VILCABAMBA',34),(328,'VIRUNDO',34),(329,'CURASCO',34),(330,'AREQUIPA',35),(331,'ALTO SELVA ALEGRE',35),(332,'CAYMA',35),(333,'CERRO COLORADO',35),(334,'CHARACATO',35),(335,'CHIGUATA',35),(336,'JACOBO HUNTER',35),(337,'LA JOYA',35),(338,'MARIANO MELGAR',35),(339,'MIRAFLORES',35),(340,'MOLLEBAYA',35),(341,'PAUCARPATA',35),(342,'POCSI',35),(343,'POLOBAYA',35),(344,'QUEQUE&Ntilde;A',35),(345,'SABANDIA',35),(346,'SACHACA',35),(347,'SAN JUAN DE SIGUAS',35),(348,'SAN JUAN DE TARUCANI',35),(349,'SANTA ISABEL DE SIGUAS',35),(350,'SANTA RITA DE SIGUAS',35),(351,'SOCABAYA',35),(352,'TIABAYA',35),(353,'UCHUMAYO',35),(354,'VITOR',35),(355,'YANAHUARA',35),(356,'YARABAMBA',35),(357,'YURA',35),(358,'JOSE LUIS BUSTAMANTE Y RIVERO',35),(359,'CAMANA',36),(360,'JOSE MARIA QUIMPER',36),(361,'MARIANO NICOLAS VALCARCEL',36),(362,'MARISCAL CACERES',36),(363,'NICOLAS DE PIEROLA',36),(364,'OCO&Ntilde;A',36),(365,'QUILCA',36),(366,'SAMUEL PASTOR',36),(367,'CARAVELI',37),(368,'ACARI',37),(369,'ATICO',37),(370,'ATIQUIPA',37),(371,'BELLA UNION',37),(372,'CAHUACHO',37),(373,'CHALA',37),(374,'CHAPARRA',37),(375,'HUANUHUANU',37),(376,'JAQUI',37),(377,'LOMAS',37),(378,'QUICACHA',37),(379,'YAUCA',37),(380,'APLAO',38),(381,'ANDAGUA',38),(382,'AYO',38),(383,'CHACHAS',38),(384,'CHILCAYMARCA',38),(385,'CHOCO',38),(386,'HUANCARQUI',38),(387,'MACHAGUAY',38),(388,'ORCOPAMPA',38),(389,'PAMPACOLCA',38),(390,'TIPAN',38),(391,'U&Ntilde;ON',38),(392,'URACA',38),(393,'VIRACO',38),(394,'CHIVAY',39),(395,'ACHOMA',39),(396,'CABANACONDE',39),(397,'CALLALLI',39),(398,'CAYLLOMA',39),(399,'COPORAQUE',39),(400,'HUAMBO',39),(401,'HUANCA',39),(402,'ICHUPAMPA',39),(403,'LARI',39),(404,'LLUTA',39),(405,'MACA',39),(406,'MADRIGAL',39),(407,'SAN ANTONIO DE CHUCA',39),(408,'SIBAYO',39),(409,'TAPAY',39),(410,'TISCO',39),(411,'TUTI',39),(412,'YANQUE',39),(413,'MAJES',39),(414,'CHUQUIBAMBA',40),(415,'ANDARAY',40),(416,'CAYARANI',40),(417,'CHICHAS',40),(418,'IRAY',40),(419,'RIO GRANDE',40),(420,'SALAMANCA',40),(421,'YANAQUIHUA',40),(422,'MOLLENDO',41),(423,'COCACHACRA',41),(424,'DEAN VALDIVIA',41),(425,'ISLAY',41),(426,'MEJIA',41),(427,'PUNTA DE BOMBON',41),(428,'COTAHUASI',42),(429,'ALCA',42),(430,'CHARCANA',42),(431,'HUAYNACOTAS',42),(432,'PAMPAMARCA',42),(433,'PUYCA',42),(434,'QUECHUALLA',42),(435,'SAYLA',42),(436,'TAURIA',42),(437,'TOMEPAMPA',42),(438,'TORO',42),(439,'AYACUCHO',43),(440,'ACOCRO',43),(441,'ACOS VINCHOS',43),(442,'CARMEN ALTO',43),(443,'CHIARA',43),(444,'OCROS',43),(445,'PACAYCASA',43),(446,'QUINUA',43),(447,'SAN JOSE DE TICLLAS',43),(448,'SAN JUAN BAUTISTA',43),(449,'SANTIAGO DE PISCHA',43),(450,'SOCOS',43),(451,'TAMBILLO',43),(452,'VINCHOS',43),(453,'JESUS NAZARENO',43),(454,'CANGALLO',44),(455,'CHUSCHI',44),(456,'LOS MOROCHUCOS',44),(457,'MARIA PARADO DE BELLIDO',44),(458,'PARAS',44),(459,'TOTOS',44),(460,'SANCOS',45),(461,'CARAPO',45),(462,'SACSAMARCA',45),(463,'SANTIAGO DE LUCANAMARCA',45),(464,'HUANTA',46),(465,'AYAHUANCO',46),(466,'HUAMANGUILLA',46),(467,'IGUAIN',46),(468,'LURICOCHA',46),(469,'SANTILLANA',46),(470,'SIVIA',46),(471,'LLOCHEGUA',46),(472,'SAN MIGUEL',47),(473,'ANCO',47),(474,'AYNA',47),(475,'CHILCAS',47),(476,'CHUNGUI',47),(477,'LUIS CARRANZA',47),(478,'SANTA ROSA',47),(479,'TAMBO',47),(480,'PUQUIO',48),(481,'AUCARA',48),(482,'CABANA',48),(483,'CARMEN SALCEDO',48),(484,'CHAVI&Ntilde;A',48),(485,'CHIPAO',48),(486,'HUAC-HUAS',48),(487,'LARAMATE',48),(488,'LEONCIO PRADO',48),(489,'LLAUTA',48),(490,'LUCANAS',48),(491,'OCA&Ntilde;A',48),(492,'OTOCA',48),(493,'SAISA',48),(494,'SAN CRISTOBAL',48),(495,'SAN JUAN',48),(496,'SAN PEDRO',48),(497,'SAN PEDRO DE PALCO',48),(498,'SANCOS',48),(499,'SANTA ANA DE HUAYCAHUACHO',48),(500,'SANTA LUCIA',48),(501,'CORACORA',49),(502,'CHUMPI',49),(503,'CORONEL CASTA&Ntilde;EDA',49),(504,'PACAPAUSA',49),(505,'PULLO',49),(506,'PUYUSCA',49),(507,'SAN FRANCISCO DE RAVACAYCO',49),(508,'UPAHUACHO',49),(509,'PAUSA',50),(510,'COLTA',50),(511,'CORCULLA',50),(512,'LAMPA',50),(513,'MARCABAMBA',50),(514,'OYOLO',50),(515,'PARARCA',50),(516,'SAN JAVIER DE ALPABAMBA',50),(517,'SAN JOSE DE USHUA',50),(518,'SARA SARA',50),(519,'QUEROBAMBA',51),(520,'BELEN',51),(521,'CHALCOS',51),(522,'CHILCAYOC',51),(523,'HUACA&Ntilde;A',51),(524,'MORCOLLA',51),(525,'PAICO',51),(526,'SAN PEDRO DE LARCAY',51),(527,'SAN SALVADOR DE QUIJE',51),(528,'SANTIAGO DE PAUCARAY',51),(529,'SORAS',51),(530,'HUANCAPI',52),(531,'ALCAMENCA',52),(532,'APONGO',52),(533,'ASQUIPATA',52),(534,'CANARIA',52),(535,'CAYARA',52),(536,'COLCA',52),(537,'HUAMANQUIQUIA',52),(538,'HUANCARAYLLA',52),(539,'HUAYA',52),(540,'SARHUA',52),(541,'VILCANCHOS',52),(542,'VILCAS HUAMAN',53),(543,'ACCOMARCA',53),(544,'CARHUANCA',53),(545,'CONCEPCION',53),(546,'HUAMBALPA',53),(547,'INDEPENDENCIA',53),(548,'SAURAMA',53),(549,'VISCHONGO',53),(550,'CAJAMARCA',54),(551,'CAJAMARCA',54),(552,'ASUNCION',54),(553,'CHETILLA',54),(554,'COSPAN',54),(555,'ENCA&Ntilde;ADA',54),(556,'JESUS',54),(557,'LLACANORA',54),(558,'LOS BA&Ntilde;OS DEL INCA',54),(559,'MAGDALENA',54),(560,'MATARA',54),(561,'NAMORA',54),(562,'SAN JUAN',54),(563,'CAJABAMBA',55),(564,'CACHACHI',55),(565,'CONDEBAMBA',55),(566,'SITACOCHA',55),(567,'CELENDIN',56),(568,'CHUMUCH',56),(569,'CORTEGANA',56),(570,'HUASMIN',56),(571,'JORGE CHAVEZ',56),(572,'JOSE GALVEZ',56),(573,'MIGUEL IGLESIAS',56),(574,'OXAMARCA',56),(575,'SOROCHUCO',56),(576,'SUCRE',56),(577,'UTCO',56),(578,'LA LIBERTAD DE PALLAN',56),(579,'CHOTA',57),(580,'ANGUIA',57),(581,'CHADIN',57),(582,'CHIGUIRIP',57),(583,'CHIMBAN',57),(584,'CHOROPAMPA',57),(585,'COCHABAMBA',57),(586,'CONCHAN',57),(587,'HUAMBOS',57),(588,'LAJAS',57),(589,'LLAMA',57),(590,'MIRACOSTA',57),(591,'PACCHA',57),(592,'PION',57),(593,'QUEROCOTO',57),(594,'SAN JUAN DE LICUPIS',57),(595,'TACABAMBA',57),(596,'TOCMOCHE',57),(597,'CHALAMARCA',57),(598,'CONTUMAZA',58),(599,'CHILETE',58),(600,'CUPISNIQUE',58),(601,'GUZMANGO',58),(602,'SAN BENITO',58),(603,'SANTA CRUZ DE TOLED',58),(604,'TANTARICA',58),(605,'YONAN',58),(606,'CUTERVO',59),(607,'CALLAYUC',59),(608,'CHOROS',59),(609,'CUJILLO',59),(610,'LA RAMADA',59),(611,'PIMPINGOS',59),(612,'QUEROCOTILLO',59),(613,'SAN ANDRES DE CUTERVO',59),(614,'SAN JUAN DE CUTERVO',59),(615,'SAN LUIS DE LUCMA',59),(616,'SANTA CRUZ',59),(617,'SANTO DOMINGO DE LA CAPILLA',59),(618,'SANTO TOMAS',59),(619,'SOCOTA',59),(620,'TORIBIO CASANOVA',59),(621,'BAMBAMARCA',60),(622,'CHUGUR',60),(623,'HUALGAYOC',60),(624,'JAEN',61),(625,'BELLAVISTA',61),(626,'CHONTALI',61),(627,'COLASAY',61),(628,'HUABAL',61),(629,'LAS PIRIAS',61),(630,'POMAHUACA',61),(631,'PUCARA',61),(632,'SALLIQUE',61),(633,'SAN FELIPE',61),(634,'SAN JOSE DEL ALTO',61),(635,'SANTA ROSA',61),(636,'SAN IGNACIO',62),(637,'CHIRINOS',62),(638,'HUARANGO',62),(639,'LA COIPA',62),(640,'NAMBALLE',62),(641,'SAN JOSE DE LOURDES',62),(642,'TABACONAS',62),(643,'PEDRO GALVEZ',63),(644,'CHANCAY',63),(645,'EDUARDO VILLANUEVA',63),(646,'GREGORIO PITA',63),(647,'ICHOCAN',63),(648,'JOSE MANUEL QUIROZ',63),(649,'JOSE SABOGAL',63),(650,'SAN MIGUEL',64),(651,'SAN MIGUEL',64),(652,'BOLIVAR',64),(653,'CALQUIS',64),(654,'CATILLUC',64),(655,'EL PRADO',64),(656,'LA FLORIDA',64),(657,'LLAPA',64),(658,'NANCHOC',64),(659,'NIEPOS',64),(660,'SAN GREGORIO',64),(661,'SAN SILVESTRE DE COCHAN',64),(662,'TONGOD',64),(663,'UNION AGUA BLANCA',64),(664,'SAN PABLO',65),(665,'SAN BERNARDINO',65),(666,'SAN LUIS',65),(667,'TUMBADEN',65),(668,'SANTA CRUZ',66),(669,'ANDABAMBA',66),(670,'CATACHE',66),(671,'CHANCAYBA&Ntilde;OS',66),(672,'LA ESPERANZA',66),(673,'NINABAMBA',66),(674,'PULAN',66),(675,'SAUCEPAMPA',66),(676,'SEXI',66),(677,'UTICYACU',66),(678,'YAUYUCAN',66),(679,'CALLAO',67),(680,'BELLAVISTA',67),(681,'CARMEN DE LA LEGUA REYNOSO',67),(682,'LA PERLA',67),(683,'LA PUNTA',67),(684,'VENTANILLA',67),(685,'CUSCO',67),(686,'CCORCA',67),(687,'POROY',67),(688,'SAN JERONIMO',67),(689,'SAN SEBASTIAN',67),(690,'SANTIAGO',67),(691,'SAYLLA',67),(692,'WANCHAQ',67),(693,'ACOMAYO',68),(694,'ACOPIA',68),(695,'ACOS',68),(696,'MOSOC LLACTA',68),(697,'POMACANCHI',68),(698,'RONDOCAN',68),(699,'SANGARARA',68),(700,'ANTA',69),(701,'ANCAHUASI',69),(702,'CACHIMAYO',69),(703,'CHINCHAYPUJIO',69),(704,'HUAROCONDO',69),(705,'LIMATAMBO',69),(706,'MOLLEPATA',69),(707,'PUCYURA',69),(708,'ZURITE',69),(709,'CALCA',70),(710,'COYA',70),(711,'LAMAY',70),(712,'LARES',70),(713,'PISAC',70),(714,'SAN SALVADOR',70),(715,'TARAY',70),(716,'YANATILE',70),(717,'YANAOCA',71),(718,'CHECCA',71),(719,'KUNTURKANKI',71),(720,'LANGUI',71),(721,'LAYO',71),(722,'PAMPAMARCA',71),(723,'QUEHUE',71),(724,'TUPAC AMARU',71),(725,'SICUANI',72),(726,'CHECACUPE',72),(727,'COMBAPATA',72),(728,'MARANGANI',72),(729,'PITUMARCA',72),(730,'SAN PABLO',72),(731,'SAN PEDRO',72),(732,'TINTA',72),(733,'SANTO TOMAS',73),(734,'CAPACMARCA',73),(735,'CHAMACA',73),(736,'COLQUEMARCA',73),(737,'LIVITACA',73),(738,'LLUSCO',73),(739,'QUI&Ntilde;OTA',73),(740,'VELILLE',73),(741,'ESPINAR',74),(742,'CONDOROMA',74),(743,'COPORAQUE',74),(744,'OCORURO',74),(745,'PALLPATA',74),(746,'PICHIGUA',74),(747,'SUYCKUTAMBO',74),(748,'ALTO PICHIGUA',74),(749,'SANTA ANA',75),(750,'ECHARATE',75),(751,'HUAYOPATA',75),(752,'MARANURA',75),(753,'OCOBAMBA',75),(754,'QUELLOUNO',75),(755,'KIMBIRI',75),(756,'SANTA TERESA',75),(757,'VILCABAMBA',75),(758,'PICHARI',75),(759,'PARURO',76),(760,'ACCHA',76),(761,'CCAPI',76),(762,'COLCHA',76),(763,'HUANOQUITE',76),(764,'OMACHA',76),(765,'PACCARITAMBO',76),(766,'PILLPINTO',76),(767,'YAURISQUE',76),(768,'PAUCARTAMBO',77),(769,'CAICAY',77),(770,'CHALLABAMBA',77),(771,'COLQUEPATA',77),(772,'HUANCARANI',77),(773,'KOS&Ntilde;IPATA',77),(774,'URCOS',78),(775,'ANDAHUAYLILLAS',78),(776,'CAMANTI',78),(777,'CCARHUAYO',78),(778,'CCATCA',78),(779,'CUSIPATA',78),(780,'HUARO',78),(781,'LUCRE',78),(782,'MARCAPATA',78),(783,'OCONGATE',78),(784,'OROPESA',78),(785,'QUIQUIJANA',78),(786,'URUBAMBA',79),(787,'CHINCHERO',79),(788,'HUAYLLABAMBA',79),(789,'MACHUPICCHU',79),(790,'MARAS',79),(791,'OLLANTAYTAMBO',79),(792,'YUCAY',79),(793,'HUANCAVELICA',80),(794,'ACOBAMBILLA',80),(795,'ACORIA',80),(796,'CONAYCA',80),(797,'CUENCA',80),(798,'HUACHOCOLPA',80),(799,'HUAYLLAHUARA',80),(800,'IZCUCHACA',80),(801,'LARIA',80),(802,'MANTA',80),(803,'MARISCAL CACERES',80),(804,'MOYA',80),(805,'NUEVO OCCORO',80),(806,'PALCA',80),(807,'PILCHACA',80),(808,'VILCA',80),(809,'YAULI',80),(810,'ASCENSION',80),(811,'HUANDO',80),(812,'ACOBAMBA',81),(813,'ANDABAMBA',81),(814,'ANTA',81),(815,'CAJA',81),(816,'MARCAS',81),(817,'PAUCARA',81),(818,'POMACOCHA',81),(819,'ROSARIO',81),(820,'LIRCAY',82),(821,'ANCHONGA',82),(822,'CALLANMARCA',82),(823,'CCOCHACCASA',82),(824,'CHINCHO',82),(825,'CONGALLA',82),(826,'HUANCA-HUANCA',82),(827,'HUAYLLAY GRANDE',82),(828,'JULCAMARCA',82),(829,'SAN ANTONIO DE ANTAPARCO',82),(830,'SANTO TOMAS DE PATA',82),(831,'SECCLLA',82),(832,'CASTROVIRREYNA',83),(833,'ARMA',83),(834,'AURAHUA',83),(835,'CAPILLAS',83),(836,'CHUPAMARCA',83),(837,'COCAS',83),(838,'HUACHOS',83),(839,'HUAMATAMBO',83),(840,'MOLLEPAMPA',83),(841,'SAN JUAN',83),(842,'SANTA ANA',83),(843,'TANTARA',83),(844,'TICRAPO',83),(845,'CHURCAMPA',84),(846,'ANCO',84),(847,'CHINCHIHUASI',84),(848,'EL CARMEN',84),(849,'LA MERCED',84),(850,'LOCROJA',84),(851,'PAUCARBAMBA',84),(852,'SAN MIGUEL DE MAYOCC',84),(853,'SAN PEDRO DE CORIS',84),(854,'PACHAMARCA',84),(855,'HUAYTARA',85),(856,'AYAVI',85),(857,'CORDOVA',85),(858,'HUAYACUNDO ARMA',85),(859,'LARAMARCA',85),(860,'OCOYO',85),(861,'PILPICHACA',85),(862,'QUERCO',85),(863,'QUITO-ARMA',85),(864,'SAN ANTONIO DE CUSICANCHA',85),(865,'SAN FRANCISCO DE SANGAYAICO',85),(866,'SAN ISIDRO',85),(867,'SANTIAGO DE CHOCORVOS',85),(868,'SANTIAGO DE QUIRAHUARA',85),(869,'SANTO DOMINGO DE CAPILLAS',85),(870,'TAMBO',85),(871,'PAMPAS',86),(872,'ACOSTAMBO',86),(873,'ACRAQUIA',86),(874,'AHUAYCHA',86),(875,'COLCABAMBA',86),(876,'DANIEL HERNANDEZ',86),(877,'HUACHOCOLPA',86),(878,'HUARIBAMBA',86),(879,'&Ntilde;AHUIMPUQUIO',86),(880,'PAZOS',86),(881,'QUISHUAR',86),(882,'SALCABAMBA',86),(883,'SALCAHUASI',86),(884,'SAN MARCOS DE ROCCHAC',86),(885,'SURCUBAMBA',86),(886,'TINTAY PUNCU',86),(887,'HUANUCO',87),(888,'AMARILIS',87),(889,'CHINCHAO',87),(890,'CHURUBAMBA',87),(891,'MARGOS',87),(892,'QUISQUI',87),(893,'SAN FRANCISCO DE CAYRAN',87),(894,'SAN PEDRO DE CHAULAN',87),(895,'SANTA MARIA DEL VALLE',87),(896,'YARUMAYO',87),(897,'PILLCO MARCA',87),(898,'AMBO',88),(899,'CAYNA',88),(900,'COLPAS',88),(901,'CONCHAMARCA',88),(902,'HUACAR',88),(903,'SAN FRANCISCO',88),(904,'SAN RAFAEL',88),(905,'TOMAY KICHWA',88),(906,'LA UNION',89),(907,'CHUQUIS',89),(908,'MARIAS',89),(909,'PACHAS',89),(910,'QUIVILLA',89),(911,'RIPAN',89),(912,'SHUNQUI',89),(913,'SILLAPATA',89),(914,'YANAS',89),(915,'HUACAYBAMBA',90),(916,'CANCHABAMBA',90),(917,'COCHABAMBA',90),(918,'PINRA',90),(919,'LLATA',91),(920,'ARANCAY',91),(921,'CHAVIN DE PARIARCA',91),(922,'JACAS GRANDE',91),(923,'JIRCAN',91),(924,'MIRAFLORES',91),(925,'MONZON',91),(926,'PUNCHAO',91),(927,'PU&Ntilde;OS',91),(928,'SINGA',91),(929,'TANTAMAYO',91),(930,'RUPA-RUPA',92),(931,'DANIEL ALOMIA ROBLES',92),(932,'HERMILIO VALDIZAN',92),(933,'JOSE CRESPO Y CASTILLO',92),(934,'LUYANDO',92),(935,'MARIANO DAMASO BERAUN',92),(936,'HUACRACHUCO',93),(937,'CHOLON',93),(938,'SAN BUENAVENTURA',93),(939,'PANAO',94),(940,'CHAGLLA',94),(941,'MOLINO',94),(942,'UMARI',94),(943,'PUERTO INCA',95),(944,'CODO DEL POZUZO',95),(945,'HONORIA',95),(946,'TOURNAVISTA',95),(947,'YUYAPICHIS',95),(948,'JESUS',96),(949,'BA&Ntilde;OS',96),(950,'JIVIA',96),(951,'QUEROPALCA',96),(952,'RONDOS',96),(953,'SAN FRANCISCO DE ASIS',96),(954,'SAN MIGUEL DE CAURI',96),(955,'CHAVINILLO',97),(956,'CAHUAC',97),(957,'CHACABAMBA',97),(958,'APARICIO POMARES',97),(959,'JACAS CHICO',97),(960,'OBAS',97),(961,'PAMPAMARCA',97),(962,'CHORAS',97),(963,'ICA',98),(964,'LA TINGUI&Ntilde;A',98),(965,'LOS AQUIJES',98),(966,'OCUCAJE',98),(967,'PACHACUTEC',98),(968,'PARCONA',98),(969,'PUEBLO NUEVO',98),(970,'SALAS',98),(971,'SAN JOSE DE LOS MOLINOS',98),(972,'SAN JUAN BAUTISTA',98),(973,'SANTIAGO',98),(974,'SUBTANJALLA',98),(975,'TATE',98),(976,'YAUCA DEL ROSARIO',98),(977,'CHINCHA ALTA',99),(978,'ALTO LARAN',99),(979,'CHAVIN',99),(980,'CHINCHA BAJA',99),(981,'EL CARMEN',99),(982,'GROCIO PRADO',99),(983,'PUEBLO NUEVO',99),(984,'SAN JUAN DE YANAC',99),(985,'SAN PEDRO DE HUACARPANA',99),(986,'SUNAMPE',99),(987,'TAMBO DE MORA',99),(988,'NAZCA',100),(989,'CHANGUILLO',100),(990,'EL INGENIO',100),(991,'MARCONA',100),(992,'VISTA ALEGRE',100),(993,'PALPA',101),(994,'LLIPATA',101),(995,'RIO GRANDE',101),(996,'SANTA CRUZ',101),(997,'TIBILLO',101),(998,'PISCO',102),(999,'HUANCANO',102),(1000,'HUMAY',102),(1001,'INDEPENDENCIA',102),(1002,'PARACAS',102),(1003,'SAN ANDRES',102),(1004,'SAN CLEMENTE',102),(1005,'TUPAC AMARU INCA',102),(1006,'HUANCAYO',103),(1007,'CARHUACALLANGA',103),(1008,'CHACAPAMPA',103),(1009,'CHICCHE',103),(1010,'CHILCA',103),(1011,'CHONGOS ALTO',103),(1012,'CHUPURO',103),(1013,'COLCA',103),(1014,'CULLHUAS',103),(1015,'EL TAMBO',103),(1016,'HUACRAPUQUIO',103),(1017,'HUALHUAS',103),(1018,'HUANCAN',103),(1019,'HUASICANCHA',103),(1020,'HUAYUCACHI',103),(1021,'INGENIO',103),(1022,'PARIAHUANCA',103),(1023,'PILCOMAYO',103),(1024,'PUCARA',103),(1025,'QUICHUAY',103),(1026,'QUILCAS',103),(1027,'SAN AGUSTIN',103),(1028,'SAN JERONIMO DE TUNAN',103),(1029,'SA&Ntilde;O',103),(1030,'SAPALLANGA',103),(1031,'SICAYA',103),(1032,'SANTO DOMINGO DE ACOBAMBA',103),(1033,'VIQUES',103),(1034,'CONCEPCION',104),(1035,'ACO',104),(1036,'ANDAMARCA',104),(1037,'CHAMBARA',104),(1038,'COCHAS',104),(1039,'COMAS',104),(1040,'HEROINAS TOLEDO',104),(1041,'MANZANARES',104),(1042,'MARISCAL CASTILLA',104),(1043,'MATAHUASI',104),(1044,'MITO',104),(1045,'NUEVE DE JULIO',104),(1046,'ORCOTUNA',104),(1047,'SAN JOSE DE QUERO',104),(1048,'SANTA ROSA DE OCOPA',104),(1049,'CHANCHAMAYO',105),(1050,'PERENE',105),(1051,'PICHANAQUI',105),(1052,'SAN LUIS DE SHUARO',105),(1053,'SAN RAMON',105),(1054,'VITOC',105),(1055,'JAUJA',106),(1056,'ACOLLA',106),(1057,'APATA',106),(1058,'ATAURA',106),(1059,'CANCHAYLLO',106),(1060,'CURICACA',106),(1061,'EL MANTARO',106),(1062,'HUAMALI',106),(1063,'HUARIPAMPA',106),(1064,'HUERTAS',106),(1065,'JANJAILLO',106),(1066,'JULCAN',106),(1067,'LEONOR ORDO&Ntilde;EZ',106),(1068,'LLOCLLAPAMPA',106),(1069,'MARCO',106),(1070,'MASMA',106),(1071,'MASMA CHICCHE',106),(1072,'MOLINOS',106),(1073,'MONOBAMBA',106),(1074,'MUQUI',106),(1075,'MUQUIYAUYO',106),(1076,'PACA',106),(1077,'PACCHA',106),(1078,'PANCAN',106),(1079,'PARCO',106),(1080,'POMACANCHA',106),(1081,'RICRAN',106),(1082,'SAN LORENZO',106),(1083,'SAN PEDRO DE CHUNAN',106),(1084,'SAUSA',106),(1085,'SINCOS',106),(1086,'TUNAN MARCA',106),(1087,'YAULI',106),(1088,'YAUYOS',106),(1089,'JUNIN',107),(1090,'CARHUAMAYO',107),(1091,'ONDORES',107),(1092,'ULCUMAYO',107),(1093,'SATIPO',108),(1094,'COVIRIALI',108),(1095,'LLAYLLA',108),(1096,'MAZAMARI',108),(1097,'PAMPA HERMOSA',108),(1098,'PANGOA',108),(1099,'RIO NEGRO',108),(1100,'RIO TAMBO',108),(1101,'TARMA',109),(1102,'ACOBAMBA',109),(1103,'HUARICOLCA',109),(1104,'HUASAHUASI',109),(1105,'LA UNION',109),(1106,'PALCA',109),(1107,'PALCAMAYO',109),(1108,'SAN PEDRO DE CAJAS',109),(1109,'TAPO',109),(1110,'LA OROYA',110),(1111,'CHACAPALPA',110),(1112,'HUAY-HUAY',110),(1113,'MARCAPOMACOCHA',110),(1114,'MOROCOCHA',110),(1115,'PACCHA',110),(1116,'SANTA BARBARA DE CARHUACAYAN',110),(1117,'SANTA ROSA DE SACCO',110),(1118,'SUITUCANCHA',110),(1119,'YAULI',110),(1120,'CHUPACA',111),(1121,'AHUAC',111),(1122,'CHONGOS BAJO',111),(1123,'HUACHAC',111),(1124,'HUAMANCACA CHICO',111),(1125,'SAN JUAN DE ISCOS',111),(1126,'SAN JUAN DE JARPA',111),(1127,'TRES DE DICIEMBRE',111),(1128,'YANACANCHA',111),(1129,'TRUJILLO',112),(1130,'EL PORVENIR',112),(1131,'FLORENCIA DE MORA',112),(1132,'HUANCHACO',112),(1133,'LA ESPERANZA',112),(1134,'LAREDO',112),(1135,'MOCHE',112),(1136,'POROTO',112),(1137,'SALAVERRY',112),(1138,'SIMBAL',112),(1139,'VICTOR LARCO HERRERA',112),(1140,'ASCOPE',113),(1141,'CHICAMA',113),(1142,'CHOCOPE',113),(1143,'MAGDALENA DE CAO',113),(1144,'PAIJAN',113),(1145,'RAZURI',113),(1146,'SANTIAGO DE CAO',113),(1147,'CASA GRANDE',113),(1148,'BOLIVAR',114),(1149,'BAMBAMARCA',114),(1150,'CONDORMARCA',114),(1151,'LONGOTEA',114),(1152,'UCHUMARCA',114),(1153,'UCUNCHA',114),(1154,'CHEPEN',115),(1155,'PACANGA',115),(1156,'PUEBLO NUEVO',115),(1157,'JULCAN',116),(1158,'CALAMARCA',116),(1159,'CARABAMBA',116),(1160,'HUASO',116),(1161,'OTUZCO',117),(1162,'AGALLPAMPA',117),(1163,'CHARAT',117),(1164,'HUARANCHAL',117),(1165,'LA CUESTA',117),(1166,'MACHE',117),(1167,'PARANDAY',117),(1168,'SALPO',117),(1169,'SINSICAP',117),(1170,'USQUIL',117),(1171,'SAN PEDRO DE LLOC',118),(1172,'GUADALUPE',118),(1173,'JEQUETEPEQUE',118),(1174,'PACASMAYO',118),(1175,'SAN JOSE',118),(1176,'TAYABAMBA',119),(1177,'BULDIBUYO',119),(1178,'CHILLIA',119),(1179,'HUANCASPATA',119),(1180,'HUAYLILLAS',119),(1181,'HUAYO',119),(1182,'ONGON',119),(1183,'PARCOY',119),(1184,'PATAZ',119),(1185,'PIAS',119),(1186,'SANTIAGO DE CHALLAS',119),(1187,'TAURIJA',119),(1188,'URPAY',119),(1189,'HUAMACHUCO',120),(1190,'CHUGAY',120),(1191,'COCHORCO',120),(1192,'CURGOS',120),(1193,'MARCABAL',120),(1194,'SANAGORAN',120),(1195,'SARIN',120),(1196,'SARTIMBAMBA',120),(1197,'SANTIAGO DE CHUCO',121),(1198,'ANGASMARCA',121),(1199,'CACHICADAN',121),(1200,'MOLLEBAMBA',121),(1201,'MOLLEPATA',121),(1202,'QUIRUVILCA',121),(1203,'SANTA CRUZ DE CHUCA',121),(1204,'SITABAMBA',121),(1205,'GRAN CHIMU',122),(1206,'CASCAS',122),(1207,'LUCMA',122),(1208,'MARMOT',122),(1209,'SAYAPULLO',122),(1210,'VIRU',123),(1211,'CHAO',123),(1212,'GUADALUPITO',123),(1213,'CHICLAYO',124),(1214,'CHONGOYAPE',124),(1215,'ETEN',124),(1216,'ETEN PUERTO',124),(1217,'JOSE LEONARDO ORTIZ',124),(1218,'LA VICTORIA',124),(1219,'LAGUNAS',124),(1220,'MONSEFU',124),(1221,'NUEVA ARICA',124),(1222,'OYOTUN',124),(1223,'PICSI',124),(1224,'PIMENTEL',124),(1225,'REQUE',124),(1226,'SANTA ROSA',124),(1227,'SA&Ntilde;A',124),(1228,'CAYALTI',124),(1229,'PATAPO',124),(1230,'POMALCA',124),(1231,'PUCALA',124),(1232,'TUMAN',124),(1233,'FERRE&Ntilde;AFE',125),(1234,'CA&Ntilde;ARIS',125),(1235,'INCAHUASI',125),(1236,'MANUEL ANTONIO MESONES MURO',125),(1237,'PITIPO',125),(1238,'PUEBLO NUEVO',125),(1239,'LAMBAYEQUE',126),(1240,'CHOCHOPE',126),(1241,'ILLIMO',126),(1242,'JAYANCA',126),(1243,'MOCHUMI',126),(1244,'MORROPE',126),(1245,'MOTUPE',126),(1246,'OLMOS',126),(1247,'PACORA',126),(1248,'SALAS',126),(1249,'SAN JOSE',126),(1250,'TUCUME',126),(1251,'LIMA',127),(1252,'ANCON',127),(1253,'ATE',127),(1254,'BARRANCO',127),(1255,'BRE&Ntilde;A',127),(1256,'CARABAYLLO',127),(1257,'CHACLACAYO',127),(1258,'CHORRILLOS',127),(1259,'CIENEGUILLA',127),(1260,'COMAS',127),(1261,'EL AGUSTINO',127),(1262,'INDEPENDENCIA',127),(1263,'JESUS MARIA',127),(1264,'LA MOLINA',127),(1265,'LA VICTORIA',127),(1266,'LINCE',127),(1267,'LOS OLIVOS',127),(1268,'LURIGANCHO',127),(1269,'LURIN',127),(1270,'MAGDALENA DEL MAR',127),(1271,'MAGDALENA VIEJA',127),(1272,'MIRAFLORES',127),(1273,'PACHACAMAC',127),(1274,'PUCUSANA',127),(1275,'PUENTE PIEDRA',127),(1276,'PUNTA HERMOSA',127),(1277,'PUNTA NEGRA',127),(1278,'RIMAC',127),(1279,'SAN BARTOLO',127),(1280,'SAN BORJA',127),(1281,'SAN ISIDRO',127),(1282,'SAN JUAN DE LURIGANCHO',127),(1283,'SAN JUAN DE MIRAFLORES',127),(1284,'SAN LUIS',127),(1285,'SAN MARTIN DE PORRES',127),(1286,'SAN MIGUEL',127),(1287,'SANTA ANITA',127),(1288,'SANTA MARIA DEL MAR',127),(1289,'SANTA ROSA',127),(1290,'SANTIAGO DE SURCO',127),(1291,'SURQUILLO',127),(1292,'VILLA EL SALVADOR',127),(1293,'VILLA MARIA DEL TRIUNFO',127),(1294,'BARRANCA',128),(1295,'PARAMONGA',128),(1296,'PATIVILCA',128),(1297,'SUPE',128),(1298,'SUPE PUERTO',128),(1299,'CAJATAMBO',129),(1300,'COPA',129),(1301,'GORGOR',129),(1302,'HUANCAPON',129),(1303,'MANAS',129),(1304,'CANTA',130),(1305,'ARAHUAY',130),(1306,'HUAMANTANGA',130),(1307,'HUAROS',130),(1308,'LACHAQUI',130),(1309,'SAN BUENAVENTURA',130),(1310,'SANTA ROSA DE QUIVES',130),(1311,'SAN VICENTE DE CA&Ntilde;ETE',131),(1312,'ASIA',131),(1313,'CALANGO',131),(1314,'CERRO AZUL',131),(1315,'CHILCA',131),(1316,'COAYLLO',131),(1317,'IMPERIAL',131),(1318,'LUNAHUANA',131),(1319,'MALA',131),(1320,'NUEVO IMPERIAL',131),(1321,'PACARAN',131),(1322,'QUILMANA',131),(1323,'SAN ANTONIO',131),(1324,'SAN LUIS',131),(1325,'SANTA CRUZ DE FLORES',131),(1326,'ZU&Ntilde;IGA',131),(1327,'HUARAL',132),(1328,'ATAVILLOS ALTO',132),(1329,'ATAVILLOS BAJO',132),(1330,'AUCALLAMA',132),(1331,'CHANCAY',132),(1332,'IHUARI',132),(1333,'LAMPIAN',132),(1334,'PACARAOS',132),(1335,'SAN MIGUEL DE ACOS',132),(1336,'SANTA CRUZ DE ANDAMARCA',132),(1337,'SUMBILCA',132),(1338,'VEINTISIETE DE NOVIEMBRE',132),(1339,'MATUCANA',133),(1340,'ANTIOQUIA',133),(1341,'CALLAHUANCA',133),(1342,'CARAMPOMA',133),(1343,'CHICLA',133),(1344,'CUENCA',133),(1345,'HUACHUPAMPA',133),(1346,'HUANZA',133),(1347,'HUAROCHIRI',133),(1348,'LAHUAYTAMBO',133),(1349,'LANGA',133),(1350,'LARAOS',133),(1351,'MARIATANA',133),(1352,'RICARDO PALMA',133),(1353,'SAN ANDRES DE TUPICOCHA',133),(1354,'SAN ANTONIO',133),(1355,'SAN BARTOLOME',133),(1356,'SAN DAMIAN',133),(1357,'SAN JUAN DE IRIS',133),(1358,'SAN JUAN DE TANTARANCHE',133),(1359,'SAN LORENZO DE QUINTI',133),(1360,'SAN MATEO',133),(1361,'SAN MATEO DE OTAO',133),(1362,'SAN PEDRO DE CASTA',133),(1363,'SAN PEDRO DE HUANCAYRE',133),(1364,'SANGALLAYA',133),(1365,'SANTA CRUZ DE COCACHACRA',133),(1366,'SANTA EULALIA',133),(1367,'SANTIAGO DE ANCHUCAYA',133),(1368,'SANTIAGO DE TUNA',133),(1369,'SANTO DOMINGO DE LOS OLLEROS',133),(1370,'SURCO',133),(1371,'HUACHO',134),(1372,'AMBAR',134),(1373,'CALETA DE CARQUIN',134),(1374,'CHECRAS',134),(1375,'HUALMAY',134),(1376,'HUAURA',134),(1377,'LEONCIO PRADO',134),(1378,'PACCHO',134),(1379,'SANTA LEONOR',134),(1380,'SANTA MARIA',134),(1381,'SAYAN',134),(1382,'VEGUETA',134),(1383,'OYON',135),(1384,'ANDAJES',135),(1385,'CAUJUL',135),(1386,'COCHAMARCA',135),(1387,'NAVAN',135),(1388,'PACHANGARA',135),(1389,'YAUYOS',136),(1390,'ALIS',136),(1391,'AYAUCA',136),(1392,'AYAVIRI',136),(1393,'AZANGARO',136),(1394,'CACRA',136),(1395,'CARANIA',136),(1396,'CATAHUASI',136),(1397,'CHOCOS',136),(1398,'COCHAS',136),(1399,'COLONIA',136),(1400,'HONGOS',136),(1401,'HUAMPARA',136),(1402,'HUANCAYA',136),(1403,'HUANGASCAR',136),(1404,'HUANTAN',136),(1405,'HUA&Ntilde;EC',136),(1406,'LARAOS',136),(1407,'LINCHA',136),(1408,'MADEAN',136),(1409,'MIRAFLORES',136),(1410,'OMAS',136),(1411,'PUTINZA',136),(1412,'QUINCHES',136),(1413,'QUINOCAY',136),(1414,'SAN JOAQUIN',136),(1415,'SAN PEDRO DE PILAS',136),(1416,'TANTA',136),(1417,'TAURIPAMPA',136),(1418,'TOMAS',136),(1419,'TUPE',136),(1420,'VI&Ntilde;AC',136),(1421,'VITIS',136),(1422,'IQUITOS',137),(1423,'ALTO NANAY',137),(1424,'FERNANDO LORES',137),(1425,'INDIANA',137),(1426,'LAS AMAZONAS',137),(1427,'MAZAN',137),(1428,'NAPO',137),(1429,'PUNCHANA',137),(1430,'PUTUMAYO',137),(1431,'TORRES CAUSANA',137),(1432,'BELEN',137),(1433,'SAN JUAN BAUTISTA',137),(1434,'YURIMAGUAS',138),(1435,'BALSAPUERTO',138),(1436,'BARRANCA',138),(1437,'CAHUAPANAS',138),(1438,'JEBEROS',138),(1439,'LAGUNAS',138),(1440,'MANSERICHE',138),(1441,'MORONA',138),(1442,'PASTAZA',138),(1443,'SANTA CRUZ',138),(1444,'TENIENTE CESAR LOPEZ ROJAS',138),(1445,'NAUTA',139),(1446,'PARINARI',139),(1447,'TIGRE',139),(1448,'TROMPETEROS',139),(1449,'URARINAS',139),(1450,'RAMON CASTILLA',140),(1451,'PEBAS',140),(1452,'YAVARI',140),(1453,'SAN PABLO',140),(1454,'REQUENA',141),(1455,'ALTO TAPICHE',141),(1456,'CAPELO',141),(1457,'EMILIO SAN MARTIN',141),(1458,'MAQUIA',141),(1459,'PUINAHUA',141),(1460,'SAQUENA',141),(1461,'SOPLIN',141),(1462,'TAPICHE',141),(1463,'JENARO HERRERA',141),(1464,'YAQUERANA',141),(1465,'CONTAMANA',142),(1466,'INAHUAYA',142),(1467,'PADRE MARQUEZ',142),(1468,'PAMPA HERMOSA',142),(1469,'SARAYACU',142),(1470,'VARGAS GUERRA',142),(1471,'TAMBOPATA',143),(1472,'INAMBARI',143),(1473,'LAS PIEDRAS',143),(1474,'LABERINTO',143),(1475,'MANU',144),(1476,'FITZCARRALD',144),(1477,'MADRE DE DIOS',144),(1478,'HUEPETUHE',144),(1479,'I&Ntilde;APARI',145),(1480,'IBERIA',145),(1481,'TAHUAMANU',145),(1482,'MOQUEGUA',146),(1483,'CARUMAS',146),(1484,'CUCHUMBAYA',146),(1485,'SAMEGUA',146),(1486,'SAN CRISTOBAL',146),(1487,'TORATA',146),(1488,'OMATE',147),(1489,'CHOJATA',147),(1490,'COALAQUE',147),(1491,'ICHU&Ntilde;A',147),(1492,'LA CAPILLA',147),(1493,'LLOQUE',147),(1494,'MATALAQUE',147),(1495,'PUQUINA',147),(1496,'QUINISTAQUILLAS',147),(1497,'UBINAS',147),(1498,'YUNGA',147),(1499,'ILO',148),(1500,'EL ALGARROBAL',148),(1501,'PACOCHA',148),(1502,'CHAUPIMARCA',149),(1503,'HUACHON',149),(1504,'HUARIACA',149),(1505,'HUAYLLAY',149),(1506,'NINACACA',149),(1507,'PALLANCHACRA',149),(1508,'PAUCARTAMBO',149),(1509,'SAN FCO.DE ASIS DE YARUSYACAN',149),(1510,'SIMON BOLIVAR',149),(1511,'TICLACAYAN',149),(1512,'TINYAHUARCO',149),(1513,'VICCO',149),(1514,'YANACANCHA',149),(1515,'YANAHUANCA',150),(1516,'CHACAYAN',150),(1517,'GOYLLARISQUIZGA',150),(1518,'PAUCAR',150),(1519,'SAN PEDRO DE PILLAO',150),(1520,'SANTA ANA DE TUSI',150),(1521,'TAPUC',150),(1522,'VILCABAMBA',150),(1523,'OXAPAMPA',151),(1524,'CHONTABAMBA',151),(1525,'HUANCABAMBA',151),(1526,'PALCAZU',151),(1527,'POZUZO',151),(1528,'PUERTO BERMUDEZ',151),(1529,'VILLA RICA',151),(1530,'PIURA',152),(1531,'CASTILLA',152),(1532,'CATACAOS',152),(1533,'CURA MORI',152),(1534,'EL TALLAN',152),(1535,'LA ARENA',152),(1536,'LA UNION',152),(1537,'LAS LOMAS',152),(1538,'TAMBO GRANDE',152),(1539,'AYABACA',153),(1540,'FRIAS',153),(1541,'JILILI',153),(1542,'LAGUNAS',153),(1543,'MONTERO',153),(1544,'PACAIPAMPA',153),(1545,'PAIMAS',153),(1546,'SAPILLICA',153),(1547,'SICCHEZ',153),(1548,'SUYO',153),(1549,'HUANCABAMBA',154),(1550,'CANCHAQUE',154),(1551,'EL CARMEN DE LA FRONTERA',154),(1552,'HUARMACA',154),(1553,'LALAQUIZ',154),(1554,'SAN MIGUEL DE EL FAIQUE',154),(1555,'SONDOR',154),(1556,'SONDORILLO',154),(1557,'CHULUCANAS',155),(1558,'BUENOS AIRES',155),(1559,'CHALACO',155),(1560,'LA MATANZA',155),(1561,'MORROPON',155),(1562,'SALITRAL',155),(1563,'SAN JUAN DE BIGOTE',155),(1564,'SANTA CATALINA DE MOSSA',155),(1565,'SANTO DOMINGO',155),(1566,'YAMANGO',155),(1567,'PAITA',156),(1568,'AMOTAPE',156),(1569,'ARENAL',156),(1570,'COLAN',156),(1571,'LA HUACA',156),(1572,'TAMARINDO',156),(1573,'VICHAYAL',156),(1574,'SULLANA',157),(1575,'BELLAVISTA',157),(1576,'IGNACIO ESCUDERO',157),(1577,'LANCONES',157),(1578,'MARCAVELICA',157),(1579,'MIGUEL CHECA',157),(1580,'QUERECOTILLO',157),(1581,'SALITRAL',157),(1582,'PARI&Ntilde;AS',158),(1583,'EL ALTO',158),(1584,'LA BREA',158),(1585,'LOBITOS',158),(1586,'LOS ORGANOS',158),(1587,'MANCORA',158),(1588,'SECHURA',159),(1589,'BELLAVISTA DE LA UNION',159),(1590,'BERNAL',159),(1591,'CRISTO NOS VALGA',159),(1592,'VICE',159),(1593,'RINCONADA LLICUAR',159),(1594,'PUNO',160),(1595,'ACORA',160),(1596,'AMANTANI',160),(1597,'ATUNCOLLA',160),(1598,'CAPACHICA',160),(1599,'CHUCUITO',160),(1600,'COATA',160),(1601,'HUATA',160),(1602,'MA&Ntilde;AZO',160),(1603,'PAUCARCOLLA',160),(1604,'PICHACANI',160),(1605,'PLATERIA',160),(1606,'SAN ANTONIO',160),(1607,'TIQUILLACA',160),(1608,'VILQUE',160),(1609,'AZANGARO',161),(1610,'ACHAYA',161),(1611,'ARAPA',161),(1612,'ASILLO',161),(1613,'CAMINACA',161),(1614,'CHUPA',161),(1615,'JOSE DOMINGO CHOQUEHUANCA',161),(1616,'MU&Ntilde;ANI',161),(1617,'POTONI',161),(1618,'SAMAN',161),(1619,'SAN ANTON',161),(1620,'SAN JOSE',161),(1621,'SAN JUAN DE SALINAS',161),(1622,'SANTIAGO DE PUPUJA',161),(1623,'TIRAPATA',161),(1624,'MACUSANI',162),(1625,'AJOYANI',162),(1626,'AYAPATA',162),(1627,'COASA',162),(1628,'CORANI',162),(1629,'CRUCERO',162),(1630,'ITUATA',162),(1631,'OLLACHEA',162),(1632,'SAN GABAN',162),(1633,'USICAYOS',162),(1634,'JULI',163),(1635,'DESAGUADERO',163),(1636,'HUACULLANI',163),(1637,'KELLUYO',163),(1638,'PISACOMA',163),(1639,'POMATA',163),(1640,'ZEPITA',163),(1641,'ILAVE',164),(1642,'CAPAZO',164),(1643,'PILCUYO',164),(1644,'SANTA ROSA',164),(1645,'CONDURIRI',164),(1646,'HUANCANE',165),(1647,'COJATA',165),(1648,'HUATASANI',165),(1649,'INCHUPALLA',165),(1650,'PUSI',165),(1651,'ROSASPATA',165),(1652,'TARACO',165),(1653,'VILQUE CHICO',165),(1654,'LAMPA',166),(1655,'CABANILLA',166),(1656,'CALAPUJA',166),(1657,'NICASIO',166),(1658,'OCUVIRI',166),(1659,'PALCA',166),(1660,'PARATIA',166),(1661,'PUCARA',166),(1662,'SANTA LUCIA',166),(1663,'VILAVILA',166),(1664,'AYAVIRI',167),(1665,'ANTAUTA',167),(1666,'CUPI',167),(1667,'LLALLI',167),(1668,'MACARI',167),(1669,'NU&Ntilde;OA',167),(1670,'ORURILLO',167),(1671,'SANTA ROSA',167),(1672,'UMACHIRI',167),(1673,'MOHO',168),(1674,'CONIMA',168),(1675,'HUAYRAPATA',168),(1676,'TILALI',168),(1677,'PUTINA',169),(1678,'ANANEA',169),(1679,'PEDRO VILCA APAZA',169),(1680,'QUILCAPUNCU',169),(1681,'SINA',169),(1682,'JULIACA',170),(1683,'CABANA',170),(1684,'CABANILLAS',170),(1685,'CARACOTO',170),(1686,'SANDIA',171),(1687,'CUYOCUYO',171),(1688,'LIMBANI',171),(1689,'PATAMBUCO',171),(1690,'PHARA',171),(1691,'QUIACA',171),(1692,'SAN JUAN DEL ORO',171),(1693,'YANAHUAYA',171),(1694,'ALTO INAMBARI',171),(1695,'YUNGUYO',172),(1696,'ANAPIA',172),(1697,'COPANI',172),(1698,'CUTURAPI',172),(1699,'OLLARAYA',172),(1700,'TINICACHI',172),(1701,'UNICACHI',172),(1702,'MOYOBAMBA',173),(1703,'CALZADA',173),(1704,'HABANA',173),(1705,'JEPELACIO',173),(1706,'SORITOR',173),(1707,'YANTALO',173),(1708,'BELLAVISTA',174),(1709,'ALTO BIAVO',174),(1710,'BAJO BIAVO',174),(1711,'HUALLAGA',174),(1712,'SAN PABLO',174),(1713,'SAN RAFAEL',174),(1714,'SAN JOSE DE SISA',175),(1715,'AGUA BLANCA',175),(1716,'SAN MARTIN',175),(1717,'SANTA ROSA',175),(1718,'SHATOJA',175),(1719,'SAPOSOA',176),(1720,'ALTO SAPOSOA',176),(1721,'EL ESLABON',176),(1722,'PISCOYACU',176),(1723,'SACANCHE',176),(1724,'TINGO DE SAPOSOA',176),(1725,'LAMAS',177),(1726,'ALONSO DE ALVARADO',177),(1727,'BARRANQUITA',177),(1728,'CAYNARACHI',177),(1729,'CU&Ntilde;UMBUQUI',177),(1730,'PINTO RECODO',177),(1731,'RUMISAPA',177),(1732,'SAN ROQUE DE CUMBAZA',177),(1733,'SHANAO',177),(1734,'TABALOSOS',177),(1735,'ZAPATERO',177),(1736,'JUANJUI',178),(1737,'CAMPANILLA',178),(1738,'HUICUNGO',178),(1739,'PACHIZA',178),(1740,'PAJARILLO',178),(1741,'PICOTA',179),(1742,'BUENOS AIRES',179),(1743,'CASPISAPA',179),(1744,'PILLUANA',179),(1745,'PUCACACA',179),(1746,'SAN CRISTOBAL',179),(1747,'SAN HILARION',179),(1748,'SHAMBOYACU',179),(1749,'TINGO DE PONASA',179),(1750,'TRES UNIDOS',179),(1751,'RIOJA',180),(1752,'AWAJUN',180),(1753,'ELIAS SOPLIN VARGAS',180),(1754,'NUEVA CAJAMARCA',180),(1755,'PARDO MIGUEL',180),(1756,'POSIC',180),(1757,'SAN FERNANDO',180),(1758,'YORONGOS',180),(1759,'YURACYACU',180),(1760,'TARAPOTO',181),(1761,'ALBERTO LEVEAU',181),(1762,'CACATACHI',181),(1763,'CHAZUTA',181),(1764,'CHIPURANA',181),(1765,'EL PORVENIR',181),(1766,'HUIMBAYOC',181),(1767,'JUAN GUERRA',181),(1768,'LA BANDA DE SHILCAYO',181),(1769,'MORALES',181),(1770,'PAPAPLAYA',181),(1771,'SAN ANTONIO',181),(1772,'SAUCE',181),(1773,'SHAPAJA',181),(1774,'TOCACHE',182),(1775,'NUEVO PROGRESO',182),(1776,'POLVORA',182),(1777,'SHUNTE',182),(1778,'UCHIZA',182),(1779,'TACNA',183),(1780,'ALTO DE LA ALIANZA',183),(1781,'CALANA',183),(1782,'CIUDAD NUEVA',183),(1783,'INCLAN',183),(1784,'PACHIA',183),(1785,'PALCA',183),(1786,'POCOLLAY',183),(1787,'SAMA',183),(1788,'CORONEL GREGORIO ALBARRACIN LANCHIPA',183),(1789,'CANDARAVE',184),(1790,'CAIRANI',184),(1791,'CAMILACA',184),(1792,'CURIBAYA',184),(1793,'HUANUARA',184),(1794,'QUILAHUANI',184),(1795,'LOCUMBA',185),(1796,'ILABAYA',185),(1797,'ITE',185),(1798,'TARATA',186),(1799,'CHUCATAMANI',186),(1800,'ESTIQUE',186),(1801,'ESTIQUE-PAMPA',186),(1802,'SITAJARA',186),(1803,'SUSAPAYA',186),(1804,'TARUCACHI',186),(1805,'TICACO',186),(1806,'TUMBES',187),(1807,'CORRALES',187),(1808,'LA CRUZ',187),(1809,'PAMPAS DE HOSPITAL',187),(1810,'SAN JACINTO',187),(1811,'SAN JUAN DE LA VIRGEN',187),(1812,'ZORRITOS',188),(1813,'CASITAS',188),(1814,'ZARUMILLA',189),(1815,'AGUAS VERDES',189),(1816,'MATAPALO',189),(1817,'PAPAYAL',189),(1818,'CALLERIA',190),(1819,'CAMPOVERDE',190),(1820,'IPARIA',190),(1821,'MASISEA',190),(1822,'YARINACOCHA',190),(1823,'NUEVA REQUENA',190),(1824,'RAYMONDI',191),(1825,'SEPAHUA',191),(1826,'TAHUANIA',191),(1827,'YURUA',191),(1828,'PADRE ABAD',192),(1829,'IRAZOLA',192),(1830,'CURIMANA',192),(1831,'PURUS',193);
/*!40000 ALTER TABLE `ubdistrito` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ubprovincia`
--

DROP TABLE IF EXISTS `ubprovincia`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ubprovincia` (
  `idProv` int(5) NOT NULL DEFAULT 0,
  `provincia` varchar(50) DEFAULT NULL,
  `idDepa` int(5) DEFAULT NULL,
  PRIMARY KEY (`idProv`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ubprovincia`
--

LOCK TABLES `ubprovincia` WRITE;
/*!40000 ALTER TABLE `ubprovincia` DISABLE KEYS */;
INSERT INTO `ubprovincia` VALUES (1,'CHACHAPOYAS ',1),(2,'BAGUA',1),(3,'BONGARA',1),(4,'CONDORCANQUI',1),(5,'LUYA',1),(6,'RODRIGUEZ DE MENDOZA',1),(7,'UTCUBAMBA',1),(8,'HUARAZ',2),(9,'AIJA',2),(10,'ANTONIO RAYMONDI',2),(11,'ASUNCION',2),(12,'BOLOGNESI',2),(13,'CARHUAZ',2),(14,'CARLOS FERMIN FITZCARRALD',2),(15,'CASMA',2),(16,'CORONGO',2),(17,'HUARI',2),(18,'HUARMEY',2),(19,'HUAYLAS',2),(20,'MARISCAL LUZURIAGA',2),(21,'OCROS',2),(22,'PALLASCA',2),(23,'POMABAMBA',2),(24,'RECUAY',2),(25,'SANTA',2),(26,'SIHUAS',2),(27,'YUNGAY',2),(28,'ABANCAY',3),(29,'ANDAHUAYLAS',3),(30,'ANTABAMBA',3),(31,'AYMARAES',3),(32,'COTABAMBAS',3),(33,'CHINCHEROS',3),(34,'GRAU',3),(35,'AREQUIPA',4),(36,'CAMANA',4),(37,'CARAVELI',4),(38,'CASTILLA',4),(39,'CAYLLOMA',4),(40,'CONDESUYOS',4),(41,'ISLAY',4),(42,'LA UNION',4),(43,'HUAMANGA',5),(44,'CANGALLO',5),(45,'HUANCA SANCOS',5),(46,'HUANTA',5),(47,'LA MAR',5),(48,'LUCANAS',5),(49,'PARINACOCHAS',5),(50,'PAUCAR DEL SARA SARA',5),(51,'SUCRE',5),(52,'VICTOR FAJARDO',5),(53,'VILCAS HUAMAN',5),(54,'CAJAMARCA',6),(55,'CAJABAMBA',6),(56,'CELENDIN',6),(57,'CHOTA ',6),(58,'CONTUMAZA',6),(59,'CUTERVO',6),(60,'HUALGAYOC',6),(61,'JAEN',6),(62,'SAN IGNACIO',6),(63,'SAN MARCOS',6),(64,'SAN PABLO',6),(65,'SANTA CRUZ',6),(66,'CALLAO',7),(67,'CUSCO',8),(68,'ACOMAYO',8),(69,'ANTA',8),(70,'CALCA',8),(71,'CANAS',8),(72,'CANCHIS',8),(73,'CHUMBIVILCAS',8),(74,'ESPINAR',8),(75,'LA CONVENCION',8),(76,'PARURO',8),(77,'PAUCARTAMBO',8),(78,'QUISPICANCHI',8),(79,'URUBAMBA',8),(80,'HUANCAVELICA',9),(81,'ACOBAMBA',9),(82,'ANGARAES',9),(83,'CASTROVIRREYNA',9),(84,'CHURCAMPA',9),(85,'HUAYTARA',9),(86,'TAYACAJA',9),(87,'HUANUCO',10),(88,'AMBO',10),(89,'DOS DE MAYO',10),(90,'HUACAYBAMBA',10),(91,'HUAMALIES',10),(92,'LEONCIO PRADO',10),(93,'MARA&Ntilde;ON',10),(94,'PACHITEA',10),(95,'PUERTO INCA',10),(96,'LAURICOCHA',10),(97,'YAROWILCA',10),(98,'ICA',11),(99,'CHINCHA',11),(100,'NAZCA',11),(101,'PALPA',11),(102,'PISCO',11),(103,'HUANCAYO',12),(104,'CONCEPCION',12),(105,'CHANCHAMAYO',12),(106,'JAUJA',12),(107,'JUNIN',12),(108,'SATIPO',12),(109,'TARMA',12),(110,'YAULI',12),(111,'CHUPACA',12),(112,'TRUJILLO',13),(113,'ASCOPE',13),(114,'BOLIVAR',13),(115,'CHEPEN',13),(116,'JULCAN',13),(117,'OTUZCO',13),(118,'PACASMAYO',13),(119,'PATAZ',13),(120,'SANCHEZ CARRION',13),(121,'SANTIAGO DE CHUCO',13),(122,'GRAN CHIMU',13),(123,'VIRU',13),(124,'CHICLAYO',14),(125,'FERRE&Ntilde;AFE',14),(126,'LAMBAYEQUE',14),(127,'LIMA',15),(128,'BARRANCA',15),(129,'CAJATAMBO',15),(130,'CANTA',15),(131,'CA&Ntilde;ETE',15),(132,'HUARAL',15),(133,'HUAROCHIRI',15),(134,'HUAURA',15),(135,'OYON',15),(136,'YAUYOS',15),(137,'MAYNAS',16),(138,'ALTO AMAZONAS',16),(139,'LORETO',16),(140,'MARISCAL RAMON CASTILLA',16),(141,'REQUENA',16),(142,'UCAYALI',16),(143,'TAMBOPATA',17),(144,'MANU',17),(145,'TAHUAMANU',17),(146,'MARISCAL NIETO',18),(147,'GENERAL SANCHEZ CERRO',18),(148,'ILO',18),(149,'PASCO',19),(150,'DANIEL ALCIDES CARRION',19),(151,'OXAPAMPA',19),(152,'PIURA',20),(153,'AYABACA',20),(154,'HUANCABAMBA',20),(155,'MORROPON',20),(156,'PAITA',20),(157,'SULLANA',20),(158,'TALARA',20),(159,'SECHURA',20),(160,'PUNO',21),(161,'AZANGARO',21),(162,'CARABAYA',21),(163,'CHUCUITO',21),(164,'EL COLLAO',21),(165,'HUANCANE',21),(166,'LAMPA',21),(167,'MELGAR',21),(168,'MOHO',21),(169,'SAN ANTONIO DE PUTINA',21),(170,'SAN ROMAN',21),(171,'SANDIA',21),(172,'YUNGUYO',21),(173,'MOYOBAMBA',22),(174,'BELLAVISTA',22),(175,'EL DORADO',22),(176,'HUALLAGA',22),(177,'LAMAS',22),(178,'MARISCAL CACERES',22),(179,'PICOTA',22),(180,'RIOJA',22),(181,'SAN MARTIN',22),(182,'TOCACHE',22),(183,'TACNA',23),(184,'CANDARAVE',23),(185,'JORGE BASADRE',23),(186,'TARATA',23),(187,'TUMBES',24),(188,'CONTRALMIRANTE VILLAR',24),(189,'ZARUMILLA',24),(190,'CORONEL PORTILLO',25),(191,'ATALAYA',25),(192,'PADRE ABAD',25),(193,'PURUS',25);
/*!40000 ALTER TABLE `ubprovincia` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `unidades_medida`
--

DROP TABLE IF EXISTS `unidades_medida`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `unidades_medida` (
  `unimed_codi` int(11) NOT NULL AUTO_INCREMENT,
  `unimed_nombre` varchar(200) NOT NULL DEFAULT '',
  `unimed_estado` int(11) NOT NULL DEFAULT 1,
  `unimed_abreviatura` varchar(45) DEFAULT NULL,
  `unimed_usu_crea` varchar(45) DEFAULT NULL,
  `unimed_usu_modifica` varchar(45) DEFAULT NULL,
  `unimed_usu_activa` varchar(45) DEFAULT NULL,
  `unimed_sunat` varchar(245) DEFAULT NULL,
  PRIMARY KEY (`unimed_codi`),
  UNIQUE KEY `Index_unimed_nombre` (`unimed_nombre`),
  KEY `Index_unimed_estado` (`unimed_estado`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `unidades_medida`
--

LOCK TABLES `unidades_medida` WRITE;
/*!40000 ALTER TABLE `unidades_medida` DISABLE KEYS */;
INSERT INTO `unidades_medida` VALUES (1,'CIENTO',1,'CTO',NULL,'LSANCHEZ',NULL,'CEN'),(2,'MILLAR',1,'MILL',NULL,'LSANCHEZ',NULL,'MLL'),(3,'KILOGRAMO',1,'KG',NULL,'LSANCHEZ',NULL,'KGM'),(4,'LITRO',1,'LT',NULL,NULL,NULL,'LTR'),(5,'UNIDAD',1,'UND',NULL,'LSANCHEZ',NULL,'NIU'),(6,'GALON',1,'GL',NULL,'LSANCHEZ',NULL,'GLI'),(7,'DOCENA',1,'DCNA',NULL,'LSANCHEZ',NULL,'DZN'),(8,'BOLSA',1,'BLS','LSANCHEZ','ROSIMAR',NULL,'BG'),(9,'LATA',1,'LTA','LSANCHEZ','LSANCHEZ',NULL,'CA'),(11,'ROLLO',1,'ROLL','LSANCHEZ','LSANCHEZ',NULL,'CJ'),(12,'VUELTA',1,'VLTA','LSANCHEZ','LSANCHEZ',NULL,'NIU'),(13,'METRO',1,'MT','LSANCHEZ',NULL,NULL,'MTR'),(14,'CAJA',1,'CAJ','etorres','LSANCHEZ',NULL,'BX'),(15,'BOLSA 1Kg.',1,'BLS 1Kg.','LSANCHEZ','LSANCHEZ',NULL,'BG'),(16,'METRO CUBICO',1,'M3','LSANCHEZ','LSANCHEZ',NULL,'MMQ'),(17,'BALDE 4L',1,'BAL4L','LSANCHEZ','LSANCHEZ',NULL,'BJ'),(18,'GALON 4LT',1,'GL 4LT','LSANCHEZ','LSANCHEZ',NULL,'GLI'),(19,'PAR',1,'PAR','LSANCHEZ',NULL,NULL,'PR'),(20,'CAJA 240 UND',1,'CAJ','LSANCHEZ',NULL,NULL,'BX'),(21,'BOLSA 3.8KG',1,'BLS','LSANCHEZ',NULL,NULL,'BG'),(22,'CAJA DE 2UNI',1,'CAJ','ACARRANZA',NULL,NULL,'BX'),(23,'TONELADAS',1,'TN','etorres',NULL,NULL,'TNE'),(24,'GALON 1LT',1,'GAL 1LT','LSANCHEZ','LSANCHEZ',NULL,'GLI'),(25,'BOLSA 5KG',1,'BLS 5KG','LSANCHEZ',NULL,NULL,'BG'),(26,'BOLSA 25KG',1,'BLS 25KG','LSANCHEZ',NULL,NULL,'BG'),(27,'GALON 3LT',1,'GL','LSANCHEZ','LSANCHEZ',NULL,'GLI'),(28,'METRO CUADRADO',1,'M2','LSANCHEZ',NULL,NULL,'MTK'),(29,'BALDE 20L',1,'BAL 20L','LSANCHEZ',NULL,NULL,'BJ'),(30,'BALDE',1,'BALDE','LSANCHEZ',NULL,NULL,'BJ'),(31,'BOLSA 4Kg.',1,'BLS 4KG','LSANCHEZ',NULL,NULL,'BG'),(32,'CONO',1,'CONO','LSANCHEZ',NULL,NULL,'YRD'),(33,'MADEJA',1,'MADEJA','LSANCHEZ',NULL,NULL,'YRD'),(34,'BIDON 5GAL',1,'BIDON 5GAL','LSANCHEZ',NULL,NULL,'GLI'),(35,'BOTELLA',1,'BOTELLA','ROSIMAR',NULL,NULL,'LTR'),(36,'BOTELLA 1/4 LT',1,'BOT','NEPTALI','NEPTALI',NULL,''),(37,'CAJA 20 UNI',1,'CAJ','EESPINOZA1',NULL,NULL,''),(38,'CAJA 30UNIDADES',1,'CAJ','EESPINOZA1',NULL,NULL,''),(39,'CAJA 10 unidades',1,'CAJ','EESPINOZA1',NULL,NULL,''),(40,'PAQUETE 50 HOJAS',1,'NIU','EESPINOZA1',NULL,NULL,'');
/*!40000 ALTER TABLE `unidades_medida` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `usuarios`
--

DROP TABLE IF EXISTS `usuarios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `usuarios` (
  `usu_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `usu_nombre` varchar(45) NOT NULL DEFAULT '',
  `usu_clave` varchar(45) NOT NULL DEFAULT '',
  `usu_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `usu_compras` int(10) unsigned NOT NULL DEFAULT 0,
  `usu_ventas` int(10) unsigned NOT NULL DEFAULT 0,
  `usu_almacen` int(10) unsigned NOT NULL DEFAULT 0,
  `usu_caja` int(10) unsigned NOT NULL DEFAULT 0,
  `usu_configuracion` int(10) unsigned NOT NULL DEFAULT 0,
  `usu_usu_crea` varchar(45) DEFAULT NULL,
  `usu_usu_modifica` varchar(45) DEFAULT NULL,
  `usu_usu_activa` varchar(45) DEFAULT NULL,
  `per_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `usu_tipo` int(10) unsigned NOT NULL DEFAULT 0,
  `usu_acceso_ip` int(10) unsigned NOT NULL DEFAULT 0,
  `usu_ip` varchar(100) DEFAULT NULL,
  `usu_almacen_salidas` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`usu_codi`),
  UNIQUE KEY `Index_usu_nombre` (`usu_nombre`),
  KEY `Index_usu_clave` (`usu_clave`),
  KEY `Index_usu_estado` (`usu_estado`)
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `usuarios`
--

LOCK TABLES `usuarios` WRITE;
/*!40000 ALTER TABLE `usuarios` DISABLE KEYS */;
INSERT INTO `usuarios` VALUES (1,'edtledu','21232f297a57a5a743894a0e4a801fc3',1,1,1,1,1,1,NULL,'etorres',NULL,14,1,3,0,NULL,0),(2,'etorres','a43c27c2babefd68df8a694900f30a1c',1,1,1,1,1,1,NULL,'etorres2',NULL,14,1,3,0,'',1);
/*!40000 ALTER TABLE `usuarios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `vehiculos`
--

DROP TABLE IF EXISTS `vehiculos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `vehiculos` (
  `veh_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `veh_placa` varchar(200) NOT NULL DEFAULT '',
  `veh_marca` varchar(200) NOT NULL DEFAULT '',
  `veh_modelo` varchar(200) NOT NULL DEFAULT '',
  `veh_ano` varchar(145) NOT NULL DEFAULT '',
  `veh_color` varchar(145) NOT NULL DEFAULT '',
  `veh_peso_bruto` float NOT NULL DEFAULT 0,
  `veh_peso_neto` float NOT NULL DEFAULT 0,
  `veh_carga_util` float NOT NULL DEFAULT 0,
  `veh_largo` float NOT NULL DEFAULT 0,
  `veh_alto` float NOT NULL DEFAULT 0,
  `veh_ancho` float NOT NULL DEFAULT 0,
  `veh_usu_crea` varchar(45) NOT NULL DEFAULT '',
  `veh_usu_modifica` varchar(45) NOT NULL DEFAULT '',
  `veh_usu_activa` varchar(45) NOT NULL DEFAULT '',
  `veh_estado` int(10) unsigned NOT NULL DEFAULT 0,
  `traemp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `veh_certificado` varchar(145) NOT NULL,
  PRIMARY KEY (`veh_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `vehiculos`
--

LOCK TABLES `vehiculos` WRITE;
/*!40000 ALTER TABLE `vehiculos` DISABLE KEYS */;
/*!40000 ALTER TABLE `vehiculos` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2021-10-06 10:36:05
