-- MySQL dump 10.16  Distrib 10.1.9-MariaDB, for Win32 (AMD64)
--
-- Host: localhost    Database: saraplast
-- ------------------------------------------------------
-- Server version	10.1.9-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `billetes`
--

DROP TABLE IF EXISTS `billetes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `billetes` (
  `bil_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bil_nombre` varchar(45) NOT NULL DEFAULT '',
  `bil_estado` int(10) unsigned NOT NULL DEFAULT '1',
  `bil_valor` float NOT NULL DEFAULT '0',
  `bil_usu_crea` varchar(45) DEFAULT NULL,
  `bil_usu_modifica` varchar(45) DEFAULT NULL,
  `bil_usu_activa` varchar(45) DEFAULT NULL,
  `bil_orden` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`bil_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `billetes`
--

LOCK TABLES `billetes` WRITE;
/*!40000 ALTER TABLE `billetes` DISABLE KEYS */;
INSERT INTO `billetes` VALUES (1,'200 SOLES',1,200,'etorres','etorres','',1),(2,'100 SOLES',1,100,'etorres','etorres',NULL,2),(3,'50 SOLES',1,50,'etorres','etorres',NULL,3),(4,'20 SOLES',1,20,'etorres','etorres',NULL,4),(5,'10 SOLES',1,10,'etorres','etorres',NULL,5),(6,'5 SOLES',1,5,'etorres','etorres',NULL,6),(7,'2 SOLES',1,2,'etorres','etorres',NULL,7),(8,'1 SOL',1,1,'etorres','etorres',NULL,8),(9,'50 CENTIMOS',1,0.5,'etorres','etorres',NULL,9),(10,'20 CENTIMOS',1,0.2,'etorres','etorres',NULL,10),(11,'10 CENTIMOS',1,0.1,'etorres','etorres',NULL,11),(12,'5 CENTIMOS',1,0.05,'etorres','etorres',NULL,12),(13,'1 CENTIMO',1,0.01,'etorres','etorres',NULL,13);
/*!40000 ALTER TABLE `billetes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `caja`
--

DROP TABLE IF EXISTS `caja`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `caja` (
  `caj_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `caj_fecha` date NOT NULL DEFAULT '0000-00-00',
  `caj_fechahora` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `caj_usu_nombre` varchar(45) NOT NULL DEFAULT '',
  `caj_cerrada` int(10) unsigned NOT NULL DEFAULT '0',
  `caj_anotaciones` text,
  `caj_monto_inicial` float NOT NULL DEFAULT '0',
  `caj_idtrans` varchar(45) DEFAULT NULL,
  `caj_numero` varchar(45) DEFAULT NULL,
  `usu_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  `usu_nombre_fk` varchar(45) NOT NULL DEFAULT '',
  `caj_estado` int(10) unsigned NOT NULL DEFAULT '1',
  `caj_monto_final` float NOT NULL DEFAULT '0',
  `caj_fechahora_cierre` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`caj_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `caja`
--

LOCK TABLES `caja` WRITE;
/*!40000 ALTER TABLE `caja` DISABLE KEYS */;
INSERT INTO `caja` VALUES (1,'2020-12-28','2020-12-28 23:34:52','etorres',0,'',0,'1609216483533723183','CAJA0000001',2,'etorres',1,0,'0000-00-00 00:00:00',1),(2,'2021-01-07','2021-01-07 18:11:09','AAURAZO',1,'',0,'1610061062882022420','CAJA0000002',3,'AAURAZO',1,0,'2021-01-12 18:59:52',1),(3,'2021-01-12','2021-01-12 19:00:06','AAURAZO',1,'',0,'16104959921357523603','CAJA0000003',3,'AAURAZO',1,0,'2021-01-12 19:03:57',1),(4,'2021-01-12','2021-01-12 19:04:06','AAURAZO',1,'',0,'1610496237197774067','CAJA0000004',3,'AAURAZO',1,0,'2021-01-12 19:59:56',1),(5,'2021-01-15','2021-01-15 16:02:02','AAURAZO',1,'',0,'1610744517848629758','CAJA0000005',3,'AAURAZO',1,0,'2021-01-15 18:10:13',1),(6,'2021-01-20','2021-01-20 18:31:17','AAURAZO',1,'',0,'16111854721150024354','CAJA0000006',3,'AAURAZO',1,0,'2021-01-21 17:08:27',1),(7,'2021-01-21','2021-01-21 17:08:37','AAURAZO',1,'',0,'1611266911801251767','CAJA0000007',3,'AAURAZO',1,0,'2021-01-21 18:30:33',1),(8,'2021-01-22','2021-01-22 17:44:04','AAURAZO',1,'',0,'1611355440897341734','CAJA0000008',3,'AAURAZO',1,0,'2021-01-22 18:34:28',1),(9,'2021-01-25','2021-01-25 17:56:03','AAURAZO',1,'',0,'1611615357589191149','CAJA0000009',3,'AAURAZO',1,0,'2021-01-25 18:22:00',1),(10,'2021-01-26','2021-01-26 11:18:35','AAURAZO',1,'',0,'1611677911597367187','CAJA0000010',3,'AAURAZO',1,0,'2021-01-26 18:55:03',1),(11,'2021-01-28','2021-01-28 18:16:24','AAURAZO',1,'',0,'16118757791250632658','CAJA0000011',3,'AAURAZO',1,0,'2021-01-28 19:05:15',1),(12,'2021-01-29','2021-01-29 18:18:02','AAURAZO',1,'',0,'16119622781180749045','CAJA0000012',3,'AAURAZO',1,0,'2021-01-29 19:03:32',1),(13,'2021-01-30','2021-01-30 18:17:48','AAURAZO',1,'',0,'1612048664649048357','CAJA0000013',3,'AAURAZO',1,0,'2021-01-30 18:51:29',1),(14,'2021-02-10','2021-02-10 13:27:20','AAURAZO',1,'',0,'1612981636348127111','CAJA0000014',3,'AAURAZO',1,0,'2021-02-10 18:46:23',1),(15,'2021-02-20','2021-02-20 16:16:54','AAURAZO',1,'',0,'1613855809368696302','CAJA0000015',3,'AAURAZO',1,0,'2021-02-20 16:50:54',1),(16,'2021-02-22','2021-02-22 11:38:20','AAURAZO',1,'',0,'16140118961195551978','CAJA0000016',3,'AAURAZO',1,0,'2021-02-22 18:13:26',1),(17,'2021-02-23','2021-02-23 18:32:56','AAURAZO',1,'',0,'16141231721240520189','CAJA0000017',3,'AAURAZO',1,0,'2021-02-23 19:35:27',1),(18,'2021-02-24','2021-02-24 18:08:10','AAURAZO',1,'',0,'16142080861090468368','CAJA0000018',3,'AAURAZO',1,0,'2021-02-24 18:40:56',1),(19,'2021-02-25','2021-02-25 18:10:55','AAURAZO',1,'',0,'16142946511305971529','CAJA0000019',3,'AAURAZO',1,0,'2021-02-25 19:35:24',1),(20,'2021-02-26','2021-02-26 11:16:20','AAURAZO',1,'',0,'1614356175893210683','CAJA0000020',3,'AAURAZO',1,0,'2021-02-26 19:37:37',1),(21,'2021-02-27','2021-02-27 14:29:00','AAURAZO',1,'',0,'1614454136244248391','CAJA0000021',3,'AAURAZO',1,0,'2021-02-27 15:32:18',1),(22,'2021-03-15','2021-03-15 19:07:17','AAURAZO',1,'',0,'16158532321128379368','CAJA0000022',3,'AAURAZO',1,0,'2021-03-15 19:15:36',1),(23,'2021-03-15','2021-03-15 19:15:59','AAURAZO',1,'',0,'1615853753288140808','CAJA0000023',3,'AAURAZO',1,0,'2021-03-15 19:28:14',1),(24,'2021-03-18','2021-03-18 18:22:41','AAURAZO',1,'',0,'1616109756431006321','CAJA0000024',3,'AAURAZO',1,0,'2021-03-18 18:37:41',1),(25,'2021-03-25','2021-03-25 18:32:15','AAURAZO',1,'',0,'1616715130852588682','CAJA0000025',3,'AAURAZO',1,0,'2021-03-25 19:51:19',1),(26,'2021-03-29','2021-03-29 18:06:59','AAURAZO',1,'',0,'16170592151115900151','CAJA0000026',3,'AAURAZO',1,0,'2021-03-29 18:36:52',1),(27,'2021-03-31','2021-03-31 16:19:51','AAURAZO',1,'',0,'1617225586845015088','CAJA0000027',3,'AAURAZO',1,0,'2021-03-31 16:46:54',1),(28,'2021-04-16','2021-04-16 18:16:52','AAURAZO',1,'',0,'1618615008171653776','CAJA0000028',3,'AAURAZO',1,0,'2021-04-23 18:09:28',1),(29,'2021-04-23','2021-04-23 18:12:15','AAURAZO',1,'',0,'16192195301025447347','CAJA0000029',3,'AAURAZO',1,0,'2021-04-23 18:46:00',1),(30,'2021-04-26','2021-04-26 18:32:15','AAURAZO',1,'',0,'161947993159555986','CAJA0000030',3,'AAURAZO',1,0,'2021-04-26 19:06:17',1),(31,'2021-04-27','2021-04-27 18:17:22','AAURAZO',1,'',0,'1619565438481912918','CAJA0000031',3,'AAURAZO',1,0,'2021-04-27 18:47:52',1),(32,'2021-04-29','2021-04-29 13:33:20','AAURAZO',1,'',0,'16197211951330886930','CAJA0000032',3,'AAURAZO',1,0,'2021-04-29 13:51:48',1),(33,'2021-04-30','2021-04-30 18:32:22','AAURAZO',1,'',0,'16198255381220811634','CAJA0000033',3,'AAURAZO',1,0,'2021-04-30 19:29:55',1),(34,'2021-05-04','2021-05-04 17:28:47','AAURAZO',1,'',0,'1620167322556271836','CAJA0000034',3,'AAURAZO',1,0,'2021-05-04 18:20:37',1),(35,'2021-05-11','2021-05-11 18:38:45','AAURAZO',1,'',0,'1620776320302341295','CAJA0000035',3,'AAURAZO',1,0,'2021-05-11 19:43:45',1),(36,'2021-05-19','2021-05-19 14:28:34','AAURAZO',1,'',0,'1621452497305998997','CAJA0000036',3,'AAURAZO',1,0,'2021-05-21 19:00:19',1),(37,'2021-05-21','2021-05-21 19:00:56','AAURAZO',1,'',0,'16216416531078161279','CAJA0000037',3,'AAURAZO',1,0,'2021-05-21 19:37:24',1),(38,'2021-05-22','2021-05-22 18:17:36','AAURAZO',1,'',0,'1621725450924968138','CAJA0000038',3,'AAURAZO',1,0,'2021-05-22 18:50:32',1),(39,'2021-05-24','2021-05-24 18:51:55','AAURAZO',1,'',0,'162190031061406352','CAJA0000039',3,'AAURAZO',1,0,'2021-05-24 19:28:39',1),(40,'2021-05-26','2021-05-26 11:42:04','AAURAZO',1,'',0,'16220473201056989643','CAJA0000040',3,'AAURAZO',1,0,'2021-05-26 13:44:11',1),(41,'2021-05-27','2021-05-27 15:37:58','AAURAZO',1,'',0,'1622147874325664521','CAJA0000041',3,'AAURAZO',1,0,'2021-05-27 18:30:06',1),(42,'2021-05-27','2021-05-27 18:31:03','AAURAZO',1,'',0,'16221582521110865433','CAJA0000042',3,'AAURAZO',1,0,'2021-05-27 18:31:14',1),(43,'2021-05-27','2021-05-27 18:31:22','AAURAZO',1,'',0,'1622158274371966717','CAJA0000043',3,'AAURAZO',1,0,'2021-05-27 18:57:40',1),(44,'2021-05-29','2021-05-29 18:12:04','AAURAZO',1,'',0,'1622329920881936357','CAJA0000044',3,'AAURAZO',1,0,'2021-05-29 19:02:28',1),(45,'2021-06-14','2021-06-14 19:03:00','AAURAZO',1,'',0,'1623715376749785756','CAJA0000045',3,'AAURAZO',1,0,'2021-06-14 19:33:58',1),(46,'2021-06-18','2021-06-18 19:12:51','AAURAZO',1,'',0,'1624061566168082138','CAJA0000046',3,'AAURAZO',1,0,'2021-06-18 19:48:59',1),(47,'2021-06-21','2021-06-21 19:19:15','AAURAZO',1,'',0,'1624321152887401393','CAJA0000047',3,'AAURAZO',1,0,'2021-06-21 19:50:23',1),(48,'2021-06-24','2021-06-24 19:07:56','AAURAZO',1,'',0,'16245796721361740717','CAJA0000048',3,'AAURAZO',1,0,'2021-06-24 20:29:52',1),(49,'2021-06-25','2021-06-25 22:45:35','AAURAZO',1,'',0,'1624679130889122664','CAJA0000049',3,'AAURAZO',1,0,'2021-06-25 23:14:27',1),(50,'2021-06-28','2021-06-28 22:42:06','AAURAZO',1,'',0,'16249381221211215546','CAJA0000050',3,'AAURAZO',1,0,'2021-06-29 19:45:11',1),(51,'2021-06-29','2021-06-29 19:45:39','AAURAZO',1,'',0,'1625013935532561325','CAJA0000051',3,'AAURAZO',1,0,'2021-06-29 20:41:03',1),(52,'2021-06-30','2021-06-30 18:33:22','AAURAZO',1,'',0,'16250959971028588667','CAJA0000052',3,'AAURAZO',1,0,'2021-06-30 19:54:57',1),(53,'2021-07-29','2021-07-29 19:16:53','AAURAZO',1,'',0,'1627604209433889451','CAJA0000053',3,'AAURAZO',1,0,'2021-07-29 19:29:35',1),(54,'2021-07-30','2021-07-30 22:15:09','AAURAZO',1,'',0,'16277013051346249276','CAJA0000054',3,'AAURAZO',1,0,'2021-07-30 22:46:46',1),(55,'2021-07-31','2021-07-31 23:07:16','AAURAZO',1,'',0,'1627790831814505555','CAJA0000055',3,'AAURAZO',1,0,'2021-08-24 21:40:57',1),(56,'2021-08-24','2021-08-24 21:42:33','AAURAZO',1,'',0,'1629859349545556923','CAJA0000056',3,'AAURAZO',1,0,'2021-08-24 22:17:10',1),(57,'2021-08-26','2021-08-26 18:56:34','AAURAZO',1,'',0,'1630022189306171124','CAJA0000057',3,'AAURAZO',1,0,'2021-08-26 19:57:17',1),(58,'2021-08-31','2021-08-31 21:06:43','AAURAZO',1,'',0,'1630461998336035180','CAJA0000058',3,'AAURAZO',1,0,'2021-08-31 22:28:34',1),(59,'2021-09-16','2021-09-16 19:58:28','AAURAZO',1,'',0,'1631840304535745677','CAJA0000059',3,'AAURAZO',1,0,'2021-09-22 23:27:20',1),(60,'2021-09-23','2021-09-23 22:05:35','AAURAZO',1,'',0,'16324527311263714320','CAJA0000060',3,'AAURAZO',1,0,'2021-09-23 23:04:12',1),(61,'2021-09-30','2021-09-30 23:26:01','AAURAZO',1,'',0,'16330623551111855164','CAJA0000061',3,'AAURAZO',1,0,'2021-10-01 00:32:06',1),(62,'2021-10-25','2021-10-25 19:57:25','AAURAZO',1,'',0,'1635209840964084027','CAJA0000062',3,'AAURAZO',1,0,'2021-10-25 22:15:24',1),(63,'2021-10-29','2021-10-29 21:38:25','AAURAZO',1,'',0,'163556150158480191','CAJA0000063',3,'AAURAZO',1,0,'2021-10-31 21:08:15',1);
/*!40000 ALTER TABLE `caja` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `caja_detalle`
--

DROP TABLE IF EXISTS `caja_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `caja_detalle` (
  `cajdet_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `caj_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  `bil_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  `cantidad_billetes` int(10) unsigned NOT NULL DEFAULT '0',
  `cajdet_apertura_cierre` varchar(10) DEFAULT NULL,
  `cajdet_monto` float NOT NULL DEFAULT '0',
  PRIMARY KEY (`cajdet_codi`),
  KEY `FK_caja_detalle_1` (`caj_codi_fk`),
  KEY `FK_caja_detalle_2` (`bil_codi_fk`),
  CONSTRAINT `FK_caja_detalle_1` FOREIGN KEY (`caj_codi_fk`) REFERENCES `caja` (`caj_codi`),
  CONSTRAINT `FK_caja_detalle_2` FOREIGN KEY (`bil_codi_fk`) REFERENCES `billetes` (`bil_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `caja_detalle`
--

LOCK TABLES `caja_detalle` WRITE;
/*!40000 ALTER TABLE `caja_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `caja_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `comprobante_serie`
--

DROP TABLE IF EXISTS `comprobante_serie`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `comprobante_serie` (
  `comser_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `comtip_codigo_fk` varchar(45) NOT NULL DEFAULT '',
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  `comser_serie` char(4) CHARACTER SET ucs2 NOT NULL DEFAULT '',
  `comser_correlativo` int(10) unsigned NOT NULL DEFAULT '0',
  `comser_estado` int(10) unsigned NOT NULL DEFAULT '1',
  `comser_usu_crea` varchar(45) DEFAULT NULL,
  `comser_usu_modifica` varchar(45) DEFAULT NULL,
  `comser_usu_activa` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`comser_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `comprobante_serie`
--

LOCK TABLES `comprobante_serie` WRITE;
/*!40000 ALTER TABLE `comprobante_serie` DISABLE KEYS */;
INSERT INTO `comprobante_serie` VALUES (9,'01',1,'F001',33,1,'','etorres',NULL),(10,'03',1,'B001',1585,1,'','etorres',NULL),(11,'07',1,'F001',3,1,'','etorres',NULL),(12,'07',1,'B001',2,1,'',NULL,NULL);
/*!40000 ALTER TABLE `comprobante_serie` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `comprobante_tipo`
--

DROP TABLE IF EXISTS `comprobante_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `comprobante_tipo` (
  `comtip_codigo` char(2) NOT NULL DEFAULT '',
  `comtip_nombre` varchar(45) NOT NULL DEFAULT '',
  PRIMARY KEY (`comtip_codigo`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `comprobante_tipo`
--

LOCK TABLES `comprobante_tipo` WRITE;
/*!40000 ALTER TABLE `comprobante_tipo` DISABLE KEYS */;
INSERT INTO `comprobante_tipo` VALUES ('01','FACTURA'),('03','BOLETA'),('07','NOTA DE CREDITO'),('08','NOTA DE DEBITO');
/*!40000 ALTER TABLE `comprobante_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `configuraciones`
--

DROP TABLE IF EXISTS `configuraciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `configuraciones` (
  `con_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `con_igv` float DEFAULT NULL,
  `con_dolar` float DEFAULT NULL,
  `con_pagocompra` int(10) unsigned DEFAULT NULL,
  `con_cobropedido` int(10) unsigned DEFAULT NULL,
  `con_aperturacaja` int(10) unsigned DEFAULT NULL,
  `con_cierrecaja` int(10) unsigned DEFAULT NULL,
  `con_usu_modifica` varchar(45) DEFAULT NULL,
  `con_mediopago` int(11) unsigned DEFAULT NULL,
  `con_operaciontipo` int(11) unsigned DEFAULT NULL,
  `con_documentotipo` int(11) unsigned DEFAULT NULL,
  `con_operaciontipo_compra` int(10) unsigned DEFAULT NULL,
  `con_documentotipo_compra` int(10) unsigned DEFAULT NULL,
  `con_token` varchar(45) NOT NULL,
  PRIMARY KEY (`con_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `configuraciones`
--

LOCK TABLES `configuraciones` WRITE;
/*!40000 ALTER TABLE `configuraciones` DISABLE KEYS */;
INSERT INTO `configuraciones` VALUES (1,18,3.63,12,11,13,14,'etorres',1,4,11,1,10,'SARAPLAST2020');
/*!40000 ALTER TABLE `configuraciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `correlativos`
--

DROP TABLE IF EXISTS `correlativos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `correlativos` (
  `cor_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cor_pedido` int(10) unsigned NOT NULL DEFAULT '0',
  `cor_compra` int(10) unsigned NOT NULL DEFAULT '0',
  `cor_almacen` int(10) unsigned NOT NULL DEFAULT '0',
  `cor_caja` int(10) unsigned NOT NULL DEFAULT '0',
  `cor_caja_cierre` int(10) unsigned NOT NULL DEFAULT '0',
  `cor_cotizacion` int(10) unsigned NOT NULL DEFAULT '0',
  `cor_persona` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cor_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `correlativos`
--

LOCK TABLES `correlativos` WRITE;
/*!40000 ALTER TABLE `correlativos` DISABLE KEYS */;
INSERT INTO `correlativos` VALUES (1,1617,1,1617,1617,64,1,120);
/*!40000 ALTER TABLE `correlativos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cotizaciones`
--

DROP TABLE IF EXISTS `cotizaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cotizaciones` (
  `cot_codi` int(11) NOT NULL AUTO_INCREMENT,
  `cot_fecha` date DEFAULT NULL,
  `cot_numero` varchar(45) DEFAULT NULL,
  `per_codi_fk` int(11) DEFAULT NULL,
  `cot_estado` int(11) NOT NULL DEFAULT '1',
  `cot_fechahora` datetime DEFAULT NULL,
  `cot_anotaciones` text,
  `cot_usu_crea` varchar(45) NOT NULL DEFAULT '',
  `cot_usu_modifica` varchar(45) NOT NULL DEFAULT '',
  `cot_usu_activa` varchar(45) NOT NULL DEFAULT '',
  `idtrans` varchar(45) DEFAULT NULL,
  `cot_situacion` int(10) unsigned NOT NULL DEFAULT '0',
  `cot_igv_porcentaje` float NOT NULL DEFAULT '18',
  `cot_dias` int(11) NOT NULL DEFAULT '5',
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cot_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cotizaciones`
--

LOCK TABLES `cotizaciones` WRITE;
/*!40000 ALTER TABLE `cotizaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `cotizaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cotizaciones_detalle`
--

DROP TABLE IF EXISTS `cotizaciones_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cotizaciones_detalle` (
  `cotdet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `cotdet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `cotdet_precio` float NOT NULL DEFAULT '0',
  `cotdet_cantidad` float NOT NULL DEFAULT '0',
  `cot_codi_fk` int(11) NOT NULL DEFAULT '0',
  `idtrans` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`cotdet_codi`),
  KEY `fk_cotizaciones_detalle_cotizaciones1_idx` (`cot_codi_fk`),
  KEY `fk_cotizaciones_detalle_productos1_idx` (`prd_codi_fk`),
  KEY `fk_cotizaciones_detalle_unidades_medida1_idx` (`unimed_codi_fk`),
  CONSTRAINT `fk_cotizaciones_detalle_cotizaciones1` FOREIGN KEY (`cot_codi_fk`) REFERENCES `cotizaciones` (`cot_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_cotizaciones_detalle_productos1` FOREIGN KEY (`prd_codi_fk`) REFERENCES `productos` (`prd_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_cotizaciones_detalle_unidades_medida1` FOREIGN KEY (`unimed_codi_fk`) REFERENCES `unidades_medida` (`unimed_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cotizaciones_detalle`
--

LOCK TABLES `cotizaciones_detalle` WRITE;
/*!40000 ALTER TABLE `cotizaciones_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `cotizaciones_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cuotas`
--

DROP TABLE IF EXISTS `cuotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cuotas` (
  `cuo_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ordcom_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  `cuo_fechahora` datetime DEFAULT NULL,
  `cuo_fecha_cuota` date DEFAULT NULL,
  `cuo_monto` float NOT NULL DEFAULT '0',
  `cuo_estado_pago` int(10) unsigned NOT NULL DEFAULT '0',
  `cuo_estado` int(10) unsigned NOT NULL DEFAULT '0',
  `cuo_tipo` varchar(45) NOT NULL DEFAULT 'CUOTA',
  `cuo_descripcion` text,
  PRIMARY KEY (`cuo_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cuotas`
--

LOCK TABLES `cuotas` WRITE;
/*!40000 ALTER TABLE `cuotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `cuotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `direcciones`
--

DROP TABLE IF EXISTS `direcciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `direcciones` (
  `dir_codi` int(11) NOT NULL AUTO_INCREMENT,
  `dir_descripcion` longtext NOT NULL,
  `dir_detalle` longtext,
  `dir_estado` int(11) NOT NULL DEFAULT '1',
  `dirtip_codi_fk` int(11) NOT NULL,
  `per_codi_fk` int(11) NOT NULL,
  PRIMARY KEY (`dir_codi`),
  KEY `fk_direcciones_direcciones_tipo1_idx` (`dirtip_codi_fk`),
  KEY `fk_direcciones_personas1_idx` (`per_codi_fk`),
  CONSTRAINT `fk_direcciones_direcciones_tipo1` FOREIGN KEY (`dirtip_codi_fk`) REFERENCES `direcciones_tipo` (`dirtip_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_direcciones_personas1` FOREIGN KEY (`per_codi_fk`) REFERENCES `personas` (`per_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `direcciones`
--

LOCK TABLES `direcciones` WRITE;
/*!40000 ALTER TABLE `direcciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `direcciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `direcciones_tipo`
--

DROP TABLE IF EXISTS `direcciones_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `direcciones_tipo` (
  `dirtip_codi` int(11) NOT NULL AUTO_INCREMENT,
  `dirtip_nombre` varchar(80) NOT NULL,
  `dirtip_estado` varchar(45) NOT NULL DEFAULT '1',
  PRIMARY KEY (`dirtip_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `direcciones_tipo`
--

LOCK TABLES `direcciones_tipo` WRITE;
/*!40000 ALTER TABLE `direcciones_tipo` DISABLE KEYS */;
INSERT INTO `direcciones_tipo` VALUES (1,'COMERCIAL','1'),(2,'VIVIENDA','1'),(3,'DESPACHO','1');
/*!40000 ALTER TABLE `direcciones_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `documento_pago`
--

DROP TABLE IF EXISTS `documento_pago`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documento_pago` (
  `docpag_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `docpag_nombre` varchar(45) NOT NULL DEFAULT '',
  `docpag_estado` int(10) unsigned NOT NULL DEFAULT '1',
  `comtip_codigo_fk` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`docpag_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documento_pago`
--

LOCK TABLES `documento_pago` WRITE;
/*!40000 ALTER TABLE `documento_pago` DISABLE KEYS */;
INSERT INTO `documento_pago` VALUES (1,'NOTA DE VENTA',1,'00'),(2,'BOLETA',1,'03'),(3,'FACTURA',1,'01');
/*!40000 ALTER TABLE `documento_pago` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `documento_tipo`
--

DROP TABLE IF EXISTS `documento_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documento_tipo` (
  `doctip_codi` int(11) NOT NULL AUTO_INCREMENT,
  `doctip_nombre` varchar(145) DEFAULT NULL,
  `doctip_estado` int(11) NOT NULL DEFAULT '1',
  `doctip_abreviatura` varchar(45) DEFAULT NULL,
  `doctip_usu_crea` varchar(45) DEFAULT NULL,
  `doctip_usu_modifica` varchar(45) DEFAULT NULL,
  `doctip_usu_activa` varchar(45) DEFAULT NULL,
  `doctip_documentado` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`doctip_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documento_tipo`
--

LOCK TABLES `documento_tipo` WRITE;
/*!40000 ALTER TABLE `documento_tipo` DISABLE KEYS */;
INSERT INTO `documento_tipo` VALUES (1,'FACTURA',1,'',NULL,NULL,NULL,1),(2,'BOLETA',1,'BOL',NULL,NULL,NULL,1),(3,'RECIBO',1,NULL,NULL,NULL,NULL,0),(4,'GUIA DE REMISION',1,'',NULL,'etorres',NULL,0),(5,'NOTA DE CREDITO',1,NULL,NULL,NULL,NULL,0),(6,'NOTA DE DEBITO',1,NULL,NULL,NULL,NULL,0),(7,'BOLETO DE DEPOSITO',1,NULL,NULL,NULL,NULL,0),(8,'CHEQUE',1,NULL,NULL,NULL,NULL,0),(9,'PAGARE',1,NULL,NULL,NULL,NULL,0),(10,'ORDEN DE COMPRA',1,NULL,NULL,NULL,NULL,0),(11,'ORDEN DE PEDIDO',1,NULL,NULL,NULL,NULL,0),(12,'NOTA DE VENTA',1,NULL,NULL,NULL,NULL,0);
/*!40000 ALTER TABLE `documento_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `empresas`
--

DROP TABLE IF EXISTS `empresas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `empresas` (
  `emp_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `emp_nom` varchar(45) NOT NULL DEFAULT '',
  `emp_estado` int(10) unsigned NOT NULL DEFAULT '1',
  `emp_direccion` text,
  `emp_telefono` varchar(45) DEFAULT NULL,
  `emp_ciudad` varchar(45) DEFAULT NULL,
  `emp_usu_crea` varchar(45) DEFAULT NULL,
  `emp_usu_modifica` varchar(45) DEFAULT NULL,
  `emp_usu_activa` varchar(45) DEFAULT NULL,
  `emprai_codi_fk` int(11) NOT NULL DEFAULT '0',
  `emp_exonerado_igv` varchar(45) NOT NULL DEFAULT '0',
  PRIMARY KEY (`emp_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `empresas`
--

LOCK TABLES `empresas` WRITE;
/*!40000 ALTER TABLE `empresas` DISABLE KEYS */;
INSERT INTO `empresas` VALUES (1,'SARA PLAST 1',1,'AV. BOLIVAR NRO. 415 LAMBAYEQUE - CHICLAYO - JOSE LEONARDO ORTIZ','','JOSE LEONARDO ORTIZ','etorres','etorres',NULL,1,'');
/*!40000 ALTER TABLE `empresas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `empresas_raiz`
--

DROP TABLE IF EXISTS `empresas_raiz`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `empresas_raiz` (
  `emprai_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `emprai_razon_social` varchar(240) NOT NULL DEFAULT '',
  `emprai_nombre_comercial` varchar(240) NOT NULL DEFAULT '',
  `emprai_ruc` varchar(45) NOT NULL DEFAULT '',
  `emprai_estado` int(10) unsigned NOT NULL DEFAULT '0',
  `emprai_facturacion_electronica` int(10) unsigned NOT NULL DEFAULT '0',
  `emprai_direccion` varchar(245) NOT NULL DEFAULT '',
  `emprai_web` varchar(245) NOT NULL,
  `emprai_email` varchar(245) NOT NULL,
  PRIMARY KEY (`emprai_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `empresas_raiz`
--

LOCK TABLES `empresas_raiz` WRITE;
/*!40000 ALTER TABLE `empresas_raiz` DISABLE KEYS */;
INSERT INTO `empresas_raiz` VALUES (1,'SARA PLAST S.A.C.','SARA PLAST S.A.C.','20601804418',1,1,'AV. BOLIVAR NRO. 415 LAMBAYEQUE - CHICLAYO - JOSE LEONARDO ORTIZ','','');
/*!40000 ALTER TABLE `empresas_raiz` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `guia_remision`
--

DROP TABLE IF EXISTS `guia_remision`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `guia_remision` (
  `gui_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gui_nro_comprobante` varchar(45) NOT NULL DEFAULT '',
  `tra_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  `traemp_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  `gui_fecha_emision` date NOT NULL DEFAULT '0000-00-00',
  `gui_fecha_traslado` date NOT NULL DEFAULT '0000-00-00',
  `gui_punto_partida` varchar(245) NOT NULL DEFAULT '',
  `gui_punto_llegada` varchar(245) NOT NULL DEFAULT '',
  `gui_destinatario` varchar(245) NOT NULL DEFAULT '',
  `mot_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  `opealm_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  `gui_marca_placa` varchar(245) NOT NULL DEFAULT '',
  `gui_observacion` varchar(245) NOT NULL DEFAULT '',
  PRIMARY KEY (`gui_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `guia_remision`
--

LOCK TABLES `guia_remision` WRITE;
/*!40000 ALTER TABLE `guia_remision` DISABLE KEYS */;
/*!40000 ALTER TABLE `guia_remision` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `marcas`
--

DROP TABLE IF EXISTS `marcas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `marcas` (
  `mar_codi` int(11) NOT NULL AUTO_INCREMENT,
  `mar_nombre` varchar(45) NOT NULL,
  `mar_estado` int(11) NOT NULL DEFAULT '1',
  `mar_abreviatura` varchar(45) DEFAULT NULL,
  `mar_usu_crea` varchar(45) DEFAULT NULL,
  `mar_usu_modifica` varchar(45) DEFAULT NULL,
  `mar_usu_activa` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`mar_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `marcas`
--

LOCK TABLES `marcas` WRITE;
/*!40000 ALTER TABLE `marcas` DISABLE KEYS */;
INSERT INTO `marcas` VALUES (1,'ASS',1,NULL,NULL,NULL,NULL),(2,'DALMATA',1,'',NULL,'AAURAZO',NULL),(3,'CASER',1,NULL,NULL,NULL,NULL),(4,'CHISMOSITA',1,NULL,NULL,NULL,NULL),(5,'CONOS',1,NULL,NULL,NULL,NULL),(6,'DOUCIL',1,'',NULL,'AAURAZO',NULL),(7,'ELEFANTE',1,NULL,NULL,NULL,NULL),(8,'ELITE',1,NULL,NULL,NULL,NULL),(9,'FIESTA',1,NULL,NULL,NULL,NULL),(10,'FIRME',1,NULL,NULL,NULL,NULL),(11,'FRAMON',1,NULL,NULL,NULL,NULL),(12,'LA SUPER',1,NULL,NULL,NULL,NULL),(13,'LUCERITO',1,NULL,NULL,NULL,NULL),(14,'MANANTIAL',1,NULL,NULL,NULL,NULL),(15,'MATIC',1,NULL,NULL,NULL,NULL),(16,'MONTENEGRO',1,NULL,NULL,NULL,NULL),(17,'NOBLE',1,NULL,NULL,NULL,NULL),(18,'OBAPLAST',1,NULL,NULL,NULL,NULL),(19,'PALMERA',1,NULL,NULL,NULL,NULL),(20,'PAMOLSA',1,NULL,NULL,NULL,NULL),(21,'PB',1,NULL,NULL,NULL,NULL),(22,'PLARESA',1,NULL,NULL,NULL,NULL),(23,'PLASTICAR',1,NULL,NULL,NULL,NULL),(24,'PLASTIMIQ',1,'',NULL,'AAURAZO',NULL),(25,'REAL',1,NULL,NULL,NULL,NULL),(26,'SANTA MARTHA',1,NULL,NULL,NULL,NULL),(27,'SHIRT',1,NULL,NULL,NULL,NULL),(28,'SINCOMENTARIOS',1,'',NULL,'AAURAZO',NULL),(29,'SM',1,NULL,NULL,NULL,NULL),(30,'VTM',1,NULL,NULL,NULL,NULL),(31,'OCTAVIO',1,'','AAURAZO',NULL,NULL),(32,'SM',1,'','AAURAZO',NULL,NULL),(33,'AMABLE',1,'','AAURAZO',NULL,NULL),(34,'RANGO',1,'','AAURAZO',NULL,NULL),(35,'CASUARINAS',1,'','AAURAZO','AAURAZO',NULL),(36,'ALFA',1,'','AAURAZO',NULL,NULL),(37,'BRILLO',1,'','AAURAZO',NULL,NULL),(38,'LIZ',1,'','AAURAZO',NULL,NULL),(39,'CASERITA',1,'','AAURAZO',NULL,NULL),(40,'PARAISO',1,'','AAURAZO',NULL,NULL),(41,'CRISTALES',1,'','AAURAZO',NULL,NULL),(42,'TOTUS',1,'','AAURAZO',NULL,NULL),(43,'PACIFICO',1,'','AAURAZO',NULL,NULL),(44,'CHEMER',1,'','AAURAZO',NULL,NULL),(45,'GORILA',1,'','AAURAZO',NULL,NULL),(46,'SAYON',1,'','AAURAZO',NULL,NULL),(47,'MONTEVERDE',1,'','AAURAZO',NULL,NULL),(48,'ANGEL',1,'','AAURAZO',NULL,NULL),(49,'DANA',1,'','AAURAZO',NULL,NULL),(50,'PLASTICENTRO',1,'','AAURAZO',NULL,NULL),(51,'EL REY LEON',1,'','AAURAZO',NULL,NULL),(52,'PREMIER',1,'','AAURAZO',NULL,NULL),(53,'PLASTIMAC',1,'','AAURAZO',NULL,NULL),(54,'REY',1,'','AAURAZO',NULL,NULL),(55,'PLASTIMICO',1,'','AAURAZO',NULL,NULL),(56,'HUASCARAN',1,'','AAURAZO',NULL,NULL),(57,'VIVERO',1,'VIV','AAURAZO',NULL,NULL),(58,'SCOTT',1,'NIU','AAURAZO',NULL,NULL),(59,'ELY',1,'NIU','AAURAZO',NULL,NULL),(60,'DANA',1,'NIU','AAURAZO',NULL,NULL),(61,'SANTA MARTHA',1,'NIU','AAURAZO',NULL,NULL),(62,'ALQUILER',1,'NIU','AAURAZO',NULL,NULL);
/*!40000 ALTER TABLE `marcas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `medios_pago`
--

DROP TABLE IF EXISTS `medios_pago`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `medios_pago` (
  `medpag_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `medpag_nombre` varchar(45) NOT NULL DEFAULT '',
  `medpag_estado` int(10) unsigned NOT NULL DEFAULT '1',
  `medpag_abreviatura` varchar(45) DEFAULT NULL,
  `medpag_usu_crea` varchar(45) DEFAULT NULL,
  `medpag_usu_modifica` varchar(45) DEFAULT NULL,
  `medpag_usu_activa` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`medpag_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `medios_pago`
--

LOCK TABLES `medios_pago` WRITE;
/*!40000 ALTER TABLE `medios_pago` DISABLE KEYS */;
INSERT INTO `medios_pago` VALUES (1,'EFECTIVO',1,'','etorres',NULL,NULL),(2,'CHEQUE',1,'','etorres','etorres',''),(3,'TRANSFERENCIA ELECTRONICA',1,'','etorres',NULL,NULL),(4,'TARJETA DE CREDITO',1,'','etorres',NULL,NULL),(5,'CUENTA CORRIENTE',1,'','etorres',NULL,NULL),(6,'NOTA DE CREDITO',1,'N CREDITO','LSANCHEZ1',NULL,NULL);
/*!40000 ALTER TABLE `medios_pago` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `motivos_traslado`
--

DROP TABLE IF EXISTS `motivos_traslado`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `motivos_traslado` (
  `mot_codi` int(11) NOT NULL AUTO_INCREMENT,
  `mot_nombre` varchar(145) NOT NULL DEFAULT '',
  `mot_estado` int(11) NOT NULL DEFAULT '1',
  `mot_abreviatura` varchar(45) DEFAULT NULL,
  `mot_usu_crea` varchar(45) DEFAULT NULL,
  `mot_usu_modifica` varchar(45) DEFAULT NULL,
  `mot_usu_activa` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`mot_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `motivos_traslado`
--

LOCK TABLES `motivos_traslado` WRITE;
/*!40000 ALTER TABLE `motivos_traslado` DISABLE KEYS */;
INSERT INTO `motivos_traslado` VALUES (1,'VENTA',1,'','etorres',NULL,NULL),(2,'VENTA SUJETA A CONFIRMACION DEL COMPRADOR',1,'','etorres',NULL,NULL),(3,'COMPRA',1,'','etorres',NULL,NULL),(4,'CONSIGNACIÓN',1,'','etorres',NULL,NULL),(5,'DEVOLUCIÓN',1,'','etorres',NULL,NULL),(6,'TRASLADO ENTRE ESTABLECIMIENTOS DE LA MISMA EMPRESA',1,'','etorres','etorres',NULL),(7,'TRASLADO DE BIENES PARA TRANSFORMACIÓN',1,'','etorres',NULL,NULL),(8,'RECOJO DE BIENES TRANSFORMADOS',1,'','etorres',NULL,NULL),(9,'TRASLADO POR EMISOR ITINERANTE DE COMPROBANTE DE PAGO',1,'','etorres',NULL,NULL),(10,'TRASLADO ZONA PRIMARIA',1,'','etorres',NULL,NULL),(11,'IMPORTACIÓN',1,'','etorres',NULL,NULL),(12,'EXPORTACIÓN',1,'','etorres',NULL,NULL),(13,'OTROS',1,'','etorres',NULL,NULL),(14,'EXHIBICIÓN',1,NULL,'etorres',NULL,NULL),(15,'EXTRACCIÓN',1,NULL,'etorres',NULL,NULL),(16,'DEMOSTRACIÓN',1,NULL,'etorres',NULL,NULL),(17,'VENTA CON ENTREGA A TERCEROS',1,NULL,'etorres',NULL,NULL);
/*!40000 ALTER TABLE `motivos_traslado` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nota_credito`
--

DROP TABLE IF EXISTS `nota_credito`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nota_credito` (
  `notcre_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `notcre_numero` varchar(45) NOT NULL DEFAULT '',
  `notcre_txt_generado` int(10) unsigned NOT NULL DEFAULT '0',
  `notcre_codigohast` varchar(245) DEFAULT NULL,
  `notcre_timbrexml` int(10) unsigned NOT NULL DEFAULT '0',
  `notcre_firma` text,
  `notcre_timbreweb` int(10) unsigned NOT NULL DEFAULT '0',
  `ordped_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  `notcre_fecha` date NOT NULL DEFAULT '0000-00-00',
  `notcre_serie` varchar(45) NOT NULL DEFAULT '',
  `notcre_fechahora` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `notcretip_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  `notcre_detalle` text,
  `notcre_descuento` float NOT NULL DEFAULT '0',
  `notcre_timbrerpta` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`notcre_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nota_credito`
--

LOCK TABLES `nota_credito` WRITE;
/*!40000 ALTER TABLE `nota_credito` DISABLE KEYS */;
INSERT INTO `nota_credito` VALUES (1,'F001-0000001',1,'LjOc5xyt6unxAQl+tgvy0j3bH64=',1,'Heu1n2MDX5EICgasWoPD6t90kXhusTm0jRqCGwMh61CSEbOlaWH0dWkWiPf0PxmpzVPjHLEOszL8eIcF+FUBpECcZY6YcaOmhcDN8TOGYVt65sDyRSMnUpOsh904owH8Nn108/aFeQhHVvtvaeAi8SgLKkgCilZX6EUlXCfE1ZdtMNmES7POtM7VIJPdOvcXsxjjkX2NxtMpOA5oEFtf5yVPw7t6zS/zMdUG+cLibqGNSQW1stAWsIErAJEpfxcBbTOJPBhlnVGOYelv3eKieXwBvUwBGhGphUwyjkR/cV4EUSe5J47NFMZqa6qiqoD+YCTdRSth07JnlHRrokvRjA==',0,4,'2021-01-15','F001','2021-01-15 23:29:26',1,'',0,1),(2,'F001-0000002',1,'/aPGf6sslWfc5rosxF5prjCc40g=',1,'DbnHivT4Bf8ImmL3RjJf5QuAH7CC4CloCWxHS/gMa9zI8xO716kZefxVjpDK6et5PzdgtN46A+V4\nGFKQxnWQuIy+1EuzozlcjjpRpDUUhSYGX/vaxpaJ244IHcgW1YPrkBw9/737C6Hd4yUsTecT8QaB\nrlbndewrl0wl3dZepQkXAG1yMTD2wRbaBmoiTY1WtEPlCXua7T9lbJFLBtDjCswRaSGyqyWvXNKW\nzX+etqpslimvBKolZuOc4lvtKp/ZT0fMqILQOxh5Yegz6nGTnq/dYKyVig6huZFf++7UDj5f61Vl\nh9CJ+F9+UZ77fu4vKscx7vrmZfqmvhQFFkhIFA==',0,15,'2021-01-22','F001','2021-01-22 23:48:57',1,'',0,1),(3,'B001-0000001',1,'WcTXNPqIMjm4pqxJaV3EPJ07Mj8=',1,'UtE2RNJvnCp7KKxCBDf8GP4qPZQgXijLdjl/xDKMP68u5g7JH1XLx3NJWq9Lt3WaW8QwfRZGQMUCTmXrVl452+XOsL9H8VdkiO0lSvu04PtOZ3pF7kcdnibvsH/sVvngBtyKdbWHMrDYFb+e45Sqh4qZUmZWYGhHhlnDVTRG+B3HDIEKIjW7z7bmdhRNfG5qk3sNhmTO90Od12JN8MoTAj5NZncqKagsClmdNP28jFabvCydQAirdm23Nzqbga2pgmJvx67y+FzXPkvHLKgeOnxEkxMZaP8i1KCYq1/sdMCJY/faWvZN3PT7h+EsSEGlkdoLTeIgwNTOPzn/VGlJiw==',0,345,'2021-03-15','B001','2021-03-16 01:27:34',1,'',0,1);
/*!40000 ALTER TABLE `nota_credito` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nota_credito_tipo`
--

DROP TABLE IF EXISTS `nota_credito_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nota_credito_tipo` (
  `notcretip_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `notcretip_codigo` varchar(45) NOT NULL DEFAULT '',
  `notcretip_nombre` varchar(245) NOT NULL DEFAULT '',
  `notcretip_estado` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`notcretip_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nota_credito_tipo`
--

LOCK TABLES `nota_credito_tipo` WRITE;
/*!40000 ALTER TABLE `nota_credito_tipo` DISABLE KEYS */;
INSERT INTO `nota_credito_tipo` VALUES (1,'01','ANULACIÓN DE OPERACIÓN',1),(2,'02','ANULACIÓN POR ERROR EN EL RUC',1),(3,'03','CORRECCIÓN POR ERROR EN LA DESCRIPCIÓN',1),(4,'04','DESCUENTO GLOBAL',1),(5,'05','DESCUENTO POR ITEM',0),(6,'06','DEVOLUCIÓN TOTAL',1),(7,'07','DEVOLUCIÓN POR ITEM',0),(8,'08','BONIFICACIÓN',0),(9,'09','DISMINUCIÓN EN EL VALOR',0),(10,'10','OTROS CONCEPTOS',1);
/*!40000 ALTER TABLE `nota_credito_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `operacion_almacen`
--

DROP TABLE IF EXISTS `operacion_almacen`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operacion_almacen` (
  `opealm_codi` int(11) NOT NULL AUTO_INCREMENT,
  `opealm_fechahora` datetime DEFAULT NULL,
  `opealm_fecha` date DEFAULT NULL,
  `opetip_codi_fk` int(11) NOT NULL DEFAULT '0',
  `per_codi_fk` int(11) DEFAULT NULL,
  `doctip_codi_fk` int(11) DEFAULT NULL,
  `opealm_anotaciones` text,
  `opealm_numero` varchar(45) DEFAULT NULL,
  `idtrans` varchar(45) DEFAULT NULL,
  `opealm_estado` int(10) unsigned NOT NULL DEFAULT '1',
  `doc_numero` varchar(45) DEFAULT NULL,
  `opealm_usu_crea` varchar(45) DEFAULT NULL,
  `opealm_usu_modifica` varchar(45) DEFAULT NULL,
  `opealm_usu_activa` varchar(45) DEFAULT NULL,
  `ordpedcom_numero` varchar(45) DEFAULT NULL,
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`opealm_codi`),
  KEY `fk_operacion_almacen_operacion_tipo1_idx` (`opetip_codi_fk`),
  KEY `fk_operacion_almacen_personas1_idx` (`per_codi_fk`),
  KEY `fk_operacion_almacen_documento_tipo1_idx` (`doctip_codi_fk`),
  CONSTRAINT `fk_operacion_almacen_documento_tipo1` FOREIGN KEY (`doctip_codi_fk`) REFERENCES `documento_tipo` (`doctip_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_operacion_almacen_operacion_tipo1` FOREIGN KEY (`opetip_codi_fk`) REFERENCES `operacion_tipo` (`opetip_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_operacion_almacen_personas1` FOREIGN KEY (`per_codi_fk`) REFERENCES `personas` (`per_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=1617 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `operacion_almacen`
--

LOCK TABLES `operacion_almacen` WRITE;
/*!40000 ALTER TABLE `operacion_almacen` DISABLE KEYS */;
INSERT INTO `operacion_almacen` VALUES (1,'2021-01-12 19:07:12','2021-01-12',4,1,2,'GENERADO AUNTOMATICAMENTE','0000001','1610496315656234664',1,'','AAURAZO',NULL,NULL,'0000001',1),(2,'2021-01-12 19:25:10','2021-01-12',4,1454,1,'GENERADO AUNTOMATICAMENTE','0000002','1610496691313357431',1,'','AAURAZO',NULL,NULL,'0000002',1),(3,'2021-01-12 19:46:51','2021-01-12',4,1454,1,'GENERADO AUNTOMATICAMENTE','0000003','16104980541397586191',1,'','AAURAZO',NULL,NULL,'0000003',1),(4,'2021-01-15 17:04:25','2021-01-15',4,1521,1,'GENERADO AUNTOMATICAMENTE','0000004','1610747944537251789',1,'','AAURAZO',NULL,NULL,'0000004',1),(5,'2021-01-15 17:49:47','2021-01-15',4,1521,1,'GENERADO AUNTOMATICAMENTE','0000005','16107508481132037069',1,'','AAURAZO',NULL,NULL,'0000005',1),(6,'2021-01-15 18:01:17','2021-01-15',4,1,2,'GENERADO AUNTOMATICAMENTE','0000006','1610751637729216565',1,'','AAURAZO',NULL,NULL,'0000006',1),(7,'2021-01-15 18:01:53','2021-01-15',4,1,2,'GENERADO AUNTOMATICAMENTE','0000007','1610751682989731',1,'','AAURAZO',NULL,NULL,'0000007',1),(8,'2021-01-15 18:02:39','2021-01-15',4,1,2,'GENERADO AUNTOMATICAMENTE','0000008','1610751719875696748',1,'','AAURAZO',NULL,NULL,'0000008',1),(9,'2021-01-15 18:03:23','2021-01-15',4,1,2,'GENERADO AUNTOMATICAMENTE','0000009','16107517621299086444',1,'','AAURAZO',NULL,NULL,'0000009',1),(10,'2021-01-15 18:05:00','2021-01-15',4,1,2,'GENERADO AUNTOMATICAMENTE','0000010','16107518121101140250',1,'','AAURAZO',NULL,NULL,'0000010',1),(11,'2021-01-15 18:05:38','2021-01-15',4,1,2,'GENERADO AUNTOMATICAMENTE','0000011','16107519031118568122',1,'','AAURAZO',NULL,NULL,'0000011',1),(12,'2021-01-15 18:06:18','2021-01-15',4,1,2,'GENERADO AUNTOMATICAMENTE','0000012','161075194283825910',1,'','AAURAZO',NULL,NULL,'0000012',1),(13,'2021-01-15 18:06:54','2021-01-15',4,1,2,'GENERADO AUNTOMATICAMENTE','0000013','1610751982820056655',1,'','AAURAZO',NULL,NULL,'0000013',1),(14,'2021-01-15 18:07:45','2021-01-15',4,1,2,'GENERADO AUNTOMATICAMENTE','0000014','1610752017768547613',1,'','AAURAZO',NULL,NULL,'0000014',1),(15,'2021-01-21 17:18:33','2021-01-21',4,1522,1,'GENERADO AUNTOMATICAMENTE','0000015','1611267024616688457',1,'','AAURAZO',NULL,NULL,'0000015',1),(16,'2021-01-21 17:33:45','2021-01-21',4,1523,1,'GENERADO AUNTOMATICAMENTE','0000016','16112678641082464457',1,'','AAURAZO',NULL,NULL,'0000016',1),(17,'2021-01-21 18:11:22','2021-01-21',4,1524,1,'GENERADO AUNTOMATICAMENTE','0000017','16112689201145161762',1,'','AAURAZO',NULL,NULL,'0000017',1),(18,'2021-01-21 18:22:39','2021-01-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000018','1611271338207198027',1,'','AAURAZO',NULL,NULL,'0000018',1),(19,'2021-01-21 18:23:23','2021-01-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000019','1611271362234824431',1,'','AAURAZO',NULL,NULL,'0000019',1),(20,'2021-01-21 18:24:15','2021-01-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000020','16112714051324432163',1,'','AAURAZO',NULL,NULL,'0000020',1),(21,'2021-01-21 18:24:49','2021-01-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000021','1611271458142306101',1,'','AAURAZO',NULL,NULL,'0000021',1),(22,'2021-01-21 18:26:23','2021-01-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000022','1611271512931638064',1,'','AAURAZO',NULL,NULL,'0000022',1),(23,'2021-01-21 18:27:20','2021-01-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000023','1611271585474769643',1,'','AAURAZO',NULL,NULL,'0000023',1),(24,'2021-01-21 18:29:46','2021-01-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000024','1611271751591730024',1,'','AAURAZO',NULL,NULL,'0000024',1),(25,'2021-01-22 18:02:09','2021-01-22',4,1522,1,'GENERADO AUNTOMATICAMENTE','0000025','1611356423477910963',1,'','AAURAZO',NULL,NULL,'0000025',1),(26,'2021-01-22 18:18:01','2021-01-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000026','16113574321397758318',1,'','AAURAZO',NULL,NULL,'0000026',1),(27,'2021-01-22 18:18:21','2021-01-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000027','161135748420870414',1,'','AAURAZO',NULL,NULL,'0000027',1),(28,'2021-01-22 18:18:56','2021-01-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000028','1611357504471284068',1,'','AAURAZO',NULL,NULL,'0000028',1),(29,'2021-01-22 18:28:58','2021-01-22',4,1525,1,'GENERADO AUNTOMATICAMENTE','0000029','1611357539998380357',1,'','AAURAZO',NULL,NULL,'0000029',1),(30,'2021-01-25 18:03:23','2021-01-25',4,1475,1,'GENERADO AUNTOMATICAMENTE','0000030','1611615389683215591',1,'','AAURAZO',NULL,NULL,'0000030',1),(31,'2021-01-25 18:17:34','2021-01-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000031','1611616334334356941',1,'','AAURAZO',NULL,NULL,'0000031',1),(32,'2021-01-25 18:19:43','2021-01-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000032','1611616665617764252',1,'','AAURAZO',NULL,NULL,'0000032',1),(33,'2021-01-25 18:21:04','2021-01-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000033','16116167881388162231',1,'','AAURAZO',NULL,NULL,'0000033',1),(34,'2021-01-26 11:20:50','2021-01-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000034','1611677936252037143',1,'','AAURAZO',NULL,NULL,'0000034',1),(35,'2021-01-26 15:34:51','2021-01-26',4,1526,1,'GENERADO AUNTOMATICAMENTE','0000035','1611692661534024405',1,'','AAURAZO',NULL,NULL,'0000035',1),(36,'2021-01-26 17:59:46','2021-01-26',4,1527,1,'GENERADO AUNTOMATICAMENTE','0000036','1611701537630157405',1,'','AAURAZO',NULL,NULL,'0000036',1),(37,'2021-01-26 18:38:45','2021-01-26',4,1528,1,'GENERADO AUNTOMATICAMENTE','0000037','16117033591008880111',1,'','AAURAZO',NULL,NULL,'0000037',1),(38,'2021-01-26 18:45:19','2021-01-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000038','16117046921024457616',1,'','AAURAZO',NULL,NULL,'0000038',1),(39,'2021-01-26 18:45:38','2021-01-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000039','1611704722165328104',1,'','AAURAZO',NULL,NULL,'0000039',1),(40,'2021-01-26 18:46:07','2021-01-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000040','1611704741529592132',1,'','AAURAZO',NULL,NULL,'0000040',1),(41,'2021-01-26 18:50:56','2021-01-26',4,1529,1,'GENERADO AUNTOMATICAMENTE','0000041','1611704769278759879',1,'','AAURAZO',NULL,NULL,'0000041',1),(42,'2021-01-28 18:24:18','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000042','1611876223564361811',1,'','AAURAZO',NULL,NULL,'0000042',1),(43,'2021-01-28 18:25:14','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000043','1611876288270454745',1,'','AAURAZO',NULL,NULL,'0000043',1),(44,'2021-01-28 18:25:34','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000044','1611876317179786782',1,'','AAURAZO',NULL,NULL,'0000044',1),(45,'2021-01-28 18:26:22','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000045','1611876336171438617',1,'','AAURAZO',NULL,NULL,'0000045',1),(46,'2021-01-28 18:26:50','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000046','1611876385534669882',1,'','AAURAZO',NULL,NULL,'0000046',1),(47,'2021-01-28 18:27:16','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000047','16118764131166032176',1,'','AAURAZO',NULL,NULL,'0000047',1),(48,'2021-01-28 18:27:43','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000048','1611876439994722655',1,'','AAURAZO',NULL,NULL,'0000048',1),(49,'2021-01-28 18:28:11','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000049','1611876466524385286',1,'','AAURAZO',NULL,NULL,'0000049',1),(50,'2021-01-28 18:28:36','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000050','1611876493876944670',1,'','AAURAZO',NULL,NULL,'0000050',1),(51,'2021-01-28 18:29:24','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000051','1611876519754174998',1,'','AAURAZO',NULL,NULL,'0000051',1),(52,'2021-01-28 18:29:47','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000052','1611876566609200927',1,'','AAURAZO',NULL,NULL,'0000052',1),(53,'2021-01-28 18:30:19','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000053','1611876600712262043',1,'','AAURAZO',NULL,NULL,'0000053',1),(54,'2021-01-28 18:31:06','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000054','1611876622690186739',1,'','AAURAZO',NULL,NULL,'0000054',1),(55,'2021-01-28 18:31:43','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000055','1611876669263784819',1,'','AAURAZO',NULL,NULL,'0000055',1),(56,'2021-01-28 18:32:21','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000056','1611876705858957385',1,'','AAURAZO',NULL,NULL,'0000056',1),(57,'2021-01-28 18:32:58','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000057','16118767441217110901',1,'','AAURAZO',NULL,NULL,'0000057',1),(58,'2021-01-28 18:33:18','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000058','1611876781406736397',1,'','AAURAZO',NULL,NULL,'0000058',1),(59,'2021-01-28 18:34:17','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000059','1611876801942352977',1,'','AAURAZO',NULL,NULL,'0000059',1),(60,'2021-01-28 18:34:50','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000060','16118768601304379353',1,'','AAURAZO',NULL,NULL,'0000060',1),(61,'2021-01-28 18:35:15','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000061','1611876892698448841',1,'','AAURAZO',NULL,NULL,'0000061',1),(62,'2021-01-28 18:35:53','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000062','1611876922206337391',1,'','AAURAZO',NULL,NULL,'0000062',1),(63,'2021-01-28 18:36:40','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000063','1611876959394859625',1,'','AAURAZO',NULL,NULL,'0000063',1),(64,'2021-01-28 18:37:15','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000064','1611877003740189669',1,'','AAURAZO',NULL,NULL,'0000064',1),(65,'2021-01-28 18:38:04','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000065','1611877038866961297',1,'','AAURAZO',NULL,NULL,'0000065',1),(66,'2021-01-28 18:38:45','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000066','1611877086709766200',1,'','AAURAZO',NULL,NULL,'0000066',1),(67,'2021-01-28 18:39:19','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000067','1611877127639882587',1,'','AAURAZO',NULL,NULL,'0000067',1),(68,'2021-01-28 18:39:58','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000068','16118771621073255656',1,'','AAURAZO',NULL,NULL,'0000068',1),(69,'2021-01-28 18:40:22','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000069','16118772011070415558',1,'','AAURAZO',NULL,NULL,'0000069',1),(70,'2021-01-28 18:41:06','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000070','16118772241225803320',1,'','AAURAZO',NULL,NULL,'0000070',1),(71,'2021-01-28 18:41:32','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000071','16118772691112930958',1,'','AAURAZO',NULL,NULL,'0000071',1),(72,'2021-01-28 18:42:01','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000072','1611877295636956426',1,'','AAURAZO',NULL,NULL,'0000072',1),(73,'2021-01-28 18:42:31','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000073','16118773301299129476',1,'','AAURAZO',NULL,NULL,'0000073',1),(74,'2021-01-28 18:43:04','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000074','1611877353822208244',1,'','AAURAZO',NULL,NULL,'0000074',1),(75,'2021-01-28 18:43:30','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000075','1611877391370417573',1,'','AAURAZO',NULL,NULL,'0000075',1),(76,'2021-01-28 18:44:32','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000076','1611877413998380357',1,'','AAURAZO',NULL,NULL,'0000076',1),(77,'2021-01-28 18:45:37','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000077','1611877484933875717',1,'','AAURAZO',NULL,NULL,'0000077',1),(78,'2021-01-28 18:46:32','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000078','16118775391219176426',1,'','AAURAZO',NULL,NULL,'0000078',1),(79,'2021-01-28 18:47:12','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000079','1611877604614665963',1,'','AAURAZO',NULL,NULL,'0000079',1),(80,'2021-01-28 18:47:39','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000080','16118776351179888410',1,'','AAURAZO',NULL,NULL,'0000080',1),(81,'2021-01-28 18:48:21','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000081','1611877662593064009',1,'','AAURAZO',NULL,NULL,'0000081',1),(82,'2021-01-28 18:49:13','2021-01-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000082','1611877705594441026',1,'','AAURAZO',NULL,NULL,'0000082',1),(83,'2021-01-29 18:21:48','2021-01-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000083','1611962455846392105',1,'','AAURAZO',NULL,NULL,'0000083',1),(84,'2021-01-29 18:22:20','2021-01-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000084','16119625131278990602',1,'','AAURAZO',NULL,NULL,'0000084',1),(85,'2021-01-29 18:22:58','2021-01-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000085','16119625471128809685',1,'','AAURAZO',NULL,NULL,'0000085',1),(86,'2021-01-29 18:26:01','2021-01-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000086','1611962580188952552',1,'','AAURAZO',NULL,NULL,'0000086',1),(87,'2021-01-29 18:26:29','2021-01-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000087','16119627641194648311',1,'','AAURAZO',NULL,NULL,'0000087',1),(88,'2021-01-29 18:27:00','2021-01-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000088','1611962792137400478',1,'','AAURAZO',NULL,NULL,'0000088',1),(89,'2021-01-29 18:27:26','2021-01-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000089','1611962822941018992',1,'','AAURAZO',NULL,NULL,'0000089',1),(90,'2021-01-29 18:28:28','2021-01-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000090','16119628481027039523',1,'','AAURAZO',NULL,NULL,'0000090',1),(91,'2021-01-29 18:29:14','2021-01-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000091','16119629101130100639',1,'','AAURAZO',NULL,NULL,'0000091',1),(92,'2021-01-29 18:38:13','2021-01-29',4,1530,2,'GENERADO AUNTOMATICAMENTE','0000092','1611962962199280179',1,'','AAURAZO',NULL,NULL,'0000092',1),(93,'2021-01-29 18:44:01','2021-01-29',4,1523,1,'GENERADO AUNTOMATICAMENTE','0000093','16119636721040336343',1,'','AAURAZO',NULL,NULL,'0000093',1),(94,'2021-01-29 18:49:28','2021-01-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000094','1611964137555540296',1,'','AAURAZO',NULL,NULL,'0000094',1),(95,'2021-01-29 18:49:53','2021-01-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000095','1611964171260471372',1,'','AAURAZO',NULL,NULL,'0000095',1),(96,'2021-01-29 18:50:17','2021-01-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000096','1611964196234308049',1,'','AAURAZO',NULL,NULL,'0000096',1),(97,'2021-01-29 18:51:01','2021-01-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000097','16119642201031729987',1,'','AAURAZO',NULL,NULL,'0000097',1),(98,'2021-01-29 18:51:37','2021-01-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000098','1611964264123027863',1,'','AAURAZO',NULL,NULL,'0000098',1),(99,'2021-01-29 18:52:21','2021-01-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000099','1611964300366544713',1,'','AAURAZO',NULL,NULL,'0000099',1),(100,'2021-01-29 18:52:58','2021-01-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000100','1611964349440516345',1,'','AAURAZO',NULL,NULL,'0000100',1),(101,'2021-01-29 18:53:28','2021-01-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000101','1611964381636181854',1,'','AAURAZO',NULL,NULL,'0000101',1),(102,'2021-01-29 18:54:40','2021-01-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000102','1611964416130214170',1,'','AAURAZO',NULL,NULL,'0000102',1),(103,'2021-01-29 18:55:12','2021-01-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000103','1611964491857967654',1,'','AAURAZO',NULL,NULL,'0000103',1),(104,'2021-01-29 18:55:35','2021-01-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000104','16119645151372842917',1,'','AAURAZO',NULL,NULL,'0000104',1),(105,'2021-01-29 18:56:36','2021-01-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000105','1611964556909003347',1,'','AAURAZO',NULL,NULL,'0000105',1),(106,'2021-01-29 18:57:33','2021-01-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000106','1611964599114851825',1,'','AAURAZO',NULL,NULL,'0000106',1),(107,'2021-01-29 18:58:14','2021-01-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000107','1611964669835892351',1,'','AAURAZO',NULL,NULL,'0000107',1),(108,'2021-01-30 18:18:42','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000108','1612048698247174552',1,'','AAURAZO',NULL,NULL,'0000108',1),(109,'2021-01-30 18:20:19','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000109','1612048786794409714',1,'','AAURAZO',NULL,NULL,'0000109',1),(110,'2021-01-30 18:20:54','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000110','16120488221237938283',1,'','AAURAZO',NULL,NULL,'0000110',1),(111,'2021-01-30 18:21:19','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000111','1612048857194116366',1,'','AAURAZO',NULL,NULL,'0000111',1),(112,'2021-01-30 18:22:03','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000112','1612048882305654743',1,'','AAURAZO',NULL,NULL,'0000112',1),(113,'2021-01-30 18:22:25','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000113','1612048926109214661',1,'','AAURAZO',NULL,NULL,'0000113',1),(114,'2021-01-30 18:23:25','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000114','161204894825517847',1,'','AAURAZO',NULL,NULL,'0000114',1),(115,'2021-01-30 18:24:13','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000115','1612049009783694800',1,'','AAURAZO',NULL,NULL,'0000115',1),(116,'2021-01-30 18:24:48','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000116','16120490571105185238',1,'','AAURAZO',NULL,NULL,'0000116',1),(117,'2021-01-30 18:25:56','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000117','16120490911404299149',1,'','AAURAZO',NULL,NULL,'0000117',1),(118,'2021-01-30 18:26:51','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000118','16120491591069985241',1,'','AAURAZO',NULL,NULL,'0000118',1),(119,'2021-01-30 18:27:21','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000119','1612049214178495829',1,'','AAURAZO',NULL,NULL,'0000119',1),(120,'2021-01-30 18:27:43','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000120','1612049243844240516',1,'','AAURAZO',NULL,NULL,'0000120',1),(121,'2021-01-30 18:28:11','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000121','1612049266122468450',1,'','AAURAZO',NULL,NULL,'0000121',1),(122,'2021-01-30 18:29:02','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000122','1612049295133097300',1,'','AAURAZO',NULL,NULL,'0000122',1),(123,'2021-01-30 18:29:41','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000123','1612049352116271873',1,'','AAURAZO',NULL,NULL,'0000123',1),(124,'2021-01-30 18:30:15','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000124','16120493841057118738',1,'','AAURAZO',NULL,NULL,'0000124',1),(125,'2021-01-30 18:30:46','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000125','1612049419449466955',1,'','AAURAZO',NULL,NULL,'0000125',1),(126,'2021-01-30 18:31:31','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000126','1612049449141144243',1,'','AAURAZO',NULL,NULL,'0000126',1),(127,'2021-01-30 18:31:53','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000127','16120494951126615065',1,'','AAURAZO',NULL,NULL,'0000127',1),(128,'2021-01-30 18:32:20','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000128','1612049516722675734',1,'','AAURAZO',NULL,NULL,'0000128',1),(129,'2021-01-30 18:33:29','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000129','16120495871028889889',1,'','AAURAZO',NULL,NULL,'0000129',1),(130,'2021-01-30 18:33:57','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000130','1612049613275274305',1,'','AAURAZO',NULL,NULL,'0000130',1),(131,'2021-01-30 18:34:37','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000131','1612049641806286485',1,'','AAURAZO',NULL,NULL,'0000131',1),(132,'2021-01-30 18:35:10','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000132','1612049689338746182',1,'','AAURAZO',NULL,NULL,'0000132',1),(133,'2021-01-30 18:35:40','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000133','16120497131280066396',1,'','AAURAZO',NULL,NULL,'0000133',1),(134,'2021-01-30 18:37:14','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000134','1612049744748322676',1,'','AAURAZO',NULL,NULL,'0000134',1),(135,'2021-01-30 18:37:37','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000135','16120498371312512359',1,'','AAURAZO',NULL,NULL,'0000135',1),(136,'2021-01-30 18:38:15','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000136','16120498651119471789',1,'','AAURAZO',NULL,NULL,'0000136',1),(137,'2021-01-30 18:38:42','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000137','16120498981133801372',1,'','AAURAZO',NULL,NULL,'0000137',1),(138,'2021-01-30 18:39:16','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000138','1612049925591600929',1,'','AAURAZO',NULL,NULL,'0000138',1),(139,'2021-01-30 18:40:12','2021-01-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000139','16120499661175499168',1,'','AAURAZO',NULL,NULL,'0000139',1),(140,'2021-02-10 13:30:41','2021-02-10',4,1531,1,'GENERADO AUNTOMATICAMENTE','0000140','16129816631222016524',1,'','AAURAZO',NULL,NULL,'0000140',1),(141,'2021-02-10 14:00:12','2021-02-10',4,1532,1,'GENERADO AUNTOMATICAMENTE','0000141','1612983229580584793',1,'','AAURAZO',NULL,NULL,'0000141',1),(142,'2021-02-10 18:15:22','2021-02-10',4,1,2,'GENERADO AUNTOMATICAMENTE','0000142','1612998904832880126',1,'','AAURAZO',NULL,NULL,'0000142',1),(143,'2021-02-10 18:18:54','2021-02-10',4,1,2,'GENERADO AUNTOMATICAMENTE','0000143','1612998995494220008',1,'','AAURAZO',NULL,NULL,'0000143',1),(144,'2021-02-10 18:19:47','2021-02-10',4,1,2,'GENERADO AUNTOMATICAMENTE','0000144','1612999137486087001',1,'','AAURAZO',NULL,NULL,'0000144',1),(145,'2021-02-10 18:20:23','2021-02-10',4,1,2,'GENERADO AUNTOMATICAMENTE','0000145','1612999190542458635',1,'','AAURAZO',NULL,NULL,'0000145',1),(146,'2021-02-10 18:21:16','2021-02-10',4,1,2,'GENERADO AUNTOMATICAMENTE','0000146','1612999227996917276',1,'','AAURAZO',NULL,NULL,'0000146',1),(147,'2021-02-10 18:22:22','2021-02-10',4,1,2,'GENERADO AUNTOMATICAMENTE','0000147','16129992801141977411',1,'','AAURAZO',NULL,NULL,'0000147',1),(148,'2021-02-10 18:24:06','2021-02-10',4,1,2,'GENERADO AUNTOMATICAMENTE','0000148','1612999349348170142',1,'','AAURAZO',NULL,NULL,'0000148',1),(149,'2021-02-10 18:25:03','2021-02-10',4,1,2,'GENERADO AUNTOMATICAMENTE','0000149','1612999449930433174',1,'','AAURAZO',NULL,NULL,'0000149',1),(150,'2021-02-10 18:25:53','2021-02-10',4,1,2,'GENERADO AUNTOMATICAMENTE','0000150','1612999507291540318',1,'','AAURAZO',NULL,NULL,'0000150',1),(151,'2021-02-10 18:26:42','2021-02-10',4,1,2,'GENERADO AUNTOMATICAMENTE','0000151','1612999564727151040',1,'','AAURAZO',NULL,NULL,'0000151',1),(152,'2021-02-10 18:27:09','2021-02-10',4,1,2,'GENERADO AUNTOMATICAMENTE','0000152','16129996051135479612',1,'','AAURAZO',NULL,NULL,'0000152',1),(153,'2021-02-10 18:28:21','2021-02-10',4,1,2,'GENERADO AUNTOMATICAMENTE','0000153','16129996561369357342',1,'','AAURAZO',NULL,NULL,'0000153',1),(154,'2021-02-10 18:29:36','2021-02-10',4,1,2,'GENERADO AUNTOMATICAMENTE','0000154','1612999705914554447',1,'','AAURAZO',NULL,NULL,'0000154',1),(155,'2021-02-10 18:30:16','2021-02-10',4,1,2,'GENERADO AUNTOMATICAMENTE','0000155','16129997801268964197',1,'','AAURAZO',NULL,NULL,'0000155',1),(156,'2021-02-10 18:30:53','2021-02-10',4,1,2,'GENERADO AUNTOMATICAMENTE','0000156','1612999819783780864',1,'','AAURAZO',NULL,NULL,'0000156',1),(157,'2021-02-10 18:31:24','2021-02-10',4,1,2,'GENERADO AUNTOMATICAMENTE','0000157','1612999862237019051',1,'','AAURAZO',NULL,NULL,'0000157',1),(158,'2021-02-20 16:21:27','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000158','1613856024569697752',1,'','AAURAZO',NULL,NULL,'0000158',1),(159,'2021-02-20 16:21:58','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000159','16138560901258679601',1,'','AAURAZO',NULL,NULL,'0000159',1),(160,'2021-02-20 16:22:16','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000160','16138561211151573498',1,'','AAURAZO',NULL,NULL,'0000160',1),(161,'2021-02-20 16:22:44','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000161','1613856139311291906',1,'','AAURAZO',NULL,NULL,'0000161',1),(162,'2021-02-20 16:23:12','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000162','161385616747033737',1,'','AAURAZO',NULL,NULL,'0000162',1),(163,'2021-02-20 16:24:05','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000163','1613856196928927062',1,'','AAURAZO',NULL,NULL,'0000163',1),(164,'2021-02-20 16:24:42','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000164','1613856248645046401',1,'','AAURAZO',NULL,NULL,'0000164',1),(165,'2021-02-20 16:25:32','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000165','161385628537437650',1,'','AAURAZO',NULL,NULL,'0000165',1),(166,'2021-02-20 16:26:09','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000166','1613856339602057652',1,'','AAURAZO',NULL,NULL,'0000166',1),(167,'2021-02-20 16:26:48','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000167','16138563721352704043',1,'','AAURAZO',NULL,NULL,'0000167',1),(168,'2021-02-20 16:27:46','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000168','1613856411147599010',1,'','AAURAZO',NULL,NULL,'0000168',1),(169,'2021-02-20 16:28:11','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000169','161385646999016129',1,'','AAURAZO',NULL,NULL,'0000169',1),(170,'2021-02-20 16:28:47','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000170','1613856493866918265',1,'','AAURAZO',NULL,NULL,'0000170',1),(171,'2021-02-20 16:29:12','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000171','161385653041009288',1,'','AAURAZO',NULL,NULL,'0000171',1),(172,'2021-02-20 16:30:14','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000172','16138565551233204787',1,'','AAURAZO',NULL,NULL,'0000172',1),(173,'2021-02-20 16:30:52','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000173','161385661665795594',1,'','AAURAZO',NULL,NULL,'0000173',1),(174,'2021-02-20 16:32:01','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000174','1613856654414998499',1,'','AAURAZO',NULL,NULL,'0000174',1),(175,'2021-02-20 16:32:35','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000175','1613856731278071371',1,'','AAURAZO',NULL,NULL,'0000175',1),(176,'2021-02-20 16:33:04','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000176','16138567581244177891',1,'','AAURAZO',NULL,NULL,'0000176',1),(177,'2021-02-20 16:33:31','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000177','16138567871390959297',1,'','AAURAZO',NULL,NULL,'0000177',1),(178,'2021-02-20 16:34:23','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000178','16138568141034957371',1,'','AAURAZO',NULL,NULL,'0000178',1),(179,'2021-02-20 16:34:55','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000179','1613856866867520710',1,'','AAURAZO',NULL,NULL,'0000179',1),(180,'2021-02-20 16:36:31','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000180','16138569631127045382',1,'','AAURAZO',NULL,NULL,'0000180',1),(181,'2021-02-20 16:37:16','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000181','1613856994492756927',1,'','AAURAZO',NULL,NULL,'0000181',1),(182,'2021-02-20 16:39:11','2021-02-20',4,1,2,'GENERADO AUNTOMATICAMENTE','0000182','1613857039901774008',1,'','AAURAZO',NULL,NULL,'0000182',1),(183,'2021-02-22 17:24:12','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000183','1614032568171438617',1,'','AAURAZO',NULL,NULL,'0000183',1),(184,'2021-02-22 17:25:03','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000184','161403265584858673',1,'','AAURAZO',NULL,NULL,'0000184',1),(185,'2021-02-22 17:25:22','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000185','1614032706816700176',1,'','AAURAZO',NULL,NULL,'0000185',1),(186,'2021-02-22 17:25:57','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000186','161403272550476280',1,'','AAURAZO',NULL,NULL,'0000186',1),(187,'2021-02-22 17:31:00','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000187','1614032760777928541',1,'','AAURAZO',NULL,NULL,'0000187',1),(188,'2021-02-22 17:32:12','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000188','1614033066325879680',1,'','AAURAZO',NULL,NULL,'0000188',1),(189,'2021-02-22 17:33:18','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000189','1614033136894716796',1,'','AAURAZO',NULL,NULL,'0000189',1),(190,'2021-02-22 17:34:14','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000190','1614033200514057659',1,'','AAURAZO',NULL,NULL,'0000190',1),(191,'2021-02-22 17:34:42','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000191','1614033257577959854',1,'','AAURAZO',NULL,NULL,'0000191',1),(192,'2021-02-22 17:35:09','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000192','16140332851388764676',1,'','AAURAZO',NULL,NULL,'0000192',1),(193,'2021-02-22 17:35:36','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000193','1614033312168684583',1,'','AAURAZO',NULL,NULL,'0000193',1),(194,'2021-02-22 17:36:04','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000194','1614033339654728552',1,'','AAURAZO',NULL,NULL,'0000194',1),(195,'2021-02-22 17:36:28','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000195','1614033367543663524',1,'','AAURAZO',NULL,NULL,'0000195',1),(196,'2021-02-22 17:37:00','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000196','1614033391402131996',1,'','AAURAZO',NULL,NULL,'0000196',1),(197,'2021-02-22 17:37:35','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000197','1614033423769924630',1,'','AAURAZO',NULL,NULL,'0000197',1),(198,'2021-02-22 17:38:25','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000198','161403345722849876',1,'','AAURAZO',NULL,NULL,'0000198',1),(199,'2021-02-22 17:38:59','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000199','1614033508562683572',1,'','AAURAZO',NULL,NULL,'0000199',1),(200,'2021-02-22 17:40:09','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000200','1614033572194933969',1,'','AAURAZO',NULL,NULL,'0000200',1),(201,'2021-02-22 17:41:02','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000201','16140336121087542207',1,'','AAURAZO',NULL,NULL,'0000201',1),(202,'2021-02-22 17:42:30','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000202','1614033665888692346',1,'','AAURAZO',NULL,NULL,'0000202',1),(203,'2021-02-22 17:43:13','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000203','16140337531206094765',1,'','AAURAZO',NULL,NULL,'0000203',1),(204,'2021-02-22 17:51:06','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000204','16140338001153208705',1,'','AAURAZO',NULL,NULL,'0000204',1),(205,'2021-02-22 17:59:01','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000205','1614034270358497770',1,'','AAURAZO',NULL,NULL,'0000205',1),(206,'2021-02-22 17:59:59','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000206','1614034753524385286',1,'','AAURAZO',NULL,NULL,'0000206',1),(207,'2021-02-22 18:07:19','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000207','1614035217684635640',1,'','AAURAZO',NULL,NULL,'0000207',1),(208,'2021-02-22 18:08:09','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000208','1614035243295241051',1,'','AAURAZO',NULL,NULL,'0000208',1),(209,'2021-02-22 18:08:52','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000209','1614035292427563779',1,'','AAURAZO',NULL,NULL,'0000209',1),(210,'2021-02-22 18:09:17','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000210','161403533516309046',1,'','AAURAZO',NULL,NULL,'0000210',1),(211,'2021-02-22 18:09:46','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000211','1614035359251004380',1,'','AAURAZO',NULL,NULL,'0000211',1),(212,'2021-02-22 18:10:18','2021-02-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000212','16140353891057376929',1,'','AAURAZO',NULL,NULL,'0000212',1),(213,'2021-02-23 18:36:58','2021-02-23',4,1533,2,'GENERADO AUNTOMATICAMENTE','0000213','1614123192887788679',1,'','AAURAZO',NULL,NULL,'0000213',1),(214,'2021-02-23 19:12:59','2021-02-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000214','1614125538612643470',1,'','AAURAZO',NULL,NULL,'0000214',1),(215,'2021-02-23 19:13:19','2021-02-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000215','16141255821118352963',1,'','AAURAZO',NULL,NULL,'0000215',1),(216,'2021-02-23 19:13:48','2021-02-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000216','16141256011111338782',1,'','AAURAZO',NULL,NULL,'0000216',1),(217,'2021-02-23 19:14:17','2021-02-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000217','1614125631769752503',1,'','AAURAZO',NULL,NULL,'0000217',1),(218,'2021-02-23 19:14:59','2021-02-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000218','16141256601274128011',1,'','AAURAZO',NULL,NULL,'0000218',1),(219,'2021-02-23 19:15:31','2021-02-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000219','1614125702114120284',1,'','AAURAZO',NULL,NULL,'0000219',1),(220,'2021-02-23 19:15:52','2021-02-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000220','1614125733120273829',1,'','AAURAZO',NULL,NULL,'0000220',1),(221,'2021-02-23 19:16:18','2021-02-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000221','1614125755675641997',1,'','AAURAZO',NULL,NULL,'0000221',1),(222,'2021-02-23 19:16:39','2021-02-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000222','16141257811278129966',1,'','AAURAZO',NULL,NULL,'0000222',1),(223,'2021-02-23 19:17:03','2021-02-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000223','1614125802265635186',1,'','AAURAZO',NULL,NULL,'0000223',1),(224,'2021-02-23 19:17:25','2021-02-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000224','16141258251244479113',1,'','AAURAZO',NULL,NULL,'0000224',1),(225,'2021-02-23 19:18:03','2021-02-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000225','1614125847989429746',1,'','AAURAZO',NULL,NULL,'0000225',1),(226,'2021-02-23 19:18:35','2021-02-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000226','16141258864131051',1,'','AAURAZO',NULL,NULL,'0000226',1),(227,'2021-02-23 19:19:16','2021-02-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000227','1614125936403638108',1,'','AAURAZO',NULL,NULL,'0000227',1),(228,'2021-02-23 19:19:43','2021-02-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000228','1614125958504891890',1,'','AAURAZO',NULL,NULL,'0000228',1),(229,'2021-02-23 19:20:13','2021-02-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000229','16141259861360148541',1,'','AAURAZO',NULL,NULL,'0000229',1),(230,'2021-02-23 19:20:49','2021-02-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000230','1614126015217181400',1,'','AAURAZO',NULL,NULL,'0000230',1),(231,'2021-02-23 19:21:15','2021-02-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000231','16141260521368840961',1,'','AAURAZO',NULL,NULL,'0000231',1),(232,'2021-02-23 19:21:42','2021-02-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000232','1614126082296402910',1,'','AAURAZO',NULL,NULL,'0000232',1),(233,'2021-02-23 19:22:29','2021-02-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000233','16141261051349863946',1,'','AAURAZO',NULL,NULL,'0000233',1),(234,'2021-02-23 19:23:07','2021-02-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000234','1614126166898933910',1,'','AAURAZO',NULL,NULL,'0000234',1),(235,'2021-02-23 19:23:46','2021-02-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000235','16141261911383385703',1,'','AAURAZO',NULL,NULL,'0000235',1),(236,'2021-02-24 18:09:13','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000236','16142081351242069334',1,'','AAURAZO',NULL,NULL,'0000236',1),(237,'2021-02-24 18:09:42','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000237','1614208157408285541',1,'','AAURAZO',NULL,NULL,'0000237',1),(238,'2021-02-24 18:10:23','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000238','1614208185310474302',1,'','AAURAZO',NULL,NULL,'0000238',1),(239,'2021-02-24 18:10:54','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000239','1614208226276522227',1,'','AAURAZO',NULL,NULL,'0000239',1),(240,'2021-02-24 18:11:16','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000240','1614208257840453719',1,'','AAURAZO',NULL,NULL,'0000240',1),(241,'2021-02-24 18:11:36','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000241','1614208279550505578',1,'','AAURAZO',NULL,NULL,'0000241',1),(242,'2021-02-24 18:12:24','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000242','1614208299979575468',1,'','AAURAZO',NULL,NULL,'0000242',1),(243,'2021-02-24 18:12:46','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000243','1614208346955434639',1,'','AAURAZO',NULL,NULL,'0000243',1),(244,'2021-02-24 18:13:27','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000244','1614208368494607294',1,'','AAURAZO',NULL,NULL,'0000244',1),(245,'2021-02-24 18:14:00','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000245','1614208411864637581',1,'','AAURAZO',NULL,NULL,'0000245',1),(246,'2021-02-24 18:14:36','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000246','1614208442986116299',1,'','AAURAZO',NULL,NULL,'0000246',1),(247,'2021-02-24 18:15:04','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000247','16142084781081775949',1,'','AAURAZO',NULL,NULL,'0000247',1),(248,'2021-02-24 18:15:25','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000248','1614208507109472852',1,'','AAURAZO',NULL,NULL,'0000248',1),(249,'2021-02-24 18:16:03','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000249','16142085281217928504',1,'','AAURAZO',NULL,NULL,'0000249',1),(250,'2021-02-24 18:16:57','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000250','1614208566958145641',1,'','AAURAZO',NULL,NULL,'0000250',1),(251,'2021-02-24 18:17:50','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000251','16142086201108972034',1,'','AAURAZO',NULL,NULL,'0000251',1),(252,'2021-02-24 18:18:11','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000252','16142086721264015542',1,'','AAURAZO',NULL,NULL,'0000252',1),(253,'2021-02-24 18:18:59','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000253','1614208694481439569',1,'','AAURAZO',NULL,NULL,'0000253',1),(254,'2021-02-24 18:19:25','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000254','1614208742684506544',1,'','AAURAZO',NULL,NULL,'0000254',1),(255,'2021-02-24 18:19:46','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000255','1614208768821993085',1,'','AAURAZO',NULL,NULL,'0000255',1),(256,'2021-02-24 18:20:18','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000256','16142087891251235103',1,'','AAURAZO',NULL,NULL,'0000256',1),(257,'2021-02-24 18:21:45','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000257','16142088701081991107',1,'','AAURAZO',NULL,NULL,'0000257',1),(258,'2021-02-24 18:22:37','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000258','1614208909633040534',1,'','AAURAZO',NULL,NULL,'0000258',1),(259,'2021-02-24 18:23:24','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000259','1614208960495812184',1,'','AAURAZO',NULL,NULL,'0000259',1),(260,'2021-02-24 18:24:10','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000260','16142090071300721651',1,'','AAURAZO',NULL,NULL,'0000260',1),(261,'2021-02-24 18:24:34','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000261','1614209053708475246',1,'','AAURAZO',NULL,NULL,'0000261',1),(262,'2021-02-24 18:24:51','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000262','16142090771062325583',1,'','AAURAZO',NULL,NULL,'0000262',1),(263,'2021-02-24 18:25:30','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000263','16142090931038055659',1,'','AAURAZO',NULL,NULL,'0000263',1),(264,'2021-02-24 18:26:20','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000264','1614209133303890439',1,'','AAURAZO',NULL,NULL,'0000264',1),(265,'2021-02-24 18:26:47','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000265','1614209182192179935',1,'','AAURAZO',NULL,NULL,'0000265',1),(266,'2021-02-24 18:27:17','2021-02-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000266','1614209216386554491',1,'','AAURAZO',NULL,NULL,'0000266',1),(267,'2021-02-25 18:40:37','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000267','16142961501175800391',1,'','AAURAZO',NULL,NULL,'0000267',1),(268,'2021-02-25 18:41:09','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000268','1614296440515477708',1,'','AAURAZO',NULL,NULL,'0000268',1),(269,'2021-02-25 18:41:37','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000269','1614296472896696258',1,'','AAURAZO',NULL,NULL,'0000269',1),(270,'2021-02-25 18:42:07','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000270','161429650037695841',1,'','AAURAZO',NULL,NULL,'0000270',1),(271,'2021-02-25 18:44:59','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000271','1614296668145490453',1,'','AAURAZO',NULL,NULL,'0000271',1),(272,'2021-02-25 18:50:57','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000272','1614296702487593113',1,'','AAURAZO',NULL,NULL,'0000272',1),(273,'2021-02-25 18:56:50','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000273','16142973831171497212',1,'','AAURAZO',NULL,NULL,'0000273',1),(274,'2021-02-25 18:58:57','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000274','16142975151264101606',1,'','AAURAZO',NULL,NULL,'0000274',1),(275,'2021-02-25 18:59:24','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000275','1614297540505924652',1,'','AAURAZO',NULL,NULL,'0000275',1),(276,'2021-02-25 18:59:59','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000276','1614297567489529544',1,'','AAURAZO',NULL,NULL,'0000276',1),(277,'2021-02-25 19:00:42','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000277','1614297603131892410',1,'','AAURAZO',NULL,NULL,'0000277',1),(278,'2021-02-25 19:02:51','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000278','1614297749914984765',1,'','AAURAZO',NULL,NULL,'0000278',1),(279,'2021-02-25 19:03:19','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000279','16142977731336136807',1,'','AAURAZO',NULL,NULL,'0000279',1),(280,'2021-02-25 19:05:45','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000280','1614297801718157397',1,'','AAURAZO',NULL,NULL,'0000280',1),(281,'2021-02-25 19:07:37','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000281','1614298037655632219',1,'','AAURAZO',NULL,NULL,'0000281',1),(282,'2021-02-25 19:07:55','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000282','1614298059348213174',1,'','AAURAZO',NULL,NULL,'0000282',1),(283,'2021-02-25 19:08:14','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000283','1614298077189124679',1,'','AAURAZO',NULL,NULL,'0000283',1),(284,'2021-02-25 19:08:45','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000284','1614298096486904605',1,'','AAURAZO',NULL,NULL,'0000284',1),(285,'2021-02-25 19:19:26','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000285','16142987451049545144',1,'','AAURAZO',NULL,NULL,'0000285',1),(286,'2021-02-25 19:19:50','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000286','16142987691193744643',1,'','AAURAZO',NULL,NULL,'0000286',1),(287,'2021-02-25 19:20:21','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000287','1614298794194159397',1,'','AAURAZO',NULL,NULL,'0000287',1),(288,'2021-02-25 19:20:49','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000288','1614298824330441048',1,'','AAURAZO',NULL,NULL,'0000288',1),(289,'2021-02-25 19:21:34','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000289','1614298852365339823',1,'','AAURAZO',NULL,NULL,'0000289',1),(290,'2021-02-25 19:21:55','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000290','1614298898975573513',1,'','AAURAZO',NULL,NULL,'0000290',1),(291,'2021-02-25 19:22:46','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000291','16142989371312125073',1,'','AAURAZO',NULL,NULL,'0000291',1),(292,'2021-02-25 19:23:23','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000292','1614298969427434683',1,'','AAURAZO',NULL,NULL,'0000292',1),(293,'2021-02-25 19:28:58','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000293','1614299006479287980',1,'','AAURAZO',NULL,NULL,'0000293',1),(294,'2021-02-25 19:29:30','2021-02-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000294','1614299349671209724',1,'','AAURAZO',NULL,NULL,'0000294',1),(295,'2021-02-26 11:28:16','2021-02-26',4,1534,1,'GENERADO AUNTOMATICAMENTE','0000295','16143566941022047836',1,'','AAURAZO',NULL,NULL,'0000295',1),(296,'2021-02-26 11:35:34','2021-02-26',4,1534,1,'GENERADO AUNTOMATICAMENTE','0000296','1614357251591213643',1,'','AAURAZO',NULL,NULL,'0000296',1),(297,'2021-02-26 19:11:42','2021-02-26',4,1536,2,'GENERADO AUNTOMATICAMENTE','0000297','16143840231392336314',1,'','AAURAZO',NULL,NULL,'0000297',1),(298,'2021-02-26 19:17:00','2021-02-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000298','1614385006934004812',1,'','AAURAZO',NULL,NULL,'0000298',1),(299,'2021-02-26 19:17:35','2021-02-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000299','1614385024594699217',1,'','AAURAZO',NULL,NULL,'0000299',1),(300,'2021-02-26 19:18:07','2021-02-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000300','16143850571091070813',1,'','AAURAZO',NULL,NULL,'0000300',1),(301,'2021-02-26 19:18:34','2021-02-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000301','1614385089734208252',1,'','AAURAZO',NULL,NULL,'0000301',1),(302,'2021-02-26 19:19:52','2021-02-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000302','16143851611092749053',1,'','AAURAZO',NULL,NULL,'0000302',1),(303,'2021-02-26 19:20:42','2021-02-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000303','1614385194868940759',1,'','AAURAZO',NULL,NULL,'0000303',1),(304,'2021-02-26 19:21:14','2021-02-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000304','161438524524485084',1,'','AAURAZO',NULL,NULL,'0000304',1),(305,'2021-02-26 19:21:34','2021-02-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000305','16143852765422005',1,'','AAURAZO',NULL,NULL,'0000305',1),(306,'2021-02-26 19:23:10','2021-02-26',4,1475,1,'GENERADO AUNTOMATICAMENTE','0000306','161438529898671875',1,'','AAURAZO',NULL,NULL,'0000306',1),(307,'2021-02-26 19:24:35','2021-02-26',4,1475,1,'GENERADO AUNTOMATICAMENTE','0000307','16143853931263585224',1,'','AAURAZO',NULL,NULL,'0000307',1),(308,'2021-02-26 19:28:57','2021-02-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000308','1614385705123243022',1,'','AAURAZO',NULL,NULL,'0000308',1),(309,'2021-02-26 19:29:24','2021-02-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000309','1614385739890198459',1,'','AAURAZO',NULL,NULL,'0000309',1),(310,'2021-02-26 19:29:58','2021-02-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000310','16143857711164827286',1,'','AAURAZO',NULL,NULL,'0000310',1),(311,'2021-02-26 19:30:26','2021-02-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000311','1614385800600379412',1,'','AAURAZO',NULL,NULL,'0000311',1),(312,'2021-02-26 19:30:49','2021-02-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000312','1614385830532862547',1,'','AAURAZO',NULL,NULL,'0000312',1),(313,'2021-02-26 19:31:17','2021-02-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000313','1614385857341930534',1,'','AAURAZO',NULL,NULL,'0000313',1),(314,'2021-02-26 19:31:45','2021-02-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000314','1614385880861754451',1,'','AAURAZO',NULL,NULL,'0000314',1),(315,'2021-02-26 19:32:12','2021-02-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000315','1614385913372741289',1,'','AAURAZO',NULL,NULL,'0000315',1),(316,'2021-02-26 19:33:12','2021-02-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000316','1614385958220580911',1,'','AAURAZO',NULL,NULL,'0000316',1),(317,'2021-02-27 14:31:48','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000317','1614454205407381873',1,'','AAURAZO',NULL,NULL,'0000317',1),(318,'2021-02-27 14:38:09','2021-02-27',4,1521,1,'GENERADO AUNTOMATICAMENTE','0000318','16144545601157727042',1,'','AAURAZO',NULL,NULL,'0000318',1),(319,'2021-02-27 14:43:47','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000319','16144549751396467365',1,'','AAURAZO',NULL,NULL,'0000319',1),(320,'2021-02-27 14:44:15','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000320','1614455030689369136',1,'','AAURAZO',NULL,NULL,'0000320',1),(321,'2021-02-27 14:44:36','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000321','1614455058247992156',1,'','AAURAZO',NULL,NULL,'0000321',1),(322,'2021-02-27 14:45:15','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000322','1614455079776551524',1,'','AAURAZO',NULL,NULL,'0000322',1),(323,'2021-02-27 14:45:45','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000323','1614455119621852271',1,'','AAURAZO',NULL,NULL,'0000323',1),(324,'2021-02-27 14:46:20','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000324','1614455149262967216',1,'','AAURAZO',NULL,NULL,'0000324',1),(325,'2021-02-27 15:03:55','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000325','1614455183843164722',1,'','AAURAZO',NULL,NULL,'0000325',1),(326,'2021-02-27 15:04:40','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000326','1614456238879698704',1,'','AAURAZO',NULL,NULL,'0000326',1),(327,'2021-02-27 15:05:11','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000327','1614456283324330536',1,'','AAURAZO',NULL,NULL,'0000327',1),(328,'2021-02-27 15:05:34','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000328','16144563141286306005',1,'','AAURAZO',NULL,NULL,'0000328',1),(329,'2021-02-27 15:06:02','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000329','16144563371172874229',1,'','AAURAZO',NULL,NULL,'0000329',1),(330,'2021-02-27 15:06:31','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000330','1614456368106417595',1,'','AAURAZO',NULL,NULL,'0000330',1),(331,'2021-02-27 15:06:57','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000331','1614456394234824431',1,'','AAURAZO',NULL,NULL,'0000331',1),(332,'2021-02-27 15:08:01','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000332','1614456430596420488',1,'','AAURAZO',NULL,NULL,'0000332',1),(333,'2021-02-27 15:09:00','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000333','16144564851050104558',1,'','AAURAZO',NULL,NULL,'0000333',1),(334,'2021-02-27 15:09:40','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000334','161445654357060142',1,'','AAURAZO',NULL,NULL,'0000334',1),(335,'2021-02-27 15:10:00','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000335','16144565831192238531',1,'','AAURAZO',NULL,NULL,'0000335',1),(336,'2021-02-27 15:10:35','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000336','1614456603758779399',1,'','AAURAZO',NULL,NULL,'0000336',1),(337,'2021-02-27 15:11:09','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000337','1614456641279749610',1,'','AAURAZO',NULL,NULL,'0000337',1),(338,'2021-02-27 15:11:43','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000338','1614456672252854747',1,'','AAURAZO',NULL,NULL,'0000338',1),(339,'2021-02-27 15:13:44','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000339','1614456705860506530',1,'','AAURAZO',NULL,NULL,'0000339',1),(340,'2021-02-27 15:14:17','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000340','1614456832799444432',1,'','AAURAZO',NULL,NULL,'0000340',1),(341,'2021-02-27 15:14:42','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000341','1614456861415687007',1,'','AAURAZO',NULL,NULL,'0000341',1),(342,'2021-02-27 15:15:28','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000342','16144568851121365187',1,'','AAURAZO',NULL,NULL,'0000342',1),(343,'2021-02-27 15:16:15','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000343','1614456937132451823',1,'','AAURAZO',NULL,NULL,'0000343',1),(344,'2021-02-27 15:17:14','2021-02-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000344','1614457013887315329',1,'','AAURAZO',NULL,NULL,'0000344',1),(345,'2021-03-15 19:23:47','2021-03-15',4,1537,2,'GENERADO AUNTOMATICAMENTE','0000345','161585391535845474',1,'','AAURAZO',NULL,NULL,'0000345',1),(346,'2021-03-18 18:23:08','2021-03-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000346','1616109764195278224',1,'','AAURAZO',NULL,NULL,'0000346',1),(347,'2021-03-18 18:23:44','2021-03-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000347','1616109793797335875',1,'','AAURAZO',NULL,NULL,'0000347',1),(348,'2021-03-18 18:26:23','2021-03-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000348','1616109829453081625',1,'','AAURAZO',NULL,NULL,'0000348',1),(349,'2021-03-18 18:27:30','2021-03-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000349','161610998672766743',1,'','AAURAZO',NULL,NULL,'0000349',1),(350,'2021-03-18 18:28:35','2021-03-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000350','16161100531324173972',1,'','AAURAZO',NULL,NULL,'0000350',1),(351,'2021-03-18 18:29:10','2021-03-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000351','1616110120932369604',1,'','AAURAZO',NULL,NULL,'0000351',1),(352,'2021-03-18 18:30:50','2021-03-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000352','1616110154641345668',1,'','AAURAZO',NULL,NULL,'0000352',1),(353,'2021-03-18 18:32:05','2021-03-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000353','1616110253284181884',1,'','AAURAZO',NULL,NULL,'0000353',1),(354,'2021-03-18 18:33:02','2021-03-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000354','16161103291249944150',1,'','AAURAZO',NULL,NULL,'0000354',1),(355,'2021-03-18 18:33:37','2021-03-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000355','1616110386926259091',1,'','AAURAZO',NULL,NULL,'0000355',1),(356,'2021-03-18 18:34:34','2021-03-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000356','1616110422267829807',1,'','AAURAZO',NULL,NULL,'0000356',1),(357,'2021-03-18 18:35:59','2021-03-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000357','161611047774014664',1,'','AAURAZO',NULL,NULL,'0000357',1),(358,'2021-03-18 18:36:57','2021-03-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000358','161611056387741802',1,'','AAURAZO',NULL,NULL,'0000358',1),(359,'2021-03-25 18:33:55','2021-03-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000359','16167152141315954902',1,'','AAURAZO',NULL,NULL,'0000359',1),(360,'2021-03-25 18:34:14','2021-03-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000360','16167152381083239029',1,'','AAURAZO',NULL,NULL,'0000360',1),(361,'2021-03-25 18:34:40','2021-03-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000361','1616715256286075282',1,'','AAURAZO',NULL,NULL,'0000361',1),(362,'2021-03-25 18:35:01','2021-03-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000362','1616715282398947644',1,'','AAURAZO',NULL,NULL,'0000362',1),(363,'2021-03-25 18:35:36','2021-03-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000363','16167153031031557860',1,'','AAURAZO',NULL,NULL,'0000363',1),(364,'2021-03-25 18:36:07','2021-03-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000364','1616715339908917283',1,'','AAURAZO',NULL,NULL,'0000364',1),(365,'2021-03-25 18:36:30','2021-03-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000365','16167153691297537300',1,'','AAURAZO',NULL,NULL,'0000365',1),(366,'2021-03-25 18:36:52','2021-03-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000366','1616715392121005369',1,'','AAURAZO',NULL,NULL,'0000366',1),(367,'2021-03-25 18:37:22','2021-03-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000367','1616715415432555465',1,'','AAURAZO',NULL,NULL,'0000367',1),(368,'2021-03-25 18:38:16','2021-03-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000368','1616715444846306042',1,'','AAURAZO',NULL,NULL,'0000368',1),(369,'2021-03-25 18:38:38','2021-03-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000369','1616715499529463037',1,'','AAURAZO',NULL,NULL,'0000369',1),(370,'2021-03-25 18:39:11','2021-03-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000370','16167155211092619957',1,'','AAURAZO',NULL,NULL,'0000370',1),(371,'2021-03-25 18:40:51','2021-03-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000371','1616715553200054751',1,'','AAURAZO',NULL,NULL,'0000371',1),(372,'2021-03-25 18:41:37','2021-03-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000372','1616715654838345162',1,'','AAURAZO',NULL,NULL,'0000372',1),(373,'2021-03-29 18:08:55','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000373','161705931075735935',1,'','AAURAZO',NULL,NULL,'0000373',1),(374,'2021-03-29 18:09:41','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000374','161705933946775547',1,'','AAURAZO',NULL,NULL,'0000374',1),(375,'2021-03-29 18:10:13','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000375','16170593841271632167',1,'','AAURAZO',NULL,NULL,'0000375',1),(376,'2021-03-29 18:10:35','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000376','1617059416540307045',1,'','AAURAZO',NULL,NULL,'0000376',1),(377,'2021-03-29 18:11:01','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000377','1617059438885766185',1,'','AAURAZO',NULL,NULL,'0000377',1),(378,'2021-03-29 18:11:32','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000378','16170594641072997465',1,'','AAURAZO',NULL,NULL,'0000378',1),(379,'2021-03-29 18:12:18','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000379','1617059494459321233',1,'','AAURAZO',NULL,NULL,'0000379',1),(380,'2021-03-29 18:12:46','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000380','1617059541999413119',1,'','AAURAZO',NULL,NULL,'0000380',1),(381,'2021-03-29 18:13:21','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000381','1617059569249024918',1,'','AAURAZO',NULL,NULL,'0000381',1),(382,'2021-03-29 18:13:41','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000382','1617059604642593589',1,'','AAURAZO',NULL,NULL,'0000382',1),(383,'2021-03-29 18:15:06','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000383','1617059623672414614',1,'','AAURAZO',NULL,NULL,'0000383',1),(384,'2021-03-29 18:15:29','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000384','1617059709439999963',1,'','AAURAZO',NULL,NULL,'0000384',1),(385,'2021-03-29 18:16:00','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000385','16170597371071491353',1,'','AAURAZO',NULL,NULL,'0000385',1),(386,'2021-03-29 18:16:42','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000386','16170597631023941235',1,'','AAURAZO',NULL,NULL,'0000386',1),(387,'2021-03-29 18:17:07','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000387','1617059804855816065',1,'','AAURAZO',NULL,NULL,'0000387',1),(388,'2021-03-29 18:17:28','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000388','1617059829939771071',1,'','AAURAZO',NULL,NULL,'0000388',1),(389,'2021-03-29 18:18:13','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000389','1617059855902978898',1,'','AAURAZO',NULL,NULL,'0000389',1),(390,'2021-03-29 18:18:43','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000390','1617059896663334908',1,'','AAURAZO',NULL,NULL,'0000390',1),(391,'2021-03-29 18:19:03','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000391','16170599261374004775',1,'','AAURAZO',NULL,NULL,'0000391',1),(392,'2021-03-29 18:19:46','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000392','16170599451315997934',1,'','AAURAZO',NULL,NULL,'0000392',1),(393,'2021-03-29 18:20:12','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000393','1617059988344555473',1,'','AAURAZO',NULL,NULL,'0000393',1),(394,'2021-03-29 18:20:59','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000394','1617060019390556447',1,'','AAURAZO',NULL,NULL,'0000394',1),(395,'2021-03-29 18:21:39','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000395','16170600621155446358',1,'','AAURAZO',NULL,NULL,'0000395',1),(396,'2021-03-29 18:22:17','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000396','161706010248109532',1,'','AAURAZO',NULL,NULL,'0000396',1),(397,'2021-03-29 18:22:41','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000397','16170601401146366652',1,'','AAURAZO',NULL,NULL,'0000397',1),(398,'2021-03-29 18:23:19','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000398','16170601641357007221',1,'','AAURAZO',NULL,NULL,'0000398',1),(399,'2021-03-29 18:23:47','2021-03-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000399','1617060202774442967',1,'','AAURAZO',NULL,NULL,'0000399',1),(400,'2021-03-31 16:22:45','2021-03-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0000400','161722573793034711',1,'','AAURAZO',NULL,NULL,'0000400',1),(401,'2021-03-31 16:23:17','2021-03-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0000401','1617225768656449823',1,'','AAURAZO',NULL,NULL,'0000401',1),(402,'2021-03-31 16:24:12','2021-03-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0000402','1617225801974626813',1,'','AAURAZO',NULL,NULL,'0000402',1),(403,'2021-03-31 16:24:55','2021-03-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0000403','1617225854636095790',1,'','AAURAZO',NULL,NULL,'0000403',1),(404,'2021-03-31 16:25:22','2021-03-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0000404','161722589735329093',1,'','AAURAZO',NULL,NULL,'0000404',1),(405,'2021-03-31 16:25:54','2021-03-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0000405','1617225925973206765',1,'','AAURAZO',NULL,NULL,'0000405',1),(406,'2021-03-31 16:26:38','2021-03-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0000406','1617225957726376467',1,'','AAURAZO',NULL,NULL,'0000406',1),(407,'2021-03-31 16:27:19','2021-03-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0000407','16172260011100795996',1,'','AAURAZO',NULL,NULL,'0000407',1),(408,'2021-03-31 16:27:36','2021-03-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0000408','1617226042996271799',1,'','AAURAZO',NULL,NULL,'0000408',1),(409,'2021-03-31 16:28:17','2021-03-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0000409','16172260641095115801',1,'','AAURAZO',NULL,NULL,'0000409',1),(410,'2021-03-31 16:28:56','2021-03-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0000410','1617226100834472302',1,'','AAURAZO',NULL,NULL,'0000410',1),(411,'2021-03-31 16:29:22','2021-03-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0000411','1617226139392665004',1,'','AAURAZO',NULL,NULL,'0000411',1),(412,'2021-03-31 16:30:30','2021-03-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0000412','1617226165390814638',1,'','AAURAZO',NULL,NULL,'0000412',1),(413,'2021-03-31 16:31:46','2021-03-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0000413','1617226233601713397',1,'','AAURAZO',NULL,NULL,'0000413',1),(414,'2021-03-31 16:32:19','2021-03-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0000414','1617226310113345712',1,'','AAURAZO',NULL,NULL,'0000414',1),(415,'2021-03-31 16:33:27','2021-03-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0000415','1617226342773238077',1,'','AAURAZO',NULL,NULL,'0000415',1),(416,'2021-03-31 16:34:04','2021-03-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0000416','1617226415937791609',1,'','AAURAZO',NULL,NULL,'0000416',1),(417,'2021-03-31 16:34:31','2021-03-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0000417','1617226447144414658',1,'','AAURAZO',NULL,NULL,'0000417',1),(418,'2021-03-31 16:35:01','2021-03-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0000418','16172264731380029224',1,'','AAURAZO',NULL,NULL,'0000418',1),(419,'2021-03-31 16:35:24','2021-03-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0000419','1617226504271358413',1,'','AAURAZO',NULL,NULL,'0000419',1),(420,'2021-03-31 16:36:06','2021-03-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0000420','1617226527114679697',1,'','AAURAZO',NULL,NULL,'0000420',1),(421,'2021-03-31 16:37:10','2021-03-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0000421','16172265741002769598',1,'','AAURAZO',NULL,NULL,'0000421',1),(422,'2021-03-31 16:37:35','2021-03-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0000422','1617226633286161346',1,'','AAURAZO',NULL,NULL,'0000422',1),(423,'2021-03-31 16:38:12','2021-03-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0000423','1617226664222560373',1,'','AAURAZO',NULL,NULL,'0000423',1),(424,'2021-04-23 18:12:46','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000424','16192195381206309923',1,'','AAURAZO',NULL,NULL,'0000424',1),(425,'2021-04-23 18:13:05','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000425','1619219569882151515',1,'','AAURAZO',NULL,NULL,'0000425',1),(426,'2021-04-23 18:13:28','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000426','1619219587295327115',1,'','AAURAZO',NULL,NULL,'0000426',1),(427,'2021-04-23 18:13:52','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000427','1619219611355012196',1,'','AAURAZO',NULL,NULL,'0000427',1),(428,'2021-04-23 18:14:35','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000428','1619219635230435189',1,'','AAURAZO',NULL,NULL,'0000428',1),(429,'2021-04-23 18:15:07','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000429','161921967766355007',1,'','AAURAZO',NULL,NULL,'0000429',1),(430,'2021-04-23 18:15:33','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000430','16192197091226879115',1,'','AAURAZO',NULL,NULL,'0000430',1),(431,'2021-04-23 18:16:14','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000431','1619219735904571074',1,'','AAURAZO',NULL,NULL,'0000431',1),(432,'2021-04-23 18:16:35','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000432','161921977626163323',1,'','AAURAZO',NULL,NULL,'0000432',1),(433,'2021-04-23 18:17:17','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000433','1619219798150611235',1,'','AAURAZO',NULL,NULL,'0000433',1),(434,'2021-04-23 18:17:40','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000434','1619219840438795074',1,'','AAURAZO',NULL,NULL,'0000434',1),(435,'2021-04-23 18:18:06','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000435','1619219862131246933',1,'','AAURAZO',NULL,NULL,'0000435',1),(436,'2021-04-23 18:18:34','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000436','16192198881193228262',1,'','AAURAZO',NULL,NULL,'0000436',1),(437,'2021-04-23 18:18:57','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000437','1619219916629468896',1,'','AAURAZO',NULL,NULL,'0000437',1),(438,'2021-04-23 18:19:18','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000438','1619219939379841533',1,'','AAURAZO',NULL,NULL,'0000438',1),(439,'2021-04-23 18:19:49','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000439','16192199611391604773',1,'','AAURAZO',NULL,NULL,'0000439',1),(440,'2021-04-23 18:20:17','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000440','16192199921195853201',1,'','AAURAZO',NULL,NULL,'0000440',1),(441,'2021-04-23 18:20:46','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000441','1619220020492240546',1,'','AAURAZO',NULL,NULL,'0000441',1),(442,'2021-04-23 18:21:09','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000442','1619220049744708006',1,'','AAURAZO',NULL,NULL,'0000442',1),(443,'2021-04-23 18:21:28','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000443','1619220072129482630',1,'','AAURAZO',NULL,NULL,'0000443',1),(444,'2021-04-23 18:21:49','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000444','16192200911403438513',1,'','AAURAZO',NULL,NULL,'0000444',1),(445,'2021-04-23 18:22:13','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000445','16192201121238024346',1,'','AAURAZO',NULL,NULL,'0000445',1),(446,'2021-04-23 18:22:32','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000446','1619220136565437606',1,'','AAURAZO',NULL,NULL,'0000446',1),(447,'2021-04-23 18:22:58','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000447','1619220155382122218',1,'','AAURAZO',NULL,NULL,'0000447',1),(448,'2021-04-23 18:23:24','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000448','16192201811215174470',1,'','AAURAZO',NULL,NULL,'0000448',1),(449,'2021-04-23 18:24:04','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000449','1619220206637386744',1,'','AAURAZO',NULL,NULL,'0000449',1),(450,'2021-04-23 18:24:44','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000450','1619220247357120753',1,'','AAURAZO',NULL,NULL,'0000450',1),(451,'2021-04-23 18:25:22','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000451','1619220287435395563',1,'','AAURAZO',NULL,NULL,'0000451',1),(452,'2021-04-23 18:25:49','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000452','161922032417772126',1,'','AAURAZO',NULL,NULL,'0000452',1),(453,'2021-04-23 18:26:25','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000453','1619220351263010247',1,'','AAURAZO',NULL,NULL,'0000453',1),(454,'2021-04-23 18:26:56','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000454','16192203941255538281',1,'','AAURAZO',NULL,NULL,'0000454',1),(455,'2021-04-23 18:27:36','2021-04-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0000455','1619220419545944209',1,'','AAURAZO',NULL,NULL,'0000455',1),(456,'2021-04-26 18:33:20','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000456','1619479984243258660',1,'','AAURAZO',NULL,NULL,'0000456',1),(457,'2021-04-26 18:33:50','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000457','1619480006536692376',1,'','AAURAZO',NULL,NULL,'0000457',1),(458,'2021-04-26 18:34:18','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000458','1619480033638548602',1,'','AAURAZO',NULL,NULL,'0000458',1),(459,'2021-04-26 18:34:44','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000459','1619480061995884513',1,'','AAURAZO',NULL,NULL,'0000459',1),(460,'2021-04-26 18:35:11','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000460','161948008782707084',1,'','AAURAZO',NULL,NULL,'0000460',1),(461,'2021-04-26 18:35:33','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000461','1619480114602531001',1,'','AAURAZO',NULL,NULL,'0000461',1),(462,'2021-04-26 18:35:56','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000462','16194801371220424348',1,'','AAURAZO',NULL,NULL,'0000462',1),(463,'2021-04-26 18:36:18','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000463','1619480158264215137',1,'','AAURAZO',NULL,NULL,'0000463',1),(464,'2021-04-26 18:36:38','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000464','1619480181496199470',1,'','AAURAZO',NULL,NULL,'0000464',1),(465,'2021-04-26 18:37:04','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000465','1619480201129138376',1,'','AAURAZO',NULL,NULL,'0000465',1),(466,'2021-04-26 18:37:26','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000466','1619480226227465996',1,'','AAURAZO',NULL,NULL,'0000466',1),(467,'2021-04-26 18:38:04','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000467','1619480262855643938',1,'','AAURAZO',NULL,NULL,'0000467',1),(468,'2021-04-26 18:38:24','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000468','1619480287164166246',1,'','AAURAZO',NULL,NULL,'0000468',1),(469,'2021-04-26 18:39:31','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000469','16194803481084874237',1,'','AAURAZO',NULL,NULL,'0000469',1),(470,'2021-04-26 18:41:58','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000470','1619480484938523149',1,'','AAURAZO',NULL,NULL,'0000470',1),(471,'2021-04-26 18:42:44','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000471','1619480521421539329',1,'','AAURAZO',NULL,NULL,'0000471',1),(472,'2021-04-26 18:43:11','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000472','1619480566310904620',1,'','AAURAZO',NULL,NULL,'0000472',1),(473,'2021-04-26 18:43:42','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000473','1619480594367147158',1,'','AAURAZO',NULL,NULL,'0000473',1),(474,'2021-04-26 18:44:20','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000474','16194806251148561273',1,'','AAURAZO',NULL,NULL,'0000474',1),(475,'2021-04-26 18:44:47','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000475','1619480662737607762',1,'','AAURAZO',NULL,NULL,'0000475',1),(476,'2021-04-26 18:45:56','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000476','1619480731440344218',1,'','AAURAZO',NULL,NULL,'0000476',1),(477,'2021-04-26 18:46:57','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000477','16194807961270556373',1,'','AAURAZO',NULL,NULL,'0000477',1),(478,'2021-04-26 18:47:25','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000478','1619480819781285020',1,'','AAURAZO',NULL,NULL,'0000478',1),(479,'2021-04-26 18:48:16','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000479','1619480854822982816',1,'','AAURAZO',NULL,NULL,'0000479',1),(480,'2021-04-26 18:51:45','2021-04-26',4,1521,1,'GENERADO AUNTOMATICAMENTE','0000480','16194809131009912874',1,'','AAURAZO',NULL,NULL,'0000480',1),(481,'2021-04-26 18:59:03','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000481','16194815021121924600',1,'','AAURAZO',NULL,NULL,'0000481',1),(482,'2021-04-26 18:59:34','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000482','1619481545838173035',1,'','AAURAZO',NULL,NULL,'0000482',1),(483,'2021-04-26 19:00:03','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000483','1619481577563759366',1,'','AAURAZO',NULL,NULL,'0000483',1),(484,'2021-04-26 19:01:07','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000484','16194816311087154921',1,'','AAURAZO',NULL,NULL,'0000484',1),(485,'2021-04-26 19:01:35','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000485','1619481672284526138',1,'','AAURAZO',NULL,NULL,'0000485',1),(486,'2021-04-26 19:02:00','2021-04-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000486','1619481697294810734',1,'','AAURAZO',NULL,NULL,'0000486',1),(487,'2021-04-27 18:19:34','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000487','1619565549636009727',1,'','AAURAZO',NULL,NULL,'0000487',1),(488,'2021-04-27 18:20:03','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000488','1619565576107880676',1,'','AAURAZO',NULL,NULL,'0000488',1),(489,'2021-04-27 18:20:18','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000489','1619565605445034682',1,'','AAURAZO',NULL,NULL,'0000489',1),(490,'2021-04-27 18:20:47','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000490','1619565621352387257',1,'','AAURAZO',NULL,NULL,'0000490',1),(491,'2021-04-27 18:21:05','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000491','1619565649195536414',1,'','AAURAZO',NULL,NULL,'0000491',1),(492,'2021-04-27 18:21:36','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000492','1619565668661613637',1,'','AAURAZO',NULL,NULL,'0000492',1),(493,'2021-04-27 18:22:07','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000493','1619565699379798502',1,'','AAURAZO',NULL,NULL,'0000493',1),(494,'2021-04-27 18:22:27','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000494','1619565730109300725',1,'','AAURAZO',NULL,NULL,'0000494',1),(495,'2021-04-27 18:22:49','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000495','16195657491363031671',1,'','AAURAZO',NULL,NULL,'0000495',1),(496,'2021-04-27 18:23:16','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000496','1619565773112011727',1,'','AAURAZO',NULL,NULL,'0000496',1),(497,'2021-04-27 18:23:35','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000497','16195657981192754912',1,'','AAURAZO',NULL,NULL,'0000497',1),(498,'2021-04-27 18:24:05','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000498','1619565817299673325',1,'','AAURAZO',NULL,NULL,'0000498',1),(499,'2021-04-27 18:24:28','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000499','1619565847468357907',1,'','AAURAZO',NULL,NULL,'0000499',1),(500,'2021-04-27 18:25:07','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000500','161956587486106595',1,'','AAURAZO',NULL,NULL,'0000500',1),(501,'2021-04-27 18:25:42','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000501','1619565910469734924',1,'','AAURAZO',NULL,NULL,'0000501',1),(502,'2021-04-27 18:25:58','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000502','161956594575133491',1,'','AAURAZO',NULL,NULL,'0000502',1),(503,'2021-04-27 18:26:37','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000503','1619565961554636629',1,'','AAURAZO',NULL,NULL,'0000503',1),(504,'2021-04-27 18:27:15','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000504','1619566003317230292',1,'','AAURAZO',NULL,NULL,'0000504',1),(505,'2021-04-27 18:27:41','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000505','1619566038926517282',1,'','AAURAZO',NULL,NULL,'0000505',1),(506,'2021-04-27 18:28:10','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000506','16195660681266425322',1,'','AAURAZO',NULL,NULL,'0000506',1),(507,'2021-04-27 18:28:39','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000507','1619566093252983842',1,'','AAURAZO',NULL,NULL,'0000507',1),(508,'2021-04-27 18:30:04','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000508','1619566175798755923',1,'','AAURAZO',NULL,NULL,'0000508',1),(509,'2021-04-27 18:31:02','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000509','16195662421275332901',1,'','AAURAZO',NULL,NULL,'0000509',1),(510,'2021-04-27 18:31:34','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000510','1619566265508463527',1,'','AAURAZO',NULL,NULL,'0000510',1),(511,'2021-04-27 18:32:07','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000511','161956629679910018',1,'','AAURAZO',NULL,NULL,'0000511',1),(512,'2021-04-27 18:32:34','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000512','161956633553187282',1,'','AAURAZO',NULL,NULL,'0000512',1),(513,'2021-04-27 18:33:01','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000513','1619566357990505541',1,'','AAURAZO',NULL,NULL,'0000513',1),(514,'2021-04-27 18:33:22','2021-04-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000514','1619566383973938305',1,'','AAURAZO',NULL,NULL,'0000514',1),(515,'2021-04-29 13:35:07','2021-04-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000515','161972129256113443',1,'','AAURAZO',NULL,NULL,'0000515',1),(516,'2021-04-29 13:35:38','2021-04-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000516','1619721310400625884',1,'','AAURAZO',NULL,NULL,'0000516',1),(517,'2021-04-29 13:36:07','2021-04-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000517','16197213411127303573',1,'','AAURAZO',NULL,NULL,'0000517',1),(518,'2021-04-29 13:37:05','2021-04-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000518','1619721398518231742',1,'','AAURAZO',NULL,NULL,'0000518',1),(519,'2021-04-29 13:37:37','2021-04-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000519','16197214281395176411',1,'','AAURAZO',NULL,NULL,'0000519',1),(520,'2021-04-29 13:38:03','2021-04-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000520','1619721460538714870',1,'','AAURAZO',NULL,NULL,'0000520',1),(521,'2021-04-29 13:39:02','2021-04-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000521','1619721511999886469',1,'','AAURAZO',NULL,NULL,'0000521',1),(522,'2021-04-29 13:39:40','2021-04-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000522','1619721547754045903',1,'','AAURAZO',NULL,NULL,'0000522',1),(523,'2021-04-29 13:40:27','2021-04-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000523','16197215821283508939',1,'','AAURAZO',NULL,NULL,'0000523',1),(524,'2021-04-29 13:41:06','2021-04-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000524','1619721630666390164',1,'','AAURAZO',NULL,NULL,'0000524',1),(525,'2021-04-29 13:41:52','2021-04-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000525','16197216751048598445',1,'','AAURAZO',NULL,NULL,'0000525',1),(526,'2021-04-29 13:42:16','2021-04-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000526','1619721714581746651',1,'','AAURAZO',NULL,NULL,'0000526',1),(527,'2021-04-29 13:43:06','2021-04-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000527','16197217401288414562',1,'','AAURAZO',NULL,NULL,'0000527',1),(528,'2021-04-29 13:44:01','2021-04-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000528','16197217891070888908',1,'','AAURAZO',NULL,NULL,'0000528',1),(529,'2021-04-29 13:45:07','2021-04-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000529','1619721861121736910',1,'','AAURAZO',NULL,NULL,'0000529',1),(530,'2021-04-30 18:33:42','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000530','1619825597562468413',1,'','AAURAZO',NULL,NULL,'0000530',1),(531,'2021-04-30 18:34:49','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000531','16198256701246673734',1,'','AAURAZO',NULL,NULL,'0000531',1),(532,'2021-04-30 18:35:20','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000532','16198256921283939257',1,'','AAURAZO',NULL,NULL,'0000532',1),(533,'2021-04-30 18:35:44','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000533','1619825722303632249',1,'','AAURAZO',NULL,NULL,'0000533',1),(534,'2021-04-30 18:36:04','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000534','16198257471109144161',1,'','AAURAZO',NULL,NULL,'0000534',1),(535,'2021-04-30 18:36:33','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000535','16198257661009095270',1,'','AAURAZO',NULL,NULL,'0000535',1),(536,'2021-04-30 18:36:55','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000536','161982579541353542',1,'','AAURAZO',NULL,NULL,'0000536',1),(537,'2021-04-30 18:37:15','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000537','1619825818697028793',1,'','AAURAZO',NULL,NULL,'0000537',1),(538,'2021-04-30 18:37:36','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000538','1619825837124792166',1,'','AAURAZO',NULL,NULL,'0000538',1),(539,'2021-04-30 18:38:01','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000539','1619825858994335369',1,'','AAURAZO',NULL,NULL,'0000539',1),(540,'2021-04-30 18:38:20','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000540','1619825883498394091',1,'','AAURAZO',NULL,NULL,'0000540',1),(541,'2021-04-30 18:38:43','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000541','1619825903492498737',1,'','AAURAZO',NULL,NULL,'0000541',1),(542,'2021-04-30 18:39:10','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000542','1619825926841228292',1,'','AAURAZO',NULL,NULL,'0000542',1),(543,'2021-04-30 18:39:39','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000543','1619825953527053257',1,'','AAURAZO',NULL,NULL,'0000543',1),(544,'2021-04-30 18:40:14','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000544','1619825982303933471',1,'','AAURAZO',NULL,NULL,'0000544',1),(545,'2021-04-30 18:40:31','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000545','1619826018108181898',1,'','AAURAZO',NULL,NULL,'0000545',1),(546,'2021-04-30 18:40:52','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000546','1619826034150180917',1,'','AAURAZO',NULL,NULL,'0000546',1),(547,'2021-04-30 18:41:09','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000547','16198260551387990104',1,'','AAURAZO',NULL,NULL,'0000547',1),(548,'2021-04-30 18:41:43','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000548','161982607112823471',1,'','AAURAZO',NULL,NULL,'0000548',1),(549,'2021-04-30 18:42:09','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000549','16198261101356146586',1,'','AAURAZO',NULL,NULL,'0000549',1),(550,'2021-04-30 18:42:29','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000550','161982613165666499',1,'','AAURAZO',NULL,NULL,'0000550',1),(551,'2021-04-30 18:43:00','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000551','1619826151742599449',1,'','AAURAZO',NULL,NULL,'0000551',1),(552,'2021-04-30 18:43:29','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000552','16198261831201963714',1,'','AAURAZO',NULL,NULL,'0000552',1),(553,'2021-04-30 18:44:06','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000553','1619826212557132472',1,'','AAURAZO',NULL,NULL,'0000553',1),(554,'2021-04-30 18:44:37','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000554','16198262501033365195',1,'','AAURAZO',NULL,NULL,'0000554',1),(555,'2021-04-30 18:45:04','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000555','1619826280732788203',1,'','AAURAZO',NULL,NULL,'0000555',1),(556,'2021-04-30 18:45:32','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000556','1619826307259610737',1,'','AAURAZO',NULL,NULL,'0000556',1),(557,'2021-04-30 18:46:20','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000557','1619826340642765717',1,'','AAURAZO',NULL,NULL,'0000557',1),(558,'2021-04-30 18:47:06','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000558','16198263831371594995',1,'','AAURAZO',NULL,NULL,'0000558',1),(559,'2021-04-30 18:47:32','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000559','1619826430757875731',1,'','AAURAZO',NULL,NULL,'0000559',1),(560,'2021-04-30 18:48:03','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000560','1619826455386468428',1,'','AAURAZO',NULL,NULL,'0000560',1),(561,'2021-04-30 18:48:31','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000561','1619826485902591612',1,'','AAURAZO',NULL,NULL,'0000561',1),(562,'2021-04-30 18:49:04','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000562','16198265171012451749',1,'','AAURAZO',NULL,NULL,'0000562',1),(563,'2021-04-30 18:49:39','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000563','161982654731972614',1,'','AAURAZO',NULL,NULL,'0000563',1),(564,'2021-04-30 18:50:08','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000564','1619826582982587693',1,'','AAURAZO',NULL,NULL,'0000564',1),(565,'2021-04-30 18:50:42','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000565','161982662567904151',1,'','AAURAZO',NULL,NULL,'0000565',1),(566,'2021-04-30 18:51:26','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000566','16198266451008707984',1,'','AAURAZO',NULL,NULL,'0000566',1),(567,'2021-04-30 18:51:51','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000567','1619826689497318296',1,'','AAURAZO',NULL,NULL,'0000567',1),(568,'2021-04-30 18:52:23','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000568','1619826713935338797',1,'','AAURAZO',NULL,NULL,'0000568',1),(569,'2021-04-30 18:53:24','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000569','16198267711072868370',1,'','AAURAZO',NULL,NULL,'0000569',1),(570,'2021-04-30 18:53:39','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000570','1619826806694360822',1,'','AAURAZO',NULL,NULL,'0000570',1),(571,'2021-04-30 18:54:12','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000571','1619826821350321731',1,'','AAURAZO',NULL,NULL,'0000571',1),(572,'2021-04-30 18:54:35','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000572','1619826854526709003',1,'','AAURAZO',NULL,NULL,'0000572',1),(573,'2021-04-30 18:55:04','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000573','1619826878594139804',1,'','AAURAZO',NULL,NULL,'0000573',1),(574,'2021-04-30 18:55:33','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000574','1619826911857623400',1,'','AAURAZO',NULL,NULL,'0000574',1),(575,'2021-04-30 18:55:55','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000575','1619826935826253232',1,'','AAURAZO',NULL,NULL,'0000575',1),(576,'2021-04-30 18:56:17','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000576','1619826958270196555',1,'','AAURAZO',NULL,NULL,'0000576',1),(577,'2021-04-30 18:56:49','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000577','1619826980389093366',1,'','AAURAZO',NULL,NULL,'0000577',1),(578,'2021-04-30 18:57:20','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000578','16198270121185095255',1,'','AAURAZO',NULL,NULL,'0000578',1),(579,'2021-04-30 18:57:55','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000579','16198270461140299171',1,'','AAURAZO',NULL,NULL,'0000579',1),(580,'2021-04-30 18:59:18','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000580','1619827132200915387',1,'','AAURAZO',NULL,NULL,'0000580',1),(581,'2021-04-30 18:59:45','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000581','1619827161980436104',1,'','AAURAZO',NULL,NULL,'0000581',1),(582,'2021-04-30 19:00:34','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000582','1619827188229918808',1,'','AAURAZO',NULL,NULL,'0000582',1),(583,'2021-04-30 19:01:12','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000583','1619827237501664506',1,'','AAURAZO',NULL,NULL,'0000583',1),(584,'2021-04-30 19:02:03','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000584','1619827302381347646',1,'','AAURAZO',NULL,NULL,'0000584',1),(585,'2021-04-30 19:02:41','2021-04-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0000585','1619827325856676701',1,'','AAURAZO',NULL,NULL,'0000585',1),(586,'2021-05-04 17:31:43','2021-05-04',4,1,2,'GENERADO AUNTOMATICAMENTE','0000586','1620167468808050788',1,'','AAURAZO',NULL,NULL,'0000586',1),(587,'2021-05-04 17:32:03','2021-05-04',4,1,2,'GENERADO AUNTOMATICAMENTE','0000587','1620167507903495279',1,'','AAURAZO',NULL,NULL,'0000587',1),(588,'2021-05-04 17:40:37','2021-05-04',4,1,2,'GENERADO AUNTOMATICAMENTE','0000588','1620167526228025409',1,'','AAURAZO',NULL,NULL,'0000588',1),(589,'2021-05-04 17:40:56','2021-05-04',4,1,2,'GENERADO AUNTOMATICAMENTE','0000589','1620168041314002908',1,'','AAURAZO',NULL,NULL,'0000589',1),(590,'2021-05-04 17:41:38','2021-05-04',4,1,2,'GENERADO AUNTOMATICAMENTE','0000590','1620168059365167696',1,'','AAURAZO',NULL,NULL,'0000590',1),(591,'2021-05-04 17:42:20','2021-05-04',4,1,2,'GENERADO AUNTOMATICAMENTE','0000591','1620168101960813612',1,'','AAURAZO',NULL,NULL,'0000591',1),(592,'2021-05-04 17:42:48','2021-05-04',4,1,2,'GENERADO AUNTOMATICAMENTE','0000592','1620168142687733928',1,'','AAURAZO',NULL,NULL,'0000592',1),(593,'2021-05-04 17:43:19','2021-05-04',4,1,2,'GENERADO AUNTOMATICAMENTE','0000593','16201681711260960286',1,'','AAURAZO',NULL,NULL,'0000593',1),(594,'2021-05-04 17:53:29','2021-05-04',4,1,2,'GENERADO AUNTOMATICAMENTE','0000594','1620168788516553502',1,'','AAURAZO',NULL,NULL,'0000594',1),(595,'2021-05-04 17:53:54','2021-05-04',4,1,2,'GENERADO AUNTOMATICAMENTE','0000595','1620168812694834172',1,'','AAURAZO',NULL,NULL,'0000595',1),(596,'2021-05-04 17:56:22','2021-05-04',4,1,2,'GENERADO AUNTOMATICAMENTE','0000596','1620168961498738345',1,'','AAURAZO',NULL,NULL,'0000596',1),(597,'2021-05-04 17:58:31','2021-05-04',4,1,2,'GENERADO AUNTOMATICAMENTE','0000597','1620169075202292404',1,'','AAURAZO',NULL,NULL,'0000597',1),(598,'2021-05-04 18:00:40','2021-05-04',4,1,2,'GENERADO AUNTOMATICAMENTE','0000598','1620169204576195551',1,'','AAURAZO',NULL,NULL,'0000598',1),(599,'2021-05-04 18:01:30','2021-05-04',4,1,2,'GENERADO AUNTOMATICAMENTE','0000599','16201692421314750012',1,'','AAURAZO',NULL,NULL,'0000599',1),(600,'2021-05-04 18:01:57','2021-05-04',4,1,2,'GENERADO AUNTOMATICAMENTE','0000600','16201692931178941711',1,'','AAURAZO',NULL,NULL,'0000600',1),(601,'2021-05-04 18:14:13','2021-05-04',4,1,2,'GENERADO AUNTOMATICAMENTE','0000601','1620170034495855215',1,'','AAURAZO',NULL,NULL,'0000601',1),(602,'2021-05-11 18:47:41','2021-05-11',4,1538,1,'GENERADO AUNTOMATICAMENTE','0000602','1620776551608899705',1,'','AAURAZO',NULL,NULL,'0000602',1),(603,'2021-05-11 18:55:48','2021-05-11',4,1,2,'GENERADO AUNTOMATICAMENTE','0000603','1620777326651974518',1,'','AAURAZO',NULL,NULL,'0000603',1),(604,'2021-05-11 18:56:11','2021-05-11',4,1,2,'GENERADO AUNTOMATICAMENTE','0000604','162077735145183371',1,'','AAURAZO',NULL,NULL,'0000604',1),(605,'2021-05-11 18:56:35','2021-05-11',4,1,2,'GENERADO AUNTOMATICAMENTE','0000605','1620777373421410234',1,'','AAURAZO',NULL,NULL,'0000605',1),(606,'2021-05-11 18:56:52','2021-05-11',4,1,2,'GENERADO AUNTOMATICAMENTE','0000606','16207773991231913833',1,'','AAURAZO',NULL,NULL,'0000606',1),(607,'2021-05-11 18:57:22','2021-05-11',4,1,2,'GENERADO AUNTOMATICAMENTE','0000607','16207774151043348568',1,'','AAURAZO',NULL,NULL,'0000607',1),(608,'2021-05-11 18:57:50','2021-05-11',4,1,2,'GENERADO AUNTOMATICAMENTE','0000608','16207774451154069341',1,'','AAURAZO',NULL,NULL,'0000608',1),(609,'2021-05-11 18:58:21','2021-05-11',4,1,2,'GENERADO AUNTOMATICAMENTE','0000609','1620777472972991606',1,'','AAURAZO',NULL,NULL,'0000609',1),(610,'2021-05-11 18:58:50','2021-05-11',4,1,2,'GENERADO AUNTOMATICAMENTE','0000610','16207775031208934862',1,'','AAURAZO',NULL,NULL,'0000610',1),(611,'2021-05-11 18:59:15','2021-05-11',4,1,2,'GENERADO AUNTOMATICAMENTE','0000611','1620777533784426340',1,'','AAURAZO',NULL,NULL,'0000611',1),(612,'2021-05-11 18:59:48','2021-05-11',4,1,2,'GENERADO AUNTOMATICAMENTE','0000612','16207775581193529484',1,'','AAURAZO',NULL,NULL,'0000612',1),(613,'2021-05-11 19:00:12','2021-05-11',4,1,2,'GENERADO AUNTOMATICAMENTE','0000613','1620777590687733928',1,'','AAURAZO',NULL,NULL,'0000613',1),(614,'2021-05-11 19:00:37','2021-05-11',4,1,2,'GENERADO AUNTOMATICAMENTE','0000614','1620777615804823405',1,'','AAURAZO',NULL,NULL,'0000614',1),(615,'2021-05-11 19:01:07','2021-05-11',4,1,2,'GENERADO AUNTOMATICAMENTE','0000615','1620777639919589165',1,'','AAURAZO',NULL,NULL,'0000615',1),(616,'2021-05-11 19:01:32','2021-05-11',4,1,2,'GENERADO AUNTOMATICAMENTE','0000616','162077766961707575',1,'','AAURAZO',NULL,NULL,'0000616',1),(617,'2021-05-21 19:01:15','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000617','1621641660874147604',1,'','AAURAZO',NULL,NULL,'0000617',1),(618,'2021-05-21 19:01:39','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000618','1621641678997003340',1,'','AAURAZO',NULL,NULL,'0000618',1),(619,'2021-05-21 19:02:17','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000619','1621641702336422466',1,'','AAURAZO',NULL,NULL,'0000619',1),(620,'2021-05-21 19:02:41','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000620','1621641740559886506',1,'','AAURAZO',NULL,NULL,'0000620',1),(621,'2021-05-21 19:03:18','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000621','1621641764229316363',1,'','AAURAZO',NULL,NULL,'0000621',1),(622,'2021-05-21 19:04:07','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000622','16216418001009525588',1,'','AAURAZO',NULL,NULL,'0000622',1),(623,'2021-05-21 19:04:40','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000623','1621641852671769137',1,'','AAURAZO',NULL,NULL,'0000623',1),(624,'2021-05-21 19:05:01','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000624','1621641883364565251',1,'','AAURAZO',NULL,NULL,'0000624',1),(625,'2021-05-21 19:05:26','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000625','1621641903123759403',1,'','AAURAZO',NULL,NULL,'0000625',1),(626,'2021-05-21 19:08:59','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000626','1621642119713509965',1,'','AAURAZO',NULL,NULL,'0000626',1),(627,'2021-05-21 19:09:28','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000627','1621642142816312890',1,'','AAURAZO',NULL,NULL,'0000627',1),(628,'2021-05-21 19:09:49','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000628','1621642170399377962',1,'','AAURAZO',NULL,NULL,'0000628',1),(629,'2021-05-21 19:11:37','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000629','1621642192504977953',1,'','AAURAZO',NULL,NULL,'0000629',1),(630,'2021-05-21 19:12:05','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000630','16216423001287596958',1,'','AAURAZO',NULL,NULL,'0000630',1),(631,'2021-05-21 19:12:30','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000631','1621642332886239535',1,'','AAURAZO',NULL,NULL,'0000631',1),(632,'2021-05-21 19:13:09','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000632','162164235264203418',1,'','AAURAZO',NULL,NULL,'0000632',1),(633,'2021-05-21 19:14:36','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000633','16216424561378996461',1,'','AAURAZO',NULL,NULL,'0000633',1),(634,'2021-05-21 19:15:13','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000634','16216424781249169578',1,'','AAURAZO',NULL,NULL,'0000634',1),(635,'2021-05-21 19:17:18','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000635','1621642538685496275',1,'','AAURAZO',NULL,NULL,'0000635',1),(636,'2021-05-21 19:18:16','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000636','16216426401001564708',1,'','AAURAZO',NULL,NULL,'0000636',1),(637,'2021-05-21 19:19:45','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000637','1621642700662302145',1,'','AAURAZO',NULL,NULL,'0000637',1),(638,'2021-05-21 19:20:52','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000638','16216427881209451243',1,'','AAURAZO',NULL,NULL,'0000638',1),(639,'2021-05-21 19:28:28','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000639','1621643282177247907',1,'','AAURAZO',NULL,NULL,'0000639',1),(640,'2021-05-21 19:29:43','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000640','16216433651191205768',1,'','AAURAZO',NULL,NULL,'0000640',1),(641,'2021-05-21 19:30:12','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000641','1621643386219332989',1,'','AAURAZO',NULL,NULL,'0000641',1),(642,'2021-05-21 19:30:41','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000642','1621643415445378936',1,'','AAURAZO',NULL,NULL,'0000642',1),(643,'2021-05-21 19:31:32','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000643','162164346262180924',1,'','AAURAZO',NULL,NULL,'0000643',1),(644,'2021-05-21 19:32:02','2021-05-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000644','16216434951034397957',1,'','AAURAZO',NULL,NULL,'0000644',1),(645,'2021-05-22 18:20:05','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000645','1621725502504504604',1,'','AAURAZO',NULL,NULL,'0000645',1),(646,'2021-05-22 18:21:59','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000646','1621725610981597962',1,'','AAURAZO',NULL,NULL,'0000646',1),(647,'2021-05-22 18:23:51','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000647','16217257461140815552',1,'','AAURAZO',NULL,NULL,'0000647',1),(648,'2021-05-22 18:24:38','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000648','16217258351189355402',1,'','AAURAZO',NULL,NULL,'0000648',1),(649,'2021-05-22 18:25:43','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000649','1621725881992657130',1,'','AAURAZO',NULL,NULL,'0000649',1),(650,'2021-05-22 18:26:46','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000650','16217259471208117258',1,'','AAURAZO',NULL,NULL,'0000650',1),(651,'2021-05-22 18:27:21','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000651','16217260091366345118',1,'','AAURAZO',NULL,NULL,'0000651',1),(652,'2021-05-22 18:28:12','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000652','1621726044633729043',1,'','AAURAZO',NULL,NULL,'0000652',1),(653,'2021-05-22 18:29:20','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000653','1621726098590309975',1,'','AAURAZO',NULL,NULL,'0000653',1),(654,'2021-05-22 18:29:51','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000654','1621726163561005332',1,'','AAURAZO',NULL,NULL,'0000654',1),(655,'2021-05-22 18:30:18','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000655','1621726194232801937',1,'','AAURAZO',NULL,NULL,'0000655',1),(656,'2021-05-22 18:31:08','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000656','16217262211325464926',1,'','AAURAZO',NULL,NULL,'0000656',1),(657,'2021-05-22 18:31:34','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000657','16217262711254161264',1,'','AAURAZO',NULL,NULL,'0000657',1),(658,'2021-05-22 18:32:36','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000658','162172630125302688',1,'','AAURAZO',NULL,NULL,'0000658',1),(659,'2021-05-22 18:33:08','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000659','1621726360529420005',1,'','AAURAZO',NULL,NULL,'0000659',1),(660,'2021-05-22 18:36:17','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000660','1621726536623616574',1,'','AAURAZO',NULL,NULL,'0000660',1),(661,'2021-05-22 18:37:03','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000661','1621726584910423396',1,'','AAURAZO',NULL,NULL,'0000661',1),(662,'2021-05-22 18:38:01','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000662','162172663333779949',1,'','AAURAZO',NULL,NULL,'0000662',1),(663,'2021-05-22 18:39:08','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000663','1621726684531786753',1,'','AAURAZO',NULL,NULL,'0000663',1),(664,'2021-05-22 18:40:27','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000664','1621726770489787734',1,'','AAURAZO',NULL,NULL,'0000664',1),(665,'2021-05-22 18:41:37','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000665','1621726861789159836',1,'','AAURAZO',NULL,NULL,'0000665',1),(666,'2021-05-22 18:42:29','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000666','1621726904203411230',1,'','AAURAZO',NULL,NULL,'0000666',1),(667,'2021-05-22 18:43:14','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000667','1621726958802112402',1,'','AAURAZO',NULL,NULL,'0000667',1),(668,'2021-05-22 18:44:44','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000668','1621726997869069854',1,'','AAURAZO',NULL,NULL,'0000668',1),(669,'2021-05-22 18:47:29','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000669','16217272081047350524',1,'','AAURAZO',NULL,NULL,'0000669',1),(670,'2021-05-22 18:47:52','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000670','16217272518778484',1,'','AAURAZO',NULL,NULL,'0000670',1),(671,'2021-05-22 18:48:36','2021-05-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0000671','1621727280928711903',1,'','AAURAZO',NULL,NULL,'0000671',1),(672,'2021-05-24 18:53:15','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000672','1621900374798024383',1,'','AAURAZO',NULL,NULL,'0000672',1),(673,'2021-05-24 18:53:36','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000673','1621900397856891860',1,'','AAURAZO',NULL,NULL,'0000673',1),(674,'2021-05-24 18:53:59','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000674','1621900418737908985',1,'','AAURAZO',NULL,NULL,'0000674',1),(675,'2021-05-24 18:54:27','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000675','1621900441220796070',1,'','AAURAZO',NULL,NULL,'0000675',1),(676,'2021-05-24 18:54:55','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000676','1621900470208273822',1,'','AAURAZO',NULL,NULL,'0000676',1),(677,'2021-05-24 18:55:18','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000677','16219004981122570077',1,'','AAURAZO',NULL,NULL,'0000677',1),(678,'2021-05-24 18:55:41','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000678','1621900520971571557',1,'','AAURAZO',NULL,NULL,'0000678',1),(679,'2021-05-24 18:56:00','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000679','1621900544652404836',1,'','AAURAZO',NULL,NULL,'0000679',1),(680,'2021-05-24 18:56:23','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000680','16219005631235872757',1,'','AAURAZO',NULL,NULL,'0000680',1),(681,'2021-05-24 18:56:52','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000681','1621900586765535388',1,'','AAURAZO',NULL,NULL,'0000681',1),(682,'2021-05-24 18:57:14','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000682','1621900615902849802',1,'','AAURAZO',NULL,NULL,'0000682',1),(683,'2021-05-24 18:57:38','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000683','1621900636907669362',1,'','AAURAZO',NULL,NULL,'0000683',1),(684,'2021-05-24 18:58:10','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000684','162190066167129579',1,'','AAURAZO',NULL,NULL,'0000684',1),(685,'2021-05-24 18:58:34','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000685','1621900693123673340',1,'','AAURAZO',NULL,NULL,'0000685',1),(686,'2021-05-24 18:58:55','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000686','1621900716527440543',1,'','AAURAZO',NULL,NULL,'0000686',1),(687,'2021-05-24 18:59:49','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000687','1621900768217869909',1,'','AAURAZO',NULL,NULL,'0000687',1),(688,'2021-05-24 19:00:15','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000688','1621900791549515847',1,'','AAURAZO',NULL,NULL,'0000688',1),(689,'2021-05-24 19:00:47','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000689','16219008171108885971',1,'','AAURAZO',NULL,NULL,'0000689',1),(690,'2021-05-24 19:01:15','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000690','1621900851764244435',1,'','AAURAZO',NULL,NULL,'0000690',1),(691,'2021-05-24 19:01:43','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000691','16219008781057204802',1,'','AAURAZO',NULL,NULL,'0000691',1),(692,'2021-05-24 19:02:15','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000692','1621900905376915372',1,'','AAURAZO',NULL,NULL,'0000692',1),(693,'2021-05-24 19:02:46','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000693','1621900938112140822',1,'','AAURAZO',NULL,NULL,'0000693',1),(694,'2021-05-24 19:03:15','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000694','1621900968378894834',1,'','AAURAZO',NULL,NULL,'0000694',1),(695,'2021-05-24 19:03:38','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000695','1621900997339649850',1,'','AAURAZO',NULL,NULL,'0000695',1),(696,'2021-05-24 19:04:07','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000696','16219010241062712869',1,'','AAURAZO',NULL,NULL,'0000696',1),(697,'2021-05-24 19:04:34','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000697','16219010491373875679',1,'','AAURAZO',NULL,NULL,'0000697',1),(698,'2021-05-24 19:05:02','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000698','1621901077410695320',1,'','AAURAZO',NULL,NULL,'0000698',1),(699,'2021-05-24 19:06:20','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000699','16219011541408731422',1,'','AAURAZO',NULL,NULL,'0000699',1),(700,'2021-05-24 19:06:42','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000700','1621901183388146667',1,'','AAURAZO',NULL,NULL,'0000700',1),(701,'2021-05-24 19:07:09','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000701','1621901204366759872',1,'','AAURAZO',NULL,NULL,'0000701',1),(702,'2021-05-24 19:07:37','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000702','1621901231630759850',1,'','AAURAZO',NULL,NULL,'0000702',1),(703,'2021-05-24 19:08:30','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000703','1621901285777326096',1,'','AAURAZO',NULL,NULL,'0000703',1),(704,'2021-05-24 19:10:51','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000704','16219013681016281578',1,'','AAURAZO',NULL,NULL,'0000704',1),(705,'2021-05-24 19:11:45','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000705','1621901454328590682',1,'','AAURAZO',NULL,NULL,'0000705',1),(706,'2021-05-24 19:12:14','2021-05-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000706','16219015101360363700',1,'','AAURAZO',NULL,NULL,'0000706',1),(707,'2021-05-26 11:47:43','2021-05-26',4,1539,2,'GENERADO AUNTOMATICAMENTE','0000707','16220473861263327034',1,'','AAURAZO',NULL,NULL,'0000707',1),(708,'2021-05-26 13:09:11','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000708','16220525001309801357',1,'','AAURAZO',NULL,NULL,'0000708',1),(709,'2021-05-26 13:09:47','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000709','16220525541103291839',1,'','AAURAZO',NULL,NULL,'0000709',1),(710,'2021-05-26 13:10:42','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000710','1622052590302341295',1,'','AAURAZO',NULL,NULL,'0000710',1),(711,'2021-05-26 13:11:34','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000711','1622052648774573',1,'','AAURAZO',NULL,NULL,'0000711',1),(712,'2021-05-26 13:12:10','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000712','162205271253918822',1,'','AAURAZO',NULL,NULL,'0000712',1),(713,'2021-05-26 13:13:05','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000713','1622052750571591150',1,'','AAURAZO',NULL,NULL,'0000713',1),(714,'2021-05-26 13:14:24','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000714','16220528251254462487',1,'','AAURAZO',NULL,NULL,'0000714',1),(715,'2021-05-26 13:15:33','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000715','16220528681196326550',1,'','AAURAZO',NULL,NULL,'0000715',1),(716,'2021-05-26 13:16:11','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000716','1622052936837742717',1,'','AAURAZO',NULL,NULL,'0000716',1),(717,'2021-05-26 13:20:30','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000717','1622053108664884052',1,'','AAURAZO',NULL,NULL,'0000717',1),(718,'2021-05-26 13:23:03','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000718','1622053316643927575',1,'','AAURAZO',NULL,NULL,'0000718',1),(719,'2021-05-26 13:24:29','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000719','1622053387442969156',1,'','AAURAZO',NULL,NULL,'0000719',1),(720,'2021-05-26 13:25:01','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000720','1622053472483462063',1,'','AAURAZO',NULL,NULL,'0000720',1),(721,'2021-05-26 13:25:59','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000721','1622053545195622478',1,'','AAURAZO',NULL,NULL,'0000721',1),(722,'2021-05-26 13:26:34','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000722','16220535621102129981',1,'','AAURAZO',NULL,NULL,'0000722',1),(723,'2021-05-26 13:28:12','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000723','1622053597541124649',1,'','AAURAZO',NULL,NULL,'0000723',1),(724,'2021-05-26 13:29:05','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000724','16220536971248481069',1,'','AAURAZO',NULL,NULL,'0000724',1),(725,'2021-05-26 13:30:15','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000725','1622053748583510954',1,'','AAURAZO',NULL,NULL,'0000725',1),(726,'2021-05-26 13:34:08','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000726','1622053818427305588',1,'','AAURAZO',NULL,NULL,'0000726',1),(727,'2021-05-26 13:34:41','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000727','16220540521197359313',1,'','AAURAZO',NULL,NULL,'0000727',1),(728,'2021-05-26 13:35:06','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000728','16220540841300463461',1,'','AAURAZO',NULL,NULL,'0000728',1),(729,'2021-05-26 13:37:34','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000729','1622054109474382357',1,'','AAURAZO',NULL,NULL,'0000729',1),(730,'2021-05-26 13:38:04','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000730','1622054261993474734',1,'','AAURAZO',NULL,NULL,'0000730',1),(731,'2021-05-26 13:38:38','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000731','16220542871122613109',1,'','AAURAZO',NULL,NULL,'0000731',1),(732,'2021-05-26 13:39:24','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000732','1622054326507129542',1,'','AAURAZO',NULL,NULL,'0000732',1),(733,'2021-05-26 13:39:51','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000733','1622054367883872787',1,'','AAURAZO',NULL,NULL,'0000733',1),(734,'2021-05-26 13:40:23','2021-05-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0000734','16220543941223909922',1,'','AAURAZO',NULL,NULL,'0000734',1),(735,'2021-05-27 15:43:00','2021-05-27',4,1502,1,'GENERADO AUNTOMATICAMENTE','0000735','16221479231363246830',1,'','AAURAZO',NULL,NULL,'0000735',1),(736,'2021-05-27 15:51:17','2021-05-27',4,1540,1,'GENERADO AUNTOMATICAMENTE','0000736','1622148418854869366',1,'','AAURAZO',NULL,NULL,'0000736',1),(737,'2021-05-27 18:32:37','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000737','1622158287645218528',1,'','AAURAZO',NULL,NULL,'0000737',1),(738,'2021-05-27 18:33:05','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000738','1622158362805253722',1,'','AAURAZO',NULL,NULL,'0000738',1),(739,'2021-05-27 18:33:30','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000739','1622158394968129014',1,'','AAURAZO',NULL,NULL,'0000739',1),(740,'2021-05-27 18:34:04','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000740','1622158413734337347',1,'','AAURAZO',NULL,NULL,'0000740',1),(741,'2021-05-27 18:34:30','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000741','16221584491116588660',1,'','AAURAZO',NULL,NULL,'0000741',1),(742,'2021-05-27 18:35:35','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000742','16221584761003415075',1,'','AAURAZO',NULL,NULL,'0000742',1),(743,'2021-05-27 18:36:00','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000743','1622158538599561808',1,'','AAURAZO',NULL,NULL,'0000743',1),(744,'2021-05-27 18:36:56','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000744','16221585621078677660',1,'','AAURAZO',NULL,NULL,'0000744',1),(745,'2021-05-27 18:37:38','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000745','16221586271357179348',1,'','AAURAZO',NULL,NULL,'0000745',1),(746,'2021-05-27 18:38:27','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000746','1622158680548353989',1,'','AAURAZO',NULL,NULL,'0000746',1),(747,'2021-05-27 18:38:55','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000747','1622158711517069884',1,'','AAURAZO',NULL,NULL,'0000747',1),(748,'2021-05-27 18:39:23','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000748','1622158737259524673',1,'','AAURAZO',NULL,NULL,'0000748',1),(749,'2021-05-27 18:40:14','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000749','1622158792582263032',1,'','AAURAZO',NULL,NULL,'0000749',1),(750,'2021-05-27 18:40:38','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000750','1622158817348428333',1,'','AAURAZO',NULL,NULL,'0000750',1),(751,'2021-05-27 18:41:03','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000751','1622158841999284024',1,'','AAURAZO',NULL,NULL,'0000751',1),(752,'2021-05-27 18:41:39','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000752','162215886643548163',1,'','AAURAZO',NULL,NULL,'0000752',1),(753,'2021-05-27 18:42:26','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000753','16221589021261906985',1,'','AAURAZO',NULL,NULL,'0000753',1),(754,'2021-05-27 18:42:48','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000754','16221589541192582785',1,'','AAURAZO',NULL,NULL,'0000754',1),(755,'2021-05-27 18:43:16','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000755','1622158971468573066',1,'','AAURAZO',NULL,NULL,'0000755',1),(756,'2021-05-27 18:44:00','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000756','1622159004116271873',1,'','AAURAZO',NULL,NULL,'0000756',1),(757,'2021-05-27 18:45:17','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000757','16221590531263370065',1,'','AAURAZO',NULL,NULL,'0000757',1),(758,'2021-05-27 18:45:50','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000758','1622159127493875754',1,'','AAURAZO',NULL,NULL,'0000758',1),(759,'2021-05-27 18:47:38','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000759','16221591531149206750',1,'','AAURAZO',NULL,NULL,'0000759',1),(760,'2021-05-27 18:48:57','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000760','1622159261776293334',1,'','AAURAZO',NULL,NULL,'0000760',1),(761,'2021-05-27 18:49:30','2021-05-27',4,1,2,'GENERADO AUNTOMATICAMENTE','0000761','1622159345964858599',1,'','AAURAZO',NULL,NULL,'0000761',1),(762,'2021-05-29 18:12:58','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000762','16223299271035818006',1,'','AAURAZO',NULL,NULL,'0000762',1),(763,'2021-05-29 18:14:08','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000763','1622329981780166194',1,'','AAURAZO',NULL,NULL,'0000763',1),(764,'2021-05-29 18:16:58','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000764','16223301921391088392',1,'','AAURAZO',NULL,NULL,'0000764',1),(765,'2021-05-29 18:17:39','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000765','1622330220688637595',1,'','AAURAZO',NULL,NULL,'0000765',1),(766,'2021-05-29 18:18:11','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000766','16223302621022262995',1,'','AAURAZO',NULL,NULL,'0000766',1),(767,'2021-05-29 18:18:40','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000767','1622330294776379397',1,'','AAURAZO',NULL,NULL,'0000767',1),(768,'2021-05-29 18:19:09','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000768','1622330322616903616',1,'','AAURAZO',NULL,NULL,'0000768',1),(769,'2021-05-29 18:19:38','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000769','1622330352703612655',1,'','AAURAZO',NULL,NULL,'0000769',1),(770,'2021-05-29 18:20:11','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000770','1622330381927248822',1,'','AAURAZO',NULL,NULL,'0000770',1),(771,'2021-05-29 18:20:48','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000771','16223304141354769569',1,'','AAURAZO',NULL,NULL,'0000771',1),(772,'2021-05-29 18:21:16','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000772','1622330451705549085',1,'','AAURAZO',NULL,NULL,'0000772',1),(773,'2021-05-29 18:21:42','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000773','162233047978145715',1,'','AAURAZO',NULL,NULL,'0000773',1),(774,'2021-05-29 18:22:10','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000774','1622330509708948596',1,'','AAURAZO',NULL,NULL,'0000774',1),(775,'2021-05-29 18:22:39','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000775','1622330533891962762',1,'','AAURAZO',NULL,NULL,'0000775',1),(776,'2021-05-29 18:23:32','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000776','162233056279479700',1,'','AAURAZO',NULL,NULL,'0000776',1),(777,'2021-05-29 18:25:37','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000777','1622330615864207263',1,'','AAURAZO',NULL,NULL,'0000777',1),(778,'2021-05-29 18:26:21','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000778','162233075751121757',1,'','AAURAZO',NULL,NULL,'0000778',1),(779,'2021-05-29 18:26:54','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000779','16223307841055612626',1,'','AAURAZO',NULL,NULL,'0000779',1),(780,'2021-05-29 18:28:18','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000780','16223308171014086957',1,'','AAURAZO',NULL,NULL,'0000780',1),(781,'2021-05-29 18:28:45','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000781','1622330905221742769',1,'','AAURAZO',NULL,NULL,'0000781',1),(782,'2021-05-29 18:29:02','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000782','1622330928211286046',1,'','AAURAZO',NULL,NULL,'0000782',1),(783,'2021-05-29 18:29:22','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000783','162233094663557941',1,'','AAURAZO',NULL,NULL,'0000783',1),(784,'2021-05-29 18:29:53','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000784','1622330974575334915',1,'','AAURAZO',NULL,NULL,'0000784',1),(785,'2021-05-29 18:30:37','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000785','1622330996494392135',1,'','AAURAZO',NULL,NULL,'0000785',1),(786,'2021-05-29 18:32:42','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000786','1622331142630716818',1,'','AAURAZO',NULL,NULL,'0000786',1),(787,'2021-05-29 18:33:15','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000787','16223311651044639521',1,'','AAURAZO',NULL,NULL,'0000787',1),(788,'2021-05-29 18:35:02','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000788','1622331205343737869',1,'','AAURAZO',NULL,NULL,'0000788',1),(789,'2021-05-29 18:35:26','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000789','1622331305221484578',1,'','AAURAZO',NULL,NULL,'0000789',1),(790,'2021-05-29 18:35:53','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000790','16223313331340870303',1,'','AAURAZO',NULL,NULL,'0000790',1),(791,'2021-05-29 18:44:40','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000791','16223318511334286441',1,'','AAURAZO',NULL,NULL,'0000791',1),(792,'2021-05-29 18:45:16','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000792','1622331882162918324',1,'','AAURAZO',NULL,NULL,'0000792',1),(793,'2021-05-29 18:45:53','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000793','1622331919215546193',1,'','AAURAZO',NULL,NULL,'0000793',1),(794,'2021-05-29 18:46:26','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000794','1622331956182540816',1,'','AAURAZO',NULL,NULL,'0000794',1),(795,'2021-05-29 18:47:01','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000795','1622332001375839578',1,'','AAURAZO',NULL,NULL,'0000795',1),(796,'2021-05-29 18:47:43','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000796','1622332023871178411',1,'','AAURAZO',NULL,NULL,'0000796',1),(797,'2021-05-29 18:48:21','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000797','1622332078283622471',1,'','AAURAZO',NULL,NULL,'0000797',1),(798,'2021-05-29 18:48:49','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000798','1622332105975444417',1,'','AAURAZO',NULL,NULL,'0000798',1),(799,'2021-05-29 18:49:24','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000799','1622332143207714408',1,'','AAURAZO',NULL,NULL,'0000799',1),(800,'2021-05-29 18:50:01','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000800','1622332177889122664',1,'','AAURAZO',NULL,NULL,'0000800',1),(801,'2021-05-29 18:50:29','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000801','1622332204957973514',1,'','AAURAZO',NULL,NULL,'0000801',1),(802,'2021-05-29 18:51:13','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000802','1622332242835031715',1,'','AAURAZO',NULL,NULL,'0000802',1),(803,'2021-05-29 18:51:37','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000803','162233227690667964',1,'','AAURAZO',NULL,NULL,'0000803',1),(804,'2021-05-29 18:52:01','2021-05-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000804','16223322991195336819',1,'','AAURAZO',NULL,NULL,'0000804',1),(805,'2021-06-14 19:04:35','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000805','16237154311357566634',1,'','AAURAZO',NULL,NULL,'0000805',1),(806,'2021-06-14 19:05:13','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000806','1623715477640054714',1,'','AAURAZO',NULL,NULL,'0000806',1),(807,'2021-06-14 19:05:49','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000807','16237155161221414079',1,'','AAURAZO',NULL,NULL,'0000807',1),(808,'2021-06-14 19:07:01','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000808','1623715587275919782',1,'','AAURAZO',NULL,NULL,'0000808',1),(809,'2021-06-14 19:07:27','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000809','1623715623695694807',1,'','AAURAZO',NULL,NULL,'0000809',1),(810,'2021-06-14 19:07:58','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000810','162371564925689974',1,'','AAURAZO',NULL,NULL,'0000810',1),(811,'2021-06-14 19:08:14','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000811','1623715681638591634',1,'','AAURAZO',NULL,NULL,'0000811',1),(812,'2021-06-14 19:08:35','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000812','162371569679135446',1,'','AAURAZO',NULL,NULL,'0000812',1),(813,'2021-06-14 19:09:10','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000813','1623715721706151530',1,'','AAURAZO',NULL,NULL,'0000813',1),(814,'2021-06-14 19:09:36','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000814','1623715753300189706',1,'','AAURAZO',NULL,NULL,'0000814',1),(815,'2021-06-14 19:09:59','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000815','162371577856801952',1,'','AAURAZO',NULL,NULL,'0000815',1),(816,'2021-06-14 19:10:22','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000816','1623715802497404360',1,'','AAURAZO',NULL,NULL,'0000816',1),(817,'2021-06-14 19:10:54','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000817','16237158251191076673',1,'','AAURAZO',NULL,NULL,'0000817',1),(818,'2021-06-14 19:11:22','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000818','16237158641082077171',1,'','AAURAZO',NULL,NULL,'0000818',1),(819,'2021-06-14 19:11:45','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000819','1623715884560488951',1,'','AAURAZO',NULL,NULL,'0000819',1),(820,'2021-06-14 19:12:33','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000820','1623715908202077245',1,'','AAURAZO',NULL,NULL,'0000820',1),(821,'2021-06-14 19:12:56','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000821','16237159561023984266',1,'','AAURAZO',NULL,NULL,'0000821',1),(822,'2021-06-14 19:13:20','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000822','1623715979145533485',1,'','AAURAZO',NULL,NULL,'0000822',1),(823,'2021-06-14 19:14:04','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000823','16237160031384074212',1,'','AAURAZO',NULL,NULL,'0000823',1),(824,'2021-06-14 19:15:29','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000824','16237160491198822393',1,'','AAURAZO',NULL,NULL,'0000824',1),(825,'2021-06-14 19:15:59','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000825','1623716132881979388',1,'','AAURAZO',NULL,NULL,'0000825',1),(826,'2021-06-14 19:16:52','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000826','1623716187143812213',1,'','AAURAZO',NULL,NULL,'0000826',1),(827,'2021-06-14 19:17:14','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000827','16237162151025576442',1,'','AAURAZO',NULL,NULL,'0000827',1),(828,'2021-06-14 19:18:48','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000828','16237162791254376423',1,'','AAURAZO',NULL,NULL,'0000828',1),(829,'2021-06-14 19:19:14','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000829','1623716332388792144',1,'','AAURAZO',NULL,NULL,'0000829',1),(830,'2021-06-14 19:19:42','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000830','1623716356188995584',1,'','AAURAZO',NULL,NULL,'0000830',1),(831,'2021-06-14 19:21:24','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000831','1623716464262493866',1,'','AAURAZO',NULL,NULL,'0000831',1),(832,'2021-06-14 19:21:51','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000832','1623716486450069400',1,'','AAURAZO',NULL,NULL,'0000832',1),(833,'2021-06-14 19:22:30','2021-06-14',4,1,2,'GENERADO AUNTOMATICAMENTE','0000833','16237165161027254682',1,'','AAURAZO',NULL,NULL,'0000833',1),(834,'2021-06-18 19:14:43','2021-06-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000834','1624061574999240992',1,'','AAURAZO',NULL,NULL,'0000834',1),(835,'2021-06-18 19:23:15','2021-06-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000835','1624061687593150073',1,'','AAURAZO',NULL,NULL,'0000835',1),(836,'2021-06-18 19:29:08','2021-06-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000836','1624062199740576955',1,'','AAURAZO',NULL,NULL,'0000836',1),(837,'2021-06-18 19:29:48','2021-06-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000837','1624062552791827807',1,'','AAURAZO',NULL,NULL,'0000837',1),(838,'2021-06-18 19:39:23','2021-06-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000838','16240631431031729987',1,'','AAURAZO',NULL,NULL,'0000838',1),(839,'2021-06-18 19:40:23','2021-06-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000839','1624063165701202875',1,'','AAURAZO',NULL,NULL,'0000839',1),(840,'2021-06-18 19:40:48','2021-06-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000840','1624063228488324654',1,'','AAURAZO',NULL,NULL,'0000840',1),(841,'2021-06-18 19:41:11','2021-06-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000841','1624063250440516345',1,'','AAURAZO',NULL,NULL,'0000841',1),(842,'2021-06-18 19:41:32','2021-06-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000842','1624063274520641521',1,'','AAURAZO',NULL,NULL,'0000842',1),(843,'2021-06-18 19:42:23','2021-06-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000843','1624063296773797490',1,'','AAURAZO',NULL,NULL,'0000843',1),(844,'2021-06-18 19:44:03','2021-06-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000844','162406334650992661',1,'','AAURAZO',NULL,NULL,'0000844',1),(845,'2021-06-18 19:44:46','2021-06-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000845','16240634461372842917',1,'','AAURAZO',NULL,NULL,'0000845',1),(846,'2021-06-18 19:45:26','2021-06-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000846','162406348991313440',1,'','AAURAZO',NULL,NULL,'0000846',1),(847,'2021-06-18 19:46:46','2021-06-18',4,1,2,'GENERADO AUNTOMATICAMENTE','0000847','16240635301336481062',1,'','AAURAZO',NULL,NULL,'0000847',1),(848,'2021-06-21 19:20:30','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000848','16243211991178081075',1,'','AAURAZO',NULL,NULL,'0000848',1),(849,'2021-06-21 19:20:49','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000849','16243212321032805782',1,'','AAURAZO',NULL,NULL,'0000849',1),(850,'2021-06-21 19:21:05','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000850','1624321252499340790',1,'','AAURAZO',NULL,NULL,'0000850',1),(851,'2021-06-21 19:21:36','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000851','16243212671141288902',1,'','AAURAZO',NULL,NULL,'0000851',1),(852,'2021-06-21 19:21:56','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000852','16243212981407354405',1,'','AAURAZO',NULL,NULL,'0000852',1),(853,'2021-06-21 19:22:20','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000853','1624321320231209761',1,'','AAURAZO',NULL,NULL,'0000853',1),(854,'2021-06-21 19:22:40','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000854','1624321342823456166',1,'','AAURAZO',NULL,NULL,'0000854',1),(855,'2021-06-21 19:23:43','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000855','1624321362880688435',1,'','AAURAZO',NULL,NULL,'0000855',1),(856,'2021-06-21 19:24:15','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000856','16243214271123344649',1,'','AAURAZO',NULL,NULL,'0000856',1),(857,'2021-06-21 19:24:41','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000857','162432145717858190',1,'','AAURAZO',NULL,NULL,'0000857',1),(858,'2021-06-21 19:24:59','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000858','1624321484190458664',1,'','AAURAZO',NULL,NULL,'0000858',1),(859,'2021-06-21 19:25:19','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000859','16243215021128035113',1,'','AAURAZO',NULL,NULL,'0000859',1),(860,'2021-06-21 19:25:41','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000860','1624321521630028309',1,'','AAURAZO',NULL,NULL,'0000860',1),(861,'2021-06-21 19:26:00','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000861','16243215441031686955',1,'','AAURAZO',NULL,NULL,'0000861',1),(862,'2021-06-21 19:29:48','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000862','16243215631406020420',1,'','AAURAZO',NULL,NULL,'0000862',1),(863,'2021-06-21 19:30:14','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000863','162432179132445964',1,'','AAURAZO',NULL,NULL,'0000863',1),(864,'2021-06-21 19:30:37','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000864','16243218171029018985',1,'','AAURAZO',NULL,NULL,'0000864',1),(865,'2021-06-21 19:31:16','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000865','16243218411288586689',1,'','AAURAZO',NULL,NULL,'0000865',1),(866,'2021-06-21 19:31:42','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000866','1624321882871479634',1,'','AAURAZO',NULL,NULL,'0000866',1),(867,'2021-06-21 19:32:04','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000867','1624321905616042980',1,'','AAURAZO',NULL,NULL,'0000867',1),(868,'2021-06-21 19:32:29','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000868','162432192719063080',1,'','AAURAZO',NULL,NULL,'0000868',1),(869,'2021-06-21 19:32:51','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000869','1624321952425971603',1,'','AAURAZO',NULL,NULL,'0000869',1),(870,'2021-06-21 19:35:09','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000870','1624322072817302621',1,'','AAURAZO',NULL,NULL,'0000870',1),(871,'2021-06-21 19:35:36','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000871','1624322112270067459',1,'','AAURAZO',NULL,NULL,'0000871',1),(872,'2021-06-21 19:36:03','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000872','1624322139318607309',1,'','AAURAZO',NULL,NULL,'0000872',1),(873,'2021-06-21 19:36:24','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000873','16243221651202953444',1,'','AAURAZO',NULL,NULL,'0000873',1),(874,'2021-06-21 19:36:49','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000874','16243221871175757359',1,'','AAURAZO',NULL,NULL,'0000874',1),(875,'2021-06-21 19:37:37','2021-06-21',4,1,2,'GENERADO AUNTOMATICAMENTE','0000875','1624322211891532444',1,'','AAURAZO',NULL,NULL,'0000875',1),(876,'2021-06-24 19:09:57','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000876','1624579770405187252',1,'','AAURAZO',NULL,NULL,'0000876',1),(877,'2021-06-24 19:10:30','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000877','1624579801102200481',1,'','AAURAZO',NULL,NULL,'0000877',1),(878,'2021-06-24 19:10:48','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000878','1624579833990075223',1,'','AAURAZO',NULL,NULL,'0000878',1),(879,'2021-06-24 19:11:08','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000879','1624579850564533938',1,'','AAURAZO',NULL,NULL,'0000879',1),(880,'2021-06-24 19:11:29','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000880','16245798701003242948',1,'','AAURAZO',NULL,NULL,'0000880',1),(881,'2021-06-24 19:12:06','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000881','1624579893434190673',1,'','AAURAZO',NULL,NULL,'0000881',1),(882,'2021-06-24 19:12:30','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000882','162457992997423953',1,'','AAURAZO',NULL,NULL,'0000882',1),(883,'2021-06-24 19:13:00','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000883','162457995394626887',1,'','AAURAZO',NULL,NULL,'0000883',1),(884,'2021-06-24 19:13:21','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000884','16245799821033494290',1,'','AAURAZO',NULL,NULL,'0000884',1),(885,'2021-06-24 19:13:46','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000885','16245800031328993532',1,'','AAURAZO',NULL,NULL,'0000885',1),(886,'2021-06-24 19:14:08','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000886','1624580028337455229',1,'','AAURAZO',NULL,NULL,'0000886',1),(887,'2021-06-24 19:14:46','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000887','1624580054255565749',1,'','AAURAZO',NULL,NULL,'0000887',1),(888,'2021-06-24 19:15:19','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000888','1624580091296747164',1,'','AAURAZO',NULL,NULL,'0000888',1),(889,'2021-06-24 19:15:48','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000889','16245801221273009184',1,'','AAURAZO',NULL,NULL,'0000889',1),(890,'2021-06-24 19:16:28','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000890','16245801511169732909',1,'','AAURAZO',NULL,NULL,'0000890',1),(891,'2021-06-24 19:16:55','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000891','16245801901057290865',1,'','AAURAZO',NULL,NULL,'0000891',1),(892,'2021-06-24 19:17:18','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000892','1624580217406047888',1,'','AAURAZO',NULL,NULL,'0000892',1),(893,'2021-06-24 19:17:53','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000893','1624580242786750057',1,'','AAURAZO',NULL,NULL,'0000893',1),(894,'2021-06-24 19:18:16','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000894','1624580276230047903',1,'','AAURAZO',NULL,NULL,'0000894',1),(895,'2021-06-24 19:18:41','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000895','16245802981097869835',1,'','AAURAZO',NULL,NULL,'0000895',1),(896,'2021-06-24 19:19:05','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000896','1624580325642894812',1,'','AAURAZO',NULL,NULL,'0000896',1),(897,'2021-06-24 19:19:27','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000897','1624580347644702147',1,'','AAURAZO',NULL,NULL,'0000897',1),(898,'2021-06-24 19:19:51','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000898','16245803701225846352',1,'','AAURAZO',NULL,NULL,'0000898',1),(899,'2021-06-24 19:20:18','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000899','16245803931333727028',1,'','AAURAZO',NULL,NULL,'0000899',1),(900,'2021-06-24 19:20:45','2021-06-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0000900','1624580421626671830',1,'','AAURAZO',NULL,NULL,'0000900',1),(901,'2021-06-25 22:46:44','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000901','1624679182723622433',1,'','AAURAZO',NULL,NULL,'0000901',1),(902,'2021-06-25 22:46:59','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000902','1624679208805167659',1,'','AAURAZO',NULL,NULL,'0000902',1),(903,'2021-06-25 22:47:30','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000903','1624679222983835615',1,'','AAURAZO',NULL,NULL,'0000903',1),(904,'2021-06-25 22:47:57','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000904','1624679254889294791',1,'','AAURAZO',NULL,NULL,'0000904',1),(905,'2021-06-25 22:48:22','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000905','1624679281629382833',1,'','AAURAZO',NULL,NULL,'0000905',1),(906,'2021-06-25 22:48:48','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000906','162467930654090949',1,'','AAURAZO',NULL,NULL,'0000906',1),(907,'2021-06-25 22:49:28','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000907','1624679330764846880',1,'','AAURAZO',NULL,NULL,'0000907',1),(908,'2021-06-25 22:49:55','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000908','162467937273197060',1,'','AAURAZO',NULL,NULL,'0000908',1),(909,'2021-06-25 22:50:22','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000909','1624679402918513371',1,'','AAURAZO',NULL,NULL,'0000909',1),(910,'2021-06-25 22:50:50','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000910','1624679425223334945',1,'','AAURAZO',NULL,NULL,'0000910',1),(911,'2021-06-25 22:51:16','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000911','1624679454963395518',1,'','AAURAZO',NULL,NULL,'0000911',1),(912,'2021-06-25 22:51:49','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000912','16246794791116631691',1,'','AAURAZO',NULL,NULL,'0000912',1),(913,'2021-06-25 22:52:30','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000913','1624679512494478198',1,'','AAURAZO',NULL,NULL,'0000913',1),(914,'2021-06-25 22:53:20','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000914','1624679552337369165',1,'','AAURAZO',NULL,NULL,'0000914',1),(915,'2021-06-25 22:53:51','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000915','1624679602268432252',1,'','AAURAZO',NULL,NULL,'0000915',1),(916,'2021-06-25 22:54:15','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000916','16246796371347798420',1,'','AAURAZO',NULL,NULL,'0000916',1),(917,'2021-06-25 22:54:34','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000917','162467965752843028',1,'','AAURAZO',NULL,NULL,'0000917',1),(918,'2021-06-25 22:55:02','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000918','16246796771014646370',1,'','AAURAZO',NULL,NULL,'0000918',1),(919,'2021-06-25 22:55:18','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000919','1624679704729905074',1,'','AAURAZO',NULL,NULL,'0000919',1),(920,'2021-06-25 22:55:48','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000920','1624679721297005354',1,'','AAURAZO',NULL,NULL,'0000920',1),(921,'2021-06-25 22:56:07','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000921','16246797511327831674',1,'','AAURAZO',NULL,NULL,'0000921',1),(922,'2021-06-25 22:56:41','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000922','16246797701374090838',1,'','AAURAZO',NULL,NULL,'0000922',1),(923,'2021-06-25 22:57:31','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000923','16246798041171368117',1,'','AAURAZO',NULL,NULL,'0000923',1),(924,'2021-06-25 22:57:57','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000924','1624679854726720722',1,'','AAURAZO',NULL,NULL,'0000924',1),(925,'2021-06-25 22:58:30','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000925','16246798791154413595',1,'','AAURAZO',NULL,NULL,'0000925',1),(926,'2021-06-25 22:58:56','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000926','1624679913447874779',1,'','AAURAZO',NULL,NULL,'0000926',1),(927,'2021-06-25 22:59:28','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000927','16246799421192109436',1,'','AAURAZO',NULL,NULL,'0000927',1),(928,'2021-06-25 23:00:00','2021-06-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0000928','162467997162137893',1,'','AAURAZO',NULL,NULL,'0000928',1),(929,'2021-06-28 22:43:16','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000929','1624938184414094831',1,'','AAURAZO',NULL,NULL,'0000929',1),(930,'2021-06-28 22:43:35','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000930','1624938198348471365',1,'','AAURAZO',NULL,NULL,'0000930',1),(931,'2021-06-28 22:44:07','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000931','162493821746259165',1,'','AAURAZO',NULL,NULL,'0000931',1),(932,'2021-06-28 22:44:57','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000932','1624938249219548148',1,'','AAURAZO',NULL,NULL,'0000932',1),(933,'2021-06-28 22:45:20','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000933','1624938299534928073',1,'','AAURAZO',NULL,NULL,'0000933',1),(934,'2021-06-28 22:45:55','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000934','1624938323349116842',1,'','AAURAZO',NULL,NULL,'0000934',1),(935,'2021-06-28 22:46:59','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000935','1624938361132365760',1,'','AAURAZO',NULL,NULL,'0000935',1),(936,'2021-06-28 22:47:29','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000936','162493842165279213',1,'','AAURAZO',NULL,NULL,'0000936',1),(937,'2021-06-28 22:47:55','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000937','16249384541191205768',1,'','AAURAZO',NULL,NULL,'0000937',1),(938,'2021-06-28 22:48:34','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000938','1624938478219332989',1,'','AAURAZO',NULL,NULL,'0000938',1),(939,'2021-06-28 22:48:58','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000939','1624938517445249841',1,'','AAURAZO',NULL,NULL,'0000939',1),(940,'2021-06-28 22:49:32','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000940','1624938540876041003',1,'','AAURAZO',NULL,NULL,'0000940',1),(941,'2021-06-28 22:50:12','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000941','1624938575965116790',1,'','AAURAZO',NULL,NULL,'0000941',1),(942,'2021-06-28 22:50:34','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000942','162493861862180924',1,'','AAURAZO',NULL,NULL,'0000942',1),(943,'2021-06-28 22:50:55','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000943','162493863710757946',1,'','AAURAZO',NULL,NULL,'0000943',1),(944,'2021-06-28 22:51:16','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000944','16249386571240735348',1,'','AAURAZO',NULL,NULL,'0000944',1),(945,'2021-06-28 22:51:46','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000945','1624938679637687966',1,'','AAURAZO',NULL,NULL,'0000945',1),(946,'2021-06-28 22:52:13','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000946','162493870862826401',1,'','AAURAZO',NULL,NULL,'0000946',1),(947,'2021-06-28 22:52:36','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000947','1624938736672543709',1,'','AAURAZO',NULL,NULL,'0000947',1),(948,'2021-06-28 22:53:09','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000948','16249387581059055168',1,'','AAURAZO',NULL,NULL,'0000948',1),(949,'2021-06-28 22:53:49','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000949','1624938791932154445',1,'','AAURAZO',NULL,NULL,'0000949',1),(950,'2021-06-28 22:54:15','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000950','16249388351036205292',1,'','AAURAZO',NULL,NULL,'0000950',1),(951,'2021-06-28 22:54:42','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000951','162493885939460144',1,'','AAURAZO',NULL,NULL,'0000951',1),(952,'2021-06-28 22:55:07','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000952','16249388841158716773',1,'','AAURAZO',NULL,NULL,'0000952',1),(953,'2021-06-28 22:55:29','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000953','1624938911310861588',1,'','AAURAZO',NULL,NULL,'0000953',1),(954,'2021-06-28 22:56:11','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000954','1624938953808222915',1,'','AAURAZO',NULL,NULL,'0000954',1),(955,'2021-06-28 22:56:32','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000955','1624938974189985315',1,'','AAURAZO',NULL,NULL,'0000955',1),(956,'2021-06-28 22:57:25','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000956','16249390171048254191',1,'','AAURAZO',NULL,NULL,'0000956',1),(957,'2021-06-28 22:58:06','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000957','1624939048835203842',1,'','AAURAZO',NULL,NULL,'0000957',1),(958,'2021-06-28 22:58:35','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000958','1624939088690057644',1,'','AAURAZO',NULL,NULL,'0000958',1),(959,'2021-06-28 22:59:00','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000959','1624939118871952983',1,'','AAURAZO',NULL,NULL,'0000959',1),(960,'2021-06-28 22:59:29','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000960','16249391431077644898',1,'','AAURAZO',NULL,NULL,'0000960',1),(961,'2021-06-28 23:00:04','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000961','1624939183747892358',1,'','AAURAZO',NULL,NULL,'0000961',1),(962,'2021-06-28 23:00:29','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000962','1624939206265204868',1,'','AAURAZO',NULL,NULL,'0000962',1),(963,'2021-06-28 23:01:05','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000963','1624939231898159338',1,'','AAURAZO',NULL,NULL,'0000963',1),(964,'2021-06-28 23:01:55','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000964','1624939281496027343',1,'','AAURAZO',NULL,NULL,'0000964',1),(965,'2021-06-28 23:02:26','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000965','1624939317372569162',1,'','AAURAZO',NULL,NULL,'0000965',1),(966,'2021-06-28 23:02:51','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000966','1624939349731970599',1,'','AAURAZO',NULL,NULL,'0000966',1),(967,'2021-06-28 23:03:20','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000967','1624939379996659085',1,'','AAURAZO',NULL,NULL,'0000967',1),(968,'2021-06-28 23:03:42','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000968','16249394021359632160',1,'','AAURAZO',NULL,NULL,'0000968',1),(969,'2021-06-28 23:04:24','2021-06-28',4,1,2,'GENERADO AUNTOMATICAMENTE','0000969','1624939428808007756',1,'','AAURAZO',NULL,NULL,'0000969',1),(970,'2021-06-29 19:47:31','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000970','16250139421300893779',1,'','AAURAZO',NULL,NULL,'0000970',1),(971,'2021-06-29 19:48:08','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000971','1625014054111624441',1,'','AAURAZO',NULL,NULL,'0000971',1),(972,'2021-06-29 19:48:37','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000972','16250140901233204787',1,'','AAURAZO',NULL,NULL,'0000972',1),(973,'2021-06-29 19:49:02','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000973','162501412065795594',1,'','AAURAZO',NULL,NULL,'0000973',1),(974,'2021-06-29 19:49:16','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000974','1625014145671123660',1,'','AAURAZO',NULL,NULL,'0000974',1),(975,'2021-06-29 19:49:35','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000975','1625014159118208304',1,'','AAURAZO',NULL,NULL,'0000975',1),(976,'2021-06-29 19:50:00','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000976','1625014178199237148',1,'','AAURAZO',NULL,NULL,'0000976',1),(977,'2021-06-29 19:51:01','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000977','1625014202814204333',1,'','AAURAZO',NULL,NULL,'0000977',1),(978,'2021-06-29 19:52:21','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000978','162501426461793638',1,'','AAURAZO',NULL,NULL,'0000978',1),(979,'2021-06-29 19:52:59','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000979','1625014351304535916',1,'','AAURAZO',NULL,NULL,'0000979',1),(980,'2021-06-29 19:53:45','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000980','1625014382244549613',1,'','AAURAZO',NULL,NULL,'0000980',1),(981,'2021-06-29 19:54:19','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000981','16250144291052385242',1,'','AAURAZO',NULL,NULL,'0000981',1),(982,'2021-06-29 19:54:42','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000982','1625014462858484036',1,'','AAURAZO',NULL,NULL,'0000982',1),(983,'2021-06-29 19:55:09','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000983','16250144891085734872',1,'','AAURAZO',NULL,NULL,'0000983',1),(984,'2021-06-29 19:55:31','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000984','16250145121002210185',1,'','AAURAZO',NULL,NULL,'0000984',1),(985,'2021-06-29 19:56:35','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000985','1625014533209607807',1,'','AAURAZO',NULL,NULL,'0000985',1),(986,'2021-06-29 19:58:16','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000986','1625014618703053242',1,'','AAURAZO',NULL,NULL,'0000986',1),(987,'2021-06-29 19:58:46','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000987','1625014699226132011',1,'','AAURAZO',NULL,NULL,'0000987',1),(988,'2021-06-29 19:59:49','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000988','1625014730375753514',1,'','AAURAZO',NULL,NULL,'0000988',1),(989,'2021-06-29 20:00:20','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000989','1625014792873803350',1,'','AAURAZO',NULL,NULL,'0000989',1),(990,'2021-06-29 20:00:52','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000990','16250148221287209672',1,'','AAURAZO',NULL,NULL,'0000990',1),(991,'2021-06-29 20:01:25','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000991','1625014859976434148',1,'','AAURAZO',NULL,NULL,'0000991',1),(992,'2021-06-29 20:01:53','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000992','162501488778403906',1,'','AAURAZO',NULL,NULL,'0000992',1),(993,'2021-06-29 20:02:34','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000993','1625014915366802904',1,'','AAURAZO',NULL,NULL,'0000993',1),(994,'2021-06-29 20:03:23','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000994','16250149571013441480',1,'','AAURAZO',NULL,NULL,'0000994',1),(995,'2021-06-29 20:03:54','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000995','16250150061124377412',1,'','AAURAZO',NULL,NULL,'0000995',1),(996,'2021-06-29 20:04:14','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000996','1625015036151988252',1,'','AAURAZO',NULL,NULL,'0000996',1),(997,'2021-06-29 20:05:07','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000997','1625015078629081610',1,'','AAURAZO',NULL,NULL,'0000997',1),(998,'2021-06-29 20:06:01','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000998','1625015138463495316',1,'','AAURAZO',NULL,NULL,'0000998',1),(999,'2021-06-29 20:06:31','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0000999','1625015167711272312',1,'','AAURAZO',NULL,NULL,'0000999',1),(1000,'2021-06-29 20:07:36','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001000','1625015206836839050',1,'','AAURAZO',NULL,NULL,'0001000',1),(1001,'2021-06-29 20:08:15','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001001','1625015259721642972',1,'','AAURAZO',NULL,NULL,'0001001',1),(1002,'2021-06-29 20:08:30','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001002','1625015297272132985',1,'','AAURAZO',NULL,NULL,'0001002',1),(1003,'2021-06-29 20:09:11','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001003','16250153131242456620',1,'','AAURAZO',NULL,NULL,'0001003',1),(1004,'2021-06-29 20:10:35','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001004','162501535421860145',1,'','AAURAZO',NULL,NULL,'0001004',1),(1005,'2021-06-29 20:11:29','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001005','1625015441871780856',1,'','AAURAZO',NULL,NULL,'0001005',1),(1006,'2021-06-29 20:12:01','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001006','1625015492341973566',1,'','AAURAZO',NULL,NULL,'0001006',1),(1007,'2021-06-29 20:13:10','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001007','1625015566133570649',1,'','AAURAZO',NULL,NULL,'0001007',1),(1008,'2021-06-29 20:13:41','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001008','16250156011005824855',1,'','AAURAZO',NULL,NULL,'0001008',1),(1009,'2021-06-29 20:14:06','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001009','16250156241350380327',1,'','AAURAZO',NULL,NULL,'0001009',1),(1010,'2021-06-29 20:14:30','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001010','1625015649696426348',1,'','AAURAZO',NULL,NULL,'0001010',1),(1011,'2021-06-29 20:14:55','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001011','16250156731388248294',1,'','AAURAZO',NULL,NULL,'0001011',1),(1012,'2021-06-29 20:16:05','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001012','1625015735240074308',1,'','AAURAZO',NULL,NULL,'0001012',1),(1013,'2021-06-29 20:16:30','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001013','1625015767400970138',1,'','AAURAZO',NULL,NULL,'0001013',1),(1014,'2021-06-29 20:17:00','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001014','16250157931205234129',1,'','AAURAZO',NULL,NULL,'0001014',1),(1015,'2021-06-29 20:17:31','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001015','1625015823513885532',1,'','AAURAZO',NULL,NULL,'0001015',1),(1016,'2021-06-29 20:18:42','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001016','1625015895167393629',1,'','AAURAZO',NULL,NULL,'0001016',1),(1017,'2021-06-29 20:19:12','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001017','16250159271084013601',1,'','AAURAZO',NULL,NULL,'0001017',1),(1018,'2021-06-29 20:19:50','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001018','16250159621043176441',1,'','AAURAZO',NULL,NULL,'0001018',1),(1019,'2021-06-29 20:20:18','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001019','1625015993769709471',1,'','AAURAZO',NULL,NULL,'0001019',1),(1020,'2021-06-29 20:20:40','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001020','1625016021909261538',1,'','AAURAZO',NULL,NULL,'0001020',1),(1021,'2021-06-29 20:21:04','2021-06-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001021','1625016042922300167',1,'','AAURAZO',NULL,NULL,'0001021',1),(1022,'2021-06-30 18:42:07','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001022','1625096265160895830',1,'','AAURAZO',NULL,NULL,'0001022',1),(1023,'2021-06-30 18:43:41','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001023','16250965661239100141',1,'','AAURAZO',NULL,NULL,'0001023',1),(1024,'2021-06-30 18:43:58','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001024','1625096623961760311',1,'','AAURAZO',NULL,NULL,'0001024',1),(1025,'2021-06-30 18:44:22','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001025','1625096640806974994',1,'','AAURAZO',NULL,NULL,'0001025',1),(1026,'2021-06-30 18:44:47','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001026','1625096664462892871',1,'','AAURAZO',NULL,NULL,'0001026',1),(1027,'2021-06-30 18:45:11','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001027','1625096690290292397',1,'','AAURAZO',NULL,NULL,'0001027',1),(1028,'2021-06-30 18:45:47','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001028','16250967191074116292',1,'','AAURAZO',NULL,NULL,'0001028',1),(1029,'2021-06-30 18:46:32','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001029','1625096750919244911',1,'','AAURAZO',NULL,NULL,'0001029',1),(1030,'2021-06-30 18:55:21','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001030','162509730631241074',1,'','AAURAZO',NULL,NULL,'0001030',1),(1031,'2021-06-30 18:56:03','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001031','1625097324894243446',1,'','AAURAZO',NULL,NULL,'0001031',1),(1032,'2021-06-30 18:56:37','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001032','1625097366324976012',1,'','AAURAZO',NULL,NULL,'0001032',1),(1033,'2021-06-30 18:57:03','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001033','1625097400271960858',1,'','AAURAZO',NULL,NULL,'0001033',1),(1034,'2021-06-30 18:57:56','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001034','16250974261016884022',1,'','AAURAZO',NULL,NULL,'0001034',1),(1035,'2021-06-30 18:58:27','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001035','16250974811230795007',1,'','AAURAZO',NULL,NULL,'0001035',1),(1036,'2021-06-30 18:58:54','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001036','16250975091216379360',1,'','AAURAZO',NULL,NULL,'0001036',1),(1037,'2021-06-30 18:59:20','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001037','1625097540854008731',1,'','AAURAZO',NULL,NULL,'0001037',1),(1038,'2021-06-30 19:00:22','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001038','16250975631305196957',1,'','AAURAZO',NULL,NULL,'0001038',1),(1039,'2021-06-30 19:02:03','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001039','1625097642314992639',1,'','AAURAZO',NULL,NULL,'0001039',1),(1040,'2021-06-30 19:04:05','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001040','1625097726703784782',1,'','AAURAZO',NULL,NULL,'0001040',1),(1041,'2021-06-30 19:06:38','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001041','16250978631102732426',1,'','AAURAZO',NULL,NULL,'0001041',1),(1042,'2021-06-30 19:07:07','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001042','1625098005805899199',1,'','AAURAZO',NULL,NULL,'0001042',1),(1043,'2021-06-30 19:07:58','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001043','1625098030325922711',1,'','AAURAZO',NULL,NULL,'0001043',1),(1044,'2021-06-30 19:09:03','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001044','1625098124717727079',1,'','AAURAZO',NULL,NULL,'0001044',1),(1045,'2021-06-30 19:09:35','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001045','16250981461018390135',1,'','AAURAZO',NULL,NULL,'0001045',1),(1046,'2021-06-30 19:10:04','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001046','16250981781378480080',1,'','AAURAZO',NULL,NULL,'0001046',1),(1047,'2021-06-30 19:10:20','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001047','1625098207666175006',1,'','AAURAZO',NULL,NULL,'0001047',1),(1048,'2021-06-30 19:10:53','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001048','1625098223764760816',1,'','AAURAZO',NULL,NULL,'0001048',1),(1049,'2021-06-30 19:11:16','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001049','1625098256274413669',1,'','AAURAZO',NULL,NULL,'0001049',1),(1050,'2021-06-30 19:11:47','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001050','1625098284431909989',1,'','AAURAZO',NULL,NULL,'0001050',1),(1051,'2021-06-30 19:13:17','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001051','162509835518632762',1,'','AAURAZO',NULL,NULL,'0001051',1),(1052,'2021-06-30 19:13:52','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001052','1625098400947559823',1,'','AAURAZO',NULL,NULL,'0001052',1),(1053,'2021-06-30 19:14:17','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001053','162509843687311485',1,'','AAURAZO',NULL,NULL,'0001053',1),(1054,'2021-06-30 19:14:40','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001054','1625098461864078167',1,'','AAURAZO',NULL,NULL,'0001054',1),(1055,'2021-06-30 19:15:57','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001055','1625098493593881613',1,'','AAURAZO',NULL,NULL,'0001055',1),(1056,'2021-06-30 19:16:25','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001056','16250985601075278150',1,'','AAURAZO',NULL,NULL,'0001056',1),(1057,'2021-06-30 19:16:52','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001057','16250985881402793036',1,'','AAURAZO',NULL,NULL,'0001057',1),(1058,'2021-06-30 19:18:06','2021-06-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001058','1625098644651802391',1,'','AAURAZO',NULL,NULL,'0001058',1),(1059,'2021-07-29 19:19:02','2021-07-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001059','1627604270770096757',1,'','AAURAZO',NULL,NULL,'0001059',1),(1060,'2021-07-29 19:19:42','2021-07-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001060','16276043441287812117',1,'','AAURAZO',NULL,NULL,'0001060',1),(1061,'2021-07-29 19:20:09','2021-07-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001061','1627604385718802874',1,'','AAURAZO',NULL,NULL,'0001061',1),(1062,'2021-07-29 19:20:41','2021-07-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001062','1627604412975788671',1,'','AAURAZO',NULL,NULL,'0001062',1),(1063,'2021-07-29 19:21:04','2021-07-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001063','1627604444816528049',1,'','AAURAZO',NULL,NULL,'0001063',1),(1064,'2021-07-29 19:21:22','2021-07-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001064','1627604466119413193',1,'','AAURAZO',NULL,NULL,'0001064',1),(1065,'2021-07-29 19:21:48','2021-07-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001065','16276044851327573483',1,'','AAURAZO',NULL,NULL,'0001065',1),(1066,'2021-07-29 19:23:52','2021-07-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001066','1627604511398646422',1,'','AAURAZO',NULL,NULL,'0001066',1),(1067,'2021-07-29 19:24:18','2021-07-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001067','16276046381167710416',1,'','AAURAZO',NULL,NULL,'0001067',1),(1068,'2021-07-29 19:25:16','2021-07-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001068','1627604670923031708',1,'','AAURAZO',NULL,NULL,'0001068',1),(1069,'2021-07-30 22:16:28','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001069','16277013731132940736',1,'','AAURAZO',NULL,NULL,'0001069',1),(1070,'2021-07-30 22:16:50','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001070','1627701390562769635',1,'','AAURAZO',NULL,NULL,'0001070',1),(1071,'2021-07-30 22:17:12','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001071','1627701412825521691',1,'','AAURAZO',NULL,NULL,'0001071',1),(1072,'2021-07-30 22:17:36','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001072','1627701434817302621',1,'','AAURAZO',NULL,NULL,'0001072',1),(1073,'2021-07-30 22:18:13','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001073','16277014591257431680',1,'','AAURAZO',NULL,NULL,'0001073',1),(1074,'2021-07-30 22:18:34','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001074','1627701495459020011',1,'','AAURAZO',NULL,NULL,'0001074',1),(1075,'2021-07-30 22:19:00','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001075','1627701517548310957',1,'','AAURAZO',NULL,NULL,'0001075',1),(1076,'2021-07-30 22:19:20','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001076','1627701543589664499',1,'','AAURAZO',NULL,NULL,'0001076',1),(1077,'2021-07-30 22:19:44','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001077','1627701563400109502',1,'','AAURAZO',NULL,NULL,'0001077',1),(1078,'2021-07-30 22:20:05','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001078','16277015871269050260',1,'','AAURAZO',NULL,NULL,'0001078',1),(1079,'2021-07-30 22:20:32','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001079','1627701610781457147',1,'','AAURAZO',NULL,NULL,'0001079',1),(1080,'2021-07-30 22:20:54','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001080','1627701634171395585',1,'','AAURAZO',NULL,NULL,'0001080',1),(1081,'2021-07-30 22:21:21','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001081','1627701657864723644',1,'','AAURAZO',NULL,NULL,'0001081',1),(1082,'2021-07-30 22:21:56','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001082','1627701684862529023',1,'','AAURAZO',NULL,NULL,'0001082',1),(1083,'2021-07-30 22:22:37','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001083','16277017331186041954',1,'','AAURAZO',NULL,NULL,'0001083',1),(1084,'2021-07-30 22:23:01','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001084','1627701759965331949',1,'','AAURAZO',NULL,NULL,'0001084',1),(1085,'2021-07-30 22:23:27','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001085','1627701783151730061',1,'','AAURAZO',NULL,NULL,'0001085',1),(1086,'2021-07-30 22:23:53','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001086','1627701809846736360',1,'','AAURAZO',NULL,NULL,'0001086',1),(1087,'2021-07-30 22:24:21','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001087','1627701836838603353',1,'','AAURAZO',NULL,NULL,'0001087',1),(1088,'2021-07-30 22:24:58','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001088','16277018691349433628',1,'','AAURAZO',NULL,NULL,'0001088',1),(1089,'2021-07-30 22:25:31','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001089','162770190184428355',1,'','AAURAZO',NULL,NULL,'0001089',1),(1090,'2021-07-30 22:26:09','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001090','16277019331179458092',1,'','AAURAZO',NULL,NULL,'0001090',1),(1091,'2021-07-30 22:26:49','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001091','16277019761282949526',1,'','AAURAZO',NULL,NULL,'0001091',1),(1092,'2021-07-30 22:27:59','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001092','1627702015300749119',1,'','AAURAZO',NULL,NULL,'0001092',1),(1093,'2021-07-30 22:30:01','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001093','1627702082432942751',1,'','AAURAZO',NULL,NULL,'0001093',1),(1094,'2021-07-30 22:30:33','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001094','162770221014458679',1,'','AAURAZO',NULL,NULL,'0001094',1),(1095,'2021-07-30 22:31:03','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001095','16277022361079667391',1,'','AAURAZO',NULL,NULL,'0001095',1),(1096,'2021-07-30 22:31:24','2021-07-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001096','16277022651181867872',1,'','AAURAZO',NULL,NULL,'0001096',1),(1097,'2021-07-31 23:25:39','2021-07-31',4,1541,1,'GENERADO AUNTOMATICAMENTE','0001097','1627791813753228299',1,'','AAURAZO',NULL,NULL,'0001097',1),(1098,'2021-07-31 23:29:33','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001098','1627792154682053733',1,'','AAURAZO',NULL,NULL,'0001098',1),(1099,'2021-07-31 23:29:51','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001099','1627792177253112938',1,'','AAURAZO',NULL,NULL,'0001099',1),(1100,'2021-07-31 23:30:13','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001100','1627792194403939331',1,'','AAURAZO',NULL,NULL,'0001100',1),(1101,'2021-07-31 23:30:33','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001101','1627792216449165733',1,'','AAURAZO',NULL,NULL,'0001101',1),(1102,'2021-07-31 23:30:57','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001102','1627792235312238605',1,'','AAURAZO',NULL,NULL,'0001102',1),(1103,'2021-07-31 23:31:30','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001103','16277922601305971529',1,'','AAURAZO',NULL,NULL,'0001103',1),(1104,'2021-07-31 23:31:51','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001104','162779229391700726',1,'','AAURAZO',NULL,NULL,'0001104',1),(1105,'2021-07-31 23:32:11','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001105','16277923131394143648',1,'','AAURAZO',NULL,NULL,'0001105',1),(1106,'2021-07-31 23:32:55','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001106','16277923381175800391',1,'','AAURAZO',NULL,NULL,'0001106',1),(1107,'2021-07-31 23:33:17','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001107','1627792378263569660',1,'','AAURAZO',NULL,NULL,'0001107',1),(1108,'2021-07-31 23:33:41','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001108','16277923991100107487',1,'','AAURAZO',NULL,NULL,'0001108',1),(1109,'2021-07-31 23:34:03','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001109','1627792423166619057',1,'','AAURAZO',NULL,NULL,'0001109',1),(1110,'2021-07-31 23:34:28','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001110','16277924501260573000',1,'','AAURAZO',NULL,NULL,'0001110',1),(1111,'2021-07-31 23:35:05','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001111','16277924801380287415',1,'','AAURAZO',NULL,NULL,'0001111',1),(1112,'2021-07-31 23:35:30','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001112','16277925071201404300',1,'','AAURAZO',NULL,NULL,'0001112',1),(1113,'2021-07-31 23:36:17','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001113','1627792549828060567',1,'','AAURAZO',NULL,NULL,'0001113',1),(1114,'2021-07-31 23:36:43','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001114','16277925801170679609',1,'','AAURAZO',NULL,NULL,'0001114',1),(1115,'2021-07-31 23:37:19','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001115','1627792605266624917',1,'','AAURAZO',NULL,NULL,'0001115',1),(1116,'2021-07-31 23:37:47','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001116','16277926441295514806',1,'','AAURAZO',NULL,NULL,'0001116',1),(1117,'2021-07-31 23:38:13','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001117','1627792670515477708',1,'','AAURAZO',NULL,NULL,'0001117',1),(1118,'2021-07-31 23:38:45','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001118','1627792706160895830',1,'','AAURAZO',NULL,NULL,'0001118',1),(1119,'2021-07-31 23:39:05','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001119','1627792727939986229',1,'','AAURAZO',NULL,NULL,'0001119',1),(1120,'2021-07-31 23:39:35','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001120','1627792748875352494',1,'','AAURAZO',NULL,NULL,'0001120',1),(1121,'2021-07-31 23:39:59','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001121','16277927781391346583',1,'','AAURAZO',NULL,NULL,'0001121',1),(1122,'2021-07-31 23:40:25','2021-07-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001122','1627792802487593113',1,'','AAURAZO',NULL,NULL,'0001122',1),(1123,'2021-08-24 21:43:04','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001123','162985935626378482',1,'','AAURAZO',NULL,NULL,'0001123',1),(1124,'2021-08-24 21:43:23','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001124','16298593882926162',1,'','AAURAZO',NULL,NULL,'0001124',1),(1125,'2021-08-24 21:44:19','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001125','1629859406216062574',1,'','AAURAZO',NULL,NULL,'0001125',1),(1126,'2021-08-24 21:44:39','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001126','162985946258178969',1,'','AAURAZO',NULL,NULL,'0001126',1),(1127,'2021-08-24 21:45:04','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001127','1629859483783909959',1,'','AAURAZO',NULL,NULL,'0001127',1),(1128,'2021-08-24 21:45:26','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001128','1629859507901946135',1,'','AAURAZO',NULL,NULL,'0001128',1),(1129,'2021-08-24 21:45:54','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001129','16298595291056215071',1,'','AAURAZO',NULL,NULL,'0001129',1),(1130,'2021-08-24 21:46:41','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001130','1629859567506225875',1,'','AAURAZO',NULL,NULL,'0001130',1),(1131,'2021-08-24 21:47:21','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001131','1629859605940631706',1,'','AAURAZO',NULL,NULL,'0001131',1),(1132,'2021-08-24 21:48:03','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001132','1629859647279061102',1,'','AAURAZO',NULL,NULL,'0001132',1),(1133,'2021-08-24 21:48:44','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001133','16298596861376672745',1,'','AAURAZO',NULL,NULL,'0001133',1),(1134,'2021-08-24 21:49:53','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001134','1629859727218773576',1,'','AAURAZO',NULL,NULL,'0001134',1),(1135,'2021-08-24 21:50:20','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001135','1629859797387931508',1,'','AAURAZO',NULL,NULL,'0001135',1),(1136,'2021-08-24 21:50:46','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001136','16298598241253171533',1,'','AAURAZO',NULL,NULL,'0001136',1),(1137,'2021-08-24 21:51:21','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001137','16298598551267544148',1,'','AAURAZO',NULL,NULL,'0001137',1),(1138,'2021-08-24 21:51:50','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001138','1629859884729087470',1,'','AAURAZO',NULL,NULL,'0001138',1),(1139,'2021-08-24 21:52:20','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001139','16298599181312039010',1,'','AAURAZO',NULL,NULL,'0001139',1),(1140,'2021-08-24 21:52:47','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001140','16298599431291684977',1,'','AAURAZO',NULL,NULL,'0001140',1),(1141,'2021-08-24 21:53:26','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001141','1629859970217310496',1,'','AAURAZO',NULL,NULL,'0001141',1),(1142,'2021-08-24 21:54:18','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001142','1629860009554980883',1,'','AAURAZO',NULL,NULL,'0001142',1),(1143,'2021-08-24 21:54:52','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001143','1629860061824316802',1,'','AAURAZO',NULL,NULL,'0001143',1),(1144,'2021-08-24 21:55:33','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001144','16298601061058323628',1,'','AAURAZO',NULL,NULL,'0001144',1),(1145,'2021-08-24 21:57:20','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001145','1629860137702407765',1,'','AAURAZO',NULL,NULL,'0001145',1),(1146,'2021-08-24 21:58:07','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001146','1629860248219074799',1,'','AAURAZO',NULL,NULL,'0001146',1),(1147,'2021-08-24 21:59:00','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001147','16298602941182771539',1,'','AAURAZO',NULL,NULL,'0001147',1),(1148,'2021-08-24 21:59:27','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001148','1629860343279061102',1,'','AAURAZO',NULL,NULL,'0001148',1),(1149,'2021-08-24 21:59:59','2021-08-24',4,1,2,'GENERADO AUNTOMATICAMENTE','0001149','16298603731376672745',1,'','AAURAZO',NULL,NULL,'0001149',1),(1150,'2021-08-26 18:58:10','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001150','1630022264605629289',1,'','AAURAZO',NULL,NULL,'0001150',1),(1151,'2021-08-26 18:58:35','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001151','1630022293321490438',1,'','AAURAZO',NULL,NULL,'0001151',1),(1152,'2021-08-26 18:58:57','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001152','16300223195809291',1,'','AAURAZO',NULL,NULL,'0001152',1),(1153,'2021-08-26 18:59:13','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001153','1630022340860377434',1,'','AAURAZO',NULL,NULL,'0001153',1),(1154,'2021-08-26 18:59:36','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001154','1630022356477222454',1,'','AAURAZO',NULL,NULL,'0001154',1),(1155,'2021-08-26 19:00:06','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001155','1630022378294724670',1,'','AAURAZO',NULL,NULL,'0001155',1),(1156,'2021-08-26 19:00:28','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001156','1630022408862873278',1,'','AAURAZO',NULL,NULL,'0001156',1),(1157,'2021-08-26 19:01:05','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001157','1630022431630802881',1,'','AAURAZO',NULL,NULL,'0001157',1),(1158,'2021-08-26 19:01:30','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001158','16300224681363246830',1,'','AAURAZO',NULL,NULL,'0001158',1),(1159,'2021-08-26 19:01:52','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001159','1630022492963782804',1,'','AAURAZO',NULL,NULL,'0001159',1),(1160,'2021-08-26 19:02:26','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001160','1630022514425455221',1,'','AAURAZO',NULL,NULL,'0001160',1),(1161,'2021-08-26 19:02:48','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001161','1630022549219462085',1,'','AAURAZO',NULL,NULL,'0001161',1),(1162,'2021-08-26 19:03:10','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001162','1630022571873028778',1,'','AAURAZO',NULL,NULL,'0001162',1),(1163,'2021-08-26 19:03:33','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001163','1630022592530108513',1,'','AAURAZO',NULL,NULL,'0001163',1),(1164,'2021-08-26 19:04:01','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001164','1630022615596979901',1,'','AAURAZO',NULL,NULL,'0001164',1),(1165,'2021-08-26 19:04:39','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001165','1630022659540737363',1,'','AAURAZO',NULL,NULL,'0001165',1),(1166,'2021-08-26 19:05:01','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001166','1630022681774916317',1,'','AAURAZO',NULL,NULL,'0001166',1),(1167,'2021-08-26 19:05:29','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001167','1630022704331990193',1,'','AAURAZO',NULL,NULL,'0001167',1),(1168,'2021-08-26 19:05:58','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001168','1630022732469476734',1,'','AAURAZO',NULL,NULL,'0001168',1),(1169,'2021-08-26 19:06:12','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001169','163002276048755009',1,'','AAURAZO',NULL,NULL,'0001169',1),(1170,'2021-08-26 19:06:37','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001170','1630022774898718751',1,'','AAURAZO',NULL,NULL,'0001170',1),(1171,'2021-08-26 19:06:58','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001171','1630022799935683051',1,'','AAURAZO',NULL,NULL,'0001171',1),(1172,'2021-08-26 19:07:20','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001172','1630022820729474756',1,'','AAURAZO',NULL,NULL,'0001172',1),(1173,'2021-08-26 19:07:39','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001173','16300228421256571044',1,'','AAURAZO',NULL,NULL,'0001173',1),(1174,'2021-08-26 19:07:59','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001174','16300228621227868846',1,'','AAURAZO',NULL,NULL,'0001174',1),(1175,'2021-08-26 19:08:18','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001175','1630022881333797527',1,'','AAURAZO',NULL,NULL,'0001175',1),(1176,'2021-08-26 19:08:39','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001176','163002290045054275',1,'','AAURAZO',NULL,NULL,'0001176',1),(1177,'2021-08-26 19:09:00','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001177','16300229211009826810',1,'','AAURAZO',NULL,NULL,'0001177',1),(1178,'2021-08-26 19:09:19','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001178','16300229421235270312',1,'','AAURAZO',NULL,NULL,'0001178',1),(1179,'2021-08-26 19:09:39','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001179','1630022963129697789',1,'','AAURAZO',NULL,NULL,'0001179',1),(1180,'2021-08-26 19:10:04','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001180','1630022982355958895',1,'','AAURAZO',NULL,NULL,'0001180',1),(1181,'2021-08-26 19:11:05','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001181','1630023007709809232',1,'','AAURAZO',NULL,NULL,'0001181',1),(1182,'2021-08-26 19:11:34','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001182','16300230681250159308',1,'','AAURAZO',NULL,NULL,'0001182',1),(1183,'2021-08-26 19:12:02','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001183','16300230961283853193',1,'','AAURAZO',NULL,NULL,'0001183',1),(1184,'2021-08-26 19:12:30','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001184','16300231311047178396',1,'','AAURAZO',NULL,NULL,'0001184',1),(1185,'2021-08-26 19:13:01','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001185','16300231521073815069',1,'','AAURAZO',NULL,NULL,'0001185',1),(1186,'2021-08-26 19:13:43','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001186','1630023184475113897',1,'','AAURAZO',NULL,NULL,'0001186',1),(1187,'2021-08-26 19:14:07','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001187','16300232271278732411',1,'','AAURAZO',NULL,NULL,'0001187',1),(1188,'2021-08-26 19:14:31','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001188','16300232501167839511',1,'','AAURAZO',NULL,NULL,'0001188',1),(1189,'2021-08-26 19:15:21','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001189','16300232741081818980',1,'','AAURAZO',NULL,NULL,'0001189',1),(1190,'2021-08-26 19:15:50','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001190','1630023324778143700',1,'','AAURAZO',NULL,NULL,'0001190',1),(1191,'2021-08-26 19:16:18','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001191','1630023355849533425',1,'','AAURAZO',NULL,NULL,'0001191',1),(1192,'2021-08-26 19:16:50','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001192','1630023380881204816',1,'','AAURAZO',NULL,NULL,'0001192',1),(1193,'2021-08-26 19:17:13','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001193','1630023413462634680',1,'','AAURAZO',NULL,NULL,'0001193',1),(1194,'2021-08-26 19:17:44','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001194','16300234361089091351',1,'','AAURAZO',NULL,NULL,'0001194',1),(1195,'2021-08-26 19:18:07','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001195','1630023466992829257',1,'','AAURAZO',NULL,NULL,'0001195',1),(1196,'2021-08-26 19:18:21','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001196','1630023490589320244',1,'','AAURAZO',NULL,NULL,'0001196',1),(1197,'2021-08-26 19:18:47','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001197','1630023503247647901',1,'','AAURAZO',NULL,NULL,'0001197',1),(1198,'2021-08-26 19:19:11','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001198','1630023529690315835',1,'','AAURAZO',NULL,NULL,'0001198',1),(1199,'2021-08-26 19:19:43','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001199','16300235541066757857',1,'','AAURAZO',NULL,NULL,'0001199',1),(1200,'2021-08-26 19:20:06','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001200','1630023585345243981',1,'','AAURAZO',NULL,NULL,'0001200',1),(1201,'2021-08-26 19:20:28','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001201','1630023609577056187',1,'','AAURAZO',NULL,NULL,'0001201',1),(1202,'2021-08-26 19:21:22','2021-08-26',4,1,2,'GENERADO AUNTOMATICAMENTE','0001202','1630023630941492342',1,'','AAURAZO',NULL,NULL,'0001202',1),(1203,'2021-08-31 21:08:06','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001203','16304620621400684479',1,'','AAURAZO',NULL,NULL,'0001203',1),(1204,'2021-08-31 21:08:25','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001204','1630462089511518784',1,'','AAURAZO',NULL,NULL,'0001204',1),(1205,'2021-08-31 21:09:04','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001205','1630462107787481597',1,'','AAURAZO',NULL,NULL,'0001205',1),(1206,'2021-08-31 21:09:29','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001206','16304621471145893303',1,'','AAURAZO',NULL,NULL,'0001206',1),(1207,'2021-08-31 21:09:51','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001207','1630462172804091864',1,'','AAURAZO',NULL,NULL,'0001207',1),(1208,'2021-08-31 21:11:31','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001208','1630462272733046394',1,'','AAURAZO',NULL,NULL,'0001208',1),(1209,'2021-08-31 21:12:00','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001209','16304622951051008225',1,'','AAURAZO',NULL,NULL,'0001209',1),(1210,'2021-08-31 21:12:20','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001210','163046232396606349',1,'','AAURAZO',NULL,NULL,'0001210',1),(1211,'2021-08-31 21:12:38','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001211','163046234378834224',1,'','AAURAZO',NULL,NULL,'0001211',1),(1212,'2021-08-31 21:13:01','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001212','16304623601311350501',1,'','AAURAZO',NULL,NULL,'0001212',1),(1213,'2021-08-31 21:13:29','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001213','1630462387209435680',1,'','AAURAZO',NULL,NULL,'0001213',1),(1214,'2021-08-31 21:14:50','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001214','1630462429848156408',1,'','AAURAZO',NULL,NULL,'0001214',1),(1215,'2021-08-31 21:15:21','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001215','1630462492462032235',1,'','AAURAZO',NULL,NULL,'0001215',1),(1216,'2021-08-31 21:15:59','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001216','1630462524829136361',1,'','AAURAZO',NULL,NULL,'0001216',1),(1217,'2021-08-31 21:16:21','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001217','1630462562346534935',1,'','AAURAZO',NULL,NULL,'0001217',1),(1218,'2021-08-31 21:16:41','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001218','1630462584898847847',1,'','AAURAZO',NULL,NULL,'0001218',1),(1219,'2021-08-31 21:18:12','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001219','1630462604682354955',1,'','AAURAZO',NULL,NULL,'0001219',1),(1220,'2021-08-31 21:18:56','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001220','16304626971225717257',1,'','AAURAZO',NULL,NULL,'0001220',1),(1221,'2021-08-31 21:19:53','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001221','1630462775420377471',1,'','AAURAZO',NULL,NULL,'0001221',1),(1222,'2021-08-31 21:21:16','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001222','1630462859692467424',1,'','AAURAZO',NULL,NULL,'0001222',1),(1223,'2021-08-31 21:21:35','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001223','1630462878737521699',1,'','AAURAZO',NULL,NULL,'0001223',1),(1224,'2021-08-31 21:22:08','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001224','16304628971252310898',1,'','AAURAZO',NULL,NULL,'0001224',1),(1225,'2021-08-31 21:22:44','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001225','1630462930880129022',1,'','AAURAZO',NULL,NULL,'0001225',1),(1226,'2021-08-31 21:23:07','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001226','1630462966889897236',1,'','AAURAZO',NULL,NULL,'0001226',1),(1227,'2021-08-31 21:24:13','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001227','1630463036410652289',1,'','AAURAZO',NULL,NULL,'0001227',1),(1228,'2021-08-31 21:24:35','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001228','1630463055430403876',1,'','AAURAZO',NULL,NULL,'0001228',1),(1229,'2021-08-31 21:25:07','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001229','16304630781396424333',1,'','AAURAZO',NULL,NULL,'0001229',1),(1230,'2021-08-31 21:25:32','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001230','1630463110456265977',1,'','AAURAZO',NULL,NULL,'0001230',1),(1231,'2021-08-31 21:26:07','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001231','16304631351363160766',1,'','AAURAZO',NULL,NULL,'0001231',1),(1232,'2021-08-31 21:26:49','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001232','16304631691198349044',1,'','AAURAZO',NULL,NULL,'0001232',1),(1233,'2021-08-31 21:27:47','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001233','1630463240240031276',1,'','AAURAZO',NULL,NULL,'0001233',1),(1234,'2021-08-31 21:28:35','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001234','1630463270148201455',1,'','AAURAZO',NULL,NULL,'0001234',1),(1235,'2021-08-31 21:29:14','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001235','163046333135587284',1,'','AAURAZO',NULL,NULL,'0001235',1),(1236,'2021-08-31 21:30:14','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001236','1630463357755552015',1,'','AAURAZO',NULL,NULL,'0001236',1),(1237,'2021-08-31 21:30:38','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001237','16304634171185310414',1,'','AAURAZO',NULL,NULL,'0001237',1),(1238,'2021-08-31 21:31:12','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001238','1630463441253887510',1,'','AAURAZO',NULL,NULL,'0001238',1),(1239,'2021-08-31 21:31:53','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001239','1630463479444303142',1,'','AAURAZO',NULL,NULL,'0001239',1),(1240,'2021-08-31 21:32:14','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001240','1630463515264043010',1,'','AAURAZO',NULL,NULL,'0001240',1),(1241,'2021-08-31 21:33:31','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001241','1630463537869026822',1,'','AAURAZO',NULL,NULL,'0001241',1),(1242,'2021-08-31 21:34:02','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001242','16304636161286865418',1,'','AAURAZO',NULL,NULL,'0001242',1),(1243,'2021-08-31 21:34:20','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001243','1630463644657009236',1,'','AAURAZO',NULL,NULL,'0001243',1),(1244,'2021-08-31 21:35:19','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001244','16304636761302615050',1,'','AAURAZO',NULL,NULL,'0001244',1),(1245,'2021-08-31 21:35:53','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001245','1630463722650468405',1,'','AAURAZO',NULL,NULL,'0001245',1),(1246,'2021-08-31 21:36:40','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001246','1630463757609803372',1,'','AAURAZO',NULL,NULL,'0001246',1),(1247,'2021-08-31 21:39:44','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001247','16304638611212463468',1,'','AAURAZO',NULL,NULL,'0001247',1),(1248,'2021-08-31 21:40:19','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001248','1630463994343823932',1,'','AAURAZO',NULL,NULL,'0001248',1),(1249,'2021-08-31 21:41:22','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001249','1630464031889768141',1,'','AAURAZO',NULL,NULL,'0001249',1),(1250,'2021-08-31 21:42:08','2021-08-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001250','16304640971214141708',1,'','AAURAZO',NULL,NULL,'0001250',1),(1251,'2021-09-22 22:31:23','2021-09-22',4,1534,1,'GENERADO AUNTOMATICAMENTE','0001251','1632367809164596564',1,'','AAURAZO',NULL,NULL,'0001251',1),(1252,'2021-09-22 22:33:25','2021-09-22',4,1534,1,'GENERADO AUNTOMATICAMENTE','0001252','1632367942453598006',1,'','AAURAZO',NULL,NULL,'0001252',1),(1253,'2021-09-22 22:34:17','2021-09-22',4,1534,1,'GENERADO AUNTOMATICAMENTE','0001253','16323680081201490364',1,'','AAURAZO',NULL,NULL,'0001253',1),(1254,'2021-09-22 22:35:25','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001254','1632368109714843950',1,'','AAURAZO',NULL,NULL,'0001254',1),(1255,'2021-09-22 22:35:57','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001255','1632368127375753514',1,'','AAURAZO',NULL,NULL,'0001255',1),(1256,'2021-09-22 22:36:26','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001256','1632368161943729994',1,'','AAURAZO',NULL,NULL,'0001256',1),(1257,'2021-09-22 22:36:55','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001257','1632368189501965728',1,'','AAURAZO',NULL,NULL,'0001257',1),(1258,'2021-09-22 22:37:43','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001258','1632368217759683066',1,'','AAURAZO',NULL,NULL,'0001258',1),(1259,'2021-09-22 22:38:10','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001259','1632368265196095828',1,'','AAURAZO',NULL,NULL,'0001259',1),(1260,'2021-09-22 22:38:30','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001260','1632368292856762765',1,'','AAURAZO',NULL,NULL,'0001260',1),(1261,'2021-09-22 22:38:52','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001261','1632368313813128538',1,'','AAURAZO',NULL,NULL,'0001261',1),(1262,'2021-09-22 22:39:23','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001262','1632368334263655724',1,'','AAURAZO',NULL,NULL,'0001262',1),(1263,'2021-09-22 22:39:47','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001263','1632368365871780856',1,'','AAURAZO',NULL,NULL,'0001263',1),(1264,'2021-09-22 22:40:12','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001264','1632368389262752057',1,'','AAURAZO',NULL,NULL,'0001264',1),(1265,'2021-09-22 22:40:36','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001265','1632368415319510976',1,'','AAURAZO',NULL,NULL,'0001265',1),(1266,'2021-09-22 22:40:58','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001266','16323684381118998439',1,'','AAURAZO',NULL,NULL,'0001266',1),(1267,'2021-09-22 22:41:22','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001267','1632368460161713434',1,'','AAURAZO',NULL,NULL,'0001267',1),(1268,'2021-09-22 22:41:42','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001268','1632368485891145158',1,'','AAURAZO',NULL,NULL,'0001268',1),(1269,'2021-09-22 22:42:07','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001269','1632368504457298740',1,'','AAURAZO',NULL,NULL,'0001269',1),(1270,'2021-09-22 22:42:27','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001270','1632368529589277213',1,'','AAURAZO',NULL,NULL,'0001270',1),(1271,'2021-09-22 22:42:50','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001271','1632368549877073765',1,'','AAURAZO',NULL,NULL,'0001271',1),(1272,'2021-09-22 22:43:13','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001272','163236857363687037',1,'','AAURAZO',NULL,NULL,'0001272',1),(1273,'2021-09-22 22:43:39','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001273','1632368597333539337',1,'','AAURAZO',NULL,NULL,'0001273',1),(1274,'2021-09-22 22:44:02','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001274','1632368622573613644',1,'','AAURAZO',NULL,NULL,'0001274',1),(1275,'2021-09-22 22:44:29','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001275','1632368645968172046',1,'','AAURAZO',NULL,NULL,'0001275',1),(1276,'2021-09-22 22:44:56','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001276','16323686711403094259',1,'','AAURAZO',NULL,NULL,'0001276',1),(1277,'2021-09-22 22:45:19','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001277','1632368699675641997',1,'','AAURAZO',NULL,NULL,'0001277',1),(1278,'2021-09-22 22:45:40','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001278','163236872121558923',1,'','AAURAZO',NULL,NULL,'0001278',1),(1279,'2021-09-22 22:46:01','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001279','16323687431244479113',1,'','AAURAZO',NULL,NULL,'0001279',1),(1280,'2021-09-22 22:46:28','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001280','1632368764989429746',1,'','AAURAZO',NULL,NULL,'0001280',1),(1281,'2021-09-22 22:46:58','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001281','1632368790403638108',1,'','AAURAZO',NULL,NULL,'0001281',1),(1282,'2021-09-22 22:47:28','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001282','1632368828727624389',1,'','AAURAZO',NULL,NULL,'0001282',1),(1283,'2021-09-22 22:47:48','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001283','16323688501135350516',1,'','AAURAZO',NULL,NULL,'0001283',1),(1284,'2021-09-22 22:48:21','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001284','16323688711256226790',1,'','AAURAZO',NULL,NULL,'0001284',1),(1285,'2021-09-22 22:48:50','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001285','1632368903373257671',1,'','AAURAZO',NULL,NULL,'0001285',1),(1286,'2021-09-22 22:49:09','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001286','1632368933227595091',1,'','AAURAZO',NULL,NULL,'0001286',1),(1287,'2021-09-22 22:49:33','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001287','16323689511104195507',1,'','AAURAZO',NULL,NULL,'0001287',1),(1288,'2021-09-22 22:49:53','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001288','16323689751050491844',1,'','AAURAZO',NULL,NULL,'0001288',1),(1289,'2021-09-22 22:50:22','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001289','1632368996245582376',1,'','AAURAZO',NULL,NULL,'0001289',1),(1290,'2021-09-22 22:50:50','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001290','163236902989850360',1,'','AAURAZO',NULL,NULL,'0001290',1),(1291,'2021-09-22 22:51:28','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001291','1632369052527440543',1,'','AAURAZO',NULL,NULL,'0001291',1),(1292,'2021-09-22 22:51:55','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001292','1632369090363790679',1,'','AAURAZO',NULL,NULL,'0001292',1),(1293,'2021-09-22 22:52:26','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001293','1632369118838904575',1,'','AAURAZO',NULL,NULL,'0001293',1),(1294,'2021-09-22 22:53:32','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001294','1632369149390470383',1,'','AAURAZO',NULL,NULL,'0001294',1),(1295,'2021-09-22 22:54:01','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001295','1632369220411857179',1,'','AAURAZO',NULL,NULL,'0001295',1),(1296,'2021-09-22 22:54:23','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001296','1632369244764244435',1,'','AAURAZO',NULL,NULL,'0001296',1),(1297,'2021-09-22 22:55:03','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001297','16323692721227997941',1,'','AAURAZO',NULL,NULL,'0001297',1),(1298,'2021-09-22 22:55:31','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001298','1632369305581058142',1,'','AAURAZO',NULL,NULL,'0001298',1),(1299,'2021-09-22 22:55:56','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001299','1632369334604940781',1,'','AAURAZO',NULL,NULL,'0001299',1),(1300,'2021-09-22 22:56:27','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001300','1632369365930002856',1,'','AAURAZO',NULL,NULL,'0001300',1),(1301,'2021-09-22 22:56:58','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001301','1632369397917824862',1,'','AAURAZO',NULL,NULL,'0001301',1),(1302,'2021-09-22 22:57:31','2021-09-22',4,1,2,'GENERADO AUNTOMATICAMENTE','0001302','1632369421133742777',1,'','AAURAZO',NULL,NULL,'0001302',1),(1303,'2021-09-23 22:23:14','2021-09-23',4,1542,1,'GENERADO AUNTOMATICAMENTE','0001303','1632453643972475224',1,'','AAURAZO',NULL,NULL,'0001303',1),(1304,'2021-09-23 22:26:51','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001304','1632453979853922667',1,'','AAURAZO',NULL,NULL,'0001304',1),(1305,'2021-09-23 22:27:14','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001305','1632454014263010247',1,'','AAURAZO',NULL,NULL,'0001305',1),(1306,'2021-09-23 22:27:53','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001306','1632454037293003399',1,'','AAURAZO',NULL,NULL,'0001306',1),(1307,'2021-09-23 22:28:39','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001307','16324540861125840493',1,'','AAURAZO',NULL,NULL,'0001307',1),(1308,'2021-09-23 22:29:05','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001308','163245412218546698',1,'','AAURAZO',NULL,NULL,'0001308',1),(1309,'2021-09-23 22:30:07','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001309','16324541471034742212',1,'','AAURAZO',NULL,NULL,'0001309',1),(1310,'2021-09-23 22:30:38','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001310','1632454213982028280',1,'','AAURAZO',NULL,NULL,'0001310',1),(1311,'2021-09-23 22:31:43','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001311','16324542411002812630',1,'','AAURAZO',NULL,NULL,'0001311',1),(1312,'2021-09-23 22:32:17','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001312','1632454306669488453',1,'','AAURAZO',NULL,NULL,'0001312',1),(1313,'2021-09-23 22:33:03','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001313','163245433986622976',1,'','AAURAZO',NULL,NULL,'0001313',1),(1314,'2021-09-23 22:33:26','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001314','1632454386728571088',1,'','AAURAZO',NULL,NULL,'0001314',1),(1315,'2021-09-23 22:34:44','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001315','1632454409591084547',1,'','AAURAZO',NULL,NULL,'0001315',1),(1316,'2021-09-23 22:36:09','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001316','16324544871318106491',1,'','AAURAZO',NULL,NULL,'0001316',1),(1317,'2021-09-23 22:36:42','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001317','1632454573543061079',1,'','AAURAZO',NULL,NULL,'0001317',1),(1318,'2021-09-23 22:37:17','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001318','163245460547679214',1,'','AAURAZO',NULL,NULL,'0001318',1),(1319,'2021-09-23 22:38:09','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001319','1632454643595602884',1,'','AAURAZO',NULL,NULL,'0001319',1),(1320,'2021-09-23 22:39:49','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001320','16324546911137545137',1,'','AAURAZO',NULL,NULL,'0001320',1),(1321,'2021-09-23 22:41:05','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001321','16324548381034311894',1,'','AAURAZO',NULL,NULL,'0001321',1),(1322,'2021-09-23 22:41:46','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001322','1632454868101856227',1,'','AAURAZO',NULL,NULL,'0001322',1),(1323,'2021-09-23 22:42:07','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001323','1632454912903839533',1,'','AAURAZO',NULL,NULL,'0001323',1),(1324,'2021-09-23 22:42:52','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001324','16324549291347884484',1,'','AAURAZO',NULL,NULL,'0001324',1),(1325,'2021-09-23 22:43:19','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001325','1632454979109300725',1,'','AAURAZO',NULL,NULL,'0001325',1),(1326,'2021-09-23 22:44:23','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001326','163245500232704154',1,'','AAURAZO',NULL,NULL,'0001326',1),(1327,'2021-09-23 22:44:57','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001327','16324550671070931940',1,'','AAURAZO',NULL,NULL,'0001327',1),(1328,'2021-09-23 22:45:26','2021-09-23',4,1,2,'GENERADO AUNTOMATICAMENTE','0001328','16324551051363031671',1,'','AAURAZO',NULL,NULL,'0001328',1),(1329,'2021-09-30 23:26:50','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001329','16330623891010859573',1,'','AAURAZO',NULL,NULL,'0001329',1),(1330,'2021-09-30 23:27:18','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001330','163306241231068947',1,'','AAURAZO',NULL,NULL,'0001330',1),(1331,'2021-09-30 23:28:54','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001331','16330625091053547100',1,'','AAURAZO',NULL,NULL,'0001331',1),(1332,'2021-09-30 23:29:40','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001332','1633062561394515371',1,'','AAURAZO',NULL,NULL,'0001332',1),(1333,'2021-09-30 23:30:11','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001333','1633062582625682099',1,'','AAURAZO',NULL,NULL,'0001333',1),(1334,'2021-09-30 23:30:32','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001334','1633062613638204348',1,'','AAURAZO',NULL,NULL,'0001334',1),(1335,'2021-09-30 23:30:53','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001335','1633062634353678210',1,'','AAURAZO',NULL,NULL,'0001335',1),(1336,'2021-09-30 23:31:33','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001336','1633062656372913417',1,'','AAURAZO',NULL,NULL,'0001336',1),(1337,'2021-09-30 23:31:56','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001337','1633062696841873768',1,'','AAURAZO',NULL,NULL,'0001337',1),(1338,'2021-09-30 23:32:17','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001338','16330627182538876',1,'','AAURAZO',NULL,NULL,'0001338',1),(1339,'2021-09-30 23:32:44','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001339','1633062739414051799',1,'','AAURAZO',NULL,NULL,'0001339',1),(1340,'2021-09-30 23:33:09','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001340','1633062766940674738',1,'','AAURAZO',NULL,NULL,'0001340',1),(1341,'2021-09-30 23:34:28','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001341','16330628141089779860',1,'','AAURAZO',NULL,NULL,'0001341',1),(1342,'2021-09-30 23:34:51','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001342','1633062871412416592',1,'','AAURAZO',NULL,NULL,'0001342',1),(1343,'2021-09-30 23:35:21','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001343','16330628931058194532',1,'','AAURAZO',NULL,NULL,'0001343',1),(1344,'2021-09-30 23:35:46','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001344','16330629231317245855',1,'','AAURAZO',NULL,NULL,'0001344',1),(1345,'2021-09-30 23:36:04','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001345','1633062948247604870',1,'','AAURAZO',NULL,NULL,'0001345',1),(1346,'2021-09-30 23:36:26','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001346','1633062966398000945',1,'','AAURAZO',NULL,NULL,'0001346',1),(1347,'2021-09-30 23:36:48','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001347','1633062988427477715',1,'','AAURAZO',NULL,NULL,'0001347',1),(1348,'2021-09-30 23:37:15','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001348','16330630101052256147',1,'','AAURAZO',NULL,NULL,'0001348',1),(1349,'2021-09-30 23:37:45','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001349','16330630391225028748',1,'','AAURAZO',NULL,NULL,'0001349',1),(1350,'2021-09-30 23:38:09','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001350','16330630671023467885',1,'','AAURAZO',NULL,NULL,'0001350',1),(1351,'2021-09-30 23:38:30','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001351','1633063091615827822',1,'','AAURAZO',NULL,NULL,'0001351',1),(1352,'2021-09-30 23:38:56','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001352','16330631121052901623',1,'','AAURAZO',NULL,NULL,'0001352',1),(1353,'2021-09-30 23:39:43','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001353','16330631381184363715',1,'','AAURAZO',NULL,NULL,'0001353',1),(1354,'2021-09-30 23:40:18','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001354','16330631901068565192',1,'','AAURAZO',NULL,NULL,'0001354',1),(1355,'2021-09-30 23:41:05','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001355','16330632211178683520',1,'','AAURAZO',NULL,NULL,'0001355',1),(1356,'2021-09-30 23:41:32','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001356','1633063268670564247',1,'','AAURAZO',NULL,NULL,'0001356',1),(1357,'2021-09-30 23:41:54','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001357','1633063295200097783',1,'','AAURAZO',NULL,NULL,'0001357',1),(1358,'2021-09-30 23:42:31','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001358','16330633161294826297',1,'','AAURAZO',NULL,NULL,'0001358',1),(1359,'2021-09-30 23:43:03','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001359','1633063359792946633',1,'','AAURAZO',NULL,NULL,'0001359',1),(1360,'2021-09-30 23:43:58','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001360','1633063420882323643',1,'','AAURAZO',NULL,NULL,'0001360',1),(1361,'2021-09-30 23:44:37','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001361','16330634411154929977',1,'','AAURAZO',NULL,NULL,'0001361',1),(1362,'2021-09-30 23:45:05','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001362','16330634791011289891',1,'','AAURAZO',NULL,NULL,'0001362',1),(1363,'2021-09-30 23:45:30','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001363','163306350966570166',1,'','AAURAZO',NULL,NULL,'0001363',1),(1364,'2021-09-30 23:45:52','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001364','163306353318159412',1,'','AAURAZO',NULL,NULL,'0001364',1),(1365,'2021-09-30 23:46:10','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001365','1633063554306386283',1,'','AAURAZO',NULL,NULL,'0001365',1),(1366,'2021-09-30 23:46:36','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001366','16330635811320860525',1,'','AAURAZO',NULL,NULL,'0001366',1),(1367,'2021-09-30 23:47:01','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001367','1633063599838818512',1,'','AAURAZO',NULL,NULL,'0001367',1),(1368,'2021-09-30 23:47:33','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001368','1633063623112226886',1,'','AAURAZO',NULL,NULL,'0001368',1),(1369,'2021-09-30 23:48:01','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001369','16330636621079323137',1,'','AAURAZO',NULL,NULL,'0001369',1),(1370,'2021-09-30 23:48:58','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001370','1633063685216665019',1,'','AAURAZO',NULL,NULL,'0001370',1),(1371,'2021-09-30 23:49:35','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001371','1633063740394085053',1,'','AAURAZO',NULL,NULL,'0001371',1),(1372,'2021-09-30 23:50:02','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001372','163306377848410754',1,'','AAURAZO',NULL,NULL,'0001372',1),(1373,'2021-09-30 23:50:27','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001373','1633063808611610707',1,'','AAURAZO',NULL,NULL,'0001373',1),(1374,'2021-09-30 23:51:16','2021-09-30',4,1,2,'GENERADO AUNTOMATICAMENTE','0001374','1633063830230306094',1,'','AAURAZO',NULL,NULL,'0001374',1),(1375,'2021-10-25 20:00:35','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001375','1635210009269723205',1,'','AAURAZO',NULL,NULL,'0001375',1),(1376,'2021-10-25 20:01:34','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001376','1635210077131849378',1,'','AAURAZO',NULL,NULL,'0001376',1),(1377,'2021-10-25 20:15:25','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001377','16352108921107767144',1,'','AAURAZO',NULL,NULL,'0001377',1),(1378,'2021-10-25 20:15:51','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001378','1635210927759855193',1,'','AAURAZO',NULL,NULL,'0001378',1),(1379,'2021-10-25 20:23:00','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001379','1635211309646294323',1,'','AAURAZO',NULL,NULL,'0001379',1),(1380,'2021-10-25 20:23:30','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001380','16352113831080269836',1,'','AAURAZO',NULL,NULL,'0001380',1),(1381,'2021-10-25 20:23:54','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001381','1635211412842777436',1,'','AAURAZO',NULL,NULL,'0001381',1),(1382,'2021-10-25 20:24:22','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001382','16352114371355845363',1,'','AAURAZO',NULL,NULL,'0001382',1),(1383,'2021-10-25 20:42:01','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001383','1635211465674006790',1,'','AAURAZO',NULL,NULL,'0001383',1),(1384,'2021-10-25 20:42:29','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001384','16352125231024629743',1,'','AAURAZO',NULL,NULL,'0001384',1),(1385,'2021-10-25 20:42:53','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001385','1635212552341414153',1,'','AAURAZO',NULL,NULL,'0001385',1),(1386,'2021-10-25 20:43:53','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001386','1635212606775217539',1,'','AAURAZO',NULL,NULL,'0001386',1),(1387,'2021-10-25 20:44:45','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001387','1635212635496156438',1,'','AAURAZO',NULL,NULL,'0001387',1),(1388,'2021-10-25 20:45:48','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001388','16352126881092318735',1,'','AAURAZO',NULL,NULL,'0001388',1),(1389,'2021-10-25 20:46:19','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001389','1635212751968774491',1,'','AAURAZO',NULL,NULL,'0001389',1),(1390,'2021-10-25 20:47:00','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001390','1635212781267184330',1,'','AAURAZO',NULL,NULL,'0001390',1),(1391,'2021-10-25 20:47:26','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001391','1635212822918556402',1,'','AAURAZO',NULL,NULL,'0001391',1),(1392,'2021-10-25 20:47:58','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001392','1635212849222087023',1,'','AAURAZO',NULL,NULL,'0001392',1),(1393,'2021-10-25 20:49:01','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001393','1635212881745568642',1,'','AAURAZO',NULL,NULL,'0001393',1),(1394,'2021-10-25 20:49:35','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001394','1635212944814032206',1,'','AAURAZO',NULL,NULL,'0001394',1),(1395,'2021-10-25 20:50:53','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001395','1635212978423518791',1,'','AAURAZO',NULL,NULL,'0001395',1),(1396,'2021-10-25 20:51:33','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001396','1635213056206896805',1,'','AAURAZO',NULL,NULL,'0001396',1),(1397,'2021-10-25 20:52:23','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001397','1635213101873330000',1,'','AAURAZO',NULL,NULL,'0001397',1),(1398,'2021-10-25 20:53:31','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001398','1635213147981210676',1,'','AAURAZO',NULL,NULL,'0001398',1),(1399,'2021-10-25 20:54:24','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001399','1635213215159432750',1,'','AAURAZO',NULL,NULL,'0001399',1),(1400,'2021-10-25 20:55:12','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001400','1635213267987019966',1,'','AAURAZO',NULL,NULL,'0001400',1),(1401,'2021-10-25 20:55:53','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001401','16352133151025017029',1,'','AAURAZO',NULL,NULL,'0001401',1),(1402,'2021-10-25 20:56:31','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001402','1635213356698664000',1,'','AAURAZO',NULL,NULL,'0001402',1),(1403,'2021-10-25 20:57:48','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001403','1635213394872813619',1,'','AAURAZO',NULL,NULL,'0001403',1),(1404,'2021-10-25 20:58:54','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001404','1635213471760457638',1,'','AAURAZO',NULL,NULL,'0001404',1),(1405,'2021-10-25 20:59:50','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001405','1635213537383542267',1,'','AAURAZO',NULL,NULL,'0001405',1),(1406,'2021-10-25 21:00:56','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001406','163521359350992661',1,'','AAURAZO',NULL,NULL,'0001406',1),(1407,'2021-10-25 21:01:45','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001407','1635213659459407297',1,'','AAURAZO',NULL,NULL,'0001407',1),(1408,'2021-10-25 21:02:55','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001408','1635213714471025878',1,'','AAURAZO',NULL,NULL,'0001408',1),(1409,'2021-10-25 21:03:54','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001409','1635213778926861536',1,'','AAURAZO',NULL,NULL,'0001409',1),(1410,'2021-10-25 21:05:30','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001410','16352138371002855662',1,'','AAURAZO',NULL,NULL,'0001410',1),(1411,'2021-10-25 21:06:14','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001411','16352139341127432668',1,'','AAURAZO',NULL,NULL,'0001411',1),(1412,'2021-10-25 21:07:04','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001412','1635213985540393109',1,'','AAURAZO',NULL,NULL,'0001412',1),(1413,'2021-10-25 21:08:25','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001413','1635214028638118284',1,'','AAURAZO',NULL,NULL,'0001413',1),(1414,'2021-10-25 21:09:11','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001414','1635214115338961341',1,'','AAURAZO',NULL,NULL,'0001414',1),(1415,'2021-10-25 21:09:42','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001415','1635214154445465000',1,'','AAURAZO',NULL,NULL,'0001415',1),(1416,'2021-10-25 21:11:03','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001416','1635214185233060128',1,'','AAURAZO',NULL,NULL,'0001416',1),(1417,'2021-10-25 21:12:22','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001417','16352142691399694748',1,'','AAURAZO',NULL,NULL,'0001417',1),(1418,'2021-10-25 21:13:19','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001418','163521434616266014',1,'','AAURAZO',NULL,NULL,'0001418',1),(1419,'2021-10-25 21:14:35','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001419','1635214402827630249',1,'','AAURAZO',NULL,NULL,'0001419',1),(1420,'2021-10-25 21:15:44','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001420','16352144791082378394',1,'','AAURAZO',NULL,NULL,'0001420',1),(1421,'2021-10-25 21:16:48','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001421','16352145471011591113',1,'','AAURAZO',NULL,NULL,'0001421',1),(1422,'2021-10-25 21:17:40','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001422','16352146251073944164',1,'','AAURAZO',NULL,NULL,'0001422',1),(1423,'2021-10-25 21:18:16','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001423','1635214663976218989',1,'','AAURAZO',NULL,NULL,'0001423',1),(1424,'2021-10-25 21:19:12','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001424','1635214699964815567',1,'','AAURAZO',NULL,NULL,'0001424',1),(1425,'2021-10-25 21:20:04','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001425','16352147551071319226',1,'','AAURAZO',NULL,NULL,'0001425',1),(1426,'2021-10-25 21:20:54','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001426','16352148081169044401',1,'','AAURAZO',NULL,NULL,'0001426',1),(1427,'2021-10-25 21:21:45','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001427','16352148572409780',1,'','AAURAZO',NULL,NULL,'0001427',1),(1428,'2021-10-25 21:24:15','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001428','1635215016150094853',1,'','AAURAZO',NULL,NULL,'0001428',1),(1429,'2021-10-25 21:25:17','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001429','1635215058815151032',1,'','AAURAZO',NULL,NULL,'0001429',1),(1430,'2021-10-25 21:26:12','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001430','1635215126268174061',1,'','AAURAZO',NULL,NULL,'0001430',1),(1431,'2021-10-25 21:26:48','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001431','1635215176673791631',1,'','AAURAZO',NULL,NULL,'0001431',1),(1432,'2021-10-25 21:27:32','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001432','16352152111389022866',1,'','AAURAZO',NULL,NULL,'0001432',1),(1433,'2021-10-25 21:28:17','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001433','1635215254652749090',1,'','AAURAZO',NULL,NULL,'0001433',1),(1434,'2021-10-25 21:29:17','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001434','1635215311552269881',1,'','AAURAZO',NULL,NULL,'0001434',1),(1435,'2021-10-25 21:30:03','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001435','1635215367197300717',1,'','AAURAZO',NULL,NULL,'0001435',1),(1436,'2021-10-25 21:30:50','2021-10-25',4,1,2,'GENERADO AUNTOMATICAMENTE','0001436','1635215407689240040',1,'','AAURAZO',NULL,NULL,'0001436',1),(1437,'2021-10-25 22:05:24','2021-10-25',4,1534,1,'GENERADO AUNTOMATICAMENTE','0001437','16352173301095847341',1,'','AAURAZO',NULL,NULL,'0001437',1),(1438,'2021-10-29 21:39:58','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001438','16355615671197746599',1,'','AAURAZO',NULL,NULL,'0001438',1),(1439,'2021-10-29 21:40:20','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001439','1635561601345674299',1,'','AAURAZO',NULL,NULL,'0001439',1),(1440,'2021-10-29 21:40:36','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001440','163556162218933984',1,'','AAURAZO',NULL,NULL,'0001440',1),(1441,'2021-10-29 21:40:56','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001441','16355616391012021431',1,'','AAURAZO',NULL,NULL,'0001441',1),(1442,'2021-10-29 21:42:14','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001442','1635561702394730530',1,'','AAURAZO',NULL,NULL,'0001442',1),(1443,'2021-10-29 21:42:55','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001443','16355617461000661041',1,'','AAURAZO',NULL,NULL,'0001443',1),(1444,'2021-10-29 21:43:44','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001444','1635561781873330000',1,'','AAURAZO',NULL,NULL,'0001444',1),(1445,'2021-10-29 21:44:12','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001445','163556182715319315',1,'','AAURAZO',NULL,NULL,'0001445',1),(1446,'2021-10-29 21:44:36','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001446','1635561855981210676',1,'','AAURAZO',NULL,NULL,'0001446',1),(1447,'2021-10-29 21:45:07','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001447','1635561878274155479',1,'','AAURAZO',NULL,NULL,'0001447',1),(1448,'2021-10-29 21:45:25','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001448','16355619091281916763',1,'','AAURAZO',NULL,NULL,'0001448',1),(1449,'2021-10-29 21:45:51','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001449','1635561927129826884',1,'','AAURAZO',NULL,NULL,'0001449',1),(1450,'2021-10-29 21:46:14','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001450','16355619531264704051',1,'','AAURAZO',NULL,NULL,'0001450',1),(1451,'2021-10-29 21:46:36','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001451','1635561976719964732',1,'','AAURAZO',NULL,NULL,'0001451',1),(1452,'2021-10-29 21:46:59','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001452','1635561998303158899',1,'','AAURAZO',NULL,NULL,'0001452',1),(1453,'2021-10-29 21:47:27','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001453','1635562022542114380',1,'','AAURAZO',NULL,NULL,'0001453',1),(1454,'2021-10-29 21:48:00','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001454','1635562050803145165',1,'','AAURAZO',NULL,NULL,'0001454',1),(1455,'2021-10-29 21:48:21','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001455','1635562083297995085',1,'','AAURAZO',NULL,NULL,'0001455',1),(1456,'2021-10-29 21:48:41','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001456','1635562103926043932',1,'','AAURAZO',NULL,NULL,'0001456',1),(1457,'2021-10-29 21:49:00','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001457','16355621231002855662',1,'','AAURAZO',NULL,NULL,'0001457',1),(1458,'2021-10-29 21:49:28','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001458','1635562143219246926',1,'','AAURAZO',NULL,NULL,'0001458',1),(1459,'2021-10-29 21:49:51','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001459','16355621711037668373',1,'','AAURAZO',NULL,NULL,'0001459',1),(1460,'2021-10-29 21:50:14','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001460','1635562193366114395',1,'','AAURAZO',NULL,NULL,'0001460',1),(1461,'2021-10-29 21:51:22','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001461','1635562218223248881',1,'','AAURAZO',NULL,NULL,'0001461',1),(1462,'2021-10-29 21:51:50','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001462','1635562285273983352',1,'','AAURAZO',NULL,NULL,'0001462',1),(1463,'2021-10-29 21:52:24','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001463','1635562313882495770',1,'','AAURAZO',NULL,NULL,'0001463',1),(1464,'2021-10-29 21:52:46','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001464','16355623461189183275',1,'','AAURAZO',NULL,NULL,'0001464',1),(1465,'2021-10-29 21:53:08','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001465','16355623691009826810',1,'','AAURAZO',NULL,NULL,'0001465',1),(1466,'2021-10-29 21:53:40','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001466','1635562390129697789',1,'','AAURAZO',NULL,NULL,'0001466',1),(1467,'2021-10-29 21:54:15','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001467','16355624241089091351',1,'','AAURAZO',NULL,NULL,'0001467',1),(1468,'2021-10-29 21:54:43','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001468','1635562459629813150',1,'','AAURAZO',NULL,NULL,'0001468',1),(1469,'2021-10-29 21:55:11','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001469','16355624931219262490',1,'','AAURAZO',NULL,NULL,'0001469',1),(1470,'2021-10-29 21:55:56','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001470','1635562513538628806',1,'','AAURAZO',NULL,NULL,'0001470',1),(1471,'2021-10-29 21:56:22','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001471','1635562559247217584',1,'','AAURAZO',NULL,NULL,'0001471',1),(1472,'2021-10-29 21:56:47','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001472','16355625841121236092',1,'','AAURAZO',NULL,NULL,'0001472',1),(1473,'2021-10-29 21:57:25','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001473','1635562609609114864',1,'','AAURAZO',NULL,NULL,'0001473',1),(1474,'2021-10-29 21:57:52','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001474','1635562648992829257',1,'','AAURAZO',NULL,NULL,'0001474',1),(1475,'2021-10-29 21:58:28','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001475','1635562675924236598',1,'','AAURAZO',NULL,NULL,'0001475',1),(1476,'2021-10-29 21:59:33','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001476','16355627151063014092',1,'','AAURAZO',NULL,NULL,'0001476',1),(1477,'2021-10-29 22:00:03','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001477','16355627771325206735',1,'','AAURAZO',NULL,NULL,'0001477',1),(1478,'2021-10-29 22:00:43','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001478','1635562819182669912',1,'','AAURAZO',NULL,NULL,'0001478',1),(1479,'2021-10-29 22:01:09','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001479','16355628461071319226',1,'','AAURAZO',NULL,NULL,'0001479',1),(1480,'2021-10-29 22:01:28','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001480','1635562872364264029',1,'','AAURAZO',NULL,NULL,'0001480',1),(1481,'2021-10-29 22:01:50','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001481','16355628901169044401',1,'','AAURAZO',NULL,NULL,'0001481',1),(1482,'2021-10-29 22:02:13','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001482','1635562913896954448',1,'','AAURAZO',NULL,NULL,'0001482',1),(1483,'2021-10-29 22:02:43','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001483','1635562935675297743',1,'','AAURAZO',NULL,NULL,'0001483',1),(1484,'2021-10-29 22:03:10','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001484','16355629651304078130',1,'','AAURAZO',NULL,NULL,'0001484',1),(1485,'2021-10-29 22:03:47','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001485','1635562992247346679',1,'','AAURAZO',NULL,NULL,'0001485',1),(1486,'2021-10-29 22:04:20','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001486','16355630301275548059',1,'','AAURAZO',NULL,NULL,'0001486',1),(1487,'2021-10-29 22:04:52','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001487','1635563063615655694',1,'','AAURAZO',NULL,NULL,'0001487',1),(1488,'2021-10-29 22:05:13','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001488','1635563094417236151',1,'','AAURAZO',NULL,NULL,'0001488',1),(1489,'2021-10-29 22:05:42','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001489','16355631161032117273',1,'','AAURAZO',NULL,NULL,'0001489',1),(1490,'2021-10-29 22:06:04','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001490','163556314528487040',1,'','AAURAZO',NULL,NULL,'0001490',1),(1491,'2021-10-29 22:06:23','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001491','16355631661225502098',1,'','AAURAZO',NULL,NULL,'0001491',1),(1492,'2021-10-29 22:06:46','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001492','1635563185764072308',1,'','AAURAZO',NULL,NULL,'0001492',1),(1493,'2021-10-29 22:07:08','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001493','1635563208726161309',1,'','AAURAZO',NULL,NULL,'0001493',1),(1494,'2021-10-29 22:07:33','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001494','16355632301005566664',1,'','AAURAZO',NULL,NULL,'0001494',1),(1495,'2021-10-29 22:07:55','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001495','1635563256195837637',1,'','AAURAZO',NULL,NULL,'0001495',1),(1496,'2021-10-29 22:08:22','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001496','16355632771101097218',1,'','AAURAZO',NULL,NULL,'0001496',1),(1497,'2021-10-29 22:08:44','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001497','1635563305254619050',1,'','AAURAZO',NULL,NULL,'0001497',1),(1498,'2021-10-29 22:09:08','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001498','16355633261030783288',1,'','AAURAZO',NULL,NULL,'0001498',1),(1499,'2021-10-29 22:09:30','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001499','163556335089204883',1,'','AAURAZO',NULL,NULL,'0001499',1),(1500,'2021-10-29 22:10:02','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001500','1635563372415945198',1,'','AAURAZO',NULL,NULL,'0001500',1),(1501,'2021-10-29 22:10:25','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001501','16355634051389022866',1,'','AAURAZO',NULL,NULL,'0001501',1),(1502,'2021-10-29 22:10:55','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001502','1635563434678008745',1,'','AAURAZO',NULL,NULL,'0001502',1),(1503,'2021-10-29 22:11:17','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001503','16355634571364408688',1,'','AAURAZO',NULL,NULL,'0001503',1),(1504,'2021-10-29 22:11:55','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001504','1635563496291239096',1,'','AAURAZO',NULL,NULL,'0001504',1),(1505,'2021-10-29 22:12:19','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001505','1635563517197300717',1,'','AAURAZO',NULL,NULL,'0001505',1),(1506,'2021-10-29 22:12:51','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001506','1635563541863992104',1,'','AAURAZO',NULL,NULL,'0001506',1),(1507,'2021-10-29 22:13:10','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001507','16355635741097697708',1,'','AAURAZO',NULL,NULL,'0001507',1),(1508,'2021-10-29 22:13:33','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001508','1635563592787997978',1,'','AAURAZO',NULL,NULL,'0001508',1),(1509,'2021-10-29 22:13:59','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001509','1635563615232758905',1,'','AAURAZO',NULL,NULL,'0001509',1),(1510,'2021-10-29 22:14:24','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001510','1635563642674996521',1,'','AAURAZO',NULL,NULL,'0001510',1),(1511,'2021-10-29 22:14:57','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001511','16355636661083583283',1,'','AAURAZO',NULL,NULL,'0001511',1),(1512,'2021-10-29 22:15:43','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001512','1635563708843422912',1,'','AAURAZO',NULL,NULL,'0001512',1),(1513,'2021-10-29 22:16:14','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001513','1635563746474812674',1,'','AAURAZO',NULL,NULL,'0001513',1),(1514,'2021-10-29 22:16:38','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001514','1635563777106675786',1,'','AAURAZO',NULL,NULL,'0001514',1),(1515,'2021-10-29 22:17:17','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001515','16355638001143698682',1,'','AAURAZO',NULL,NULL,'0001515',1),(1516,'2021-10-29 22:17:58','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001516','1635563840785975484',1,'','AAURAZO',NULL,NULL,'0001516',1),(1517,'2021-10-29 22:18:23','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001517','16355638801303131431',1,'','AAURAZO',NULL,NULL,'0001517',1),(1518,'2021-10-29 22:18:48','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001518','1635563905343307551',1,'','AAURAZO',NULL,NULL,'0001518',1),(1519,'2021-10-29 22:19:19','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001519','163556393150691439',1,'','AAURAZO',NULL,NULL,'0001519',1),(1520,'2021-10-29 22:19:49','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001520','1635563961717210698',1,'','AAURAZO',NULL,NULL,'0001520',1),(1521,'2021-10-29 22:20:29','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001521','16355639971044639521',1,'','AAURAZO',NULL,NULL,'0001521',1),(1522,'2021-10-29 22:20:54','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001522','163556403143634227',1,'','AAURAZO',NULL,NULL,'0001522',1),(1523,'2021-10-29 22:25:30','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001523','16355643071098988661',1,'','AAURAZO',NULL,NULL,'0001523',1),(1524,'2021-10-29 22:25:52','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001524','16355643338305134',1,'','AAURAZO',NULL,NULL,'0001524',1),(1525,'2021-10-29 22:26:40','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001525','1635564364317273323',1,'','AAURAZO',NULL,NULL,'0001525',1),(1526,'2021-10-29 22:27:12','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001526','1635564403223076754',1,'','AAURAZO',NULL,NULL,'0001526',1),(1527,'2021-10-29 22:27:43','2021-10-29',4,1,2,'GENERADO AUNTOMATICAMENTE','0001527','16355644351334286441',1,'','AAURAZO',NULL,NULL,'0001527',1),(1528,'2021-10-31 19:22:31','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001528','1635726131219720275',1,'','AAURAZO',NULL,NULL,'0001528',1),(1529,'2021-10-31 19:23:05','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001529','1635726154264903646',1,'','AAURAZO',NULL,NULL,'0001529',1),(1530,'2021-10-31 19:23:26','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001530','16357261871343667369',1,'','AAURAZO',NULL,NULL,'0001530',1),(1531,'2021-10-31 19:23:53','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001531','16357262091325852212',1,'','AAURAZO',NULL,NULL,'0001531',1),(1532,'2021-10-31 19:24:20','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001532','1635726235617549093',1,'','AAURAZO',NULL,NULL,'0001532',1),(1533,'2021-10-31 19:24:44','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001533','16357262631379684970',1,'','AAURAZO',NULL,NULL,'0001533',1),(1534,'2021-10-31 19:25:13','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001534','1635726287864508485',1,'','AAURAZO',NULL,NULL,'0001534',1),(1535,'2021-10-31 19:25:47','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001535','1635726315668756912',1,'','AAURAZO',NULL,NULL,'0001535',1),(1536,'2021-10-31 19:26:27','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001536','1635726349286720759',1,'','AAURAZO',NULL,NULL,'0001536',1),(1537,'2021-10-31 19:26:54','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001537','16357263901408344136',1,'','AAURAZO',NULL,NULL,'0001537',1),(1538,'2021-10-31 19:27:40','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001538','1635726416559843474',1,'','AAURAZO',NULL,NULL,'0001538',1),(1539,'2021-10-31 19:28:11','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001539','1635726463480191647',1,'','AAURAZO',NULL,NULL,'0001539',1),(1540,'2021-10-31 19:28:52','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001540','1635726494863088436',1,'','AAURAZO',NULL,NULL,'0001540',1),(1541,'2021-10-31 19:29:40','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001541','1635726535463968666',1,'','AAURAZO',NULL,NULL,'0001541',1),(1542,'2021-10-31 19:30:31','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001542','1635726604222646437',1,'','AAURAZO',NULL,NULL,'0001542',1),(1543,'2021-10-31 19:31:04','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001543','1635726633286978949',1,'','AAURAZO',NULL,NULL,'0001543',1),(1544,'2021-10-31 19:32:09','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001544','1635726667680332462',1,'','AAURAZO',NULL,NULL,'0001544',1),(1545,'2021-10-31 19:32:44','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001545','16357267321229030704',1,'','AAURAZO',NULL,NULL,'0001545',1),(1546,'2021-10-31 19:33:15','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001546','1635726768815581350',1,'','AAURAZO',NULL,NULL,'0001546',1),(1547,'2021-10-31 19:35:06','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001547','1635726832311033715',1,'','AAURAZO',NULL,NULL,'0001547',1),(1548,'2021-10-31 19:36:34','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001548','16357269541046102602',1,'','AAURAZO',NULL,NULL,'0001548',1),(1549,'2021-10-31 19:38:28','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001549','16357269981275677155',1,'','AAURAZO',NULL,NULL,'0001549',1),(1550,'2021-10-31 19:45:50','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001550','16357275241283465907',1,'','AAURAZO',NULL,NULL,'0001550',1),(1551,'2021-10-31 19:46:28','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001551','16357275531103291839',1,'','AAURAZO',NULL,NULL,'0001551',1),(1552,'2021-10-31 19:47:20','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001552','16357275911407698660',1,'','AAURAZO',NULL,NULL,'0001552',1),(1553,'2021-10-31 19:47:50','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001553','16357276441031471796',1,'','AAURAZO',NULL,NULL,'0001553',1),(1554,'2021-10-31 19:48:20','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001554','1635727672918857625',1,'','AAURAZO',NULL,NULL,'0001554',1),(1555,'2021-10-31 19:49:22','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001555','1635727702319295817',1,'','AAURAZO',NULL,NULL,'0001555',1),(1556,'2021-10-31 19:49:45','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001556','1635727764673189186',1,'','AAURAZO',NULL,NULL,'0001556',1),(1557,'2021-10-31 19:50:13','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001557','16357277871197101122',1,'','AAURAZO',NULL,NULL,'0001557',1),(1558,'2021-10-31 19:50:40','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001558','1635727815595344694',1,'','AAURAZO',NULL,NULL,'0001558',1),(1559,'2021-10-31 19:51:13','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001559','16357278421251966643',1,'','AAURAZO',NULL,NULL,'0001559',1),(1560,'2021-10-31 19:51:39','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001560','1635727876184778469',1,'','AAURAZO',NULL,NULL,'0001560',1),(1561,'2021-10-31 19:52:46','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001561','16357279451170335354',1,'','AAURAZO',NULL,NULL,'0001561',1),(1562,'2021-10-31 19:53:26','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001562','1635727969187274312',1,'','AAURAZO',NULL,NULL,'0001562',1),(1563,'2021-10-31 19:53:59','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001563','1635728009446454731',1,'','AAURAZO',NULL,NULL,'0001563',1),(1564,'2021-10-31 19:54:52','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001564','16357280411270384246',1,'','AAURAZO',NULL,NULL,'0001564',1),(1565,'2021-10-31 19:55:15','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001565','1635728094396107547',1,'','AAURAZO',NULL,NULL,'0001565',1),(1566,'2021-10-31 19:56:03','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001566','16357281221032763',1,'','AAURAZO',NULL,NULL,'0001566',1),(1567,'2021-10-31 19:56:36','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001567','16357281651155016040',1,'','AAURAZO',NULL,NULL,'0001567',1),(1568,'2021-10-31 19:57:03','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001568','1635728199978671801',1,'','AAURAZO',NULL,NULL,'0001568',1),(1569,'2021-10-31 19:57:35','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001569','16357282251262638525',1,'','AAURAZO',NULL,NULL,'0001569',1),(1570,'2021-10-31 19:58:07','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001570','1635728257634331487',1,'','AAURAZO',NULL,NULL,'0001570',1),(1571,'2021-10-31 19:58:41','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001571','1635728290302341295',1,'','AAURAZO',NULL,NULL,'0001571',1),(1572,'2021-10-31 19:59:09','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001572','16357283231012193558',1,'','AAURAZO',NULL,NULL,'0001572',1),(1573,'2021-10-31 19:59:44','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001573','1635728351787352501',1,'','AAURAZO',NULL,NULL,'0001573',1),(1574,'2021-10-31 20:00:33','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001574','1635728386136841065',1,'','AAURAZO',NULL,NULL,'0001574',1),(1575,'2021-10-31 20:01:11','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001575','1635728437829351520',1,'','AAURAZO',NULL,NULL,'0001575',1),(1576,'2021-10-31 20:03:52','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001576','1635728610130085075',1,'','AAURAZO',NULL,NULL,'0001576',1),(1577,'2021-10-31 20:04:33','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001577','163572863457576524',1,'','AAURAZO',NULL,NULL,'0001577',1),(1578,'2021-10-31 20:05:10','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001578','16357286761254505518',1,'','AAURAZO',NULL,NULL,'0001578',1),(1579,'2021-10-31 20:05:43','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001579','16357287131145161762',1,'','AAURAZO',NULL,NULL,'0001579',1),(1580,'2021-10-31 20:06:09','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001580','1635728747610965230',1,'','AAURAZO',NULL,NULL,'0001580',1),(1581,'2021-10-31 20:06:39','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001581','16357287711393369076',1,'','AAURAZO',NULL,NULL,'0001581',1),(1582,'2021-10-31 20:07:18','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001582','1635728802413578450',1,'','AAURAZO',NULL,NULL,'0001582',1),(1583,'2021-10-31 20:07:50','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001583','1635728840783780864',1,'','AAURAZO',NULL,NULL,'0001583',1),(1584,'2021-10-31 20:08:35','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001584','1635728873962663978',1,'','AAURAZO',NULL,NULL,'0001584',1),(1585,'2021-10-31 20:09:37','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001585','16357289191032633654',1,'','AAURAZO',NULL,NULL,'0001585',1),(1586,'2021-10-31 20:10:16','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001586','1635728979406133952',1,'','AAURAZO',NULL,NULL,'0001586',1),(1587,'2021-10-31 20:10:41','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001587','1635729018644443956',1,'','AAURAZO',NULL,NULL,'0001587',1),(1588,'2021-10-31 20:11:05','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001588','1635729044714198473',1,'','AAURAZO',NULL,NULL,'0001588',1),(1589,'2021-10-31 20:12:56','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001589','16357290681172874229',1,'','AAURAZO',NULL,NULL,'0001589',1),(1590,'2021-10-31 20:13:21','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001590','1635729180162100720',1,'','AAURAZO',NULL,NULL,'0001590',1),(1591,'2021-10-31 20:13:47','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001591','163572920348152564',1,'','AAURAZO',NULL,NULL,'0001591',1),(1592,'2021-10-31 20:14:26','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001592','163572922933478726',1,'','AAURAZO',NULL,NULL,'0001592',1),(1593,'2021-10-31 20:15:12','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001593','163572929582405862',1,'','AAURAZO',NULL,NULL,'0001593',1),(1594,'2021-10-31 20:15:39','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001594','16357293141269695737',1,'','AAURAZO',NULL,NULL,'0001594',1),(1595,'2021-10-31 20:16:51','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001595','163572934169410264',1,'','AAURAZO',NULL,NULL,'0001595',1),(1596,'2021-10-31 20:17:38','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001596','1635729419936457623',1,'','AAURAZO',NULL,NULL,'0001596',1),(1597,'2021-10-31 20:18:49','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001597','1635729461745654705',1,'','AAURAZO',NULL,NULL,'0001597',1),(1598,'2021-10-31 20:19:18','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001598','1635729532642077208',1,'','AAURAZO',NULL,NULL,'0001598',1),(1599,'2021-10-31 20:19:42','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001599','1635729561741480623',1,'','AAURAZO',NULL,NULL,'0001599',1),(1600,'2021-10-31 20:20:06','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001600','16357295851338288396',1,'','AAURAZO',NULL,NULL,'0001600',1),(1601,'2021-10-31 20:20:30','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001601','1635729609735068887',1,'','AAURAZO',NULL,NULL,'0001601',1),(1602,'2021-10-31 20:21:04','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001602','1635729633551021959',1,'','AAURAZO',NULL,NULL,'0001602',1),(1603,'2021-10-31 20:21:25','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001603','16357296681204932906',1,'','AAURAZO',NULL,NULL,'0001603',1),(1604,'2021-10-31 20:21:54','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001604','1635729687325363298',1,'','AAURAZO',NULL,NULL,'0001604',1),(1605,'2021-10-31 20:22:22','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001605','1635729716887057139',1,'','AAURAZO',NULL,NULL,'0001605',1),(1606,'2021-10-31 20:23:09','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001606','16357297451394789125',1,'','AAURAZO',NULL,NULL,'0001606',1),(1607,'2021-10-31 20:23:37','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001607','1635729791447272334',1,'','AAURAZO',NULL,NULL,'0001607',1),(1608,'2021-10-31 20:24:02','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001608','16357298211331575439',1,'','AAURAZO',NULL,NULL,'0001608',1),(1609,'2021-10-31 20:24:26','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001609','16357298451121365187',1,'','AAURAZO',NULL,NULL,'0001609',1),(1610,'2021-10-31 20:24:54','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001610','16357298691105271301',1,'','AAURAZO',NULL,NULL,'0001610',1),(1611,'2021-10-31 20:25:22','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001611','16357298961075794531',1,'','AAURAZO',NULL,NULL,'0001611',1),(1612,'2021-10-31 20:25:48','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001612','16357299251286176909',1,'','AAURAZO',NULL,NULL,'0001612',1),(1613,'2021-10-31 20:26:13','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001613','16357299511141719220',1,'','AAURAZO',NULL,NULL,'0001613',1),(1614,'2021-10-31 20:26:37','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001614','16357299751237421901',1,'','AAURAZO',NULL,NULL,'0001614',1),(1615,'2021-10-31 20:27:06','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001615','16357300001044596490',1,'','AAURAZO',NULL,NULL,'0001615',1),(1616,'2021-10-31 20:27:34','2021-10-31',4,1,2,'GENERADO AUNTOMATICAMENTE','0001616','1635730029740964241',1,'','AAURAZO',NULL,NULL,'0001616',1);
/*!40000 ALTER TABLE `operacion_almacen` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `operacion_almacen_detalle`
--

DROP TABLE IF EXISTS `operacion_almacen_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operacion_almacen_detalle` (
  `opealmdet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `opealmdet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `opealmdet_cantidad` float DEFAULT NULL,
  `opealm_codi_fk` int(11) DEFAULT NULL,
  `idtrans` varchar(45) DEFAULT NULL,
  `opealmdet_cantidad_disponible` float NOT NULL DEFAULT '0',
  PRIMARY KEY (`opealmdet_codi`),
  KEY `fk_operacion_almacen_detalle_operacion_almacen1_idx` (`opealm_codi_fk`),
  KEY `fk_operacion_almacen_detalle_productos1_idx` (`prd_codi_fk`),
  CONSTRAINT `fk_operacion_almacen_detalle_operacion_almacen1` FOREIGN KEY (`opealm_codi_fk`) REFERENCES `operacion_almacen` (`opealm_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_operacion_almacen_detalle_productos1` FOREIGN KEY (`prd_codi_fk`) REFERENCES `productos` (`prd_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=1972 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `operacion_almacen_detalle`
--

LOCK TABLES `operacion_almacen_detalle` WRITE;
/*!40000 ALTER TABLE `operacion_almacen_detalle` DISABLE KEYS */;
INSERT INTO `operacion_almacen_detalle` VALUES (1,'2021-01-12 19:07:12',361,28,2,1,'1610496315656234664',0),(2,'2021-01-12 19:07:12',3,28,1,1,'1610496315656234664',0),(3,'2021-01-12 19:25:10',2,28,1,2,'1610496691313357431',0),(4,'2021-01-12 19:25:10',69,28,1,2,'1610496691313357431',0),(5,'2021-01-12 19:25:10',32,28,1,2,'1610496691313357431',0),(6,'2021-01-12 19:25:10',17,28,2,2,'1610496691313357431',0),(7,'2021-01-12 19:25:10',11,28,1,2,'1610496691313357431',0),(8,'2021-01-12 19:25:10',352,28,1,2,'1610496691313357431',0),(9,'2021-01-12 19:25:10',8,28,1,2,'1610496691313357431',0),(10,'2021-01-12 19:46:51',25,28,5,3,'16104980541397586191',0),(11,'2021-01-12 19:46:51',3,28,3,3,'16104980541397586191',0),(12,'2021-01-12 19:46:51',75,28,2,3,'16104980541397586191',0),(13,'2021-01-12 19:46:51',353,28,1,3,'16104980541397586191',0),(14,'2021-01-12 19:46:51',64,28,1,3,'16104980541397586191',0),(15,'2021-01-15 17:04:25',242,29,15,4,'1610747944537251789',0),(16,'2021-01-15 17:49:47',242,29,15,5,'16107508481132037069',0),(17,'2021-01-15 18:01:17',116,3,50,6,'1610751637729216565',0),(18,'2021-01-15 18:01:53',129,7,50,7,'1610751682989731',0),(19,'2021-01-15 18:02:39',69,28,1,8,'1610751719875696748',0),(20,'2021-01-15 18:02:39',74,28,1,8,'1610751719875696748',0),(21,'2021-01-15 18:03:23',148,2,10,9,'16107517621299086444',0),(22,'2021-01-15 18:05:00',10,28,2,10,'16107518121101140250',0),(23,'2021-01-15 18:05:00',19,28,2,10,'16107518121101140250',0),(24,'2021-01-15 18:05:38',87,28,2,11,'16107519031118568122',0),(25,'2021-01-15 18:05:38',88,28,2,11,'16107519031118568122',0),(26,'2021-01-15 18:05:38',86,14,1,11,'16107519031118568122',0),(27,'2021-01-15 18:06:18',32,28,1,12,'161075194283825910',0),(28,'2021-01-15 18:06:54',302,28,3,13,'1610751982820056655',0),(29,'2021-01-15 18:07:45',25,28,5,14,'1610752017768547613',0),(30,'2021-01-21 17:18:33',239,14,5,15,'1611267024616688457',0),(31,'2021-01-21 17:33:45',85,2,1,16,'16112678641082464457',0),(32,'2021-01-21 17:33:45',69,11,3,16,'16112678641082464457',0),(33,'2021-01-21 17:33:45',17,1,5,16,'16112678641082464457',0),(34,'2021-01-21 17:33:45',45,1,5,16,'16112678641082464457',0),(35,'2021-01-21 17:33:45',144,1,5,16,'16112678641082464457',0),(36,'2021-01-21 17:33:45',88,1,5,16,'16112678641082464457',0),(37,'2021-01-21 18:11:22',145,14,3,17,'16112689201145161762',0),(38,'2021-01-21 18:11:22',295,2,1,17,'16112689201145161762',0),(39,'2021-01-21 18:11:22',132,2,3,17,'16112689201145161762',0),(40,'2021-01-21 18:11:22',337,7,50,17,'16112689201145161762',0),(41,'2021-01-21 18:11:22',336,7,50,17,'16112689201145161762',0),(42,'2021-01-21 18:22:39',129,7,50,18,'1611271338207198027',0),(43,'2021-01-21 18:23:23',148,2,10,19,'1611271362234824431',0),(44,'2021-01-21 18:24:15',114,2,5,20,'16112714051324432163',0),(45,'2021-01-21 18:24:49',5,28,5,21,'1611271458142306101',0),(46,'2021-01-21 18:26:23',74,28,1,22,'1611271512931638064',0),(47,'2021-01-21 18:26:23',3,28,1,22,'1611271512931638064',0),(48,'2021-01-21 18:26:23',9,28,1,22,'1611271512931638064',0),(49,'2021-01-21 18:27:20',74,28,1,23,'1611271585474769643',0),(50,'2021-01-21 18:27:20',2,28,1,23,'1611271585474769643',0),(51,'2021-01-21 18:29:46',78,14,1,24,'1611271751591730024',0),(52,'2021-01-21 18:29:46',79,14,1,24,'1611271751591730024',0),(53,'2021-01-21 18:29:46',80,14,1,24,'1611271751591730024',0),(54,'2021-01-22 18:02:09',239,14,5,25,'1611356423477910963',0),(55,'2021-01-22 18:18:01',2,28,1,26,'16113574321397758318',0),(56,'2021-01-22 18:18:01',74,28,1,26,'16113574321397758318',0),(57,'2021-01-22 18:18:21',129,7,50,27,'161135748420870414',0),(58,'2021-01-22 18:18:56',116,3,50,28,'1611357504471284068',0),(59,'2021-01-22 18:28:58',17,28,1,29,'1611357539998380357',0),(60,'2021-01-22 18:28:58',118,3,50,29,'1611357539998380357',0),(61,'2021-01-22 18:28:58',119,3,30,29,'1611357539998380357',0),(62,'2021-01-22 18:28:58',246,29,10,29,'1611357539998380357',0),(63,'2021-01-22 18:28:58',297,2,1,29,'1611357539998380357',0),(64,'2021-01-22 18:28:58',50,2,1,29,'1611357539998380357',0),(65,'2021-01-25 18:03:23',130,3,306.2,30,'1611615389683215591',0),(66,'2021-01-25 18:17:34',3,28,2,31,'1611616334334356941',0),(67,'2021-01-25 18:17:34',2,28,1,31,'1611616334334356941',0),(68,'2021-01-25 18:19:43',85,2,2,32,'1611616665617764252',0),(69,'2021-01-25 18:21:04',116,3,50,33,'16116167881388162231',0),(70,'2021-01-26 11:20:50',130,3,27.6,34,'1611677936252037143',0),(71,'2021-01-26 15:34:51',115,13,14,35,'1611692661534024405',0),(72,'2021-01-26 17:59:46',116,13,17,36,'1611701537630157405',0),(73,'2021-01-26 18:38:45',1,2,1,37,'16117033591008880111',0),(74,'2021-01-26 18:45:19',78,14,1,38,'16117046921024457616',0),(75,'2021-01-26 18:45:19',79,14,1,38,'16117046921024457616',0),(76,'2021-01-26 18:45:19',80,14,1,38,'16117046921024457616',0),(77,'2021-01-26 18:45:38',129,7,50,39,'1611704722165328104',0),(78,'2021-01-26 18:46:07',85,2,2,40,'1611704741529592132',0),(79,'2021-01-26 18:50:56',239,14,5,41,'1611704769278759879',0),(80,'2021-01-26 18:50:56',41,25,2,41,'1611704769278759879',0),(81,'2021-01-26 18:50:56',24,1,5,41,'1611704769278759879',0),(82,'2021-01-28 18:24:18',346,28,4,42,'1611876223564361811',0),(83,'2021-01-28 18:25:14',78,14,1,43,'1611876288270454745',0),(84,'2021-01-28 18:25:14',79,14,1,43,'1611876288270454745',0),(85,'2021-01-28 18:25:14',80,14,1,43,'1611876288270454745',0),(86,'2021-01-28 18:25:34',129,7,50,44,'1611876317179786782',0),(87,'2021-01-28 18:26:22',292,14,1,45,'1611876336171438617',0),(88,'2021-01-28 18:26:22',292,14,1,45,'1611876336171438617',0),(89,'2021-01-28 18:26:50',148,2,10,46,'1611876385534669882',0),(90,'2021-01-28 18:27:16',85,2,2,47,'16118764131166032176',0),(91,'2021-01-28 18:27:43',115,3,50,48,'1611876439994722655',0),(92,'2021-01-28 18:28:11',117,3,50,49,'1611876466524385286',0),(93,'2021-01-28 18:28:36',297,2,10,50,'1611876493876944670',0),(94,'2021-01-28 18:29:24',48,28,1,51,'1611876519754174998',0),(95,'2021-01-28 18:29:24',10,28,1,51,'1611876519754174998',0),(96,'2021-01-28 18:29:47',113,2,5,52,'1611876566609200927',0),(97,'2021-01-28 18:30:20',5,28,5,53,'1611876600712262043',0),(98,'2021-01-28 18:31:06',2,28,1,54,'1611876622690186739',0),(99,'2021-01-28 18:31:06',72,28,2,54,'1611876622690186739',0),(100,'2021-01-28 18:31:43',3,28,4,55,'1611876669263784819',0),(101,'2021-01-28 18:32:21',138,2,1,56,'1611876705858957385',0),(102,'2021-01-28 18:32:58',50,28,2,57,'16118767441217110901',0),(103,'2021-01-28 18:33:18',129,7,50,58,'1611876781406736397',0),(104,'2021-01-28 18:34:17',19,28,3,59,'1611876801942352977',0),(105,'2021-01-28 18:34:17',10,28,1,59,'1611876801942352977',0),(106,'2021-01-28 18:34:50',25,28,5,60,'16118768601304379353',0),(107,'2021-01-28 18:35:15',85,2,2,61,'1611876892698448841',0),(108,'2021-01-28 18:35:53',21,28,10,62,'1611876922206337391',0),(109,'2021-01-28 18:36:40',61,28,1,63,'1611876959394859625',0),(110,'2021-01-28 18:37:15',32,28,2,64,'1611877003740189669',0),(111,'2021-01-28 18:38:04',294,2,5,65,'1611877038866961297',0),(112,'2021-01-28 18:38:04',140,2,1,65,'1611877038866961297',0),(113,'2021-01-28 18:38:45',87,28,4,66,'1611877086709766200',0),(114,'2021-01-28 18:39:19',17,28,3,67,'1611877127639882587',0),(115,'2021-01-28 18:39:58',64,28,1,68,'16118771621073255656',0),(116,'2021-01-28 18:39:58',312,28,1,68,'16118771621073255656',0),(117,'2021-01-28 18:40:22',131,3,50,69,'16118772011070415558',0),(118,'2021-01-28 18:41:06',10,28,3,70,'16118772241225803320',0),(119,'2021-01-28 18:41:32',41,28,2,71,'16118772691112930958',0),(120,'2021-01-28 18:42:01',340,28,1,72,'1611877295636956426',0),(121,'2021-01-28 18:42:31',85,2,2,73,'16118773301299129476',0),(122,'2021-01-28 18:43:04',151,14,5,74,'1611877353822208244',0),(123,'2021-01-28 18:43:30',302,28,5,75,'1611877391370417573',0),(124,'2021-01-28 18:44:32',3,28,3,76,'1611877413998380357',0),(125,'2021-01-28 18:45:37',74,28,1,77,'1611877484933875717',0),(126,'2021-01-28 18:45:37',2,28,1,77,'1611877484933875717',0),(127,'2021-01-28 18:46:32',75,28,2,78,'16118775391219176426',0),(128,'2021-01-28 18:46:32',346,28,1,78,'16118775391219176426',0),(129,'2021-01-28 18:47:12',281,28,5,79,'1611877604614665963',0),(130,'2021-01-28 18:47:12',280,28,5,79,'1611877604614665963',0),(131,'2021-01-28 18:47:39',246,29,20,80,'16118776351179888410',0),(132,'2021-01-28 18:48:21',135,29,10,81,'1611877662593064009',0),(133,'2021-01-28 18:48:21',136,29,10,81,'1611877662593064009',0),(134,'2021-01-28 18:49:13',30,28,2,82,'1611877705594441026',0),(135,'2021-01-29 18:21:48',3,28,1,83,'1611962455846392105',0),(136,'2021-01-29 18:21:48',346,28,1,83,'1611962455846392105',0),(137,'2021-01-29 18:21:48',7,28,1,83,'1611962455846392105',0),(138,'2021-01-29 18:22:20',78,14,1,84,'16119625131278990602',0),(139,'2021-01-29 18:22:20',79,14,1,84,'16119625131278990602',0),(140,'2021-01-29 18:22:20',80,14,1,84,'16119625131278990602',0),(141,'2021-01-29 18:22:58',129,7,50,85,'16119625471128809685',0),(142,'2021-01-29 18:26:01',17,28,1,86,'1611962580188952552',0),(143,'2021-01-29 18:26:01',10,28,1,86,'1611962580188952552',0),(144,'2021-01-29 18:26:01',25,28,1,86,'1611962580188952552',0),(145,'2021-01-29 18:26:29',85,2,2,87,'16119627641194648311',0),(146,'2021-01-29 18:27:00',147,2,10,88,'1611962792137400478',0),(147,'2021-01-29 18:27:26',114,2,5,89,'1611962822941018992',0),(148,'2021-01-29 18:28:28',115,3,50,90,'16119628481027039523',0),(149,'2021-01-29 18:29:14',22,28,10,91,'16119629101130100639',0),(150,'2021-01-29 18:38:13',85,2,5,92,'1611962962199280179',0),(151,'2021-01-29 18:38:13',114,2,4,92,'1611962962199280179',0),(152,'2021-01-29 18:38:13',66,28,1,92,'1611962962199280179',0),(153,'2021-01-29 18:44:01',138,1,5,93,'16119636721040336343',0),(154,'2021-01-29 18:49:28',25,28,7,94,'1611964137555540296',0),(155,'2021-01-29 18:49:53',139,2,1,95,'1611964171260471372',0),(156,'2021-01-29 18:50:17',30,28,1,96,'1611964196234308049',0),(157,'2021-01-29 18:51:01',148,2,10,97,'16119642201031729987',0),(158,'2021-01-29 18:51:37',117,3,50,98,'1611964264123027863',0),(159,'2021-01-29 18:52:21',364,3,50,99,'1611964300366544713',0),(160,'2021-01-29 18:52:58',127,2,2,100,'1611964349440516345',0),(161,'2021-01-29 18:53:28',118,3,50,101,'1611964381636181854',0),(162,'2021-01-29 18:54:40',136,29,10,102,'1611964416130214170',0),(163,'2021-01-29 18:54:40',135,29,10,102,'1611964416130214170',0),(164,'2021-01-29 18:55:12',41,28,2,103,'1611964491857967654',0),(165,'2021-01-29 18:55:35',130,3,50,104,'16119645151372842917',0),(166,'2021-01-29 18:56:36',50,28,1,105,'1611964556909003347',0),(167,'2021-01-29 18:57:33',69,28,1,106,'1611964599114851825',0),(168,'2021-01-29 18:57:33',77,28,2,106,'1611964599114851825',0),(169,'2021-01-29 18:58:14',3,28,3,107,'1611964669835892351',0),(170,'2021-01-30 18:18:42',129,7,50,108,'1612048698247174552',0),(171,'2021-01-30 18:20:19',87,28,5,109,'1612048786794409714',0),(172,'2021-01-30 18:20:54',25,28,5,110,'16120488221237938283',0),(173,'2021-01-30 18:21:19',85,2,2,111,'1612048857194116366',0),(174,'2021-01-30 18:22:03',4,28,5,112,'1612048882305654743',0),(175,'2021-01-30 18:22:25',346,28,2,113,'1612048926109214661',0),(176,'2021-01-30 18:23:25',17,28,3,114,'161204894825517847',0),(177,'2021-01-30 18:24:13',50,28,1,115,'1612049009783694800',0),(178,'2021-01-30 18:24:48',302,28,6,116,'16120490571105185238',0),(179,'2021-01-30 18:25:56',74,28,1,117,'16120490911404299149',0),(180,'2021-01-30 18:25:56',74,28,1,117,'16120490911404299149',0),(181,'2021-01-30 18:26:51',2,28,1,118,'16120491591069985241',0),(182,'2021-01-30 18:26:51',11,28,1,118,'16120491591069985241',0),(183,'2021-01-30 18:27:21',78,14,1,119,'1612049214178495829',0),(184,'2021-01-30 18:27:21',79,14,1,119,'1612049214178495829',0),(185,'2021-01-30 18:27:21',80,14,1,119,'1612049214178495829',0),(186,'2021-01-30 18:27:43',131,3,50,120,'1612049243844240516',0),(187,'2021-01-30 18:28:11',138,2,1,121,'1612049266122468450',0),(188,'2021-01-30 18:29:02',152,28,2,122,'1612049295133097300',0),(189,'2021-01-30 18:29:41',130,3,50,123,'1612049352116271873',0),(190,'2021-01-30 18:30:15',146,2,10,124,'16120493841057118738',0),(191,'2021-01-30 18:30:46',39,28,2,125,'1612049419449466955',0),(192,'2021-01-30 18:31:31',83,2,1,126,'1612049449141144243',0),(193,'2021-01-30 18:31:53',129,7,50,127,'16120494951126615065',0),(194,'2021-01-30 18:32:20',75,28,2,128,'1612049516722675734',0),(195,'2021-01-30 18:33:29',151,14,5,129,'16120495871028889889',0),(196,'2021-01-30 18:33:57',313,2,4,130,'1612049613275274305',0),(197,'2021-01-30 18:34:37',133,29,10,131,'1612049641806286485',0),(198,'2021-01-30 18:34:37',136,29,10,131,'1612049641806286485',0),(199,'2021-01-30 18:35:11',84,2,1,132,'1612049689338746182',0),(200,'2021-01-30 18:35:40',24,28,5,133,'16120497131280066396',0),(201,'2021-01-30 18:37:14',62,28,1,134,'1612049744748322676',0),(202,'2021-01-30 18:37:14',18,28,1,134,'1612049744748322676',0),(203,'2021-01-30 18:37:37',353,28,1,135,'16120498371312512359',0),(204,'2021-01-30 18:38:15',34,28,1,136,'16120498651119471789',0),(205,'2021-01-30 18:38:42',87,28,5,137,'16120498981133801372',0),(206,'2021-01-30 18:39:16',118,3,50,138,'1612049925591600929',0),(207,'2021-01-30 18:40:12',148,2,10,139,'16120499661175499168',0),(208,'2021-02-10 13:30:41',131,3,20,140,'16129816631222016524',0),(209,'2021-02-10 14:00:12',365,2,20,141,'1612983229580584793',0),(210,'2021-02-10 18:15:22',129,7,50,142,'1612998904832880126',0),(211,'2021-02-10 18:18:54',85,2,2,143,'1612998995494220008',0),(212,'2021-02-10 18:19:47',146,2,10,144,'1612999137486087001',0),(213,'2021-02-10 18:20:23',113,2,3,145,'1612999190542458635',0),(214,'2021-02-10 18:21:16',74,28,1,146,'1612999227996917276',0),(215,'2021-02-10 18:21:16',2,28,1,146,'1612999227996917276',0),(216,'2021-02-10 18:22:22',3,28,1,147,'16129992801141977411',0),(217,'2021-02-10 18:22:22',19,28,1,147,'16129992801141977411',0),(218,'2021-02-10 18:24:06',14,28,2,148,'1612999349348170142',0),(219,'2021-02-10 18:24:06',346,28,1,148,'1612999349348170142',0),(220,'2021-02-10 18:25:03',78,14,1,149,'1612999449930433174',0),(221,'2021-02-10 18:25:03',79,14,1,149,'1612999449930433174',0),(222,'2021-02-10 18:25:03',87,28,1,149,'1612999449930433174',0),(223,'2021-02-10 18:25:03',88,28,1,149,'1612999449930433174',0),(224,'2021-02-10 18:25:53',392,28,1,150,'1612999507291540318',0),(225,'2021-02-10 18:25:53',3,28,1,150,'1612999507291540318',0),(226,'2021-02-10 18:26:42',45,28,1,151,'1612999564727151040',0),(227,'2021-02-10 18:27:09',115,3,50,152,'16129996051135479612',0),(228,'2021-02-10 18:28:21',5,28,2,153,'16129996561369357342',0),(229,'2021-02-10 18:28:21',21,28,5,153,'16129996561369357342',0),(230,'2021-02-10 18:29:36',17,28,1,154,'1612999705914554447',0),(231,'2021-02-10 18:29:36',71,28,1,154,'1612999705914554447',0),(232,'2021-02-10 18:30:16',146,2,10,155,'16129997801268964197',0),(233,'2021-02-10 18:30:53',118,3,50,156,'1612999819783780864',0),(234,'2021-02-10 18:31:24',129,7,50,157,'1612999862237019051',0),(235,'2021-02-20 16:21:27',392,28,1,158,'1613856024569697752',0),(236,'2021-02-20 16:21:27',47,28,1,158,'1613856024569697752',0),(237,'2021-02-20 16:21:58',85,2,2,159,'16138560901258679601',0),(238,'2021-02-20 16:22:16',129,7,50,160,'16138561211151573498',0),(239,'2021-02-20 16:22:44',115,3,50,161,'1613856139311291906',0),(240,'2021-02-20 16:23:12',118,3,50,162,'161385616747033737',0),(241,'2021-02-20 16:24:05',3,28,1,163,'1613856196928927062',0),(242,'2021-02-20 16:24:05',74,28,1,163,'1613856196928927062',0),(243,'2021-02-20 16:24:42',74,28,1,164,'1613856248645046401',0),(244,'2021-02-20 16:24:42',64,28,1,164,'1613856248645046401',0),(245,'2021-02-20 16:25:32',17,28,1,165,'161385628537437650',0),(246,'2021-02-20 16:25:32',22,28,5,165,'161385628537437650',0),(247,'2021-02-20 16:26:09',148,2,10,166,'1613856339602057652',0),(248,'2021-02-20 16:26:48',22,28,10,167,'16138563721352704043',0),(249,'2021-02-20 16:27:46',75,28,1,168,'1613856411147599010',0),(250,'2021-02-20 16:27:46',42,28,1,168,'1613856411147599010',0),(251,'2021-02-20 16:28:11',113,2,3,169,'161385646999016129',0),(252,'2021-02-20 16:28:47',87,28,2,170,'1613856493866918265',0),(253,'2021-02-20 16:28:47',88,28,2,170,'1613856493866918265',0),(254,'2021-02-20 16:29:12',83,2,1,171,'161385653041009288',0),(255,'2021-02-20 16:30:14',26,28,1,172,'16138565551233204787',0),(256,'2021-02-20 16:30:14',21,28,5,172,'16138565551233204787',0),(257,'2021-02-20 16:30:52',78,14,1,173,'161385661665795594',0),(258,'2021-02-20 16:30:52',79,14,1,173,'161385661665795594',0),(259,'2021-02-20 16:30:52',80,14,1,173,'161385661665795594',0),(260,'2021-02-20 16:32:01',143,28,2,174,'1613856654414998499',0),(261,'2021-02-20 16:32:01',144,28,2,174,'1613856654414998499',0),(262,'2021-02-20 16:32:35',138,2,1,175,'1613856731278071371',0),(263,'2021-02-20 16:33:04',139,2,1,176,'16138567581244177891',0),(264,'2021-02-20 16:33:31',131,3,50,177,'16138567871390959297',0),(265,'2021-02-20 16:34:23',116,3,50,178,'16138568141034957371',0),(266,'2021-02-20 16:34:55',84,2,1,179,'1613856866867520710',0),(267,'2021-02-20 16:36:31',85,2,1,180,'16138569631127045382',0),(268,'2021-02-20 16:37:16',135,29,10,181,'1613856994492756927',0),(269,'2021-02-20 16:39:11',127,2,1,182,'1613857039901774008',0),(270,'2021-02-20 16:39:11',112,2,3,182,'1613857039901774008',0),(271,'2021-02-22 17:24:12',74,28,1,183,'1614032568171438617',0),(272,'2021-02-22 17:24:12',64,28,1,183,'1614032568171438617',0),(273,'2021-02-22 17:25:03',87,28,2,184,'161403265584858673',0),(274,'2021-02-22 17:25:03',88,28,2,184,'161403265584858673',0),(275,'2021-02-22 17:25:22',129,7,50,185,'1614032706816700176',0),(276,'2021-02-22 17:25:57',85,2,2,186,'161403272550476280',0),(277,'2021-02-22 17:31:00',148,2,10,187,'1614032760777928541',0),(278,'2021-02-22 17:32:12',3,28,1,188,'1614033066325879680',0),(279,'2021-02-22 17:32:12',17,28,1,188,'1614033066325879680',0),(280,'2021-02-22 17:32:12',346,28,1,188,'1614033066325879680',0),(281,'2021-02-22 17:33:18',4,28,2,189,'1614033136894716796',0),(282,'2021-02-22 17:33:18',45,28,1,189,'1614033136894716796',0),(283,'2021-02-22 17:34:14',25,28,5,190,'1614033200514057659',0),(284,'2021-02-22 17:34:42',131,30,50,191,'1614033257577959854',0),(285,'2021-02-22 17:35:09',81,2,1,192,'16140332851388764676',0),(286,'2021-02-22 17:35:36',138,2,1,193,'1614033312168684583',0),(287,'2021-02-22 17:36:04',84,2,1,194,'1614033339654728552',0),(288,'2021-02-22 17:36:28',82,2,1,195,'1614033367543663524',0),(289,'2021-02-22 17:37:00',145,2,10,196,'1614033391402131996',0),(290,'2021-02-22 17:37:35',78,14,1,197,'1614033423769924630',0),(291,'2021-02-22 17:37:35',80,14,1,197,'1614033423769924630',0),(292,'2021-02-22 17:38:25',50,28,1,198,'161403345722849876',0),(293,'2021-02-22 17:38:25',30,28,1,198,'161403345722849876',0),(294,'2021-02-22 17:38:59',17,28,1,199,'1614033508562683572',0),(295,'2021-02-22 17:38:59',346,28,1,199,'1614033508562683572',0),(296,'2021-02-22 17:40:09',112,2,5,200,'1614033572194933969',0),(297,'2021-02-22 17:41:02',16,28,1,201,'16140336121087542207',0),(298,'2021-02-22 17:41:02',71,28,1,201,'16140336121087542207',0),(299,'2021-02-22 17:42:30',127,2,1,202,'1614033665888692346',0),(300,'2021-02-22 17:42:30',124,2,1,202,'1614033665888692346',0),(301,'2021-02-22 17:42:30',125,2,1,202,'1614033665888692346',0),(302,'2021-02-22 17:42:30',320,2,1,202,'1614033665888692346',0),(303,'2021-02-22 17:43:13',2,28,2,203,'16140337531206094765',0),(304,'2021-02-22 17:51:06',149,2,10,204,'16140338001153208705',0),(305,'2021-02-22 17:59:01',75,28,1,205,'1614034270358497770',0),(306,'2021-02-22 17:59:01',32,28,1,205,'1614034270358497770',0),(307,'2021-02-22 17:59:59',137,29,10,206,'1614034753524385286',0),(308,'2021-02-22 17:59:59',134,29,10,206,'1614034753524385286',0),(309,'2021-02-22 17:59:59',268,29,10,206,'1614034753524385286',0),(310,'2021-02-22 18:07:19',114,2,3,207,'1614035217684635640',0),(311,'2021-02-22 18:08:09',115,3,50,208,'1614035243295241051',0),(312,'2021-02-22 18:08:52',32,28,1,209,'1614035292427563779',0),(313,'2021-02-22 18:09:17',151,14,4,210,'161403533516309046',0),(314,'2021-02-22 18:09:46',146,2,10,211,'1614035359251004380',0),(315,'2021-02-22 18:10:18',43,28,1,212,'16140353891057376929',0),(316,'2021-02-23 18:36:58',117,3,52.1,213,'1614123192887788679',0),(317,'2021-02-23 18:36:58',117,3,54.5,213,'1614123192887788679',0),(318,'2021-02-23 18:36:58',22,28,10,213,'1614123192887788679',0),(319,'2021-02-23 19:12:59',74,28,1,214,'1614125538612643470',0),(320,'2021-02-23 19:12:59',2,28,1,214,'1614125538612643470',0),(321,'2021-02-23 19:13:19',129,7,50,215,'16141255821118352963',0),(322,'2021-02-23 19:13:48',147,2,10,216,'16141256011111338782',0),(323,'2021-02-23 19:14:17',114,2,5,217,'1614125631769752503',0),(324,'2021-02-23 19:14:59',27,28,1,218,'16141256601274128011',0),(325,'2021-02-23 19:14:59',32,28,1,218,'16141256601274128011',0),(326,'2021-02-23 19:15:31',87,28,3,219,'1614125702114120284',0),(327,'2021-02-23 19:15:31',88,28,2,219,'1614125702114120284',0),(328,'2021-02-23 19:15:52',138,2,1,220,'1614125733120273829',0),(329,'2021-02-23 19:16:18',139,2,1,221,'1614125755675641997',0),(330,'2021-02-23 19:16:39',129,7,50,222,'16141257811278129966',0),(331,'2021-02-23 19:17:03',84,2,1,223,'1614125802265635186',0),(332,'2021-02-23 19:17:25',81,2,1,224,'16141258251244479113',0),(333,'2021-02-23 19:18:03',78,14,1,225,'1614125847989429746',0),(334,'2021-02-23 19:18:03',79,14,1,225,'1614125847989429746',0),(335,'2021-02-23 19:18:35',85,2,2,226,'16141258864131051',0),(336,'2021-02-23 19:19:16',151,14,5,227,'1614125936403638108',0),(337,'2021-02-23 19:19:43',148,2,10,228,'1614125958504891890',0),(338,'2021-02-23 19:20:13',135,29,10,229,'16141259861360148541',0),(339,'2021-02-23 19:20:13',136,29,10,229,'16141259861360148541',0),(340,'2021-02-23 19:20:49',246,29,30,230,'1614126015217181400',0),(341,'2021-02-23 19:21:15',83,2,1,231,'16141260521368840961',0),(342,'2021-02-23 19:21:42',131,3,50,232,'1614126082296402910',0),(343,'2021-02-23 19:22:29',30,28,1,233,'16141261051349863946',0),(344,'2021-02-23 19:22:29',27,28,1,233,'16141261051349863946',0),(345,'2021-02-23 19:23:07',130,3,50,234,'1614126166898933910',0),(346,'2021-02-23 19:23:46',76,28,2,235,'16141261911383385703',0),(347,'2021-02-23 19:23:46',14,28,3,235,'16141261911383385703',0),(348,'2021-02-24 18:09:14',129,7,50,236,'16142081351242069334',0),(349,'2021-02-24 18:09:42',78,14,1,237,'1614208157408285541',0),(350,'2021-02-24 18:09:42',79,14,1,237,'1614208157408285541',0),(351,'2021-02-24 18:09:42',80,14,1,237,'1614208157408285541',0),(352,'2021-02-24 18:10:23',147,2,10,238,'1614208185310474302',0),(353,'2021-02-24 18:10:54',41,28,1,239,'1614208226276522227',0),(354,'2021-02-24 18:11:16',131,3,50,240,'1614208257840453719',0),(355,'2021-02-24 18:11:36',85,2,2,241,'1614208279550505578',0),(356,'2021-02-24 18:12:24',67,28,1,242,'1614208299979575468',0),(357,'2021-02-24 18:12:24',346,28,1,242,'1614208299979575468',0),(358,'2021-02-24 18:12:46',130,3,50,243,'1614208346955434639',0),(359,'2021-02-24 18:13:27',87,28,2,244,'1614208368494607294',0),(360,'2021-02-24 18:13:27',88,28,2,244,'1614208368494607294',0),(361,'2021-02-24 18:14:00',75,28,2,245,'1614208411864637581',0),(362,'2021-02-24 18:14:36',118,3,50,246,'1614208442986116299',0),(363,'2021-02-24 18:15:04',297,2,10,247,'16142084781081775949',0),(364,'2021-02-24 18:15:25',41,28,1,248,'1614208507109472852',0),(365,'2021-02-24 18:16:03',143,28,5,249,'16142085281217928504',0),(366,'2021-02-24 18:16:57',32,28,1,250,'1614208566958145641',0),(367,'2021-02-24 18:17:50',69,28,1,251,'16142086201108972034',0),(368,'2021-02-24 18:17:50',11,28,1,251,'16142086201108972034',0),(369,'2021-02-24 18:18:11',138,2,1,252,'16142086721264015542',0),(370,'2021-02-24 18:18:59',83,2,1,253,'1614208694481439569',0),(371,'2021-02-24 18:19:25',25,28,5,254,'1614208742684506544',0),(372,'2021-02-24 18:19:46',151,14,5,255,'1614208768821993085',0),(373,'2021-02-24 18:20:18',3,28,3,256,'16142087891251235103',0),(374,'2021-02-24 18:21:45',4,28,5,257,'16142088701081991107',0),(375,'2021-02-24 18:22:37',2,28,1,258,'1614208909633040534',0),(376,'2021-02-24 18:22:37',343,28,1,258,'1614208909633040534',0),(377,'2021-02-24 18:23:24',30,28,1,259,'1614208960495812184',0),(378,'2021-02-24 18:23:24',18,28,1,259,'1614208960495812184',0),(379,'2021-02-24 18:24:10',302,28,3,260,'16142090071300721651',0),(380,'2021-02-24 18:24:34',20,28,5,261,'1614209053708475246',0),(381,'2021-02-24 18:24:51',129,7,50,262,'16142090771062325583',0),(382,'2021-02-24 18:25:30',134,29,10,263,'16142090931038055659',0),(383,'2021-02-24 18:25:30',136,29,10,263,'16142090931038055659',0),(384,'2021-02-24 18:25:30',135,29,10,263,'16142090931038055659',0),(385,'2021-02-24 18:26:20',8,28,1,264,'1614209133303890439',0),(386,'2021-02-24 18:26:20',21,28,10,264,'1614209133303890439',0),(387,'2021-02-24 18:26:47',146,2,10,265,'1614209182192179935',0),(388,'2021-02-24 18:27:17',241,29,10,266,'1614209216386554491',0),(389,'2021-02-25 18:40:37',20,28,5,267,'16142961501175800391',0),(390,'2021-02-25 18:41:09',129,7,50,268,'1614296440515477708',0),(391,'2021-02-25 18:41:37',85,2,2,269,'1614296472896696258',0),(392,'2021-02-25 18:42:07',78,14,1,270,'161429650037695841',0),(393,'2021-02-25 18:42:07',79,14,1,270,'161429650037695841',0),(394,'2021-02-25 18:42:07',80,14,1,270,'161429650037695841',0),(395,'2021-02-25 18:44:59',282,3,30,271,'1614296668145490453',0),(396,'2021-02-25 18:50:57',10,28,1,272,'1614296702487593113',0),(397,'2021-02-25 18:50:57',346,28,1,272,'1614296702487593113',0),(398,'2021-02-25 18:50:57',19,28,1,272,'1614296702487593113',0),(399,'2021-02-25 18:56:50',147,2,10,273,'16142973831171497212',0),(400,'2021-02-25 18:58:57',138,2,1,274,'16142975151264101606',0),(401,'2021-02-25 18:59:24',302,28,5,275,'1614297540505924652',0),(402,'2021-02-25 18:59:59',115,3,50,276,'1614297567489529544',0),(403,'2021-02-25 19:00:42',69,28,1,277,'1614297603131892410',0),(404,'2021-02-25 19:00:42',74,28,1,277,'1614297603131892410',0),(405,'2021-02-25 19:02:51',20,28,5,278,'1614297749914984765',0),(406,'2021-02-25 19:03:19',83,2,1,279,'16142977731336136807',0),(407,'2021-02-25 19:05:45',2,28,1,280,'1614297801718157397',0),(408,'2021-02-25 19:05:45',2,28,1,280,'1614297801718157397',0),(409,'2021-02-25 19:07:37',82,2,1,281,'1614298037655632219',0),(410,'2021-02-25 19:07:55',129,7,50,282,'1614298059348213174',0),(411,'2021-02-25 19:08:14',131,3,50,283,'1614298077189124679',0),(412,'2021-02-25 19:08:45',149,2,10,284,'1614298096486904605',0),(413,'2021-02-25 19:19:26',41,28,2,285,'16142987451049545144',0),(414,'2021-02-25 19:19:50',138,2,1,286,'16142987691193744643',0),(415,'2021-02-25 19:20:21',32,28,1,287,'1614298794194159397',0),(416,'2021-02-25 19:20:49',19,28,3,288,'1614298824330441048',0),(417,'2021-02-25 19:21:34',75,28,2,289,'1614298852365339823',0),(418,'2021-02-25 19:21:34',312,28,2,289,'1614298852365339823',0),(419,'2021-02-25 19:21:55',40,28,2,290,'1614298898975573513',0),(420,'2021-02-25 19:22:46',85,2,2,291,'16142989371312125073',0),(421,'2021-02-25 19:23:23',134,29,10,292,'1614298969427434683',0),(422,'2021-02-25 19:23:23',135,29,10,292,'1614298969427434683',0),(423,'2021-02-25 19:28:58',365,28,1,293,'1614299006479287980',0),(424,'2021-02-25 19:29:30',114,2,5,294,'1614299349671209724',0),(425,'2021-02-26 11:28:16',400,5,1,295,'16143566941022047836',0),(426,'2021-02-26 11:35:34',400,5,1,296,'1614357251591213643',0),(427,'2021-02-26 19:11:42',140,1,5,297,'16143840231392336314',0),(428,'2021-02-26 19:11:42',151,1,5,297,'16143840231392336314',0),(429,'2021-02-26 19:11:42',268,29,1,297,'16143840231392336314',0),(430,'2021-02-26 19:11:42',129,7,1,297,'16143840231392336314',0),(431,'2021-02-26 19:11:42',320,1,5,297,'16143840231392336314',0),(432,'2021-02-26 19:11:42',296,1,5,297,'16143840231392336314',0),(433,'2021-02-26 19:11:42',297,1,2.5,297,'16143840231392336314',0),(434,'2021-02-26 19:11:42',145,1,1,297,'16143840231392336314',0),(435,'2021-02-26 19:17:00',129,7,50,298,'1614385006934004812',0),(436,'2021-02-26 19:17:35',85,2,2,299,'1614385024594699217',0),(437,'2021-02-26 19:18:07',148,2,10,300,'16143850571091070813',0),(438,'2021-02-26 19:18:34',114,2,5,301,'1614385089734208252',0),(439,'2021-02-26 19:19:52',78,14,1,302,'16143851611092749053',0),(440,'2021-02-26 19:19:52',79,14,1,302,'16143851611092749053',0),(441,'2021-02-26 19:19:52',80,14,1,302,'16143851611092749053',0),(442,'2021-02-26 19:20:42',74,28,1,303,'1614385194868940759',0),(443,'2021-02-26 19:20:42',2,28,1,303,'1614385194868940759',0),(444,'2021-02-26 19:21:14',25,28,5,304,'161438524524485084',0),(445,'2021-02-26 19:21:34',131,3,50,305,'16143852765422005',0),(446,'2021-02-26 19:23:10',130,3,250,306,'161438529898671875',0),(447,'2021-02-26 19:24:35',130,3,261,307,'16143853931263585224',0),(448,'2021-02-26 19:28:57',138,2,1,308,'1614385705123243022',0),(449,'2021-02-26 19:29:24',139,2,1,309,'1614385739890198459',0),(450,'2021-02-26 19:29:58',136,29,10,310,'16143857711164827286',0),(451,'2021-02-26 19:29:58',134,29,10,310,'16143857711164827286',0),(452,'2021-02-26 19:30:26',23,28,10,311,'1614385800600379412',0),(453,'2021-02-26 19:30:49',131,3,50,312,'1614385830532862547',0),(454,'2021-02-26 19:31:17',84,2,1,313,'1614385857341930534',0),(455,'2021-02-26 19:31:45',127,2,2,314,'1614385880861754451',0),(456,'2021-02-26 19:32:12',241,29,20,315,'1614385913372741289',0),(457,'2021-02-26 19:33:12',313,2,5,316,'1614385958220580911',0),(458,'2021-02-27 14:31:48',346,28,1,317,'1614454205407381873',0),(459,'2021-02-27 14:31:48',17,28,1,317,'1614454205407381873',0),(460,'2021-02-27 14:31:48',32,28,1,317,'1614454205407381873',0),(461,'2021-02-27 14:38:09',242,29,12,318,'16144545601157727042',0),(462,'2021-02-27 14:38:09',297,2,1,318,'16144545601157727042',0),(463,'2021-02-27 14:43:47',74,28,1,319,'16144549751396467365',0),(464,'2021-02-27 14:43:47',11,28,1,319,'16144549751396467365',0),(465,'2021-02-27 14:44:15',117,3,50,320,'1614455030689369136',0),(466,'2021-02-27 14:44:36',130,3,50,321,'1614455058247992156',0),(467,'2021-02-27 14:45:15',116,3,50,322,'1614455079776551524',0),(468,'2021-02-27 14:45:45',115,3,50,323,'1614455119621852271',0),(469,'2021-02-27 14:46:20',149,2,10,324,'1614455149262967216',0),(470,'2021-02-27 15:03:55',78,14,1,325,'1614455183843164722',0),(471,'2021-02-27 15:03:55',79,14,1,325,'1614455183843164722',0),(472,'2021-02-27 15:03:55',80,14,1,325,'1614455183843164722',0),(473,'2021-02-27 15:04:40',147,2,10,326,'1614456238879698704',0),(474,'2021-02-27 15:05:11',85,2,2,327,'1614456283324330536',0),(475,'2021-02-27 15:05:34',3,28,3,328,'16144563141286306005',0),(476,'2021-02-27 15:06:02',114,2,5,329,'16144563371172874229',0),(477,'2021-02-27 15:06:31',138,2,1,330,'1614456368106417595',0),(478,'2021-02-27 15:06:57',139,2,1,331,'1614456394234824431',0),(479,'2021-02-27 15:08:01',87,28,2,332,'1614456430596420488',0),(480,'2021-02-27 15:08:01',88,28,2,332,'1614456430596420488',0),(481,'2021-02-27 15:09:00',344,28,1,333,'16144564851050104558',0),(482,'2021-02-27 15:09:40',136,29,10,334,'161445654357060142',0),(483,'2021-02-27 15:09:40',134,29,10,334,'161445654357060142',0),(484,'2021-02-27 15:09:40',137,29,10,334,'161445654357060142',0),(485,'2021-02-27 15:10:00',129,7,50,335,'16144565831192238531',0),(486,'2021-02-27 15:10:35',313,2,10,336,'1614456603758779399',0),(487,'2021-02-27 15:11:09',287,30,2,337,'1614456641279749610',0),(488,'2021-02-27 15:11:09',296,14,2,337,'1614456641279749610',0),(489,'2021-02-27 15:11:43',83,2,1,338,'1614456672252854747',0),(490,'2021-02-27 15:11:43',85,2,1,338,'1614456672252854747',0),(491,'2021-02-27 15:13:44',23,28,10,339,'1614456705860506530',0),(492,'2021-02-27 15:14:17',10,28,2,340,'1614456832799444432',0),(493,'2021-02-27 15:14:17',346,28,1,340,'1614456832799444432',0),(494,'2021-02-27 15:14:42',82,2,1,341,'1614456861415687007',0),(495,'2021-02-27 15:15:28',116,3,50,342,'16144568851121365187',0),(496,'2021-02-27 15:16:15',27,28,1,343,'1614456937132451823',0),(497,'2021-02-27 15:16:15',20,28,2,343,'1614456937132451823',0),(498,'2021-02-27 15:17:14',3,28,3,344,'1614457013887315329',0),(499,'2021-03-15 19:23:47',24,28,4,345,'161585391535845474',0),(500,'2021-03-15 19:23:47',14,28,6,345,'161585391535845474',0),(501,'2021-03-15 19:23:47',124,2,1,345,'161585391535845474',0),(502,'2021-03-15 19:23:47',114,2,2,345,'161585391535845474',0),(503,'2021-03-15 19:23:47',132,2,2,345,'161585391535845474',0),(504,'2021-03-15 19:23:47',151,2,2,345,'161585391535845474',0),(505,'2021-03-18 18:23:08',129,7,50,346,'1616109764195278224',0),(506,'2021-03-18 18:23:44',21,28,10,347,'1616109793797335875',0),(507,'2021-03-18 18:26:23',69,28,1,348,'1616109829453081625',0),(508,'2021-03-18 18:26:23',3,28,2,348,'1616109829453081625',0),(509,'2021-03-18 18:27:30',346,28,1,349,'161610998672766743',0),(510,'2021-03-18 18:27:30',25,28,5,349,'161610998672766743',0),(511,'2021-03-18 18:28:35',148,2,10,350,'16161100531324173972',0),(512,'2021-03-18 18:29:10',3,28,3,351,'1616110120932369604',0),(513,'2021-03-18 18:30:50',77,28,1,352,'1616110154641345668',0),(514,'2021-03-18 18:30:50',41,28,1,352,'1616110154641345668',0),(515,'2021-03-18 18:32:05',4,28,3,353,'1616110253284181884',0),(516,'2021-03-18 18:32:05',346,28,1,353,'1616110253284181884',0),(517,'2021-03-18 18:33:02',8,28,1,354,'16161103291249944150',0),(518,'2021-03-18 18:33:02',5,28,1,354,'16161103291249944150',0),(519,'2021-03-18 18:33:02',38,28,1,354,'16161103291249944150',0),(520,'2021-03-18 18:33:37',85,2,2,355,'1616110386926259091',0),(521,'2021-03-18 18:34:34',114,2,5,356,'1616110422267829807',0),(522,'2021-03-18 18:35:59',87,28,1,357,'161611047774014664',0),(523,'2021-03-18 18:35:59',88,28,1,357,'161611047774014664',0),(524,'2021-03-18 18:35:59',143,28,1,357,'161611047774014664',0),(525,'2021-03-18 18:35:59',144,28,1,357,'161611047774014664',0),(526,'2021-03-18 18:36:57',78,14,1,358,'161611056387741802',0),(527,'2021-03-18 18:36:57',79,14,1,358,'161611056387741802',0),(528,'2021-03-18 18:36:57',248,29,10,358,'161611056387741802',0),(529,'2021-03-25 18:33:55',3,28,2,359,'16167152141315954902',0),(530,'2021-03-25 18:34:14',129,7,50,360,'16167152381083239029',0),(531,'2021-03-25 18:34:40',148,2,10,361,'1616715256286075282',0),(532,'2021-03-25 18:35:01',85,2,2,362,'1616715282398947644',0),(533,'2021-03-25 18:35:36',78,14,1,363,'16167153031031557860',0),(534,'2021-03-25 18:35:36',79,14,1,363,'16167153031031557860',0),(535,'2021-03-25 18:36:07',22,28,10,364,'1616715339908917283',0),(536,'2021-03-25 18:36:30',114,2,5,365,'16167153691297537300',0),(537,'2021-03-25 18:36:52',138,2,1,366,'1616715392121005369',0),(538,'2021-03-25 18:37:22',134,29,10,367,'1616715415432555465',0),(539,'2021-03-25 18:37:22',136,29,10,367,'1616715415432555465',0),(540,'2021-03-25 18:37:22',137,29,10,367,'1616715415432555465',0),(541,'2021-03-25 18:38:16',10,28,1,368,'1616715444846306042',0),(542,'2021-03-25 18:38:16',361,28,1,368,'1616715444846306042',0),(543,'2021-03-25 18:38:16',5,28,1,368,'1616715444846306042',0),(544,'2021-03-25 18:38:38',131,3,50,369,'1616715499529463037',0),(545,'2021-03-25 18:39:11',25,28,5,370,'16167155211092619957',0),(546,'2021-03-25 18:40:51',291,14,1,371,'1616715553200054751',0),(547,'2021-03-25 18:40:51',293,14,1,371,'1616715553200054751',0),(548,'2021-03-25 18:40:51',292,14,1,371,'1616715553200054751',0),(549,'2021-03-25 18:41:37',150,14,2,372,'1616715654838345162',0),(550,'2021-03-25 18:41:37',151,14,2,372,'1616715654838345162',0),(551,'2021-03-29 18:08:55',129,7,50,373,'161705931075735935',0),(552,'2021-03-29 18:09:41',148,2,10,374,'161705933946775547',0),(553,'2021-03-29 18:10:13',118,3,50,375,'16170593841271632167',0),(554,'2021-03-29 18:10:35',85,2,2,376,'1617059416540307045',0),(555,'2021-03-29 18:11:01',17,28,2,377,'1617059438885766185',0),(556,'2021-03-29 18:11:32',20,28,6,378,'16170594641072997465',0),(557,'2021-03-29 18:12:18',74,28,1,379,'1617059494459321233',0),(558,'2021-03-29 18:12:18',69,28,1,379,'1617059494459321233',0),(559,'2021-03-29 18:12:46',32,28,1,380,'1617059541999413119',0),(560,'2021-03-29 18:13:21',21,28,10,381,'1617059569249024918',0),(561,'2021-03-29 18:13:41',138,2,1,382,'1617059604642593589',0),(562,'2021-03-29 18:15:06',140,2,1,383,'1617059623672414614',0),(563,'2021-03-29 18:15:29',131,3,50,384,'1617059709439999963',0),(564,'2021-03-29 18:16:00',5,28,3,385,'16170597371071491353',0),(565,'2021-03-29 18:16:42',302,28,5,386,'16170597631023941235',0),(566,'2021-03-29 18:17:07',3,28,2,387,'1617059804855816065',0),(567,'2021-03-29 18:17:28',10,28,2,388,'1617059829939771071',0),(568,'2021-03-29 18:18:13',87,28,1,389,'1617059855902978898',0),(569,'2021-03-29 18:18:13',88,28,1,389,'1617059855902978898',0),(570,'2021-03-29 18:18:13',86,14,1,389,'1617059855902978898',0),(571,'2021-03-29 18:18:43',83,2,1,390,'1617059896663334908',0),(572,'2021-03-29 18:19:03',83,2,1,391,'16170599261374004775',0),(573,'2021-03-29 18:19:46',142,14,1,392,'16170599451315997934',0),(574,'2021-03-29 18:19:46',143,28,1,392,'16170599451315997934',0),(575,'2021-03-29 18:19:46',144,28,1,392,'16170599451315997934',0),(576,'2021-03-29 18:20:12',81,2,1,393,'1617059988344555473',0),(577,'2021-03-29 18:20:59',136,29,10,394,'1617060019390556447',0),(578,'2021-03-29 18:20:59',134,29,10,394,'1617060019390556447',0),(579,'2021-03-29 18:20:59',137,29,10,394,'1617060019390556447',0),(580,'2021-03-29 18:20:59',268,29,10,394,'1617060019390556447',0),(581,'2021-03-29 18:21:39',26,28,1,395,'16170600621155446358',0),(582,'2021-03-29 18:22:17',326,29,10,396,'161706010248109532',0),(583,'2021-03-29 18:22:17',241,29,10,396,'161706010248109532',0),(584,'2021-03-29 18:22:41',281,28,2,397,'16170601401146366652',0),(585,'2021-03-29 18:22:41',280,28,2,397,'16170601401146366652',0),(586,'2021-03-29 18:23:19',75,28,1,398,'16170601641357007221',0),(587,'2021-03-29 18:23:19',41,28,1,398,'16170601641357007221',0),(588,'2021-03-29 18:23:47',25,28,4,399,'1617060202774442967',0),(589,'2021-03-31 16:22:45',3,28,2,400,'161722573793034711',0),(590,'2021-03-31 16:23:17',41,28,1,401,'1617225768656449823',0),(591,'2021-03-31 16:24:12',5,28,2,402,'1617225801974626813',0),(592,'2021-03-31 16:24:55',19,28,2,403,'1617225854636095790',0),(593,'2021-03-31 16:25:22',148,2,10,404,'161722589735329093',0),(594,'2021-03-31 16:25:54',149,2,10,405,'1617225925973206765',0),(595,'2021-03-31 16:26:38',85,2,2,406,'1617225957726376467',0),(596,'2021-03-31 16:27:19',77,28,2,407,'16172260011100795996',0),(597,'2021-03-31 16:27:19',4,28,2,407,'16172260011100795996',0),(598,'2021-03-31 16:27:36',129,7,50,408,'1617226042996271799',0),(599,'2021-03-31 16:28:17',78,14,1,409,'16172260641095115801',0),(600,'2021-03-31 16:28:17',79,14,1,409,'16172260641095115801',0),(601,'2021-03-31 16:28:56',18,28,1,410,'1617226100834472302',0),(602,'2021-03-31 16:28:56',302,28,1,410,'1617226100834472302',0),(603,'2021-03-31 16:29:22',130,3,50,411,'1617226139392665004',0),(604,'2021-03-31 16:30:30',43,28,1,412,'1617226165390814638',0),(605,'2021-03-31 16:30:30',3,28,1,412,'1617226165390814638',0),(606,'2021-03-31 16:31:46',69,28,1,413,'1617226233601713397',0),(607,'2021-03-31 16:31:46',74,28,1,413,'1617226233601713397',0),(608,'2021-03-31 16:32:19',313,2,3,414,'1617226310113345712',0),(609,'2021-03-31 16:33:27',30,28,1,415,'1617226342773238077',0),(610,'2021-03-31 16:33:27',41,28,1,415,'1617226342773238077',0),(611,'2021-03-31 16:34:04',132,2,4,416,'1617226415937791609',0),(612,'2021-03-31 16:34:31',138,2,1,417,'1617226447144414658',0),(613,'2021-03-31 16:35:01',140,2,1,418,'16172264731380029224',0),(614,'2021-03-31 16:35:24',139,2,1,419,'1617226504271358413',0),(615,'2021-03-31 16:36:06',136,29,10,420,'1617226527114679697',0),(616,'2021-03-31 16:36:06',137,29,10,420,'1617226527114679697',0),(617,'2021-03-31 16:36:06',134,29,10,420,'1617226527114679697',0),(618,'2021-03-31 16:37:10',64,28,1,421,'16172265741002769598',0),(619,'2021-03-31 16:37:10',3,28,1,421,'16172265741002769598',0),(620,'2021-03-31 16:37:35',281,28,2,422,'1617226633286161346',0),(621,'2021-03-31 16:37:35',280,28,2,422,'1617226633286161346',0),(622,'2021-03-31 16:38:12',22,28,10,423,'1617226664222560373',0),(623,'2021-04-23 18:12:46',146,2,10,424,'16192195381206309923',0),(624,'2021-04-23 18:13:05',129,7,50,425,'1619219569882151515',0),(625,'2021-04-23 18:13:28',148,2,10,426,'1619219587295327115',0),(626,'2021-04-23 18:13:52',85,2,2,427,'1619219611355012196',0),(627,'2021-04-23 18:14:35',74,28,1,428,'1619219635230435189',0),(628,'2021-04-23 18:14:35',69,28,1,428,'1619219635230435189',0),(629,'2021-04-23 18:15:07',138,2,1,429,'161921967766355007',0),(630,'2021-04-23 18:15:33',34,28,2,430,'16192197091226879115',0),(631,'2021-04-23 18:16:14',64,28,1,431,'1619219735904571074',0),(632,'2021-04-23 18:16:14',2,28,1,431,'1619219735904571074',0),(633,'2021-04-23 18:16:35',139,2,1,432,'161921977626163323',0),(634,'2021-04-23 18:17:17',21,28,10,433,'1619219798150611235',0),(635,'2021-04-23 18:17:40',113,2,5,434,'1619219840438795074',0),(636,'2021-04-23 18:18:06',87,28,5,435,'1619219862131246933',0),(637,'2021-04-23 18:18:34',143,28,5,436,'16192198881193228262',0),(638,'2021-04-23 18:18:57',140,2,1,437,'1619219916629468896',0),(639,'2021-04-23 18:19:18',83,2,1,438,'1619219939379841533',0),(640,'2021-04-23 18:19:49',75,28,2,439,'16192199611391604773',0),(641,'2021-04-23 18:20:17',10,28,3,440,'16192199921195853201',0),(642,'2021-04-23 18:20:46',302,28,5,441,'1619220020492240546',0),(643,'2021-04-23 18:21:09',84,2,1,442,'1619220049744708006',0),(644,'2021-04-23 18:21:28',134,29,10,443,'1619220072129482630',0),(645,'2021-04-23 18:21:49',241,29,10,444,'16192200911403438513',0),(646,'2021-04-23 18:22:13',295,2,1,445,'16192201121238024346',0),(647,'2021-04-23 18:22:32',326,29,10,446,'1619220136565437606',0),(648,'2021-04-23 18:22:58',82,1,5,447,'1619220155382122218',0),(649,'2021-04-23 18:23:24',81,2,5,448,'16192201811215174470',0),(650,'2021-04-23 18:24:04',281,28,5,449,'1619220206637386744',0),(651,'2021-04-23 18:24:04',280,28,5,449,'1619220206637386744',0),(652,'2021-04-23 18:24:44',153,28,2,450,'1619220247357120753',0),(653,'2021-04-23 18:25:22',30,28,1,451,'1619220287435395563',0),(654,'2021-04-23 18:25:49',127,2,2,452,'161922032417772126',0),(655,'2021-04-23 18:26:25',124,2,5,453,'1619220351263010247',0),(656,'2021-04-23 18:26:56',88,28,5,454,'16192203941255538281',0),(657,'2021-04-23 18:27:36',144,28,5,455,'1619220419545944209',0),(658,'2021-04-26 18:33:20',129,7,50,456,'1619479984243258660',0),(659,'2021-04-26 18:33:50',117,3,50,457,'1619480006536692376',0),(660,'2021-04-26 18:34:18',10,28,3,458,'1619480033638548602',0),(661,'2021-04-26 18:34:44',148,2,10,459,'1619480061995884513',0),(662,'2021-04-26 18:35:11',18,28,3,460,'161948008782707084',0),(663,'2021-04-26 18:35:33',85,2,2,461,'1619480114602531001',0),(664,'2021-04-26 18:35:56',138,2,1,462,'16194801371220424348',0),(665,'2021-04-26 18:36:18',139,2,1,463,'1619480158264215137',0),(666,'2021-04-26 18:36:38',140,2,1,464,'1619480181496199470',0),(667,'2021-04-26 18:37:04',337,7,50,465,'1619480201129138376',0),(668,'2021-04-26 18:37:26',336,7,50,466,'1619480226227465996',0),(669,'2021-04-26 18:38:04',81,2,1,467,'1619480262855643938',0),(670,'2021-04-26 18:38:24',83,2,1,468,'1619480287164166246',0),(671,'2021-04-26 18:39:31',21,28,10,469,'16194803481084874237',0),(672,'2021-04-26 18:41:58',74,28,1,470,'1619480484938523149',0),(673,'2021-04-26 18:41:58',69,28,1,470,'1619480484938523149',0),(674,'2021-04-26 18:42:44',136,29,10,471,'1619480521421539329',0),(675,'2021-04-26 18:42:44',134,29,10,471,'1619480521421539329',0),(676,'2021-04-26 18:42:44',135,29,10,471,'1619480521421539329',0),(677,'2021-04-26 18:43:11',84,2,1,472,'1619480566310904620',0),(678,'2021-04-26 18:43:42',115,3,50,473,'1619480594367147158',0),(679,'2021-04-26 18:44:20',23,28,10,474,'16194806251148561273',0),(680,'2021-04-26 18:44:47',281,28,5,475,'1619480662737607762',0),(681,'2021-04-26 18:44:47',280,28,5,475,'1619480662737607762',0),(682,'2021-04-26 18:45:56',5,28,4,476,'1619480731440344218',0),(683,'2021-04-26 18:46:57',87,28,5,477,'16194807961270556373',0),(684,'2021-04-26 18:47:25',143,28,5,478,'1619480819781285020',0),(685,'2021-04-26 18:48:16',14,28,5,479,'1619480854822982816',0),(686,'2021-04-26 18:51:45',242,29,20,480,'16194809131009912874',0),(687,'2021-04-26 18:51:45',34,28,1,480,'16194809131009912874',0),(688,'2021-04-26 18:59:03',130,3,50,481,'16194815021121924600',0),(689,'2021-04-26 18:59:34',131,3,50,482,'1619481545838173035',0),(690,'2021-04-26 19:00:03',149,2,10,483,'1619481577563759366',0),(691,'2021-04-26 19:01:07',145,2,5,484,'16194816311087154921',0),(692,'2021-04-26 19:01:35',146,2,10,485,'1619481672284526138',0),(693,'2021-04-26 19:02:00',147,2,10,486,'1619481697294810734',0),(694,'2021-04-27 18:19:34',75,28,3,487,'1619565549636009727',0),(695,'2021-04-27 18:20:03',71,28,3,488,'1619565576107880676',0),(696,'2021-04-27 18:20:18',129,7,50,489,'1619565605445034682',0),(697,'2021-04-27 18:20:47',147,2,10,490,'1619565621352387257',0),(698,'2021-04-27 18:21:05',131,3,50,491,'1619565649195536414',0),(699,'2021-04-27 18:21:36',78,14,3,492,'1619565668661613637',0),(700,'2021-04-27 18:22:07',85,2,2,493,'1619565699379798502',0),(701,'2021-04-27 18:22:27',87,28,5,494,'1619565730109300725',0),(702,'2021-04-27 18:22:49',118,3,50,495,'16195657491363031671',0),(703,'2021-04-27 18:23:16',149,2,10,496,'1619565773112011727',0),(704,'2021-04-27 18:23:35',138,2,1,497,'16195657981192754912',0),(705,'2021-04-27 18:24:05',130,3,50,498,'1619565817299673325',0),(706,'2021-04-27 18:24:28',145,2,5,499,'1619565847468357907',0),(707,'2021-04-27 18:25:07',74,28,2,500,'161956587486106595',0),(708,'2021-04-27 18:25:42',2,28,2,501,'1619565910469734924',0),(709,'2021-04-27 18:25:58',129,7,50,502,'161956594575133491',0),(710,'2021-04-27 18:26:37',3,28,3,503,'1619565961554636629',0),(711,'2021-04-27 18:27:15',10,28,3,504,'1619566003317230292',0),(712,'2021-04-27 18:27:41',18,28,3,505,'1619566038926517282',0),(713,'2021-04-27 18:28:10',5,28,3,506,'16195660681266425322',0),(714,'2021-04-27 18:28:39',14,28,3,507,'1619566093252983842',0),(715,'2021-04-27 18:30:04',302,28,5,508,'1619566175798755923',0),(716,'2021-04-27 18:31:02',83,2,1,509,'16195662421275332901',0),(717,'2021-04-27 18:31:34',14,28,3,510,'1619566265508463527',0),(718,'2021-04-27 18:32:07',14,28,3,511,'161956629679910018',0),(719,'2021-04-27 18:32:34',81,2,1,512,'161956633553187282',0),(720,'2021-04-27 18:33:01',20,28,5,513,'1619566357990505541',0),(721,'2021-04-27 18:33:22',82,2,1,514,'1619566383973938305',0),(722,'2021-04-29 13:35:07',129,7,50,515,'161972129256113443',0),(723,'2021-04-29 13:35:38',39,28,2,516,'1619721310400625884',0),(724,'2021-04-29 13:36:07',85,2,2,517,'16197213411127303573',0),(725,'2021-04-29 13:37:05',3,28,3,518,'1619721398518231742',0),(726,'2021-04-29 13:37:37',5,28,3,519,'16197214281395176411',0),(727,'2021-04-29 13:38:03',115,3,50,520,'1619721460538714870',0),(728,'2021-04-29 13:39:02',10,28,3,521,'1619721511999886469',0),(729,'2021-04-29 13:39:40',302,28,3,522,'1619721547754045903',0),(730,'2021-04-29 13:40:27',19,28,3,523,'16197215821283508939',0),(731,'2021-04-29 13:41:06',20,28,5,524,'1619721630666390164',0),(732,'2021-04-29 13:41:52',50,28,2,525,'16197216751048598445',0),(733,'2021-04-29 13:42:16',148,2,10,526,'1619721714581746651',0),(734,'2021-04-29 13:43:06',27,28,2,527,'16197217401288414562',0),(735,'2021-04-29 13:44:01',48,28,2,528,'16197217891070888908',0),(736,'2021-04-29 13:45:07',74,28,1,529,'1619721861121736910',0),(737,'2021-04-29 13:45:07',69,28,1,529,'1619721861121736910',0),(738,'2021-04-30 18:33:42',14,28,4,530,'1619825597562468413',0),(739,'2021-04-30 18:34:49',84,2,2,531,'16198256701246673734',0),(740,'2021-04-30 18:35:20',85,2,2,532,'16198256921283939257',0),(741,'2021-04-30 18:35:44',81,2,1,533,'1619825722303632249',0),(742,'2021-04-30 18:36:04',82,2,1,534,'16198257471109144161',0),(743,'2021-04-30 18:36:33',115,3,50,535,'16198257661009095270',0),(744,'2021-04-30 18:36:55',145,2,5,536,'161982579541353542',0),(745,'2021-04-30 18:37:15',87,28,5,537,'1619825818697028793',0),(746,'2021-04-30 18:37:36',87,28,5,538,'1619825837124792166',0),(747,'2021-04-30 18:38:01',110,31,1,539,'1619825858994335369',0),(748,'2021-04-30 18:38:20',78,14,3,540,'1619825883498394091',0),(749,'2021-04-30 18:38:43',131,3,60,541,'1619825903492498737',0),(750,'2021-04-30 18:39:10',116,3,50,542,'1619825926841228292',0),(751,'2021-04-30 18:39:39',14,28,3,543,'1619825953527053257',0),(752,'2021-04-30 18:40:14',25,28,6,544,'1619825982303933471',0),(753,'2021-04-30 18:40:31',129,7,50,545,'1619826018108181898',0),(754,'2021-04-30 18:40:52',130,3,60,546,'1619826034150180917',0),(755,'2021-04-30 18:41:09',134,29,20,547,'16198260551387990104',0),(756,'2021-04-30 18:41:43',249,29,30,548,'161982607112823471',0),(757,'2021-04-30 18:42:09',385,29,20,549,'16198261101356146586',0),(758,'2021-04-30 18:42:29',23,28,10,550,'161982613165666499',0),(759,'2021-04-30 18:43:00',117,3,50,551,'1619826151742599449',0),(760,'2021-04-30 18:43:29',32,28,2,552,'16198261831201963714',0),(761,'2021-04-30 18:44:06',29,28,1,553,'1619826212557132472',0),(762,'2021-04-30 18:44:37',57,28,1,554,'16198262501033365195',0),(763,'2021-04-30 18:45:04',22,28,10,555,'1619826280732788203',0),(764,'2021-04-30 18:45:32',151,14,5,556,'1619826307259610737',0),(765,'2021-04-30 18:46:20',19,28,4,557,'1619826340642765717',0),(766,'2021-04-30 18:47:06',10,28,3,558,'16198263831371594995',0),(767,'2021-04-30 18:47:32',14,28,5,559,'1619826430757875731',0),(768,'2021-04-30 18:48:03',127,2,3,560,'1619826455386468428',0),(769,'2021-04-30 18:48:31',320,2,2,561,'1619826485902591612',0),(770,'2021-04-30 18:49:04',19,28,5,562,'16198265171012451749',0),(771,'2021-04-30 18:49:39',25,28,5,563,'161982654731972614',0),(772,'2021-04-30 18:50:08',42,28,2,564,'1619826582982587693',0),(773,'2021-04-30 18:50:42',137,29,30,565,'161982662567904151',0),(774,'2021-04-30 18:51:26',314,14,3,566,'16198266451008707984',0),(775,'2021-04-30 18:51:51',296,14,3,567,'1619826689497318296',0),(776,'2021-04-30 18:52:23',286,30,8,568,'1619826713935338797',0),(777,'2021-04-30 18:53:24',148,14,2,569,'16198267711072868370',0),(778,'2021-04-30 18:53:39',129,7,50,570,'1619826806694360822',0),(779,'2021-04-30 18:54:12',118,3,50,571,'1619826821350321731',0),(780,'2021-04-30 18:54:35',43,28,2,572,'1619826854526709003',0),(781,'2021-04-30 18:55:04',295,2,2,573,'1619826878594139804',0),(782,'2021-04-30 18:55:33',241,29,20,574,'1619826911857623400',0),(783,'2021-04-30 18:55:55',85,2,2,575,'1619826935826253232',0),(784,'2021-04-30 18:56:17',128,7,100,576,'1619826958270196555',0),(785,'2021-04-30 18:56:49',313,2,8,577,'1619826980389093366',0),(786,'2021-04-30 18:57:20',5,28,5,578,'16198270121185095255',0),(787,'2021-04-30 18:57:55',124,2,5,579,'16198270461140299171',0),(788,'2021-04-30 18:59:18',384,3,50,580,'1619827132200915387',0),(789,'2021-04-30 18:59:45',297,2,5,581,'1619827161980436104',0),(790,'2021-04-30 19:00:34',142,14,2,582,'1619827188229918808',0),(791,'2021-04-30 19:00:34',86,14,2,582,'1619827188229918808',0),(792,'2021-04-30 19:01:12',149,2,10,583,'1619827237501664506',0),(793,'2021-04-30 19:02:03',150,14,3,584,'1619827302381347646',0),(794,'2021-04-30 19:02:41',32,28,2,585,'1619827325856676701',0),(795,'2021-05-04 17:31:43',361,28,5,586,'1620167468808050788',0),(796,'2021-05-04 17:32:03',129,7,50,587,'1620167507903495279',0),(797,'2021-05-04 17:40:37',78,14,1,588,'1620167526228025409',0),(798,'2021-05-04 17:40:37',79,14,1,588,'1620167526228025409',0),(799,'2021-05-04 17:40:56',129,7,50,589,'1620168041314002908',0),(800,'2021-05-04 17:41:38',146,2,5,590,'1620168059365167696',0),(801,'2021-05-04 17:41:38',148,2,5,590,'1620168059365167696',0),(802,'2021-05-04 17:42:20',87,28,3,591,'1620168101960813612',0),(803,'2021-05-04 17:42:20',88,28,3,591,'1620168101960813612',0),(804,'2021-05-04 17:42:48',83,2,1,592,'1620168142687733928',0),(805,'2021-05-04 17:43:19',22,28,10,593,'16201681711260960286',0),(806,'2021-05-04 17:53:29',138,2,1,594,'1620168788516553502',0),(807,'2021-05-04 17:53:54',85,2,2,595,'1620168812694834172',0),(808,'2021-05-04 17:56:22',84,2,1,596,'1620168961498738345',0),(809,'2021-05-04 17:58:31',117,3,50,597,'1620169075202292404',0),(810,'2021-05-04 18:00:40',69,28,1,598,'1620169204576195551',0),(811,'2021-05-04 18:00:40',74,28,1,598,'1620169204576195551',0),(812,'2021-05-04 18:01:30',145,2,3,599,'16201692421314750012',0),(813,'2021-05-04 18:01:57',115,3,50,600,'16201692931178941711',0),(814,'2021-05-04 18:14:13',241,29,10,601,'1620170034495855215',0),(815,'2021-05-11 18:47:41',142,2,2,602,'1620776551608899705',0),(816,'2021-05-11 18:55:48',17,28,3,603,'1620777326651974518',0),(817,'2021-05-11 18:56:11',14,28,3,604,'162077735145183371',0),(818,'2021-05-11 18:56:35',3,28,3,605,'1620777373421410234',0),(819,'2021-05-11 18:56:52',129,7,50,606,'16207773991231913833',0),(820,'2021-05-11 18:57:22',14,28,3,607,'16207774151043348568',0),(821,'2021-05-11 18:57:50',85,2,2,608,'16207774451154069341',0),(822,'2021-05-11 18:58:21',116,3,50,609,'1620777472972991606',0),(823,'2021-05-11 18:58:50',117,3,50,610,'16207775031208934862',0),(824,'2021-05-11 18:59:15',41,28,2,611,'1620777533784426340',0),(825,'2021-05-11 18:59:48',4,28,4,612,'16207775581193529484',0),(826,'2021-05-11 19:00:12',115,3,50,613,'1620777590687733928',0),(827,'2021-05-11 19:00:37',145,14,2,614,'1620777615804823405',0),(828,'2021-05-11 19:01:07',282,3,30,615,'1620777639919589165',0),(829,'2021-05-11 19:01:32',114,2,5,616,'162077766961707575',0),(830,'2021-05-21 19:01:15',129,7,50,617,'1621641660874147604',0),(831,'2021-05-21 19:01:39',131,3,50,618,'1621641678997003340',0),(832,'2021-05-21 19:02:17',78,14,1,619,'1621641702336422466',0),(833,'2021-05-21 19:02:17',79,14,1,619,'1621641702336422466',0),(834,'2021-05-21 19:02:17',80,14,1,619,'1621641702336422466',0),(835,'2021-05-21 19:02:41',301,3,50,620,'1621641740559886506',0),(836,'2021-05-21 19:03:18',152,28,1,621,'1621641764229316363',0),(837,'2021-05-21 19:03:18',34,28,1,621,'1621641764229316363',0),(838,'2021-05-21 19:04:07',85,2,2,622,'16216418001009525588',0),(839,'2021-05-21 19:04:40',75,28,3,623,'1621641852671769137',0),(840,'2021-05-21 19:05:01',83,2,1,624,'1621641883364565251',0),(841,'2021-05-21 19:05:26',148,2,10,625,'1621641903123759403',0),(842,'2021-05-21 19:08:59',84,2,1,626,'1621642119713509965',0),(843,'2021-05-21 19:09:28',17,28,3,627,'1621642142816312890',0),(844,'2021-05-21 19:09:49',37,28,1,628,'1621642170399377962',0),(845,'2021-05-21 19:11:37',148,14,2,629,'1621642192504977953',0),(846,'2021-05-21 19:12:05',117,3,50,630,'16216423001287596958',0),(847,'2021-05-21 19:12:30',85,2,2,631,'1621642332886239535',0),(848,'2021-05-21 19:13:09',74,28,1,632,'162164235264203418',0),(849,'2021-05-21 19:13:09',2,28,1,632,'162164235264203418',0),(850,'2021-05-21 19:14:36',245,29,20,633,'16216424561378996461',0),(851,'2021-05-21 19:15:13',326,29,15,634,'16216424781249169578',0),(852,'2021-05-21 19:17:18',17,28,3,635,'1621642538685496275',0),(853,'2021-05-21 19:18:16',21,28,10,636,'16216426401001564708',0),(854,'2021-05-21 19:19:45',5,28,4,637,'1621642700662302145',0),(855,'2021-05-21 19:20:52',64,28,1,638,'16216427881209451243',0),(856,'2021-05-21 19:20:52',11,28,1,638,'16216427881209451243',0),(857,'2021-05-21 19:28:28',16,28,1,639,'1621643282177247907',0),(858,'2021-05-21 19:29:43',87,28,5,640,'16216433651191205768',0),(859,'2021-05-21 19:30:12',143,28,5,641,'1621643386219332989',0),(860,'2021-05-21 19:30:41',116,3,50,642,'1621643415445378936',0),(861,'2021-05-21 19:31:32',346,28,3,643,'162164346262180924',0),(862,'2021-05-21 19:32:02',119,3,50,644,'16216434951034397957',0),(863,'2021-05-22 18:20:05',12,28,1,645,'1621725502504504604',0),(864,'2021-05-22 18:20:05',3,28,1,645,'1621725502504504604',0),(865,'2021-05-22 18:20:05',76,28,1,645,'1621725502504504604',0),(866,'2021-05-22 18:21:59',17,28,4,646,'1621725610981597962',0),(867,'2021-05-22 18:23:51',74,28,1,647,'16217257461140815552',0),(868,'2021-05-22 18:23:51',2,28,1,647,'16217257461140815552',0),(869,'2021-05-22 18:24:38',25,28,5,648,'16217258351189355402',0),(870,'2021-05-22 18:25:43',22,28,10,649,'1621725881992657130',0),(871,'2021-05-22 18:26:46',10,28,3,650,'16217259471208117258',0),(872,'2021-05-22 18:27:21',148,2,10,651,'16217260091366345118',0),(873,'2021-05-22 18:28:12',78,14,1,652,'1621726044633729043',0),(874,'2021-05-22 18:28:12',79,14,1,652,'1621726044633729043',0),(875,'2021-05-22 18:28:12',80,14,1,652,'1621726044633729043',0),(876,'2021-05-22 18:29:20',87,28,5,653,'1621726098590309975',0),(877,'2021-05-22 18:29:51',115,3,50,654,'1621726163561005332',0),(878,'2021-05-22 18:30:18',41,28,2,655,'1621726194232801937',0),(879,'2021-05-22 18:31:08',364,3,50,656,'16217262211325464926',0),(880,'2021-05-22 18:31:34',114,2,5,657,'16217262711254161264',0),(881,'2021-05-22 18:32:36',136,29,10,658,'162172630125302688',0),(882,'2021-05-22 18:32:36',137,29,10,658,'162172630125302688',0),(883,'2021-05-22 18:32:36',134,29,10,658,'162172630125302688',0),(884,'2021-05-22 18:33:08',88,28,5,659,'1621726360529420005',0),(885,'2021-05-22 18:36:17',29,28,1,660,'1621726536623616574',0),(886,'2021-05-22 18:37:03',18,28,3,661,'1621726584910423396',0),(887,'2021-05-22 18:38:01',28,28,1,662,'162172663333779949',0),(888,'2021-05-22 18:39:08',47,28,2,663,'1621726684531786753',0),(889,'2021-05-22 18:40:27',118,3,50,664,'1621726770489787734',0),(890,'2021-05-22 18:41:37',131,3,50,665,'1621726861789159836',0),(891,'2021-05-22 18:42:29',296,14,1,666,'1621726904203411230',0),(892,'2021-05-22 18:42:29',314,14,1,666,'1621726904203411230',0),(893,'2021-05-22 18:43:14',302,28,5,667,'1621726958802112402',0),(894,'2021-05-22 18:44:44',27,28,1,668,'1621726997869069854',0),(895,'2021-05-22 18:44:44',32,28,1,668,'1621726997869069854',0),(896,'2021-05-22 18:47:29',23,28,10,669,'16217272081047350524',0),(897,'2021-05-22 18:47:52',129,7,50,670,'16217272518778484',0),(898,'2021-05-22 18:48:36',85,2,2,671,'1621727280928711903',0),(899,'2021-05-24 18:53:15',81,2,1,672,'1621900374798024383',0),(900,'2021-05-24 18:53:36',85,2,2,673,'1621900397856891860',0),(901,'2021-05-24 18:53:59',84,2,1,674,'1621900418737908985',0),(902,'2021-05-24 18:54:27',20,28,5,675,'1621900441220796070',0),(903,'2021-05-24 18:54:55',78,14,2,676,'1621900470208273822',0),(904,'2021-05-24 18:54:55',79,14,1,676,'1621900470208273822',0),(905,'2021-05-24 18:55:18',87,28,5,677,'16219004981122570077',0),(906,'2021-05-24 18:55:41',14,28,5,678,'1621900520971571557',0),(907,'2021-05-24 18:56:00',129,7,50,679,'1621900544652404836',0),(908,'2021-05-24 18:56:23',82,2,1,680,'16219005631235872757',0),(909,'2021-05-24 18:56:52',19,28,4,681,'1621900586765535388',0),(910,'2021-05-24 18:57:14',88,28,5,682,'1621900615902849802',0),(911,'2021-05-24 18:57:38',131,3,50,683,'1621900636907669362',0),(912,'2021-05-24 18:58:10',3,28,3,684,'162190066167129579',0),(913,'2021-05-24 18:58:34',297,2,5,685,'1621900693123673340',0),(914,'2021-05-24 18:58:55',34,28,2,686,'1621900716527440543',0),(915,'2021-05-24 18:59:49',10,28,3,687,'1621900768217869909',0),(916,'2021-05-24 19:00:15',148,2,10,688,'1621900791549515847',0),(917,'2021-05-24 19:00:47',119,3,50,689,'16219008171108885971',0),(918,'2021-05-24 19:01:15',116,3,50,690,'1621900851764244435',0),(919,'2021-05-24 19:01:43',340,28,1,691,'16219008781057204802',0),(920,'2021-05-24 19:02:15',29,28,1,692,'1621900905376915372',0),(921,'2021-05-24 19:02:46',4,28,5,693,'1621900938112140822',0),(922,'2021-05-24 19:03:15',120,3,50,694,'1621900968378894834',0),(923,'2021-05-24 19:03:38',148,14,2,695,'1621900997339649850',0),(924,'2021-05-24 19:04:07',138,1,1,696,'16219010241062712869',0),(925,'2021-05-24 19:04:34',139,2,1,697,'16219010491373875679',0),(926,'2021-05-24 19:05:02',140,2,2,698,'1621901077410695320',0),(927,'2021-05-24 19:06:20',80,14,1,699,'16219011541408731422',0),(928,'2021-05-24 19:06:42',83,2,1,700,'1621901183388146667',0),(929,'2021-05-24 19:07:09',144,28,5,701,'1621901204366759872',0),(930,'2021-05-24 19:07:37',151,14,3,702,'1621901231630759850',0),(931,'2021-05-24 19:08:30',143,28,5,703,'1621901285777326096',0),(932,'2021-05-24 19:10:51',50,2,3,704,'16219013681016281578',0),(933,'2021-05-24 19:11:45',153,28,1,705,'1621901454328590682',0),(934,'2021-05-24 19:12:14',302,28,10,706,'16219015101360363700',0),(935,'2021-05-26 11:47:43',85,2,1,707,'16220473861263327034',0),(936,'2021-05-26 11:47:43',83,2,1,707,'16220473861263327034',0),(937,'2021-05-26 11:47:43',2,11,10,707,'16220473861263327034',0),(938,'2021-05-26 11:47:43',10,2,1,707,'16220473861263327034',0),(939,'2021-05-26 11:47:43',136,29,1,707,'16220473861263327034',0),(940,'2021-05-26 13:09:11',3,28,3,708,'16220525001309801357',0),(941,'2021-05-26 13:09:47',129,7,50,709,'16220525541103291839',0),(942,'2021-05-26 13:10:42',148,2,10,710,'1622052590302341295',0),(943,'2021-05-26 13:11:34',138,2,1,711,'1622052648774573',0),(944,'2021-05-26 13:12:10',131,3,50,712,'162205271253918822',0),(945,'2021-05-26 13:13:05',20,28,5,713,'1622052750571591150',0),(946,'2021-05-26 13:14:24',10,28,3,714,'16220528251254462487',0),(947,'2021-05-26 13:15:33',143,28,5,715,'16220528681196326550',0),(948,'2021-05-26 13:16:11',85,2,2,716,'1622052936837742717',0),(949,'2021-05-26 13:20:30',74,28,1,717,'1622053108664884052',0),(950,'2021-05-26 13:20:30',64,28,1,717,'1622053108664884052',0),(951,'2021-05-26 13:23:03',302,28,5,718,'1622053316643927575',0),(952,'2021-05-26 13:24:29',19,28,4,719,'1622053387442969156',0),(953,'2021-05-26 13:25:01',24,28,5,720,'1622053472483462063',0),(954,'2021-05-26 13:25:59',83,2,1,721,'1622053545195622478',0),(955,'2021-05-26 13:26:34',37,28,2,722,'16220535621102129981',0),(956,'2021-05-26 13:28:12',30,28,2,723,'1622053597541124649',0),(957,'2021-05-26 13:29:05',50,28,2,724,'16220536971248481069',0),(958,'2021-05-26 13:30:15',131,3,50,725,'1622053748583510954',0),(959,'2021-05-26 13:34:08',78,14,1,726,'1622053818427305588',0),(960,'2021-05-26 13:34:08',79,14,1,726,'1622053818427305588',0),(961,'2021-05-26 13:34:08',80,14,1,726,'1622053818427305588',0),(962,'2021-05-26 13:34:41',26,28,2,727,'16220540521197359313',0),(963,'2021-05-26 13:35:06',117,3,50,728,'16220540841300463461',0),(964,'2021-05-26 13:37:34',115,3,50,729,'1622054109474382357',0),(965,'2021-05-26 13:38:04',118,3,50,730,'1622054261993474734',0),(966,'2021-05-26 13:38:38',19,28,2,731,'16220542871122613109',0),(967,'2021-05-26 13:39:24',16,28,1,732,'1622054326507129542',0),(968,'2021-05-26 13:39:51',81,2,1,733,'1622054367883872787',0),(969,'2021-05-26 13:40:23',143,28,5,734,'16220543941223909922',0),(970,'2021-05-27 15:43:00',350,5,6,735,'16221479231363246830',0),(971,'2021-05-27 15:43:00',74,11,3,735,'16221479231363246830',0),(972,'2021-05-27 15:43:00',64,11,2,735,'16221479231363246830',0),(973,'2021-05-27 15:51:17',74,28,1,736,'1622148418854869366',0),(974,'2021-05-27 15:51:17',2,28,1,736,'1622148418854869366',0),(975,'2021-05-27 15:51:17',138,2,1,736,'1622148418854869366',0),(976,'2021-05-27 18:32:37',25,28,5,737,'1622158287645218528',0),(977,'2021-05-27 18:33:05',10,28,3,738,'1622158362805253722',0),(978,'2021-05-27 18:33:30',129,7,50,739,'1622158394968129014',0),(979,'2021-05-27 18:34:04',148,2,10,740,'1622158413734337347',0),(980,'2021-05-27 18:34:30',85,2,2,741,'16221584491116588660',0),(981,'2021-05-27 18:35:35',27,28,2,742,'16221584761003415075',0),(982,'2021-05-27 18:36:00',114,2,5,743,'1622158538599561808',0),(983,'2021-05-27 18:36:56',78,14,1,744,'16221585621078677660',0),(984,'2021-05-27 18:36:56',79,14,1,744,'16221585621078677660',0),(985,'2021-05-27 18:36:56',87,28,3,744,'16221585621078677660',0),(986,'2021-05-27 18:37:38',115,3,50,745,'16221586271357179348',0),(987,'2021-05-27 18:38:27',149,2,10,746,'1622158680548353989',0),(988,'2021-05-27 18:38:55',152,28,2,747,'1622158711517069884',0),(989,'2021-05-27 18:39:23',34,28,2,748,'1622158737259524673',0),(990,'2021-05-27 18:40:14',17,28,3,749,'1622158792582263032',0),(991,'2021-05-27 18:40:38',5,28,5,750,'1622158817348428333',0),(992,'2021-05-27 18:41:03',138,2,1,751,'1622158841999284024',0),(993,'2021-05-27 18:41:39',250,14,1,752,'162215886643548163',0),(994,'2021-05-27 18:41:39',251,14,1,752,'162215886643548163',0),(995,'2021-05-27 18:42:26',33,28,2,753,'16221589021261906985',0),(996,'2021-05-27 18:42:48',83,2,1,754,'16221589541192582785',0),(997,'2021-05-27 18:43:16',144,28,5,755,'1622158971468573066',0),(998,'2021-05-27 18:44:00',140,2,1,756,'1622159004116271873',0),(999,'2021-05-27 18:44:00',141,2,1,756,'1622159004116271873',0),(1000,'2021-05-27 18:45:17',326,29,10,757,'16221590531263370065',0),(1001,'2021-05-27 18:45:17',241,29,10,757,'16221590531263370065',0),(1002,'2021-05-27 18:45:50',88,28,5,758,'1622159127493875754',0),(1003,'2021-05-27 18:47:38',391,1,2,759,'16221591531149206750',0),(1004,'2021-05-27 18:47:38',387,1,2,759,'16221591531149206750',0),(1005,'2021-05-27 18:48:57',124,2,1,760,'1622159261776293334',0),(1006,'2021-05-27 18:48:57',125,2,1,760,'1622159261776293334',0),(1007,'2021-05-27 18:48:57',127,2,1,760,'1622159261776293334',0),(1008,'2021-05-27 18:48:57',320,2,1,760,'1622159261776293334',0),(1009,'2021-05-27 18:49:30',281,28,5,761,'1622159345964858599',0),(1010,'2021-05-27 18:49:30',280,28,5,761,'1622159345964858599',0),(1011,'2021-05-29 18:12:58',19,28,4,762,'16223299271035818006',0),(1012,'2021-05-29 18:14:08',10,28,3,763,'1622329981780166194',0),(1013,'2021-05-29 18:16:58',119,3,50,764,'16223301921391088392',0),(1014,'2021-05-29 18:17:39',25,28,5,765,'1622330220688637595',0),(1015,'2021-05-29 18:18:11',14,28,5,766,'16223302621022262995',0),(1016,'2021-05-29 18:18:40',3,28,3,767,'1622330294776379397',0),(1017,'2021-05-29 18:19:09',18,28,3,768,'1622330322616903616',0),(1018,'2021-05-29 18:19:38',25,28,5,769,'1622330352703612655',0),(1019,'2021-05-29 18:20:11',250,14,1,770,'1622330381927248822',0),(1020,'2021-05-29 18:20:11',251,14,1,770,'1622330381927248822',0),(1021,'2021-05-29 18:20:48',14,28,1,771,'16223304141354769569',0),(1022,'2021-05-29 18:20:48',346,28,1,771,'16223304141354769569',0),(1023,'2021-05-29 18:21:16',138,2,1,772,'1622330451705549085',0),(1024,'2021-05-29 18:21:42',139,2,1,773,'162233047978145715',0),(1025,'2021-05-29 18:22:10',85,2,2,774,'1622330509708948596',0),(1026,'2021-05-29 18:22:39',302,28,5,775,'1622330533891962762',0),(1027,'2021-05-29 18:23:32',50,28,2,776,'162233056279479700',0),(1028,'2021-05-29 18:25:37',115,3,50,777,'1622330615864207263',0),(1029,'2021-05-29 18:26:21',364,3,50,778,'162233075751121757',0),(1030,'2021-05-29 18:26:54',44,28,2,779,'16223307841055612626',0),(1031,'2021-05-29 18:28:18',74,28,1,780,'16223308171014086957',0),(1032,'2021-05-29 18:28:18',69,28,1,780,'16223308171014086957',0),(1033,'2021-05-29 18:28:45',85,2,2,781,'1622330905221742769',0),(1034,'2021-05-29 18:29:02',83,2,1,782,'1622330928211286046',0),(1035,'2021-05-29 18:29:22',295,2,1,783,'162233094663557941',0),(1036,'2021-05-29 18:29:53',82,2,1,784,'1622330974575334915',0),(1037,'2021-05-29 18:30:37',21,28,10,785,'1622330996494392135',0),(1038,'2021-05-29 18:32:42',134,29,20,786,'1622331142630716818',0),(1039,'2021-05-29 18:33:15',50,28,2,787,'16223311651044639521',0),(1040,'2021-05-29 18:35:02',112,2,1,788,'1622331205343737869',0),(1041,'2021-05-29 18:35:02',113,2,1,788,'1622331205343737869',0),(1042,'2021-05-29 18:35:02',124,2,1,788,'1622331205343737869',0),(1043,'2021-05-29 18:35:02',125,2,1,788,'1622331205343737869',0),(1044,'2021-05-29 18:35:02',127,2,1,788,'1622331205343737869',0),(1045,'2021-05-29 18:35:26',32,28,1,789,'1622331305221484578',0),(1046,'2021-05-29 18:35:53',246,29,20,790,'16223313331340870303',0),(1047,'2021-05-29 18:44:40',41,28,2,791,'16223318511334286441',0),(1048,'2021-05-29 18:45:16',301,3,50,792,'1622331882162918324',0),(1049,'2021-05-29 18:45:53',76,28,4,793,'1622331919215546193',0),(1050,'2021-05-29 18:46:26',392,28,2,794,'1622331956182540816',0),(1051,'2021-05-29 18:46:26',8,28,2,794,'1622331956182540816',0),(1052,'2021-05-29 18:47:01',345,28,1,795,'1622332001375839578',0),(1053,'2021-05-29 18:47:43',312,28,3,796,'1622332023871178411',0),(1054,'2021-05-29 18:48:21',282,3,50,797,'1622332078283622471',0),(1055,'2021-05-29 18:48:49',17,28,4,798,'1622332105975444417',0),(1056,'2021-05-29 18:49:25',16,28,1,799,'1622332143207714408',0),(1057,'2021-05-29 18:50:01',143,28,5,800,'1622332177889122664',0),(1058,'2021-05-29 18:50:29',144,28,5,801,'1622332204957973514',0),(1059,'2021-05-29 18:51:13',353,28,1,802,'1622332242835031715',0),(1060,'2021-05-29 18:51:37',351,28,1,803,'162233227690667964',0),(1061,'2021-05-29 18:52:01',361,28,5,804,'16223322991195336819',0),(1062,'2021-06-14 19:04:35',121,3,15,805,'16237154311357566634',0),(1063,'2021-06-14 19:05:13',19,28,1,806,'1623715477640054714',0),(1064,'2021-06-14 19:05:13',43,28,1,806,'1623715477640054714',0),(1065,'2021-06-14 19:05:49',12,28,1,807,'16237155161221414079',0),(1066,'2021-06-14 19:05:49',3,28,2,807,'16237155161221414079',0),(1067,'2021-06-14 19:07:01',14,28,5,808,'1623715587275919782',0),(1068,'2021-06-14 19:07:27',32,28,1,809,'1623715623695694807',0),(1069,'2021-06-14 19:07:58',78,14,2,810,'162371564925689974',0),(1070,'2021-06-14 19:07:58',79,14,1,810,'162371564925689974',0),(1071,'2021-06-14 19:08:14',129,7,50,811,'1623715681638591634',0),(1072,'2021-06-14 19:08:35',346,28,3,812,'162371569679135446',0),(1073,'2021-06-14 19:09:10',4,28,5,813,'1623715721706151530',0),(1074,'2021-06-14 19:09:36',302,28,5,814,'1623715753300189706',0),(1075,'2021-06-14 19:09:59',117,3,50,815,'162371577856801952',0),(1076,'2021-06-14 19:10:22',131,3,50,816,'1623715802497404360',0),(1077,'2021-06-14 19:10:54',136,29,20,817,'16237158251191076673',0),(1078,'2021-06-14 19:10:54',134,29,10,817,'16237158251191076673',0),(1079,'2021-06-14 19:11:22',138,2,1,818,'16237158641082077171',0),(1080,'2021-06-14 19:11:45',149,2,10,819,'1623715884560488951',0),(1081,'2021-06-14 19:12:33',64,28,1,820,'1623715908202077245',0),(1082,'2021-06-14 19:12:33',2,28,1,820,'1623715908202077245',0),(1083,'2021-06-14 19:12:56',87,28,5,821,'16237159561023984266',0),(1084,'2021-06-14 19:13:20',144,28,5,822,'1623715979145533485',0),(1085,'2021-06-14 19:14:04',81,2,1,823,'16237160031384074212',0),(1086,'2021-06-14 19:15:29',76,28,3,824,'16237160491198822393',0),(1087,'2021-06-14 19:15:59',152,28,2,825,'1623716132881979388',0),(1088,'2021-06-14 19:16:52',141,2,2,826,'1623716187143812213',0),(1089,'2021-06-14 19:17:14',139,2,1,827,'16237162151025576442',0),(1090,'2021-06-14 19:18:48',343,28,1,828,'16237162791254376423',0),(1091,'2021-06-14 19:18:48',55,28,1,828,'16237162791254376423',0),(1092,'2021-06-14 19:19:14',21,28,10,829,'1623716332388792144',0),(1093,'2021-06-14 19:19:42',39,28,1,830,'1623716356188995584',0),(1094,'2021-06-14 19:21:24',130,3,50,831,'1623716464262493866',0),(1095,'2021-06-14 19:21:51',346,28,3,832,'1623716486450069400',0),(1096,'2021-06-14 19:22:30',34,28,1,833,'16237165161027254682',0),(1097,'2021-06-18 19:14:43',4,28,5,834,'1624061574999240992',0),(1098,'2021-06-18 19:23:15',346,28,4,835,'1624061687593150073',0),(1099,'2021-06-18 19:29:08',319,28,2,836,'1624062199740576955',0),(1100,'2021-06-18 19:29:08',42,28,1,836,'1624062199740576955',0),(1101,'2021-06-18 19:29:48',346,28,4,837,'1624062552791827807',0),(1102,'2021-06-18 19:39:23',129,7,50,838,'16240631431031729987',0),(1103,'2021-06-18 19:40:23',82,2,1,839,'1624063165701202875',0),(1104,'2021-06-18 19:40:48',148,2,10,840,'1624063228488324654',0),(1105,'2021-06-18 19:41:11',116,3,50,841,'1624063250440516345',0),(1106,'2021-06-18 19:41:32',131,3,50,842,'1624063274520641521',0),(1107,'2021-06-18 19:42:23',115,3,50,843,'1624063296773797490',0),(1108,'2021-06-18 19:44:03',27,28,1,844,'162406334650992661',0),(1109,'2021-06-18 19:44:03',14,28,2,844,'162406334650992661',0),(1110,'2021-06-18 19:44:46',17,28,4,845,'16240634461372842917',0),(1111,'2021-06-18 19:45:26',295,2,2,846,'162406348991313440',0),(1112,'2021-06-18 19:46:46',3,28,2,847,'16240635301336481062',0),(1113,'2021-06-21 19:20:30',123,3,30,848,'16243211991178081075',0),(1114,'2021-06-21 19:20:49',87,28,5,849,'16243212321032805782',0),(1115,'2021-06-21 19:21:05',129,7,50,850,'1624321252499340790',0),(1116,'2021-06-21 19:21:36',42,28,1,851,'16243212671141288902',0),(1117,'2021-06-21 19:21:36',36,28,1,851,'16243212671141288902',0),(1118,'2021-06-21 19:21:56',85,2,2,852,'16243212981407354405',0),(1119,'2021-06-21 19:22:20',113,2,5,853,'1624321320231209761',0),(1120,'2021-06-21 19:22:40',138,2,1,854,'1624321342823456166',0),(1121,'2021-06-21 19:23:43',67,28,1,855,'1624321362880688435',0),(1122,'2021-06-21 19:23:43',76,28,1,855,'1624321362880688435',0),(1123,'2021-06-21 19:23:43',346,28,1,855,'1624321362880688435',0),(1124,'2021-06-21 19:24:15',14,28,5,856,'16243214271123344649',0),(1125,'2021-06-21 19:24:41',120,3,50,857,'162432145717858190',0),(1126,'2021-06-21 19:24:59',81,2,1,858,'1624321484190458664',0),(1127,'2021-06-21 19:25:19',82,2,1,859,'16243215021128035113',0),(1128,'2021-06-21 19:25:41',81,2,1,860,'1624321521630028309',0),(1129,'2021-06-21 19:26:00',83,2,1,861,'16243215441031686955',0),(1130,'2021-06-21 19:29:48',74,28,1,862,'16243215631406020420',0),(1131,'2021-06-21 19:29:48',69,28,1,862,'16243215631406020420',0),(1132,'2021-06-21 19:30:14',8,28,3,863,'162432179132445964',0),(1133,'2021-06-21 19:30:37',139,2,1,864,'16243218171029018985',0),(1134,'2021-06-21 19:31:16',39,28,2,865,'16243218411288586689',0),(1135,'2021-06-21 19:31:42',140,2,2,866,'1624321882871479634',0),(1136,'2021-06-21 19:32:04',83,2,1,867,'1624321905616042980',0),(1137,'2021-06-21 19:32:29',144,28,5,868,'162432192719063080',0),(1138,'2021-06-21 19:32:51',88,28,5,869,'1624321952425971603',0),(1139,'2021-06-21 19:35:09',134,29,10,870,'1624322072817302621',0),(1140,'2021-06-21 19:35:09',136,29,10,870,'1624322072817302621',0),(1141,'2021-06-21 19:35:09',137,29,10,870,'1624322072817302621',0),(1142,'2021-06-21 19:35:36',143,28,5,871,'1624322112270067459',0),(1143,'2021-06-21 19:36:03',364,3,50,872,'1624322139318607309',0),(1144,'2021-06-21 19:36:24',118,3,60,873,'16243221651202953444',0),(1145,'2021-06-21 19:36:49',281,28,5,874,'16243221871175757359',0),(1146,'2021-06-21 19:36:49',280,28,5,874,'16243221871175757359',0),(1147,'2021-06-21 19:37:37',19,28,4,875,'1624322211891532444',0),(1148,'2021-06-24 19:09:57',75,28,3,876,'1624579770405187252',0),(1149,'2021-06-24 19:10:30',34,28,2,877,'1624579801102200481',0),(1150,'2021-06-24 19:10:48',129,7,50,878,'1624579833990075223',0),(1151,'2021-06-24 19:11:08',148,2,10,879,'1624579850564533938',0),(1152,'2021-06-24 19:11:29',14,28,5,880,'16245798701003242948',0),(1153,'2021-06-24 19:12:06',78,14,2,881,'1624579893434190673',0),(1154,'2021-06-24 19:12:06',79,14,2,881,'1624579893434190673',0),(1155,'2021-06-24 19:12:30',17,28,3,882,'162457992997423953',0),(1156,'2021-06-24 19:13:00',30,28,2,883,'162457995394626887',0),(1157,'2021-06-24 19:13:21',82,2,1,884,'16245799821033494290',0),(1158,'2021-06-24 19:13:46',3,28,3,885,'16245800031328993532',0),(1159,'2021-06-24 19:14:08',81,2,1,886,'1624580028337455229',0),(1160,'2021-06-24 19:14:46',14,28,5,887,'1624580054255565749',0),(1161,'2021-06-24 19:15:19',139,2,1,888,'1624580091296747164',0),(1162,'2021-06-24 19:15:48',8,28,3,889,'16245801221273009184',0),(1163,'2021-06-24 19:16:28',2,28,1,890,'16245801511169732909',0),(1164,'2021-06-24 19:16:28',74,28,1,890,'16245801511169732909',0),(1165,'2021-06-24 19:16:55',85,2,2,891,'16245801901057290865',0),(1166,'2021-06-24 19:17:18',139,2,1,892,'1624580217406047888',0),(1167,'2021-06-24 19:17:53',295,2,1,893,'1624580242786750057',0),(1168,'2021-06-24 19:17:53',84,2,1,893,'1624580242786750057',0),(1169,'2021-06-24 19:18:16',83,2,1,894,'1624580276230047903',0),(1170,'2021-06-24 19:18:41',144,28,5,895,'16245802981097869835',0),(1171,'2021-06-24 19:19:05',87,28,5,896,'1624580325642894812',0),(1172,'2021-06-24 19:19:27',41,28,2,897,'1624580347644702147',0),(1173,'2021-06-24 19:19:51',140,2,2,898,'16245803701225846352',0),(1174,'2021-06-24 19:20:18',143,28,5,899,'16245803931333727028',0),(1175,'2021-06-24 19:20:45',17,28,3,900,'1624580421626671830',0),(1176,'2021-06-25 22:46:44',337,7,50,901,'1624679182723622433',0),(1177,'2021-06-25 22:46:59',129,7,50,902,'1624679208805167659',0),(1178,'2021-06-25 22:47:30',78,14,1,903,'1624679222983835615',0),(1179,'2021-06-25 22:47:30',80,14,1,903,'1624679222983835615',0),(1180,'2021-06-25 22:47:57',131,3,50,904,'1624679254889294791',0),(1181,'2021-06-25 22:48:22',85,2,2,905,'1624679281629382833',0),(1182,'2021-06-25 22:48:48',17,28,3,906,'162467930654090949',0),(1183,'2021-06-25 22:49:28',74,28,1,907,'1624679330764846880',0),(1184,'2021-06-25 22:49:28',69,28,1,907,'1624679330764846880',0),(1185,'2021-06-25 22:49:55',116,3,50,908,'162467937273197060',0),(1186,'2021-06-25 22:50:22',83,2,1,909,'1624679402918513371',0),(1187,'2021-06-25 22:50:50',22,28,10,910,'1624679425223334945',0),(1188,'2021-06-25 22:51:16',10,28,3,911,'1624679454963395518',0),(1189,'2021-06-25 22:51:49',24,28,5,912,'16246794791116631691',0),(1190,'2021-06-25 22:52:30',152,28,1,913,'1624679512494478198',0),(1191,'2021-06-25 22:52:30',37,28,1,913,'1624679512494478198',0),(1192,'2021-06-25 22:53:20',81,2,1,914,'1624679552337369165',0),(1193,'2021-06-25 22:53:51',21,28,10,915,'1624679602268432252',0),(1194,'2021-06-25 22:54:15',138,2,1,916,'16246796371347798420',0),(1195,'2021-06-25 22:54:34',139,2,1,917,'162467965752843028',0),(1196,'2021-06-25 22:55:02',19,28,4,918,'16246796771014646370',0),(1197,'2021-06-25 22:55:18',129,7,50,919,'1624679704729905074',0),(1198,'2021-06-25 22:55:48',3,28,3,920,'1624679721297005354',0),(1199,'2021-06-25 22:56:07',82,2,1,921,'16246797511327831674',0),(1200,'2021-06-25 22:56:41',140,2,1,922,'16246797701374090838',0),(1201,'2021-06-25 22:56:41',141,2,1,922,'16246797701374090838',0),(1202,'2021-06-25 22:57:31',87,28,5,923,'16246798041171368117',0),(1203,'2021-06-25 22:57:57',144,28,5,924,'1624679854726720722',0),(1204,'2021-06-25 22:58:30',117,3,60,925,'16246798791154413595',0),(1205,'2021-06-25 22:58:56',135,29,10,926,'1624679913447874779',0),(1206,'2021-06-25 22:59:28',124,2,3,927,'16246799421192109436',0),(1207,'2021-06-25 23:00:00',34,28,2,928,'162467997162137893',0),(1208,'2021-06-28 22:43:16',129,7,50,929,'1624938184414094831',0),(1209,'2021-06-28 22:43:35',148,14,2,930,'1624938198348471365',0),(1210,'2021-06-28 22:44:07',78,14,1,931,'162493821746259165',0),(1211,'2021-06-28 22:44:07',79,14,1,931,'162493821746259165',0),(1212,'2021-06-28 22:44:57',116,3,50,932,'1624938249219548148',0),(1213,'2021-06-28 22:45:20',115,3,50,933,'1624938299534928073',0),(1214,'2021-06-28 22:45:55',392,28,1,934,'1624938323349116842',0),(1215,'2021-06-28 22:46:59',392,28,1,935,'1624938361132365760',0),(1216,'2021-06-28 22:46:59',312,28,1,935,'1624938361132365760',0),(1217,'2021-06-28 22:46:59',71,28,1,935,'1624938361132365760',0),(1218,'2021-06-28 22:47:29',14,28,5,936,'162493842165279213',0),(1219,'2021-06-28 22:47:55',3,28,3,937,'16249384541191205768',0),(1220,'2021-06-28 22:48:34',17,28,3,938,'1624938478219332989',0),(1221,'2021-06-28 22:48:58',148,2,10,939,'1624938517445249841',0),(1222,'2021-06-28 22:49:32',39,28,2,940,'1624938540876041003',0),(1223,'2021-06-28 22:50:12',34,28,1,941,'1624938575965116790',0),(1224,'2021-06-28 22:50:12',26,28,1,941,'1624938575965116790',0),(1225,'2021-06-28 22:50:34',84,2,1,942,'162493861862180924',0),(1226,'2021-06-28 22:50:55',83,2,1,943,'162493863710757946',0),(1227,'2021-06-28 22:51:16',85,2,1,944,'16249386571240735348',0),(1228,'2021-06-28 22:51:46',116,3,50,945,'1624938679637687966',0),(1229,'2021-06-28 22:52:13',251,14,3,946,'162493870862826401',0),(1230,'2021-06-28 22:52:36',138,2,1,947,'1624938736672543709',0),(1231,'2021-06-28 22:53:09',139,2,1,948,'16249387581059055168',0),(1232,'2021-06-28 22:53:49',50,28,2,949,'1624938791932154445',0),(1233,'2021-06-28 22:54:15',117,3,50,950,'16249388351036205292',0),(1234,'2021-06-28 22:54:42',20,28,5,951,'162493885939460144',0),(1235,'2021-06-28 22:55:07',114,2,5,952,'16249388841158716773',0),(1236,'2021-06-28 22:55:29',346,28,3,953,'1624938911310861588',0),(1237,'2021-06-28 22:56:11',131,3,50,954,'1624938953808222915',0),(1238,'2021-06-28 22:56:32',130,3,50,955,'1624938974189985315',0),(1239,'2021-06-28 22:57:25',353,28,1,956,'16249390171048254191',0),(1240,'2021-06-28 22:58:06',41,28,2,957,'1624939048835203842',0),(1241,'2021-06-28 22:58:35',352,28,1,958,'1624939088690057644',0),(1242,'2021-06-28 22:59:00',143,28,5,959,'1624939118871952983',0),(1243,'2021-06-28 22:59:29',88,28,5,960,'16249391431077644898',0),(1244,'2021-06-28 23:00:04',118,3,50,961,'1624939183747892358',0),(1245,'2021-06-28 23:00:29',146,2,10,962,'1624939206265204868',0),(1246,'2021-06-28 23:01:05',74,28,1,963,'1624939231898159338',0),(1247,'2021-06-28 23:01:05',64,28,1,963,'1624939231898159338',0),(1248,'2021-06-28 23:01:55',150,14,1,964,'1624939281496027343',0),(1249,'2021-06-28 23:01:55',151,14,1,964,'1624939281496027343',0),(1250,'2021-06-28 23:02:26',26,28,1,965,'1624939317372569162',0),(1251,'2021-06-28 23:02:26',17,28,2,965,'1624939317372569162',0),(1252,'2021-06-28 23:02:51',135,29,10,966,'1624939349731970599',0),(1253,'2021-06-28 23:03:20',14,28,3,967,'1624939379996659085',0),(1254,'2021-06-28 23:03:42',116,3,50,968,'16249394021359632160',0),(1255,'2021-06-28 23:04:24',74,28,1,969,'1624939428808007756',0),(1256,'2021-06-28 23:04:24',2,28,1,969,'1624939428808007756',0),(1257,'2021-06-29 19:47:31',44,28,2,970,'16250139421300893779',0),(1258,'2021-06-29 19:48:08',78,14,1,971,'1625014054111624441',0),(1259,'2021-06-29 19:48:08',79,14,1,971,'1625014054111624441',0),(1260,'2021-06-29 19:48:37',116,3,50,972,'16250140901233204787',0),(1261,'2021-06-29 19:49:02',149,2,10,973,'162501412065795594',0),(1262,'2021-06-29 19:49:16',129,7,50,974,'1625014145671123660',0),(1263,'2021-06-29 19:49:35',139,2,1,975,'1625014159118208304',0),(1264,'2021-06-29 19:50:00',85,2,2,976,'1625014178199237148',0),(1265,'2021-06-29 19:51:01',74,28,1,977,'1625014202814204333',0),(1266,'2021-06-29 19:51:01',69,28,1,977,'1625014202814204333',0),(1267,'2021-06-29 19:52:21',71,28,1,978,'162501426461793638',0),(1268,'2021-06-29 19:52:21',75,28,1,978,'162501426461793638',0),(1269,'2021-06-29 19:52:21',3,28,1,978,'162501426461793638',0),(1270,'2021-06-29 19:52:59',346,28,3,979,'1625014351304535916',0),(1271,'2021-06-29 19:53:45',19,28,3,980,'1625014382244549613',0),(1272,'2021-06-29 19:54:19',14,28,3,981,'16250144291052385242',0),(1273,'2021-06-29 19:54:42',138,2,1,982,'1625014462858484036',0),(1274,'2021-06-29 19:55:09',82,2,1,983,'16250144891085734872',0),(1275,'2021-06-29 19:55:31',83,2,1,984,'16250145121002210185',0),(1276,'2021-06-29 19:56:35',50,28,1,985,'1625014533209607807',0),(1277,'2021-06-29 19:56:35',41,28,1,985,'1625014533209607807',0),(1278,'2021-06-29 19:58:16',392,28,1,986,'1625014618703053242',0),(1279,'2021-06-29 19:58:16',10,28,1,986,'1625014618703053242',0),(1280,'2021-06-29 19:58:16',17,28,1,986,'1625014618703053242',0),(1281,'2021-06-29 19:58:46',81,1,5,987,'1625014699226132011',0),(1282,'2021-06-29 19:59:49',3,28,3,988,'1625014730375753514',0),(1283,'2021-06-29 20:00:20',21,28,10,989,'1625014792873803350',0),(1284,'2021-06-29 20:00:52',22,28,10,990,'16250148221287209672',0),(1285,'2021-06-29 20:01:25',113,2,5,991,'1625014859976434148',0),(1286,'2021-06-29 20:01:53',295,2,1,992,'162501488778403906',0),(1287,'2021-06-29 20:02:34',25,28,5,993,'1625014915366802904',0),(1288,'2021-06-29 20:03:23',27,28,1,994,'16250149571013441480',0),(1289,'2021-06-29 20:03:23',34,28,1,994,'16250149571013441480',0),(1290,'2021-06-29 20:03:54',127,2,2,995,'16250150061124377412',0),(1291,'2021-06-29 20:04:14',84,2,1,996,'1625015036151988252',0),(1292,'2021-06-29 20:05:07',353,28,1,997,'1625015078629081610',0),(1293,'2021-06-29 20:06:01',14,28,5,998,'1625015138463495316',0),(1294,'2021-06-29 20:06:31',19,28,4,999,'1625015167711272312',0),(1295,'2021-06-29 20:07:36',20,28,5,1000,'1625015206836839050',0),(1296,'2021-06-29 20:08:15',42,28,2,1001,'1625015259721642972',0),(1297,'2021-06-29 20:08:30',129,7,50,1002,'1625015297272132985',0),(1298,'2021-06-29 20:09:11',145,14,1,1003,'16250153131242456620',0),(1299,'2021-06-29 20:09:11',297,2,2,1003,'16250153131242456620',0),(1300,'2021-06-29 20:10:35',131,3,50,1004,'162501535421860145',0),(1301,'2021-06-29 20:11:29',126,2,1,1005,'1625015441871780856',0),(1302,'2021-06-29 20:11:29',125,2,1,1005,'1625015441871780856',0),(1303,'2021-06-29 20:11:29',124,2,1,1005,'1625015441871780856',0),(1304,'2021-06-29 20:12:01',115,3,50,1006,'1625015492341973566',0),(1305,'2021-06-29 20:13:10',21,28,10,1007,'1625015566133570649',0),(1306,'2021-06-29 20:13:41',34,28,2,1008,'16250156011005824855',0),(1307,'2021-06-29 20:14:06',140,2,2,1009,'16250156241350380327',0),(1308,'2021-06-29 20:14:30',88,28,5,1010,'1625015649696426348',0),(1309,'2021-06-29 20:14:55',144,28,5,1011,'16250156731388248294',0),(1310,'2021-06-29 20:16:05',337,7,50,1012,'1625015735240074308',0),(1311,'2021-06-29 20:16:30',336,7,50,1013,'1625015767400970138',0),(1312,'2021-06-29 20:17:00',146,2,10,1014,'16250157931205234129',0),(1313,'2021-06-29 20:17:31',25,28,5,1015,'1625015823513885532',0),(1314,'2021-06-29 20:18:42',136,29,20,1016,'1625015895167393629',0),(1315,'2021-06-29 20:18:42',134,29,10,1016,'1625015895167393629',0),(1316,'2021-06-29 20:19:12',132,2,5,1017,'16250159271084013601',0),(1317,'2021-06-29 20:19:50',282,3,30,1018,'16250159621043176441',0),(1318,'2021-06-29 20:20:18',117,3,50,1019,'1625015993769709471',0),(1319,'2021-06-29 20:20:40',87,28,5,1020,'1625016021909261538',0),(1320,'2021-06-29 20:21:04',143,28,5,1021,'1625016042922300167',0),(1321,'2021-06-30 18:42:07',41,28,2,1022,'1625096265160895830',0),(1322,'2021-06-30 18:43:41',116,3,50,1023,'16250965661239100141',0),(1323,'2021-06-30 18:43:58',129,7,50,1024,'1625096623961760311',0),(1324,'2021-06-30 18:44:22',148,2,10,1025,'1625096640806974994',0),(1325,'2021-06-30 18:44:47',138,2,1,1026,'1625096664462892871',0),(1326,'2021-06-30 18:45:11',3,28,3,1027,'1625096690290292397',0),(1327,'2021-06-30 18:45:47',85,2,2,1028,'16250967191074116292',0),(1328,'2021-06-30 18:46:32',114,2,5,1029,'1625096750919244911',0),(1329,'2021-06-30 18:55:21',129,7,50,1030,'162509730631241074',0),(1330,'2021-06-30 18:56:03',74,28,1,1031,'1625097324894243446',0),(1331,'2021-06-30 18:56:03',64,28,1,1031,'1625097324894243446',0),(1332,'2021-06-30 18:56:37',78,14,1,1032,'1625097366324976012',0),(1333,'2021-06-30 18:56:37',79,14,1,1032,'1625097366324976012',0),(1334,'2021-06-30 18:57:03',139,2,1,1033,'1625097400271960858',0),(1335,'2021-06-30 18:57:56',117,3,50,1034,'16250974261016884022',0),(1336,'2021-06-30 18:58:27',20,28,5,1035,'16250974811230795007',0),(1337,'2021-06-30 18:58:54',10,28,3,1036,'16250975091216379360',0),(1338,'2021-06-30 18:59:20',44,28,2,1037,'1625097540854008731',0),(1339,'2021-06-30 19:00:22',76,28,1,1038,'16250975631305196957',0),(1340,'2021-06-30 19:00:22',75,28,1,1038,'16250975631305196957',0),(1341,'2021-06-30 19:00:22',346,28,1,1038,'16250975631305196957',0),(1342,'2021-06-30 19:02:03',17,28,2,1039,'1625097642314992639',0),(1343,'2021-06-30 19:04:05',20,28,5,1040,'1625097726703784782',0),(1344,'2021-06-30 19:06:38',4,28,5,1041,'16250978631102732426',0),(1345,'2021-06-30 19:07:07',336,7,50,1042,'1625098005805899199',0),(1346,'2021-06-30 19:07:58',337,7,50,1043,'1625098030325922711',0),(1347,'2021-06-30 19:09:03',87,28,5,1044,'1625098124717727079',0),(1348,'2021-06-30 19:09:35',145,14,1,1045,'16250981461018390135',0),(1349,'2021-06-30 19:09:35',313,14,1,1045,'16250981461018390135',0),(1350,'2021-06-30 19:10:04',19,28,3,1046,'16250981781378480080',0),(1351,'2021-06-30 19:10:20',129,7,50,1047,'1625098207666175006',0),(1352,'2021-06-30 19:10:53',84,2,1,1048,'1625098223764760816',0),(1353,'2021-06-30 19:11:16',83,2,1,1049,'1625098256274413669',0),(1354,'2021-06-30 19:11:47',144,28,5,1050,'1625098284431909989',0),(1355,'2021-06-30 19:13:17',136,29,10,1051,'162509835518632762',0),(1356,'2021-06-30 19:13:17',134,29,10,1051,'162509835518632762',0),(1357,'2021-06-30 19:13:17',137,29,10,1051,'162509835518632762',0),(1358,'2021-06-30 19:13:52',41,28,2,1052,'1625098400947559823',0),(1359,'2021-06-30 19:14:17',87,28,5,1053,'162509843687311485',0),(1360,'2021-06-30 19:14:40',143,28,5,1054,'1625098461864078167',0),(1361,'2021-06-30 19:15:57',112,2,1,1055,'1625098493593881613',0),(1362,'2021-06-30 19:15:57',113,2,1,1055,'1625098493593881613',0),(1363,'2021-06-30 19:15:57',125,2,1,1055,'1625098493593881613',0),(1364,'2021-06-30 19:15:57',126,2,1,1055,'1625098493593881613',0),(1365,'2021-06-30 19:16:25',127,2,2,1056,'16250985601075278150',0),(1366,'2021-06-30 19:16:52',281,28,5,1057,'16250985881402793036',0),(1367,'2021-06-30 19:16:52',280,28,5,1057,'16250985881402793036',0),(1368,'2021-06-30 19:18:06',146,14,1,1058,'1625098644651802391',0),(1369,'2021-06-30 19:18:06',291,14,1,1058,'1625098644651802391',0),(1370,'2021-07-29 19:19:02',10,28,1,1059,'1627604270770096757',0),(1371,'2021-07-29 19:19:02',14,28,1,1059,'1627604270770096757',0),(1372,'2021-07-29 19:19:02',347,28,1,1059,'1627604270770096757',0),(1373,'2021-07-29 19:19:02',12,28,1,1059,'1627604270770096757',0),(1374,'2021-07-29 19:19:42',21,28,10,1060,'16276043441287812117',0),(1375,'2021-07-29 19:20:09',85,2,1,1061,'1627604385718802874',0),(1376,'2021-07-29 19:20:41',3,28,3,1062,'1627604412975788671',0),(1377,'2021-07-29 19:21:04',241,29,10,1063,'1627604444816528049',0),(1378,'2021-07-29 19:21:23',129,7,50,1064,'1627604466119413193',0),(1379,'2021-07-29 19:21:48',148,2,10,1065,'16276044851327573483',0),(1380,'2021-07-29 19:23:52',34,28,1,1066,'1627604511398646422',0),(1381,'2021-07-29 19:23:52',75,28,1,1066,'1627604511398646422',0),(1382,'2021-07-29 19:23:52',71,28,1,1066,'1627604511398646422',0),(1383,'2021-07-29 19:24:18',114,2,5,1067,'16276046381167710416',0),(1384,'2021-07-29 19:25:16',74,28,1,1068,'1627604670923031708',0),(1385,'2021-07-29 19:25:16',2,28,1,1068,'1627604670923031708',0),(1386,'2021-07-30 22:16:28',129,7,50,1069,'16277013731132940736',0),(1387,'2021-07-30 22:16:50',337,7,50,1070,'1627701390562769635',0),(1388,'2021-07-30 22:17:12',148,2,10,1071,'1627701412825521691',0),(1389,'2021-07-30 22:17:36',85,2,2,1072,'1627701434817302621',0),(1390,'2021-07-30 22:18:13',78,14,2,1073,'16277014591257431680',0),(1391,'2021-07-30 22:18:13',80,14,1,1073,'16277014591257431680',0),(1392,'2021-07-30 22:18:34',139,2,1,1074,'1627701495459020011',0),(1393,'2021-07-30 22:19:00',118,3,50,1075,'1627701517548310957',0),(1394,'2021-07-30 22:19:20',138,2,1,1076,'1627701543589664499',0),(1395,'2021-07-30 22:19:44',336,7,50,1077,'1627701563400109502',0),(1396,'2021-07-30 22:20:05',83,2,1,1078,'16277015871269050260',0),(1397,'2021-07-30 22:20:32',3,28,3,1079,'1627701610781457147',0),(1398,'2021-07-30 22:20:54',114,2,5,1080,'1627701634171395585',0),(1399,'2021-07-30 22:21:21',88,28,5,1081,'1627701657864723644',0),(1400,'2021-07-30 22:21:56',297,2,5,1082,'1627701684862529023',0),(1401,'2021-07-30 22:22:37',88,28,5,1083,'16277017331186041954',0),(1402,'2021-07-30 22:23:01',21,28,10,1084,'1627701759965331949',0),(1403,'2021-07-30 22:23:27',131,3,50,1085,'1627701783151730061',0),(1404,'2021-07-30 22:23:53',81,1,5,1086,'1627701809846736360',0),(1405,'2021-07-30 22:24:21',140,2,2,1087,'1627701836838603353',0),(1406,'2021-07-30 22:24:58',144,28,5,1088,'16277018691349433628',0),(1407,'2021-07-30 22:25:31',3,28,3,1089,'162770190184428355',0),(1408,'2021-07-30 22:26:09',116,3,50,1090,'16277019331179458092',0),(1409,'2021-07-30 22:26:49',19,28,4,1091,'16277019761282949526',0),(1410,'2021-07-30 22:27:59',74,28,1,1092,'1627702015300749119',0),(1411,'2021-07-30 22:27:59',69,28,1,1092,'1627702015300749119',0),(1412,'2021-07-30 22:30:01',112,2,1,1093,'1627702082432942751',0),(1413,'2021-07-30 22:30:01',111,2,1,1093,'1627702082432942751',0),(1414,'2021-07-30 22:30:01',126,2,1,1093,'1627702082432942751',0),(1415,'2021-07-30 22:30:01',124,2,1,1093,'1627702082432942751',0),(1416,'2021-07-30 22:30:01',125,2,1,1093,'1627702082432942751',0),(1417,'2021-07-30 22:30:33',245,29,10,1094,'162770221014458679',0),(1418,'2021-07-30 22:31:03',17,28,3,1095,'16277022361079667391',0),(1419,'2021-07-30 22:31:24',130,3,50,1096,'16277022651181867872',0),(1420,'2021-07-31 23:25:39',402,1,100,1097,'1627791813753228299',0),(1421,'2021-07-31 23:25:39',401,1,50,1097,'1627791813753228299',0),(1422,'2021-07-31 23:29:33',139,2,1,1098,'1627792154682053733',0),(1423,'2021-07-31 23:29:51',129,7,50,1099,'1627792177253112938',0),(1424,'2021-07-31 23:30:13',3,28,3,1100,'1627792194403939331',0),(1425,'2021-07-31 23:30:33',138,2,1,1101,'1627792216449165733',0),(1426,'2021-07-31 23:30:57',21,28,10,1102,'1627792235312238605',0),(1427,'2021-07-31 23:31:30',145,14,2,1103,'16277922601305971529',0),(1428,'2021-07-31 23:31:51',84,2,1,1104,'162779229391700726',0),(1429,'2021-07-31 23:32:11',85,2,2,1105,'16277923131394143648',0),(1430,'2021-07-31 23:32:55',74,28,1,1106,'16277923381175800391',0),(1431,'2021-07-31 23:32:55',69,28,1,1106,'16277923381175800391',0),(1432,'2021-07-31 23:33:17',83,2,1,1107,'1627792378263569660',0),(1433,'2021-07-31 23:33:41',116,3,50,1108,'16277923991100107487',0),(1434,'2021-07-31 23:34:03',144,28,5,1109,'1627792423166619057',0),(1435,'2021-07-31 23:34:28',88,28,5,1110,'16277924501260573000',0),(1436,'2021-07-31 23:35:05',140,2,2,1111,'16277924801380287415',0),(1437,'2021-07-31 23:35:30',5,28,5,1112,'16277925071201404300',0),(1438,'2021-07-31 23:36:17',10,28,3,1113,'1627792549828060567',0),(1439,'2021-07-31 23:36:43',17,28,4,1114,'16277925801170679609',0),(1440,'2021-07-31 23:37:19',26,28,1,1115,'1627792605266624917',0),(1441,'2021-07-31 23:37:19',3,28,1,1115,'1627792605266624917',0),(1442,'2021-07-31 23:37:47',22,28,10,1116,'16277926441295514806',0),(1443,'2021-07-31 23:38:13',149,2,10,1117,'1627792670515477708',0),(1444,'2021-07-31 23:38:45',43,28,2,1118,'1627792706160895830',0),(1445,'2021-07-31 23:39:05',87,28,5,1119,'1627792727939986229',0),(1446,'2021-07-31 23:39:35',302,28,4,1120,'1627792748875352494',0),(1447,'2021-07-31 23:39:59',134,29,10,1121,'16277927781391346583',0),(1448,'2021-07-31 23:39:59',136,29,10,1121,'16277927781391346583',0),(1449,'2021-07-31 23:40:25',326,29,10,1122,'1627792802487593113',0),(1450,'2021-08-24 21:43:04',10,28,4,1123,'162985935626378482',0),(1451,'2021-08-24 21:43:23',129,7,50,1124,'16298593882926162',0),(1452,'2021-08-24 21:44:19',145,14,1,1125,'1629859406216062574',0),(1453,'2021-08-24 21:44:19',291,14,1,1125,'1629859406216062574',0),(1454,'2021-08-24 21:44:19',293,14,1,1125,'1629859406216062574',0),(1455,'2021-08-24 21:44:39',85,2,2,1126,'162985946258178969',0),(1456,'2021-08-24 21:45:04',114,2,5,1127,'1629859483783909959',0),(1457,'2021-08-24 21:45:27',17,28,4,1128,'1629859507901946135',0),(1458,'2021-08-24 21:45:54',14,28,5,1129,'16298595291056215071',0),(1459,'2021-08-24 21:46:41',25,28,5,1130,'1629859567506225875',0),(1460,'2021-08-24 21:47:21',74,28,1,1131,'1629859605940631706',0),(1461,'2021-08-24 21:47:21',64,28,1,1131,'1629859605940631706',0),(1462,'2021-08-24 21:48:03',34,28,2,1132,'1629859647279061102',0),(1463,'2021-08-24 21:48:44',250,14,1,1133,'16298596861376672745',0),(1464,'2021-08-24 21:48:44',251,14,1,1133,'16298596861376672745',0),(1465,'2021-08-24 21:49:53',112,2,2,1134,'1629859727218773576',0),(1466,'2021-08-24 21:49:53',125,2,2,1134,'1629859727218773576',0),(1467,'2021-08-24 21:50:20',81,1,5,1135,'1629859797387931508',0),(1468,'2021-08-24 21:50:46',84,2,1,1136,'16298598241253171533',0),(1469,'2021-08-24 21:51:21',83,2,1,1137,'16298598551267544148',0),(1470,'2021-08-24 21:51:50',25,28,5,1138,'1629859884729087470',0),(1471,'2021-08-24 21:52:20',138,2,1,1139,'16298599181312039010',0),(1472,'2021-08-24 21:52:47',139,2,1,1140,'16298599431291684977',0),(1473,'2021-08-24 21:53:26',3,28,4,1141,'1629859970217310496',0),(1474,'2021-08-24 21:54:18',146,14,1,1142,'1629860009554980883',0),(1475,'2021-08-24 21:54:18',313,14,1,1142,'1629860009554980883',0),(1476,'2021-08-24 21:54:18',148,14,1,1142,'1629860009554980883',0),(1477,'2021-08-24 21:54:52',124,2,5,1143,'1629860061824316802',0),(1478,'2021-08-24 21:55:33',76,28,4,1144,'16298601061058323628',0),(1479,'2021-08-24 21:57:20',75,28,3,1145,'1629860137702407765',0),(1480,'2021-08-24 21:58:07',24,28,5,1146,'1629860248219074799',0),(1481,'2021-08-24 21:59:00',296,14,3,1147,'16298602941182771539',0),(1482,'2021-08-24 21:59:27',34,28,2,1148,'1629860343279061102',0),(1483,'2021-08-24 21:59:59',88,28,5,1149,'16298603731376672745',0),(1484,'2021-08-26 18:58:10',85,2,2,1150,'1630022264605629289',0),(1485,'2021-08-26 18:58:35',83,2,1,1151,'1630022293321490438',0),(1486,'2021-08-26 18:58:57',3,28,3,1152,'16300223195809291',0),(1487,'2021-08-26 18:59:13',129,7,50,1153,'1630022340860377434',0),(1488,'2021-08-26 18:59:36',139,2,1,1154,'1630022356477222454',0),(1489,'2021-08-26 19:00:06',24,28,5,1155,'1630022378294724670',0),(1490,'2021-08-26 19:00:28',84,2,1,1156,'1630022408862873278',0),(1491,'2021-08-26 19:01:05',302,28,5,1157,'1630022431630802881',0),(1492,'2021-08-26 19:01:30',145,14,2,1158,'16300224681363246830',0),(1493,'2021-08-26 19:01:52',139,2,1,1159,'1630022492963782804',0),(1494,'2021-08-26 19:02:26',19,28,5,1160,'1630022514425455221',0),(1495,'2021-08-26 19:02:48',87,28,5,1161,'1630022549219462085',0),(1496,'2021-08-26 19:03:10',87,28,5,1162,'1630022571873028778',0),(1497,'2021-08-26 19:03:33',140,2,2,1163,'1630022592530108513',0),(1498,'2021-08-26 19:04:01',78,14,1,1164,'1630022615596979901',0),(1499,'2021-08-26 19:04:01',79,14,1,1164,'1630022615596979901',0),(1500,'2021-08-26 19:04:39',346,28,4,1165,'1630022659540737363',0),(1501,'2021-08-26 19:05:01',353,28,1,1166,'1630022681774916317',0),(1502,'2021-08-26 19:05:29',27,28,2,1167,'1630022704331990193',0),(1503,'2021-08-26 19:05:58',3,28,4,1168,'1630022732469476734',0),(1504,'2021-08-26 19:06:12',129,7,50,1169,'163002276048755009',0),(1505,'2021-08-26 19:06:37',136,29,20,1170,'1630022774898718751',0),(1506,'2021-08-26 19:06:37',137,29,10,1170,'1630022774898718751',0),(1507,'2021-08-26 19:06:58',113,2,5,1171,'1630022799935683051',0),(1508,'2021-08-26 19:07:20',32,28,2,1172,'1630022820729474756',0),(1509,'2021-08-26 19:07:39',83,2,1,1173,'16300228421256571044',0),(1510,'2021-08-26 19:07:59',41,28,2,1174,'16300228621227868846',0),(1511,'2021-08-26 19:08:18',281,28,10,1175,'1630022881333797527',0),(1512,'2021-08-26 19:08:39',280,28,10,1176,'163002290045054275',0),(1513,'2021-08-26 19:09:00',81,1,5,1177,'16300229211009826810',0),(1514,'2021-08-26 19:09:19',87,28,5,1178,'16300229421235270312',0),(1515,'2021-08-26 19:09:39',21,28,10,1179,'1630022963129697789',0),(1516,'2021-08-26 19:10:04',75,28,3,1180,'1630022982355958895',0),(1517,'2021-08-26 19:11:05',29,28,1,1181,'1630023007709809232',0),(1518,'2021-08-26 19:11:34',74,28,1,1182,'16300230681250159308',0),(1519,'2021-08-26 19:11:34',64,28,1,1182,'16300230681250159308',0),(1520,'2021-08-26 19:12:02',82,1,5,1183,'16300230961283853193',0),(1521,'2021-08-26 19:12:30',76,28,5,1184,'16300231311047178396',0),(1522,'2021-08-26 19:13:01',298,29,20,1185,'16300231521073815069',0),(1523,'2021-08-26 19:13:43',69,28,1,1186,'1630023184475113897',0),(1524,'2021-08-26 19:13:43',16,28,1,1186,'1630023184475113897',0),(1525,'2021-08-26 19:14:07',39,28,2,1187,'16300232271278732411',0),(1526,'2021-08-26 19:14:31',10,28,3,1188,'16300232501167839511',0),(1527,'2021-08-26 19:15:21',2,28,1,1189,'16300232741081818980',0),(1528,'2021-08-26 19:15:21',11,28,1,1189,'16300232741081818980',0),(1529,'2021-08-26 19:15:50',62,28,5,1190,'1630023324778143700',0),(1530,'2021-08-26 19:16:18',136,29,20,1191,'1630023355849533425',0),(1531,'2021-08-26 19:16:18',134,29,20,1191,'1630023355849533425',0),(1532,'2021-08-26 19:16:50',241,29,20,1192,'1630023380881204816',0),(1533,'2021-08-26 19:17:13',124,2,5,1193,'1630023413462634680',0),(1534,'2021-08-26 19:17:44',127,2,3,1194,'16300234361089091351',0),(1535,'2021-08-26 19:18:07',125,2,5,1195,'1630023466992829257',0),(1536,'2021-08-26 19:18:21',129,7,50,1196,'1630023490589320244',0),(1537,'2021-08-26 19:18:47',149,2,10,1197,'1630023503247647901',0),(1538,'2021-08-26 19:19:11',151,2,4,1198,'1630023529690315835',0),(1539,'2021-08-26 19:19:43',18,28,4,1199,'16300235541066757857',0),(1540,'2021-08-26 19:20:06',118,3,50,1200,'1630023585345243981',0),(1541,'2021-08-26 19:20:28',88,28,5,1201,'1630023609577056187',0),(1542,'2021-08-26 19:21:22',25,28,5,1202,'1630023630941492342',0),(1543,'2021-08-31 21:08:06',116,3,50,1203,'16304620621400684479',0),(1544,'2021-08-31 21:08:25',129,7,50,1204,'1630462089511518784',0),(1545,'2021-08-31 21:09:04',74,28,1,1205,'1630462107787481597',0),(1546,'2021-08-31 21:09:04',2,28,1,1205,'1630462107787481597',0),(1547,'2021-08-31 21:09:29',3,28,3,1206,'16304621471145893303',0),(1548,'2021-08-31 21:09:51',85,2,2,1207,'1630462172804091864',0),(1549,'2021-08-31 21:11:31',250,14,3,1208,'1630462272733046394',0),(1550,'2021-08-31 21:12:00',10,28,3,1209,'16304622951051008225',0),(1551,'2021-08-31 21:12:20',138,2,1,1210,'163046232396606349',0),(1552,'2021-08-31 21:12:38',131,3,50,1211,'163046234378834224',0),(1553,'2021-08-31 21:13:01',78,14,3,1212,'16304623601311350501',0),(1554,'2021-08-31 21:13:29',23,28,10,1213,'1630462387209435680',0),(1555,'2021-08-31 21:14:50',8,28,3,1214,'1630462429848156408',0),(1556,'2021-08-31 21:15:21',26,28,2,1215,'1630462492462032235',0),(1557,'2021-08-31 21:15:59',34,28,2,1216,'1630462524829136361',0),(1558,'2021-08-31 21:16:21',83,2,1,1217,'1630462562346534935',0),(1559,'2021-08-31 21:16:41',84,2,1,1218,'1630462584898847847',0),(1560,'2021-08-31 21:18:12',21,28,10,1219,'1630462604682354955',0),(1561,'2021-08-31 21:18:56',17,28,5,1220,'16304626971225717257',0),(1562,'2021-08-31 21:19:53',130,3,50,1221,'1630462775420377471',0),(1563,'2021-08-31 21:21:16',81,1,5,1222,'1630462859692467424',0),(1564,'2021-08-31 21:21:35',139,2,1,1223,'1630462878737521699',0),(1565,'2021-08-31 21:22:08',298,29,20,1224,'16304628971252310898',0),(1566,'2021-08-31 21:22:44',134,29,20,1225,'1630462930880129022',0),(1567,'2021-08-31 21:22:44',136,29,10,1225,'1630462930880129022',0),(1568,'2021-08-31 21:23:07',143,28,5,1226,'1630462966889897236',0),(1569,'2021-08-31 21:24:13',79,14,2,1227,'1630463036410652289',0),(1570,'2021-08-31 21:24:35',144,28,5,1228,'1630463055430403876',0),(1571,'2021-08-31 21:25:07',141,2,2,1229,'16304630781396424333',0),(1572,'2021-08-31 21:25:32',87,28,5,1230,'1630463110456265977',0),(1573,'2021-08-31 21:26:07',3,28,3,1231,'16304631351363160766',0),(1574,'2021-08-31 21:26:49',85,2,2,1232,'16304631691198349044',0),(1575,'2021-08-31 21:27:47',297,2,7,1233,'1630463240240031276',0),(1576,'2021-08-31 21:28:35',115,3,50,1234,'1630463270148201455',0),(1577,'2021-08-31 21:29:14',25,28,5,1235,'163046333135587284',0),(1578,'2021-08-31 21:30:14',131,3,50,1236,'1630463357755552015',0),(1579,'2021-08-31 21:30:38',117,3,50,1237,'16304634171185310414',0),(1580,'2021-08-31 21:31:12',10,28,3,1238,'1630463441253887510',0),(1581,'2021-08-31 21:31:53',146,14,1,1239,'1630463479444303142',0),(1582,'2021-08-31 21:31:53',292,14,1,1239,'1630463479444303142',0),(1583,'2021-08-31 21:32:14',151,14,5,1240,'1630463515264043010',0),(1584,'2021-08-31 21:33:31',20,28,5,1241,'1630463537869026822',0),(1585,'2021-08-31 21:34:02',148,14,2,1242,'16304636161286865418',0),(1586,'2021-08-31 21:34:20',129,7,50,1243,'1630463644657009236',0),(1587,'2021-08-31 21:35:19',22,28,10,1244,'16304636761302615050',0),(1588,'2021-08-31 21:35:53',113,2,5,1245,'1630463722650468405',0),(1589,'2021-08-31 21:36:40',17,28,3,1246,'1630463757609803372',0),(1590,'2021-08-31 21:39:44',118,3,50,1247,'16304638611212463468',0),(1591,'2021-08-31 21:40:19',127,2,3,1248,'1630463994343823932',0),(1592,'2021-08-31 21:41:22',64,28,1,1249,'1630464031889768141',0),(1593,'2021-08-31 21:41:22',45,28,1,1249,'1630464031889768141',0),(1594,'2021-08-31 21:42:08',268,29,10,1250,'16304640971214141708',0),(1595,'2021-09-22 22:31:23',400,5,1,1251,'1632367809164596564',0),(1596,'2021-09-22 22:33:25',400,5,1,1252,'1632367942453598006',0),(1597,'2021-09-22 22:34:17',400,5,1,1253,'16323680081201490364',0),(1598,'2021-09-22 22:35:25',129,7,50,1254,'1632368109714843950',0),(1599,'2021-09-22 22:35:57',116,3,50,1255,'1632368127375753514',0),(1600,'2021-09-22 22:36:26',345,28,1,1256,'1632368161943729994',0),(1601,'2021-09-22 22:36:55',85,2,2,1257,'1632368189501965728',0),(1602,'2021-09-22 22:37:43',118,3,50,1258,'1632368217759683066',0),(1603,'2021-09-22 22:38:10',3,28,3,1259,'1632368265196095828',0),(1604,'2021-09-22 22:38:30',131,3,50,1260,'1632368292856762765',0),(1605,'2021-09-22 22:38:52',346,28,3,1261,'1632368313813128538',0),(1606,'2021-09-22 22:39:23',78,14,2,1262,'1632368334263655724',0),(1607,'2021-09-22 22:39:23',79,14,2,1262,'1632368334263655724',0),(1608,'2021-09-22 22:39:47',19,28,5,1263,'1632368365871780856',0),(1609,'2021-09-22 22:40:12',5,28,5,1264,'1632368389262752057',0),(1610,'2021-09-22 22:40:36',8,28,3,1265,'1632368415319510976',0),(1611,'2021-09-22 22:40:58',353,28,1,1266,'16323684381118998439',0),(1612,'2021-09-22 22:41:22',138,2,1,1267,'1632368460161713434',0),(1613,'2021-09-22 22:41:42',83,2,1,1268,'1632368485891145158',0),(1614,'2021-09-22 22:42:07',19,28,4,1269,'1632368504457298740',0),(1615,'2021-09-22 22:42:27',130,3,50,1270,'1632368529589277213',0),(1616,'2021-09-22 22:42:50',145,14,3,1271,'1632368549877073765',0),(1617,'2021-09-22 22:43:13',113,2,5,1272,'163236857363687037',0),(1618,'2021-09-22 22:43:39',3,28,3,1273,'1632368597333539337',0),(1619,'2021-09-22 22:44:02',151,14,5,1274,'1632368622573613644',0),(1620,'2021-09-22 22:44:29',25,28,5,1275,'1632368645968172046',0),(1621,'2021-09-22 22:44:56',25,28,5,1276,'16323686711403094259',0),(1622,'2021-09-22 22:45:19',88,28,5,1277,'1632368699675641997',0),(1623,'2021-09-22 22:45:40',81,1,5,1278,'163236872121558923',0),(1624,'2021-09-22 22:46:01',87,28,5,1279,'16323687431244479113',0),(1625,'2021-09-22 22:46:28',146,14,2,1280,'1632368764989429746',0),(1626,'2021-09-22 22:46:58',84,2,1,1281,'1632368790403638108',0),(1627,'2021-09-22 22:47:28',50,28,2,1282,'1632368828727624389',0),(1628,'2021-09-22 22:47:48',350,14,1,1283,'16323688501135350516',0),(1629,'2021-09-22 22:48:21',295,2,2,1284,'16323688711256226790',0),(1630,'2021-09-22 22:48:50',354,28,1,1285,'1632368903373257671',0),(1631,'2021-09-22 22:49:09',134,29,30,1286,'1632368933227595091',0),(1632,'2021-09-22 22:49:33',249,29,30,1287,'16323689511104195507',0),(1633,'2021-09-22 22:49:53',139,2,1,1288,'16323689751050491844',0),(1634,'2021-09-22 22:50:22',132,2,1,1289,'1632368996245582376',0),(1635,'2021-09-22 22:50:50',45,28,2,1290,'163236902989850360',0),(1636,'2021-09-22 22:51:28',74,28,1,1291,'1632369052527440543',0),(1637,'2021-09-22 22:51:28',64,28,1,1291,'1632369052527440543',0),(1638,'2021-09-22 22:51:55',115,3,50,1292,'1632369090363790679',0),(1639,'2021-09-22 22:52:26',29,28,1,1293,'1632369118838904575',0),(1640,'2021-09-22 22:53:32',2,28,1,1294,'1632369149390470383',0),(1641,'2021-09-22 22:53:32',11,28,1,1294,'1632369149390470383',0),(1642,'2021-09-22 22:54:01',148,14,2,1295,'1632369220411857179',0),(1643,'2021-09-22 22:54:23',22,28,10,1296,'1632369244764244435',0),(1644,'2021-09-22 22:55:03',281,28,10,1297,'16323692721227997941',0),(1645,'2021-09-22 22:55:31',153,28,2,1298,'1632369305581058142',0),(1646,'2021-09-22 22:55:56',75,28,3,1299,'1632369334604940781',0),(1647,'2021-09-22 22:56:27',136,29,40,1300,'1632369365930002856',0),(1648,'2021-09-22 22:56:58',21,28,10,1301,'1632369397917824862',0),(1649,'2021-09-22 22:57:31',39,28,2,1302,'1632369421133742777',0),(1650,'2021-09-23 22:23:14',115,3,52.8,1303,'1632453643972475224',0),(1651,'2021-09-23 22:26:51',34,28,2,1304,'1632453979853922667',0),(1652,'2021-09-23 22:27:14',302,28,5,1305,'1632454014263010247',0),(1653,'2021-09-23 22:27:53',5,28,3,1306,'1632454037293003399',0),(1654,'2021-09-23 22:28:39',78,14,2,1307,'16324540861125840493',0),(1655,'2021-09-23 22:28:39',79,14,2,1307,'16324540861125840493',0),(1656,'2021-09-23 22:29:05',3,28,3,1308,'163245412218546698',0),(1657,'2021-09-23 22:30:07',25,28,5,1309,'16324541471034742212',0),(1658,'2021-09-23 22:30:38',21,28,10,1310,'1632454213982028280',0),(1659,'2021-09-23 22:31:43',75,28,3,1311,'16324542411002812630',0),(1660,'2021-09-23 22:32:17',14,28,5,1312,'1632454306669488453',0),(1661,'2021-09-23 22:33:03',130,3,50,1313,'163245433986622976',0),(1662,'2021-09-23 22:33:26',148,2,10,1314,'1632454386728571088',0),(1663,'2021-09-23 22:34:44',138,2,1,1315,'1632454409591084547',0),(1664,'2021-09-23 22:36:09',139,2,1,1316,'16324544871318106491',0),(1665,'2021-09-23 22:36:42',26,28,1,1317,'1632454573543061079',0),(1666,'2021-09-23 22:37:17',152,28,3,1318,'163245460547679214',0),(1667,'2021-09-23 22:38:09',85,2,1,1319,'1632454643595602884',0),(1668,'2021-09-23 22:39:49',83,2,1,1320,'16324546911137545137',0),(1669,'2021-09-23 22:41:05',113,2,5,1321,'16324548381034311894',0),(1670,'2021-09-23 22:41:46',19,28,4,1322,'1632454868101856227',0),(1671,'2021-09-23 22:42:07',129,7,50,1323,'1632454912903839533',0),(1672,'2021-09-23 22:42:52',136,29,40,1324,'16324549291347884484',0),(1673,'2021-09-23 22:43:19',151,14,4,1325,'1632454979109300725',0),(1674,'2021-09-23 22:44:23',74,28,1,1326,'163245500232704154',0),(1675,'2021-09-23 22:44:23',2,28,1,1326,'163245500232704154',0),(1676,'2021-09-23 22:44:57',81,1,5,1327,'16324550671070931940',0),(1677,'2021-09-23 22:45:26',3,28,3,1328,'16324551051363031671',0),(1678,'2021-09-30 23:26:50',346,28,4,1329,'16330623891010859573',0),(1679,'2021-09-30 23:27:18',5,28,5,1330,'163306241231068947',0),(1680,'2021-09-30 23:28:54',81,1,6,1331,'16330625091053547100',0),(1681,'2021-09-30 23:29:40',85,2,2,1332,'1633062561394515371',0),(1682,'2021-09-30 23:30:11',116,3,50,1333,'1633062582625682099',0),(1683,'2021-09-30 23:30:32',353,28,1,1334,'1633062613638204348',0),(1684,'2021-09-30 23:30:53',3,28,3,1335,'1633062634353678210',0),(1685,'2021-09-30 23:31:33',10,28,4,1336,'1633062656372913417',0),(1686,'2021-09-30 23:31:56',117,3,60,1337,'1633062696841873768',0),(1687,'2021-09-30 23:32:17',82,1,6,1338,'16330627182538876',0),(1688,'2021-09-30 23:32:44',138,2,1,1339,'1633062739414051799',0),(1689,'2021-09-30 23:33:09',392,28,1,1340,'1633062766940674738',0),(1690,'2021-09-30 23:34:28',3,28,3,1341,'16330628141089779860',0),(1691,'2021-09-30 23:34:51',10,28,4,1342,'1633062871412416592',0),(1692,'2021-09-30 23:35:21',302,28,7,1343,'16330628931058194532',0),(1693,'2021-09-30 23:35:46',19,28,4,1344,'16330629231317245855',0),(1694,'2021-09-30 23:36:04',129,7,70,1345,'1633062948247604870',0),(1695,'2021-09-30 23:36:26',45,28,2,1346,'1633062966398000945',0),(1696,'2021-09-30 23:36:48',250,14,3,1347,'1633062988427477715',0),(1697,'2021-09-30 23:37:15',69,28,1,1348,'16330630101052256147',0),(1698,'2021-09-30 23:37:15',74,28,1,1348,'16330630101052256147',0),(1699,'2021-09-30 23:37:45',25,28,7,1349,'16330630391225028748',0),(1700,'2021-09-30 23:38:09',3,28,3,1350,'16330630671023467885',0),(1701,'2021-09-30 23:38:30',148,2,10,1351,'1633063091615827822',0),(1702,'2021-09-30 23:38:56',26,28,2,1352,'16330631121052901623',0),(1703,'2021-09-30 23:39:43',2,28,1,1353,'16330631381184363715',0),(1704,'2021-09-30 23:39:43',76,28,1,1353,'16330631381184363715',0),(1705,'2021-09-30 23:40:18',87,28,6,1354,'16330631901068565192',0),(1706,'2021-09-30 23:41:05',21,28,14,1355,'16330632211178683520',0),(1707,'2021-09-30 23:41:32',82,1,5,1356,'1633063268670564247',0),(1708,'2021-09-30 23:41:54',392,28,5,1357,'1633063295200097783',0),(1709,'2021-09-30 23:42:31',21,28,12,1358,'16330633161294826297',0),(1710,'2021-09-30 23:43:03',5,28,5,1359,'1633063359792946633',0),(1711,'2021-09-30 23:43:58',131,3,60,1360,'1633063420882323643',0),(1712,'2021-09-30 23:44:37',251,14,4,1361,'16330634411154929977',0),(1713,'2021-09-30 23:45:05',78,14,2,1362,'16330634791011289891',0),(1714,'2021-09-30 23:45:05',79,14,2,1362,'16330634791011289891',0),(1715,'2021-09-30 23:45:30',152,28,2,1363,'163306350966570166',0),(1716,'2021-09-30 23:45:52',83,2,1,1364,'163306353318159412',0),(1717,'2021-09-30 23:46:10',84,2,1,1365,'1633063554306386283',0),(1718,'2021-09-30 23:46:36',139,2,1,1366,'16330635811320860525',0),(1719,'2021-09-30 23:47:01',116,3,50,1367,'1633063599838818512',0),(1720,'2021-09-30 23:47:33',3,28,3,1368,'1633063623112226886',0),(1721,'2021-09-30 23:48:01',134,29,40,1369,'16330636621079323137',0),(1722,'2021-09-30 23:48:58',148,2,10,1370,'1633063685216665019',0),(1723,'2021-09-30 23:49:35',14,28,5,1371,'1633063740394085053',0),(1724,'2021-09-30 23:50:02',115,3,60,1372,'163306377848410754',0),(1725,'2021-09-30 23:50:27',131,3,60,1373,'1633063808611610707',0),(1726,'2021-09-30 23:51:16',21,28,14,1374,'1633063830230306094',0),(1727,'2021-10-25 20:00:35',138,2,1,1375,'1635210009269723205',0),(1728,'2021-10-25 20:01:34',129,7,50,1376,'1635210077131849378',0),(1729,'2021-10-25 20:15:25',145,14,2,1377,'16352108921107767144',0),(1730,'2021-10-25 20:15:51',85,2,1,1378,'1635210927759855193',0),(1731,'2021-10-25 20:23:00',150,14,3,1379,'1635211309646294323',0),(1732,'2021-10-25 20:23:30',291,14,2,1380,'16352113831080269836',0),(1733,'2021-10-25 20:23:54',151,14,4,1381,'1635211412842777436',0),(1734,'2021-10-25 20:24:22',292,14,2,1382,'16352114371355845363',0),(1735,'2021-10-25 20:42:01',293,14,2,1383,'1635211465674006790',0),(1736,'2021-10-25 20:42:29',146,14,2,1384,'16352125231024629743',0),(1737,'2021-10-25 20:42:53',27,28,2,1385,'1635212552341414153',0),(1738,'2021-10-25 20:43:53',147,2,10,1386,'1635212606775217539',0),(1739,'2021-10-25 20:44:45',5,28,5,1387,'1635212635496156438',0),(1740,'2021-10-25 20:45:48',148,14,2,1388,'16352126881092318735',0),(1741,'2021-10-25 20:46:19',361,28,5,1389,'1635212751968774491',0),(1742,'2021-10-25 20:47:00',3,28,3,1390,'1635212781267184330',0),(1743,'2021-10-25 20:47:26',139,2,1,1391,'1635212822918556402',0),(1744,'2021-10-25 20:47:58',349,14,1,1392,'1635212849222087023',0),(1745,'2021-10-25 20:49:01',347,28,3,1393,'1635212881745568642',0),(1746,'2021-10-25 20:49:35',346,28,4,1394,'1635212944814032206',0),(1747,'2021-10-25 20:50:53',392,28,4,1395,'1635212978423518791',0),(1748,'2021-10-25 20:51:33',3,28,3,1396,'1635213056206896805',0),(1749,'2021-10-25 20:52:23',302,28,5,1397,'1635213101873330000',0),(1750,'2021-10-25 20:53:31',10,28,3,1398,'1635213147981210676',0),(1751,'2021-10-25 20:54:24',19,28,4,1399,'1635213215159432750',0),(1752,'2021-10-25 20:55:12',250,14,3,1400,'1635213267987019966',0),(1753,'2021-10-25 20:55:53',20,28,5,1401,'16352133151025017029',0),(1754,'2021-10-25 20:56:31',79,14,4,1402,'1635213356698664000',0),(1755,'2021-10-25 20:57:48',19,28,4,1403,'1635213394872813619',0),(1756,'2021-10-25 20:58:54',34,28,2,1404,'1635213471760457638',0),(1757,'2021-10-25 20:59:50',30,28,3,1405,'1635213537383542267',0),(1758,'2021-10-25 21:00:56',36,28,3,1406,'163521359350992661',0),(1759,'2021-10-25 21:01:45',17,28,4,1407,'1635213659459407297',0),(1760,'2021-10-25 21:02:55',153,28,2,1408,'1635213714471025878',0),(1761,'2021-10-25 21:03:54',67,28,3,1409,'1635213778926861536',0),(1762,'2021-10-25 21:05:30',79,14,3,1410,'16352138371002855662',0),(1763,'2021-10-25 21:06:14',40,28,1,1411,'16352139341127432668',0),(1764,'2021-10-25 21:07:04',21,28,10,1412,'1635213985540393109',0),(1765,'2021-10-25 21:08:26',361,28,5,1413,'1635214028638118284',0),(1766,'2021-10-25 21:09:11',136,29,30,1414,'1635214115338961341',0),(1767,'2021-10-25 21:09:42',83,2,1,1415,'1635214154445465000',0),(1768,'2021-10-25 21:11:03',84,2,1,1416,'1635214185233060128',0),(1769,'2021-10-25 21:12:22',2,28,1,1417,'16352142691399694748',0),(1770,'2021-10-25 21:12:22',64,28,1,1417,'16352142691399694748',0),(1771,'2021-10-25 21:13:19',14,28,5,1418,'163521434616266014',0),(1772,'2021-10-25 21:14:35',24,28,5,1419,'1635214402827630249',0),(1773,'2021-10-25 21:15:44',44,28,2,1420,'16352144791082378394',0),(1774,'2021-10-25 21:16:48',2,28,1,1421,'16352145471011591113',0),(1775,'2021-10-25 21:16:48',71,28,1,1421,'16352145471011591113',0),(1776,'2021-10-25 21:17:40',88,28,5,1422,'16352146251073944164',0),(1777,'2021-10-25 21:18:16',87,28,5,1423,'1635214663976218989',0),(1778,'2021-10-25 21:19:12',312,28,3,1424,'1635214699964815567',0),(1779,'2021-10-25 21:20:04',42,28,2,1425,'16352147551071319226',0),(1780,'2021-10-25 21:20:54',16,28,1,1426,'16352148081169044401',0),(1781,'2021-10-25 21:21:45',8,28,3,1427,'16352148572409780',0),(1782,'2021-10-25 21:24:15',30,28,3,1428,'1635215016150094853',0),(1783,'2021-10-25 21:25:17',19,28,3,1429,'1635215058815151032',0),(1784,'2021-10-25 21:26:12',112,2,5,1430,'1635215126268174061',0),(1785,'2021-10-25 21:26:48',67,28,4,1431,'1635215176673791631',0),(1786,'2021-10-25 21:27:32',51,28,2,1432,'16352152111389022866',0),(1787,'2021-10-25 21:28:18',113,2,3,1433,'1635215254652749090',0),(1788,'2021-10-25 21:29:17',4,28,4,1434,'1635215311552269881',0),(1789,'2021-10-25 21:30:03',124,2,3,1435,'1635215367197300717',0),(1790,'2021-10-25 21:30:50',25,28,5,1436,'1635215407689240040',0),(1791,'2021-10-25 22:05:24',400,5,1,1437,'16352173301095847341',0),(1792,'2021-10-29 21:39:58',346,28,4,1438,'16355615671197746599',0),(1793,'2021-10-29 21:40:20',78,14,4,1439,'1635561601345674299',0),(1794,'2021-10-29 21:40:36',129,7,80,1440,'163556162218933984',0),(1795,'2021-10-29 21:40:56',79,14,3,1441,'16355616391012021431',0),(1796,'2021-10-29 21:42:17',276,2,10,1442,'1635561702394730530',0),(1797,'2021-10-29 21:42:55',3,28,3,1443,'16355617461000661041',0),(1798,'2021-10-29 21:43:44',8,28,3,1444,'1635561781873330000',0),(1799,'2021-10-29 21:44:12',312,28,2,1445,'163556182715319315',0),(1800,'2021-10-29 21:44:36',348,28,4,1446,'1635561855981210676',0),(1801,'2021-10-29 21:45:07',21,28,14,1447,'1635561878274155479',0),(1802,'2021-10-29 21:45:25',75,28,3,1448,'16355619091281916763',0),(1803,'2021-10-29 21:45:51',19,28,4,1449,'1635561927129826884',0),(1804,'2021-10-29 21:46:14',27,28,2,1450,'16355619531264704051',0),(1805,'2021-10-29 21:46:36',152,28,3,1451,'1635561976719964732',0),(1806,'2021-10-29 21:46:59',77,28,4,1452,'1635561998303158899',0),(1807,'2021-10-29 21:47:27',19,28,4,1453,'1635562022542114380',0),(1808,'2021-10-29 21:48:00',72,28,4,1454,'1635562050803145165',0),(1809,'2021-10-29 21:48:21',74,28,2,1455,'1635562083297995085',0),(1810,'2021-10-29 21:48:41',69,28,2,1456,'1635562103926043932',0),(1811,'2021-10-29 21:49:00',64,28,2,1457,'16355621231002855662',0),(1812,'2021-10-29 21:49:28',343,28,3,1458,'1635562143219246926',0),(1813,'2021-10-29 21:49:51',55,28,3,1459,'16355621711037668373',0),(1814,'2021-10-29 21:50:14',16,28,2,1460,'1635562193366114395',0),(1815,'2021-10-29 21:51:22',2,28,2,1461,'1635562218223248881',0),(1816,'2021-10-29 21:51:50',87,28,6,1462,'1635562285273983352',0),(1817,'2021-10-29 21:52:24',101,31,2,1463,'1635562313882495770',0),(1818,'2021-10-29 21:52:46',88,28,6,1464,'16355623461189183275',0),(1819,'2021-10-29 21:53:08',306,2,1,1465,'16355623691009826810',0),(1820,'2021-10-29 21:53:40',37,28,2,1466,'1635562390129697789',0),(1821,'2021-10-29 21:54:15',365,28,1,1467,'16355624241089091351',0),(1822,'2021-10-29 21:54:43',115,3,50,1468,'1635562459629813150',0),(1823,'2021-10-29 21:55:11',116,3,50,1469,'16355624931219262490',0),(1824,'2021-10-29 21:55:56',311,28,4,1470,'1635562513538628806',0),(1825,'2021-10-29 21:56:22',117,3,50,1471,'1635562559247217584',0),(1826,'2021-10-29 21:56:47',120,3,50,1472,'16355625841121236092',0),(1827,'2021-10-29 21:57:25',364,3,70,1473,'1635562609609114864',0),(1828,'2021-10-29 21:57:52',118,3,80,1474,'1635562648992829257',0),(1829,'2021-10-29 21:58:29',364,3,70,1475,'1635562675924236598',0),(1830,'2021-10-29 21:59:34',250,14,3,1476,'16355627151063014092',0),(1831,'2021-10-29 22:00:03',251,14,4,1477,'16355627771325206735',0),(1832,'2021-10-29 22:00:43',294,2,5,1478,'1635562819182669912',0),(1833,'2021-10-29 22:01:09',138,2,1,1479,'16355628461071319226',0),(1834,'2021-10-29 22:01:28',139,2,1,1480,'1635562872364264029',0),(1835,'2021-10-29 22:01:50',140,2,2,1481,'16355628901169044401',0),(1836,'2021-10-29 22:02:13',141,2,2,1482,'1635562913896954448',0),(1837,'2021-10-29 22:02:43',391,2,1,1483,'1635562935675297743',0),(1838,'2021-10-29 22:03:10',112,2,5,1484,'16355629651304078130',0),(1839,'2021-10-29 22:03:47',124,2,4,1485,'1635562992247346679',0),(1840,'2021-10-29 22:04:20',126,2,3,1486,'16355630301275548059',0),(1841,'2021-10-29 22:04:52',127,2,3,1487,'1635563063615655694',0),(1842,'2021-10-29 22:05:13',310,2,1,1488,'1635563094417236151',0),(1843,'2021-10-29 22:05:42',320,2,2,1489,'16355631161032117273',0),(1844,'2021-10-29 22:06:04',145,14,2,1490,'163556314528487040',0),(1845,'2021-10-29 22:06:23',150,14,3,1491,'16355631661225502098',0),(1846,'2021-10-29 22:06:46',291,14,2,1492,'1635563185764072308',0),(1847,'2021-10-29 22:07:08',292,14,2,1493,'1635563208726161309',0),(1848,'2021-10-29 22:07:33',293,14,2,1494,'16355632301005566664',0),(1849,'2021-10-29 22:07:55',146,14,2,1495,'1635563256195837637',0),(1850,'2021-10-29 22:08:22',148,14,2,1496,'16355632771101097218',0),(1851,'2021-10-29 22:08:44',149,14,2,1497,'1635563305254619050',0),(1852,'2021-10-29 22:09:08',313,14,2,1498,'16355633261030783288',0),(1853,'2021-10-29 22:09:30',151,14,4,1499,'163556335089204883',0),(1854,'2021-10-29 22:10:02',297,2,7,1500,'1635563372415945198',0),(1855,'2021-10-29 22:10:25',382,14,3,1501,'16355634051389022866',0),(1856,'2021-10-29 22:10:55',29,28,1,1502,'1635563434678008745',0),(1857,'2021-10-29 22:11:17',28,28,1,1503,'16355634571364408688',0),(1858,'2021-10-29 22:11:55',59,28,1,1504,'1635563496291239096',0),(1859,'2021-10-29 22:12:19',353,28,1,1505,'1635563517197300717',0),(1860,'2021-10-29 22:12:51',85,2,1,1506,'1635563541863992104',0),(1861,'2021-10-29 22:13:10',83,2,1,1507,'16355635741097697708',0),(1862,'2021-10-29 22:13:33',84,2,1,1508,'1635563592787997978',0),(1863,'2021-10-29 22:13:59',295,2,2,1509,'1635563615232758905',0),(1864,'2021-10-29 22:14:24',82,1,6,1510,'1635563642674996521',0),(1865,'2021-10-29 22:14:57',81,1,6,1511,'16355636661083583283',0),(1866,'2021-10-29 22:15:43',281,28,8,1512,'1635563708843422912',0),(1867,'2021-10-29 22:16:14',280,28,8,1513,'1635563746474812674',0),(1868,'2021-10-29 22:16:38',326,29,20,1514,'1635563777106675786',0),(1869,'2021-10-29 22:17:17',245,29,25,1515,'16355638001143698682',0),(1870,'2021-10-29 22:17:58',136,29,40,1516,'1635563840785975484',0),(1871,'2021-10-29 22:18:23',385,29,20,1517,'16355638801303131431',0),(1872,'2021-10-29 22:18:48',134,29,40,1518,'1635563905343307551',0),(1873,'2021-10-29 22:19:19',137,29,30,1519,'163556393150691439',0),(1874,'2021-10-29 22:19:49',268,29,25,1520,'1635563961717210698',0),(1875,'2021-10-29 22:20:29',143,28,6,1521,'16355639971044639521',0),(1876,'2021-10-29 22:20:54',144,28,6,1522,'163556403143634227',0),(1877,'2021-10-29 22:25:30',296,14,3,1523,'16355643071098988661',0),(1878,'2021-10-29 22:25:52',314,14,3,1524,'16355643338305134',0),(1879,'2021-10-29 22:26:40',1,2,8,1525,'1635564364317273323',0),(1880,'2021-10-29 22:27:12',331,2,5,1526,'1635564403223076754',0),(1881,'2021-10-29 22:27:43',264,2,10,1527,'16355644351334286441',0),(1882,'2021-10-31 19:22:31',346,28,4,1528,'1635726131219720275',0),(1883,'2021-10-31 19:23:05',340,28,1,1529,'1635726154264903646',0),(1884,'2021-10-31 19:23:26',129,7,50,1530,'16357261871343667369',0),(1885,'2021-10-31 19:23:53',344,28,1,1531,'16357262091325852212',0),(1886,'2021-10-31 19:24:20',392,28,4,1532,'1635726235617549093',0),(1887,'2021-10-31 19:24:44',353,28,1,1533,'16357262631379684970',0),(1888,'2021-10-31 19:25:13',354,28,1,1534,'1635726287864508485',0),(1889,'2021-10-31 19:25:47',347,2,10,1535,'1635726315668756912',0),(1890,'2021-10-31 19:26:27',3,28,3,1536,'1635726349286720759',0),(1891,'2021-10-31 19:26:54',5,28,4,1537,'16357263901408344136',0),(1892,'2021-10-31 19:27:40',361,28,4,1538,'1635726416559843474',0),(1893,'2021-10-31 19:28:11',5,28,4,1539,'1635726463480191647',0),(1894,'2021-10-31 19:28:52',10,28,4,1540,'1635726494863088436',0),(1895,'2021-10-31 19:29:40',7,28,3,1541,'1635726535463968666',0),(1896,'2021-10-31 19:30:31',312,28,3,1542,'1635726604222646437',0),(1897,'2021-10-31 19:31:04',274,2,10,1543,'1635726633286978949',0),(1898,'2021-10-31 19:32:09',302,28,5,1544,'1635726667680332462',0),(1899,'2021-10-31 19:32:44',17,28,4,1545,'16357267321229030704',0),(1900,'2021-10-31 19:33:15',352,28,1,1546,'1635726768815581350',0),(1901,'2021-10-31 19:35:06',17,28,4,1547,'1635726832311033715',0),(1902,'2021-10-31 19:36:34',25,28,6,1548,'16357269541046102602',0),(1903,'2021-10-31 19:38:28',26,28,2,1549,'16357269981275677155',0),(1904,'2021-10-31 19:45:50',34,28,2,1550,'16357275241283465907',0),(1905,'2021-10-31 19:46:28',152,28,3,1551,'16357275531103291839',0),(1906,'2021-10-31 19:47:20',398,1,1,1552,'16357275911407698660',0),(1907,'2021-10-31 19:47:50',74,28,2,1553,'16357276441031471796',0),(1908,'2021-10-31 19:48:20',69,28,2,1554,'1635727672918857625',0),(1909,'2021-10-31 19:49:22',39,28,2,1555,'1635727702319295817',0),(1910,'2021-10-31 19:49:45',69,28,2,1556,'1635727764673189186',0),(1911,'2021-10-31 19:50:13',64,28,2,1557,'16357277871197101122',0),(1912,'2021-10-31 19:50:40',75,28,3,1558,'1635727815595344694',0),(1913,'2021-10-31 19:51:13',21,28,14,1559,'16357278421251966643',0),(1914,'2021-10-31 19:51:39',11,28,2,1560,'1635727876184778469',0),(1915,'2021-10-31 19:52:46',64,28,2,1561,'16357279451170335354',0),(1916,'2021-10-31 19:53:26',343,28,3,1562,'1635727969187274312',0),(1917,'2021-10-31 19:53:59',2,28,2,1563,'1635728009446454731',0),(1918,'2021-10-31 19:54:52',10,28,3,1564,'16357280411270384246',0),(1919,'2021-10-31 19:54:52',76,28,3,1564,'16357280411270384246',0),(1920,'2021-10-31 19:55:15',23,28,10,1565,'1635728094396107547',0),(1921,'2021-10-31 19:56:03',250,14,4,1566,'16357281221032763',0),(1922,'2021-10-31 19:56:36',251,14,3,1567,'16357281651155016040',0),(1923,'2021-10-31 19:57:03',132,2,5,1568,'1635728199978671801',0),(1924,'2021-10-31 19:57:35',138,2,1,1569,'16357282251262638525',0),(1925,'2021-10-31 19:58:07',138,2,1,1570,'1635728257634331487',0),(1926,'2021-10-31 19:58:41',140,2,2,1571,'1635728290302341295',0),(1927,'2021-10-31 19:59:09',141,2,2,1572,'16357283231012193558',0),(1928,'2021-10-31 19:59:44',114,2,3,1573,'1635728351787352501',0),(1929,'2021-10-31 20:00:33',387,2,1,1574,'1635728386136841065',0),(1930,'2021-10-31 20:01:11',112,2,5,1575,'1635728437829351520',0),(1931,'2021-10-31 20:03:52',124,2,4,1576,'1635728610130085075',0),(1932,'2021-10-31 20:04:33',125,2,3,1577,'163572863457576524',0),(1933,'2021-10-31 20:05:10',126,2,3,1578,'16357286761254505518',0),(1934,'2021-10-31 20:05:43',127,2,3,1579,'16357287131145161762',0),(1935,'2021-10-31 20:06:09',320,2,2,1580,'1635728747610965230',0),(1936,'2021-10-31 20:06:39',86,14,2,1581,'16357287711393369076',0),(1937,'2021-10-31 20:07:18',87,28,6,1582,'1635728802413578450',0),(1938,'2021-10-31 20:07:50',88,28,6,1583,'1635728840783780864',0),(1939,'2021-10-31 20:08:35',81,1,5,1584,'1635728873962663978',0),(1940,'2021-10-31 20:09:37',82,1,6,1585,'16357289191032633654',0),(1941,'2021-10-31 20:10:16',83,2,1,1586,'1635728979406133952',0),(1942,'2021-10-31 20:10:41',84,2,1,1587,'1635729018644443956',0),(1943,'2021-10-31 20:11:05',85,2,1,1588,'1635729044714198473',0),(1944,'2021-10-31 20:12:56',295,2,1,1589,'16357290681172874229',0),(1945,'2021-10-31 20:13:21',326,29,20,1590,'1635729180162100720',0),(1946,'2021-10-31 20:13:47',281,28,8,1591,'163572920348152564',0),(1947,'2021-10-31 20:14:26',280,28,8,1592,'163572922933478726',0),(1948,'2021-10-31 20:15:12',245,29,20,1593,'163572929582405862',0),(1949,'2021-10-31 20:15:39',136,29,20,1594,'16357293141269695737',0),(1950,'2021-10-31 20:16:51',241,29,20,1595,'163572934169410264',0),(1951,'2021-10-31 20:17:38',78,14,4,1596,'1635729419936457623',0),(1952,'2021-10-31 20:18:49',79,14,3,1597,'1635729461745654705',0),(1953,'2021-10-31 20:19:18',80,14,1,1598,'1635729532642077208',0),(1954,'2021-10-31 20:19:42',115,3,50,1599,'1635729561741480623',0),(1955,'2021-10-31 20:20:06',116,3,50,1600,'16357295851338288396',0),(1956,'2021-10-31 20:20:30',117,3,60,1601,'1635729609735068887',0),(1957,'2021-10-31 20:21:04',118,3,60,1602,'1635729633551021959',0),(1958,'2021-10-31 20:21:25',311,28,5,1603,'16357296681204932906',0),(1959,'2021-10-31 20:21:54',145,14,2,1604,'1635729687325363298',0),(1960,'2021-10-31 20:22:22',150,14,3,1605,'1635729716887057139',0),(1961,'2021-10-31 20:23:09',291,14,2,1606,'16357297451394789125',0),(1962,'2021-10-31 20:23:37',292,14,2,1607,'1635729791447272334',0),(1963,'2021-10-31 20:24:02',146,14,2,1608,'16357298211331575439',0),(1964,'2021-10-31 20:24:26',147,2,10,1609,'16357298451121365187',0),(1965,'2021-10-31 20:24:54',148,14,2,1610,'16357298691105271301',0),(1966,'2021-10-31 20:25:22',148,14,2,1611,'16357298961075794531',0),(1967,'2021-10-31 20:25:48',149,14,2,1612,'16357299251286176909',0),(1968,'2021-10-31 20:26:13',313,14,2,1613,'16357299511141719220',0),(1969,'2021-10-31 20:26:37',151,14,4,1614,'16357299751237421901',0),(1970,'2021-10-31 20:27:06',297,2,8,1615,'16357300001044596490',0),(1971,'2021-10-31 20:27:34',382,14,3,1616,'1635730029740964241',0);
/*!40000 ALTER TABLE `operacion_almacen_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `operacion_caja`
--

DROP TABLE IF EXISTS `operacion_caja`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operacion_caja` (
  `opecaj_codi` int(11) NOT NULL AUTO_INCREMENT,
  `opecaj_fechahora` datetime DEFAULT NULL,
  `opecaj_fecha` date DEFAULT NULL,
  `opecaj_numero` varchar(45) DEFAULT NULL,
  `per_codi_fk` int(11) DEFAULT NULL,
  `opecajtip_codi_fk` int(11) NOT NULL DEFAULT '0',
  `opecaj_estado` int(11) NOT NULL DEFAULT '1',
  `opecaj_anulado` int(11) NOT NULL DEFAULT '0',
  `opecaj_monto` float NOT NULL DEFAULT '0',
  `opecaj_anotaciones` text,
  `opecaj_usu_crea` varchar(45) DEFAULT NULL,
  `opecaj_usu_modifica` varchar(45) DEFAULT NULL,
  `opecaj_usu_activa` varchar(45) DEFAULT NULL,
  `idtrans` varchar(45) DEFAULT NULL,
  `medpag_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  `caj_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`opecaj_codi`),
  KEY `fk_operacion_caja_personas1_idx` (`per_codi_fk`),
  CONSTRAINT `fk_operacion_caja_personas1` FOREIGN KEY (`per_codi_fk`) REFERENCES `personas` (`per_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=1617 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `operacion_caja`
--

LOCK TABLES `operacion_caja` WRITE;
/*!40000 ALTER TABLE `operacion_caja` DISABLE KEYS */;
INSERT INTO `operacion_caja` VALUES (1,'2021-01-12 19:07:12','2021-01-12','0000001',1,11,1,0,235,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1610496315656234664',1,4,1),(2,'2021-01-12 19:25:10','2021-01-12','0000002',1454,11,1,0,1512,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1610496691313357431',1,4,1),(3,'2021-01-12 19:46:51','2021-01-12','0000003',1454,11,1,0,1505,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16104980541397586191',1,4,1),(4,'2021-01-15 17:04:25','2021-01-15','0000004',1521,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1610747944537251789',1,5,1),(5,'2021-01-15 17:49:47','2021-01-15','0000005',1521,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16107508481132037069',1,5,1),(6,'2021-01-15 18:01:17','2021-01-15','0000006',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1610751637729216565',1,5,1),(7,'2021-01-15 18:01:53','2021-01-15','0000007',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1610751682989731',1,5,1),(8,'2021-01-15 18:02:39','2021-01-15','0000008',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1610751719875696748',1,5,1),(9,'2021-01-15 18:03:23','2021-01-15','0000009',1,11,1,0,280,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16107517621299086444',1,5,1),(10,'2021-01-15 18:04:59','2021-01-15','0000010',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16107518121101140250',1,5,1),(11,'2021-01-15 18:05:38','2021-01-15','0000011',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16107519031118568122',1,5,1),(12,'2021-01-15 18:06:18','2021-01-15','0000012',1,11,1,0,235,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161075194283825910',1,5,1),(13,'2021-01-15 18:06:54','2021-01-15','0000013',1,11,1,0,180,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1610751982820056655',1,5,1),(14,'2021-01-15 18:07:45','2021-01-15','0000014',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1610752017768547613',1,5,1),(15,'2021-01-21 17:18:33','2021-01-21','0000015',1522,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611267024616688457',1,7,1),(16,'2021-01-21 17:33:45','2021-01-21','0000016',1523,11,1,0,303,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16112678641082464457',1,7,1),(17,'2021-01-21 18:11:22','2021-01-21','0000017',1524,11,1,0,1595,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16112689201145161762',1,7,1),(18,'2021-01-21 18:22:39','2021-01-21','0000018',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611271338207198027',1,7,1),(19,'2021-01-21 18:23:23','2021-01-21','0000019',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611271362234824431',1,7,1),(20,'2021-01-21 18:24:15','2021-01-21','0000020',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16112714051324432163',1,7,1),(21,'2021-01-21 18:24:49','2021-01-21','0000021',1,11,1,0,425,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611271458142306101',1,7,1),(22,'2021-01-21 18:26:23','2021-01-21','0000022',1,11,1,0,395,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611271512931638064',1,7,1),(23,'2021-01-21 18:27:20','2021-01-21','0000023',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611271585474769643',1,7,1),(24,'2021-01-21 18:29:46','2021-01-21','0000024',1,11,1,0,445,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611271751591730024',1,7,1),(25,'2021-01-22 18:02:09','2021-01-22','0000025',1522,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611356423477910963',1,8,1),(26,'2021-01-22 18:18:01','2021-01-22','0000026',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16113574321397758318',1,8,1),(27,'2021-01-22 18:18:21','2021-01-22','0000027',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161135748420870414',1,8,1),(28,'2021-01-22 18:18:56','2021-01-22','0000028',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611357504471284068',1,8,1),(29,'2021-01-22 18:28:58','2021-01-22','0000029',1525,11,1,0,875,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611357539998380357',1,8,1),(30,'2021-01-25 18:03:23','2021-01-25','0000030',1475,11,1,0,2143.4,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611615389683215591',1,9,1),(31,'2021-01-25 18:17:34','2021-01-25','0000031',1,11,1,0,395,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611616334334356941',1,9,1),(32,'2021-01-25 18:19:43','2021-01-25','0000032',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611616665617764252',1,9,1),(33,'2021-01-25 18:21:04','2021-01-25','0000033',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16116167881388162231',1,9,1),(34,'2021-01-26 11:20:50','2021-01-26','0000034',1,11,1,0,179.4,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611677936252037143',1,10,1),(35,'2021-01-26 15:34:51','2021-01-26','0000035',1526,11,1,0,119,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611692661534024405',1,10,1),(36,'2021-01-26 17:59:46','2021-01-26','0000036',1527,11,1,0,153,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611701537630157405',1,10,1),(37,'2021-01-26 18:38:45','2021-01-26','0000037',1528,11,1,0,45,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16117033591008880111',1,10,1),(38,'2021-01-26 18:45:19','2021-01-26','0000038',1,11,1,0,445,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16117046921024457616',1,10,1),(39,'2021-01-26 18:45:38','2021-01-26','0000039',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611704722165328104',1,10,1),(40,'2021-01-26 18:46:07','2021-01-26','0000040',1,11,1,0,410,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611704741529592132',1,10,1),(41,'2021-01-26 18:50:56','2021-01-26','0000041',1529,11,1,0,338,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611704769278759879',1,10,1),(42,'2021-01-28 18:24:18','2021-01-28','0000042',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611876223564361811',1,11,1),(43,'2021-01-28 18:25:14','2021-01-28','0000043',1,11,1,0,445,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611876288270454745',1,11,1),(44,'2021-01-28 18:25:34','2021-01-28','0000044',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611876317179786782',1,11,1),(45,'2021-01-28 18:26:22','2021-01-28','0000045',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611876336171438617',1,11,1),(46,'2021-01-28 18:26:50','2021-01-28','0000046',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611876385534669882',1,11,1),(47,'2021-01-28 18:27:16','2021-01-28','0000047',1,11,1,0,430,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16118764131166032176',1,11,1),(48,'2021-01-28 18:27:43','2021-01-28','0000048',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611876439994722655',1,11,1),(49,'2021-01-28 18:28:11','2021-01-28','0000049',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611876466524385286',1,11,1),(50,'2021-01-28 18:28:36','2021-01-28','0000050',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611876493876944670',1,11,1),(51,'2021-01-28 18:29:24','2021-01-28','0000051',1,11,1,0,340,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611876519754174998',1,11,1),(52,'2021-01-28 18:29:47','2021-01-28','0000052',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611876566609200927',1,11,1),(53,'2021-01-28 18:30:19','2021-01-28','0000053',1,11,1,0,425,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611876600712262043',1,11,1),(54,'2021-01-28 18:31:06','2021-01-28','0000054',1,11,1,0,375,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611876622690186739',1,11,1),(55,'2021-01-28 18:31:43','2021-01-28','0000055',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611876669263784819',1,11,1),(56,'2021-01-28 18:32:21','2021-01-28','0000056',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611876705858957385',1,11,1),(57,'2021-01-28 18:32:58','2021-01-28','0000057',1,11,1,0,200,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16118767441217110901',1,11,1),(58,'2021-01-28 18:33:18','2021-01-28','0000058',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611876781406736397',1,11,1),(59,'2021-01-28 18:34:17','2021-01-28','0000059',1,11,1,0,410,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611876801942352977',1,11,1),(60,'2021-01-28 18:34:50','2021-01-28','0000060',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16118768601304379353',1,11,1),(61,'2021-01-28 18:35:15','2021-01-28','0000061',1,11,1,0,430,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611876892698448841',1,11,1),(62,'2021-01-28 18:35:53','2021-01-28','0000062',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611876922206337391',1,11,1),(63,'2021-01-28 18:36:40','2021-01-28','0000063',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611876959394859625',1,11,1),(64,'2021-01-28 18:37:15','2021-01-28','0000064',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611877003740189669',1,11,1),(65,'2021-01-28 18:38:04','2021-01-28','0000065',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611877038866961297',1,11,1),(66,'2021-01-28 18:38:45','2021-01-28','0000066',1,11,1,0,280,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611877086709766200',1,11,1),(67,'2021-01-28 18:39:19','2021-01-28','0000067',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611877127639882587',1,11,1),(68,'2021-01-28 18:39:58','2021-01-28','0000068',1,11,1,0,285,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16118771621073255656',1,11,1),(69,'2021-01-28 18:40:22','2021-01-28','0000069',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16118772011070415558',1,11,1),(70,'2021-01-28 18:41:06','2021-01-28','0000070',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16118772241225803320',1,11,1),(71,'2021-01-28 18:41:32','2021-01-28','0000071',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16118772691112930958',1,11,1),(72,'2021-01-28 18:42:01','2021-01-28','0000072',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611877295636956426',1,11,1),(73,'2021-01-28 18:42:31','2021-01-28','0000073',1,11,1,0,430,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16118773301299129476',1,11,1),(74,'2021-01-28 18:43:04','2021-01-28','0000074',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611877353822208244',1,11,1),(75,'2021-01-28 18:43:30','2021-01-28','0000075',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611877391370417573',1,11,1),(76,'2021-01-28 18:44:32','2021-01-28','0000076',1,11,1,0,345,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611877413998380357',1,11,1),(77,'2021-01-28 18:45:37','2021-01-28','0000077',1,11,1,0,370,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611877484933875717',1,11,1),(78,'2021-01-28 18:46:32','2021-01-28','0000078',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16118775391219176426',1,11,1),(79,'2021-01-28 18:47:12','2021-01-28','0000079',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611877604614665963',1,11,1),(80,'2021-01-28 18:47:39','2021-01-28','0000080',1,11,1,0,340,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16118776351179888410',1,11,1),(81,'2021-01-28 18:48:21','2021-01-28','0000081',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611877662593064009',1,11,1),(82,'2021-01-28 18:49:13','2021-01-28','0000082',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611877705594441026',1,11,1),(83,'2021-01-29 18:21:48','2021-01-29','0000083',1,11,1,0,335,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611962455846392105',1,12,1),(84,'2021-01-29 18:22:20','2021-01-29','0000084',1,11,1,0,445,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16119625131278990602',1,12,1),(85,'2021-01-29 18:22:58','2021-01-29','0000085',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16119625471128809685',1,12,1),(86,'2021-01-29 18:26:01','2021-01-29','0000086',1,11,1,0,280,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611962580188952552',1,12,1),(87,'2021-01-29 18:26:29','2021-01-29','0000087',1,11,1,0,430,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16119627641194648311',1,12,1),(88,'2021-01-29 18:27:00','2021-01-29','0000088',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611962792137400478',1,12,1),(89,'2021-01-29 18:27:26','2021-01-29','0000089',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611962822941018992',1,12,1),(90,'2021-01-29 18:28:28','2021-01-29','0000090',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16119628481027039523',1,12,1),(91,'2021-01-29 18:29:14','2021-01-29','0000091',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16119629101130100639',1,12,1),(92,'2021-01-29 18:38:13','2021-01-29','0000092',1530,11,1,0,1760,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611962962199280179',1,12,1),(93,'2021-01-29 18:44:01','2021-01-29','0000093',1523,11,1,0,150,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16119636721040336343',1,12,1),(94,'2021-01-29 18:49:28','2021-01-29','0000094',1,11,1,0,455,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611964137555540296',1,12,1),(95,'2021-01-29 18:49:53','2021-01-29','0000095',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611964171260471372',1,12,1),(96,'2021-01-29 18:50:17','2021-01-29','0000096',1,11,1,0,180,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611964196234308049',1,12,1),(97,'2021-01-29 18:51:01','2021-01-29','0000097',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16119642201031729987',1,12,1),(98,'2021-01-29 18:51:37','2021-01-29','0000098',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611964264123027863',1,12,1),(99,'2021-01-29 18:52:21','2021-01-29','0000099',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611964300366544713',1,12,1),(100,'2021-01-29 18:52:58','2021-01-29','0000100',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611964349440516345',1,12,1),(101,'2021-01-29 18:53:28','2021-01-29','0000101',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611964381636181854',1,12,1),(102,'2021-01-29 18:54:40','2021-01-29','0000102',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611964416130214170',1,12,1),(103,'2021-01-29 18:55:12','2021-01-29','0000103',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611964491857967654',1,12,1),(104,'2021-01-29 18:55:35','2021-01-29','0000104',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16119645151372842917',1,12,1),(105,'2021-01-29 18:56:36','2021-01-29','0000105',1,11,1,0,220,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611964556909003347',1,12,1),(106,'2021-01-29 18:57:33','2021-01-29','0000106',1,11,1,0,345,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611964599114851825',1,12,1),(107,'2021-01-29 18:58:14','2021-01-29','0000107',1,11,1,0,345,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1611964669835892351',1,12,1),(108,'2021-01-30 18:18:42','2021-01-30','0000108',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612048698247174552',1,13,1),(109,'2021-01-30 18:20:19','2021-01-30','0000109',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612048786794409714',1,13,1),(110,'2021-01-30 18:20:54','2021-01-30','0000110',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16120488221237938283',1,13,1),(111,'2021-01-30 18:21:19','2021-01-30','0000111',1,11,1,0,430,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612048857194116366',1,13,1),(112,'2021-01-30 18:22:03','2021-01-30','0000112',1,11,1,0,375,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612048882305654743',1,13,1),(113,'2021-01-30 18:22:25','2021-01-30','0000113',1,11,1,0,220,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612048926109214661',1,13,1),(114,'2021-01-30 18:23:25','2021-01-30','0000114',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161204894825517847',1,13,1),(115,'2021-01-30 18:24:13','2021-01-30','0000115',1,11,1,0,200,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612049009783694800',1,13,1),(116,'2021-01-30 18:24:48','2021-01-30','0000116',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16120490571105185238',1,13,1),(117,'2021-01-30 18:25:56','2021-01-30','0000117',1,11,1,0,370,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16120490911404299149',1,13,1),(118,'2021-01-30 18:26:51','2021-01-30','0000118',1,11,1,0,370,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16120491591069985241',1,13,1),(119,'2021-01-30 18:27:21','2021-01-30','0000119',1,11,1,0,445,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612049214178495829',1,13,1),(120,'2021-01-30 18:27:43','2021-01-30','0000120',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612049243844240516',1,13,1),(121,'2021-01-30 18:28:11','2021-01-30','0000121',1,11,1,0,280,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612049266122468450',1,13,1),(122,'2021-01-30 18:29:02','2021-01-30','0000122',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612049295133097300',1,13,1),(123,'2021-01-30 18:29:41','2021-01-30','0000123',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612049352116271873',1,13,1),(124,'2021-01-30 18:30:15','2021-01-30','0000124',1,11,1,0,250,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16120493841057118738',1,13,1),(125,'2021-01-30 18:30:46','2021-01-30','0000125',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612049419449466955',1,13,1),(126,'2021-01-30 18:31:31','2021-01-30','0000126',1,11,1,0,280,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612049449141144243',1,13,1),(127,'2021-01-30 18:31:53','2021-01-30','0000127',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16120494951126615065',1,13,1),(128,'2021-01-30 18:32:20','2021-01-30','0000128',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612049516722675734',1,13,1),(129,'2021-01-30 18:33:29','2021-01-30','0000129',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16120495871028889889',1,13,1),(130,'2021-01-30 18:33:57','2021-01-30','0000130',1,11,1,0,160,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612049613275274305',1,13,1),(131,'2021-01-30 18:34:37','2021-01-30','0000131',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612049641806286485',1,13,1),(132,'2021-01-30 18:35:10','2021-01-30','0000132',1,11,1,0,180,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612049689338746182',1,13,1),(133,'2021-01-30 18:35:40','2021-01-30','0000133',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16120497131280066396',1,13,1),(134,'2021-01-30 18:37:14','2021-01-30','0000134',1,11,1,0,200,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612049744748322676',1,13,1),(135,'2021-01-30 18:37:37','2021-01-30','0000135',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16120498371312512359',1,13,1),(136,'2021-01-30 18:38:15','2021-01-30','0000136',1,11,1,0,280,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16120498651119471789',1,13,1),(137,'2021-01-30 18:38:42','2021-01-30','0000137',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16120498981133801372',1,13,1),(138,'2021-01-30 18:39:16','2021-01-30','0000138',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612049925591600929',1,13,1),(139,'2021-01-30 18:40:12','2021-01-30','0000139',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16120499661175499168',1,13,1),(140,'2021-02-10 13:30:41','2021-02-10','0000140',1531,11,1,0,160,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16129816631222016524',1,14,1),(141,'2021-02-10 14:00:12','2021-02-10','0000141',1532,11,1,0,160,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612983229580584793',1,14,1),(142,'2021-02-10 18:15:22','2021-02-10','0000142',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612998904832880126',1,14,1),(143,'2021-02-10 18:18:54','2021-02-10','0000143',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612998995494220008',1,14,1),(144,'2021-02-10 18:19:47','2021-02-10','0000144',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612999137486087001',1,14,1),(145,'2021-02-10 18:20:23','2021-02-10','0000145',1,11,1,0,195,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612999190542458635',1,14,1),(146,'2021-02-10 18:21:16','2021-02-10','0000146',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612999227996917276',1,14,1),(147,'2021-02-10 18:22:22','2021-02-10','0000147',1,11,1,0,220,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16129992801141977411',1,14,1),(148,'2021-02-10 18:24:06','2021-02-10','0000148',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612999349348170142',1,14,1),(149,'2021-02-10 18:25:03','2021-02-10','0000149',1,11,1,0,315,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612999449930433174',1,14,1),(150,'2021-02-10 18:25:53','2021-02-10','0000150',1,11,1,0,220,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612999507291540318',1,14,1),(151,'2021-02-10 18:26:42','2021-02-10','0000151',1,11,1,0,220,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612999564727151040',1,14,1),(152,'2021-02-10 18:27:09','2021-02-10','0000152',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16129996051135479612',1,14,1),(153,'2021-02-10 18:28:21','2021-02-10','0000153',1,11,1,0,345,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16129996561369357342',1,14,1),(154,'2021-02-10 18:29:36','2021-02-10','0000154',1,11,1,0,235,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612999705914554447',1,14,1),(155,'2021-02-10 18:30:16','2021-02-10','0000155',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16129997801268964197',1,14,1),(156,'2021-02-10 18:30:53','2021-02-10','0000156',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612999819783780864',1,14,1),(157,'2021-02-10 18:31:24','2021-02-10','0000157',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1612999862237019051',1,14,1),(158,'2021-02-20 16:21:27','2021-02-20','0000158',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1613856024569697752',1,15,1),(159,'2021-02-20 16:21:58','2021-02-20','0000159',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16138560901258679601',1,15,1),(160,'2021-02-20 16:22:16','2021-02-20','0000160',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16138561211151573498',1,15,1),(161,'2021-02-20 16:22:44','2021-02-20','0000161',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1613856139311291906',1,15,1),(162,'2021-02-20 16:23:12','2021-02-20','0000162',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161385616747033737',1,15,1),(163,'2021-02-20 16:24:05','2021-02-20','0000163',1,11,1,0,310,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1613856196928927062',1,15,1),(164,'2021-02-20 16:24:42','2021-02-20','0000164',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1613856248645046401',1,15,1),(165,'2021-02-20 16:25:32','2021-02-20','0000165',1,11,1,0,285,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161385628537437650',1,15,1),(166,'2021-02-20 16:26:09','2021-02-20','0000166',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1613856339602057652',1,15,1),(167,'2021-02-20 16:26:48','2021-02-20','0000167',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16138563721352704043',1,15,1),(168,'2021-02-20 16:27:46','2021-02-20','0000168',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1613856411147599010',1,15,1),(169,'2021-02-20 16:28:11','2021-02-20','0000169',1,11,1,0,195,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161385646999016129',1,15,1),(170,'2021-02-20 16:28:47','2021-02-20','0000170',1,11,1,0,280,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1613856493866918265',1,15,1),(171,'2021-02-20 16:29:12','2021-02-20','0000171',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161385653041009288',1,15,1),(172,'2021-02-20 16:30:14','2021-02-20','0000172',1,11,1,0,345,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16138565551233204787',1,15,1),(173,'2021-02-20 16:30:52','2021-02-20','0000173',1,11,1,0,445,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161385661665795594',1,15,1),(174,'2021-02-20 16:32:01','2021-02-20','0000174',1,11,1,0,280,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1613856654414998499',1,15,1),(175,'2021-02-20 16:32:35','2021-02-20','0000175',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1613856731278071371',1,15,1),(176,'2021-02-20 16:33:04','2021-02-20','0000176',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16138567581244177891',1,15,1),(177,'2021-02-20 16:33:31','2021-02-20','0000177',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16138567871390959297',1,15,1),(178,'2021-02-20 16:34:23','2021-02-20','0000178',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16138568141034957371',1,15,1),(179,'2021-02-20 16:34:55','2021-02-20','0000179',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1613856866867520710',1,15,1),(180,'2021-02-20 16:36:31','2021-02-20','0000180',1,11,1,0,250,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16138569631127045382',1,15,1),(181,'2021-02-20 16:37:15','2021-02-20','0000181',1,11,1,0,250,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1613856994492756927',1,15,1),(182,'2021-02-20 16:39:11','2021-02-20','0000182',1,11,1,0,386,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1613857039901774008',1,15,1),(183,'2021-02-22 17:24:12','2021-02-22','0000183',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614032568171438617',1,16,1),(184,'2021-02-22 17:25:03','2021-02-22','0000184',1,11,1,0,280,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161403265584858673',1,16,1),(185,'2021-02-22 17:25:22','2021-02-22','0000185',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614032706816700176',1,16,1),(186,'2021-02-22 17:25:57','2021-02-22','0000186',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161403272550476280',1,16,1),(187,'2021-02-22 17:31:00','2021-02-22','0000187',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614032760777928541',1,16,1),(188,'2021-02-22 17:32:12','2021-02-22','0000188',1,11,1,0,340,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614033066325879680',1,16,1),(189,'2021-02-22 17:33:18','2021-02-22','0000189',1,11,1,0,370,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614033136894716796',1,16,1),(190,'2021-02-22 17:34:14','2021-02-22','0000190',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614033200514057659',1,16,1),(191,'2021-02-22 17:34:42','2021-02-22','0000191',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614033257577959854',1,16,1),(192,'2021-02-22 17:35:09','2021-02-22','0000192',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16140332851388764676',1,16,1),(193,'2021-02-22 17:35:36','2021-02-22','0000193',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614033312168684583',1,16,1),(194,'2021-02-22 17:36:04','2021-02-22','0000194',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614033339654728552',1,16,1),(195,'2021-02-22 17:36:28','2021-02-22','0000195',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614033367543663524',1,16,1),(196,'2021-02-22 17:37:00','2021-02-22','0000196',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614033391402131996',1,16,1),(197,'2021-02-22 17:37:35','2021-02-22','0000197',1,11,1,0,375,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614033423769924630',1,16,1),(198,'2021-02-22 17:38:25','2021-02-22','0000198',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161403345722849876',1,16,1),(199,'2021-02-22 17:38:59','2021-02-22','0000199',1,11,1,0,210,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614033508562683572',1,16,1),(200,'2021-02-22 17:40:09','2021-02-22','0000200',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614033572194933969',1,16,1),(201,'2021-02-22 17:41:02','2021-02-22','0000201',1,11,1,0,385,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16140336121087542207',1,16,1),(202,'2021-02-22 17:42:30','2021-02-22','0000202',1,11,1,0,490,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614033665888692346',1,16,1),(203,'2021-02-22 17:43:13','2021-02-22','0000203',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16140337531206094765',1,16,1),(204,'2021-02-22 17:51:06','2021-02-22','0000204',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16140338001153208705',1,16,1),(205,'2021-02-22 17:59:01','2021-02-22','0000205',1,11,1,0,385,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614034270358497770',1,16,1),(206,'2021-02-22 17:59:59','2021-02-22','0000206',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614034753524385286',1,16,1),(207,'2021-02-22 18:07:19','2021-02-22','0000207',1,11,1,0,210,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614035217684635640',1,16,1),(208,'2021-02-22 18:08:09','2021-02-22','0000208',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614035243295241051',1,16,1),(209,'2021-02-22 18:08:52','2021-02-22','0000209',1,11,1,0,245,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614035292427563779',1,16,1),(210,'2021-02-22 18:09:17','2021-02-22','0000210',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161403533516309046',1,16,1),(211,'2021-02-22 18:09:46','2021-02-22','0000211',1,11,1,0,250,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614035359251004380',1,16,1),(212,'2021-02-22 18:10:18','2021-02-22','0000212',1,11,1,0,225,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16140353891057376929',1,16,1),(213,'2021-02-23 18:36:58','2021-02-23','0000213',1533,11,1,0,883,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614123192887788679',1,17,1),(214,'2021-02-23 19:12:59','2021-02-23','0000214',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614125538612643470',1,17,1),(215,'2021-02-23 19:13:19','2021-02-23','0000215',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16141255821118352963',1,17,1),(216,'2021-02-23 19:13:48','2021-02-23','0000216',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16141256011111338782',1,17,1),(217,'2021-02-23 19:14:17','2021-02-23','0000217',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614125631769752503',1,17,1),(218,'2021-02-23 19:14:59','2021-02-23','0000218',1,11,1,0,425,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16141256601274128011',1,17,1),(219,'2021-02-23 19:15:31','2021-02-23','0000219',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614125702114120284',1,17,1),(220,'2021-02-23 19:15:52','2021-02-23','0000220',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614125733120273829',1,17,1),(221,'2021-02-23 19:16:18','2021-02-23','0000221',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614125755675641997',1,17,1),(222,'2021-02-23 19:16:39','2021-02-23','0000222',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16141257811278129966',1,17,1),(223,'2021-02-23 19:17:03','2021-02-23','0000223',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614125802265635186',1,17,1),(224,'2021-02-23 19:17:25','2021-02-23','0000224',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16141258251244479113',1,17,1),(225,'2021-02-23 19:18:03','2021-02-23','0000225',1,11,1,0,215,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614125847989429746',1,17,1),(226,'2021-02-23 19:18:35','2021-02-23','0000226',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16141258864131051',1,17,1),(227,'2021-02-23 19:19:16','2021-02-23','0000227',1,11,1,0,375,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614125936403638108',1,17,1),(228,'2021-02-23 19:19:43','2021-02-23','0000228',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614125958504891890',1,17,1),(229,'2021-02-23 19:20:13','2021-02-23','0000229',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16141259861360148541',1,17,1),(230,'2021-02-23 19:20:49','2021-02-23','0000230',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614126015217181400',1,17,1),(231,'2021-02-23 19:21:15','2021-02-23','0000231',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16141260521368840961',1,17,1),(232,'2021-02-23 19:21:42','2021-02-23','0000232',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614126082296402910',1,17,1),(233,'2021-02-23 19:22:29','2021-02-23','0000233',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16141261051349863946',1,17,1),(234,'2021-02-23 19:23:07','2021-02-23','0000234',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614126166898933910',1,17,1),(235,'2021-02-23 19:23:46','2021-02-23','0000235',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16141261911383385703',1,17,1),(236,'2021-02-24 18:09:13','2021-02-24','0000236',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16142081351242069334',1,18,1),(237,'2021-02-24 18:09:42','2021-02-24','0000237',1,11,1,0,445,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614208157408285541',1,18,1),(238,'2021-02-24 18:10:23','2021-02-24','0000238',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614208185310474302',1,18,1),(239,'2021-02-24 18:10:54','2021-02-24','0000239',1,11,1,0,210,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614208226276522227',1,18,1),(240,'2021-02-24 18:11:16','2021-02-24','0000240',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614208257840453719',1,18,1),(241,'2021-02-24 18:11:36','2021-02-24','0000241',1,11,1,0,470,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614208279550505578',1,18,1),(242,'2021-02-24 18:12:24','2021-02-24','0000242',1,11,1,0,220,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614208299979575468',1,18,1),(243,'2021-02-24 18:12:45','2021-02-24','0000243',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614208346955434639',1,18,1),(244,'2021-02-24 18:13:27','2021-02-24','0000244',1,11,1,0,280,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614208368494607294',1,18,1),(245,'2021-02-24 18:14:00','2021-02-24','0000245',1,11,1,0,280,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614208411864637581',1,18,1),(246,'2021-02-24 18:14:36','2021-02-24','0000246',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614208442986116299',1,18,1),(247,'2021-02-24 18:15:04','2021-02-24','0000247',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16142084781081775949',1,18,1),(248,'2021-02-24 18:15:25','2021-02-24','0000248',1,11,1,0,210,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614208507109472852',1,18,1),(249,'2021-02-24 18:16:03','2021-02-24','0000249',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16142085281217928504',1,18,1),(250,'2021-02-24 18:16:57','2021-02-24','0000250',1,11,1,0,245,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614208566958145641',1,18,1),(251,'2021-02-24 18:17:50','2021-02-24','0000251',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16142086201108972034',1,18,1),(252,'2021-02-24 18:18:11','2021-02-24','0000252',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16142086721264015542',1,18,1),(253,'2021-02-24 18:18:59','2021-02-24','0000253',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614208694481439569',1,18,1),(254,'2021-02-24 18:19:25','2021-02-24','0000254',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614208742684506544',1,18,1),(255,'2021-02-24 18:19:46','2021-02-24','0000255',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614208768821993085',1,18,1),(256,'2021-02-24 18:20:18','2021-02-24','0000256',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16142087891251235103',1,18,1),(257,'2021-02-24 18:21:45','2021-02-24','0000257',1,11,1,0,375,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16142088701081991107',1,18,1),(258,'2021-02-24 18:22:37','2021-02-24','0000258',1,11,1,0,310,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614208909633040534',1,18,1),(259,'2021-02-24 18:23:24','2021-02-24','0000259',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614208960495812184',1,18,1),(260,'2021-02-24 18:24:10','2021-02-24','0000260',1,11,1,0,210,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16142090071300721651',1,18,1),(261,'2021-02-24 18:24:34','2021-02-24','0000261',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614209053708475246',1,18,1),(262,'2021-02-24 18:24:51','2021-02-24','0000262',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16142090771062325583',1,18,1),(263,'2021-02-24 18:25:30','2021-02-24','0000263',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16142090931038055659',1,18,1),(264,'2021-02-24 18:26:20','2021-02-24','0000264',1,11,1,0,470,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614209133303890439',1,18,1),(265,'2021-02-24 18:26:47','2021-02-24','0000265',1,11,1,0,250,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614209182192179935',1,18,1),(266,'2021-02-24 18:27:17','2021-02-24','0000266',1,11,1,0,200,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614209216386554491',1,18,1),(267,'2021-02-25 18:40:37','2021-02-25','0000267',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16142961501175800391',1,19,1),(268,'2021-02-25 18:41:09','2021-02-25','0000268',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614296440515477708',1,19,1),(269,'2021-02-25 18:41:37','2021-02-25','0000269',1,11,1,0,430,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614296472896696258',1,19,1),(270,'2021-02-25 18:42:07','2021-02-25','0000270',1,11,1,0,445,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161429650037695841',1,19,1),(271,'2021-02-25 18:44:59','2021-02-25','0000271',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614296668145490453',1,19,1),(272,'2021-02-25 18:50:57','2021-02-25','0000272',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614296702487593113',1,19,1),(273,'2021-02-25 18:56:50','2021-02-25','0000273',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16142973831171497212',1,19,1),(274,'2021-02-25 18:58:57','2021-02-25','0000274',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16142975151264101606',1,19,1),(275,'2021-02-25 18:59:24','2021-02-25','0000275',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614297540505924652',1,19,1),(276,'2021-02-25 18:59:59','2021-02-25','0000276',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614297567489529544',1,19,1),(277,'2021-02-25 19:00:42','2021-02-25','0000277',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614297603131892410',1,19,1),(278,'2021-02-25 19:02:51','2021-02-25','0000278',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614297749914984765',1,19,1),(279,'2021-02-25 19:03:19','2021-02-25','0000279',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16142977731336136807',1,19,1),(280,'2021-02-25 19:05:45','2021-02-25','0000280',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614297801718157397',1,19,1),(281,'2021-02-25 19:07:37','2021-02-25','0000281',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614298037655632219',1,19,1),(282,'2021-02-25 19:07:55','2021-02-25','0000282',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614298059348213174',1,19,1),(283,'2021-02-25 19:08:14','2021-02-25','0000283',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614298077189124679',1,19,1),(284,'2021-02-25 19:08:45','2021-02-25','0000284',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614298096486904605',1,19,1),(285,'2021-02-25 19:19:26','2021-02-25','0000285',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16142987451049545144',1,19,1),(286,'2021-02-25 19:19:50','2021-02-25','0000286',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16142987691193744643',1,19,1),(287,'2021-02-25 19:20:21','2021-02-25','0000287',1,11,1,0,245,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614298794194159397',1,19,1),(288,'2021-02-25 19:20:49','2021-02-25','0000288',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614298824330441048',1,19,1),(289,'2021-02-25 19:21:34','2021-02-25','0000289',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614298852365339823',1,19,1),(290,'2021-02-25 19:21:55','2021-02-25','0000290',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614298898975573513',1,19,1),(291,'2021-02-25 19:22:46','2021-02-25','0000291',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16142989371312125073',1,19,1),(292,'2021-02-25 19:23:23','2021-02-25','0000292',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614298969427434683',1,19,1),(293,'2021-02-25 19:28:58','2021-02-25','0000293',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614299006479287980',1,19,1),(294,'2021-02-25 19:29:30','2021-02-25','0000294',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614299349671209724',1,19,1),(295,'2021-02-26 11:28:16','2021-02-26','0000295',1534,11,1,0,5000,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16143566941022047836',1,20,1),(296,'2021-02-26 11:35:34','2021-02-26','0000296',1534,11,1,0,5000,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614357251591213643',1,20,1),(297,'2021-02-26 19:11:42','2021-02-26','0000297',1536,11,1,0,321,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16143840231392336314',1,20,1),(298,'2021-02-26 19:17:00','2021-02-26','0000298',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614385006934004812',1,20,1),(299,'2021-02-26 19:17:35','2021-02-26','0000299',1,11,1,0,430,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614385024594699217',1,20,1),(300,'2021-02-26 19:18:07','2021-02-26','0000300',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16143850571091070813',1,20,1),(301,'2021-02-26 19:18:34','2021-02-26','0000301',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614385089734208252',1,20,1),(302,'2021-02-26 19:19:52','2021-02-26','0000302',1,11,1,0,445,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16143851611092749053',1,20,1),(303,'2021-02-26 19:20:42','2021-02-26','0000303',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614385194868940759',1,20,1),(304,'2021-02-26 19:21:14','2021-02-26','0000304',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161438524524485084',1,20,1),(305,'2021-02-26 19:21:34','2021-02-26','0000305',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16143852765422005',1,20,1),(306,'2021-02-26 19:23:10','2021-02-26','0000306',1475,11,1,0,1750,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161438529898671875',1,20,1),(307,'2021-02-26 19:24:35','2021-02-26','0000307',1475,11,1,0,1827,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16143853931263585224',1,20,1),(308,'2021-02-26 19:28:57','2021-02-26','0000308',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614385705123243022',1,20,1),(309,'2021-02-26 19:29:24','2021-02-26','0000309',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614385739890198459',1,20,1),(310,'2021-02-26 19:29:58','2021-02-26','0000310',1,11,1,0,210,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16143857711164827286',1,20,1),(311,'2021-02-26 19:30:26','2021-02-26','0000311',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614385800600379412',1,20,1),(312,'2021-02-26 19:30:49','2021-02-26','0000312',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614385830532862547',1,20,1),(313,'2021-02-26 19:31:17','2021-02-26','0000313',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614385857341930534',1,20,1),(314,'2021-02-26 19:31:45','2021-02-26','0000314',1,11,1,0,340,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614385880861754451',1,20,1),(315,'2021-02-26 19:32:12','2021-02-26','0000315',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614385913372741289',1,20,1),(316,'2021-02-26 19:33:12','2021-02-26','0000316',1,11,1,0,250,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614385958220580911',1,20,1),(317,'2021-02-27 14:31:48','2021-02-27','0000317',1,11,1,0,465,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614454205407381873',1,21,1),(318,'2021-02-27 14:38:09','2021-02-27','0000318',1521,11,1,0,310,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16144545601157727042',1,21,1),(319,'2021-02-27 14:43:47','2021-02-27','0000319',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16144549751396467365',1,21,1),(320,'2021-02-27 14:44:15','2021-02-27','0000320',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614455030689369136',1,21,1),(321,'2021-02-27 14:44:36','2021-02-27','0000321',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614455058247992156',1,21,1),(322,'2021-02-27 14:45:15','2021-02-27','0000322',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614455079776551524',1,21,1),(323,'2021-02-27 14:45:45','2021-02-27','0000323',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614455119621852271',1,21,1),(324,'2021-02-27 14:46:20','2021-02-27','0000324',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614455149262967216',1,21,1),(325,'2021-02-27 15:03:55','2021-02-27','0000325',1,11,1,0,445,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614455183843164722',1,21,1),(326,'2021-02-27 15:04:40','2021-02-27','0000326',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614456238879698704',1,21,1),(327,'2021-02-27 15:05:11','2021-02-27','0000327',1,11,1,0,430,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614456283324330536',1,21,1),(328,'2021-02-27 15:05:34','2021-02-27','0000328',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16144563141286306005',1,21,1),(329,'2021-02-27 15:06:02','2021-02-27','0000329',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16144563371172874229',1,21,1),(330,'2021-02-27 15:06:31','2021-02-27','0000330',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614456368106417595',1,21,1),(331,'2021-02-27 15:06:57','2021-02-27','0000331',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614456394234824431',1,21,1),(332,'2021-02-27 15:08:01','2021-02-27','0000332',1,11,1,0,280,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614456430596420488',1,21,1),(333,'2021-02-27 15:09:00','2021-02-27','0000333',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16144564851050104558',1,21,1),(334,'2021-02-27 15:09:40','2021-02-27','0000334',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161445654357060142',1,21,1),(335,'2021-02-27 15:10:00','2021-02-27','0000335',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16144565831192238531',1,21,1),(336,'2021-02-27 15:10:35','2021-02-27','0000336',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614456603758779399',1,21,1),(337,'2021-02-27 15:11:09','2021-02-27','0000337',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614456641279749610',1,21,1),(338,'2021-02-27 15:11:43','2021-02-27','0000338',1,11,1,0,475,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614456672252854747',1,21,1),(339,'2021-02-27 15:13:44','2021-02-27','0000339',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614456705860506530',1,21,1),(340,'2021-02-27 15:14:17','2021-02-27','0000340',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614456832799444432',1,21,1),(341,'2021-02-27 15:14:42','2021-02-27','0000341',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614456861415687007',1,21,1),(342,'2021-02-27 15:15:28','2021-02-27','0000342',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16144568851121365187',1,21,1),(343,'2021-02-27 15:16:15','2021-02-27','0000343',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614456937132451823',1,21,1),(344,'2021-02-27 15:17:14','2021-02-27','0000344',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1614457013887315329',1,21,1),(345,'2021-03-15 19:23:46','2021-03-15','0000345',1537,11,1,0,1215,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161585391535845474',1,23,1),(346,'2021-03-18 18:23:08','2021-03-18','0000346',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1616109764195278224',1,24,1),(347,'2021-03-18 18:23:44','2021-03-18','0000347',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1616109793797335875',1,24,1),(348,'2021-03-18 18:26:23','2021-03-18','0000348',1,11,1,0,410,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1616109829453081625',1,24,1),(349,'2021-03-18 18:27:30','2021-03-18','0000349',1,11,1,0,425,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161610998672766743',1,24,1),(350,'2021-03-18 18:28:35','2021-03-18','0000350',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16161100531324173972',1,24,1),(351,'2021-03-18 18:29:10','2021-03-18','0000351',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1616110120932369604',1,24,1),(352,'2021-03-18 18:30:50','2021-03-18','0000352',1,11,1,0,290,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1616110154641345668',1,24,1),(353,'2021-03-18 18:32:05','2021-03-18','0000353',1,11,1,0,295,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1616110253284181884',1,24,1),(354,'2021-03-18 18:33:02','2021-03-18','0000354',1,11,1,0,405,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16161103291249944150',1,24,1),(355,'2021-03-18 18:33:37','2021-03-18','0000355',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1616110386926259091',1,24,1),(356,'2021-03-18 18:34:34','2021-03-18','0000356',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1616110422267829807',1,24,1),(357,'2021-03-18 18:35:59','2021-03-18','0000357',1,11,1,0,280,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161611047774014664',1,24,1),(358,'2021-03-18 18:36:57','2021-03-18','0000358',1,11,1,0,335,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161611056387741802',1,24,1),(359,'2021-03-25 18:33:55','2021-03-25','0000359',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16167152141315954902',1,25,1),(360,'2021-03-25 18:34:14','2021-03-25','0000360',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16167152381083239029',1,25,1),(361,'2021-03-25 18:34:40','2021-03-25','0000361',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1616715256286075282',1,25,1),(362,'2021-03-25 18:35:01','2021-03-25','0000362',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1616715282398947644',1,25,1),(363,'2021-03-25 18:35:36','2021-03-25','0000363',1,11,1,0,215,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16167153031031557860',1,25,1),(364,'2021-03-25 18:36:07','2021-03-25','0000364',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1616715339908917283',1,25,1),(365,'2021-03-25 18:36:30','2021-03-25','0000365',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16167153691297537300',1,25,1),(366,'2021-03-25 18:36:52','2021-03-25','0000366',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1616715392121005369',1,25,1),(367,'2021-03-25 18:37:22','2021-03-25','0000367',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1616715415432555465',1,25,1),(368,'2021-03-25 18:38:16','2021-03-25','0000368',1,11,1,0,275,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1616715444846306042',1,25,1),(369,'2021-03-25 18:38:38','2021-03-25','0000369',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1616715499529463037',1,25,1),(370,'2021-03-25 18:39:11','2021-03-25','0000370',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16167155211092619957',1,25,1),(371,'2021-03-25 18:40:51','2021-03-25','0000371',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1616715553200054751',1,25,1),(372,'2021-03-25 18:41:37','2021-03-25','0000372',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1616715654838345162',1,25,1),(373,'2021-03-29 18:08:55','2021-03-29','0000373',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161705931075735935',1,26,1),(374,'2021-03-29 18:09:41','2021-03-29','0000374',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161705933946775547',1,26,1),(375,'2021-03-29 18:10:13','2021-03-29','0000375',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16170593841271632167',1,26,1),(376,'2021-03-29 18:10:35','2021-03-29','0000376',1,11,1,0,470,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617059416540307045',1,26,1),(377,'2021-03-29 18:11:01','2021-03-29','0000377',1,11,1,0,220,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617059438885766185',1,26,1),(378,'2021-03-29 18:11:32','2021-03-29','0000378',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16170594641072997465',1,26,1),(379,'2021-03-29 18:12:18','2021-03-29','0000379',1,11,1,0,410,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617059494459321233',1,26,1),(380,'2021-03-29 18:12:46','2021-03-29','0000380',1,11,1,0,245,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617059541999413119',1,26,1),(381,'2021-03-29 18:13:21','2021-03-29','0000381',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617059569249024918',1,26,1),(382,'2021-03-29 18:13:41','2021-03-29','0000382',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617059604642593589',1,26,1),(383,'2021-03-29 18:15:06','2021-03-29','0000383',1,11,1,0,200,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617059623672414614',1,26,1),(384,'2021-03-29 18:15:29','2021-03-29','0000384',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617059709439999963',1,26,1),(385,'2021-03-29 18:16:00','2021-03-29','0000385',1,11,1,0,285,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16170597371071491353',1,26,1),(386,'2021-03-29 18:16:42','2021-03-29','0000386',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16170597631023941235',1,26,1),(387,'2021-03-29 18:17:07','2021-03-29','0000387',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617059804855816065',1,26,1),(388,'2021-03-29 18:17:28','2021-03-29','0000388',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617059829939771071',1,26,1),(389,'2021-03-29 18:18:13','2021-03-29','0000389',1,11,1,0,280,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617059855902978898',1,26,1),(390,'2021-03-29 18:18:43','2021-03-29','0000390',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617059896663334908',1,26,1),(391,'2021-03-29 18:19:03','2021-03-29','0000391',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16170599261374004775',1,26,1),(392,'2021-03-29 18:19:46','2021-03-29','0000392',1,11,1,0,280,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16170599451315997934',1,26,1),(393,'2021-03-29 18:20:12','2021-03-29','0000393',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617059988344555473',1,26,1),(394,'2021-03-29 18:20:59','2021-03-29','0000394',1,11,1,0,490,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617060019390556447',1,26,1),(395,'2021-03-29 18:21:39','2021-03-29','0000395',1,11,1,0,190,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16170600621155446358',1,26,1),(396,'2021-03-29 18:22:17','2021-03-29','0000396',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161706010248109532',1,26,1),(397,'2021-03-29 18:22:41','2021-03-29','0000397',1,11,1,0,160,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16170601401146366652',1,26,1),(398,'2021-03-29 18:23:19','2021-03-29','0000398',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16170601641357007221',1,26,1),(399,'2021-03-29 18:23:47','2021-03-29','0000399',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617060202774442967',1,26,1),(400,'2021-03-31 16:22:45','2021-03-31','0000400',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161722573793034711',1,27,1),(401,'2021-03-31 16:23:17','2021-03-31','0000401',1,11,1,0,220,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617225768656449823',1,27,1),(402,'2021-03-31 16:24:12','2021-03-31','0000402',1,11,1,0,190,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617225801974626813',1,27,1),(403,'2021-03-31 16:24:55','2021-03-31','0000403',1,11,1,0,200,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617225854636095790',1,27,1),(404,'2021-03-31 16:25:22','2021-03-31','0000404',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161722589735329093',1,27,1),(405,'2021-03-31 16:25:54','2021-03-31','0000405',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617225925973206765',1,27,1),(406,'2021-03-31 16:26:38','2021-03-31','0000406',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617225957726376467',1,27,1),(407,'2021-03-31 16:27:19','2021-03-31','0000407',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16172260011100795996',1,27,1),(408,'2021-03-31 16:27:36','2021-03-31','0000408',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617226042996271799',1,27,1),(409,'2021-03-31 16:28:17','2021-03-31','0000409',1,11,1,0,215,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16172260641095115801',1,27,1),(410,'2021-03-31 16:28:56','2021-03-31','0000410',1,11,1,0,190,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617226100834472302',1,27,1),(411,'2021-03-31 16:29:22','2021-03-31','0000411',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617226139392665004',1,27,1),(412,'2021-03-31 16:30:30','2021-03-31','0000412',1,11,1,0,340,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617226165390814638',1,27,1),(413,'2021-03-31 16:31:46','2021-03-31','0000413',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617226233601713397',1,27,1),(414,'2021-03-31 16:32:19','2021-03-31','0000414',1,11,1,0,150,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617226310113345712',1,27,1),(415,'2021-03-31 16:33:27','2021-03-31','0000415',1,11,1,0,370,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617226342773238077',1,27,1),(416,'2021-03-31 16:34:04','2021-03-31','0000416',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617226415937791609',1,27,1),(417,'2021-03-31 16:34:31','2021-03-31','0000417',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617226447144414658',1,27,1),(418,'2021-03-31 16:35:01','2021-03-31','0000418',1,11,1,0,200,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16172264731380029224',1,27,1),(419,'2021-03-31 16:35:24','2021-03-31','0000419',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617226504271358413',1,27,1),(420,'2021-03-31 16:36:06','2021-03-31','0000420',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617226527114679697',1,27,1),(421,'2021-03-31 16:37:10','2021-03-31','0000421',1,11,1,0,340,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16172265741002769598',1,27,1),(422,'2021-03-31 16:37:35','2021-03-31','0000422',1,11,1,0,160,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617226633286161346',1,27,1),(423,'2021-03-31 16:38:12','2021-03-31','0000423',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1617226664222560373',1,27,1),(424,'2021-04-23 18:12:46','2021-04-23','0000424',1,11,1,0,250,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16192195381206309923',1,29,1),(425,'2021-04-23 18:13:05','2021-04-23','0000425',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619219569882151515',1,29,1),(426,'2021-04-23 18:13:28','2021-04-23','0000426',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619219587295327115',1,29,1),(427,'2021-04-23 18:13:52','2021-04-23','0000427',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619219611355012196',1,29,1),(428,'2021-04-23 18:14:35','2021-04-23','0000428',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619219635230435189',1,29,1),(429,'2021-04-23 18:15:07','2021-04-23','0000429',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161921967766355007',1,29,1),(430,'2021-04-23 18:15:33','2021-04-23','0000430',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16192197091226879115',1,29,1),(431,'2021-04-23 18:16:14','2021-04-23','0000431',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619219735904571074',1,29,1),(432,'2021-04-23 18:16:35','2021-04-23','0000432',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161921977626163323',1,29,1),(433,'2021-04-23 18:17:17','2021-04-23','0000433',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619219798150611235',1,29,1),(434,'2021-04-23 18:17:40','2021-04-23','0000434',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619219840438795074',1,29,1),(435,'2021-04-23 18:18:06','2021-04-23','0000435',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619219862131246933',1,29,1),(436,'2021-04-23 18:18:34','2021-04-23','0000436',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16192198881193228262',1,29,1),(437,'2021-04-23 18:18:57','2021-04-23','0000437',1,11,1,0,210,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619219916629468896',1,29,1),(438,'2021-04-23 18:19:18','2021-04-23','0000438',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619219939379841533',1,29,1),(439,'2021-04-23 18:19:49','2021-04-23','0000439',1,11,1,0,280,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16192199611391604773',1,29,1),(440,'2021-04-23 18:20:17','2021-04-23','0000440',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16192199921195853201',1,29,1),(441,'2021-04-23 18:20:46','2021-04-23','0000441',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619220020492240546',1,29,1),(442,'2021-04-23 18:21:09','2021-04-23','0000442',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619220049744708006',1,29,1),(443,'2021-04-23 18:21:28','2021-04-23','0000443',1,11,1,0,110,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619220072129482630',1,29,1),(444,'2021-04-23 18:21:49','2021-04-23','0000444',1,11,1,0,200,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16192200911403438513',1,29,1),(445,'2021-04-23 18:22:13','2021-04-23','0000445',1,11,1,0,200,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16192201121238024346',1,29,1),(446,'2021-04-23 18:22:32','2021-04-23','0000446',1,11,1,0,200,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619220136565437606',1,29,1),(447,'2021-04-23 18:22:58','2021-04-23','0000447',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619220155382122218',1,29,1),(448,'2021-04-23 18:23:24','2021-04-23','0000448',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16192201811215174470',1,29,1),(449,'2021-04-23 18:24:04','2021-04-23','0000449',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619220206637386744',1,29,1),(450,'2021-04-23 18:24:44','2021-04-23','0000450',1,11,1,0,200,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619220247357120753',1,29,1),(451,'2021-04-23 18:25:22','2021-04-23','0000451',1,11,1,0,150,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619220287435395563',1,29,1),(452,'2021-04-23 18:25:49','2021-04-23','0000452',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161922032417772126',1,29,1),(453,'2021-04-23 18:26:25','2021-04-23','0000453',1,11,1,0,425,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619220351263010247',1,29,1),(454,'2021-04-23 18:26:56','2021-04-23','0000454',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16192203941255538281',1,29,1),(455,'2021-04-23 18:27:36','2021-04-23','0000455',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619220419545944209',1,29,1),(456,'2021-04-26 18:33:20','2021-04-26','0000456',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619479984243258660',1,30,1),(457,'2021-04-26 18:33:50','2021-04-26','0000457',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619480006536692376',1,30,1),(458,'2021-04-26 18:34:18','2021-04-26','0000458',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619480033638548602',1,30,1),(459,'2021-04-26 18:34:44','2021-04-26','0000459',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619480061995884513',1,30,1),(460,'2021-04-26 18:35:11','2021-04-26','0000460',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161948008782707084',1,30,1),(461,'2021-04-26 18:35:33','2021-04-26','0000461',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619480114602531001',1,30,1),(462,'2021-04-26 18:35:56','2021-04-26','0000462',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16194801371220424348',1,30,1),(463,'2021-04-26 18:36:18','2021-04-26','0000463',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619480158264215137',1,30,1),(464,'2021-04-26 18:36:38','2021-04-26','0000464',1,11,1,0,210,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619480181496199470',1,30,1),(465,'2021-04-26 18:37:04','2021-04-26','0000465',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619480201129138376',1,30,1),(466,'2021-04-26 18:37:26','2021-04-26','0000466',1,11,1,0,425,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619480226227465996',1,30,1),(467,'2021-04-26 18:38:04','2021-04-26','0000467',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619480262855643938',1,30,1),(468,'2021-04-26 18:38:24','2021-04-26','0000468',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619480287164166246',1,30,1),(469,'2021-04-26 18:39:31','2021-04-26','0000469',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16194803481084874237',1,30,1),(470,'2021-04-26 18:41:58','2021-04-26','0000470',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619480484938523149',1,30,1),(471,'2021-04-26 18:42:44','2021-04-26','0000471',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619480521421539329',1,30,1),(472,'2021-04-26 18:43:11','2021-04-26','0000472',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619480566310904620',1,30,1),(473,'2021-04-26 18:43:42','2021-04-26','0000473',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619480594367147158',1,30,1),(474,'2021-04-26 18:44:20','2021-04-26','0000474',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16194806251148561273',1,30,1),(475,'2021-04-26 18:44:47','2021-04-26','0000475',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619480662737607762',1,30,1),(476,'2021-04-26 18:45:56','2021-04-26','0000476',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619480731440344218',1,30,1),(477,'2021-04-26 18:46:57','2021-04-26','0000477',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16194807961270556373',1,30,1),(478,'2021-04-26 18:47:25','2021-04-26','0000478',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619480819781285020',1,30,1),(479,'2021-04-26 18:48:16','2021-04-26','0000479',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619480854822982816',1,30,1),(480,'2021-04-26 18:51:45','2021-04-26','0000480',1521,11,1,0,520,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16194809131009912874',1,30,1),(481,'2021-04-26 18:59:03','2021-04-26','0000481',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16194815021121924600',1,30,1),(482,'2021-04-26 18:59:34','2021-04-26','0000482',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619481545838173035',1,30,1),(483,'2021-04-26 19:00:03','2021-04-26','0000483',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619481577563759366',1,30,1),(484,'2021-04-26 19:01:07','2021-04-26','0000484',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16194816311087154921',1,30,1),(485,'2021-04-26 19:01:35','2021-04-26','0000485',1,11,1,0,250,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619481672284526138',1,30,1),(486,'2021-04-26 19:02:00','2021-04-26','0000486',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619481697294810734',1,30,1),(487,'2021-04-27 18:19:34','2021-04-27','0000487',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619565549636009727',1,31,1),(488,'2021-04-27 18:20:03','2021-04-27','0000488',1,11,1,0,435,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619565576107880676',1,31,1),(489,'2021-04-27 18:20:18','2021-04-27','0000489',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619565605445034682',1,31,1),(490,'2021-04-27 18:20:47','2021-04-27','0000490',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619565621352387257',1,31,1),(491,'2021-04-27 18:21:05','2021-04-27','0000491',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619565649195536414',1,31,1),(492,'2021-04-27 18:21:36','2021-04-27','0000492',1,11,1,0,225,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619565668661613637',1,31,1),(493,'2021-04-27 18:22:07','2021-04-27','0000493',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619565699379798502',1,31,1),(494,'2021-04-27 18:22:27','2021-04-27','0000494',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619565730109300725',1,31,1),(495,'2021-04-27 18:22:49','2021-04-27','0000495',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16195657491363031671',1,31,1),(496,'2021-04-27 18:23:16','2021-04-27','0000496',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619565773112011727',1,31,1),(497,'2021-04-27 18:23:35','2021-04-27','0000497',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16195657981192754912',1,31,1),(498,'2021-04-27 18:24:05','2021-04-27','0000498',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619565817299673325',1,31,1),(499,'2021-04-27 18:24:28','2021-04-27','0000499',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619565847468357907',1,31,1),(500,'2021-04-27 18:25:07','2021-04-27','0000500',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161956587486106595',1,31,1),(501,'2021-04-27 18:25:42','2021-04-27','0000501',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619565910469734924',1,31,1),(502,'2021-04-27 18:25:58','2021-04-27','0000502',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161956594575133491',1,31,1),(503,'2021-04-27 18:26:37','2021-04-27','0000503',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619565961554636629',1,31,1),(504,'2021-04-27 18:27:15','2021-04-27','0000504',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619566003317230292',1,31,1),(505,'2021-04-27 18:27:41','2021-04-27','0000505',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619566038926517282',1,31,1),(506,'2021-04-27 18:28:10','2021-04-27','0000506',1,11,1,0,285,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16195660681266425322',1,31,1),(507,'2021-04-27 18:28:39','2021-04-27','0000507',1,11,1,0,270,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619566093252983842',1,31,1),(508,'2021-04-27 18:30:04','2021-04-27','0000508',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619566175798755923',1,31,1),(509,'2021-04-27 18:31:02','2021-04-27','0000509',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16195662421275332901',1,31,1),(510,'2021-04-27 18:31:34','2021-04-27','0000510',1,11,1,0,270,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619566265508463527',1,31,1),(511,'2021-04-27 18:32:07','2021-04-27','0000511',1,11,1,0,270,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161956629679910018',1,31,1),(512,'2021-04-27 18:32:34','2021-04-27','0000512',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161956633553187282',1,31,1),(513,'2021-04-27 18:33:01','2021-04-27','0000513',1,11,1,0,375,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619566357990505541',1,31,1),(514,'2021-04-27 18:33:22','2021-04-27','0000514',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619566383973938305',1,31,1),(515,'2021-04-29 13:35:07','2021-04-29','0000515',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161972129256113443',1,32,1),(516,'2021-04-29 13:35:38','2021-04-29','0000516',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619721310400625884',1,32,1),(517,'2021-04-29 13:36:07','2021-04-29','0000517',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16197213411127303573',1,32,1),(518,'2021-04-29 13:37:05','2021-04-29','0000518',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619721398518231742',1,32,1),(519,'2021-04-29 13:37:37','2021-04-29','0000519',1,11,1,0,285,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16197214281395176411',1,32,1),(520,'2021-04-29 13:38:03','2021-04-29','0000520',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619721460538714870',1,32,1),(521,'2021-04-29 13:39:02','2021-04-29','0000521',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619721511999886469',1,32,1),(522,'2021-04-29 13:39:40','2021-04-29','0000522',1,11,1,0,240,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619721547754045903',1,32,1),(523,'2021-04-29 13:40:27','2021-04-29','0000523',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16197215821283508939',1,32,1),(524,'2021-04-29 13:41:06','2021-04-29','0000524',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619721630666390164',1,32,1),(525,'2021-04-29 13:41:52','2021-04-29','0000525',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16197216751048598445',1,32,1),(526,'2021-04-29 13:42:16','2021-04-29','0000526',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619721714581746651',1,32,1),(527,'2021-04-29 13:43:06','2021-04-29','0000527',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16197217401288414562',1,32,1),(528,'2021-04-29 13:44:01','2021-04-29','0000528',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16197217891070888908',1,32,1),(529,'2021-04-29 13:45:07','2021-04-29','0000529',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619721861121736910',1,32,1),(530,'2021-04-30 18:33:42','2021-04-30','0000530',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619825597562468413',1,33,1),(531,'2021-04-30 18:34:49','2021-04-30','0000531',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16198256701246673734',1,33,1),(532,'2021-04-30 18:35:20','2021-04-30','0000532',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16198256921283939257',1,33,1),(533,'2021-04-30 18:35:44','2021-04-30','0000533',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619825722303632249',1,33,1),(534,'2021-04-30 18:36:04','2021-04-30','0000534',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16198257471109144161',1,33,1),(535,'2021-04-30 18:36:33','2021-04-30','0000535',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16198257661009095270',1,33,1),(536,'2021-04-30 18:36:55','2021-04-30','0000536',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161982579541353542',1,33,1),(537,'2021-04-30 18:37:15','2021-04-30','0000537',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619825818697028793',1,33,1),(538,'2021-04-30 18:37:36','2021-04-30','0000538',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619825837124792166',1,33,1),(539,'2021-04-30 18:38:01','2021-04-30','0000539',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619825858994335369',1,33,1),(540,'2021-04-30 18:38:20','2021-04-30','0000540',1,11,1,0,225,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619825883498394091',1,33,1),(541,'2021-04-30 18:38:43','2021-04-30','0000541',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619825903492498737',1,33,1),(542,'2021-04-30 18:39:10','2021-04-30','0000542',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619825926841228292',1,33,1),(543,'2021-04-30 18:39:39','2021-04-30','0000543',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619825953527053257',1,33,1),(544,'2021-04-30 18:40:14','2021-04-30','0000544',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619825982303933471',1,33,1),(545,'2021-04-30 18:40:31','2021-04-30','0000545',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619826018108181898',1,33,1),(546,'2021-04-30 18:40:52','2021-04-30','0000546',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619826034150180917',1,33,1),(547,'2021-04-30 18:41:09','2021-04-30','0000547',1,11,1,0,220,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16198260551387990104',1,33,1),(548,'2021-04-30 18:41:43','2021-04-30','0000548',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161982607112823471',1,33,1),(549,'2021-04-30 18:42:09','2021-04-30','0000549',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16198261101356146586',1,33,1),(550,'2021-04-30 18:42:29','2021-04-30','0000550',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161982613165666499',1,33,1),(551,'2021-04-30 18:43:00','2021-04-30','0000551',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619826151742599449',1,33,1),(552,'2021-04-30 18:43:29','2021-04-30','0000552',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16198261831201963714',1,33,1),(553,'2021-04-30 18:44:06','2021-04-30','0000553',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619826212557132472',1,33,1),(554,'2021-04-30 18:44:37','2021-04-30','0000554',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16198262501033365195',1,33,1),(555,'2021-04-30 18:45:04','2021-04-30','0000555',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619826280732788203',1,33,1),(556,'2021-04-30 18:45:32','2021-04-30','0000556',1,11,1,0,375,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619826307259610737',1,33,1),(557,'2021-04-30 18:46:20','2021-04-30','0000557',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619826340642765717',1,33,1),(558,'2021-04-30 18:47:05','2021-04-30','0000558',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16198263831371594995',1,33,1),(559,'2021-04-30 18:47:32','2021-04-30','0000559',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619826430757875731',1,33,1),(560,'2021-04-30 18:48:03','2021-04-30','0000560',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619826455386468428',1,33,1),(561,'2021-04-30 18:48:31','2021-04-30','0000561',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619826485902591612',1,33,1),(562,'2021-04-30 18:49:04','2021-04-30','0000562',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16198265171012451749',1,33,1),(563,'2021-04-30 18:49:39','2021-04-30','0000563',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161982654731972614',1,33,1),(564,'2021-04-30 18:50:08','2021-04-30','0000564',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619826582982587693',1,33,1),(565,'2021-04-30 18:50:42','2021-04-30','0000565',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'161982662567904151',1,33,1),(566,'2021-04-30 18:51:26','2021-04-30','0000566',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16198266451008707984',1,33,1),(567,'2021-04-30 18:51:51','2021-04-30','0000567',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619826689497318296',1,33,1),(568,'2021-04-30 18:52:23','2021-04-30','0000568',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619826713935338797',1,33,1),(569,'2021-04-30 18:53:24','2021-04-30','0000569',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16198267711072868370',1,33,1),(570,'2021-04-30 18:53:39','2021-04-30','0000570',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619826806694360822',1,33,1),(571,'2021-04-30 18:54:12','2021-04-30','0000571',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619826821350321731',1,33,1),(572,'2021-04-30 18:54:35','2021-04-30','0000572',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619826854526709003',1,33,1),(573,'2021-04-30 18:55:04','2021-04-30','0000573',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619826878594139804',1,33,1),(574,'2021-04-30 18:55:33','2021-04-30','0000574',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619826911857623400',1,33,1),(575,'2021-04-30 18:55:55','2021-04-30','0000575',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619826935826253232',1,33,1),(576,'2021-04-30 18:56:17','2021-04-30','0000576',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619826958270196555',1,33,1),(577,'2021-04-30 18:56:49','2021-04-30','0000577',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619826980389093366',1,33,1),(578,'2021-04-30 18:57:20','2021-04-30','0000578',1,11,1,0,475,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16198270121185095255',1,33,1),(579,'2021-04-30 18:57:55','2021-04-30','0000579',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16198270461140299171',1,33,1),(580,'2021-04-30 18:59:18','2021-04-30','0000580',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619827132200915387',1,33,1),(581,'2021-04-30 18:59:45','2021-04-30','0000581',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619827161980436104',1,33,1),(582,'2021-04-30 19:00:34','2021-04-30','0000582',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619827188229918808',1,33,1),(583,'2021-04-30 19:01:12','2021-04-30','0000583',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619827237501664506',1,33,1),(584,'2021-04-30 19:02:03','2021-04-30','0000584',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619827302381347646',1,33,1),(585,'2021-04-30 19:02:41','2021-04-30','0000585',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1619827325856676701',1,33,1),(586,'2021-05-04 17:31:43','2021-05-04','0000586',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1620167468808050788',1,34,1),(587,'2021-05-04 17:32:03','2021-05-04','0000587',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1620167507903495279',1,34,1),(588,'2021-05-04 17:40:37','2021-05-04','0000588',1,11,1,0,175,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1620167526228025409',1,34,1),(589,'2021-05-04 17:40:56','2021-05-04','0000589',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1620168041314002908',1,34,1),(590,'2021-05-04 17:41:38','2021-05-04','0000590',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1620168059365167696',1,34,1),(591,'2021-05-04 17:42:20','2021-05-04','0000591',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1620168101960813612',1,34,1),(592,'2021-05-04 17:42:48','2021-05-04','0000592',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1620168142687733928',1,34,1),(593,'2021-05-04 17:43:19','2021-05-04','0000593',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16201681711260960286',1,34,1),(594,'2021-05-04 17:53:29','2021-05-04','0000594',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1620168788516553502',1,34,1),(595,'2021-05-04 17:53:54','2021-05-04','0000595',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1620168812694834172',1,34,1),(596,'2021-05-04 17:56:22','2021-05-04','0000596',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1620168961498738345',1,34,1),(597,'2021-05-04 17:58:31','2021-05-04','0000597',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1620169075202292404',1,34,1),(598,'2021-05-04 18:00:40','2021-05-04','0000598',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1620169204576195551',1,34,1),(599,'2021-05-04 18:01:30','2021-05-04','0000599',1,11,1,0,210,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16201692421314750012',1,34,1),(600,'2021-05-04 18:01:57','2021-05-04','0000600',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16201692931178941711',1,34,1),(601,'2021-05-04 18:14:13','2021-05-04','0000601',1,11,1,0,200,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1620170034495855215',1,34,1),(602,'2021-05-11 18:47:41','2021-05-11','0000602',1538,11,1,0,180,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1620776551608899705',1,35,1),(603,'2021-05-11 18:55:48','2021-05-11','0000603',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1620777326651974518',1,35,1),(604,'2021-05-11 18:56:11','2021-05-11','0000604',1,11,1,0,240,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162077735145183371',1,35,1),(605,'2021-05-11 18:56:35','2021-05-11','0000605',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1620777373421410234',1,35,1),(606,'2021-05-11 18:56:52','2021-05-11','0000606',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16207773991231913833',1,35,1),(607,'2021-05-11 18:57:22','2021-05-11','0000607',1,11,1,0,270,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16207774151043348568',1,35,1),(608,'2021-05-11 18:57:49','2021-05-11','0000608',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16207774451154069341',1,35,1),(609,'2021-05-11 18:58:21','2021-05-11','0000609',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1620777472972991606',1,35,1),(610,'2021-05-11 18:58:50','2021-05-11','0000610',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16207775031208934862',1,35,1),(611,'2021-05-11 18:59:15','2021-05-11','0000611',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1620777533784426340',1,35,1),(612,'2021-05-11 18:59:48','2021-05-11','0000612',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16207775581193529484',1,35,1),(613,'2021-05-11 19:00:12','2021-05-11','0000613',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1620777590687733928',1,35,1),(614,'2021-05-11 19:00:37','2021-05-11','0000614',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1620777615804823405',1,35,1),(615,'2021-05-11 19:01:07','2021-05-11','0000615',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1620777639919589165',1,35,1),(616,'2021-05-11 19:01:32','2021-05-11','0000616',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162077766961707575',1,35,1),(617,'2021-05-21 19:01:15','2021-05-21','0000617',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621641660874147604',1,37,1),(618,'2021-05-21 19:01:39','2021-05-21','0000618',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621641678997003340',1,37,1),(619,'2021-05-21 19:02:17','2021-05-21','0000619',1,11,1,0,475,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621641702336422466',1,37,1),(620,'2021-05-21 19:02:41','2021-05-21','0000620',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621641740559886506',1,37,1),(621,'2021-05-21 19:03:18','2021-05-21','0000621',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621641764229316363',1,37,1),(622,'2021-05-21 19:04:07','2021-05-21','0000622',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16216418001009525588',1,37,1),(623,'2021-05-21 19:04:40','2021-05-21','0000623',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621641852671769137',1,37,1),(624,'2021-05-21 19:05:01','2021-05-21','0000624',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621641883364565251',1,37,1),(625,'2021-05-21 19:05:26','2021-05-21','0000625',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621641903123759403',1,37,1),(626,'2021-05-21 19:08:59','2021-05-21','0000626',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621642119713509965',1,37,1),(627,'2021-05-21 19:09:28','2021-05-21','0000627',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621642142816312890',1,37,1),(628,'2021-05-21 19:09:49','2021-05-21','0000628',1,11,1,0,230,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621642170399377962',1,37,1),(629,'2021-05-21 19:11:37','2021-05-21','0000629',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621642192504977953',1,37,1),(630,'2021-05-21 19:12:04','2021-05-21','0000630',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16216423001287596958',1,37,1),(631,'2021-05-21 19:12:30','2021-05-21','0000631',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621642332886239535',1,37,1),(632,'2021-05-21 19:13:09','2021-05-21','0000632',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162164235264203418',1,37,1),(633,'2021-05-21 19:14:36','2021-05-21','0000633',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16216424561378996461',1,37,1),(634,'2021-05-21 19:15:13','2021-05-21','0000634',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16216424781249169578',1,37,1),(635,'2021-05-21 19:17:18','2021-05-21','0000635',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621642538685496275',1,37,1),(636,'2021-05-21 19:18:16','2021-05-21','0000636',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16216426401001564708',1,37,1),(637,'2021-05-21 19:19:45','2021-05-21','0000637',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621642700662302145',1,37,1),(638,'2021-05-21 19:20:52','2021-05-21','0000638',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16216427881209451243',1,37,1),(639,'2021-05-21 19:28:28','2021-05-21','0000639',1,11,1,0,210,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621643282177247907',1,37,1),(640,'2021-05-21 19:29:43','2021-05-21','0000640',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16216433651191205768',1,37,1),(641,'2021-05-21 19:30:12','2021-05-21','0000641',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621643386219332989',1,37,1),(642,'2021-05-21 19:30:41','2021-05-21','0000642',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621643415445378936',1,37,1),(643,'2021-05-21 19:31:32','2021-05-21','0000643',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162164346262180924',1,37,1),(644,'2021-05-21 19:32:02','2021-05-21','0000644',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16216434951034397957',1,37,1),(645,'2021-05-22 18:20:05','2021-05-22','0000645',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621725502504504604',1,38,1),(646,'2021-05-22 18:21:59','2021-05-22','0000646',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621725610981597962',1,38,1),(647,'2021-05-22 18:23:51','2021-05-22','0000647',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16217257461140815552',1,38,1),(648,'2021-05-22 18:24:38','2021-05-22','0000648',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16217258351189355402',1,38,1),(649,'2021-05-22 18:25:43','2021-05-22','0000649',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621725881992657130',1,38,1),(650,'2021-05-22 18:26:46','2021-05-22','0000650',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16217259471208117258',1,38,1),(651,'2021-05-22 18:27:21','2021-05-22','0000651',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16217260091366345118',1,38,1),(652,'2021-05-22 18:28:12','2021-05-22','0000652',1,11,1,0,475,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621726044633729043',1,38,1),(653,'2021-05-22 18:29:20','2021-05-22','0000653',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621726098590309975',1,38,1),(654,'2021-05-22 18:29:51','2021-05-22','0000654',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621726163561005332',1,38,1),(655,'2021-05-22 18:30:18','2021-05-22','0000655',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621726194232801937',1,38,1),(656,'2021-05-22 18:31:07','2021-05-22','0000656',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16217262211325464926',1,38,1),(657,'2021-05-22 18:31:34','2021-05-22','0000657',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16217262711254161264',1,38,1),(658,'2021-05-22 18:32:36','2021-05-22','0000658',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162172630125302688',1,38,1),(659,'2021-05-22 18:33:08','2021-05-22','0000659',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621726360529420005',1,38,1),(660,'2021-05-22 18:36:17','2021-05-22','0000660',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621726536623616574',1,38,1),(661,'2021-05-22 18:37:03','2021-05-22','0000661',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621726584910423396',1,38,1),(662,'2021-05-22 18:38:01','2021-05-22','0000662',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162172663333779949',1,38,1),(663,'2021-05-22 18:39:08','2021-05-22','0000663',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621726684531786753',1,38,1),(664,'2021-05-22 18:40:27','2021-05-22','0000664',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621726770489787734',1,38,1),(665,'2021-05-22 18:41:37','2021-05-22','0000665',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621726861789159836',1,38,1),(666,'2021-05-22 18:42:29','2021-05-22','0000666',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621726904203411230',1,38,1),(667,'2021-05-22 18:43:14','2021-05-22','0000667',1,11,1,0,375,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621726958802112402',1,38,1),(668,'2021-05-22 18:44:44','2021-05-22','0000668',1,11,1,0,430,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621726997869069854',1,38,1),(669,'2021-05-22 18:47:29','2021-05-22','0000669',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16217272081047350524',1,38,1),(670,'2021-05-22 18:47:52','2021-05-22','0000670',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16217272518778484',1,38,1),(671,'2021-05-22 18:48:36','2021-05-22','0000671',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621727280928711903',1,38,1),(672,'2021-05-24 18:53:15','2021-05-24','0000672',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621900374798024383',1,39,1),(673,'2021-05-24 18:53:36','2021-05-24','0000673',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621900397856891860',1,39,1),(674,'2021-05-24 18:53:59','2021-05-24','0000674',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621900418737908985',1,39,1),(675,'2021-05-24 18:54:27','2021-05-24','0000675',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621900441220796070',1,39,1),(676,'2021-05-24 18:54:55','2021-05-24','0000676',1,11,1,0,280,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621900470208273822',1,39,1),(677,'2021-05-24 18:55:18','2021-05-24','0000677',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16219004981122570077',1,39,1),(678,'2021-05-24 18:55:41','2021-05-24','0000678',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621900520971571557',1,39,1),(679,'2021-05-24 18:56:00','2021-05-24','0000679',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621900544652404836',1,39,1),(680,'2021-05-24 18:56:23','2021-05-24','0000680',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16219005631235872757',1,39,1),(681,'2021-05-24 18:56:52','2021-05-24','0000681',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621900586765535388',1,39,1),(682,'2021-05-24 18:57:14','2021-05-24','0000682',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621900615902849802',1,39,1),(683,'2021-05-24 18:57:38','2021-05-24','0000683',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621900636907669362',1,39,1),(684,'2021-05-24 18:58:10','2021-05-24','0000684',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162190066167129579',1,39,1),(685,'2021-05-24 18:58:34','2021-05-24','0000685',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621900693123673340',1,39,1),(686,'2021-05-24 18:58:55','2021-05-24','0000686',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621900716527440543',1,39,1),(687,'2021-05-24 18:59:49','2021-05-24','0000687',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621900768217869909',1,39,1),(688,'2021-05-24 19:00:15','2021-05-24','0000688',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621900791549515847',1,39,1),(689,'2021-05-24 19:00:47','2021-05-24','0000689',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16219008171108885971',1,39,1),(690,'2021-05-24 19:01:15','2021-05-24','0000690',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621900851764244435',1,39,1),(691,'2021-05-24 19:01:43','2021-05-24','0000691',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16219008781057204802',1,39,1),(692,'2021-05-24 19:02:15','2021-05-24','0000692',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621900905376915372',1,39,1),(693,'2021-05-24 19:02:46','2021-05-24','0000693',1,11,1,0,475,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621900938112140822',1,39,1),(694,'2021-05-24 19:03:15','2021-05-24','0000694',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621900968378894834',1,39,1),(695,'2021-05-24 19:03:38','2021-05-24','0000695',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621900997339649850',1,39,1),(696,'2021-05-24 19:04:07','2021-05-24','0000696',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16219010241062712869',1,39,1),(697,'2021-05-24 19:04:34','2021-05-24','0000697',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16219010491373875679',1,39,1),(698,'2021-05-24 19:05:02','2021-05-24','0000698',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621901077410695320',1,39,1),(699,'2021-05-24 19:06:20','2021-05-24','0000699',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16219011541408731422',1,39,1),(700,'2021-05-24 19:06:42','2021-05-24','0000700',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621901183388146667',1,39,1),(701,'2021-05-24 19:07:09','2021-05-24','0000701',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621901204366759872',1,39,1),(702,'2021-05-24 19:07:37','2021-05-24','0000702',1,11,1,0,225,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621901231630759850',1,39,1),(703,'2021-05-24 19:08:30','2021-05-24','0000703',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621901285777326096',1,39,1),(704,'2021-05-24 19:10:51','2021-05-24','0000704',1,11,1,0,150,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16219013681016281578',1,39,1),(705,'2021-05-24 19:11:45','2021-05-24','0000705',1,11,1,0,180,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1621901454328590682',1,39,1),(706,'2021-05-24 19:12:14','2021-05-24','0000706',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16219015101360363700',1,39,1),(707,'2021-05-26 11:47:43','2021-05-26','0000707',1539,11,1,0,669.5,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16220473861263327034',1,40,1),(708,'2021-05-26 13:09:11','2021-05-26','0000708',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16220525001309801357',1,40,1),(709,'2021-05-26 13:09:47','2021-05-26','0000709',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16220525541103291839',1,40,1),(710,'2021-05-26 13:10:42','2021-05-26','0000710',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622052590302341295',1,40,1),(711,'2021-05-26 13:11:34','2021-05-26','0000711',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622052648774573',1,40,1),(712,'2021-05-26 13:12:10','2021-05-26','0000712',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162205271253918822',1,40,1),(713,'2021-05-26 13:13:05','2021-05-26','0000713',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622052750571591150',1,40,1),(714,'2021-05-26 13:14:24','2021-05-26','0000714',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16220528251254462487',1,40,1),(715,'2021-05-26 13:15:33','2021-05-26','0000715',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16220528681196326550',1,40,1),(716,'2021-05-26 13:16:11','2021-05-26','0000716',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622052936837742717',1,40,1),(717,'2021-05-26 13:20:30','2021-05-26','0000717',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622053108664884052',1,40,1),(718,'2021-05-26 13:23:03','2021-05-26','0000718',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622053316643927575',1,40,1),(719,'2021-05-26 13:24:29','2021-05-26','0000719',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622053387442969156',1,40,1),(720,'2021-05-26 13:25:01','2021-05-26','0000720',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622053472483462063',1,40,1),(721,'2021-05-26 13:25:59','2021-05-26','0000721',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622053545195622478',1,40,1),(722,'2021-05-26 13:26:34','2021-05-26','0000722',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16220535621102129981',1,40,1),(723,'2021-05-26 13:28:12','2021-05-26','0000723',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622053597541124649',1,40,1),(724,'2021-05-26 13:29:05','2021-05-26','0000724',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16220536971248481069',1,40,1),(725,'2021-05-26 13:30:15','2021-05-26','0000725',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622053748583510954',1,40,1),(726,'2021-05-26 13:34:08','2021-05-26','0000726',1,11,1,0,475,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622053818427305588',1,40,1),(727,'2021-05-26 13:34:41','2021-05-26','0000727',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16220540521197359313',1,40,1),(728,'2021-05-26 13:35:06','2021-05-26','0000728',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16220540841300463461',1,40,1),(729,'2021-05-26 13:37:34','2021-05-26','0000729',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622054109474382357',1,40,1),(730,'2021-05-26 13:38:04','2021-05-26','0000730',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622054261993474734',1,40,1),(731,'2021-05-26 13:38:38','2021-05-26','0000731',1,11,1,0,200,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16220542871122613109',1,40,1),(732,'2021-05-26 13:39:24','2021-05-26','0000732',1,11,1,0,230,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622054326507129542',1,40,1),(733,'2021-05-26 13:39:51','2021-05-26','0000733',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622054367883872787',1,40,1),(734,'2021-05-26 13:40:23','2021-05-26','0000734',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16220543941223909922',1,40,1),(735,'2021-05-27 15:43:00','2021-05-27','0000735',1502,11,1,0,98.5,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16221479231363246830',1,41,1),(736,'2021-05-27 15:51:17','2021-05-27','0000736',1540,11,1,0,760,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622148418854869366',1,41,1),(737,'2021-05-27 18:32:36','2021-05-27','0000737',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622158287645218528',1,43,1),(738,'2021-05-27 18:33:05','2021-05-27','0000738',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622158362805253722',1,43,1),(739,'2021-05-27 18:33:30','2021-05-27','0000739',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622158394968129014',1,43,1),(740,'2021-05-27 18:34:04','2021-05-27','0000740',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622158413734337347',1,43,1),(741,'2021-05-27 18:34:30','2021-05-27','0000741',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16221584491116588660',1,43,1),(742,'2021-05-27 18:35:35','2021-05-27','0000742',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16221584761003415075',1,43,1),(743,'2021-05-27 18:36:00','2021-05-27','0000743',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622158538599561808',1,43,1),(744,'2021-05-27 18:36:56','2021-05-27','0000744',1,11,1,0,415,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16221585621078677660',1,43,1),(745,'2021-05-27 18:37:38','2021-05-27','0000745',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16221586271357179348',1,43,1),(746,'2021-05-27 18:38:27','2021-05-27','0000746',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622158680548353989',1,43,1),(747,'2021-05-27 18:38:55','2021-05-27','0000747',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622158711517069884',1,43,1),(748,'2021-05-27 18:39:23','2021-05-27','0000748',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622158737259524673',1,43,1),(749,'2021-05-27 18:40:14','2021-05-27','0000749',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622158792582263032',1,43,1),(750,'2021-05-27 18:40:38','2021-05-27','0000750',1,11,1,0,475,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622158817348428333',1,43,1),(751,'2021-05-27 18:41:03','2021-05-27','0000751',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622158841999284024',1,43,1),(752,'2021-05-27 18:41:39','2021-05-27','0000752',1,11,1,0,270,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162215886643548163',1,43,1),(753,'2021-05-27 18:42:26','2021-05-27','0000753',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16221589021261906985',1,43,1),(754,'2021-05-27 18:42:48','2021-05-27','0000754',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16221589541192582785',1,43,1),(755,'2021-05-27 18:43:16','2021-05-27','0000755',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622158971468573066',1,43,1),(756,'2021-05-27 18:44:00','2021-05-27','0000756',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622159004116271873',1,43,1),(757,'2021-05-27 18:45:17','2021-05-27','0000757',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16221590531263370065',1,43,1),(758,'2021-05-27 18:45:50','2021-05-27','0000758',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622159127493875754',1,43,1),(759,'2021-05-27 18:47:38','2021-05-27','0000759',1,11,1,0,280,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16221591531149206750',1,43,1),(760,'2021-05-27 18:48:57','2021-05-27','0000760',1,11,1,0,490,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622159261776293334',1,43,1),(761,'2021-05-27 18:49:30','2021-05-27','0000761',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622159345964858599',1,43,1),(762,'2021-05-29 18:12:58','2021-05-29','0000762',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16223299271035818006',1,44,1),(763,'2021-05-29 18:14:08','2021-05-29','0000763',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622329981780166194',1,44,1),(764,'2021-05-29 18:16:58','2021-05-29','0000764',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16223301921391088392',1,44,1),(765,'2021-05-29 18:17:39','2021-05-29','0000765',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622330220688637595',1,44,1),(766,'2021-05-29 18:18:11','2021-05-29','0000766',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16223302621022262995',1,44,1),(767,'2021-05-29 18:18:40','2021-05-29','0000767',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622330294776379397',1,44,1),(768,'2021-05-29 18:19:09','2021-05-29','0000768',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622330322616903616',1,44,1),(769,'2021-05-29 18:19:38','2021-05-29','0000769',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622330352703612655',1,44,1),(770,'2021-05-29 18:20:11','2021-05-29','0000770',1,11,1,0,270,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622330381927248822',1,44,1),(771,'2021-05-29 18:20:48','2021-05-29','0000771',1,11,1,0,190,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16223304141354769569',1,44,1),(772,'2021-05-29 18:21:16','2021-05-29','0000772',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622330451705549085',1,44,1),(773,'2021-05-29 18:21:42','2021-05-29','0000773',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162233047978145715',1,44,1),(774,'2021-05-29 18:22:10','2021-05-29','0000774',1,11,1,0,470,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622330509708948596',1,44,1),(775,'2021-05-29 18:22:39','2021-05-29','0000775',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622330533891962762',1,44,1),(776,'2021-05-29 18:23:32','2021-05-29','0000776',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162233056279479700',1,44,1),(777,'2021-05-29 18:25:37','2021-05-29','0000777',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622330615864207263',1,44,1),(778,'2021-05-29 18:26:21','2021-05-29','0000778',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162233075751121757',1,44,1),(779,'2021-05-29 18:26:54','2021-05-29','0000779',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16223307841055612626',1,44,1),(780,'2021-05-29 18:28:18','2021-05-29','0000780',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16223308171014086957',1,44,1),(781,'2021-05-29 18:28:45','2021-05-29','0000781',1,11,1,0,470,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622330905221742769',1,44,1),(782,'2021-05-29 18:29:02','2021-05-29','0000782',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622330928211286046',1,44,1),(783,'2021-05-29 18:29:22','2021-05-29','0000783',1,11,1,0,170,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162233094663557941',1,44,1),(784,'2021-05-29 18:29:53','2021-05-29','0000784',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622330974575334915',1,44,1),(785,'2021-05-29 18:30:37','2021-05-29','0000785',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622330996494392135',1,44,1),(786,'2021-05-29 18:32:42','2021-05-29','0000786',1,11,1,0,220,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622331142630716818',1,44,1),(787,'2021-05-29 18:33:15','2021-05-29','0000787',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16223311651044639521',1,44,1),(788,'2021-05-29 18:35:02','2021-05-29','0000788',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622331205343737869',1,44,1),(789,'2021-05-29 18:35:26','2021-05-29','0000789',1,11,1,0,255,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622331305221484578',1,44,1),(790,'2021-05-29 18:35:53','2021-05-29','0000790',1,11,1,0,340,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16223313331340870303',1,44,1),(791,'2021-05-29 18:44:40','2021-05-29','0000791',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16223318511334286441',1,44,1),(792,'2021-05-29 18:45:16','2021-05-29','0000792',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622331882162918324',1,44,1),(793,'2021-05-29 18:45:53','2021-05-29','0000793',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622331919215546193',1,44,1),(794,'2021-05-29 18:46:26','2021-05-29','0000794',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622331956182540816',1,44,1),(795,'2021-05-29 18:47:01','2021-05-29','0000795',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622332001375839578',1,44,1),(796,'2021-05-29 18:47:43','2021-05-29','0000796',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622332023871178411',1,44,1),(797,'2021-05-29 18:48:21','2021-05-29','0000797',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622332078283622471',1,44,1),(798,'2021-05-29 18:48:49','2021-05-29','0000798',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622332105975444417',1,44,1),(799,'2021-05-29 18:49:24','2021-05-29','0000799',1,11,1,0,250,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622332143207714408',1,44,1),(800,'2021-05-29 18:50:01','2021-05-29','0000800',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622332177889122664',1,44,1),(801,'2021-05-29 18:50:29','2021-05-29','0000801',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622332204957973514',1,44,1),(802,'2021-05-29 18:51:13','2021-05-29','0000802',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1622332242835031715',1,44,1),(803,'2021-05-29 18:51:37','2021-05-29','0000803',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162233227690667964',1,44,1),(804,'2021-05-29 18:52:01','2021-05-29','0000804',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16223322991195336819',1,44,1),(805,'2021-06-14 19:04:35','2021-06-14','0000805',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16237154311357566634',1,45,1),(806,'2021-06-14 19:05:13','2021-06-14','0000806',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1623715477640054714',1,45,1),(807,'2021-06-14 19:05:49','2021-06-14','0000807',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16237155161221414079',1,45,1),(808,'2021-06-14 19:07:01','2021-06-14','0000808',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1623715587275919782',1,45,1),(809,'2021-06-14 19:07:27','2021-06-14','0000809',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1623715623695694807',1,45,1),(810,'2021-06-14 19:07:58','2021-06-14','0000810',1,11,1,0,290,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162371564925689974',1,45,1),(811,'2021-06-14 19:08:14','2021-06-14','0000811',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1623715681638591634',1,45,1),(812,'2021-06-14 19:08:35','2021-06-14','0000812',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162371569679135446',1,45,1),(813,'2021-06-14 19:09:10','2021-06-14','0000813',1,11,1,0,375,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1623715721706151530',1,45,1),(814,'2021-06-14 19:09:36','2021-06-14','0000814',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1623715753300189706',1,45,1),(815,'2021-06-14 19:09:59','2021-06-14','0000815',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162371577856801952',1,45,1),(816,'2021-06-14 19:10:22','2021-06-14','0000816',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1623715802497404360',1,45,1),(817,'2021-06-14 19:10:54','2021-06-14','0000817',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16237158251191076673',1,45,1),(818,'2021-06-14 19:11:22','2021-06-14','0000818',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16237158641082077171',1,45,1),(819,'2021-06-14 19:11:45','2021-06-14','0000819',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1623715884560488951',1,45,1),(820,'2021-06-14 19:12:33','2021-06-14','0000820',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1623715908202077245',1,45,1),(821,'2021-06-14 19:12:56','2021-06-14','0000821',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16237159561023984266',1,45,1),(822,'2021-06-14 19:13:20','2021-06-14','0000822',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1623715979145533485',1,45,1),(823,'2021-06-14 19:14:04','2021-06-14','0000823',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16237160031384074212',1,45,1),(824,'2021-06-14 19:15:29','2021-06-14','0000824',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16237160491198822393',1,45,1),(825,'2021-06-14 19:15:59','2021-06-14','0000825',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1623716132881979388',1,45,1),(826,'2021-06-14 19:16:52','2021-06-14','0000826',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1623716187143812213',1,45,1),(827,'2021-06-14 19:17:14','2021-06-14','0000827',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16237162151025576442',1,45,1),(828,'2021-06-14 19:18:48','2021-06-14','0000828',1,11,1,0,280,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16237162791254376423',1,45,1),(829,'2021-06-14 19:19:14','2021-06-14','0000829',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1623716332388792144',1,45,1),(830,'2021-06-14 19:19:42','2021-06-14','0000830',1,11,1,0,230,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1623716356188995584',1,45,1),(831,'2021-06-14 19:21:24','2021-06-14','0000831',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1623716464262493866',1,45,1),(832,'2021-06-14 19:21:51','2021-06-14','0000832',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1623716486450069400',1,45,1),(833,'2021-06-14 19:22:30','2021-06-14','0000833',1,11,1,0,220,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16237165161027254682',1,45,1),(834,'2021-06-18 19:14:43','2021-06-18','0000834',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624061574999240992',1,46,1),(835,'2021-06-18 19:23:15','2021-06-18','0000835',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624061687593150073',1,46,1),(836,'2021-06-18 19:29:08','2021-06-18','0000836',1,11,1,0,370,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624062199740576955',1,46,1),(837,'2021-06-18 19:29:48','2021-06-18','0000837',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624062552791827807',1,46,1),(838,'2021-06-18 19:39:23','2021-06-18','0000838',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16240631431031729987',1,46,1),(839,'2021-06-18 19:40:23','2021-06-18','0000839',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624063165701202875',1,46,1),(840,'2021-06-18 19:40:48','2021-06-18','0000840',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624063228488324654',1,46,1),(841,'2021-06-18 19:41:11','2021-06-18','0000841',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624063250440516345',1,46,1),(842,'2021-06-18 19:41:32','2021-06-18','0000842',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624063274520641521',1,46,1),(843,'2021-06-18 19:42:22','2021-06-18','0000843',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624063296773797490',1,46,1),(844,'2021-06-18 19:44:03','2021-06-18','0000844',1,11,1,0,370,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162406334650992661',1,46,1),(845,'2021-06-18 19:44:46','2021-06-18','0000845',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16240634461372842917',1,46,1),(846,'2021-06-18 19:45:26','2021-06-18','0000846',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162406348991313440',1,46,1),(847,'2021-06-18 19:46:46','2021-06-18','0000847',1,11,1,0,220,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16240635301336481062',1,46,1),(848,'2021-06-21 19:20:30','2021-06-21','0000848',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16243211991178081075',1,47,1),(849,'2021-06-21 19:20:49','2021-06-21','0000849',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16243212321032805782',1,47,1),(850,'2021-06-21 19:21:05','2021-06-21','0000850',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624321252499340790',1,47,1),(851,'2021-06-21 19:21:36','2021-06-21','0000851',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16243212671141288902',1,47,1),(852,'2021-06-21 19:21:56','2021-06-21','0000852',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16243212981407354405',1,47,1),(853,'2021-06-21 19:22:20','2021-06-21','0000853',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624321320231209761',1,47,1),(854,'2021-06-21 19:22:40','2021-06-21','0000854',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624321342823456166',1,47,1),(855,'2021-06-21 19:23:43','2021-06-21','0000855',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624321362880688435',1,47,1),(856,'2021-06-21 19:24:15','2021-06-21','0000856',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16243214271123344649',1,47,1),(857,'2021-06-21 19:24:41','2021-06-21','0000857',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162432145717858190',1,47,1),(858,'2021-06-21 19:24:59','2021-06-21','0000858',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624321484190458664',1,47,1),(859,'2021-06-21 19:25:19','2021-06-21','0000859',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16243215021128035113',1,47,1),(860,'2021-06-21 19:25:41','2021-06-21','0000860',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624321521630028309',1,47,1),(861,'2021-06-21 19:26:00','2021-06-21','0000861',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16243215441031686955',1,47,1),(862,'2021-06-21 19:29:48','2021-06-21','0000862',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16243215631406020420',1,47,1),(863,'2021-06-21 19:30:14','2021-06-21','0000863',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162432179132445964',1,47,1),(864,'2021-06-21 19:30:37','2021-06-21','0000864',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16243218171029018985',1,47,1),(865,'2021-06-21 19:31:16','2021-06-21','0000865',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16243218411288586689',1,47,1),(866,'2021-06-21 19:31:42','2021-06-21','0000866',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624321882871479634',1,47,1),(867,'2021-06-21 19:32:04','2021-06-21','0000867',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624321905616042980',1,47,1),(868,'2021-06-21 19:32:29','2021-06-21','0000868',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162432192719063080',1,47,1),(869,'2021-06-21 19:32:51','2021-06-21','0000869',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624321952425971603',1,47,1),(870,'2021-06-21 19:35:09','2021-06-21','0000870',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624322072817302621',1,47,1),(871,'2021-06-21 19:35:36','2021-06-21','0000871',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624322112270067459',1,47,1),(872,'2021-06-21 19:36:03','2021-06-21','0000872',1,11,1,0,250,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624322139318607309',1,47,1),(873,'2021-06-21 19:36:24','2021-06-21','0000873',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16243221651202953444',1,47,1),(874,'2021-06-21 19:36:49','2021-06-21','0000874',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16243221871175757359',1,47,1),(875,'2021-06-21 19:37:37','2021-06-21','0000875',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624322211891532444',1,47,1),(876,'2021-06-24 19:09:57','2021-06-24','0000876',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624579770405187252',1,48,1),(877,'2021-06-24 19:10:30','2021-06-24','0000877',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624579801102200481',1,48,1),(878,'2021-06-24 19:10:48','2021-06-24','0000878',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624579833990075223',1,48,1),(879,'2021-06-24 19:11:08','2021-06-24','0000879',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624579850564533938',1,48,1),(880,'2021-06-24 19:11:29','2021-06-24','0000880',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16245798701003242948',1,48,1),(881,'2021-06-24 19:12:06','2021-06-24','0000881',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624579893434190673',1,48,1),(882,'2021-06-24 19:12:30','2021-06-24','0000882',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162457992997423953',1,48,1),(883,'2021-06-24 19:13:00','2021-06-24','0000883',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162457995394626887',1,48,1),(884,'2021-06-24 19:13:21','2021-06-24','0000884',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16245799821033494290',1,48,1),(885,'2021-06-24 19:13:46','2021-06-24','0000885',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16245800031328993532',1,48,1),(886,'2021-06-24 19:14:08','2021-06-24','0000886',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624580028337455229',1,48,1),(887,'2021-06-24 19:14:46','2021-06-24','0000887',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624580054255565749',1,48,1),(888,'2021-06-24 19:15:19','2021-06-24','0000888',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624580091296747164',1,48,1),(889,'2021-06-24 19:15:48','2021-06-24','0000889',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16245801221273009184',1,48,1),(890,'2021-06-24 19:16:28','2021-06-24','0000890',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16245801511169732909',1,48,1),(891,'2021-06-24 19:16:55','2021-06-24','0000891',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16245801901057290865',1,48,1),(892,'2021-06-24 19:17:18','2021-06-24','0000892',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624580217406047888',1,48,1),(893,'2021-06-24 19:17:53','2021-06-24','0000893',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624580242786750057',1,48,1),(894,'2021-06-24 19:18:16','2021-06-24','0000894',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624580276230047903',1,48,1),(895,'2021-06-24 19:18:41','2021-06-24','0000895',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16245802981097869835',1,48,1),(896,'2021-06-24 19:19:05','2021-06-24','0000896',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624580325642894812',1,48,1),(897,'2021-06-24 19:19:27','2021-06-24','0000897',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624580347644702147',1,48,1),(898,'2021-06-24 19:19:51','2021-06-24','0000898',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16245803701225846352',1,48,1),(899,'2021-06-24 19:20:18','2021-06-24','0000899',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16245803931333727028',1,48,1),(900,'2021-06-24 19:20:45','2021-06-24','0000900',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624580421626671830',1,48,1),(901,'2021-06-25 22:46:44','2021-06-25','0000901',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624679182723622433',1,49,1),(902,'2021-06-25 22:46:59','2021-06-25','0000902',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624679208805167659',1,49,1),(903,'2021-06-25 22:47:30','2021-06-25','0000903',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624679222983835615',1,49,1),(904,'2021-06-25 22:47:57','2021-06-25','0000904',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624679254889294791',1,49,1),(905,'2021-06-25 22:48:22','2021-06-25','0000905',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624679281629382833',1,49,1),(906,'2021-06-25 22:48:48','2021-06-25','0000906',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162467930654090949',1,49,1),(907,'2021-06-25 22:49:28','2021-06-25','0000907',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624679330764846880',1,49,1),(908,'2021-06-25 22:49:55','2021-06-25','0000908',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162467937273197060',1,49,1),(909,'2021-06-25 22:50:22','2021-06-25','0000909',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624679402918513371',1,49,1),(910,'2021-06-25 22:50:50','2021-06-25','0000910',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624679425223334945',1,49,1),(911,'2021-06-25 22:51:16','2021-06-25','0000911',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624679454963395518',1,49,1),(912,'2021-06-25 22:51:49','2021-06-25','0000912',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16246794791116631691',1,49,1),(913,'2021-06-25 22:52:29','2021-06-25','0000913',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624679512494478198',1,49,1),(914,'2021-06-25 22:53:20','2021-06-25','0000914',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624679552337369165',1,49,1),(915,'2021-06-25 22:53:51','2021-06-25','0000915',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624679602268432252',1,49,1),(916,'2021-06-25 22:54:15','2021-06-25','0000916',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16246796371347798420',1,49,1),(917,'2021-06-25 22:54:34','2021-06-25','0000917',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162467965752843028',1,49,1),(918,'2021-06-25 22:55:02','2021-06-25','0000918',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16246796771014646370',1,49,1),(919,'2021-06-25 22:55:18','2021-06-25','0000919',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624679704729905074',1,49,1),(920,'2021-06-25 22:55:48','2021-06-25','0000920',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624679721297005354',1,49,1),(921,'2021-06-25 22:56:07','2021-06-25','0000921',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16246797511327831674',1,49,1),(922,'2021-06-25 22:56:41','2021-06-25','0000922',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16246797701374090838',1,49,1),(923,'2021-06-25 22:57:31','2021-06-25','0000923',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16246798041171368117',1,49,1),(924,'2021-06-25 22:57:57','2021-06-25','0000924',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624679854726720722',1,49,1),(925,'2021-06-25 22:58:30','2021-06-25','0000925',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16246798791154413595',1,49,1),(926,'2021-06-25 22:58:56','2021-06-25','0000926',1,11,1,0,240,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624679913447874779',1,49,1),(927,'2021-06-25 22:59:28','2021-06-25','0000927',1,11,1,0,255,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16246799421192109436',1,49,1),(928,'2021-06-25 23:00:00','2021-06-25','0000928',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162467997162137893',1,49,1),(929,'2021-06-28 22:43:16','2021-06-28','0000929',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624938184414094831',1,50,1),(930,'2021-06-28 22:43:35','2021-06-28','0000930',1,11,1,0,240,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624938198348471365',1,50,1),(931,'2021-06-28 22:44:06','2021-06-28','0000931',1,11,1,0,210,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162493821746259165',1,50,1),(932,'2021-06-28 22:44:57','2021-06-28','0000932',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624938249219548148',1,50,1),(933,'2021-06-28 22:45:20','2021-06-28','0000933',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624938299534928073',1,50,1),(934,'2021-06-28 22:45:55','2021-06-28','0000934',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624938323349116842',1,50,1),(935,'2021-06-28 22:46:58','2021-06-28','0000935',1,11,1,0,375,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624938361132365760',1,50,1),(936,'2021-06-28 22:47:29','2021-06-28','0000936',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162493842165279213',1,50,1),(937,'2021-06-28 22:47:55','2021-06-28','0000937',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16249384541191205768',1,50,1),(938,'2021-06-28 22:48:34','2021-06-28','0000938',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624938478219332989',1,50,1),(939,'2021-06-28 22:48:58','2021-06-28','0000939',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624938517445249841',1,50,1),(940,'2021-06-28 22:49:32','2021-06-28','0000940',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624938540876041003',1,50,1),(941,'2021-06-28 22:50:12','2021-06-28','0000941',1,11,1,0,410,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624938575965116790',1,50,1),(942,'2021-06-28 22:50:34','2021-06-28','0000942',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162493861862180924',1,50,1),(943,'2021-06-28 22:50:55','2021-06-28','0000943',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162493863710757946',1,50,1),(944,'2021-06-28 22:51:16','2021-06-28','0000944',1,11,1,0,250,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16249386571240735348',1,50,1),(945,'2021-06-28 22:51:46','2021-06-28','0000945',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624938679637687966',1,50,1),(946,'2021-06-28 22:52:13','2021-06-28','0000946',1,11,1,0,345,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162493870862826401',1,50,1),(947,'2021-06-28 22:52:36','2021-06-28','0000947',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624938736672543709',1,50,1),(948,'2021-06-28 22:53:09','2021-06-28','0000948',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16249387581059055168',1,50,1),(949,'2021-06-28 22:53:49','2021-06-28','0000949',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624938791932154445',1,50,1),(950,'2021-06-28 22:54:15','2021-06-28','0000950',1,11,1,0,250,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16249388351036205292',1,50,1),(951,'2021-06-28 22:54:42','2021-06-28','0000951',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162493885939460144',1,50,1),(952,'2021-06-28 22:55:07','2021-06-28','0000952',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16249388841158716773',1,50,1),(953,'2021-06-28 22:55:29','2021-06-28','0000953',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624938911310861588',1,50,1),(954,'2021-06-28 22:56:11','2021-06-28','0000954',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624938953808222915',1,50,1),(955,'2021-06-28 22:56:32','2021-06-28','0000955',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624938974189985315',1,50,1),(956,'2021-06-28 22:57:25','2021-06-28','0000956',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16249390171048254191',1,50,1),(957,'2021-06-28 22:58:06','2021-06-28','0000957',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624939048835203842',1,50,1),(958,'2021-06-28 22:58:35','2021-06-28','0000958',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624939088690057644',1,50,1),(959,'2021-06-28 22:59:00','2021-06-28','0000959',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624939118871952983',1,50,1),(960,'2021-06-28 22:59:29','2021-06-28','0000960',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16249391431077644898',1,50,1),(961,'2021-06-28 23:00:04','2021-06-28','0000961',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624939183747892358',1,50,1),(962,'2021-06-28 23:00:29','2021-06-28','0000962',1,11,1,0,250,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624939206265204868',1,50,1),(963,'2021-06-28 23:01:05','2021-06-28','0000963',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624939231898159338',1,50,1),(964,'2021-06-28 23:01:55','2021-06-28','0000964',1,11,1,0,190,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624939281496027343',1,50,1),(965,'2021-06-28 23:02:26','2021-06-28','0000965',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624939317372569162',1,50,1),(966,'2021-06-28 23:02:51','2021-06-28','0000966',1,11,1,0,240,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624939349731970599',1,50,1),(967,'2021-06-28 23:03:20','2021-06-28','0000967',1,11,1,0,270,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624939379996659085',1,50,1),(968,'2021-06-28 23:03:42','2021-06-28','0000968',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16249394021359632160',1,50,1),(969,'2021-06-28 23:04:24','2021-06-28','0000969',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1624939428808007756',1,50,1),(970,'2021-06-29 19:47:31','2021-06-29','0000970',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250139421300893779',1,51,1),(971,'2021-06-29 19:48:08','2021-06-29','0000971',1,11,1,0,210,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625014054111624441',1,51,1),(972,'2021-06-29 19:48:37','2021-06-29','0000972',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250140901233204787',1,51,1),(973,'2021-06-29 19:49:02','2021-06-29','0000973',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162501412065795594',1,51,1),(974,'2021-06-29 19:49:16','2021-06-29','0000974',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625014145671123660',1,51,1),(975,'2021-06-29 19:49:35','2021-06-29','0000975',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625014159118208304',1,51,1),(976,'2021-06-29 19:50:00','2021-06-29','0000976',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625014178199237148',1,51,1),(977,'2021-06-29 19:51:01','2021-06-29','0000977',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625014202814204333',1,51,1),(978,'2021-06-29 19:52:21','2021-06-29','0000978',1,11,1,0,415,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162501426461793638',1,51,1),(979,'2021-06-29 19:52:59','2021-06-29','0000979',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625014351304535916',1,51,1),(980,'2021-06-29 19:53:45','2021-06-29','0000980',1,11,1,0,345,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625014382244549613',1,51,1),(981,'2021-06-29 19:54:19','2021-06-29','0000981',1,11,1,0,270,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250144291052385242',1,51,1),(982,'2021-06-29 19:54:42','2021-06-29','0000982',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625014462858484036',1,51,1),(983,'2021-06-29 19:55:09','2021-06-29','0000983',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250144891085734872',1,51,1),(984,'2021-06-29 19:55:31','2021-06-29','0000984',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250145121002210185',1,51,1),(985,'2021-06-29 19:56:35','2021-06-29','0000985',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625014533209607807',1,51,1),(986,'2021-06-29 19:58:16','2021-06-29','0000986',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625014618703053242',1,51,1),(987,'2021-06-29 19:58:46','2021-06-29','0000987',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625014699226132011',1,51,1),(988,'2021-06-29 19:59:49','2021-06-29','0000988',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625014730375753514',1,51,1),(989,'2021-06-29 20:00:20','2021-06-29','0000989',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625014792873803350',1,51,1),(990,'2021-06-29 20:00:52','2021-06-29','0000990',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250148221287209672',1,51,1),(991,'2021-06-29 20:01:25','2021-06-29','0000991',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625014859976434148',1,51,1),(992,'2021-06-29 20:01:53','2021-06-29','0000992',1,11,1,0,200,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162501488778403906',1,51,1),(993,'2021-06-29 20:02:34','2021-06-29','0000993',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625014915366802904',1,51,1),(994,'2021-06-29 20:03:23','2021-06-29','0000994',1,11,1,0,410,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250149571013441480',1,51,1),(995,'2021-06-29 20:03:54','2021-06-29','0000995',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250150061124377412',1,51,1),(996,'2021-06-29 20:04:14','2021-06-29','0000996',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625015036151988252',1,51,1),(997,'2021-06-29 20:05:07','2021-06-29','0000997',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625015078629081610',1,51,1),(998,'2021-06-29 20:06:01','2021-06-29','0000998',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625015138463495316',1,51,1),(999,'2021-06-29 20:06:31','2021-06-29','0000999',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625015167711272312',1,51,1),(1000,'2021-06-29 20:07:36','2021-06-29','0001000',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625015206836839050',1,51,1),(1001,'2021-06-29 20:08:15','2021-06-29','0001001',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625015259721642972',1,51,1),(1002,'2021-06-29 20:08:30','2021-06-29','0001002',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625015297272132985',1,51,1),(1003,'2021-06-29 20:09:11','2021-06-29','0001003',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250153131242456620',1,51,1),(1004,'2021-06-29 20:10:35','2021-06-29','0001004',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162501535421860145',1,51,1),(1005,'2021-06-29 20:11:29','2021-06-29','0001005',1,11,1,0,275,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625015441871780856',1,51,1),(1006,'2021-06-29 20:12:01','2021-06-29','0001006',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625015492341973566',1,51,1),(1007,'2021-06-29 20:13:10','2021-06-29','0001007',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625015566133570649',1,51,1),(1008,'2021-06-29 20:13:41','2021-06-29','0001008',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250156011005824855',1,51,1),(1009,'2021-06-29 20:14:06','2021-06-29','0001009',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250156241350380327',1,51,1),(1010,'2021-06-29 20:14:30','2021-06-29','0001010',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625015649696426348',1,51,1),(1011,'2021-06-29 20:14:55','2021-06-29','0001011',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250156731388248294',1,51,1),(1012,'2021-06-29 20:16:05','2021-06-29','0001012',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625015735240074308',1,51,1),(1013,'2021-06-29 20:16:30','2021-06-29','0001013',1,11,1,0,425,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625015767400970138',1,51,1),(1014,'2021-06-29 20:17:00','2021-06-29','0001014',1,11,1,0,250,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250157931205234129',1,51,1),(1015,'2021-06-29 20:17:31','2021-06-29','0001015',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625015823513885532',1,51,1),(1016,'2021-06-29 20:18:42','2021-06-29','0001016',1,11,1,0,310,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625015895167393629',1,51,1),(1017,'2021-06-29 20:19:12','2021-06-29','0001017',1,11,1,0,425,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250159271084013601',1,51,1),(1018,'2021-06-29 20:19:50','2021-06-29','0001018',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250159621043176441',1,51,1),(1019,'2021-06-29 20:20:18','2021-06-29','0001019',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625015993769709471',1,51,1),(1020,'2021-06-29 20:20:40','2021-06-29','0001020',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625016021909261538',1,51,1),(1021,'2021-06-29 20:21:04','2021-06-29','0001021',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625016042922300167',1,51,1),(1022,'2021-06-30 18:42:07','2021-06-30','0001022',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625096265160895830',1,52,1),(1023,'2021-06-30 18:43:41','2021-06-30','0001023',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250965661239100141',1,52,1),(1024,'2021-06-30 18:43:58','2021-06-30','0001024',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625096623961760311',1,52,1),(1025,'2021-06-30 18:44:22','2021-06-30','0001025',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625096640806974994',1,52,1),(1026,'2021-06-30 18:44:47','2021-06-30','0001026',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625096664462892871',1,52,1),(1027,'2021-06-30 18:45:11','2021-06-30','0001027',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625096690290292397',1,52,1),(1028,'2021-06-30 18:45:47','2021-06-30','0001028',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250967191074116292',1,52,1),(1029,'2021-06-30 18:46:32','2021-06-30','0001029',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625096750919244911',1,52,1),(1030,'2021-06-30 18:55:21','2021-06-30','0001030',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162509730631241074',1,52,1),(1031,'2021-06-30 18:56:03','2021-06-30','0001031',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625097324894243446',1,52,1),(1032,'2021-06-30 18:56:37','2021-06-30','0001032',1,11,1,0,210,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625097366324976012',1,52,1),(1033,'2021-06-30 18:57:03','2021-06-30','0001033',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625097400271960858',1,52,1),(1034,'2021-06-30 18:57:56','2021-06-30','0001034',1,11,1,0,250,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250974261016884022',1,52,1),(1035,'2021-06-30 18:58:27','2021-06-30','0001035',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250974811230795007',1,52,1),(1036,'2021-06-30 18:58:54','2021-06-30','0001036',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250975091216379360',1,52,1),(1037,'2021-06-30 18:59:20','2021-06-30','0001037',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625097540854008731',1,52,1),(1038,'2021-06-30 19:00:22','2021-06-30','0001038',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250975631305196957',1,52,1),(1039,'2021-06-30 19:02:02','2021-06-30','0001039',1,11,1,0,240,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625097642314992639',1,52,1),(1040,'2021-06-30 19:04:05','2021-06-30','0001040',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625097726703784782',1,52,1),(1041,'2021-06-30 19:06:38','2021-06-30','0001041',1,11,1,0,425,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250978631102732426',1,52,1),(1042,'2021-06-30 19:07:07','2021-06-30','0001042',1,11,1,0,425,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625098005805899199',1,52,1),(1043,'2021-06-30 19:07:58','2021-06-30','0001043',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625098030325922711',1,52,1),(1044,'2021-06-30 19:09:03','2021-06-30','0001044',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625098124717727079',1,52,1),(1045,'2021-06-30 19:09:35','2021-06-30','0001045',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250981461018390135',1,52,1),(1046,'2021-06-30 19:10:04','2021-06-30','0001046',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250981781378480080',1,52,1),(1047,'2021-06-30 19:10:20','2021-06-30','0001047',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625098207666175006',1,52,1),(1048,'2021-06-30 19:10:53','2021-06-30','0001048',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625098223764760816',1,52,1),(1049,'2021-06-30 19:11:16','2021-06-30','0001049',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625098256274413669',1,52,1),(1050,'2021-06-30 19:11:47','2021-06-30','0001050',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625098284431909989',1,52,1),(1051,'2021-06-30 19:13:17','2021-06-30','0001051',1,11,1,0,340,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162509835518632762',1,52,1),(1052,'2021-06-30 19:13:52','2021-06-30','0001052',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625098400947559823',1,52,1),(1053,'2021-06-30 19:14:17','2021-06-30','0001053',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162509843687311485',1,52,1),(1054,'2021-06-30 19:14:40','2021-06-30','0001054',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625098461864078167',1,52,1),(1055,'2021-06-30 19:15:57','2021-06-30','0001055',1,11,1,0,345,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625098493593881613',1,52,1),(1056,'2021-06-30 19:16:25','2021-06-30','0001056',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250985601075278150',1,52,1),(1057,'2021-06-30 19:16:52','2021-06-30','0001057',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16250985881402793036',1,52,1),(1058,'2021-06-30 19:18:06','2021-06-30','0001058',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1625098644651802391',1,52,1),(1059,'2021-07-29 19:19:02','2021-07-29','0001059',1,11,1,0,465,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627604270770096757',1,53,1),(1060,'2021-07-29 19:19:42','2021-07-29','0001060',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16276043441287812117',1,53,1),(1061,'2021-07-29 19:20:09','2021-07-29','0001061',1,11,1,0,250,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627604385718802874',1,53,1),(1062,'2021-07-29 19:20:41','2021-07-29','0001062',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627604412975788671',1,53,1),(1063,'2021-07-29 19:21:04','2021-07-29','0001063',1,11,1,0,200,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627604444816528049',1,53,1),(1064,'2021-07-29 19:21:22','2021-07-29','0001064',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627604466119413193',1,53,1),(1065,'2021-07-29 19:21:48','2021-07-29','0001065',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16276044851327573483',1,53,1),(1066,'2021-07-29 19:23:52','2021-07-29','0001066',1,11,1,0,495,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627604511398646422',1,53,1),(1067,'2021-07-29 19:24:18','2021-07-29','0001067',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16276046381167710416',1,53,1),(1068,'2021-07-29 19:25:16','2021-07-29','0001068',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627604670923031708',1,53,1),(1069,'2021-07-30 22:16:28','2021-07-30','0001069',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16277013731132940736',1,54,1),(1070,'2021-07-30 22:16:50','2021-07-30','0001070',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627701390562769635',1,54,1),(1071,'2021-07-30 22:17:12','2021-07-30','0001071',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627701412825521691',1,54,1),(1072,'2021-07-30 22:17:36','2021-07-30','0001072',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627701434817302621',1,54,1),(1073,'2021-07-30 22:18:13','2021-07-30','0001073',1,11,1,0,470,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16277014591257431680',1,54,1),(1074,'2021-07-30 22:18:34','2021-07-30','0001074',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627701495459020011',1,54,1),(1075,'2021-07-30 22:19:00','2021-07-30','0001075',1,11,1,0,250,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627701517548310957',1,54,1),(1076,'2021-07-30 22:19:20','2021-07-30','0001076',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627701543589664499',1,54,1),(1077,'2021-07-30 22:19:44','2021-07-30','0001077',1,11,1,0,425,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627701563400109502',1,54,1),(1078,'2021-07-30 22:20:05','2021-07-30','0001078',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16277015871269050260',1,54,1),(1079,'2021-07-30 22:20:32','2021-07-30','0001079',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627701610781457147',1,54,1),(1080,'2021-07-30 22:20:54','2021-07-30','0001080',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627701634171395585',1,54,1),(1081,'2021-07-30 22:21:21','2021-07-30','0001081',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627701657864723644',1,54,1),(1082,'2021-07-30 22:21:56','2021-07-30','0001082',1,11,1,0,325,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627701684862529023',1,54,1),(1083,'2021-07-30 22:22:37','2021-07-30','0001083',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16277017331186041954',1,54,1),(1084,'2021-07-30 22:23:01','2021-07-30','0001084',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627701759965331949',1,54,1),(1085,'2021-07-30 22:23:27','2021-07-30','0001085',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627701783151730061',1,54,1),(1086,'2021-07-30 22:23:53','2021-07-30','0001086',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627701809846736360',1,54,1),(1087,'2021-07-30 22:24:21','2021-07-30','0001087',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627701836838603353',1,54,1),(1088,'2021-07-30 22:24:58','2021-07-30','0001088',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16277018691349433628',1,54,1),(1089,'2021-07-30 22:25:30','2021-07-30','0001089',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162770190184428355',1,54,1),(1090,'2021-07-30 22:26:09','2021-07-30','0001090',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16277019331179458092',1,54,1),(1091,'2021-07-30 22:26:49','2021-07-30','0001091',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16277019761282949526',1,54,1),(1092,'2021-07-30 22:27:59','2021-07-30','0001092',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627702015300749119',1,54,1),(1093,'2021-07-30 22:30:01','2021-07-30','0001093',1,11,1,0,445,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627702082432942751',1,54,1),(1094,'2021-07-30 22:30:33','2021-07-30','0001094',1,11,1,0,200,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162770221014458679',1,54,1),(1095,'2021-07-30 22:31:03','2021-07-30','0001095',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16277022361079667391',1,54,1),(1096,'2021-07-30 22:31:24','2021-07-30','0001096',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16277022651181867872',1,54,1),(1097,'2021-07-31 23:25:39','2021-07-31','0001097',1541,11,1,0,2750,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627791813753228299',1,55,1),(1098,'2021-07-31 23:29:33','2021-07-31','0001098',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627792154682053733',1,55,1),(1099,'2021-07-31 23:29:51','2021-07-31','0001099',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627792177253112938',1,55,1),(1100,'2021-07-31 23:30:13','2021-07-31','0001100',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627792194403939331',1,55,1),(1101,'2021-07-31 23:30:33','2021-07-31','0001101',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627792216449165733',1,55,1),(1102,'2021-07-31 23:30:57','2021-07-31','0001102',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627792235312238605',1,55,1),(1103,'2021-07-31 23:31:30','2021-07-31','0001103',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16277922601305971529',1,55,1),(1104,'2021-07-31 23:31:51','2021-07-31','0001104',1,11,1,0,270,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162779229391700726',1,55,1),(1105,'2021-07-31 23:32:11','2021-07-31','0001105',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16277923131394143648',1,55,1),(1106,'2021-07-31 23:32:55','2021-07-31','0001106',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16277923381175800391',1,55,1),(1107,'2021-07-31 23:33:17','2021-07-31','0001107',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627792378263569660',1,55,1),(1108,'2021-07-31 23:33:41','2021-07-31','0001108',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16277923991100107487',1,55,1),(1109,'2021-07-31 23:34:03','2021-07-31','0001109',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627792423166619057',1,55,1),(1110,'2021-07-31 23:34:28','2021-07-31','0001110',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16277924501260573000',1,55,1),(1111,'2021-07-31 23:35:05','2021-07-31','0001111',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16277924801380287415',1,55,1),(1112,'2021-07-31 23:35:30','2021-07-31','0001112',1,11,1,0,475,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16277925071201404300',1,55,1),(1113,'2021-07-31 23:36:17','2021-07-31','0001113',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627792549828060567',1,55,1),(1114,'2021-07-31 23:36:43','2021-07-31','0001114',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16277925801170679609',1,55,1),(1115,'2021-07-31 23:37:19','2021-07-31','0001115',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627792605266624917',1,55,1),(1116,'2021-07-31 23:37:47','2021-07-31','0001116',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16277926441295514806',1,55,1),(1117,'2021-07-31 23:38:13','2021-07-31','0001117',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627792670515477708',1,55,1),(1118,'2021-07-31 23:38:45','2021-07-31','0001118',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627792706160895830',1,55,1),(1119,'2021-07-31 23:39:05','2021-07-31','0001119',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627792727939986229',1,55,1),(1120,'2021-07-31 23:39:35','2021-07-31','0001120',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627792748875352494',1,55,1),(1121,'2021-07-31 23:39:59','2021-07-31','0001121',1,11,1,0,210,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16277927781391346583',1,55,1),(1122,'2021-07-31 23:40:25','2021-07-31','0001122',1,11,1,0,280,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1627792802487593113',1,55,1),(1123,'2021-08-24 21:43:04','2021-08-24','0001123',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162985935626378482',1,56,1),(1124,'2021-08-24 21:43:23','2021-08-24','0001124',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16298593882926162',1,56,1),(1125,'2021-08-24 21:44:19','2021-08-24','0001125',1,11,1,0,540,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1629859406216062574',1,56,1),(1126,'2021-08-24 21:44:39','2021-08-24','0001126',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'162985946258178969',1,56,1),(1127,'2021-08-24 21:45:04','2021-08-24','0001127',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1629859483783909959',1,56,1),(1128,'2021-08-24 21:45:26','2021-08-24','0001128',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1629859507901946135',1,56,1),(1129,'2021-08-24 21:45:54','2021-08-24','0001129',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16298595291056215071',1,56,1),(1130,'2021-08-24 21:46:41','2021-08-24','0001130',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1629859567506225875',1,56,1),(1131,'2021-08-24 21:47:21','2021-08-24','0001131',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1629859605940631706',1,56,1),(1132,'2021-08-24 21:48:03','2021-08-24','0001132',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1629859647279061102',1,56,1),(1133,'2021-08-24 21:48:44','2021-08-24','0001133',1,11,1,0,250,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16298596861376672745',1,56,1),(1134,'2021-08-24 21:49:53','2021-08-24','0001134',1,11,1,0,370,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1629859727218773576',1,56,1),(1135,'2021-08-24 21:50:20','2021-08-24','0001135',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1629859797387931508',1,56,1),(1136,'2021-08-24 21:50:46','2021-08-24','0001136',1,11,1,0,270,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16298598241253171533',1,56,1),(1137,'2021-08-24 21:51:21','2021-08-24','0001137',1,11,1,0,270,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16298598551267544148',1,56,1),(1138,'2021-08-24 21:51:50','2021-08-24','0001138',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1629859884729087470',1,56,1),(1139,'2021-08-24 21:52:20','2021-08-24','0001139',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16298599181312039010',1,56,1),(1140,'2021-08-24 21:52:47','2021-08-24','0001140',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16298599431291684977',1,56,1),(1141,'2021-08-24 21:53:26','2021-08-24','0001141',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1629859970217310496',1,56,1),(1142,'2021-08-24 21:54:18','2021-08-24','0001142',1,11,1,0,530,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1629860009554980883',1,56,1),(1143,'2021-08-24 21:54:52','2021-08-24','0001143',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1629860061824316802',1,56,1),(1144,'2021-08-24 21:55:33','2021-08-24','0001144',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16298601061058323628',1,56,1),(1145,'2021-08-24 21:57:20','2021-08-24','0001145',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1629860137702407765',1,56,1),(1146,'2021-08-24 21:58:07','2021-08-24','0001146',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1629860248219074799',1,56,1),(1147,'2021-08-24 21:59:00','2021-08-24','0001147',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16298602941182771539',1,56,1),(1148,'2021-08-24 21:59:27','2021-08-24','0001148',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1629860343279061102',1,56,1),(1149,'2021-08-24 21:59:59','2021-08-24','0001149',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16298603731376672745',1,56,1),(1150,'2021-08-26 18:58:10','2021-08-26','0001150',1,11,1,0,490,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630022264605629289',1,57,1),(1151,'2021-08-26 18:58:35','2021-08-26','0001151',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630022293321490438',1,57,1),(1152,'2021-08-26 18:58:57','2021-08-26','0001152',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16300223195809291',1,57,1),(1153,'2021-08-26 18:59:13','2021-08-26','0001153',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630022340860377434',1,57,1),(1154,'2021-08-26 18:59:36','2021-08-26','0001154',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630022356477222454',1,57,1),(1155,'2021-08-26 19:00:06','2021-08-26','0001155',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630022378294724670',1,57,1),(1156,'2021-08-26 19:00:28','2021-08-26','0001156',1,11,1,0,270,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630022408862873278',1,57,1),(1157,'2021-08-26 19:01:05','2021-08-26','0001157',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630022431630802881',1,57,1),(1158,'2021-08-26 19:01:30','2021-08-26','0001158',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16300224681363246830',1,57,1),(1159,'2021-08-26 19:01:52','2021-08-26','0001159',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630022492963782804',1,57,1),(1160,'2021-08-26 19:02:26','2021-08-26','0001160',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630022514425455221',1,57,1),(1161,'2021-08-26 19:02:48','2021-08-26','0001161',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630022549219462085',1,57,1),(1162,'2021-08-26 19:03:10','2021-08-26','0001162',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630022571873028778',1,57,1),(1163,'2021-08-26 19:03:33','2021-08-26','0001163',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630022592530108513',1,57,1),(1164,'2021-08-26 19:04:01','2021-08-26','0001164',1,11,1,0,260,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630022615596979901',1,57,1),(1165,'2021-08-26 19:04:39','2021-08-26','0001165',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630022659540737363',1,57,1),(1166,'2021-08-26 19:05:01','2021-08-26','0001166',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630022681774916317',1,57,1),(1167,'2021-08-26 19:05:29','2021-08-26','0001167',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630022704331990193',1,57,1),(1168,'2021-08-26 19:05:58','2021-08-26','0001168',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630022732469476734',1,57,1),(1169,'2021-08-26 19:06:12','2021-08-26','0001169',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163002276048755009',1,57,1),(1170,'2021-08-26 19:06:37','2021-08-26','0001170',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630022774898718751',1,57,1),(1171,'2021-08-26 19:06:58','2021-08-26','0001171',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630022799935683051',1,57,1),(1172,'2021-08-26 19:07:20','2021-08-26','0001172',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630022820729474756',1,57,1),(1173,'2021-08-26 19:07:39','2021-08-26','0001173',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16300228421256571044',1,57,1),(1174,'2021-08-26 19:07:59','2021-08-26','0001174',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16300228621227868846',1,57,1),(1175,'2021-08-26 19:08:18','2021-08-26','0001175',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630022881333797527',1,57,1),(1176,'2021-08-26 19:08:39','2021-08-26','0001176',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163002290045054275',1,57,1),(1177,'2021-08-26 19:09:00','2021-08-26','0001177',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16300229211009826810',1,57,1),(1178,'2021-08-26 19:09:19','2021-08-26','0001178',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16300229421235270312',1,57,1),(1179,'2021-08-26 19:09:39','2021-08-26','0001179',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630022963129697789',1,57,1),(1180,'2021-08-26 19:10:04','2021-08-26','0001180',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630022982355958895',1,57,1),(1181,'2021-08-26 19:11:05','2021-08-26','0001181',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630023007709809232',1,57,1),(1182,'2021-08-26 19:11:34','2021-08-26','0001182',1,11,1,0,430,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16300230681250159308',1,57,1),(1183,'2021-08-26 19:12:02','2021-08-26','0001183',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16300230961283853193',1,57,1),(1184,'2021-08-26 19:12:30','2021-08-26','0001184',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16300231311047178396',1,57,1),(1185,'2021-08-26 19:13:01','2021-08-26','0001185',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16300231521073815069',1,57,1),(1186,'2021-08-26 19:13:43','2021-08-26','0001186',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630023184475113897',1,57,1),(1187,'2021-08-26 19:14:07','2021-08-26','0001187',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16300232271278732411',1,57,1),(1188,'2021-08-26 19:14:31','2021-08-26','0001188',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16300232501167839511',1,57,1),(1189,'2021-08-26 19:15:21','2021-08-26','0001189',1,11,1,0,430,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16300232741081818980',1,57,1),(1190,'2021-08-26 19:15:50','2021-08-26','0001190',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630023324778143700',1,57,1),(1191,'2021-08-26 19:16:18','2021-08-26','0001191',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630023355849533425',1,57,1),(1192,'2021-08-26 19:16:50','2021-08-26','0001192',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630023380881204816',1,57,1),(1193,'2021-08-26 19:17:13','2021-08-26','0001193',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630023413462634680',1,57,1),(1194,'2021-08-26 19:17:44','2021-08-26','0001194',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16300234361089091351',1,57,1),(1195,'2021-08-26 19:18:07','2021-08-26','0001195',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630023466992829257',1,57,1),(1196,'2021-08-26 19:18:21','2021-08-26','0001196',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630023490589320244',1,57,1),(1197,'2021-08-26 19:18:47','2021-08-26','0001197',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630023503247647901',1,57,1),(1198,'2021-08-26 19:19:11','2021-08-26','0001198',1,11,1,0,340,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630023529690315835',1,57,1),(1199,'2021-08-26 19:19:43','2021-08-26','0001199',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16300235541066757857',1,57,1),(1200,'2021-08-26 19:20:06','2021-08-26','0001200',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630023585345243981',1,57,1),(1201,'2021-08-26 19:20:28','2021-08-26','0001201',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630023609577056187',1,57,1),(1202,'2021-08-26 19:21:22','2021-08-26','0001202',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630023630941492342',1,57,1),(1203,'2021-08-31 21:08:06','2021-08-31','0001203',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16304620621400684479',1,58,1),(1204,'2021-08-31 21:08:25','2021-08-31','0001204',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630462089511518784',1,58,1),(1205,'2021-08-31 21:09:04','2021-08-31','0001205',1,11,1,0,430,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630462107787481597',1,58,1),(1206,'2021-08-31 21:09:29','2021-08-31','0001206',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16304621471145893303',1,58,1),(1207,'2021-08-31 21:09:51','2021-08-31','0001207',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630462172804091864',1,58,1),(1208,'2021-08-31 21:11:31','2021-08-31','0001208',1,11,1,0,405,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630462272733046394',1,58,1),(1209,'2021-08-31 21:12:00','2021-08-31','0001209',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16304622951051008225',1,58,1),(1210,'2021-08-31 21:12:20','2021-08-31','0001210',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163046232396606349',1,58,1),(1211,'2021-08-31 21:12:38','2021-08-31','0001211',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163046234378834224',1,58,1),(1212,'2021-08-31 21:13:01','2021-08-31','0001212',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16304623601311350501',1,58,1),(1213,'2021-08-31 21:13:29','2021-08-31','0001213',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630462387209435680',1,58,1),(1214,'2021-08-31 21:14:50','2021-08-31','0001214',1,11,1,0,405,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630462429848156408',1,58,1),(1215,'2021-08-31 21:15:21','2021-08-31','0001215',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630462492462032235',1,58,1),(1216,'2021-08-31 21:15:59','2021-08-31','0001216',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630462524829136361',1,58,1),(1217,'2021-08-31 21:16:21','2021-08-31','0001217',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630462562346534935',1,58,1),(1218,'2021-08-31 21:16:41','2021-08-31','0001218',1,11,1,0,280,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630462584898847847',1,58,1),(1219,'2021-08-31 21:18:12','2021-08-31','0001219',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630462604682354955',1,58,1),(1220,'2021-08-31 21:18:56','2021-08-31','0001220',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16304626971225717257',1,58,1),(1221,'2021-08-31 21:19:53','2021-08-31','0001221',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630462775420377471',1,58,1),(1222,'2021-08-31 21:21:16','2021-08-31','0001222',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630462859692467424',1,58,1),(1223,'2021-08-31 21:21:35','2021-08-31','0001223',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630462878737521699',1,58,1),(1224,'2021-08-31 21:22:08','2021-08-31','0001224',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16304628971252310898',1,58,1),(1225,'2021-08-31 21:22:44','2021-08-31','0001225',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630462930880129022',1,58,1),(1226,'2021-08-31 21:23:07','2021-08-31','0001226',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630462966889897236',1,58,1),(1227,'2021-08-31 21:24:13','2021-08-31','0001227',1,11,1,0,320,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630463036410652289',1,58,1),(1228,'2021-08-31 21:24:35','2021-08-31','0001228',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630463055430403876',1,58,1),(1229,'2021-08-31 21:25:07','2021-08-31','0001229',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16304630781396424333',1,58,1),(1230,'2021-08-31 21:25:32','2021-08-31','0001230',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630463110456265977',1,58,1),(1231,'2021-08-31 21:26:07','2021-08-31','0001231',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16304631351363160766',1,58,1),(1232,'2021-08-31 21:26:49','2021-08-31','0001232',1,11,1,0,490,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16304631691198349044',1,58,1),(1233,'2021-08-31 21:27:47','2021-08-31','0001233',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630463240240031276',1,58,1),(1234,'2021-08-31 21:28:35','2021-08-31','0001234',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630463270148201455',1,58,1),(1235,'2021-08-31 21:29:14','2021-08-31','0001235',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163046333135587284',1,58,1),(1236,'2021-08-31 21:30:14','2021-08-31','0001236',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630463357755552015',1,58,1),(1237,'2021-08-31 21:30:38','2021-08-31','0001237',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16304634171185310414',1,58,1),(1238,'2021-08-31 21:31:12','2021-08-31','0001238',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630463441253887510',1,58,1),(1239,'2021-08-31 21:31:53','2021-08-31','0001239',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630463479444303142',1,58,1),(1240,'2021-08-31 21:32:14','2021-08-31','0001240',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630463515264043010',1,58,1),(1241,'2021-08-31 21:33:31','2021-08-31','0001241',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630463537869026822',1,58,1),(1242,'2021-08-31 21:34:02','2021-08-31','0001242',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16304636161286865418',1,58,1),(1243,'2021-08-31 21:34:20','2021-08-31','0001243',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630463644657009236',1,58,1),(1244,'2021-08-31 21:35:19','2021-08-31','0001244',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16304636761302615050',1,58,1),(1245,'2021-08-31 21:35:53','2021-08-31','0001245',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630463722650468405',1,58,1),(1246,'2021-08-31 21:36:40','2021-08-31','0001246',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630463757609803372',1,58,1),(1247,'2021-08-31 21:39:44','2021-08-31','0001247',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16304638611212463468',1,58,1),(1248,'2021-08-31 21:40:19','2021-08-31','0001248',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630463994343823932',1,58,1),(1249,'2021-08-31 21:41:22','2021-08-31','0001249',1,11,1,0,445,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1630464031889768141',1,58,1),(1250,'2021-08-31 21:42:08','2021-08-31','0001250',1,11,1,0,180,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16304640971214141708',1,58,1),(1251,'2021-09-22 22:31:23','2021-09-22','0001251',1534,11,1,0,5000,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632367809164596564',1,59,1),(1252,'2021-09-22 22:33:25','2021-09-22','0001252',1534,11,1,0,5000,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632367942453598006',1,59,1),(1253,'2021-09-22 22:34:17','2021-09-22','0001253',1534,11,1,0,5000,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16323680081201490364',1,59,1),(1254,'2021-09-22 22:35:25','2021-09-22','0001254',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368109714843950',1,59,1),(1255,'2021-09-22 22:35:57','2021-09-22','0001255',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368127375753514',1,59,1),(1256,'2021-09-22 22:36:26','2021-09-22','0001256',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368161943729994',1,59,1),(1257,'2021-09-22 22:36:55','2021-09-22','0001257',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368189501965728',1,59,1),(1258,'2021-09-22 22:37:43','2021-09-22','0001258',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368217759683066',1,59,1),(1259,'2021-09-22 22:38:10','2021-09-22','0001259',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368265196095828',1,59,1),(1260,'2021-09-22 22:38:30','2021-09-22','0001260',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368292856762765',1,59,1),(1261,'2021-09-22 22:38:52','2021-09-22','0001261',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368313813128538',1,59,1),(1262,'2021-09-22 22:39:23','2021-09-22','0001262',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368334263655724',1,59,1),(1263,'2021-09-22 22:39:47','2021-09-22','0001263',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368365871780856',1,59,1),(1264,'2021-09-22 22:40:12','2021-09-22','0001264',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368389262752057',1,59,1),(1265,'2021-09-22 22:40:36','2021-09-22','0001265',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368415319510976',1,59,1),(1266,'2021-09-22 22:40:58','2021-09-22','0001266',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16323684381118998439',1,59,1),(1267,'2021-09-22 22:41:22','2021-09-22','0001267',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368460161713434',1,59,1),(1268,'2021-09-22 22:41:42','2021-09-22','0001268',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368485891145158',1,59,1),(1269,'2021-09-22 22:42:07','2021-09-22','0001269',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368504457298740',1,59,1),(1270,'2021-09-22 22:42:27','2021-09-22','0001270',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368529589277213',1,59,1),(1271,'2021-09-22 22:42:50','2021-09-22','0001271',1,11,1,0,540,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368549877073765',1,59,1),(1272,'2021-09-22 22:43:13','2021-09-22','0001272',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163236857363687037',1,59,1),(1273,'2021-09-22 22:43:39','2021-09-22','0001273',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368597333539337',1,59,1),(1274,'2021-09-22 22:44:02','2021-09-22','0001274',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368622573613644',1,59,1),(1275,'2021-09-22 22:44:29','2021-09-22','0001275',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368645968172046',1,59,1),(1276,'2021-09-22 22:44:56','2021-09-22','0001276',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16323686711403094259',1,59,1),(1277,'2021-09-22 22:45:18','2021-09-22','0001277',1,11,1,0,375,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368699675641997',1,59,1),(1278,'2021-09-22 22:45:40','2021-09-22','0001278',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163236872121558923',1,59,1),(1279,'2021-09-22 22:46:01','2021-09-22','0001279',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16323687431244479113',1,59,1),(1280,'2021-09-22 22:46:28','2021-09-22','0001280',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368764989429746',1,59,1),(1281,'2021-09-22 22:46:58','2021-09-22','0001281',1,11,1,0,280,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368790403638108',1,59,1),(1282,'2021-09-22 22:47:28','2021-09-22','0001282',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368828727624389',1,59,1),(1283,'2021-09-22 22:47:48','2021-09-22','0001283',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16323688501135350516',1,59,1),(1284,'2021-09-22 22:48:21','2021-09-22','0001284',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16323688711256226790',1,59,1),(1285,'2021-09-22 22:48:50','2021-09-22','0001285',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368903373257671',1,59,1),(1286,'2021-09-22 22:49:09','2021-09-22','0001286',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368933227595091',1,59,1),(1287,'2021-09-22 22:49:33','2021-09-22','0001287',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16323689511104195507',1,59,1),(1288,'2021-09-22 22:49:53','2021-09-22','0001288',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16323689751050491844',1,59,1),(1289,'2021-09-22 22:50:22','2021-09-22','0001289',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632368996245582376',1,59,1),(1290,'2021-09-22 22:50:50','2021-09-22','0001290',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163236902989850360',1,59,1),(1291,'2021-09-22 22:51:28','2021-09-22','0001291',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632369052527440543',1,59,1),(1292,'2021-09-22 22:51:55','2021-09-22','0001292',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632369090363790679',1,59,1),(1293,'2021-09-22 22:52:26','2021-09-22','0001293',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632369118838904575',1,59,1),(1294,'2021-09-22 22:53:32','2021-09-22','0001294',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632369149390470383',1,59,1),(1295,'2021-09-22 22:54:01','2021-09-22','0001295',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632369220411857179',1,59,1),(1296,'2021-09-22 22:54:23','2021-09-22','0001296',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632369244764244435',1,59,1),(1297,'2021-09-22 22:55:03','2021-09-22','0001297',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16323692721227997941',1,59,1),(1298,'2021-09-22 22:55:31','2021-09-22','0001298',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632369305581058142',1,59,1),(1299,'2021-09-22 22:55:56','2021-09-22','0001299',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632369334604940781',1,59,1),(1300,'2021-09-22 22:56:27','2021-09-22','0001300',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632369365930002856',1,59,1),(1301,'2021-09-22 22:56:58','2021-09-22','0001301',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632369397917824862',1,59,1),(1302,'2021-09-22 22:57:31','2021-09-22','0001302',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632369421133742777',1,59,1),(1303,'2021-09-23 22:23:14','2021-09-23','0001303',1542,11,1,0,528,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632453643972475224',1,60,1),(1304,'2021-09-23 22:26:51','2021-09-23','0001304',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632453979853922667',1,60,1),(1305,'2021-09-23 22:27:14','2021-09-23','0001305',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632454014263010247',1,60,1),(1306,'2021-09-23 22:27:53','2021-09-23','0001306',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632454037293003399',1,60,1),(1307,'2021-09-23 22:28:39','2021-09-23','0001307',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16324540861125840493',1,60,1),(1308,'2021-09-23 22:29:05','2021-09-23','0001308',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163245412218546698',1,60,1),(1309,'2021-09-23 22:30:07','2021-09-23','0001309',1,11,1,0,375,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16324541471034742212',1,60,1),(1310,'2021-09-23 22:30:38','2021-09-23','0001310',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632454213982028280',1,60,1),(1311,'2021-09-23 22:31:43','2021-09-23','0001311',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16324542411002812630',1,60,1),(1312,'2021-09-23 22:32:17','2021-09-23','0001312',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632454306669488453',1,60,1),(1313,'2021-09-23 22:33:03','2021-09-23','0001313',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163245433986622976',1,60,1),(1314,'2021-09-23 22:33:26','2021-09-23','0001314',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632454386728571088',1,60,1),(1315,'2021-09-23 22:34:43','2021-09-23','0001315',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632454409591084547',1,60,1),(1316,'2021-09-23 22:36:09','2021-09-23','0001316',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16324544871318106491',1,60,1),(1317,'2021-09-23 22:36:42','2021-09-23','0001317',1,11,1,0,210,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632454573543061079',1,60,1),(1318,'2021-09-23 22:37:17','2021-09-23','0001318',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163245460547679214',1,60,1),(1319,'2021-09-23 22:38:09','2021-09-23','0001319',1,11,1,0,265,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632454643595602884',1,60,1),(1320,'2021-09-23 22:39:49','2021-09-23','0001320',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16324546911137545137',1,60,1),(1321,'2021-09-23 22:41:05','2021-09-23','0001321',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16324548381034311894',1,60,1),(1322,'2021-09-23 22:41:46','2021-09-23','0001322',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632454868101856227',1,60,1),(1323,'2021-09-23 22:42:06','2021-09-23','0001323',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632454912903839533',1,60,1),(1324,'2021-09-23 22:42:52','2021-09-23','0001324',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16324549291347884484',1,60,1),(1325,'2021-09-23 22:43:19','2021-09-23','0001325',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1632454979109300725',1,60,1),(1326,'2021-09-23 22:44:23','2021-09-23','0001326',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163245500232704154',1,60,1),(1327,'2021-09-23 22:44:57','2021-09-23','0001327',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16324550671070931940',1,60,1),(1328,'2021-09-23 22:45:26','2021-09-23','0001328',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16324551051363031671',1,60,1),(1329,'2021-09-30 23:26:50','2021-09-30','0001329',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16330623891010859573',1,61,1),(1330,'2021-09-30 23:27:18','2021-09-30','0001330',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163306241231068947',1,61,1),(1331,'2021-09-30 23:28:54','2021-09-30','0001331',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16330625091053547100',1,61,1),(1332,'2021-09-30 23:29:40','2021-09-30','0001332',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1633062561394515371',1,61,1),(1333,'2021-09-30 23:30:11','2021-09-30','0001333',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1633062582625682099',1,61,1),(1334,'2021-09-30 23:30:32','2021-09-30','0001334',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1633062613638204348',1,61,1),(1335,'2021-09-30 23:30:53','2021-09-30','0001335',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1633062634353678210',1,61,1),(1336,'2021-09-30 23:31:33','2021-09-30','0001336',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1633062656372913417',1,61,1),(1337,'2021-09-30 23:31:56','2021-09-30','0001337',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1633062696841873768',1,61,1),(1338,'2021-09-30 23:32:17','2021-09-30','0001338',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16330627182538876',1,61,1),(1339,'2021-09-30 23:32:44','2021-09-30','0001339',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1633062739414051799',1,61,1),(1340,'2021-09-30 23:33:09','2021-09-30','0001340',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1633062766940674738',1,61,1),(1341,'2021-09-30 23:34:28','2021-09-30','0001341',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16330628141089779860',1,61,1),(1342,'2021-09-30 23:34:51','2021-09-30','0001342',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1633062871412416592',1,61,1),(1343,'2021-09-30 23:35:21','2021-09-30','0001343',1,11,1,0,490,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16330628931058194532',1,61,1),(1344,'2021-09-30 23:35:46','2021-09-30','0001344',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16330629231317245855',1,61,1),(1345,'2021-09-30 23:36:04','2021-09-30','0001345',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1633062948247604870',1,61,1),(1346,'2021-09-30 23:36:26','2021-09-30','0001346',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1633062966398000945',1,61,1),(1347,'2021-09-30 23:36:48','2021-09-30','0001347',1,11,1,0,405,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1633062988427477715',1,61,1),(1348,'2021-09-30 23:37:15','2021-09-30','0001348',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16330630101052256147',1,61,1),(1349,'2021-09-30 23:37:45','2021-09-30','0001349',1,11,1,0,490,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16330630391225028748',1,61,1),(1350,'2021-09-30 23:38:09','2021-09-30','0001350',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16330630671023467885',1,61,1),(1351,'2021-09-30 23:38:30','2021-09-30','0001351',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1633063091615827822',1,61,1),(1352,'2021-09-30 23:38:56','2021-09-30','0001352',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16330631121052901623',1,61,1),(1353,'2021-09-30 23:39:43','2021-09-30','0001353',1,11,1,0,345,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16330631381184363715',1,61,1),(1354,'2021-09-30 23:40:18','2021-09-30','0001354',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16330631901068565192',1,61,1),(1355,'2021-09-30 23:41:05','2021-09-30','0001355',1,11,1,0,490,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16330632211178683520',1,61,1),(1356,'2021-09-30 23:41:32','2021-09-30','0001356',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1633063268670564247',1,61,1),(1357,'2021-09-30 23:41:54','2021-09-30','0001357',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1633063295200097783',1,61,1),(1358,'2021-09-30 23:42:31','2021-09-30','0001358',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16330633161294826297',1,61,1),(1359,'2021-09-30 23:43:03','2021-09-30','0001359',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1633063359792946633',1,61,1),(1360,'2021-09-30 23:43:58','2021-09-30','0001360',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1633063420882323643',1,61,1),(1361,'2021-09-30 23:44:37','2021-09-30','0001361',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16330634411154929977',1,61,1),(1362,'2021-09-30 23:45:05','2021-09-30','0001362',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16330634791011289891',1,61,1),(1363,'2021-09-30 23:45:30','2021-09-30','0001363',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163306350966570166',1,61,1),(1364,'2021-09-30 23:45:52','2021-09-30','0001364',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163306353318159412',1,61,1),(1365,'2021-09-30 23:46:10','2021-09-30','0001365',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1633063554306386283',1,61,1),(1366,'2021-09-30 23:46:36','2021-09-30','0001366',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16330635811320860525',1,61,1),(1367,'2021-09-30 23:47:01','2021-09-30','0001367',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1633063599838818512',1,61,1),(1368,'2021-09-30 23:47:33','2021-09-30','0001368',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1633063623112226886',1,61,1),(1369,'2021-09-30 23:48:01','2021-09-30','0001369',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16330636621079323137',1,61,1),(1370,'2021-09-30 23:48:58','2021-09-30','0001370',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1633063685216665019',1,61,1),(1371,'2021-09-30 23:49:35','2021-09-30','0001371',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1633063740394085053',1,61,1),(1372,'2021-09-30 23:50:01','2021-09-30','0001372',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163306377848410754',1,61,1),(1373,'2021-09-30 23:50:27','2021-09-30','0001373',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1633063808611610707',1,61,1),(1374,'2021-09-30 23:51:16','2021-09-30','0001374',1,11,1,0,490,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1633063830230306094',1,61,1),(1375,'2021-10-25 20:00:35','2021-10-25','0001375',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635210009269723205',1,62,1),(1376,'2021-10-25 20:01:34','2021-10-25','0001376',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635210077131849378',1,62,1),(1377,'2021-10-25 20:15:25','2021-10-25','0001377',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16352108921107767144',1,62,1),(1378,'2021-10-25 20:15:51','2021-10-25','0001378',1,11,1,0,280,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635210927759855193',1,62,1),(1379,'2021-10-25 20:23:00','2021-10-25','0001379',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635211309646294323',1,62,1),(1380,'2021-10-25 20:23:30','2021-10-25','0001380',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16352113831080269836',1,62,1),(1381,'2021-10-25 20:23:54','2021-10-25','0001381',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635211412842777436',1,62,1),(1382,'2021-10-25 20:24:22','2021-10-25','0001382',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16352114371355845363',1,62,1),(1383,'2021-10-25 20:42:01','2021-10-25','0001383',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635211465674006790',1,62,1),(1384,'2021-10-25 20:42:29','2021-10-25','0001384',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16352125231024629743',1,62,1),(1385,'2021-10-25 20:42:53','2021-10-25','0001385',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635212552341414153',1,62,1),(1386,'2021-10-25 20:43:53','2021-10-25','0001386',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635212606775217539',1,62,1),(1387,'2021-10-25 20:44:45','2021-10-25','0001387',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635212635496156438',1,62,1),(1388,'2021-10-25 20:45:48','2021-10-25','0001388',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16352126881092318735',1,62,1),(1389,'2021-10-25 20:46:19','2021-10-25','0001389',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635212751968774491',1,62,1),(1390,'2021-10-25 20:47:00','2021-10-25','0001390',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635212781267184330',1,62,1),(1391,'2021-10-25 20:47:26','2021-10-25','0001391',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635212822918556402',1,62,1),(1392,'2021-10-25 20:47:58','2021-10-25','0001392',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635212849222087023',1,62,1),(1393,'2021-10-25 20:49:01','2021-10-25','0001393',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635212881745568642',1,62,1),(1394,'2021-10-25 20:49:35','2021-10-25','0001394',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635212944814032206',1,62,1),(1395,'2021-10-25 20:50:53','2021-10-25','0001395',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635212978423518791',1,62,1),(1396,'2021-10-25 20:51:33','2021-10-25','0001396',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635213056206896805',1,62,1),(1397,'2021-10-25 20:52:23','2021-10-25','0001397',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635213101873330000',1,62,1),(1398,'2021-10-25 20:53:31','2021-10-25','0001398',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635213147981210676',1,62,1),(1399,'2021-10-25 20:54:24','2021-10-25','0001399',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635213215159432750',1,62,1),(1400,'2021-10-25 20:55:12','2021-10-25','0001400',1,11,1,0,405,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635213267987019966',1,62,1),(1401,'2021-10-25 20:55:53','2021-10-25','0001401',1,11,1,0,375,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16352133151025017029',1,62,1),(1402,'2021-10-25 20:56:31','2021-10-25','0001402',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635213356698664000',1,62,1),(1403,'2021-10-25 20:57:48','2021-10-25','0001403',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635213394872813619',1,62,1),(1404,'2021-10-25 20:58:54','2021-10-25','0001404',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635213471760457638',1,62,1),(1405,'2021-10-25 20:59:50','2021-10-25','0001405',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635213537383542267',1,62,1),(1406,'2021-10-25 21:00:56','2021-10-25','0001406',1,11,1,0,690,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163521359350992661',1,62,1),(1407,'2021-10-25 21:01:45','2021-10-25','0001407',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635213659459407297',1,62,1),(1408,'2021-10-25 21:02:55','2021-10-25','0001408',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635213714471025878',1,62,1),(1409,'2021-10-25 21:03:54','2021-10-25','0001409',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635213778926861536',1,62,1),(1410,'2021-10-25 21:05:30','2021-10-25','0001410',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16352138371002855662',1,62,1),(1411,'2021-10-25 21:06:14','2021-10-25','0001411',1,11,1,0,230,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16352139341127432668',1,62,1),(1412,'2021-10-25 21:07:04','2021-10-25','0001412',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635213985540393109',1,62,1),(1413,'2021-10-25 21:08:25','2021-10-25','0001413',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635214028638118284',1,62,1),(1414,'2021-10-25 21:09:11','2021-10-25','0001414',1,11,1,0,330,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635214115338961341',1,62,1),(1415,'2021-10-25 21:09:42','2021-10-25','0001415',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635214154445465000',1,62,1),(1416,'2021-10-25 21:11:03','2021-10-25','0001416',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635214185233060128',1,62,1),(1417,'2021-10-25 21:12:22','2021-10-25','0001417',1,11,1,0,470,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16352142691399694748',1,62,1),(1418,'2021-10-25 21:13:19','2021-10-25','0001418',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163521434616266014',1,62,1),(1419,'2021-10-25 21:14:35','2021-10-25','0001419',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635214402827630249',1,62,1),(1420,'2021-10-25 21:15:44','2021-10-25','0001420',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16352144791082378394',1,62,1),(1421,'2021-10-25 21:16:48','2021-10-25','0001421',1,11,1,0,385,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16352145471011591113',1,62,1),(1422,'2021-10-25 21:17:40','2021-10-25','0001422',1,11,1,0,375,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16352146251073944164',1,62,1),(1423,'2021-10-25 21:18:16','2021-10-25','0001423',1,11,1,0,375,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635214663976218989',1,62,1),(1424,'2021-10-25 21:19:11','2021-10-25','0001424',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635214699964815567',1,62,1),(1425,'2021-10-25 21:20:04','2021-10-25','0001425',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16352147551071319226',1,62,1),(1426,'2021-10-25 21:20:54','2021-10-25','0001426',1,11,1,0,225,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16352148081169044401',1,62,1),(1427,'2021-10-25 21:21:45','2021-10-25','0001427',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16352148572409780',1,62,1),(1428,'2021-10-25 21:24:15','2021-10-25','0001428',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635215016150094853',1,62,1),(1429,'2021-10-25 21:25:17','2021-10-25','0001429',1,11,1,0,270,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635215058815151032',1,62,1),(1430,'2021-10-25 21:26:12','2021-10-25','0001430',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635215126268174061',1,62,1),(1431,'2021-10-25 21:26:48','2021-10-25','0001431',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635215176673791631',1,62,1),(1432,'2021-10-25 21:27:32','2021-10-25','0001432',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16352152111389022866',1,62,1),(1433,'2021-10-25 21:28:17','2021-10-25','0001433',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635215254652749090',1,62,1),(1434,'2021-10-25 21:29:17','2021-10-25','0001434',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635215311552269881',1,62,1),(1435,'2021-10-25 21:30:03','2021-10-25','0001435',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635215367197300717',1,62,1),(1436,'2021-10-25 21:30:50','2021-10-25','0001436',1,11,1,0,375,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635215407689240040',1,62,1),(1437,'2021-10-25 22:05:24','2021-10-25','0001437',1534,11,1,0,5000,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16352173301095847341',1,62,1),(1438,'2021-10-29 21:39:58','2021-10-29','0001438',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355615671197746599',1,63,1),(1439,'2021-10-29 21:40:20','2021-10-29','0001439',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635561601345674299',1,63,1),(1440,'2021-10-29 21:40:36','2021-10-29','0001440',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163556162218933984',1,63,1),(1441,'2021-10-29 21:40:56','2021-10-29','0001441',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355616391012021431',1,63,1),(1442,'2021-10-29 21:42:09','2021-10-29','0001442',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635561702394730530',1,63,1),(1443,'2021-10-29 21:42:54','2021-10-29','0001443',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355617461000661041',1,63,1),(1444,'2021-10-29 21:43:44','2021-10-29','0001444',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635561781873330000',1,63,1),(1445,'2021-10-29 21:44:12','2021-10-29','0001445',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163556182715319315',1,63,1),(1446,'2021-10-29 21:44:36','2021-10-29','0001446',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635561855981210676',1,63,1),(1447,'2021-10-29 21:45:07','2021-10-29','0001447',1,11,1,0,490,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635561878274155479',1,63,1),(1448,'2021-10-29 21:45:25','2021-10-29','0001448',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355619091281916763',1,63,1),(1449,'2021-10-29 21:45:51','2021-10-29','0001449',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635561927129826884',1,63,1),(1450,'2021-10-29 21:46:14','2021-10-29','0001450',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355619531264704051',1,63,1),(1451,'2021-10-29 21:46:36','2021-10-29','0001451',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635561976719964732',1,63,1),(1452,'2021-10-29 21:46:59','2021-10-29','0001452',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635561998303158899',1,63,1),(1453,'2021-10-29 21:47:27','2021-10-29','0001453',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635562022542114380',1,63,1),(1454,'2021-10-29 21:48:00','2021-10-29','0001454',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635562050803145165',1,63,1),(1455,'2021-10-29 21:48:21','2021-10-29','0001455',1,11,1,0,470,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635562083297995085',1,63,1),(1456,'2021-10-29 21:48:41','2021-10-29','0001456',1,11,1,0,470,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635562103926043932',1,63,1),(1457,'2021-10-29 21:49:00','2021-10-29','0001457',1,11,1,0,470,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355621231002855662',1,63,1),(1458,'2021-10-29 21:49:28','2021-10-29','0001458',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635562143219246926',1,63,1),(1459,'2021-10-29 21:49:51','2021-10-29','0001459',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355621711037668373',1,63,1),(1460,'2021-10-29 21:50:14','2021-10-29','0001460',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635562193366114395',1,63,1),(1461,'2021-10-29 21:51:22','2021-10-29','0001461',1,11,1,0,470,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635562218223248881',1,63,1),(1462,'2021-10-29 21:51:50','2021-10-29','0001462',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635562285273983352',1,63,1),(1463,'2021-10-29 21:52:24','2021-10-29','0001463',1,11,1,0,340,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635562313882495770',1,63,1),(1464,'2021-10-29 21:52:46','2021-10-29','0001464',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355623461189183275',1,63,1),(1465,'2021-10-29 21:53:08','2021-10-29','0001465',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355623691009826810',1,63,1),(1466,'2021-10-29 21:53:40','2021-10-29','0001466',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635562390129697789',1,63,1),(1467,'2021-10-29 21:54:15','2021-10-29','0001467',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355624241089091351',1,63,1),(1468,'2021-10-29 21:54:41','2021-10-29','0001468',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635562459629813150',1,63,1),(1469,'2021-10-29 21:55:11','2021-10-29','0001469',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355624931219262490',1,63,1),(1470,'2021-10-29 21:55:56','2021-10-29','0001470',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635562513538628806',1,63,1),(1471,'2021-10-29 21:56:22','2021-10-29','0001471',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635562559247217584',1,63,1),(1472,'2021-10-29 21:56:47','2021-10-29','0001472',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355625841121236092',1,63,1),(1473,'2021-10-29 21:57:25','2021-10-29','0001473',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635562609609114864',1,63,1),(1474,'2021-10-29 21:57:52','2021-10-29','0001474',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635562648992829257',1,63,1),(1475,'2021-10-29 21:58:24','2021-10-29','0001475',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635562675924236598',1,63,1),(1476,'2021-10-29 21:59:33','2021-10-29','0001476',1,11,1,0,405,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355627151063014092',1,63,1),(1477,'2021-10-29 22:00:03','2021-10-29','0001477',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355627771325206735',1,63,1),(1478,'2021-10-29 22:00:43','2021-10-29','0001478',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635562819182669912',1,63,1),(1479,'2021-10-29 22:01:09','2021-10-29','0001479',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355628461071319226',1,63,1),(1480,'2021-10-29 22:01:28','2021-10-29','0001480',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635562872364264029',1,63,1),(1481,'2021-10-29 22:01:50','2021-10-29','0001481',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355628901169044401',1,63,1),(1482,'2021-10-29 22:02:13','2021-10-29','0001482',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635562913896954448',1,63,1),(1483,'2021-10-29 22:02:43','2021-10-29','0001483',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635562935675297743',1,63,1),(1484,'2021-10-29 22:03:09','2021-10-29','0001484',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355629651304078130',1,63,1),(1485,'2021-10-29 22:03:47','2021-10-29','0001485',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635562992247346679',1,63,1),(1486,'2021-10-29 22:04:20','2021-10-29','0001486',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355630301275548059',1,63,1),(1487,'2021-10-29 22:04:52','2021-10-29','0001487',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635563063615655694',1,63,1),(1488,'2021-10-29 22:05:13','2021-10-29','0001488',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635563094417236151',1,63,1),(1489,'2021-10-29 22:05:42','2021-10-29','0001489',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355631161032117273',1,63,1),(1490,'2021-10-29 22:06:04','2021-10-29','0001490',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163556314528487040',1,63,1),(1491,'2021-10-29 22:06:23','2021-10-29','0001491',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355631661225502098',1,63,1),(1492,'2021-10-29 22:06:46','2021-10-29','0001492',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635563185764072308',1,63,1),(1493,'2021-10-29 22:07:08','2021-10-29','0001493',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635563208726161309',1,63,1),(1494,'2021-10-29 22:07:33','2021-10-29','0001494',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355632301005566664',1,63,1),(1495,'2021-10-29 22:07:55','2021-10-29','0001495',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635563256195837637',1,63,1),(1496,'2021-10-29 22:08:22','2021-10-29','0001496',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355632771101097218',1,63,1),(1497,'2021-10-29 22:08:44','2021-10-29','0001497',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635563305254619050',1,63,1),(1498,'2021-10-29 22:09:08','2021-10-29','0001498',1,11,1,0,490,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355633261030783288',1,63,1),(1499,'2021-10-29 22:09:30','2021-10-29','0001499',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163556335089204883',1,63,1),(1500,'2021-10-29 22:10:02','2021-10-29','0001500',1,11,1,0,455,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635563372415945198',1,63,1),(1501,'2021-10-29 22:10:25','2021-10-29','0001501',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355634051389022866',1,63,1),(1502,'2021-10-29 22:10:55','2021-10-29','0001502',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635563434678008745',1,63,1),(1503,'2021-10-29 22:11:17','2021-10-29','0001503',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355634571364408688',1,63,1),(1504,'2021-10-29 22:11:55','2021-10-29','0001504',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635563496291239096',1,63,1),(1505,'2021-10-29 22:12:19','2021-10-29','0001505',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635563517197300717',1,63,1),(1506,'2021-10-29 22:12:51','2021-10-29','0001506',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635563541863992104',1,63,1),(1507,'2021-10-29 22:13:10','2021-10-29','0001507',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355635741097697708',1,63,1),(1508,'2021-10-29 22:13:33','2021-10-29','0001508',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635563592787997978',1,63,1),(1509,'2021-10-29 22:13:59','2021-10-29','0001509',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635563615232758905',1,63,1),(1510,'2021-10-29 22:14:24','2021-10-29','0001510',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635563642674996521',1,63,1),(1511,'2021-10-29 22:14:57','2021-10-29','0001511',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355636661083583283',1,63,1),(1512,'2021-10-29 22:15:43','2021-10-29','0001512',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635563708843422912',1,63,1),(1513,'2021-10-29 22:16:14','2021-10-29','0001513',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635563746474812674',1,63,1),(1514,'2021-10-29 22:16:38','2021-10-29','0001514',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635563777106675786',1,63,1),(1515,'2021-10-29 22:17:17','2021-10-29','0001515',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355638001143698682',1,63,1),(1516,'2021-10-29 22:17:58','2021-10-29','0001516',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635563840785975484',1,63,1),(1517,'2021-10-29 22:18:23','2021-10-29','0001517',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355638801303131431',1,63,1),(1518,'2021-10-29 22:18:48','2021-10-29','0001518',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635563905343307551',1,63,1),(1519,'2021-10-29 22:19:19','2021-10-29','0001519',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163556393150691439',1,63,1),(1520,'2021-10-29 22:19:49','2021-10-29','0001520',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635563961717210698',1,63,1),(1521,'2021-10-29 22:20:29','2021-10-29','0001521',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355639971044639521',1,63,1),(1522,'2021-10-29 22:20:54','2021-10-29','0001522',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163556403143634227',1,63,1),(1523,'2021-10-29 22:25:30','2021-10-29','0001523',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355643071098988661',1,63,1),(1524,'2021-10-29 22:25:52','2021-10-29','0001524',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355643338305134',1,63,1),(1525,'2021-10-29 22:26:40','2021-10-29','0001525',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635564364317273323',1,63,1),(1526,'2021-10-29 22:27:12','2021-10-29','0001526',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635564403223076754',1,63,1),(1527,'2021-10-29 22:27:43','2021-10-29','0001527',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16355644351334286441',1,63,1),(1528,'2021-10-31 19:22:31','2021-10-31','0001528',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635726131219720275',1,63,1),(1529,'2021-10-31 19:23:05','2021-10-31','0001529',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635726154264903646',1,63,1),(1530,'2021-10-31 19:23:26','2021-10-31','0001530',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357261871343667369',1,63,1),(1531,'2021-10-31 19:23:53','2021-10-31','0001531',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357262091325852212',1,63,1),(1532,'2021-10-31 19:24:20','2021-10-31','0001532',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635726235617549093',1,63,1),(1533,'2021-10-31 19:24:44','2021-10-31','0001533',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357262631379684970',1,63,1),(1534,'2021-10-31 19:25:13','2021-10-31','0001534',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635726287864508485',1,63,1),(1535,'2021-10-31 19:25:47','2021-10-31','0001535',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635726315668756912',1,63,1),(1536,'2021-10-31 19:26:27','2021-10-31','0001536',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635726349286720759',1,63,1),(1537,'2021-10-31 19:26:53','2021-10-31','0001537',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357263901408344136',1,63,1),(1538,'2021-10-31 19:27:40','2021-10-31','0001538',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635726416559843474',1,63,1),(1539,'2021-10-31 19:28:11','2021-10-31','0001539',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635726463480191647',1,63,1),(1540,'2021-10-31 19:28:52','2021-10-31','0001540',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635726494863088436',1,63,1),(1541,'2021-10-31 19:29:40','2021-10-31','0001541',1,11,1,0,390,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635726535463968666',1,63,1),(1542,'2021-10-31 19:30:31','2021-10-31','0001542',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635726604222646437',1,63,1),(1543,'2021-10-31 19:31:04','2021-10-31','0001543',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635726633286978949',1,63,1),(1544,'2021-10-31 19:32:09','2021-10-31','0001544',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635726667680332462',1,63,1),(1545,'2021-10-31 19:32:44','2021-10-31','0001545',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357267321229030704',1,63,1),(1546,'2021-10-31 19:33:15','2021-10-31','0001546',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635726768815581350',1,63,1),(1547,'2021-10-31 19:35:06','2021-10-31','0001547',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635726832311033715',1,63,1),(1548,'2021-10-31 19:36:34','2021-10-31','0001548',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357269541046102602',1,63,1),(1549,'2021-10-31 19:38:28','2021-10-31','0001549',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357269981275677155',1,63,1),(1550,'2021-10-31 19:45:50','2021-10-31','0001550',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357275241283465907',1,63,1),(1551,'2021-10-31 19:46:28','2021-10-31','0001551',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357275531103291839',1,63,1),(1552,'2021-10-31 19:47:20','2021-10-31','0001552',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357275911407698660',1,63,1),(1553,'2021-10-31 19:47:50','2021-10-31','0001553',1,11,1,0,470,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357276441031471796',1,63,1),(1554,'2021-10-31 19:48:20','2021-10-31','0001554',1,11,1,0,470,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635727672918857625',1,63,1),(1555,'2021-10-31 19:49:22','2021-10-31','0001555',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635727702319295817',1,63,1),(1556,'2021-10-31 19:49:45','2021-10-31','0001556',1,11,1,0,470,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635727764673189186',1,63,1),(1557,'2021-10-31 19:50:13','2021-10-31','0001557',1,11,1,0,470,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357277871197101122',1,63,1),(1558,'2021-10-31 19:50:40','2021-10-31','0001558',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635727815595344694',1,63,1),(1559,'2021-10-31 19:51:13','2021-10-31','0001559',1,11,1,0,490,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357278421251966643',1,63,1),(1560,'2021-10-31 19:51:39','2021-10-31','0001560',1,11,1,0,470,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635727876184778469',1,63,1),(1561,'2021-10-31 19:52:46','2021-10-31','0001561',1,11,1,0,470,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357279451170335354',1,63,1),(1562,'2021-10-31 19:53:26','2021-10-31','0001562',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635727969187274312',1,63,1),(1563,'2021-10-31 19:53:59','2021-10-31','0001563',1,11,1,0,470,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635728009446454731',1,63,1),(1564,'2021-10-31 19:54:51','2021-10-31','0001564',1,11,1,0,750,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357280411270384246',1,63,1),(1565,'2021-10-31 19:55:15','2021-10-31','0001565',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635728094396107547',1,63,1),(1566,'2021-10-31 19:56:03','2021-10-31','0001566',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357281221032763',1,63,1),(1567,'2021-10-31 19:56:36','2021-10-31','0001567',1,11,1,0,405,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357281651155016040',1,63,1),(1568,'2021-10-31 19:57:03','2021-10-31','0001568',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635728199978671801',1,63,1),(1569,'2021-10-31 19:57:35','2021-10-31','0001569',1,11,1,0,350,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357282251262638525',1,63,1),(1570,'2021-10-31 19:58:07','2021-10-31','0001570',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635728257634331487',1,63,1),(1571,'2021-10-31 19:58:41','2021-10-31','0001571',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635728290302341295',1,63,1),(1572,'2021-10-31 19:59:09','2021-10-31','0001572',1,11,1,0,460,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357283231012193558',1,63,1),(1573,'2021-10-31 19:59:44','2021-10-31','0001573',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635728351787352501',1,63,1),(1574,'2021-10-31 20:00:33','2021-10-31','0001574',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635728386136841065',1,63,1),(1575,'2021-10-31 20:01:11','2021-10-31','0001575',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635728437829351520',1,63,1),(1576,'2021-10-31 20:03:52','2021-10-31','0001576',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635728610130085075',1,63,1),(1577,'2021-10-31 20:04:33','2021-10-31','0001577',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163572863457576524',1,63,1),(1578,'2021-10-31 20:05:10','2021-10-31','0001578',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357286761254505518',1,63,1),(1579,'2021-10-31 20:05:43','2021-10-31','0001579',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357287131145161762',1,63,1),(1580,'2021-10-31 20:06:09','2021-10-31','0001580',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635728747610965230',1,63,1),(1581,'2021-10-31 20:06:39','2021-10-31','0001581',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357287711393369076',1,63,1),(1582,'2021-10-31 20:07:18','2021-10-31','0001582',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635728802413578450',1,63,1),(1583,'2021-10-31 20:07:50','2021-10-31','0001583',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635728840783780864',1,63,1),(1584,'2021-10-31 20:08:35','2021-10-31','0001584',1,11,1,0,375,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635728873962663978',1,63,1),(1585,'2021-10-31 20:09:37','2021-10-31','0001585',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357289191032633654',1,63,1),(1586,'2021-10-31 20:10:16','2021-10-31','0001586',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635728979406133952',1,63,1),(1587,'2021-10-31 20:10:41','2021-10-31','0001587',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635729018644443956',1,63,1),(1588,'2021-10-31 20:11:05','2021-10-31','0001588',1,11,1,0,280,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635729044714198473',1,63,1),(1589,'2021-10-31 20:12:56','2021-10-31','0001589',1,11,1,0,250,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357290681172874229',1,63,1),(1590,'2021-10-31 20:13:21','2021-10-31','0001590',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635729180162100720',1,63,1),(1591,'2021-10-31 20:13:47','2021-10-31','0001591',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163572920348152564',1,63,1),(1592,'2021-10-31 20:14:26','2021-10-31','0001592',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163572922933478726',1,63,1),(1593,'2021-10-31 20:15:12','2021-10-31','0001593',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163572929582405862',1,63,1),(1594,'2021-10-31 20:15:38','2021-10-31','0001594',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357293141269695737',1,63,1),(1595,'2021-10-31 20:16:51','2021-10-31','0001595',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'163572934169410264',1,63,1),(1596,'2021-10-31 20:17:38','2021-10-31','0001596',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635729419936457623',1,63,1),(1597,'2021-10-31 20:18:49','2021-10-31','0001597',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635729461745654705',1,63,1),(1598,'2021-10-31 20:19:18','2021-10-31','0001598',1,11,1,0,300,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635729532642077208',1,63,1),(1599,'2021-10-31 20:19:42','2021-10-31','0001599',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635729561741480623',1,63,1),(1600,'2021-10-31 20:20:06','2021-10-31','0001600',1,11,1,0,450,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357295851338288396',1,63,1),(1601,'2021-10-31 20:20:30','2021-10-31','0001601',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635729609735068887',1,63,1),(1602,'2021-10-31 20:21:04','2021-10-31','0001602',1,11,1,0,360,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635729633551021959',1,63,1),(1603,'2021-10-31 20:21:25','2021-10-31','0001603',1,11,1,0,500,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357296681204932906',1,63,1),(1604,'2021-10-31 20:21:54','2021-10-31','0001604',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635729687325363298',1,63,1),(1605,'2021-10-31 20:22:22','2021-10-31','0001605',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635729716887057139',1,63,1),(1606,'2021-10-31 20:23:09','2021-10-31','0001606',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357297451394789125',1,63,1),(1607,'2021-10-31 20:23:37','2021-10-31','0001607',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635729791447272334',1,63,1),(1608,'2021-10-31 20:24:02','2021-10-31','0001608',1,11,1,0,380,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357298211331575439',1,63,1),(1609,'2021-10-31 20:24:26','2021-10-31','0001609',1,11,1,0,400,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357298451121365187',1,63,1),(1610,'2021-10-31 20:24:54','2021-10-31','0001610',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357298691105271301',1,63,1),(1611,'2021-10-31 20:25:22','2021-10-31','0001611',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357298961075794531',1,63,1),(1612,'2021-10-31 20:25:48','2021-10-31','0001612',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357299251286176909',1,63,1),(1613,'2021-10-31 20:26:13','2021-10-31','0001613',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357299511141719220',1,63,1),(1614,'2021-10-31 20:26:37','2021-10-31','0001614',1,11,1,0,440,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357299751237421901',1,63,1),(1615,'2021-10-31 20:27:06','2021-10-31','0001615',1,11,1,0,480,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'16357300001044596490',1,63,1),(1616,'2021-10-31 20:27:34','2021-10-31','0001616',1,11,1,0,420,'GENERADO AUTOMATICAMENTE','AAURAZO',NULL,NULL,'1635730029740964241',1,63,1);
/*!40000 ALTER TABLE `operacion_caja` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `operacion_caja_detalle`
--

DROP TABLE IF EXISTS `operacion_caja_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operacion_caja_detalle` (
  `opecajdet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `opecajdet_fechahora` datetime DEFAULT NULL,
  `opecajdet_fecha` date DEFAULT NULL,
  `opecaj_codi_fk` int(11) DEFAULT NULL,
  `opecajtip_codi_fk` int(11) NOT NULL,
  `opecajdet_monto` float DEFAULT NULL,
  `opecajdet_eliminado` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`opecajdet_codi`),
  KEY `fk_operacion_caja_detalle_operacion_caja1_idx` (`opecaj_codi_fk`),
  KEY `fk_operacion_caja_detalle_operacion_caja_tipo1_idx` (`opecajtip_codi_fk`),
  CONSTRAINT `fk_operacion_caja_detalle_operacion_caja1` FOREIGN KEY (`opecaj_codi_fk`) REFERENCES `operacion_caja` (`opecaj_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_operacion_caja_detalle_operacion_caja_tipo1` FOREIGN KEY (`opecajtip_codi_fk`) REFERENCES `operacion_caja_tipo` (`opecajtip_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `operacion_caja_detalle`
--

LOCK TABLES `operacion_caja_detalle` WRITE;
/*!40000 ALTER TABLE `operacion_caja_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `operacion_caja_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `operacion_caja_tipo`
--

DROP TABLE IF EXISTS `operacion_caja_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operacion_caja_tipo` (
  `opecajtip_codi` int(11) NOT NULL AUTO_INCREMENT,
  `opecajtip_nombre` varchar(145) NOT NULL DEFAULT '',
  `opecajtip_tipo` char(10) NOT NULL DEFAULT 'E',
  `opecajtip_estado` int(11) NOT NULL DEFAULT '1',
  `opecajtip_abreviatura` varchar(45) DEFAULT NULL,
  `opecajtip_usu_crea` varchar(45) DEFAULT NULL,
  `opecajtip_usu_modifica` varchar(45) DEFAULT NULL,
  `opecajtip_usu_activa` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`opecajtip_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `operacion_caja_tipo`
--

LOCK TABLES `operacion_caja_tipo` WRITE;
/*!40000 ALTER TABLE `operacion_caja_tipo` DISABLE KEYS */;
INSERT INTO `operacion_caja_tipo` VALUES (1,'PAGO DE SALARIOS','SALIDA',1,NULL,NULL,NULL,NULL),(2,'PAGO A PROVEEDORES','SALIDA',1,NULL,NULL,NULL,NULL),(3,'COBRANZAS','INGRESO',1,NULL,NULL,NULL,NULL),(4,'PAGO DE SERVICIOS','SALIDA',1,NULL,NULL,NULL,NULL),(5,'PRESTAMO DE TERCEROS','INGRESO',1,'',NULL,NULL,NULL),(7,'PRESTAMO A TERCEROS','SALIDA',1,'',NULL,NULL,NULL),(8,'OTROS INGRESOS','INGRESO',1,'',NULL,NULL,NULL),(9,'OTRAS SALIDAS','SALIDA',1,'',NULL,NULL,NULL),(10,'PAGO DE BONIFICACIONES','SALIDA',1,'',NULL,NULL,NULL),(11,'COBRO DE ORDEN DE PEDIDO','INGRESO',1,'','etorres','etorres',NULL),(12,'PAGO DE ORDEN DE COMPRA','SALIDA',1,'','etorres',NULL,NULL),(13,'INGRESO POR APERTURA DE CAJA','INGRESO',1,'','etorres',NULL,NULL),(14,'SALIDA POR CIERRE DE CAJA','SALIDA',1,'','etorres2',NULL,NULL),(15,'SERVICIO DE TRANSPORTE ','SALIDA',1,'','ROSIMAR',NULL,NULL),(16,'DEPOSITO BANCARIO','SALIDA',1,'','LRIMARACHIN',NULL,NULL),(17,'pagos de cascos','SALIDA',1,'','ETICLLA',NULL,NULL),(18,'pagos de cascos','SALIDA',1,'','ETICLLA',NULL,NULL),(19,'pagos de cascos','SALIDA',1,'','ETICLLA',NULL,NULL),(20,'ALMUERZO','SALIDA',1,'','ETICLLA',NULL,NULL),(21,'DESAYUNO','SALIDA',1,'','ETICLLA',NULL,NULL),(22,'AGUA SAN BENITO','SALIDA',1,'','ETICLLA','ETICLLA',NULL);
/*!40000 ALTER TABLE `operacion_caja_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `operacion_tipo`
--

DROP TABLE IF EXISTS `operacion_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operacion_tipo` (
  `opetip_codi` int(11) NOT NULL AUTO_INCREMENT,
  `opetip_nombre` varchar(100) DEFAULT NULL,
  `opetip_estado` int(11) NOT NULL DEFAULT '1',
  `opetip_tipo` char(10) NOT NULL DEFAULT 'S',
  `opetip_abreviatura` varchar(45) DEFAULT NULL,
  `opetip_usu_crea` varchar(45) DEFAULT NULL,
  `opetip_usu_modifica` varchar(45) DEFAULT NULL,
  `opetip_usu_activa` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`opetip_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `operacion_tipo`
--

LOCK TABLES `operacion_tipo` WRITE;
/*!40000 ALTER TABLE `operacion_tipo` DISABLE KEYS */;
INSERT INTO `operacion_tipo` VALUES (1,'COMPRA',1,'INGRESO','',NULL,NULL,NULL),(2,'INGRESO POR TRASLADO',1,'INGRESO','',NULL,NULL,NULL),(3,'SALIDA POR TRASLADO',1,'SALIDA','',NULL,NULL,'etorres'),(4,'VENTA',1,'SALIDA','',NULL,NULL,NULL),(5,'INGRESO POR DONACIÓN',1,'INGRESO','',NULL,NULL,NULL),(6,'SALIDA POR DESCARTE',1,'SALIDA','',NULL,NULL,NULL),(7,'SALIDA POR CONVERSIÓN DE UNIDADES',1,'SALIDA','','etorres',NULL,NULL),(8,'INGRESO POR CONVERSIÓN DE UNIDADES',1,'INGRESO','','etorres',NULL,NULL),(9,'INVENTARIO INICIAL',1,'INGRESO','INV. INIC','ROSIMAR',NULL,NULL),(10,'AGUA SAN BENITO',1,'SALIDA','','ETICLLA',NULL,NULL);
/*!40000 ALTER TABLE `operacion_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orden_compra`
--

DROP TABLE IF EXISTS `orden_compra`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orden_compra` (
  `ordcom_codi` int(11) NOT NULL AUTO_INCREMENT,
  `ordcom_fechahora` datetime DEFAULT NULL,
  `ordcom_fecha` date DEFAULT NULL,
  `ordcom_numero` varchar(45) DEFAULT NULL,
  `per_codi_fk` int(11) NOT NULL,
  `pagtip_codi_fk` int(11) DEFAULT NULL,
  `ordcom_estado` int(10) unsigned NOT NULL DEFAULT '1',
  `idtrans` varchar(45) DEFAULT NULL,
  `ordcom_anotaciones` text,
  `ordcom_usu_crea` varchar(45) DEFAULT NULL,
  `ordcom_usu_modifica` varchar(45) DEFAULT NULL,
  `ordcom_usu_activa` varchar(45) DEFAULT NULL,
  `docpag_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  `ordcom_docpagnum` varchar(45) DEFAULT NULL,
  `ordcom_igv_porcentaje` float NOT NULL DEFAULT '18',
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ordcom_codi`),
  KEY `fk_orden_pago_tipo1_idx` (`pagtip_codi_fk`),
  KEY `fk_orden_personas1_idx` (`per_codi_fk`),
  CONSTRAINT `fk_orden_pago_tipo1` FOREIGN KEY (`pagtip_codi_fk`) REFERENCES `pago_tipo` (`pagtip_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_orden_personas1` FOREIGN KEY (`per_codi_fk`) REFERENCES `personas` (`per_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orden_compra`
--

LOCK TABLES `orden_compra` WRITE;
/*!40000 ALTER TABLE `orden_compra` DISABLE KEYS */;
/*!40000 ALTER TABLE `orden_compra` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orden_compra_almacen`
--

DROP TABLE IF EXISTS `orden_compra_almacen`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orden_compra_almacen` (
  `ordcomalm_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ordcom_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  `opealm_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  `ordcomalm_fechahora` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`ordcomalm_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orden_compra_almacen`
--

LOCK TABLES `orden_compra_almacen` WRITE;
/*!40000 ALTER TABLE `orden_compra_almacen` DISABLE KEYS */;
/*!40000 ALTER TABLE `orden_compra_almacen` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orden_compra_caja`
--

DROP TABLE IF EXISTS `orden_compra_caja`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orden_compra_caja` (
  `ordcomcaj_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ordcom_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  `opecaj_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  `ordcomcaj_fechahora` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`ordcomcaj_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orden_compra_caja`
--

LOCK TABLES `orden_compra_caja` WRITE;
/*!40000 ALTER TABLE `orden_compra_caja` DISABLE KEYS */;
/*!40000 ALTER TABLE `orden_compra_caja` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orden_compra_detalle`
--

DROP TABLE IF EXISTS `orden_compra_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orden_compra_detalle` (
  `ordcomdet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `ordcomdet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `ordcomdet_precio` float NOT NULL DEFAULT '0',
  `ordcomdet_cantidad` float NOT NULL DEFAULT '0',
  `ordcom_codi_fk` int(11) DEFAULT NULL,
  `idtrans` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`ordcomdet_codi`),
  KEY `fk_orden_compra_detalle_orden1_idx` (`ordcom_codi_fk`),
  CONSTRAINT `fk_orden_compra_detalle_orden1` FOREIGN KEY (`ordcom_codi_fk`) REFERENCES `orden_compra` (`ordcom_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orden_compra_detalle`
--

LOCK TABLES `orden_compra_detalle` WRITE;
/*!40000 ALTER TABLE `orden_compra_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `orden_compra_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orden_pedido`
--

DROP TABLE IF EXISTS `orden_pedido`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orden_pedido` (
  `ordped_codi` int(11) NOT NULL AUTO_INCREMENT,
  `ordped_fechahora` datetime DEFAULT NULL,
  `ordped_fecha` date DEFAULT NULL,
  `ordped_numero` varchar(45) DEFAULT NULL,
  `per_codi_fk` int(11) NOT NULL,
  `doctip_codi_fk` int(11) NOT NULL,
  `pagtip_codi_fk` int(11) NOT NULL DEFAULT '0',
  `idtrans` varchar(45) DEFAULT NULL,
  `ordped_anotaciones` text,
  `ordped_estado` int(10) unsigned NOT NULL DEFAULT '1',
  `ordped_usu_crea` varchar(45) DEFAULT NULL,
  `ordped_usu_modifica` varchar(45) DEFAULT NULL,
  `ordped_usu_activa` varchar(45) DEFAULT NULL,
  `docpag_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  `ordped_docpagnum` varchar(45) DEFAULT NULL,
  `cot_codi_fk` int(10) unsigned DEFAULT NULL,
  `ordped_igv_porcentaje` float NOT NULL DEFAULT '18',
  `ordped_fecha_documento` date DEFAULT NULL,
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT '0',
  `ordped_dias_credito` int(10) unsigned NOT NULL DEFAULT '0',
  `ordped_dias_credito_ampliacion` int(10) unsigned NOT NULL DEFAULT '0',
  `ordped_txt_generado` int(10) unsigned NOT NULL DEFAULT '0',
  `codigohast` varchar(245) NOT NULL DEFAULT '',
  `timbrexml` int(10) unsigned NOT NULL DEFAULT '0',
  `firma` text,
  `timbreweb` int(10) unsigned NOT NULL DEFAULT '0',
  `ordped_facturacion_electronica` int(10) unsigned NOT NULL DEFAULT '0',
  `ordped_observacion` text,
  `medpag_codi_fk` int(11) DEFAULT NULL,
  `timbrerpta` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ordped_codi`),
  KEY `fk_orden_pedido_documento_tipo1_idx` (`doctip_codi_fk`),
  KEY `fk_orden_pedido_pago_tipo1_idx` (`pagtip_codi_fk`),
  KEY `fk_orden_pedido_personas1_idx` (`per_codi_fk`),
  CONSTRAINT `fk_orden_pedido_documento_tipo1` FOREIGN KEY (`doctip_codi_fk`) REFERENCES `documento_tipo` (`doctip_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_orden_pedido_pago_tipo1` FOREIGN KEY (`pagtip_codi_fk`) REFERENCES `pago_tipo` (`pagtip_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_orden_pedido_personas1` FOREIGN KEY (`per_codi_fk`) REFERENCES `personas` (`per_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=1617 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orden_pedido`
--

LOCK TABLES `orden_pedido` WRITE;
/*!40000 ALTER TABLE `orden_pedido` DISABLE KEYS */;
INSERT INTO `orden_pedido` VALUES (1,'2021-01-12 19:07:12','2021-01-12','0000001',1,2,1,'1610496315656234664','',1,'AAURAZO',NULL,NULL,2,'B001-0000001',0,18,'2021-01-12',1,0,0,1,'oDbReiDj+bpIiJXY1VHVDdDkmOw=',1,'eTpsnlK4pWCCobM6COrJx0rzIM19zQe1/05SHa+b869jnOC2b4bL6G21hUhAdJiOn1Pf0cp5Ptkj\nucXOA+8mNJUeAph2epRMU8NWycXjx+JU0bdP7V3DbHADYTZ+CrYqzVTLqHYo/Jclw7iZ3PcRNs39\n20k/FiAZ4ZkAezxtKsvkjz2d2rieyTnN7vfSnDfB7QuX60Vigo4plaP31fOuv3Nziq6cdVPg42jB\nmL1ftXaz9OqwsYnw4wDgMaM0xXq1r0ivraitvKUy08YVOLhuCqowF+PDeiBWb/ja9KMv1X6zjyeZ\nKpfo2H72hi587IwE52+KJgQ2Swkvt8fbz7juDg==',1,1,'',1,1),(2,'2021-01-12 19:25:10','2021-01-12','0000002',1454,2,1,'1610496691313357431','',1,'AAURAZO',NULL,NULL,3,'F001-0000001',0,18,'2021-01-12',1,0,0,1,'MD7VfxE+j13JK8EJMiHWptJxfN8=',1,'NvoS0187k7yo5v6+Dt1wviW6qOWVJq454/ktx0RlH+j6ogMs5gBAWO5T/RnxhIctsZzAEqX/qC5goFt+OaID7L2Jh31upnCYjq9Cy9tJrAHTUcFv46ik6rV74+m0Q/juy8J0f72ePgz7bsAEfwfzlH/ebP+11xpt2z6i31SoQAKYlJBffxg7oBbUT41ZxR8gDyL3bvj039pw7H8tJmEET1/EnbRuIn3np5YNkAcFriY4Za7PXLt32tde6/CZx5TJB9iEdSMJceQriBAl8a+sLIf08+pf1P5lBVNFvMBhmfjWMN4FlUZdn0WSjj1RKg3It8EON6S0rVoebuX8f35vyw==',1,1,'',1,1),(3,'2021-01-12 19:46:51','2021-01-12','0000003',1454,2,1,'16104980541397586191','',1,'AAURAZO',NULL,NULL,3,'F001-0000002',0,18,'2021-01-12',1,0,0,1,'JIE8okcSCq7UXzv49cxjPfJPiJw=',1,'PjrXA3nLCYstQriEnTeJqRqBmtopk6RalSV8aa76KPSZiuu2Pb/+urOMSH6q4h/3s9RWkJHH5ZymcBlF6SUfPQMtP69dVr6xMFKuI7YI1Y8ym6+2gdxzUniZoH95yqq3iAAlB2Dvn5HTWhvM4NNMuC9HMl9j0So6SVViA/Ln9bLX7R/yswz+9F+6hTrWyQQgc6ZMdF/YVKufytwgsr9oTLuQl9lNBtMefXmGoOEU6My+yToNPLcyQcfqQg6h2sAYP6nw6o58l42LWOZXsKXbI0V7+a4kXYPWC1IB6dk32DWGiqxY9npfB09kUskJOZpzcTZTlIiDFsSM7lJeNwLj3w==',1,1,'',1,1),(4,'2021-01-15 17:04:25','2021-01-15','0000004',1521,2,1,'1610747944537251789','',0,'AAURAZO',NULL,'AAURAZO',3,'F001-0000003',0,18,'2021-01-15',1,0,0,1,'BIjc68rgL0AqDryTZFSvTwdwl4o=',1,'Mv7r1780GYQ7C00xdLMhUo0aBVIydVAFyqkCDyx0AuyYkakBtlLDC3AFOUtyVQj7ItnKvlixTiof\ny7EphtYxR6dlyPhYlebbOwohfRGaAlgjSbhAAnKbeevd1rhRPkpYylgko2Alc/716H8X3k0JvPiv\noUcw1nvc7cMFUA4ozN0NkE8M/jz6TDKXsVFWCd3Vqex3lzjQrVI2G3KJXI4k/meYZCxuamxe47eg\nqXeQmwbYhMB6njMHbHNFYfPivOIK/BGbTSh+6fWyFesYadbDJ+7E1Gt/mI1YdnxpqzUBEpkqDCcs\nyoyNNkwLa/LFsH3tznijQ8nwIbzDc8c9jdAJEg==',1,1,'',1,1),(5,'2021-01-15 17:49:47','2021-01-15','0000005',1521,2,1,'16107508481132037069','',1,'AAURAZO',NULL,NULL,3,'F001-0000004',0,18,'2021-01-15',1,0,0,1,'hnXgRvkdcelnoCHTpXsw0DN+qjQ=',1,'FbVz/e0UfQdEQ9xqmIjPfEXAXY4jCalmYLjnFcbtwCfvGymMVAqkOH7/M6CajdOkUX8+A/sBB1eR6tuz4pgGdEMZQCQWpKf30rGFLfE/TrgMq+Zp/aUOd1+En2bECH09vxl+3SzYiPPS3LdZ8qAK6k3f3uAoPHAdB1n88llWQW16FW3zAKW+WsYTZML9sUc+E35AKBirJeuZoIErmR9WbY9tIMfAitzwMBpnecfxBx6cKZtnkhM7ZVmv8lPdmvxensS+ARmzyggEuhq6BjSGXEfIStgLK0kmZc5PauSMSfea4yaE+XbL07PreobdMblOGtxld1gm7sL2Pm0VjKYKUA==',1,1,'',1,1),(6,'2021-01-15 18:01:17','2021-01-15','0000006',1,2,1,'1610751637729216565','',1,'AAURAZO',NULL,NULL,2,'B001-0000002',0,18,'2021-01-15',1,0,0,1,'Xl6hOvKyEWT4U43YveRMbvJKyLQ=',1,'aDyEM91Vzth8gtFjC8nFZ1OJ2Vgpl/jcjczxgULU2EAAYHE5fiej6LN4KJdvbNGwH3z2Pfl6+yBAubOegea1wE/LOCNSpqd0hHqomql+xwKqKmvhU8TqnZq1oq0hWr5P2cXuh5IIMP2pPfjeRezg7YjlzaFIK19G3e2t2Uq98LqnLZXcNTEWWkryXMlrzIHaBrk0cbDYBgaoqlRuEN2twe9hra49zWZNzw8kCfxuoFRiZQiv4xSNTKi50TUcldpvRjlNmn3BVBo+aNtfMJcGp3JFm8BonVrn6fE78ordGPvS2eQcr+A3dQ1rUYoQjj82BGlx54cIDhVtF0tdpiEVyw==',1,1,'',1,1),(7,'2021-01-15 18:01:53','2021-01-15','0000007',1,2,1,'1610751682989731','',1,'AAURAZO',NULL,NULL,2,'B001-0000003',0,18,'2021-01-15',1,0,0,1,'jv1fPl0eOCzuDzKs31Zto489dME=',1,'JucbrMKlhC1Bf0apyw2LPu55U930bz6sndsRn66QSmkyJ9MmuP0q0XfOieDdqgMcsjNNtg3+veob5Bt69x6yslBF9uVTUBevmsyd7ycNJ5v408jF2IXNCy8p1DVMOebs307H5hQ0uL8Q3fRQU5yFhG546277X5SwT6AnWlvgB78Sa+b+adRcgBSVW6Ly/OeFezxtO0PrC++qwkA/xuN7rDbdeHAItcU/e7hRgu3xKrReQLyW9EziR4pHfN2I66ospyevXca0wWPaASHu+0ylm1sIVmdE74xQEvjzgtZCTdPutNv6A17W4lR1J7didKq0+VEVTSOklkI0KoiDHcrhZw==',1,1,'',1,1),(8,'2021-01-15 18:02:39','2021-01-15','0000008',1,2,1,'1610751719875696748','',1,'AAURAZO',NULL,NULL,2,'B001-0000004',0,18,'2021-01-15',1,0,0,1,'pHH34zdq5JDrY0kqR4m+Y/5WHdc=',1,'Xha9k5Ny2VycUSfXYwYHRBugj1L1iaC+nyABqWqeLOGCJ6Oht7mADBR33BCW+BvDx8HwsRW7Phl2Hn2jo2NHqK+/oLak/MTa4HoEhizqyPPKiuFaihS7OFcuqOjpLzqrzGJkLktPr2fhGy7/wdEDd/HASS0be6fd5jAWjRq71tMfWEm5YQD45rF+5qtTuO2GD4KX3dZKCIiDlJT8XH7ii18yfO3wSy0zOTvtooEo5V0amxOziOq0h0D7mgGhGj09/IcRQCNDbjgiwt9ge7/m+dxTPiA6WXDegYw3By1K8NvySn/5+pvMPiN+XeYv64C2qVlfGLPaSNodqschrHIS7w==',1,1,'',1,1),(9,'2021-01-15 18:03:23','2021-01-15','0000009',1,2,1,'16107517621299086444','',1,'AAURAZO',NULL,NULL,2,'B001-0000005',0,18,'2021-01-15',1,0,0,1,'zmdDeGduQaM68MPSvD6bRxWTPFQ=',1,'ZtvnFcfyXBsrzpCn9jj2MLwL/G3njtcpEWJpgEL0ZdruwKsPHmJqeLevoV4mUQ02b0BAhv44NcOm3ktTGqkZPSn+VxgEly61fznk0FSWw1NoqXQHkzNom+8a1msHj4ef96IaQh0YzYAgxKxFbaOaQM5N8l9jCvUQd/4rIB+DKzDg9Itug4il3OBcu0Yh2CVOTukgariFbRv7uy/hx6Z7xtKm6TZMt0TbmmFo5xaRjCv1wUDuL/BFv9qnnJfER5AImjbo0UP8vTJd6GgqoIrDnwj5mf5zF4Oep3DIscdBKCrrLFrGQiHeyHXQrKfd8plqWkKIa20Ys7c+B6ikCcoing==',1,1,'',1,1),(10,'2021-01-15 18:04:59','2021-01-15','0000010',1,2,1,'16107518121101140250','',1,'AAURAZO',NULL,NULL,2,'B001-0000006',0,18,'2021-01-15',1,0,0,1,'NNITEF/9TMreNQZXwbb0zj6Ez3Y=',1,'YN0hiTKhTqINDf5dVSuZyHnL5asQc8wzKGLKDTHZhvavbNABvcwglld/DHRqyOqgvaFsJYptXs4D34oKxXrAZnOR7Rg+SlkkOXVWZHXbOBO7F2TX0xDlUbCsWPmMzXcZwrSbTWBYxXnUT3FokCfnI6YknQCz11f+lDauxWfaR03IWqnTba7L3mgiKw76BnEWr4/2zYDuYGCqTSiqObk3b748KOiRneKEVjaxaULoxwaU+76kVLCvDnmdBc6W2bCVhac8XFh2HQjcvu7O1nVfPA1WHLPJW88sn5VjZo+YmOyCFa2AtxIATvWu1ainYhlYsWyRdo+FXGWsBvOTP/6FUw==',1,1,'',1,1),(11,'2021-01-15 18:05:38','2021-01-15','0000011',1,2,1,'16107519031118568122','',1,'AAURAZO',NULL,NULL,2,'B001-0000007',0,18,'2021-01-15',1,0,0,1,'n9X2W+l+wtotGWu2CrdUlU+ce/Q=',1,'Z6BPVvOyavJiVNFhJ/4GWNuR2hAjN7QzZm/mAPQ+SmJYoivFlqBsuBuYDHA0og+8fbkE4REcDPzlERKubUGVMq3jjxNiNLbt0k7QAfm/MjPeE0tXx6d+c8PoRmN/9sCZUknNOZcoRK9ifAHtITmZtvYdap8O/Q7igmOd9TvYEudNTssW6RtctPdytF6CVn+yBdalpOJ9GQ9MPE2EoSN+WtIZdUzQkAwjmd2OA2slnOgmNboqQ3zuc/YziKmHwkRAr7mpW8wht8Q+BhvlnB41zc8ljDVWUWuoJr6eupmTNJVjiOLjsIIQJ1Qca0qWpyRd/Ojx11ohKcA7O9+PBta3iA==',1,1,'',1,1),(12,'2021-01-15 18:06:18','2021-01-15','0000012',1,2,1,'161075194283825910','',1,'AAURAZO',NULL,NULL,2,'B001-0000008',0,18,'2021-01-15',1,0,0,1,'sMP/tIIUi2KOGadEUyS1Qu6n1Do=',1,'i7YCEtSG+84pxAz8l88fRzPqGgAw08hEShSEmbHF9G61L7RUDtft1roI3FXo8fFLNFO2zcjxrYWIvDTD9JDMRWRVn2/wsuy+hok++TyuSem3QdmO7iBcTqnECUxkhCeKJohiuBvbvyu8xWkyIH65gc0ORlzTxcfK/KGq9+wpH/jFICbcyZowjGMaWz++hTLAe8QysstOCGaIDiYq0VSItMAeYqZkagROvqJxON1WyzXNPeo9ng2ARnjzrsmFME4zGYdsPGfGw6X7JbS22uRGoJOolBKfnWP305U5sHAV4nMaWn6TYijpCZDtU+gdhTLBCOP3OBSU2SsvSt41Hv5Mmw==',1,1,'',1,1),(13,'2021-01-15 18:06:54','2021-01-15','0000013',1,2,1,'1610751982820056655','',1,'AAURAZO',NULL,NULL,2,'B001-0000009',0,18,'2021-01-15',1,0,0,1,'9Otpem0CuXhpRCk5kBcr7JMFFGs=',1,'BgeDaHDUJyND10GxU57a2+B61Pqgu9Z2KzKCkB7p9AQ/L+S+N+h/LthI9v5OGu9kWHp4hE5I7bn+6U+LvePrtuFx8nGupAH/WxWyvoA0hnxn6QwBbUus2e24SXwU+o/bZQ1LV78Vo8mZXxm3jRUv7wUCwEMvtSX1OilM3fYkU3Nkn+bZ6JT+3xx4e3JZmvZP8qHV1ti1f40XQoqEs3NVTufhjNcrv1S49TxRLCSBFUIr/DPJDMbeEiOcpJb6hBz0Oe0fx3qjUkLcZE1DgApz7ynYLf/N81fyKSlmcaugwF+Cw+3I/XHSZYZRWgrIKgcd241EtIXvMORjvRbUOOwB4Q==',1,1,'',1,1),(14,'2021-01-15 18:07:45','2021-01-15','0000014',1,2,1,'1610752017768547613','',1,'AAURAZO',NULL,NULL,2,'B001-0000010',0,18,'2021-01-15',1,0,0,1,'dsXJkvdLG2LoMc3tw7VfZeidEw4=',1,'dkZlWjDKq1azLIKWr2bgiKYJv6T2h+apj5t5afZdWc6uzOYGkIzm/W32PD3k2qv3YH5Q5DnSBoWc+UnCT72KzmrwZy1i8LXgb1SpNpo4yrSL4C3cwuuFdNVnd/2jOIhsl8C4pfNuG1uVWh8iaYjelJct+MLElhb3kC8jcE7/1GVQgHO09lZH+dnP3lj9N5SbY4DzuxnKP823F5SnZzja4YOm0+//Iw8mTn746Q0a/aFC7x0ZgiPpk8i3RUf9feLoxP+94chq9plal88cgUSjzulOOku042U0zwXwp6AKwTbbJ+chPckYceBdkTkiP5N9CswIp8DEzqexuOAdh2SceQ==',1,1,'',1,1),(15,'2021-01-21 17:18:33','2021-01-21','0000015',1522,2,1,'1611267024616688457','',0,'AAURAZO',NULL,'AAURAZO',3,'F001-0000005',0,18,'2021-01-21',1,0,0,1,'uJV7HN6odlR9ZgELXolyika4m78=',1,'f2kiU4F7LXTlmOrwjMqDfCURadjmRUu5k89WRnz3IJ7248pL2egv2nI7unxHvDHwdJX+siIBgtKV\n5KNd60SWECWXO+9yuPk1/1vd0RuOyreS9OmXvu9ywwBW7Gk2lXGhIaLq2hymJ6AovCJ13TDy3D+r\nX5nYz1gWjfKwQG54MfY1fIL5jNbstbr1JQYydxEMYUWivolmRY5AIrQfrDDc5G3QgjM36eTEKtaJ\nCtZiL19ajGN9/+mQgdWp4jtRsC7yLtOj/loEhAV0PBxuND8RtupNmSADUZhudYIiq5gxR7jbZyPK\nYzhMNVHgvNlLKZHdcRuaSwruIqqHyp63cgmpEg==',1,1,'',1,1),(16,'2021-01-21 17:33:45','2021-01-21','0000016',1523,2,1,'16112678641082464457','',1,'AAURAZO',NULL,NULL,3,'F001-0000006',0,18,'2021-01-21',1,0,0,1,'u/UoefVbbA5xxv27ENu3t/8WJMY=',1,'f8COHHh9YkHu8TaKhUKTZXqHLHlR0JfIeq4fuivxGAvVqCrObHLX0mRgwV3t3h3mlJkFDqbam+rAmtCw71VW2wMDZfzVE2qKL90tWCXknnJzxivHjjLcuL3RpGYkbI0JPUjjzPtE5mCg16Ou9LeqVPm2gneqLxPGHasxt7MbdeuYzww3xhqg5o9URP5Vv++cG6Rg/jxEFPk9ppuhVDXamWQ5eTUVsn57IoxwIwvQg5rFaBY3Aj8vkIptxSnI+FdBHhMVXLjESaGceDJ7dddcfW9DR3yxwuUw7MN2oy6kZgni6J86hrHOLtkrgjoISBD00prHpId2vLDtm9xvFpdrxQ==',1,1,'',1,1),(17,'2021-01-21 18:11:22','2021-01-21','0000017',1524,2,1,'16112689201145161762','',1,'AAURAZO',NULL,NULL,3,'F001-0000007',0,18,'2021-01-21',1,0,0,1,'+IrNprR7oPZuBK4wpnKb0TufBmQ=',1,'BfMrH8CNaRgMPs8TpPB9WV+QfjIZjCNFoGzEUsM42kFavg54Kt+SSifWrtBP3lDlfqAf06w14AJiHNbkqN2rPiBJKjz6lWEoOR64IYqKZrgkHLCUSeWKqBT/1bJpB8KITLO7BqNxNlYn3GZLBq5/2RWbuSfvwhehuS7a9uhNJhdKujcqkthwC/NJlOCQx7UJCM/D9fpzP3OstJSvF6CSrU4xB/Dmpw7kVSpd17Ny1I8Jfoo6bWdXm4LbJu4CkOCdmsqJhyopK952QmhtXeW+QCUAGRkSenCLBhWSNC25kpJQtxBzNeQON/rwXZ1hMwXJCnBXWtQ6o2e6UKlO+C9G1g==',1,1,'',1,1),(18,'2021-01-21 18:22:39','2021-01-21','0000018',1,2,1,'1611271338207198027','',1,'AAURAZO',NULL,NULL,2,'B001-0000011',0,18,'2021-01-21',1,0,0,1,'gSnm/fohok9taiw3ywejfhwUEm0=',1,'hqSjn0eShBy5LGDQGAWdUESZBaWkOiqvJ7+Z1RwZOOGTKveBXp/fcT6LfOlZ9FHeYS5jpbJBa8SilYMaBCTrUpCfXI5hqLnDVHCHJXmdND9S9xhggffnfSAVLtB35sqrAIX9sCKfb4ukD4Ipx2KIdyUl9NsWhTXF7MZUjpB9I069Fb86DJv8JisQviGdRph7LcmOknn4Y+L7RCXrTHT28bMYy/HbtuzZOihuUpP4Kdvwcvbnvue2u+vk666dQJP8Osucg+KFJeYWz3CxfFtsmZJqvsjTbr1czVXpQxHCp1134sE/MKiXOj/RppVngmTP7c+EjCotU/KY6ZUfH4U9fA==',1,1,'',1,1),(19,'2021-01-21 18:23:23','2021-01-21','0000019',1,2,1,'1611271362234824431','',1,'AAURAZO',NULL,NULL,2,'B001-0000012',0,18,'2021-01-21',1,0,0,1,'NmqGC1b+gxaNmowayYV+AtapKoI=',1,'NJeDqjb8ZbDwrIqnfAXMCtVOMoPEf8YDHXV9zWOjrT3PAye79NyTELOOWEuBg2CQMd9yTrwd3CUEbZpxAeRi3/5nAPHJJKlQf2s35cYz8xWl1TAkRMZ78rJ12VFr16/4TzUkX8obHrE2+3dRUOEK2/mt990bgN7sKiF6zbEQi7spNIiV/hzKoLlpFbbdXiUEhdEEvfraruvB+hxvQok8i9V0F+92sTHs8UtodjYmcwczWnTLXeXv4XVE7own5+VsWAp62D205VPJTaEof6fETianX4mt9ngky98XXMPDDIoe+ZM5sCyJgF60p4qPyeMDjpv4Hg8vhNXe3aXQuXJnKA==',1,1,'',1,1),(20,'2021-01-21 18:24:15','2021-01-21','0000020',1,2,1,'16112714051324432163','',1,'AAURAZO',NULL,NULL,2,'B001-0000013',0,18,'2021-01-21',1,0,0,1,'Bw5bguG6DYgH93JlzH9TFXTjDjk=',1,'ApsESZsaRFocq9opojKpBA227w8ewGgleBkHCLuVuEQQoWpbBVjXb90Gp+Un1KC5SKIT6NT6bLSMSkPa9ND4MhmhhClKDoqYcDDZXMP+wLJjbMBNOQU9iXlCsv9LDBlxx/BuERF0SErlheXHxvCgYGwQJpq73Fdqe3CePY/bmGNQ7Tj+qBFy+CufNZYNhs23ORKoFvvZ95HQI40MyUuYaGrn+1C5cDrT9Gefi1tGD+EUMGP9zyPSuSm/knFvmTeER452PfIs6QDYPEzc4ahz9Fyytlvx3Utbj2t0BkS03DGqbqYTc6j2TgGfsm5YytcudFj48uLMWFj6QzrOMdfnUg==',1,1,'',1,1),(21,'2021-01-21 18:24:49','2021-01-21','0000021',1,2,1,'1611271458142306101','',1,'AAURAZO',NULL,NULL,2,'B001-0000014',0,18,'2021-01-21',1,0,0,1,'pg7KcBC+QEGytqsDF0S1kVnCl58=',1,'fmBD8CJaTQXS/KvYbnzHR8dnsEzZfPcqHTxXCdck/a7Og6r2h+mPN6SIcir+yXj/EevQgpF65rapkwM+AZHZFiSIyAAKVXK+boO2QstcWRry+tzOd7pMsrwwzycdt41kS3y2z4odsTbIjWmm2/uzG8T3/D1ZMbeYA7Eb3nGowztflyNbu1o7EsZdAsJXWqgHjdc7oil8YJhbnZwiNrCwWJ1BPFnAbvP6f7jLCCyn6jPT39C9DA5GFdGN2mkRl9ZjDCc4xBxQNG2nIlx8Ad8Ne3zlEgMf64Bcxx0rHT8BTQLz0OtuA8HXI7sqW0ptwLdACsDe+h1hZuPy7ZoX/CMl9A==',1,1,'',1,1),(22,'2021-01-21 18:26:23','2021-01-21','0000022',1,2,1,'1611271512931638064','',1,'AAURAZO',NULL,NULL,2,'B001-0000015',0,18,'2021-01-21',1,0,0,1,'upA73EXdUicuEUMgM7CGp34Hc5w=',1,'C3raoa+eWfZ4ttfPTvOkdJBpRRCaeXSsSYTWQtWjTV1lav4KN/CDW3MiNmp1m10uvf/3N0UFxeK/WoAPKvUy39QJ5UPOOIOZdGSKKRZX1Uy57XMZBUaQddFlivEENo2gduMhQgU/YYq0SVoPd6AGyHWER+s8rhBGpt4V4qsdmXbSGnHi3NfnuWmk/gA1W1BItKDorGt/Y1zXgIv1JBK52bpdsGaSWsQrMnJjunJBzokn2JoWrkM63Ke2228p1BJ0xDuytBm4q8TQLLT6nQzVa8OkOpH95cxBQEspVRikpuCVNae/0c7jUlIWDC6xSDyKnEMfp3kFd9BCH6rG7wCuWQ==',1,1,'',1,1),(23,'2021-01-21 18:27:20','2021-01-21','0000023',1,2,1,'1611271585474769643','',1,'AAURAZO',NULL,NULL,2,'B001-0000016',0,18,'2021-01-21',1,0,0,1,'n/Zyj/tBsA6fIdnC0zAo1RW6PSY=',1,'OxFmwsbkxV4EXO7LLhJqQHzyYqp03t4Umhz+1lbWIgYeWeFTjrXBCXha/9MCIdTgqRfB+CbH3IJC4yiJ/FYqJfyec5O0g03lW0f4OcbQz0cZzT0zB1VvenCzAzCiZbulRJZc0Ax3TQN64jLjOce/U9slKimQUNfNWLU6h4OHSZgjYEH0DdSEUrEpf2aOduSo99T94gkTYraHgkzuuuPNl0sjTWzOLXlWUG+crYNMtSzTunehNvhhyuFI6wIREN/FS5n/+L32kbsvizeI8rWOmQZqXHrDKWvd5m72PPqJ8GGz1sEPbD6xaEarexbotMJ7vDTFAAXUIWmRaR4iyhjO3g==',1,1,'',1,1),(24,'2021-01-21 18:29:46','2021-01-21','0000024',1,2,1,'1611271751591730024','',1,'AAURAZO',NULL,NULL,2,'B001-0000017',0,18,'2021-01-21',1,0,0,1,'BIeJfROlg7UHZmAgQrsTJNGSsh0=',1,'Hv0t9gOcP7KJyhJKGX8ApGQfKufO+szqtA6g8PW7kkhJaPZ3KOtK6cuBALQJlyeURDw5nDRXf+cZXm4A14PQ6Jlc0Go22b2BCsIpZoCAOynAsJdaNggRXaROX/bBuSL10owRRB2zlHVEuaN/IgSn+E/tBtkrCFwXV5iDlb4gfTt7bRCxz20tkBvaYej9jnFJJbrv58q/b1GguFuKGySpql0MBIWOfsfdTLMFeEFce6dOQ0EbAaumdKCXhtdC3+uKmnwYPwmSNBdBYRegZU1rnDGhV9/UZBR/QCR4tYJa/lz1yog+2mhGXCnL++0e5Jh46aAj+PYfp8f4r6M0wMex3g==',1,1,'',1,1),(25,'2021-01-22 18:02:09','2021-01-22','0000025',1522,2,1,'1611356423477910963','',1,'AAURAZO',NULL,NULL,3,'F001-0000008',0,18,'2021-01-22',1,0,0,1,'t+7mdM+4PfGkHs/Nsql/h1XxZRM=',1,'fIAztCVSktNHsN77bAYVWZ9CVabLAgT7XT6Xosg5cx33C5Lvo7vgF1HJziI7ETodcHiswZFw9grWy5UWVR030KmjFWQrgQ6fdBZker9z6zcIZloKcGLNinO9GwVtp0GpGtk0YZtvqUNzk4/QpB8qeswFjVwwk+VSqFKL3R7vRcsnwbWVWNBEs/RVdgoZrkW8KbaSKW2GQokCsdkQysH5VMtb6+qy/T6XoGyi5uKRDtHkAmqWaz2I1aaeqmCoeZiM5LtFnLtnAxFIi+4Vx8AJ/xyXmefm9AP6+p24SWiuwuF1hMhbfoZmQp2DKqie6+EMS+iuhLWI+fWZCUpL3IuZGg==',1,1,'',1,1),(26,'2021-01-22 18:18:01','2021-01-22','0000026',1,2,1,'16113574321397758318','',1,'AAURAZO',NULL,NULL,2,'B001-0000018',0,18,'2021-01-22',1,0,0,1,'oAVGvgd5Nd6ijxf9Mu/kMyj6ALY=',1,'JB5V4qKgNhzavzy7j/cBIm506cxVf5pAMm7Tq/WLFvjX31JjxQG4c61vGGQS4wuAn9j3VthjiDZKtewW4k5MxqgoKzFstH7YH9RLLq0rB8Bpa0Tr49oZC0Ki6w/1uTTZyN85HKtLjGg6y8tUIAo7pfDjbacZreB8Xj8RcnuLa4ERIll6Nwsv1A4tuIaENd0Tlam6A6s9j8zqjX5zs8qGp6+i36wAQLACUxfyeB4/ckkuDjzP90oBMjS1N2/mZWJr2MEXTIgcwhtn7HPRzwOefX576GGFVVJA8mfbjc2TVuuCmWVm6hMh0eve90pSGqKfHAgcffNKoqeqv/PgpHP5FA==',1,1,'',1,1),(27,'2021-01-22 18:18:21','2021-01-22','0000027',1,2,1,'161135748420870414','',1,'AAURAZO',NULL,NULL,2,'B001-0000019',0,18,'2021-01-22',1,0,0,1,'c/d9GQeYEQKwVfGqqjamHtSLgD4=',1,'M1wLp8crIdzzwtlFnNgHzyQesfHVBTszqSeiI+ZF9VZJhGmJ3S8dcbyfUw16w92S12WtGV/R+bdBlQYp/kmrCLZkcjjP+uBoXavau7V5xYOQiG+2Tx5EFgCDQ09CoGK0sWWIxjqXKL/LEfh4wy9NWKAiEZWPxkxW1UIlAJknDgHAk1mQGlDlwIOGwOdN/kebYlCGCmbltCxsVpsKiwhaCv/p8rzhmShwnnR5TDGNM94/WXRHQ2Cwt1BxGAmDcZhkrkYEZG3X6O216M+AbeMjR4acevCt2HFzO0+BQl12qnURskrpRHpLPymIhOsMlj9XKZI4TivJRy8aUZ18PAX1nw==',1,1,'',1,1),(28,'2021-01-22 18:18:56','2021-01-22','0000028',1,2,1,'1611357504471284068','',1,'AAURAZO',NULL,NULL,2,'B001-0000020',0,18,'2021-01-22',1,0,0,1,'gqE2i9Zh8qbY7QbNe1bSXuscV14=',1,'LQgJkAA0sCgWuRub82WDGkSEB8Fw97TdpiTe1R6qEOm1vnJKGoaLqKkmo12zEqAbwynuZrlJbcOZgrcqWZ9LMCTIp0c7vUiORvg6O+mhCzeckSz86Mn++DTN2XLYcSWVv2m1m7Xu6WFOzbXFCtORaMFC3vNQItqvVo2WXW7wbw1dYIBIGhncIwXN6FVFyF8RORdgXfaJcKiO3Nk/jbO7gdVGnV4+1AiRoF1vVYKIeHS7K6h+tDmle5V7sZYqTJBpqu2tUNSOFU1QX0/fmcQvIPNm++C08pLzwVd5ZO1+D0pJvrwYzZhblYUQ1EsVq2YdXpzg7mmqK/jz0vDij2X3wg==',1,1,'',1,1),(29,'2021-01-22 18:28:58','2021-01-22','0000029',1525,2,1,'1611357539998380357','',1,'AAURAZO',NULL,NULL,3,'F001-0000009',0,18,'2021-01-22',1,0,0,1,'7Lr6N9coHprExDO67y3dX8BQzs4=',1,'Bbkg/iHX2vOtMNuQRIqzLr+1sShBritCf8nyhPW/AVLa4q1eGp0TaA5+j6AEKvqPVEZKg0d7d/iZ8ufJKNYV3NaY9SajjXbAaKivHek9bd5pxPqRYj+PaylEgdJHpu1MBBBZ4FSycRZdQPIV+JC+5/R/Dizv947Eaw3vmoqopTZ6Yk+aVWLp7BSiGquf6NK/fr3SSzTHuTCxc6z5MHDHoSsRRxWPrKBoTpCHu9/TZS7vkALOHz21Etf5SMbETj90OX4D3OmOlqxRYJsAfly3dGm87AG6IIXUlXxWUUOudGW+OpkQc1jQDF9b9AoPp39NMFmMGImPBoY+bDrAnExUFw==',1,1,'',1,1),(30,'2021-01-25 18:03:23','2021-01-25','0000030',1475,2,1,'1611615389683215591','',1,'AAURAZO',NULL,NULL,3,'F001-0000010',0,18,'2021-01-25',1,0,0,1,'HJAjRVoHzuhJFXYkzHb23gj+Pnw=',1,'A2Mb3whD/VLXEslUzQefpUDsF10SrNobXJhFvuatPDDZ+BYCAKIoKGD40vA9O6/Z9DrQnN8t9Lyb\nsYSFa99pQQi0Ogqm0oWv4BRspC8cJ3lTcKfocuFig8VaVkI7oGbGw0XLuU63oBA5ko36q9hS4oke\nH8202cmUGhcuU5LBJ1VIMEwf0inA/CTu+wm4fho1faKw7uXFnk3211HD8GQ13BE8eYIVxmPHPQBo\nnq92Pu3h4qRJjcGZtNSDXH3ckq85Yer5vLoL+Fnw2qfgYxCN7MULBhKV/5r4ehWgvL41Vs/MsrLG\noCXmznzeUObLKUp9/W7ncYB3ayV8dTVq++Us5w==',1,1,'',1,1),(31,'2021-01-25 18:17:34','2021-01-25','0000031',1,2,1,'1611616334334356941','',1,'AAURAZO',NULL,NULL,2,'B001-0000021',0,18,'2021-01-25',1,0,0,1,'bDaNa6+lZ5zAoQj3wCdiANsxKug=',1,'iDZcOk9XH0eg/h1lfOySmEJoonmWUHGeOXk/34qTwKjOdVHq6fvjfzT7i1fBXln4oFdxH8L1X4jHgfyefPjuoAGrKuhDtqIwAnu+5E6YWKJM3rnkZxfZEQi8kSq6yLhdau3qzKPOVV2K177PMolkoxCYHgf3MwvMnEtBuW1LU/kgl8rDD6VYXVLNc2FY0ZEnzSMHL5IJceMSJkIHF9BICEQtfkBMOrWm9hVdUX73H3VDpgKsfMevGpXgBMuK8/M7K06A7b/EyWyx6nn2wtsYmeK6IBvxN3dsRDYnwAQPKT9y5iMRaaLV8mDS5s0MPPGETBCzdrW+Ix5gu+1mzz8QgQ==',1,1,'',1,1),(32,'2021-01-25 18:19:43','2021-01-25','0000032',1,2,1,'1611616665617764252','',1,'AAURAZO',NULL,NULL,2,'B001-0000022',0,18,'2021-01-25',1,0,0,1,'/IxH3eqtBb5mU/ACMnSqG5iAxz8=',1,'cfkHc2JAon/Rwb9n6eQyKKybruyANuYHaAzClZ/gcX+fq4AasHetE/wxPLnMWeq1o+ip2K1hVv1kfDjeySQJ5jjf/szIqjNsuSlAoWNLERA+l4nilmGql60H55qa2Hj/9kZrYx/eRt5soU/YfvTT93PH6fNEwwc3cmvTEkiBplhRQryoW2ko9BNP3maEEc+qLxWTbv+x+aPNhd1Oed4gbjSD0n7wt6+oIzEqLjP4N7R0/cDWsx5OAo5w1TmS98gv7GuiYWnwAAi4YPzCmdZQBoKZCGLZZT1/iOy7iap4xwYItpq5iAn3fjh1rnQZXjL85q4VLC8jRW/smkR4OKPe+Q==',1,1,'',1,1),(33,'2021-01-25 18:21:04','2021-01-25','0000033',1,2,1,'16116167881388162231','',1,'AAURAZO',NULL,NULL,2,'B001-0000023',0,18,'2021-01-25',1,0,0,1,'kaoqwQQyCytso/OlsihTrslmC2Y=',1,'GfgRXetFS5LTQmYNuwhw9NmezFyek8Fonogj5ROkp4Y12YOS1JM4eMispFe4d6djXNKdhtTIiuwtqYB2CZBvIZ/ebN65/7P6xVYGjk22G3vqByIca9Ejh3FI9TVAvq79QdJFKQJHsUKz4jlSmkmSnOCKWGiuFgngnVoLdhmYpSThJ0/mXRjlH/vVl/n2ttKlii2KtLwreTr30mjSWlu+hgwp/+enmbCxB299GA070AFIToOd3LIv6AccQ8PM/GY2cRaGdtKGn0gOzZ1zSqLEXJjqJVfdo1YL46hciFNop75RhJPtQGq6vMJcT1D4+DLHEndj/m7B1HSJVQkt+O8i/g==',1,1,'',1,1),(34,'2021-01-26 11:20:50','2021-01-26','0000034',1,2,1,'1611677936252037143','',1,'AAURAZO',NULL,NULL,2,'B001-0000024',0,18,'2021-01-26',1,0,0,1,'SO8Pkwnf6NEcjstPHFZFkShutT0=',1,'fIOqk2oGUxwbtXY+zGPJourNW8XDBJqzPCmLAW8No2rffk3ehFPxc9znSW7yocWu/sjTYYEe56dX\nBlfZy36YeyRqSQt784dYd2Z1qk6WnGONCI0LqkSOTimfshOm8HvbwpVK8SoHpHkaZeSXlP/gbiNq\n2AMMrQborpO5J5rMb8y8WwWsjRPT5kBBeEOYFOmDvdXCYv6De7605N8YfvJ+SpJydgx5rl+llu1k\nfMSnKaDkTYDGxgOVbL55Wr//VBm5BUaIM4a/g879SlibM5OkyUQA1MeV+o8p+B4m3emoA38vurH8\nvu9DxWfYCBsiO+AkVwNGHEG5y9WLNaL2+VWBNQ==',1,1,'',1,1),(35,'2021-01-26 15:34:51','2021-01-26','0000035',1526,2,1,'1611692661534024405','',1,'AAURAZO',NULL,NULL,3,'F001-0000011',0,18,'2021-01-26',1,0,0,1,'DRwMcpeJlbWbeULGGSdQEn/r1lk=',1,'TXTdD7e84+GGW1tKvYkvzRiu/WHZBiY41UktOWO9CvfbXUsAKmZUTFKsW9sC3fn9iZ9zHi1VCogsHdaa+FeoHodVj3viv10uc8epXtstniI69mpR4lu83JTPaJpK3Tc/Ymha7XPI9VCJwED/nioj/yKdyEqfiMX0XjLQpuV8GRd2KkB7b9lIFgw/CQpKkh3JfxOSpEQd/M0QUTiN6NnR0POeC0lvm/q/xMwrtWwf0IzPAjv4UYOWYNgNCCNunOf9AFcoMrc6ueZo/csQ6bSjBQjOdE3qvK85AwZHAScvV8bi24dJpOiH1w1w01YClWZ1+eNbIr7gxsGIRDHSFSvemw==',1,1,'',1,1),(36,'2021-01-26 17:59:46','2021-01-26','0000036',1527,2,1,'1611701537630157405','',1,'AAURAZO',NULL,NULL,3,'F001-0000012',0,18,'2021-01-26',1,0,0,1,'hd1v48sosk11cG/inQNJSgT7Ofo=',1,'IhtV+3lFTzcJWP6++dGN9CSYcBft4UMqyrQFbRZ4/LxmDZ0PlK0I0Mc0ln34Kfd43Q5B9T2KdZAfQNUpKzR7CHr4HKlsw+XjOb7KlITW3dc+oNsalFZOPn58CC6N6xFQHL0d2VS9iuZRyNy+Qstr/h7r5sS6nc2HGNykqFrL3W6pauWUb3XjZ5C7B9fdUmqDaG3wfvGcruq2U4OLOUvDbpQtKmLeLa32jArw62u9x/lg3tO+89TC6oE3CNxwxW45kK0fwT76of0Dp3xUY0duet+3KONQ3oAu0E45SZUQq+WPIHso1rCuIsQedqe1ijix6iOBqSt2iCNyvPTP7RY+Rw==',1,1,'',1,1),(37,'2021-01-26 18:38:45','2021-01-26','0000037',1528,2,1,'16117033591008880111','',1,'AAURAZO',NULL,NULL,3,'F001-0000013',0,18,'2021-01-26',1,0,0,1,'qcxIZmGeHAqTXjiIJN/aBYtlens=',1,'DPrN+UYpksd4KJBymoXJOk6BWkSsKcB5fnilT9Z+EAr/dBEwYXdhQQi/V1Yq3eu3VaN+GhkHLG1NivTn4dVDOQT70XnCC4TBJFxbeN8amTd4Og42QNWMbzkkisP8QwCaSmgwswTYLOUegyv5qotWm1whnMwVW96LTZJS646Axj/wqVIimkf+yWbBKwhHRXXeOXOvgCAUVHJ/p0vKn9ql/v5PHCHmNRF9JK/Yg5u6Z0SvvMHGDb8VTeuUBFmNWsZkZ/EytoLynxf7VzXrHtwHX0dN2sbKEism6xOjgaykjCQpLiNwafi1HTppP0paOiLdlRAlPAR0RVyRaq7YFnZgLA==',1,1,'',1,1),(38,'2021-01-26 18:45:19','2021-01-26','0000038',1,2,1,'16117046921024457616','',1,'AAURAZO',NULL,NULL,2,'B001-0000025',0,18,'2021-01-26',1,0,0,1,'WYGW1jEdpBoGbS7s8dHPx+jXh74=',1,'cU/GVSQJDbF+tnkn25PYkYAD3/TLubZaxYCwidzdqNCDKFZKS8FjD6ownf+44nEs7bMpLzId26uDxPtTge0DxpGcSxRa/p6RB4F+nxJ+QraOLTHX+in2t7sj30/Y0CyBYFZbORTpPxBVgPU6GUrPFMjG6N+mnTgqxM4mmBi7cZiDFfen57Nl4zo6VKE9dwoE8AzPfFnHxMkhXMWHcNZZZl6gtHFTWOZM1+KXRLcYgkNYpP6ZEDe/8pYOGsZ0m4xp/vcphJ4yWxqHGT3gfxgEg0upAH7a+nfm9QRnHasctOP/caOIVoRF2fyVndzbw2Wnol7rIepP0Dhh8w5ZtHIotQ==',1,1,'',1,1),(39,'2021-01-26 18:45:38','2021-01-26','0000039',1,2,1,'1611704722165328104','',1,'AAURAZO',NULL,NULL,2,'B001-0000026',0,18,'2021-01-26',1,0,0,1,'p7Zghc7cga8bBFlSv17K/pVGQaU=',1,'KSBKiCrLsRxVNggHetX1nCrf7paFiu3XQKwH97Ytu00mgA2ct11d4R+gKQotD4lAqYfW/GdgYjWyJVyVn0mQ5lYcLl2RkSRMn/mn74zCbnYO5JDhkziH3vZnyhFdvm7TmRwJoacsjG5YkpfW3H07YGOa9Be1BobMdWn71TpYlu3g9FDWPH0WKXHo7iP1TOmPy2M0jWHXMXWlmCBu33QiTv94QJ+rIp89pCB/eXTC6VT0mAPqIc1YdCWrb/2RUhGALj1GjF3Yzm7qx451VjWQizgbkIt88KqYZd14A/7QORZbFybsysm4Z4BRSm4udJw4l8CdKo3qTzKKyw0gxySL6g==',1,1,'',1,1),(40,'2021-01-26 18:46:06','2021-01-26','0000040',1,2,1,'1611704741529592132','',1,'AAURAZO',NULL,NULL,2,'B001-0000027',0,18,'2021-01-26',1,0,0,1,'G+FP2Q2qC5bnPrZcpnS356mOQdg=',1,'N3emrpdacvoymGBUbSPpWsmQoTwP3IvtgW1bsFxGivcz/+TflSjFQugJOeCB3WjQSNCllm80tGmVyNCm+esvCeHHNi+S78IPKIuInP6zb57x3XNCXBVvwspEDEDgtJLblXT56NLeDZ8AazyPejmCLb1o5d9MPevtSMAEkaXKcuGjPdpoBneF3r3JhRkWPOnzRi8W35NDc4ybdQTsLum31rPqhC0MqqEqGhjrYQ9q9KvAGqlN+HtV2PVdBtiv7qtUZqD7iJ6/jM6kNQ5cZYZrWUDNgUmEBTxwkw0p5JqzChMSDE6L/3hC/kk4SYetoOEt0hqHU8ANqVXPiV+MXucjug==',1,1,'',1,1),(41,'2021-01-26 18:50:56','2021-01-26','0000041',1529,2,1,'1611704769278759879','',1,'AAURAZO',NULL,NULL,3,'F001-0000014',0,18,'2021-01-26',1,0,0,1,'xT3bhkQB1TFdCPJOMMFAQX8Iugw=',1,'dhNn39U/qyEtJWHcx9sYBz6nn0ZtDV9j5LdWEE9Hgv+gMOWLO8KbJFNG4S8v2PlXaPrEfo27hBU0/Qfk1UBQZSEkO7mGFFjppjIKLy6oUXVGgPI1j7KB47/rKWBbqtsKzSUi8YzqsKIvglPJd6A2s8VA6EkqGpYm59+b1dTD5uePPBsk7LhC5eldVl7K4CXEhRSIuRfy0/BrwoySvUyrvomf5wcpizIpjOTiV2Fh67929NpDTwOIC5vkX1JOYWdMcBNZAWYMdbIFSOxX5KR14B4GGY17rLfJ7jFdgPuHQGzBFORtFbRWY7fYaQ5u3zuNfQFm3KkHKpcSjs8kWXQAgQ==',1,1,'',1,1),(42,'2021-01-28 18:24:18','2021-01-28','0000042',1,2,1,'1611876223564361811','',1,'AAURAZO',NULL,NULL,2,'B001-0000028',0,18,'2021-01-28',1,0,0,1,'2+fn80AZu28LJ9afbkXRQnMVwSY=',1,'N6M6/9n7AUeP0rpbw17nan9urN4T3pi3j0u8sq4HgZqhO+gXS88p2e8GcYlY5aKyf8fKoMuBIxXk\nvBf5P0EJvUIFQPJvRfXPCirda7tOasa/g3nwu4kazp7Kk+jIn8RB/Zb5cBfL88WZ6axWy7sxNDKK\nUECvbgokKNUIMvmR8m1mNqKUFr2JmmxDFzUZiLaboTJjOIE46FJtWqOlA8ofYPu2uC15MvIeouzV\n2qH2Qn60E7Q3XVx5HHlXq3YJZWl6ok/Cb1wnY+a/HCWs2heWYwsbJMvx2ZAQ2BBm3+lLeI3SrGPI\nMeimrGgWIkZF/mqJJRRiXc8oFmVEvWqmT5qGpQ==',1,1,'',1,1),(43,'2021-01-28 18:25:14','2021-01-28','0000043',1,2,1,'1611876288270454745','',1,'AAURAZO',NULL,NULL,2,'B001-0000029',0,18,'2021-01-28',1,0,0,1,'7bdy/MINZpKyfhEb6Kzl38GzcDc=',1,'f/ip0gxcAvwLiJ6jrw9Blx8mIPWhr1MkFGXoZQdInPerb1yWNHEm8leLwD7AceSULMCHWFSdktMAC+Pg0JczfWsMd2rDkLXcjZ0SgAAi5i67phDDjmgKcKy64g8EmeUyDCqHwjBhUAO/c8mcQGljEqQ05TrhbZUCdHTxagACMSxuh4oOTOh6OsxcT8cOWP/tF4uM5QXW3uDx7MTXL7IcFzTJQwHxUICkUdWgw4SMw0StvSX4LvSa4X2uUQo0GilPHapIoy3w26CVGAZh612Qt62aJoSiOQqaW1m1Ky3G0L4mUM7/fqdpk2vsLBw46ZCkX/RDiWNR7HAmZbWLQc5Mjg==',1,1,'',1,1),(44,'2021-01-28 18:25:34','2021-01-28','0000044',1,2,1,'1611876317179786782','',1,'AAURAZO',NULL,NULL,2,'B001-0000030',0,18,'2021-01-28',1,0,0,1,'31RhzxTrbER7e4pVknsZjYahPo0=',1,'VpURmS3QjH+l1todnG6uRl5TZjhFXHef7GYxVY/1fjHCwwq/ftbRMAK1rB+HR1Bfn11x+90FI54VK/ahOiK0AdCPiw/WN54GdcCR5af/F42+XkJWJ22mdW8hZIFsX7R5+CmiN8TsufYRzKZOmSx7/Hs6sQ5iotdnVJFvc+4HLMr3RKyAIdGQYY0GdXnbHyBHsg6co4uud5Qej3Nl8m0oNCUfPUJDTWyoO3avhTio7qbrEvWFtDrDOjA6u9bZsZhMjI+H6nfCt74gotcfiAxbDj12Ohl/EHo14CJD7nUKG3Zplw5WIlNXambMNkFKMyGPqlM3h90xnW6sg0/WEgtrLw==',1,1,'',1,1),(45,'2021-01-28 18:26:22','2021-01-28','0000045',1,2,1,'1611876336171438617','',1,'AAURAZO',NULL,NULL,2,'B001-0000031',0,18,'2021-01-28',1,0,0,1,'X7r7JNZteCev8AXsJjD38T9g0gE=',1,'RF1ZIvA4JE9O3kEYGaaawn/e2gn84nxp4oQwD98/G/HtmmqY38Ptofecuvosr11qw7Pr1RjedWyQgENHW2Mv9YLBcuK2vE89fX5KXRoHTxpmKvYlue7i3m7rO+4cGwDTSrH3GJy17BYc3o2XwI/qOtTJKrNyKLr4FEzWWI+LuhTCa5OJlw4nSQTVCd3/XnvL2N+FO62sIq3f+ByJix0Nj7j/u6PZS55Ek6CWcI/yajKhcV4NiyJayAe/nm9MNBF4zq9Ho8fDu9FCCMC41ATbdmadx7Wp2+v8pFrQD610bVextNyB1DdNvxV9g0Gjr49bWrGQOe8W9R3Smm1BKB69Gg==',1,1,'',1,1),(46,'2021-01-28 18:26:50','2021-01-28','0000046',1,2,1,'1611876385534669882','',1,'AAURAZO',NULL,NULL,2,'B001-0000032',0,18,'2021-01-28',1,0,0,1,'MHW4KTxNvht+lKdSwdNNACauaF8=',1,'WVjSrTrcfIKqDLORjAaocdEW6lpXIOzfHx8McS5byptYPqorTYaW1yj0E/J6RLWH4Xs6z7QokXxijPCQQdkdr1ZoujZVLaIVeiy53R5MYNWZlBlulIEjpPOEwBKgdMq6FzO5E62hCaCvkE8BKzRamxJRnNwMTBMBkOEqIjaATLsQIa1AFvnycQBQv21koFPWguGiU9VqYI6Hcpsf7N770xc4BoS+zCFKbC8kTXq/6VuU9FXxBiXgv8acWXOHILZOhtBuzqXNE7JCQJmq1Vrwmd5uAlMQgHEqItzM0AHdRrH/dv4w4tDJ1uCF4fovc6Atex8JEBk7eLlZopcWiCkJgw==',1,1,'',1,1),(47,'2021-01-28 18:27:16','2021-01-28','0000047',1,2,1,'16118764131166032176','',1,'AAURAZO',NULL,NULL,2,'B001-0000033',0,18,'2021-01-28',1,0,0,1,'m+mYtoX2QZqXXxK3nvSMgYRTY90=',1,'dqB69+F7LBColbjURISCTGJ3yX4w4QR85JDa1E2pmehV88O5oqcDKajHcDCqeAVWAI4lvxinsnnB9YLIqkhgznBnDuUcb1jpKtu3EZyRCQTJa+/M+TsmV2f2X22BIMM6ZVgPVOPJw0CpSFfL3mWMNZbi/8TXUOuWN2sHyMfhbotUnSA1lLVE5LhoMpqIYy6PtDFtYtqFZtNzzvob+26L2pIYWw1YDM43xO0WGEcq8xxmT95/YsDGvEm81EMdct6GMQD6PTlA0xnFK/WHku7gCqF5+nxTBWXNuq7QMbJQZjMjDlaFvpsu0SNBV6sKqHGCBYHux+nWiFCnzaLRjA8KWA==',1,1,'',1,1),(48,'2021-01-28 18:27:43','2021-01-28','0000048',1,2,1,'1611876439994722655','',1,'AAURAZO',NULL,NULL,2,'B001-0000034',0,18,'2021-01-28',1,0,0,1,'nX4dA3lW7DozQlBfbHfP6QgZrG8=',1,'Ich0nDuhdWxmbMYoJv/SVeFMWk39tyodvGmW+vsybBmJRVPyZlpoPd6+TKm0cxUtrlrwJAZox7VBmKunfv0TKgnCMffPNuVrbIKxv5vvuciidQ54ozVpLz5HF0eZp/2OxVklNDLkyL2COJjQSuCHtoK3mw98eXF4HdM7XsoY8gm1CmtnfNp5j5sOnNc7Xi6NCY7bvmRvDArxDvtxuNzJUUIJ0VqpZihiPtigY8nRrWYSTKowXRCUjWPTcEr9RI0jMaWjSZpg3/WhcGvu8NP7rqCWth1N6dby6VzQrbxE5myOL+uC74anfmxzOWQ+cdwNmvlctw18u3s+OktH56sLgg==',1,1,'',1,1),(49,'2021-01-28 18:28:11','2021-01-28','0000049',1,2,1,'1611876466524385286','',1,'AAURAZO',NULL,NULL,2,'B001-0000035',0,18,'2021-01-28',1,0,0,1,'5FO/nKtSHPSvC4k1JAZPYNbSQWA=',1,'QceG0Ig3czWcIIKB7W7x1eai8NSAkhpV5DKNY38FnyQKfV/aQw5yw8RIdqFJMJ+zCEN17js33doiAUTv7DGl9/ZbsZ9u9FH0z9kMvE/bPMbzZg370LCHycuaxTQfuSYcNiTDbR4Leb/qfKgsNHHdnz1xzATL43zbVpkDRogzTF8PyZrU0kl2v7KYsyFaauv3qHOkrNHjYp4beCIf9RlYfga9Y2pLMo/3sGx1EuDUoXLkIdOA+z0KAjk9fj7WBQZ/lB6ZPOpi/ryUwfSC2FngmSdHhI1TXZIa6Vla00fSxJPADS6jwNaBhmtSHAZ1ivm05QTXBLMu4ATZ6Y3kueT28w==',1,1,'',1,1),(50,'2021-01-28 18:28:36','2021-01-28','0000050',1,2,1,'1611876493876944670','',1,'AAURAZO',NULL,NULL,2,'B001-0000036',0,18,'2021-01-28',1,0,0,1,'GUv12sHE/0/WPVLZVSOVI7vNCFc=',1,'P+t1f9mCjp0iAA0Gmmisbgso2j0oeHzEUYhvojbTkoXnGaKnura6Sh54Jseez5kQnVcjwfzmDXZkYQcOJwFTIZ+itQp6RElKMIOgo9k1EAE4FVjvdxDuS52ZXrlfIXBGHfinu/qlhVZHOMIAdEafCnYz1MSqONKES6Qy2C0HNfuixDvYdmkC9Yyh08gegwj375HuRXmegqmbNbGfdfZO2creJsC2GK2Ecb3C+hQWIwYUe9c4qVTZrxXcHiBV3IYu+607RGDQwifcal1r/juA1+2eUJaAS7FCP/ssBziHVDG32E/BUSuZn/UoLs72XdE6wDlVrxtlfOULOIpZ325YxA==',1,1,'',1,1),(51,'2021-01-28 18:29:24','2021-01-28','0000051',1,2,1,'1611876519754174998','',1,'AAURAZO',NULL,NULL,2,'B001-0000037',0,18,'2021-01-28',1,0,0,1,'eRfInlcaILkaQKcwl67zJMY9/xM=',1,'D37ntkBgfGHLSE2LdPO0VEojioY1TQMCTTq4Lch43rbmgkGD6MIkQNNPzD3GVy04NLFGfoGH3i7xAjJEXfcQyjLlH5ff7+ce4x6re4Yt+TRYhlW5dqWr2TY3oyGO3SEGfHca2WUUyiv24z1QBUOie1Tt+wUI4yYFCSFc6jmg5TE2zaZCrl1VAGf446fSxxvoc5pRiwl2P8Cp7LtiJY0XD5oDKzhJsHIY2mGLTWZKvgjRo5tkG6uwo3Sgj/tNpvi4a3v7er4nW5Hjc0rzvg2G8xI7SaflVi40OvNpfYzfPmXPy12Sety9x8cukiWr/804W7UalZcELD/x3n4GrorNlg==',1,1,'',1,1),(52,'2021-01-28 18:29:47','2021-01-28','0000052',1,2,1,'1611876566609200927','',1,'AAURAZO',NULL,NULL,2,'B001-0000038',0,18,'2021-01-28',1,0,0,1,'Cptx9T5c7ibnGC0UjlrJIWtlm+U=',1,'fU9QdEawuJubR4E5fbgd/RbrZW0lhWEOZZFlRx0JXrsKZEle25MufNLjBR/cStULs4mDHuW8e3+0eQflqQ2yEP6J/6kdusWgfa9KqPI7jwAxIBw/txRsKzb0Kxoaj/mXyTNeqGqoGvZi0EpzKq/Sg0ORD2WcW6S3FrkrZfF94mEghk8Sm8Gvmn36Rb9NGiFIFtLTHOYUpUaaZGhqgjZsmQkBMXNa/SJWYYKn3xH0KFTaZ4m4uIXgH1zg4DF6aZLtDT+dzkVexr8o+9iot9id82OHuldau1dskEQt618NVHvMLNGm8Lp1Jbk1VWI0htDZzsB8btTXY0+89o9swILkPA==',1,1,'',1,1),(53,'2021-01-28 18:30:19','2021-01-28','0000053',1,2,1,'1611876600712262043','',1,'AAURAZO',NULL,NULL,2,'B001-0000039',0,18,'2021-01-28',1,0,0,1,'/7+M7lore0E47zTUQ8Iq9sVZ8iE=',1,'atayMEF5ZqOsqNOJ026en/ziT6kur8/PQWnBKcyEFuZNbm7qWnbMsHsgBBYlXTLz4TfZuqVgg+oqWFHMb7JQyD6O2utjsd5qt5YQGRW0j2/DLcku2k8QEuns76rsi+8knjKq6wlhIFdhTCF9HOgRjyEFxu3fWAoGtCp/AMfagkX2D2IaqcLP/I3DzRjReatDhcgfZcU02yoDp8yGbFHjrw9n79P435h3neCiVEsXi3nsQBKUr6gGgU3DRZhilA7uXnHHk+xpVik3J8+MCxtJxl1yN8I+MScighpgDMjec/dall4rA3mpqt08uoNW71kwf4w2FGLHhB8igwLbSoqgbA==',1,1,'',1,1),(54,'2021-01-28 18:31:06','2021-01-28','0000054',1,2,1,'1611876622690186739','',1,'AAURAZO',NULL,NULL,2,'B001-0000040',0,18,'2021-01-28',1,0,0,1,'notytsyR1R187HeFA4dmtKPckX4=',1,'TxamSiQrdSdI43V9YIMIA8ctWMtl88PEaksjsNornLdytDs+DorU9GIir1Im6/iiF2bWsczwvRw1VwywcqNcyaR+jymu87vQEUTsqdcjG4gBIog/TwqHS5LoLfSoeCo8F8u4YUpv7h+XpDfjkKc+FPf3B8OozL6JwK/kp7LJejTdJTP2mlhSdrNfjN99LPhpx+kyJcdti0wxo9pbpKSzv9su6MTAaOnUMuRCRcd4xCe0RibxJO5v8ztfzr9kLbV/7DaKAbmLSaI1pZYtvo+uW1zJr57IMN4/eCxfrdUSGs2dMQQg48rCiauMsx/byW6hnCeuQZnA91wNygedPoPewA==',1,1,'',1,1),(55,'2021-01-28 18:31:43','2021-01-28','0000055',1,2,1,'1611876669263784819','',1,'AAURAZO',NULL,NULL,2,'B001-0000041',0,18,'2021-01-28',1,0,0,1,'wvJzQttthFeej3Z3Li90ukxqffM=',1,'HbKyDkToRVxBh+bnIlZ0Vpb7Z7w8djw5j8TVZo3yFbibjNvtkJ/j0NsDmL/ILhbbvmJ9CDKseVfrcqQea3Yl/cwedYg5g7QzRKfgsQpHE2morDxHxkbqEN8SmiEncS4oOkXpwMsgBLfXl1SW2u0aVdSuQKpMAEQEh+7xh2JyLvu/3pgWss7fRJXWxN08SFakmxpsnJv4jZ47NBPKXoJTGTP3TPooiOlT7LBA7XzoA5JJmNEOakBFU32DDAWj704TSqZ4jgr0nv9o/ZFmFXx6z2h3YwLaIKCWupCw6aN1N1MvvkSH38Vgb8ZIMtDDJ98AA3/Kj3czQJZLHrhKQLkNtg==',1,1,'',1,1),(56,'2021-01-28 18:32:21','2021-01-28','0000056',1,2,1,'1611876705858957385','',1,'AAURAZO',NULL,NULL,2,'B001-0000042',0,18,'2021-01-28',1,0,0,1,'0Ljlr6piAJtDLbagCik3Ig7Pdxs=',1,'Gi6QDawSdsppmwJHksYtWcyDBSzuFLAb6sJsyZKQv2twXcAJImXgAP7ZqwCMn7FnyM/ZF2JW7bH2l/bhIlbuqkWamAjGx/t6wo4VNwgp5LyrvlFXoIdIfazXXL/d4mHq8ViQyL4odZsspD9ZUztv608m2NcVKi/E8MaMKwlNagI5g3RgDpEktFuo0XSla8qhpPmipAtnfcFcs26j4jEn3499O16fLpL3Ud4Qf4svPMskRoWpJUATkkJ60RUgsvp24SyMAkr63gbom5lm/5X4K8A9cVPvdC0Qtovb4OKiuh1qxXncb3yj461iKrAAbsmmYA0/aC0HsdmI0lFo5rnM3g==',1,1,'',1,1),(57,'2021-01-28 18:32:58','2021-01-28','0000057',1,2,1,'16118767441217110901','',1,'AAURAZO',NULL,NULL,2,'B001-0000043',0,18,'2021-01-28',1,0,0,1,'tTK+fFSFIgY++4tejaDjManW6IM=',1,'XDi7xBXVjeF1lyQyT1PtgpN54vh8JIhBK2oNjrmqCOTPUemINL/cu/sjx43TJdHK4cVqmyDCBdOoqkzZCLHF2vpwzDY/r/DWP19sVFou/7Ekbl/WZKk8MymomHLoxizG9atAXqRMt4mqmjFGuWMYQqw3tM+QeT7cG4d0TnVypnT2sfjZU+Vne4//IC/MoKF9Ox6l62DIWuWw45APBLJhFqnrwqOI9oKwZ9IzNTqNWlfkqRxZ0QE5nvxh1C0pRjDB0+fsBq+/UCnDjT+FlLFCXVs3biNBIeact4shMcyY80EgOawZgXLUL4Ma/sS7Lf7kBbUfaJnILQs5QPFvhO8EOw==',1,1,'',1,1),(58,'2021-01-28 18:33:18','2021-01-28','0000058',1,2,1,'1611876781406736397','',1,'AAURAZO',NULL,NULL,2,'B001-0000044',0,18,'2021-01-28',1,0,0,1,'Se3+59JkYjP4JN6eqxZumDzz07k=',1,'cSwoh3z/Z6H/NVfcbYuECJGZ7L5XnqhdO7sxrS08WcwFIex0GcgPDZvdZlRWimSOMM49onsPApRdK1UYo2a4VErHWlY/EzakXcsilRDUOC8TssPHzHde1UkkKK+Ac+LzhnCKhvu2fqH+0UZea6A5siCI6ErvDyTseT4T4ZiabWNbHP2KaAwCr7b+kcsNpk3yvxdDlyk5fTblTyK/vF++WgAY/ZcJmPXe+iFui2Iovz/g9yVvOafadUbLOTIHvR0kjsPr7qYoh4UKCpfr+EDSPrROgR4D9oeKiouOpFypLfktif2zy+DN5Yx2PuCJUAalGlLvPJJ9nNVCXG6P+woy3A==',1,1,'',1,1),(59,'2021-01-28 18:34:17','2021-01-28','0000059',1,2,1,'1611876801942352977','',1,'AAURAZO',NULL,NULL,2,'B001-0000045',0,18,'2021-01-28',1,0,0,1,'subcaVuf0/6SsLlOBf0dqgxca2E=',1,'J5AR4p0m8dSr2DpKQif27Bcnt5xelxMaXy7PqGLXYL47/bGcEF9iLf542U6ta1Tyf+4rgTOWBW+3cJRJiRbCgjkYfDmbM+60DSxRFo7GXU4T3SwWgTfT/Unl08ljkpEuPnwZgz5nBDzEH1UH5uDKHFyYLKigKh3oMETIo1Oko/AaNrl8Jqrz/47Y5fcYpnrM375/1n0m4sCPjE0CukWDjJUVV60PPZySSezoRgEclrUxNfSFlI5tjXKQmq3uDzHTLFrClmajnE+wgt7RFBdi3MinqPElfFQAIJnatarZQ1KQUK9J9q7Np+ih3L07x1jDvG8/T89mx98qogt6rYg1+A==',1,1,'',1,1),(60,'2021-01-28 18:34:50','2021-01-28','0000060',1,2,1,'16118768601304379353','',1,'AAURAZO',NULL,NULL,2,'B001-0000046',0,18,'2021-01-28',1,0,0,1,'8NE0oRKeITBAs8/TQSPz9kITuuU=',1,'F39Rx65pZGDLaSUlecKxbXqVX9q9fU1G2EpbfLOL0noXUUxgAh1qM6cahoMA0+H/5Mqp1w4SQ+r7C0+su+Yma4i8k1xbrvix7v7Wr9d9p9IqeIZ0r4Jtz30T4I1eLlsEid9g6PUJvo7AxElH0AF7i/9HBFgjd0KbvVqtri02kEWjG81fQBKRCAANfjCzzdbVsJArBxsG6eqTtBPR5IFTZJf7WXLKi5YXEYwP9z3yk51twwf3hw96YXmr1162ANJ0nWoaVaYn2riPLveyNr7iFzkFaZEtX3tkkHvCmNyEQ32jnomXHAgGsE8VQ89TodQ9qk2cc9nQuvN8PRFMwH9YVw==',1,1,'',1,1),(61,'2021-01-28 18:35:15','2021-01-28','0000061',1,2,1,'1611876892698448841','',1,'AAURAZO',NULL,NULL,2,'B001-0000047',0,18,'2021-01-28',1,0,0,1,'WIX6k6A5HBcKR6Bclqfj3VhgUMI=',1,'UVpewjy024E9f6SLS2Y+nMYt4ZOrDAUhOVXcEa9nJrudXCdjcS8btq4mFwaPg+mXHfLLZ8D+cRiQcgi7s6dRn0/IzkuuhWVSFtOuvr5IjidaYNN5L3XjnYg2UZAFD3s5juIb6kucom2AJaMQaz02WcMsEw/zCrGt5qyXsEEzq0ZYHwObD3Sz5CmHWKqwvK8pplziTwD0pmJMmld3TwlEho9r5H52vjtywKuMW42xKS77HbOwc9xiJ/bjgiWs5mMDynykamdu7uKXiaKbfkgD5RMl3CSoqsPZjeHBCTbyBSM/ArFDF+bK8ktC3MHhkA1PSFOVMf8/Lsrls9YT3hQSuw==',1,1,'',1,1),(62,'2021-01-28 18:35:53','2021-01-28','0000062',1,2,1,'1611876922206337391','',1,'AAURAZO',NULL,NULL,2,'B001-0000048',0,18,'2021-01-28',1,0,0,1,'d0gAY4Bt8eq4YipXrLFFyS2e8sM=',1,'V7p/yTwHJ0eXU7WlJPYDA5cmdqF4EpZJ1TiT9cfq4wikfhjZkNuqRp5qJ3A9liylEyPpHJcnf8hki50FmZ6y+vskZw6W3K9B/ZKh8HEoL63zdE8JJ7nhGSgwMlIp6NS+6wpI9GuBzkv9AAgq+RZ+ydsiCGLHH+kNLZLjFxcbc4+qYVw62t+ysl+XkGFkQDj7JieBNXZSHeaqBm3WD7VV+jRFuOO38k7cTI3+hAzp36FhTqKDh2Wxpg6aGUTjRINkMM/+Owg6pNl/hdZL4qhnmaqs5GFWNVm/THSsCIMpOm0eMP3WeGNb+rZlH4MqTZDBseixSDKYvtF0mOBIXMgOSw==',1,1,'',1,1),(63,'2021-01-28 18:36:40','2021-01-28','0000063',1,2,1,'1611876959394859625','',1,'AAURAZO',NULL,NULL,2,'B001-0000049',0,18,'2021-01-28',1,0,0,1,'P8UKufs6y3XG58FUCEw1F0EKh0A=',1,'QfwmNE14qHRhW6WgLsvIkvIGP8BVO4gqDaGnP3R1jItWWMV9QSGnkGx5YZtabSw/GabNN226q3SkejuEOVZpsPCNGUHuW/4aJX9Y4PlocHel7qc/rhllUUSdI6sQ+r3kJ2BL7JVVHLn9xvncMP8CwnQr06Ns2tFkl/2a2XTYj9cwJJcKCHBmAQtvxBP3CL8b+fAA9GdvZRCskrlUL9TqPlHxwjDEnu8bt17Jcde40ytJ171qXVCVuXJdW/1Yux5XvNFb2K0MixOKxeMIMEZrJVShMjr+expKKbSUV3zKmWdAru/FvQTtfVJLwXIuNR4y04hVoMNhRkqRIlqDHCj7yQ==',1,1,'',1,1),(64,'2021-01-28 18:37:15','2021-01-28','0000064',1,2,1,'1611877003740189669','',1,'AAURAZO',NULL,NULL,2,'B001-0000050',0,18,'2021-01-28',1,0,0,1,'H54HxCMJkcOztrj9/rhFIeLeycw=',1,'TzHN1Kh5Ke2yOGYfKZb0fVc6goVW44OwacnOl8/THVwKgkMGReM+9r74BoBw1TOx3lG8N+WkwMMsh+KSDmKnZLdI4wdtJvytPS47BzBe+QEUHBIYgp3wn0X07uVgSwreRRIvUgRjytJOiqUM+cKdrKHbFRg0TFYeXJfrHBonCcL3I4/+oEEt54qZ7aITh5jN7LH3PCQ1GxAC+GpdxcMmxE62vCwFry8fFJQyGWAtjMQUrOHyUxmAHvvSRZnqJIFTOKSduuIpjZpTMUZ5sfO+PvDNqj8Bo+rX80IblM0Co/jMhShezte4/Tf1qk9oJhzOlVoRwSXsm8/RgRcqvP6eOw==',1,1,'',1,1),(65,'2021-01-28 18:38:04','2021-01-28','0000065',1,2,1,'1611877038866961297','',1,'AAURAZO',NULL,NULL,2,'B001-0000051',0,18,'2021-01-28',1,0,0,1,'gTK31dXwIe2umhw888el+nvVsL4=',1,'IliBkseIbFSirW26lfhs5a6VeCzy34t1e7yKr08kbPZMfPRolDFC9NeBZCikoIFPMbh1jn7w39orsff6lP7lSIDUu8MYr6sLSEcUVdtnjb7omTLGEUYKfwlzon8QHCi00DR9y36WNLoQ56azJ4jkRNC9ajpJP1zchNqiOfc9/n1XbN7BndgBuFu1hf2UmPF+wPT2ZB8EFUWMzJJ1aYJOBmpL6RSHmE2eDxmLlJfwYYxPfgj7jlL2YjepbZ8nVshK2VLlqmojeAbqlOungnBb3CKVLtp3IHolynUNuL6YtHEYnKgeWiZrGrhwO4adqrBFMMvIq497HgNhIdYbpnK2UQ==',1,1,'',1,1),(66,'2021-01-28 18:38:45','2021-01-28','0000066',1,2,1,'1611877086709766200','',1,'AAURAZO',NULL,NULL,2,'B001-0000052',0,18,'2021-01-28',1,0,0,1,'YdZT6qAJUNL4+ObWBBlehMXe95I=',1,'RaWX99lrlcawl+V82Y0uwO1faVs9VtLqtXTxCFMHE0BTreLWElbfq45Bn+zyaJo1oq3Kvpl3EGJeDscvPKitacPsvloybGRPUtMTEFRk/M2B/lRGrkeMc2RqS1YyoY55pIU661L1cjGewNYXsalnBrVnAu5Gg0oXverI7yeL/0eFBiPQVAGG/f2r00KGRkbm5Aja0CJJGjssE4kIhh1HUZfMrh87yMmcsYK6PcqaFHDTjc6zRwcTkbzR/y+yB0Bw7llmlKPToNziJF0qtNEGYGEuP1cXz2NNa4+Y1P1WLYAG9LLcYJ2AiK4i/4cbAtNqSDoOrMMTxVdkpY8lYLDnww==',1,1,'',1,1),(67,'2021-01-28 18:39:19','2021-01-28','0000067',1,2,1,'1611877127639882587','',1,'AAURAZO',NULL,NULL,2,'B001-0000053',0,18,'2021-01-28',1,0,0,1,'bF2482CPf6R6WZzbquovVARcr4Y=',1,'iEcN7F8rzojMRy+Eef7oZYJ9CRAGzbfbGyrmr4ADbvpEAex7TJrdD2kQlExXQtslYnC6r8BAPs792RcVQZ4cGWsEfOmqcCaRJ7KqcAmLAIzNWj30mpXljxHfJ7y19y0cA/oRiIk5PwavriLj4ddzivZAehMTu4Z+hQXt28kp7zhjo+KZa1qLrw9HhBg0gftTtuN0RTu1lRNWtes86sal6HWriCLT8rV6CBgE4OY0JLbXAaF031VrsE2atlxiTuP5fgXqZLq9Ggqh0P3uU1tUxcFimCMHwFUqzXlOPzI/YSsE7CHJsg4ekz5Gn3zoRurkCpHJnUWLLYxVL7nY0ZlMDw==',1,1,'',1,1),(68,'2021-01-28 18:39:58','2021-01-28','0000068',1,2,1,'16118771621073255656','',1,'AAURAZO',NULL,NULL,2,'B001-0000054',0,18,'2021-01-28',1,0,0,1,'7kUeza72UEoL8gsv6x9zk485Bwc=',1,'JasBNcsSHzV+QSeWzzX7kZOxzGSL5rlnc9tKYz053L+SFj3ilS+j/ammEeYmHgSSYyShQN2KYxNa6aEecChYziGFSryKSNqdSCp5kXIllANF++pW+KF/r3ssRMrk+kZE3eCxL9uo5LBBkBJE8NdS4RkgVve3tBdBO37QV6qTqXQpgDChpLR1oMQ8KsswUMcWlcGrGDeM1WITC9wqILm/ZCBf4Tgpj4lnDE0TwQiWwRMjofEn/A7Ge1viCLQRI4cmeuF499Yb90Jp4Toku+SDvyvzyBSMUXeSzVry+E+XRtZuNCGVy3isz/nM0bs7+jSQooYegYolI32c5H15bEQQFQ==',1,1,'',1,1),(69,'2021-01-28 18:40:22','2021-01-28','0000069',1,2,1,'16118772011070415558','',1,'AAURAZO',NULL,NULL,2,'B001-0000055',0,18,'2021-01-28',1,0,0,1,'mNPSXzdY3WK0mX/v+y6jyd2LbQ8=',1,'fIY0y7bvwvH2igRX8OM4ggf7fIj0HfvDlzacUZhsyJpbqOMIqF1KIhBW1aIBXx1L3ebV4AjsJwY9sam07t3fJAvdI5M4i6gUhZRbMuGITghv23jUNEUzFG+/91ud6S8aCxz+pQYI6STjXaDwGmuYRC+xtCDrvX3uapIuCVKoGH9emN1Vp8YcMMHP1xMTpBAU6ydHpcR5zPfbQcSssoOegQrvVm2XD3/4JaZStabrn1vqwy2uejZqZAKotKxeneh3bN3zjzCjGAd++8wKPeCSx2/H5w6aL6eytHM5nCqIT2WbrtX5XNqIJJzyLunQyEOK7pVcsGAXD1es04tAyUxFNA==',1,1,'',1,1),(70,'2021-01-28 18:41:06','2021-01-28','0000070',1,2,1,'16118772241225803320','',1,'AAURAZO',NULL,NULL,2,'B001-0000056',0,18,'2021-01-28',1,0,0,1,'XGwn7bf2C+Qa0sCTGhhYy3vOmnk=',1,'HXfytIhrcAGTYrBslSqFUbqdgKORamzOhzAZKX9rH76WRacdOb2Cs6fnOULz+SNE1T69J5DR8QrM6lx6NWfBsjgTWRaH3j86bi0NMB2/V3k5XE31aONdKen5XkiwIxtaiRM5sVXIUtAKxsQozKPftLxv3cf5M/IIu99RrE7Hdbwlh9H5e3eemzayozHqcjQcZlNcka2GJZ7od0Ti5i8eSk/pCqeF+L/XR2xq98L66nMxAuujFudJv/F+faXz8CTawjygJLuIbva5TArJhe0eVgs89rPGToHSD6UBjm8Zqr4yWdhT34n0uQoFhOxMH5pNWy+fs41ksGf7EZ/vWtVeZw==',1,1,'',1,1),(71,'2021-01-28 18:41:32','2021-01-28','0000071',1,2,1,'16118772691112930958','',1,'AAURAZO',NULL,NULL,2,'B001-0000057',0,18,'2021-01-28',1,0,0,1,'XFeIPUPO55A3khCJToUgI2UcLEY=',1,'Juo1uMIwh+jes42AdjBIjC26lxM/6JhSvCt+lLBfNUST3a81P86cNAOZgRx81TRojgX/E2tvr4DOeyw90nG4P/+2uc+wPBzsw6K8qVhpmfAcVEvijrOHnqTBZ2FMpNXXC4TqC1cl4VCzZchve7iHd36whGMINGEa/p/z9R1mQ4P1Ng5ZTdFz4iTX4UiP8hVExMAvmAoCKHEGUJQrNNY7JHhR/tW+Ogh7jUnr/vjMVVKemsdc5N9DVFZOdWWTwkxuBzo78M5N8//fZVprYCyTOW/x7hv+QAdNM9UNPTmOXJiJdTTcv0Za9U0cTlyblM7eTSKu9biG304g3yJLVt/54w==',1,1,'',1,1),(72,'2021-01-28 18:42:01','2021-01-28','0000072',1,2,1,'1611877295636956426','',1,'AAURAZO',NULL,NULL,2,'B001-0000058',0,18,'2021-01-28',1,0,0,1,'RRCOzwwBz3Nsn3mbKvV04J4O1WI=',1,'fSjPbXNUtlbhJ2sEC0stf0MBCYO9BiEif2UmOyd8SuCbyagxq5O0yndSRs53rg4XKk/VuEbwba17oh7v1EhF5V4AAyMFksD8n/zFUi4km3yFE23RSQKMg5DRzr9Gd/AJn4xSe3VJcOKwWh879+e0p2nrtZsJtgr2krCo0Iu+Q6Rqu2alytUvTqGXXB95LblzNDGP4ja7y6ShuEvaY4xXOhgfWP0oc3GuQ5g9pbzKRUqR8+uul3XcB4IZTWPYETPK3aN1M/7mnpQIjLDY9JRWN/+8U6IxyxnALMuZi3cijrGW3x4pBoKWz7wSVZS8ClymQ/zVVQNAW/6NnSBQ9tmJAQ==',1,1,'',1,1),(73,'2021-01-28 18:42:31','2021-01-28','0000073',1,2,1,'16118773301299129476','',1,'AAURAZO',NULL,NULL,2,'B001-0000059',0,18,'2021-01-28',1,0,0,1,'I/KQv41+5VeG+et/eza8Xb7ZZo4=',1,'Biwjnv2rQ61FDtRcLIvZnEQov20Frkne26Hoz+JiEd3LqE4DWoxIttfRoIUuUIG2MrOKc8hYmb61d2NCZWeZSUVoz1fx6x7b5wAwHnG7zhwVBsIoYBo9ML8/w3a669NOP0CWm35Sc0LEDA0UD/z4RzzZEN8NWr0IkIzTSfiw011aU3pVYefFKYDHxZZVqOcZ0RmTFK1mb8olZqd8aZJLymcavmWTFHGrEdnS9B6aC4N6yljHJ0bg0Nk4tOrsep0KkyA5gbl2ME3EPgYRzMt5jK2NWpiTu17wLKVBxa1Tj4Mqw+tWd8vbqRuM/5CqfDcCLaQ2IMNtKcmgI65IEcRYDA==',1,1,'',1,1),(74,'2021-01-28 18:43:04','2021-01-28','0000074',1,2,1,'1611877353822208244','',1,'AAURAZO',NULL,NULL,2,'B001-0000060',0,18,'2021-01-28',1,0,0,1,'stEL1cptBWvMy54F8vQQ/ZJ6S5Q=',1,'BqSUKSe6px1zz+/M2PHOs7c2pXiWkWK40hmAEPB156AcnN+PZB9t8ZHjztu3va/eh9DnxLY+kYmZ07oLJwVkJ3Dzka7laXgByPVvgs7W8hu8ySxyQlYYu8nDNUMiz795Y9QpySSp8Go7xDZOY5e9yvmBuRrEvIk+IalOGTbkJqtYFYQCkRpv9mRaaXngfo5/l06X0BKbteB/+XUFsK/Y4aGQHmaJRt8Y+G4ChOrga5Woo/0drBFNp3WvBWi2+R9HH9zfqGmVT/+F7ufeyWc6362lA4C0YO4Y2Q8il9qXUbkTN/DScF+B53r8ShUcQI338yCdGt5Yo99RBvz5DaVE9A==',1,1,'',1,1),(75,'2021-01-28 18:43:30','2021-01-28','0000075',1,2,1,'1611877391370417573','',1,'AAURAZO',NULL,NULL,2,'B001-0000061',0,18,'2021-01-28',1,0,0,1,'Pa8TltPmvPoHjXKUPQaHTDfcoQU=',1,'YQXz3ojIEAk5LA8FQmmMitymO7m/OOGAtXXkVEMxp54IuembbfiLF1SkFtUhgOIaf22UTgsMdfE+AU2Kds3UgcuCFy2ReNslbO0Kt6MRtjUoGt4MVu4zf9d6qrm/ZyGTJGV/RwIW8RNW586CxpmAyAq7CCyb5BgY+uNraJwTtOs41qW1rtIl5Upnv4FMAyjUHDb20tqa982lfwL4XiRiPIQKuM70b3nMWvc4h7hMNvDQu3NtyI7xWV0kvDa/qUDBa6UeONj1AwJNt2trdOzDN31x5pABb1DAVZ41ZX905UPvxyleWI9rcbdFZe0RZQKweqp0mcvV28JsZ1cn0OOYAQ==',1,1,'',1,1),(76,'2021-01-28 18:44:32','2021-01-28','0000076',1,2,1,'1611877413998380357','',1,'AAURAZO',NULL,NULL,2,'B001-0000062',0,18,'2021-01-28',1,0,0,1,'Lo1XYHvAcwne5dty7LwjWSvBbSs=',1,'Zeb8PVVub8ZJWa60D15lEh+8XpUQ5ynzWAEEm7wafInPm2wMSsK70k/Q1orAug1FubDfbyHBNi3p5pXnaOqu33qYmG3vphCZC0OYM1Tv1IMwItvKXRDR2FqBhTt7YzEeVuaFO4ihcYsUhNW1vWmPIC2Bbgxtp+dO0I/f8IlS4xYabJ63jvJPAbksV9E/jACONE5kkw2d2/4So2EwCF1paYer5myXLNf3WSmGLmKZgCOb45G0GIPqxlgabcC+5ano3sdisAykNNepQg63T7moWsczwjmKJnInsf54vnJYTDA0CiLsoizAdiDF7NiJYctYoIi+N3+Rr9VCv2HrlDO7cQ==',1,1,'',1,1),(77,'2021-01-28 18:45:37','2021-01-28','0000077',1,2,1,'1611877484933875717','',1,'AAURAZO',NULL,NULL,2,'B001-0000063',0,18,'2021-01-28',1,0,0,1,'ZXhZfevhDUah+mO+42fOhLXaqaY=',1,'LUtZsXyy9WEQXOqQ0tYzNfsRlnCFQZOxiui9yAjP40rdrye+a3f5qXFzpbJlTh4XLbhJzJB2gu7BcfKjhBrs4FmOCjq/pGfI3ZIwVBCnneVtoWSfuXMAyi7TGU4cnHi/NoKw+qDNZutNQiEX9+C6GiABPXaSg4RJwo7nPfShUMzUCuuLmO8OIY4k/BqaqC9BxyTlFkbHlQpflMkDN8CckLX01Vs7QZ7Ie7JbisnKBF60djh1JC9sHPg95DAiwg6k5Tr51hgKSyQ4pKAer+V48DMkiyMqHorzLpNI+9atDwMpHKFTX+Fy2lJJfry0BaLdTEZZKe+6YjtaW8Ygm5Y7XA==',1,1,'',1,1),(78,'2021-01-28 18:46:32','2021-01-28','0000078',1,2,1,'16118775391219176426','',1,'AAURAZO',NULL,NULL,2,'B001-0000064',0,18,'2021-01-28',1,0,0,1,'1/bYNlT8Ym3F0JliRhGia2r+3bg=',1,'Qir5dNUNqlYj2YYIVCKOHpxKH6qO1vuwy3LkxnbpWbukKQ3Y+objy8lPF6gVB+gqnCpsrRyuDu2gqBE5ppvJ1/wNEaJls9msymhwnkP4f3oppsDUoTddeMu1q2cLAMtKl0Q6ldEdZvIOH56RR0Ob76vjEHOUbLBb9qw1zuCgPzAMolxbot/XGvHxkQ2Szq0Wdbb3uNVNgeuOifi9l+Fo+N5BnlAI31e4s4r6MHLuhT2QFtEwl2EwmpiKef5F4dG59k/WVWEZte3qbSWPWOHvSpf7uSTXtSKflYNi+2ce6BQjZCCNVzvg9WGbr2TH0KunGLTKqorKxWckZe/WjM9E2A==',1,1,'',1,1),(79,'2021-01-28 18:47:12','2021-01-28','0000079',1,2,1,'1611877604614665963','',1,'AAURAZO',NULL,NULL,2,'B001-0000065',0,18,'2021-01-28',1,0,0,1,'+YEPHS9mXIZ5xqJ1Pr4x5hpGcTM=',1,'aAM5mciGlUA+JkKR8UMTGbubii3+oI/vkMUzvZPcPHgrYTUfWun1wDdyCMj+jf8fBFDRaVgf2P06dKyklYdhNfdfV5FUTldXwVvYdGPhI0QbPkTqRO/KNH/aIZfeiVZDltwZ0LgH6Pl4z3Cs8UEQp7kZh4RCtEiw62jQBUjD6PCbGTlCZENbfDlqbgARmVrxU5H4XuNT4ElFasykwSYjE3rHxz7gPV9WM6ROayL7SB5GxgD6ZvY6of8ZJniQ8euWF5RYPBBaHP2sYEXhStNELPf32l3hU7I+VR3y+n2PKMaA1Jf41vSlSruXJyg5NjTlo2UQ17VSZuHbIKV+UTo+KA==',1,1,'',1,1),(80,'2021-01-28 18:47:39','2021-01-28','0000080',1,2,1,'16118776351179888410','',1,'AAURAZO',NULL,NULL,2,'B001-0000066',0,18,'2021-01-28',1,0,0,1,'pMAXlPNhwdakhRr9LU2YGbiVb88=',1,'W6v4pGeISk0iSdK/l5/OFvXVpP0dPhaHz1G2G+lKSRexA/HeJWEeV58FHSGaAxS1Dmp+8ji+xTXfyBA/0LSuwI0HDNK6E+48EokL6YgrRkiriOdeFZhW+o6RyKXt/z4XpIGBuUflVlKoH5NESKyYOtKMvQLZptihw8hEWUi3JtoHfReMMBWqyeg9YEDSAq2dmaKtmpfX0XuM4sQV/1rYXls8xt1ELxtu16YS9qjQITxM3psgDLIr6QDeoMxt5bKGVIAr6o79xsRbPASa3tRWXKBDFv6hNEpOQX22MzJm31r+n1nUJO4H3CPg7hV6AiBUh7BRnn9T8pmUm3wc9DGt7w==',1,1,'',1,1),(81,'2021-01-28 18:48:21','2021-01-28','0000081',1,2,1,'1611877662593064009','',1,'AAURAZO',NULL,NULL,2,'B001-0000067',0,18,'2021-01-28',1,0,0,1,'Gc/RsYN3jEDV84qqJrDPzYl5uVI=',1,'QnoqtgFWOgzM9OqI2sf4a5+G+hoRFe+qgrKBTYR9RLMe/dbMDpQFxPshh9ByNKXsGzS/y8/FnHbiFW1Faf1EVm9HqfvbCosVXvdefs5EZQV7VDJvcCo1T9ajukdZhnOug61ZgAlfSwlmpGJrq4J1lzvLS9JJKQPapKRDzXJod1gKiQ0D2Ln+Z+hrin3/9ohPfN6lFfsVmXZ6Q19I89sqwJz6GZxirrOV0UOcMuU1WfjL/IYQv/ONUkSe0xud+VhUKbskgI2Awmwnv0Pb4YtC54n4Zu2T59FtFnrBle/16+xyNY5JUrv2cbCmuk39ipdQoD7h+en07bPzEYmPDWIsng==',1,1,'',1,1),(82,'2021-01-28 18:49:13','2021-01-28','0000082',1,2,1,'1611877705594441026','',1,'AAURAZO',NULL,NULL,2,'B001-0000068',0,18,'2021-01-28',1,0,0,1,'D3w/TBLjUYe9LgUmu0M4xiTntqo=',1,'euTq1YuGuBsuCecP+UPrLhyUAFwI8VykAdmPyEOw8lGtl8W9nWa2Jctj6LBloR2QDfWSp8ADcEU6uRk/6xq6Qp38h1G6p8WB4aDRvIamKO8fqGuyR8kemZdE08kUoYIGjBQKKxbisD6X8fbRx1kGvsMscTmycCavbyueO9imBTquZHZO1zyUIltlnBdzoSlLpneNSnMnejUANSLxzYR62veUgHaAQqrPHoWCc/4bnGZYmIX1GI3yWoWPiK6uakM5qrYylKy4snyOXkpqSasiCjHvQsFmc+ReIqfmdmG9Vk+xvja/siatBfDCVxx92a0kcJ+bvOtTQRvEbNWeAruQjg==',1,1,'',1,1),(83,'2021-01-29 18:21:48','2021-01-29','0000083',1,2,1,'1611962455846392105','',1,'AAURAZO',NULL,NULL,2,'B001-0000069',0,18,'2021-01-29',1,0,0,1,'RPZS3CxZJg/KEs0IpWu1u/m1vX0=',1,'Ay1DlAOI9Xf+HuzYtUshTAkXEOGbfN3UnouaMwIEJa+D4isC5iRUaeC9kyQRkkezqqW9+T9MrNTN\nJvIOHXO2iHiapeMvsrYtbtskc5r1m5y9lbrcz+k0vHJIU/k4fSzQAnVoimYmfD+iLqhAMaoMiaTA\n/8pQd6CjpLno9p0YyCiR2FPNnc5wSHoNBYYYHCb6fKIRjMy6kQrRJf6ofS9VRtOMJb5NBUmOrAFt\nuwMSZoCO2oVZbYTnn2uebDWdL1DzEGo8ow93MV625eknygNmSlHekaX1dRnBnyCmmXHAeMM7XZpo\ntEaYIdNCkUTChpV5ZvgDZ8MJQTPj9DSc32ZBpQ==',1,1,'',1,1),(84,'2021-01-29 18:22:20','2021-01-29','0000084',1,2,1,'16119625131278990602','',1,'AAURAZO',NULL,NULL,2,'B001-0000070',0,18,'2021-01-29',1,0,0,1,'X1e+ifQQldMql2j13bgk+WTALlI=',1,'hzdMp60JKeEY9gDWxVC18bqxn1J1elVBanPqlSUHbiG9Jau/zPgLv6m/7gD+v7ICayuNedfHBKlf13gJ9tXSvmHmIUcUDESoMnWgbEFqrhV1JDFJIAcZxBRWnnSDSrdLoxzCy/JM7Z31dwMAgyg3hUhmeTsn2/fYO/E90lU+RC1vinmqPaRwPAnJCzBmQ+UyroaU+rFqXkJTyFysBJ9x1696Nda7MP9Bdm/WBfOFZVdQlJyczCuMfl38SwQxhpSMuyegGO2k47VwKjczb6K6QbTtGEQU4QSNlBipnoKPr/g3GVqZ0wBboUCslWQiObmgvbLj/iV/Td9pBrYfeAo9vA==',1,1,'',1,1),(85,'2021-01-29 18:22:58','2021-01-29','0000085',1,2,1,'16119625471128809685','',1,'AAURAZO',NULL,NULL,2,'B001-0000071',0,18,'2021-01-29',1,0,0,1,'sxtg5tv8xViCq893j40xgTASgXM=',1,'IQvffCfbNFV0yCMBMi66gDDtHl8rZtCa9Gk8UYOj9P/5dzE8ag/F9IGFoeTWEztH+JvH05F10pcq4x3TaFVbp+sIaRPbURllP2KQPAcACINV/EOcDXS9fBfpNhK/akmvVDPMyBErJXe8DmID/nDOgG7ylriIv3SZek3qOa+Fmy/p2jDK6YN63kHVaxn+6uCBhCs24AN5DE0fF4gbaopCwO0lKhXKHoSZKX+GnLDtnGIg6t5BliNyzbY9VMvEMyrpiZQ8lnIUYZRIg3lDx3PNyZpoWwBhrUt7Vszc1B2BWXO5HDmvLxTrrlWmcZDaoWuTuCtx/ZB66gsQzk0SSupeMA==',1,1,'',1,1),(86,'2021-01-29 18:26:01','2021-01-29','0000086',1,2,1,'1611962580188952552','',1,'AAURAZO',NULL,NULL,2,'B001-0000072',0,18,'2021-01-29',1,0,0,1,'GJ27YGHmWyDlsg8lEJjSlB1RuGc=',1,'MpR1UVj5f2iaqzF+A0Xo4yWp1AgJ2tBy8J1jQ2adkCKdkKhkKkKM1zdDmz1yYaQmZ+eap9jYiZPMOO6+pmg09BwrUDBGvSDKad5ltwA9hmMRQnXKELhVOl+Nc+fK3zm8+iwcA/u7/St5VFC9/bjNkXQc8iw3QjgShjp1QsUQYCs+Oc4pNvi/RZa2jPSdHi5k+46VP0CYr1aPpL1x1lICT+VNQgk9RW+H6MrIx/Z60zDXcANu1D/GrQgtIOzChm9uVrOGKM5zica9x4H5jrSk2rYtMUvz+nNs/tGee9D91EikXEnKppCjZ86YKzwOjzamO7LFW9X6KJGURq1+LFMXYg==',1,1,'',1,1),(87,'2021-01-29 18:26:29','2021-01-29','0000087',1,2,1,'16119627641194648311','',1,'AAURAZO',NULL,NULL,2,'B001-0000073',0,18,'2021-01-29',1,0,0,1,'iHphd5PWHub+f8o2qItsv4QH00c=',1,'CAG2K9k/e9hQEw3rSeT4ITII36Rbk6wHGezeb+fKQ5vE5x4ird83yhoDcb1OmdmQscM5CcFbMD5XN7o/iKuwSazwXIH8Xtz8+CcoNndr3oxdx1k8vBgbmGTF5/pSmWFdKoklZmyaoQKeuilI56aIjVipg1G2z7nXJWYAHI2J9Yr2R5Qxdy2+miKpyqABpskSVcpPkZ8id2+rmpAcKRNdsiQblypgvWEsdARgVTw1JKBrWsbXSsxaYqGrvvww4F5NLPF/edLE6wbMkSv5UO14rW5f/0FvfDbBsX+bmSqH+x1K0+/Le2t8desyQoT1z56bnxkQEjk9TxXoOCfxbu3MvQ==',1,1,'',1,1),(88,'2021-01-29 18:27:00','2021-01-29','0000088',1,2,1,'1611962792137400478','',1,'AAURAZO',NULL,NULL,2,'B001-0000074',0,18,'2021-01-29',1,0,0,1,'fn0scKAf6tsRjshQUOcfjrcle+E=',1,'Zfv3rgqB1IC1Ya2uN5ST9+sCcIH2h0VJlQWWWFGKF+SdPdLqPkJMc8OjomA+YtGjBUjpDAxDgOE7KPd3oUC/K0TLyifroDhipB2CGUFCb5VHP3Djy00wuo+qWwAUFqa6Zlk1ToRT37V2VaGOaQyDhuj8QhnoM+2xwkVGHD5USjGFqaOzFyuWZsuLONPDQ1hPketUC8On72yIIB2f0YfBm8Xkie6GIimhmbWhFuj9V69bmkoWOJHz/5sPvTkGAQKJdjy+iKozxdQHUTS739K+OzOtxDc+d49Cot9dwiUJ8maGiQTDks1DBEJ7+gVRoIweqTgwq/pD0fIy6cA+RRtE2Q==',1,1,'',1,1),(89,'2021-01-29 18:27:26','2021-01-29','0000089',1,2,1,'1611962822941018992','',1,'AAURAZO',NULL,NULL,2,'B001-0000075',0,18,'2021-01-29',1,0,0,1,'qGGeHIw58FjSEz2INeZctKGPA8o=',1,'DH1Y22ewl1I89sClZatXFwaXhnQxIuE6Ta4qoQDRsbCvny0Gy0SIT/d0VeWt6ezM/PsFIslkKi4rkA4Ml5onAAR63OOQq4YPwBR1RTwUtRmQyAtrYZMUT5piK35ncnaHDEqiTP3hca3q5ppFZF01Ax12UxSpCeuRZVvV0dHP2eC+ipFxgL4z2FisKZhxcnohIluzyWigRe16tXpVP0haY9sWJ6Lnis5tTpc3dTWeBIgpIoPmxDvqIqfC1BUUEo1wQ5Obuw3qMeTZA+j2O5R3/ZoDL2EyMJApkXIeJoaEBeUg/tERu/aZ941SOQXqHNJ/q0zyy8LHtp400UzPXunSKg==',1,1,'',1,1),(90,'2021-01-29 18:28:28','2021-01-29','0000090',1,2,1,'16119628481027039523','',1,'AAURAZO',NULL,NULL,2,'B001-0000076',0,18,'2021-01-29',1,0,0,1,'Q0WeFOlq2xsGiSb7HEX5wZKXkmI=',1,'E/cGSDs3g+TJSc1fUF/R4kr9lgo/MnEiDvWKtYpak+PAlS4yLc25km9uTl+wt+IfUt7jGGbDAy8AMoRt1DI7b3SfAXRl+kMsPViDEJ0PvCraFhO4P7DWqpBOe/gkkDowx1C2hJIlmafywh1sdJaAfq+5NqQ7RzL2VWqCbhJ2/RyPQKr4Ws8xeXN5TH2KF59tze0TfPplBng4JYXAtE7qWftBb830LVvnHMulaDtLtH7zzABezinOeNJkizQQDt8rihOkjXeFGeeui7EiDZiJ9KkIu9Kb6jaF1trRSwoTe2MmU1WeNp/r0GxesM5c05d/fLLrntX2VGr4/PFB9TdnrA==',1,1,'',1,1),(91,'2021-01-29 18:29:14','2021-01-29','0000091',1,2,1,'16119629101130100639','',1,'AAURAZO',NULL,NULL,2,'B001-0000077',0,18,'2021-01-29',1,0,0,1,'3LzCNDxZUgbS7fPvFRFu/aKAu7g=',1,'cp72Wsx6pxU0lCgqyetfb570p5vVVJbEEwwkUebuiQB9x/vsTtHanDBubWELYnFrUE1vPq6Xgza4Egq54Hn1Bh1zf0PoHhlA+1FmqVeBYqnrXpohHLTlKWDKOfD5Po/n9hTPOjWUdpJ3+0OHLlgkUrDdx8NMvi504oEP2z5Ri+blQoHTtm3aMHcHADgv+O0RCJhFDCQmXrCPaqc0JIlJovcMT2pYrgeXI3p+kUSu88MuR7yeJ5a0cDpO3Sqiue1AJn8DXNgnHCrCcRm5QjCvlE2L3V/FgAMIxnZUJzqTnMpO2vSLdEL8x0dOxFP6I+avdrz2p+hkxycXI7/IrXSOVA==',1,1,'',1,1),(92,'2021-01-29 18:38:13','2021-01-29','0000092',1530,2,1,'1611962962199280179','',1,'AAURAZO',NULL,NULL,2,'B001-0000078',0,18,'2021-01-29',1,0,0,1,'dnokLzo4obCV52TmoAxWcAEpkpc=',1,'ZNhl1AVxD05tB432xSJtrNopMeMY0aGp3wWteTHR1jsc3c8HNp2JgAo8lhTxCScxu/K9bCwgZH9OXNc2ND/O1EZNWNulYhNxZiPpI+FcVXs4+twteXq73nw3GPGA76zmjcOKDdfaI5WF1uLJWMkmEL3yo/Oek7oi4sDOCRvWBqxYSofYzHPF+kGjjZ6hnZdz1Vd8ctfF1j3/iDz2PHGsynMjNVx+9RiTPCb+oiB1yYgX7vono6ZWtH+MwTAKtV0owuazT+gpGGZXSZNTpJUw0Ho6GKLtGiaLBM7R+ix7sRE798DethuJeIQ2zzb3iBLBJXJQh5fRyURllq3ozyFQQA==',1,1,'',1,1),(93,'2021-01-29 18:44:01','2021-01-29','0000093',1523,2,1,'16119636721040336343','',1,'AAURAZO',NULL,NULL,3,'F001-0000015',0,18,'2021-01-29',1,0,0,1,'qkky1K+TMKvzGVmmRd6X3FzIg+8=',1,'CQdtIm/3Zen4VTvDWdva4Q2JSCKp0P1oAqnpa8P0axkj4P3B9LCXKTctfvJ1J21U0nGsCw0hDD6uOwJfxLVOlnY5CsVWBbkoXK9uAhUcoA8/uh8Th2j6J6879Tjy3UAwJua/5b+Ho8YddRCMWE03p7k+CKJkKGqTfXbf3zisiKO0GOCFZSGKsw745rsFVGBclvpUB59RWXJFNmU+ng3KINDSQFu7XaBiD+4k0ZjNQWvokK8jlGGMrMhT8NsLq1ZG55Ne9pE+Kf76PuQLUm6IFGRJf2VBVI3ESqIIye+V832KNl+f3+EqhL0HWM9INYQDrn6W0ZnqJkRT70ai2P2fXQ==',1,1,'',1,1),(94,'2021-01-29 18:49:28','2021-01-29','0000094',1,2,1,'1611964137555540296','',1,'AAURAZO',NULL,NULL,2,'B001-0000079',0,18,'2021-01-29',1,0,0,1,'JWajYh3pAYPtAANV8QUPngl0EUg=',1,'buEXGzY7adnOtGc/NKXy/0HB0oT1ZCMtXwBpZ62Jt1XbE1yC2F50ZiqCqWqnOlWUmuXm7bBsbjPXE3XkbgC+1CmutAcTCTtFzF5qewGOzC8feU1m4aNExQ7a7j9q2M9EswGHCyFAmNsk2dwLLLmwIaVGfGx6fAfoNcy7YasjSLytd2G8f8rFbZzrb5DsQsXtiihSUeXC0fGsZr8JOq+GUJdNeSY55XeARA+GkHsxldS31paT2k9XvTKwudi+uK5yApLAjWIx4jusidoIq58fPEdVRQQQSe08/QQlzOjf0EuE3+xBOSfDd2/LoVXQeXX2LprDvOlxuRgsG3P6Qtm5wA==',1,1,'',1,1),(95,'2021-01-29 18:49:53','2021-01-29','0000095',1,2,1,'1611964171260471372','',1,'AAURAZO',NULL,NULL,2,'B001-0000080',0,18,'2021-01-29',1,0,0,1,'L2y7JWZFR9ZlxHpwgVLr55Spq28=',1,'MkaFQ4BWyfQGrX8KtW6nN+Oh0XI9ku4w4hMbb9SFP5jiSE8BmPeuQg/8yfQkduSe91dmHIRqIjz1mNUICWnrtNfEmPOtHH64+h/r8GAVB0SpGkpbxxsTjwdNHV0GMjqNAWXAvQHxllxeeTGKaGC1XeX1gdoiodsGWkaWAcOYGBQLcIvALZmPaWhQHSmERX4C54+6qvtKqzGdrpoxOYEz+GvqPXonXZLmQW9yCm4kaC6zW91/2H0At45eFaTbkFgm91PvSp1qDLKl0iHRvpUAL+oRcK7E+YMG6ogG5RThhGHsBE8m9unbQCSzrei4Lfv13ZGvjqbfBmKRNv3NW04JmA==',1,1,'',1,1),(96,'2021-01-29 18:50:17','2021-01-29','0000096',1,2,1,'1611964196234308049','',1,'AAURAZO',NULL,NULL,2,'B001-0000081',0,18,'2021-01-29',1,0,0,1,'mnJPfgGkvvkkn+bAxurXnz6z66M=',1,'W9aY9ahaHuKi8cTDIzE8hGx0KZ6C0+GLVcBa4hK7F15/oJIf/HwRXSAs0cUvQUcdF8HiYpxwMSJEXO9e/hOsCsLv/oOWe46GltM/Xntndp+jW/ZEg6X0nvsvQ/ob176PR9iFU7Wkxoeoy1IwTUe2WbW4o53iPSe0ul83MCQPQAJTeaY26uOdx+9G5LfNPU8DKTOyQauCG/2w7Eguu+Ir8y7piIYa+mqZHtcpgnDrbOnbY3DDRI693sieG+0mT2yCCEb7byRzq4kqsz3/07+5TMkV84JImMaaaRC3u5k/x0CclBYPJAEDxaxIMRaT/T1dWgy0h4nsIORQ2Bpx7YcLsQ==',1,1,'',1,1),(97,'2021-01-29 18:51:01','2021-01-29','0000097',1,2,1,'16119642201031729987','',1,'AAURAZO',NULL,NULL,2,'B001-0000082',0,18,'2021-01-29',1,0,0,1,'2XqEOetxlDX88xny0btHvNQ6pLg=',1,'WRiKzLnKfz5R5AkfjSTJFQ4OZtKqmjCNnzgRMzew6gle4041JONzDLpnPHfTf8XFCvMr4g93fM8okjeMrkdLQXIlx98jYIW/OppppcbadQ5TcX8KYe6DbiYWsePLFO+1iclxOvZjI06xTPFOslS7O8JnlYxh07Ki+kXebnqyfuyRRRlkxB/i+eT2i+pA2Z5HmZiORA+NxytRo2ochjNoYiVts+Y/ltjiUlcnM7o83zfEtf+DRSx91GYTYQqvRaR4AmbtJvytUsdFRXW/F5tQm5dhAK5lU2OfyPXiFCYATslm9sVW4QFhJspXkjlKQdQvF6gpyUASydc1m7Ex3ZkFOA==',1,1,'',1,1),(98,'2021-01-29 18:51:37','2021-01-29','0000098',1,2,1,'1611964264123027863','',1,'AAURAZO',NULL,NULL,2,'B001-0000083',0,18,'2021-01-29',1,0,0,1,'5qnXovPE9pWySOcvIe8MYDkZHno=',1,'OVrV3Oe9rW1H8PmT7e0mvbj8TqhBk7QsfYYuql+fpXRz+TerDXjrHvhD544FEWutbswQdDOAhgEJFw+kJ8b4g9DTi1zJgEua1KwcLAx/bgvzWuU/1BWXVM+dfYahdE5QZhkpnhVqnfUevaDosiwdT4zdj6637bfdaF20dZUkkND29b6mjkMRnBsj+iCnSEtu1UbxsSIGQjILBY1IBeQMsvShdWxJj+mMbj1dBfMH9DqSUj+NyyvvCeTSGFI5Owg/7sp0W2/anHuhIdS3IdEwfs32GEKB/wJ9rFNPF+Cf1j0kDg9VzVjK3VEWyn5+gUsfxImSwYhT4S1dVnKOZUL43Q==',1,1,'',1,1),(99,'2021-01-29 18:52:21','2021-01-29','0000099',1,2,1,'1611964300366544713','',1,'AAURAZO',NULL,NULL,2,'B001-0000084',0,18,'2021-01-29',1,0,0,1,'l0GCa04aeYHoSIZQSki+3vBwMDE=',1,'GCmtyRfABU/1jwRMnzuB9M3LmNw5u2/izc7PCcoyE2LV/aWemVEAvO4YlrAOc4ZYz7eZ6v89EhGKbJiNZRAQgyKktOVBXBdycCWNG0KuTCK7BL1vU2qlMJVlV83TETHIedaJAVjrzVWSfHglXXm0fyOJWrREvT773SSGL1YGu2Yd63hocvmvQ8gqZBZuyNgWW5UTTL+PyIjBx8b8Y5nMMtv/p9ZbZd03QoPr5SgTtpVPeBFhPJ7S0CcmMDvJPo4Q5Cadxz7IKUb3rHIw1L5/A8k6jTikF/r/ZLuzpLi1GZMgFwW4FsvvvHAm18/5JjLX6lnjoc4sHHcNTC/W6in59A==',1,1,'',1,1),(100,'2021-01-29 18:52:58','2021-01-29','0000100',1,2,1,'1611964349440516345','',1,'AAURAZO',NULL,NULL,2,'B001-0000085',0,18,'2021-01-29',1,0,0,1,'zIe6+ePzMngAysEECeYoRPgDOog=',1,'WXdWYLVACOMqM0LALliH5zJXEAykWaIeLhBnWwPuyCuBo96BN1Ew/eNaYTEgraNqY82loS6L3iY2dpYIE8Ktg29dbaMxg9vr8Y+s4/Wkkl3VleuYmGb+cB69vBx0FQ799gs7Q8NBT4sOsu58fFuBMjvEIKMdU59rkURv3OQQb7s82/t/GkLNw9PypK5cwRHcxHZPIEcDljk7bxsC+2hZEu+E/B0CndZKuQWeF9UjUJ0WcWvHT2nxBET7HeRoX21Zk3kBQ1N2yz5jE/fbPXqmnbrYCd8yb5GOMtVWVzWWKxCmoTqpGkr70xAIRa4CBR681kMj1zQcFqSiQBgM/J/w6Q==',1,1,'',1,1),(101,'2021-01-29 18:53:28','2021-01-29','0000101',1,2,1,'1611964381636181854','',1,'AAURAZO',NULL,NULL,2,'B001-0000086',0,18,'2021-01-29',1,0,0,1,'DvpcaIlejVxIrY3xpHQJXKh++vA=',1,'ZdFxIgiWGBA4umAEf2+pTNO2Lr6qLeW4wW2yuZxKvUfwg/t0W/p8Km1nm1z2g6tydbHTcXAJrTi3Q98P2+Kr3iSG7Jnn8stfvZ+wDNZ2KXBPygfiNRhDlRckRZgmL75Rbvm1Wt/pF2qV8hZhm4QiXMyZMhKhX3hVJr7BfohIbPP2RmnvyUdtg+Dax5HeUMGGijw09N/iHJg/xYLhviSA9WywRrzF5C0Lm3Y44px1bgzD9xpqQxDHVVxRLAMNUvcm0LWRBz+T/goVLYvJp/M7Ww0JLk7YBJdnHU+x/KenITSYmsc/cIBuErPwojlrXGMzTgc04Lm7jtTtK0sT7yWuJA==',1,1,'',1,1),(102,'2021-01-29 18:54:40','2021-01-29','0000102',1,2,1,'1611964416130214170','',1,'AAURAZO',NULL,NULL,2,'B001-0000087',0,18,'2021-01-29',1,0,0,1,'32HcMR2WmGferkFYaodYMub16yk=',1,'Y2S84aOTOc3h7Wyw5P+FHsBDXv1T5PgHo2qbaOkYPHkMDhFM/lPhNzrGST7yx0TYkc9bLV4I2LDpf4oWCLagPXp2jGUzIvE1y7HQBR1engHAKXfHjmCrO/XZoUJzQ2f9oxzAOs/TTmM40T4CsXzajmurblAk3A3+OG6cjk5aeq3QJ9+qeGPdEiF89rs7VlJywFGYm6mSK0TE57HayB/4NPS+x15Diav+kcgwOjaVSjzzpAWCqfAxK28Q1aizISmMvaw31g7h+T+y0ybpELvq8pyCxmtOlrlqj93hTeWMoo8Dly4t6h0JG0vje8AQFDtLccLDK5UFxS/MXr2qleCOQQ==',1,1,'',1,1),(103,'2021-01-29 18:55:12','2021-01-29','0000103',1,2,1,'1611964491857967654','',1,'AAURAZO',NULL,NULL,2,'B001-0000088',0,18,'2021-01-29',1,0,0,1,'1gvjRgvwG1e6EppIoj3ntoOewB0=',1,'D6hHdTRoik32LaS1eJ0rhY9rO/3QlQFG1TPGOK9o9S7ltEzMs2yUfXHH7dPA2KWE7sBRZi7aPq4Zu0QCEwJ+g9dmHfa8aDFIPFAURtg6aV/CqqEiimRlADG8gezm7rho17sFu1xqLKLAjWfbvLcqPuN0bAwdKhRLKPfEI59JKRJtTROCnZ9voxsvYck64bmjqPsrtROJ0+JxGYPsiPeHICBYd2SoR4XWw+ekPvM+k84Gyy6JluTrAOgn/gSm/PMw+6AN7ZX6WIzaCtY2PntBrbV+V3F6GR8L+XhNHVfTwd5Avhn/yUqUgDnIR0Ig8CIFNhU9kVC31IzigPZP6sygAA==',1,1,'',1,1),(104,'2021-01-29 18:55:35','2021-01-29','0000104',1,2,1,'16119645151372842917','',1,'AAURAZO',NULL,NULL,2,'B001-0000089',0,18,'2021-01-29',1,0,0,1,'+hw5VPdpi9G2dPft4NIVLa2Dde8=',1,'WkyY+tMLOOVnd0TlP4SZ8L1gvxw+2BPCpgi1iXUo2a+ILNknvVcQZ7Uybu+P8azRBM/KeE2O5Agw4IgpojX3DMYcHdmcspgkCRZN/KAYnoUozvcStEyt0aH5Ks2a8iA3kmQyfT/ALyY4VDym4MkxvDhQ5m7jFLy7TZBVFvxvMFQKqjhZg85GCRdtjD2/qV50SrV7FMc+zpaxVKJ9sHWWBPIimf2e5ImmFvkipYeIX2OHfTBT4FBTUQy8RDf82cBX0up3gdDP3s3bmPxN7G2ZMITkUlYKAnurbyQ6t7S3bTDbwJmAAtu9Z0KlI6lnDJaAXfmTNYptxwrstH37sgdEuQ==',1,1,'',1,1),(105,'2021-01-29 18:56:36','2021-01-29','0000105',1,2,1,'1611964556909003347','',1,'AAURAZO',NULL,NULL,2,'B001-0000090',0,18,'2021-01-29',1,0,0,1,'0ADbPFQO4esQqF7pOYmhEED3d6U=',1,'QZdXA3zbnaDehDshTZ9+84Pnce8YrLk69uhVdnWndOvEKNxGKtvc283h+N5XpDusCAqOaYwhnbVW4oWrTJ5mu7IDh1P3MdgrXXRUMJHqVHrIvGIU54gANuIz6ykMAeGFivqLz+vADikWa41SrU/9oQT5NQXXlrHhxXWns/a07Sc3z1ItouL3VcYfFlzVLZcIbemD+l0psZfYwQH63jLsbaON3jmOs3c8gdWXfD1RzRNaZiJBy7F1Bqesv1q2f300Vr18lhJXQ+TvKbFqhlTOhrK8CixWjNGtKSHKAM8oHImatDZt41U5Mw9yqvEfvYDQE0hmqOfvPovolO/w7a1dNg==',1,1,'',1,1),(106,'2021-01-29 18:57:33','2021-01-29','0000106',1,2,1,'1611964599114851825','',1,'AAURAZO',NULL,NULL,2,'B001-0000091',0,18,'2021-01-29',1,0,0,1,'v+Tb8rJfkHuu8CQEsUDschk04WM=',1,'HPDsi3FeaR35qVSJeLttR/Id5cYRIxV8qn9mDZzQfUlopyWKl/ysRhoHQS6kLKDocaVcBFTBZz/DoglOccPyJaqVkcK8shGGCyDXhdSeMVujTQXgXwmlmBVysNbFcwaOW0T29PZ0/qVi0u0csoOPvLgHIYhT3b/AtJRqC1V/FEThga4LjcKXhgFUyKcoZuSocM8nkt0IauvSFqGTE9k9Fe2ak9uZVG4hY87mOHOXAldTSiR0QvQsiFt5df1rIRIB6vyseCeaY/DS6cAb/HNfx3Qpma0TIIIzjDKi6jDMRu2gCQ2GPlMLJDYE7vE019Nj41MMQMYpu7OKnqHXXefGkg==',1,1,'',1,1),(107,'2021-01-29 18:58:14','2021-01-29','0000107',1,2,1,'1611964669835892351','',1,'AAURAZO',NULL,NULL,2,'B001-0000092',0,18,'2021-01-29',1,0,0,1,'t01hCXImQ9Q38DC7wUD8+tDi9mA=',1,'JD+40EZmJk/Jfmchmd+mqN2kRkmx8b7iKGQCYsIawmYLFgCi6hK67lhcOpJ+3g6gxb9UMDY93p0a1MN63oYGksboYUbrwVN3hVcYWKYHji9jdnYrAlnxuMEaHQLkQw8PR9hzYlHOaxXF8L+MfaWM6BysJcRCF0Fb3eEQN9Ce5MVzDiJD158jTCnUpWOQibO0TVwPxds6gebFY9Kmo9KvbGFNQTIWFMndqX0h/c+6FhKJ8RDpMbPTbPKjPm5MZMvSY6wlmzjhEQuCEBY7AEbaxCQL6OzkoPN3/cUXAZBwg7PrtkA9Kx9A6WOPHr+ivvKPvfol3w+XJWNgDPh3gyG3JA==',1,1,'',1,1),(108,'2021-01-30 18:18:42','2021-01-30','0000108',1,2,1,'1612048698247174552','',1,'AAURAZO',NULL,NULL,2,'B001-0000093',0,18,'2021-01-30',1,0,0,1,'mSLr9kzJFH5SMHWeRInz+JoDfS0=',1,'PJEQ7IiYLHupnCGu+skjRyqrbGV6M08C/WskxRtqPI6anDCW5kqcCjcsgKMnP1srhiLK+VvsrdAz\nKD/N2rCMpckoKVHadR+OoiHthp0+ZG/+LT+pIVRwIKPEzceImsBNYIcYddf6blIm9MLp47Nd9LCz\nPUQxZ22SfRSOWM1d0+bh9OQOvrHOLAph3rOke+uDpNW7yBPiJqZQkqvo2a5TeH6OCPbZNpYmYJl3\n7wxYCQAvfiMhtm4fe2ufVO6PR3FW5icbHrEIHV8OdVmN22NmWtkqtYIqlzzdBhrwcymlfrX9kGB9\ndWc6VOfjeob1Nd7yP/qOoR+RbuTVPcy2Z7xssg==',1,1,'',1,1),(109,'2021-01-30 18:20:19','2021-01-30','0000109',1,2,1,'1612048786794409714','',1,'AAURAZO',NULL,NULL,2,'B001-0000094',0,18,'2021-01-30',1,0,0,1,'7C3dG+rZ5/zXd8rTXqrloryXfGQ=',1,'NI9OL3+B6PqJ4X74LxN/1ZbGt0tO4qp8Le7+UyGCA7oIEamMPPgCdaiiHaCqUX1UUE0imDCuxjHL1z1KjfpCz0tUD1mYLYEgFFkvsx8uBNkfpwtaz97Zi/weLC2SUHJmnEXDdOrQ5oDpg/U3xIqVB3rUiZO1e3b9SV7PhR4x06y3JlulBrYD2YIpaAnc0pLa5p3Cs1WHtgXNXk/tLSjxVRLd3QYiDa0CTqsYUGQEG1Bi36xeE4jqJP25/iN8Ax1yat7PUdtVdBa+qxvJtEyLJtYPGWElgjUGBOsuGdzmNra23h1PeMOG8jFsspCJl/zyuowwK6KEf9zXZz2TX9zf3A==',1,1,'',1,1),(110,'2021-01-30 18:20:54','2021-01-30','0000110',1,2,1,'16120488221237938283','',1,'AAURAZO',NULL,NULL,2,'B001-0000095',0,18,'2021-01-30',1,0,0,1,'iyoZ+DdTyrymV41kQlNWy+6FA14=',1,'hjyyMu5s28qM+VGxdkuRbBeyOx/HQ43xSZ9VSsZ3O3G/axlbXMZOqSZWm2epiOpg/aaLRnDc86EIOGcJVPF3vd2psEXLON7DWbK3KM5zmBvYJmPDQ5Kdnv0CaLeaNKzfA9wxxu5ZghHA7mKvyuKx8587JoHJjS4HS1SevwwCX0d0vLXytHYxS5AoJDGAdg0NlOdSkeU2OWD6Y+Tj7sUE88nwIZcRJEjWfuLzjGKzHaThB7wLFuobCcw2cb4hnObdiiOGkuf+7+wBOHnG8UEAw1DjBHoODCupAQJ8jdVlZpwgZHgAarrkHOBZckgSPCtoBPKwjhyw6JFGit7dvncFGw==',1,1,'',1,1),(111,'2021-01-30 18:21:19','2021-01-30','0000111',1,2,1,'1612048857194116366','',1,'AAURAZO',NULL,NULL,2,'B001-0000096',0,18,'2021-01-30',1,0,0,1,'b1iCL4ipGzM0tdrXvQkrPoQonlI=',1,'LadaDL3cMxV4cuHhaT+H4zQVXTj+9umzg5Y3cxK+x9WxeVML8GXjBLyuCNKiQBJkUbjxbyiE/WNjV5kJRt0mlfAEb8EQ0JHoYtNkUPn1DC45/yC94V1bMaovdtdUjrITOoXaODNKyaNQom6T9WypP4tl7VLQd22xQ2o2yCPse6wxCBtOZe4sgAAOroIiY5wfiis5NxY2/4zyeBCQ+EFdORIVgUI/MW6HsuUVPMZLirjpVxr0hP4Dg3ONzBvKZ4Cs0XUCZ3zOAQbWfWqkCRiWjb67Dld2EC45GMCMndRxU0iQfEipuM2QFI5U9R8CdhWZ8mCHlsdYh0R9ypbfLzvEHw==',1,1,'',1,1),(112,'2021-01-30 18:22:03','2021-01-30','0000112',1,2,1,'1612048882305654743','',1,'AAURAZO',NULL,NULL,2,'B001-0000097',0,18,'2021-01-30',1,0,0,1,'uYzXVCK0i3PZinSKj1jxLheAVCw=',1,'dlN4Mtavzzj2FhbFSvBNezwYUS1DKpP1dkaT3MDXpXyA27JXoo+Oe1OqkuKKsPvT3mRjYt9En0IA+k2G2GjYZDN3NnCTL+YsIA+ssjZf0dqYh6rQyOtcAieCufl+Kr7LNLgmZoMFtVjgz09DFj4pVyKHAES/UNCvj9WjlQEI3Hy/x0UhfqgDb30LF1G+t/JF7UcSToI0+4gUBseDYlAbUHiIueZE0BNlYq+jPgEi7bV5it0y085oYyqfyS+IofGhB7Ip60G5sIPq3YABPyTdYgbLZDB3sxnlTfFktaKaWxsKoYybtrlSG9lRCSk9UFyAnLP2XI6kbYeKjnflyPGLMg==',1,1,'',1,1),(113,'2021-01-30 18:22:25','2021-01-30','0000113',1,2,1,'1612048926109214661','',1,'AAURAZO',NULL,NULL,2,'B001-0000098',0,18,'2021-01-30',1,0,0,1,'5O54LSLOxfupqD6uMGuNRHapuZs=',1,'fRRGntBY/U723n/sNYb9NAVg2FzW7nTrJDThW992KGDhhqR22xolL5XeZB6cucpKUJYoAYS9dlDBxiuSvt9ZccLh67U7AO2y68DTejjWP4Z30slZlgXp/8fa+zgFTBXsp973LKUpgkKKyzmbylULeqWI0poAJOp/SOqLx7i1Ivj7afI+zZdlt+dkTz/l7fU2dK2WstTCa3r6s+MTW0qGlyAuTkW8PmplQrRR9g9wFKUWFKYgaEKDs+bjjWB+j2KFZtpEOtukNtfivFwlmhkqK8oMWTImrtjWXWcZ1/MY1RCcTAUXsmBHX+C+pa9Nm21KDOGHQNt4uu4v6rGPjOPC3g==',1,1,'',1,1),(114,'2021-01-30 18:23:25','2021-01-30','0000114',1,2,1,'161204894825517847','',1,'AAURAZO',NULL,NULL,2,'B001-0000099',0,18,'2021-01-30',1,0,0,1,'M6wqzkFBKfJvEftxsD0/Z1R4V/4=',1,'duYmg4nYGui99CEmMTgulCpp0sm3BhunFUglqyqkpKszfGG71enuWDCQWlIVd0UdwDqxnA//nNrRlpN4M91pkrVKIdJtVx09i1yquH0kw5pAvqKdeTprOuKoxMGhZQG1ovaiJosAOfJAk8G4EkVleyxqYRRt/sLY5Ygre30vdXR7NIoQ3a/zidRoYpZYxrUtTq0y6SX7xS+x5XjoqfYS901z7zJDq6zEQZRKn+a0Yd5XQtFh6h7GdFAJZu5eClDTOdWI/xGIdvIWPcbWwvGOPcO1AquLmRlPWLjXDZl37xkkRw84tR6v0Nm7IK+HK7acfminlUTGEaocNdEcxjR+aw==',1,1,'',1,1),(115,'2021-01-30 18:24:13','2021-01-30','0000115',1,2,1,'1612049009783694800','',1,'AAURAZO',NULL,NULL,2,'B001-0000100',0,18,'2021-01-30',1,0,0,1,'VBvdnRQFaQWN+9IZRMRpeveGIPY=',1,'Iv/BzLfi1psHL170IwkhwZ7Xulkltfvcgf6Om1Zk1lifdnYNwvxbr03s39ZCuNo0vWvoRmxPcmBO8l8eJhRXSOZG+zLwveeyUClsIwHtSTAUgPyLGex5Cc/Jbaf9lrbZXohmgzRPWw0OJGEu43wfCIYyFQmwUzOZ8MpfeHzZRn741OKV1NAVRgByvtSgK+xtt8T6jnSNRcYNyfZH+S8y7DqLGHbBXhgOhvxx5HhUyJ6VBbn1e4EXFxXD9DyHo3tBgDw5ZlyKeeFVwxRXaCe6M36AiSd29EElz1nXDpJU4qHeD24rYKGlfQPqZvoR4bi2DxOWO37VXcDGVUb2QY8ZSw==',1,1,'',1,1),(116,'2021-01-30 18:24:48','2021-01-30','0000116',1,2,1,'16120490571105185238','',1,'AAURAZO',NULL,NULL,2,'B001-0000101',0,18,'2021-01-30',1,0,0,1,'ZcWuGnGmRFKwQzmxlBl6wPQ8Wls=',1,'bpj/+XDNllzlE3DiDsZZuUIBzjbE17PN8ZrgJJkeN77cxu5nEwR+UV/Hgl4rMPXlMseZ3amRoA0dVa6gb+woxj0urO99l9jgPT+hDdpRc/JgfK9HEIXukOhDut9bNLmeByVYtq6z6p/Kumsvn6/ZrsHawC6z1n8w9jUhmS9ZcmiMe4VVmUG12vTt2fxYJU3FQ5NlU0cfS3Q+EkfwM9cr8q1c2jsY+xTkgMbHL/R5z5C56PvnXinUZOFHvY8gEpVReGa4zLVJZ604kYgghTwX+sxJ6INwJNRac+BtxOsyWozQmXEXV0l6uieyjb2YpZvno2f12VSCaXGd9QRRsQW0Fw==',1,1,'',1,1),(117,'2021-01-30 18:25:56','2021-01-30','0000117',1,2,1,'16120490911404299149','',1,'AAURAZO',NULL,NULL,2,'B001-0000102',0,18,'2021-01-30',1,0,0,1,'pbgkwMsVAtQVeTBEJh9FVlP7JSc=',1,'LReqC25sT6kiBkbioGuwUHR3SHkNYkMXhkNPUvF8C4mPOhswFT25FRgQJ3e3gdfxAOmdWVzFKpA9PT0YIaX3i8l2YV5NMRruxhYWHUi6MrZu/ZX+3rp0Za1Cik1WsgNn+hi2gsbkrePpVyrEX0+eLL0rSzz+R3cZEYlzrC5jia4ysiARbiS7qgBgPT49TkhbaO+DTVsyTp3hEYigjF4OPnGqA15XV8YzkwJO8fuA0JGwU/rbq9X7DtjpNRz71V8aug8fo0jXam+BMQ1VDU5fNXRQe4asSZQ0XNVAcyOUbiHrnOEAd1ybTsEaX2WyGJJiQG0zUpvgPXL6I8+O1QxTLg==',1,1,'',1,1),(118,'2021-01-30 18:26:51','2021-01-30','0000118',1,2,1,'16120491591069985241','',1,'AAURAZO',NULL,NULL,2,'B001-0000103',0,18,'2021-01-30',1,0,0,1,'MBMiF1hj+Nc3bBG2pjo8t6XYLrw=',1,'LB+mZy6nhBkchlvbbFD/QtBri6XfjI/LydMNxAEusLjTA86yH7j7Lzthn+GLd2y43izVETT6/zHaNxQQ/H0+17ScF21nvaSclklqD/kUbScUpOyjbmj5K/6ov4v92HmInBwDzTyiZHZNlsSa91M8vBqUochJ+f3AIvjMM376x2rsWvZzH5QlTfa9eYq4wwaVKte5VIN5F13g71GeAF/r4CSmq8go7jiOd3Eagug3ANVKZ+XL5Wd+aQql1FsQDTRkBZU0ytViA0uOlFdPkH7/qW8mhRRiWIsBDirJ/bhpVa5zQ8AjVHsixz0014rMtkDlNeNnLXVQQXMawzvb4XwS9Q==',1,1,'',1,1),(119,'2021-01-30 18:27:20','2021-01-30','0000119',1,2,1,'1612049214178495829','',1,'AAURAZO',NULL,NULL,2,'B001-0000104',0,18,'2021-01-30',1,0,0,1,'7pb+Sc3azNiDt7x0iQkHJWi9STQ=',1,'dwCINamMwUtOnKvtMsyJZ7LS+WeI4/D1sUYPPTtoYgQb8uD2DgxymF8dYNTkpmq3Mc/Z/lH72ADrF6Q1PizwjsN+H/Ou0SfH6FUVKl1KgtKo0w41LD0mf2H5wpW68jYXBLbhoUrn5TpBw14WLve6dG4JmEHlxQlsYGK6IfyhyaOGSGd4HQoFrs/ELg163ROBYuxWPcFZ3hfVWqqYHbSa4XT3acoBB0U66g5P5L/FXW30t4MkjkYTCYmV5o6nVEZCenw7TNi291vsMN1euo9Go3O78FBt6c9/qBuUxhz88XgEGLlUspMmc0cmyCUJXpIlqr36IfZQPW2/43uS9iI3EA==',1,1,'',1,1),(120,'2021-01-30 18:27:43','2021-01-30','0000120',1,2,1,'1612049243844240516','',1,'AAURAZO',NULL,NULL,2,'B001-0000105',0,18,'2021-01-30',1,0,0,1,'IJaLRT8O8XZN9bHGPkr0D6kzPcw=',1,'GJOFNSJyvEurTe5CfaFYj1GCbtKHB2bV0VbB2A4ejOM0crC+1oUchpqJ3UheLFFKSG53zV/D54jMI1yBtqSTZZumdtbFvtRKxfThkYtHPeHsCvP3dQFryIq0p08qohz4/pOvZyQYwz66/GdLlLfDz9UPLmfpU0KKd52VsDyTzS0iF4wptEHUk0RmjduR25KmFebev5PAolHhZQ1DydArmCCzP2tU+hQKmLLNyOg6nZEwCZs4c8TzPCflvZDgCk1Vec3VZGTUf6gbHV4+Bsth95Ob/65wBTYtLlrxi5vXTsFjtRkButIm0ggcnOKyNAlCvO2llx8jHi0t+v5fbNoq6w==',1,1,'',1,1),(121,'2021-01-30 18:28:11','2021-01-30','0000121',1,2,1,'1612049266122468450','',1,'AAURAZO',NULL,NULL,2,'B001-0000106',0,18,'2021-01-30',1,0,0,1,'8W/cWh7BO46tMdGtgbUhqJstaKk=',1,'PPehpPjYr9QqCWMh4VUt6wIWTJki31nRAZ4HUtp5/m8DRiaRDmwaqxRlb0tU9vNeIGUR6o+SFl9CIMnQJzJGq4m/R67CTZuY6sZedQ5r+wX33wbE9W0dtvqZiAU55HygY7Exlmdc8Itbe68TXzg6r3xxbZGQl2VUWgGIvaOtKAhMGEMdngQs0afH6QXpYeWJUZaGTDH8GsQetDuVaaAc89qUG6Frn5Oh5vqtcEBtDdtUlZqCTGSzc+ubvNhYg9R8TUD8+bkb/ALDqX5BT/9KfVkQneuQhVXar5ShSk3d3NZlanYYgQNZJVQffl2n+cXotg/6E+VD3Y2Fgju4z4Na3Q==',1,1,'',1,1),(122,'2021-01-30 18:29:02','2021-01-30','0000122',1,2,1,'1612049295133097300','',1,'AAURAZO',NULL,NULL,2,'B001-0000107',0,18,'2021-01-30',1,0,0,1,'vSOcPv7su095S5As3xrsiofK+GA=',1,'KalpCJce4kYPFKc4bDHNyC14AMJp5XnAIeDsFWGSZM8LW7HuFkQghVkJbQ5Mf9ugd9adukXc8BfsCpvjVL5ohDPVxmZIQMd9wVdNUM/zm/3PhgXSCjNgwsM5EtLvnaPkZCGs5XvStNvYE4logjLsEVvw+HZDuU/imW6Bl/bcL18cXEZFNvb4t8Ykbyxq9L5X+aTGFXKXMn6zUZaAM9lkPTNhq2UwadHZmy7zNujVSQ3HpfmlPzqtlQMfHz+hbAcM7o3hhxfGghUStgU9CJR2xl2C1/fq+YIQtEJdUkRivaTsKXv1GtAJC096H0vDSYvuhyC3/2mX8fRhfZbzt3byrw==',1,1,'',1,1),(123,'2021-01-30 18:29:41','2021-01-30','0000123',1,2,1,'1612049352116271873','',1,'AAURAZO',NULL,NULL,2,'B001-0000108',0,18,'2021-01-30',1,0,0,1,'QpMT3XlIzSDhRZt21PsDTEyIwQ8=',1,'RqYqeqqCedRzO8uuGUPnBwIE/HeH+oISbb8btX8HtRwfPHM34KVEG+g9GtvSHzf/TMwPNlcK2ugKQTEpwU8/v7xm4Vwvz0B9jSBP2ZkzdWpPn56P6oqiBjMxEgXUigZv0i7JPwYMHPc0xui3hyt9OOD0xm9fJlkIihDXOnQZWNuw1Vvs6NpHCcnaBv8d8mZHngicve7BVETBFmFvU3Bnv3adfPVXZnbwYRIp3T0eGU4gcGLNFMeQV1N7Z1N2dKGh1wMArGfIPfRYVz550RJxV7/d7fN280Yfp0+BHdFWDMnHxzfs9Lj6978kRTdL09JNF7JXEwoJ5cqySbq2Avbdew==',1,1,'',1,1),(124,'2021-01-30 18:30:15','2021-01-30','0000124',1,2,1,'16120493841057118738','',1,'AAURAZO',NULL,NULL,2,'B001-0000109',0,18,'2021-01-30',1,0,0,1,'VAeo0KBJeXVjKqT2b4CRLgnjGEs=',1,'hYMyUW8t77KSKAGo8Qm4d7YnWNPgs1Y3tEIIaEXZzkbus2AqXj2lXeWHTCHpZsKgQ6RlD+Cgbeu/G5ObJTzKcYMejmckTgaHeZL63CnB+cD8ai7QOTsWsBiEwcCWCfZU25jFq7TNDk46zuCAjx0HwXm2amOH7CaPsHizTQKBi/Wfl1yE8A5WIecsofBGzfke9LfR3qXI4tHd+kXJrztHo63EQmKWmRgq3DAN5h6RW3l55TxVRIHtcWQHFjklPJzPMnc2xKbBsboUIPTXrZLn4Z+N1Mxe4mL4xLoI2eIhs+F16LWUouUy8bW9GLiDOqbjAnJ0kR+KrCH61/Bt8Ndq7Q==',1,1,'',1,1),(125,'2021-01-30 18:30:46','2021-01-30','0000125',1,2,1,'1612049419449466955','',1,'AAURAZO',NULL,NULL,2,'B001-0000110',0,18,'2021-01-30',1,0,0,1,'GG5PYYgphOqpO3uF92GlNPwTGu8=',1,'KvlIZkHe42o7e7Qc9mIqR6qGovqeWikCFPGffPzq/A+YH8a0vhFTrg4sErJ5NNE+MwbK+txr9ky3dGOz1gD7oq62R2ph/QUk2dpxJSBWHaSavdCc/+Ckhtixm9bEz2UcHSt+RaMYS8VyZ5fW6YaD28+IpeLCB1myuS7XDKjhwEDm4PJeh5YmDzfnyv7BRNnS4BS64K+2dWeX3A013ikmAZJldPXPwhHQAwfrS/aFAA/keWFDpAaBanFJyFLUYvL3KxhNRClwF1HLZOCSFwt8+NYJh6hZUP2vMs0uNs0oQL6Qd73zwpXUuPEcSni3s2VMRt5Je4wS6APfD6rYe9lbhg==',1,1,'',1,1),(126,'2021-01-30 18:31:31','2021-01-30','0000126',1,2,1,'1612049449141144243','',1,'AAURAZO',NULL,NULL,2,'B001-0000111',0,18,'2021-01-30',1,0,0,1,'3o1tlSy2jnLiOqY15puvyOUCHa8=',1,'ibQkaiXMIZbygR196WISO9LUOcfkOdsApRrLdtQedyZFzVzobIxduKldPMnoX2CH2FxWCx1NYsAeLY87P7pCvCax05jTngEeFj4No8mEeoiv/e9aY/NcyE/wsrS24dQYyB0pkZDnJIEjs6uvYPwjMPso5l98l5g7ZLn82R+lj3oNpTm3pC1Tp0/+LnyASGrBLIVJTgnTMXReJG8DfbRE7yBNSeJ0/tyzQA2XztT8a1P4kMBhcugPELIHxWE/Q142SsDW/sv38O5wNn51pY+iVF6oTkD24brMOp4o8MyE2SNne9F716taRoSa+3nSUwstuLtC/ILLlkc/KLzP2Vsh1g==',1,1,'',1,1),(127,'2021-01-30 18:31:53','2021-01-30','0000127',1,2,1,'16120494951126615065','',1,'AAURAZO',NULL,NULL,2,'B001-0000112',0,18,'2021-01-30',1,0,0,1,'+2yo3iOiIdQGo0lrLJ1j6KahjsM=',1,'CErudK+upm2nvK6sQYa4HSQFtHwAbhmOdLhsAOn2ftgRXLb7ND5bymoAYRknp8WwhoZ6pwcgtA7jMKJZmLYExpYF1AXDzkOr3UFGNjx8K9dt2qohbJPUv8ORnBM+Xa6mYhKAWJldmN41d4Iy6PiMV/eR+aWF8kb+A7qXQnIrx96Ous6mZpA3LawFSvhKL6OckoDWzVqpxtqXv74jbkzKOk+9EAMaBIglImrath9hxn1HFAjfHHLnwSN8alo15nBfh8tDRP8MatwBd0RmLb9YE0lP931TraK8kLZ4s30aKGc5ttVfp09Xw6GRwYnnjBAcDY7SQXWvhHbcz6Ccs1sZsA==',1,1,'',1,1),(128,'2021-01-30 18:32:20','2021-01-30','0000128',1,2,1,'1612049516722675734','',1,'AAURAZO',NULL,NULL,2,'B001-0000113',0,18,'2021-01-30',1,0,0,1,'jxkzaNrBiznPf4IUqEy7aqml6OM=',1,'PHvWC9RL3eL2DXoaOBvot5NVX7DhzZLvtTDpe5O1pqRqW35eRajCsNu0pPlhnnFcpVjiSLGd1ZUOPw2v1jHGW1LI169zxu0EnGeaxYXUepl3zwpnb3prLJqFjPdydkEj3OtB38yW8ZcGbrkxepKeQCSlz5OrzbcBiCum+suQAzjOGOBe9M8L219pZTY9Hkyo18649Wgb/4a3xkn9QNUZAFT1kKlN4LfhNFTeJQeoOZaCWax1zEGLKg18BeKzy2pcS5ZTyfSrvtXiR19mvkgjV0NCd/17rN/8taYX2vRsAjx9pqxe7+/PL06BdgZ8n2iLn08UV9sN3+vf4rdt7sNSBg==',1,1,'',1,1),(129,'2021-01-30 18:33:29','2021-01-30','0000129',1,2,1,'16120495871028889889','',1,'AAURAZO',NULL,NULL,2,'B001-0000114',0,18,'2021-01-30',1,0,0,1,'0I9/+fVYIZtWkX/gVwLV2h/Qmjs=',1,'EkCq1Y+ADWEdSKBtzK9Oiq82zHZTv4RkqMd7HWq+o148ThqH3FU+LnBrwwePmDif3SpzdpOLTe7PByBFvnqHqfUgvAdYbNdHbcjYE73jB8te9wx5ouin4fe/ewRJIeIHl0igE1WFYqokEc5imN8Ev2yiMpt9uUAN0DjRR1d6eaZUXIVeC7WrcT0WGbthatcCQMOvaOu/zlN4K7qnBDnar9+4qFku+CigFv5rOEbvZUvNzdDHYNMnabCVR2zvHAra90tuqe2UzAXpfUdJYCRCbFGqxoZ1Rbyyg0gIo9RqMlaOvEq5aNHRrja9Jg84FqivwshCsPuokAXbXF6kFhEQxQ==',1,1,'',1,1),(130,'2021-01-30 18:33:57','2021-01-30','0000130',1,2,1,'1612049613275274305','',1,'AAURAZO',NULL,NULL,2,'B001-0000115',0,18,'2021-01-30',1,0,0,1,'lSpIZq6RtpbL+ArMIvO7lseaaYg=',1,'LDhoqxJxxCvNlZjZ4nP1YT0ZaHSvSYwABRn5KenOj+XcDPInT6lJYT5OEC3TK0XMFmQBmSCf3uCJaf+P0dFSQEGp2G/fiM677w8kq2H1oVDvZv9W6EOqDTRiclVoipW6OO3alCCNRDHdlzaWXI021NSTkjVL1F2ODQGxll8tufpdPdBPux+GAuyMKmhZavHohKcIkVCj0czZt/EzzVB/p0jztyX75xY4sFBlebRy2xkTyzeQftk8t48XcPxx0roRLMofGjhuM/S2/7PhIrpCfugdXDgCIpCs4Gyng7wrZHPYdO0vt8leE5MOetpOcyy7NrP6pYCsgWigIolAvQCdIQ==',1,1,'',1,1),(131,'2021-01-30 18:34:37','2021-01-30','0000131',1,2,1,'1612049641806286485','',1,'AAURAZO',NULL,NULL,2,'B001-0000116',0,18,'2021-01-30',1,0,0,1,'AFanHArj7dPGRx36KkRrwtGkFUc=',1,'HOdgnKQ7GBsxFqUPnyGA2OQ9Z9oPVMDg9Ax+bUcV73p0AKCaq4vxbPYIRixbbCUsbFXCEJkEoLNHHsftSqTz61bklUJ1KdppFpiDsCsd2/E0zIxqvkc6KwByLLP09MuVMZQAP5bc+Q/td3wJlwjuCwdV5sG5Le271LcO5Bxa0btMDsVU/cf8XcYBLStjnatR81xlhnlZOhupyHe6REcSukdtclURzJ3vQtr8SgefhidpPY1zOppia9I3mYdbWtbvHlGULIOildUpzGcB7JDy6uJCSXFJsjZT6u+Bhdp40WpYHYoENbFlWYC87mZvdFbYA6QK192CDeC1FNCGQqaatQ==',1,1,'',1,1),(132,'2021-01-30 18:35:10','2021-01-30','0000132',1,2,1,'1612049689338746182','',1,'AAURAZO',NULL,NULL,2,'B001-0000117',0,18,'2021-01-30',1,0,0,1,'KZEF8gQxVj5en81iga+iC/0vWzY=',1,'Ki/UyJ4hhLIjNaQBFMcAjrox8+T3yhlJBtHRG1Twvtxi9RwrLsL5MVblts0nOKecoDUW1ezZtL2BUCuuOKejnytpulcClHlYukX71WLkWnHV95W04MknYIi1lJt1z/ppIInER4S7C5O7G4lU0mBoWAyJHGkTPxEs5suGutTdz05TiTzNkz5eLoTEOXy9yEesEFKoSCXor5J/f6cXCfE8vw8a2JkgZxQVzgMdcd9+gH1Crd1w8N9ZVfqHd6VnnLi4L/i0fsr7tk4g9YdIaRbka8wRzD5Edgf/nss+HmcK2bnxYDfae9FRoV4TiAAF3ZCzBOZzh49trZCzsEPJtbAXGg==',1,1,'',1,1),(133,'2021-01-30 18:35:40','2021-01-30','0000133',1,2,1,'16120497131280066396','',1,'AAURAZO',NULL,NULL,2,'B001-0000118',0,18,'2021-01-30',1,0,0,1,'KN4vQHhlHnKHQCVOzazvUj3WYdk=',1,'b9MYhLvh8yN24v4kSz74xfgZmQxKvKKB40TM2lwHVIB72nZNBCnkayzBumKtO4qON2EKomIUWqRJQeVvKrOb5950JzjYyROnMQ++2A+3oA6Ur9Kq+7vwy6K54KyFh9xBy0DpIDYxBoD1UOTnjw+dS7g4UGEm34ZGzinx7Ju90rZqQ2Wvh2Bt7l50fIK1CZswvvjFAG257NFsSA5CVBwuAionqXrhnlNQKBGomI/APYlt78U9PKFGrp0ZhIP5y3VKgOAs0R52U6T7fX8RXKcvqybzLjS+l5rPUgEo/rzJpCBwWBdlY8hYlBTY5Rvf6u1tNWjIIa6WhT6croNPekzniQ==',1,1,'',1,1),(134,'2021-01-30 18:37:14','2021-01-30','0000134',1,2,1,'1612049744748322676','',1,'AAURAZO',NULL,NULL,2,'B001-0000119',0,18,'2021-01-30',1,0,0,1,'x9mM74IfDSfc+V8HQGuBBx2Q54M=',1,'J6R2Q3EylT4wbUK/4WMi9iqOUWmV7DR6XbrH4/sDhKpWBn4i+xvZ2KnhLHU7shWYInyrErIdU5YISkw5xOrHhWfxdfD2Hh79ViaUEYjYaXfPBRAbIToth4tRuNbDZEs5Dcme/g3WTtj+PpX3JQyEXE1Em7Z4CAX2e5uRIuML51HICr2kzKJk9LpykVTBFp6PYfckXEDD0+IIoVpCdrp2hOB8wg4GvzEIAuYnyHv9Lvod3c1CafEKBkEnQlJ876PsnMpadKSL0FdvXos/dom2ky1IoAuOpGZxjMNV992nEQSlOfK4RLuuR6KJ62u2AsVGUdTpzpRcFV8X+3baqbECyQ==',1,1,'',1,1),(135,'2021-01-30 18:37:37','2021-01-30','0000135',1,2,1,'16120498371312512359','',1,'AAURAZO',NULL,NULL,2,'B001-0000120',0,18,'2021-01-30',1,0,0,1,'0ongCu8Je5B5gv1hTwHYgyeJJ0g=',1,'dAQATo+eQr4GQ2icnSFpeD3jLunzEekayRamruw9xN2zHKX9v/5CFoZfR70602y7JHFXymDPKLaSOfjBo+ZpehTRTnPkJ3YFLL7lfCNVfNU/sF160RjDamGmrdW4LMLlQ+ZEbZM80It2tb/8DrJj9IKRAM5p0EkMEoqDZSgNVUA0zHN7vb1w7TRNPKaQ2KgDZO92S1LqUwDA7lr4cT7C0n87Rz6JMr2o5+H3CoraMJNLSloSSRYnxYGvVx6ijef3f7RtcUCkVK8knIwSYBLgCsw6mhfRGQ0+HzyJxfr26s9WWDd1YfS/73spjBM8bPq2V4Ly6WlgPdAINUsKfT0FWg==',1,1,'',1,1),(136,'2021-01-30 18:38:15','2021-01-30','0000136',1,2,1,'16120498651119471789','',1,'AAURAZO',NULL,NULL,2,'B001-0000121',0,18,'2021-01-30',1,0,0,1,'lAGQixHFuujTOn5DsImp2viz9XU=',1,'UmGy96873zpjTMbNvlRqs61niF4gFnqcrx2b6die5iWdxgrnVkBct210vgHVBsyn/S1BEVBbAjcptKXGN0rjOq5n7ikRpRGvoYz5CUGJpJFDgHkZM3AnC2DXcwD2dt852IebZfxyRVjau14KUobSankA3FlSHuKoSNKuug5M7yWdctx4m8aM8M5ELQyA2zbnoGNMSylzR6YYBvFEnAPjVHsVLuykT2cl6XGyPjRsaNIIqctHaHRVSivFzoY4lmyX451Z6sFulEt0hX8Zth2cX7bPog+Q+J64sbjkyVNVCw7kgRuZw7IMtcgzJl4A2sk0FAHT0FnN/PwKuYF6FcEWXA==',1,1,'',1,1),(137,'2021-01-30 18:38:42','2021-01-30','0000137',1,2,1,'16120498981133801372','',1,'AAURAZO',NULL,NULL,2,'B001-0000122',0,18,'2021-01-30',1,0,0,1,'BJg/k/Jq3glpgzUsKgBXd+JJxTg=',1,'ajEQbJzPo4om6/UEcNM17IzXBlPZNdapsFH5mLTQ3PxSMXrTpZhxlrd1aDwij+gJGzUWyDxf00BV/8iXU5vmiRz+eUhhq1OrucSkgu/c8bbK04gr2vi7sfmhJuUBkQOuz3TphW772Oov43YEuOD5uN1SD/8TTlUY3eNFwhP6pz7MmC/ansDm8JGdGsvxXc1QjC2yfIDxJsog0qswgU10LaZy5BoUDfiNTvihmhZ2/SnwxPsCKaUm9Fihs7IMzV2fUF1X1Va4kSDBGAutQZdCu+pZjad1RpvpZvDcjJBiKoht7EZz9JmYh3oDn5dWvtDXNZP+k/2vyvnHsMl7WLTJOg==',1,1,'',1,1),(138,'2021-01-30 18:39:16','2021-01-30','0000138',1,2,1,'1612049925591600929','',1,'AAURAZO',NULL,NULL,2,'B001-0000123',0,18,'2021-01-30',1,0,0,1,'SZlU7TMCRhWcXtaO3KAtIpOS9Q0=',1,'e0/npRLSsP3q3wy4dMzco+sSVIXE6TlBwm5pGoDUB9oF8YJtoRyPvjCzlPicKO94fJ9EO6QUhnNcA7v866X8YdmL+ZEN3zrfICCtWmC1nV6O//bstzP0vf9zIZf7HmknZhC0BiO6SaHbmu254DNrKpdRRxNh/xnTGJIbNsFmb9+2yXO5Te+LqSPLdo4PFw5UQf01wrm12GNK15UbB8I0nTVBBAkgvkiFKdTyfEvL2kgSDb8VdraQFCoE2gW0JaPtKEMUTu62K/xsdmOSyULpCc0U9AdCKzNPMvPrbQFLSaDG7TeyPt4eRr+mxSVL3cWNFcNtzF9Mc4hh/0/xPNpifQ==',1,1,'',1,1),(139,'2021-01-30 18:40:12','2021-01-30','0000139',1,2,1,'16120499661175499168','',1,'AAURAZO',NULL,NULL,2,'B001-0000124',0,18,'2021-01-30',1,0,0,1,'DhFRtdnCOm02SmqxOdvgETtuhqY=',1,'HJc7aad1/MmrC9QMcKRQCdeuLK/GmOwKCvmHEAxMvR3GkDBujtdwqbIKUbgyH5T0oClYdZ4hEUnSiI/iN1Ub0gcfOD0sOuxf7di+8mwGTVjzSfIGNE5jy1pxAeg/vAYias0WUV5eemMvPPqowP3bYG+NYGMda9W0K5psS4xZm0lJDimishX+j1d01IeJDY4jgFUYrcN1N9bJ5lqAg3vWbn3hj7vQdQirYhWo0XtPGVsEfm0X8MgOli8LOXJ8Uneb96vG70E/3PxEkmBqKspV2wyq35HlC9q/QiVi9AgHL1QG4ywJin2A9jCcZTtz+eV2ID7NOGgflV5slt1n9czzrA==',1,1,'',1,1),(140,'2021-02-10 13:30:41','2021-02-10','0000140',1531,2,1,'16129816631222016524','',1,'AAURAZO',NULL,NULL,3,'F001-0000016',0,18,'2021-02-10',1,0,0,1,'AOnRC0+pNO9c0oGhnl9Mu6wwIkE=',1,'hV4zax4udB2DbHn8s8hOfqWYQANjox1lPRL9f1mkJUDMj0HP4AevsH3/bNWPRtea0xCX1GOiNobO\nAr61Elg5qJCjJErr4adzJL7StFSrUNZwufhnUACWQkHqU8oE6uIhJ2Vkskbe5CDTadUYpgFItqi9\n3ciWbBLeBmDVic8CyYzP389CjDUocLrfdNKQAisbbzjjVE8aS6KUdpQP1VOA+lt8HOqrFEk7hefZ\nVizfcspplZqSu0dgqHmRqiRtWXUNPKm7J9Iig8OCDSRvqNP6RYg+7eb3bKeOyyL3v76kegugPsYO\n1t9qYBfiWk7LjxMh0vn0IiEyoziFC9gWfmrrNg==',1,1,'',1,1),(141,'2021-02-10 14:00:12','2021-02-10','0000141',1532,2,1,'1612983229580584793','',1,'AAURAZO',NULL,NULL,3,'F001-0000017',0,18,'2021-02-10',1,0,0,1,'8npj5VEye1CW3H6DLVJP7YRatGY=',1,'WjZWQcvpmWa5gIuWVvaP6BNfYQOYqFRZOMyglz9FisQ9FBq2CinSfGuXmy6M6vlycBIes/7tgLuC/uWupoGxUfO5y5mcpFcEnlIuF4JEoGsB1k6BDi370ecud2L0/7OBkQzYn+E+zLcZAeeaOmVk0hSLaq235PZ9Vk5GUJTPjjC2UHSWIuDNgXDYwE64QyODZVslpl/s2ltCW4QrBK0C9ahqpp93ban1Whk+XukNUlogDHAzOh3bHg7ncHbdWxQWaoaA3rHa+zJtJOy711TxYOlzcIu24j/lt0OUTOinQSv+CaK72KTMnKzo80ePfyzJtmNvVkxs3Ts6L3PpMO5Y9A==',1,1,'',1,1),(142,'2021-02-10 18:15:22','2021-02-10','0000142',1,2,1,'1612998904832880126','',1,'AAURAZO',NULL,NULL,2,'B001-0000125',0,18,'2021-02-10',1,0,0,1,'QRoam9gX7JFPIR9hoxPWozxu+tQ=',1,'gAi5nJt3gh3uA4qFevp8UJVIsH4a7FAXJPBjgyU7LqQApLamlOiU0+i60mYFEWKq/HZML0hMrXKzGhkaSpVxppwCqFzOFqt8hAOAiXOPNu1T8NnuN6FtGCC5msz/JyiHpKjm0XM4UqA2/L7OHxnnYoaOe4dAlyera6pbssXC7+gT4FfELh4I4vwh76IKNQHeUm5Krh0K6Y5eI34XXx+ka9DUCeruuQKcxWks2gEHQSN1fY9NeI24vwvsqFvjZOb3RUo1X7oI0CclcGMxwfTIK18TLo9xvw3C6rfd7vDY4lTHpZUAIUI3WvgeXfjI/rRvCAIfU5jm0vWWYItNBNWX2A==',1,1,'',1,1),(143,'2021-02-10 18:18:54','2021-02-10','0000143',1,2,1,'1612998995494220008','',1,'AAURAZO',NULL,NULL,2,'B001-0000126',0,18,'2021-02-10',1,0,0,1,'5RMkuc3mCf4syEdhdrbgrLxBV70=',1,'WBbXZjPom8m6W6yHgJGBFAp8/2nhZvtjNwpnNTEe2zTjRtJzwsQCAV7G9tPLx+Y/Ykb9UswsMRwdO6MhWQ4cC6KTMauyRI8rbw9UJat+3u819fq8EVopBXGpz55Vxn8uC8SdP7gr6h3OsEi9igDQ/kgpVkzK4YeqIkX+RJuPvL2Oihmflmi/I1tM672ZA4lL4S3bTxBlNICgOIrMikeA+NGe4kxqG1on0a8UaOx4xuLVC47R/Qh2LHg2jv4NL5C4D+Ta7YZcgHOd+d0CoRLUkshFMta4q6KUqcoDwpgzNWFNC7/NgCGCqz7TMdqwigx4tEBWapcziLE5eccwgC3/lQ==',1,1,'',1,1),(144,'2021-02-10 18:19:47','2021-02-10','0000144',1,2,1,'1612999137486087001','',1,'AAURAZO',NULL,NULL,2,'B001-0000127',0,18,'2021-02-10',1,0,0,1,'OBtjjbKX9WUjFDs3ynuQFAOZpOo=',1,'IzkfDbGUT6GvAji3bwrIVchU5hAyo8X/5nFFZePVfXTh/VAiSE9uwHuSdZvruLd1gOsQsnDz5akr+sgBd3vcG4636QjXzuI+4sxB6ARe593lDQ1w3fDKvEKLT6XflxPkFgMRnrLJ1zyifwzAmQB7BrCGBTE5G51RKa1dTdrJKU/POYTzKbEGrE9ZVqzB7pUY2ryLxJoLkou30razT4iQbsUY6dmHq7Izqipzoqs8uMJQwzzHHvp3uDPKd3CkKQGomxAATOkhVw4xrNKgGQF58fIlLQWR3P0MnjI4YUm1NtltgHnLImQIpBzCHAIBg/dNwrwXCROibhfKy4W5hPMdSA==',1,1,'',1,1),(145,'2021-02-10 18:20:23','2021-02-10','0000145',1,2,1,'1612999190542458635','',1,'AAURAZO',NULL,NULL,2,'B001-0000128',0,18,'2021-02-10',1,0,0,1,'8qI20zvKprD9d5ObFOU8XahkrFU=',1,'dGWuEbjeku+B+br8zGXCU72UFwE/ACq3OmNtkoLSBtYriu3VRN3n/PX2xbeV9/7JNuasntiKeIiA4bXQLfDqtFaCMSMvfgN8d1RhXK/xesmCoAoUHufsDZljssNkH/QT0VnN58KeumH513foGyUFZV1bbV7zt3J6Qg2Ga6UHt2GE4kyz4uQFdRy1ePf5EWbs30zrAyOgSrbn/bOBGOJhDoasB4TulGeko+SIfSHf8gI4GoR1jXh7xiQpMzMs507+7z+e3/22cAEekGBPwjfTTMXZFq0hv/pMZbnJxPdh1rVgd5O+0eBr0jFgdrCPfI9OxWrdTAzexnDOqBxzd24O4A==',1,1,'',1,1),(146,'2021-02-10 18:21:16','2021-02-10','0000146',1,2,1,'1612999227996917276','',1,'AAURAZO',NULL,NULL,2,'B001-0000129',0,18,'2021-02-10',1,0,0,1,'S6lR/knxr3YWmO9ORjxflX8APdo=',1,'iv5xAH84YEqyKTRkuEzV44rCv1DAMo/iVt9wthcLB7TXaT6boofXgv8ahnE4LbZe7uJ2KJIzHM/J3/z39TXiJF+eYRpAvScE1uq9fkigdTK5vu3TqDVKlj+HlG7idoMKZAf8AHkiztbzWqSY0zF1eumwYXZq8nc6yMRkQqI7PZ7PYLkfJMFgJpYgw3AgP1BoPmBWWc/AVkF2routAUvzBUYdgvmhKmUYnOaW1kUT5+Xp3KW8vryiTtn3FFun4qGcX13AlWJKlOvv6m9ruckW167dHc0YlMphHYqRPoMTn/vTvjXMrmRCvj3qeqkmEJbA1BExrkrc+OsXwxuUQIDfJQ==',1,1,'',1,1),(147,'2021-02-10 18:22:22','2021-02-10','0000147',1,2,1,'16129992801141977411','',1,'AAURAZO',NULL,NULL,2,'B001-0000130',0,18,'2021-02-10',1,0,0,1,'olcqWiWQfukkfPa6nD6G8ieOsbE=',1,'K6gjOb8XiTpIU9+R6frI1FSxJzE2PimQya9cKEi7a3L7CO1B0493rJ5vvaaPx6/PMdhADi04AvZ4j7oYcLiCa5BoqhWfEDybbLkZevYJFwR7tCE4tx5dW5PCvBo45y2nXqQu3r9+kKWuA+UB+TYTNUv5OF6LYcpsTNOLoO+kSj+i/u9Ggbi5eIDDGfKV6agpaHFTJ32vre7DN8NU83Lau0oou1E1dGGDiEVv3hhgkCWB4n9bEsVWT5n23Zw/tibb2hRqkIEf3mEQTUjkOIj7v0fRIIUdPVXaQ7qp0olYchpscPO06BgLrr803nYOHUt3j4HPkSmhFE3doup13r6Hpg==',1,1,'',1,1),(148,'2021-02-10 18:24:06','2021-02-10','0000148',1,2,1,'1612999349348170142','',1,'AAURAZO',NULL,NULL,2,'B001-0000131',0,18,'2021-02-10',1,0,0,1,'041Ry9w5elel9qNA0vh6EktsHsU=',1,'B/ayb1Dh0V2PlRY3oIgmXCQGg9sgXRrw7VkNznoyC28k3WnVF+HI18S4LEb4Md8yDCUuu81zb+4qFRyRcUkJpJKmb7g3CHgQVIjmVxZ9ZWX3JeZvfl1wd2y7/ZDDisxfFwksao100ZWwOe/QuK+szC5kUVyl/B7uui7QkuyPZThh6ZL9MmRmYeM10Tn62PRSBRsucaJL6cZqyXq74aNizdCe1TiSDiiNKkNXV+cSLNWNPXUagD81Rj4psSFfNouKHYCG5BxqcAlFbkeqoHuAQm9j/rFihRGWtIwl6ylc4oGLQmTLWPHf+EWlyfInEprsL6v79Okd3NwW6geDwRv3EQ==',1,1,'',1,1),(149,'2021-02-10 18:25:03','2021-02-10','0000149',1,2,1,'1612999449930433174','',1,'AAURAZO',NULL,NULL,2,'B001-0000132',0,18,'2021-02-10',1,0,0,1,'oqcvprk508pgRJ+ZptwSPv/veAw=',1,'TGJegetZ82OmxXEkoYJ6B9UDnvgTiqHDZN/Uw6m+eaB8f7y+k/2HARFf4sj6JXfjzRclC2gfFsGJ9UPIcRDDofeZ/ojlLaPRpfaOc0vKMkkAQmbPeByTiLgtqgEHlY1++QNsJURqsecyCwok1xXbw4Bq4HR3AnVzJTCbv4MAYA+Gj60CB0wKd1EY2h/Kp9kSZGlc5hccBlFG6T+3RGJ+0R0gUigxeyRKjsQIi6cd0Vb9GELsT4LrLvi2mPFaDFC0DX2uPNJ4hYPZgCcrswh2/hhoDKnrkA20zeEbQihN4TpMHspPVyD4EJ0/Vhr6pH3oSEKuh+ajhtB2Ydm2r8dYGw==',1,1,'',1,1),(150,'2021-02-10 18:25:53','2021-02-10','0000150',1,2,1,'1612999507291540318','',1,'AAURAZO',NULL,NULL,2,'B001-0000133',0,18,'2021-02-10',1,0,0,1,'zyxCEVtz3bhwuBwtjF6iClXANF0=',1,'akUAEGjBUSjgCHMokz7dqWS1Qo+ssA3WZ7IuBWBv3UFdaC5FJUoVIRGeCMfyag5292O/OwEMkM+UI++JKgAw48tn1M6wCD9I90qul6ATcslX8O3hJKCepa2O0rO8u1aZTiV7qS75/R71hf54LwidBts1SlFfiLr8bQ4eXzrC539j0nWpvcJQumZgO6S1iv+5cSg7A39A9qGKmauv4fzduNrKuig+nnMJ83ncfV18k7+vXBXhHAypwWglDl6ZDH0z+FiRE0i0Nj8u0yCEs5PxD6sSJrlDXw5WsUM7AOcF4afRR8Yg4Pzb8p8NObp089GTdolfxlepakm7S05HPyBVEg==',1,1,'',1,1),(151,'2021-02-10 18:26:42','2021-02-10','0000151',1,2,1,'1612999564727151040','',1,'AAURAZO',NULL,NULL,2,'B001-0000134',0,18,'2021-02-10',1,0,0,1,'PP1pc75CV63YjccdgeEiN17zrH4=',1,'DhyHuxrOVpi8UbPchcYnZpcx+mp1Py5mM3PnXsywiaSnXYOgxJzWylH/Exbpco4y5PnnJWBd3TP9TYttimgbefLOndav6b6fIFtoLbnWVT4ecqA8zLOfKOZWryCkWm/t2XTQAzO139NTgV/kbQ/D2oD4QmuO9oYRj+0as9dtczlRSpEWgnWLQXdVHChZeEifWAKaDWMwRFmOcLStrT5WIVpKEsE3NrFhDbXrByaVDSq+05YSkCtylzqMgC7kAa6oT2K6c6Cnj4GJo283fKyfI/n15BsAP1Pil78RVW0uXiawF7CUp1gkxT/X7poaEBxCA/tbxEMEK6L5fruWytNlmw==',1,1,'',1,1),(152,'2021-02-10 18:27:09','2021-02-10','0000152',1,2,1,'16129996051135479612','',1,'AAURAZO',NULL,NULL,2,'B001-0000135',0,18,'2021-02-10',1,0,0,1,'RitApO7Aa23F3j0ME6vHujg5teY=',1,'eFhfPJoXfpnF10HMMEvz4RFg0K3HQ4lWFzGZpfRtmxV0P7myObWVaWu8GloontWSibDSrThw0o4z/EIg1LBjDNrILzlkfEiNu7l/dPFzqjv8tJe38YntYCiDfzXtjMERLuWH5WdoyBXi8IiuhX80YNSoSgyk1QO7wrkEIMJfeDgVEhkGdf3u/2SHwUE3OEa7mKCXz+xFbPzbN2UIYmEIkHMFkwynLSgeKk/1AW544QndVdSptdpPq2TwAzuZwdfqZE9kaSygni47mD+QKH5yGgnm/jYiAPJ46o8mwAAdm6r+54KZRd0RodizBouLtY3nSjEhkBuERHCXPY08zJZqzQ==',1,1,'',1,1),(153,'2021-02-10 18:28:21','2021-02-10','0000153',1,2,1,'16129996561369357342','',1,'AAURAZO',NULL,NULL,2,'B001-0000136',0,18,'2021-02-10',1,0,0,1,'6mWnZi1iwR7xG+XvYy/kYDTxmaw=',1,'cmidpEkL7r7hN3hV6bMmufDjosdW7kpYgRzNvw93abajCpGIXGOFi6O9IYuyABo6a1H5Ne8NPvW54aLgLsx36hPNFM8M1gKPMtLbLjuiSemNP5+WBYs7Ttg5g+37EaZjehxu3f2G4SQuXPsPcmIr/VnV547ERKdf8sKyfQlO3zLkIdAre2NvTFbjxVJt5ZQKuBZvvG9R+uB/dApEngdyQPzibLFWIGK4k0ZBLZce9YzhBWB+PIKIG52MN5pp43pFKHHHU9ty8FCkB5iC36mzom/OSnaEW3bdVC6LgkqWMTUNBQVcLLZWWUmfgriUvSkBy2AIqXBdpLsk1hIwspTcJQ==',1,1,'',1,1),(154,'2021-02-10 18:29:36','2021-02-10','0000154',1,2,1,'1612999705914554447','',1,'AAURAZO',NULL,NULL,2,'B001-0000137',0,18,'2021-02-10',1,0,0,1,'BddVSX3W+N36h6pO3Ajs8dJPF3w=',1,'cTd71hPIInJUcSIMQlKT3Jd7Qu/s2oqoyNzWxkFqcoGHP3t3ABRtHz1xy6GWHF61yHqnKMBf8xKAe3JXjg1vpfzvH1HPB9RFwmu6foGYIUVYScOUyQXbtrBz/EGfhAxpZXv01A1UcdzeNWogdmLl0vF9MiCU+86pMwJ+r9wr1prBl/SwuGOUXl1Ogn/ID//xkUEe+9+cdVhto3fphao0jOX1J2kbLWvBzWzTkY6n4gg/rLyX04P0XaXHg4a5d/oDUYDUoYuTJ2tqL+8R3FeGHbtb30ufjFq3oCxCJAeD2+XsHYNzEHWpv6a68xEotLdacxA+i7S97FQ4KiLJWvLPtQ==',1,1,'',1,1),(155,'2021-02-10 18:30:16','2021-02-10','0000155',1,2,1,'16129997801268964197','',1,'AAURAZO',NULL,NULL,2,'B001-0000138',0,18,'2021-02-10',1,0,0,1,'9Gi0NNU6uTFpP3VFMLPIMXnbx7A=',1,'QE1LYw4wloYYSR52OdmXxx4b5uJ7aG3Whp3sUfcJtfq49D6g25itY7j+YlIKdZ+YhtlyxCXYypcGgNOmNiy9tDR+qHFlJGgGW6qJyQ8dkka4PQ82Js9scaUfmqXZSwH9OpCKf3EKJj+rjEoJhVN6KcQHgle12tQ91+KzZV4YMfqSLX+GlJahmYx2+40/58m5ZC67P4x3g087xiIbUDOHBA32ZXt6RG4ym8WYOSwVORZTPvDpLvEE163NpBz61Jl04LhzImiUA00we11cLpCEapD88JB9srGH3xIz24KJEEGxveqfC2Zbk2ClZ/sUuz35Smd5bIERRqz7TyS2iIVNGg==',1,1,'',1,1),(156,'2021-02-10 18:30:53','2021-02-10','0000156',1,2,1,'1612999819783780864','',1,'AAURAZO',NULL,NULL,2,'B001-0000139',0,18,'2021-02-10',1,0,0,1,'tPKn6MCGehwZqdWgKHtDRSNcTh8=',1,'Zvu8hlSXN4dJIUhglE8wu2Dl3hy+1J6JRVNzMmpCNCqgqA7WQG4+2RbZa2894b1c4w3beBikLOOiCUcmtsPiAcpdlo4gPUpAtjrjXfrIRPsw+/Grxw8kLQMzqgkAG75+NXeyVSjwy3+D7F1/oNQ+iTcGUlXpSKngMGqBPTd/ztqyQCVJ2JUf1CbxjyKGkCkYnwCG+gg/QhFXPw2nQ9+3l6lJVQFzcvcWBUESgSbTHjkfs0CHGVonsofKnJiCTR/TFlYdZ+BXC97u7nHDAMPA9tkXRHlwDUHyO6GtihGiWIlWVo7j08ugKmhugrMgr31Ncttu5ibIBOzXw1TNTXf0GA==',1,1,'',1,1),(157,'2021-02-10 18:31:24','2021-02-10','0000157',1,2,1,'1612999862237019051','',1,'AAURAZO',NULL,NULL,2,'B001-0000140',0,18,'2021-02-10',1,0,0,1,'M9vp6q8RVmTglxfgKt2oNvIsBPw=',1,'a3UM/M+fKo8xyIL2QfBXTzufl3bckd66z76H81bY/d6GGoEO4K6W0wp42wFnb8IKbOh9IfvT5+WvtZsxmQSPgoAC7hOwM6PFK+4G6LaGO1SyRqbWuHSX8cyGMhpRCtkLTLQTw9lthW9amK+TNghe679M4pGMER80gRKmh0G5ABGKbBGWJWKs1sPpmYzcJXKsjGpXFxpZdLeCCMjvb4khU9hF/4yO8wZwUBPkQJffx+Rzj6fJnOLdfdYX3CD/pVotqhrn/RCL98Ybe1og+AQG1ghbp7z69DHJW39ZEaDOzr7O/T72JGCkB2wLoYBRCvhbVP/U/UwmPkLf+whKSyr/Iw==',1,1,'',1,1),(158,'2021-02-20 16:21:27','2021-02-20','0000158',1,2,1,'1613856024569697752','',1,'AAURAZO',NULL,NULL,2,'B001-0000141',0,18,'2021-02-20',1,0,0,1,'RdDN2VUVB2GNyRQUoG0ZZdfJkuc=',1,'Nt+h+so7ot8JBgscoJXdqNPtfo4kTzdT9zHs84+k/vm/7bxnwoYQfTwuBOYT5BwUuSj685mrq74d\nhdMSn6X8m35h9BJyxM4HcN5WOeSj74okMqVE3G5SsqI3T0F9NpIfFtcmj4Yx6D7VoYg1sghCSv5s\n/TuY+y8BIW8k5o0Ebji16Rrs8/VBK039edfcmJPw6EXMlnV2HvPhCITpfrv/nh0U9rvDtdD3P9Ax\n9tJfPW2aWfQt6/78kAz3g92aE2H5Una/P2b31ry6jKYxh6ImHsmy+YDKlZ3bZa6k30R5//7t1q4z\nJ9HKlfOLmBioW/sM8dAXvGFLu9oEmjjJ/zBzIA==',1,1,'',1,1),(159,'2021-02-20 16:21:58','2021-02-20','0000159',1,2,1,'16138560901258679601','',1,'AAURAZO',NULL,NULL,2,'B001-0000142',0,18,'2021-02-20',1,0,0,1,'xErnt6bd0Yq93ae6yr155Scp85o=',1,'SIIpF4ZCZNiS4r/0N3ILkJvJP6XVkn8xAShebnZJFBdp89/LhBrXhu21P1NMukfGL9Icja6c/QiV6p2vkWa3d38rHSLsUDDI9BeoaYZw6qH4SfMiGQ/COiCy5EH8FiXMOe7rF24jU6kv1qvPdJ0/0hTYIxiHoDiPqrj3Rd2rGzrBYOMW26w2w87S55okJFM8nYZUMAhXxnsj6eKy8YeENclv3OeNVrj+FUry4skMZxNKJylNM5j0UZceRodqHDVnNp/4gw0m8py/GZABUBgsKPWXOj0StcYe1CAe+lTrAxYUXE+mD1ZRG8JHBgx9Kgk00YHq8y11AxoE9ERmmf1XJw==',1,1,'',1,1),(160,'2021-02-20 16:22:16','2021-02-20','0000160',1,2,1,'16138561211151573498','',1,'AAURAZO',NULL,NULL,2,'B001-0000143',0,18,'2021-02-20',1,0,0,1,'zCQTuCwm3G+/7pH8LsQ6txu8RXI=',1,'caGGta1d/AVvI8UYoc7Qn5mn+8ofHYYxLgWr6uyunF2bUfHSLu535THbmkne/rMh01+4onl/tzEH/K1CroSzZKhJCCPb3z2vSXpjpTlVQWkcNJ+9UFgkpvNboJh26+VNqQH4bWVixJC9xAoJsycJvzi1As3mgTVljH9O4azupwCdZdYLnTJVKi1NLxXu1NFtjH2BPcbbiqM5oD1T4N83+aVU4PIu3rcmoOzl1pWW0qoGnMT//d2u5iD4KhWWjMqiDBDxSvpA/rfjYelRmZ3DSt9MgjKIUlnnfaLANdGqhZRkSwiW/r+r/3jAaodFjvCkK0LG65X73hYzZMj88FeC8Q==',1,1,'',1,1),(161,'2021-02-20 16:22:44','2021-02-20','0000161',1,2,1,'1613856139311291906','',1,'AAURAZO',NULL,NULL,2,'B001-0000144',0,18,'2021-02-20',1,0,0,1,'tUg8apXH/U0CgfBL4ScTcXQEyuo=',1,'Sc3wHnHU9ir6U2fpI/MIyWrr5KiapZYv8wS3nBkvGYmJflZ7BGu/dhuTWILv4m4N9VLUroHURo58x0oOQDL+ysPNQQP2maZ/fW4romrxlO19D4evJViIYvx90mkd+2Ep1Hhm0ffAMYGX1yzFbwbCaQsMFfEY8DPZTttdXoGypFZjMZyQtH1RoyH8/75CgvYWy5FgYNrxB0bSf26VNEiEx4H2wfj88ns4/wNMic3EmLaxMjB1PCFBBIUkBRs7xu71Ld1G6u/cykeoa3FPsp4Q6MIRPw4b79Gq7enzVR/sTtXdlScxDcfU4iv9LmgEGvZ36SIM6ETQE8yagx/0Gt8MBw==',1,1,'',1,1),(162,'2021-02-20 16:23:12','2021-02-20','0000162',1,2,1,'161385616747033737','',1,'AAURAZO',NULL,NULL,2,'B001-0000145',0,18,'2021-02-20',1,0,0,1,'4zYiVNdoSnksKvAKAvV70EsJTJg=',1,'DISiLJFDbDEi0z22pgo/vWTkv78F++oyv6fOeUZLwIiH3veteN6wcwFRCsxO21nqUb/phTRuZ2MY/6KnrNea5dxEd2jCBwzF4jQ/dgLiNidPviEtxqyFxfSBSkWH+U5pK43nnl4n/mQGvBMUivnJA2vDEYcLeOuxXkTJdStQxOd3xLMNIC3oRmOEOUhvw1jcjE0HnDe37Ge1SGeORHuHMKkIReTTfG4F2GnFbNsiCazGbO/yOBP5X5hElRFvrcf5tiecz9OJpPrrsOV3KeyGCG5+s5gnDoLZ+J6re/EYRYDcSRTc9WxvIo8SfcC+wVR2AeSElMCQDdt3ViDugLU/4Q==',1,1,'',1,1),(163,'2021-02-20 16:24:05','2021-02-20','0000163',1,2,1,'1613856196928927062','',1,'AAURAZO',NULL,NULL,2,'B001-0000146',0,18,'2021-02-20',1,0,0,1,'d4m7dkX2m/b5l6fUJfDSdzN4awY=',1,'PxuJezsfkhbroU97+b0Ct/GbnRChSAzc+iGNPR16u/tCcbWIQsvVYgui/ZC2akiVNiXitXOaTvG5jPEgGb9r5b/w3XBymsC9B3BaY7C1hZZOH7Aw316X6E/Gk9KrF7w/QdUGdouZUsHCn251U4IjfEdLrpv6hB/+kt4QyoyLjfIV3KhopwJS4Ca6JsNJkrZUtt0p1ocxJPUlsI7DOmxUkYjN940uq4sNbhOvmCSeQMgdqb13s3mN46oRh2TI77kwd2epzyoiU+ef8Ec4Y1ZQ+hv93uN0V4Qy3nT7QnHQo7iVARjKUjhjcG+DS9lNJY/RuB6mpoD3pN67aJDKiz8ScA==',1,1,'',1,1),(164,'2021-02-20 16:24:42','2021-02-20','0000164',1,2,1,'1613856248645046401','',1,'AAURAZO',NULL,NULL,2,'B001-0000147',0,18,'2021-02-20',1,0,0,1,'CGRKd4EXOc46ITh4VWPHpzai8rY=',1,'EPOkiXMsirfH3ecBcKA6kT1Lqid3RScENUrcLuvdNN7Oh3HpUbhSb+/9DVNG/SY7BfRWekbCDmb8f+gmWrqk5rU4UMcE/Pr+Nl2XrpKwYTkwCJjtiKmTFX9rpkgoxLt3MzObU2BrUqQiRM5jI6F/yxdDJBd+MmSEfAPywCT5alY3NyhQWYYcFssgpZCg00oAazh298CyQfJC68gWdHCg80jZjgLbEphWSPwBKaybNRk+4ffD8ofV63EMsQYJ5vYSfvN7UV1WKHqzGGmzkcU+CnxaqP9/3m15FeCBY2OkjWv6OqFBWjDzEXAJOgv0+4ha/oNPSyUdllvWy2vGqdqsng==',1,1,'',1,1),(165,'2021-02-20 16:25:32','2021-02-20','0000165',1,2,1,'161385628537437650','',1,'AAURAZO',NULL,NULL,2,'B001-0000148',0,18,'2021-02-20',1,0,0,1,'WVyl69o5PQ87ZjyraY1+21XQYdQ=',1,'SH4iL+2BtSft8Kk2eQYf6sdrK+4BLDrz43omCD6E81MGdBChZXkkOCvLUxCnMCDQF1w7kH9dZM7kWESVUDMwxYjT7OIcWRfqDDk+aA34hdTDhngVoEXAGSOPVnZ2SCLN8hpgnP01CxZq8zPsxd+txF+sIxEzaw4O5dhuBAXa8bK8GjVjZcpNkeMt1sBDYLpYCSkezKdrZqdLUi2xXpwuo2uJVFuAUY10PBGccCHnwuWib7Ay61EglBfDBz0JSgCM1iO69q44OKXeBaSe7vrrw/kY+pQOk2+WgvkkItT61c8NH07mBMAd2jEMeeJKcA2caK8oIu1dEQQULH6vIk8WQA==',1,1,'',1,1),(166,'2021-02-20 16:26:09','2021-02-20','0000166',1,2,1,'1613856339602057652','',1,'AAURAZO',NULL,NULL,2,'B001-0000149',0,18,'2021-02-20',1,0,0,1,'7bvl/7iR/91jhY80cB1svlw/T9U=',1,'XDm4f4jHpX9r+dkgJ8XGjvZDKZslye4YV8uAehkEG164XwUY3a30JrSGgM9bMGVIba4fSI7a0s+KMoriF2mUlsIDK+WW3LOBK9FTtNPLhWXdPvzIzapbmrHE9L04+vETkko8+502yxONVXEMje4wlwWM5cE7MBWxkVJb7bV/s1PkK9oxnAAiurk5FW61o8dI+M9j1z0jUwd9XiFZyW1GnGLUM/YrX7wBAmQxeLfbttog5e2AeSnztMMHTiT/ZzMc31HHbXvjSWZFP2tKkMfmYAZTnaPwUSURvYXOo0hCebiWGro6AAucq3FPgSNi283rNUAI18RK8uIG0eDmnk5HFQ==',1,1,'',1,1),(167,'2021-02-20 16:26:48','2021-02-20','0000167',1,2,1,'16138563721352704043','',1,'AAURAZO',NULL,NULL,2,'B001-0000150',0,18,'2021-02-20',1,0,0,1,'XQtpNiOnaULtWcUnePKtcIg7acQ=',1,'brc816TzIOa5doQxPEWHFAjWkSQMK3hi2fYMauDg8A/oXLMCZZO4IxI89yhegqUNNfgRoi+Jl8sZpaE7mR2FWgK8zdhVORU3SodeVpL9+3qIukO2QerTkZwfWvs9Ib3G/JTA/ofA8UeDi0siYUaYSBa4yvGXAm52IlIrPF+THpE7+pYel/cO5nrMC4etackrwy91O++fjDNRVocPtjn/kaR4Cf0MUqxBLX8B81ZFNB9JVF1uod0hjDQjUDMSw4eQGYh1kl3TXF9DeI6pdZmwW+pFNPfrmp79YVcLxSWTD2NGC/W41pJqSojMwTPE5NXXJdy2lYlL1sirWf9t2IQzhw==',1,1,'',1,1),(168,'2021-02-20 16:27:46','2021-02-20','0000168',1,2,1,'1613856411147599010','',1,'AAURAZO',NULL,NULL,2,'B001-0000151',0,18,'2021-02-20',1,0,0,1,'x0kXk7q9RadlM0kSOXDFJ7SPStQ=',1,'drqGeRTblZl++xHv3wMpqPRRfvf/+9SZmakFl0vIZbMjdzWbL7joiJ1FxPtygfbZe2FLV4Ho1YQs1xfe4TMaFevFrRp/Hmf4S5I3zFD3ldrtSAzA6oFltAFrRnfIEv4oUCSPGLhaKAVSRdMwjmYfolCkQPAGN+pP9cTCGYuIjucXf5jkkmi7gDBmbkou9vGVzrWAdbHRAZotC8T+OY8pAMpq0K66J1FngYSmIqp58L8hYQk+gX5SKxE2qIWluxOl8pufFyaWEZiORPl8wjXH+iEKzt8qnahBWizvYPc8ktgH4qo+qB2Dnt26gGXX1ZBJAXifzbiullf7JUVDkpiCUg==',1,1,'',1,1),(169,'2021-02-20 16:28:10','2021-02-20','0000169',1,2,1,'161385646999016129','',1,'AAURAZO',NULL,NULL,2,'B001-0000152',0,18,'2021-02-20',1,0,0,1,'0t89bv0cVtUwE+DeZybRC+L/TT4=',1,'T7nLHEqex9jqmnhv9j9P5wgSikA+p9FTcg5flnDvncFhA+3kZwKCNM0E8Qhx8BsyjXb3gBUY+FRFCvIdMih+ejUik2AgRZAJym+XiW9SBYy6HMHciqn7nRmRp4aAtA/7srUAYkA1Fg9vwUNIKkIlAbcYkedTABhsSF+YRHkl6M0FfkDWWATO8YRPnmUnPMGA0V1ZiUckfWWyIukdEJlrrFLcnnHupfQCqjMpd/W9+WFYjwuVJ4P69nYiUXCaqChbyKbKJqGYVkeiDnwgtwTc9SeHwxk9OqQUckqXRd2bd7OKMnoUUFDQLQWYEabgO8kqmmHhoW7mwuJVdI9/OFtqmw==',1,1,'',1,1),(170,'2021-02-20 16:28:47','2021-02-20','0000170',1,2,1,'1613856493866918265','',1,'AAURAZO',NULL,NULL,2,'B001-0000153',0,18,'2021-02-20',1,0,0,1,'p8G1ZgBK7CVvto7IR+eJlHaiPg4=',1,'A8GZcEafH3qye3aIu2BSvHJI7rtpRjiYcyoAC9riHUneqyT6fj+nC/4VFVSnQP+QXS8fSxs5UV07A0rCc5M4qEPlKpiFLRTPCNhJuYaNDo7W4WP6oalFKWeZkDWk+hF6v4JHnwy+6dwMj2SwXldCnYLLCYaiq6ZIMRklCSj+SJJ0cfddksfb0E5d631ESmIWSL40iQpx0aeuS0N6BbZLZUUHLHnycDm+k2viwb0/3NMH3UqRfePZ/xVGJOI8wxaAXp87OulgNHhD1sHvVVNATAXqMcmc0rDUIj7sjBj4bV8F4RuSo0CrGzgu7z/M7Qk/ELhJu9WrDR6NMXTwe6j7hw==',1,1,'',1,1),(171,'2021-02-20 16:29:12','2021-02-20','0000171',1,2,1,'161385653041009288','',1,'AAURAZO',NULL,NULL,2,'B001-0000154',0,18,'2021-02-20',1,0,0,1,'J3uxksGnl5dWcY+ZN26X1Trppb8=',1,'ZPS2qJIIWsuJRXSStVWovzHjURSkF+CxrzzNGZxuRPmHHLc7w4dYlWkegK92A1pdF+rQDchmV3SFOy9ndT/pVrelgACBW1cs+zqnXxu+HS+kjQ4CWenWkhbQ1wwu++HNB65683D8Xzc8Tb4VHrT9nidhbv9XD3k3DcBoWZVOyBCkLAU0xDBMQ18DFlz0gsF29Q4UlWbOHWrx5OJBDe/meVacQBCr36WLCctZHGu1bWCP9RZapRVVrCh0pmG03gX7HIc1MR2OHlyA/kRkzAH4y5X2K5ja/xN3P72tG7b55mr1mLTjtCUuj9Qb6tszDz/jSr2Tl1EGwnaHO3KZXdJ2FA==',1,1,'',1,1),(172,'2021-02-20 16:30:13','2021-02-20','0000172',1,2,1,'16138565551233204787','',1,'AAURAZO',NULL,NULL,2,'B001-0000155',0,18,'2021-02-20',1,0,0,1,'5GX1uWej05s9h0IaOdvxPHkS/j4=',1,'MVkYFhEnK5x2Gd/MwjLmwVBFarPkh5jG6LST6J2CiNiJNJyuaExoTjkRVwM8t7WPp+2KIUDBwMwDZ3nJWSrZ3y4GhUtxxRY2vjJ0Kw/iBXh1wEjrakYW+MTwv4vNd+3QSPFiSEhGc7B1UcbEY3blX2/mAuzYTcL3fHo0z1ryZ6w8wmb8OFnqPdfe4MO59JbB+Mx/y/9kNAu/cqHdeptj0LaictbuID74aRbqd9S63RMXwFbhi+tRG8xnLE8PlOoRJfZ5wFfKilcpaEGAYEZZnZ2yzueW4aYoQQx/4Hg0DiJ6vJzxXB6sCViUXhSF1UkN3uO64FEDcpKvI7HtXWPbTg==',1,1,'',1,1),(173,'2021-02-20 16:30:52','2021-02-20','0000173',1,2,1,'161385661665795594','',1,'AAURAZO',NULL,NULL,2,'B001-0000156',0,18,'2021-02-20',1,0,0,1,'XWnvK1Il5ZlyjhHHNo/wTEBGsqg=',1,'eGzf2IV6Qb2NdwtFgmEI1YCRP+8VL/dHlbn42tJGFWzEBKJQGxYzxm7fr1Y4kf7G8Ee7SYzevptLoYan464I608Vvw+T/qeV24MKxF5WfQL27xtFG/prl/EDT4pZR4nf6qjinnEkMhKQzV+pLXvm59vwIXH7xqevKL8pDi3nXphUjGxHFvMhRuMCiGDbH1WrkVZ/BcO3PKXNMwGsnKs7/jfecFsXATTvE8nfoCJ+zCRv+ScxcGGHYaQrhWm1p9+fcJCQ/PWOs3rRMoYh7FbREGcCLvWWmLLnwbA+acc5WGkUCBi5HwvZNihdHS1Enx913Ms9bKupk7fshK4DghbMKQ==',1,1,'',1,1),(174,'2021-02-20 16:32:01','2021-02-20','0000174',1,2,1,'1613856654414998499','',1,'AAURAZO',NULL,NULL,2,'B001-0000157',0,18,'2021-02-20',1,0,0,1,'XR0q+S+aY5qvhscxxGStpljSxuk=',1,'N7n9CFGTqGQ/3aPu52n2clrX3ADY2+br+YPvHCRLMeMNy0pL8hRVhJg5Kw5ckj/JyYRgCVkLLlwHGAQluA5t1s13Piq9FVcdcPm+8sd/3WH8LNb9Pp2+/VfpjHbzXlL9PPida+JNLc9dM5nI2dIDkDGJoLw0QxHzxf1oTGtkG332vSdMK3wBCs1YN9MhaF02r7Ym8cRFRTzIVGavv4uAHXYr2TKNN7pQd3+68Bsv4aaOOdihW03HTMEHPFrxpf2QhVLvDwl+M/W8Rjdm084fyYCg8XvIcNRuypaybStFXmnQgKgT0SIaoDDzjUef9uJW+AIjq+SCNHSeNSLwn0to6A==',1,1,'',1,1),(175,'2021-02-20 16:32:35','2021-02-20','0000175',1,2,1,'1613856731278071371','',1,'AAURAZO',NULL,NULL,2,'B001-0000158',0,18,'2021-02-20',1,0,0,1,'ucfliTgntQpYFcYSPaufpbocFJw=',1,'OdW7g3O9e579X0j9wNYA3UN9hW7DS+vrbGjWvrNQ4vbYikWGFkSw4RJwFf9tBe/UyCqoarhyNil6vIKRtv/FVayDY3g97HxiOWsFAMFmHXG8wL6nb0+p+PcufviOxNYt0sSSQJfwMTHI6Uk+KrDWKFyrp4Zve23jRrq3QpxN33gquGPnEfUufy3L1tvjuMeglG+1bftjxTb7giqo9lv0cmvc0c5dORGZD6ia0OhR3wnRmYJCCNp0ieispmNMWuNHHs9JVF/A9xUvq9Mspt1AIrgtuCYABy/DicFGssBk1lGJajOcnl0iJ8A0FaX4Z9g9Iym5LVxjecRv3anxSB1c/w==',1,1,'',1,1),(176,'2021-02-20 16:33:04','2021-02-20','0000176',1,2,1,'16138567581244177891','',1,'AAURAZO',NULL,NULL,2,'B001-0000159',0,18,'2021-02-20',1,0,0,1,'/GhUYBZ0Y8FcNJHQVJuxh7xK7e8=',1,'UzK2qvWgQ6fX+CzGbLQBkIE3PEJRHQJamq3QkT1SAQs9sayE8dSMjomzN7ytdSzOX2VOnzCmWwvZ0Cw0fMG1vai6bz3HbGvRxjr7XL111z3PbXAI0Q1tM9dFt+CiPETHh7+NV32HKzvblIIzNDiuRJnSU7LzkjQZYJrQyGXKXmTUkD4oClMULNLE6R/IP++e2rkZuAs9K0FrTjtrT04IdMi5706A1JwvvXFw1oz7Jmv0+uloM22nhLOwo9eumb86xdo3GCYMsA93iiSQj0VxXhG7T5MmXji8j3ZAxpqQE4IDY7iPlJbySGY4Y+00v+tNo8xwpBKHnk4r3eP32d+BSA==',1,1,'',1,1),(177,'2021-02-20 16:33:31','2021-02-20','0000177',1,2,1,'16138567871390959297','',1,'AAURAZO',NULL,NULL,2,'B001-0000160',0,18,'2021-02-20',1,0,0,1,'2ATaaA19qyZa7GdrW1mUswuacHM=',1,'WgVaK/pigvdUj4/EforUU4LJaZQVHKfheRvMQb0+oE7t9rd2L3XBz8B2Et/WR9M2gliqemhrs69sn0yHuhd1M+ZPhPm1lYSHWhcC8Mgrs7xbahsyxi8CISW3TJxRVLri4XkueWX2TGeg2Qjx29cSIT/tQcIOYHkxgNclADGOgMn2gdfmWQEAdRQ9adbi3w9KhtPtBUqaJ3vCBbuenqs18Kepx/PwhA2yDvSFKihMpUOduWOOZ1yH2y6EBQkt/uIeqllTZX0783e/u5uYuidN1y2nZqp17cEC1uqqhOLegdBuao4qJmYuOQ7mWV0t5JxrJXv3ATFccICmyjubaOWajw==',1,1,'',1,1),(178,'2021-02-20 16:34:23','2021-02-20','0000178',1,2,1,'16138568141034957371','',1,'AAURAZO',NULL,NULL,2,'B001-0000161',0,18,'2021-02-20',1,0,0,1,'Cfr6q2MlIA+s8unZbHI4AMhnHKg=',1,'g3h1OSpntjbwaNRxHegffEPWjJV5tQ2wGjLID2RB+lr4bqSVkyPfWLHJFk5m3a2s2q2STW9MvsFio/Liz6ajko9/QewpWiYC3oDcO+/xbYYlSJ1wbSkGqLtKbuRmOtPBelE3/iwdhxW/vgq6pgPD+kKab7/ItvZlIIFurEXFRdM5e7N0ui6Ok541xUgUA8HGi9q6SlxMmpEDCaA+MkBLvhrOzl8k9wQwgEZOeIxINBN1RiH/IoTUwnkbMdUd+ZSGKhrlH91qRJC+fJ1sW8XbQt441lkaV9RCetdUULdKmAaJULs90sthzKezg3yp2XueGfQjUNuDJkE0GlJDGmIREg==',1,1,'',1,1),(179,'2021-02-20 16:34:55','2021-02-20','0000179',1,2,1,'1613856866867520710','',1,'AAURAZO',NULL,NULL,2,'B001-0000162',0,18,'2021-02-20',1,0,0,1,'G3bqr+iv4L6vd9gOz42fTO09PuA=',1,'KKa79KPsCKlrn9eRDEB4Ul94VQf1iIoE18ZzAQjaudCYD6yvDT94miWcpUDbBiUI6d7Y0AAqThrPdxZzJPQMCc/61BpweoXvMexWzP95T1DCYmIv7KWdrIqAH2TRO268v+aamdgOI+3uB9tnO3jZg4DRYqn5f62xs/uHbKC6KdZ0KILoL2wLmUQ8tGkerfdFIGVKtmcjKXEARlQOHPSqDv4GQnIljOqVUR10HRqCq4xZJafKJPFFznfKvScSGloy2rFWO14DQL5AhGvNpuwb0G5jit3SjBStHc7236iTRaEi2RjeOd0VhUmj9lDq2lzJWmzXLtoUTQ74AGje7gL82g==',1,1,'',1,1),(180,'2021-02-20 16:36:31','2021-02-20','0000180',1,2,1,'16138569631127045382','',1,'AAURAZO',NULL,NULL,2,'B001-0000163',0,18,'2021-02-20',1,0,0,1,'zJN763/GHP9qg0SGhdcc7MPCWU8=',1,'BDde2B6N6YufMWkTIDT6mwNuqrATAh77DFx3YICXU5JfwybAxr0v9Q+nluDKGD4p69qq82y7hbpJVsL+xdvH7rI5V2t0YJ65eLiUKKMhjdz6M9PpyLTbMooA4WnOm6/Y0+5L3kxr1L8JuK+S4VAt7F2WW6wP0Pk5B91CxffK2dGtywBQFcHqK3cj0jg7xyAfXd9ZbtOUmVWAU9kMIllJSi2auzLHY18EVjhODrwq+kp3qXgLb3WJBxdFwAyAwnQ3wgFpwVexvVvhcij4LS722p2JWEeqWOXoHvnndnZbfYS0smzqMzYaMTCkk5JFF/jeXPof4zWokyr3qZTvLi8z9A==',1,1,'',1,1),(181,'2021-02-20 16:37:15','2021-02-20','0000181',1,2,1,'1613856994492756927','',1,'AAURAZO',NULL,NULL,2,'B001-0000164',0,18,'2021-02-20',1,0,0,1,'aKJtd1fOf086tcX01So6mGj1vl0=',1,'Eo3Mw38yxg2VuNYfenT3gLOmRnuDdumjYf9qdCTLmo1nPEzNCyKB1mmf4MwMJ/aU6dZnL8BccpRNTs0W2WY0nPwDgOogMbnefXMetFEdiY6GI7gFgky7nukYoddkWWyVqiZ/OmRoe4Uh/CvuGsdYNeXN1zCxtvr8YsQL2UvAW2RFjEaA6e2e9twR788097SAYYJBRX9NCMr6q0RbsqvDrR/2sgCpIZPoW4aDfNrZpBNDkP7a8wsNM6W+ksUpIzB0t18/qfzc7jG6WkjyBSfAehLK0dzTZ7M/31SH5gCqhYbIsX5HHTnZxgEGXzAP4+cczlC/ylvGalpzQJp5c1z28Q==',1,1,'',1,1),(182,'2021-02-20 16:39:11','2021-02-20','0000182',1,2,1,'1613857039901774008','',1,'AAURAZO',NULL,NULL,2,'B001-0000165',0,18,'2021-02-20',1,0,0,1,'crq9oEcbxzbgxlCtwaXEEw5EZe8=',1,'eY09VHPDXLFL9MMPaiQMu4BlkjKnY3dtT4zBDVnZ5kMBF0skiQxzgBNTOaMtzUiqYNbxeuspWzuC7O+YGf0ympOOTHaO2peQVusmlLcYoMqs1dpYOksgtigu7hRJ0wsFztp23XLuePGBVuysJNDmGaqnQfrJBFIyZ4aJ5mK8TZncK8zpg/qwp51vQhGPIhQvZYKulrye5VXtevnJLIwzKZMegji24d0/DpJEuNLSAax3iqSzcORZNenzJLin0CoYM6TOvvMqqL1eVVw9UYegJv+2GxKPxmdYjXMG/vslAYfPcx0SBDo5DsRwxRui+xDZAPdAmuQ8imT2Xws+KlrBgw==',1,1,'',1,1),(183,'2021-02-22 17:24:12','2021-02-22','0000183',1,2,1,'1614032568171438617','',1,'AAURAZO',NULL,NULL,2,'B001-0000166',0,18,'2021-02-22',1,0,0,1,'hkJJjK5rF4W+GMZw3ExuXfSPHcc=',1,'OndYaIJK7xwBVDsezzCInQEcKOEAeWvQgvLVtmNVhSdZxH7rmp3zTpjH7dpeIP3QEPOqOyzfAMQb\nRA+1NbqWEB4Hwu1pVGYyfqHInQseRa+sBljVx40Km6LTuq+XPC/TyiowZrZlguZfqh4qjrZrC2Zk\neQsEmjhUv8atuvslKcLvHHpAoLswMCuCD7aGw/nf2yRBQqDv6ui3O4Kes8PVSLtTkhAFtFTO/ZW7\nhO241gE5wj4SUKL2KYnrJbVrIVTcB1xGJTPSwJfJf5GNnj/4xZeAZeKHEXU1LPoYtpgO4wQeQiQN\nMwefxnYrYb34Y2tycnnigR5q8wY8/7vWum5kxg==',1,1,'',1,1),(184,'2021-02-22 17:25:03','2021-02-22','0000184',1,2,1,'161403265584858673','',1,'AAURAZO',NULL,NULL,2,'B001-0000167',0,18,'2021-02-22',1,0,0,1,'SMeU8w2heHkA1bXvnS1LgACoVY4=',1,'iuUsaULLfDqCDs3RF/zos8R++V+eWCpOxx3knX/VJV+Gfm5vXG31HMZMxm8HArCXELOCvdwSyCyN\nUsqRdTUXo+vklNRLfVrER4fWmslpQEJHrVCIK/lTTlDGnJ4konUiH4nCB1Qt0dj1P3+4+qdLyu84\neYdPgd6zawCQcqn4BnEJu+3HSRgsEEgxHQ7WiNiVIEMaCad9eMlho5Z802XDn3b7EOfRSRl1yPIT\neSqPJeKpIrcbJo88diQNn5+vBSlJhbBVDAcP030o0Mx6xDuGsYRaOO6EbweB1zUtmBA5h2YPj1ta\nDMFkTx9fbNHRMfaclpwEf86/ughoppcgbJJB0Q==',1,1,'',1,1),(185,'2021-02-22 17:25:22','2021-02-22','0000185',1,2,1,'1614032706816700176','',1,'AAURAZO',NULL,NULL,2,'B001-0000168',0,18,'2021-02-22',1,0,0,1,'84nMkqI697fNxjCdGM38gNh/sME=',1,'ReNqr7uMRvZ32bcotXssMzMDI/sIxy5N/cmjuQs/VFNaC/atsv7MqZJX4fjj2N/z8Rbjb3oL0JFPHormuP+EGe/CC1TUxo2M/HLu3apzHeqSPniMvCfAUcO5UrOygkBFnsWFXbbLi9DUUuKkypHFYRiPqlBM8n8XHlYc/tmPcIjLjjlyOkGGxj4uzwHhEC8CHy96/Yi8nUt6UtFiMK3lFL1KFSoBGFb+h9yYM1PFei7IHAyFkv1hRjNFLmpPCuNa6th7noKMhYOqqCEJG/hE9dwvDU70KwWWWaTrfCmWKQxpykYfDxxWgmk6YSo5WZs7bBbmJAh8ZfRk9JJr8g7XDg==',1,1,'',1,1),(186,'2021-02-22 17:25:57','2021-02-22','0000186',1,2,1,'161403272550476280','',1,'AAURAZO',NULL,NULL,2,'B001-0000169',0,18,'2021-02-22',1,0,0,1,'B1b5YSfQ3o/+rQkIvpHYm0Stt/0=',1,'V7ceMG1ANM31pW7sswGB8Ippbqz91ZaAHkvyQasA92HRcEuPqySKyjvNEnokyj5lf6f3k0Se0oJbYumNPY0dt2ARS/bSmo13julHMHsPxETBX2XA4uElXWRk8gO2Ufein+F4QW7JoQRRy+TOaJ4fXJgD+hNy87XXH38rrWPECYenxeTnB+vNwa7cr0BjcFvZrh+Tcmt+joQte9/M7qyXv9XTf4qrhhK8DaZ9vc6byDdJvMuefu1EcSHfSW5dUZD69vBwJhdoAogVNjWi5zZ7Ek8B7eWrmQJVRU12I6idYf2mKCbRIR1G5ub+x4PKq1Ug7rUzm7DDwi+7g79oCnS0Bg==',1,1,'',1,1),(187,'2021-02-22 17:31:00','2021-02-22','0000187',1,2,1,'1614032760777928541','',1,'AAURAZO',NULL,NULL,2,'B001-0000170',0,18,'2021-02-22',1,0,0,1,'Dru6lIQ9Vw1TgyJ1P00BqmKhOOQ=',1,'CSyeXVht5WA6buKlusWUJ3bk5BfRjGzyRPRg++PoXIqnyIq6U+s8QMs4NlYInSBhSH38TwaIww3l9936C+RUcNPY4gRgjhIvQc1Qg0sgA8SsQ1oVHS39y0OlErgU7cpq26OHM46d/IVfM1NhkYc96xgcYGxbu4FrEDKkZdZkXz0OmrJXSzc6p/DchsBD5XGNBcRftn5ZQAR7zxNEyMvG+lLddQyWa3hZkCkrpPL+XayxLo+3r5CjDbf0ngXFOMZ3hKn4au0rkRposSPqGnxKGUngDxHZTGb7LoSHeO8k4Y7BFFOdJEd95/vylp+GQ8brfUCckwXhbj54wegwmk3Oqg==',1,1,'',1,1),(188,'2021-02-22 17:32:12','2021-02-22','0000188',1,2,1,'1614033066325879680','',1,'AAURAZO',NULL,NULL,2,'B001-0000171',0,18,'2021-02-22',1,0,0,1,'gduY9jO34y5HjDNv7aIuNLdTJDg=',1,'TEbJFWkvV3oPfmx4Rv4/M0O8ReoNf+orLkO9PuOoBkuBAxZJPA6ReF9bsvLCs535O6lJarCZHQPN5UVqJZu7WTodYQ8X1aojgeNJ08HCRJaPZXTKHI+PeIev2oNtr5QF0uUmdwkd20rJ0HqYsrwHLT2Covil8hatt1padO3TK/hufsomO0rusv/G6O0/U6VCZympyQV7VUhfUMKHPMJ9rpMcSyaH8vjQ5NkAMaDsrScTr53iVXOPdqzR6fCTiWhbMqrC58gZOlubs5r3SKngFqsYBdDB+6T0dS0aKx6l5QQLDNzBB0z0fDCBrr/59aVwmjvHg8E5N4yq23JFLEmvKw==',1,1,'',1,1),(189,'2021-02-22 17:33:18','2021-02-22','0000189',1,2,1,'1614033136894716796','',1,'AAURAZO',NULL,NULL,2,'B001-0000172',0,18,'2021-02-22',1,0,0,1,'cEkkYKkYDSlyknQupQGyHoH8waw=',1,'Uobua7Mb7mO8W5PTApQSfdzXg3nwwCwXoS6P4QZkG/1qEkT/NWSbwZyX6qJDU3aYLow1di78SUgZUbhncYGzmpusrLq/QGONozvr4LojvHBagdg3sCVkhh/dAKn78o6AAF5q+hjg7vP42FP5dMH9ZnE1aQ5lAErqIFHifcHdKLetxju07RtcFXzy/1bzMHEB55yUPggce19uX0RhZbwxfYNpRGvW1mGi8BpdndYy3IvjQA5Sqdy9twDkXYWWe/nPVsksScv+R9WSFR34kr5WnYcsEwNucUSQVRt8/PWEGTEi98HL7ntN/rzeTU+Jml5ulnlZgVYFP+9FIwnsvJHoMg==',1,1,'',1,1),(190,'2021-02-22 17:34:14','2021-02-22','0000190',1,2,1,'1614033200514057659','',1,'AAURAZO',NULL,NULL,2,'B001-0000173',0,18,'2021-02-22',1,0,0,1,'Hz735GHDmFohoueutE8zvM27hxk=',1,'WRb/BLLKyUbEe/B2/5/iyGbYDUgt+WmY5V6saQjqwS2H+eKGkaNIjVaMSpt5GkToVZDPuBau74dUrNKWc/qK3EHwQCYlWHQkp3fMz7RPkQp73RzH6st8cM8YLOiN0XLPN7vlMPRRGmZpTX+sxKwEvgXaZKrQmmkoIiiPyiaqvQbW5QFZ72GMKpk6Pp0/4psgqpgxZrvQw5mP6TdkzbRSSfrC0MN8CE9iQqvjODNLFCUC3UeZwcylUsbSV6tAWDZIvjXAWJ+xWBHoXtPQVVvIRruMzt7AOiUmZZxE5olpCTHjl2owuH3iQyQEmy6D0jSl/iMJnrp/FBBhUOrXormXVw==',1,1,'',1,1),(191,'2021-02-22 17:34:42','2021-02-22','0000191',1,2,1,'1614033257577959854','',1,'AAURAZO',NULL,NULL,2,'B001-0000174',0,18,'2021-02-22',1,0,0,1,'LrrI2xWbUGdcHAotDjJap+iQ0rA=',1,'ZU3B+Qo8FHsQ3Dxgm9ec5ZNvj63nL6hex29D7rt+rv3g2GkfJjXhQr6vkxgRNfrEMrwJti6i30dd663mdf+EaJwW2l/EiW4nkT6wCgx4Yj5BQ2eNGC4kH1E9Q4KEWSCbZUp+2YAQMH3Iqr9VMmzuycXr014Ylre+SQe4BA6DqrWJsCdo3q3U+yaCC87Vbx1GBtCJ65i4zp9bQy8bN7JFbuohXcSvazZuLTLvjfUxVtSpTmeWks+iLZMGaUapj/0s91DdR/Aer4FV/7Lyws6/ZzWjoPOrLQvaG5niAhBz9tzM+FXC0asJ11oabnzpnhe4KktJ3UtUk68CW7c4qjVQoA==',1,1,'',1,1),(192,'2021-02-22 17:35:09','2021-02-22','0000192',1,2,1,'16140332851388764676','',1,'AAURAZO',NULL,NULL,2,'B001-0000175',0,18,'2021-02-22',1,0,0,1,'GYsTObWO//lONjs3f3QfGrr5lHA=',1,'YayV+yckVQNJa9eM6JRw0zF+tcRYN6WCdCx1dG+UZC5QF86IL+Ui2xLJ7D22yF2vU/t9BbdzmJKcrsgl9+bF6vUtEggF9fKa/yw4zPpfPG1TLIY6srHp6x5vEwiJ5Q7KaFc2HnuAbzjZI4xF+AA4zREqcuTF15HCwgmnzVQ0yOe28Zk95dG9VcbIK3zCLfofBnWWn57fxozucYfZ+hJekulR8CKQ/v4KZEjU/j827dJ8qqqH9jf3PPgVWfjKbNHzjAXGzgfvln6OZO3hzVy52WkZy7dJICznb88fZwIzoBGiosP7jheXyJIf+NNN9z9iFJ/j0n+LgF2a4qroSoCvfA==',1,1,'',1,1),(193,'2021-02-22 17:35:36','2021-02-22','0000193',1,2,1,'1614033312168684583','',1,'AAURAZO',NULL,NULL,2,'B001-0000176',0,18,'2021-02-22',1,0,0,1,'o/C+3/ZyxVHvwIUxIIm+iUEFqFY=',1,'D0GEz0XYk5qm44h4zT8+QIOtm4x6W24AW665GFO6RLBQEH8as7ohLtpU7r2yEQTpQukxGitP7kkaY9enOc4/cFCbXirg+4/d7h8DrI7RCb6yAxl32EDcYjtazDHDJsPaSnO+NbPm2+zDJRM1F40mK+pKGjfoGcHWERntHkUX2rM1BjBW6etHmVEpWapO/+ABmKBSjakAJXPYpDp+k03GYCMY67KfXjdJi5I+rWH54Ouomf+4oCRudkWVW6RHGeGuplh6QLRobkNEkUL39foLRYqpzjpc5LAWbTM3aBP2jbszLfecogAIwzDQgopD6LwnLssVXOK7WnuTuk1KPwGPtw==',1,1,'',1,1),(194,'2021-02-22 17:36:04','2021-02-22','0000194',1,2,1,'1614033339654728552','',1,'AAURAZO',NULL,NULL,2,'B001-0000177',0,18,'2021-02-22',1,0,0,1,'lJEfInf2UA4d2qMuz3i5HwXNLDI=',1,'g6r0gjoLP9UWI4MY66zDNxNCQVozIHFagPRW7DtsLvSVBJruiLWSN9SJFg73kCi21WiwOWCDeu6YRltUlDw3DIGS71A0OXUFFmOckNAH3v6jVMsmgfrXOjLz/vgekTSwxtAk4Uj5q9Tsyt4SyBkIk/AlezK4Y7qS4Gu1EIec2vK4o009mhZ/eNlGBBQLWg8lt+XiWRTpJvqChIIHQADlK1AAOSr+BPn926dSWX4C2a3PieV9ebR8i7fi1FokjSHuCEYc/8Urlqv05OfLATGMTrx5veOu4gqDBEd2EfBzNo740f0tZMd38LGh5yvFGl4FqKY/l21beD1ncwdVaz5J2w==',1,1,'',1,1),(195,'2021-02-22 17:36:28','2021-02-22','0000195',1,2,1,'1614033367543663524','',1,'AAURAZO',NULL,NULL,2,'B001-0000178',0,18,'2021-02-22',1,0,0,1,'FTzWljoftBZqAf8t+dMQVWHDc0E=',1,'UJOodm2pjxBQ5eVNiPrV/2klZ6ovb5hF/n2NAuqHTAONGcgsyVtvtpCsAKbsMtr77Po9iKNJxHxjAPmZb+pbeu4UwEc9rreVqpQRFy169Tfg+kK6l+Gwc57lXrC6xYMIXjLGTWMV6MrDFWu/6IkMlap7LaYN7fqu0HpxwUbmyau5QI4BWzXNPkp4HuwEX4vsB8xyEEqiNqQMfqM4J814F4ChjujVtT3ydkkmePGJ13jCAUtyWe73yFm32A7t+Rg43lDwjvNF6jffXBa5PcmC9mL2BNtDzmEQ3bb+Mj1nSXVKr6YzCn9+Cn9Vpo8TirJckBgd6x79C8oDOgj5C+e34g==',1,1,'',1,1),(196,'2021-02-22 17:37:00','2021-02-22','0000196',1,2,1,'1614033391402131996','',1,'AAURAZO',NULL,NULL,2,'B001-0000179',0,18,'2021-02-22',1,0,0,1,'HbORNlkCJi3FvHM7+ZmJjB/QEeM=',1,'KfudflIaYh6L4VPwTIv47dGhoHdRKHOiotb1aLEPzIwwVLs+v8MuIh8TKx+NL3Iueqs3LvpLvOLx5XqOY10KZRHsAXVATKvFVuEDqLB3GnLKVhV/5+xMLeF7To8nGVfRhYCq/OlK4ct7NC6+CczQmuE8FcumoKd+Hp1xPXJDm2Ax2CNsjUcs/n29i4xZu/bMTKvtwzUMFlVz+/Y8CUYO9GvERzO1mNzzidCr0bvWMw0pJTjeb8oyXtnkjN4mDqISfVvtT2m9hiQ+UZmo8KxOud5LaegtkkqrseujdwelD5DSJ7wt47EVczrD7wwl9c6wZmgNODpkC80AmbXGdNeC2Q==',1,1,'',1,1),(197,'2021-02-22 17:37:35','2021-02-22','0000197',1,2,1,'1614033423769924630','',1,'AAURAZO',NULL,NULL,2,'B001-0000180',0,18,'2021-02-22',1,0,0,1,'UcFjZXWPuXQ/7Dzd3wkzPcX9vTc=',1,'d0SfLqpHPZLK3XrYIQX52gr9ECH82CLqxxSG6i8VOOxVF91mJvzTKNJA2AcjGRQwFTbz78MtOQpZtwRSVZYuMn510XeVSL1vKIvuG7M0KVprDf60JnSKr97EjExsgQ9pbjtRXgnsxgv9NdXzBzGm2veKNn1dTbFQdnFdBAq+5gP+itKF7NVoGFEX3gPhrTcI5k1Qt7P7gw8aaX3qC/SI+R06hhuyehc/GkKB9Yf2X0I/NkjDtAwv+wbuXUi3rKYU/AAEAbt1a9ZLCY2KpB3oo0gqtcB3G5LFEurYW1hdhl8m2gn2d4N2082+rGaQ6PgtE0vD2Wb40RVBVTS1bCIRNQ==',1,1,'',1,1),(198,'2021-02-22 17:38:25','2021-02-22','0000198',1,2,1,'161403345722849876','',1,'AAURAZO',NULL,NULL,2,'B001-0000181',0,18,'2021-02-22',1,0,0,1,'Ns+UywipTu/isC+sk3UDXBzdeyE=',1,'dn5LvBMGhIKnTtiH7/kdf6Ou9tdQviv0GFCs1LphloKM4AsZMwZf3bytdFnGc2bqQV7Fw9+8DCs/90LmDNDbEzz2srbXUgUaLuWwrdRDY8mPrUZbkvLlyA2uQZ/omUBxhBqDh6eL9uV3tuoh+qzkjZoRsBypWrV+iUvcKk98ngqzqteVKXSSx6KvoiPAfboEvh/yatYRAKZgxtA9F7Dp6z8kgv5p8XHoV1e8ih2FqC7SeRNpsJE7eyzuV+c8TLMY8cjWycl/mv2wwrYz5bYNWob/g3xhbM6D+JIiMIWhkdkzSxKeASuIs1yVVHvZeJcs+nE40mhl1xk/S8cVB6k54g==',1,1,'',1,1),(199,'2021-02-22 17:38:59','2021-02-22','0000199',1,2,1,'1614033508562683572','',1,'AAURAZO',NULL,NULL,2,'B001-0000182',0,18,'2021-02-22',1,0,0,1,'FA+LtQ5Q6Ce1XRk3qVj/NXYavOA=',1,'O6v4qJiROgLMCJOutyORWk9yojVjqyhN9b+OYz6Fb0TGe6/ZJp5Wpgh6j14tvPsAuJCkMERzGWQA/naeq5Mnse6a1z443vogHhD6iIyE11vKIaBVE2TuHX5giYSfnrdDMq3GtSG5f7lEz2jfEOfTh2sq13FM7jzBNO4G1WI//NloCvTHOixi01e4qNWOe0BALNEv6N6i4jC8Z4npBB7SFSQwFPrlhijV2TXFFdN5oiEQjKAsGfdSiro1YoSfm/gyE4lQBLEkIpb9BtOiVux6hiMFQaveqHl+urno0x+0RM8cplUcWFKW6bK7ySL/LvlUkYyxA9BWdpnZ07ZDqQb8FA==',1,1,'',1,1),(200,'2021-02-22 17:40:09','2021-02-22','0000200',1,2,1,'1614033572194933969','',1,'AAURAZO',NULL,NULL,2,'B001-0000183',0,18,'2021-02-22',1,0,0,1,'cc8rjey2YBcvUaW0ZOgyqRXfAi0=',1,'WaE6+jFJG6BiTzA/e0AX2vaplq75inYKV8u5op495F/Y4Hj4fiyUhS7gz8RGMD6MIABrt3UCtZExLY9hLUqUfTCfeZMK4Mwv6aLXxNVCGf2l3YfEHoVE1a5jE5XTB21Dxbx4LkouhF/PtWcPRqrE6VjoWkMLOFEqRd5jGM3tEIXAuh+6MzwQrIaXgAxi8Rdfo+261xVCZw+302QEKtuOW8s89SUoDTgnmWku2hYmmMI5rZKRTErmdAf6PS7+jtE2n3reVduAumxUCDzAbhq8Am2OdTDhY/FV7BSwOFns12p7u0yp1KRvyX7XPobi3uVjf5TidiW4SR3ItwP96cCZYw==',1,1,'',1,1),(201,'2021-02-22 17:41:02','2021-02-22','0000201',1,2,1,'16140336121087542207','',1,'AAURAZO',NULL,NULL,2,'B001-0000184',0,18,'2021-02-22',1,0,0,1,'lytRUjay5e26GY7MLhKCcn60HNk=',1,'ZVcb2GP1RnrmmnFp62mfb1gKV/FSYnMRJDOZs0JTcukZXyJc1pCjGoMTsF9y+T6rLv5bgB/3eUpFrz/U/ixryv/J35OfgijsFFMi5SWA3I65TnNCjbvLjD7YX8HheF6H5KJ6wAQaaGrMk8OCu8XFHXXqgFQKktABE3Tus8minVw90zs97g6tgnAqF2YB2x8hew93jpZcFpSavLUDy0ptupeUPy8ibwxQ+mCCdHFvyUH23F4veFSO1N5QVWdoXsFvyrbFi53BNssLHYUKKZyK3vrq5YziNB7dNiDJ8clLmghcxCXpH1SktOBfY0v49h++mOBnwIH1lq3HP7+MaTldkg==',1,1,'',1,1),(202,'2021-02-22 17:42:30','2021-02-22','0000202',1,2,1,'1614033665888692346','',1,'AAURAZO',NULL,NULL,2,'B001-0000185',0,18,'2021-02-22',1,0,0,1,'DaI6VXDmyn1i+3M0jKIOkyjr1RM=',1,'B0bGYsohvWEQssDeQs4TxFi9NTc2jDs9a+adGevx/e0J4GOFQ247RJpcaw2PxGrkgQGlDKqPRuneax6uktY7W3pClFnNyqEbJVqyRBYOaNKS2LbW7Ofxpj7CL6y17ftuMt9lyGtxY16Zksf5eSvFByBhB63jb0LVokJczj3ynREsAkRmcz/I0GTAVlaPALp0frkBuYvffs1EreprRWf5TQURfaS6O9MtuE/bz7712cx0zeH0QrD3sy6xSm57apSSTaCSQkFtXQzgHEIkvwnBlbJ2MhEVdF1hC8Jr9/Y+k9IV1N9jj3gY0nj7h1x8I8o8XpndrK74fENlip/vLUPzbA==',1,1,'',1,1),(203,'2021-02-22 17:43:13','2021-02-22','0000203',1,2,1,'16140337531206094765','',1,'AAURAZO',NULL,NULL,2,'B001-0000186',0,18,'2021-02-22',1,0,0,1,'nn+nCzuifFdJLzq3qhHhgqD2wBE=',1,'Xe9BrCAQhBaDICpVxoWp0iyqTSSBde/bzxhlvNnEdyb5nuRFlWF69jpMUde3IWy3KwleibHWqfVRqCHqpeGwdDlQlJcn2oA9QTMN5qFHDfTcFv29uElu0xoxSQ5pQ0SNA5lsX5MZwq75yRd1bu8cOcenw0BCuchC6E4x7ruakXTEtn6pYaNYJF7NAXbNDaH2Zj7MTOR5HW8g1LkQrKWJbAlt5tDO5s6BqVfF9CYxz4F63xS0+Tj3NNykQCjDtO7IvgFSMu2RrGdPkkrvJxHtF8/kBhrAyFpy8mhG4JdAhnbpSQLey+6scggLddZWpYa7hNntzT1aBDEllOPmi90Lxw==',1,1,'',1,1),(204,'2021-02-22 17:51:06','2021-02-22','0000204',1,2,1,'16140338001153208705','',1,'AAURAZO',NULL,NULL,2,'B001-0000187',0,18,'2021-02-22',1,0,0,1,'cBHXlk8XItni997meS1iiKEDiQo=',1,'CKSVJ+bCoBaZ39JLZkrBpZwd7wPODKWyuOBkHDPo6/tdaltWEN1dEO97yHONN5AA7IDdoZBXlmPzqYs1CmdlQZbfmI2G6jt1KXFcTCvBODni71EPUj73QwfrDTPm+bWej0Yid3SopUrI4ATy+0AT3DIbMXXfsDOX6owHtuuOYaM9Tv3NVnYeFhM3m9wXHh6Lb1v4lrUFSOw/g98KPX49kxCZoNgCXiN0dLkeC/TvcCTH70JEJANkPLFVjz+QIG6P9JYFAL9x/9Ia54MB6jS5i5rV1e+F30LxBTPD2p3VEAbUrGuMxz4oE7FzfRfEy+BC88eD//+xALzR6+MJSQLQXg==',1,1,'',1,1),(205,'2021-02-22 17:59:01','2021-02-22','0000205',1,2,1,'1614034270358497770','',1,'AAURAZO',NULL,NULL,2,'B001-0000188',0,18,'2021-02-22',1,0,0,1,'mR70GiuNDDbte5Z8ZjpU4b6N52s=',1,'T3Ef/kQcoVLA/yLj7NLRHP9ndNYthBmTZ9nRDiNrVmue1xm4Sllk67KRaXpokPI3JRJpgG1NZT0BlO62zZrYbjneAleLNnwgwh9ZX8UwH9IVxJyGuU72/qRlXHgi2CdAB72gs+hlwVbroJJXs+dyO+707bamRMJQbkwdIL5e/lNe4hm1c3EeN/gegr0wqDMEduOUEh+5MD+n/Q4tns25KW3Upc6p9wwv5uau0ogZ3uo5GhqJgy9BzIDAarynY/Dpb0k0ohTcxYWwX/r4CdhyCql4La9mOaKOYMcgdbjPErJHiMGvBgbdeti5WQvXhwVKO81xCzfmBcmxMD6bAVYWgg==',1,1,'',1,1),(206,'2021-02-22 17:59:59','2021-02-22','0000206',1,2,1,'1614034753524385286','',1,'AAURAZO',NULL,NULL,2,'B001-0000189',0,18,'2021-02-22',1,0,0,1,'TqiF6l5NZ0IdfohKAryOlYAQX2Y=',1,'BJCNKp/X6AZpjqjh8NB0EAImNwbpBhUb9YRGxs74VuBOSaTvwwq/moUkEXGkFg48Tl/j0l6aCus07u7+G0Z90k5z89U95YEjeAIHmRm1X4msgY1jBjFfjXh7yxIyg8Cr3rkZhE/e2LaQdgxWkw7j/heNNcMXejKPrrSkAzPPk/EBOP9KfqSJHFrBwyHCUOV68LCC4U1SpQ1mWqp6p+cdvChVOAz6dFiejhrdxqrKM0AJ7ddsTFsMLMJzA1pSccDVW4pLRMULbB64hAoKsWjPFQ/AHjBPcnb53M0nJF/CW5oj36MHqHq8BcxB/+/d0NsiDCy8KER9YvTBhbR9kq4vQw==',1,1,'',1,1),(207,'2021-02-22 18:07:19','2021-02-22','0000207',1,2,1,'1614035217684635640','',1,'AAURAZO',NULL,NULL,2,'B001-0000190',0,18,'2021-02-22',1,0,0,1,'MHRDqJzedsGhYvtPa5VtMTh+/Lk=',1,'KzACTZMwr6zv1kkKrYZibel6CPYGgqvlQB0asTEVJvNlPYGj07gmhYXJLFcG+bGwmFSLsEa3DoHOcM2P4XfELr6gtKZUU8nqb99qtRpQ3r7T6pP82HdjLeMUiUWMyxn6pwxW4F25dOdHFI5J8qF74Ys1slmDqNamJIE/dKSNhSk+MqHEZ3r0pGOMUia6VBL6oWbncXbqPj0+7/G1FC0hzSi+yd1Ii0T8J+2KJeQY5gcMLonMnBp2anUuAyPTHZ+xqvRB4/d44Gy3DSUpuKIdWRfS+ecn9BBKIEqi7qq+BDaFFePILJzHB7IYngd/WLHywjJ/VbtH3PTQBeuwiqGX5Q==',1,1,'',1,1),(208,'2021-02-22 18:08:09','2021-02-22','0000208',1,2,1,'1614035243295241051','',1,'AAURAZO',NULL,NULL,2,'B001-0000191',0,18,'2021-02-22',1,0,0,1,'+lquq2vc+T+SwVmc2tEgSY8M0z4=',1,'Mcak2bukB/hnQKgx6m/qc2PdYvOZuALkbo/Zkb0iSPn4Pqk8mEjiAbXQugmanl0i2qI7F10/e/I0v2uDbADcFQnfdxBsYanURaGb8AVLJ3pW3PDpoHHjYuwW5GyA1rZ3jCwVDNS/Lm4Odnsb1nHtb9N80cVObV8YhlcCbu6d8HWIeQApYlBmbwzAxw90Z5fNDmdvcsnsAmisgmQfwQ2kOdGKqUVe7RvvIVEZGQNMyyiKwxWCWl0dYnepDQpfB/4adaX0bay6VwPerXhCH0r+FQcKIGp4ByfSlWCTtlpGWtOKHjzTk0twDUiTeT63sVTrHNYF+cfw7J/J8lkvhG2tNQ==',1,1,'',1,1),(209,'2021-02-22 18:08:52','2021-02-22','0000209',1,2,1,'1614035292427563779','',1,'AAURAZO',NULL,NULL,2,'B001-0000192',0,18,'2021-02-22',1,0,0,1,'yll6rpbsuwwhcy5DnOU8F4VRbKQ=',1,'BslIZQqkLZLxVeBcJ3eyHUMtlYUQDvq1Vos7t4AqmGzxtdxd48qELD0qS17qnZkRZGqH0HfgEcB24DJFrZNN5ShhT/96iPyHn713ORnzFKTc2BuQV/7+OpgLM4CbiLReEfGH+9iZu1v49Md8ynC6pGc7Y7ng7k0hcZKu64iwFCNriWwJbjEss7xuUyQv5q1PQ+1TC8yb/U0w0L3IMZU5qZadSBSJL36NwmbzEsIi8hLmYgMvmip/jYaUGIbjZYTHljkVZSLkdm73+1OuxBxkAxvq9WaVad6LvPScZX7UytqQADC4b1jCH7zRuZX5oEugUtL2iMy2bQJ39znTeaTRKA==',1,1,'',1,1),(210,'2021-02-22 18:09:17','2021-02-22','0000210',1,2,1,'161403533516309046','',1,'AAURAZO',NULL,NULL,2,'B001-0000193',0,18,'2021-02-22',1,0,0,1,'LJMeF9WgoD01dZa3+Td4fvqZUi0=',1,'XfS9L2mpwCv1kgQHnCH97CUzusOc3mcTP2fEmDns6+GE2tv0uc1b820/g7gscsd7q9fup8Qx2lO/KbObXDdGODF/4mFcL0YPaIeMBo6XzXGPr/xo9mK2bPkbJyjWo5z/jZrOjfHS+0CUsRzGY+Vzn2EDTNpG3oUy0/cyjo68DJE7UAaxBFkGsltJgKhxZXQrvr7fVeRBsd9hJYL9Hi55vc3cvymM1rphA9+EvfTHRNA/Uzu9UsixZJBb+LJiPIUpPwjblZgYmcfSKgadaUY4pqDOeNyb06avfXw0kPpc6benOwWYFEGA3fLI+sB+zYhl4AlUi4ErUYiU4aJF1qt5zg==',1,1,'',1,1),(211,'2021-02-22 18:09:46','2021-02-22','0000211',1,2,1,'1614035359251004380','',1,'AAURAZO',NULL,NULL,2,'B001-0000194',0,18,'2021-02-22',1,0,0,1,'iARUQOSv1+0+xCBEGyH8Zzfv7Cg=',1,'a6EEhldRCzmIsH7IC05LQjqRPrUDvloe/ehrnmAdZBm27eXb9XK1ddJTsJaDZnaTBigsuR4AWh4mdpZb+Owq9+BIwEnAu7a3Xv8QwlPA90O5nhRoUCYyVYiHeeAMrt3vQuQ1gPzSJgOagJONbSxnsSIkrl8X/OkqF0vBEuaa5EDbx2csK5jvVx0Xo347Dv2BSdVcRhnEEGWy/N5DFeV5JhmuiszjEQkslmqhyh163zmDHjmO7eDb/ekGV4MBTtWO8TxYwrEps+kbI9Oq5uq7u8MTo1WyHjxez56pwvz9WRXykvmEm4NCCTHd8whyHiiARdk54SU4XbwMTe5oxoExiA==',1,1,'',1,1),(212,'2021-02-22 18:10:18','2021-02-22','0000212',1,2,1,'16140353891057376929','',1,'AAURAZO',NULL,NULL,2,'B001-0000195',0,18,'2021-02-22',1,0,0,1,'ObWIWihHQNd3Ui11HZSa5nyxGw4=',1,'ckclKkq0MMl3y+T5WTldAGpq7EHxga5gyGdagE9PQtLtWGmW+ms70QP3nRHi0Z7ugIbDgpuD9S0cz6f1jV/AQEzNvMUi5oWJe9ozhu6YJa25VhUbN2csWy+auu5Sj81c6huj/x87EKmoIvRRF25aJ+pmenpzrrF3v8S6xfDCVjaoT2hsmiw/W0evMCqbhv3pcSxsx+a9b4cxPqiST6sngGjN2OulZ2ki8g0PvYF81gFsFdrCIouTW5Sw8Via95CsKVMag2r6PeT5wrSDphNXXrk0zbydzqmshA8bCYcGU0VgxC38v8HdJ0ZFKcGeadbwzaCKv8yIGue5cBY1379TsA==',1,1,'',1,1),(213,'2021-02-23 18:36:58','2021-02-23','0000213',1533,2,1,'1614123192887788679','',1,'AAURAZO',NULL,NULL,2,'B001-0000196',0,18,'2021-02-23',1,0,0,1,'RFs6t7nKhtxT8iWg5Qg2RvjI4xY=',1,'OUVYjsFLImOaYLZOfEDXJrlZfqseLfzJT972MzTJKbd5guEHLZpnO4TxXn2/axNxlfgzoZa6adz/\npHwv+mBzeBv4I7eR0yWLr4wMS+hht0AozaH6BRYubTFEfAzpEIzl1DtiTvLGQae+zjiXjArphCsQ\nEGT9q0m14j9mSP6p+LDbTjlks+Mj/4TOVpHPD2xO0uIzbIrP0+XLUTjAmcmCoAuaIcpKYPXnYDN8\nXxCJqpkMQoA42bs0QAyQTr38mXBDv53YgNDR6QQzUoycgLB1pIUn3FpJ5Ge9Sg7fh//NLCQHm5gS\nCwjCRAsuqOUq80lEkyoCatowJVZIHOULWTZxNg==',1,1,'',1,1),(214,'2021-02-23 19:12:59','2021-02-23','0000214',1,2,1,'1614125538612643470','',1,'AAURAZO',NULL,NULL,2,'B001-0000197',0,18,'2021-02-23',1,0,0,1,'DQ0kzgZFOX5Mvrubvco1pTysQyc=',1,'Zc8SbLKUa5DxbdQ4vMTaeLuk8wzxlVdwC2wb3CunsK8i93ZESWWvUAdz+adlynWOkeflJ0CXgDls\nrtADZiHimLqu/XW2sTPVVUMyZ9WIAgw4Njr5fdFdb7tKMs0lom6Yvm4Q4skc7QPSuLPi7ogXgvaZ\nSQZoOtU2Yw3FqA/2Cg3KSUC9LAoPobnsfoXTjWD/TBQ90DILuEWODwcuL9HCRWu+ATQsTF3wB93/\n/skSWKDy/nZLdwSY9XlPjcSb/35vWpE7lTe2HczFLFEUXOoleZBCWOqRr4uBdHhCVFixP28CF9tC\nx6IpcVDgeGSPp2CoaHPb9OwghisQJZvSNYI39A==',1,1,'',1,1),(215,'2021-02-23 19:13:19','2021-02-23','0000215',1,2,1,'16141255821118352963','',1,'AAURAZO',NULL,NULL,2,'B001-0000198',0,18,'2021-02-23',1,0,0,1,'2fEq/ZlFUvXXw0Hboc3CM/BdYCI=',1,'jJG5k1M/LdFLyDJZP19TBXF6xrnf0YfICpGoNyEAhL7OLRcRduNnHslVnCqKP0Hq//WRxIa3u1Zq\n8ZenYs+dLiYNE92XVGpoG1tJAqmIZsj3f7eM4Uz3cZEh0WG/AwvDVUjgvPla9NWs4Ncnlq5Bvc9O\nqFWXAZyClkx12LU8NvgQK7oYz1yU2PqHaiiESxzRzxGc3kqBzeGJp4CEsDemtjV8MUSUEUxoST0W\nckKrfME7BpjCNrcgLoDlrezqQNVbJZCHbkzvujTnBOanbWPPMp4+oHQ+dwnmSDmt6XL1Ni0Q20ve\n8sjQDGsOfH8fNSh+/PP6BuNHxINMtpYpVKp6ew==',1,1,'',1,1),(216,'2021-02-23 19:13:48','2021-02-23','0000216',1,2,1,'16141256011111338782','',1,'AAURAZO',NULL,NULL,2,'B001-0000199',0,18,'2021-02-23',1,0,0,1,'99Kc30foEBdnk+B0Jm57OfkJEvM=',1,'HslyCkbq/NChKhejAcBIRb+LjI9JGSv2+LYdiv8FAlCB7PuMQYeLWbpZ8ypjPVHp5Imzxvz3cURi\nvvkfVUhSgJmLVtF1YalbaYEp1B4d+LuszlKTLDHb2VBgnKkNEvUjcEahk5bB01rZt3m+mIsK6rpB\nFMKW3Pr5uxsAhyQF10/iMyyDZBdJifWIE8VCVMQYrouHguDZbagkQ98O03ZxZKWnz5YWYxbiiBaf\nOu6dH1EWppS2TVTWVeB7YOtP4XQ/EKlh9NEnlP0S0QfN9tfXzpmCeBvcA3wvef4qaMdMPLkMvN+K\n8ELnhVoT1qbaK5Mxroch9tuPTWI/08TkUB4Kjg==',1,1,'',1,1),(217,'2021-02-23 19:14:17','2021-02-23','0000217',1,2,1,'1614125631769752503','',1,'AAURAZO',NULL,NULL,2,'B001-0000200',0,18,'2021-02-23',1,0,0,1,'yX98YUN3tfZa69xsApf9c5uVtDk=',1,'Nm2zo6jlTn42X8T4/YXfCxztsB5b2QxXkIM0RmEpEL+dDJASKU2H1fcuv8DgfID8CfxUO53O0ccDbis/d2Jl/f/9bZcomw9E17BX4f4CFlvT501ZbfFyh1Ty6lEYBJB/6Rsh44pHzeQQhcUvU3NioXfeVPNNNXKRFJSB6xF+EvI45zT2y5VFwS1/GgTmTcxSrRaDZ6grK97byrGIo459/Fp85gFiyN6LCOC4wUMq2AkaH5VgtUQPdFOM7vkCPwhnn+NJoSWAPr/QVMmu3zOGNm+Oye0xvlN9QODLnFlrQTcoc6yrtwm28QgyoXzqby6++3AUR+PCqmnFKSVq4rnd0w==',1,1,'',1,1),(218,'2021-02-23 19:14:59','2021-02-23','0000218',1,2,1,'16141256601274128011','',1,'AAURAZO',NULL,NULL,2,'B001-0000201',0,18,'2021-02-23',1,0,0,1,'SD6OYtqWhQP0RPcV07zacFv3b7c=',1,'BImWbIFMSt04doLhBixAfWHXeCfacqXybdvRf1yWJvHxSCmatOPd8NajDOixcyhj/tRTLeZ7s3ziWlK7yECypaDUm6wuu5QuIv6Im40m2e0sbMtb709+EgLVYON9x+bGeS1kbkR4Km+96soG7gNBpSX1RenQW7QrvVN8M3reIXqkYvyW/vxlwBSJxerlnsSq1krcTQoJYGKvcp3ZFYeZj/6CuPxLF5FbqNflnAHI4QTita+LqrWjSDl8Oj2Fm13/pMGxtwq894IGeP4A9DhokqX8zBNPZa5SMFtbjCOLO9fpbqYhnYhQ/cZVyq1FS7AxgjJm0nYHPxSp+lSpjMvgIA==',1,1,'',1,1),(219,'2021-02-23 19:15:31','2021-02-23','0000219',1,2,1,'1614125702114120284','',1,'AAURAZO',NULL,NULL,2,'B001-0000202',0,18,'2021-02-23',1,0,0,1,'IaiQntfUC51Ms/gOSGoiDDoeauk=',1,'OmjTYxPHhRM2sucgY6mP0WuNTjwubvz1wSQDYX1Tog+i0GTAYs9sbzYYy5AGU6I83y1vphOIZbfdtWC25K9xFCQJCJLOesCPKfQr/cRp1nXnDMxHF/3WlsP7XMUfdseTPMxzOGxIVaN4R96VmUFDkfky5RBNPeKqBQcVNVtoUkLuCsHkz/A8ySrmuQxNA6flacHjQj323jiNA+j+PxzWM70BwChu+dgFN9pbzyLkj0wY97XWeuDJmRlNDS7EiUxsLextzWqeKSM1wWtK2DcuAURI+nfx1ZRaWng4ib9EntAafokkLDL6IQof06N6OzQx41wWyckjiRFGyiKb6ESO6w==',1,1,'',1,1),(220,'2021-02-23 19:15:52','2021-02-23','0000220',1,2,1,'1614125733120273829','',1,'AAURAZO',NULL,NULL,2,'B001-0000203',0,18,'2021-02-23',1,0,0,1,'zXwLime4wrcS4Lwi73AJV9JMjiI=',1,'OWnxh4Ohd3kc44xnHKqXA9cIsbytBnmpPaFNELT6+6ERVd+3oDgipQ2esPzuplcOvOVkSZseElilWd+Owbq0J171XkOzLo6UmNjct3jwadLLk6jdtH7j0TVfoEPdP4sMud49U80MZ6jnGgdcxXxSmnWsyp5xEb9s0OFjpreVFouyQBw5dQXCyG0rwg9otUsGcAW7ddgNn3FNDVsk9jsOifeCgxlBWkK3AQ5bJfWYJr35e3ah/ya01LpJ0QyBtOyhl9BeIT4HutjguPVOhsfyS9Gv2YjjL5V/4JexnJvyndY4bW8jzsfM3vZFbwuqEwRHHK1MxAgQ72MNBe5R43mzfg==',1,1,'',1,1),(221,'2021-02-23 19:16:18','2021-02-23','0000221',1,2,1,'1614125755675641997','',1,'AAURAZO',NULL,NULL,2,'B001-0000204',0,18,'2021-02-23',1,0,0,1,'JPVH1SIFB5O+26Cupwo1vlJBoU0=',1,'O5bcBaPBPNHG0kRvVZUFbGDBQItpXwHpcpscn09KLzEs1HMlSyen66+sLZ3ROGN2VWfhIH4LWrx1ivggjfHud3CoeJztYGnPmhf3EL1fQVANgRDPPRs6ThmLQYm5472/LnyBTgP4XnfgJeKJ4GvENTGnQNDPPCt3ylevyIhPGMNp1000ZcEFEC6ItezEtWJppfP2nTxdVpsR60gk/V2HpXe7+fdLRQpPTqdzwBDDTgHbPcGsjlyTR0f96rC6Vb/8ddFSGd9+hOzjrOu/Mz3h4beO8ludu3d1FK/4QZHHE3sgowHA8zB//7mwH8w4dT0ZytGmGwDVbDS3w2w+zte53Q==',1,1,'',1,1),(222,'2021-02-23 19:16:39','2021-02-23','0000222',1,2,1,'16141257811278129966','',1,'AAURAZO',NULL,NULL,2,'B001-0000205',0,18,'2021-02-23',1,0,0,1,'xnBmQEt9fpjjKafiUtdKz3+B26s=',1,'JoxwYZYXltZyaEAB8YL3woyZLQhMkfYeukuleyYXiPu64YgP/bYe6JJlJgLm3kLkKRRBriMJksuBTQnGWtg8lSBfR8sQ2pmmR9GFHplZAdGXsZnptvsAPeUHA0EfYSRNa+HOuMnUg2XE9UDxCW2CK1UUzM99WU04TkDkWe+Pow1AyIFraLJBa9y41oaI2fOv6ZXphDiVQHU0R6UfXDFV7sOl4PGSr1YXJ098u1pS7Jdci9F9lZ4Kc75MhfQpg0SkLQPvxKLtXXcmRJ8mh6+ahVcQD7wc+xpJ6Yux2bRlOTHqpHm0LI+aS91NBFxSOCvRWi1cs1Jo7GpymIsqiXiXyA==',1,1,'',1,1),(223,'2021-02-23 19:17:03','2021-02-23','0000223',1,2,1,'1614125802265635186','',1,'AAURAZO',NULL,NULL,2,'B001-0000206',0,18,'2021-02-23',1,0,0,1,'aPbSoyNEh5PHN3xQ4jzrDBB7RtY=',1,'Vut7kqDm3xRHe5p9xLKvqhKaq80glm6zvkl/M4hP7XR8HlIG4ka0eWgcUc5RKw14pHBJWody1yzOEwxCLxS+4Y0W28YwzoizLLxBaK5r3xB+C+BV8A8CahgbTFj9Yc7HxYZpU89FkMyMD73XvkiOLzV6rPfDOi9hvLG/61MN31pgSxrW2QpAht+5RMLjv43Q8n2sawIKEbNe+EFssiJQ0FuwA1+UqlGyo6YROkttQ1R4al6dI6226aVBd8HaT17B2NECsmJnt5zX+YIZTow7gv+DMnFaiH2QzYBkKncPcplDhonmL11oMxqzWmbB5KcxIwFNBO0KB9JOfbWJAMvOPA==',1,1,'',1,1),(224,'2021-02-23 19:17:25','2021-02-23','0000224',1,2,1,'16141258251244479113','',1,'AAURAZO',NULL,NULL,2,'B001-0000207',0,18,'2021-02-23',1,0,0,1,'G4CczmYhQ/eKx1f+EFk9xkl6oag=',1,'MGpK/l7p5cHPfUImExICrH7Mnuz2byPb8hl9NM56FO4QsTHyXrcZHdgx0DDCSovx2l9InSPYRgg4HvFsuMlFL97MZi6sRyomE6OkjeAuzTOxujFUXmWHgwK0FzXbp7KW0D/094ilt720uq7Wm+38xNBslIOIfOGLNnrjQhPmXOIFqaCDGazNlgYCmi/m05DfqfjwDH+qp6NLTnOCV/OEuIPd8w3/gvgZ2jSauo2fhZ33WDL3I3loLq2UmMKsAwhtECeQyDro4GSIJVUePt/RDZjP4aX35o6qvCAFWa/EMuuuL0JF3d7nlHXWmDfUNpH0/SC8nDCBiAbeJKR4dIE2yQ==',1,1,'',1,1),(225,'2021-02-23 19:18:03','2021-02-23','0000225',1,2,1,'1614125847989429746','',1,'AAURAZO',NULL,NULL,2,'B001-0000208',0,18,'2021-02-23',1,0,0,1,'CWxEZiJ39vj0bSq027/I/N9iTjU=',1,'Qg3kqBspMGmFB1TalH81X+c6Vqgs/mPa+eRN31HOdYVit3rBBt7Q1xZq446SH3OsnQreNPmBuswFjHisEza9eg/KCoO0RP8wi5OIPHnqgaGW5ZBAjIIXOEctzYqw1nSj5Y06L37P+oKP1qscZ6sAzXp+VMO5EXdLKvGlAbhdce/syW3l2LJMD7I0eWhrZoV16zOfNVImrROne9ZwsD31LY/EmVbIaW55iyZVsAxEODMOWN1Ar2uzbPSQ9ZXDHsmFIOqdTNnCELJ7N2pKXanNkOa4m/vGYq2KOZF/902BJ5omqQVAoAl6t6DIZmhUDG41mJavrT/rW+EuBLKm7giOVQ==',1,1,'',1,1),(226,'2021-02-23 19:18:35','2021-02-23','0000226',1,2,1,'16141258864131051','',1,'AAURAZO',NULL,NULL,2,'B001-0000209',0,18,'2021-02-23',1,0,0,1,'4Wy2Egaw5LTnJM+O00noyOOEPU8=',1,'V2NPEQ7DRGkZI2qY7L5a64lLFY88a0ZkG1TwDuorelth32XLCjykohJmP/IKf73t7xDWY37awLQC3glwvCaSNzK4Kg0x44DcyQKoRRQemZWloQyZ5DGWCinH+b3OxuEYZ+O/Nt4SzkYX8HclmLydihGW5xAoUO1Kmb4w4G7+ClGLCBv8ogEQ4WLno1qo+QUhCA/I46ZNito+rZF/L/ZsysojxHKK6hBan1ozXVe5F0yKq8ofj0Zn50SRvXrMsGv+m76Ou+FHDz/nMsBqcacOGFNpiEW3Kx2qxZq0F6DnIpwgKgucxy3vr6uymtr/sdd4pO1GjUHqegtFIRBGFzKXxg==',1,1,'',1,1),(227,'2021-02-23 19:19:16','2021-02-23','0000227',1,2,1,'1614125936403638108','',1,'AAURAZO',NULL,NULL,2,'B001-0000210',0,18,'2021-02-23',1,0,0,1,'itAN1CqvlTbr0NgARY0LM1qT78Q=',1,'EUNWYqdEmCrnL7o4G4grr5aIyrDEFFuZXwofZxD3ADWPv6iXyCdNGsTnYFvXLH7g92VX9uR2F0R+hD85rW/h6GjST9S+1dbPBGh34kq5C8oxk00l512fknKWynU21fq+l+PzXi8NotjWWtEKj4EruisII4lBNuJObRWlGtpHR3pyGE+gCa4ykeBaFjVRor4b9ggO2ACtByvPLL1flWYdLW6F0GH38vkIwM537kdK1nLXNlNRq5hsjLgsjUcRZktmPkFi6sGwLH47PoBQiCmhewCHvYBQEC9++wnWVa1Jjucbnr7/w6RP36u/GaksqSgd4BdagUX34qmNwz2DRntoxg==',1,1,'',1,1),(228,'2021-02-23 19:19:43','2021-02-23','0000228',1,2,1,'1614125958504891890','',1,'AAURAZO',NULL,NULL,2,'B001-0000211',0,18,'2021-02-23',1,0,0,1,'w2YuWAMOnDkWGlu+8b6bDRMoEHQ=',1,'jlJEelkSGI/sPz1zg3m9MKT/Nh2xLFpfjL3UEs8YfiCvbESE6L/qOnDR1/bGBMYoH7t8bsW6LCx5uokxCtVgzSRTVfvTXkL4bZCrMGXwqpE37L+B1roPZaoskgGDhLGZAED5Xq7LxTOClzCJ9R/dwlOseiY1W/Nl7vm0SWFkBJd2ToikO8JeIEBNEHPYu3DRjwYLvJcCRTFDB3pNufeLE0DJtXTTNtpxp49MbrCCkDQt8RPj9KG/DrBmWlFbIhOMvqYwDtcU5ax2MqJtUrJoDGi9Xaaz0vPN3cjxCvqRj6XUBo1BkyODyyC54SzHorylfLl7eF/k9TpfjrPxPGh3Pg==',1,1,'',1,1),(229,'2021-02-23 19:20:13','2021-02-23','0000229',1,2,1,'16141259861360148541','',1,'AAURAZO',NULL,NULL,2,'B001-0000212',0,18,'2021-02-23',1,0,0,1,'8Om33SXvhsCpjV3wvl7l1mTx1j4=',1,'LHstReLN3eEHiTybJ3VZeApPBSVBP5qgsXVnZFzhZBctihS5M82nf6yV0vpsJANpCZqLhsEL8YHzv/jsm24aMs12Ym2WsKFZhPYMsU7QDyKgSUTAooYgH7TtnuXXcgMfRdVHljpz/W81v30Sjh3aJ1a+PJ8g3ptC/uw8yaJ8Nw8nqcVVCaJaZdKPrBEjW7pClVpp33OCkvpW/35s8dXW4iq3Zv+f9Pca0etSzLGPNVgeCOI6CRjKmigfAVqyNHN8nB10z5/WHKCt286U2U0rNCmKuqlE5ZuCVs85RwJKdEIYbu295i/BiTGK4zw+TBs9WYAdIUPyCSeEJaz8ja6bmA==',1,1,'',1,1),(230,'2021-02-23 19:20:49','2021-02-23','0000230',1,2,1,'1614126015217181400','',1,'AAURAZO',NULL,NULL,2,'B001-0000213',0,18,'2021-02-23',1,0,0,1,'mYbe7WL7brwRzDYs3NJErp3mswE=',1,'axi0W+T3TuH1adGRBLJ0y6Xdeaa2Dlc0UksrLuzTAejVTNuVNsHOmxFbaLcO9cP470eWycrV79+Mi1pPAzJEnMLcvVtF8KecPzIzrydF/bFHSWaHD9B++XmCzEcjHb8mugRby3X4+ljLdobYPsXAEDhENb4YT+nhu8HjsJbS2HQLLjVyG5WIBaRmtr5NeeA82QTNodvDnTKMa/c+Mmw95YDsO4FfDW7eLP9Gj1ImsWj6il3mAQUTlzuabUVcae20+/tFmJSbZIGIxFUIcPVXk2ilryVykiC9zWTFPit3+/MSee4KyzoG1clYcGYLCr93kwUzAZgiWCtVKpIAEJoCtQ==',1,1,'',1,1),(231,'2021-02-23 19:21:15','2021-02-23','0000231',1,2,1,'16141260521368840961','',1,'AAURAZO',NULL,NULL,2,'B001-0000214',0,18,'2021-02-23',1,0,0,1,'gu283QdopKrPNa+wxklz3OS7m1I=',1,'TBlpJdjnJ4/GXIec/hJBNvLrn16pUinabsbf4G6MgNebHMuJmDFk6D8kLkum99rQOX26HapIyRhSRLnB4S6MPHH0RNKLAJacKX1T6kfsyvc7JJnP5XkO8S1cuI+y9ZhfSQdY+X+v7N/d47U2qim0SH0JODs+9Oh1dAD+BIdSXDlhUcxtRyWcxbmoMGPl7U+fDM/pKaUBczv2hBoAR50Zgl1w+RNNynh1ZU0weVT0CvawN1kenP0r7sQp9H42Ai3Xvk6vKbD1hSmoJmFeU2XSMIAbAfDlu7v3puLj9RzqM+b2lFU0d37xr6aRYZtMUU9emqTdQSNcNulGcGmKh0sefQ==',1,1,'',1,1),(232,'2021-02-23 19:21:42','2021-02-23','0000232',1,2,1,'1614126082296402910','',1,'AAURAZO',NULL,NULL,2,'B001-0000215',0,18,'2021-02-23',1,0,0,1,'yBEZLWV48CyJvXvxu7L6uDHWfDo=',1,'B2WYeUgmnyqk7LT2vPTpUQmnamy+VY3APtcYthnpD4XNI9rpBXfcwkgqKD3eBY/0cyG84Xi2xF8amojHSkjIEmK50pyuDG3fpv9MnTilHA0Z5qv/ZXbdGFs+wFyrTH8DxDhcGaGsyghW5KXRZLLaO8HnYqAi9ic4JzAShGxjvS1CQz4g+jWrdOgHMuukyNVvP801BhQneW4fB4EAqRLW4Bg8UocGLyKbtB+1OJla+5nSEaR8dZBEa4E0jboKu98O4WVrT8gvdGdCxUAVaAxCmlFAW1IDXifDSPXFzI7JUpGbwUumQKU2i80DZ0PcXJ1s+z4CwvsuNqHXkXIvIeakvQ==',1,1,'',1,1),(233,'2021-02-23 19:22:29','2021-02-23','0000233',1,2,1,'16141261051349863946','',1,'AAURAZO',NULL,NULL,2,'B001-0000216',0,18,'2021-02-23',1,0,0,1,'oNjdG7PTfutvZxrY5DPF4fLaqfI=',1,'ci1CjLoiNKMe43PDhbKCyJsKafjtomTwbqJzr/Nh9qHC/1j8WZ3imWLGZGvAZua2Wr6JsTlT+YYf1alBbjTC0Lwc5yLakKXDgR7o09Af2Op1VX8shYAK67NHfK6uEL5934dZIyKGRpiRg5H/yC3EenPQ1W8Q6IBSYx786Oep/YSVRPfC1J2ArbfCST2P5fMd4gv9lXF01JEQdsST4gDFasPPK97i7bsXxDbkjkHjOIauW5/FEkIAft5P0dsC4NXnE9zJqJUDVG6kFHp738mSXxKhXg2SJuiksnTpzfBwoA+mp7zZ6ykKaKp6lyr1FjHROGhxueLc2UOvoW37amyEEw==',1,1,'',1,1),(234,'2021-02-23 19:23:07','2021-02-23','0000234',1,2,1,'1614126166898933910','',1,'AAURAZO',NULL,NULL,2,'B001-0000217',0,18,'2021-02-23',1,0,0,1,'7Na36psRjX3RMBzMgaghJvp9moY=',1,'V2eTLyp0zzGOgtWeTnkcfj+N6YPCW84Kz18h/P5Hg4ZwlSVbO/IG3YlTu5PZ4X/fKJRU+IsatuCQD/CDuPsFPHnMZxkOc3+XGvcZncubEkligXSS7Qurc/Td9gKz7NTBZAemawvBMJA1v3qeQ5szYi04VD4SteuY0BrnH53SUN9vfLzRNdk/GYdT6H8vYtJOuHMfAJ4RkrYJP3jnGFFHcLDRi5vPaiZWDIWHwvRttgior30Nryaio0O1BQ3et7H/eFk9w+SjVUYdSej/nIPoQ4cJuzur7HXnFJovx5BrUjvawqleHzOPS05mlK8ugpEs/1NJ8ZhJoGLCtHWHNjv7XQ==',1,1,'',1,1),(235,'2021-02-23 19:23:46','2021-02-23','0000235',1,2,1,'16141261911383385703','',1,'AAURAZO',NULL,NULL,2,'B001-0000218',0,18,'2021-02-23',1,0,0,1,'Ainh+JLHrTLl5CKxZ43S4W0Yb8A=',1,'M/Q5oCAsRl/QrwJ9H4IWY5QhrExsm6Qu9uKgce984nV/eKm+dVBWnh0w+twflprCoUNbKN0Sp4zzymCDrKE3mA6LKcbjEtQK2mw3bNo6oyrNtqyX0QkTGS+ZoNPMVh3/hPAHh8HTdccsOJOf+qap4WKWzEZo/vj34AusZdpJgewOQWcWCGru7ZjFuCwslR3/zRWZq4QAfXBGfLDKznUm8gjrL86Ritec8EkHBS2cxMhD8+a57kDzmotIDTQGbwYXQN26UGXIXz9D6smpNpwwdED7ClMYvWUNpIqVkoO9INrUs/OTWfDfysB/RvS+eglJWBsJ+S0c0CF2umU2cmJTgg==',1,1,'',1,1),(236,'2021-02-24 18:09:13','2021-02-24','0000236',1,2,1,'16142081351242069334','',1,'AAURAZO',NULL,NULL,2,'B001-0000219',0,18,'2021-02-24',1,0,0,1,'C4tXQBhD8y75lk4rd9YS+bWDPmA=',1,'VJzgyC4U7UkPpexwpme7kYSi6B8HMgbyhgwU8Aai8fT4G2bnQoposRTJ4yCQQxQ5OvpxCTE55fAR\nr5+GTDpMW9cW6XoqPggvtidtTCge5xYIT1LEWWtNb5lA+U4xbBbFsiOPL/I8sr0bZi8DZt/mm1MY\nmrDnta9V2j0F9u+ocEfoAilYOy/jp1s1rp+z5Vg79MqXSeNkaRCUwFk34x/A0fU++Mnmj7Rapbbl\nubWbY773QivF5wjGAMicUSBA62viJqyB6ok5IclvjgmKfTpHDAhJUZ4uEbRLsy5yC4ZyhYjt+2ag\nkH9l+/VRcPIxHvPqY07vougsUQIlfcBKY950lA==',1,1,'',1,1),(237,'2021-02-24 18:09:42','2021-02-24','0000237',1,2,1,'1614208157408285541','',1,'AAURAZO',NULL,NULL,2,'B001-0000220',0,18,'2021-02-24',1,0,0,1,'zydv0vNK7qE30ckNjZ6HYlgXq+o=',1,'asrlJjnTvfGWwUKHtOUTvgKxvEIbtas8ujZ6JKCotbf3GwqEsCFHV4y/5udVKz9TZi4OT6S14nlG\nfpO9LXUEfUc7TUhSg7A+TN39SxL51mSnOB3urBX/vcsz69f8yO7JxJV3Y2wUceh0dTSANyUWrZSg\nm1ehMT+qye/vF4sjVX03pVVaYKDI+0XnhK6xfg04r6mCSSQIecZXmLUEtaFr4oYzfykcLX1RmIM9\nrnQGpHzYdnKnYHXxNJoxFsseSv8A3lB57stJC0TJBhooMtS2tV0OUNShEFhBtDzu2mt888OD3rMC\nI1IgJmW0+vZfsbBjb3vZ2kb4G7tXllPNMK7duQ==',1,1,'',1,1),(238,'2021-02-24 18:10:23','2021-02-24','0000238',1,2,1,'1614208185310474302','',1,'AAURAZO',NULL,NULL,2,'B001-0000221',0,18,'2021-02-24',1,0,0,1,'vRGYJcfr8BHUWuGa6pAss7ZG+wA=',1,'Dlom8zbhaeskMIUk9uVcCB8xd3qwuQg7lzXcMjO0a6MrFbtMZXUwnWWxi2gT92UVYJyY4T0/JHMEKFXB3Ah7Ef6TaSA6GQonL7Sx/6bnUg2FFJ3B+IouGU5cQF1Eq16bOpRaIGunit3djjOlhB4eKwnC1x1RgAYlFnDXB30CQ7vXhaOmuA827Ib+ajbkp4+nxEddtnvRFb9c9CQmsILjYz6Ma8DrONRBPKsNb4L2v2w6dipWiXAQl2/3AXyB1gf/6DFWQHkqNhUK5TlirsE51BrSX9HbhNoSFHzteb7aQ7VXko/7AT5m2ILe7cpiP7VPuzSjJl0MuKgeeP0C/HLy/g==',1,1,'',1,1),(239,'2021-02-24 18:10:54','2021-02-24','0000239',1,2,1,'1614208226276522227','',1,'AAURAZO',NULL,NULL,2,'B001-0000222',0,18,'2021-02-24',1,0,0,1,'ayBZXcADOjRQe0D8uTbTVCrNzws=',1,'AxL5EVuaUaYxeyKXCeZXW2m5MkQgbpAFNqWl61PYdIWrP2sSy0gyKaMhln1TCji4W4ho3yy3m6tJM2+bfy4PLsaI/1n/0cIkFVkvauPrrZdRrwNOgLykW97cGSkORthltgB8yeBIOQpBsdgJ5kSH+pgq/KSx20PqxbbNZGawDR9Mie+mcFWfcXhczU6oB4+0O91wqVK9CYnwzx6F3udVg+rNviFN5xuIk2qGP+qt0FkQU44Yu8jGRCiWPHFXhedycrJGyLxToelxCGOIDj6Cdic+/OFz/YZgBZJQHCyJLJxf34nmbpNbIHnmnUBQzCmxKyNMFX77KGcC553z6A43BQ==',1,1,'',1,1),(240,'2021-02-24 18:11:16','2021-02-24','0000240',1,2,1,'1614208257840453719','',1,'AAURAZO',NULL,NULL,2,'B001-0000223',0,18,'2021-02-24',1,0,0,1,'VizTnp7IeBEHCvXvaxrYNTuQ1HU=',1,'cbiIxw+SGUBorlppnregi9DjImZVSxx1yB7zcksucwfDz4PLei9C+BY3NduBUSvD8TB4fDnFE7IDqIv+hL0DR8lemkGpkW0VM3IKabRKvUXrTBO/BeRUFcKcNUwLd+6fGZCP+WWBY6BuetVCBzCSc9FyaUhdC9qlnyWurTibXuzgp+hfCir+8L6tvK1kGyQE45rL1RHbWPf3sXYvuy0wNudHt+KMMlAj0C+HquDHcAMCSU/unqZghOKwQPMMoUO6iUU/cndEkf9kZcg6siMdiPMTHU4wSenJhK+Cjc4h8jM5PV8XD2VZMflatkgpPOlLil9rsotOeWGa/42gOipj4g==',1,1,'',1,1),(241,'2021-02-24 18:11:36','2021-02-24','0000241',1,2,1,'1614208279550505578','',1,'AAURAZO',NULL,NULL,2,'B001-0000224',0,18,'2021-02-24',1,0,0,1,'/qKTa5a5RQ4680REmO/SVxVvOrE=',1,'E8ttb1+aD1/SbJzcE9eVTDW9C3Hn7Qip2kop588VcqBMpKNHM0EkdHAPFULaxpk9WcRIHsZQ/tlmYQx7RPHJewIMx9CsRUJ8RDctnJmztv2jz/bt4Ykasad8S5nS7oDLVRqY8rn5zEopt/fdkmk6sKP1uLn9d9jvBBOmcxvDyoK7tL2gbwpaaLa/uO6/sZ3CCO70rByKB6yP2362zjoufOkP3J65zYyD0/N0ki2miKuDpZUJzKxM9y4lWu9Zs4drPcLemuVWMJJz4YgBis5KOW2VP3TBa3rECeagqLUWb8zDRXZDfDfQEcNLKP3zUYj8Vf+0FiLSbBhnBvZ9p5nA2w==',1,1,'',1,1),(242,'2021-02-24 18:12:24','2021-02-24','0000242',1,2,1,'1614208299979575468','',1,'AAURAZO',NULL,NULL,2,'B001-0000225',0,18,'2021-02-24',1,0,0,1,'aE+iyG/nExtPpZTImX0/4oke5Tc=',1,'XIHODN/NecOgzBDxRL+D3N9VNkAOt6bXAQzE8w5pA3e63xaFeMRzcdjsOJNpO7TIwiQ0O1B5xUHj+mFtlvfqX5sTeU1rA8Cjo/8cjBQvMZrLLAe+U8jmNexPLMoR7YdIvLLvRtZSmbAgPVPkh+l7xUERho41Rfayl8Q+sc0RrsNYHmF6uxFb8bSY6AfIPzIPMxXtPSDC/6+sK+Z7ki4j4vY70db2oRQugyp/URSX/z5vrQocqYeDa1btpH5SlV7mfo/sQw8bC9dbPfIfj2Rzo2DumLk5XwHn4jjzlhSX+W0N1a2icFQCMZtpNOb1yhF2+8OGTB4JJBonuNm424poHQ==',1,1,'',1,1),(243,'2021-02-24 18:12:45','2021-02-24','0000243',1,2,1,'1614208346955434639','',1,'AAURAZO',NULL,NULL,2,'B001-0000226',0,18,'2021-02-24',1,0,0,1,'8h0ER7YZ5jAL1UFLCZ8OPaWJaIE=',1,'XJv/vHO5QkUTHDlcHhHxbazITPUUe2DEs216s84wCmN9kn9zt4ETfGvMiwjaSE/cCsB+j0Av5AxfqK9GfzQq+/TpgBXh9PbeVVWvq98ciCuv+XCLHnqFeBJzagFMGXGDGGuFKVDJQ9QYG5SpZCy0m5BGU1J+y/HI+6mEjeq5ld2Xhbh3ghYfZC/hy7Xog3Q9flxSp2wCc6UJ7I+7WK/aM8SPv1uMeVCP79CN5JNYa8ShuZxtRY882fvAHcpFbmzKUK8zOWuSMCoSf207ho2VYt3felQm27yTHPgqAB2Km0RZfPRB7OtkhtXfTox7EG4kxa5jA8axq7ZZ3/mgYPuFtA==',1,1,'',1,1),(244,'2021-02-24 18:13:27','2021-02-24','0000244',1,2,1,'1614208368494607294','',1,'AAURAZO',NULL,NULL,2,'B001-0000227',0,18,'2021-02-24',1,0,0,1,'ySq09hqbU0f7LBvLzTzBGgDawZU=',1,'Hf9+lUNyIeuKnNUG5LdpZ9xQXpq4cp4qAc73ms3nOJcao/iaFmL8yuxPFS4tFQWaLXNZeGy2axkCU+05XGPrPCQYthzn+GBOGCg+CnWppE8yl/YvSmIrvOyIj5ooZFHA14h1CaSgt3OiMg/y9rE6cFt0pspQcqZGgqKmXNCWEe1K8ammer0wo9EV9ExmpBklS2rCh8axOuOzr8VCBoCXKRWAwTH2VOlAXiuwsHKHJd9XaT9o9VJPHLxq97FZXsLsaVY8fexIpDADtvxXY2JtyLDKyvo90XsoM2036gzy7JolWZCJi/dc8buWGPQ5XjBTJcMqNNMiE1efpxaMzkzpgw==',1,1,'',1,1),(245,'2021-02-24 18:14:00','2021-02-24','0000245',1,2,1,'1614208411864637581','',1,'AAURAZO',NULL,NULL,2,'B001-0000228',0,18,'2021-02-24',1,0,0,1,'XIkqv0FFlolp0O2VQuN0MN05MQc=',1,'FH2YcvcDDC67UwEeDVI1a6d2RSkz7rAay/6fMrI0NEElD6XF5CXBsy6Ggr2AEJMBFHcpdvWtGeACscHy8q7XbMLuzJtLpPPovTpWcLAFCAX10WY/dvqQhTZ7LR/FK3LjUcSBhpim3rm0xAgi8nLw7qu7j3EHtvuHX8edBewY22BHgfcg/B3ZMep0wmbsqeUzlnoOdv5mr4azbeFmqyPmWKwIi55C/D3HoRGGDK2UQbG/E+p9PdbwigYdCKlOLGY6uL0z63wcQ9QbbaFYv8C9B0cXHxWam9n3LLcvzqVStgFapa7HysaWBEOkQkAYHh+1urdJh0bDdJIXb1k8C8bHHg==',1,1,'',1,1),(246,'2021-02-24 18:14:36','2021-02-24','0000246',1,2,1,'1614208442986116299','',1,'AAURAZO',NULL,NULL,2,'B001-0000229',0,18,'2021-02-24',1,0,0,1,'7mPEATSJ0Twr1IR7M8jkRTd0op8=',1,'UrXFCDBZHDJH9A1XwHBxRz2i7AC0CvI3iyeKZHf81bec6mYWgXletgsPVIYj+bh55nJXARQI3OR/5GPHsr6MD59qe4L35E9fhiX5hK428CS7OLsBtZiblWUtc/fRVdwyodUUIrD7eQWqUdQT08Y9xq0uU4jNLCr5cHN/+n3QSq4sA/wHim5MojtCLX62lQ4p44KxhotF9B0e+YeZxIWcZgWNr3uQeRy08SOCyKvXoQqe/jbZw9CoUsUG4BCcBPkVK1InlYAK7+77Bl2L3JyKOobNWsidodSXp2dVV6qlF/zVUnt7BphInQeuo4lYWMurPFZtM7xkKfMrm2yZbw5CCQ==',1,1,'',1,1),(247,'2021-02-24 18:15:04','2021-02-24','0000247',1,2,1,'16142084781081775949','',1,'AAURAZO',NULL,NULL,2,'B001-0000230',0,18,'2021-02-24',1,0,0,1,'dqnBe8qpw20fV+Xh3m05/halowI=',1,'YXXB0xxl6B0AfiXLn76tmDmw4lsYnHpdE3Nq2c/NPd9k787nhujq7RNy9v98BwlGftFJcYVWw21LXH/97aZgwpt2pSHWSXmQ7ARZI2ZpcQqnJqd6BPHaOlg8yOj/X/kvjgJ1HfcPe5HDR/2/lNP/6PayQoeIf95NqQsZGx03wjHpnolKOn2jvWHWYMjI+8YxRPh4gteFa8atkykvjFrZG/MlYfBe0crQ9Lw1snY/bTXLpOispn4LSdKIZdYKAlS5ycuBM9Av/79UYzbV2RA80kqseoUWF9eN4gVtzIV845SojR8uinBXey15OOlTXVqqRqNN5sDWuXWQuNWwpkp7Fg==',1,1,'',1,1),(248,'2021-02-24 18:15:25','2021-02-24','0000248',1,2,1,'1614208507109472852','',1,'AAURAZO',NULL,NULL,2,'B001-0000231',0,18,'2021-02-24',1,0,0,1,'KP77t96Q5lfU0RdeMTP70M3WlhA=',1,'c6v8/9rnX4TtO4iek2Kjh/Y0iNlSnaelY5Prz9nDEf213aZMYvlV4nsndKX0XylL5AAqdT9uiq2ugeAuNgzL3g+GzVo1zh7T0X41fYGtLzWuKN78n32NxN/+OmJXmfgGBaCqpyzDKNZ50XYugupsd667s1QyRqdi97Pk5ov9WMMpc6vg1hcbvjzCSht7Mb46X+6TLttyYQ/cZg2gAQiyyugHukLmjdzmb3a6NlSdJYF/jZuEp3Y9JBvP38Ctd/0ChGw9+gTWgbqmYNdVDrCIKkbMc8hMkN/9pKxUQFX3FfrKwNHLpHTALjGTEm/uX8UGKU13kciRAHlagJKnlsiwEw==',1,1,'',1,1),(249,'2021-02-24 18:16:03','2021-02-24','0000249',1,2,1,'16142085281217928504','',1,'AAURAZO',NULL,NULL,2,'B001-0000232',0,18,'2021-02-24',1,0,0,1,'2qCgz2547elODxLy3cALxzQ4/Yc=',1,'ar4H4Zw/dabEkTP/vvDdOJMQXwf9aqt9FIdKHoXLomYd0oU52g8EajyOJZvLwh2sMGlvYLBjrFI4wvUYXqQ9iPkaiAAeJTVhOpHCATog75NpVr74/NvtA9F1epJtcRUXGWPeyEaAAuA81YEjkgprTXFDVG6LE94Q6uGpkxw0yhj/3+qq/Y7lXBCIC8ZcqJGBwaJFiiJ8t0BrfN6tcjNS8mvSkTBfnlz6JKg5rCa1/SJR+y1YG/0+c4jWUu2DByNLKXn2EdSAcqjrBcUAmDBxkPiPDim5JJ7fhiRL9+r2ABvt2arNbhiG+DELNq+Uoi1iqEr2XKHf00KPLsSnkcvJ3w==',1,1,'',1,1),(250,'2021-02-24 18:16:57','2021-02-24','0000250',1,2,1,'1614208566958145641','',1,'AAURAZO',NULL,NULL,2,'B001-0000233',0,18,'2021-02-24',1,0,0,1,'BLqylM7NkxD53NjBzSFKQnVs1Ls=',1,'cjEpckRuWC4j09pwV7LjTEODQ06IoNr268Fnfo90JdZyXOCEK6Zcz9EwBkcHPLJ7k0Y5BCCliQu3torcU2sfHyx+SI9gQh/Po9UdxwQNLZkCac1XNVkNV30jWwHsAQqDqnJs5BH3YERFVJRedXl1qNF9rthwNAfukhQecqgNGDSPtPpgzFfqcc95ltSEd2QoTI7oCvNk5kPbrZIolMoSD2lWBnk9uOW3kXwXcsKn4yvFpyqL0SsgxW8uf95x380BwDNGmO9XfL2rOOGW3zJQDF6Vv5v8UMlgkaFyhqul1hxeb7OToUuvST/ktHJjPbY5aVjJI9iFHlDQ6tBO7hjCaQ==',1,1,'',1,1),(251,'2021-02-24 18:17:50','2021-02-24','0000251',1,2,1,'16142086201108972034','',1,'AAURAZO',NULL,NULL,2,'B001-0000234',0,18,'2021-02-24',1,0,0,1,'ZxPt5CaLhmhRF8pG9E19VM4ZYDE=',1,'UQEJ3LA5qto9QrJQR+XoUVtFqoy46o4V5X0q2wbEYVA/yCQmTXRBQ0sgEIYhpr4mj81M4ch2dO66RJSQa8PkE9qu5NVhaFc2ZiEjbcOGZ+fMcsrDcGltbh1grYMV0pWRW4sPJ6zGm0V6EXsWoaweNUC0e73ASIlgAhDHoGKUblSFWV2hG+J51Bd9YtPswActeL/ntMz1H0MsrO/RbJIb4eckVPJXJm5evjRcJOOLToO7UyXQsOulM08LYUdOAJ/NRzs7pSxJRsIhfCiJoEcWW+nfec/jNRKb30CKiVjuUMmyQnODZTCWX3vytDe1PdElD6JRMPvqFmy9I5tFgX3dNg==',1,1,'',1,1),(252,'2021-02-24 18:18:11','2021-02-24','0000252',1,2,1,'16142086721264015542','',1,'AAURAZO',NULL,NULL,2,'B001-0000235',0,18,'2021-02-24',1,0,0,1,'Mgz2bNTCOK+F/Gc+/p0wELPO9Pk=',1,'Lf0oVl684ydEo06BSD4GDBZtEE88/7r3Gzt55YFT55yCT2oZdHXCxNWM2qE0lWMXCwYzGElXRq0w9RFUYZgIte9L+HGSbIAUa9/se4yFADUhuOxG1Cn6uQNjuBkJgV4dBVHJVWO6RFHKt9FFTzMsJKvrv1pEOlcHGoMk4dcvdXj8vGbK+B/92QF0wgfrDhy7sqGMVFuiO0sRSmUeU2n5UD6PRsgfcuocNXuU7d22WO9Qa7vXomOwOCfmCKWln19tpTKoxhQhrY/+ksnkoY9LsgcjQ7HzmNuGazhBOYdUAH80AVsIwusKheFFDKoBmMPYV3/Qo8aLt0EbHPJwogvPvw==',1,1,'',1,1),(253,'2021-02-24 18:18:59','2021-02-24','0000253',1,2,1,'1614208694481439569','',1,'AAURAZO',NULL,NULL,2,'B001-0000236',0,18,'2021-02-24',1,0,0,1,'8n8ywClYNCTAYZO+PbDFaORgIKM=',1,'f5EMZ9zZYb3/6gYeTe5BneSUWQZ/JM72DqKlE1m/Ftsst9DavqUJmOu9ZgO+ODZQVF1XYWhu1ANyVKfbehHfRqsF7Qs7E1gisONjSLtu8+O5N8kRmV3TSJBj4q8bR4q6MVZ+G33kaAz9SIOuMJ+m8f9gPpTEItEMn4erqE6G+AEqCGHsG91fbPAxwW8e4SrxKMNJuT4M3lv6tDmnqYwHrzhyoK/cx2hnBrl7Cddlgd86MCQMl1y4wbtgzorZMhr494tdXNt/cZ7etgJ78gk928A4FL3XwrGzhwvw8V1ikBbz6B3CrmJHKKRRTf5ViAThrfjQO2GfbOgsR+FoH8x/Xw==',1,1,'',1,1),(254,'2021-02-24 18:19:25','2021-02-24','0000254',1,2,1,'1614208742684506544','',1,'AAURAZO',NULL,NULL,2,'B001-0000237',0,18,'2021-02-24',1,0,0,1,'y7NSDvM6eQMPOmogJXBotT7CD5E=',1,'L3ggnEAvDMjBfG8eTh2s9XbH5VTmFeX19TPY8Hp5cZu1HjVzF+lq+HaMHe95kL709YoVWn7x+GrQgz7GG0QDSbISAdcDusUunzCuSKom8QyFhSm9F11GG6y7Ck4a9ekGwluUqGwPENksOTrr5vvLNdGSgkdQoSi9MHTIg3ApL8XdImNvO1kFeLj7Tz3h9EvGhgaFksVh+d1eVM+SHUlKIKVStqknrvtIzk0YxZMw4gs4SE+S6FCtQLGi6efkdnBM1Nszsjei0T5me78HsUjG3TyI5cw0CKmpPraSrxIP3CCH82MrM0dTbtviixsIe+H5AfkX1ZxHBdxrmu5T9gc7ow==',1,1,'',1,1),(255,'2021-02-24 18:19:46','2021-02-24','0000255',1,2,1,'1614208768821993085','',1,'AAURAZO',NULL,NULL,2,'B001-0000238',0,18,'2021-02-24',1,0,0,1,'2lqOsut8C2PZUAVqdwk6BngSgf8=',1,'T3v72SFmd5OrZq9+nC0o+SrF4GcJWscHku4/IHK+jwSR2HcRrfIuU4t0sQCKzTIk3EKNzZBO4sgBwFCjA4tQ+P3IDhzROivbbpxvOKUoH1nMFn0SBYHGilpYHgKOJNMe+9LRwEjQQk68wdCy7yW//DA3MeMwSVfYGRElNCejDlEuKmc8qSu5eA5lS++LIYVItdoUSnBvob3lQ7+TqQj/RX1kxhs6ZFlL8vpwpkqY6M9b2cVv6evXJUB/s9+NcZlIJJqI3YRE+wHT3pKBv0hakse17Ip5WyOU/Y0pxl/Qudmhh3m4xMxCs4ZETtT9oec3B48o4LEiGtgPmF3fokVLMA==',1,1,'',1,1),(256,'2021-02-24 18:20:18','2021-02-24','0000256',1,2,1,'16142087891251235103','',1,'AAURAZO',NULL,NULL,2,'B001-0000239',0,18,'2021-02-24',1,0,0,1,'El5yRU4F2G+gk8Ymi+SrAI0W7zw=',1,'esBM2ksodEbnPQnmKOeVgXuXJTzJKLk8JD7tx1kDmE9vPYFElHPFDtp3eQvLPPJ4sLr0W3kDVZicr08Rzr42rNXiete3NlUT5XpT4PT2jVYKW5bli6cg5Q3QL78Fl7n5c56IlAp6g6UopfUGV5FCfHxmXFc9eREoQx8vPxgk52TjxyVzFT7IbwMThfELVmtg4AUGeWKPS5S5pkCO5tSRSR7sQ4u5g/Kk5ItF/aV+1Y726vsCSdsXQWxxITSxKYKbiHW6q5F4Ejg4w3CLLU9vwaOvMB78GsqZG6xZMrQylLxmmdCO04WhyVyOqgoqErG/hnRt+895IeXo91NchDrIrQ==',1,1,'',1,1),(257,'2021-02-24 18:21:45','2021-02-24','0000257',1,2,1,'16142088701081991107','',1,'AAURAZO',NULL,NULL,2,'B001-0000240',0,18,'2021-02-24',1,0,0,1,'kpW9kchsZmeAIpyaTrhuAOuM6fI=',1,'TAIPSlL1aw92HNAfawhshAd6R7I/R9NknVjt6wD3uTGqY+tKHYMTVcMk9aPo9VJlT+cscpyz1GKBhtKq7x534MRA5GCRFi+8fvDCdqnp+oid2A2qz17f9G6AaGHd60btU/MJZXoUwiBkeKuIjIsDNUuvazmiwtA7O9E/NcFkvUXsgk9sOI9ElTfs3EDkoPWTYFnb1OQhPQSw3HyAgi4dgPk876uWQYUWsMTaLapGP5TFOkfWNVkgdoxcJw+nKNgy/SAqGzWfHKMmUeS8kKMvrnNyJd2qcOxpoxv/+EBJzcimP8bawms9yTQrRR/p1yY9ID6EEZy5/MJ/5x6S4y0MyQ==',1,1,'',1,1),(258,'2021-02-24 18:22:37','2021-02-24','0000258',1,2,1,'1614208909633040534','',1,'AAURAZO',NULL,NULL,2,'B001-0000241',0,18,'2021-02-24',1,0,0,1,'22NERjn99pxfSEd8quNqpOy9PhE=',1,'CCH3GjwtVP18PMBAACCNFkJ2xEre9UgqpFVImUDakQQgqh2vEckMzFbp4gLy9EGdcoC4WpIvO+6uJcwEDt44htaCZmvvNrUVlcMFYUQcT8amfHmHp45vzA0eG7iym2zg9VeR8w70d+PjbyMmCh572MjEoVwppoSPMbGdvF3ysCEGwHwQp/cvThcECXQoXYJanPMhlLKNZdgko65CEmS83cZx6Y5F0p8Oj1KLDXA+j9mNhmCRD1I7Zh8tctwRcbzlKOdgE2TJNYlFCef1yCEUW8Ea+YmMaKMLGc1Z3MS3+GEA45iERup0/Im8gXCtidSXH7v7feQFowy0Xcdy700a9Q==',1,1,'',1,1),(259,'2021-02-24 18:23:24','2021-02-24','0000259',1,2,1,'1614208960495812184','',1,'AAURAZO',NULL,NULL,2,'B001-0000242',0,18,'2021-02-24',1,0,0,1,'o7HeXdDttZpFNGKiJssYExw+Xq4=',1,'QsMKa/dMsJxzNxM4vXw3QM4dJW077XFh29aN85AvCFd8YXkB2MWjZYC3OFstE/BbvqUwBSro/GXAVn8Ps/EINX3dsPaR19qlSMlSwQeVHvE/tCj8xPdXQMcpGnqn73UNld7QMd5K5JWdv7o9giLRzBxTnI4zN5r1K74KNF+8lD0E3tmHudLJm1NFaOWeMAYZG7Tbdt3Z7eaRbanAqh+/hRPG6DrfGeolJkx/toq3Vzz+GJwH3MU9iFWoQJAizjiqmSjVQ+TepbfS67Pl2LHN8Eg/5CU1GIXU+JPjuQchHtaok+Q2zLPcuCL7SB6IyLY5ODaQVzVGwOXaeSdmPwCHkg==',1,1,'',1,1),(260,'2021-02-24 18:24:10','2021-02-24','0000260',1,2,1,'16142090071300721651','',1,'AAURAZO',NULL,NULL,2,'B001-0000243',0,18,'2021-02-24',1,0,0,1,'WSZT2MNlrBFZbc4/6+vor95Qe5g=',1,'A3zzMJ48ehtjxZXxHzCpZL1EOpkAAUuUd/3fytRXfpFqctNdqZ8+XuJ5ztkGF2RMyPAJ6YzVUj1+PEQLUhBmuwuilcjZ8wAUV6BOOQ8hjymrJHrKgADX3sDGJMQ8m1Wlaixl+1pjBOEj3oEX3SX45GOW3Gz7MeS3d19yEvtncwumXs0wdUvYsC44lzOXy3zgyildJJW0zOqrTmvVpNiHVJiO78UffCIqvm0hhGQKf6dF3/98+gjaxsjdW4u9zj8T0CQl9Nlhr1Lnkps0H6CrhXEpUBAqSn3l9qMvNCb0VD+y0IgEtu+pfFjA5twxGYF5MipmgKrjoUl836nVqRATZQ==',1,1,'',1,1),(261,'2021-02-24 18:24:34','2021-02-24','0000261',1,2,1,'1614209053708475246','',1,'AAURAZO',NULL,NULL,2,'B001-0000244',0,18,'2021-02-24',1,0,0,1,'uRx4eJUCCLrdL7iroHOATjkqVAc=',1,'S7S3cTOsyTHcbL9A6jk1rJlrJsz49Qgr4drWf0mODbpykgip7l/EzXCslm3tjx9jjYzsbPLud9S5L4qrUtLFfmQRX78i+m7OfyIZxf0WiFZKW9eH0utsV+j17xC8Xm15+jbvIZmM3yFA45VNIg8ld7hh1oaJF4a8kb91ViM+4Oq7XjhW+Z6J+UZNXsX5+md8DNIAy2vR221HJjwxl3sLAgASPzUeB/D6iR93t7VHBIc3ONfWRblV3tsheBSCXReRWjgnJnn2km9ehjq+lJDDlq1665tmPeLSrO1bgqGTikx6kvFoshp50cIUmkc7ItJIQPAhSozMEZC+p552OwoM+g==',1,1,'',1,1),(262,'2021-02-24 18:24:51','2021-02-24','0000262',1,2,1,'16142090771062325583','',1,'AAURAZO',NULL,NULL,2,'B001-0000245',0,18,'2021-02-24',1,0,0,1,'shtGNf66Zcv4/XFvcQoMz4HF2RY=',1,'BqOlfs7AT6x+6FpN5/IOabo6NKYvPO2CpBlzTC0M2zgxO0rtGUU8s31Gv5VRSzxxGApckD87Le4TCRNM74V0bZX5NBMFKCYe8duIVPipdpyjSsZFvulCRQvtuZg12Ypxemv2mUFtzbEUNGYdg/8HwMzhvAhiqwaVwdqoDoEkr/A7Sl8QQaPO3SVMh/Iw2dMsViThXW3FD3JYKs7Z3vY5pAGcmXaG/yG4RzEKeh8Hszc3wUSgBktsAZLp7eJBhRRkjKO2K/9eVm8rZbmdKkJmIIpuj1HulghOtP+ePeyqF1Xk3WaTlbX0Tf0VQhHu9cJ4R4SWqJfhUvnmrSCmMMqpxQ==',1,1,'',1,1),(263,'2021-02-24 18:25:30','2021-02-24','0000263',1,2,1,'16142090931038055659','',1,'AAURAZO',NULL,NULL,2,'B001-0000246',0,18,'2021-02-24',1,0,0,1,'Fpmou3AxnRw1bHNFe8qkhGIQLmI=',1,'d272c/3x4wLz9af95KnjgyJ4VZlJZTKcXoFvwe/gCpJjDuzAnpszJdasNWmEE3jb/WQnTQnVAwqePK9XcvTHjr+93Hi3SOnjXb51mXyKExGupnZg2CO5KFS4tUXCicCyQt/XYOjKfnLS6PuFA8MOK7vz/RbNBKBxjr/JxApopr1lsRUWORbx/E7YZr5cwJ52bmjNMt8a1QUKOXWIDrVIn5mh0GZxL9xeWCfplj/YDgESb6MquGzl9UwmGFEVn3ofR/pngRiqxmxyHIBwg1VaAYZg0tS85eZkZLFW8r7AD50b10Obr203r8S6yTxK+6zB4v0Ndv/SoYx/VZvcMsPtaQ==',1,1,'',1,1),(264,'2021-02-24 18:26:19','2021-02-24','0000264',1,2,1,'1614209133303890439','',1,'AAURAZO',NULL,NULL,2,'B001-0000247',0,18,'2021-02-24',1,0,0,1,'sShCf6TPH7HejQVWvX6kWWR2GFA=',1,'JMBgvJPWsXunyHF+n+0UZEovoGOVqNkibNI6HyBXZjDEVqu+sInKH40ogK2wqtxUcMv5z/I150MjsAfs16l1GyJlMYcn3q4Ns7HffInfXwrE0DSjBU23zKzxuScwLO+3AQbnBp+6rYxQlwtReB6JodQKEpl1hiQwUv9GTNC9WUBRgmRVyEK2X0hoX81qLCkhQfNTFN4fA9yTYUmyyRWoqICwvc8du+eXxVXoWJAjZw/xqfm4DraTblBkxoNQ3r7MB4JbjJ4rACYZkN2qMm6c5KVRYdpBn3m5SV+c5sLFY1xJ24Bn/LFcV/YP5x+TlwDHJInyfBLU7ji2eZ+SBli2Jw==',1,1,'',1,1),(265,'2021-02-24 18:26:47','2021-02-24','0000265',1,2,1,'1614209182192179935','',1,'AAURAZO',NULL,NULL,2,'B001-0000248',0,18,'2021-02-24',1,0,0,1,'410MM6ZguABtGlhOZC+6TjrDqq8=',1,'Epaw0yXH090UDDdOiGhS2UrnvDmOFn7iZiS8W+xk0HR7PIS8SavGiZcC8UG+MBGOinQH6PzT2zdbQ9UOXU3Ia3UiCADVfxybCGoSn/XVcHHcS9bS56NtguUIqD7PG2rEd0G5Fm2geUapAL37aBL+wchXZATOjPnEel3MoDt3xQgiNzA1vGlRVTcj3CKRSYLjGF0RdIVaUO2XDHPym0x25bOUS/n1Agn5O+QVfmiK5QyaPTcAOyGh+O5auXq+6QfDi/YsNRP1i+Ep7KjoSqcPKKOWPLBRNn7Cyx/RjyWISWO9UDSPAOezQGYQVrzV3VFQBfMl23A8mWKcpYw16PpB/Q==',1,1,'',1,1),(266,'2021-02-24 18:27:17','2021-02-24','0000266',1,2,1,'1614209216386554491','',1,'AAURAZO',NULL,NULL,2,'B001-0000249',0,18,'2021-02-24',1,0,0,1,'yd42peVZVO8bp2Q0X4oDOdF3fq8=',1,'D3b3Uwokl4FV4ywiEErSMeevbtn7RZ01YIRBVdHIyBzZQUj4ehxosk3pBD94h1K1W0jRQbO+WB6Mdw6+XhrZ6lBRJHiANMhvYqs10oQFLSIo6IIfgzuC/RVBVaOotZ2hR4rz5Qz476Q4yRntrgGzy2AS4YgJrjDVVOlbGSJqBQPpFGLqys0VvneBv6RI0b/+dAyGt2CxiZsvcvK5voFr5dJjlU43Vr3DoCFhea0iw+NEyaLZUK47pADa+Ej5w8xsPp18/OABzm3f4FTVCeyXrHDXjNc0Ko2maCJ9RAW2Ici9tdFGTzcmebljpwxh0QV9J7f1MQ2gbDtVVDClcPfCMQ==',1,1,'',1,1),(267,'2021-02-25 18:40:37','2021-02-25','0000267',1,2,1,'16142961501175800391','',1,'AAURAZO',NULL,NULL,2,'B001-0000250',0,18,'2021-02-25',1,0,0,1,'1cMlsDYOp/cahMCXlTzE/cmptFM=',1,'jX95wLo4tBJ6V2iBxbS2lC7vuIi7eIpgKXfrBQ/FyxQJQzbHdW+RhIB+cVwlIDlSApLbgh6utkVv\n7i2XMVjuYDrd3k3m01nrZ+D0G7IzYqlOpXupIvsc4ujZoMlhwHpmGKFNNBUFee7stHDS3065TjWM\nmoF/7Y5Riw9v3YQyMC17tDz+AGVSsW+T+58DLozC1arxadxIIJuwdZdWKDmgUoZ1UCTiOqMkjwI0\nOK98fiMABWKl5pLhC4uiU7S9SLXwoRUfW5a30P7nPJMcVw/c6bfAeY8J0s6uYgIVZplLeS+kCGOV\nQPjJ8eRjsYsqjBgnotCZsTp+o1Cq694vrb+pSg==',1,1,'',1,1),(268,'2021-02-25 18:41:09','2021-02-25','0000268',1,2,1,'1614296440515477708','',1,'AAURAZO',NULL,NULL,2,'B001-0000251',0,18,'2021-02-25',1,0,0,1,'7no1J32vhe6ceVplyuA2ECZpTwE=',1,'P4c9le9OjqwOUOpDxbNOBcSOlR3p+QBHhn+OEjeeukmx7/EsqXsy8n4YCw3iaw5YE27h/ZbPrsTS\nlW3YmKUm6wC+Fq19fq6ho7XjNQtNFqXY8wd0/K6RWsxPwlaRB6ItRUnTl5oM36fqAzf3JBp06VIC\n1FQijK66wr7a4tQR5KPaa7nPd9JtFwwKnE0LF0oOKGMvlz/fSpusBZNDBWTA69jCrNyU6mGDr8CX\n8+do+9f7I7F8FMfRjQQWTl39pyua7h9azwuXAHCjxdXBiZwDVMa02gnt3o1TbHKxfAF05QpHGIn/\nOZ86BWhn/IxXMmBUVc4P1a1CtZElRoQQL/llDw==',1,1,'',1,1),(269,'2021-02-25 18:41:37','2021-02-25','0000269',1,2,1,'1614296472896696258','',1,'AAURAZO',NULL,NULL,2,'B001-0000252',0,18,'2021-02-25',1,0,0,1,'m4W7Pp2wAQQAD9V4YYRSs6aSucA=',1,'gpSDErPGoTr3UPLirKh1sILozF3MK5uAXL3WJpXxdpDa9knC+s2WdeDyGwKratCVyqW3YhJ4pJCX\nQenjq0ni7DLy7lbxxMPZuiAffcm4+cWdGr2udThq/i6yUTksruuLFSxB5epfs6CdqwC3Gac4ThBo\n0lezhKVYPd2L0lcrNkXV7xmVuFFUhCgbEO20BNlEaSOeUbpHox7GbUt6mNgPANz8n8cx7rt24Hjg\nQmNvIhtpeKHaCV9NO6JCJDLwy5yWd93hXcNJQVNq3kXWbKbHkJA+aiyZmEkelVJcU9qt9KKaCr20\nGGwLAonzGT7K3n6S18ytMdcyDA42CdHRuTy43w==',1,1,'',1,1),(270,'2021-02-25 18:42:07','2021-02-25','0000270',1,2,1,'161429650037695841','',1,'AAURAZO',NULL,NULL,2,'B001-0000253',0,18,'2021-02-25',1,0,0,1,'lmgl7mi20EDZyOmUf95tmWC7GCc=',1,'Pn5vWYUdVS6DQVino86pvkuhsshbejMqwM3csT38eRjGauz8vb4JwoNTwufXPZqmQTlWxVJzLl8ZQDK8MmzsBARRUTvbDmyIS2aqd6aUN9JoL+upWiIDQ54DxbYByed8NWW/P4GsQHpc/jCiBduM2wEYFHCW+ZJDwSghtO7FZPlQIp5esLoMcZvfPea21RL2Cl7wisbGaU8xVeSX7BOJBxHZWkds8S2Dbnac1u5Y8Ln04xVfMJrnnKPVHIhwWUud7HNY5ky8YP1lAR3Mum8I2aaQW2UIxINdYA2lPxInuQlfq5lTi3CY8CAREAh755lUK2k1hSV/psxAkyNERm7AaA==',1,1,'',1,1),(271,'2021-02-25 18:44:59','2021-02-25','0000271',1,2,1,'1614296668145490453','',1,'AAURAZO',NULL,NULL,2,'B001-0000254',0,18,'2021-02-25',1,0,0,1,'Ddwtg+wWNPA2+sf+dRTipQvVxvc=',1,'eKyqrfG5pS6YmGODuDarbkU6XjhE8OEeTOZYJmLH1LBF2B3/f9JpXwa/bK7rKaRlaPriIuks5haFnj5awEU6NdWFIUKPPmofk2FgHCcon3FxSM0imptX0xr9uKJUY73wuN7BnXcNqxk0WozufOJP81YolgatD6/az0cgTj3lZ3nsDDOg9PJk3wt28kt+dS33QA8CMQ06IEPQo17/L+D51S754LHesglIxmhauaF/GmyIUGaeD0Klwk0d/A8gKbA+KfQ+jJZu48IIlLIep8Z01+RbJA3WytVckhHX0+9uL7E3m9kS+08x5z97NvpTdtq1zvYFm2kX5Yez5S9sYloFkQ==',1,1,'',1,1),(272,'2021-02-25 18:50:57','2021-02-25','0000272',1,2,1,'1614296702487593113','',1,'AAURAZO',NULL,NULL,2,'B001-0000255',0,18,'2021-02-25',1,0,0,1,'XJB1YGig9tTadVJky2iy/HDTjE4=',1,'BS8fbB90ZhnpzfXeZT3hSxfNDZ3D7zJAnHQuLVB41DgeykeY6zhLP9FOvPGkUI1raMIP2iZHi7ZKXvvSrcia8z8vg1CHiCQ1fRmbmf3bl1fiETtma4hyS4WyGwGTOFhjKyLis8hh0QZZv6WY+EJJr2nUof8k8YWzkwlhIiiYC5+HV6J4rgya9TU8Iap8dBMtkqVi4AJJU2RmFbtHhKUe3qGNtbcAL+WyX1EOxwXlqqz+xlDvLy/CnYmSAWvJaGplJ8tmAdHAIwt32AYKsZJHE4OUJeBDwgWw2Cq/xQotckvHT/1JvZHq+H43PSrECh54m/Ao/HD1+54VWcBh7FUDYw==',1,1,'',1,1),(273,'2021-02-25 18:56:50','2021-02-25','0000273',1,2,1,'16142973831171497212','',1,'AAURAZO',NULL,NULL,2,'B001-0000256',0,18,'2021-02-25',1,0,0,1,'h5X3lCF9QZk/r/UtkCV2+eHXmLE=',1,'gibxNpKTa65CTh5VYWxtThROyQwtDT5AKw2E/Jwo9g2fUYba5mP/LKuRNUN+LSfLZK0+js4fr7BRfT2UYwd74zl3FJ/NCXdcsEzQg9oBUqxHW65emo+WWbf3JhxYUuWZ1GydvrNKK8+lWRzFTw4p84g5R7RJVjbwwC0kWYsZZ0LnhXfF5GaW5RTF6vcTkSPUXunGwNV0kFAIRn4C2kjSePuNZlI6Z/Bm5cZKtgg/uxUwlCezlxOUjKfVDIf1V3ePHVCoHIDbVYpxuE+5R40QshNPJlD7w1aWHVnlnygNkl+RVI7ryfSdnrsIoIcTCET6Mn+4hKbM68GDH+fiasolfw==',1,1,'',1,1),(274,'2021-02-25 18:58:57','2021-02-25','0000274',1,2,1,'16142975151264101606','',1,'AAURAZO',NULL,NULL,2,'B001-0000257',0,18,'2021-02-25',1,0,0,1,'ES8cwIJetm7qRgoJAcJax7//mgQ=',1,'b6YaptNp3eng2aI1lHCjq/6uiJk1x/XCfBpp84e/OrtO4MploF3geOlwiWD4U9HwhQb1A3IcHm/DZnX3eQF60P2o4qAZNc8+5Pdf9GralkVc3wF/QI4iP+z/6HmA4l9iYpnWTJRt8lveFe8+owdxKiVzFVkQ/5B6xVyBW4Igwf1nQ5TegszmGLTJds5Y3BgFCQZI6auCUvM/GHi4xlVkyAo2ngvR19sy5ivWJbxOw3xRpcNxwi8gfoQFmqDLDGNgysfruUdIunh3zR3qd2LscHuGndBLsizp3X0uUTD+oarrV1JjFmTWODlEWdyl8Mt2Mytx3T/W8boGG2yD+aJzXg==',1,1,'',1,1),(275,'2021-02-25 18:59:24','2021-02-25','0000275',1,2,1,'1614297540505924652','',1,'AAURAZO',NULL,NULL,2,'B001-0000258',0,18,'2021-02-25',1,0,0,1,'nu0lGVAVvbG98W9AHqIQGq/MeCY=',1,'QLafIZg99yowRrqcVerFxyFUxTUz85+HTku5zTAjYvtF4n7QwW7kZiFiNx2gIu5qt37NZLjEO7i7GXOSnXVpnVg3Axdds0bxTjbBG/iLuKzgH6ZxswdQNqtgLuzZL2kZXoK2q//Yvh466dDyJv0PvVLXzPCiDycnYb5Lr74YDD+AWBpj9c59TThnNXdSUOuh+43laUDWR8dh2EjBy+Gcep9tNdSzfWGb2jrnuntURzbbExNNydxX8a567juA7DYZGcCnujjep9bbu3LRsHfdYxhVmvYMog78TP+L5rHUz5mKRQ/UF2wmIUfYlWeFUik6tvt45XQlqJx/bSUsyI2roA==',1,1,'',1,1),(276,'2021-02-25 18:59:59','2021-02-25','0000276',1,2,1,'1614297567489529544','',1,'AAURAZO',NULL,NULL,2,'B001-0000259',0,18,'2021-02-25',1,0,0,1,'PUUYkdMpX1ryRrONMxeNzTuWeMg=',1,'LGef95BC8ahV3sb1Hxe+nhlMg3RtxqI0cVXHkHzO9ontDsDmtjRX+F9j2APQjnsL/hZhQYuGKcZNsV6aZI0+K0iGHTLmX97musnediXiKetM2UY5QJNIPIsiYPnTTnqxOoBErcab1c1fOHa9FZmomFaUKVl8FCyN0l80pMOIPAEuo1abhwwiYylHZgEEU7b51nwQIdNEwfeICnKnXn7MxgFzLZhEGNaHFRqskA5XF07jvbutJX6FPIAJYPsIKtQHEat9wDeZshuwIkGqqRDo01f2uJSfezfTyHNGo2LQ6NR1Wt7ZhLSyBFsRJ8UbHQJCeAlKd7b9dA6pz2jQapFlhQ==',1,1,'',1,1),(277,'2021-02-25 19:00:42','2021-02-25','0000277',1,2,1,'1614297603131892410','',1,'AAURAZO',NULL,NULL,2,'B001-0000260',0,18,'2021-02-25',1,0,0,1,'Z8Y+vbjdKyqBoU7fWDDT6nHAqVE=',1,'h5f8B81VWX/GXd8F17Yl7T0ERjt2m7tTdVVoyX7ZkTxS9OpwmkNag2jmi9MrrokdxD7wcKvsFFT8VUnBDSAqjCA4+QhFeyT6C8Ggi/muEgOB5A8yi7OSk7aoZn9i67TjEHGa1686kdbueQLQOQ9rGGYzMAolQXmzykN749gmys01dIegdnrvHyxESBqBnbbbMuqsTTHp19EJjzBqfrruO9YLPWD2ZleT05mmqmU0w+zdz01wmSb7UxoJKpbT9Jv4Ih5Xw9FVSSn+CnP5e8nd8Z0rW4+SbZSIlmcoCZzwpTm2TrqLOVP+Kukr1jBYcFBq+pd8durXv8cXHJW4Odw1MA==',1,1,'',1,1),(278,'2021-02-25 19:02:51','2021-02-25','0000278',1,2,1,'1614297749914984765','',1,'AAURAZO',NULL,NULL,2,'B001-0000261',0,18,'2021-02-25',1,0,0,1,'lNXd8wumiT1w/rdXLVgpY/5iFSs=',1,'PBYau+XsevWUx/L8EVfB2REfWBGeYWPhkDz0+QkeKpDtM1Srqi3WCbPP3Snh0w5JJ9ZldpLkVCZDwpOEqevBML87cF+YMU9q+/ZRYYn8DXwtuFxhR4L03yFMnb4FHwTYRWBkr5tF5ABHCRHe7W8nJaw7MRXL0oYNB6qCr36j6W3vSU300KYzY06Yfs7wc0JB62AM6Fmu9fFTiaTjomFokKlNo0qbihoTybHfjXnijNT4fjHKe1CstyF7kCr3x5MDQELzkK5JBHU9VUtomJ/rOgRjOyRqCAY8PbQnyYwNWBFt0jlSc3poyI6ihNh5XsFW00hYCK5+5epgoVNWGnQP1w==',1,1,'',1,1),(279,'2021-02-25 19:03:19','2021-02-25','0000279',1,2,1,'16142977731336136807','',1,'AAURAZO',NULL,NULL,2,'B001-0000262',0,18,'2021-02-25',1,0,0,1,'IkNrSfhJSbLDzQPpOm0yw2pl2/E=',1,'NbycrqXGa4JgyrBg3+mdO75vGITev95QckbpNHLxxzKDJAQyeFQbC7aNaFleCqi9YNovfAEDvlNla099xR7byQazFEjNto+brmOFmNWmnpZm9XyY5h3aJOX9y8lK1ytjQRm4Yo3cvZ4lKAfDWislwpLAZyHzBx//JHBTlTg1uJmsnOewkXpcxaeCYjjJwRbkQbFll1anp17eCnbp1HK+NsbdGJVazpTqWTh1jX4xhfSZ0sHKO4rr5YfobmHP3XwhEM5Zyq8VFVdt43bL9i10MF2pfPpA1XgTNQWYed/We7SVdnxRPUmrHwy5DmPckdxQ22/WyzKctQBDUkU4PgtiJQ==',1,1,'',1,1),(280,'2021-02-25 19:05:45','2021-02-25','0000280',1,2,1,'1614297801718157397','',1,'AAURAZO',NULL,NULL,2,'B001-0000263',0,18,'2021-02-25',1,0,0,1,'oHigZW8cVvtTN18Wr/HufY1O0mQ=',1,'iLL/MWS7eegevZ2bzr9EoxlZjreGoCuGshiSubbZbWF7uYsspC5ngb3fG/at5WaeImsovFXAMpQ0jVS6bXgCcwQMHCOMYuEyDJGjI3RWP9vXpTpvb07o5co+oQFRMsF7Kfpe77QZa9i2kFGNF3eDCfaySaHGAB7f3017PORbcO7g/9HbYIFu5leLgtQyILqSuo5owlxHYfZQPUAUh0uErk4OBxfzruCFOKchrsWYUCMXUo2Q8b2Yd+dzFea6/NV9/HiTIJoJ0DE+iHcYjM0775xDjj+5mo7iAwNteltm2tV5H7qDyvmqDM2SfkxB9tD0Ed3GxP3zWgR5BOexsjXpGQ==',1,1,'',1,1),(281,'2021-02-25 19:07:37','2021-02-25','0000281',1,2,1,'1614298037655632219','',1,'AAURAZO',NULL,NULL,2,'B001-0000264',0,18,'2021-02-25',1,0,0,1,'8ej3AGNXeuH13ai1w5+YHYSXifA=',1,'J4YEgs0HplmKjU2LgwaGxeXLI1PIzU9P7XbiWpYYis7LivHa5eLJ06FDCRCEDvs+zy8nhMkBtm9m/hZS2IcLOecaGqjQq/46ZUZ3tKYSG1vt9wDoBBljrXJ0amHyBrCzuHU4ZHJOXj5dCR4UHSOC9BAJfD4XGaTnjcp7vqAeNUn98Y68STz0ktzVFD53NkI/JBxBpERFU40rJ6ZkE3NxpMMNkJqlifhCp/0py8aFB0Z0CTbMSbrg9O3rWXo1SwkDM+71r5W/LBjS9IIclWxGg1Ku6aMfzVe9z4T9DSOmi+U7ZYwNmOmlD16G+NhI/D9xcOIAFfCqMDFVrivDl/K+Yg==',1,1,'',1,1),(282,'2021-02-25 19:07:55','2021-02-25','0000282',1,2,1,'1614298059348213174','',1,'AAURAZO',NULL,NULL,2,'B001-0000265',0,18,'2021-02-25',1,0,0,1,'4oU46S0JhzQI/eMCPNZEK4gNRWc=',1,'h2XSaQwASDvhh5t2ZAl3LGBOBSgl3k2JuVjpXxKmmvb9aFoWdObTktTRrKwioPHH6ePte3IOKMe10UdRJY+gNIB2+yD3FdzSOAo9YuFXp4mvzBWZgX/bMr0Z8i4PobPPBt6xc/niqeZB1F5cMM7SyeRGyNmKvMaRJtR+RpY0ntzro7H/2v/ptKjtgONzBLgWJ86ehQgFA2QEQaT88RlFAiBmDYyED4bZI0oRYubQOUtLMvaldkWkpRcbRjrWu3au3qtYLipDluKYtH451HdiJNV5LBRvciA4yHix21lkUVdzpW8+QY/U6qZkA2klXCS446+1U7t+UJAS6SNhGf1yYQ==',1,1,'',1,1),(283,'2021-02-25 19:08:14','2021-02-25','0000283',1,2,1,'1614298077189124679','',1,'AAURAZO',NULL,NULL,2,'B001-0000266',0,18,'2021-02-25',1,0,0,1,'PVXy03vtGKHsCZYxZ25jJk+IVC8=',1,'bp8yr+fGy3Auo1ym+5pmxoNoyrKrSmSr0ct8nECvSRewEniwSR1A3YywktQpvNBQWpwV23WN6U7kce2T8ywSbXykAIZyMrZrPNs0NBZ6hcxknYM+8vol24G1kvjjpjiCMm9LKdR04EnA/xUqfHJZRZ6ypYwfWaLgvruhgK+Usqgtp1E8hXSHmb35ZrnuiC/qAqUG/oFBDGH0pX24VRty2a8aJPDBOcEjYqs7cF5s4R3OHeH2SRfgx3EqJRlYZUFcmUFHU1PeRKfKIBQgxBjBxlU7CBa5a2y9D8RLWyb5FkDE3i38ZlVHLWrfzYEHdDIqYj08Z8pNx0yTzC4/9FgUUA==',1,1,'',1,1),(284,'2021-02-25 19:08:45','2021-02-25','0000284',1,2,1,'1614298096486904605','',1,'AAURAZO',NULL,NULL,2,'B001-0000267',0,18,'2021-02-25',1,0,0,1,'zW+UIIcFEZtievSYs1/o0WvIUYQ=',1,'btQaKUupQK65piiq+lnwAsvNLF3F/Cd1/PYbP2ismun7g/rYypHzy5VaiqvY/zFkcztVdlGOpP4tCL2orREopkriaGn7qUnD7IFhXyZKA8ydOIsaRkMX4RDx/S10CuFzngJExv0MnmoF1CpUXaLUX15sVxri+B+q1kbToQqBYoBNq0ARwhfhRvzX755W3frr+/meYftnCClZf7oqAQ7R8U+I65RAYUi8gUW7dCeGP74pqWy63Q9kgx/IPDIyhFzp9WzryNJ7LavCm8CopDx7dVpCydwHn5kD7BgjSAxkgpoJuKLFcZMLjaHzPyHndGaJRiz6625QrII+IQToGu7wvQ==',1,1,'',1,1),(285,'2021-02-25 19:19:26','2021-02-25','0000285',1,2,1,'16142987451049545144','',1,'AAURAZO',NULL,NULL,2,'B001-0000268',0,18,'2021-02-25',1,0,0,1,'y6LVaylijKV/LlMYO5/sFMIoNAE=',1,'FYRMZkFZCuY0VrbuCOP35EjjRzi7+D63GSFet6EN2ffyEX0Ywhu/8NRLnUSEFMvOjBG1yfUejwRvWq/T2ZEAV5djZ0NO80QjiDoXVTfuwavREoq8OB7wVLBvUNfEguL45ZHJ98SGzeFI4NlskjVnYBnhX7xwFgdmHIQzsuYdXf0fiQHSI230gEBgz/f7jEFLeuOR2dx2NCH6bdZ7y+cdQlwGpyNKr/chw11mj34+rUsoEqQgRJ4TcCR0kk2MO20yBkTzJ2r0H3qhnZFlnutf0FJuOSWarRnjXMitKMYxJIyWg1/KUy2I5zfffqOxiH6WU56zdvMGgH7B56qUVwFdrQ==',1,1,'',1,1),(286,'2021-02-25 19:19:50','2021-02-25','0000286',1,2,1,'16142987691193744643','',1,'AAURAZO',NULL,NULL,2,'B001-0000269',0,18,'2021-02-25',1,0,0,1,'wkryXs58aH19pb8Lv8F9iMGlpqA=',1,'IU953Dx9NbVdzVYedpBNj3yMR7zbltIvlFOlYIPl6GMNuydLCRysd/RKmIO3WcpXe+coryf0aVDlDkAZ2itX6qbUV0/z6uo6ZDpLk4GpAeMFRvbeZqmahhq3a/HHvGzxPOQrECnGUZFztb3ERqf8MeopBF4voQU1mjMAAXi+EIxAIIhc3PQ0tT0NZqzA6KrvEYi06khX9oBh3webGmChLRTPq8ZiDh2mG4nF2Mj7xhHaqpfIfBEqFLXrZjxtOUemg1xGd3fMt9w7jIIKuB2jTLeVZuBfHqLjpiMXAx9816paT81klNXmUFoUCDqzcDjB1Ml2NALZs89AYUuIEtbUkw==',1,1,'',1,1),(287,'2021-02-25 19:20:21','2021-02-25','0000287',1,2,1,'1614298794194159397','',1,'AAURAZO',NULL,NULL,2,'B001-0000270',0,18,'2021-02-25',1,0,0,1,'4aZJBw6S6O39r1/w8CO6WD4zq3Y=',1,'a/aadiH7Lnd5rzHOyF7agZWW+bIhKqlE2WByapleRydQr+YJB6OCkPhyE/ci9ovYB7S7/guOgNCTvLhjG4eVNsUkkRPL2IimO1F7ltapT+cQ3JFecVWD4/QZdLWkqKAOPxnwcHyO+KMgyU1lU+glK/Kid7kGtvbHymjhydEy7lCknVzHE4NiApM+teKPxz8mtdDCTsl0d1OtCUEFCJYMtMBDLXDq9OybZOH9FzUF9q+jOIniiRsGgdmjB45+eCfyN7h4mtccd0QSCX9dAIDHm80/aRMkX2KAIo+Dy69xuQgTcpMuE9IFalVdZtNoQyelThmTnOU9XYB4xKBh6Zf+FA==',1,1,'',1,1),(288,'2021-02-25 19:20:49','2021-02-25','0000288',1,2,1,'1614298824330441048','',1,'AAURAZO',NULL,NULL,2,'B001-0000271',0,18,'2021-02-25',1,0,0,1,'IByP9dWeXLFnBTypaVv4AqKHvg4=',1,'ZVAsiWzgFsEdHv4r8/NRIs4LMSGsyLBysG2dEzjVIj6Q3pBhzQnn396SDGOqBjmebJKxRLpUt3/+9YR6wWGyPWLYt+t25CMkHOK/JuitNNwKNpBCaAyLu4iTfD6wu1km5tOZLmbLdyPQYIIG4bgkTSUZ6KSIFtPw3Hw+L6J2obImZ69QmD+2IRDTuFTV8V4L2+MzRQU7mbl3pk2O5cO/8six5lxf2YCmvpimwKaqHNjQbTpP9PZen6KMgCIqR/OGDgDVbX9IF2DPJlsOXvdnw3qDyqPH8I10xdtEPyFageuDx0jb8RPE1r6WaUFyNv3wAiD1kueqWvz/uJ4U1OQQTQ==',1,1,'',1,1),(289,'2021-02-25 19:21:34','2021-02-25','0000289',1,2,1,'1614298852365339823','',1,'AAURAZO',NULL,NULL,2,'B001-0000272',0,18,'2021-02-25',1,0,0,1,'X41Vjbu0fBJK0114IQSRNvRb2hE=',1,'fcsh/AaEwJ0ixk2wolxCijBHUsSxc4rAa0MjliHU+lzxYtYsr+2FkITaMtgymqscHCM9VSzJUkLYGn4GKYbRpX9KPMW90HqrJxZEx/DgDgNs6fHhwrQcrRRCurqL7NleYHJA+sH//++0X/VEdSXpKqVyeXmWdfQertZZAWirw/4BFn2x+NY2xWPMRndviac/A756zdR5zhgJ0br4lJY0/V/2gs5GGEnxvzJ0NXy4R8+fgXKw4wU6ZdLtLzDOEi6iwftONc/TuxFU80VDpygnZqSLg2deE0NcnO7MY466Ml5uu3xNyq3Esi3VYF7fm9+IGMBj0NpqLvhuq/mn90c5Hg==',1,1,'',1,1),(290,'2021-02-25 19:21:55','2021-02-25','0000290',1,2,1,'1614298898975573513','',1,'AAURAZO',NULL,NULL,2,'B001-0000273',0,18,'2021-02-25',1,0,0,1,'DoV2rXSfsmsUnWeHD2ldnSVvaeE=',1,'ELGj4Rn774a6mU1gZ9w/9bxmr77G9giU2/nvySXm8AY+sxYL0/qfWLLHhGRaiTSK30FmJbZVh16OhuiB2v7G7VarlClNo7SLd7NXYKDCr5mklSA21N6WXtKbjQr3MmwoQffm/Hnlo3RDdf99xRpjvyrFe7KYhFSE1dxeKVQElJirmN1CYpp4U1lhJJQXeHp+a5KCQiZz1GkGP512+J/VOsGT33HskIbzufimzItO5We2m7ybe2L7XX0wzSdezwZfgztlX1sfmJYe/tVNypJ3yIEpNYKwFsd4/oxIQETO4PS6A22NDz2XJB9AJL9ZFXoIHHguqVTNsd1vBnNIt6BZqg==',1,1,'',1,1),(291,'2021-02-25 19:22:46','2021-02-25','0000291',1,2,1,'16142989371312125073','',1,'AAURAZO',NULL,NULL,2,'B001-0000274',0,18,'2021-02-25',1,0,0,1,'0pGkeRjZlXg7mAYoKdb8b3QU8SE=',1,'cBKA7czkqSrRcgb9lC2Yi9MkfD7F8zK8JcJEl2AFuJaYAUB2u6+TajQXtaI+B6VDE+b7b3jIfc7wV4wuzVWnbZRYYKCIaG6Lh44KJp+3hSsr0ZbFqIQQrjNq7etEkeNrqbuQ89qu515JQ28kO7SmT0RleWtlwANOMj8c/UfpdBEv56KEyG0OJwal+OARBJp713se9yw7dojWz44sYCODbamwNIaVX4ZqcRgnuQBZiA40psSKpNdJJd9gl4XwL2+fpza8eXnYsgMTobIwWJLgoPrzR9lif65ZSu4PzqKEf1hjY2fUw6Blyxw7wkNoAa+71VToC9Q3kIMr1PfyK1CCzg==',1,1,'',1,1),(292,'2021-02-25 19:23:23','2021-02-25','0000292',1,2,1,'1614298969427434683','',1,'AAURAZO',NULL,NULL,2,'B001-0000275',0,18,'2021-02-25',1,0,0,1,'0uQusQ2eCcgpUhN6+FV8ivA8hco=',1,'RC7Vl44EPYwoXPInIhPHwOtu53yE5bob+yB9o+Em8+IuKEagxXkkbCqEyD2aAc5VuJlK3pdHxIhAhbGEsQYfFBa/hukqxKA5L//0M8VdIs6uCHbJ43Gv8AWoUU0iTtGhP7wCBWorkzNEILvzTZu2iKFi14R2RPqaWyeuw7hp87u7nvHr+LlfKpYmDADJb2XP+SGsa0WX7CAHrpVJSGVmpSjRLcQ21yDfZl80d87Y2ZwFdTpT0h/u9Zqe8R5NhAuJKM+kiaNEFLWBmIMY1yoJKMUgUWSGjP845OvXrugJI1P4XGvqLP/uZMSQPpKbHwCUM931CcFsC1a3ypebmxXXlw==',1,1,'',1,1),(293,'2021-02-25 19:28:58','2021-02-25','0000293',1,2,1,'1614299006479287980','',1,'AAURAZO',NULL,NULL,2,'B001-0000276',0,18,'2021-02-25',1,0,0,1,'VYANveHLNIQQG7EBbf4w768gtxY=',1,'Tqx82SUzkTl9lMxnPvFCGqMsHs9XaiqZ3yOvof/2ZDnDFrkqZ63JpVQxdSV+G6YCg6iT45SW4IgziSqJxJoVfTw+2d9IuUWgNjKHnkJtdx2GoZt0yx2CL0+zj0xXl6vX5DkTBDJnFhhkuVdnMa6tVBTg/ViWQj826I9KlhtE0YDKJadlnRfFIwXfOhsAUULsPEKSm3KJr0z+MuY8vRfhghfPtNzk0WHI3In400UT7FUZh0WNeMMOS3U7VBAwehoFEBUTsUB2rBU78K8+LysqJTsLNKxZC2SiTT3mCvOnrZxUgS6/xCO2tMiHNDPdkJEigaDdxu8zBMJD5kadQ7awFA==',1,1,'',1,1),(294,'2021-02-25 19:29:30','2021-02-25','0000294',1,2,1,'1614299349671209724','',1,'AAURAZO',NULL,NULL,2,'B001-0000277',0,18,'2021-02-25',1,0,0,1,'+uC+YnA3Kp2KGhSP6vJZ/OlYjDE=',1,'KO8u3ySt4tANpa63Ge5q7zk2xooVvz+Ew5z3OHBaSdUtESSxUXR//1iE7jfs+83tA0VIE9pQrrcB0tGXPZc6klYhw1z1J9VYUPRvxT+60xRgXt/66qSF1lRk2IRcqmK+XdfpkRUyzJzXRNQEOku5Oij4GZrZUC25c59HFW+/UsiOtV/GjMIzFeIUYp++mE6c2Gs9buXnTommcodwNYxNf2HctVEhvRA9e7M5w79nF2YAJqM4WrWu8U2Dt0w5Wz5tei1VZRev4tUktwRIzgnLslWLCKENKLojB1EdV21iq5/ex6wm3luSJfKeFFMnttMVc3viz5ey8HcmqDySMf4iQg==',1,1,'',1,1),(295,'2021-02-26 11:28:16','2021-02-26','0000295',1534,2,1,'16143566941022047836','',1,'AAURAZO',NULL,NULL,3,'F001-0000018',0,18,'2021-02-26',1,0,0,1,'u8us8oUeUl//mRHgiuMKQlE3eW0=',1,'JWO8N5fwR2bTnJjZWDuFj5CBUjULI0F4b4f/fGDraj9CKjNi5ere+YdnQ0snWc7L/V0YONemocjg\nFdApej4MTKAjDuyHMhIV7DaObtl8JFoS+XNXFSRzFNvGF4WowH7aJkGh709CkLqTBbjkJN9ktUIw\nnjQh+TkchtS/BW9g+xqRoLGq8jUfy5nxDc/byROzdIXGkQ4YZFp17dYqS5bnlQq0VAjrxuHIVQOs\nHSOPnvnMhDok2lue8073sr5ODk3nSya9HB8hsLl3EVZYpxo1nYWMOZ2ZCSTCnFir1xTrErQWSW65\nfsP2qcYVCahERfcP0baX8UeoFxy7iGxgTyfz2A==',1,1,'',1,1),(296,'2021-02-26 11:35:34','2021-02-26','0000296',1534,2,1,'1614357251591213643','',1,'AAURAZO',NULL,NULL,3,'F001-0000019',0,18,'2021-02-26',1,0,0,1,'v0hbCNNY2Yqh/LmjeDi5jRgbrns=',1,'Q3Q1rWN8iM9mV0tctevZn4BnFatpyZi4Y6+8xl2vUQaAQmlhbPxmPhk/3vPvbIQ+NWf3JPofrOtxMAOUZZo1XAhTq+MuqFYeC+HYnLnRlhypf6/GeuBXoFvPJkOCRe7v4cQ925GNpiV1Dlst7pSLlCipPsRaujOu5ZdR4D23HVcRJyScPv5hedC+zO9svvjD07U/Zma4I5f9PLWuLcc5Xa3pqta/zzoW3efpgN1Bc4PdX101LMbTF6/xIOraGevjHAlHCYIC5iLMnjedMEN3iz0giHhXkbowI1MLhHqf4WncLES9V0Ycj5Rlcip4dN9JatT0QN5jm2JEZa2bGAXglw==',1,1,'',1,1),(297,'2021-02-26 19:11:42','2021-02-26','0000297',1536,2,1,'16143840231392336314','',1,'AAURAZO',NULL,NULL,2,'B001-0000278',0,18,'2021-02-26',1,0,0,1,'FlfKQWUes0s55W3ht/Vin5dzbYM=',1,'AGXzHzKmK9zzudzijRGqXUK3fge2qjh7739w1g6H7Z+jlODJ7bhuvD64ZoD/BI+Uc5ItaJFAIxJb\nVugQUiPHjLmWoKZisTm91hbkd+HICybrwFErAE4lrXfZEwyQbAOWhTgPEm5G1Rs0SE36MUyKzT2q\n4f/OCeanxtMenJCGTmywqQ1MhK+RNn7T5WIGqM2FOT21rnF1kk8QvDqC4Sn3DjfrltXDshERczCT\nn8sOSwzF9E2Hq21SN5eMEv9/aWfTSa0mDV+/moh9SIcRETtXBK6BuMu/nZB62CfLdQh7MjVk3vv2\ng2W9fSBHSsPzKcjM3blTNEfX66J3XpbVFK/5BA==',1,1,'',1,1),(298,'2021-02-26 19:17:00','2021-02-26','0000298',1,2,1,'1614385006934004812','',1,'AAURAZO',NULL,NULL,2,'B001-0000279',0,18,'2021-02-26',1,0,0,1,'eQr1oK6gKN83XHd/hoCrn0e7Lqg=',1,'EHyswzCpupQ+h4N4m+8gZ2dW+oyfTwLPAYTYWqKD8wTfR6GIWVoWAJk0Rd929NOrGXoMGC43MM3wxjfr2RtNDbXErD4u6PoovwnsiMOieVmHmvetP5Ag910aBVvciDzHxiIKq8W8W836NbpNs3hUHOauq3kBr9L81SawL9gIhxL7p3RDs8XsNPtl1wJko24R2ObSjTyPBSrVWeSThpjd8kJX1K31By9sX4F9JC5pXp/DlW3mrEiuoiDXqCh5L+L93h9k/TDd66odMG4XUT6MRKLE4c6orYyJ3klQnVco0gL9SUsFrchOqDGH69lFJiBksHPquizaky4cCUfD7cMHzw==',1,1,'',1,1),(299,'2021-02-26 19:17:35','2021-02-26','0000299',1,2,1,'1614385024594699217','',1,'AAURAZO',NULL,NULL,2,'B001-0000280',0,18,'2021-02-26',1,0,0,1,'Fq/T4oMWiP/POGwfBvEoyoJQnxY=',1,'Lii22ZzLmjD+YJGi7bUL1R5QfbBckak0DTCrGwZNYq7EADu7hiZExAeoe1mAcr28CHv5UQErjCJSRA15iwVAZxnK008pJXYWkP1/mX71ZVkScl+uoSTrCJjsTMyh1hevW1ahYh4/jEu7h2GBgPyP3D+umRIfHjIuwgCkjbjxdMCgJsQVxhbmp2kXsx1Jc//XiZJ12ZGUIwMUddKBoRHL3TPqVm8LAmkgcx08wlhtnb4iO/7mt/7Lm9BG25VywI5O7nz5kZdvZKVKravV/CXnlcfZGD8kbHHLyNLZWm7ioT8jf/x+WCH3BBxYwHS27Jyvhm4zLsFb3h/Axz/ziDEgNA==',1,1,'',1,1),(300,'2021-02-26 19:18:07','2021-02-26','0000300',1,2,1,'16143850571091070813','',1,'AAURAZO',NULL,NULL,2,'B001-0000281',0,18,'2021-02-26',1,0,0,1,'oSh1FTlB+hvTgIv0y9jeSRgrits=',1,'IDUKrRHjV+/ULggNeZEuGicS+pusLrETZNyLoReoJya0phFwzrUOz7CAezbml/Zb8VeNWsEgMo/ZVUZBV8ritVmKgeUb0xx6O75xkTQOotIDPFK8bCGAVELzzdVGu2JA9N8tGz0UN8fzhnNmAD09rXisgexkI1TgiNcf2QeEUTMiB3/C/aM40tQtw+BS9kQzqGgwM8/3CRHpxD0MN1woLLVkHcT2Try/nIXjAeJwMP0ExWHl1AzoW12vXqTJaxQB9DAGCBiCdSgn6mrlYYzQcptZdAh4uH3P6Z8GobTpL2j5wUme5U3ejwxDWaledDPodNM5HGCFlI+bPe2WBHiV5Q==',1,1,'',1,1),(301,'2021-02-26 19:18:34','2021-02-26','0000301',1,2,1,'1614385089734208252','',1,'AAURAZO',NULL,NULL,2,'B001-0000282',0,18,'2021-02-26',1,0,0,1,'N9WoxIh22g7IxXjpRWbQeuwutWc=',1,'KYSIdcsQZBmtAotQEt82T5cS1NSrMIiaw76PQ7DrMVCpfVK6o4/o0t9/yKN2vfYwbVatJ/7dVadT8hEU6uOJygx8nl05yeFJ8K+eSzo105DeCOKgifl+HAVk7Bt/Bx/O+eeFfLv7BJ6hPOLKGMT8cAojw84EE0Fgr/6/DZ91JO0M9o5h2dJy1LwjKAw6UxPdlHso4uKaoEDCOKffoUmoyWz/NV5UF6j6zQmLGhc45nSrI1eTgJ8kYVLclTucaGFlPKK/7v2hqcGwKlC1BHIm2DGnXYBkK/JLK/auca5YGE9jNC8qK8t6AwZc6cKtO8aZfNT6Z8e2mPyh9fDwsCV3QQ==',1,1,'',1,1),(302,'2021-02-26 19:19:51','2021-02-26','0000302',1,2,1,'16143851611092749053','',1,'AAURAZO',NULL,NULL,2,'B001-0000283',0,18,'2021-02-26',1,0,0,1,'eGs4FhCLUsO8aOZJxm8/5YzeS3w=',1,'acOK2jSGU2/GiK999G2miMi8cbYBm5lO6IPicnX54kpxRkFbW4xNTs/aiflKDptUgoFy8DedFzwHtyjU+Ml6FTK9UEUofWFK2Br/X3z6dnmLnbC7kU8aV3D6z2A+7iNZYdsc32Upa8lQEGw6SBgPm/xSo0y6tN7p3PxkQtf/QZyzTW5uUWWzxrXb9GInWLdqfm/KqocqyNgmmlYpSDjvbeKARMS8dZPox/ZKcUy04Y84Su+hEX1jvHCiz2dqzMj28oXihnUy8wp+peV/wLyHu6UdI1seMi3FCR2mXZ7GwXuX/AFW917C1EgoymSyrq0tKp8BTCJEmeQq+ZgIfx3P9g==',1,1,'',1,1),(303,'2021-02-26 19:20:42','2021-02-26','0000303',1,2,1,'1614385194868940759','',1,'AAURAZO',NULL,NULL,2,'B001-0000284',0,18,'2021-02-26',1,0,0,1,'MCghWdqWc4XbMir/0vq9KeOCFGE=',1,'aabkMrHUAn9fzaAGo5wxAPzCirRc2muK3WRXybA/oddLGniR63tPlbJm9mFjOap79c8ijPPHC6UfKG2+qTSZ30NZIPYeociygn9PUNU1DfogcMu6aJejNxGNeHl7d9/OJFX/YevSyZACknYSP2baRM/B3J7KMEJ5zQgg5L1DLUn/2S35jtZ+5OgE4raZv/bB1UQnIPr2Rl1FXGodNDRj6FnMNLEF+xSVL7VBfCEvZMh3VyPqtOMws+b4yDR64pjzxghSRWTUHyoRAxEDNs7kGPusa7geWXt3gZuR6aHmI/BKJkQKww608WX2Qa/MLT9SOUwrj6VuP1CcYH1JsIcROA==',1,1,'',1,1),(304,'2021-02-26 19:21:14','2021-02-26','0000304',1,2,1,'161438524524485084','',1,'AAURAZO',NULL,NULL,2,'B001-0000285',0,18,'2021-02-26',1,0,0,1,'X5B6zzP88uV4ZP3SxxSgwsQe4pU=',1,'Getu18f0umEFavtT4Hm1jksQHdOG/nArTtxYXVXZ0FlhWfsaJ17UepbQmWWei0H9i8J41VZOh7asZOUy9PM/HAGn/9IPpkfoWLGVshTi97RN6UWIEIw1yXIHWUV7L6WbkpU4MrfDm+BUzp4jfwn0wrOUfBGdWdBerAkC8av13zQ15zMrpgPmNnR0cBvPmp/CVQ7lVc/ZfyiTbeKuhvXXSSJwg1dnj9ruu6unN4Npy1ijAXpOSniZn/2FfsKwP4w3w8dInP1uqWg1o/DNaTDlfvXH1u5yPahpTPg++L20sf6nbLMjnVNifQV04ut/7wEKrcMahllORtkYAFNlW4T2jg==',1,1,'',1,1),(305,'2021-02-26 19:21:34','2021-02-26','0000305',1,2,1,'16143852765422005','',1,'AAURAZO',NULL,NULL,2,'B001-0000286',0,18,'2021-02-26',1,0,0,1,'Wg+FrAgHvkGgUgXA0UC1OgdAlfI=',1,'eUnvi1WpJzUQWIp+n2uQAOV+NCN15L2+Gv2h1bRrls+hByr77qEF+5hv7I/cnwk7e/DQeYPmAXgX0g/CoWhm+4d71MyXuL9uMCZ7wS+anB4ZRDDDX3Ke4wU7UPe9WGN1KQ/UeD2+K05/DP8v7rCtHj5icmXgz40r7HFawupT73Q5y+RK6tTfNZmItpr93g3S7hxBphXznUIC8SrbnJebYRYr1ElXjleRifXWb8RivsqXNpxRcvmFkQsAVbvINiqRqxAgaAPL9XN/4OjyykWY0rKCydDGU8/jmqhvFjVYkq+kPb0S91UY9OewlwsU6ZdbE/HXIsH/mlyVMRngAKrYqg==',1,1,'',1,1),(306,'2021-02-26 19:23:10','2021-02-26','0000306',1475,2,1,'161438529898671875','',1,'AAURAZO',NULL,NULL,3,'F001-0000020',0,18,'2021-02-26',1,0,0,1,'iSwNbK2Q9AddUFdXF9mNNi2chQA=',1,'KM4j5eY9t3sIu6/iDf9FdwU76Kcep1ogsuBF8WqA1u1S/wVZGoxgcW+8I50MAqAb/bW7KpRWBpw3dTEvK99OvMXFbRoQyz9pPXW6Z+CCFfRvij3QnEFxpAqmk1zpAFLi0RZTrJak7nQFLYB2le/PtwndvDDGXgGzXSeOklmeo7+LvbdvxHuOGPIWSBeTdm1ymnZWgw415YPWvXjzWR+nYBpWkOUousUO4fQGMDIGikS0R0onzhhCs5oCAuS/5OlAtoboJXlIhLEU6uZankywI8QpZv0rMmNEawdMej9riPeuBBF3/4ME0IKvR5v8vSo/PkU5lsvCcoFrCaty3qnunA==',1,1,'',1,1),(307,'2021-02-26 19:24:35','2021-02-26','0000307',1475,2,1,'16143853931263585224','',1,'AAURAZO',NULL,NULL,3,'F001-0000021',0,18,'2021-02-26',1,0,0,1,'rXpzfDYwbUg0wXiLdWt9kLnP6Co=',1,'WywXw3CmphPO/HrQ4qx5eRdOuDW+rGMdv/l5dQJF4I5HUBM2u7gNwWXQR1cbqw9XFL3bT49oZgZvKiaIJTRkVfpChQFyoJIYygfRMJtQjiIRT3GAXjfm0qQ3KB/SvbpXw0HVqNQgAMbhIoeman5xFrQssgVDmKZ5P1eij9DLI2Nt2/QTV5NGwDIZsDIscEdtAjTwlny18G6S+ZnkBqN2CsZrfdr/RA3bNpS5zLTKhrVQfSxqgJjiE+9KRS/OAS3MP/z2D3qHB5Nn9vfaIfwbxNJ/CELFOg2SO2l40Ru85Xk6ykdo6S297dI6EHU45FUTSQBNtcKs7pwBtrgs7WYh1Q==',1,1,'',1,1),(308,'2021-02-26 19:28:57','2021-02-26','0000308',1,2,1,'1614385705123243022','',1,'AAURAZO',NULL,NULL,2,'B001-0000287',0,18,'2021-02-26',1,0,0,1,'5WQkFVpoewXFgxqUYQB9FkQb+lo=',1,'TuPwzRsbFygKWknAAi2TyEudfR+Qa45+wxRVJau1rc/drJmPrh40DjSa4B+giaF+x+8p4wSXiklnbXZPCt+5wFuyTlsDNk3z/nmSXUSFBBzQEpA5vpMMjY/75EaXY/8S8T+1tddhUEY9mYdZ28HvveVhA3BX6dzNmTvjyCTKd9r7fwTCnDHLeB9s21cQ0oCbIkzVWvddtWCyakkZn/smAqgjnlHqBKU7So1jMvc/SGV4V9bI8NdZhnxuJSNyagQCanw+Nb2dLwooFyE6OlojNTmNfyPG2JlA1oft8XMuAEF5U1YCdAc3qXiUfMhrWwAap3Uhv1hxRhAkfIUODicKWA==',1,1,'',1,1),(309,'2021-02-26 19:29:24','2021-02-26','0000309',1,2,1,'1614385739890198459','',1,'AAURAZO',NULL,NULL,2,'B001-0000288',0,18,'2021-02-26',1,0,0,1,'xbuLzaEWdzDqxZrF2PgSgxWincE=',1,'HheLyG0KjwYN1kTKXuB1peEUQhFIF9DpHhLolsO9dYAUubMDZAPwDBtrQ5T+o6bJ+VJMdx9mtxNOxKnpLqlypIvhs8h1m2JX+ruDihc8YhUXVNPcSxiagBWpYFCVeZ7NQtfZb7bhvdU9WtbOik+Aw6zVLIwf5u4nW2Wkr+eTSJUss3vEW+CL60VO1Ou6gSdoKRrp4rIieS+te3rJAM+GrYafIJY0tupZMh2Ps6+PBVC/q7sBqC77J2znbmtjxXAUdUdOfVZG1+r5c5Tjrds2Ca3ICLEWDyySMIjxPOIl9FaZ6HTwYVy7RaurTszmB290j5sZIyzGmnVsG6S/ngskNQ==',1,1,'',1,1),(310,'2021-02-26 19:29:58','2021-02-26','0000310',1,2,1,'16143857711164827286','',1,'AAURAZO',NULL,NULL,2,'B001-0000289',0,18,'2021-02-26',1,0,0,1,'svCkNDLbHdOoGuSN57Al4BW8K/I=',1,'GNU5feiyVkjSSKNxKruv1+o6zWWw0suOe8Niny+lnJ3JOLqYbZdCDe6G3fjFAZgNE1VGOj2+DlMXi8j7VFJQON/aTl3R0Kt/8K/gxeLC688WAm01iqgiZpuzFTCdoG7Sx9Dq/6A+JJpEpCWRqJ+XCy9kt1E4JLGTUgqdoixw8hLA6gRQ54A4Lp1EBkphN3wW8v6DdSSKB7zwxUlB7Ryj4+FidcCvX7WWWTwqSGVhJQZoWb9PJ/09h7+/lci0L+aw5FlK/U8Zoi8BJGsSAMG34o4F9kY5V0VRZEY7xdtH5cIySzGgaNbLgW+IpqX01E13GYkyYzHWuuBUrAVxn4ZGjw==',1,1,'',1,1),(311,'2021-02-26 19:30:26','2021-02-26','0000311',1,2,1,'1614385800600379412','',1,'AAURAZO',NULL,NULL,2,'B001-0000290',0,18,'2021-02-26',1,0,0,1,'hS4o87l0/bHtLOr02Yukxi0xHUA=',1,'IEEFbE6NAUczx96ndRX7cDHe1vhJZx+lVK2HXWlO/PGwkQiEC3jtcXXPssz9aSh+ZLxCGR2DTo0UgDAk9iMGLPsDRpm580l5gdM+HSrr55LFlOUiTlAn3jTjfXdIPwkR4CZHhLil+rF0MgJY3cQ5zhr1O7H93M30ju5q9CqJPjGZVbsANS1zTh0Yy2Cb11wzYpe0AO8VajL7Mp02RnsstccVvoWl2YFeT4e1jLnrAHpyUvawifppCCoOdpMh7RBRJ2UYR3J037fOU92AnHDz0oZdKGh/Az/urSwd4olisWprV1Rwfm0O4H8YA6sBs9D/DeYPFjm2DbM61j34lQxqeg==',1,1,'',1,1),(312,'2021-02-26 19:30:49','2021-02-26','0000312',1,2,1,'1614385830532862547','',1,'AAURAZO',NULL,NULL,2,'B001-0000291',0,18,'2021-02-26',1,0,0,1,'Q+sj09hEqVXxO35RVKnUT6m8MFY=',1,'L3pmYnXakNyQxgGakpRZRSFx5Ci36B7M26lU232kS0+Mpl6GCqqP/5PTraXm2Bb2rAyHpUBuUz9ywNJGf9rSfA/E9SEozmOMjzSL8dfc6j3Cj7xnj9ltYaf7GFs2H6+iFC1lHfL/3odY2awvw9c1GxVp2FAtoIoMsG7A8Ekrd4N8q0ccdHLU7XiPjEPonhZUbiPbRyfaFRmZfeUwW7W9F3VygfyuWYtFSB2tUErHtUH4tEUiQQ8GV5GBFQSiDVCnLru4Py7qwMtreXlLJ7Rab1wU1bmsAAw6FWUL+XMK+wXT9OOhpwyz1YXQuJZZLhWVZqlqiNEZu0VkXZdWaluRIw==',1,1,'',1,1),(313,'2021-02-26 19:31:17','2021-02-26','0000313',1,2,1,'1614385857341930534','',1,'AAURAZO',NULL,NULL,2,'B001-0000292',0,18,'2021-02-26',1,0,0,1,'VR4N+FMGazqrQWd1T88u6ZiaU9Q=',1,'UjBnmN6EKhXWWhEG+O45j1HdB47uh7PGDV82AhsvLy65gDjaOgh+8PNqY8OAmLkw6ILLQHplxPGcHy397wkhwnRTef0V3sBxoLCrMkQB7yFLV1ny6W9GV2/suVQwF2vBmT2X6+AJe8m+8/jY07SsbXyxWZN4df2YCgkuZtYDwEObhDQJWtgHFobXiX7AQdP0MoWR8gyVfGuveNB1FVxyYpUElUhJyQSjB0AgB+n3Fg4ha3/FH0sCQ6jgLXahmcv65+w/ojfBiRUfczqWbXZwf577aERwBbav9z3KBJIXjkNmY4sWPAWLCXo1e9G1w405RnACFqLyfn7+42LNdvjdIg==',1,1,'',1,1),(314,'2021-02-26 19:31:45','2021-02-26','0000314',1,2,1,'1614385880861754451','',1,'AAURAZO',NULL,NULL,2,'B001-0000293',0,18,'2021-02-26',1,0,0,1,'uKXPhKEu2h+qcUSkfU2Z8uWGpfs=',1,'B7+jXwG8VVdkAOr0JxcOUs7oqWlRaoWgAsfg1FbAGy1S0M8w8AeqmxqTi5vhdcmhJQmCx6Tg37HJZYn68YEWDHLe5d+QFNIUbjy6yRm4Xj5weEzcRmRQFo8z/0qQb4Xdf17nxS1BCkbh7iM3aJJ+2s1jWymWna8xCP8OhJbOwvznTivJ5J9ZFGSax1085IHyJdFpya04pRYs9D9SYq38T7zboleosmOpKhGH/sIEXYtFRYIIpjLHhjf80/eCvwddePkPESTrR0PSaInwshqs4pW72v2yvtyK3Xtk7tlz/4+lz3xZI+hH7Dh0u3xBbbBX79a1f5bgjMNCw0zxSWNpOg==',1,1,'',1,1),(315,'2021-02-26 19:32:12','2021-02-26','0000315',1,2,1,'1614385913372741289','',1,'AAURAZO',NULL,NULL,2,'B001-0000294',0,18,'2021-02-26',1,0,0,1,'4LE2hUKR9rk2BZ9/DmkmdBXqyRg=',1,'iEbGE53cvjS+W0V8e5jY7IkL8ImfV0zFU21vgM24Z6sDzEAtYl2/TRiSsIhCu3RIl7+Dx2iqKsmP6pEJARs8HEFNZERUFlBSQkDYZ61bmFoeQhjjKi05+xmZNzu/FvZCPqnd/Xp+ljL4OQn3Z8sGVGDJmw9smyyAPNFAj6wvynANuu/D0KwkEE5q+TqTK/ySFZmW67dlZfuGyrDzTVwHYwiz0AoLl/F3LXONuTLlKw7EtJM5nmzeUnbS8xUpUJWl3BLAAvW1AFmhfrHURADQ6DrWr3yOLQx4qlqmfiCCsJHbwHfNfBJDQcpr9LbQ/yFUztwWXUQhEyV7Is++r18JRg==',1,1,'',1,1),(316,'2021-02-26 19:33:11','2021-02-26','0000316',1,2,1,'1614385958220580911','',1,'AAURAZO',NULL,NULL,2,'B001-0000295',0,18,'2021-02-26',1,0,0,1,'seFqCqxLGe1smCAg2Gj9x+4GSkk=',1,'XqTYgC51M917JLclY1/gR0JMWPWrQwwmGb0E4MeoIBiuSFqodWsnsnXLLSs9TiQH32BtssMRjGfA7eEXpTwo23q2+QNGWiGsJYM7BucwRB7gqYRbbn/KXKpzKntvnJb9GCEqPNT+60rbHuXUh56KEy4hx29VzVV9Af+ioyXJ4m64teP77S767f6qb7zR5YwF4mYM6qRvHYHx/QNbV+dRVReOXs41wasJINZJq8FT9+u/dpmowyY8zo5LJfLHuDoZxtVoT5ijBZgpcDLmr7hfXl5LS7BGOh0t4Zws/07brfUAA2i2DZXojCfEGhqtpMqooYfKIVU+RXV4je4buBoFkw==',1,1,'',1,1),(317,'2021-02-27 14:31:48','2021-02-27','0000317',1,2,1,'1614454205407381873','',1,'AAURAZO',NULL,NULL,2,'B001-0000296',0,18,'2021-02-27',1,0,0,1,'42W3J2XxUPnt37uE1bA2BXY73ew=',1,'IqqKK4CjVL7MLktNiRJhgeLxO7+AsPKXR89K8BteMLMoR/5Zt49rZ9YRvZolI4Wv2q8IcJqXGXpw\nfJuQ0/VQhQKiL10q0q3TI3DzpQvLHUxYioh6OAdA5ziKQ1/+7SxcWqwY+PuusnY2LXj/9sSGhMtS\nHtQxRz0gF4KZql0eQ8hsJYtgXSazPusgJtTxTU7+SsAnHsKh9w7S1isjBeBBgBwRt0C6o8xjRFmv\n9ySFXGlqS+a9y7g2pUUz1zc3rsyjQZLvxhjMv7qN82fhcYQgGaZLT+id7EtQEcGSeA8BsAZfV1hp\nyT3ksKo096n42lBfejVGnJDaEFwTK+tPe158MA==',1,1,'',1,1),(318,'2021-02-27 14:38:09','2021-02-27','0000318',1521,2,1,'16144545601157727042','',1,'AAURAZO',NULL,NULL,3,'F001-0000022',0,18,'2021-02-27',1,0,0,1,'74kZeu8swoBXVVU+ZwtPVsAUeZQ=',1,'YRcoWhhnRykOehCWYHWvCJNBJ/SvcqmeUSqV3TxJ4bh8+XhKDAvxC6Rqs/6N9YgnoGVpes35/QXgpiq4V48PbayUCZppJGBRPBAog9J5QAsaKszonap78VeY3zxUSvHiYvrtSeblzEGk9/klw3P+tC5n9fnIbdptcpe1ftws3bju1HpALVe+4NoKAjCalTrcOTEsRwMds55os2Rck0uaIBoArrfKTM8EC1FIClMAOXuJq1brdfB96BlF8y6kSzVmJt42sNTI+ZA2KDPIVXQqwkKh8MCqPdQ91jeiW0EFkhCSugaz0aJXF+H2UDHZkpkVdAXwUgYVkLpdtJwORb45FA==',1,1,'',1,1),(319,'2021-02-27 14:43:47','2021-02-27','0000319',1,2,1,'16144549751396467365','',1,'AAURAZO',NULL,NULL,2,'B001-0000297',0,18,'2021-02-27',1,0,0,1,'X4Z5DTaF/GkP+/BNiIPzE1YUTbk=',1,'EiYBw95cwMb5oGjxrmIycKO5O+W2TbKkxXunWUJ7E/rRBoeiDqDcTlWS3HBUKAyeRWk8Dsb9VEt3eQbEm0BEruUo0ALFmjBonbH232BBJvM4FcpOvHOc4iwZ6BZbAtrxMLU6RJbap+vkdbf1zD3M/6cgrbX8/GUKYg4jRAdlAgWcnz7LPWidk4eLn0l25l0qb9Gn7bi83irMQX3i1Ac984g886MWEwFrdNtnO86YYps9AuhhOPWdhm6sLu+nBf+ZbQe3SiJRiWeD1w5PMWju7H9jSF4uPjn4CgOVvv6+89oRYAhZYGs+keGMDFb8WuI8CdPersMpj/Unnxh6bFyJcw==',1,1,'',1,1),(320,'2021-02-27 14:44:15','2021-02-27','0000320',1,2,1,'1614455030689369136','',1,'AAURAZO',NULL,NULL,2,'B001-0000298',0,18,'2021-02-27',1,0,0,1,'V945/1KzXae6tPMAp5zchn4RgMc=',1,'L7XxI9hSMt05volPPA44QMdkICZ6En6oHm0OR/cjYeDnoW7sAZM6PPG4Tk59gkvzN7yqqSTjLBNWZPM3otNZNHqIHmN4G67P+Kerye/V1qd+cjwTr066zKGvGT585QA/fQzqVGy61Ymh3+zxOFkyPdvD4h/XdKdQnsbq0CE19QMIJytZW99x+eeX6yKbgihaMd8WpQa+TVCXTF7vrnoVsYMZK0Q3DRIhy+E3iiQC5hASCx5RYIuuxjIXh0pMQgGc3YI2yjoGp/FN29xC5L0/z7i7A9nI09HdW0b5tcvBypjfeel+7147a1sTE+NUQRdsUvwGiMmVTNexUu5S1vpBTg==',1,1,'',1,1),(321,'2021-02-27 14:44:36','2021-02-27','0000321',1,2,1,'1614455058247992156','',1,'AAURAZO',NULL,NULL,2,'B001-0000299',0,18,'2021-02-27',1,0,0,1,'gW3aaHsFYlav79B0EROLn009V5Y=',1,'cM7IB66qsBu+TwX6/V2jRKb3x9eYyTqRMBiJcQgzxyFR8WXBgYqSrwSxzAKabqRu2Y1rOXahyOTLWbg9iEsmOuioy5h3Y2UhTSQplLFmUtQKDtaf7UMITVIrTi/LIdONLX201O25jan88MJJSMF5S7j+DlF3oGLrwETVYTmn52G0H8TnwCgn3vcMCxkxfwPF+g2nPkPBD6fTgkDLt6FMPYFmaVks/W1M+MnXXk65yA3X776QDAB1q8otGO99kaKbO4G2qBKPhbxwyB5hUUWdEu4KkE/vxH+Og4cw1/gGYvhIsp+nHBJgcWoNquoJKO/8gwZpAGgLClbL2saVH+fo4Q==',1,1,'',1,1),(322,'2021-02-27 14:45:15','2021-02-27','0000322',1,2,1,'1614455079776551524','',1,'AAURAZO',NULL,NULL,2,'B001-0000300',0,18,'2021-02-27',1,0,0,1,'+5lN5xO3hb3pKNr41fuwO6Pp2pg=',1,'KFU5klULun8oGjTyzj2DOV6fgdRFLJfloeFNjOPBn47LQmSCaH4uY0zuavb7ZXdOB3JiiuZF02q4ISj96ez/0rPOEShGTHtr9Olfm4Q5gV2jC0dzDeY7b2CNsxDr5hmUa4EyuUG38FkIfVDPZt/ZA09+jMUiod9p+pAR+StylxKkLVQJCwYYbooCRNXyO7CqA4rF3v0mgayGppZpCWPG1qGIDg6cG1c3Od4Fw9kZc83Oz5/MY+msx30MBGQHsIQaebdN62m21gz7ClK5LQue0E7bwfp6C259470t5GgMvBGFBp+/ZcZg4vNARd2k4EM1mZ0ma0wSxpuyiKWaX6i3cA==',1,1,'',1,1),(323,'2021-02-27 14:45:45','2021-02-27','0000323',1,2,1,'1614455119621852271','',1,'AAURAZO',NULL,NULL,2,'B001-0000301',0,18,'2021-02-27',1,0,0,1,'CQyD3DxvVXQDMxV20F3Ffj1BCyM=',1,'Z1FjC1jG1LOGYLHPYBDfDVCLB2Lb/gPow05XQZD/rOLF7A90SGI9qjrEpk8HwpqE57VpYs0lTLvgUYOHQ4sFEQxBxWzMghjrPHrJTZfQVeN+kS2/PVsTMmgSNZECUFxowIf4V92O9HWNUlN7BQubn0nnjxjRsvyondicOLL4BAOoK8uHbCJotyOtGtiCnRVHHYEggHh1Y7xIqsMn8A83+9ihx1SMGb7uBbFqa77bxj2oiLIx4PQdx7M+Zx4nyeW4rB8EsixTKMPkt3cqarAzxr8+l/TUT0dulrcJcK3vFhjP9sVt+si25Ak74xKGHHODIX2Hm2VRiq5WsuXMsQ3X1A==',1,1,'',1,1),(324,'2021-02-27 14:46:20','2021-02-27','0000324',1,2,1,'1614455149262967216','',1,'AAURAZO',NULL,NULL,2,'B001-0000302',0,18,'2021-02-27',1,0,0,1,'CLcIJkqJbJ7wnm1QznZ3JuvdpnM=',1,'QOIq1qAsrlcxxLSl13z//FI7XMeiXNF/kTloaBVloxG/zVAfCFlYoDCXebQ4wQjLj2OSWMzsLgAUIL38KQxRVhRx2k7xKPiTqmV07J09Fg9HaUX6H0WSCb+4T/r96QFS9i2dEgRqbZ/zXYqrZO3qXhlug5ulhlX9pIZRljGrcb9OCDYgPXUhHuzPRvltC73XxdAfeTrdnp+/dw3Qk3vZDpYqfSHEeeIiCOSafuNJv4fDe4/64bd1uN20cwxN5y4jNszw5H3J7EF0pyU503Umi4v39Q6Bk4LPoFMgvD0DzkY7VrDy99lTPTJSG1UunRshsMD/snBbXBI+onVtDZk+VA==',1,1,'',1,1),(325,'2021-02-27 15:03:55','2021-02-27','0000325',1,2,1,'1614455183843164722','',1,'AAURAZO',NULL,NULL,2,'B001-0000303',0,18,'2021-02-27',1,0,0,1,'gfgOYGkEQEBmp+DzIh6yyDdg5tg=',1,'IIuK2NGqkzzN4pqOLzPfRweyPmYX9egX4j3zIONe2GC+JuXOA/5qt8X6QkEMA3SnjLGapWkTtRLmSatnSv26Q4NvtWxAmIE1KAWbobJHdGU92ZFraMPq6Vx2MH5hxGVsUw5cGJEjCJyGSgei+q8/GTxoYbLiMO8Y77TfzzwnyetHPqaXh9r0uFOZBPCAYzDGZmMHFW+tLS9HxFeGayJrsvgalqA6Zb3owO+Gk4dVthsWn/5ng9c3GD1M5WgxfcXlNsd0ortylNToFQsV+2hVciJAqmljMT/BNkT+H7HFO/EwRCrVhJpINdJU6eSyhj1griapnQB2PVMXoHBN0vgp+A==',1,1,'',1,1),(326,'2021-02-27 15:04:40','2021-02-27','0000326',1,2,1,'1614456238879698704','',1,'AAURAZO',NULL,NULL,2,'B001-0000304',0,18,'2021-02-27',1,0,0,1,'XMnFCW33HbhI/f1UT52QaMbA0iw=',1,'AN6Grk8x55Bp6A2221VFTyHXCMpRk3caM7gt7cKzAp32R49SqLa89zPKq6OSFENXF6wnsyoiaGVNco2EFQIUaQ4vRhVH7019mtwTLvHZNMHLcTw9LQDiKx6wjRDPwBgGI81p8CA5g9f0v9aTG0XUldfXSfRgogh9C0ZmIbjWbY7S6SOa8OkEOpLtI4KkgGTf48YBX7+8fSpnJItdL4PK1vEEorTK2pNSm+aPDArqWQqmu2q5A1SKCz8xDFQs2gome8Szgo0oI9Gk6DiFQFEinENP1PiBwO9fmYjs8p1fub1j26tr4CHps0pmlv5El7VVr9tx3emxl9oL0+5kA53QdA==',1,1,'',1,1),(327,'2021-02-27 15:05:11','2021-02-27','0000327',1,2,1,'1614456283324330536','',1,'AAURAZO',NULL,NULL,2,'B001-0000305',0,18,'2021-02-27',1,0,0,1,'lDZwXBCUgwyKDQc2xVmnP35Xu44=',1,'VqBLIj5UZmaxBuEu7Oavp++yeSHvNWHeqeMoAgBR9NwYt0A4aHH4jJf54/2GGaZ0mT3R9jSuOjCIQ2N8NF01X9jwycsXJ8uMe6JPUYvoRs9jv2u1kiuXt4ykzO9GjpY51e5pMl1GzDkNmJh2HxLSCVVSajflWJjw2JsYNV/+Y6zYBlL7V62jeH3UCd4Q9DfFummKsxlsbKBI2WO/A8tMQY6nulUUcJkb/tVHn5YUtShgM3WgzNHoqOLqlJRIxQhAbfr+ZxTJZOf/nMtQHksIqX75Tps7GYCCSdBUW4W88NH6LX1ZBmscq06G/kUj1tkNuARRVBYUDaMk4LiJ32DqMw==',1,1,'',1,1),(328,'2021-02-27 15:05:34','2021-02-27','0000328',1,2,1,'16144563141286306005','',1,'AAURAZO',NULL,NULL,2,'B001-0000306',0,18,'2021-02-27',1,0,0,1,'MtjjmLsas1oycX1bE7RyXQ7ssPM=',1,'bjs1lHtBiQ5NzcKm+elzz7OGBLKlddIA/TmqfCOe8oROlCWnTvn6CeZMgORhFhcWOSPdIkwopq/b2jXZ2Ssy9Wi5f5idEKyNKjKGL4k1bPe1JAP0Kmdrluj8gqQzbctXt+vfa9uzoOxINuL6ReH4ULQXZEymMxnBzC3VZ8fm44eMXnDBhOOTeIzygKWZvn9OIDOyFHPhQlAMKcw4GCZ/PY+lTL9KYZyofyVjZAhxOPtZQjR0I/CdJlB0f4vBwtCidrddA3Lm8V0KHiHr5vflrIOdyb/KF+gIBF3cHmGXMnO9QyJHnoC5eeiQZuMqKAerenHIlxq3zaHWZo+AtVAKSg==',1,1,'',1,1),(329,'2021-02-27 15:06:02','2021-02-27','0000329',1,2,1,'16144563371172874229','',1,'AAURAZO',NULL,NULL,2,'B001-0000307',0,18,'2021-02-27',1,0,0,1,'nMrvIK73B7Ut5oKS1x9+sgs9hC0=',1,'RLzijL4yHV96Gsesl8nhqZZFAqlbGYyHT9LH8eLJf4R1JypKg4Bbzwa8hyJmp1tQecV8PUaeLZwJTFeb1bLV4/3OSdx7TsolAV2yIxI2aeGWqGDHLvTMIMUBSDHpXPx8J+tiRfim2tBeSXBUFi8R+EAtpxrZgayx+mvdv9gR2NUlE27cXFcQk5X0YzZuJisHrdRt+Gbmxq2g47Uk4eI602rSWlnKgF4ItOYChn1M6/jp2iugTK/2HSBKAIq5kMR+2DOhDDcvzJIAvtDVdrQBisGontHXSfBs3AyDn3XmCuhN+dDKsRnsnpKD/L1/nlZwFihHSUkk1myuLacY88tHtQ==',1,1,'',1,1),(330,'2021-02-27 15:06:31','2021-02-27','0000330',1,2,1,'1614456368106417595','',1,'AAURAZO',NULL,NULL,2,'B001-0000308',0,18,'2021-02-27',1,0,0,1,'kz6Ag15D0hm2B1KPUgF89x5dUZY=',1,'aUTvDxLbecaURB2S3ccTByNrYi642SjjlbB7NG67yrECj4DNq1ferv7eYlXkmlClrOqttCMTRVerjjE2akK3EFN4shsFUkjn4JYRmJBdTolwHvtO43xXVO1RzCiOORjNTRMZvtpsRUg+l8ciObHZQbYuFl5vu1ORFG0x+MHi8jfCnu7oM/Cihgmqd9JyQbztaQVrZ4fu/DDZTU6MBAokVP50lLxzHKSGm96u5XqMFeX8rg0j1EZhjoH/SK4l8taVx48XKMgJHXd5afkO7Ch2sMQWYCT92bfIUeNXw6hiFzfaGIzFsCQUFjGhV/8eYHYxyMt6B9qpPmipHbft3M24aQ==',1,1,'',1,1),(331,'2021-02-27 15:06:57','2021-02-27','0000331',1,2,1,'1614456394234824431','',1,'AAURAZO',NULL,NULL,2,'B001-0000309',0,18,'2021-02-27',1,0,0,1,'p7T7fEoSR1B6rMOK2b9y5W4mMwo=',1,'P5hYtVfByeSTxDSERH6SKKz0BhYdak/a+Y1qFuLaWwkrOfIBRJfM5dzrpY8bRDP+8hGcytwjdDOuoxFC96PgT30EmdjJSx0HwZoBjFX+tUE6oaro8MS5KsAopFWVpFmR2kVjxElLFEQ1+xB3oB5ESAUIWSjcHoX0StPZHc7qs1u3G70RhT/awmFkpHCNBTs9UPhZksLCZ3gtLaQbEIq/QbZl2RcW+0iR1rtXLzNOOAqbrsBhoNtarcSMzhX7vouWIaOEKeOjXWr4JgjvI+Iq43fqRNrp3UF8XVy+eh4gSHVeBDDDexPyXlR73wGE7lXWl9IRaVlnlTxMUVnf7e+o/g==',1,1,'',1,1),(332,'2021-02-27 15:08:01','2021-02-27','0000332',1,2,1,'1614456430596420488','',1,'AAURAZO',NULL,NULL,2,'B001-0000310',0,18,'2021-02-27',1,0,0,1,'PrK0mIaaE0HFqcYoREL/mv+p+CE=',1,'ELZLJXXvXQius/7YB4kDF5k93FMo74qEve+w2rmoVMoXgPXM4HW8Pi657DB42RxkPDpLy4E5+2YzDVHy0WnSjDLqtYaXco14l3wM/6ZmrcZAWxABc0pMBXRlLqOYba73F3atr8HBrCrBw2uukYrTVgi7nt2lswW47kFsFnw7xYOmiftNKvZjQKjdErQl0A3KTYSaVYuXUYe1CxpnfqTUiEWqI8IYNBEkfn1rMoP2gDJ2v/3tT0Rmt9IMd9DyoVqFNVjy2zZnssXeWXmHwXTkf9kmqo9gOAXJvrPHpgNx60flNk6B/LpAuk0OzVk5KmEqXrGC2QPEZ++PphAYYQ06wg==',1,1,'',1,1),(333,'2021-02-27 15:09:00','2021-02-27','0000333',1,2,1,'16144564851050104558','',1,'AAURAZO',NULL,NULL,2,'B001-0000311',0,18,'2021-02-27',1,0,0,1,'vai8c+i8PPM9NWRyHysjqK9mvPI=',1,'A2AsZKOql+BG4onq0ga/2GACrCT6DMPHJo2EpQJKo8yp4u9ca3Sc57LgPBY6VlF0wpXCRt6OApkb3HFFoW+LOHgp0WDMWBgPeK8IFavRKQITZlB4lbg3fjsCzdEBOYwNpbbgzDIPK+RKItx8NYtow9BFBNOiFPqcxb0ZIhRwhOQ1z9GQjKDxE3vXph8hZ46AfXIRh+K69zVuBstlkQjXAS59tb6IZaXLB1RBLRI+1oftUCoDSbJ0Mtt86Boockpvl9WuHYFInW0dnB2Zu0X1law2gMarcBK1CGKZpwj0JXSeY0TM250qSvBR9VpI8jHjq6c1fr14QOLmTcs4xiDyaA==',1,1,'',1,1),(334,'2021-02-27 15:09:40','2021-02-27','0000334',1,2,1,'161445654357060142','',1,'AAURAZO',NULL,NULL,2,'B001-0000312',0,18,'2021-02-27',1,0,0,1,'ECoZApb1GupWL2gystoByg3KYUU=',1,'JVBdsokVOacIXjAyvE9QmS1a07ko8+af1Yow2tp0nZA46Hdecg4SSPuPUHRu+j/yGWLrNUp3ZKDat6NV1xvLqyzCHudISTNtTLmWPpibs58gbsI+cz+kmUEwxIGfLP4Xt1HY/0D6iX7488RsjLAAYDv237BNop9GklbZ9QbKfbx3MdT7mS7Yi+JXEyieJhcMvKZghH8V2FKkczy//Kc01uD7iGuBoHWzkQwQnHh6J3kxYsb99pJ23zqYQbdKUkC3GEiV2nA7+u4JxoKH9Jnr9NobHOxxPH1d9uMzUWi9xtxjDfdiPC6RoFZbKbxOP4GiAZji+8wZsrLbCYGOciyJnw==',1,1,'',1,1),(335,'2021-02-27 15:10:00','2021-02-27','0000335',1,2,1,'16144565831192238531','',1,'AAURAZO',NULL,NULL,2,'B001-0000313',0,18,'2021-02-27',1,0,0,1,'YJD61aHh1PZqyuiSsDTtygsoZXo=',1,'hssQsUAzXHmfmCCPXx/n29lNxTFoYeMfxh5xBafcu1JGAoYhO+GNE01lEGOzRt0vGxcT9rTQ6AOCBcOFACljR6lb8S6kGMw487jGDToZ2xrWbRCfnJJUfFUhsfiOjgkkRixzV5cN+Sn1PU39B8zie3cjQ6/oIqytIaeG/lqht/AkwuB0S19bykVt7U3cKuDkNcWqg8uhPSpxoyzwBLyOkmI9I4My4T5FxI2dBfVu4x4Mg0zbYb9Ju6Lm4zxsJ8XlSw+s4vVZ3nNTYDJiPy4dLHlRQYLlFHij5XWz1sV8V7hk0rkTD1oZcQkmY9wrFSjm49PHj4WIlAbGT4C+itxMWQ==',1,1,'',1,1),(336,'2021-02-27 15:10:35','2021-02-27','0000336',1,2,1,'1614456603758779399','',1,'AAURAZO',NULL,NULL,2,'B001-0000314',0,18,'2021-02-27',1,0,0,1,'GWi9mUSLC61UStnWTEdDUUMHTVY=',1,'UBOiah3QkADgJf6PLlsZx/zVxh3uZYs8mVIVHsp3oFJhz3Ndm+0q35l1FRqqNSI3VvQ8t10rLIXN3UPjG/bwu/Fh4XQLojzYGyJLN5U0s8n9yOYKv8FANYKi5CeNfiTKta5o75rVWmZS4ffFYzYjMN+Dp6PeTEOtFdUkvOLhCZlzs6Fbm4ZcJvISlES65bYpHs5BBCH0DOyJ82EHGZqLDItjQAG/1GHJd7xtD/xzBw+XyeahKyldT5AjE5gK+IXGBHhvTlb9OwetynkDVugkttUyBtdV3X6q0k8gie7agnwgc2FWXPQMJ2Ygal71eempVMxlq4PE7lYIqhXB2Z+LqQ==',1,1,'',1,1),(337,'2021-02-27 15:11:09','2021-02-27','0000337',1,2,1,'1614456641279749610','',1,'AAURAZO',NULL,NULL,2,'B001-0000315',0,18,'2021-02-27',1,0,0,1,'OC0r1UQGZw0/BowUg06ei8dsiW8=',1,'avndCFfvvPhLZFPfZXhtKuDyf5pbXh/IFjjLqpGJKwWDpMjQor0yQaU6Pze1wwFu1UyOrP11xtQi62cayN+gRaJ5cpQ59U65G2BBYaxoQT/GKGqNp4n4/pPaxUKOshVk4WHqGjzWoPNE2PFghC8EY4rFvtjthZyyGba4SYLvq2nzDySLNgVohRwZ/9idaLl5Wea4WJhoHMdV/0ASIoNN5s8habHxdqIzwkAkcx4E6Qux8lPzIynwJ/82QvgSZ2OfkUbWr5oexCla89b6GZRPg2Dn0IpToGrLVH0Agg6zZfmxT4TwEnco//8ppEIJgcztacCWnktg7yR2pEjxskbjqQ==',1,1,'',1,1),(338,'2021-02-27 15:11:43','2021-02-27','0000338',1,2,1,'1614456672252854747','',1,'AAURAZO',NULL,NULL,2,'B001-0000316',0,18,'2021-02-27',1,0,0,1,'WqSYT2znFgUIY3K02Zw5308SVho=',1,'aVIOUqzapHXtMEgDzg/zqIuqu+XaiFd0ibcLPS7BUOa0K6zhtonVyBEJ1xXbDg1QXXTnpRGoKbWaGE9kCFqe/xx6k1yUiltmWWAGGDJgTy6/h3uK5ibKQ0CNZQS1z3qcsuUkTMiGwNQansPA9sx/Y1r3CZx0wSxXirWJNuWx5ykoYImsn+fNg9Cnueo2+G/0JUEGQHC+xhZyMkYe48nEYWWyL8RWO9wrJtBa7MZdme86cqnwBZjp9xELcpR6cVKj/wntvuNBRmKwkuKPp//O9NJbZ4KNOSbgiVPZypllx86/YBdThco44Yvu4AjYvRFUM9qE2WHeAfpvxT3Um0RlAg==',1,1,'',1,1),(339,'2021-02-27 15:13:44','2021-02-27','0000339',1,2,1,'1614456705860506530','',1,'AAURAZO',NULL,NULL,2,'B001-0000317',0,18,'2021-02-27',1,0,0,1,'xYHr6n6GjTs6G2GNop7bOmTPoQ8=',1,'VyshKenSgJSonXZdHWcljeeTwSou0TkMwS9BQSvHs7KrJBxiS3ChMWLaLsaGoTcsxm01Yqx2fvI1J/ccKYXSRapWBmK4PRI8LY+EIC0WNsglUw1l9N3n4FbberA1G54+UKU64xnsadF6Xr/Se++nfAkpDGlkV/zFEpOFmYdAVTe+ZfJhMfdU+oPPr6/Rr1i2b9e8nd17NZ7fD51tOpWid0ERge8gmfe3aIfC/DWmvM47MB3fJfZET1MRMfxl7ySzmOWpMivRMgrdqTEpNVwi7G6S5mM4IiaFO5u9lF0WXPq6FEyjupcSrqgoBmodCCqzH+JWEmlzyKXA6fu5aCeDWQ==',1,1,'',1,1),(340,'2021-02-27 15:14:17','2021-02-27','0000340',1,2,1,'1614456832799444432','',1,'AAURAZO',NULL,NULL,2,'B001-0000318',0,18,'2021-02-27',1,0,0,1,'SakCMHOO/RpGxQq9pC/HfHmursc=',1,'cvPH+hEZgIoLYk+qC5EBW0B4mQQ4MrVA6wL9AdS+kFEF7zcyun9yN+i+qcFiCG6jnJwGXjPqPH5yaX3EeiAUdyYkG1e1owEEBX6kae6mYYA0+8/kn75GPtlJ6yWPicoVhw5fgFPSTixjUPc9zSUWeuzpbZTMX+fMr0I89ZtYfiPxcN2XRbg8l84TJ0z++ly+dgfhxq6EDqjSoZjnzdVBrHlO1zdQ+EReKlxHHFglUPOk5W5HTw+Ebscs/wNT5EvSG+pPx1eR1XzE7n975z1H5ikBAOnOmPYglQx5eqcQmwD2aWNMRn12uP/aGn3C4lyf0YunLjDp7PBpIzTgQHAPxw==',1,1,'',1,1),(341,'2021-02-27 15:14:42','2021-02-27','0000341',1,2,1,'1614456861415687007','',1,'AAURAZO',NULL,NULL,2,'B001-0000319',0,18,'2021-02-27',1,0,0,1,'VXQJD+qPeFyUlx3d98+MGKENa/E=',1,'X8kvvaVgwC4R7d2/VioMuwm6J7d0RWUwynurpWUqmDt44X1PglH1THtx1QTU4SifRkOXC+wmvpYdp7hpzC4Syv2cL1wAmOdseotQyVQcDcpjjVPtA/jr+qxb2+ibqkDoJNcU6jafhqrp95Nw2A4rkNfNFal09vmSJv1HuwQarGZrIkX8RChJOx/iC53nCAVRLIuygE/6ft6ZDTREgLwN93Iv/BniNh62QubwhXtgtH+qUH8lpka6v+rTlHzCGVQ/pREKTVXEcISVAnQOPJFL3Cxj6lS+54TFy5/7xsuv6jDU0FsdYD1pDMK8yD+CgplF55Z2a4IdVMnYitJAd7TvuQ==',1,1,'',1,1),(342,'2021-02-27 15:15:28','2021-02-27','0000342',1,2,1,'16144568851121365187','',1,'AAURAZO',NULL,NULL,2,'B001-0000320',0,18,'2021-02-27',1,0,0,1,'f/bJrH43/EN5wZaHOg5VnjTq4/U=',1,'ZGBroC3r5Z3sBs+UrOBy544r5NW+FZ6gS2yHAcJi/Q3orOCUUMVC1Rj354BO/bOyykfGpxuP2Ag9Z9a+Yh1+UQ2JUqXzLONl3+o1L4wY1yvrQ+AQUGe3ZedzS3N0iayhT6WM/INq/U7FMm7scMMZcuTuLChIlOqFOk/4Y+d7oTtWshmU8Zt+KFfJJr8tcnqBV3MPgBZ3efh0net60hvssg+WnRFjEI7W2srD5HrNTLTXT7cShQz5Y70jQQX5OULkgOIo5rZA/NuiI1xi1Wc1TD4FolpGRW16UjHiUqmpwZ3t/MqUWCB8liF7+JeXUsLLV4e4CbzVIeTSD7By1qwiqQ==',1,1,'',1,1),(343,'2021-02-27 15:16:15','2021-02-27','0000343',1,2,1,'1614456937132451823','',1,'AAURAZO',NULL,NULL,2,'B001-0000321',0,18,'2021-02-27',1,0,0,1,'X/CFUBeAU9RkbcgxPmfTnOZSpaA=',1,'WnFA+mmoQbDOglcsJkQt3RxVcb2sSAld5pJMUTjG31ytOK9/cg/F3wCF0bFPCl28EUx2dQrAmclGkqPf4PD++7ZEARlKJRRCrWczZcS8ycEvBf9OO1phjUsAz2dI6PirGk0fhURFrguMJgSFJvJbxQM9p4BKXUxfa1YD5MS71Ayo2UYljfjpHm5yEST3RrBBrPIDZvB/dU+OheupiobDb71lIi5uud3L/cplR8adm5i7/Ra5v4cAN6segfcXzKryjPHxPO4MMuavgh6Tbg9eIZoAVQ8NY8vljUN6tdDP/nDHQJ0eeiepnX4ZidDWNP1sJnooV+hu+McAXy0EoG3Qwg==',1,1,'',1,1),(344,'2021-02-27 15:17:14','2021-02-27','0000344',1,2,1,'1614457013887315329','',1,'AAURAZO',NULL,NULL,2,'B001-0000322',0,18,'2021-02-27',1,0,0,1,'Fvj1WSzm9BtKG/eBZzVN3qEZ108=',1,'X1uOo5lLF7erRncVdZaXtHlDPrlFuAQhEJDo0UVC1t5ZZfu3l9uEiaS3H8iCOyqdymsKWcCotRFPIDMyhP+YB0I32glzawGCnsvJUiuX2SlmBVKll1itXPsINLZ723/M52ZqqyZFQTJiNGQmpv2cihy+mSGSewmQ1/8A6rXM2Cxu768WJfEUA4XqaLgW1gFrKOquVMhsnJXRPCJBhDhJEn2ARqSISna4J/FPxMqoeXBJwzIR5eBkDaXrSIn6i6G8NeGCUFgQB4gRxgWKksLJbND9ksxYszP/fzvTSenLdLtknMmOrOk77PTH4kVPcE1YLe34uwOZqJhPUFi+D9mbaA==',1,1,'',1,1),(345,'2021-03-15 19:23:46','2021-03-15','0000345',1537,2,1,'161585391535845474','',0,'AAURAZO',NULL,'AAURAZO',2,'B001-0000323',0,18,'2021-03-15',1,0,0,1,'XmOytLA8Ur5lXnkPZiw9gyDwQ/Y=',1,'e/GqcLQ/s867HMJIjvkvi6HNgeutIYEVW5pviC7KWyKs6fuwwGvJ/GHOh6keImncNlt5v7whHziw\neB/xQq+ve5bTUBjboKIZDLZ7XsuxeCkoBmagN7rVeFMp4l02JCxQssZx6MhBpiTKgIk/nOqiZ7UO\nclz6NDAqNqEtCtqCnVzImGlFHtKKtYwiFPgZvo0OATHy5ZRBAP8GDRpFnRjxpVGKK+GUF67bxwV5\ndVIto2QqxL9BTkMcmA1vswK2R8jNQ3tSpK4LkyBX4/VgUpSqRuP2a9GjnYQOOcOpTv28/688k5wC\n1Xnw35DjpqMIifybyP+mXkkt4b1Kqyt0ou4bRQ==',1,1,'',1,1),(346,'2021-03-18 18:23:08','2021-03-18','0000346',1,2,1,'1616109764195278224','',1,'AAURAZO',NULL,NULL,2,'B001-0000324',0,18,'2021-03-18',1,0,0,1,'iBATc9W5gD58eBYrFqar+clZ1wg=',1,'YpDjqNx6Md/y7QThyAgksjWPE8B0EP7KTaWV22lLyl9qLh5K/F+fRvxTSafTcDv8qry83oRBmtZx\nnpP1iMQcjc6KVmuZKmvAvxtLeZVmf1d+ReyJ39eZIth+HO5yvKyv7UbNC0tJtj7F86VI7fNGJ7o4\nbbm3V/KhbbQgq80zetCBsZGBcGbHd87ksC67i3X9oF5Es+dmZButZqavEMvBg3LuKGPRGJwor3sl\nAmpUXKRA0CgUY+kyy4a3f7+EUCZ04MsCmU+Qb7r9hAcKblm4m85Wq7KpLbKnHkbV9/Re3dpGrqdw\nr1+NgpPesiINZGiPy0ypizQwD0EaRilR46W7zA==',1,1,'',1,1),(347,'2021-03-18 18:23:44','2021-03-18','0000347',1,2,1,'1616109793797335875','',1,'AAURAZO',NULL,NULL,2,'B001-0000325',0,18,'2021-03-18',1,0,0,1,'gPIzj37+5SF9TUcleWUtxySDQBY=',1,'ISRT6yNaJT1D6yDLZ+QXEyhdHhfnQXI6F5iUQZPl8XulPl45cYNbMWSzgp4taX8226Ii/MWKcBeei+mcwZ6sDFO2beJcVKyWGYD47fjv058kmYd7eVo0g7OOml1Omibt9/Dza5O+RLZcRWCeSQNE9MI7exIU/9aWNuV2Pj+D1yenilMKz0A9eRuindj60w+d1DgPVdGtaK9fWomxDc/Fh5KS+zCmc7JTn90x+YP/bNzzMjDuCTJpxBWBiKAoP+LO4/W2Km5DHL1iYneWohXKThG6QIapTyuo/8iN4OcUXturWQY1Z+qotKmOsuCIby2AGnUNt2sKJ2o/s9BnT1yfUQ==',1,1,'',1,1),(348,'2021-03-18 18:26:23','2021-03-18','0000348',1,2,1,'1616109829453081625','',1,'AAURAZO',NULL,NULL,2,'B001-0000326',0,18,'2021-03-18',1,0,0,1,'MLVLvFnmHvwoc1JHcq+gOJoPUnQ=',1,'RC1FQLB9HU4QlQ/QcOsz94dsWBgrqGNcrQT8G9MdAhcTWtSsRtt3aNUpIOE/t+mnTu14HXHXC1sNGtwWXMKBA4JWNjLKe3aUnC4v6a9Lsv/RFfy7ZqJ99p2D5xsjK0FU4WIrgsABC7ZlhwTz3kYCjs6ZgeKs142i1aDHgGJnIvatej8u7BhubINML7l8v4cYIOet8qIhn3S2dZavmhuHYNTnqwN6fn9QNKljtjI0wJuJdg/+VU6ilbbLRAPO2fp02vBaSC/cjWy2s8MYTGsyzXncUfb96RFR44wbEDw/27mqGwLdYoL24nvaU1FwRH+/HN20q6jMJwRb/+hPKWVeTw==',1,1,'',1,1),(349,'2021-03-18 18:27:30','2021-03-18','0000349',1,2,1,'161610998672766743','',1,'AAURAZO',NULL,NULL,2,'B001-0000327',0,18,'2021-03-18',1,0,0,1,'+QAPEUMuHSAD/4bJmF1Hawq5CEg=',1,'CAi9lQhpdO8Nr87P8u01jTR+UXCVhhh9Dd/4aFwcGSAs85uB6xRz/SYhe191xYoOZu8NJJpCeztwk8Tjngby43wnk54rQWjEJsFSlDSAof7vtSDVJrE3UrJ6BJhBaDCMjQRTFvU+QmDDlQvtldDNsYl9pR2jod5v9nqOMyKUpVs5M6YA8kr6hc7Qc//a/5ol6wkNXmjG14OaOLYP7HW1em/lyTG6jtl/4Oge7TyLVg8JDTBBg6oH2gIVAJ8sGDgz7rCY2PtuJuwLBnAVTH/dSgpL9PELCg5hmXuTyASKg4y8bSPxF8FnEHc2UUTa8hszo/EaSqZAQN4DdJCEtQ4AOg==',1,1,'',1,1),(350,'2021-03-18 18:28:35','2021-03-18','0000350',1,2,1,'16161100531324173972','',1,'AAURAZO',NULL,NULL,2,'B001-0000328',0,18,'2021-03-18',1,0,0,1,'SSm9KcaHy7JRJHB5yxs82undmHc=',1,'er6Kbex7FVtNnnYn2Koay9VPgTZi9TH1eb7z02F9e+St8DkMeCYj27dFmYFSEDyljW2Iz9+8rfzcAzyHsXM0CHzh7MhBO11GmUuCmzqA0Q5wb8PRPbLlM2E6iZOlZE6Mz1TNnwfxNq9Gl3mn0QsVpqeTY27h/kQVKQNm3lh3MBovWCJAUAuhtD7cs4txLEsP/PzI2rjsc2QJOTytuyrIrHTKC/LP8A2IhUpWo5Ry7VJKwNfH/fymrEKf7ih9o+IrD3TW8j3PN5mtZZNM+Tq5ijYaecZLX7WHA4BMsIEeQlqoTrp1egL/HjJAn0mjfL5RlziuV6S1f/ShIVPqpg8BHg==',1,1,'',1,1),(351,'2021-03-18 18:29:10','2021-03-18','0000351',1,2,1,'1616110120932369604','',1,'AAURAZO',NULL,NULL,2,'B001-0000329',0,18,'2021-03-18',1,0,0,1,'xu8/IT5CCJIMMfwyHhiq7ZNdWNU=',1,'U5wB5ODz3GaJrFTdng879vMACB12j0whytOOca6YfyMxLiEQ6BixxslECH1kO/VWoZje5H5T2UI/8ZGqSD6C6uIRwzWv1dqSHScvMVwtu2DWSKoSmU+9JKqMstj5aYZSdo+wndazDz6VojmP8nbDEBuRKvJCP2PInAnTceauq5hb2tl88Dv+5x9BqURrpLvqQMXPYMCs+iMOPIwHzpkaKjr9DvDjUBj7mg9uNDiiEc7VFo4GjJSWgsVsSYUOd3dIsKeP/Lh+f+z2OrIAO/rbdDPGk2i0AcQUYubMbM1+c292drNAGnzsqQRLgSrAyGkow0jxg+99Tfhdneet7qddtQ==',1,1,'',1,1),(352,'2021-03-18 18:30:50','2021-03-18','0000352',1,2,1,'1616110154641345668','',1,'AAURAZO',NULL,NULL,2,'B001-0000330',0,18,'2021-03-18',1,0,0,1,'70jlarJzJaZGeeUrhds4ZFiNXM0=',1,'JWAHctuazBYrvc6Sn3W/26+Em2XSvqfs63VeVDhmKHevE3Wi380FZqJWAH2XR4M0RrOsjiHQ+F2C7UlEUtDmMbgwt7EdB+DxiYcGs14zoshe+0Pn5H9vE+L6tedkh1QvS5yReirtfkdaaS/vDwamLIewrkWS3AIuTMVpnXwN3LPDHUEWHTWN3tPRlJssujD42xVorxPIdtMIsZSnOy6iFngfrqpoHHUe8cVF7RlUWps2YMqm1EgsaK1GD7x8ZlqnWQ8A61leFNdqbETwcLdhxKPp8v0yK3zaP8dZAdtHaSseLigwOnRyOEri8XcQ3mHBcrYUKoeg3+6q2oXFZNNqPA==',1,1,'',1,1),(353,'2021-03-18 18:32:05','2021-03-18','0000353',1,2,1,'1616110253284181884','',1,'AAURAZO',NULL,NULL,2,'B001-0000331',0,18,'2021-03-18',1,0,0,1,'JfE6wRb+X/psiygSH75e5lH8EKQ=',1,'EerpBBJod6m2JYOrgH1lErBHyAmxIEJm7oHTw2w0xmSxzLyKLftYXUXBD+iR0r3GC8HKbscSYjZ5Y0j+TmSXSQrr7XBF9hniexzAeLdGabLofpGNOkVcQ3By4Evg6V4C4ssEKHIqw/Wir46x2HAsBlO9ryB+DANTHU8/pQjiAHsreO2w3f1ECZpwhlTmM4vFxuHb+VF4YKW7aFeR7OjRSW1Ael+VyVltYlPn8r4IDdWHqOfdvUAfDdJe/6JpANmSw1ABiE+zhUxP8XsT+U2S7pNNk2PAGSLbLilPQvxn2SevY9hAK3TYMa3Ba2BujFwX60Z4xkMen/m7iGD1KCpYSg==',1,1,'',1,1),(354,'2021-03-18 18:33:02','2021-03-18','0000354',1,2,1,'16161103291249944150','',1,'AAURAZO',NULL,NULL,2,'B001-0000332',0,18,'2021-03-18',1,0,0,1,'S8QFgmkbM/9hl0a9TcfOuVfivGc=',1,'Gs51djlZNnr4i9HnaFIcLEiAJZSfXBzF8lP21FMyZS5OkyCjiKW5jdbY2TN0AM0w+5KxCQI4kRvry1eS2IxRkESyiuXTK/cx7dlhu6g1ZpMTC4pecXVpzTZA/KRmSm6b0vF909+VKquwmzWfxSauPk7rJPXifvJDLVHqMxmKE6Nek6letrQCDnslf3mqxzPIoIWHz8ENbxFbCjUwtG9LGZY6sElOca+CC4FH2zYuDq1/QrbvUSTI4KlBWKRoSVWNhfmpebXesdrdBwxPKoLlvHmrUlg4eMh+FwqRaFtld236j0CoFYE7wDGjNxbr4Scjet8lmCTJZ2cd38M0Ugt4Wg==',1,1,'',1,1),(355,'2021-03-18 18:33:37','2021-03-18','0000355',1,2,1,'1616110386926259091','',1,'AAURAZO',NULL,NULL,2,'B001-0000333',0,18,'2021-03-18',1,0,0,1,'ARwa41lPHf/VAAdYBlfrWbTCcrE=',1,'Z9jfRcKfLWh+EPmc5/iwAtfm90+9DbP3PxxeZefu+J1do5UAvvY4MG7WrmxOPQuuTZPJ2S956A66DeC8vgVL9FqZ0IhPOV2uhSDG9lT88bdRE6Gua58XGN2sHSkPVMAVjqMXEsCYTl7qWCcvq5HzKdXg3Pq5Hx/nIqOAHakf7YTxPF6qcI8Udf1tPcgJFvdqYJYEz9Y8znpeJwP1OkXDec+6Ymv9u1/8Vtog+x2ODfBm2bmd78O6HZbOW1Y2tkiWiWy1TYty2SD9jCj4bTcP9um9S/G/Hw88Za2jOMeIIqAsMZDMIUB6cGSNbO6k0nqft9hxnxZYw5tGg8oTJ684rw==',1,1,'',1,1),(356,'2021-03-18 18:34:34','2021-03-18','0000356',1,2,1,'1616110422267829807','',1,'AAURAZO',NULL,NULL,2,'B001-0000334',0,18,'2021-03-18',1,0,0,1,'CMQw3kNMsi4Dx7aTNDV0DH2lHQk=',1,'cAic7J0LAKPgrehYd2plyp9t+uylIvHPM3MVEMKlSsebCEDlaom+4CwrrPJmq6QLgY34jwJTGnQi2LHGb6bEun4ykaDGJ00Z/28D5t6NhuqpA+eZHuo7H/2S4+PbJC+rx7FE8OfO4mHXI14PgNSPNO5FrGFQueUaHfp6JkUh9kg4xfTdaLVF0trAxUdjJTYPYKkuYcmu9bAuGelsN4s39S6R935nTYUnn9kj7b2GUBkJlpE6/cHcp+wVoxQYKLf/kK9PXUQKlqAi4R/CoqCA0oEQCw1xH0B0zctO7tOEk+2+7YKOxFP653lR+55pMbhN5My3BwP1lEku3vOCyb6aNg==',1,1,'',1,1),(357,'2021-03-18 18:35:59','2021-03-18','0000357',1,2,1,'161611047774014664','',1,'AAURAZO',NULL,NULL,2,'B001-0000335',0,18,'2021-03-18',1,0,0,1,'z7tuubmr48+n+CEfp4kImlMvhh0=',1,'PvKDwSzP90kKBuyDI95o2O2CxlfLx2kj4cfjSk8lFMTNrp5cNSgm2Rv9fe2q00hZHuj67ywrSYTX0gxVqhLenJ2L3jDy8Yjtrhl1wt4aEVIjcBqLc0WR26e6TljuJ0B4mcXyFjGzGNEaTI0Rz92TkDdTX1Il/4teb+dzVVUEssI9/MZRFFFDye4a3LAdLjlnh6CVPOoTKKu3hn2u+ZRnsGVWK3/G0n72+W67jym3U7CjnAkIlAyryNNugpG3JjiNlZp1nXjQ4Yv1XG39VLy29RUu3ERGwdI3ttClA7HJVeJBdBky/PyTJb5a+RfHrzTDrLkwIHQxz+Oj0aj38ROl+g==',1,1,'',1,1),(358,'2021-03-18 18:36:57','2021-03-18','0000358',1,2,1,'161611056387741802','',1,'AAURAZO',NULL,NULL,2,'B001-0000336',0,18,'2021-03-18',1,0,0,1,'dFTxjH7NfYnI7qNXfJqm3X8LbN8=',1,'MdhE8PzgZVENGf8FbZP8zRsdHbIPaeRfGmuIGuLTE0tcQJpURZVoOf2Ien5Go9yje1xBpTuvJDk2xhCsPBwPulz1xr8hyJ25Go4WUkE/db2mCD1duqHd/jHMsib/4sVk9sW7RNGU/0kRP1cp+h8AveA5Rj6Gs7DSkhph///4cO9arwzE6DJ7zzAK+Iy0vi+U/wNE1SeSu4ma7uE8s38iANTPBFXx6awUpaMjIivEkMWYTW6RQjzP2X2n0IAe9TzrcIJi+QLsFMwfsAZDXAYSBtE6d5w4okPAU6nHeEV7hBNhOd5Rj5mzNB71pkA5u6cs+aG+pEirVZ7ZL36nLqW/Ow==',1,1,'',1,1),(359,'2021-03-25 18:33:55','2021-03-25','0000359',1,2,1,'16167152141315954902','',1,'AAURAZO',NULL,'AAURAZO',2,'B001-0000337',0,18,'2021-03-25',1,0,0,1,'9Twm58PT5q/ZqmNUDRhnulcJor4=',1,'jcvAmI4jN1/YrIFAjXvycfnoAqVAHrW2OEzeVHg6qs5a365i914PcM1Qk1ogZiw+38nh+Ajzy92ycT5FNVvx8O2yP/p2AklQDMS3iaxaDEGT1V35uJ8d2uTXBaF06O7mYa1VMXCtLilO2dHnpTBEV8Ud4/tT0Y75aheTz/Ust+ENcx5shKd6v6CdrsmmggVeSZMVwYoS2XYspTtgeWV0GAsQpZxtRf1Qwq2CF+hRYwkWgDBH1y6LSRcPLk07/bKeHoXchHyEtJ+wTgnrlBQYXqj5EqoBJS43JwQOIF3RlAk7Q9tc9D+aEcdCEuhDC8snpagsDDeXmd53fau97Jn6yg==',1,1,'',1,1),(360,'2021-03-25 18:34:14','2021-03-25','0000360',1,2,1,'16167152381083239029','',1,'AAURAZO',NULL,NULL,2,'B001-0000338',0,18,'2021-03-25',1,0,0,1,'8nJygtzZdz848hrWubyzBNmxfu8=',1,'MlQmlxdCtR3LQ1pv7jTbPt8zHVLT4+tYFiLwltyUPOzS79MuMpdybr4sM7+IWMoqBVky/Opt7EITNZa3xmCxRRrvKSX+PVYOJqw8KMxILk0YDQYhf4tdEtMsLdsimP4knGjy3zBlfLILKGfOVkNLemd1twt/LB8lWuoGFiNMp/iBrEGHydHiLVCIfih2SYPXaDtqeiFVGv41LuNf9zjixwL6c4G72eyEWaur3QgJ4MPVwmX4IY44kN7OUEAPwCcUQp307rRjsCEEeoxS5hpKVS8jaD/ms2INlheqtAvCHh8X4+pyzJagfmHkaclD9/ZEeBznJWsPLDnkNPNWH/urpg==',1,1,'',1,1),(361,'2021-03-25 18:34:40','2021-03-25','0000361',1,2,1,'1616715256286075282','',1,'AAURAZO',NULL,NULL,2,'B001-0000339',0,18,'2021-03-25',1,0,0,1,'hbkxGIUGMjcsvA4Ng0yGA9OR9NQ=',1,'VqQoibMGYFvZurhO8ek88yuUM0J29GmsDnY96krcyC5Lhq4A+5v/23dGCraGDYKk6bcz8nd2Ed9eTNTqncgrtrMeHuA5BPeO4XHKayP0r67a+HK7nDR0ide/z3X0GtYqfyVbYEXhh24IwL2+BAr7TdOhw+6Ai+1I5qC57zYZzPEbXAtULFQaGMJLYgHfS1lhz4ug0leBsFgt2AXGuvkTkSvg6O6vrrAHGSi+YwxjgpNzsaha93BOu4JRfjpwzzPDhNp2m1HYgTYSBC4vx+0sDs8hqGxJh51Uiip2jBvawmPsZCxnktETNODG7aL8bVizeBqmowT+zyAteAz/29COGA==',1,1,'',1,1),(362,'2021-03-25 18:35:01','2021-03-25','0000362',1,2,1,'1616715282398947644','',1,'AAURAZO',NULL,NULL,2,'B001-0000340',0,18,'2021-03-25',1,0,0,1,'Onu7Ipt8xlvbxnQovvTuH3U+NqY=',1,'Dx0H7b5hMHQx/m6UFSkqXZKaQdSQrt3s89Onmysw6pgPpFhdiRqsoq7maIsiXgJyd5oYb1iVxd1w\nTjZMRqKDe/mJTbxRcJVr5wNukzwyj+kt0+IrWStLoWpLfp1bgX6lDKEphA/mRo0vF0I2fkFRTVYG\n0m3OtVlymb/IszwsIZr6rP8J/b3sMmXZTU0bMMjhDRACAQBSKqgFu+1wpYLc6H3Qup9sHUzEwFp7\n8g/Rl5mBVUz9XDltJ/gyvLuyifXQB8uhfzcJ1VZp2CmwNxVYXv6Fy4isv/2zIJwi0DvcxZW7v2r+\nd+j3JtZIKb0AZRSFXyvu2RLaY43tudqbLDwPGA==',1,1,'',1,1),(363,'2021-03-25 18:35:36','2021-03-25','0000363',1,2,1,'16167153031031557860','',1,'AAURAZO',NULL,NULL,2,'B001-0000341',0,18,'2021-03-25',1,0,0,1,'6M9E42sTo5efjQSP0V1IZcTr2d4=',1,'TV/1moSG0M/7V1ibIzjX+VaRL3TGVG51ks3FbMsmXlXgikyGUV4VOQNSjZR4Monn6MoOhwnMjZlD\ndVDiBTtB5yAl3DCNPReEpszhy9UJZNWt7D73F2GwR+Unlxwa5TKyv7t4Cdchgjx8apHMHmkupkN8\nsn5+GhMzJ0CtpTPBbOYgNqKTyz9GvgwxmSUTdy+eCdVR8K2JWi0eWPH5HWN5JSW+BXSi+IxBeLcU\nDggxBK1MUM/itcbSaINge96apow4z97mPo3RdbsjfdTZNYhs3i+vqTCFjXhdtsJBrXKP8kwnT01M\nuDIQOtY3fGXmf/eCOL28e8Cflbo6+xLvb4Zrng==',1,1,'',1,1),(364,'2021-03-25 18:36:07','2021-03-25','0000364',1,2,1,'1616715339908917283','',1,'AAURAZO',NULL,NULL,2,'B001-0000342',0,18,'2021-03-25',1,0,0,1,'kO/pt8dk2DEn0JJEdpRt9FgYv1I=',1,'Z3EFU2T/mNO+zOeiFvdR6FL30l8GTq+oe5i/W8K5C3dxw12QMno/zVu/PQnRd0/e6hDde8vRIAtkkfy+v2evB2YPdeqm+SI6EmPobYJbKE1XVG2+Qn+FBRH4gDt6t2jip84Nxa/VGDeUuMESXLyTavXSBvwSkvXTN76bIHqoAcFUw7DcGxfHQhEyHYyG4eMB8GQT5UKEu1yD9fygJ4dcXE1dlY/aIYHtAaI7eInY9S0z0S7QFZl71Qtj23dChctlhP2O8WWHVU9Vldu4DS5+rsMBq6N2C6TCgj9R6PnHPsDecYq4gOBA3DGG9EZI2Wh4oWzbpmrX/f1tbGz8IPtOJQ==',1,1,'',1,1),(365,'2021-03-25 18:36:30','2021-03-25','0000365',1,2,1,'16167153691297537300','',1,'AAURAZO',NULL,NULL,2,'B001-0000343',0,18,'2021-03-25',1,0,0,1,'j1mfGmUdNFHuXnDLVZoYZIK0vgE=',1,'UGxUj7ThXoaTc7T02CzSTQ+6xsb8ohadoumhdUmHFGLaMOunp3lp0xRRIvDGyq0E1ZBht9arXwPX\nkKVz6P86ZHTSw+XEmJub1rujXnGxukmb09ayDvDHvG8t3dPgMAgyvS1Y0jlv61QZ+G2ZLCyf93ZR\nbcFU8e+8uD52YLFyIXLOQfWUZ8Iu5TMc36Wx2W4kVGGlaj0wxtRD+I0v545jbJHOamj0RLt/aMYA\nSrtuHvELIMVL66Luy2JnPHka/NVfIJ/2Qu5a8aaU898/t9r3mBzcg2L+7BYFjfpkmS3gMwxyWJXf\nCTWgWRSaKngUT3i3zAe6LYYjBVn/Pji57I79vQ==',1,1,'',1,1),(366,'2021-03-25 18:36:52','2021-03-25','0000366',1,2,1,'1616715392121005369','',1,'AAURAZO',NULL,NULL,2,'B001-0000344',0,18,'2021-03-25',1,0,0,1,'lbcirxjMEclQN0elCyCfO17jL/k=',1,'Tfr8MLURdbTDzQgO0pndU4liI4ierILtKMOQrLOKDQxs+7U+nifPUhImDpPjGYxTJKwBujdls5LFdGnrAH3ouukROs344SH3oF+shqHleglPEG0JhmjTWvb5+wIijQQTHoBxAy0YgZWqcavrhrNYiE5EiI2btOPFNMgaxLdoSGLLrEQW57/wbX8Adbn/HrpkRo4zOUzLX4Qsy9l0LuGAKH688uwWZG+QRyKobO7rhT3gR+l6eSJStA67j/7kjwAIGKUOUVUYBehGUwWZ45Bv20yUHXBQh1RpM2rKVlIVuUFebyA+xFEsTRml65mkXJ4SQ5tnPNlQhArnefKTrkiDig==',1,1,'',1,1),(367,'2021-03-25 18:37:22','2021-03-25','0000367',1,2,1,'1616715415432555465','',1,'AAURAZO',NULL,NULL,2,'B001-0000345',0,18,'2021-03-25',1,0,0,1,'pRskHx04R744WZ+9xs8vDuYXh7w=',1,'gD8tL1aM1r0TqqF3SziC7jE6qOzmMWU64g8QXbNxx4khTYff+Zx6R8lfMmQEjx4sJa7CZLYFc+kY9Pg48sJNr0xuDsJ6tEj17x94GgSFyO62Iw6vOihhKu1Xe1i5xapBle8ieMe2w6uuUutfnvoOWm0EJJsJUf9slXwVsYkq/AA4d7HNm4bQlktuQlORDvOQfelg+AizXlylWAA2n8gsM85zb27cpkF69RHQxVzXscWc51uRcJ6L3psyUx4cQuMXY06U8R+OIegwL2Rbr+XERnmWNjt39aCdYMtZYqMBrMu6rsmcT0H68hWq5eACWYEoIvr8sgqB2KKqW3Qsx4WrRw==',1,1,'',1,1),(368,'2021-03-25 18:38:16','2021-03-25','0000368',1,2,1,'1616715444846306042','',1,'AAURAZO',NULL,NULL,2,'B001-0000346',0,18,'2021-03-25',1,0,0,1,'AYOslWdG6QQQVxx4PD+4soGcbyY=',1,'HJJHZzKNFZmO2pxB3mUacRP7PtCci44/+aMj8bORS9Vj8d2DPW5i+er+pLZZTikjcGHTEzlbLa7i\nCtM87Tp1bAc7uD37Qh+JrAETIPyiSrB/5+mP6GxcCpCvmtDldOAdAZDV8uwIaTjxl9q2yCUB84rb\nngkyvliJrhdhsmMHyiE2jYFJE3sN4lpsZtATOp/9FPFs1WtEzCpn79+EqOCY4KoYnlzEKBqJ1mzv\nDLXWsYpVSf7ETSd9a02xyiF47t0jYPbudAJA/K49WW53mFsD5uL/VPbztodBrUm7YjHikvgich97\niIEWcuEjZEpucbBfQ6J6ljhMx1Aua/rlfKi0cQ==',1,1,'',1,1),(369,'2021-03-25 18:38:38','2021-03-25','0000369',1,2,1,'1616715499529463037','',1,'AAURAZO',NULL,NULL,2,'B001-0000347',0,18,'2021-03-25',1,0,0,1,'4EzEOC96aiAu+GPCxK4qDmlPwbc=',1,'bfR8kCikNhHvKBSvj7ZU2RQSiVr1NU3alisAsP+ZvqFH21FkFkB54Tt6xMx9RUPjq1X9t8DqKgZaEQH2GorMXQIVkddUzPstPK4AeIwWM+wUN81FmD/Py1fiyN4qKYZdVXtwlheKByIxPcHGVkLsdtBGaFYEgfCQlCi0/KlLtK4fueS+6Y6n9DvQNM8MKfZMrJ20MNe96Yb2eO/xnirtwwnqmlXRpR2kvnnJXYxrQqoUoX9hIiDbIkzaK+mkGZkQsMiDpdOkrpSQfKa5NPlafUnDbJUj6ElB9OJRYgKIkVPEUbicjy/ljFBIh1Pafoxkt9bWSsvycwt+5n187cZlng==',1,1,'',1,1),(370,'2021-03-25 18:39:11','2021-03-25','0000370',1,2,1,'16167155211092619957','',1,'AAURAZO',NULL,NULL,2,'B001-0000348',0,18,'2021-03-25',1,0,0,1,'Ju6ktfKQp/mnCOSlvFnriPZ58cY=',1,'XdyXYGKnWuV7iRKGlRi9XPlfDyxHgd3yiQwpIuNy95+fCTYQ3yegU5Wqyi/JSm+OHBEPl2evFofcJsaVYw5xEPFfp5WfpK/LFm6WU0u/27MVeBJ4IRQXciyGnhVpJF+WTiYBRsAH0jGxGiNLvd8fSh71lV27oyeVB7wtMEqNUqEXbi5GzXIv7pPOXqzVJ4FtVObs03oDG+gV4b2EjtYOePFZdCmfuXwVF7LVIQt0fZseYaIaPYEpD1kspokAFds1E2eI5h3bRE1z7/HORBtnPMsWzZJI1kfs8yv/XpR7QoXNd7Rboj3RJgYyTA3Y595RKW1F+iTtbdhk6MgD2wLBlA==',1,1,'',1,1),(371,'2021-03-25 18:40:51','2021-03-25','0000371',1,2,1,'1616715553200054751','',1,'AAURAZO',NULL,NULL,2,'B001-0000349',0,18,'2021-03-25',1,0,0,1,'fC2DJzLgttZSYQX4AV7LkehsIjg=',1,'QRBqiYn2idp8wlCfTOPg+n74NAIiZX02Q0a6Z8ZNeoSSb9od95vTkuVDy1r83vPCOCB5t9BNDDvj\n0vfpm79DnX5hPbd3/WCFWLikI4cZeNQ9Py1vb3hQ/baal0iJlcqrfnBKIc3g1PBlXW0ReINwYJB6\n2JeRtxzLYjiPVRNoaeKO8nELmpWUir4YLUJlTUhwUWEfvqCRf/sCYGj8oZrbYTgDB6M7Wj3tL2Or\nidYfsfOVP8lJN7IwoCaBTCmMtpE4JKFmfW8sbtageVQl/xOwZ3L0LxamurN2IUOjl0lVhPd7Vdqn\n/gXb+LBQ0Qy3RrncF5Cf3dVYtHoeV+CUsQOVPg==',1,1,'',1,1),(372,'2021-03-25 18:41:37','2021-03-25','0000372',1,2,1,'1616715654838345162','',1,'AAURAZO',NULL,'AAURAZO',2,'B001-0000350',0,18,'2021-03-25',1,0,0,1,'p7IrcO8uBgvkB8GNsFRGvwsu0gI=',1,'bFfqdcCDR7Gya4Tm+ewRSJSPIDWDMIDMWf5asQbmtZGJwo+G61v+xlvu4oKnr2E8ukZtbYwqiupn\nHXfMUy1giXUJqoBZICy1WDo910h8VmX67l/SINI8tu+kinR7bKmTYau5dYR7s3q0EpLdvZ4Ip9d7\n6Yi1fIvSISeqgIGwRhieCri2b8Wjd2U6j4JSPDd42dP9nQjvJ8BVk7MAINaxDW0D8hjulz0J18hK\nmgKgbqR5IrgRfOBWXIUdMa0XWTRMi/yFrgWybDKCSiTBhidMUt0cz/Nu3Grqh+mujmfFts93noX/\ncJjJALExmM2DFT79EIlkawhETroCG0O9s1EZgA==',1,1,'',1,1),(373,'2021-03-29 18:08:55','2021-03-29','0000373',1,2,1,'161705931075735935','',1,'AAURAZO',NULL,NULL,2,'B001-0000351',0,18,'2021-03-29',1,0,0,1,'2rhww5pUeXs/rHW6UmnOpKDGGbQ=',1,'IeP65gyPbb+PEy91fohK13AVdoTQSzT91Y/7069okExELUPC6qr+lD7yCnNfWlMZZi22w9CZxoPL\nmE8rsQnRNE3W+egOq64O0xTnUbpvH0LZJgHgWQ0a0qZCFZWqG9wbSMiib3p+cwAguu3m49Pg1XJo\nbFDAdXpVOJCaaHDgkbOLtq1RupYyPw6kEcWx/SrnbM253f0tAllXBQLoPFAl50YFDB3PoCsJeFWH\nTaJqhy9+4rq8rcKKYSBDVcRZ/+Oo0HxyEJJ2ZHa47WWrqwj4Tztt0mqzPQma9+Ucjxy6AohAWZnj\nV1402OQOWUeKTNbG9FjzuyJs7YujBp/2Mbe/bw==',1,1,'',1,1),(374,'2021-03-29 18:09:41','2021-03-29','0000374',1,2,1,'161705933946775547','',1,'AAURAZO',NULL,NULL,2,'B001-0000352',0,18,'2021-03-29',1,0,0,1,'dYBqYAO8xyuCX/c2xCCddsbUBFw=',1,'GfKpYIvvaKTvav3jpzpGADEq08GVJjU/JFvIyZET9k7Ubae9KdEyImhtYTg7sH8t2JfHCphvDlGe\n50y8w/UwBqPCMU5BedjZlMtn77oJZFNnZbEJP6ZbhmmfBfs+naDhVo+9g7aYaEidtMV6K1OPJGxQ\nd7B30g4reithipeEYtij9moR0tAe9Y1r201jYRWGGBbayrv74Fzpyps9qRYN3M9YG4mJxz2G/r81\nFn6z930gc4DhosL+sadutccNE/gBeeiNJpZd8n0J0+QWPhaJ8dno9PT+eA8tEmTLq7mh101uD5a8\nkf0adksV+STlL5nO59IoSXx8GCpuDEnmOipimQ==',1,1,'',1,1),(375,'2021-03-29 18:10:13','2021-03-29','0000375',1,2,1,'16170593841271632167','',1,'AAURAZO',NULL,NULL,2,'B001-0000353',0,18,'2021-03-29',1,0,0,1,'TEwJk/VrIK0cYkXbsZ+JHIYcs7c=',1,'etVXfNvD0MYKFj0RL+samkF0veoFXYBHES+JdhGI0sQxy4pQtviOo6JITf1zcAfPivZLzOTiFKhxsGgFIW27yBmjC3xnK1oUbBU5A3CqqfkOAOs8SSY2gB9WUTJJZtrwSRsPBIXQr4M7RLsdYomVcndcjdK9TLa2JrZoZPR1rLA36h3i/U34KVA5UTrx/lIWpV67HA/Scf6ttA8WdJZ4QUXW79+dZBHCLCcaFmUFdsOWQNXchbEpH1Fu/T2eGg17+ciPOvkFsY9wB4GkfvBnDd4KY2rNH0H31u/gWfwuTJhFGgzQRSIxSGVD9gpXSLvYAfthPPajYdt2vCn4eN7dhw==',1,1,'',1,1),(376,'2021-03-29 18:10:35','2021-03-29','0000376',1,2,1,'1617059416540307045','',1,'AAURAZO',NULL,NULL,2,'B001-0000354',0,18,'2021-03-29',1,0,0,1,'xEZdNOCzXUGzJkJbJuUZUzvL+Tw=',1,'WQMD7r0mMUMNPw1S90AtNYJPR4dcsZz/Qixy6Fcm3AIVMhTDvnLFQXKK0Zhe9fsfM82zdVZHC+nk1CFBOu3XFIDjQfO5QnSiUvoxhk5uHHOFxZGMkN4rmaKSi/TvYMI4UP8YieOOeDX50pVenlZZf5x0blq4Lbd+o6pk9f6CnS1JlaanrgOwEr3QmtgFI4xd77WWof+tIlTPxEPEh8TabHO+1ZV1s4jLmt6wGWhlSFmBEeMEw2k9IyqvrTc78kArBG1CoFfDKyQ1sdozwSsQOWwru6ewIb8CPhlU/kVptd0PN2H+Y0aVOvPECrWdhbotKBrYmoU5bes17NOqDCxc8Q==',1,1,'',1,1),(377,'2021-03-29 18:11:01','2021-03-29','0000377',1,2,1,'1617059438885766185','',1,'AAURAZO',NULL,NULL,2,'B001-0000355',0,18,'2021-03-29',1,0,0,1,'5sgg6ImVWqbUNko2918DfVW9cDw=',1,'FBoGjwkqMStSavJEWMyPTjhl/mZ2aP5ZH5ETSIQJfKPa+Maq/b2t2J183hikmNIngvCF5R7XCUkxV4UZNR4f54zvIV1E53t+1NtqGv4iaq2PdoYxXoQe+N80ROWYkMUgTEDN9ihqPyp9BNynRO1LRihMjyThrIdVOUQ6prGBF1qZOmuiNHHY9Zk/Ex+RWT8eE49fx2xkSs5THjYvzh73gLlIKjEFdGzqPdKNp8MRni5jCYMTfRTOziwZBc6hBOK+i4iEEPCO5GXKppk1cN+2UoglZqSfd+zrAGFGbPKZmoZXHlIAUv23puhfgfsQvOsHlQ0w+Pd0pgpVWLiyNkzv6w==',1,1,'',1,1),(378,'2021-03-29 18:11:32','2021-03-29','0000378',1,2,1,'16170594641072997465','',1,'AAURAZO',NULL,NULL,2,'B001-0000356',0,18,'2021-03-29',1,0,0,1,'1Eb9v/0RYyMjs+HkPH/8oeFd9lI=',1,'eax9Xn90m4JprZAHSaHaCIkvCod8fRBwZz95ldrG73J6RhxIKuBtGB31DlnOa7kugo+xszfiQkoP7rZl0ki/GnaIwjvODZcTPthJ9njGhJbN3+DQ0vUqJCxyy3wj6EEd9HyT7VEm5/08I6ug7M5CICkDtppZeD4s+HK2w3CLxJmhXadfKFqC2ZtMqFlFf2ZwfcAChboCQHlxmjLZW45+DKfEA5IplqyuALiPXYZ9tHoOvfzImAQbDQUB3ahHIC/hXOYXlSrhbqjk+hsFCgvJZpZrvmde/ih/g4ophLkobbQelknEbGXHvZP/qnUE8HV6vpWdGlk55YpXE+i0XdVLqw==',1,1,'',1,1),(379,'2021-03-29 18:12:18','2021-03-29','0000379',1,2,1,'1617059494459321233','',1,'AAURAZO',NULL,NULL,2,'B001-0000357',0,18,'2021-03-29',1,0,0,1,'sorWoQFTO7cO9IYTkZCxIyci8mM=',1,'RvF+X0pUILrfAsStuFbgxGAdgjtKjuW5MgYNxv3w7PZueEHfu9yeLQg1Djcaw3xQnHsb1NnT5qQQZVH0rP8pk5Dc+kuNV7tf8z/4dbvAGdR8Qq/VMMMaoF8ZCEsQ8yVlAwP+hjG5hXK+d9ka/Rw3RbZ+yOF1zRLDVz3/av0Jr/BULD0bVjSC/cckfnxqMNU4lwC4/CtoMFJUKnlbWiLl4nDKLtIL39pwbMztNIO4Hs4/09OQOPRAA1rieZJ8O/1BgNbESRJzg4S7x2UBS3ShciG4ZERVUqiyzawVfpL4W512K47mNyNkx4WW/d+6/LsGmSAK+6EcciGHecW3baeiBA==',1,1,'',1,1),(380,'2021-03-29 18:12:46','2021-03-29','0000380',1,2,1,'1617059541999413119','',1,'AAURAZO',NULL,NULL,2,'B001-0000358',0,18,'2021-03-29',1,0,0,1,'drKnvdtQKZJzMr/FNz7XJ2m5jyk=',1,'RViGi4x2hKLfS3ibU93EMoO5HucW/jbNufpl7+w0dua+5GsbOcMBomnzLH9CLZFfA3g90SQo9lXbm9iFDi7nLBskZneECZ/9nCUUxAAotxF6HiQ7QqwVsplxpx1IX5XgdjW0zokyDzvwxI+ZpnQ0tGL8KFjTX+hJ5NxMJ+jRP2c4VJOjk0UV+gNUXyhbKQ8bB/d47RSVAnrObgxOP/P5DUmTAno0ZeRV6dHOA5McB/Rsl8SOY/Z7EXz+ulN6UXIWeXihwLyYg9GcMpPBhj3lxYPN+2vYAaNVVp6K5FIFrLwtLUV51/iteAa7Xz5tjHWmG0+STdTGSYchgH7YMQKaiA==',1,1,'',1,1),(381,'2021-03-29 18:13:21','2021-03-29','0000381',1,2,1,'1617059569249024918','',1,'AAURAZO',NULL,NULL,2,'B001-0000359',0,18,'2021-03-29',1,0,0,1,'6Qrn7UT2hKY1Js1M7O//fAPK33E=',1,'QIrNXXU3I8ZlZ1zNQ2wQrU/OF4ZuW/1PyozaGJUMCtFqvIszBdCVPi8UGOeGOOKMxVCm3ETxN01VJPwknrjedMVa9q5ZQOdVbzwOtW0gRR55+QCtv68xiHDukU3wpNm1bWo5HfOEC7vBMrpKW5g01HTJRR4nkEBj3xaJs0C27foQ9NgMbe9jnAwvgHgP6ywj+JKkxfs/XRgVMo2V5xBjvq+lfyWE1p/YT004O9hoxjoh28gWpDgSpezhH2lu0s+pUQTezM9cESjL34z6pIaR1PEiu2ul7KQr3ETGlq+couvTqcbWP7dBUfpP82xKX0FyYSVPNYdQc92LAtfl+wcszw==',1,1,'',1,1),(382,'2021-03-29 18:13:41','2021-03-29','0000382',1,2,1,'1617059604642593589','',1,'AAURAZO',NULL,NULL,2,'B001-0000360',0,18,'2021-03-29',1,0,0,1,'qpm0XvVNsrmLHWX/0PztdobuJw4=',1,'X/WiLT6qepMfsz8kxQDGU7uk7wbtXx3aHRFX17oqFpW71Vg//aJF+c2BnoPEDqE9wZR6NmJUi0ISR1tQ3kaZT9QxYkQG0OQmF43gs3jL01gEuaRHVqtTVcG6Xw+CeHg9KnRFJ/AA2uehtd51Sx6Ujon7JbMNLPOJKT2YhaCdN7XYaowXMDmdJLmrWaqj0Eozo58ISzrQzz5dqlZfbbQrTT3k8MnkpSW3p4brZuqxC2duSX3wv/HrOKIj0zmr0WVSEjrmcq/Loui4awXNnSG+BFN6zkKi+UKvQoou9lTmdovIV3Oi8JswOyoyeF5cH1Cwc6DiOd06oxTuLY7580pLLA==',1,1,'',1,1),(383,'2021-03-29 18:15:06','2021-03-29','0000383',1,2,1,'1617059623672414614','',1,'AAURAZO',NULL,NULL,2,'B001-0000361',0,18,'2021-03-29',1,0,0,1,'1jpStdtUDktu6Qd4n3uz6xeSO+w=',1,'YH4EDcerglM0AilEEx27cRkj4FmNR3rjfZMbrbn7jSpnFm9/6+tA2wd86+pgSTZ3bHe1kUeXwfl40e4S+YGvu5/KWjqsQ4M6SEqchd/uJHjOw5223zMaG1bySbMVjnXq099Fvf4OxuYTf5VuRPccY5Ys4Nvhrxk9x74WuuGcqJebJOYA6Mzlu/HptrzDOY1ewN5If2XMRk+uWKMWIieL7wbI9taJgfDRNn80JWPAvAMk7MPszTyloyrMoHTaarZITeMbi/e0moADaZz2RmlQBWjIx53FAwJBqAxGbesc+s9UOHbtTCSuEPgBVGR0C04+I7ym4AGyhCBWl3NzpI2IDA==',1,1,'',1,1),(384,'2021-03-29 18:15:29','2021-03-29','0000384',1,2,1,'1617059709439999963','',1,'AAURAZO',NULL,NULL,2,'B001-0000362',0,18,'2021-03-29',1,0,0,1,'Y+rKV8u3HWAIL8OL2WfnkRTgLos=',1,'DjbbPlER9g/Nyy8nHZfcWMpt8h+RGRgw+8/YVEvyG3HeyOnFlENeiUUXBuLtGNbORN16pT07haSKl1REKOgpNXKKMSZt+xqq/FNURMcXIjYEOlpFNvV4vRP9BUHyEVPF5yeTjw+TXf8g12RQlbaQgxt/8I6v3k2dCismPYNM4osD7KXVOL8gLEPvV/tNs2wYy/B4MJH2Iiu2WA7vr+eC/nMcgILl2ogXxRT5MjcdgVuJ+p3eY7CBU3Xqv74K3zTCp7fyhLdlMVg1aCz/FhSTNy+y6XObgRvUDgupJEfCP3NWpn+RsmOaWlkQREoBAF7UTFVVKmS+U5vbXRVA5MzNrA==',1,1,'',1,1),(385,'2021-03-29 18:16:00','2021-03-29','0000385',1,2,1,'16170597371071491353','',1,'AAURAZO',NULL,NULL,2,'B001-0000363',0,18,'2021-03-29',1,0,0,1,'fMsy1YJcRrcuLnJBYf08jW5FRkQ=',1,'faCLfeOAlCfqj/yJn7oFlm5mJBPvmjzh3l/HBkBRDw9hVp21FgSSwPl/TywFB8ZGkfhQvsRJiJD2WlX5LLzM7BSdg98wrYeu2qXb69TF4uVwkMv1weGD433F33JDUtTH4NM8FafuPsTT2eQB4/qfSxa+fB4deftJLvMvhTvSixOxiceT3me/u5ijRrg9RZxmt7T5BV9t10PLdYMhPxDjkfeNa2C332JfwcfcS5lClpqhQk2iWIVk89jaf7+M0H8MKvAD6+PrS07JBugO0PruYwPtn7TFo6zu5qgSLyPKD1Y4k68IauZn6C3P3lMyHQCQhhqm86rsJ0PeE9A6f5wl+w==',1,1,'',1,1),(386,'2021-03-29 18:16:42','2021-03-29','0000386',1,2,1,'16170597631023941235','',1,'AAURAZO',NULL,NULL,2,'B001-0000364',0,18,'2021-03-29',1,0,0,1,'2lBSy51oJKhk/Sb65w1p2Z4qbck=',1,'hGdsYM+iHJGL163lM+03dna3NR3mtS7raGtlaC0I2laBFN9fyjPvTUPoY4rMFCS3qBrZOGfM0/25X3+S4LR6Pz3mKJVEsIErGugkVZDWYoa3ldsgs6Tk4lalmEuUj4kEEUQGk2kaeP6TJLNPnIO8Z2MabDwOVGFAJxLh8PAtKcJobm0D9YhLP3xX3e7uoCoERjYqe2lSi+JEm/uWjvqFqWFukcUaZj7eFl766z4Pu9jo2ty6BmOIxY6d+ZbrUMWgJlSKN/WFBGZCn5VhPokaWucbDgU9n6PaZXMDbuRpqq9iyFVAt892088dK4CqWfbmg910KhYMv+5dlRDxWKjLDw==',1,1,'',1,1),(387,'2021-03-29 18:17:07','2021-03-29','0000387',1,2,1,'1617059804855816065','',1,'AAURAZO',NULL,NULL,2,'B001-0000365',0,18,'2021-03-29',1,0,0,1,'iTC3HUIhG3ll1W44hOiyEAsytUA=',1,'gsox3fG2QmdacNa3jasWRJhbQqA0C6cY/IQuLloQSn2FJmejwYJPcnsBFTs3OtoQQFzFWecKxSWccP5CKAzmIcaTlf3K73DNKRiuWO4j2R7lP8+O8rO2zad5bdM/Uqw6HOFC4LYMrsTXYQpqe7oSXgjC4tsW+mUfgeU3cMAcRcqbxQUPX7vNTVGOTS2O/uYmxrk1GlxOJ0bBGxKz5Q3ZS1M0PDqkysDR5OkxEMZEQgUwPWOPW99Rr8Tdh9n+HazR16xQal+DVIp4Ms9ijw+6dg9Grti6JlhIj3qObmVgMmXCxpR3t0dzpLH0VGYa6MQL9Qhg65rh51Hq01Lr4Z5tzg==',1,1,'',1,1),(388,'2021-03-29 18:17:28','2021-03-29','0000388',1,2,1,'1617059829939771071','',1,'AAURAZO',NULL,NULL,2,'B001-0000366',0,18,'2021-03-29',1,0,0,1,'xBHQEOmDwFU+SmSO43A23qYqUhA=',1,'fuDUBXUJwz+vTlEpT7rr8VQn4jmusPKW+JRbYyVDinCa/LZ/Xz3RijATNWgwplkPpip2EY+PwrnFhB2A+sFr8UW7aMjJMd4diErzehgXtBtUXx4W97mI6tBxu8owhd8EQ5rqDJOWT26X4yh8gxcksju7CSWlmwOy7NdOTDPsPd6yIXtmwUlnc/TZiOb5+pWR3IHeS0ZVVXAG2r25I44Fwc9WdWAhpxH7PjDIymR2rkzSU7/o5VIHNm3s2h905a8baWMwDgkxrIF35fgP7ZCWakx5i6jqr+nw+q0s7hrz1UDv1gu2cphRiEBMJZ0zIwDAFNHrC/Dw0Yt22U+h/Nl9fw==',1,1,'',1,1),(389,'2021-03-29 18:18:13','2021-03-29','0000389',1,2,1,'1617059855902978898','',1,'AAURAZO',NULL,NULL,2,'B001-0000367',0,18,'2021-03-29',1,0,0,1,'1X9shsoM7H5VqHd9HYYZtCEp2yE=',1,'AeEs0Y3psBTSziIyVo0OlDEg6d87eTfh2Av+iGPv9sRK9ZZ7QFZ5srHXKSBtSdoLkfH7D0bjC7J3GqgvGgCRtssinNz5fkWlH9+RURd5WRpjrWX+WkM2FDVjTH6pqULIMN+970YeVrZFcIv8mjZpcYQmEZcK4fFxyIHWLVhN8yZzx4++8nRuVC1y5KS09jjsgFI4QCmuRij6gt89rb1y4AapSWAnVpKxY8XHaREAzTp95urkatyyIR7Gpt6mk4QDUfUhAdLwpsRxz9zCfYy0H80tUh5O9/DQWQRruVXsDzGFuTimXm7q9h1t2HvXlGI5jH0lIxluqoK0lFinaeJwog==',1,1,'',1,1),(390,'2021-03-29 18:18:43','2021-03-29','0000390',1,2,1,'1617059896663334908','',1,'AAURAZO',NULL,NULL,2,'B001-0000368',0,18,'2021-03-29',1,0,0,1,'wfRy/2IpjpIsCVTlWNWjYPm300g=',1,'UdG1aPZE9paRb0AeAq3sWdAhS5PnfTNmtHvLJ242K1+sMe9gGgrW69O3/HjVBQZKjQGSZfDNzawTWD3DyqflLUkNjkPTfs8EBGbzIf7Dyc3fXDnneAqjWghFSW6g63jeaaFN8jGaBRtqLU31/H+a+KT+Ouc2wIlH/PzWz+CHoPfTYJq1by2PDWoPWH/WSY1RzJ0YGKwfVNHC1U32DmK1Plwj+sK/9DA6EWDIT4Fg5hl/WW8rlkh3HGgiTaaPuFvPdqsgHeZ3goHcqqlGow2qgJH3nUwzAyjKJQgcSq6A/gQ7/L0y/PqMbuqzHF+ZY98ufIjWpz2tibn5W73/fVZIZA==',1,1,'',1,1),(391,'2021-03-29 18:19:03','2021-03-29','0000391',1,2,1,'16170599261374004775','',1,'AAURAZO',NULL,NULL,2,'B001-0000369',0,18,'2021-03-29',1,0,0,1,'A6SPrzsb5n33UZE8XetsNjfRwuM=',1,'RAu6BiGE3O+OVt1MlGKhbRdNJIYZ2kFuoMyXj5p62Uyi2C7wGgbcHFvSt/kvWtOx1riMDPdI9ZvmGDvK96m2/B7jXe6pf/WOAd5pJZq+aQ0YzYgwHhxc4Fao8qU+3Tg6sNM9mBys0WUvSw1Gb5EdStZolUGRqA4X6HcHBYcBHcpa13JXZ6rKAqPV9QXqsXnSyJB+YlW32fJVczmHzo7NoY6O2EV7Eqiem01zuM1F0RJjn0BQFEDsbOj4zj8aLmrLdePj83CYGNHzU+wrrPSRQPz39ZIX+uTIVSqJJFl/RSs0gjHq8XOMGXeT1dUcISqNGcapUAX6DiBBNMZBTjAy4Q==',1,1,'',1,1),(392,'2021-03-29 18:19:46','2021-03-29','0000392',1,2,1,'16170599451315997934','',1,'AAURAZO',NULL,NULL,2,'B001-0000370',0,18,'2021-03-29',1,0,0,1,'gcSWEEThuZohEpXn+za8bufi3Lo=',1,'dKH9GeippZUilt3LUgZeOOUeFr+8hVOlyVXye3E8jZRenKh+Xf+Efwr7tKhKR55JuL7DNY2NkO4JQewCi9PfcJ8lP6tki4d9z4hiARBYT2D3jopJBAxzTrMU0TpuAffkBvrAksbzBNehMzOWw/4crK+r8MKyMurDSKzjEBRd4mqtQii25OuHtX2dDg7pJ9kkj68XOL2MgBoGQrK95nbhWMTOmE9umOWqcjzop8Nn/49EWocVS9bC4QGX4nYsFDWfhq1KkjxAWb8fdABHxgQxHaZs8vpF7iwfRVhiaAVfuF+ptbKGamrW5dTpN232RltufJv6EChkBr8yE7ZIIHx7kg==',1,1,'',1,1),(393,'2021-03-29 18:20:12','2021-03-29','0000393',1,2,1,'1617059988344555473','',1,'AAURAZO',NULL,NULL,2,'B001-0000371',0,18,'2021-03-29',1,0,0,1,'UkqcjBj2qt9LHR4+yrwxiBEVCQU=',1,'Bwr50nyciYBB/t+M1yfHDEIihaGAEVq3BRX9r7Pb/0whQQ3PRpXCwyzc8SNe6ZBlD51N6Ra8XEzyIejN9MRB2GxZLI2nSkRgJ+yPNP0vFX94DZmklHOxbvg4iPpNiOYtopQ89bLA7RbnAjd442rPN5hk/llz/vrkeJkirHpLdk9n5lfITRVUi2wxWSkUFGD+A74YuSt4mc9gUjtH9vluLcoqYZyiq9/evDPQTfRS3j//YgJoFcpn1XS9Rm2oMVXqcyAPjDwNybC84DftSUhxa/wTH2CCxbSQO7yCdKSN/g7mYLU5G6JmSFN/jlukPFEqITt5bUbzJd8qtxiMXhAr2w==',1,1,'',1,1),(394,'2021-03-29 18:20:59','2021-03-29','0000394',1,2,1,'1617060019390556447','',1,'AAURAZO',NULL,NULL,2,'B001-0000372',0,18,'2021-03-29',1,0,0,1,'UfnTGev+2NwpKLQPwrSWCASqs8o=',1,'iu2P8l7SldcyEaVKZBRqHq37pws+4sy9+eYiu+SkufWNQHL7GGqBLzLoagcmF96tLfJX6X1AWmscr4AwsO8dmiHDcsxICWvK0kBf937wHqaLe85M0N3pgawRZ9UrAD+LWWjJn4V/31SPjqWOkQ3YyI2aDUYtvv7r5ECIq8blZzvuWMzdB0fMIFT17VKRk1N0hqnQdfWRe2f7VNPYGpIZfenp+jAPJe476gdhHtjHiqwdToecJfSUrO+T0cwRcf4RuDG+SxmEGIQUQvbhpKEB80ECQ25mHXOYhTQSu8aLjdAJaDxrwFKIGxxdtoEN7UklkljV1KgZc8j/8nH7WOZzGA==',1,1,'',1,1),(395,'2021-03-29 18:21:39','2021-03-29','0000395',1,2,1,'16170600621155446358','',1,'AAURAZO',NULL,NULL,2,'B001-0000373',0,18,'2021-03-29',1,0,0,1,'YDQKOcP5qdMNtCKK5SxUDsA3SuM=',1,'JmZ1K0IG6PCEE7GInsHKSFiWg+OWp3o4HN6ovzfiNQyrkEr/hs8Lp3wMksTbodj9N4zcA+EuK3V6q8w7pPYs1f/ahAF7yIc1LBxnAkiOiz0H0+muYBP9a/S7QZgH6LBMP9O0KgNNbvpS0XHqvHwNvi2rV1QC3SwJ3iPPzzXY3ctGFp2O0WR7mkiHGzcYY704KkUD25u+oiaQhKhXf83jTQ7ntVODkTCzhjBXOelVbW8nfpzMJMYb+KDeAmLtvCJb4OhdrPBO1SONdpdZofNdJugIfZJI/TLeEX7BQffvjIcGL6JWt/XYomfzoNvyKxfx/siw4tiCTYmqrlLIUyxOPA==',1,1,'',1,1),(396,'2021-03-29 18:22:17','2021-03-29','0000396',1,2,1,'161706010248109532','',1,'AAURAZO',NULL,NULL,2,'B001-0000374',0,18,'2021-03-29',1,0,0,1,'7I7DnGrT3/sXwS6PQJqthP52MPo=',1,'BAAXVGOfTQpq10Z/dLYrXbKvlCXe1l2rAD0MwWXiKTwhD1PKbPaWbnKYa+ZIIGhAIpMGXWR/42gW+D5Dt2ZrZv1j0e2ZWSeVEtftEVNlXbUa5KOjESRiR3lVi8h0DxJbx6+549imzioeZtTZjXLvOuzvHcMdGFRpmJHFnMQuqpoONpgsovXF79+fu16BurINpA6POQj8D1WaP27Z/ZSumJSsCMOTtw1Od9JqpPvAAqFDqzhhf0eJ5uTIDUwjARbv/fJ6tQe9CFdOyB2RG/7B3fdTIfu2kr7wflufU9wPO2K31n7juYLSI5eEF5nSrPtIFK45hVcDUHE9Msv4LU0Y8g==',1,1,'',1,1),(397,'2021-03-29 18:22:41','2021-03-29','0000397',1,2,1,'16170601401146366652','',1,'AAURAZO',NULL,NULL,2,'B001-0000375',0,18,'2021-03-29',1,0,0,1,'0IO2q4SIULpQVvH2SDTjfGssyd0=',1,'dYVuX0FIMw770JYKEtjhOagp3HXTqIbCjzNQcUrZgYFWZ3lWL/XOfTwTnUoszdS2qH1FKIPELTNKsqlG29wSIYmdV54OtVCXGeu/qYBUToeK0QyFjUPKvIKRCI0z5eH9VjxIKJllCx4jYzkzqvTsQ8umZoE9FjDP4D2/86uI0Sn3iniam3U6/TgG7yqdCUkc8h+whHr1v7+HMsi7j7ju9ZCd9kJt326xVbPDmWptkLIG2Fkwl1o+5rOLlVP5f+WYXmGAZ+m2kfofO2/JcYlUUJFWvnqPaIlbApjfhfpD85eqIP1ZmEFR2JlCIkxzqnMIh4oyIVHJWwFE1UQ8T1rykw==',1,1,'',1,1),(398,'2021-03-29 18:23:19','2021-03-29','0000398',1,2,1,'16170601641357007221','',1,'AAURAZO',NULL,NULL,2,'B001-0000376',0,18,'2021-03-29',1,0,0,1,'X4okF2tpRkabybRgC2bi5p5jZSI=',1,'eAue1ysTklC0f7CqrejHDIldH8BbzdHoJaqTyoUnvDgnPkdSkRp+f+tJlHergitd4eKw/cafiZ1n5SwLJEEUUfu2bHZuSVwWZeZIY4o+7q6QXLR9OqaifmqRRYbse7FBt6WecYh3P6V9VxNadFSD+TAaCkaaVHnmYZbjblJVfHqANNL/yC9fbYYPpNepJRn0vU+JjnITH6hZpM4mwsJWcjb4ZtRBToCzWVAf+CAlCqS+xUJI7mc5FecUBB7cXWRZVhiCsXWIherj+355RNj0GmTV/yoVrY6ygJG7kJTslZDZuEl8nR6MMVe+3oUPDZS6r9HPV3QnOAcKdk7cQHVpug==',1,1,'',1,1),(399,'2021-03-29 18:23:46','2021-03-29','0000399',1,2,1,'1617060202774442967','',1,'AAURAZO',NULL,NULL,2,'B001-0000377',0,18,'2021-03-29',1,0,0,1,'0VeM9i2cZoGRzYyeexLGbz+PAjI=',1,'F+KrpIgqlcoySYYPn0uKmPMF+T4k3Uy1TVbc3xlKgpncl0fLBqTGAX/jCO/9HdFuUvk8KRTg5HIA2wrjqKVihHy8F0mUUrbQ5Ik6PtZrj+obvcBUpNV07ZHTA73YOt73nPzpP5j4pkQym6uUMToEJ0ppP1Rsx54TyfFZ2d3J61dE03iRlT1Fqaa057s0HaIEG8Y4EHBOfwaEpeDaleM3e+AJ0LqHWt09mUHwT+90Hrs/nh21M5hSE/s5SL0uwNdapVJdZZ5+Xyqxcj+3QVnIGCuaULdpPmS8FP1lay9wVfO17IYSurIx3BozEzBTUjaQ9wgdr4dld/XkJ0oq5Cop4g==',1,1,'',1,1),(400,'2021-03-31 16:22:45','2021-03-31','0000400',1,2,1,'161722573793034711','',1,'AAURAZO',NULL,NULL,2,'B001-0000378',0,18,'2021-03-31',1,0,0,1,'gpbFPS8CvKiNkW7phEkFOe0ykUo=',1,'OwPBoQf8G7o/K9R3MqZZl4Q97s5KOZnoYr5PoYhba3lV8bbut2gFVdD42bV4GP8JZnXH2k0w57jn\n9SJLysXkgL0cxJYtV8n3EJgOUQ4mOOxDIhTErDO2kuoF1mtFWwQ7FsCtlIG9ekQPFYfBvyJbXO1g\njhkQ1BBSry9sS9hlSDhFme36WjSnugPtp+7TbEu6ALTRRThLMTWIKVSPUetb0ZXF1McqmwWjDoUc\nqQEtdmFRoYHKPfc21AJ8EPG9asodQUCt9g8DFK660Tl+i70VA8ZQcfZHtuw5/dfnVdj5hwxlEpAT\n2ZqvA4xB8OX4ThcIkjvl+EJKa2JyE5mVoVxDnA==',1,1,'',1,1),(401,'2021-03-31 16:23:17','2021-03-31','0000401',1,2,1,'1617225768656449823','',1,'AAURAZO',NULL,NULL,2,'B001-0000379',0,18,'2021-03-31',1,0,0,1,'QgoWb0/gqPf3ilf7MgtDDCg496g=',1,'eAzNm8PxSeE+4BvtEDnYNDo1rNx/wiutZtfKi+EqlW4EQ/dWdB7/ppSqpgVgGzR4pu7/6k2vClx+\nU53aHFb7+euOmoW1wSleC4HW8aMc76PS5CjAjw96nZAkbln48kiYivw4TES3A0CNSGSSVRgs2+f9\nFrXjt9ytaaNG1WF/jm1Wfwv6D6mPb8wHVQLQtqhN3cauSHQXAfM6xeHgbbikIiAAXPQ8mZtTl5Pe\nrc+NutXHhRgFz7eDmBk+TfhQT5j6x51vOEE1XvkK1ZX2oZCGToySJF7aL1PNumwfbLC9lO3M81Gj\nEvjgC0h5ZhTdZ/l+iuZaMs1Ha2GXAZoNQNTGBA==',1,1,'',1,1),(402,'2021-03-31 16:24:11','2021-03-31','0000402',1,2,1,'1617225801974626813','',1,'AAURAZO',NULL,NULL,2,'B001-0000380',0,18,'2021-03-31',1,0,0,1,'eRCDl9HvPX6uVwlDxH65rDSAcDk=',1,'BO82YQO9aIQpysloTsKZPk/I5SibNE2YyGCk2+5hPJFJ4y0CBQwWJ/PmsOZQ+pZu+w7PQpsZtUWtoUiDXiKeDHqpWv7K8zVLcnjIs9oc95525NMf5+JQLsvgvopWcpgxfkbPd90QJMpwwGav1oFUoLbekXY8byH120fNF2T0YxxM1ak0Hh7NS5jIZooG9EwLiB4wSviV5koPCslQbOITNx+X8lBwSvkfHGyGJyLlR1TR/P2d6ANHaQOQ58VQTB8T62kcTFZcw6V1wdYCV/qpxIOGRBa8ARDl2StVdpaysZdPZOjmjb1GyRInGNsULny8ifE6mgY9Mr0tNoLNNT8hgw==',1,1,'',1,1),(403,'2021-03-31 16:24:55','2021-03-31','0000403',1,2,1,'1617225854636095790','',1,'AAURAZO',NULL,NULL,2,'B001-0000381',0,18,'2021-03-31',1,0,0,1,'5S2dK64zqDcs/La/ncoTPkEHIPQ=',1,'ZrL+Vcveph68y4tDUlBXw8dEWL1YZOQuS8heJx0lGf7i0Ra5IsOZeAQm1rAaWmYsEIvEdRfKd0uIVINMHD9EsvrINIMbbvD6otZqvGej/sxtw0D2JMdvgjdmjFQKzpO2iQF5TFXVivHjjKrUZ3pFWbw22hpS9dGruC6FU28X7CJZZ4LU3D2Q3lj3Zprn3misOlwQihoYFMZo2+YjUvl0Dx756bP4mnbGeFPeyCNadAjZSilT7bGY+hs6Q/i38n8rLrHBdTlVCykCDQxhj8LCHUinnctnexfarKAuxO6EHUm5Hsdt1xraszMPwWYYhDwqRdIj9QqjOP3VjG50eSxXUg==',1,1,'',1,1),(404,'2021-03-31 16:25:22','2021-03-31','0000404',1,2,1,'161722589735329093','',1,'AAURAZO',NULL,NULL,2,'B001-0000382',0,18,'2021-03-31',1,0,0,1,'vvN4WvvZap6I4lDGUrQvoBC+o84=',1,'iy+zX3iNDsFsWXLTkQqqMJ6cp9emZOJ4INf1WPB/gyBPjyXWwvFSP2gdnCKCGSv8HUrc2cjWgokmGu0yPFoHY8rzLZLMj6J6K1PZgbPyEy69yiRwQst9HLa5QZNC3mlNMXd04/bIAX4Nj3tL4/g+cv7Li0BSN5MPSiBnryfwoJnakqVOpLgQENxfPGQdlNIAbFWQOKT5GIG8KH3tL0oFk+j1vxwTvQCoMKP0/PXgF22wJn8JYIjNu8GBhdv0Q89N9Fzwna6PAs2hDODe7d69FvJpVAF3wB+Ff52y/OpSTAOJBoVZonbON9kHk2fzOjhBcLjRymGLdLClv7Q8hPfcRA==',1,1,'',1,1),(405,'2021-03-31 16:25:54','2021-03-31','0000405',1,2,1,'1617225925973206765','',1,'AAURAZO',NULL,NULL,2,'B001-0000383',0,18,'2021-03-31',1,0,0,1,'t5cGiNu8cOapBFWLWhYXX39X5Ts=',1,'FmJmRxn9aWporSR70Hunvkb+NEsFPbbS/Hcm2WPImIcUzACCMj5oV7EQyL/YsUFrgmYpw6/vObDr1aPuxxX9fZg9qPz1cMVihcDsXMYWdyLXYMltlUmLgeawL8pfLKZ/tYWGpOuPQtfzgdrjgF35L3YhizS84SsI8/zqdVOmQehOJsH3F8FXZyQMV+RlHgNNbW66VRDVQcHeU2EWVox8VAjwF+145xoLBRip1Z5GYqFFBQVWO0oq/0rZjreFr3onkdPhKqu6V4R/Ead9G7nIDLlswzzqFMQxONqpRjBucRFnjUAkvcW8YNSefhaEfxM3EeqCm6GxOA25cyotDbIcdQ==',1,1,'',1,1),(406,'2021-03-31 16:26:38','2021-03-31','0000406',1,2,1,'1617225957726376467','',1,'AAURAZO',NULL,NULL,2,'B001-0000384',0,18,'2021-03-31',1,0,0,1,'VZYem4KO/q772ZmejfxcgIxP4f0=',1,'RvIiDRB/5VkqlBPQOd1vVQLvSoR+Vhgcbg5+1Fcc+v/eLx2E6oGxHOLuMf05E3vxjTUbhOaHWdGtAw9xLPUV/8xW/DkrgKmWXoP9NVDXHx/m4ajGA8NMwxp6/CpfOkA8XA86Tkjy7JsHZ9vzDe3bQf4UuR+AOgJ21EixK626y7tj4CnPWplTZ4QLMxauwAKZpEeO1e4NhLzhR1Dhyt5jrcvJiQFJtFFowLbL124OrRgv49CH2iVcjBCAtbMvUPZ8Eks9zAv+Ma6c+Vy4Bhlpd3IKD4SQdh5Pr5qo2FxZmIt3dfMwf2pBq3RrxzTaoI0pxV8s+WBmP5qxIJawQNSEUQ==',1,1,'',1,1),(407,'2021-03-31 16:27:19','2021-03-31','0000407',1,2,1,'16172260011100795996','',1,'AAURAZO',NULL,NULL,2,'B001-0000385',0,18,'2021-03-31',1,0,0,1,'30+swDzGLWI2eEsYr4LsPNTlatM=',1,'KqhxROsK8EfMXiN3FgpQnxwtqRvLhgo3o85N3DfYeS/fF8JRPXQ+l4okRFrQJ47Qlzm5vaf1U7S3yUH+OnKJGOS2+FZkJwbJGtXpTqZR42JFBWaqbk2Hy0d/h1iVXqVJ/6VIXW9a3WmmJbnEHCRnFmlEACKUggUrC0rO8Tp0N5nkFrPtU7uCrLinbnBvTKV/KJ/A18GN6r6XVtiRHcRScF/dLczNWj4eW+ZQTl8Mc3ALNMoo12I6zk6bZu9WGd9mGnLmNg/tlRL30mtvBCh8miqxys1soGKiOpuB9GBREYNr42S0421PRbOITzS+J07yoMDrrX6IYZLsLroHevjaTw==',1,1,'',1,1),(408,'2021-03-31 16:27:36','2021-03-31','0000408',1,2,1,'1617226042996271799','',1,'AAURAZO',NULL,NULL,2,'B001-0000386',0,18,'2021-03-31',1,0,0,1,'GIEcPLoLeybAZThLhLEJcGdu1CQ=',1,'EBg7YhLuCjZFN9QkCxhv2yE2SnOiAgAyc3Zwoq9mGIAVYWGk3RpcZhdn2xelc1jc87RrTWf8Qv7LAV2awMzDXCCEziSkHs4Be2IOTnt8fDPBdamiPIhmgoWNBatroL7ewI9XiO1RQtvGSVRx9/d/eLjIypt8h9E3nHfjd0bJFS+ReApIr3UTYW+JqllG0Q00zvVlbSjBJyYQfb2Et9iVbCCVh3B2AeQVNsjsxujtXs9yLdLuvVeq60gTZ9Sb9dZ3JbZAvTCIP7YwzqbBUhnhzXgpc4XxPhz+f4z9Veq43w317hNl9VY3oXQNRy2AKv96GPCydU3ylcovC2wKRPJAZA==',1,1,'',1,1),(409,'2021-03-31 16:28:17','2021-03-31','0000409',1,2,1,'16172260641095115801','',1,'AAURAZO',NULL,NULL,2,'B001-0000387',0,18,'2021-03-31',1,0,0,1,'hyBgtbl3TaVklwPIovMJjDQ6zEk=',1,'RqZz5wWHGT9/DagHgJUemgrDY3v9xQt8+OjL3uf81xetEN3n0Qsc98dQF14quORC4bxpZxoS+PlmL/qBpp+pwtjQkzdMmBpGSRPlB7x/PVxHn/PNt+1i+32gVRO8Fyx/bVBmePX6SAAEBtmHR8evuUBFgJmU7HNeUTK6kbxHk8kMG4ZmE0L4BCLtYxxOovRRRg+XoztRk6a8e9Om3G6JaRGkH4Wm+1J5bdV3ENhOGfOf97PPIUtBC6PmfJiE+0fTiy/fGidip+2nCWxPGaF7NcYna0Yp7SZGDj01tCgQZxtBp/i0GH+197WxZRtlKaKiKAK+Rmp40oCxDIJ4GZMTig==',1,1,'',1,1),(410,'2021-03-31 16:28:56','2021-03-31','0000410',1,2,1,'1617226100834472302','',1,'AAURAZO',NULL,NULL,2,'B001-0000388',0,18,'2021-03-31',1,0,0,1,'3M1YXQj/kI24EQN1m+9iufPJDUQ=',1,'hBY+AhGOeurLakGedBLsKXs76KEtO2zeqXxSkxH8y/RZ4AQ33Oa+wU04FX56SFkmU+5fHdjpdceK83jVubSQQE+dMYeUHspGY9Sjjy+MciVDwoUk/UGOfGKKB47eiL9lT0lH31oPv0Pa67K2/foimASzwF2adV/dnCDt6KlVouXjZIvn+BvzAwSibN3CujA5EqYcaDitviPr9Esh6JeEWvnMUt7qBKBAhq7Tq/FlHzwHMNexouTfXuWnALTycB8z795L5kbe7kDPHOr1sN2GtXnN5S1eYqiEPV6jRc2htCYdVtRJLRCpybI6QJVxKp4cY1eYmttHwDUd5TquHm5cxg==',1,1,'',1,1),(411,'2021-03-31 16:29:22','2021-03-31','0000411',1,2,1,'1617226139392665004','',1,'AAURAZO',NULL,NULL,2,'B001-0000389',0,18,'2021-03-31',1,0,0,1,'0fblIuM+jVuiZtHjaPNbNtzEkTQ=',1,'jNJs+69NAsZ86Fnxc6fHSsmaf8nzt/oVnXkvR5U/9Fg1OZqQvTQEQtdNFbsdw+VXoDfKs6rkACyvzJR93ARNHmtC1qYFcNbCR6Sn+70p5NCDAunJVlHTBotuOpcmrT0dNi4MnrnBZxFC2QH8YvmsVhz+PAVwjSBw47X7Td1sPPvfxG4YQ8q/jRZl6ltdfU/OLvvlRulx/xCPkqEWpT9cGO1gxSixIsEopslPNGbmGTIz3TsYbdPVvzdR/SzreMMCLDRuZvC1dnIC0bFXp82Ydnyv7TbC5kUo3QjbGIyeMfnyq/W6H8y6PCR6vOuHZrL6zVE4eLkeh0JepfnU3kutkQ==',1,1,'',1,1),(412,'2021-03-31 16:30:30','2021-03-31','0000412',1,2,1,'1617226165390814638','',1,'AAURAZO',NULL,NULL,2,'B001-0000390',0,18,'2021-03-31',1,0,0,1,'56iBxEeq4NPq+iN1Z1AxLpGGJsE=',1,'IMEU1GC52idDBjjb/1nniJnmb7OkdonVddChVC7u3PqATjwQF3rn8dEPqnZJnQLDoQsyGlNNwc9LvHWLnnwroMKP/7DAHYMsh//B13gF6n4XvY/Bm35J3PxgsYAVre8Mq/PIZuUWZral2PpvwW1O/258z8AqrWFFBzJdur6leZ9MOBWvyIy/MRuSvcstyIVG5kO2ogOxyZyyPkDfB9JYpHTauXbOCVDAzy3mybVHsDZPtxxhsDMdnyHekr3fI8YxJNJB9v9MrhFVUlblZeirq1zgOCfxaPJxJZ21Q77U3eZzjDX+dkSJO0lIuhfZze/82Y025x0FPNKhZhgNSjXHLg==',1,1,'',1,1),(413,'2021-03-31 16:31:46','2021-03-31','0000413',1,2,1,'1617226233601713397','',1,'AAURAZO',NULL,NULL,2,'B001-0000391',0,18,'2021-03-31',1,0,0,1,'ZTAlh2I/HmEVrHtJUZBPb+I214U=',1,'PeM6gsSmFXbmJKxvN3COAjlmj4v8I8HuSNPyKXsJYz3MlYxNuks327KlmyF3WrqqFjyRKHyADDoc4DMjefgDZhjDTBVoLWvCYgnl4N2GzEwj2F2r1t/AEWvouodmG0zH2ZkehmPUaOWBMmFvNf7PU0/+uQfA63hSSWqA5BEXT2A6041LvlnJClvUlfWje8Z1wykozQIjZsEiBPKwwo8E2L62DcKCU7SDyM/GfDOWEuot5aoSWVXlh2T7s8/Gu1oSJbXHNx355VdEfLekjNUgrokeBfbhmvatT/zyF5wBgo9dLExRzKGDHLxgtfAMo8VBG0ZH4VU8peMANrsDBwTQtg==',1,1,'',1,1),(414,'2021-03-31 16:32:19','2021-03-31','0000414',1,2,1,'1617226310113345712','',1,'AAURAZO',NULL,NULL,2,'B001-0000392',0,18,'2021-03-31',1,0,0,1,'bmEXzR0d1xAex699cZ6dpE/2w0M=',1,'Lei9+JpnPUQ4EmHID4OgFTiaHVbCvPy7L6+jtHMvasIVo5KCvD0hrhim7Vnm1RnX3RlIsI7A7gIDVDb9LSKqWDewusHz/ElxddAd/D47zm4D61R2fWHjkrog7rlwcHPl7nZoTBL9hP8yP4WAcujhaa7FyuqQDENleDqMYvUKeQwSDc+WfCSZVuaH7F0tS/k5JOT6IYch63Zkv5kx63C55+MHXIkST8muwmaKShPfG2EakostRqiwk0019vsjfvtDUE00smaHlARdB7fquV4oT03wy46mdwLLR5IXLuMOnpaPFLN3Xg4JbKAGcppqVVFnuzU+G/aBiaa0ATy0zpgy1A==',1,1,'',1,1),(415,'2021-03-31 16:33:27','2021-03-31','0000415',1,2,1,'1617226342773238077','',1,'AAURAZO',NULL,NULL,2,'B001-0000393',0,18,'2021-03-31',1,0,0,1,'hQ3q9fwNp7aoGKk+B84oof6Vxfo=',1,'izLKURqZ62JjvkrRUSncr6z8n9JJzT9zCcjHn2nstczbf+3g4EEmYqCYPadaNMWg9Uk2GukXf76zDa0moplW43FpiORlZ7nbK9c21L6qnmxGbACS3IP1UigCTVlaSWGdU2Dzeebd3jYZ3a9WTPU+N/41dp1PoEvZlhtxGKOtecK3veVNktqFtxFCes5WP2Cf2Oxlg6qMiKHWsIwWHr5oYd6BvIu+l+uhGqxjZie86zMinkewaQ1ghWGaaMg+JD26JgyCXUQYh+bS/Ybd9XkM3HIDj1QbgIVjGrN9MUoT1siLHEwTzf2C5EFBtqJEfG0HokuZwxHr2vaRKmA3fUfMyw==',1,1,'',1,1),(416,'2021-03-31 16:34:04','2021-03-31','0000416',1,2,1,'1617226415937791609','',1,'AAURAZO',NULL,NULL,2,'B001-0000394',0,18,'2021-03-31',1,0,0,1,'sw92qehmd+JbjeB2d2wI9EbRbqU=',1,'U7BVQZTsQJWrjyGhSrfpnk4TZXe1yCFDYrf0425FkyC40ZlszBTPGcEBgqon/+r+IRE6XZnoQEYxu/wz6kDgQ/3fprpYSFloWtj3tfxZl+drc+86R37ldMw3Ngv/xivo/BT5pqWt3Bx3R2zP1v81DgdkAc9hV1tITKg5x/5dmLGqa1HvV2LyoQ7/LWHJM4KYVAVf7b9/KkH2l12q3r+KwTIturxeHTcxpls05G5JsxemCBQk6pyYbeKFmonEqsZrkXgNVaOMFnyFMtcdEti7jGq5yfV9tv4zVNBOYe4OWkhHOuA+Gn5tss6tmV4/rlUFUp/ZpMTqa9DtGuKc8Qxwbw==',1,1,'',1,1),(417,'2021-03-31 16:34:31','2021-03-31','0000417',1,2,1,'1617226447144414658','',1,'AAURAZO',NULL,NULL,2,'B001-0000395',0,18,'2021-03-31',1,0,0,1,'aZ5ZqvcuXvO3C+qA78ipRKHjtTU=',1,'Z2NXizpulZba29++z89bSb+ibyve7FoSK1sejrU2K+fpthswDFZuaP33sbzIzjIS30C5jD1s5YUdb5zqObX+/OLL0b1MQFqX6IgoWO33+5Yqlom1xXlD4zBejVxiRXgEbaY5emkL8BQc+3UFdgdYLzK7981FcB+leQ8mfCy480lUTacs+H1cqkRiGaFaOuHj8tEd5Uur6wQI0p7pGaWDqTiUOeFbH2kFhjRTzDN+bWNQ3ZMYQqZf9UEC881nsYpHprM8cHRjJ5ih+60+b6flZZp2hMWXv6gKkC6h1MJeIlvZDPjGwXrIvzvWC2vXHaWLvoW59jlGiBP6Nq+pLsXeKg==',1,1,'',1,1),(418,'2021-03-31 16:35:01','2021-03-31','0000418',1,2,1,'16172264731380029224','',1,'AAURAZO',NULL,NULL,2,'B001-0000396',0,18,'2021-03-31',1,0,0,1,'/laXQM6SYjG0DN7gK5uuEDM6+vk=',1,'TEZ5KD8Fj8DuoPkEuEeZEgVXP7oIXogOjg/uZUzvJU3olQ4Frem8c/tpUq72yAKysp8xtXcFn5fgJWNsTpgxbO/iAxzmpk4ZBGHZNE6/NAUnYBEzS6FGNjR5MTRjErlW71+FfQdIeMp3LtJ9MJdNs1IOp+gYvtB+RQXOsVbYGIdhm/jR1fXfjFDWtCi2n0aBmrcTWW/h7Spm6xAt+aOEfSeBDLzesqgQ2Xe3cUp4iAWMA90e81r6svC3Mlfv2BcedbeNUtCNJARg6MIbfYDgFB37fj94ThSs2ZVNykj+3aBeiAzR97Z3viP2Bh8ysZzxEQP/SYowDf2LoQkstmF1dQ==',1,1,'',1,1),(419,'2021-03-31 16:35:24','2021-03-31','0000419',1,2,1,'1617226504271358413','',1,'AAURAZO',NULL,NULL,2,'B001-0000397',0,18,'2021-03-31',1,0,0,1,'ELw/qB/wr2oOZShFVhCTpE/OWb4=',1,'VA5wqSBshnlWXwLp2v2ramIBXtKz0lbo0BjfQYL9sigB6vX7kLTO43v+tWNmmmjF40FtOY3IIZx/jqf+pqIYq9dY/xSMRaRJtCurdnGYGxf8SALS4BBawYBKY6nxH6pllEM42Tp833WxzhN7u0c+p3qP5hn9pqIYZb75KA1O78sgvMSHbaK8eV3xsPPBhIO7EEov2U0VZB1Z+FzQw3W+OpGRfY9ImxQbXtZ1ybU96SxwUhrgwh0UV0NHY1zHZQIvu0SxrqcKcCr74gcpYtdzLrEA8Yv63uZCiI3Gg/HC0+1iX/oDNZ1B/uKSP4rAfzmKsYbDI3G2s7f0FvgDrriVDw==',1,1,'',1,1),(420,'2021-03-31 16:36:06','2021-03-31','0000420',1,2,1,'1617226527114679697','',1,'AAURAZO',NULL,NULL,2,'B001-0000398',0,18,'2021-03-31',1,0,0,1,'IPwgCnz5Cf/di5nGiY8n0RetECo=',1,'C+IKA94IHSczhJb4y8Xi3t9Hol/pX0Exd7ThOmGVk+lsoGni0uR0SIuSVRMRgM6t/p8gcZi/txUkbq7U3pJMOJPMMGe7aX5ZLZJzGUqSLGLkeT7NhqiIryGQU5KY/fQUuie0HFIIGgVevdGdNuPHaB2yCG3yvTU9A+8gSMjhA953gEF05rRdwlXhPpKjDha9RB3ZdLOnfqaM6fVtpivmaGJxGn2rl42TibSFBwLUYt57eFeRmsdr9vXwrLy+x6hlICsLQkdolNasI7X4TRvudfNoI0i4Vml114wQsxZ3vnZHbRkPWo1/UIwW3zp76TTq4Qk/b8gozp47CAllYXzFbQ==',1,1,'',1,1),(421,'2021-03-31 16:37:10','2021-03-31','0000421',1,2,1,'16172265741002769598','',1,'AAURAZO',NULL,NULL,2,'B001-0000399',0,18,'2021-03-31',1,0,0,1,'Hlz4dYkxIo2SCpuVyMd1Iyxpp3w=',1,'F95ZKFaSMhx003ocJ4P+0LgFqCgLl9+u0dFoedbsYPNmF/u05nozLAid1JMi0QxnH7iq1UiGDnN9cVPtCqWu4ImDpFnxp/iIcrrgYjosN8lMlRftSgScQXq0lTjj3LWiE6viNcgK8ivfgsKAkzQqiKCRJlFaVv05vZ7Rdpn97yaSRLnSmoZdf3kR3krtIn+1gw+iWmE/duTGYoAdlDosmvwZREwMSbNqzNqWHgqTlGGiwYVcsWFpQfDvD8KlCls+js+yD9eIXBaEpg/jUVoMIflopHqfWJatC9HLTP0Eh98WVGOPv3nIh1cxpjFTXbPidsepT5ahshxzdBtUYmdFqg==',1,1,'',1,1),(422,'2021-03-31 16:37:35','2021-03-31','0000422',1,2,1,'1617226633286161346','',1,'AAURAZO',NULL,NULL,2,'B001-0000400',0,18,'2021-03-31',1,0,0,1,'9YwlmeacWbUADIO3T4IjP3w3YwI=',1,'HeiGhxhALcuUfevFe6ULOgh+T0n5MvTVYZgzcyZx0vmllsvtTzI8sOKmTCgCP2OgUGeogT9macJfVfukacNvUCbddmYNmcU/KfIXsdj15k0/Tt37DhCf3fxJMGTH/0grBDHJdSuT+Qe/y2SI5A+MvK7b/oMyC/8PtH8+hqBszYjgvLwOKhuMzyAweZn1SkQYSBdFnfYJehqxJ6G05fahBOd/N7YKCEgYkUPz90bRVRc8cQsIjvES5PrcfKUKj+bmIfyzjjsit2+aQC1HYMfygj2YtrtJnOEyyeeJQd3nuYiI23hpsPGDwFxRe+Dkl9wXDF0LYsgkXeUV5WBj75/VFw==',1,1,'',1,1),(423,'2021-03-31 16:38:12','2021-03-31','0000423',1,2,1,'1617226664222560373','',1,'AAURAZO',NULL,NULL,2,'B001-0000401',0,18,'2021-03-31',1,0,0,1,'zwRZ1WHlZEot7U3iH/8KtXTBCQQ=',1,'RMG2j81WryacbmlbJ4Nlcuc0LSl+VuNVoy7D8BvD1DrCdW58ByV5+e+3Oixewi62ubnJOdehWa55sJfIsRs7Y3o6r0/XM8exua5x/lTn1YvFJ8iSbDhhhFT9knInmPatLbnKj5p1RecGyI9MgnGeWqBZM8tab94tMEb3e76w6/j1tsbi0I9gpXnqeeuLn67uxlmLmqsL7xfEmxcXQxcvX3L9Tycfg4eeVZ1F9IbPTBor/mLXDEP64rJR8QC7n+e7/xxBzdorsyyckvnOjZr0s7GfVctECwDgk9H86rf7CLxKYShU2dpySo374nQi0HBguriCjHI0XpIzarVWpak3Dg==',1,1,'',1,1),(424,'2021-04-23 18:12:46','2021-04-23','0000424',1,2,1,'16192195381206309923','',1,'AAURAZO',NULL,NULL,2,'B001-0000402',0,18,'2021-04-23',1,0,0,1,'owkQQGe3gxOMzhmQx/gruNjG9cI=',1,'cNoxerab4fyM+nZl0ExEn8yuOKfOJvJjKOrWGX9EkpphvVxwJS9/Z7eMgWpPfbfmNI3pnzuAVraI\nOgKFfPjHtyAZZCKUZx1hD53j9uZi0/bTLm7KEbmAcNV87nx+UUsnWNnT97qW6nZXSWXjNmUamDri\nBeWcYiA3KmBU00dUksYCOfeV+7rVcYMWus0wTA2GtFm7RjBJrYKggyPzGej7mnObczP08ZHoqNKZ\nfvyKaUii1ab10FnsGeAOOiI95hPK0M2ihcpLXYVRxQU/gW9cziMtSp5o2BR685PiCPLhJzDx8pb4\nSX+CeYJwJLephYcI6l9gcZKFjxBX8wB2AFFw4A==',1,1,'',1,1),(425,'2021-04-23 18:13:05','2021-04-23','0000425',1,2,1,'1619219569882151515','',1,'AAURAZO',NULL,NULL,2,'B001-0000403',0,18,'2021-04-23',1,0,0,1,'HcrBl6WK+QZIuhUyFUdXypBQ+eo=',1,'fv+3+h++fFekKBEr/5r0re0IlCev3vUXd6xC0RohdNFc5YJK+cScqesZAp8vzxhrNSzIi7yYkvX1iSFDmzeCjiY8QZ3wfeJl99IoYQ6oX5FK97qI2jlL5iOJbjP2crFe/i2g5wrxHf+/mzkL1WAogvfPjdASs8cIFnrS0fflOra/UXgu+Dicz8JPLb9RHkwY1I/wFlpW2YXgxRc8Z9SOMhXXmGs0S5UnqZcTmMT8D4L+t3lgDbbvTAxnz6NtsYMcxhpe2NNxDRVx6uu2k+8rXJwXtAieGExQB6rWlYmtw/gGy8PoQr7pbsrJR4L/Sf8lzfEsLuCT5f4Wzz0e5p9rXg==',1,1,'',1,1),(426,'2021-04-23 18:13:28','2021-04-23','0000426',1,2,1,'1619219587295327115','',1,'AAURAZO',NULL,NULL,2,'B001-0000404',0,18,'2021-04-23',1,0,0,1,'7nLyRU8n43qnkLlNu9x6Y4+uELk=',1,'SdJ+RHQGmAYiek9onC1yLRn2ZjDq5gB724/AugderL3NQTZU6GjnjsUF7wnvjD/wyJEWAQmCxhw4MA0co2s/cWGf32+bOQNnrD8S0QLm0u8gTPEEu9mGOa0qNBcH5YwnALiBKPCzwwyVGMnPBWTzKcxkvuBiAQYu+Y6N5WunpI01/x/7C5gCrqM5HNTyFWTJrC+A/A+tKa3sY6/15+UYSVhKSgB9sZwil3QdnRva+pizhVNlR5r7h7TnPqOaInMRLkV+bDuJ9Wu2v5PMAbryGsIGQNG7j5nKrTFK1yQyXu99ftDQHVjG19e8qAMbhESmtXeQkVIfN8aP+L67kOw1Cw==',1,1,'',1,1),(427,'2021-04-23 18:13:52','2021-04-23','0000427',1,2,1,'1619219611355012196','',1,'AAURAZO',NULL,NULL,2,'B001-0000405',0,18,'2021-04-23',1,0,0,1,'Gpu6Z6kVAFjdLZhD1880Dh+DySU=',1,'ZC1YbFJleHzzl5ESNVXvBmMekbnZhDa2wK+s+zZYMgYHvph9hcsuZSXkxSSxDfhV5CXZ28BU4r2rvoMXpzT1crzrsScfyh3SlUxk82R7C7rKb8NKeD1nBNFF89y3L7l1SY50NQ9xwwcjcaTROnMpiSbz8XxCZgYUJhhyRuLvG2Ot/of5hvnJd0idiw3veWW8XT55hvgzDhfdNAqjpFDvzIQp2zFq37hkwUkvhzbH21qC0b5e60C5+Y4Dt0HZrN4jrFtnR8YtFVtNKYzFJd0gIqhh9aotXBz20Xu9dTniZxNNhpDE0wH9AkRoh1u8nN6fCuysVZsHxRysQFlNyX5dUQ==',1,1,'',1,1),(428,'2021-04-23 18:14:35','2021-04-23','0000428',1,2,1,'1619219635230435189','',1,'AAURAZO',NULL,NULL,2,'B001-0000406',0,18,'2021-04-23',1,0,0,1,'57qDpQJgvbFjFAIIyN7z8WEak2M=',1,'bTDXE9Xwz7SbtRmz0i4RQo5xoTNFyy40/3UsOW67KJCXq4bVjIGKP2apnUjPEFosveqXB6iSaVs5pxDk4JVBP4PZq2EUxam9Op/5AH1GneOjEH9fb+aspXriRPAxQPl4wYCsklA1EmPmYZtnhLh5hLxlA+Mtv7tm5fNwpifHImGvdSJmWfupWEunKFQ/MQ7+ixoDO9XoJKYOm1rpaSmMf5LlVtZMDmDbzbTTpwclmk2wCg5DRHMehjTs5kuf/JAoMK9qRIFknsiQacMiRMjjfDFbn5C0pRh1GbTtzW8YVLJ3/j736mdFQsNIAaV0WcU55Vks5dhxj24zWB0apHW6tA==',1,1,'',1,1),(429,'2021-04-23 18:15:07','2021-04-23','0000429',1,2,1,'161921967766355007','',1,'AAURAZO',NULL,NULL,2,'B001-0000407',0,18,'2021-04-23',1,0,0,1,'jsvu7FZH+ojg98+Bmyl+kVwWEM4=',1,'RNt56XtLIMY0O+ztSr7eOXnqi1UhDqb1YrhTg4QP8bp0wK9c1UyKXwFwp/BEXkrPiPtNXg/Kf0NybbJVWSNETY8lCR3nrys0R8mAMBegAYt9Rp3zULsIHGGqKbgYox2Ua4QZO65GnbIdGl//YtP7sS9/0+vUSd9tiMAzkBc5ZHSrSsPoYXfOLBHZeH4SxswqMIf3NQ9YXZXsjOZmHgWhEEZAUygpd+jhrbDW9tPFkmnJsjdeeEcDD2tYfxnJeAvMVv1m10s6j+PKsF+xbxuJWv2ldVehswNuwnl35VT7NETUW/bi/OyVUloT2p0mmlazu8eDXkuT0hs2nY59ykaYEA==',1,1,'',1,1),(430,'2021-04-23 18:15:33','2021-04-23','0000430',1,2,1,'16192197091226879115','',1,'AAURAZO',NULL,NULL,2,'B001-0000408',0,18,'2021-04-23',1,0,0,1,'dsGKKriY74c3nY3uWg11NFDBgpI=',1,'FYLtvCjlQ3uvlRzGVAvbViCflJuunAcaa7BOHTVFwvxu7mcaOebEp7z7v6px+RUQt0ljMb3OovL4tBzcoD9T/C0Xr3cpHa0HMoE7GZFc1eNDzo42KxjLZfvQEusXiP1oDPO7hvJAGtuuBBYRkUkV9KmMPp9GjN8JjVXEj7kvbyMMDYoZ+/y6p3WlsIzW0gsmd1qw2+XxJuidpNQn8bodrzKpbmU1hmGA++ONVw8VdKJ539XXYZFDgsq3OzcLkVdQ4D9yvf+k0xr4BhpAT7OIubPX8flDJQJDzfmYQCNxM+HHvFPcFY8AxJbhVBFSA4w/cs2a2+fBcg6daUUl45556g==',1,1,'',1,1),(431,'2021-04-23 18:16:14','2021-04-23','0000431',1,2,1,'1619219735904571074','',1,'AAURAZO',NULL,NULL,2,'B001-0000409',0,18,'2021-04-23',1,0,0,1,'A9MpMZ7KituSN/v+t/dHyyaTQlM=',1,'VRZXzwgFDxO7ay7xe5j2BCFal1qsvm/b/Zg//eEZNkMcfwZuE0BVDOW7PyomHz90cslAyxspyrzkcGrz+fWGd7vS3A4I7EusS165jmDZ/loZrvKScErVzF2KYspZE6uirwb/tYWdkEgb7GbqYJYBmdBpfqX5uCsFT7BPWw+0pAHHr+szCYyaythxDLEb2RwFpc1arSMXSJ9HAbY5YLiEv7Nkf5QNCTSdusDf50yNt/RGQEJ957p46vJL7mvvmb9nCW5OfesiJF+ZeRQJHO+1tK/7KfOWwO+k77tPsc3M/ajJybqmxAHSQ0ZbK1Y0oln43udEZQQ0/AZ4eQ5cLG+WVg==',1,1,'',1,1),(432,'2021-04-23 18:16:35','2021-04-23','0000432',1,2,1,'161921977626163323','',1,'AAURAZO',NULL,NULL,2,'B001-0000410',0,18,'2021-04-23',1,0,0,1,'XEIiDB+X4/Okm/K9cXAONh9gXxw=',1,'g1uc0nP55RqiZeZY4gUrsjZ9szX1ZNtO3LrBcEWzIAwTCJI9VyxJ4YNp+IMseXj3MJcK0qsp2TacoXRJtz36yffYTzkmYII+H1tL/9JI2k/U659RaB/Q3Mcn+3gpmB7zDexL3R2i0QfpqHHElw8FJJNuzfKcDNHRSLzj2w2pXHsSfrcdNlAJnOAkzx/h3FQVo6fB6Pt8LwxA4tdlRZqE79Uso2w9DjRVB6Od4jcGxY6Am/NsnG2OrO34Z25WkPOOAy0KGlLqtlQ5YE001ao4FdYLBK8vs8hJpJ5qUY/06QHcLRYu5RPF1n0t+iZjRwneyQcV3ZFrPVH4pNTQdvQO6Q==',1,1,'',1,1),(433,'2021-04-23 18:17:17','2021-04-23','0000433',1,2,1,'1619219798150611235','',1,'AAURAZO',NULL,NULL,2,'B001-0000411',0,18,'2021-04-23',1,0,0,1,'q9nn7J9If6j/z+WVKpCCTQzm/9U=',1,'KWBKeE4BWhhdxxF03m5zxCHU3JF+owdN2eHgR7Krekmn4rzyWub9uwkWaB9URjLcwmjH+kQkDpTH0una8Yl60ynz+/Xg/8UkwZ2pXqsMqPdU6QMzt8YoerRqj83fcQdRkY7IdarIrx9ag2M2C7lGN2PY5jdC3HD4CUEA9Cz6FABs6k9clNJkgoK0VzM0Tdnqt9kRiiHyEeBGvSuOYkxzZ+N5EbE9ep2EIA0aQZWSYdEHXARkXw9J69V0t5S4TuNlRegRh4klvN/IXq70tk9a2PSzGexn5vrEE4YQJeHUdzWhrMIQvrMA61dNtimbsm655kDf1bPYALs5Zymxnuw42w==',1,1,'',1,1),(434,'2021-04-23 18:17:40','2021-04-23','0000434',1,2,1,'1619219840438795074','',1,'AAURAZO',NULL,NULL,2,'B001-0000412',0,18,'2021-04-23',1,0,0,1,'dttEuJ1aeub+nOloaVwQhRxD8fU=',1,'cvw4m4lPdISwxiaPWqa2EGJYDB3Eeh+QitYVkTGGsujR5MlsJfZ6p/NXpiRhZNg5Ib1WTlREYml7BWxEKvqKfTjkNbqY30NrdaNePf+h4iBNBFOr3BewYcBxImhHtrJqIc94ZPU/0u9IGkgEfGWY76RnGneEX4j3CuRe00nehNJQOuFiw6sWGNxIy6Ismu8k9Orvb1cEi2Duv5Tvo7M4Q6FYg5KZdlBq60DFayVfuakwvr9k2LhOdETt7XM8qxDGd/PUocmPnIBmR4D0P3bCwrqpF63nP4GRtRlXAheNIh5G8M/TNkgoktGCidNHg7IhRcSWRb3V0WAb9HSmA9u94A==',1,1,'',1,1),(435,'2021-04-23 18:18:06','2021-04-23','0000435',1,2,1,'1619219862131246933','',1,'AAURAZO',NULL,NULL,2,'B001-0000413',0,18,'2021-04-23',1,0,0,1,'xlyzQ9mjZT0fk4GtYNnK5BOS8lE=',1,'FXtguXu9hhMGVFgg1Sx2ZwxPO4FaCyYEl1FJXuqFalsvzf7X7KLHtYok8XcFFZ7qdtlx8jPhZ8Xbd7JykYCPz/UdlJleuevpRlY9GfcxyH82k2cEDZlhgqjVaWHhesgwA//iVjZB+0P1eYikmz6vjjNTjhFofNkvZR+xMdlOf/Rds8InYIrx0FAeyS4tb/9iy3k+SxQyuDVOrUnmPKR9wldapqU3pAhlv5e/V3x2tANoMulbdu77n/+cMdIy0IEIKjqJUQCAXI2gYqw83K4zV41vAeXyf33S9MwAORWpZcMb7IQD1Y/8x6AgcCjyt7V0hnzzwU2X0Hgg/JKIipxssg==',1,1,'',1,1),(436,'2021-04-23 18:18:34','2021-04-23','0000436',1,2,1,'16192198881193228262','',1,'AAURAZO',NULL,NULL,2,'B001-0000414',0,18,'2021-04-23',1,0,0,1,'IJN++n/XZEZoAXrygzUZDZGg25M=',1,'Txk0cPkKf08kPJPE6ZLzd1Va5l0Qu2F4WQBjkkQk1z/JcZLevNFzt8dkIgo5Dz7Ts3e40Fm2jagMWPCzU/ZaBcJtqonxrbGJS6h8Q7+Fo4xuhld2Lzn7rRUh9X+19ufXgzyUOJkzhUfAUvQuy3f5V809SPcKR3tVDyXcOUS+ckgVFmiQkF0uH62qbURpGHtopZFKoWwMTgqoTvfdszRWw3gspcipCxqcbM3G+eMGIXhhv9wk+WnB1yVEAwOJXQEEBT4MS9cs8cqNB894FIYXonud5oSs5psEJ5nvtZNxSHYdqcxLcS3MrsEG+XZtiNBEUikCy5FbPSk3ZL8M8ooLbQ==',1,1,'',1,1),(437,'2021-04-23 18:18:57','2021-04-23','0000437',1,2,1,'1619219916629468896','',1,'AAURAZO',NULL,NULL,2,'B001-0000415',0,18,'2021-04-23',1,0,0,1,'GGUGvQTEcI77sv/Y0s5oavAhRz0=',1,'XrUexT0mWor2Uleaajq/RYkOQSGS2o/mwAQ4pHV16E5whof+xySKIqZR68RNA+GlxuLsZhU3i9IZMcrRq4r6M6tSfGmu6amRfFF8EHA+ubUMltDY8EviTJRz/LSs1qJyoL1v1lfDtuO+WNbgzoWptbT9ZxyrfKdoRcYzru2NYRIEqbCC4mrvWQWkVCLhgOqcCg5LiFoXdUgh3Ajowu7j58+EUxfBTBvEmDWwKCmOdd88zHTKd/Ac1PvJ6Ts/VrAwS9gC0QpCeJCbbfXTZo0yDfxxfxbCkRybJf2Y1/SEj09cX3XlyJmcd31eOZyEWHBrcnio6YZAlUCve+cP22p7nA==',1,1,'',1,1),(438,'2021-04-23 18:19:18','2021-04-23','0000438',1,2,1,'1619219939379841533','',1,'AAURAZO',NULL,NULL,2,'B001-0000416',0,18,'2021-04-23',1,0,0,1,'EiIJpXdbcl9E0qU5a2p2PEfcmE0=',1,'IqfgciNj7fHFlcljD3XYTC5vhWVVhZ2My8/s+Ss5fhs5TRxcyIKo5rD5qYX17SHmAq4FMTWe8gs12zZGTQvyvGhJV1HzPdGQauQgnQHgR4IRJhCN0uFDBU1UkpoRW+S71CdB50AyPfkuKQk1DFsZdkMMoNHDrit4f507sCQv+iBGL5InhEgbiklFuSV5l1Krw+JwJ3IbLpWKVoxLxqcnxBf4/ANBuxqierp/7zmTOtpEh0KoWkpWOpHfBPoMONrC7QndpDCudXNLIHUftHH2CLh9c2t2GXPIHrDbca4uj38s0K0nrrCtMMqLALyFA9cnfUIHdVwAuI+R1ceFJSs1nQ==',1,1,'',1,1),(439,'2021-04-23 18:19:49','2021-04-23','0000439',1,2,1,'16192199611391604773','',1,'AAURAZO',NULL,NULL,2,'B001-0000417',0,18,'2021-04-23',1,0,0,1,'/9lESAoriVGD+Kxv36QOa7OBYZQ=',1,'IpruVbcs7dBGkUHsCwzcxwckNF4iZlo7lTnr6cra47Y4Vl0lt2ENS6jQnTGgIMbauZTGbhsPBMYPpXk82tCLMm7HcQvxojOgGYgfqiiBt9xJYuZwDbkCzHgQtN3gKFjol0CBvR6EZjn4/8ez8430JMyl7CM0T4lWUYf+KyGf/ajxCSDUqWBv2claIWGrIGQEwDDt3l1/FEuWZ+WpjheQxfoJujMzQ4VyeP7+zbAuUKK64PuFdkhu8mjKr46vsfkLw1x/YnD++reYwKRYZ5GlaNE9RHEupIYkCA2f+K8R0nBkWbPKfgS7b3vOpbe+exNEORiS0Md6SkGclJx0/6qwAw==',1,1,'',1,1),(440,'2021-04-23 18:20:17','2021-04-23','0000440',1,2,1,'16192199921195853201','',1,'AAURAZO',NULL,NULL,2,'B001-0000418',0,18,'2021-04-23',1,0,0,1,'u4xZSKQPK8ZjTF8Mu28IjNl+X9E=',1,'Kz+D8RgWZQpcXmtbRNsua3ObMdmFQEjvMbaTtn4j1t5GM0SOJDmgJIK3E6Hj4ZF8GPGEu3F18cWBkrMaKWaTCYiGKfGzHt6ilLNKCgk/LUvS7q4bQEIq4Xkl3pmuB5Usu29LjI+iX8q1J8Zr/D1AH6deADJEtdsftPuhAqCKBzhsMWDZsGrZmL+qBGBVW/feTE0/R0ncAa5MnSViJUKfp5FDc/Q556DcqLLnFp0Ryhn4SVYCJiYQ7ypgiLGfjnnsWhOihUDy1x8GgD3bkrwqwo95h+0Ox7y8BpraPLitIviMZXmckViwOHqCWER+hCl1lDmDqfXRU8ErM7H3c0GN3g==',1,1,'',1,1),(441,'2021-04-23 18:20:46','2021-04-23','0000441',1,2,1,'1619220020492240546','',1,'AAURAZO',NULL,NULL,2,'B001-0000419',0,18,'2021-04-23',1,0,0,1,'cMti9xjkwFi3zsvHbgXGWel+TIs=',1,'JzuMCoIi1jp4W6To4XXDy3DHMTfsALHcFpwpGia6sGOyDUY5Pz+RbxEPGe/5/U1H4ylR7Ik5XZJgKwrRH0Z4/MGmZE1qgSH4KNrLOMuAt1xjqiM5TjgF3Dh4yImfbiKR5N3FYFBeCRepF2jLPs+0WKcHHI0xtPJ1SycwrIyHxiy3Tua+vr1WOfPJeZoOfh4i52BaKsXYLeWPFil5Euy7JFimXjKskBbj7u1uxyF6n5w0dA5mToMZ2IYeJWYn6F+fpje9aKLWZkZDWt3VQvO3+GKnTSVew/mHo3aBFGT/RIUzvVoBRGHIijPfMK2VieMqhsodIPhvqqJyMKV8vnU+mQ==',1,1,'',1,1),(442,'2021-04-23 18:21:09','2021-04-23','0000442',1,2,1,'1619220049744708006','',1,'AAURAZO',NULL,NULL,2,'B001-0000420',0,18,'2021-04-23',1,0,0,1,'gDYAoqyQS1GS1WXnmmfrL6WHaas=',1,'gK1HZgyZ+/ImggVr/d2ty3IkMaA4/Jp6xr+cIUagYGaH60A/Zo3JBAEBVI01s4I94cNHiRHxBFlVB34IvDPTNGlsplwUIIFbHYajBrHY20DPFuQoqoCBvScz3fyBYU233H22cubxPqwMFIzYv/R/t+dyJCGZjWulL3go7HbfitNQ7VqhlvkQ2jxYGm9AWXEakBlkB6951H+TuKBCP3SYkp6CLqIDQXo2LtNgnqYF1paKc4keoYyQWLMeJq49MLm0E7wmUzJMSs7ZTx+48RNoIZ5nOwr9E9RPdSCKh+CicWctDzSOEQPiJ9fanVKUv7CmMW0OFPHQ0fAG0MYZxkNM+g==',1,1,'',1,1),(443,'2021-04-23 18:21:28','2021-04-23','0000443',1,2,1,'1619220072129482630','',1,'AAURAZO',NULL,NULL,2,'B001-0000421',0,18,'2021-04-23',1,0,0,1,'bcwxU+2yqWrtYtddojFUAY8X6nM=',1,'F3GYOR03gVaj1SKUJa18oWnx46Hi/QZKDgTA7/brpHz2kMjeJMopOgFzs+bxNwl11op9xPrVuV/2JZ1R8y7jIjCoC0IiinBewxiDD3XCbq7sFJRrKMLSpcP3Jx/ssromBD3iB0JRXhddQkyVizoec5rPJ1/IpJqIY5QgGl8hvzKMlsYhnVameN4lle7Y8Z0EkjFSH1OoqbTSEczb0Dv9YjjcaM7r4tBUcmY9r6/gmhqYeAgum9VaJZIaVf+gqQW29if0djDjpWcNBDOcPZgkc9NFAlj1cIKdibE61GFm4oC0PIozJ9h846iFeyApwxsChDN6DnKFuZqqKc9a855W2w==',1,1,'',1,1),(444,'2021-04-23 18:21:49','2021-04-23','0000444',1,2,1,'16192200911403438513','',1,'AAURAZO',NULL,NULL,2,'B001-0000422',0,18,'2021-04-23',1,0,0,1,'FEjdYGqMvhH1jJ+SCp9nEZpsoRE=',1,'D/bU0+GYn3WoKkDruhCJ5Nwf8iBuOmp3MsATrPV71sfi+XkQZiLPj96npq4RAkTrqpKxjTHqLf842qT3ONGijYYGvJTzmEPgwsYj+3V6h953hM8ESGMOMWG4Hcaypvn8p/u0s08jcPGhO83/K3RyBu4BLGLWX1ZbJdHMdn+ihqz/Vw5jljf30k90eKQ/Px3jvhz3e9TGdNAkBbJaIZDCcaJ44os8HvUCzJlmHuUScUUkZsKvLSgUcqUKzovFqXzFihUl3+lk4GsyiY6aXJaIhvMu3dPxyLIfRmQkY0656A3PIWGZpwxDWrsqqoW9oFbx+9C5gzbnQZnVPCK3hyiGTw==',1,1,'',1,1),(445,'2021-04-23 18:22:13','2021-04-23','0000445',1,2,1,'16192201121238024346','',1,'AAURAZO',NULL,NULL,2,'B001-0000423',0,18,'2021-04-23',1,0,0,1,'wvsVX6gDxMy0BfISiDVtNSa9+DQ=',1,'fjuyZxajIGBxfwJMmTB15vxgDTjDujsoL6VV4jW0AxlLnwjTCV28EuAPIehcW14QGBsSqislybXRPPvZ2r5N/sjqqify4WRo8OamNN0sqS29JfXfJS6LdC6kYxbq+8MzOD1EIdZszFn3e1xGPHjYqfmjXza5Mtrmj41/HqUh4av1W6sAYt+Z1/7oW1uXYU3y2IKCtcJjQQfbloywb4D9cAjd51X83ybcGp/Z/RMJBnEfM6fXJolPrA2AnA9UDvALaycYbS7qVP8m/Tz2arvPkjc5GinbybpgdBwslj4rPd6aikJ6A8SyiHzFvviwcOZDkrKlK2LaKhJdY4TkSwBdqA==',1,1,'',1,1),(446,'2021-04-23 18:22:32','2021-04-23','0000446',1,2,1,'1619220136565437606','',1,'AAURAZO',NULL,NULL,2,'B001-0000424',0,18,'2021-04-23',1,0,0,1,'krR0yt56n2KRl1WOfvzTd6yY4LE=',1,'PT6vDYGQNM/apBMCC5bI/3Do1fkk3qw1wP2q0AEncVFm5f1kAVnYQ6kdyTgg0vM2/DMyJky6F5bc5qVICQ1Subhs5CwEJRRvkqxety/wg/xJqceQkWu/IZm1sjcbE2B/F2Bx4XigvAsU5J0yGrWUGTcdTehIXEyy8vv8bH4iySfGYp1WDCgWzZgVo7AsZuResG/2Kb+Y2S2Yo/t/5Zfjxp7Wl8YOFUEnZ3b3OQC30zom523ckJv5zp8/RoIPPtv5IeWyYBgZXhz0Qq+RER+WDD2II0XHz8UKmo5fNCs6fA8ptzF82b0Xcj+UWU2Yj3SfuFALe1sg9XkpSGlMnIzJxg==',1,1,'',1,1),(447,'2021-04-23 18:22:58','2021-04-23','0000447',1,2,1,'1619220155382122218','',1,'AAURAZO',NULL,NULL,2,'B001-0000425',0,18,'2021-04-23',1,0,0,1,'Ekv41Ll7Oa7b5HxcpUlvernfZ9Y=',1,'UTzdwH8Jpo6/cECTY9jyQBcr+RVA2vUWtAiKqIxuRDOnq38od78AHvGn9HPPrCIjevAgQgXF8ftHpQWlayGKamWN0C6tr/5fHcFpnAcXUFeSq45eFIyQ4HRaazLcBNgvgJv6+UxzRcuIYWPU2xxE5bil/5VTJDODRzJArIFjKYbnGaLWZMt1wvzxjCPgj602G4QE+h4ljVIDefgE2v6YVkBnzzsJHzGPKX0k8gPvWYbwBJxxUnQ8fy3Gf5ZGlTwkgww0sqApjsnwm69o8NQQZHbWPvxwk36SU+NEzzmOZpx2toRcOtp3eZ9JFz002AJqwc4x0i1khbA+pQmu8FtmcA==',1,1,'',1,1),(448,'2021-04-23 18:23:24','2021-04-23','0000448',1,2,1,'16192201811215174470','',1,'AAURAZO',NULL,NULL,2,'B001-0000426',0,18,'2021-04-23',1,0,0,1,'9sE4fdJT20GPtuas/qU4pSopguc=',1,'Kid8+WS9xqBND6F/jgtS/SPhWFXMLIbi/zTLMB6CHZuq1tNBMjipm/FjLq+StBKOSGZ2rN94KmVMyoa2Hjg6l/E4WN2lHJhI1T41sTMk8Hf1QpfqXnwDFlhtW0mldhIC1RnmP1vp//Eqxh+orQPxvuLRICvoNPdRqRQJ6H1wbC7K12rquIYYxpev/mEP3+7CGiBxggyFMFp1Ue5ys4iMwpm45jddXuk7vKw4+PH1ac/emg4ttwg4EcvM53elqxi4Pq78m767eElQybxMmeOubpJ/9cxRV9eicpBcqBEYBtGdD0VzPoZjiqaUAjPP3/QCOe1XdoAbTryBAxIfpfNLtQ==',1,1,'',1,1),(449,'2021-04-23 18:24:04','2021-04-23','0000449',1,2,1,'1619220206637386744','',1,'AAURAZO',NULL,NULL,2,'B001-0000427',0,18,'2021-04-23',1,0,0,1,'5Lp5UlFcBEArhJtR35oDK3a6n9w=',1,'ivlHB/b9a2CrKk4fZcwaluYSNOlFH6phR1eEaUwj0Tx7xT3RuAMHeA5J0QGDr18N5iSvxb4VIpq1s/TVlNVRY7OH4n5gR/nmrdIuvUuonFgJtR2PX0gHWBtgCyMEzA55ebVnIemKYBhIqgPTSrjQR9isWxYd2AB0ir/qSdf/qHA9PgL6vVDToMTua/pG/ZBflCndcZnwQ3lcIiCWPxAJtY6teefKP6FI+vVPA5wtdKEeF7LJppyGiDaTDhnPjlHOTfRSBsJgMbNV4UxKhdtOdE7Q9hcfgC4uTjejoqilxFn0rGcassynz6vd7AgrOiKEcrhfGRG7bXLuxchq7o68DQ==',1,1,'',1,1),(450,'2021-04-23 18:24:44','2021-04-23','0000450',1,2,1,'1619220247357120753','',1,'AAURAZO',NULL,NULL,2,'B001-0000428',0,18,'2021-04-23',1,0,0,1,'3EqK3PH+0MCGl800QK7eNfR7mdQ=',1,'VMvsUa/+0vUx4AH9VgtBsleSHIyNQLfcN3VRmywf4ReLhiQ6nBZomXtNPClX0zMnHEAQFtyyi7KsnXCjFrdS3vlkx4QIDkMFaVXY1yVG2kxZB0HgbZMtkji9Tc9HzhJ1q2BHJniDKx4FbgmJYv9MmgKL/9uLQlyAVPMbWmbwSiAw+NdJ24NTDkmsmk/5nJ9SLPKtjPM/6iP7UK7D65Qa+S+dOqq1RI779cQZi8tOJSNd2M/1O7QuaZOIwSMrqtkGQAX6NguM0ijYXdDm49JWh0l18pXo6L+tL4oupV9m5v1qQTZTM5u6HR/kK5ZOuJHtaZRzbcFf0WYVNRGkXX3aUQ==',1,1,'',1,1),(451,'2021-04-23 18:25:22','2021-04-23','0000451',1,2,1,'1619220287435395563','',1,'AAURAZO',NULL,NULL,2,'B001-0000429',0,18,'2021-04-23',1,0,0,1,'HsED6F7nuNm9pEAZAIJJmF0PTg4=',1,'UBCAiRqG/LXLLBo/SC4DnDMTG+0WOQpH/kG3Bt8e81Iz/034oOe2NsvHWiaLz8S1sjBw71Iun8p/IS7bRe/XnWW4pKD/i1ziGkUq7ireo+ZDYSsBxchJRy6vqWRTfT0ZtC34K4UA2yZArH1r3kuoldT/s/sVTXeBdzOm4ZKlK1r3tDdLts0kUO+GzHB4g6SvbtjgzSwNz1/UqYLmdBCBYlPs835s9FYMVjbyUNkJvtbx8Vfbt17R6r0WPw1T77rRdByeZDWQDv2/o0wuKSNP/YEQPTlgC71qdNUMKvE4fThmjeFebqwACH4QYuG+XSG3b6h8pmLFTvwmZZuaW4aWGQ==',1,1,'',1,1),(452,'2021-04-23 18:25:49','2021-04-23','0000452',1,2,1,'161922032417772126','',1,'AAURAZO',NULL,NULL,2,'B001-0000430',0,18,'2021-04-23',1,0,0,1,'Wy37TGbuplNZqebGs/gxvAw/RJE=',1,'S7NBud0XLwFv4fT5TPPGCQvivbkXj1A8QZ/6oGFDLKXTVvyjDSlbz+VcmGVeD9AUD2Fq/Ll5XBySXu2zLnNWyTKmSfeWz4BMXNKsfKfoBzu6gNJ8n09VrZqm6dKBw2Ybgv2XETqJjnxZ4FOXxZcXmqMRTkLaAIEkTWTzvaJ7nv+BXM73guuDg+q0hnJcO1e9YjOkIBRlL7pb3FfiB+QAU+xPC/zOStXZjmHIkN1Hn3rf4iycUJDuPmb89BnWDlhF1yTkH5tbx5pkLPdcuFTSfHzPHm1np9ZiHR5u2Q3w7RjXh3F3DX4fxtEP5e/IoK6Y+bS7BtP0PkLdKyTerscELw==',1,1,'',1,1),(453,'2021-04-23 18:26:25','2021-04-23','0000453',1,2,1,'1619220351263010247','',1,'AAURAZO',NULL,NULL,2,'B001-0000431',0,18,'2021-04-23',1,0,0,1,'tiFZOCYNoxgnObomUaPMrb+AId4=',1,'JAY2Mx0RwsKXaI77jwRGgKsU2vI30tUNlJCzfX0tIa4wiIYitwL5a6m11RtGVU6UOTQiB/I02XN3PrtT6Gxg/zpZwrPDtLCBLNMHWmgD/6ebvFsiihGpcX0uOcMrVNkP9UO8NkTYER54PNWz8zy63OAZOesjrW7hYMPV1p2dhFpLQzfy02BlrOSnmJlErED2pYhW6fzhcRFxYDIoNyyzcbWBFQwS1T7iJG9Tgn/b88CMkh/rnjVkkIfC+vReuJmZCLBvEUFaX/usoekbVjepa2EGJ1IbvIZc5EyqCULt9+HVKXgEvQ8J8jUKKp+RN6SPdXNocVGdRAoogzLeD/VHvA==',1,1,'',1,1),(454,'2021-04-23 18:26:56','2021-04-23','0000454',1,2,1,'16192203941255538281','',1,'AAURAZO',NULL,NULL,2,'B001-0000432',0,18,'2021-04-23',1,0,0,1,'ubhF6bUHur4SfWUZcTAcH4zDR+8=',1,'CMk94fJ7Q4i8AIytDMqZoHb1XM2QbsNjEgqYQcDs8PLEXj8oopcCi3YtXe5KJhnFYJ1K9GyR2vEjJUja9t/dcxo1L3fJOxpSrSNhUnOtgrfvEX8/PDJ33QdB6954h9V5Wfo9PWHLnKHhCFJoIiMFVpnZJH/kgwcpas73dd43JvrMv7AevR0erq0Ye4g9/YqceJ5vTjsW+6cENInqx4U23id92UItzGm8PWPBxsNkw5XrIrrjkGdgfGMyn61P0MQxCGP13NEWJjGuxGh1zL1zG+8TZ1xG1m5ChEp2T56/RzGHVzfALiefQcfdt5UFiLEk7FBm221TTrYCfFi7sdesFg==',1,1,'',1,1),(455,'2021-04-23 18:27:36','2021-04-23','0000455',1,2,1,'1619220419545944209','',1,'AAURAZO',NULL,NULL,2,'B001-0000433',0,18,'2021-04-23',1,0,0,1,'VAnuKboYIA/ilEL0yNzM/QGfx3o=',1,'N+gYoRxAs85kQ9nPUNrBBYgerVIIm+G28YoJGu7SxnxsGwkA01wNgilcCs5f9aOwSDs3khFxpmmg4ozSpEUnc7PwET1RUZamA8lDuvR5oC14b+58gxTcoNHsc7x2KKuJfuXlVWek9MsN4kFeRXjxlNB7GCiFAFb6S9YDdp9xM1XbXk06RXAW/okbKrmXLggM3YGyDYdBq5TrHNLGUcVN3zrUO64WxD+HrD15D0jgYuhPkfx9bb7iz9VTaYnucQCMP78yY4liCPzA9muFBa48x77MEqUIBvLJcTyx1NxZf8bdZJ/tv98TWQcksQuqXrdzwyaN61gs2XsbmRcSmZln9g==',1,1,'',1,1),(456,'2021-04-26 18:33:20','2021-04-26','0000456',1,2,1,'1619479984243258660','',1,'AAURAZO',NULL,NULL,2,'B001-0000434',0,18,'2021-04-26',1,0,0,1,'uch8I/imdOp//MUef0CpC9j2lRw=',1,'bCM2O2j/EEVkn58cFT8GajTwfsNoH9JSKSAHOwMNSU1JyehDCE7/U842WeU8LerNRyo/W1kDopDF\n9VWpfHm4VqPsYvDtI5wRCLX7wkG0sw6JUiXNjAIjQEaVyAmOlUfSk8J7N0MhQwMzv7mUIwyVJ9s4\nEs0pcxGb28a0Zy8t4wuNo5EfBRGqL4aHHDN64MwVjWudZGPWH2kQNZ6YRQ6jpECYWecsoPnQBuDv\ntQ0mvQedwA0RzeAQCyuL6wssvblPM0ghQiY9r7PntCOYpF5FU9h0Z30i3vt6BKukWYrgjZ/Jlbl8\nrwnd8O0ZsLO+/u9lFd1H38fMZ2zUXR9HPqPquw==',1,1,'',1,1),(457,'2021-04-26 18:33:50','2021-04-26','0000457',1,2,1,'1619480006536692376','',1,'AAURAZO',NULL,NULL,2,'B001-0000435',0,18,'2021-04-26',1,0,0,1,'MaEoEBRLCixitHWb5NxGdtEyFsQ=',1,'cZxaG6rHDtVwL/2e7y/i73g/XBPRpWFFaAIjcMGzEGvOgOEu6Y5RM8yxhY0SYt6JA9AR7AFKVQDg\ngojCRrTWUnxPh2k4e4CjLbeohct+GqRsvg9cbQm/a3VBkmLa6+C+TwFGdqtA5ypy61gHRKOvYVq/\nCNatZz9TxnKuMO9IHbQGgqbCP9Szjp2BSPMS+GAepIr8aNu1eoe3/6U5q3JPY0bsZLDpIlyGGYuz\n0PVNjfgfN2QESClZVRmtAVg75L/xG21hzjBjpOnR874d9gW0HtxEljYbXlfFHgklJOB2QpbdTXMr\nI3pM4WByxKKkjH3HuB0p3pSKyGl2PtB/ZxUDPQ==',1,1,'',1,1),(458,'2021-04-26 18:34:18','2021-04-26','0000458',1,2,1,'1619480033638548602','',1,'AAURAZO',NULL,NULL,2,'B001-0000436',0,18,'2021-04-26',1,0,0,1,'TVRqchhctEXcx1zGoC5bqjZq32Q=',1,'QaNi7PG1OfonUdscOXYQjkOOMgfTCASv+Ct+Z0hEU/yYEvfDakv1tNmiibBdVC3SmHNLtzb/Y0I05CA9RXnIKfPX0scu14dXShtl/6WbpSEfyTItV1sYWrssVSP1j4TuR0D/GxZDGPIEBimEVT2Zq9DsoJ8xOv+NPrkJ+E5fCadYhz2PBCjBuP8IZKDLxdzq9M5S0gxfBGZWKQjvJtQKI1Q9mJk7BkKXE0AoPQTP1acUg27XhOugABy9bij4kRYFkpsNNoke2rNideS3C5CtaNTjkHOL3cwjSpmZyD7REIEiAhKz81XNPE8jlGz5SbJQRNMShU4VKfLkfEwbGOzXlQ==',1,1,'',1,1),(459,'2021-04-26 18:34:44','2021-04-26','0000459',1,2,1,'1619480061995884513','',1,'AAURAZO',NULL,NULL,2,'B001-0000437',0,18,'2021-04-26',1,0,0,1,'b0OlFjw4miLrMFyQMgEBl5cybyI=',1,'KuGLelZvzHD+0z/DAhO6lB6F6eQbsI5YeSGLp3QohCV3MQ+/ugXzeYDXg5sTVP5rLvovSieB9BUudV3+KIYKsDeBSvpftMY1tsl59K/W6axD26PyoAnhCx+92q2RvojYsTuRDzc1VFg5T02FKoroGeAqDpBbnGxwz+JkcSpddRyLMWKHykqpRdhKfPW+Y9SunKMt1xROJUY8lA4Z5wNx+YHCjfHmRG1/oGvTt4wIbWl+R1LzIjBb5bIexCJrL2KHnHfH7lfdPgcQuKv4UlfBGFQNGU6+e/69dVS8/x3VY5fRjtwzeQvzpart2UtOUoRhi/56PGR1Zet/livXTC15ww==',1,1,'',1,1),(460,'2021-04-26 18:35:11','2021-04-26','0000460',1,2,1,'161948008782707084','',1,'AAURAZO',NULL,NULL,2,'B001-0000438',0,18,'2021-04-26',1,0,0,1,'kmDBL8HDswOOrTBNjlvaKl0YR1w=',1,'BdfRUg2xDE0K5I7fLWfjZxiKHqt78UygIJvE79oPbEDsOx0BY3rDkjSXxXV6XMqYZrjNnD+fzEB8gtP/X/I+hRmo4km+gqCryk4DpIcovDck7DQORyFuNrfg3OtawsfP/xokhao6ywQecl6X0rM4LePCT5OPOM2a2/JBoSQyLzjEm4o4l256LN+2UUPWS3LxHZdS9ytS9odcTmx0MN5P/PxxZZhEYSuSkRPd47Ozj2VkjowI3wtozDiRRnNTLerCUXJ6HYXUISyUZgV6EqSlb1DnK6vjpgPuP4Pml0Xfw13dhSyEVC4jTEIOnSY7L0HBUGt+w1g6ugN1Av13vsg2VA==',1,1,'',1,1),(461,'2021-04-26 18:35:33','2021-04-26','0000461',1,2,1,'1619480114602531001','',1,'AAURAZO',NULL,NULL,2,'B001-0000439',0,18,'2021-04-26',1,0,0,1,'7Bw4/O9p81zPfUxg2JSIaKYZjZY=',1,'QypRfvkqjE8VMp926bqBu+0LcC9pNeRmtdWsu1R5Us8ZlvdZ7Jq/sk5sT4mfpdkX6jy62LrV0qqTrHXctlntCuq7laCIJVG2QQdAQHLYcWqAW/2TT3ckRYMpA2u3FiA6ANwgsSUZKoAjxvKf4NSoLiBNd2d4/vdhaaDDsSn6FMrzVH1ZSBTbOrv/G/5LnntaAQyYf4UuUAm3aHKOJOokA1tSxXcojOl3t8Caqjxdbbu5Tqyi6nih04FjfLbPjAa8PsUkOTJBb9MrsNF/miU1Oyrnb22UAZLHaozcvA+zwZhKxBTFbUi4o7n0/8yxk3F5maFYiK9m3ceTpnVtkNreKA==',1,1,'',1,1),(462,'2021-04-26 18:35:56','2021-04-26','0000462',1,2,1,'16194801371220424348','',1,'AAURAZO',NULL,NULL,2,'B001-0000440',0,18,'2021-04-26',1,0,0,1,'bKZh1COloPEFjlb5FXKolsr9E4w=',1,'STrhPpGfTxyXbnpdkfJWngsiru03QciJBw0C47yrbyaDtVK4/A9NbO4VTnlc69OZuafEmqyabiYvcSdBXHtYpITvpBSZY1qUxaHdua1E9B6gmaBYs7xOE6+upHANk20zJVQH394roY99bebzmS7jzcr9RSEcUfd0HE02OefxoufQVmNBjQJ9F6jP0fEyK1+MCD8mJ9o8woz9QPcDvRUrYstGq13ylY09yIBlvRM1HktvY26Dso0uNL6BiogFL+HDo8KO6roB3V+K4ORn2WlqLkqFjx4JTxrIEnW/LkKI54Dwl2tzWcpP+Wv4zEierzdi3/yFsxP7DnpxlNJUPZd2tQ==',1,1,'',1,1),(463,'2021-04-26 18:36:18','2021-04-26','0000463',1,2,1,'1619480158264215137','',1,'AAURAZO',NULL,NULL,2,'B001-0000441',0,18,'2021-04-26',1,0,0,1,'OxMEtWwBU/PWKrg/Y+idx829Wwg=',1,'Jxg40a/Dkm7bkVddQy86a/4RHZlqI1DQTymClJ6uqfC3lNqE7RHIxBVv3pZ46r+FZ6zPzAJtTWR+gyuoqDFZLCWJdK6E3+YX1iGO6+I3CbX5Em2IkBFARI0SQyK9QelHD/4o15WhjsotH3cff1EJg1ER+NTtbhkMecPLbiDx7YvS1FBgB1ZSxJHlrYB7oIE0d6o8n1thE67GD2WcG39wx674fyzSDVXv2YhAQggLySLdCG1KX/GrVDKeyQIRX9wOEaSO3T7wYf6ymqB72NAoANtBb1spUIIBF5fOuZfeAmLDCZvSZmVGpqC0BdFRn23Gz1HkJf1WfUofhN02rvEEBQ==',1,1,'',1,1),(464,'2021-04-26 18:36:38','2021-04-26','0000464',1,2,1,'1619480181496199470','',1,'AAURAZO',NULL,NULL,2,'B001-0000442',0,18,'2021-04-26',1,0,0,1,'gz+RsaYqlxJ8dFgNp2muz3+yB/c=',1,'dbTumvrp6lioe9snJfT9uXe2m6EOuGov1w5NiYn3OGDYpeclky4bFYaHYTKJwYPYmfqWSPF9o1pHce59Ca3KQ8M7fuIxq6mrbCRnjnCD6hKXU9ISZTNH/7uYqCwXfMK31YSkn2P7uWoVsMO5cuZlSxfaIw0W94NgXKGMR27p1NXCPbmT8BPTIU72Pefb5RH9qSSkThu7+uBRFFcOB2xmrWN3C9Oj4JEfcZJ8i/r7HbU4s3X7EVNuc25IOLZ/8/toyJvUSA2cg8FubruxBxOaz0Eujown4xzEkkmKh25cGpoK5sLNru2d2CHmxELYQTiLag8P8/5nB9WM0N7ZMQmZBw==',1,1,'',1,1),(465,'2021-04-26 18:37:04','2021-04-26','0000465',1,2,1,'1619480201129138376','',1,'AAURAZO',NULL,NULL,2,'B001-0000443',0,18,'2021-04-26',1,0,0,1,'NRCiRLvbkPbRU1LDisRUHebWBfc=',1,'d2jyNQsuGuYrB0ce4rNmmVuggxvSXaGfSgZxmfGOdSQVFMQyen3PG0VrcIn9PmsR8CY+KsbDafhVtm3zFqSv+/0b3IegYwSFuC+5g5cZLtYREveiPbzGjyM+Dub9XkWo12IrBTvE3w41p+d/BBFrpWYJRp0m4UIoyW/roKIx5G0qXW28b6n2BiHvj8djheGZzI5D/ngmWg9JtHu/3D0oDJf/8RtgZNNjf0Vlhnkv0Ibg14E6mxhxz4lFu7D9Z8Q3c6buIa8SgtFxD+f8PVD476JmC/nAeSYYJFujtGD4Tc2CnwfKf/Qz4peT/F7UXB25cdKAvyYVPlY6150Tf3K9HQ==',1,1,'',1,1),(466,'2021-04-26 18:37:26','2021-04-26','0000466',1,2,1,'1619480226227465996','',1,'AAURAZO',NULL,NULL,2,'B001-0000444',0,18,'2021-04-26',1,0,0,1,'ygdKbLM/HYlLJfj5ARIVUoZitJw=',1,'fxs7Nnad0PYIept3G4z9HpEKuFCZ0ewHm0u11a8OMTOfVsa4876bSzyihGkQQT/nnlQgF0Df9FdWW9rwdUAgi0psZXBbayvWr5ZpfMZhoTXku+xBy6sOD2FEJPDDZ5VI3YlDHJjG1kzroRdvTT9KwFP/DDg9Dui5BB/b1xk0jDT+idFUPfNg//BuWLardnwTi58AzMN37MStuArpu0sffAiGu3UmsHi0tM4FonJasboNwAms3Wvnr4mVAaSIyvjfj81ZFVU0JqYB3C1wSzZm4lA9O1zjVlAVLVQlolsca3lQ7uZ31l9xnm4GNrv0ITxkqcoxU7z/lHg7gTbvuEdQkA==',1,1,'',1,1),(467,'2021-04-26 18:38:04','2021-04-26','0000467',1,2,1,'1619480262855643938','',1,'AAURAZO',NULL,NULL,2,'B001-0000445',0,18,'2021-04-26',1,0,0,1,'M7CP48a30nLYU9MIAjgeVTwSF2U=',1,'Kosno2voymzRpO0I1ROshqMg2gNAXRLhI9VNHFpn9UeMTcoKGP68N/NVd0mOQTR+VHs82x0AFYjiJZztHZpXonjoPix7IlQY8I3z+ApAaolmsqOGpiGtharmx4tLFuGC6oFyYUgSe8Zacwbs9M0xRVOoqXNhQWtlqc6BIvD1UsQpk13OrKMh7143bkpv4AbknVjsm1xxIhaO/U3Kvv/QbSm5LnW6k/C9WBqtRK5XWCkRntNkPPg1otZbr2ZSOUdiZF350PGBy64e7sbpVMa1DT5vPZcimAsTnkYN3KmAg2Aoo6bEc5t6iyGfEZ2GlskUi8NXD1OPZSBkIpfD35VdkQ==',1,1,'',1,1),(468,'2021-04-26 18:38:24','2021-04-26','0000468',1,2,1,'1619480287164166246','',1,'AAURAZO',NULL,NULL,2,'B001-0000446',0,18,'2021-04-26',1,0,0,1,'erHhlk2CyS4reesp5ssxdUV22oQ=',1,'boDnE69KLJ+WjzN2TQCvM86gjf5pvnY28z35ROoHfhteW1+SSygjAC0nOKk0J/kODoDiYtUvdM/xxeMjAW7LDlxyCr6jE0BVFMQmq1wv/vwpk2tq8z/uedSddT4YpCWxR+22i49AAvmQVQljC3scM3Tk+iqHfiezrtKIu/807QrTsGnE+NWmz6/uWEpH/GL4X7zpKhFpJ2MIbAuGaIT47KO3QESOaWDKzzCfGcLq6i71e4ullTaYtVkTTfso1e1RHZxrQ2uSjjNLBODXPH8xSS3khQ+x3XEuhvud/IOIdpE5XM9jD5KzrBG7L+KtfrYGGm41Sl4MXenAj0+Qn/DwuA==',1,1,'',1,1),(469,'2021-04-26 18:39:31','2021-04-26','0000469',1,2,1,'16194803481084874237','',1,'AAURAZO',NULL,NULL,2,'B001-0000447',0,18,'2021-04-26',1,0,0,1,'NAjUfXqM9ZHqYMTqlx71jGdZoJ0=',1,'WqZ0OFv3w3vLunqy1AA/X1GduMaaUiEzcIPVZ/aAWpUZuqPmRZVLQfs1VT4fneJb6ejskvd55mvkOFOzkinflSoQ58aGiSyfnMUoXiEsygxeE6QCqs44W+KgnmhD0hQ7nSjLJgffcEdmDkvzUp1d07cQlx8G6kfuKd8W0xXmWwAzcXiHYUVLF4z2aukmyP2xcabzzJcdIptopMpaGAHm+a/GiieT7geikP39QShybaWICZaBvFGSeNNWL/fREFwOVi5GhkvBP1n7zVTptgzF62NMSiRdkLqjVr5E6MDp+Wy+hUKpxUZNe/+RDzyGmY8+/QZ9GVk8gARVXlc6Jr4EqQ==',1,1,'',1,1),(470,'2021-04-26 18:41:58','2021-04-26','0000470',1,2,1,'1619480484938523149','',1,'AAURAZO',NULL,NULL,2,'B001-0000448',0,18,'2021-04-26',1,0,0,1,'aUGlT4PAl8xoyUALhfg7/qHVryM=',1,'Uojn52Z97ztbgSqxEdAIh02+Rf+/h4rmBV8GfyVZIKAvNWJ9VJkiBF+ChY59F18WcdhtqY6DkzgD6Qjxp9Qcl4YWrNm0+5OaQbb6/93AhhlAsG4pLkFMPwYzanIl028YA/WKNOIwJ7m9wwmKCLJO+pwGMMlk6aXvKrt4eDsbo8mXkcnDCAq7AS3a1kmf/NiUsOOFBjm5Dotpjv7hXdcvf1x2yHzJcmG874AGiH3QIAPMD21gAoPtg+AG3NUyOsP9xHP2A7O1AsfB9Kr3J11/YHQ+EjMihCJvu+YI3cH+Q+3OqJYuYWxyDbx1k9l+VIqiy14IEZZcQ4V8pRS4nOULRQ==',1,1,'',1,1),(471,'2021-04-26 18:42:44','2021-04-26','0000471',1,2,1,'1619480521421539329','',1,'AAURAZO',NULL,NULL,2,'B001-0000449',0,18,'2021-04-26',1,0,0,1,'cypkX+qMw08EJGki99JBy/3flMo=',1,'A3dkNjuny8j3iXP0R3MpCSkHKiQNvoWhTVpNoEau8WRLGgScyTW3N3x3sn/7Dm+OplvOvv9hGya7UNBgzv0Q4W5jTOy8Qw8hUrAYs4FJ4SzP1vu/n7qJf/hhl1IpjR9q8yJzgtnaBhA0fzSXsrphVhzMqrLrDC058VcHP7yNrDhttROEaX5PAjVHBU58ItZ1ykrWi0GMmg8na4I4efmXBCSlb/I7sc2wQylc+50qxDOipjkuR5YKQEw0qxq6SzyGIFiWdtvwQPoJu6UoFAF77fKForJZDBV+/vqi2Dl3Up2TNvvTZBNb6mEJbghfcpDmWsZi0w0+QYzv1CPZcE7FNQ==',1,1,'',1,1),(472,'2021-04-26 18:43:11','2021-04-26','0000472',1,2,1,'1619480566310904620','',1,'AAURAZO',NULL,NULL,2,'B001-0000450',0,18,'2021-04-26',1,0,0,1,'M3gq+SL3t8kw/TooUWDxHU+D2Uc=',1,'ggG4IoX76Ix8tmQts8bMMGalKX1gQVxO01ZRqZqNX6rqR/zc/4hH+e2ENe1upLOqGML8neZJ508MU2pFGimO3DR6ldXX0PVykdeP6atv08QPRXZt6zRGov1VTLr0v/r/nY+Uq3+93ER4zzqQWpMxzwbouSOYVNNa1OHiBS9PuB3jTcgSF7pF6I2HMGO8ES/7d6br3r9b4JeVgUZMFGFPYQh8/D+gh7tn+rE4cUMFhqPri8PUwiZSQoUUwEdhPdOCANPSP91ysvWSuzk7vuS/C2vkC04E8ZEsfyTPRDYFiRuUjLtBzI5MLwUgOulOtWq7vFXdeO3UwA4E9eNe63xwTg==',1,1,'',1,1),(473,'2021-04-26 18:43:42','2021-04-26','0000473',1,2,1,'1619480594367147158','',1,'AAURAZO',NULL,NULL,2,'B001-0000451',0,18,'2021-04-26',1,0,0,1,'HKYhgqYznXGFtIrKtnBHaVh7EeU=',1,'Mxc3I4VgWOklpqsXjf9G0XezthmAEp81J7EqPy8q4/VfDriWqKkVsQSpI2M3vuX0POK0Kd7cisEJ17aL6IXYBpX6/hoDN2zUvrOXObjWzWzrFmhQbmcLBHZ89pekFUjeaRzPOlrCZKZsl5OaSZoxvLROdeZIhz+pBZELR20qZjGXIg9hv5w54+lmmN1M1cglhCd3scp5BxpZd0Mom70wnKbNGHX9TBsIe+WNPsZ/M1XFfXThspTTshrd4COSmb+E84Cr+lNAew2Oqvm6GPxiLqpENuDVUzK2YLfge+HfHLocdeV4Cx92Rcrmjmm5f4dx9rE/nEpLp3RZKjemT5YcWA==',1,1,'',1,1),(474,'2021-04-26 18:44:20','2021-04-26','0000474',1,2,1,'16194806251148561273','',1,'AAURAZO',NULL,NULL,2,'B001-0000452',0,18,'2021-04-26',1,0,0,1,'I96QqG77rxZZZeGimlRMRCY3iXA=',1,'glbxUw847z8z702iJfPUrfBdCTtqHqTNYf6du5JhyUC4M6cZ1m7Y1XNJNQgWcK5hULeDPYFoLUHV8PvxJaBC/tp76opD5Tfp8LMK5uchAN1nHawu/sznpq3xpbIIOFnQwfnAKjc3Q9G6Nlrls4x9FBSuWH+bnXBhdp8fvUQOof8IHxgJwnR81elIadhu8gveCyRn8M4FrPtKBL3DBiSWlCBlbRtvekOPVEJhlISBI8GIziKGhy0b5N7XRAENz1ZyVZ6xYeh7A+NIWk58Zy+itkNOgwlrn5dLg8gXh/W9AVcJHkHgBhc3djl5AlxxlQSgcJTGP0Kp1Osl/UNxmQ//4A==',1,1,'',1,1),(475,'2021-04-26 18:44:47','2021-04-26','0000475',1,2,1,'1619480662737607762','',1,'AAURAZO',NULL,NULL,2,'B001-0000453',0,18,'2021-04-26',1,0,0,1,'RicD1aTW+s3Ct1nek/LLZXmxPfs=',1,'BS2iTCzTR8l9+dsS+oG+k9PT1o3R+BxH7LvHKRcf0prbU8fyMnd4RPLv7/GoIUQ25y6fdTSe8CyTHzUFripmgg8SpmQiiAhQEOcyzMah7CbaJtz3fZ/BTw9MjuyQAE5zUoGvo+TMjmndBvX1WJve0nRp1lFxpdk8XNZhq3aDYW0/KaWF2A9LQoFUKidxYrBaclfhICrCfOdw8MPRQEid2Q1HsGr5/XIiBh4ifL4cjveZgQU/imDyoN4tr5gGGVwhYi/0/6dEmSQ8j1pcCOQog7GFN2VX55zTGP/+S14/Oce+gWT53+1/khZdozqucKMYjfNOP1zfGhfQTN9OOq0Mtw==',1,1,'',1,1),(476,'2021-04-26 18:45:56','2021-04-26','0000476',1,2,1,'1619480731440344218','',1,'AAURAZO',NULL,NULL,2,'B001-0000454',0,18,'2021-04-26',1,0,0,1,'3adTtBAd3neGxYJ2RFjslSO+nEU=',1,'fWgdVc14Kd0JhBmNr0tT8GScLQQB2KkjF9EbBJrNwu2uDSUyMmM81/Ld4HSvGLqq1jnP8qQyKWdK6Tw3jbR7F27M+kFOjN8woWRQaf5nQZFn7G+Xo03uOi5ObXDNoaTvZRfSh1mbEMDIWKyGBzwcv9TKjjp0KtuzPUYvq71dksJgDAWYYSxqysoPy2exDL3HuHF+2zeRpHRRJRkd8vGOJVFNp+j/3nioMKh4I9bvdsty8ZDttW4bzB4N0SNzRlpuzl/V8KVGdcJRtCmOMcc9KLakoSMbDwdkwzkXvKH9sACdL5EaWz938q2tBpxOi+NgY3IhyY3FAJjDVJDH/ALnyA==',1,1,'',1,1),(477,'2021-04-26 18:46:57','2021-04-26','0000477',1,2,1,'16194807961270556373','',1,'AAURAZO',NULL,NULL,2,'B001-0000455',0,18,'2021-04-26',1,0,0,1,'C5bTji4DNb7VsoiZcIQS0MeikIk=',1,'C4OdkqsMTlseW6I5nVm9iwr1DCrZ35cjSLF4oC10TyRM6a5hVbOiY7j6fzKKWfMegvTyiZU2/fGj9lQ64ARO2GmAZb82tTfOCgigoiS8ncdNcWPoVnZP6DmKpaLNOcu3Yj6668Qx+e9Y351qyqni6UjhDx+vJiSvseFvaSzj3PTVx4W4II6aVnG+sjJTpzkgXvBTUBLXZrYk8jPKWYQJtc+qQOvAhzpbdy9y6V4meOdU6Of4zL3KtR4k84/+Uo1iDHTNzkvKCmDzraxaUmLe9n/oTCcCCCu9Q6wcOcuEmHdpM0k/nGtb4zs2oQWhKDUSR21LovMPJXlZxiaVSpJg5A==',1,1,'',1,1),(478,'2021-04-26 18:47:25','2021-04-26','0000478',1,2,1,'1619480819781285020','',1,'AAURAZO',NULL,NULL,2,'B001-0000456',0,18,'2021-04-26',1,0,0,1,'cgHxJRNpKH0IGVvJu+jB/XXzl5o=',1,'hbW+VqtsZ7X7jX0webiST6HrGDb8NqBLJmOW5CScGBGyjZEREind0D9o6AaYVSI/YsEJigavL7ygXRSb90onmB0e7zbQhQOaN88N5vJo/G9jwwrJ3zaxq4Kpax2XnDUqe2I4ODKyJsJ1c8fwgHuEkd7m4waJ+KEZRAyHd06d8R3EkQTUjnEuRkf2MVg5ExZE3FhaBdRjouWJ2aAdtNUPoL0KiFNVYq7UPouzFFZfvUjdN2QLEd3j2tvITvgtUbxuoT/1SO3XAfPwb68Uz8ANCw1/qpY2ickuuq/CKSsJgKLOF4Sde4++y9wJy/fBHu6I5kQe4shU8HSWlJXXl1ekGw==',1,1,'',1,1),(479,'2021-04-26 18:48:16','2021-04-26','0000479',1,2,1,'1619480854822982816','',1,'AAURAZO',NULL,NULL,2,'B001-0000457',0,18,'2021-04-26',1,0,0,1,'PQVN3ih/NzZHVcGQ05XNIdnkRIA=',1,'Lskvtt9VcDWnxO0zOiyx8eNW5RgG69if46hsUlDzIjqSU/GQHxLdyd9fr0x+7sMzHKBRqPmODqxeg6JFRwhAscy+QvFhkpiviU5SE3QAF/hU3xJ9dbBwQI4r9o62pm+EGFUCWLJ5hSpqs3QLRIA6Otbq8J2Mz+1vnC2VKjstR+3suFNnUKY3lso9O/6lgWLwrnvXDTgKrNXOjrFBQgLT9eRoFeUBClqiZbJuQi/7ju3swYvUOvCDsxo8twZZrEYEMtkDrqmrQJPc+O7Uv9+KggTNhovGOzhhyDgzgdLb1GpLQoZUDPjMgBjtTlYIDPGuW8GKw6m6yIxSfZO/HBgPjw==',1,1,'',1,1),(480,'2021-04-26 18:51:45','2021-04-26','0000480',1521,2,1,'16194809131009912874','',1,'AAURAZO',NULL,NULL,3,'F001-0000023',0,18,'2021-04-26',1,0,0,1,'tOMsTy/Z3oEn3dofCfc8Unn+8rQ=',1,'BWmPkzO3O28Mzy2/vCVmmxIbmmlwEqPotIsD6CMmEigGLfuE3T+rROOlUUCdoHWvXop6IPWZxmVSr2C3dbCqzIpCGBcWj9FVf5gamjkgNBwtUNsAGaLvEjSNjJRuT897wZnzfJQm126W5YrYpogqr2sHbDpqJsindizRl1qOKImcQ4plKwKQx66fXfL8rVQGGTBQbGYDKuEpcbsBmeOlTOaYWUmuu8H512rpi1CMlBsX5Iq1cRpSLqjUYoushO4ipkQXw6lqT+oQ/WTZwRylOBkaM93ZbbRX4yhInOZvfjVOvXuM/JWWNYlCmSB8whlmc6Eq0PcYXuIqmxaqqGooqg==',1,1,'',1,1),(481,'2021-04-26 18:59:03','2021-04-26','0000481',1,2,1,'16194815021121924600','',1,'AAURAZO',NULL,NULL,2,'B001-0000458',0,18,'2021-04-26',1,0,0,1,'+iJO8zHB0MOeBFlNbxoiy86MaIY=',1,'Flizn/ZI1irowrL2aB6wkSHLdiiYem3aQeD4VfaMDk9vqJBr6ApajMjh5vPXwqvUGjuRmnVQ4oZSDpk+EJz6LQSVvV4k9KkdMwivXTAB6N3NGe8IFRJv0De/nYt2deVumdU8OC9qYNf50KYPnnFppoVMCgtJQ6rr72Nq16JIMMunbO3H6cVF8isZPVQsPHKxdWMcHc9eRSmE0+Zzcw5ZmIkMVlkOLOnycg8E4CtnQwWAE1xocQe0SzmIpaXixpCBxZ81VGmHQSku+76OcWLcbviiIm1FxIWdqLXr7uRFSR801OzUPdgGat8leHcpyDD+WcikHGffneNLFkufyre7MA==',1,1,'',1,1),(482,'2021-04-26 18:59:34','2021-04-26','0000482',1,2,1,'1619481545838173035','',1,'AAURAZO',NULL,NULL,2,'B001-0000459',0,18,'2021-04-26',1,0,0,1,'Kh0FXz80MKfnrRLZ//50d1QFmtI=',1,'FwY7aZh9sCJGnCyEoCtzPBLaIKiBg51p72eMUQ3WBbmLjsvPYCzA+2uAggQoErh2STqOyzVf1M22fV2qBEMx/M7WiAD3N4vEvlxCs90EWebdxgQCUZ5i4TVWZ00jF8/T1biVOWdRA2qAK0H3M783qLi3pEKzzBSL1GAlOgp+vl7hPb6pSq/SdJH5Dgp8HA/zTEvJRs7AxOxvuiVb+vAYcT228JjZzZo+DYqhyLNLS/V4DBou8/iZkQyR2kiV3+IiXmWlop2HivgXCPoImiCj2jc9pYmNWTwXb5AVD4jrbUXMq/RlT3kwiFWlB2D6AL0wT51YTTE0lmSaJrGV6dTpTA==',1,1,'',1,1),(483,'2021-04-26 19:00:03','2021-04-26','0000483',1,2,1,'1619481577563759366','',1,'AAURAZO',NULL,NULL,2,'B001-0000460',0,18,'2021-04-26',1,0,0,1,'987xfIdO3SDhogLSqp0iA3h5M/Y=',1,'N2qLa1VUf/1421tAmB2O5eTScm+fD/4/v73bCD1G+24+XzPLr/6IkwycZlyQ27IyqLVU7CXgWJOOYasar0D7SCNmb/t4GLjuqPhWtBfqj/jhT7ishergfKK1qmhi8VXDmfixUhFWkbcAVhVHWxFYBS5ED9U6WvG9fhV9g1Cqi/qLkvUMaM+/qykcjlrkmz42pOo0sSB+pSxDug5HrYasPqCxKd6G5XavOGJSGC1C1NEuw8Sfc7qNt5sYhJkJCaDr84Fxl6vErbS4WKpxe6cWPjRJT2hbCeCPEF0cigWMe6MciJJkjGV03gwot+nCGskBqL5K4U4kZVJOwc1Qqi31hw==',1,1,'',1,1),(484,'2021-04-26 19:01:07','2021-04-26','0000484',1,2,1,'16194816311087154921','',1,'AAURAZO',NULL,NULL,2,'B001-0000461',0,18,'2021-04-26',1,0,0,1,'RWi/R/ngJwRg0fHdp0GS5nRQjmY=',1,'jGn5Y2b+CPF0FdFyq0Qre1V/vI2Ma20xQkjs5get/QQFU3Ot6dp2tvahqb8NgPoNhXlQOFIc/9J0n6foD/VAwcp9yuV/rwcE7Ea2Nzhk48UeLR/3BihaggaKoBhQxVKCIAL19fcIrUdXcrOhnzplgpBNOgXdnycBaUaTvbt0cTCcHRjpzrzXlWrXp0SA42mqLGFSePUKptYZF8zQLaSTnajZlvlYsuH4huSKiSrOtgAnX/WWrJW2B0d+JfH8I3EGJ3EteaqJ4OpGumtqy6t/AGB9fr87rDQZ6z6QdV/t6JA+Ciq6drhFwyl+gq0N36A3fNvJaqwj/0OC1521hze4/Q==',1,1,'',1,1),(485,'2021-04-26 19:01:35','2021-04-26','0000485',1,2,1,'1619481672284526138','',1,'AAURAZO',NULL,NULL,2,'B001-0000462',0,18,'2021-04-26',1,0,0,1,'TvTUX2JFXZUO2gfkCsp4D3+bAGQ=',1,'U8ReKkOt4OODUWGQhZAB+rvl1mutNkNeAXK8wr08gbmaU1wzcs6NlfbG1Xau+lYZ6u6jYP7yR67P1Kso5FnNl9f4RJnI8bYvOLb+yTrm4hHAjKPnVYVtIe01jQeLHe9cSDi2PJOUv2NNYFT3Tu/EIvMt1ixuGJ7vkMU8Cz3ua4z7A9+8WbXxGl06FcPZxMRchIB3Mc/XOjngQhCINoE9eoX09LoXT+Ve2OJEvU759VTFQdLydRZHSqlLqQkrN2MheNreVglZas0dg8mDx0xs2s2AuM9HTS4xLA7SGbgksHt4Zy1rDmusL8+wdzUrqxHjdK+MkQrA1Ru43ZHPykF6lg==',1,1,'',1,1),(486,'2021-04-26 19:02:00','2021-04-26','0000486',1,2,1,'1619481697294810734','',1,'AAURAZO',NULL,NULL,2,'B001-0000463',0,18,'2021-04-26',1,0,0,1,'c6zjgnyjsFHg5agsJBwJoJpdnN8=',1,'dSTr1b6BSmXBSYZKLfTbZEPfbnbO6mU5FHlYYFl0R64Fjtl9KltcxiBdZlqArrGLuCKKrcwJgalBRz46bvUlugUe66CqbOWtiJwTUIuUlNMCLuLMAC6bsVB0YiPd9yWwl2kXezok5aClkYvvAdGbmeJsEM/FxTiA4I1APaK+0CtUZXjpsampC9Vn4KZIXf6fJtY6kkpOG86+/tmVviavZ3wiEJqX+l/WsV9cmPAuaw6lv5yUbMunEmC7KXR97PPLjzBZ3b88GWv24yYO3SAg26Zsi11Cu+EzOgwJPBxocfj/N9C0B2Uipx91VBGdfCH13OYcDJ5WbDt91bnsTc/rYQ==',1,1,'',1,1),(487,'2021-04-27 18:19:34','2021-04-27','0000487',1,2,1,'1619565549636009727','',1,'AAURAZO',NULL,NULL,2,'B001-0000464',0,18,'2021-04-27',1,0,0,1,'PejUqRiU17Pk+Hwk+5JzosDSidw=',1,'ivu0+/LymS1rPvQl0JWNCFYteTqMqdAn5LnVOGlQeVlrNXlWbs6KSKBycaE0LmQ996uiJIzTN2cg\n7StgmGxxklv1H0Tmc5o6NJW2d7Fl6Q1T6NesjXsndoSo55QvsY3d1SN8DgFFYZFrZPwmVZafuFYu\nfLxX0maLe8hVYiEy1SaGIalbDxZTMHcBUQu4Gr9GfPD1cOsXbggEk3e6ztwdPPwULIDzXN19jvU/\n8/7gGO+3py8UqRv9YEFrFlWEMNB8969VjusR08mFvKge8ZiecKtPqNFcUoYfI3riwytd17YEXVKU\ngW2bo0FP6Kn5PFQjl46rqoX4G5va2Q0lk1biDw==',1,1,'',1,1),(488,'2021-04-27 18:20:03','2021-04-27','0000488',1,2,1,'1619565576107880676','',1,'AAURAZO',NULL,NULL,2,'B001-0000465',0,18,'2021-04-27',1,0,0,1,'8B63J+c9QSlUcDCSmJ8M4ytiVEs=',1,'MhCX6y6/GrXny2OQjy5SCW8dlZuaMsxvdaQPoXnEbgGPoPLPGeOhF4rNS7KSidhT8x9EyjlXF2lE\nrz+YMFJtwgM/SsjQiuJyv071oCUgBn2DcoinZR1YfCFtU/wS7ua+SNTRBQNFWsNxCLeusVcE1VP6\n/app4OhYZs8aoHPcNvyI38JQF+1i/zNw/aTFvOReAjpv0lZiFOZP4OBkkW+YrryBO6nZupxfUyuw\nGLtl1PnwAqMb/aX9BDBGikaZswLTuRMyKc0O378KIHJ7onbk8e4UyaUcXV9KTCEmYuX+h2+gFkm3\nA6RxaN8GEC8QhZ2tpYFdKV/jCjvyrj82eqkS3w==',1,1,'',1,1),(489,'2021-04-27 18:20:18','2021-04-27','0000489',1,2,1,'1619565605445034682','',1,'AAURAZO',NULL,NULL,2,'B001-0000466',0,18,'2021-04-27',1,0,0,1,'adyfM4fTiGDtY3UgKYNGkT9J4Qo=',1,'iWz7NYa1JbFshhA7ne2hU736BhjPuurA+ve9SiqPihflRe1WuSX5L+hh56trClj60SLNFxrtXBb8jeKQHdqxuOTbp1JYuaj96/4F19zULFTpcvkkkClXf9SevT6bF8Ct4i4NeZMxQG+uIpyLfg3mcopuRp5aPTShKEOW6zGGg0xBXqu6GDwHh7LxtbRrGUlAN7SSq0WwUFNT4P6edgZRn7bWwEYpo6Qi9tf9dtnSieGrxGx3kJvZqczAkdASslX5dzSfFfl2HifJvHfuOuS9I3iUD5MwhY/auqVrhlaK01TaBvukaFSxbPvM8epgjt/M+7RCdQYn4N5ziOLXjkeInw==',1,1,'',1,1),(490,'2021-04-27 18:20:47','2021-04-27','0000490',1,2,1,'1619565621352387257','',1,'AAURAZO',NULL,NULL,2,'B001-0000467',0,18,'2021-04-27',1,0,0,1,'lqyvqlBd5Q04XRoFUHSQ1g/UU5k=',1,'KllOulaIy3zgUyJ9JoFlu8PdzflpWfte8sJnIktmMrltQDYItQ7dKsLAnkUFqBNwUJJ+MHLuVj8T5BxyKJbom3qhMKbQ6ACmkB+b2ycSXY5UIshkh2gfVvj1xjomdxnRArEzG45Urh515Ifuoj4jzpyE6xwvKdjISkWfem/lOmEuCrW004JtCAZKHP0vIoBFJ0TfYsCIOzEPrVCBWBXjagcfHbxdQyJBuYK9p+mgalCXKYS9FNKnbbpDU9IGayTJA2EWAPmEwJykLrY8iuzr52YQgao69EX/Ho7FbNNtYt4n/A675zAQN55WJ1MfXNM9bNTa7IyOjThc/xcMZlOmtw==',1,1,'',1,1),(491,'2021-04-27 18:21:05','2021-04-27','0000491',1,2,1,'1619565649195536414','',1,'AAURAZO',NULL,NULL,2,'B001-0000468',0,18,'2021-04-27',1,0,0,1,'Jx5C68zCOYDBb+QxAHVww0ipvW0=',1,'PXCQOOX65o7b4H10fsGaoUUzZrrvs43QI41WLKayn7rxuzEaBbQucELlL2x41ru0qWxrJ1bc5E0FGQ3t5tOQbKSEAjYnY4iMf+TzocDQmnO/aTnGt7/r+GE5+YbFsj53Gas4U7UOhsxwvQNXxK6eCZFnBsEV1b0IS3pk847pPOS+etJCKgnFoqLRCP9QUcbwDGOMgO3PuWMPbhPX5jnyga6Ra30+G6zVkOC1mQbGqAatqMzmRAOwrNRXdKunXlHlCzFVL4bxa47jkiDYgGzX+i89d/q4qMZqnd6bNgRdrULIf9+eQNil81cxbgPjecGaYhdytYculViIKewFeiswWw==',1,1,'',1,1),(492,'2021-04-27 18:21:36','2021-04-27','0000492',1,2,1,'1619565668661613637','',1,'AAURAZO',NULL,NULL,2,'B001-0000469',0,18,'2021-04-27',1,0,0,1,'pHdYtXtiZ3tHooFZgG6/qv0aJKk=',1,'fUumacxnfLnWimE7q0accNz14+iU39hl++m/8sy3k8qbruvUq9fhYIrZ3YDH5ktDT1O/X36UivRxmxUZJ2hiVSjcso4gnbdv05cogM+XzaFChOBJ3bgXrHRW0o0l8SDIOIU02pQchiclT8O1TUm8ArXXycYvMOK2aj+4m7W89AR/iRDDuQci04guvdeynCtRYJun6+r+jp9hlwmWUEMlFCUfsYStiiR71WhlLCxsBLu0y8Lxpk3pPPqgm6Gmt7vGjU6dTd8E/m9wCY8BIUg4x+do6oD6dPoEKsAr9b7C8JFLD8TejtH/NVL0d3X8DNHQ5W+DCbcqUEnv1RAwGh1ePw==',1,1,'',1,1),(493,'2021-04-27 18:22:07','2021-04-27','0000493',1,2,1,'1619565699379798502','',1,'AAURAZO',NULL,NULL,2,'B001-0000470',0,18,'2021-04-27',1,0,0,1,'VTEgVwvmc/bG3C39Bm+2reFgZXg=',1,'GXsFuFKA8lBmdh/Wb+cB7CVgA++PHZH+0bwoFVi5cQfuyqfnYJCHipsZ0wJLKYPyNAUz8rUiEdOCRMr5KTPI0EIYNipqrkXmetCunMsQaf6HWgeyH81sjKbUgPwQj4y24DO4ZKW9m3JRa6+1PB3+mIQgbUAcEoFNotMv8NzjtuYvlcqkaw3k5Y/fb3v4oaCudP3dnLEygiNHhOQcnkpLmj4MfAUvPo2yzuaoO0d8zmbPsQ/v9S2EG19YjgbYt9CRxbsr/Fl1hdjEnWdBIDF4f8lZPdGHsn/Qgh9VUY2KJ2sDStC4K2STPpUUATabjdAgXAJH4RgE7l7yv3nDHCibWw==',1,1,'',1,1),(494,'2021-04-27 18:22:26','2021-04-27','0000494',1,2,1,'1619565730109300725','',1,'AAURAZO',NULL,NULL,2,'B001-0000471',0,18,'2021-04-27',1,0,0,1,'wUfjad6Vpr7T3AYJfqQiXx2pXgg=',1,'PtVf8IhDD75FVpZfzNy3n+xpF/OvQF2HRud22OoV3GenjzAycKlLsLkE7Ake2TSyFzzvJ9+stoc4GVIgcFPBHw9lu9x5EMfyUgTYLWX1nitlDliY76nMakcO1+eCVVunMx/I0IeBzQbIQZS/8vkaNrMxdtEJ41naGlLxgj1urwUQVqSUuaP1fYaBfJnrlnZgsf65uNp7hm6bgRY9hkPQY/2RGH+zF4RELvePNvFrUe7nHWaO25AD5Ahxv3oP9dtWCWC25sXQqUPlDTaOq163QSwNLrzrZe4niI96kSmbYd2cbT63p6gSi6PwyAACIOPH+jsAUXVQ637OhcYa4NxgRA==',1,1,'',1,1),(495,'2021-04-27 18:22:49','2021-04-27','0000495',1,2,1,'16195657491363031671','',1,'AAURAZO',NULL,NULL,2,'B001-0000472',0,18,'2021-04-27',1,0,0,1,'MVsiRm0wVnhxgTUyLC52ZANEGWg=',1,'TNEuk6L+pgbQCl+q3Zb2N9yczLuBt+1hGXjISCNOiWnHltXhOMID9nqbk6jbf7r9SRlG1VY3XxlQItOwWqnq7yB0ZaCrzQYX2GZEJH5Tnbpy/6KNwLCIe/9L6G5izJ1XyJGd05WYK+iPVlWpN/vbhk0lEbboh+FfoRLQGaBM8LhNyAJ0hlhYJijbHpAPPVPkG79tGWlwVE3LnkFqh2s9DmBiCPufsTTsbhHqs6aR7bR48D+T8WdxWa3+5Jbfzx2JqjoGTLu0hQuk0kL0263SEL9IT5imwDB9Ds8OVYaK9YTHqCMY4tEAUnnnXUPa6jkEVlYdzpfzfp/GlibffAN10A==',1,1,'',1,1),(496,'2021-04-27 18:23:16','2021-04-27','0000496',1,2,1,'1619565773112011727','',1,'AAURAZO',NULL,NULL,2,'B001-0000473',0,18,'2021-04-27',1,0,0,1,'z6aYoCAFgicihScQN1tLJ8fGQ8Q=',1,'Dpt4KwsDrtiKiVqadiLZtC6fuKH6RULjepyAOWeswTn8ze36fYpyxHXKIFr1Zll9crGh1AQR4YVQ0Ehy+LkE2DC+zO25tdMV6LMrw0pNuCmtaivKPwgBzw5Fsv1lZz8eqDve3nwWQ8rVSwOo2gm5Pvj06XHlU7vLvmliyqGyHb5ATN/JFRhDeENn2YSBCkWZbQsOua9n01sc2QVaqanyAn5FtYb+2Usa3E5pYxa9eP9T9NeROXnIlzr+uP9ywFM8MecuTqWJOxYGt8NfrqlyqzHtReanWJRAXJpFroOYur6mo6UB59YVP+9QJFB/fdYsdNnTk4NoWnPsX/rBDu2BUg==',1,1,'',1,1),(497,'2021-04-27 18:23:35','2021-04-27','0000497',1,2,1,'16195657981192754912','',1,'AAURAZO',NULL,NULL,2,'B001-0000474',0,18,'2021-04-27',1,0,0,1,'75m3Daz/+zgINo+0RBXARE7GtNI=',1,'PBx9fI86xuHBUddsAXRNPCaz2p/EmWsdMz/sM1M0tgpR1W4DgNW1n7CYXPgitmm4ccUHH/jDKPWumYjp1goSEzGEtMR/N6M2exOKZJh6nJ9PD+s6mMkFSsQ71mfizKZagQxECvvDMxJWTk8c605Tv7Mz1p9QdgPpL73RVR9TffW867C1mb9L3sOKwRf9phtJXkI7yxL2cPus6vFpvBhcYqXGj7/eoHkOhRXErE3BAogkXCbOwNwac5jVN/QlUCsf4y6RRJNhHhhZEFfZpxKP63+qu9tmjxtIg0V2sZQIecZ6PPC36PKPCHAO7GtnX9sxiMw1eKtwKGteurSsKiM6eQ==',1,1,'',1,1),(498,'2021-04-27 18:24:05','2021-04-27','0000498',1,2,1,'1619565817299673325','',1,'AAURAZO',NULL,NULL,2,'B001-0000475',0,18,'2021-04-27',1,0,0,1,'ILx6ZK1kKuv7C0ltHWm0E+HaAMk=',1,'IVx5rS6XD95IEM+f9LDJEQlCUJ2WWf1rdcLxIcD3pw8c+U/q+5dsGK3dTQ4IjbDKSgwY9RTDFKMz2OeySxILo4TdeJyP01r/wH06DlC52Q7y+TqWvtqIMZph5m8G7u7Vc0DJ+U5qBCzpxWuqkbINwJzhN5YZmCa6vS+K1pxPqAUD0KEeq+72tmuCcfHn1AXi5skFvUcnlSwPSTnPZ48S9qKU2uiIAJ+rBBT5psr9JLbukHN27eiIovEtoD33ES+5kvMoWtrh9+Lk92l+rcdiKwRSH47xlurDAL1Rx/AduO0e61AFFLr0NFsGoPEa/I85kgexrHQxVFVsIqiBo8Jc4Q==',1,1,'',1,1),(499,'2021-04-27 18:24:28','2021-04-27','0000499',1,2,1,'1619565847468357907','',1,'AAURAZO',NULL,NULL,2,'B001-0000476',0,18,'2021-04-27',1,0,0,1,'JUn5/ozG+LmPP34q22V4H5pu3ds=',1,'DQZgLVSVF5xq4n3ycKWK5aEiR9KpBO510xSz5jt6HU9zGuWIsCU50iriQzcFwOd1FuF9cKCMxcqM1kn8lSwYuoYYHyRBJyEgceTm7GcJ74yqsqerov+9tyabj2xzisr1o8e6+v7G3pJ4f+MfsW/2i7KD2LOD4GftQBTiIxNYs0sOszUweHJboKXE5vWuNBUDSt2aPgqEx7Pc3ALJEBWOoVLtdl847vbjp4rxLg9peI/1REtFNP4wFgiRr/IsK50u/6x9oKetz+5x4B/UohaWN5Umtc9h834wFLyBy4P6YRi+7PGgBnhfEtxEhtdVQbvUQ0NdBelGIJnJA75sSSUWCA==',1,1,'',1,1),(500,'2021-04-27 18:25:07','2021-04-27','0000500',1,2,1,'161956587486106595','',1,'AAURAZO',NULL,NULL,2,'B001-0000477',0,18,'2021-04-27',1,0,0,1,'qkQPwK33Y9g/HzLRcm4NCdZGd3I=',1,'BECO7R6kqcCCQquVGyDMKsxGdltt7GAPcHd22xXfS1gxCg0ziPcN0oduJjg4tdesLSa6WpuO5xYgQIq+80dhpoRYdWslad/DzfV/9d4s7S2Z53xppkC8YO6xMDVqHrbm4N3Rgi3nsdywfhh+zdBeIBRsLTAsWIXefTINm6sTju/1u7j3eJV3S/FtSM119sL1e0sdglHXg4PSMqQgm+91/nRXL13VFfzImnhfmsmv7UPpAQPDM1UnULfdM56ETp62FrUKwCLKnJUg+1FWlc+rWbYt/ZVJgfIZWusKfUNIbotamFtsAXbpbyc5cJMQAxW6bjTR6xQAy/qJ04rt3jfvWw==',1,1,'',1,1),(501,'2021-04-27 18:25:42','2021-04-27','0000501',1,2,1,'1619565910469734924','',1,'AAURAZO',NULL,NULL,2,'B001-0000478',0,18,'2021-04-27',1,0,0,1,'0LJNkL+npGHxPzuh5E1W0qExSJU=',1,'Cst7eiyF/vz0fs2DMbjxJiBye+Rke+UQKo5RpWYbfl2IB76myKqXyjIfxUEvDjpc0Hz0lOH6p9tS77riZXXuadmLpCx5uFNZKdnesRAFAL4NLvIExQ01C3IRcsySf7eqhIYJ+PEHk+/ZvmkjHeJkxFha9lapS7P9/i36r1gm3k+rxKhkGadrmvbxYSf7RxdlsCQkUfZMaM6GMXqaJtVQjq5IVSTnlx42sHoD/co9R1QbkynRo/ciLbt3PuWlUkAzc5GSkJwDQIrUu1zua+nMuNOMcNTA6nLE5/uCKa0RkXbC56H+J4b5gkIx08IsGfc/jzYGeUWNxDWSeP9DUosqqg==',1,1,'',1,1),(502,'2021-04-27 18:25:58','2021-04-27','0000502',1,2,1,'161956594575133491','',1,'AAURAZO',NULL,NULL,2,'B001-0000479',0,18,'2021-04-27',1,0,0,1,'EC+2W+aaw3VGHZeIxyD/sQR+3Mk=',1,'ZliejjAAJEZ7MOXVto80ZE4XcC0hom9S6BMQNV62fxpD6oGeySJThMOZ3c5l+/rR24QY/tyLmHW+CrOfpHdoQn+WwgEALHnM60Xb7fsB8JbPx8Ir5su3BiV4hYAF2thZtny5tmhWn5lfOkMsccSWSJqiSQdvbJ+bV0edA6HoYpAiKw9l1BgfCzJmIgn8TQFvYMqJv3O7uzRujcAb/tfkPBTJE/BK2f0BkcsN5EA2JZPzAHHBbFkuvDw0tzhcJfJog3L4CxoEj1dpY4EvUKFB8h0DhLQhoZ2SSvNZH4lLuz1zyo1x/w/xKOEfw5lEY1oJdnFlxoeSU4K/nEE16e7Jkg==',1,1,'',1,1),(503,'2021-04-27 18:26:37','2021-04-27','0000503',1,2,1,'1619565961554636629','',1,'AAURAZO',NULL,NULL,2,'B001-0000480',0,18,'2021-04-27',1,0,0,1,'afUaMjZYlFcYxod1FIV9FDQFQTk=',1,'PoP5Dq1q1lbp0h7f97/Nr8HN5grZRC3g/H3WTb+bwlZ/Ptu+oebjnT6pMgqKUTL87PicZ32y4NhMROcvtC7bn3t0v2Z6W2DfQ3gu5lUVQFtG+YNj2Hsalt9bV/iD8Jqonb06g08f/jLXRDdR5Oaghv48hYX5GP6cqOWE7KxkcndXuURPfBGyCVPpBLsUKu0IxSqXpvMTk/Wa1IDeoPrq218QTmKP1UVmEcMLEqn917ylIODAKD38cNDJpnU6JZ3H8PuebJZwNJqziz/xC2v+zl6W+eD2E2eUJsF799m7UwqS0fetqi7/mdY6BPFKgFbKIHsaFqqEfK+2rsbh9AFSCQ==',1,1,'',1,1),(504,'2021-04-27 18:27:15','2021-04-27','0000504',1,2,1,'1619566003317230292','',1,'AAURAZO',NULL,NULL,2,'B001-0000481',0,18,'2021-04-27',1,0,0,1,'wt4uCRJXcMcVffrkQSZyCx7uHHM=',1,'FNSRco7HFd2yRgTpDxte/cqCJ/w7IVjnb41fDhiJpbeP3+/OSjeNdFYZAhroLl4dqtV5usiCn2JzIVGr5CxKIAm+5E/hRtxZKnB7vJej1Lfn+UFrQKTBLaAX6QQm6NinC/TLYJx+xnnp0ysMQPSnv8kP3kBpulXmNWzKss6xiYUFIKYJJr4hBYvv52KikJdL3KFTwNu2atShl05LMVmJU4id7Xu37ZSVRaXlBPzfhrgcSpPZFLlhHdM9Pi4kVo66JoZ8hHBYJLg5ex3OZdm6gd08rgDeQEDiObp/zbASZj7bshrLsWjuPFf+b4dg4FJjFoT8YO1Bep3bDWyMkZ+uaQ==',1,1,'',1,1),(505,'2021-04-27 18:27:41','2021-04-27','0000505',1,2,1,'1619566038926517282','',1,'AAURAZO',NULL,NULL,2,'B001-0000482',0,18,'2021-04-27',1,0,0,1,'owinZu+lEY+8VHkzi0RFHz6KBzY=',1,'Z7Y1ZB2upkfgxSgNpNnLXMos5Ut5KS8zg7Tgud3x0WGhTV36WOL3u9CcY2kmcGQilxD7UqV7a+ATypBDWb8GCOcw8JOE98OGsvXv/780jbfBUlES6DO4hn9cGUOua9/xRl9sU7iy+0ZWoJy94w638iegdDuW3XGsJAGlJTW9UIk5l9qfuaXfVgahuvMndycpMFKPXkeJQy2Q8w+ojkCTaSmIcehfMhyVLBLa4gThODqG75a/FxdMva3kg1kd/aI9BE9fZiIsgOiRKaAxfWiYcmtjUFJA02EwkgGiCFz95MaCNAyLRGpQKqJt/vE9pMRNW6FGdnIMWkQkxMer7/iPXw==',1,1,'',1,1),(506,'2021-04-27 18:28:10','2021-04-27','0000506',1,2,1,'16195660681266425322','',1,'AAURAZO',NULL,NULL,2,'B001-0000483',0,18,'2021-04-27',1,0,0,1,'mRuHBCQ+g2Ebs7a+gCy162qiHYs=',1,'AIq3RVHdGSgVFwnd4Ji13jXzbYnsv3wh8ZbLrgA1mkMKup+okZEIIkKrSPOx2G+/8gfqeXI3bVj616CZG7FTPL0HTg6/yNHAlifKCalEFpPvSEDDIx05i9etxBh3lUB9KwXSZtLQo27oSPCbPZiVLHYcDMeYXwRqvEMi6f/e37hEjIZipI7wxqK4yZnvAEpnhtH8EYPURFz5ztbaRyas+FniZo4Jq9BgMRM+XqSNTOjucOINGgGfyTwJTxDMOrVGzyMzQdqchsZWvua/sxGYrooOwWarmpO/mfob9iRRWEmHo/a/X9EFo0tQvlLesL17gqeOqA9Lc7dmYQeLB7NvZg==',1,1,'',1,1),(507,'2021-04-27 18:28:39','2021-04-27','0000507',1,2,1,'1619566093252983842','',1,'AAURAZO',NULL,NULL,2,'B001-0000484',0,18,'2021-04-27',1,0,0,1,'R3DxXjoghU6GxzQ0EGQE5Soep00=',1,'YcNjJKMAlVGrrRqy688HfPrhq6qVaelVVhMjHyjJ1B7zEZOP2fd+ZjFcYx6TfpVcba9DKxRS3PsVpcpIC+OGqZ7mbucQvWsgFmOJfQGhQ22zANUEOFTicHWx8pa0ze90TvIuo4R3+UR3pjUH0o+sDZ102U2EDyWqCvEJGHzr99qt7+zb5BoxjAgNTF1tqxFzr196kA45Nuuj8aTzZgqFOyaWDk4hTbdObQr7SytKzbmHb6NPAYZPk3U6HqmJv+gqEiCkckcPVep+M6ck32lRzNVoSdlqCsnlTo1sOLnlWBJKvtszM1UjRtST3OsehR07TAn913bMwRg/AFVwNiaf0A==',1,1,'',1,1),(508,'2021-04-27 18:30:04','2021-04-27','0000508',1,2,1,'1619566175798755923','',1,'AAURAZO',NULL,NULL,2,'B001-0000485',0,18,'2021-04-27',1,0,0,1,'EsUWvrIFYJ0lFSQ8N2IdflC7UM4=',1,'MnqlvgN0Q0Fej0+H90PgaqZ913hWCQ3i5pztHe4YcLjpso9k79A5zGT5WFLvYEEKiOsSEgtxBL3eG6/sf+imL4AWg57rGD7WaZpeiGSSupCIAM4L3fSEDXrd6cyj+kfyAuh6cY/n4bgB+EDNuYEkYtw/YX+ZWim7RNLLKUpcPNjmAq3zGk3QiMWQTmeGSVwWdyz0Vg5BVsSp0ij7AEpp1TAAC4luW1mgIG1Hzl4/goQpUX/m2RgFpNNZKbrQLvUwk4XotTg5MaRaOcZOVnBQGO4RLjTUocOfpNQI2ckDQJ6EdeflcgQJ3Ip7xHoFkIy0zDXdoYEmM9pZRnNjNDZ9Pg==',1,1,'',1,1),(509,'2021-04-27 18:31:02','2021-04-27','0000509',1,2,1,'16195662421275332901','',1,'AAURAZO',NULL,NULL,2,'B001-0000486',0,18,'2021-04-27',1,0,0,1,'KpJbmPylpe02ol2Nl1+UBOHLVR0=',1,'ZhrZinVwnKSxx5J/sMKZsRjChx/Zs0/VsHxMWx++FS2u6NX4+oJ8Sw+y75IQccwcvUOiCF892X8tghdSLwyYO+aGoGlMU83Kym0jdnnILMm8ck8x9x9nCdY4v+otN0H9YZUeUm7ANtkt9AtRR9JldoVfZSDO2mPhbh2NTG69jdWya/fg0TrVK4dOC/uM4pb0yEJox+TDuYW/AdzR9j4YBwGDOSlkQyVG9j6eFS9gg09BxZrmB0qhr9Nj662zP1vBiQWxDY5hydQwW1jVcDGkCaelw4cxh6gE37dLWcQhgAw0kRH5xuUUXtVzDm37ew7uz/sAwQ5KTKgpjJ6GYX9RLg==',1,1,'',1,1),(510,'2021-04-27 18:31:34','2021-04-27','0000510',1,2,1,'1619566265508463527','',1,'AAURAZO',NULL,NULL,2,'B001-0000487',0,18,'2021-04-27',1,0,0,1,'oxd9KKKJcysKO63iKrSX5B8Tn90=',1,'ZreW6hV4NSJQnAIDy/tNHFevv3K2rjfhxncUAZ8SX30Pqw9MrWFw4xAtYrDsi5nH0dh+sG2YGPg5p0X5biKGY8Bbas8+gaARjbuyXszs2vZb7UGda7rbSMqdTXi9P6BeIkcTyHgUqrYG7W1p7vXh2M9GK2ZJSIw3G99ZdBabYdt39Bxo6fBCYarPbDu/LODXf+baO6TlQpQuUuK6zEoQLkEXLFI1xxCwdTiPLhPI9h9dKVdBRIPZ43EVrbuVOjZJbkN1sCEZGhoQSLdy1uZnY6CkoQbpgYKyGTofzpu56eFHgCSPRO8Mg4S0pDbTgZOC1BR5ryOEdVHnq2L6ToBKOg==',1,1,'',1,1),(511,'2021-04-27 18:32:07','2021-04-27','0000511',1,2,1,'161956629679910018','',1,'AAURAZO',NULL,NULL,2,'B001-0000488',0,18,'2021-04-27',1,0,0,1,'Soodag+FHxUDITbZiW+w4CrCOgY=',1,'W5rrm0hhj92gGWcByy1qc28V81lGNvRIZ1WfErj5CX8v5onBwn2lcZgSN9y7UoyIOXQgmtul0wugKVN5i0xX09fkf1/MfxLhyfgOSFS9xp/muqAXa0jhgus40GAZAEUsNi0TxtKkJR2Z30/D7Idc28nPZpB2j26GdCJFRgnitoFkjcsxlUXE0hXT292uGAVQMJyMqfBEkb79muT9N/0H8IvXA2RRm68kQ4rJ/3CfZPVCvebRDFz8S2Gy0TpNNW+OMNv1/2yOGUO9g89oL477yEOzBGuvp4HYDYIIvY+njG0llkHuf7ROdFZ1p3OJ8KyYKIfwEjwI67jp5mFgeAejNw==',1,1,'',1,1),(512,'2021-04-27 18:32:34','2021-04-27','0000512',1,2,1,'161956633553187282','',1,'AAURAZO',NULL,NULL,2,'B001-0000489',0,18,'2021-04-27',1,0,0,1,'qk6uuR4oEzrsmaA2PHQT0sayom4=',1,'hxseFBp0FQ0gWXKGk8PE7/NYy+XP/d68f/d2Mro7Sq5Tjt1bpEdoHlLloLBSMISBYq3uiCVdmjcLw9ZHk7Aa3TDdRaJwWtw3zPap/mtFuWBaOaCmkV9DrmhxAXpZUNX5R+e9qKi+X2fci5FyHH6khbTGwLOa6XNN7nOfMy9+clUTWJdZ25SCFNa5C3+btHEHYFYuJIDuqnXXs31+4GiAz3qJD7fQIpH9ExQimn4Zz3N/UZcGkZoEYdSebY3LV2hEH/l+A8C6mwq549g/RsAUUoT1ysB8+ovSG6Nh0vyN1Squ8d3FkVU7PSB8S8IP2fs2bgE8GC2l970KAinETbDK0g==',1,1,'',1,1),(513,'2021-04-27 18:33:01','2021-04-27','0000513',1,2,1,'1619566357990505541','',1,'AAURAZO',NULL,NULL,2,'B001-0000490',0,18,'2021-04-27',1,0,0,1,'6TS9KdG4iYEtUL0BRay0f1+CYWU=',1,'Wnhp+SehxDOZSbvlEjf6hQ7IbVUgQWSiNVNGGX0bJGCWuBK702/jzYWotoEflEQ5el7aAFhut80mVy8Bw9bf+2vZpL1x0BdDFpX6g0gXNOpNLiVK8gm6EIr49pDtQTAg6sWkWenlh3fN5R/itFFtePoMqZSaHx5LaWhVvwbVubPgVPaRi4cwdJgsEQL9T3ztZxqPc2He/i6hSz5P2+s/LA0R77KJ+6Nu43jB0YRyg+NEd8uzLFL+Hjef4psx9zNAsvs2FfI+cqeGqrrfpRL3/f1WeHGnZqI5XyZrFrr/5/nzZZzjMslHy6VwQO78U0zTd395NdoTfMBaw+LLihhX7g==',1,1,'',1,1),(514,'2021-04-27 18:33:22','2021-04-27','0000514',1,2,1,'1619566383973938305','',1,'AAURAZO',NULL,NULL,2,'B001-0000491',0,18,'2021-04-27',1,0,0,1,'Jj6KzRPoaOSbyzFp9kPIIOwAqic=',1,'DHVBURUgiJ/qkYlHpC8+qdPK4rgsk7QhozXSUBQKI3X87pYvMqYdWXm5JktxlpENDVp+h08eFDVbC1t1Qi3SB296RPpAXj0Ulo2cpp8uFZxwwNR7qbXYdc2hO0jXuG2TmlOSJadtUNqMyj0EJ3sJQSl9wamCbRsZd8ZVqZEXrtN2kdwRpUAzjDfCsBjO6rEnmvqt6/WOrdLWOV/X1wsDGhIBj83kCMXWuBdtU9m4Veur9T8p49mept0fDbnyFQgOniQHcLyalchyRb873tuHC2Z25pfi+se6I1Ipcw3NROayFYfY6fF0X44wQV8lBINEaaB/9Innk0t+C/BMfYzOvw==',1,1,'',1,1),(515,'2021-04-29 13:35:07','2021-04-29','0000515',1,2,1,'161972129256113443','',1,'AAURAZO',NULL,NULL,2,'B001-0000492',0,18,'2021-04-29',1,0,0,1,'MBczDU9U9DmrT6GETY4fJUVxlLc=',1,'WFCa6NDSrM/XgYw5zYlZGhcrsqW49LQLhzc4pWCjVybhB16UPbKf4HpNmQXO2RQ6gutF9C6q56aH\n9hv7Ya4sWAfQ/GcQJ27KpjZyzkij/o5EQYLBCIA2fRZytv/fic6j/FietJkHiifPwfcKbC9gbpYh\nLrMAZZCt6c5+vuZODDX9L+uLVSUrjboYPmaKoRQmEVuhY5b1qDqLMzfajJxz6BJ+rV2IjV+ruC9M\naxh2Hn6XJr5WvQgxLoN5Rhw7Gw3sst3RqApNrkK0OFV0+cnP6PAU4OtCGe2NRKumsCxHn8BxXIvN\nSVlxmxApSixY0mGQkc4qcU5YP+UBrRqeYBSscQ==',1,1,'',1,1),(516,'2021-04-29 13:35:38','2021-04-29','0000516',1,2,1,'1619721310400625884','',1,'AAURAZO',NULL,NULL,2,'B001-0000493',0,18,'2021-04-29',1,0,0,1,'geURkHC7XP7vZsmI4JfmKr32Mhk=',1,'IT8PYawyXjzHTMKQDf/atvsamcK9G+9idjwMGDjqG5AXmt5dKXAJcAeuuPVDtbBLh0k4erVxynG1\nY5NuakmDAGkeyNP9/a+VaEJjyOrBu0IijDDoUnaOI+z+Ez0LWQcjrSFGOqfBaMk4xjVxG2C5pNMe\n8HKjNomh+K0kugZTvIjuGqJSdIBjR0DyqLWk0BDLZ9iLykD5yZLXQE4wX1dwfEW/W+0SB6IBjMF8\nKt647x7YODWyfDp64vlcglVw6vY13EvC1Y3KABjkJn2Qmlu9LT0mqNPIjwqVojem2bnaOertcf0I\nTqegDLti7R3uJfbBD/2eUb2qV8hQ/lZ8ndhzLw==',1,1,'',1,1),(517,'2021-04-29 13:36:07','2021-04-29','0000517',1,2,1,'16197213411127303573','',1,'AAURAZO',NULL,NULL,2,'B001-0000494',0,18,'2021-04-29',1,0,0,1,'2kp8Ef+qnteKKjEE/LDuMrHPpBA=',1,'AqRQ1gSVo61ReehvI3yQ+Kc2yAWbdyL+C3zn9M94jNv24SW3QRfdTGXRxpRnBEUXgRqk/5n9e/GE\nrrs8mzcC0+k+dVZ+60QFVRulVrjLFdCZ8YL1TPOitHyfH1nkpv7GnNrh7+jePV0TIGKuDedbrDnm\nW0zg942A7R/nrLVz6lK9cN5Lh1gHnTNc2jh4zyQj5Vg+3k+wJLvbsB6y8DpaMPglKbslHrWtN2dc\n/NTCpfzqBXG3UlcFG6ytWwZzSRFLxBUEOmRJHlPXvW3JqE1/ZsCHhOax2ZD+vpXLR4FoVXkPdUpi\nuICGNsAuagXhgtkyedKoz09uUxTyyQqvWx3bgQ==',1,1,'',1,1),(518,'2021-04-29 13:37:05','2021-04-29','0000518',1,2,1,'1619721398518231742','',1,'AAURAZO',NULL,NULL,2,'B001-0000495',0,18,'2021-04-29',1,0,0,1,'3HewI31ZD+U2yPhLtPjxHtY7IVM=',1,'gX3MGrxZVZfyR2rUEx1d0mvhZslZbz+PiEIRnEYg2aT/KW9DptOrY3fZSDsYSrpRXCkkYZ2iFR8bDt9/CGl0vPr4HV0qoA8ceRFTuh4Asf4dG8MPMHpR0U4MAj9Am/gaQ9ea6ZfiF1XN9WniYHSx7VB9DotoJHLiJc47HCbCflk/+OxuVBba+mQQbxcCRbpGDH8uhr1axq1gcKC1YfwjehftrJSyZMqkNNPr3gHY0z5Qsn/ZEgKZEPNf08xKsDlmUKROcf7Qgu5gM8+t5/31Scyck49UEPAydid/fAGRj2cbwhzCuyxgGXOrgHmMeSOoFLulVawjBmFXiA8iqP3g/g==',1,1,'',1,1),(519,'2021-04-29 13:37:37','2021-04-29','0000519',1,2,1,'16197214281395176411','',1,'AAURAZO',NULL,NULL,2,'B001-0000496',0,18,'2021-04-29',1,0,0,1,'iotKJokcA+DErsw/n4G8FPO6iyY=',1,'WiP0hyCELuEf6fgzr/IuSemApajcu2x1320hQhIvM/NGP6QXvArLC62fIyhX8RNoaGLWVG/EZ0e4XTa26QUD2XrJq4TQmkCuVTnvmgbcFB0jbOVMi5qpjiDMiCabMMThKrvaP7kqTOi1C/VtiWvycqdyR9x9PaXs677brRO/UMnN9Y8a0iQgInb6HJg1GPe+Gw36leSE2rYUWBwAGLKESS+TD13su5SkPh9vNZDlT7XsVZyRqvoDLYkJGgx+fuLPIGEft96gPao1byeqK3qezieQ6M+Vwx63YjQ+85puXRrpzdQe8QDBRbJDn/rzwMwzW++IpCbMZ5GJyL+7C9wL8w==',1,1,'',1,1),(520,'2021-04-29 13:38:03','2021-04-29','0000520',1,2,1,'1619721460538714870','',1,'AAURAZO',NULL,NULL,2,'B001-0000497',0,18,'2021-04-29',1,0,0,1,'q2M195RGWfZ5eImaG8oJljM6TwU=',1,'AXO6wKRCzgzJTcACPmSDZwhlJe6YpBOXeUqRBj6KyaEec00uds/0ddq5TcEHIlIKhbWdd6QvQ+XkV6cLOOCQDCIDHEXB3doqW/gUydf7M7YlfmWDZ8MNqQAPxRXwUx3g4E5g7AUIfALBUnbTsngXqmskE19Wefz3gJynk18vEdtQItEpjsVcYmETUIHw0YVibRR6p7sC3NxWqEevMmg3A16L9dzy/La4a+WpKAMo3VNdDcPzGnU8iTMD0s8zRz4C2m/Xahx8wK5EbYXmzaAOldJJFPiQrGf7QPDuahqhcRIsYil2eBcOpjGPXAPyR8Y5QJ3TqmyJ9P5kApkMCrOKSg==',1,1,'',1,1),(521,'2021-04-29 13:39:02','2021-04-29','0000521',1,2,1,'1619721511999886469','',1,'AAURAZO',NULL,NULL,2,'B001-0000498',0,18,'2021-04-29',1,0,0,1,'7zmEqcbVVAWSdEZdx56tHIHrfdE=',1,'Lm+uvqyrBgs+1/df/xYKA53b5lFZBrKNzxxamMKWWPy2mxAPcSNa3966HYKnx7g/yqUQRH+tEWVcywlFiahKQOQo+uiRJ3s22Z8XVl58AhUu6Si7Cbbdgsp3Mm80je7qH1Y09OetfZuuvJXJOMI9K/Ys+BzaU/2Zc3i+tT4wpbc3fdgnmJbWAYz6F+XuKfqEeUae64Sdj5jcQui6X/nmPUkufS5oDqCiBD1gm4SuBYUM6Cb8cCgyVy94QCbQqg+aaYW4N5kxgEy6RNX2JOe73WFT2e4HmPC1DyYYvTS6kUesyX3XiXLZZR00SGLawo3AIyoB85Q4SXPHlm6WO4Yusg==',1,1,'',1,1),(522,'2021-04-29 13:39:40','2021-04-29','0000522',1,2,1,'1619721547754045903','',1,'AAURAZO',NULL,NULL,2,'B001-0000499',0,18,'2021-04-29',1,0,0,1,'Kse5uTKat+btJFjKBx8zx8NGzzQ=',1,'EeUkVuI1uSjRbwDHcEZfEla4n2uBlrYUo6bItIrO8Gj77owTXuXeTaWC6ZViwfiACPRQA75OUT4bUGFKMAG1YY9faY4U8M4ivakFkPZr8yrHNpm2mAurbtDS2kUyfhMxXLwKwSzgeOrEl20FB6hyOc1TWwpGsH4e0kNl6KQmEZygQNa1XpHWQ/BKVu2zRxUxVqIuxzmEnGBQYjFD2o6/rLfmGYaF92om89497Ycf2X7bw80b0o3t2TbPTup7lfrhydS5xykaEXKwgLhe2Ii45jmHmp1QfroqURx68Zucx6Eq70MI/fxycr5zrdqMG0oVRPfRrINwT5EnYXuDacs5pw==',1,1,'',1,1),(523,'2021-04-29 13:40:27','2021-04-29','0000523',1,2,1,'16197215821283508939','',1,'AAURAZO',NULL,NULL,2,'B001-0000500',0,18,'2021-04-29',1,0,0,1,'/Yau3nWe+w7wp1eQz6raBJ/6sdU=',1,'bshmcO9ndWZA+1dxCa8Cn64XvlM0GssFndqHJV3c5FREn0vj5IpjPVCefD5uIeajuQ5VSsYbyHzph/lE8WHnrl0V7M7IF9vWu/OmF5nCUo081/Lf09Ok9VD62qAfEOr2AGvYpqdcLt0vb3mExOpd7g9BzDs9soyNIgMe7oeQDdlQWBk66/rodNUNgum+q/krlEXhSnYwt/LnoaGTginerPgyvv0xprq264MvPA7nbCXWSjCF7UOcH9h+cxFHr3pfUorKRHiGFSLJTh3rWW3ZEMDoDmeBfcwNf3hDyMjMnZ/9xHsgmyDA6U1JgvmWdbjSderFKB8qDN4WUTQQGyJ6gg==',1,1,'',1,1),(524,'2021-04-29 13:41:06','2021-04-29','0000524',1,2,1,'1619721630666390164','',1,'AAURAZO',NULL,NULL,2,'B001-0000501',0,18,'2021-04-29',1,0,0,1,'0OH6PSQr6gSm2utuJu2PD8WeNaA=',1,'MY565ncXHMagitbXq2ZaQxnO/0URZuGTdInuy2uzkNYYCf9jR61tdCs2dk+WvQlqxOIQcYxZVGjjsr1gNs29IxChx4Jr08i9/gU6Sr+4UsnCz6sHOH/x8YbQj1/PLQZ9Vn+4wfvRauBXmibV3PXilJm4ENyWHkjW9/+2B9gXTYqsPM1eC7Cvy3/VEakLK6OIWcOKbKgPB09a2xVl1Jk0fDPpV0XTqV6eiBdh9JNnoJYlYODpFO0uhPkySDaiizdr0lvtpeuFPLpfGftxnaam1gtXEaY1Im9/303vdLIKMaIule1Tf3+U0IZtFHqxcp+N7hsq6GMseZH2eekE18XItA==',1,1,'',1,1),(525,'2021-04-29 13:41:52','2021-04-29','0000525',1,2,1,'16197216751048598445','',1,'AAURAZO',NULL,NULL,2,'B001-0000502',0,18,'2021-04-29',1,0,0,1,'Y2UMvfxn8Cd9zJD8My/Xn9LGjb4=',1,'B186jpDv/JDgcv+5YbXOv+ovmaKcGK8kWjK95D2osyJmKwjwfsmTErpt2lZ0B/HLbOL4sc7WM2QpyAcKDMGArCym8CfCSFO2EEildLYVNg8tAEGLV0C89Ctn3kHRQyKm8aJPh2jVQaTxM+ALOonKxq9bPFs4Rx8KvPnmIoOpW8fWtioSgRiJHVvs+uy4kUecxaDBujwW6Sa01+vgq0uRK0u9xXSussmtyAjwIugGIZYH1vISngLDqV1YATJOZpQjW+mzb1oViM4wzQFmTWzZMuxB/yN1/+/IQIgkDMm74B64Jj0VDp9rFwI+YFLtYBudUkQFomnR9qEoKbK3XAyznw==',1,1,'',1,1),(526,'2021-04-29 13:42:16','2021-04-29','0000526',1,2,1,'1619721714581746651','',1,'AAURAZO',NULL,NULL,2,'B001-0000503',0,18,'2021-04-29',1,0,0,1,'o0jK4er3Q1YMOjshOrjlDCZU/CI=',1,'EZwKraIK1BqHdJwknSqS3taunizXgLBfZphBjiihRMUa1qdidDQAQkoqEz2J0QNgeyG7qZw2ZVI3DiWoC99TH351ltEKFoc4zPjllXrfRHW9OZvKViUgrlxBmyHTYagOVkdDV+4+Vlg9qiGrADpag8CDjjD9U+fOcY+uAyMaeHpkOmQrezxiRgnR6CCJTQx+7b/12/3bA4xA7VWrUR1PtEoqpbcVhZVD5rv4HzLIi2qmbXZGq/OcjIjPqDe+bpCza/Dfl4RQgzxztglqqowkRdLcVnM7mqgYlfa0Dv70oAsEAQrKeCaaYwLwtulY/mzTJv52ER6jXoFWeO9oEDU2KQ==',1,1,'',1,1),(527,'2021-04-29 13:43:06','2021-04-29','0000527',1,2,1,'16197217401288414562','',1,'AAURAZO',NULL,NULL,2,'B001-0000504',0,18,'2021-04-29',1,0,0,1,'IJCaJas8dpLAPO24r3v0NDUN//c=',1,'SwEWeHs303a/0KhIYYYid92Bi/ErlNCqWbKuDCKhkGZuv6JIe7ykk/G1htvgA3ujyouJPNDquB16u4TZ3dUtod1Y4Z1dFL3KycPtNx7S5/0Ekiw3CjKEUF/rmy+cojTwJFgbV92lGuavpfo9FXI2yLtj2uZbVzTZ/8J+YVtcoCFq9uszQFHkRaOsQWrQ1ajb0Ix7GElh85M+96zzdXsWfxg7EaYYG2YH7L+k3fyOSmMGq1WBxdGPvk14FskahHtu+buvHByWDErYa1lWMcmvf2w+HhK/RS31ERPvz0FGGrDoH+xHjmS0OHIK362iFYz+xA+OuxKHPurCH+bz2RM+aA==',1,1,'',1,1),(528,'2021-04-29 13:44:01','2021-04-29','0000528',1,2,1,'16197217891070888908','',1,'AAURAZO',NULL,NULL,2,'B001-0000505',0,18,'2021-04-29',1,0,0,1,'QFKc3NfPn6GHZT/WPEf5PAtE/JA=',1,'ILCkLjEaIlnZBwbFcmetTCLAE4okjKT0x5lwZQGk0IjpNe8HBXlpxqiJuw0C09S2dqKt0eQi0uFU6wHc42fxuXFzXjjGzWOpjXgniShm29UieQbJRViYMGTDIhMEPP2MeSJdzBzsCNyadjITNFsBBOZxWx12pxPv2W/ihAu8GPp5MFr6PcHUu7aZTSEoncCZfV/7KIHCWzX4krVqvBbtUAvB8HdSVQpSl1I1hBOlpegkGh/W+6HwMBw6IrTiyHetGYjJ0bSljhc+IDLDbI5CvhftfSk/5syCHAV1ZXOutn1AmbJ/5nstNSs8IbHJUZh374Chnf45CcXRADs0SLe+Og==',1,1,'',1,1),(529,'2021-04-29 13:45:07','2021-04-29','0000529',1,2,1,'1619721861121736910','',1,'AAURAZO',NULL,NULL,2,'B001-0000506',0,18,'2021-04-29',1,0,0,1,'WElexsE1NHwztBJyDEceTB6ZhXQ=',1,'THsf/+zVJD+Zbr1yoThppGWpU9IU31xSZ4zj2AvgWfJr99SIGpPRJNlof2T1ptNBb3LrxnxGsqAKHd26TmEqyh0Lrg9pAmK4kcHl7fqkEQ4RCQBELlvZvjsXhMyiYwhGUnRz8TStb52eTHcUGOsnMTK5xFlGmaA3PauKLxWT3xA8U48WhftYjDetXuefwBpGt/CoyuZmQT9vkDerV0/XArEkYDb7kV0SEy4dCKajCDp28Q+uUzrdAnGlG9YHcXaLVaVkDQt7vPmyIgof4+HHMYQ/KIYjtr1FqjuwKyTUO6ZN1fb6l84+IO8pUIOBLus7KkFil6tnfnRGB4iEiHpVHA==',1,1,'',1,1),(530,'2021-04-30 18:33:42','2021-04-30','0000530',1,2,1,'1619825597562468413','',1,'AAURAZO',NULL,NULL,2,'B001-0000507',0,18,'2021-04-30',1,0,0,1,'I/z91Z5ZmQ9+95QI33hzfc6PiHk=',1,'EfQD8AW6GJfZ2ehuJ43/DSYro0jvg74Qxm1xYATJnb9ieGdy3nRM4tMFRv50yxSiGuOAX5gCL/ow\nSPwz3tZOtd/32KXqBcDj+JbT97KiJUSNUpsVA0G2oLr/ZB1Vi3uR04PtGZdj6P5Ip4Uu1M0snKHk\nni/6Q4EZIHn/JUXZJZ5ujVla4L1Vh2w+MO9S5GiGE2zEagR3CPfS/qPP38J6ahakU2iTpZHrXTZX\nN+qmRjWMpdizUp/W5i0A4rKuVs8Yh+8gID6GvubHm1ZLf3/nWPgWiLJ/MORkazZhil0swYH4pWU2\nRGid6uxzihkXgJ6WAMum6Ic37OFz7haMmgFS8g==',1,1,'',1,1),(531,'2021-04-30 18:34:49','2021-04-30','0000531',1,2,1,'16198256701246673734','',1,'AAURAZO',NULL,NULL,2,'B001-0000508',0,18,'2021-04-30',1,0,0,1,'1hQijGH4OQ9WXcCPP+nBsaL6VJE=',1,'Dhmve2inKYONrtjKQRd3D59WHqLrcHGIrL/38UMMK5OpceQhOetQIcgkn3lK8M9OfhalVqV1FgtN7W9NOuEP79wGgyseSffhtGEm1h4475WtCY1JZtlZ27lEokLJJjA5qZ3h7pi+wvHSEZ9rWWeJY0SNZwPJWaGtJ1bHg61PHn2X430fGPeDkK6V61VRIuuLN3jskV8jbTUeP+G9Lp2tlzYuk3fBJP8IXBm6nRdn5KgA9XgcACNZSghiQTU/oQVmZKCKqRyjY7jbVD6v+epkRJ303RR2LsDbdGzIDDdpcXychEDwFVnLpJpJH45UnY+umRr3qo4CGCy2xtIA0XAY0A==',1,1,'',1,1),(532,'2021-04-30 18:35:20','2021-04-30','0000532',1,2,1,'16198256921283939257','',1,'AAURAZO',NULL,NULL,2,'B001-0000509',0,18,'2021-04-30',1,0,0,1,'Yg8tpSXKYRzdpNdbnrmH514yPbU=',1,'V88SpV0Ljr1RCcBEw19HtulNkb4MysRDROKwrACFZr6ejrCb8IUBsicWk1IKxLzIj7gkzUJ46LWeoBeUIFiVWS59rWG1sT7NfZ3xvHwjYTG7Xv3hd6kTqIyVdwdkpRz+GqyAZf7O+vVCbHXoOHyYj0rYeyBVzXs3aEOkEK9T6xk4leKjWuvmIATMRsSj1LY5doP1K2m/al7bqmIHHwntnZc7FAPXI6wkQkeFnkKHHkbSbt+/kCnTdNn+xs3NPxCUolpVYk7Uz/AvLf0Y16KgUXxqh7xVcVPp+zRCyMBuabtFeHLAE1xPbe+B8Vf3dnr1yUh25cab4PIbI97qoPyMRA==',1,1,'',1,1),(533,'2021-04-30 18:35:44','2021-04-30','0000533',1,2,1,'1619825722303632249','',1,'AAURAZO',NULL,NULL,2,'B001-0000510',0,18,'2021-04-30',1,0,0,1,'+U16tzbHRUtNpjJwhS0PAtVidns=',1,'RkFZyya05DcbKZye4zcFNATFU2DB76OsIXYTe/2aq+avUt8LSijOoIdOynyAlSB+9cwaqdUhnH3qHZUboWZ/g9JoZeSrf7KcF59xImULrqQpL/xBgCVkr1gZwuAkggLTfhbXZHOI0mDxnRTJpLBbd3EY93pzmCcizDnzSbXFHJkzlej5yV2cR32SW5jjdJxzng8f9iiyf1IPAOrW3yEcWniRJ5xZHZFgjPMSkA1m7DCAwWGgx9JeMqpQQnoe2bVolzsbrhziWh4QJq+yNPsc12mYJ8K7eiB/aUdXh00jnNY/yCQOtcE49gMLdF3FCnqjsX++NW+4xyfV5LJN4kdYww==',1,1,'',1,1),(534,'2021-04-30 18:36:04','2021-04-30','0000534',1,2,1,'16198257471109144161','',1,'AAURAZO',NULL,NULL,2,'B001-0000511',0,18,'2021-04-30',1,0,0,1,'qdDGQ4FCiiSGaHFtN/i6lOlntZI=',1,'cpfZBb8U6OTCqKDxH06AcpIpZKIdUr8zhPNyqozq5hwIvUhEb5rEeiWFlqWDeLqiVjPZm45kNlu4NcApzRpgZFrrV15b+8SExuqKFy1pZ9Zj4hPXpcNWug4/sSegkkpP1GQllJhMs51jzSCK8qoGvv9XDlD0FFIjt0Da1B11uQ7pXWUeNJdvp8XGgRCfHdCww9WHbTfDc9bRX3jhGVQCiczl/uu/moM0AWsiExZyiNsa/wzh8vkEoiUDGcQ27jQ+vC7fWGK92et9f4+2qXkqGnG7lnAWOqz47uHld0qby9CQ0hm/NxdIVHHy4mO9AEoYaSeL8J4/YU3zTVRYDTafTQ==',1,1,'',1,1),(535,'2021-04-30 18:36:33','2021-04-30','0000535',1,2,1,'16198257661009095270','',1,'AAURAZO',NULL,NULL,2,'B001-0000512',0,18,'2021-04-30',1,0,0,1,'XJw7auSbXi7bx2vRSYqT1wl0yBw=',1,'N+I35yQ9OOxj9hyqOQwTO0hj3VZRAdl13nuUheLTXvVCBFermE/Au+sHqX0rMH5Ia8b+K2iIw7stGeUApkIAeMFlDWtLK4saEJTPrp1BprGSiP9BqWUpLBic4sAeeOeLlb6GQW6FaXRII1AbjantLd25cmC1FHyBluy4GOPEunbq4ymUgcpHsAJPtV0Lf8LTtbgjXlzG0AHUMITnslpb//G+/3nqRs0ForQoNzk0iNBliBEku2dKfi6IAKIlG8U3pPFmM4I3fsiOzeEdsF8v8PmgNnx4LVj2sbWIGbkRyFMuSxn88y/sG16YW7L6reSRKtIUXqsgdSejCzkr5XrBgw==',1,1,'',1,1),(536,'2021-04-30 18:36:55','2021-04-30','0000536',1,2,1,'161982579541353542','',1,'AAURAZO',NULL,NULL,2,'B001-0000513',0,18,'2021-04-30',1,0,0,1,'cRe/aknjorj3dXgUSrULQlu0wV8=',1,'UCQkELgSV31Azuu4m31EuPohkiidJeJk7h1dpGlQs7byTRVtPXfNYgS0I8G7Vsy2jlf3fVEa4skwYSodWuuifQm+JDBK97rnasDSptvL+QesR8S+Oh32c3m0TEWkFhOrM/ep13xbNZfy2RfQ6apLOUwfpnQhiGdwvJ7XHrSGqJcduGrJ1cdBjGb0kdU8U6dK5sFvWCr25Xs6QpMjkONzJUbclAYNXYAyRqfai63HxDgVHRXIuRUXet0jig4wj1Zun5+kBtBm5qzEVK7KyPsZGwKs8eA9XcJRNF2tQgsDSP0XJILgdkOlm0Q0wDwS+RcDzhevevJ8m2aWevfS62n1mQ==',1,1,'',1,1),(537,'2021-04-30 18:37:15','2021-04-30','0000537',1,2,1,'1619825818697028793','',1,'AAURAZO',NULL,NULL,2,'B001-0000514',0,18,'2021-04-30',1,0,0,1,'fHcd0gAby/i90SSJSjb38d7iMSI=',1,'comrHJJqUl603+zZ98qLcvll5fNEEPgxINkJkka9C/Uxjko7oBjrTzbjlE9HA3ezHxly0W5xDA6DHLn7xNbpKrRuaSrf2uZYeF3ZKsL/FCQcPqk2QeNAw0/OGtUGRG//SZ7CDO8YUy0QlFKMqwph2u97gsRI4D7D/2FSZld4eBuGS8pr+hFznB3YiQuzgw0uJjXAU5QUMSd/UsC/a2PuJNspxFPCpnpMiRUXL+Dv19K7YrliYvfpM7O0m2d8/bWNhnhdZyXgJWb0b/v5HqKyn6NdR3HcXP8Cdj1pg2kef9PPutCuBUC5NJja6N/XfvC5c/C74NnnVQ2Rfn0FYEJRaw==',1,1,'',1,1),(538,'2021-04-30 18:37:36','2021-04-30','0000538',1,2,1,'1619825837124792166','',1,'AAURAZO',NULL,NULL,2,'B001-0000515',0,18,'2021-04-30',1,0,0,1,'A5yyKIXfskWETGZxBHxG9UjY96k=',1,'M9m8UfRO/6DNYH2WqxI5Vn3PZpByf9jJu7O42b0eDK8HcEy81VwxfKqrANYtU/SxIj8zfil8p9qSpRMBq3qxNIHiZ+JDsXq6hcPuwlUiVz8K1nfazXHBL9Owbv1OLoE4XEiWW7kHv5EGsI5NV/WxvDkX16A1AVfBDGCjhgXx1SMLyVjk+EtI9IEHAmgixyDePKLKPD7PyCWnnuejLwEjO6aOOckmnWOHa0jKnxgb7AX9if84ZxeyUNsQHy/csv63mawE/fSQD2vbJxdrQrU2YCUIB6Zcuv6vKBb4Jb2cLn9G/gssPFAZw6LhB3xiXcEH0l2IE3SwD6FNU/qzYioL2w==',1,1,'',1,1),(539,'2021-04-30 18:38:01','2021-04-30','0000539',1,2,1,'1619825858994335369','',1,'AAURAZO',NULL,NULL,2,'B001-0000516',0,18,'2021-04-30',1,0,0,1,'BYHPpAtZUKJ1UtQ30pW91TJBRGU=',1,'bZ1+t9O85feY42qDz9PqyVko7mPYqcxv2hPI/POeJF0VAR7yCxjAnJ6gL2E1+ksPwACLVk11Vv4U/X2y62S2gYXgSWxoYiQBofElz54MUuvpcVFG41HxKRA4y8hdErqfp0mkxzr87Znk/jKPZHpwP9h1373XRUxbA7d41bXHW0sALZw3pp7kaqZy6qkAvnYPpgCguZwKPQAQGXBdi7g0x7h7sF2S08yf4LLi0jJUTNXt7dAQ19WborKME79rCJ/RGkyEl6WrRNLdk+chOhOABQSy91lo3HKL31E+6GnVSaE710KWNyc+1P3OkEX4+hWdi/DAfBc4vk/pREKOwfGDhQ==',1,1,'',1,1),(540,'2021-04-30 18:38:20','2021-04-30','0000540',1,2,1,'1619825883498394091','',1,'AAURAZO',NULL,NULL,2,'B001-0000517',0,18,'2021-04-30',1,0,0,1,'jYbZVkxTgTWC15kb2MvGQjeyW6M=',1,'gXxgpYZwfdbSUk18jjjyKwHv5L/2R0TFvelQppaPDfW3LGMX2krR3jSHgmg3zt2i8SiJExt2piF6acRW/9JB+wzz3MUITE8M5gyemUxGUZTEOzZHXUNQI2PAknMY0THZYqDWBNWNNQr3mDM+vjKDCrc0nSJFtkt2FyiYnDDu+qgygVU3SObG/hG48gWzEkYGTzvOh3V7a+Xpvbzy2j2u/DYYvgdzun/lk009xwdhg2paKeTC16A7L/viWhhbabwd77L2+FUGHyAdS4iTixMIx9+f+dOh6Q2POeDou4BMZYPNOb7ofQBtrlDvqOoCmkiWjCE1TQ8+2VT1apXd6FkzIw==',1,1,'',1,1),(541,'2021-04-30 18:38:43','2021-04-30','0000541',1,2,1,'1619825903492498737','',1,'AAURAZO',NULL,NULL,2,'B001-0000518',0,18,'2021-04-30',1,0,0,1,'f+aXJj/CCG49AXtlIzeKTVbMkqU=',1,'Fv/cHB9Pm28qQ3rBam+OSZV9IXr1Auf5APfGbPrM2I8ECx+29wa0BKRVd+QIXs1yCQdqnMsS9hHD48Lo12NP2lm110+K0G7aoRS3aNPVj46oD6FnVheYDC4APnWbpCxHYLREfWqSXVAZ5NClsqt2SzVrpKQUQ7+D8mDfMT0qttQEO+T/GcJMPhkqjzwHjTlGlmnLAhzm3X56SlD1aHi8UmjjMp+vfKc/cbw9zVkhF0wvW8++1EEl/JL4h1puFYEQLTHd7WYPqEJkCMcuDX8UyafP5bXzEO9TnHurV2rpNFvpuDHFJGtTd8hD/I0qDKluYZq3Jhx99ubw1r30SAqBaw==',1,1,'',1,1),(542,'2021-04-30 18:39:10','2021-04-30','0000542',1,2,1,'1619825926841228292','',1,'AAURAZO',NULL,NULL,2,'B001-0000519',0,18,'2021-04-30',1,0,0,1,'uF+arg0R68mWLJ/v68A0700ZBoU=',1,'IJXlbiY8DH9NXMofmMgXoCR6mtUS0v1b3wnDSDp0+IqXTxv5w1GRqE7JVpsZ7WU4BhtkntjfVh+PW1M7DW9pY5FFlZq3Ec1pOP7x52VLxGbHnTPEpbryTjR41j2d1NWMhHg8+o9iORC5YFe6zlzdmp2RwQaYdZkDRD77bMrmsEQkh8/UipfPeaX6epHLLzMvWYZQ0zSfuvQocW0NPRcsRF0beJlaQMt+v58LvOYcRHaPcsYIamyWmezMc6hztlAosUw46Abj/3wJdEZ5QwGQYeZPIvqZ4N7yu3PDXuqw6VgoEQLuoBWOrfA2H7vW4xQfWlbgujDJrLMsu03nYi+ksw==',1,1,'',1,1),(543,'2021-04-30 18:39:39','2021-04-30','0000543',1,2,1,'1619825953527053257','',1,'AAURAZO',NULL,NULL,2,'B001-0000520',0,18,'2021-04-30',1,0,0,1,'wcbQ+GJqqN7ePmK/xmvwVDkt+HA=',1,'BHBH+JidW7kRwRnuQJllMECr+iHGMCueb+BKosZPZ/BlzXCPf8EB32JNjT6EdVA3oJGXw6TJOeegYv7Heb6oZEE3sDluz3RA+4lc/slPBM/oa+PMthDTlm6uHzeaD4HNqEeEVx6h/VcA4AQqD2OyH/sUFQ9WCZNO2vBOXap9EZQlXqoVDV/o9cEq+LVuB1mV6j2lqDV4m+hGgPPpqlXIrce3+sOCg6vInhk3eM8XaXhrCTnc7tWwiHHuCxCwCZFfaGtQ5oCY1hqxqmjWL+ysgHJ7IjKAn8PDZymoNfh/FcCjTQUU3j2K8hPIQyt8jD8ci+gHaDUdW4lxrQ0HrNTnkA==',1,1,'',1,1),(544,'2021-04-30 18:40:14','2021-04-30','0000544',1,2,1,'1619825982303933471','',1,'AAURAZO',NULL,NULL,2,'B001-0000521',0,18,'2021-04-30',1,0,0,1,'32r1rzBeZUcFMmkCpl1poAJz09s=',1,'FlTq/+VsL1fo4gCqvPNwLuEIaqlviXwlnreOpZcfB/OSyjmVwf0Ayo1kFikmIuN8ry5FXisqAmJFwpCO1qNaKSpwl6TnIq4CotnpA0VYngljxuovd2C1QPEzrwnKiEiOeN/SgMjQr7NXJumyMfEKhWTeTxpGLK1Pe2ZdzwlpYBbtBTNnLJfh8Tung/tyaw6E8Gaon697zt+//zH1yYIG/qILXOJcGpEBARAUjV4gAcAAJp1XnYRl8IYEnwSlJ6nL3cfpv1Bt3wvzb9Urav1NIHUndw6g5NvkWiixOtertJmg1B49nn66TV+Fw9vhwR1nazvIZMFm51x8FTYnIMKmiA==',1,1,'',1,1),(545,'2021-04-30 18:40:31','2021-04-30','0000545',1,2,1,'1619826018108181898','',1,'AAURAZO',NULL,NULL,2,'B001-0000522',0,18,'2021-04-30',1,0,0,1,'AlgKdFzt6tzqtjFc3T2VtVWcWbk=',1,'ahuH2K+GCiZBpaoVz0xWskFHIdV2q9IDXkzz+hHOwRdhI731ZtxMo+Ibu3mjeVKWXRkHVf/D3UZFdFa5MmPDXgHw+9doMs8G6ahBqqz2zX00vl/lIkbqO9735yISF8Q6abGMD6VK66uHiq3twSOeAySrdjU6j46vMbDmx9tTj8tiIwYykEJvLQwfAeUzZp0Es8w39mCc1c2VFGuSNyv48n9lFgZ3knOEhtvozWR7occLWnySMZgc0FOAH8H6yptBlan/zzUayiMYQb/RCHWmgJIAZu0o2oc5qVzOZvRHnetDrnrQC1a/WeXQ7O7JyfDMedrYkq8Baaunn7IM/nqesw==',1,1,'',1,1),(546,'2021-04-30 18:40:52','2021-04-30','0000546',1,2,1,'1619826034150180917','',1,'AAURAZO',NULL,NULL,2,'B001-0000523',0,18,'2021-04-30',1,0,0,1,'PNR6KYGWKikIBOOWHwnbR9wGn50=',1,'EYlLPzfbNmbILpICrQuTCQXHOqYoKlPu6YDKwDEkFDbgUMAp7KDYpHl/kl/K06DCYBDoKe/WYSMY2Kp5NPA2uZCOQPiUi479fg8UbN3H6ZmRXr6VsVTN0CCNuaZjFySPxWgJJJbg1WZEoO2/5t0rjDvEAMmOjBXfmpbZEhuFrHMD9y4SoDImR8qq06hEScKUlh3/QC91mWXAbzI63Ru0/a6GUqxp2Az+lc/I/4f4Y5VKYaKHfRqhmcvD78DhQfjOL2M2Zp5La4R8Nk0Vm/DpDEj1xZ/SI19IODawlHEGDUETmY6yd+CQ7XJjpO4GUe5ZOnEcrTfLbzWrf9VoG4omgQ==',1,1,'',1,1),(547,'2021-04-30 18:41:09','2021-04-30','0000547',1,2,1,'16198260551387990104','',1,'AAURAZO',NULL,NULL,2,'B001-0000524',0,18,'2021-04-30',1,0,0,1,'yiITKP5vpMfqwREm0+Uf/T5miVg=',1,'jJpAy3GloHS0MGcDyhnOJqwoM6cT3L4RFgqPTV6lZOFGmzLVQDhHFA+btx2O0VaXWz77GGiszbiR1O2aJLy9msF5/0DF1mAYX7J42hktsPR8jqw45P3IEsL2cePHdLoNnDoR539nzane2GfpOmdsUKivrjv+TO7esYKpdLsTar8YZi60pL6P5RQ0hsqM186GifshxjsWRHrvT9OSqpDeAkOWbum2HzrY3bPi6RHg+E+JORBAJwQzLurvcLamJ4Aniz6AXJACRP2fORP0d1XrDjrz+phlpArzrvhiuObedk5NeJKwEQwuE4HBaod1mDVsYQjGp+4JGMnSB4Q1Bas5mQ==',1,1,'',1,1),(548,'2021-04-30 18:41:43','2021-04-30','0000548',1,2,1,'161982607112823471','',1,'AAURAZO',NULL,NULL,2,'B001-0000525',0,18,'2021-04-30',1,0,0,1,'BR0g6ySrhHUMBYUIA5ndTX58p+w=',1,'Um3I5v+IYww17flM9xK1V0ITIGJRm8gAYC684Hr6A/buCX2LPNy/qT/goFsCVFUHeqOnn+uPtkvKhG95AaBSvu4iwiSwvndOgMSj2pn5t4s3DZfnuUDh1yG4/9T3JSLJcvok1fsNnXYc8Do/hGt0bH42QwF8/imzG6uhxbNhtCo81Yna0p3muS9noCuFIs6opXwGYLhw0Cjx2X9wRVPN0x9l9gkcXpNYV+2JpmHkZcsXP8ngiLFyhw6oiEOuXDJKrHuyVYoZokyk/t9KaZLO8moRF7rM9R+FDRvO7LYt5bBTD9sRorgLe7vDARjIWx9Kc2VTFObryfb4R4dfcO01yw==',1,1,'',1,1),(549,'2021-04-30 18:42:09','2021-04-30','0000549',1,2,1,'16198261101356146586','',1,'AAURAZO',NULL,NULL,2,'B001-0000526',0,18,'2021-04-30',1,0,0,1,'swGRLujCnLU/ayQ/NDjEWfstUds=',1,'PNa6KblnHy2xYNxIe7lFkLzGyxT3ny9YaC8S7+Sg3ndZDl9U+IhY+euBtVuNu35TONDIdbgyM1Mj+/Nj4ciYYMN5KQKZx9tRcgEAVYfIrZ1tALc+Ak+yNk0HXtT9Mo2sdIZOfJf+IsxvM391fGzKxBbR+XkGjwdsKk2CsXChSJyp9LWGYBJWaLX/9uDcfMCiwe01Wxk+YwUHUzgIGljLmdcI974utiRW0Y0gNZG7GixA6w4GoMesqKshfcrpJzFiEPYSMenHx5vj0fSS4MI0rI9uF2f/BB1fLWu4NVrQrAqF27TODe+YXYcGcueSX35jx8tJ3qiuXqiGUXSGQ/95kA==',1,1,'',1,1),(550,'2021-04-30 18:42:29','2021-04-30','0000550',1,2,1,'161982613165666499','',1,'AAURAZO',NULL,NULL,2,'B001-0000527',0,18,'2021-04-30',1,0,0,1,'3isdRpuK91340ZksEltGwtJdJVY=',1,'XZll90egNqKv12U1PveEe89CApBAlH4RIyTvGTNa/E929B1GU6dc3EYSQv2e5A09Dwd4WnvQf3s1/8ZQE2XsU9o+rbCWDqa1Ba8Dj0fYXr9vdyOf44SPT3162d7y0uwvh3RG6dw0axulXMW3STCbHaeDj4ocNu+AbfcECqPs365sb/YgPYumb2x1dUPGFTF1KQHQEJIXBspy4orKVhGUDlfht8Mr/vTdKIDoBhxYJjN8taOlmOK34VOpWd2AlIL37dKXrVAYULJR2Z2fBMW8l7E2gKwT4WtLv0Swvi29EwynDHSiY21HrZo5Kiks1Yk5NVFyzUl2cpM1r2ONWnoXuA==',1,1,'',1,1),(551,'2021-04-30 18:43:00','2021-04-30','0000551',1,2,1,'1619826151742599449','',1,'AAURAZO',NULL,NULL,2,'B001-0000528',0,18,'2021-04-30',1,0,0,1,'HWZsMFAaRv+PhId2XQdpU8m4QBs=',1,'XGtvcUKXP12g19unWtvQ7dVGSMSzVRCWCs4ulA0suAK50z/KagyQSYiQoCFobLebLgEiE1TffOGC+ummgmeiTdY8hdQb/g5U9ostMnVI16fQ7lhTYyu9oOm5C3kncUaePX5n8KHm3+jACx0abbp/UBsYFh8/Jx/N4f4UVFz7SDrAYGlP0aArqwlw1WGGceOxTf0I/uyWbHGUQpmlrP+oskbOG+lAI2NvSTXUzYgYEEs+110xmf0dYVukrET+/CbjCnuNJzTQw4Y3gm8Ptt3AydUnsZCqbUcFevK0hGdkJNcAV/o0R5f4jtXUyfBOAUERrGnzdozBvy208W9jL5EeAw==',1,1,'',1,1),(552,'2021-04-30 18:43:29','2021-04-30','0000552',1,2,1,'16198261831201963714','',1,'AAURAZO',NULL,NULL,2,'B001-0000529',0,18,'2021-04-30',1,0,0,1,'3S7Zjff8IEBtaRcGXAVZsi8ynT8=',1,'O7O0a+/Vg9HqXzxAdxZw4+Sh2CiVeHnF586ZvmMHylnFIHqgbXHPk0uOWFeLv21Ef/HbhrWmHxnuFKOA10VlR7Ik0YUmTiVUokzAMn0LVIyZZXP8E4nhSjAWH/YmE/4Tqo1V0aWFxho4a1PiPZf5muF90LBuCfY8L94q0wTEi03sBe7f7gDGzUyQtx7n40YMNOic3s3dY/wIfu6xPipLjYrYwIi2xUoNGiKNSfYbJb75j1ORtFLxoVtIzkGb7s7w7Q99Vm+tC3t+ppz2HJbCm/ko9bSVmD6ul/bnsnoAx8WlhgUJX4OX/jHtcg+ZH+BtrHBm4gzTq2hfyMlQ8xMKZA==',1,1,'',1,1),(553,'2021-04-30 18:44:06','2021-04-30','0000553',1,2,1,'1619826212557132472','',1,'AAURAZO',NULL,NULL,2,'B001-0000530',0,18,'2021-04-30',1,0,0,1,'1onmJoL0IedjybKxbUeBJG5Qhg8=',1,'AjTZVB4ZBfs2aa/jtDrK87maaPqUMuQeTC7FsGaR7U3J1xFAUo90bOhQWakAWZAzpK2M4ocNwLTxtzKGhBKcIvlWfVpRMHRSJvGr28F3vi2baHDErG/kb8b/z46NxErvpo03lM4IV1CpbKArn+sOjm3VEaIaGeV8n9VonWSic4A542RBxt7vRhKTmzWRirTk4SzCT7jEMDJmG8r/FPpZXu7eDZaRJ1gVQ7q98mt1+02/1LXe7HWcMKWTTRhlFDgaLHnNQo+SnEmnbSfM9tnP7zhu1C6K9Jh5f3t6WewQlumkhg5hKHUD3L8nR2T3yfDf04iDLewfuzgAFTw2rFykoA==',1,1,'',1,1),(554,'2021-04-30 18:44:37','2021-04-30','0000554',1,2,1,'16198262501033365195','',1,'AAURAZO',NULL,NULL,2,'B001-0000531',0,18,'2021-04-30',1,0,0,1,'IlTwjKWPRfGQEajEqnL+jz5tdrU=',1,'i96EyeC6O1IpDdt+eCGRRSXP9hOPcOVn8P86y3EeaEqWKBck+Dkm6dyIT8/o7GwxDWfx/FgPAuPrHIi3VwG2DyiyC+cOs6FnKaqOamxhrcFqg6xe4ple/OzUq2zhE20OtkDJn4UaAMMJ/LVE7A/sDtyRr5GNciQbc43y6qOoUGXgwhDne6xkZpEBiMKFRauxz2DvhgL0lSL6vHav3fVreuHOg7CF+VZPd754YGhLp1VwSB1TOv4Dq4hU/FfOxasEUIZyOwvONhSt9dI9ZfvttCHLeyxhNKihInBzvm2S20y4dg7dVULzIWln4lAe7wKqsowtHHtyKKaiQ9kLWdCAtA==',1,1,'',1,1),(555,'2021-04-30 18:45:04','2021-04-30','0000555',1,2,1,'1619826280732788203','',1,'AAURAZO',NULL,NULL,2,'B001-0000532',0,18,'2021-04-30',1,0,0,1,'gWzio1maMLZGYVQY4J1A2EK+taw=',1,'TLum7xSFMWXZiiP9Px0CF6cvomnLaJiI8xs3DBR+J7WLIoDzvMN9WOhBbsg74VnKQkrwhT6pgbHznEHbk4FyJv7rWpp3q+yZnA/G4WQicAO0EI7kwbcOTTnN1PwCTHXHhvRhd0xPpZ1D13RgdBk049SpRp/ry3TY1YZJm15HNUBXCKe4nEVOv4oMXwYiskbHAOySCMbdMY9NHbZcQgTNiIiRcdIw67YSZ9h0PAADgqlzmRjSQx4w4Akdhdo2B7AWxiv9dHAq2I/GfUJagZXigeIM7iRscNcpG/TZr6vbQ9hwFy1qaK7Iypx51HNn9ba5W+UvO8mtvkR0RQSnJuqScA==',1,1,'',1,1),(556,'2021-04-30 18:45:32','2021-04-30','0000556',1,2,1,'1619826307259610737','',1,'AAURAZO',NULL,NULL,2,'B001-0000533',0,18,'2021-04-30',1,0,0,1,'9hjNO1eiVumdVzftfq0kZBxcjEY=',1,'PulAynLeAvflxwuMTBj0SnRwrVGaIWBy6JJ7HtHxrHBcjAi3bpISD6bNERk8vUIENdz/jCEyErFk2WoBva+p2uIdVmvjRwmJsCSNWDiDvx1nppInB+VRc9ljUbfjFBRFPUnGkvXi/UoGZftWtUkehQYypPerTdf2dosdHPWbcNj9E1yX62ganzqI4F0JKSLElyqtEYsF/OuURiRD6ei5+sy1pO37Tggs2pUFGhZg02BMlJ43izFeuNWbYJN5boRxycgiR1UWt8tl0XVUeKxs0tNdilPNq5W3GUvRSsFXnarV7QOo/7+M9tox4x1Cw206+mTvfmgiBbO8b9kWDDxJQA==',1,1,'',1,1),(557,'2021-04-30 18:46:20','2021-04-30','0000557',1,2,1,'1619826340642765717','',1,'AAURAZO',NULL,NULL,2,'B001-0000534',0,18,'2021-04-30',1,0,0,1,'+hH2h7aMBhdC/Ng2qhS5uyih36c=',1,'XUuUX4EkpTydo4yeoZ4W71/KvRtCdaVDcpZ8FAaycEsu9NZ4lmTkgKVV3lLfW6mI8Cvy/vViSixVACx8l1TejPfq3JmUMYPTl31pQkuAvh4Ktk8q2hQMuz5lLporC8wRKtRMVBKNWz5a1MNgVt3mOZZ2AwY7Ev9eUMCB9+83Jm+JH7IiQb0teaMCJlDfqJcJjs2dxByiHMPrfeCSQ9VX30i2EapUZ0FeF4zUmesYEeJ+PDUBHTuyW9rQVAEJ4YjK9H3h8YOFfSrEr/ocyyLEGptUk8Zw4/7TMTZ8elytMnFbOhgfqr+/vLEyTstm1+hk+S6ZKqism+rxm67mK0JSdg==',1,1,'',1,1),(558,'2021-04-30 18:47:05','2021-04-30','0000558',1,2,1,'16198263831371594995','',1,'AAURAZO',NULL,NULL,2,'B001-0000535',0,18,'2021-04-30',1,0,0,1,'LndI3L2Uc6kTTzkAgR5rlUvFUog=',1,'YJDLgUGK0ZSCGP5+rIlT2uElPs2SBPOeWHBSYgs5OqQBI0wcb8J+5x2HOPq6WhhZrtBujBgeJweLpzUdINzwxwEuaXKC44uBJt9tnXe04nw9KjXnmHTzf1gzglENfAXe3MYD8kvnp+ZS0M5dqkwssKSLB8BzzihiFppFrfcUXogv0pj2SAkThL02X+9HRhoYErGj/6qhB/DbLZ/x+GveszQLNX4qBS7hISaIaG7iaSuIpfETTIlCFsZEs8/3qO5Hy+1cWEk/DDVThBLJ0HkK1tQgbjRblPzFdw7zKCHuFlljNZk55ggYFlLKZOdHjz11KlrX1KEwbQ5IDuAde2OXGg==',1,1,'',1,1),(559,'2021-04-30 18:47:32','2021-04-30','0000559',1,2,1,'1619826430757875731','',1,'AAURAZO',NULL,NULL,2,'B001-0000536',0,18,'2021-04-30',1,0,0,1,'taZOzu4QWU45fjHT1BI752Ko+OI=',1,'KIoWzk+stO5SB0eFvQl4yzBFCs6Ttz2PKkvXg1HxWkZXFY56ilbauI1gsAEbg+qDAD5S9w2PkE3v7Oxv8fSk49JXG2SrmlHIXO0aLHurzqIfDligKyTXu+hMtq68ZhVE1ZiK2QmFymeNpCMqqYCHlrxC9MIlkCmr4sqn5yMfM3ajsqkZJw3iIg3SbnpVCq7rpMNp7kBNArXqxqITP/sT35ExSgQfXe051T4W7WkH2kXqWuNpYRW0a3WJdvyCGbQe0UfAW3dcuvC3D7mcmGK0Vv6526CU1tg08awBRHaXkDcguWxNG2ePMSz+PSylM8ymIqozyRffDHcduA43T7jYZg==',1,1,'',1,1),(560,'2021-04-30 18:48:03','2021-04-30','0000560',1,2,1,'1619826455386468428','',1,'AAURAZO',NULL,NULL,2,'B001-0000537',0,18,'2021-04-30',1,0,0,1,'CVdPCNKZ5GB5QTyzp4vF5As1gJA=',1,'QF28ivnrkcg+GeIwboNQGfAOQRyGjdQohjkZlmA+std8arwLkmuZ5dQ0y07QfhjBWMosnShReskTMEqLEXJIq2cpkgvCJWr/gDN16DK4/Mxt9/UgbZOjNUHhFMu5hQEcaMGqW5STCaJadDOipp2A/KARSI62+fy5zVzELUQt4XtPXr4O/VvDF0D2JDWWY9rp6NDtoZHJ1LYLcdSgLwGqjm3USfBzdm9LEw0JG6ARdHlCxhm+y8EFXL94/VS42QukzdiJ8EoBFZfgjeCWgansuEMfWeJ8z5tZ7knXB3phYlhMbHAeW5tsKITeSk2QSGme/NE2lLStrekR0gzeuxcpDQ==',1,1,'',1,1),(561,'2021-04-30 18:48:31','2021-04-30','0000561',1,2,1,'1619826485902591612','',1,'AAURAZO',NULL,NULL,2,'B001-0000538',0,18,'2021-04-30',1,0,0,1,'RUS1Z2zXAk7UvyT9NrgecqLZf6U=',1,'XnIVZFLUyivShleBB6V39kvztvtV8Q8X2AiV6G1sVF4mIm8nFTwvhqKzY37BCVSPgi+Sge3EfgyAvwjWlyBEXeyNeWBFfLdbHjz5rjEj1bIFlLuCzFGmbB50Jae8lsgTUTTY6OA/dtkTF4DjJPq0fqv06X4OOUREkLsmjBLgNWKjkto7QHhiNo3d5IHZYSgZF66gIbT6L6zUC0QteZlPwBHqMX/lv7VMpLS2j7L5SnNEXXlAT+1x4Mol1CYliE7pvemoHG1Ic4pfqGlsDa+tYzyATzoqaTv/qICtF38X53wS3o4O2OpBVkZsSDTJu4e6fEMBQcNm0hQ4XbXcsBpW+A==',1,1,'',1,1),(562,'2021-04-30 18:49:04','2021-04-30','0000562',1,2,1,'16198265171012451749','',1,'AAURAZO',NULL,NULL,2,'B001-0000539',0,18,'2021-04-30',1,0,0,1,'iMb/oN3mcAei5O3w8vhfuY2A0NY=',1,'EIdLzuruvuejvQ+b2KAi0zDLC28PtwZPMAlC43czuQTRYtv+UlBZaK5lTPCSjf32hE7JYTfBEylC0EfNDe8dY3GVE5/wJ9X5MIcZtqx6ObfmFh4D14nKDPwa9Ew3XtG/fzQqOOWf9hbNp0fwNToJuE2bfrdDP5SqAOAFp/lJh78SjIb1IHddjd1e6MgvHa26Nc7IpYkSv0h3HVyH38yLyhAmN0Fvx6/CF6FferfNgxyOSE59jtAvHLB1oncyRleOouF6pWtkgaDsdphZcSWZGovooC8a41aJbsSlw18S3y2ofQXFIkz2TYc6nwfbMvy+uaeFd7n/epEqAw2w3bw8vw==',1,1,'',1,1),(563,'2021-04-30 18:49:39','2021-04-30','0000563',1,2,1,'161982654731972614','',1,'AAURAZO',NULL,NULL,2,'B001-0000540',0,18,'2021-04-30',1,0,0,1,'U0uj+sCz7tIfa2m6A+T5DojH2e0=',1,'UL8+JC6uu1XtpvI6KedVxUh1gw9V0y//U/yLCB2QTJ+BKvkJH3RFDmaY5Av1WBtclR3+UotxgJKO4VzlyFRnYomBEgX7jQ9CZcXBNKPov7DzZ9BdzHAzbGGEEJAyV3XfQSiXY1OQFWlO/awYcCi81+FaIt6Lkx0MoJ3Q5zXEBe+FwADeLR+hbReah3YbwJ1fTn7lp+myjW79NK41Rmfp/61OGlZx2MnVWw55OSxraEFjeodFZoEHZZxIIa21LVyUhquHxt6jHkzFY28JuGTWbLa+Fh+tgRcuo0+oJSxOYSGxgsrnElB/NU28JB9dFhMHHU9BwV6ywlYbxUEUBQgMVQ==',1,1,'',1,1),(564,'2021-04-30 18:50:08','2021-04-30','0000564',1,2,1,'1619826582982587693','',1,'AAURAZO',NULL,NULL,2,'B001-0000541',0,18,'2021-04-30',1,0,0,1,'X8yCR5pQhKeieVp55WkpOIOsWB4=',1,'KWX8T97gP28Q5ojlA0JExt0hNrecAer2u7uEsIaRkvAKD490fzrcE6Ua+HHVtdkXVNz9X4pa4cYB9cVStqMXX+ZmKXfkL9O7++ittjoM44p0jWUpj4DzjZe0qmsU/h4L4CxjKAAXtlNRR7Dz2ydnH+C9rSnuTQSW/76ntD0uEli9evkx896BeVL4VY61Y50MUEtpfgtSDKDIacr+Qj1KLGqEju6NJ+qbwpMPt/pQXASZAxNPxAbL4K4wzIoqr1wH91oWvfx5lcLzo4fkoGsNwH1H/ZPUvFyBqM90euo7iKqQXc7ySmnp8Qx/vRKD8p0TIhEZ8gMEofksLTkxEFvhmw==',1,1,'',1,1),(565,'2021-04-30 18:50:42','2021-04-30','0000565',1,2,1,'161982662567904151','',1,'AAURAZO',NULL,NULL,2,'B001-0000542',0,18,'2021-04-30',1,0,0,1,'T5UDwrSKzpA0U/lv+DLhPQLzmD8=',1,'WcPW1aIC4TGlFd4Kre7alu8Fw1jgwe/Ma299WTpcwy/CfKmteP+rMMkz1q5/D4m1iAyewKF8EteTrb2feYd9ucuN76Ia+P86mveLqJ9yKGC77omf8tRa7dte5CtjMORPTcy4UgN4TkYoaw6uDnLOSZKaKkwud1IgbpPofalCTwp4+N/12o7GZQajz3tU1/oejLeY1WyW9kunwdThW1Cq4FMbqlr5HOydCL1QMqX4V800Ud0GcGQNB+7w/CBCoWhdlxW79GxGPkUQ+iQmldfMHdc7feUleZB2P0s+6n6je+nhRG05ru0db3Fgzs1z+Pa3dqLdR7oY1So0aIQHhnTvqA==',1,1,'',1,1),(566,'2021-04-30 18:51:26','2021-04-30','0000566',1,2,1,'16198266451008707984','',1,'AAURAZO',NULL,NULL,2,'B001-0000543',0,18,'2021-04-30',1,0,0,1,'YzOA9hc/Ph5KdWSbEItnHzcNn00=',1,'BIE4a0/zrXM8ru2HLwAnm8hobCuO2aBOZc4lVLmMsuNrmntP0NjQaGuWMT3LyLU8k4ZbOXDFw0bXc9E8BUwWR2+5q6ytMiClGmvg2LyeGrT95nPWjwhlXF+OhXfBswAur31v+VCzYnkg/a9VBQKJItILrsy5wl+AzQrC71gGkvyoOuG66d0X8BVd+kfQvojrgoNOt4lnuhAVfvwF4JwBu3qI2VHJ3EkeMnevzZVMxjk7uZqplfbblEsClfHbhJxCX+8jARuOqiVhDxuityL2RBwynDkWshyf4XTCGCD5TT33IFW2jLq17R9rzDoO44ektvOdWfSMzLAs+Ox67GklxA==',1,1,'',1,1),(567,'2021-04-30 18:51:51','2021-04-30','0000567',1,2,1,'1619826689497318296','',1,'AAURAZO',NULL,NULL,2,'B001-0000544',0,18,'2021-04-30',1,0,0,1,'I09gY0sJGZh3zFZtUKdZ7/0R2yw=',1,'JyZ9ROoKkbC5tJNuZGbcYAx0DZmQexlRzHBE4yUTZ5W27EBMWVPyP2/+K6uFVJFOAmNLjIj4RlcIxqElF7fLyfKXn/zMGA6baVZ0ei6M4MAjGQKfG9GJVD7lVadExhHreCgEacE9PYwB0qkv6TRTxVwVIYJxOAlO3Gkpf+Ffow1xosRZ7Oy/VnSH/RssYsgVO41ctRbnd4owvSJUzgNK23LUfwXl78I+e+tn0Qi8x1/hkYr4ce7Bwfz7GcHJOVpNTs3H29H4Bc+6ioPst/KKAvJUR9aDkgTIZ2jrbLVbPuxivUn5EQQRUoO3RJcsUGCbb1uOBomZALE1CD9ksS8GhQ==',1,1,'',1,1),(568,'2021-04-30 18:52:23','2021-04-30','0000568',1,2,1,'1619826713935338797','',1,'AAURAZO',NULL,NULL,2,'B001-0000545',0,18,'2021-04-30',1,0,0,1,'NFU0jRm/U/FVlKxQiAQrh+3pfP4=',1,'HpjKhp0KwUSICrnijTg/y3DkkZLx/Ed/GBGAAMv+caJs0BOsi2v4Ahj5zmrupLS4DHwlNifhI62/3nUjsetcvvj94KX3nTxI06+uHgx7S475dgI7O0CeH0TFa+ESKXXP1pcdA/pagepqv+0iufWOfzvRN84+0alNZIXqUku1xalXrfx2fMGHhO6JbsQDd4Oa7GiLex/VzaZLGKzoqZn93HKwx5aHaQT8vw/DKoBYSDX3RoGhJ/75HdUzKeFqg3kB4PPFX/dE2F8QIHo+AfKYkFWpSp522PwQTSD4BP6np0RqZMVo02qZxvu61tQMKoUjlu3QCax3yQxQ1g07/5nCpA==',1,1,'',1,1),(569,'2021-04-30 18:53:24','2021-04-30','0000569',1,2,1,'16198267711072868370','',1,'AAURAZO',NULL,NULL,2,'B001-0000546',0,18,'2021-04-30',1,0,0,1,'ozqNnCgBtxMtMt2IADXdq/fKz7g=',1,'O4Dkg9hEbD1xvUB2l7TCycoBk/RzpM0/2YPJLgklDfQWc43opZBatnAIwR3rfyw3LBV1GM0WqxfTms8rKScsz9V3m1nzvy809TS1js/mdqDU+bd5bwbgS3WeTHlZv29k61UzNoaGk0L3uKthh/VBYpl/iJTl+IA4TOxtX//QYtEkH15VJDo6cX9Ie5lE8f38XOMkRLmk5Iu/ly6zIsFq6gjsxd29+gG8SvgCr+89+bBnrj5JQpyIO2b9X9RHAbu5M8PTbnHRAhgelFd9LiQP8LMS7cKRDuuCPYNQuIhShu9QDtPB/hlHhJ8Sj3JtI6cBeFjjk0qlFaPAxvoYIVZwxQ==',1,1,'',1,1),(570,'2021-04-30 18:53:39','2021-04-30','0000570',1,2,1,'1619826806694360822','',1,'AAURAZO',NULL,NULL,2,'B001-0000547',0,18,'2021-04-30',1,0,0,1,'GkMnEwYtu8HF5lUNDqYpmZUjchg=',1,'Vm4001ti02S1LXfkB8Aj4veIH9bOflNyt4qi0MxIgDf3OA06GaACkF27d/g6W1i+RId67W1oFfx4ZWINznpTB9ldjlAFVwDCL3jem2UYH2wDOdoB7Gyz/BKdkiHlX11r7KeE7eBA/XUw9v1JYLHaQeMuJ+vQIavFIpCVYNtCz8z6KLqpJTt6TopCY+OCOXuhmuzPoH9pw2DeOljWF7gKRC8qylmE5jYAp7uIV0XhDg/pMDpR5K9QUQOoOfxnDvhwfPDt8eLkwfu7EjIYlGsCIORP5Q37jpyiMO8XhWaL/kdxgDb986FzuYZyJn0gfrkXqLnkngans1Yo6kYWHmz0TA==',1,1,'',1,1),(571,'2021-04-30 18:54:12','2021-04-30','0000571',1,2,1,'1619826821350321731','',1,'AAURAZO',NULL,NULL,2,'B001-0000548',0,18,'2021-04-30',1,0,0,1,'kpsbCYSFmsfyZRxefO8SI8a3p3U=',1,'TOdFrcFew9hYXV/g+8DnFsAWdEsOwTqok7zCIxZ51+kqCZVhSP2DjOJaBTPMdYqkaFaryaWNkH9jFN74r8ZlABFNf+oygeEeaoR67U0OdcXjg3M5hRt1R5BsECLg6qHcRo1FCuQAkwVM7s91lSOzVfbEIXQmKSr8DqZIQz+6FzDZoaZMolk1ttcZ33SDnKUY7xCUcRRt0ssHpyAz4Gw1w1fnr8fc93wI4q+YLr2StNYdAcnH3AejHsWXemwOGX9RO7uk0eX2+TENGcniTj4G/9oqB4GEweHkrErXj8VIef5lT4U5JJX1j2AhVbCCSV6Q7P9ovzbCmAbXfmvpOUqA7g==',1,1,'',1,1),(572,'2021-04-30 18:54:35','2021-04-30','0000572',1,2,1,'1619826854526709003','',1,'AAURAZO',NULL,NULL,2,'B001-0000549',0,18,'2021-04-30',1,0,0,1,'qQIOzdu8DeABxCpdeW+IXZz0usc=',1,'PjX1fhps2yTtkZgvqD4vJM160MGoOH6B8GZOTnQSYFk6QddxmbjoqbNe8HdJ8lJkKTv/9/eFa/qRYAVwJouUzlVoACtgJHQ3UoBciRHCJCrPrbdSsArBKqaccDf2a/Cz10nYtyGswN4jcFhU7nzNERefu+1WoVEl7sUGxmQYrGgYNTF1etGf2NUkDS8oBJ0R8201gHHruhRlOH+jdolWyJwF4sL1ZJ6ODBM0NE0inExA65Z7ILHhC6AXPQlp0R6am9p3lS9UC1kMO8Srpxr8ALG54h2jwXqwPD4Cor0u43Ps3UzqnLcQSemy0X7JTTzdz8K+XSw9ZuS6xeFWJcHBNg==',1,1,'',1,1),(573,'2021-04-30 18:55:04','2021-04-30','0000573',1,2,1,'1619826878594139804','',1,'AAURAZO',NULL,NULL,2,'B001-0000550',0,18,'2021-04-30',1,0,0,1,'rwzmBDVdULwwnXh6vnVRYd2RYv8=',1,'G0w/sahqOkcBLq49a+XVpfJx47BA7cWx51Rxpdk85VA5FgR8EP18HAyVfS8W85AyoPAg5cNBxUgjwDLjeOIuBVN+XHoFFKiMy9R9kII0UE/e96HuGAH7GRo17u9jZK+stGFP3u3W3VyfjkIUUTocccayaAIqpM8X1MNYqCmq/aqYDsK+k1OuEnEEbFtlYQJjclkLFidEWDkzsA5/D+KFja4QxdabfqxQKy0wBVWQSt4c1KWdln2+Ejh/x5+CtXTwgZB6AK9L3JCzQiDK4u/RFdE1D3Uz4AesB6/eu48Jm8eY1oVWrhOuIwa177eoFBaQgIHCMAuaip0F82U18EENOQ==',1,1,'',1,1),(574,'2021-04-30 18:55:33','2021-04-30','0000574',1,2,1,'1619826911857623400','',1,'AAURAZO',NULL,NULL,2,'B001-0000551',0,18,'2021-04-30',1,0,0,1,'0bizN5g0gVaIqykQurt0MbEQbHI=',1,'Jn/S9N0qqLP/x5Oytlbl29qyjRVWwp/093ccI7F+tRE5xSMtgHvL8ghjqzrVb0J4zkhpRrDKdvz9RoO5BmGiZ2P5RRVR6FKSe3dUMabVLxFK4iJMTh64o6z/Zzk7S9vhROt/MK6eRApRLgPWlO114vu3iDlxC87HpwFX9p0b0Sfbkb1k5I9wUkF/jW0hREEo0jS2XsiZ06fMrb9wUWk8sGV163SwUY1Nm7OFDzscz5f6f8XSgereA/MsUs1Z1XgJ7kTwRVmIw2cYrZ50lqA6t9EUwzxYz+ykSJlCk9MKT5JzC5FT3Tz5iRtcpe0abGxCuWcKe0Ch/dFVIbn3MNRAag==',1,1,'',1,1),(575,'2021-04-30 18:55:55','2021-04-30','0000575',1,2,1,'1619826935826253232','',1,'AAURAZO',NULL,NULL,2,'B001-0000552',0,18,'2021-04-30',1,0,0,1,'H5Fxv8N4N6gVp6tvNw+cV/kLcM0=',1,'IXJBAuWAyGbXaySn3An7HrGu+uwu6zrlL5p+xMQQ5vS27og/Gge4kgKyRvJm6fdzXHKidScP+B81nvN5S2iquByHE/XpF8t1Zi2mUVik7niVNDZM4AUxmbbVj7CaQWRIfq4PYLrA2C67GY+DZQHIRVAP5MP6CeOVmLN8XmbaFggFMBHArzghVVw/sG+0WMDX6W+8ZWQGI40XDKCCMyvfW2pjvG6u3LjLc4Ju28KxlDOCi5V25Hr7K+p8hFmZ7yp2NKysOKdpK83yenRBp0WCFtTECruDBo8uWGqT4s/vPNDQCi7B12uwWkq9zqD7VTWrZWKdQKJv/qX4ORcPPgI9AA==',1,1,'',1,1),(576,'2021-04-30 18:56:17','2021-04-30','0000576',1,2,1,'1619826958270196555','',1,'AAURAZO',NULL,NULL,2,'B001-0000553',0,18,'2021-04-30',1,0,0,1,'P1aY3aurELoI87YegbH87ztNJ5k=',1,'c6L7k3ihYuQxlGlMoeHK2JfcEuqTX10leD8OdlFKaDqIWfYO/qsxv6zukRO9hVgW9xE0M5odVSOnO2xUGYch4Tkh1otZVMHZJgV9rhdbGrqk6z0X1a4gUhebeXrST7gGLh3i3CN1TK68988SN8LtOAGNY6mCfcF+7dRUwkvmyHwi9HTRgG5bO8JvWm6HWHg6rgWJLp8SEFN/s6u/ONaHSUucLon/Oh3EsjQ4y+mPJi6ZRpvxZyonVYj01DwaAzabg6DUZ5ZK5L4DUTrP+DbXY/tfvDzNJxEt32WvFXwlL3iEfdbyJq1Y1+u3qCfRjGno1VS44STT6EomPQVYTKIRhA==',1,1,'',1,1),(577,'2021-04-30 18:56:49','2021-04-30','0000577',1,2,1,'1619826980389093366','',1,'AAURAZO',NULL,NULL,2,'B001-0000554',0,18,'2021-04-30',1,0,0,1,'sMWLL6IhCxlAF4pOzlu7DBbeou8=',1,'cOatiUPqbzLX33AULkmjHxN8RbB/co+ida1QpVMBEkmKYFcGdgwmZOR8Jw6FtPCXlHmDDiXpXwJJg5L+vq6oQ4FRNNwUrTokMs4q5Oer9kxndOGUrASLUvPQwCMsCRaH8+cf+i7qlLiiKhnp5oM6PtEo2auKsutLOqZywn0i5J6bVt4gOzri+7mPythaV26tGIgtv2U9J5p/FcxHo2ZKp7qkEwWXdtqs2UGyKgXSz0aYp5BJEuy1G1N1o+VWEpmKu+m4UGiw2h69X0DMhoMwMCJdOwI93K1U6I2YUnW+QvNsP0whPRnEoHRQTRqWjCjLGK/T5WLRP6wlQ3Fm5MurSg==',1,1,'',1,1),(578,'2021-04-30 18:57:20','2021-04-30','0000578',1,2,1,'16198270121185095255','',1,'AAURAZO',NULL,NULL,2,'B001-0000555',0,18,'2021-04-30',1,0,0,1,'AtlYcELQFExX/1Z8D+YXAnOw040=',1,'WOIhN5TM2yfIlB7dhF1mmzv9BMtUeumZZuzPfpNGJXc5LDLdk77ze9vSTngCyTdaJE4n5JZjwgvQ53cCm/tuuVuV4YTvzngos8xtE3CZCz9pIk0hOPlnz34RhbhmIdVV9Opj4OLmpg9STC8M6+96PzGR33Vw6WQ8/Z9KPPSSpE+7i9emrbWHhpkKSklOP+pzh+ccTSMsJ2C1dc8tTUZdo98+zK0Bkfla5vtdImclyQSl2sjoJVcycBVGEpV0XDczS/Z4ZShmGqVld60BN3T4sUvm+s+TH3d7j6XPUXUPJGNgj4vtjDZHQQpygdmYdMNsrppHSJtm2jRZ+BQ66WVHVw==',1,1,'',1,1),(579,'2021-04-30 18:57:55','2021-04-30','0000579',1,2,1,'16198270461140299171','',1,'AAURAZO',NULL,NULL,2,'B001-0000556',0,18,'2021-04-30',1,0,0,1,'JrKLaAIWCKEeKCumWY6EQgdiNdg=',1,'EnVTbx7UQ+oPJZoLevVDnIiy8U6dc5LvxVWtvJO0SNt+5zKX3zFlaqW4LCRl58qWBj2toVtCvT3/iQXSM8GU0tzXPlz+hhWRu0rZbPUFz58+mdI+PkyrVAphwZm+kobH8O+AcHdLV+fFQsupzoR5i+YAvisbZ/Xbc32EnJY16QHIv6D4H0jXjEWsxc6g3udQsi8+K3Rgl5MVIu06uuFlst9nVmUdzAvDYeoW4ltBDMm5TLJQjMdVagfga4zsGTh6ZQIMMSbPDtAkUqG16gsWoKg7ywInbrS3cajxgqgK6Wz22TBAM+Zn0xUxKbO4gsA41ZSK9u0HWpKChfpbLiPPTw==',1,1,'',1,1),(580,'2021-04-30 18:59:18','2021-04-30','0000580',1,2,1,'1619827132200915387','',1,'AAURAZO',NULL,NULL,2,'B001-0000557',0,18,'2021-04-30',1,0,0,1,'WOHMnyf3ZDCsYotH8yjGxDM1EjA=',1,'HVlJRSVS8soCVpn0HcyaumD8Mrwgk+iPj1nBk5jn1JAdFVnyWsJjCWpjx/bs8YIvS5oEpu6RCz0uMSadeitN7LsEQbGS/nJzkN4IqLp0yMUb6+V6pJ8XlqW3tYxWgD3JCUuhnQvL9CQ5siaXiKxsLYhMnxOJqr05I1I8qeIHEzau+HA/jbm2+znLc+9tHdEFebQqdIiYB3FZ0V9JcdRYmadekpS000f2jxyYv3z3iZ5s9cbeGAgrQXMiaBJ/qnRdplCJW7JeFb5DdxdFW55wOjH9BsTjHoDpiseQcGDEBwgWyfUpD9KRscASRtBxTwGNsVZN4sqmEseK3lOvNIrNHQ==',1,1,'',1,1),(581,'2021-04-30 18:59:45','2021-04-30','0000581',1,2,1,'1619827161980436104','',1,'AAURAZO',NULL,NULL,2,'B001-0000558',0,18,'2021-04-30',1,0,0,1,'N4pROdrSjOfQqHR/jeFgiRzfH20=',1,'is1KJhrsuRTJHbEp8RTb09pky6uHbQIKPa4PjL0aPaBuRqn15e54oQQARMMRhak99QnEepVaozQAEV0IBEX9FBcJBOoecqQ0Rjc+WfuJpyHGHIkvufXeWfwHSK8lW3BsVvJ+tj/3ZhSyT/BXRNzF9pq5qL3EFCh0JHYG9vYQB7IcMWSdzUHcy4RAo4b9iDV0k7jEvGnFAYf+dSexoqhF/8Aa/NrAofwzWm52b3DeUpGnstFWpyiI3uYoy5bhRsQFmyggLScey6Fsmv8uuQedR+8rb8BcuoU9gwNMdN7E0SKRJjDRLYV99JmNTZzmNLO5O8iuY9Br3NwG5iTT9bwu+g==',1,1,'',1,1),(582,'2021-04-30 19:00:34','2021-04-30','0000582',1,2,1,'1619827188229918808','',1,'AAURAZO',NULL,NULL,2,'B001-0000559',0,18,'2021-04-30',1,0,0,1,'hBtUsFWTJAKiGnx+pG25E0WlM54=',1,'WtWeCiIIS7Ws2W3pme/m7eAjJ6YOUx58WFXS2WL8fjEWksSLyLO8xRxSDbWB1/J0pjOGpQa4hQ9bT2kUxh7s0Qnvluh6UErndAjyyZYhu2kCF/kCmrJ9eRceRDNIyNXIhsd7eSWac+BGhJkBUp/PWeY7jK9/TL29M01nDkopv+Wh6yD5h05IJvOMADEnACpYOrzh3dlqNNHVVedCPiF/EHdN1SILooALmuXVQV/AC5M9dGRQMO6MiTbhmSLbDhT02R9P+qDkaAxf5+DTX/Sce754hqOjis2IPcLCnY444Pw8ITLz0J+3D8ot4EY2MD0t4P/4lbIznz6uVeZ1AX3Sqg==',1,1,'',1,1),(583,'2021-04-30 19:01:12','2021-04-30','0000583',1,2,1,'1619827237501664506','',1,'AAURAZO',NULL,NULL,2,'B001-0000560',0,18,'2021-04-30',1,0,0,1,'tavg/N7XHWN/PL0VsybaKht4G7k=',1,'FqTVuyjfVAXHCAXwIuW/ojZpS9Dcc3rZF6IGmc+Nob0811Y0ZdM8iCb9Eqtgoz9Vek3laU+7s4rx2QmQtLlEJhdTZo17Iq9sOvSc+UQ1kmednxQzNYx1RiSnutmOAymAL9NB9Ln7N7M9p1CD+a6+qlEJHXS3ewZTfB8cUeLoZdxABR3fPohmyP2ioI3Fm23FdbdSaSvpNZP3qmIL1bEP3F7tc2Gcj7WDkIu/pzyoe8N3JW5i4Ah+tf/4XAhz+GvyxjCKucqcPFU//cg6sYcuNESnf8i9VsECaX42hO7EVXQRt0pRs+W0HHKHhGzNt0eQ8Xb7EwoGOYg1Tm1yq4DTTg==',1,1,'',1,1),(584,'2021-04-30 19:02:03','2021-04-30','0000584',1,2,1,'1619827302381347646','',1,'AAURAZO',NULL,NULL,2,'B001-0000561',0,18,'2021-04-30',1,0,0,1,'u+lVbQqGERB9e5xdhM2k8k0uqqQ=',1,'E2G9Rbhj3XiLHLQYwaKkXtDDAxa+ALnCqmtckugabasx9kchQyjULODCjn97XjZVLo1DkETK5JsvY9HTBtSHcY5TWUItm/vIK+PIJn6yW4x9uA7Zc+pdnO+CNu3Q5wUPty8Q+whnv16H9/1CD66nLK0DPOTZjthCMzzac/PsHaKmJrZyZRsrukML25rfJclqgudxHvCCKI1EOVsmQr0zouFTbjw1ZWVTCfG7h7C8V1EPwscw5K/kEva2KKAtzvCOQNJjUYXamE4u0+bAMectLwF+dDKhu2bvC2V0LvAxKas6e6z2mhkcUktXkYYbFr59h7kXR46IaRqhs9m66T6COQ==',1,1,'',1,1),(585,'2021-04-30 19:02:41','2021-04-30','0000585',1,2,1,'1619827325856676701','',1,'AAURAZO',NULL,NULL,2,'B001-0000562',0,18,'2021-04-30',1,0,0,1,'NoCES2cGSYEk9KwDS2tznA8akbA=',1,'PrsNbir6QU0Z+P6wMCkEFSdAQ4D+XY/J9+ubKTNQ4si5I8ELzaSP3N//VLPjt/KsSIcUr19TfxKTmYmM221V3bqk8juT6w/FiYQvThpdj6gA6/C7aeogbrfcZa6W6EigclvADzeuglYThYVcV2roYmh/dWpUDgFxA82OTDspAAOEkuSQbOkl3f+Cd57WWp5TubAAtFCMeIf3VxKXFL+WqeQuVLu5UE6mDgjzILNxXdkSHsJM49xbVn+wxgvQtiTlI/higYauOBMoEB89QKDjQjfYKU6ZtRv6ALJk85UaPyo1U1r40pnsgd/7h7Y6Kkyzslx9BrQfzNAQPM8cq4Xp1A==',1,1,'',1,1),(586,'2021-05-04 17:31:43','2021-05-04','0000586',1,2,1,'1620167468808050788','',1,'AAURAZO',NULL,NULL,2,'B001-0000563',0,18,'2021-05-04',1,0,0,1,'Jcuo6lu54G7CafTkSWdm++tT2nI=',1,'P2EcR93F6zZavGuMtFpF9kZWW8hhMZiTSCikWhsiiS8XCCkAVFuGQ8FQseJOlTzqbv/mTVdZlp7o\n1llWHKyr/iawulrzICkhwk8pzaJPMnmX+dI+vbLEccRR1Rh6MYmRS4uWbYuCzESvdaymIsYEwBUn\n8MRxmydx0NdI6454znRlczMDvs9EqPlqsalv/sUZjeaJcK7+xcI/aQ01TawyILdOxBIoROAU11wa\nApmrLorNmMVvP7qFg+BD5xDLUM8rMG6m/gZt8ay5AlUJNro36avGZ8r82x8mXmTU2yK3GFltDomj\nlhmqNSHryRcIwdzjCbT5uemwvVAR7AtntMDuCg==',1,1,'',1,1),(587,'2021-05-04 17:32:03','2021-05-04','0000587',1,2,1,'1620167507903495279','',1,'AAURAZO',NULL,NULL,2,'B001-0000564',0,18,'2021-05-04',1,0,0,1,'fnShCv4n2e3Vh7kXCnMhJzefdFo=',1,'TXMCk6ZFAO5waF8S2FkAFVP8l9JUtxsUXuH4YqoBF7fxNfD5T1Lrh62+G6dgOsIm5eUv+YZRlKUI\nQjQoDRFPAwszEI5G3a8zaobW1SlGYH4EypunLmAfxAcm/aVG6r1zDJZLKTc6IMqz0sLFyBZ2Kt8d\nRmlb+RL94AZuoMz9ehw09yRgpdxUQUxyDzLlTOgzgVgBlzDGImzGx4Lnli7U4Xz7kn2HdmLSkPsU\nVOiJUF82yCfhhL8HHMAN4/0L+9JpcRfH5ucLOy9pfurSn7PM407FAqro+/Gdq4OUyDLYjtDUVlRH\n0a2mFTo5LzFV51Rd1vH8907CGHoOyYTeoVZWqQ==',1,1,'',1,1),(588,'2021-05-04 17:40:37','2021-05-04','0000588',1,2,1,'1620167526228025409','',1,'AAURAZO',NULL,NULL,2,'B001-0000565',0,18,'2021-05-04',1,0,0,1,'N3e4geFB11FtLBekReBgbd8JCbQ=',1,'XEq7NzBZOqgkEjehRNM67SY0BbMHOm+lY1XsSv70veM42UOOn+F5GtmfCrnu9OzMBwshV1HQ7x+r+hDZCvEPjGP68ouexaRlV3BtrOjCqLat9JENuOphL7bMOrQqwU5wWdAczvlItOoqHYiykpSmDITZDQAY4LddCWIAIqG8Y1tPJXBbib3dgGI8FIkqydgLSK43dRZsjgnu3T2oXyT2GN7EjWqHvia2ANjyzIstUuQyWrvNY1YvaXtUl+arD0+ui6Pbb1St/3xLdsJL/ZXIRTBedjdXmdznGlZ1JY3ZEQPn6WT1MfXSH2+dWetAA5S1gviH9Go13xqvQp9byb+5jA==',1,1,'',1,1),(589,'2021-05-04 17:40:56','2021-05-04','0000589',1,2,1,'1620168041314002908','',1,'AAURAZO',NULL,NULL,2,'B001-0000566',0,18,'2021-05-04',1,0,0,1,'meAz6klzB5UrxbVo1d6+csgT6PQ=',1,'eJcEjR97kGx9wQjyrFZg0XCj6mTGx4MBCXJ6IR3nJk1QkMFDmHHuHgk3F27pHKRlCwEeehsg/iG3/PJHFXXmVn4bkdzlFYIqN45jLj6micyKr7iuXQDncDP5xTrRAAmbco1QmlnDC7OY7JYscf+GBms+mSPost+OG/lW+GCRg83KuZYVBF/vDurQ4c315hD51LGqeZmAQY0cKYYXUdeWzaqOFJZFSb3xfDJKWSCCHHenEwEsPpyH4yhq9ATJBw7uXDaai0MRKDzwS4OVXKjHo9IQa2jYslHzigrXSAGCh+/sXh7MLSkZG/hItBsa5hN8yxQGKcsrLY/f7XdhyFYBFw==',1,1,'',1,1),(590,'2021-05-04 17:41:38','2021-05-04','0000590',1,2,1,'1620168059365167696','',1,'AAURAZO',NULL,NULL,2,'B001-0000567',0,18,'2021-05-04',1,0,0,1,'R1SIVK4sX3R1rK/an4Gp+PAtakk=',1,'WxXDcaviNzQBDFC1K7jAmm1WcfENC43yPRmmeVn8einZIbCiAa41FT1Z4kEC076cTHtYkjiDApO/cVpljbuOvrZ+oPo/WcKY+leg3UEW70KrJzvgEBfxsofXQwnHrNtl6GaB070AFzAk18/rfTB/jWl1gOiV3xDLHP0iPUpFaCZmUG+PGkg3CIvk+MU5fQeW/V3liYFuCJDhq3PO2rI/OCnlawUCDzzAeZ1RtAHX5rA5oOZDpQCRPjC+0Q2+oD2X8wf3tE/FdflpDFpslt120vHmzGxmyRko8l08O6026PRQfFg8D4eC4zt8PU+1ZLj++qd9ntUONGpZFZsO+Bj8GQ==',1,1,'',1,1),(591,'2021-05-04 17:42:19','2021-05-04','0000591',1,2,1,'1620168101960813612','',1,'AAURAZO',NULL,NULL,2,'B001-0000568',0,18,'2021-05-04',1,0,0,1,'QJndpsedg1qYMivulPtLWFqJJPw=',1,'XYqG6pKaOrhuWNqmD2DaWy+k2ILo6YOiRBj534wDe/afeSsMOhSMHNDoPVL6M4SOXLlVKhBHokNaEx/SP9/217hLHBq/IydconWta0Jwy2eflTEDpKcu1NFJeykFoAPn0F3gE4CkT9Yt/x/7oKjQZR/rQgLB5ed1QnPiQbIbdSGwzHK5mKcvSTBcE7VjWryTFyT194BcXSNuDz9bQ/DBIYqyeONSutYEHMnGgVui1aq1adR7hPC/d3IyplTVq47cgrc8ILWJZmxINOjjyRbi4VBo+r0rAFkTa2pv5ROCrb6yliCa2om0HQq0IcXx4IzjLSi+tTpgGQSdUqtXNmeZuQ==',1,1,'',1,1),(592,'2021-05-04 17:42:48','2021-05-04','0000592',1,2,1,'1620168142687733928','',1,'AAURAZO',NULL,NULL,2,'B001-0000569',0,18,'2021-05-04',1,0,0,1,'9+p/PJI7G5OYNSgyRGJdKevpQZk=',1,'fu3Etmpf7akhf65HSufInvV3YdLmjoxkkl4+GPpozh9L+h8S6Xg2UW1doGETA4a4p9B2LKumFq9qDCUNhQ84QoVSF4DZ6H9H1//zGYfsI/BitBO99MrrNmbDYvRtMU7DraVY7Xmo54bVernZe/XRg79o2nGk6xdD4cf5H4pCWIoiKe20jIUxTBp6lw5AKIkb6myQS4pV+gSZH1SJhtGmV4jwt5ykh+yvgsJY+vGcIEdmbQK6rYd6L68hb4nNID8upx8Mdi6oancaj2Vr5zyzDge2pT26uHjZ2w9OwjHFZ30zxE81C/csO4wWh0YNSv4fWTxG4kmwKLEVWC9uMtwMdA==',1,1,'',1,1),(593,'2021-05-04 17:43:19','2021-05-04','0000593',1,2,1,'16201681711260960286','',1,'AAURAZO',NULL,NULL,2,'B001-0000570',0,18,'2021-05-04',1,0,0,1,'3AeM3ScttQgmRZEj5MINr4JmlCg=',1,'O8/+vcLu4veRh7JapeXaDwdpWGRoOMzuWAPEGiL8DPMO1YfbhWf53MFRAzfyRep5Hzh3FAI49rV1H9108ZxN1NlFfwAUtQDTwW2PeZyPckw4MmFK2uo01KwaztAwLMQa7ufq+GXEckhjiXinhbkBJvfNhwA6UB7h7rEDsfKlF6LtOqe/9OtkBoRKOfGIY2FywTozH8ubedz/pWIYI5EJhx9cpdJX4j2aA492XvGhl8wGC2c+vn7TlALoWsZQOHMVPZ/odsGnct6+t3hga2XUwVd6DhXjtQmtDaLToozHxQi/4zaeoB8kHHACbc/XilqnDD5PybRCx3ZJoOoDCliNxA==',1,1,'',1,1),(594,'2021-05-04 17:53:29','2021-05-04','0000594',1,2,1,'1620168788516553502','',1,'AAURAZO',NULL,NULL,2,'B001-0000571',0,18,'2021-05-04',1,0,0,1,'T2AZp/umOQwSxxzvPVn+akjVfM4=',1,'R1KfgopEaM6tuirA+Lx3NxZmIwNkoI55Jm+XLj0+Zairws6n/3oSksvAmK42yUeozr+5WGJPmkCA1Hnsqmfaf/iAbPt3dcYrQx3bXDZfK1qcIAtw3Y6joymrTJXsFYMcfJzeuygaS0JTUzBEkPmk1n8+YwYwEZNYoohdyFkd+FFu7aP00sCTLPEjmV3YcWZoPL8jkcCKaBSYG+ZC8E32sptunbEdbJKT/t5ab0snYv91zRUVeuLDQW4ntIaViyGVYaK/2WRV4VjSlEtzfMrvDIruJM0sAZeUY+7IO46Gk5p31oTIo12xBsfozdhnw+koGeGEu3GyQHMXXmnJTZbEFw==',1,1,'',1,1),(595,'2021-05-04 17:53:54','2021-05-04','0000595',1,2,1,'1620168812694834172','',1,'AAURAZO',NULL,NULL,2,'B001-0000572',0,18,'2021-05-04',1,0,0,1,'HxGnuLgYDlN+PvYu0gL1bOce8rM=',1,'FGM01IKEy/ishafhdcft8LoOol+tCI8RJi2aVmMXR5zJTYxfDwX8VECsYtDtROfEuAL+w7KaBYBYLw7quVrAevt3Y3SXffJM45FuRvCtzCX6l6SKtsugDF8fZvnF5LfnzZ7tsLrz79MCXNUc9CMWDrDoe+8qKYpXvCdVS96+jjIQyp/qqkS0Pi7Y8NruoOdBZRi69FebFZXXWB/ARGfRsnFGJDrJQLBkWr9lwrs3xPRnk/+dxCLeJzGysliSz/660jR/TvZvqXng5jK3gzs1pqg6avRIZDKDluIndm4Y5NZyM29d4dOojc0b+p2BQqkJNCJ64NKQCbhuax6E8zPOlQ==',1,1,'',1,1),(596,'2021-05-04 17:56:21','2021-05-04','0000596',1,2,1,'1620168961498738345','',1,'AAURAZO',NULL,NULL,2,'B001-0000573',0,18,'2021-05-04',1,0,0,1,'Txsuf7C+Rcb70AqQv9pmjZyCiO4=',1,'CFGuTmxCgTlQ8oirg28WNlewfLjUqbTLHnW21EgxPQzAIIKC67qJQJNUkPYB5O7VlzQWfXFlOPRAtf03CTH8T+b0JAxW+a1K/+Zge3crytFQ8CweCUJL2QedE3RvCciacw2ug8TCHMasl8YnKWcD1I1PQGCdTNbRsWjisftoxjaqsNlcGNLlIr59vxKpTHOd8nT9d4cS8uzRmfGOJQOGu24fp8kfejiNWz24iIApCtYTQ8ECEAK91kGWbwWrVkjzzBlsL0wSmN791f/Kgsm/qKsSupf7Neutlg6HUHLuN/HjZJ2VnrLyLfcNmy9zAo70hqcpR4IwJCYqaTTSguYRqw==',1,1,'',1,1),(597,'2021-05-04 17:58:31','2021-05-04','0000597',1,2,1,'1620169075202292404','',1,'AAURAZO',NULL,NULL,2,'B001-0000574',0,18,'2021-05-04',1,0,0,1,'gkPZ3cna8sJwMv/9HWlrluybyKc=',1,'BKRgGJCEksDbnUFCA6V9NlE2oQwjnq5FlEtWPls73dBvE/f/jeCEard66zjK+4ncuGZZgzU8wJotfRUBQmN+y9iabyNMBjh4Bw0125UD5nNDSSPYuy27TEsd4EYBwxxA16jZRrrRfV9sQwPN3K8wtjo6KWlyrvmlExLrKRbn8xxQvMVfgpuslkKW9LXQ4juri0r211k6pW5uUu9Bld0Jz2b3wTdKD3Z7OZpB5iWItumdt6WC435oIgPPKYANJreXfSXLFJ+X3fNdCG7gAKH33PqIURLX1EDdGB+ozr9+wzj0vS4zOutAZdoFb0sP/+EgIQbjsJIOZfKoptQ5UBqMbg==',1,1,'',1,1),(598,'2021-05-04 18:00:40','2021-05-04','0000598',1,2,1,'1620169204576195551','',1,'AAURAZO',NULL,NULL,2,'B001-0000575',0,18,'2021-05-04',1,0,0,1,'jbb7ASeYUHivSUQU4jtzvgAmZ8I=',1,'iC1sYRuLB2J0W+tZSSwvqudGbuZPF0mbSIKDT2F/vaPfGRT6ZH2rUcgucm9B5SsJCCDL3lmc38tKcI1JcWj6jkHAy54/hsdVWrjsLm3wO7lRiTxnUPW72nuomyC9puzjvUCiOLWqtRdi9qaFRV8ebfUd9O0dnMTbMCOmcCgL3SDYhgjpB2jx1KM5QI90AkgkBB9fRHWWYBjPmYuKbmtypwlwmZ2qZa9DwVZxT60dsqfrPF8QLDx+WYsR22KyCq+/C+grhrh1E4hL0nMUMwRhlOQS+Cgw0agh9P8LTkZJlJzWykxYjRUqbq99Fkt01biIaVbyfcyxrGoYLUW6ocK3aQ==',1,1,'',1,1),(599,'2021-05-04 18:01:30','2021-05-04','0000599',1,2,1,'16201692421314750012','',1,'AAURAZO',NULL,NULL,2,'B001-0000576',0,18,'2021-05-04',1,0,0,1,'ECxngXp+mdzhjvqsWNvmWtSuIPk=',1,'YW7d6JrcKoWEMCiJrSN4OXQv9vOa60iDrtNWfl0JHXXcVXSk4vYfdhRgddGedKpgPI5liulg0LTdP1sg38WmbSnyu6Bt71TLxkq4nSPYO/Nii1KluoSAQfCS7YeiA2o8jFKWxxRgJUk1x2sEtTryU/kPEcEiY+M6fCgZf8f6tmlwTc/cg+/RZZduYIiUngmNASZYAqrNlE2aqqYrssnpUecdwB67LjU1Ic/thFLgofCJGt/NgDFOIK9Aut14IcO7Mkf/JCAOczotYSykwAqA+ypy4EmoRhvQ5fL3i3o47BmBMPvjG3Yj19CngVJNdmD6L0XmZHNz/OyBs//C7lyCMw==',1,1,'',1,1),(600,'2021-05-04 18:01:57','2021-05-04','0000600',1,2,1,'16201692931178941711','',1,'AAURAZO',NULL,NULL,2,'B001-0000577',0,18,'2021-05-04',1,0,0,1,'xKjHHPsQDA8qLxEyvfyAcziAHWE=',1,'LQWl4CWZiGG2zfwyX4zAEkcHV1YFtXPP4g6Pss4n8fBD2j01xu0WDoHnVgD/c9C9X5cC/cwJgaWD2m+nJtwNlxCP2m6BPvu8Ubxg4GfsAwfLxNDiW35FFBXcg7+lQqHV5SDw2DqBondu7ENt0OGB/oCIuq42j2hCSJt2zN+jES8me+yReYmlFc30aSXqfmGho7b9wfIxR55rDPkaF17X1+4xkmhED/Ad9bNpL79rTx0S1T3dPwhJg+IiYX3GuJvXw+62C9APYLrxlU7skeOrlcAVxErgEGAq+ivk153zsWnmn/zhcbys0yEYgnK2xVSeyEU1zpEkrNyIIy34J8NZ4Q==',1,1,'',1,1),(601,'2021-05-04 18:14:13','2021-05-04','0000601',1,2,1,'1620170034495855215','',1,'AAURAZO',NULL,NULL,2,'B001-0000578',0,18,'2021-05-04',1,0,0,1,'mlaU0qEmiYTKlzI7L9ohX+9BZow=',1,'AMGuvh3vxuLN7FLjARrpxkNTF6/xgOmFOQOXrW7WvP1c0lo0iafi+8u/xq+wIg5REBkm8i9kOtti0XUZKPeXgfFfVMF8sHafLJ0gK+uiEGAdkEOtPWJ86IDvk9eN1p5WDibWIchvWZ/UXB8Og18tgZVm16bOp9PxX8rW/CU5sMgmozi+jxp05NIMNMROUas5J+36vL+LodoMkyCvbDH4UjUDSQuAgrf8JEUL4sA+4b+fQe5woOmwBl/x7QH4FoB06tvoP+xqi9CAQfGxmhP+9ZrxV1uwY6sAo3WjR7mtW5jx5KmtTtPOZu84EXHXranjPbVOBXCEUvui4K9D71Iezw==',1,1,'',1,1),(602,'2021-05-11 18:47:41','2021-05-11','0000602',1538,2,1,'1620776551608899705','',1,'AAURAZO',NULL,NULL,3,'F001-0000024',0,18,'2021-05-11',1,0,0,1,'dTyrHyUJcnO5WYNmrl+TnAPY964=',1,'Hh4WyNqIEaQCrgvFGxRbAtpo/WTVukNqOVGwksR28k0vq9eqPT6874WnSqie8AwBjhMMzVafAcnc\noT+1SwSZ03oBk0YD5XgjXqJ0S4dqplJHf4SR1YF5pMC/2dKt91mRNq39hFDgQ7u5dVRqGkYTVg7x\nVRcc1O3tnHEvzfEaXPZj9pZHq3q8lgDV+yam+QYSMasiCUptuz3GrnMs01RxgUFkIS8Gc6UNVEqX\nIyvB3FEE/q44Wc+nGMq2gOK1jmGQArwRcDDohk+iH2J0Lijdo3VU19GPW4Gi2JgFrzasUQTpgbnh\ny+AwFbq+EQqBbkFtp/vtmDklbe/Wp9wfRDLy1w==',1,1,'',1,1),(603,'2021-05-11 18:55:48','2021-05-11','0000603',1,2,1,'1620777326651974518','',1,'AAURAZO',NULL,NULL,2,'B001-0000579',0,18,'2021-05-11',1,0,0,1,'rtVckOQtWyCDfiPPqUk17yZnAJ0=',1,'F9Bba0RA90Bb2GzYISoVNjHQrtvJCvbAeqn1n2UgwluZKYGEY6mu0K/vs2/3giFsM7PtuOw2w/nqGMrCbFdJwLT0ddP2PSoBVl56OwAyx1TEwHvAeuJAHInNsAt2G7xROw5cK9kRQdUGVYBoIU4ZWmLeGLz/Bm+aQ/Gz+O1+V5eFl8pDtRpgu7Jqq8ipHsVs6W++crDeYlOkBFHC47KI3ugCiguK9RPhr6KfDwGmxDu0AhDKrv+6rHwRDk4IMatoe5zbuiKfZbFFiy7WhQfr+a+NvBvop49wU/FdDyws/ipnQx7acwpzXtTDotHuOCNafJEo1vzDYjgQ0TYsGUGJfw==',1,1,'',1,1),(604,'2021-05-11 18:56:11','2021-05-11','0000604',1,2,1,'162077735145183371','',1,'AAURAZO',NULL,NULL,2,'B001-0000580',0,18,'2021-05-11',1,0,0,1,'ZddS6qP7Mi2vAp3guXuPIjK/N5A=',1,'ashEZi3Z07J6NZYAPYggKFzmnQfYVPCPvCGcgbqJWEUNt7bid1qOMsytceYyGinBAak03q0S7hQN9LctdnRneq974VH/rw/4qhq93mOAPDdUVaDqHknPRG0bUWNyH6Cmjy4ELMmrw8utn3gQehC+63wrtATZph8dWUgKgNWqofrf3FOS3dTIASM/HS9yWwdSC/uN12X4UNJ2G88lo4zCN3OMMJM9poMM8tqhnU3bpNijFxPZFOLeXLA3NIdpDIqeI/FmMQXMTV5cRO0ISOfCmLBnLlQ0vcHJVqj5DpKixDOB/1Vz+SD+YNQDEzGW+z8wwoZEx+cn00BemiXRnlRsDA==',1,1,'',1,1),(605,'2021-05-11 18:56:35','2021-05-11','0000605',1,2,1,'1620777373421410234','',1,'AAURAZO',NULL,NULL,2,'B001-0000581',0,18,'2021-05-11',1,0,0,1,'87Wz8RfrzOcZYAm/J0M/bJwBRIY=',1,'Yvb1vUVuMj3MrxLdpXW3xIvg2JtQXR8uBpTBriMTT8du+/bUhPD1Lubr5ZnttyTQm+/XdZuZ1zG3PD8RbzDzbYyvf3m2qA/DRWg2019vspWvQ3NpqMIinILCR9pYq4/PAclKb45LgOQhXTp+Fsn2vcrmVrh9aUmxwkHRddLejoRrN/nZtk7QepDwYaQwIPdLb+pKON6grBkxIPWovnl1Pz4bXQGUycPQ/SwgW4GOSDfsJuaUn0alM3YUSvbvt8U9VPdFQjgxJI32DsBOZlf085eMAbMIxsqG862a5SFQ1x3iZkyPOwnDXkLXVOgrkJqmWh19tZrLhXXOd4fvjWtPkg==',1,1,'',1,1),(606,'2021-05-11 18:56:52','2021-05-11','0000606',1,2,1,'16207773991231913833','',1,'AAURAZO',NULL,NULL,2,'B001-0000582',0,18,'2021-05-11',1,0,0,1,'1ZSNz2c+2NySVGl3eN+4Y6vUGXs=',1,'RKm9tnWzhsZF4y/Z/gLoKeYdq5BS2rAqHeUE8hZXX5qqIOhp86M/nuRH2ZLKFmsAjqYwN8GWY0f9BESU7mMaBme1Js+MxArFUSCodTjYY4BkMa9WeKKk3Qp8q3bcz5lrP8oK1qhWWBksujiK1jidDVH5+wvuO7FtJPpZr/qb1Z3RJOQtDygmvPFNOUtzn7D4Zk9VWT0I097ICM4ni9oUfWnf6Gm9HNXqpwOlwxIYfgckvgOKmBwv7nLgDsoLx/ugn7cTaw62ozB5cVpERIfDuV4YtKWaBNsGev2QP2BuKHXewbqYJ9F0kIC+f2lNHR+R5QJfV6DdNTHTs8/Kv61eFA==',1,1,'',1,1),(607,'2021-05-11 18:57:22','2021-05-11','0000607',1,2,1,'16207774151043348568','',1,'AAURAZO',NULL,NULL,2,'B001-0000583',0,18,'2021-05-11',1,0,0,1,'4s9Cn2YaO+son/AFByfPrmZvLJs=',1,'IdgxWvzq3r3XeiOCcbcjsbenCQbcOweit9Se9rmpY88ZyTRg8Q8QH5dBHar8i2hrLNaBYpHYZwtmmTc1aDXAJc0876fUjlBvu3XtcEQzRF6iSdzzSNFcckiKi9F1NXXeDL36OAY2SSRKtHvxPywD4tNsdceqrKM3sFKPjqdo10p0yHcV4L1Cr+uJZAr+VRowyT54yaXhyXDWCuulIeXHCHo6nqsPhcLC76+OdLsbgH5Jcyw2WDPZZNcdgkr6dQLgEqwF6lmPbYbvMRXjfwi7EzR+sAM9AtBmAk1W3S8ysWOxqsf1GxhM2QafioymNM5HNU2Qq+mz9d12OjEdIgo3hg==',1,1,'',1,1),(608,'2021-05-11 18:57:49','2021-05-11','0000608',1,2,1,'16207774451154069341','',1,'AAURAZO',NULL,NULL,2,'B001-0000584',0,18,'2021-05-11',1,0,0,1,'vqH+5WaFaRbAhIQRUGwR7tcVlv0=',1,'EU8LUisDuCUFA3TiJ3zTn15kjPT+0CAX0YKHgx2u8t4VhLi3wiYV+jOxX9ZbFz6LILT3i0Jes6+PP9eqDDwleBeAl2YnxxV3jcV6ioO/+fxSjKqvns1PX2AycTr2VYMGircA/eHfhO5k+Qcs7IvIB2r1OgAY+vW3cRfqy6xcA686G/UCdTk48PG3kkIWSDwUJ5pGwg5p+poPtNiFEqkFfgPRqOFWYTRP51n5LSzol45+Ed7E7TmrhoRsyjBE2s9rHSEJrxotjimlTDtI0G9XvgSRDUsedcKSksjfUz3tN0B3ucjYYJpPzvneoE+n4vGsevbhIBaUzGrOK7DKX0SyUA==',1,1,'',1,1),(609,'2021-05-11 18:58:21','2021-05-11','0000609',1,2,1,'1620777472972991606','',1,'AAURAZO',NULL,NULL,2,'B001-0000585',0,18,'2021-05-11',1,0,0,1,'4oO3cxz9RHMZGM6wNX2utnB71c0=',1,'Ip5eKvWQOUWVECw5N7kiXx/87wpHouRFzdk9A7I0z/6Uarf1bYJlHj4Fj5nXP4f49ZckmkirHjEFyaPk9AUX1VTkqXURE+B5y8IFfxldHphcjMJ34VPdspAv6yWswuBVcoawxrhuTHOilyo5eoW/KPMoAzwhqh+2DRCaT94ZHZ5TJgBb9fFcBhME1IjXdSOyp435jALcpgGBmG3Z/kL4xF9O/FbDY0MeiaLFp1YNB+pMfltr+eHWxEQiqbSkQ+N2eWnl4UaDvsW/MLnPmrQgbGiSprkRtBzDnBgLoQfGfx0qODvYcEW9rARHLfb3ZT7E7h2DGFhsoD0TsqwWl1oNTg==',1,1,'',1,1),(610,'2021-05-11 18:58:50','2021-05-11','0000610',1,2,1,'16207775031208934862','',1,'AAURAZO',NULL,NULL,2,'B001-0000586',0,18,'2021-05-11',1,0,0,1,'ZqQlOBCmYA4xXA9K918XADHrIOY=',1,'DxZZyLc8wMKOVEcxPcRcTgmCNkqLgfOrhvsNAtDhOsWPlSoOHfQkQ8eSIIK8QZHpB4zH6ixmhjyixWGnXFV9oeuYmdWwRJ2eDKwARFUUwNY24GfQChvLxzUHk0LDKR8/F2TdeeZqxaLlU024Qhdn67LzVm6+UNNPib8W/y569N20ou965aHPvoHfDoGnYQMK2CLIPGEEitYL0YU+sSddtIlX4WlpYCmqOkL9TpOH1WrhnbBPw3OtMAk77LhacnjMo9mnFKd2pytInRLHGEVllc9WT1JOs0JmK1IIUS8vij46v2sFIB6pT4y6NRORX105sBJQtav7mxCgBbGMCyA1KQ==',1,1,'',1,1),(611,'2021-05-11 18:59:15','2021-05-11','0000611',1,2,1,'1620777533784426340','',1,'AAURAZO',NULL,NULL,2,'B001-0000587',0,18,'2021-05-11',1,0,0,1,'jg9/t+lVGOfC0mtKUn8/pFQb5Z4=',1,'KNY17th7l2d/XHdczBYt6wuwr4yyEun/DAwApQWsq0pktoWOeBhnRESVfNR1t7MCoQhBy2hXNKWQ5UXv2ig3cKCv+qraZzTFvQX+OP92z/NVlbBWahyJ/d+ShUs2D1LdlLWJHR4Qq3gwXaPhY9CWvFGMoos2SUccbq43JCsjn1W/QNTaaooovvVvQjvbGTdGRZgdnKrj0o6IVDq1JyX0rdn8trKNrG7Bdg6F4IT7iXX1BLCIAJ1c/dbyYME8MYnK49J1aNv45xbHOT/hFt4QFh4cha26V89KTERsl6/8Jiqw/NytXC0gWnSNvGSphg4BxNTXnNnYuMOt+T1eCMS6MA==',1,1,'',1,1),(612,'2021-05-11 18:59:48','2021-05-11','0000612',1,2,1,'16207775581193529484','',1,'AAURAZO',NULL,NULL,2,'B001-0000588',0,18,'2021-05-11',1,0,0,1,'eGrm3sbvRc7Cp6hUNhG3IUGOu2o=',1,'i7Ln3EINyGnoEyPpuVXU1T5wVpTY2J9z6AWBZ/fi/3JXAMUvoWNKuFxDhvBWrAJUs/FWpSHEIidzOccMbg/Ek05Yw4pAAzQPa0RNguJK2klg1qhC9p5Scq0jJdfSvY2DiMoN5oaj7NI4tlVQsWR/VImg52Wi3q4VMl55Hq4CqMBa855JX7uo3X8hLP7kJog/XK9Tseju/TFN8Yk7F3itwhGHdp+VlH8hnAtGabul4T/pI2ApF3UOyWiVwkzuAtGkhxD8WwRi7bPpFLRGtAt/+3Rh8o1ATkxWggFEX8IrqyqbO43Dbcrsv2GbRNJYF8zfvwXErrmwPslzjiQyR4cqVw==',1,1,'',1,1),(613,'2021-05-11 19:00:12','2021-05-11','0000613',1,2,1,'1620777590687733928','',1,'AAURAZO',NULL,NULL,2,'B001-0000589',0,18,'2021-05-11',1,0,0,1,'o5MlV8hY636tjmEAq4dsp3DPFtg=',1,'JHV1IBGlII0dKqX6BDbAmszLbTw4dZfiXxteD97FUxHlEyW0J96Vzg/hQytNj8ZG1mxu98aVLkCiWmHYuF+TdYwNlo2rAZePbgXfDxfBzhMxrFJrLM6f8uUSPTe/zM8h2I1NmoB8mzJ5eX6xnPCHyY0Xv7GUDX1QaHVxIfMRm/A5rok9GdMKKeGt8F2HNtRdIKiUOhmxz7KKrwu8kxdock8f4UpOrfJ+Nv0XKZm5scrpkBs8Ngk8FinYYn7GQL121yZiLZZnWNfrZbtgNdc6aC83bjyBRfMJPUZs/j2dA+Z0XM3RwNu/6dl6MeI0jWe+KkJXDIl+cYIz+bb4E2NpwQ==',1,1,'',1,1),(614,'2021-05-11 19:00:37','2021-05-11','0000614',1,2,1,'1620777615804823405','',1,'AAURAZO',NULL,NULL,2,'B001-0000590',0,18,'2021-05-11',1,0,0,1,'dy8vuhFcNjmnxa2XEBjgcKiXcCg=',1,'XwnoNKx/HFwinajbo/HJ+7C5y1SpLW/MSAud5Kg/3qygjf5LM6I5JmcQnRFBq07t9Mq/PAuz5056fI2Nj0Bd+9k9i0VjtYJhVx+d8HYR/LNKPP/Gr4Z/e/XqS/317xCzfkV0rDYoj5hkcofPv4ZykydIXNBaOerTFs2wMnJjl4rqtSFaQMSUBsGXeRSHwpRIkOiQmSIFJ8IDhQs+ggC9Jg9c4OHsy1xGyAxR7Tggzj+ktYErjOUCHXvUZKHPL93Kz/sB3t+FguqXg28bQq4ap8I8Yg5XUl+1Ia+GbSAHwT9OzP2cLBvyduxT8xUsJyKBQtfw+yaoTyYy41pRXrV1SA==',1,1,'',1,1),(615,'2021-05-11 19:01:07','2021-05-11','0000615',1,2,1,'1620777639919589165','',1,'AAURAZO',NULL,NULL,2,'B001-0000591',0,18,'2021-05-11',1,0,0,1,'L7R2d/sYvl7dxRJz/unGaHZfG2c=',1,'QApSiV20sX1mBxNyzvKI5J+ZBHy0UiaQ4Nq0GtYSg32Al5F6bR4fmI9/6C0D6fov4+uwrCrodrmjbJqAsVmUHk7pC4gZLDrlMT6YCtDyJx7XgMHJWrh5hKMf/ny9moTKZazRjhuKIYZ6P+CKuc2+HQTgmNZ6VB9Yw1OcwfwEzMkcyzbXnXDuVyDE3vdhOqLqbxF66Ozn/ZRX8zSGGpwnuCxzjgCTdJFy/7bDfPzM0vyIF/FovnYjpzB4QRxujZcgE2Fx6pYVJM/Jwevp8IlwnYevtdCnhHAYK/U8sSos4//r4CcHUKoG6HW4k1JXZF2WI+8ve48My6fPCrk1awNkfg==',1,1,'',1,1),(616,'2021-05-11 19:01:32','2021-05-11','0000616',1,2,1,'162077766961707575','',1,'AAURAZO',NULL,NULL,2,'B001-0000592',0,18,'2021-05-11',1,0,0,1,'0drdlGrCIRd5w6Hw7i41rGfxLXk=',1,'VDI0esxDco1UMOi7lKkS1UzA05ge2s9fDBj/JvWK1UqaKJLlNPr5UTEweO7Nw2YMsF2IoeK09EFbF1XOC6edRz28VL+xOO+Qe5KrGXFflQxcQKc4gGbl/i+ATfx6AUYumbdcXhY6SvRK343ammrRUMVyyizmFCRa1o8a4mAiS2NZQklTbKCnkpEZEAN17b0g6gJE+jz2V4TxwcoBc4Z6Y7k5x2cUNw0C9rt/t8wNG7eut6z45YLpodhuJCFs5KtsRWzuB8z1TjCUZnPBWCsDf81+p0muN1DIr/4y6nM/d8C+wMCIePoHOYk3WZpKHclGgPoddf8962ZenYHqzRoqZQ==',1,1,'',1,1),(617,'2021-05-21 19:01:15','2021-05-21','0000617',1,2,1,'1621641660874147604','',1,'AAURAZO',NULL,NULL,2,'B001-0000593',0,18,'2021-05-21',1,0,0,1,'QEL31UXvL7RI6CvoM0kbMIWr2jw=',1,'BuM2QO8ByJBl1/yflLu3a/4UE9An7wFH17UxLHh2mSgCu39up3OrUDFeoAOKFHEzdTGFHW7nknxd\nw9Ze/UmH36Lco8DiD6ZMajVW7tqDaiLNmHcYpIrYQ5RAnf1/0i3NDNmNYxdbGG8YUY8H1dCiNOYB\nYkZUY6YTQ+6b7Pp426t6jWHdQprCGqCaHuXiFZH/sUET7nONUgEb1pEzqPSDC1AXpEOP5/gGdy4f\nTzxtKs2j1FcUG8IpdYPxjahBlzed45p3JNML6X7KZ8jG058Mp8zg2a5dXaK3MC/2sv2dxWs7PlFp\npC0r8TtjHT8sH2As3GytEcJEMnHK8jHjP0jw6A==',1,1,'',1,1),(618,'2021-05-21 19:01:39','2021-05-21','0000618',1,2,1,'1621641678997003340','',1,'AAURAZO',NULL,NULL,2,'B001-0000594',0,18,'2021-05-21',1,0,0,1,'QRSMIYdOUm7Tfa5HTIaKqeORvF8=',1,'jXBCgcAZqkCuH1QLFw/suNH9jlNTDfAy/jQPz2TJ6Z609CPgKzMhPvOZdDO8wXDTwdmMLRYfv5ec\nqntuqlfA5dZjmK5jtYFTriX4f/4IEOWYHPOZ3hA1geitVaC9I9YgbhJv0My+B7dPE5r0mHcnqn4q\nW2E9ayXXA6Gs0LJKlL9Xpf30VCG/nCeeedueT2wkNB7zgXIQmdKp9l06LsoAYglJtP9KO5LhS4Xm\nlbvvomRvC18g8GTbeONjLsgBh3AoThlNugHFI1dDmcjZIVCnLWg+/XK9B/1LQu7hMYmYhwLfpaoN\nuFdO6Vo4o0R6dd2QEa8AoT6zvpDJYStrPIYiAw==',1,1,'',1,1),(619,'2021-05-21 19:02:17','2021-05-21','0000619',1,2,1,'1621641702336422466','',1,'AAURAZO',NULL,NULL,2,'B001-0000595',0,18,'2021-05-21',1,0,0,1,'gm4BWdCtD5j70CkvqWRnF/Dzd1E=',1,'iTLGRARWWCww0ewVNd/RwwzmiTJaNtV/R7uBrupNrcoWXdHevxfJuTlEodbCf6Fwb12yq25WrBsVw/4xWiHJdYndWlAVVdvA6rK7JtDhHZt0oTTh2WglpM1CbPGssB7f3dilcYRv1sLIt2bZpNlTqEJo+ysO3k3NDod1oJhkR9wjDJU6iPVCmhaEZScC4bdKnNYqW5xtcVhH7WoD8OVAhVjPgL3SqMDdJU5cizG95zIXtxNMrV6giVvSY3xYXJTfyAneLvEN7vRy0rqkHBf4CyOJZ2cwjTHFvZP8oSiSigZgeAyAbmTjNm66RsmVbFk8lqmeu9kchjs+ZoM4fsN+FQ==',1,1,'',1,1),(620,'2021-05-21 19:02:41','2021-05-21','0000620',1,2,1,'1621641740559886506','',1,'AAURAZO',NULL,NULL,2,'B001-0000596',0,18,'2021-05-21',1,0,0,1,'4Bo17BEdoE3bbo1ECQqeZ7hZxt4=',1,'Fi5g93v8601nONqqiGoCFwmClP5srw+Ci/lbmbWY/UbkTgthuKpsD6y5diJdczQw29C0sg4U6LAYqTi+EumXESyogpBdb/aQjAnkTpsMDPNHROHu4TVoiaoBeAMoohl/C0npWc03G8DgKhuyetSpMKwaLIjrvWLRrKFPbX9zX5C3NCFdXfJMzIlrAHlNDGbIWQmcvCeG6tJCsYa4mfYGk7w6RI6lywslPbYnj1Fi0C9CtMYjMGVYo3BZ5ja3DERLH0fn3QsW93LG8Sp0neFaoPsy9u1FiEDTZLUsYAvTs5G2kuA5b1DcTJ5hjx3DVcJPH9beHW936E7TSGSq0yECfA==',1,1,'',1,1),(621,'2021-05-21 19:03:18','2021-05-21','0000621',1,2,1,'1621641764229316363','',1,'AAURAZO',NULL,NULL,2,'B001-0000597',0,18,'2021-05-21',1,0,0,1,'zhedFgrg1oW5vt//MBOAdq2yPp4=',1,'Cg6NC2MQEseIzSxHW06Lpj0UM5aW214VeypQBnG4HzPL7w+AneEvGlYMuYZh6x4OnRqp0tM/SCqa1fU2RBP2z4vUhfyy/GgDgYiJONTm3ArNvRP9sqI3CwRttuTchiMyuQwuf+4mBPRROk0j+YBsJwUeqtqSOcrSuRtANzaK2EOl3xZdnmQC4gmMbPjJvJA0WmP1mZeVygSve6qpHlRUmPR/XTSjSlOXUJPPzJrVmd41QCi5Z6scbPtwjTp5xdmUnSTmEXCAvNwRovrty1v/0qrxzYmI3tAR545/RkZw+gF+1uDpXrwKw9MXI3S8ihZJyMTrX1Ek+7188nfTLeEMNA==',1,1,'',1,1),(622,'2021-05-21 19:04:07','2021-05-21','0000622',1,2,1,'16216418001009525588','',1,'AAURAZO',NULL,NULL,2,'B001-0000598',0,18,'2021-05-21',1,0,0,1,'v+NH9W6+I7Bqk9dFYsB+zaak8oQ=',1,'DvhpdYAbARCfMCDnvffmkjwER4qvxU8IQMgAmc6QABEBP6DyptNYuY5ESKJ27Jvf54N1Z+j2QW8uMmCNAu5XoFLgXBzRO+LXPVT202uR2Tbhg13TWXYWNRpdYMQXbgJNG2/la5Z0DLAB4Kz9jCeKbSTY/5XtyCcHzOWZ9mWcD0gtvemE6yLENVhEEGj3MhrZogyRGRzvpfXJtFfIqj/G1vH3z/xFMnYTFtmi2YZY+GOlEaKc7jThPKTZV9HnkTvJmhUlg3A1UbsPYbT8T4uKf1GJ4EOyoP7gbZmo3jzhODRLhVUuoewew6hiWSCaSyPBp8o+dXVFO904r29fSP0tZQ==',1,1,'',1,1),(623,'2021-05-21 19:04:39','2021-05-21','0000623',1,2,1,'1621641852671769137','',1,'AAURAZO',NULL,NULL,2,'B001-0000599',0,18,'2021-05-21',1,0,0,1,'R/LNk0YwynxgaqY67GnbVzlRcDo=',1,'RRxvQ8Tv99p8BNzigtQuy2Uv6BGNY6zu4WuAM04r7ZwWyzNf/ibG4HIjTUvJzcIzrGE7fPRBNA00udOFSh+p2Zax4bBQZMr2wxu5qRnFU0sc7nHEL81glWZCD6sh5THhmluk5Dwtbh08HvVG6S6ahhHKEm8CUN0GitAyHn0Zf1YnR33D+mOOqeA0oFD+bd5jR1CwpTIHKzD1ae+gdenQAdCJpcshtFs08vHIM/YKw0Ycrf1dFUBQrLJ7biDuO51/Cz7E9R6nV8xIWLQoZwefMFivXZRe5z8ocvi90l/4JTJX8x6+8bec/++ifwu4M3/l4VvvedKQBC/3X/oOkZqzjQ==',1,1,'',1,1),(624,'2021-05-21 19:05:01','2021-05-21','0000624',1,2,1,'1621641883364565251','',1,'AAURAZO',NULL,NULL,2,'B001-0000600',0,18,'2021-05-21',1,0,0,1,'lpxeVQjmcchwvjyWfJbs2twxrh0=',1,'NglxxnMYylbm8Dn0q29UktmezdY1UHwJY0muIDfL1Y1TjKKhPDDB0ZDf8XVcpLzzl9NeDRGCJZySUpB7R7D47se8dI17pMew8299aMXz/sC6uBq55WU9cFJzmY6jadz6R45L2OYxZskW4JTXjClWmwqEPmtG+hdSKbiRN87p+K8S8kCNLXdthcy1izEws+pa3lxYwGXQdtBr8WDeam8i4CQotxj9cuEFUgei05V9F+YK3cGyKxhRf7N4EmXf9phoIMR1er+S57LZT043+IJ0ujp7W7O0xuEeEW8cl49U3xRwY6lqWDULdteRX6XKYluAkCLz0KSginQfu2MMcJvusw==',1,1,'',1,1),(625,'2021-05-21 19:05:26','2021-05-21','0000625',1,2,1,'1621641903123759403','',1,'AAURAZO',NULL,NULL,2,'B001-0000601',0,18,'2021-05-21',1,0,0,1,'FvnZFGUFiqVEbwbJGuqaTKcwR3s=',1,'R9o+DPu1FWoyiHYQPZO6sO+F78EfnUpDCDyAP6GKJlJk5jawOXjLHgSfSYML0s+ZIXKnsWNFniIIV4MEQH8wo5gDDRVAiYv2k6PeiH8mnWir0WIWT0FhJDqLyTiPjzk7x+wKGzeD1U75C5Vndx3ctlgnCyOe5WQAa+h9XxoJXjHoQhkT5CKKTpmgj0omivCRsg8CkozLcEmtf7RnEfHvpPLZ1UrSMUBKWEL7IphHstjsqnWvAc+t3UKFquF04EPDRFhyknM5xvxzpoklWYtUhxmHLKsBKUzQX49v4kYu5c1WLglFnL3HIh510j7bcNhENYyGyw2jaBU/w41T3jfOaQ==',1,1,'',1,1),(626,'2021-05-21 19:08:59','2021-05-21','0000626',1,2,1,'1621642119713509965','',1,'AAURAZO',NULL,NULL,2,'B001-0000602',0,18,'2021-05-21',1,0,0,1,'W6IJhTsHtfXKkjyZouVYGwV2+m4=',1,'QZsIfkbfjlYZWdmVL+1szmkvZdFXhFy1dO1dDy1xSYVMTkeACOD4FOluFs8Gue+A7ZhzecrYf95RilYAwNbWCFFaz7U7m9wa9+hWrQ1U51+E7fO1kuajK8mMcX/miXk5JAkODu6JXUsTMa7lPMGAc3VKMFk6XgJY2mgQz85aeRRkG6nhow2pJCWxagtDiZKjuzIZ5c3DH/GiOoUJNocVIPTdZb4GaITJGoHnT+XBheLjb1kkoAiKDR19956i+dZN5IqFwMkUjgq7wK4+3PnSBfrytVjUZslX/+d23fBJv/RroDYoFCbKV8T97U6c0rwuUw2XW2hLhPJ0CCxbeAjb1g==',1,1,'',1,1),(627,'2021-05-21 19:09:28','2021-05-21','0000627',1,2,1,'1621642142816312890','',1,'AAURAZO',NULL,NULL,2,'B001-0000603',0,18,'2021-05-21',1,0,0,1,'xYjd5iK1wklLbzjnYIZzGkJ0p00=',1,'bKwJfn87H/kaGtFPMQEDN++UhNxYp9pVDi5qMC6kWP6enb9VxkncNcNueEPI5HnUFAvOu+8XKQKW4jyodm5bDRP3oG5Ypjda6LeTTW/zz/hIheP21nXprjx0RG5lKl+BorfxYrW1zbHPKjOkBbWErZI95smIwCiUCpztFRO0S80k58yQwFDVc0t4tB92fGuXk/H17XRlVp3o3YXufPQb7/7W62zxyKsxAun6L6olFBfYqc/cwOt3PhtZe/mBgrz0mg6e/tX/BzkQbqwIaa53638046I0y5p1gZu0KmO5EzMmzoharmMUSwLdB3jJb8CYS3TS12SiVp5ZrPgtQfHEKg==',1,1,'',1,1),(628,'2021-05-21 19:09:49','2021-05-21','0000628',1,2,1,'1621642170399377962','',1,'AAURAZO',NULL,NULL,2,'B001-0000604',0,18,'2021-05-21',1,0,0,1,'c3Intvq1EHw67yffQaOipMJiAcY=',1,'cr/XbW8YZOHZ0TSiPC44iVPv9jbTSPMOny7Jmsf7+YFtTUG0auVwmHTSVBRjv0Plxwzq81tUyy6TPkR8Z3v29yho74ZhlkuDcKcP70615h8eN9PULXTP4LPfdKzGwYiFEUBEY650faMNEnmLxphGS3zfHO92oN0WQTzdyH3yH2wh82MvGkYLHz9J0xMmPV+hXBiin6xGTE512gmNQcw0JtTf2n4EiRgXT2pCZbqy+WocoHGRz6wEGCpSCddqgydD8FwumqB0VF8NYf61p3sLKgZ+ZPe0uM/uras4xJSauiAGdP9y2Mb390bdSLenwdyW07/QIPbO70oHhlrf/JgOTw==',1,1,'',1,1),(629,'2021-05-21 19:11:37','2021-05-21','0000629',1,2,1,'1621642192504977953','',1,'AAURAZO',NULL,NULL,2,'B001-0000605',0,18,'2021-05-21',1,0,0,1,'NJjS1kZMx1mfcZoNAVXn+YN9DbI=',1,'V1aya10QyCY90TQ7F4EKcweAEEdar5VHwYoZzDad2urC98CAr8g2h4Sko8mw3nxtDVLGch3VJOpxP6+4EvtSrY7KxKe+vxRA3y9tyEOJEsF6kyLTVZzzxMBuSaZhFEKOw8umGFp88IMbTrOZjuuE3rZiwjSh0iv7muKD3yOupWSZVhsOzN/P/6oUwiNEGq3qr2HTxkOmaspu39iCwM41pQHEbg1phmUVoWOVTGYw2CmrQc76McutO5rDD2r6OMwfLBCG+Ol3wRSTiPbMs2qX7A7GKo5bHLLFuqq8I5VS+9mOtYrRu+CcrjOfFXzeHAy3txhCJTLxzCaBxioyxDeGTg==',1,1,'',1,1),(630,'2021-05-21 19:12:04','2021-05-21','0000630',1,2,1,'16216423001287596958','',1,'AAURAZO',NULL,NULL,2,'B001-0000606',0,18,'2021-05-21',1,0,0,1,'dduoCEENbO5jpJQv61VeBxsWTQg=',1,'jgD+0wGDfm9avlhV39fPFjCdjCiAElR6I+OujIfQEkgt7iHD/+lKfLk/qxw86qHwJEry4Tq/s3AVwUSHfRzbjdDEWySuSxeS6BwiAgsuOQ3cM8xU7ncuZQZ6LVZLjU8PInXucbX96URhUqw0kJWPe98S6eKQDVyM2Vx9e5DNsieYhvOEVtNX5Dgq1uY18InTCRt1C4zXTkD5SGYEvZMZnoygVMyFqZFUppjPgG5pgt5Ly428Ho04oP03gRM5KhJ8cLxjv9813MPFFXGvDtaBHr6Vxc2O/10oWjOMD1gcN4GVw2351y46xv4M6p16UL1eQ8O5s+7/1MnJys5yGO48Gg==',1,1,'',1,1),(631,'2021-05-21 19:12:30','2021-05-21','0000631',1,2,1,'1621642332886239535','',1,'AAURAZO',NULL,NULL,2,'B001-0000607',0,18,'2021-05-21',1,0,0,1,'7SCRAQPKpA5fzWQALDIHjA55658=',1,'dNRcxD0bcmLa4misGJvdNChkAL6Phb9TcyUiz9F1vgN7qWW0JwlikK+AgA8iVs59k3w+aXcG0pkttQZPSvfTp4+IjbKNzfl7MbxmPzXZPZpvTjHHnquChFuSB4QBpIp0kVktylZKct5ny2ucjGzdgoP/eoTBId51Fa3cskT+oTAbZyETQ0zThtbDpsqBjwkpnaE7+sld7AxnbLFcwF8XMG5nobzLm1PHew3TFDH9DJlPRqNr2dQLWny5XPG4P/kJZJBOjp0JvZR3m/MmwQeOHoMDSpQ+vwTWQY0rtRjA2OapG19qMM7K1Hfgr2Jd/o6GL99I6GrnO5TErXd/7q6RHg==',1,1,'',1,1),(632,'2021-05-21 19:13:09','2021-05-21','0000632',1,2,1,'162164235264203418','',1,'AAURAZO',NULL,NULL,2,'B001-0000608',0,18,'2021-05-21',1,0,0,1,'PfsxJJUSclPeXtsh2G5YP5ZsMd0=',1,'MNUf7R0dM2YzWJ9uy/LL83x/5unFINRIzaGRI+tCNrK7cFd6UvkbC+IEe+RsNHNfiWEDvxMYFTrqTs7F1y6Qoyn19694u+3WPCpeDJ5ebRvMxLuYM7NTY9lZLiBeYbcnd9vp1h/3Ht03jGdOZKqF8+edPNHjbMH50CzJsMY+7g9yqoywmtTWSJXn6GC6J99PB7DaSy+rl6utKJn7jME69ajDf1CniTpgu5ZSU5Anq0UYqWwb9wvEONhPONJGONIB80ihkPkMqm9LHH1SpbwdT3/KxAw2WuW+1mLY/Tne5lIt+6oWkeYWkTBv/f+2Mx2DmGomSF2WNwC3OXIxn5PIMg==',1,1,'',1,1),(633,'2021-05-21 19:14:36','2021-05-21','0000633',1,2,1,'16216424561378996461','',1,'AAURAZO',NULL,NULL,2,'B001-0000609',0,18,'2021-05-21',1,0,0,1,'Loq95eGTcOz5inWt+KekXXlcN+A=',1,'RLlpjkxFyeewgoewpJjIB1eakenePoC0vcKUZIC5Xu3bwlO+sLPchPVft/1YusuX/2GJ2f9+GUNM08/JsS+vRT007GjZQdHZoCiSyWTAZ/A4DJDy12fclSHNm3NXoaxb6WsyjZ3ZyGfLaxVoefu3DewDviQKs8Eusthg7n7Oh4cfBC9qCAMRiw7hkmHnqVW0gZyqgh/V9ndZcKpQ6VlIw9akOdjFXzeqpY4qEf0C+3alyt1MOcLUXV3e4b/1E2NmaZvl6Rafiq8Ue4N0LZAXJhV/iVC3Niuv4aufeI8IGtgcHWBqSXTLDVN4pUSmORUDH9ikzVDJ1ITPkUhLzr3HXA==',1,1,'',1,1),(634,'2021-05-21 19:15:13','2021-05-21','0000634',1,2,1,'16216424781249169578','',1,'AAURAZO',NULL,NULL,2,'B001-0000610',0,18,'2021-05-21',1,0,0,1,'b9pEn/79v3mEpfSfhR2RONXKdlM=',1,'AdEp6E0jM3P9wCXzpgalIkCC04CQ/RbOXq27hDq90rEtfEI6qNumVcML2zsbI+24G5tou3R0fPyTAyUpiT5Z9NPihzMC/czkNbFqYXhC4D5XWxxzDLZlCW/lbm11ZN1nu6RlGY4exn+L7x/UXMEFaZm/0WRzEvD8TPvob2p+CcM2d00RLe63M5cSM8TdYAPCJtdiC8ijuZPP9M6P5GXmqsVFEqSFI4InHOpNWziwiU9jOZuv4bchjJlq02bej2gdFp3yPa1ohNeEtdYq/Zm6zOh02FtD7drrAtA9/YbwOeFTgA3aWMe6Z60anZ+PTENK83zm63oEBDqovSX1P4wyQw==',1,1,'',1,1),(635,'2021-05-21 19:17:18','2021-05-21','0000635',1,2,1,'1621642538685496275','',1,'AAURAZO',NULL,NULL,2,'B001-0000611',0,18,'2021-05-21',1,0,0,1,'TFpZIicNOckHadxTCuYxJvO5BBw=',1,'c0cv8teJUqF0RF0051iU8hOSC3++8QKwnL72RtXeEzFMu6lrWL/nX+0D1nvmYXcdFbTq9NSn1vkxQnPI/EqE5ieYgLcjCoWYo7sWeRctBsk+wFKFAOhMrW8GVfoWbFjJg0lOl6v+rNeTzrFqZvh/ja0CAKX3N/8OUK7ZIsvSRISvS8TpfKiQkAGizwiIxCajMHGtE9IOpR/c/HNcpi2rDAcfz0HS9Xxv6rVDtnQgtIghqBWjerbpXeunV//nn4epc1u+4eqNgAMGlOpYyb9OfcFXpyWF/TPEOSXnoP28ch2D0kGNbBuCnvRWzeGcR7OKlOkRslDuOOsOXnR0exacOg==',1,1,'',1,1),(636,'2021-05-21 19:18:16','2021-05-21','0000636',1,2,1,'16216426401001564708','',1,'AAURAZO',NULL,NULL,2,'B001-0000612',0,18,'2021-05-21',1,0,0,1,'bKErgedrhNuQ24h09SYQ/N8kIz4=',1,'Rk7AghtjUmfVZp+hTk+DQBBlmZ3dYV7EAT5cXPTuB4xS5Rw2DBRGm9igHviE5cnvwIWXnvCju+LT2AYBoLVhlfe/VzUY03OoKCBB+FAe/6YeSUDjzPjGJMLHoJ8IdLMxROTBQ15khOoyHJyfq5CXZs5kz+Fl5QmEpvL7/f7Pt2ZVmfES42Qe+m2fLlUa9F9Iy071VPl53Zm4cTD87XTbl7w//kT2BhQt3X9U3QR69g8kkjVr/UutCzHTQo1cWWY8I5vdXAMmHWTATQ66MDGmUyu7q4EJxsx2QdP7Q8wKbtHAJlgD33svI9RqYvg7dijrKxD64k904v5kqRgiRoWbig==',1,1,'',1,1),(637,'2021-05-21 19:19:44','2021-05-21','0000637',1,2,1,'1621642700662302145','',1,'AAURAZO',NULL,NULL,2,'B001-0000613',0,18,'2021-05-21',1,0,0,1,'RsPxsQGaxvMHIJlEfX7R6LI8ZM4=',1,'F5BRalWNR8IrAQjr+M9jJ8uQfF1nglIK7MBNtYcpFNhNlsp3OZiLsnmj6aU+RBp/Uxx7iOFhmUHsBtIs4DUoMMo7AtY1ajlIH776QfFJuyulRbmiEKzZGotxFIWTpz5eJ7txScDUZY6gAyHqglYUmshg9LEr8fZLCm8sfniTQnk6jjq5MvUE4dyNrMTOF6UK1qv9DNjfDNyN/+MQL9jdDRef97ZWqYwsUm1NorC4lJGjxcV0LIOA/gr4moA0ZbSABSLEl4sk+8nr1UpWaYqMJEU3t43XlAcqIJDD2iVcdM6INobstbg02UhhD6f9qCiCMcd0S3nTcPs3lURtLBjzug==',1,1,'',1,1),(638,'2021-05-21 19:20:52','2021-05-21','0000638',1,2,1,'16216427881209451243','',1,'AAURAZO',NULL,NULL,2,'B001-0000614',0,18,'2021-05-21',1,0,0,1,'lYXE5GlD4y4yQzQ8mT7/u1DqB5E=',1,'Aq6suLmITzAdblBoqAUMkdFwqEeIZoSncocvtjmrC+0BsXz2NkCfw9dFcDu/EFDl70XYLl1tqc4kbKGSykYFQzDCQk/KthRSuw65LtnCVbx8hyQK9L/6DkOrRlBCPSm9/g8ET4MIP8SJbwbsAJt3aDj8a3evK2r1cmBRx5ClKxC9kmwWAer6XZcteJfZT63eQLAATKJDzmqKfU3Yfic3Qd1rCAnznXnGbeEJn5j/CoO86sTle1x+5xCPJuvvdE+MCgEj5dhHhlPP2nhxXM19AIXjJxPDkCLgMJpqDOZMnu4Ukg3fsDm7SLkoIn5PGwwsCYPZVab23tWvSYwZ+2jMZQ==',1,1,'',1,1),(639,'2021-05-21 19:28:28','2021-05-21','0000639',1,2,1,'1621643282177247907','',1,'AAURAZO',NULL,NULL,2,'B001-0000615',0,18,'2021-05-21',1,0,0,1,'f5J4BleD+/z+wvBEK9dCemys2/8=',1,'DrMrVLsPzOcLXTf32bEwUfg2EjCin312m4UCMVaOFq/KpJJVC4XV9E5tOl0eEYN+2hXKGjAImBFjOB2rDmAEsCCkJOvDxB6y12l8LAv09EZgfvcbPrgPF/2ErrwCYMRrFjYvPTJyOYqPoOG2DNd8EHOTTK+W4Ez8Xfh2TGEe16WXBDcV1D+gNBGbril253+ugLjRVZQyUWvQpaVhl8c6mRTbq+ykvBHZUZyDNU9dhX4CF+JFTP84TmBKvTWx+QTCwEbLtAoM6mkH8gevtTlKWbcN77C/953//Rd58rpBa6v1nE30xactsttJ7A6eqsr37gzlnQpnyw/iv34aiY+EiA==',1,1,'',1,1),(640,'2021-05-21 19:29:43','2021-05-21','0000640',1,2,1,'16216433651191205768','',1,'AAURAZO',NULL,NULL,2,'B001-0000616',0,18,'2021-05-21',1,0,0,1,'vOqgIpKw7z/8xRpU9qfEMnR+bxA=',1,'ISHYmoDZvsnoJjf7nfDKpjWIvcKl+ezuusqD2GxcNSyOw0Z40+vleklvo96kBxJ3uv7Kw3rSmwMcvO9gioXh8unEXYNwwrq+TgDzZisWPy3tpzw6mh8iXrA+fxz7FFBMZOYG3FLxVt8Ao7MkCB8P2IHyiqb+KwQEDbnBhpxOELpFTYD6XlrG4fBrn8LzFJQlhld3lHOyZS1yjpwLwr6hY4tG4gli3gl0xyPVwZjwsl1t0udooP59KnYeUT83JxrYunIAyZgeGiKb3dm4wjZTxtwgLkg+58veF212uesIc44Fcn5BbaBGb9re1RsqPbd8K8AJy6VQF5XEGXnwpSgM7A==',1,1,'',1,1),(641,'2021-05-21 19:30:12','2021-05-21','0000641',1,2,1,'1621643386219332989','',1,'AAURAZO',NULL,NULL,2,'B001-0000617',0,18,'2021-05-21',1,0,0,1,'k0NPjeJX7po0Ib2J9/QL6tPAqkg=',1,'Kv76fJzG9vl9eFc7kAVk+KpP2WfxVwIh1Ifwl+P5GD+RlLZKg3mAiE/NYeJ2uXzoRj5G22pbddVA6j7VYbI4vkbKyVeAD1r5guqcHlLElkByLTzKPgD40V8eDPdTWHD1Qq3vdiWg1Q2KrNBdXBpSyq09j2EVUSDodvvTN6CCaQqEp9g2dnW/7ZKhA0+vvWHNdhn1e2hySJBMj601Cq2eub6hV8Gm1YrzxZC6eVBlkpeetPxGBxqI0Yy8X7lJ/qFv+TMQpowPjHHvti9A9xqnukZ7NRHh+sU/wTqfbdeMvbG1+Ke/Aiot/HlUdqmBWJaFK3cSIexY9o2MDW4yiv/2ag==',1,1,'',1,1),(642,'2021-05-21 19:30:41','2021-05-21','0000642',1,2,1,'1621643415445378936','',1,'AAURAZO',NULL,NULL,2,'B001-0000618',0,18,'2021-05-21',1,0,0,1,'tnHGb0GxMKKTmMkqvXe9xXY0Y5Q=',1,'PJEtoo/xTQ4FZG1CWpXJP4IyGZw/iKT52/Ot5rcUzj02kT5EhAJuLy8O4Z8fIIEPL8xFdKtfUVs8XOr+YROskaSVfM+R16h0AaOkK0VWxQ89yDygzGVFSUUd18MODU0sqNnM7JNPugJfDp7xXgX3TMmmUI/J4ey0jzHB6TjS2q5XZSWacd9MTrPGtFCqek3sw87/UQh8a/XDwTjte0nywsLmWBCczDPShfCzF1UgqnADU+946Q+ZXvlcMb9wBxSn9koDgKLIMVtefw+jpoPP5s0XD0sEDyzPxSGolfFpYoimjRcoG5Pp1bHxitmGYXv3r16uMzi9zvSoLBtDqq8hYQ==',1,1,'',1,1),(643,'2021-05-21 19:31:32','2021-05-21','0000643',1,2,1,'162164346262180924','',1,'AAURAZO',NULL,NULL,2,'B001-0000619',0,18,'2021-05-21',1,0,0,1,'BcJmIQpmql0B3ePjqUdAG9FaFXI=',1,'DHjHLWqpOZHccq3PMlFq7+/DD42Hc/RCQ4NfLHj3UEJ+8Iz2ttriCI/AKS0J+JkdV6QvFZsTUEI5mLvNti0RKCKkkrEJCIz36dNzBxrkVDqHSncG9oXlC/eI9UAFCCmh9KJ4hbq/3Y+qKm2QVXEHO+3HcKRYnIZW+3sE8IgTFFnBtgHL1nbqynIctFqElCke5gmP6gYBDnInxFu2Ia+JXh7NdmEakAzjYcW/lZlKLcXWIJ7hy/VepnFRcz6rDIRXlYxvfLt5Dcw8oexlXkR8kTIDDdpkW4EsaGRlMJWPOp7CrBtZ74t4BeC6PUcxjAgp4olDPZqj8jELxvkHsqmj8g==',1,1,'',1,1),(644,'2021-05-21 19:32:02','2021-05-21','0000644',1,2,1,'16216434951034397957','',1,'AAURAZO',NULL,NULL,2,'B001-0000620',0,18,'2021-05-21',1,0,0,1,'ptdzejtbhE0hL3ODz7vinNhM94c=',1,'FAVrL6Hj68B3G4qC3QotYsiBNakdYeURnBnzH0yOyMxkuOpW00i1THTKWZXDkRPfxJxW2gHLjFYtm8YWcVL7WDgukuGbMCEJLUgP3UCqrGuOA+GsLboBaq8v+4higzcHnHiat1XwqZqe1qHWkk+KA0ZiFEHY+kMWQrpta+AZUofhXG3xzVPkLjI1XeFRAqDd1wCuDQk0IGdleXzvmkkV+beBp39Hw+qyhDCiBxDECGu+Y8kgeup46VYTPcaTlZGunaaTtjYDTBCcHeRpluhpYwnJpc3Z4wQ7bKKTHIIgRWJFf4HXQGhDInwggqVHUSsVTKVd1e3YEO/kH4W/qtvagA==',1,1,'',1,1),(645,'2021-05-22 18:20:05','2021-05-22','0000645',1,2,1,'1621725502504504604','',1,'AAURAZO',NULL,NULL,2,'B001-0000621',0,18,'2021-05-22',1,0,0,1,'ImO2es2JCkXKRXFQDrLWA+1vOwk=',1,'PjvSOxCbZjVyDx4g7HJnN4y+vdRhS6jfq3ftRvVbRUJ7X095pCwndfhC6DPrqDrHvWZvtLa5z7G1\ngAkV+gqByNiUy5lhUJnXc0waxvfQ3MCwb/E+gmpcMzcJX0MxHwNw0fCGn2Q9bpJpYQ4ciK8+MT4c\n0HGRvhlNvj9mfACybkcwjj7VYsMAG1LRcReWsJTb/+7FCGJa6mh2fJIr9blcw5rRFPJM+fUvQdLq\nge3rih9NuKVLxlqPodh58rDdhKAII/K+FGUlYNBoTEXvJE66dS8XDzTxRTt1L2nxYxwYsAIs7Egq\nKUV+zhv10r9ZZdY5fr+KnGLU47kIWvPE05PQtA==',1,1,'',1,1),(646,'2021-05-22 18:21:59','2021-05-22','0000646',1,2,1,'1621725610981597962','',1,'AAURAZO',NULL,NULL,2,'B001-0000622',0,18,'2021-05-22',1,0,0,1,'8mfHiTZYmKGm/yySXVY2/9Yxsbc=',1,'iQ19w4NSutp9fL6wZ08ZPbZ3+vRF8RE5Vh2NnOqgB+sg5iGmRP3TaxJ39HdWZ4/WIwqmjdS/c6oM/Hhywl5vKqGPJj2o23EH7HyS2mURNwlqfTSvUJftzz/3tTimjw16Y4VYJxrVZzVesCPVzkmFUK4/k3BMVp/ATZK1z15/8xa12UUcy2pdzeo6GZTxR3bsxqmdB3DA+lWanijNK9rnBAyH+fL+dhihbkPGvswybLJz9Qlna6OeIiEORmXObS60qQSHVDJ2v2JqNZTdhYWECbTgHLyYgjc5bj3JEZI6vuR6XOvPmH7SbJLry0jFoCOoplOsqj7OlzpHqInu9/nVrg==',1,1,'',1,1),(647,'2021-05-22 18:23:51','2021-05-22','0000647',1,2,1,'16217257461140815552','',1,'AAURAZO',NULL,NULL,2,'B001-0000623',0,18,'2021-05-22',1,0,0,1,'tRmK/Emn0q5lqL87loCfXWxEJ6A=',1,'UZodOJnMylws/+Mq3vd0tdhGDlJ4eaTGcS2VgqHLXclVoZgRmCc7Gcaw5TQei+bcVcCA4R1a0qtnvw/0nrCGnNSSmUeDmwgoUVMxENmYU9GAtZYL+ItuKcwGCseKjvrT8DXnfoyhpvs0va2edQum8L3qP14CU7wLKaGBw3DR6f4sRB6ODV/iRnUjvqTziCU1vgj0v3MLRlH1TiWj5n1RVjGquoZ5EPHQn+1i3i1NWv18w+UOzdZArsL2QpQ3/I/lIPBdYo5JioZwhr+hlOs4PmS37Jl/ux9hu5HB+2fnKvgziKglRvaUKfhn7Pn18ArJXm27Ar86iE5/KujYrHkpeQ==',1,1,'',1,1),(648,'2021-05-22 18:24:38','2021-05-22','0000648',1,2,1,'16217258351189355402','',1,'AAURAZO',NULL,NULL,2,'B001-0000624',0,18,'2021-05-22',1,0,0,1,'9r7KROAyu5dxhZicExGhw0U77dc=',1,'DydJ1UZnxvdzAmWacHp/1g0/Uke9hdWtudz3EndLp0lviTS1f0OXy50nftdUjGw3JUZN7i85knzR+suWhmwkdou/ST1R+bUZkpn8UAZ4ky4Z2cC9M498wDNyczGhSbS/hgXTDxnpNpQC7wgnQurOufoLplhbdI5mDzdoA4aCUyea3YEFuv1KmA6sFwmq8XO05800LMPbdTQh18I5QKlW2z18qVuWUmIEnbZn2F9IakUNImg2JWVcBGoexeqEi4m7SFrxHat5ID0cQxNuK/tFUVnkyFrMHFQ6MSHUZGt/eR4kQJWqJ5pXtLwCYXdVyomQEpxzYgz0zw/xA+tNIsuUvA==',1,1,'',1,1),(649,'2021-05-22 18:25:43','2021-05-22','0000649',1,2,1,'1621725881992657130','',1,'AAURAZO',NULL,NULL,2,'B001-0000625',0,18,'2021-05-22',1,0,0,1,'K+8LnINNqzTXoD/SuONaAq2Lotk=',1,'J/POGrbxhA2beobMmw7Q/6Z4c9VCYQAJZFtm6tW9Eu4Oq3MLWZdOlNnbMKzLvRraUl7n3FXuZt/DJtUf5N6mQaCEkeSg0TzgYnXq8ARQZ+JD6dqSyIxlaN1+1zDvwqjxhNmsnffoa9PIg23nnWXJR6YYFj1Nh9u8VAKbZELsqAGOJzu9uCNjfMHlttFAN//HDm+nAmGCPBjv1mEEK/qb7FVul6PnwZCwZFSPvsLmtYZH2Wk5IMv1ZxHGKURq0nU7eTayhE0hB4VteZO/UFzqC1IyH/ehZlHDyZ1T9c84JlkNyQ0J8JgTNIyTlnGI4ymMCB335rgF85Yx0uOdFbrT4Q==',1,1,'',1,1),(650,'2021-05-22 18:26:46','2021-05-22','0000650',1,2,1,'16217259471208117258','',1,'AAURAZO',NULL,NULL,2,'B001-0000626',0,18,'2021-05-22',1,0,0,1,'t3yc1As25P9G+zFbahYD2nxJRHM=',1,'Fs29i4BAdcNsQ3iZCuYznH6k/W/TFdRLmUNAzAKSmw51zXbaXoAvvS9Qa4nBDw6MkyW71rgPIw9gBITWfJlwwUj+5vgqZ2nruc+4MTeCSxpgmjblq00Wo/YEe6qFyc76v+dq8+oRCEVFD6+eVyGTctPJjBSl78rYclNjfXkimohswikNwoNa3lEcs0Rw3PTFWFW+ez1dKGQRDaDPGMy9MKK4TR+TIC9oGkLUlgDSPURn4hA3JCOOcL4xvs9oAymOASb8ytfEh6OE4L4edaDRjYlSLYHt9avEib3dxlV22/bBPn4tD3DTTJ6MUd8GnWbqjfj15/zrh1MvuTZ+7n1FzQ==',1,1,'',1,1),(651,'2021-05-22 18:27:21','2021-05-22','0000651',1,2,1,'16217260091366345118','',1,'AAURAZO',NULL,NULL,2,'B001-0000627',0,18,'2021-05-22',1,0,0,1,'I0gxjTNjrqDXa5RkV+3U/dNpCZQ=',1,'DtSPmrdrGXGq7bk0i0dYjaSkOL6QUGB2k3wzLj5OU/14ZjVLGu1WwRxdviYb7S6CeA5BLKKd1WgjWCt++Jc19WdKd2tAQPbgXJvoIAtaDChOHVSysHnvs6LlEiR4aDeT55lgJrk48qKVfW37QNFvSqrH/cyxpRV08VUSVL8N9CU6szq619LEYJwtbXdPQZg6ZUXS4AA99Eag5FpujKMinTy90brz8gWsl8IwcTQj489tRy7AOu2/OaQjn8Nds9GowigVKUKyara3x7TXjHnafhjK7dfI51M9xamXDJUZBVIhMbHRfmioluQhfy/ovx/lEvBpnwGdOXvKLH77BmZJNg==',1,1,'',1,1),(652,'2021-05-22 18:28:12','2021-05-22','0000652',1,2,1,'1621726044633729043','',1,'AAURAZO',NULL,NULL,2,'B001-0000628',0,18,'2021-05-22',1,0,0,1,'mj7Yl4dgDddIy3lghGRt+aVPK98=',1,'B07wDMoG22/xtVrPt97nCoks/wjrn7FrIX5o5ICFPy4soVokJdFMMHkqrmHbIt3A39VKZ/PNiiYDQ162uS8pS0dJJh1Q0PpHQyNSNeD56A1unqbwRzwX9OOop9zqqfdb1CysbrgkaVSJXodrpJLQ89pM6WrE26wir5T4mr4zj5x99k4a6FZuWcr1606Am77Ll3Jfig3BOmqOlXQrgG448kNuZ3AFDfKlrzBATN1WK3oS0HLIJt4gZ/CLNn0hOs+wP/RfZ+3DZVcgy6tOQ3dKSw1ODBDWVPvY6fvQblmz5LaY2M4RePpVCLlg+j5K3ae/q1vDetmqQZgwgfzAemuvSQ==',1,1,'',1,1),(653,'2021-05-22 18:29:20','2021-05-22','0000653',1,2,1,'1621726098590309975','',1,'AAURAZO',NULL,NULL,2,'B001-0000629',0,18,'2021-05-22',1,0,0,1,'a+fv8xf8BeSrEZ/h6rf/LreETyo=',1,'EjwMzsEMCCD3G9VrCWnbS75OM3rZP+0J0FN+sehhAClYW3Eb1a1a8wOE4aAu2xgLp7ycCtFYwWNO5J9+ijWbd4cLFAdS/Vy2y812yjcSveMwmT2fUMttLygDnNv7IGrmm0rNbwkNtN4FlPFeTdaA5tGogdWz0Fp57ElEzEo0zhUqK6djpmK0NuhE09bDH7KQbCyGDKFtYAwTicDUb6iw0WIPqoLAkLEwe9v5PMGPmEdF+NUt7dzPu6M4pL/c+BowRo3hrLDWU+S7hU+Big1azEY3UoqJ9COCgU9ctnXikHSgr/8yyDUVXLNbTOY4WeoQ4UmlRoN+EhXgCGAVd+VM3g==',1,1,'',1,1),(654,'2021-05-22 18:29:51','2021-05-22','0000654',1,2,1,'1621726163561005332','',1,'AAURAZO',NULL,NULL,2,'B001-0000630',0,18,'2021-05-22',1,0,0,1,'qsP5rhnE/2hNWzNavYSEgporOP0=',1,'RRKiJGCk4vgHkC/3Jird9Z2I1ARdoQJXqkNXiMndedPjAjQqenINGUHdQd3xbtSKKfPF6GQgY2rmoDxmJNy/LV/JHHRkEJ+Qa/0Xy052DrEaY8vwWoSqlZsw1+R+nQGUefpP3/OQwD2LWOnZKW/6xGoYXyFBujhuCnQ63zKWSED6BjuykAT77Y0JoTEaPE4vmEUZRUfaLULvXPrtIe/zJoOhCubn/Cp12ONHtTt5IUxKN5S+7tM5QBAAfsR+DWTpMvvTcul95EOnCTuC47mO5YZD5q7/haenr/JXSpV+OfswPm6uYqegWp+zTUbjmzbs+TcCz5sId0UDZP6+SI+wGw==',1,1,'',1,1),(655,'2021-05-22 18:30:18','2021-05-22','0000655',1,2,1,'1621726194232801937','',1,'AAURAZO',NULL,NULL,2,'B001-0000631',0,18,'2021-05-22',1,0,0,1,'pGJ9W3r/amOaBNOdFKhYIM6zIAY=',1,'bVcLXVqqlhLVNlblIktBCDaOVSWPyNMOojOXW