/*!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.6.18-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: comercialaliazione
-- ------------------------------------------------------
-- Server version	10.6.18-MariaDB-cll-lve

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `caja`
--

DROP TABLE IF EXISTS `caja`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `caja` (
  `caj_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `caj_fecha` date DEFAULT NULL,
  `caj_fechahora` datetime DEFAULT NULL,
  `caj_usu_nombre` varchar(45) NOT NULL DEFAULT '',
  `caj_cerrada` int(10) unsigned NOT NULL DEFAULT 0,
  `caj_anotaciones` text DEFAULT NULL,
  `caj_monto_inicial` float NOT NULL DEFAULT 0,
  `caj_idtrans` varchar(45) DEFAULT NULL,
  `caj_numero` varchar(45) DEFAULT NULL,
  `usu_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `usu_nombre_fk` varchar(45) NOT NULL DEFAULT '',
  `caj_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `caj_monto_final` float NOT NULL DEFAULT 0,
  `caj_fechahora_cierre` datetime DEFAULT NULL,
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `caj_monto_final_bouchers` float NOT NULL DEFAULT 0,
  `caj_anotaciones_cierre` text DEFAULT NULL,
  PRIMARY KEY (`caj_codi`),
  UNIQUE KEY `Index_caj_numero` (`caj_numero`),
  KEY `Index_caj_usu_nombre` (`caj_usu_nombre`),
  KEY `Index_caj_cerrada` (`caj_cerrada`),
  KEY `Index_caj_idtrans` (`caj_idtrans`),
  KEY `Index_usu_codi_fk` (`usu_codi_fk`),
  KEY `Index_emp_codi_fk` (`emp_codi_fk`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `caja`
--

LOCK TABLES `caja` WRITE;
/*!40000 ALTER TABLE `caja` DISABLE KEYS */;
INSERT INTO `caja` (`caj_codi`, `caj_fecha`, `caj_fechahora`, `caj_usu_nombre`, `caj_cerrada`, `caj_anotaciones`, `caj_monto_inicial`, `caj_idtrans`, `caj_numero`, `usu_codi_fk`, `usu_nombre_fk`, `caj_estado`, `caj_monto_final`, `caj_fechahora_cierre`, `emp_codi_fk`, `caj_monto_final_bouchers`, `caj_anotaciones_cierre`) VALUES (1,'2024-09-14','2024-09-14 19:00:53','ETORRES',0,'',0,'17263584533926921895','C-0000001',2,'ETORRES',1,0,NULL,1,0,NULL),(2,'2024-10-03','2024-10-03 14:16:41','EBOTELLO',0,'',0,'17279830016534122316','C-0000002',10,'EBOTELLO',1,0,NULL,1,0,NULL);
/*!40000 ALTER TABLE `caja` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `comprobante_serie`
--

DROP TABLE IF EXISTS `comprobante_serie`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `comprobante_serie` (
  `comser_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `comtip_codigo_fk` varchar(45) NOT NULL DEFAULT '',
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `comser_serie` char(4) CHARACTER SET ucs2 COLLATE ucs2_general_ci NOT NULL DEFAULT '',
  `comser_correlativo` int(10) unsigned NOT NULL DEFAULT 0,
  `comser_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `comser_usu_crea` varchar(45) DEFAULT NULL,
  `comser_usu_modifica` varchar(45) DEFAULT NULL,
  `comser_usu_activa` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`comser_codi`),
  KEY `Index_comtip_codigo_fk` (`comtip_codigo_fk`),
  KEY `Index_emp_codi_fk` (`emp_codi_fk`),
  KEY `Index_comser_estado` (`comser_estado`),
  CONSTRAINT `FK_comprobante_serie_comprobante_tipo` FOREIGN KEY (`comtip_codigo_fk`) REFERENCES `comprobante_tipo` (`comtip_codigo`),
  CONSTRAINT `FK_comprobante_serie_empresas` FOREIGN KEY (`emp_codi_fk`) REFERENCES `empresas` (`emp_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `comprobante_serie`
--

LOCK TABLES `comprobante_serie` WRITE;
/*!40000 ALTER TABLE `comprobante_serie` DISABLE KEYS */;
INSERT INTO `comprobante_serie` (`comser_codi`, `comtip_codigo_fk`, `emp_codi_fk`, `comser_serie`, `comser_correlativo`, `comser_estado`, `comser_usu_crea`, `comser_usu_modifica`, `comser_usu_activa`) VALUES (1,'01',1,'F001',3,1,'','',NULL),(2,'03',1,'B001',2,1,'','',NULL),(5,'07',1,'F001',2,1,'','',NULL),(6,'07',1,'B001',2,1,'',NULL,NULL),(7,'08',1,'F001',1,1,'',NULL,NULL),(8,'08',1,'B001',1,1,'',NULL,NULL),(11,'01',1,'F002',1,1,'',NULL,NULL),(12,'03',1,'B002',1,1,'',NULL,NULL),(13,'08',1,'B002',1,1,'',NULL,NULL),(14,'07',1,'B002',1,1,'',NULL,NULL);
/*!40000 ALTER TABLE `comprobante_serie` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `comprobante_tipo`
--

DROP TABLE IF EXISTS `comprobante_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `comprobante_tipo` (
  `comtip_codigo` char(2) NOT NULL DEFAULT '',
  `comtip_nombre` varchar(45) NOT NULL DEFAULT '',
  PRIMARY KEY (`comtip_codigo`),
  UNIQUE KEY `Index_comtip_nombre` (`comtip_nombre`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `comprobante_tipo`
--

LOCK TABLES `comprobante_tipo` WRITE;
/*!40000 ALTER TABLE `comprobante_tipo` DISABLE KEYS */;
INSERT INTO `comprobante_tipo` (`comtip_codigo`, `comtip_nombre`) VALUES ('03','BOLETA'),('01','FACTURA'),('07','NOTA DE CREDITO'),('08','NOTA DE DEBITO');
/*!40000 ALTER TABLE `comprobante_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `configuraciones`
--

DROP TABLE IF EXISTS `configuraciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `configuraciones` (
  `con_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `con_igv` float DEFAULT NULL,
  `con_dolar` float DEFAULT NULL,
  `con_pagocompra` int(10) unsigned DEFAULT NULL,
  `con_cobropedido` int(10) unsigned DEFAULT NULL,
  `con_aperturacaja` int(10) unsigned DEFAULT NULL,
  `con_cierrecaja` int(10) unsigned DEFAULT NULL,
  `con_usu_modifica` varchar(45) DEFAULT NULL,
  `con_mediopago` int(11) unsigned DEFAULT NULL,
  `con_operaciontipo` int(11) unsigned DEFAULT NULL,
  `con_documentotipo` int(11) unsigned DEFAULT NULL,
  `con_operaciontipo_compra` int(10) unsigned DEFAULT NULL,
  `con_documentotipo_compra` int(10) unsigned DEFAULT NULL,
  `con_token` varchar(45) NOT NULL,
  `con_prdfam_codi_icbper` int(10) unsigned DEFAULT NULL,
  `con_icbper_monto` float DEFAULT NULL,
  `con_pagonotacredito` int(11) DEFAULT NULL,
  `con_operaciontipo_notacredito` int(11) DEFAULT NULL,
  `con_documentotipo_notacredito` int(11) DEFAULT NULL,
  `con_valor_punto` float DEFAULT NULL,
  `con_medpag_codi` int(10) unsigned DEFAULT NULL,
  `con_dis_codi` int(10) unsigned DEFAULT NULL,
  `con_camara_codigobarras` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`con_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `configuraciones`
--

LOCK TABLES `configuraciones` WRITE;
/*!40000 ALTER TABLE `configuraciones` DISABLE KEYS */;
INSERT INTO `configuraciones` (`con_codi`, `con_igv`, `con_dolar`, `con_pagocompra`, `con_cobropedido`, `con_aperturacaja`, `con_cierrecaja`, `con_usu_modifica`, `con_mediopago`, `con_operaciontipo`, `con_documentotipo`, `con_operaciontipo_compra`, `con_documentotipo_compra`, `con_token`, `con_prdfam_codi_icbper`, `con_icbper_monto`, `con_pagonotacredito`, `con_operaciontipo_notacredito`, `con_documentotipo_notacredito`, `con_valor_punto`, `con_medpag_codi`, `con_dis_codi`, `con_camara_codigobarras`) VALUES (1,18,3.77,12,11,13,14,'ETORRES',1,4,11,1,10,'SISTEMACOMERCIAL2024',0,0.4,18,55,11,0.2,8,70,1);
/*!40000 ALTER TABLE `configuraciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `configuraciones2`
--

DROP TABLE IF EXISTS `configuraciones2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `configuraciones2` (
  `con_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `con_usuario` varchar(145) NOT NULL DEFAULT '',
  `con_clave` varchar(145) NOT NULL DEFAULT '',
  `con_token` varchar(45) NOT NULL DEFAULT '',
  `con_email` varchar(145) NOT NULL DEFAULT '',
  `con_usuario_estado` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`con_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `configuraciones2`
--

LOCK TABLES `configuraciones2` WRITE;
/*!40000 ALTER TABLE `configuraciones2` DISABLE KEYS */;
INSERT INTO `configuraciones2` (`con_codi`, `con_usuario`, `con_clave`, `con_token`, `con_email`, `con_usuario_estado`) VALUES (1,'ADMIN','3f7caa3d471688b704b73e9a77b1107f','ALIZIONEBOTELLO','cbotello.aliazioneperu@gmail.com',1);
/*!40000 ALTER TABLE `configuraciones2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cotizaciones`
--

DROP TABLE IF EXISTS `cotizaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cotizaciones` (
  `cot_codi` int(11) NOT NULL AUTO_INCREMENT,
  `cot_fecha` date DEFAULT NULL,
  `cot_numero` varchar(45) DEFAULT NULL,
  `per_codi_fk` int(11) DEFAULT NULL,
  `cot_estado` int(11) NOT NULL DEFAULT 1,
  `cot_fechahora` datetime DEFAULT NULL,
  `cot_anotaciones` text DEFAULT NULL,
  `cot_usu_crea` varchar(45) NOT NULL DEFAULT '',
  `cot_usu_modifica` varchar(45) NOT NULL DEFAULT '',
  `cot_usu_activa` varchar(45) NOT NULL DEFAULT '',
  `idtrans` varchar(45) DEFAULT NULL,
  `cot_situacion` int(10) unsigned NOT NULL DEFAULT 0,
  `cot_igv_porcentaje` float NOT NULL DEFAULT 18,
  `cot_dias` int(11) NOT NULL DEFAULT 5,
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `cot_origen` int(10) unsigned NOT NULL DEFAULT 0,
  `cot_otra_direccion` text DEFAULT NULL,
  `cot_cadena_datos` text DEFAULT NULL,
  `cot_autoriza_web` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`cot_codi`),
  UNIQUE KEY `Index_cot_numero` (`cot_numero`),
  KEY `Index_per_codi_fk` (`per_codi_fk`),
  KEY `Index_cot_estado` (`cot_estado`),
  KEY `Index_idtrans` (`idtrans`),
  KEY `Index_cot_situacion` (`cot_situacion`),
  KEY `Index_emp_codi_fk` (`emp_codi_fk`),
  CONSTRAINT `FK_cotizaciones_empresas` FOREIGN KEY (`emp_codi_fk`) REFERENCES `empresas` (`emp_codi`),
  CONSTRAINT `FK_cotizaciones_personas` FOREIGN KEY (`per_codi_fk`) REFERENCES `personas` (`per_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cotizaciones`
--

LOCK TABLES `cotizaciones` WRITE;
/*!40000 ALTER TABLE `cotizaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `cotizaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cotizaciones_detalle`
--

DROP TABLE IF EXISTS `cotizaciones_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cotizaciones_detalle` (
  `cotdet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `cotdet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `cotdet_precio` float NOT NULL DEFAULT 0,
  `cotdet_cantidad` float NOT NULL DEFAULT 0,
  `cot_codi_fk` int(11) NOT NULL DEFAULT 0,
  `idtrans` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`cotdet_codi`),
  KEY `fk_cotizaciones_detalle_cotizaciones1_idx` (`cot_codi_fk`),
  KEY `fk_cotizaciones_detalle_productos1_idx` (`prd_codi_fk`),
  KEY `fk_cotizaciones_detalle_unidades_medida1_idx` (`unimed_codi_fk`),
  CONSTRAINT `fk_cotizaciones_detalle_cotizaciones1` FOREIGN KEY (`cot_codi_fk`) REFERENCES `cotizaciones` (`cot_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_cotizaciones_detalle_productos1` FOREIGN KEY (`prd_codi_fk`) REFERENCES `productos` (`prd_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_cotizaciones_detalle_unidades_medida1` FOREIGN KEY (`unimed_codi_fk`) REFERENCES `unidades_medida` (`unimed_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cotizaciones_detalle`
--

LOCK TABLES `cotizaciones_detalle` WRITE;
/*!40000 ALTER TABLE `cotizaciones_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `cotizaciones_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cuentas_contables`
--

DROP TABLE IF EXISTS `cuentas_contables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cuentas_contables` (
  `cc_codi` int(11) NOT NULL AUTO_INCREMENT,
  `cc_nombre` varchar(245) NOT NULL DEFAULT '',
  `cc_tipo` char(10) NOT NULL DEFAULT 'E',
  `cc_estado` int(11) NOT NULL DEFAULT 1,
  `cc_abreviatura` varchar(45) DEFAULT NULL,
  `cc_usu_crea` varchar(45) DEFAULT NULL,
  `cc_usu_modifica` varchar(45) DEFAULT NULL,
  `cc_usu_activa` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`cc_codi`),
  UNIQUE KEY `Index_cc_tipo` (`cc_tipo`),
  KEY `Index_cc_estado` (`cc_estado`),
  KEY `Index_cc_nombre` (`cc_nombre`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cuentas_contables`
--

LOCK TABLES `cuentas_contables` WRITE;
/*!40000 ALTER TABLE `cuentas_contables` DISABLE KEYS */;
/*!40000 ALTER TABLE `cuentas_contables` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `detecciones`
--

DROP TABLE IF EXISTS `detecciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `detecciones` (
  `det_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `det_fechahora` datetime DEFAULT NULL,
  `espcom_codi_fk` int(11) NOT NULL DEFAULT 0,
  `det_enojado` float NOT NULL DEFAULT 0,
  `det_asqueado` float NOT NULL DEFAULT 0,
  `det_temeroso` float NOT NULL DEFAULT 0,
  `det_feliz` float NOT NULL DEFAULT 0,
  `det_neutral` float NOT NULL DEFAULT 0,
  `det_triste` float NOT NULL DEFAULT 0,
  `det_sorprendido` float NOT NULL DEFAULT 0,
  `det_cantidad` int(11) NOT NULL DEFAULT 0,
  `det_fecha` date DEFAULT NULL,
  PRIMARY KEY (`det_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=266 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `detecciones`
--

LOCK TABLES `detecciones` WRITE;
/*!40000 ALTER TABLE `detecciones` DISABLE KEYS */;
INSERT INTO `detecciones` (`det_codi`, `det_fechahora`, `espcom_codi_fk`, `det_enojado`, `det_asqueado`, `det_temeroso`, `det_feliz`, `det_neutral`, `det_triste`, `det_sorprendido`, `det_cantidad`, `det_fecha`) VALUES (1,'2024-06-18 13:17:31',1,0,0,0,0,1,0,0,1,'2024-06-18'),(2,'2024-06-18 13:17:31',3,0,0,0,0,9,0,0,9,'2024-06-18'),(3,'2024-06-18 13:36:10',1,0,0,0,0,2,0,0,2,'2024-06-18'),(4,'2024-06-18 13:36:10',3,0,0,0,0,8,0,0,8,'2024-06-18'),(5,'2024-06-18 13:37:19',3,0,0,0,0,10,0,0,10,'2024-06-18'),(6,'2024-06-18 13:39:55',1,0,0,0,0,1,0,0,1,'2024-06-18'),(7,'2024-06-18 13:39:55',3,0,0,0,0,9,0,0,9,'2024-06-18'),(8,'2024-06-18 13:42:11',3,0,0,0,0,9,1,0,10,'2024-06-18'),(9,'2024-06-18 13:44:49',3,0,0,0,0,7,0,0,7,'2024-06-18'),(10,'2024-06-18 13:44:49',1,0,0,0,0,3,0,0,3,'2024-06-18'),(11,'2024-06-18 13:47:04',1,0,0,0,0,1,0,0,1,'2024-06-18'),(12,'2024-06-18 13:47:04',3,0,0,0,0,9,0,0,9,'2024-06-18'),(13,'2024-06-18 14:34:06',3,0,0,0,0,10,0,0,10,'2024-06-18'),(14,'2024-06-18 15:18:09',1,1,0,0,2,2,0,0,5,'2024-06-18'),(15,'2024-06-18 15:18:09',3,0,0,0,3,2,0,0,5,'2024-06-18'),(16,'2024-06-18 15:18:55',3,0,0,0,4,6,0,0,10,'2024-06-18'),(17,'2024-06-18 16:13:46',1,0,0,0,0,5,0,0,5,'2024-06-18'),(18,'2024-06-18 16:13:46',3,0,0,0,0,5,0,0,5,'2024-06-18'),(19,'2024-06-18 16:14:14',3,0,0,0,0,4,2,0,6,'2024-06-18'),(20,'2024-06-18 16:14:14',1,0,0,0,0,3,1,0,4,'2024-06-18'),(21,'2024-06-18 16:15:53',3,0,0,0,0,7,0,0,7,'2024-06-18'),(22,'2024-06-18 16:15:53',1,0,0,0,0,3,0,0,3,'2024-06-18'),(23,'2024-06-18 17:51:00',3,0,0,0,0,2,0,4,6,'2024-06-18'),(24,'2024-06-18 17:51:00',1,0,0,0,0,4,0,0,4,'2024-06-18'),(25,'2024-06-18 17:51:24',3,0,0,0,0,10,0,0,10,'2024-06-18'),(26,'2024-06-18 17:58:16',1,0,0,0,0,10,0,0,10,'2024-06-18'),(27,'2024-06-18 17:58:48',1,0,0,0,0,5,0,0,5,'2024-06-18'),(28,'2024-06-18 17:58:48',3,0,0,0,0,5,0,0,5,'2024-06-18'),(29,'2024-06-18 17:59:19',1,0,0,0,0,7,0,0,7,'2024-06-18'),(30,'2024-06-18 17:59:19',3,0,0,0,0,3,0,0,3,'2024-06-18'),(31,'2024-06-18 18:02:49',3,0,0,0,0,10,0,0,10,'2024-06-18'),(32,'2024-06-18 18:58:20',3,0,0,0,0,10,0,0,10,'2024-06-18'),(33,'2024-06-18 19:21:42',3,0,0,0,0,10,0,0,10,'2024-06-18'),(34,'2024-06-18 19:22:43',1,0,1,1,1,0,0,0,3,'2024-06-18'),(36,'2024-06-18 19:23:47',3,1,0,0,0,9,0,0,10,'2024-06-18'),(37,'2024-06-18 19:26:13',3,0,0,0,0,2,0,0,2,'2024-06-18'),(38,'2024-06-18 19:26:13',1,0,0,0,3,0,3,0,6,'2024-06-18'),(41,'2024-06-18 19:26:46',1,0,0,0,1,0,0,0,1,'2024-06-18'),(42,'2024-06-18 19:27:21',3,0,0,0,0,10,0,0,10,'2024-06-18'),(43,'2024-06-18 20:41:02',3,0,0,0,0,10,0,0,10,'2024-06-18'),(44,'2024-06-18 23:58:01',3,0,0,0,0,9,0,0,9,'2024-06-18'),(45,'2024-06-18 23:58:01',1,0,0,0,0,1,0,0,1,'2024-06-18'),(46,'2024-06-18 23:58:33',3,0,0,0,1,4,3,0,8,'2024-06-18'),(47,'2024-06-18 23:58:33',1,0,0,0,0,0,2,0,2,'2024-06-18'),(48,'2024-06-19 13:50:22',3,0,0,0,0,8,0,0,8,'2024-06-19'),(49,'2024-06-19 13:50:22',1,0,0,0,0,2,0,0,2,'2024-06-19'),(50,'2024-06-19 13:50:49',3,0,0,0,0,10,0,0,10,'2024-06-19'),(51,'2024-06-19 14:44:26',3,0,0,0,8,2,0,0,10,'2024-06-19'),(52,'2024-06-19 15:25:44',3,0,0,0,0,10,0,0,10,'2024-06-19'),(53,'2024-06-19 16:38:52',3,2,0,0,0,5,2,0,9,'2024-06-19'),(54,'2024-06-19 16:38:52',1,1,0,0,0,0,0,0,1,'2024-06-19'),(55,'2024-06-19 21:13:44',3,0,0,0,0,10,0,0,10,'2024-06-19'),(56,'2024-06-19 21:14:15',3,0,0,0,0,10,0,0,10,'2024-06-19'),(57,'2024-06-20 08:19:47',3,0,0,0,0,10,0,0,10,'2024-06-20'),(58,'2024-06-20 08:20:23',3,0,0,0,1,8,0,0,9,'2024-06-20'),(59,'2024-06-20 08:20:23',1,0,0,0,0,1,0,0,1,'2024-06-20'),(60,'2024-06-20 15:28:28',3,0,0,0,0,9,0,1,10,'2024-06-20'),(61,'2024-06-20 15:29:23',3,0,0,0,0,10,0,0,10,'2024-06-20'),(62,'2024-06-21 08:02:21',3,0,0,0,0,5,0,0,5,'2024-06-21'),(63,'2024-06-21 08:02:21',1,0,0,0,0,3,0,2,5,'2024-06-21'),(64,'2024-06-21 08:02:50',3,0,0,0,0,10,0,0,10,'2024-06-21'),(65,'2024-06-21 10:56:07',1,0,0,0,0,4,1,1,6,'2024-06-21'),(66,'2024-06-21 10:56:07',3,0,0,0,0,3,0,1,4,'2024-06-21'),(67,'2024-06-21 10:56:34',3,0,0,0,0,10,0,0,10,'2024-06-21'),(68,'2024-06-21 11:08:36',3,0,0,0,0,10,0,0,10,'2024-06-21'),(69,'2024-06-21 20:25:59',3,0,0,0,0,4,0,0,4,'2024-06-21'),(70,'2024-06-21 20:25:59',1,1,0,0,1,3,1,0,6,'2024-06-21'),(71,'2024-06-21 20:26:27',3,0,0,0,0,8,0,2,10,'2024-06-21'),(72,'2024-06-21 22:34:05',1,0,0,0,0,3,0,0,3,'2024-06-21'),(73,'2024-06-21 22:34:05',3,0,0,0,0,7,0,0,7,'2024-06-21'),(74,'2024-06-21 22:34:48',3,0,0,0,0,10,0,0,10,'2024-06-21'),(75,'2024-06-21 22:42:21',3,0,0,0,0,9,0,1,10,'2024-06-21'),(76,'2024-06-21 22:56:19',3,0,0,0,0,5,0,0,5,'2024-06-21'),(77,'2024-06-21 22:56:19',1,0,0,0,2,3,0,0,5,'2024-06-21'),(78,'2024-06-21 22:56:43',3,0,0,0,0,10,0,0,10,'2024-06-21'),(79,'2024-06-22 12:06:35',3,0,0,0,0,10,0,0,10,'2024-06-22'),(80,'2024-06-22 12:22:24',3,0,0,0,0,10,0,0,10,'2024-06-22'),(81,'2024-06-22 12:23:45',3,0,0,0,0,10,0,0,10,'2024-06-22'),(82,'2024-06-22 12:26:46',3,0,0,0,0,10,0,0,10,'2024-06-22'),(83,'2024-06-22 12:36:15',3,0,0,0,1,9,0,0,10,'2024-06-22'),(84,'2024-06-22 13:19:16',3,0,0,0,1,8,0,0,9,'2024-06-22'),(85,'2024-06-22 13:19:16',1,0,0,0,1,0,0,0,1,'2024-06-22'),(86,'2024-06-22 13:19:53',1,0,0,0,0,0,1,0,1,'2024-06-22'),(87,'2024-06-22 13:19:53',3,0,0,0,0,9,0,0,9,'2024-06-22'),(88,'2024-06-22 15:30:41',3,0,0,0,0,4,0,0,4,'2024-06-22'),(89,'2024-06-22 15:30:41',1,0,0,0,0,6,0,0,6,'2024-06-22'),(90,'2024-06-22 15:31:58',1,0,0,0,0,9,0,0,9,'2024-06-22'),(91,'2024-06-22 15:31:58',3,0,0,0,0,1,0,0,1,'2024-06-22'),(92,'2024-06-22 15:32:47',3,0,0,0,0,10,0,0,10,'2024-06-22'),(93,'2024-06-22 19:20:10',1,1,0,0,0,3,0,0,4,'2024-06-22'),(94,'2024-06-22 19:20:10',3,0,0,0,0,6,0,0,6,'2024-06-22'),(95,'2024-06-22 19:20:35',3,0,0,0,0,10,0,0,10,'2024-06-22'),(96,'2024-06-22 20:13:51',1,0,0,0,0,7,0,3,10,'2024-06-22'),(97,'2024-06-22 20:14:58',3,0,0,0,0,3,0,2,5,'2024-06-22'),(98,'2024-06-22 20:14:58',1,0,0,0,0,4,0,1,5,'2024-06-22'),(99,'2024-06-22 20:15:32',3,0,0,0,0,10,0,0,10,'2024-06-22'),(100,'2024-06-23 10:43:44',1,0,0,0,2,3,1,0,6,'2024-06-23'),(101,'2024-06-23 10:43:44',3,0,0,0,2,2,0,0,4,'2024-06-23'),(102,'2024-06-23 10:44:14',1,0,0,0,0,1,0,0,1,'2024-06-23'),(103,'2024-06-23 10:44:14',3,0,0,0,0,9,0,0,9,'2024-06-23'),(104,'2024-06-23 13:40:43',1,0,0,0,0,1,0,0,1,'2024-06-23'),(105,'2024-06-23 13:40:43',3,0,0,0,0,9,0,0,9,'2024-06-23'),(106,'2024-07-05 16:03:56',3,0,0,0,0,10,0,0,10,'2024-07-05'),(107,'2024-07-05 16:04:24',3,0,0,0,0,9,1,0,10,'2024-07-05'),(108,'2024-07-05 16:08:17',1,0,0,0,0,1,0,0,1,'2024-07-05'),(109,'2024-07-05 16:08:17',3,0,0,0,0,9,0,0,9,'2024-07-05'),(110,'2024-07-05 16:09:16',1,0,0,0,0,5,0,3,8,'2024-07-05'),(111,'2024-07-05 16:09:16',3,0,0,0,0,2,0,0,2,'2024-07-05'),(112,'2024-07-05 16:13:37',1,0,0,0,0,1,1,0,2,'2024-07-05'),(113,'2024-07-05 16:13:37',3,0,0,0,0,8,0,0,8,'2024-07-05'),(114,'2024-07-05 16:14:48',3,0,0,0,0,7,0,0,7,'2024-07-05'),(115,'2024-07-05 16:14:48',1,0,0,0,0,3,0,0,3,'2024-07-05'),(116,'2024-07-05 16:17:50',1,0,0,0,3,6,0,0,9,'2024-07-05'),(117,'2024-07-05 16:17:50',3,0,0,0,0,1,0,0,1,'2024-07-05'),(118,'2024-07-05 17:39:34',1,0,0,0,8,0,0,0,8,'2024-07-05'),(119,'2024-07-05 17:39:34',3,0,0,0,2,0,0,0,2,'2024-07-05'),(120,'2024-07-05 17:41:14',3,0,0,0,0,8,2,0,10,'2024-07-05'),(121,'2024-07-05 17:41:55',1,0,0,0,0,9,0,0,9,'2024-07-05'),(122,'2024-07-05 17:41:55',3,0,0,0,0,1,0,0,1,'2024-07-05'),(123,'2024-07-05 17:47:12',3,0,0,0,0,7,0,0,7,'2024-07-05'),(124,'2024-07-05 17:47:12',1,0,0,0,0,3,0,0,3,'2024-07-05'),(125,'2024-07-05 18:02:20',1,1,0,0,0,8,1,0,10,'2024-07-05'),(126,'2024-07-05 18:11:16',3,0,0,0,1,9,0,0,10,'2024-07-05'),(127,'2024-07-05 18:15:20',1,1,0,0,0,5,0,0,6,'2024-07-05'),(128,'2024-07-05 18:15:20',3,2,0,0,0,2,0,0,4,'2024-07-05'),(129,'2024-07-05 18:15:51',1,0,0,0,0,3,0,0,3,'2024-07-05'),(130,'2024-07-05 18:15:51',3,0,0,0,0,7,0,0,7,'2024-07-05'),(131,'2024-07-05 20:02:14',3,0,0,0,0,3,0,2,5,'2024-07-05'),(132,'2024-07-05 20:02:14',1,0,0,0,0,5,0,0,5,'2024-07-05'),(133,'2024-07-05 20:03:22',3,0,0,0,0,7,0,1,8,'2024-07-05'),(134,'2024-07-05 20:03:22',1,0,0,0,0,1,1,0,2,'2024-07-05'),(135,'2024-07-05 22:36:55',1,0,0,0,0,1,0,0,1,'2024-07-05'),(136,'2024-07-05 22:36:55',3,0,0,0,0,7,1,1,9,'2024-07-05'),(137,'2024-07-05 23:16:43',1,0,0,0,0,0,1,0,1,'2024-07-05'),(138,'2024-07-05 23:16:43',3,2,0,0,0,5,2,0,9,'2024-07-05'),(139,'2024-07-06 09:59:56',3,1,0,0,0,9,0,0,10,'2024-07-06'),(140,'2024-07-06 11:04:27',1,0,0,0,0,1,0,0,1,'2024-07-06'),(141,'2024-07-06 11:04:27',3,0,0,0,0,9,0,0,9,'2024-07-06'),(142,'2024-07-06 12:05:37',3,0,0,0,0,9,0,0,9,'2024-07-06'),(143,'2024-07-06 12:05:37',1,0,0,0,0,1,0,0,1,'2024-07-06'),(144,'2024-07-06 12:07:38',3,0,0,0,0,5,1,0,6,'2024-07-06'),(145,'2024-07-06 12:07:38',1,0,0,0,0,4,0,0,4,'2024-07-06'),(146,'2024-07-06 12:09:32',1,0,0,0,0,5,1,0,6,'2024-07-06'),(147,'2024-07-06 12:09:32',3,0,0,0,0,4,0,0,4,'2024-07-06'),(148,'2024-07-06 12:17:38',1,0,0,0,0,4,0,0,4,'2024-07-06'),(149,'2024-07-06 12:17:38',3,0,0,0,0,6,0,0,6,'2024-07-06'),(150,'2024-07-06 12:18:07',3,0,0,0,4,6,0,0,10,'2024-07-06'),(151,'2024-07-06 15:00:30',3,2,0,0,0,7,1,0,10,'2024-07-06'),(152,'2024-07-06 16:03:40',3,0,0,0,10,0,0,0,10,'2024-07-06'),(153,'2024-07-06 16:05:54',3,0,0,0,0,10,0,0,10,'2024-07-06'),(154,'2024-07-06 16:08:09',1,0,0,0,0,3,0,0,3,'2024-07-06'),(155,'2024-07-06 16:08:09',3,0,0,0,0,7,0,0,7,'2024-07-06'),(156,'2024-07-06 16:09:05',3,0,0,0,0,10,0,0,10,'2024-07-06'),(157,'2024-07-06 16:29:26',3,0,0,0,2,4,0,0,6,'2024-07-06'),(158,'2024-07-06 16:29:26',1,0,0,0,2,2,0,0,4,'2024-07-06'),(159,'2024-07-06 16:29:51',3,0,0,0,0,10,0,0,10,'2024-07-06'),(160,'2024-07-06 17:17:29',3,0,0,0,0,8,0,2,10,'2024-07-06'),(161,'2024-07-06 18:07:48',3,3,0,0,0,7,0,0,10,'2024-07-06'),(162,'2024-07-09 21:52:49',3,2,0,0,0,8,0,0,10,'2024-07-09'),(163,'2024-07-09 21:53:36',24,0,0,0,0,10,0,0,10,'2024-07-09'),(164,'2024-07-09 21:55:14',24,0,0,0,0,10,0,0,10,'2024-07-09'),(165,'2024-07-09 21:56:43',24,0,0,0,10,0,0,0,10,'2024-07-09'),(166,'2024-07-09 21:59:00',24,0,0,0,3,7,0,0,10,'2024-07-09'),(167,'2024-07-12 15:57:19',1,0,0,0,0,9,1,0,10,'2024-07-12'),(168,'2024-07-12 15:57:46',3,0,0,0,0,10,0,0,10,'2024-07-12'),(169,'2024-07-12 15:59:02',3,1,0,0,0,9,0,0,10,'2024-07-12'),(170,'2024-07-12 16:00:38',1,0,0,0,0,6,3,0,9,'2024-07-12'),(171,'2024-07-12 16:00:38',3,0,0,0,0,0,1,0,1,'2024-07-12'),(172,'2024-07-12 16:07:28',3,0,0,0,1,9,0,0,10,'2024-07-12'),(173,'2024-07-12 16:09:13',3,0,0,0,0,6,0,0,6,'2024-07-12'),(174,'2024-07-12 16:09:13',1,0,0,0,1,3,0,0,4,'2024-07-12'),(175,'2024-07-13 16:44:24',3,0,0,0,1,9,0,0,10,'2024-07-13'),(176,'2024-07-13 23:45:47',1,0,0,0,0,1,0,0,1,'2024-07-13'),(177,'2024-07-13 23:45:47',3,0,0,0,0,9,0,0,9,'2024-07-13'),(178,'2024-07-14 00:21:04',3,0,0,0,0,10,0,0,10,'2024-07-14'),(179,'2024-07-14 20:08:39',3,0,0,0,0,10,0,0,10,'2024-07-14'),(180,'2024-07-14 20:17:18',3,0,0,0,0,8,0,1,9,'2024-07-14'),(181,'2024-07-14 20:17:18',1,1,0,0,0,0,0,0,1,'2024-07-14'),(182,'2024-07-14 22:02:59',3,0,0,0,0,10,0,0,10,'2024-07-14'),(183,'2024-07-14 23:59:21',1,0,2,0,0,0,1,0,3,'2024-07-14'),(184,'2024-07-14 23:59:21',3,2,0,0,0,4,1,0,7,'2024-07-14'),(185,'2024-07-15 07:54:22',3,0,0,0,0,10,0,0,10,'2024-07-15'),(186,'2024-07-15 08:57:03',3,0,0,0,0,9,0,0,9,'2024-07-15'),(187,'2024-07-15 08:57:03',1,0,0,0,0,1,0,0,1,'2024-07-15'),(188,'2024-07-15 09:42:37',3,0,0,0,9,0,0,0,9,'2024-07-15'),(189,'2024-07-15 09:42:37',1,0,0,0,1,0,0,0,1,'2024-07-15'),(190,'2024-07-15 10:50:52',1,0,0,1,0,1,0,0,2,'2024-07-15'),(191,'2024-07-15 10:50:52',3,0,0,0,0,6,0,2,8,'2024-07-15'),(192,'2024-07-15 11:31:56',1,0,0,0,1,6,0,0,7,'2024-07-15'),(193,'2024-07-15 11:31:56',24,0,0,0,0,3,0,0,3,'2024-07-15'),(194,'2024-07-15 11:32:48',1,1,0,0,0,0,0,0,1,'2024-07-15'),(195,'2024-07-15 11:32:48',24,0,0,0,0,9,0,0,9,'2024-07-15'),(196,'2024-07-15 11:34:08',1,0,0,0,2,8,0,0,10,'2024-07-15'),(197,'2024-07-17 09:08:13',3,0,0,0,0,8,0,0,8,'2024-07-17'),(198,'2024-07-17 09:08:13',1,0,0,0,0,2,0,0,2,'2024-07-17'),(199,'2024-07-17 09:45:52',1,0,0,0,0,2,0,0,2,'2024-07-17'),(200,'2024-07-17 09:45:52',3,0,0,0,0,8,0,0,8,'2024-07-17'),(201,'2024-07-17 11:12:24',1,0,0,0,0,1,1,0,2,'2024-07-17'),(202,'2024-07-17 11:12:24',3,0,0,0,0,8,0,0,8,'2024-07-17'),(203,'2024-07-17 11:18:57',1,1,0,0,1,2,0,0,4,'2024-07-17'),(204,'2024-07-17 11:18:57',3,0,0,0,0,6,0,0,6,'2024-07-17'),(205,'2024-07-17 11:19:33',1,0,0,0,0,9,0,0,9,'2024-07-17'),(206,'2024-07-17 11:19:33',3,0,0,0,0,1,0,0,1,'2024-07-17'),(207,'2024-07-17 11:24:16',1,0,0,1,0,3,0,0,4,'2024-07-17'),(208,'2024-07-17 11:24:16',3,0,0,0,0,4,2,0,6,'2024-07-17'),(209,'2024-07-17 11:24:49',3,0,0,0,0,8,2,0,10,'2024-07-17'),(210,'2024-07-17 17:06:33',1,0,0,0,0,1,0,0,1,'2024-07-17'),(211,'2024-07-17 17:06:33',3,0,0,0,0,9,0,0,9,'2024-07-17'),(212,'2024-07-17 17:49:21',1,0,0,0,0,3,0,1,4,'2024-07-17'),(213,'2024-07-17 17:49:21',3,0,0,0,0,4,0,2,6,'2024-07-17'),(214,'2024-07-17 17:49:46',1,0,0,0,0,1,0,0,1,'2024-07-17'),(215,'2024-07-17 17:49:46',3,0,0,0,0,9,0,0,9,'2024-07-17'),(216,'2024-07-17 18:42:36',3,0,0,0,0,8,0,2,10,'2024-07-17'),(217,'2024-07-17 18:49:05',3,4,0,0,0,6,0,0,10,'2024-07-17'),(218,'2024-07-17 23:00:17',3,0,0,0,0,10,0,0,10,'2024-07-17'),(219,'2024-07-18 07:50:23',1,2,0,0,0,8,0,0,10,'2024-07-18'),(220,'2024-07-18 07:51:50',1,1,0,0,0,8,1,0,10,'2024-07-18'),(221,'2024-07-25 11:32:30',1,0,0,0,3,0,0,0,3,'2024-07-25'),(222,'2024-07-25 11:32:30',3,0,0,0,0,7,0,0,7,'2024-07-25'),(223,'2024-07-25 21:44:37',1,0,0,0,0,2,0,0,2,'2024-07-25'),(224,'2024-07-25 21:44:37',3,0,0,0,0,8,0,0,8,'2024-07-25'),(225,'2024-07-31 17:17:53',1,0,0,0,0,2,0,0,2,'2024-07-31'),(226,'2024-07-31 17:17:53',25,0,0,0,0,8,0,0,8,'2024-07-31'),(227,'2024-07-31 17:18:39',3,0,0,0,0,8,1,0,9,'2024-07-31'),(228,'2024-07-31 17:18:39',1,0,0,0,0,1,0,0,1,'2024-07-31'),(229,'2024-07-31 17:19:25',25,0,0,0,0,8,0,0,8,'2024-07-31'),(230,'2024-07-31 17:19:25',1,0,0,0,0,2,0,0,2,'2024-07-31'),(231,'2024-07-31 17:44:38',1,0,0,0,0,1,0,0,1,'2024-07-31'),(232,'2024-07-31 17:44:38',25,0,0,0,0,9,0,0,9,'2024-07-31'),(233,'2024-08-01 14:51:37',1,0,0,0,0,1,0,0,1,'2024-08-01'),(234,'2024-08-01 14:51:37',25,0,0,0,4,5,0,0,9,'2024-08-01'),(235,'2024-08-02 20:27:13',1,1,0,0,1,2,2,0,6,'2024-08-02'),(236,'2024-08-02 20:27:13',25,0,0,0,0,4,0,0,4,'2024-08-02'),(237,'2024-08-02 20:27:51',25,0,0,0,0,10,0,0,10,'2024-08-02'),(238,'2024-08-06 15:32:38',1,0,0,0,0,2,1,0,3,'2024-08-06'),(239,'2024-08-06 15:32:38',25,0,0,0,0,7,0,0,7,'2024-08-06'),(240,'2024-08-06 20:24:28',1,0,0,0,0,1,0,0,1,'2024-08-06'),(241,'2024-08-06 20:24:28',25,0,0,0,0,9,0,0,9,'2024-08-06'),(242,'2024-08-07 15:01:34',25,0,0,0,1,9,0,0,10,'2024-08-07'),(243,'2024-08-07 17:11:55',25,0,0,0,0,10,0,0,10,'2024-08-07'),(244,'2024-08-08 22:45:44',1,0,0,0,1,3,0,0,4,'2024-08-08'),(245,'2024-08-08 22:45:44',25,0,0,0,0,6,0,0,6,'2024-08-08'),(246,'2024-08-08 22:46:00',1,0,0,1,0,1,0,0,2,'2024-08-08'),(247,'2024-08-08 22:46:00',25,0,0,0,0,8,0,0,8,'2024-08-08'),(248,'2024-08-09 11:19:57',25,0,0,0,0,9,0,0,9,'2024-08-09'),(249,'2024-08-09 11:19:57',1,0,0,0,0,1,0,0,1,'2024-08-09'),(250,'2024-08-11 08:45:29',25,0,0,0,0,6,0,0,6,'2024-08-11'),(251,'2024-08-11 08:45:29',1,0,0,0,0,4,0,0,4,'2024-08-11'),(252,'2024-08-11 08:45:51',25,1,0,0,0,6,0,0,7,'2024-08-11'),(253,'2024-08-11 08:45:51',1,0,0,0,0,3,0,0,3,'2024-08-11'),(254,'2024-08-26 20:43:22',25,0,0,0,0,8,0,0,8,'2024-08-26'),(255,'2024-08-26 20:43:22',1,0,0,0,0,2,0,0,2,'2024-08-26'),(256,'2024-08-31 18:07:10',25,0,0,0,0,10,0,0,10,'2024-08-31'),(257,'2024-09-21 18:22:09',3,6,0,0,0,2,2,0,10,'2024-09-21'),(258,'2024-09-21 18:23:41',3,0,0,0,10,0,0,0,10,'2024-09-21'),(259,'2024-09-28 09:55:13',25,0,0,0,0,10,0,0,10,'2024-09-28'),(260,'2024-10-03 13:58:00',25,0,0,0,0,8,0,0,8,'2024-10-03'),(261,'2024-10-03 13:58:00',1,0,0,0,0,2,0,0,2,'2024-10-03'),(262,'2024-10-03 22:21:24',1,1,0,0,1,7,1,0,10,'2024-10-03'),(263,'2024-10-03 22:21:28',1,0,0,0,1,7,2,0,10,'2024-10-03'),(264,'2024-10-03 22:23:15',1,0,0,0,3,4,3,0,10,'2024-10-03'),(265,'2024-10-04 08:39:23',3,0,0,0,0,10,0,0,10,'2024-10-04');
/*!40000 ALTER TABLE `detecciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `diseno`
--

DROP TABLE IF EXISTS `diseno`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `diseno` (
  `dis_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dis_nombre` varchar(145) NOT NULL DEFAULT '',
  `dis_color_fondo` varchar(45) NOT NULL DEFAULT '',
  `dis_color_letra` varchar(45) NOT NULL DEFAULT '',
  `dis_archivo` varchar(145) NOT NULL DEFAULT '',
  `dis_estado` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`dis_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `diseno`
--

LOCK TABLES `diseno` WRITE;
/*!40000 ALTER TABLE `diseno` DISABLE KEYS */;
INSERT INTO `diseno` (`dis_codi`, `dis_nombre`, `dis_color_fondo`, `dis_color_letra`, `dis_archivo`, `dis_estado`) VALUES (1,'NINGUNO','#666666','#FFFFFF','',0),(2,'DISEÑO 1','#666666','#FFFFFF','BG-NEBRO-GRIS1.PNG',0),(3,'DISEÑO 2','#666666','#FFFFFF','BG-NEBRO-GRIS2.PNG',0),(4,'DISEÑO 3','#666666','#FFFFFF','BG-NEBRO-GRIS3.PNG',0),(5,'DISEÑO 4','#666666','#FFFFFF','BG-NEBRO-GRIS4.PNG',0),(6,'DISEÑO 5','#666666','#FFFFFF','BG-NEBRO-GRIS5.PNG',0),(7,'DISEÑO 6','#666666','#FFFFFF','BG-NEBRO-GRIS6.PNG',0),(8,'DISEÑO 7','#666666','#FFFFFF','BG-NEBRO-GRIS7.PNG',0),(9,'DISEÑO 8','#666666','#FFFFFF','BG-NEBRO-GRIS8.PNG',0),(10,'DISEÑO 9','#666666','#FFFFFF','BG-NEBRO-AZUL9.PNG',0),(11,'DISEÑO 10','#666666','#FFFFFF','BG-NEBRO-VERDE10.PNG',0),(12,'DISEÑO 11','#666666','#FFFFFF','BG-NEBRO-AMARILLO11.PNG',0),(13,'DISEÑO 12','#666666','#FFFFFF','BG-NEBRO-ROJO12.PNG',0),(14,'MANTEL','#666666','#FFFFFF','BG-MANTEL.PNG',1),(15,'CERAMICO','#FFFFFF','#FFFFFF','BG-CERAMICOS.PNG',1),(16,'METAL','#666666','#FFFFFF','BG-METAL.PNG',1),(17,'MADERA','#666666','#FFFFFF','BG-MADERA.PNG',1),(18,'VARIOS','#666666','#FFFFFF','BG-VARIOS.PNG',1),(19,'HERRAMIENTAS','#666666','#FFFFFF','BG-HERRAMIENTAS.PNG',1),(20,'PIES','#666666','#FFFFFF','BG-PIES.PNG',1),(21,'BEBE','#666666','#FFFFFF','BG-BEBE.PNG',1),(22,'FIESTA','#666666','#D5D5FF','BG-FIESTA.PNG',1),(23,'NUBES OSCURAS','#666666','#FFFFFF','BG-NUBES_OSCURAS.PNG',0),(24,'NUBES','#FFFFFF','#FFFFFF','BG-NUBES.PNG',0),(25,'JEAN','#FFFFFF','#FFFFFF','BG-JEAN.PNG',1),(26,'MILITAR','#FFFFFF','#FFFFFF','BG-MILITAR.PNG',1),(27,'PSICODELICO','#FFFFFF','#FFFFFF','BG-PSICODELICO.PNG',1),(28,'ESTRELLAS','#FFFFFF','#FFFFFF','BG-ESTRELLAS.PNG',1),(29,'ESTRELLAS 2','#FFFFFF','#FFFFFF','BG-ESTRELLAS2.PNG',1),(30,'ESTRELLAS 3','#FFFFFF','#FFFFFF','BG-ESTRELLAS3.PNG',1),(31,'CORAZONES','#FFFFFF','#FFFFFF','BG-CORAZONES.PNG',1),(32,'INFORMATICO','#FFFFFF','#FFFFFF','BG-INFORMATICO.PNG',1),(33,'MEDICO','#FFFFFF','#FFFFFF','BG-MEDICO.PNG',0),(34,'MERCADO','#FFFFFF','#FFFFFF','BG-MERCADO.PNG',1),(35,'MERCADO 2','#FFFFFF','#FFFFFF','BG-MERCADO2.PNG',1),(36,'BURGERS','#FFFFFF','#FFFFFF','BG-BURGERS.PNG',1),(37,'NAVIDAD','#FFFFFF','#FFFFFF','BG-NAVIDAD.PNG',1),(38,'HALLOWEN','#FFFFFF','#FFFFFF','BG-HALLOWEN.PNG',1),(39,'NAVIDAD2','#FFFFFF','#FFFFFF','BG-NAVIDAD2.PNG',1),(40,'NAVIDAD3','#FFFFFF','#FFFFFF','BG-NAVIDAD3.PNG',1),(41,'FIESTA2','#FFFFFF','#FFFFFF','BG-FIESTA2.PNG',1),(42,'CARTON','#FFFFFF','#FFFFFF','BG-CARTON.PNG',1),(43,'AGUA','#FFFFFF','#FFFFFF','BG-AGUA.PNG',1),(44,'AGUA 2','#FFFFFF','#FFFFFF','BG-AGUA2.PNG',1),(45,'HELLO KITY','#FFFFFF','#FFFFFF','BG-HELLOKITY.PNG',1),(46,'DOLARES','#FFFFFF','#FFFFFF','BG-DOLARES.PNG',1),(47,'GOTAS','#FFFFFF','#FFFFFF','BG-GOTAS.PNG',1),(48,'GLOBOS','#FFFFFF','#FFFFFF','BG-GLOBOS.PNG',1),(49,'GRASS','#FFFFFF','#FFFFFF','BG-GRASS.PNG',1),(50,'OLEO','#FFFFFF','#FFFFFF','BG-OLEO.PNG',1),(51,'OLEO2','#FFFFFF','#FFFFFF','BG-OLEO2.PNG',1),(52,'BITS','#FFFFFF','#FFFFFF','BG-BITS.PNG',0),(53,'IA','#FFFFFF','#FFFFFF','BG-IA.PNG',0),(54,'GALA','#FFFFFF','#FFFFFF','BG-GALA.PNG',0),(55,'LICORERIA','#FFFFFF','#FFFFFF','BG-LICORERIA.PNG',1),(56,'BG-DISCOTECA','#FFFFFF','#FFFFFF','BG-DISCOTECA.PNG',1),(57,'BG-RESTOBAR','#FFFFFF','#FFFFFF','BG-RESTOBAR.PNG',1),(58,'BG-FARMACIA','#FFFFFF','#FFFFFF','BG-FARMACIA.PNG',1),(59,'BG-FARMACIA2','#FFFFFF','#FFFFFF','BG-FARMACIA2.PNG',1),(60,'1-BG-SAGAZ','#FFFFFF','#FFFFFF','1-BG-SAGAZ.PNG',1),(61,'2-BG-SAGAZ','#FFFFFF','#FFFFFF','2-BG-SAGAZ.PNG',1),(62,'3-BG-SAGAZ','#FFFFFF','#FFFFFF','3-BG-SAGAZ.PNG',1),(63,'4-BG-SAGAZ','#FFFFFF','#FFFFFF','4-BG-SAGAZ.PNG',1),(64,'5-BG-SAGAZ','#FFFFFF','#FFFFFF','5-BG-SAGAZ.PNG',1),(65,'6-BG-SAGAZ','#FFFFFF','#FFFFFF','6-BG-SAGAZ.PNG',1),(66,'7-BG-SAGAZ','#FFFFFF','#FFFFFF','7-BG-SAGAZ.PNG',1),(67,'8-BG-SAGAZ','#FFFFFF','#FFFFFF','8-BG-SAGAZ.PNG',1),(68,'9-BG-SAGAZ','#FFFFFF','#FFFFFF','9-BG-SAGAZ.PNG',1),(69,'10-BG-SAGAZ','#FFFFFF','#FFFFFF','10-BG-SAGAZ.PNG',1),(70,'0-ALIAZIONE-1','#FFFFFF','#FFFFFF','0-ALIAZIONE-1.PNG',1),(71,'0-ALIAZIONE-2','#FFFFFF','#FFFFFF','0-ALIAZIONE-2.PNG',1),(72,'0-ALIAZIONE-3','#FFFFFF','#FFFFFF','0-ALIAZIONE-3.PNG',1),(73,'0-ALIAZIONE-4','#FFFFFF','#FFFFFF','0-ALIAZIONE-4.PNG',1);
/*!40000 ALTER TABLE `diseno` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `documento_pago`
--

DROP TABLE IF EXISTS `documento_pago`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documento_pago` (
  `docpag_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `docpag_nombre` varchar(45) NOT NULL DEFAULT '',
  `docpag_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `comtip_codigo_fk` char(2) NOT NULL DEFAULT '',
  `doctip_codi_compatible` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`docpag_codi`),
  UNIQUE KEY `Index_docpag_nombre` (`docpag_nombre`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documento_pago`
--

LOCK TABLES `documento_pago` WRITE;
/*!40000 ALTER TABLE `documento_pago` DISABLE KEYS */;
INSERT INTO `documento_pago` (`docpag_codi`, `docpag_nombre`, `docpag_estado`, `comtip_codigo_fk`, `doctip_codi_compatible`) VALUES (1,'NOTA DE VENTA',1,'00',11),(2,'BOLETA',1,'03',2),(3,'FACTURA',1,'01',1);
/*!40000 ALTER TABLE `documento_pago` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `documento_tipo`
--

DROP TABLE IF EXISTS `documento_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documento_tipo` (
  `doctip_codi` int(11) NOT NULL AUTO_INCREMENT,
  `doctip_nombre` varchar(145) DEFAULT NULL,
  `doctip_estado` int(11) NOT NULL DEFAULT 1,
  `doctip_abreviatura` varchar(45) DEFAULT NULL,
  `doctip_usu_crea` varchar(45) DEFAULT NULL,
  `doctip_usu_modifica` varchar(45) DEFAULT NULL,
  `doctip_usu_activa` varchar(45) DEFAULT NULL,
  `doctip_documentado` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`doctip_codi`),
  UNIQUE KEY `Index_doctip_nombre` (`doctip_nombre`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documento_tipo`
--

LOCK TABLES `documento_tipo` WRITE;
/*!40000 ALTER TABLE `documento_tipo` DISABLE KEYS */;
INSERT INTO `documento_tipo` (`doctip_codi`, `doctip_nombre`, `doctip_estado`, `doctip_abreviatura`, `doctip_usu_crea`, `doctip_usu_modifica`, `doctip_usu_activa`, `doctip_documentado`) VALUES (1,'FACTURA',1,'',NULL,NULL,NULL,1),(2,'BOLETA',1,'BOL',NULL,NULL,NULL,1),(3,'RECIBO',1,NULL,NULL,NULL,NULL,0),(4,'GUIA DE REMISION',1,'',NULL,'LSANCHEZ',NULL,1),(5,'NOTA DE CREDITO',1,NULL,NULL,NULL,NULL,0),(6,'NOTA DE DEBITO',1,NULL,NULL,NULL,NULL,0),(7,'BOLETO DE DEPOSITO',1,NULL,NULL,NULL,NULL,0),(8,'CHEQUE',1,NULL,NULL,NULL,NULL,0),(9,'PAGARE',1,NULL,NULL,NULL,NULL,0),(10,'ORDEN DE COMPRA',1,NULL,NULL,NULL,NULL,0),(11,'NOTA DE VENTA',1,'',NULL,NULL,NULL,0),(12,'NOTA DE VENTA22',1,'',NULL,NULL,NULL,0),(13,'REPORTE',1,'','MRODRIGUEZ',NULL,NULL,0),(14,'NOTA DE PEDIDO',1,'','ACARRASCO',NULL,NULL,0);
/*!40000 ALTER TABLE `documento_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `empresas`
--

DROP TABLE IF EXISTS `empresas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `empresas` (
  `emp_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `emp_nom` varchar(45) NOT NULL DEFAULT '',
  `emp_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `emp_direccion` text DEFAULT NULL,
  `emp_telefono` varchar(45) DEFAULT NULL,
  `emp_ciudad` varchar(45) DEFAULT NULL,
  `emp_usu_crea` varchar(45) DEFAULT NULL,
  `emp_usu_modifica` varchar(45) DEFAULT NULL,
  `emp_usu_activa` varchar(45) DEFAULT NULL,
  `emprai_codi_fk` int(11) NOT NULL DEFAULT 0,
  `emp_exonerado_igv` varchar(45) NOT NULL DEFAULT '0',
  `emp_direccion_partida` text DEFAULT NULL,
  PRIMARY KEY (`emp_codi`),
  UNIQUE KEY `Index_emp_nom` (`emp_nom`),
  KEY `Index_emp_estado` (`emp_estado`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `empresas`
--

LOCK TABLES `empresas` WRITE;
/*!40000 ALTER TABLE `empresas` DISABLE KEYS */;
INSERT INTO `empresas` (`emp_codi`, `emp_nom`, `emp_estado`, `emp_direccion`, `emp_telefono`, `emp_ciudad`, `emp_usu_crea`, `emp_usu_modifica`, `emp_usu_activa`, `emprai_codi_fk`, `emp_exonerado_igv`, `emp_direccion_partida`) VALUES (1,'ALIAZIONE',1,'CAL.EL MENSAJERO NRO. 195 URB. LAS BRISAS LAMBAYEQUE - CHICLAYO - CHICLAYO','TELF: 998642256','CHICLAYO',NULL,NULL,NULL,1,'0','CAL.EL MENSAJERO NRO. 195 URB. LAS BRISAS LAMBAYEQUE - CHICLAYO - CHICLAYO');
/*!40000 ALTER TABLE `empresas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `empresas_cuenta`
--

DROP TABLE IF EXISTS `empresas_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `empresas_cuenta` (
  `empcue_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `empcue_banco` varchar(245) NOT NULL DEFAULT '',
  `empcue_nro` varchar(245) DEFAULT NULL,
  `empcue_nro_cci` varchar(245) DEFAULT NULL,
  `empcue_moneda` varchar(145) DEFAULT NULL,
  `empcue_estado` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`empcue_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `empresas_cuenta`
--

LOCK TABLES `empresas_cuenta` WRITE;
/*!40000 ALTER TABLE `empresas_cuenta` DISABLE KEYS */;
INSERT INTO `empresas_cuenta` (`empcue_codi`, `emp_codi_fk`, `empcue_banco`, `empcue_nro`, `empcue_nro_cci`, `empcue_moneda`, `empcue_estado`) VALUES (1,1,'BANCO CONTINENTAL','001102870100040729','011-287-001102870100040729-04','SOLES',1),(2,1,'BANCO DE CREDITO DEL PERU','30506842959066','002-305106842959066-10','SOLES',1);
/*!40000 ALTER TABLE `empresas_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `empresas_raiz`
--

DROP TABLE IF EXISTS `empresas_raiz`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `empresas_raiz` (
  `emprai_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `emprai_razon_social` varchar(240) NOT NULL DEFAULT '',
  `emprai_nombre_comercial` varchar(240) NOT NULL DEFAULT '',
  `emprai_ruc` varchar(45) NOT NULL DEFAULT '',
  `emprai_estado` int(10) unsigned NOT NULL DEFAULT 0,
  `emprai_facturacion_electronica` int(10) unsigned NOT NULL DEFAULT 0,
  `emprai_direccion` varchar(245) NOT NULL DEFAULT '',
  `emprai_web` varchar(245) NOT NULL,
  `emprai_email` varchar(245) NOT NULL,
  `emprai_departamento` varchar(245) NOT NULL DEFAULT '',
  `emprai_provincia` varchar(245) NOT NULL DEFAULT '',
  `emprai_distrito` varchar(245) NOT NULL DEFAULT '',
  PRIMARY KEY (`emprai_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `empresas_raiz`
--

LOCK TABLES `empresas_raiz` WRITE;
/*!40000 ALTER TABLE `empresas_raiz` DISABLE KEYS */;
INSERT INTO `empresas_raiz` (`emprai_codi`, `emprai_razon_social`, `emprai_nombre_comercial`, `emprai_ruc`, `emprai_estado`, `emprai_facturacion_electronica`, `emprai_direccion`, `emprai_web`, `emprai_email`, `emprai_departamento`, `emprai_provincia`, `emprai_distrito`) VALUES (1,'ALIAZIONE COSTRUZIONE E SALDATURA E.I.R.L.','ALIAZIONE E.I.R.L.','20480823860',1,1,'CAL.EL MENSAJERO NRO. 195 URB. LAS BRISAS LAMBAYEQUE - CHICLAYO - CHICLAYO','www.gruppoindustrialealiazione.org','cbotello.aliazioneperu@gmail.com','LAMBAYEQUE','CHICLAYO','CHICLAYO');
/*!40000 ALTER TABLE `empresas_raiz` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `especialistascomunitarios`
--

DROP TABLE IF EXISTS `especialistascomunitarios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `especialistascomunitarios` (
  `espcom_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `espcom_nombres` varchar(145) NOT NULL DEFAULT '',
  `espcom_apellido_paterno` varchar(145) NOT NULL DEFAULT '',
  `espcom_apellido_materno` varchar(145) NOT NULL DEFAULT '',
  `espcom_dni` varchar(45) NOT NULL DEFAULT '',
  `espcom_direccion` varchar(245) NOT NULL DEFAULT '',
  `espcom_telefono` varchar(45) NOT NULL DEFAULT '',
  `espcom_ocupacion` varchar(245) NOT NULL DEFAULT '',
  `espcom_cargo` varchar(245) NOT NULL DEFAULT '',
  `espcom_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `espcom_ratificar` int(10) unsigned NOT NULL DEFAULT 0,
  `espcom_id_trans` varchar(145) DEFAULT NULL,
  `espcom_usu_codi_crea` int(10) unsigned DEFAULT NULL,
  `espcom_usu_codi_modifica` int(10) unsigned DEFAULT NULL,
  `espcom_vectorfacial` text DEFAULT NULL,
  `espcom_vectorfacial2` text DEFAULT NULL,
  `espcom_base64facial` text DEFAULT NULL,
  PRIMARY KEY (`espcom_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `especialistascomunitarios`
--

LOCK TABLES `especialistascomunitarios` WRITE;
/*!40000 ALTER TABLE `especialistascomunitarios` DISABLE KEYS */;
INSERT INTO `especialistascomunitarios` (`espcom_codi`, `espcom_nombres`, `espcom_apellido_paterno`, `espcom_apellido_materno`, `espcom_dni`, `espcom_direccion`, `espcom_telefono`, `espcom_ocupacion`, `espcom_cargo`, `espcom_estado`, `espcom_ratificar`, `espcom_id_trans`, `espcom_usu_codi_crea`, `espcom_usu_codi_modifica`, `espcom_vectorfacial`, `espcom_vectorfacial2`, `espcom_base64facial`) VALUES (1,'-NO-RECONOCIDO','-','-','-','','','','',1,0,'17187570277514807323',NULL,NULL,NULL,NULL,NULL),(3,'EDUARDO ALFONSO','TORRES','LUNA','16754598','LAS HIEDRAS 355 - VILLARREAL - CHICLAYO','954618004','ING. SISTEMAS','ANALISTA PROGRAMADOR DE SISTEMAS',1,1,NULL,NULL,NULL,'0.14926761, 0.04471046, 0.0802986, 0.10617673999999999, 0.02390421, 0.05181621, 0.021355640000000002, 0.04929566, 0.08761067, 0.07984375, 0.07127048000000001, 0.06916280000000001, 0.06571469999999999, 0.060055979999999995, 0.15421947, 0.16691831999999998, 0.14629778999999998, 0.13228721, 0.11091508, 0.06272086, 0.00733658, 0.011346410000000001, 0.08580759, 0.05323738, 0.10110833, 0.04523414, 0.027961649999999998, 0.02796568, 0.02872777, 0.061035, 0.05547981, 0.05610192, 0.059589300000000005, 0.03816234, 0.032444629999999995, 0.02872777, 0.032444629999999995, 0.15049631, 0.14995992000000002, 0.10457146,,, 0.14970281, 0.04473763, 0.08006431, 0.10631269, 0.02345178, 0.0511669, 0.02173856, 0.04980345, 0.08603501, 0.08099354, 0.0705658, 0.06980141999999999, 0.06410542, 0.06077224, 0.15332875999999998, 0.1663646, 0.14515424, 0.13120700999999999, 0.10999217, 0.06230732, 0.00746514, 0.01146177, 0.08523909, 0.053078600000000004, 0.10096823, 0.04516254, 0.02776896, 0.028086200000000002, 0.028673570000000002, 0.06084644, 0.05536649, 0.05624539, 0.05969223, 0.03732138, 0.03268673, 0.028673570000000002, 0.03268673, 0.15083611, 0.15040192, 0.10496616,,, 0.14914257, 0.04466001, 0.07987156000000001, 0.10718208, 0.024631229999999997, 0.05265038, 0.0209923, 0.048890949999999996, 0.08918161999999999, 0.07811117000000001, 0.0723962, 0.06905345, 0.06703847, 0.05831153, 0.15388299, 0.16680007, 0.14607579999999998, 0.13205135, 0.11065604000000001, 0.06225331, 0.0074542, 0.0114717, 0.08557924, 0.05310534, 0.10153844, 0.04559044, 0.02807799, 0.02792966, 0.02885021, 0.06102259, 0.055321060000000005, 0.0559019, 0.059335610000000004, 0.039000749999999994, 0.0315905, 0.02885021, 0.0315905, 0.15020094, 0.14984265, 0.1045255,,, 0.14984861000000002, 0.04358138, 0.07853879999999999, 0.10816117, 0.02427201, 0.052196269999999996, 0.021197459999999998, 0.04912141, 0.08834974, 0.07855351000000001, 0.07144905, 0.06902592, 0.06602962999999999, 0.05802609, 0.15296613, 0.16611059, 0.14489082, 0.13075292, 0.10960307, 0.06216004, 0.007763829999999999, 0.011770870000000001, 0.08487963999999999, 0.05284791, 0.10131762999999999, 0.04541117, 0.0279907, 0.02796208, 0.029008040000000002, 0.060032499999999996, 0.054329670000000004, 0.05491267, 0.05832316, 0.03865846, 0.03103531, 0.029008040000000002, 0.03103531, 0.15060235, 0.15025299, 0.1063035,,, 0.15000055, 0.04393218, 0.07901675, 0.10799505999999999, 0.02412253, 0.052159260000000006, 0.02189243, 0.05026485, 0.08703126, 0.08140885, 0.07156904, 0.07044073000000001, 0.06468385, 0.06044293, 0.1542779, 0.1676203, 0.14599209999999999, 0.13163972000000002, 0.11024657, 0.06260264, 0.00771275, 0.01175967, 0.08539991000000001, 0.05308388, 0.10242409999999999, 0.04595765, 0.028104749999999998, 0.02841001, 0.02923238, 0.060386989999999995, 0.054662010000000004, 0.05540068, 0.058904609999999996, 0.037760930000000005, 0.032416310000000004, 0.02923238, 0.032416310000000004, 0.15088429, 0.15036664, 0.10607783999999999','-0.09108251333236694, 0.06100701540708542, 0.030483338981866837, 0.029382558539509773, -0.0225689597427845, -0.09635426849126816, -0.03211615979671478, -0.12714779376983643, 0.2132944017648697, -0.06760072708129883, 0.2332690805196762, -0.012856516055762768, -0.2010258138179779, 0.002251365687698126, -0.0017231013625860214, 0.11897870898246765, -0.10183212161064148, -0.05708974972367287, -0.15533019602298737, -0.12193822860717773, 0.04266819357872009, -0.026657070964574814, 0.02127087488770485, 0.009090237319469452, -0.17282098531723022, -0.2570644021034241, -0.09553920477628708, -0.10442139953374863, 0.04372792690992355, -0.0595087856054306, 0.021120790392160416, -0.008744521997869015, -0.1244889497756958, -0.06500135362148285, 0.017932500690221786, 0.06875531375408173, -0.016993915662169456, 0.022701485082507133, 0.21972553431987762, 0.021277591586112976, -0.15900515019893646, 0.08955594897270203, 0.025689303874969482, 0.22423991560935974, 0.14283187687397003, 0.06304275989532471, 0.032802414149045944, -0.06098013371229172, 0.054628852754831314, -0.26875701546669006, 0.07713139057159424, 0.0856756642460823, 0.15757806599140167, 0.04280807077884674, 0.15679985284805298, -0.1822066307067871, -0.052915625274181366, 0.09174822270870209, -0.21146106719970703, 0.09958098083734512, 0.07998275756835938, -0.02014228329062462, -0.10700151324272156, -0.05156249552965164, 0.21873876452445984, 0.2171998918056488, -0.13589467108249664, -0.06206095963716507, 0.18593336641788483, -0.11870144307613373, -0.006515363231301308, 0.04472535848617554, -0.061033375561237335, -0.15972153842449188, -0.27483171224594116, 0.05394260585308075, 0.4916108548641205, 0.073222815990448, -0.189147487282753, -0.005248634144663811, -0.1091013178229332, -0.0038451976142823696, -0.012899585999548435, -0.08530241996049881, -0.13212916254997253, -0.023496871814131737, -0.03411410376429558, 0.0175252016633749, 0.1314244270324707, 0.003262430429458618, -0.007000016514211893, 0.16812457144260406, -0.014722855761647224, 0.015828203409910202, 0.0011351513676345348, 0.030832558870315552, -0.12255172431468964, -0.07743935286998749, -0.08842546492815018, -0.04947574436664581, 0.060281749814748764, -0.14456278085708618, 0.08344695717096329, 0.035091184079647064, -0.23051130771636963, 0.15669606626033783, 0.016579410061240196, -0.05829774588346481, 0.035270050168037415, 0.20473089814186096, -0.12555113434791565, 0.0018764067208394408, 0.1997106671333313, -0.2897369861602783, 0.25195619463920593, 0.16132017970085144, -0.02674028091132641, 0.11834660172462463, 0.024444380775094032, 0.09418364614248276, -0.03466450423002243, 0.0921807512640953, -0.0926155149936676, -0.11102862656116486, -0.07035303115844727, -0.03724902123212814, 0.04136884957551956, 0.09720161557197571','data:image/jpeg;base64,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'),(24,'CELIA GISSEL','TORRES','SANCHEZ','74680901','','','','',1,0,'17205797102959325009',NULL,NULL,'0.11922208999999999, 0.040145690000000005, 0.06809381, 0.09088939, 0.02436187, 0.0507319, 0.01552051, 0.038981949999999994, 0.08959088, 0.05666623, 0.06903601000000001, 0.05723547, 0.07346593, 0.04174523, 0.13582076, 0.14607291, 0.12797577, 0.1146679, 0.09560449, 0.04764304, 0.00638532, 0.0106377, 0.07231252, 0.04363543, 0.08946429, 0.03980827, 0.026382449999999998, 0.02346152, 0.02354469, 0.056706000000000006, 0.05059082, 0.04887415, 0.051629219999999997, 0.04759059, 0.01995038, 0.02354469, 0.01995038, 0.12186388, 0.12202029, 0.07985038,,, 0.11926433, 0.04060326, 0.06996288, 0.09432351, 0.02429332, 0.05093186, 0.01500507, 0.038406930000000006, 0.09109086999999999, 0.05599813, 0.06970318, 0.056677399999999996, 0.0758783, 0.041211109999999995, 0.13568141, 0.14654591, 0.12719626, 0.11320643, 0.09418138000000001, 0.0434039, 0.00681587, 0.011123599999999999, 0.0706396, 0.042769329999999994, 0.08905378, 0.039199599999999994, 0.02664722, 0.02340204, 0.02317632, 0.05809355, 0.05188254, 0.04944625, 0.05199705, 0.051548229999999994, 0.02088545, 0.02317632, 0.02088545, 0.12204380999999999, 0.12214958, 0.07965996,,, 0.11898398, 0.04093614, 0.06922394, 0.09325683, 0.024219169999999998, 0.05109408, 0.0156722, 0.03962788, 0.09130533, 0.05772493, 0.06976194, 0.057992310000000005, 0.07513656, 0.04234348, 0.13816338, 0.14880216999999998, 0.12987852, 0.11571016, 0.09607862, 0.04658197, 0.00655614, 0.01103613, 0.0719416, 0.04307783, 0.09048432, 0.03983776, 0.02689295, 0.02395749, 0.02408972, 0.05761897, 0.051387169999999996, 0.0494111, 0.05223882, 0.0499392, 0.02023554, 0.02408972, 0.02023554, 0.12157455, 0.12155017, 0.07881399,,, 0.11635299, 0.039704340000000005, 0.06907922000000001, 0.09059547999999999, 0.02456787, 0.05139342, 0.015789110000000002, 0.03968292, 0.09178503, 0.057518599999999996, 0.06982411000000001, 0.05747009, 0.07527712, 0.041900770000000004, 0.13872214, 0.14910793, 0.13039698000000002, 0.11603542, 0.09621399, 0.04880009, 0.0061937699999999995, 0.01051988, 0.07185944999999999, 0.042910130000000005, 0.09089871, 0.040329880000000005, 0.02684456, 0.023900420000000002, 0.0244972, 0.05653286, 0.05040932, 0.04822716, 0.0510349, 0.04885418, 0.01925655, 0.0244972, 0.01925655, 0.11895935, 0.11856119, 0.0773968,,, 0.11685183, 0.04050624, 0.06917828, 0.09134004, 0.02438789, 0.05146207, 0.016048919999999998, 0.04023399, 0.09104052, 0.05824682, 0.06996489, 0.05810113, 0.07469556, 0.042511270000000004, 0.1383446, 0.14904269, 0.13002526, 0.11560297, 0.09564182, 0.04728327, 0.00634601, 0.01076982, 0.07138809, 0.04250911, 0.09147651000000001, 0.040384569999999995, 0.02708856, 0.02418658, 0.02441444, 0.05726435, 0.05103364, 0.049095860000000005, 0.05194132, 0.04919262, 0.020154440000000003, 0.02441444, 0.020154440000000003, 0.11960891, 0.11942993, 0.07709951','-0.06701537221670151, 0.01594647392630577, 0.08101534843444824, -0.051350805908441544, -0.12630459666252136, 0.029682662338018417, -0.03114842250943184, -0.12347717583179474, 0.1867845505475998, -0.16656829416751862, 0.20647545158863068, 0.006381534971296787, -0.26529863476753235, 0.009090667590498924, 0.01629648171365261, 0.12524528801441193, -0.182708278298378, -0.12690499424934387, -0.028565138578414917, -0.01686101406812668, -0.001782950945198536, -0.013187951408326626, 0.039126209914684296, 0.08955676108598709, -0.09558255970478058, -0.3849870264530182, -0.11016987264156342, -0.08606143295764923, 0.035577256232500076, -0.05596459284424782, -0.014897122979164124, 0.02566075325012207, -0.1486896574497223, 0.05007621645927429, 0.017364848405122757, 0.06037251278758049, -0.06989956647157669, -0.12139525264501572, 0.21920858323574066, -0.009564563632011414, -0.20059338212013245, -0.04955259710550308, -0.014279915019869804, 0.1553468406200409, 0.13843730092048645, 0.08980883657932281, 0.0408584401011467, -0.08294561505317688, 0.06773409992456436, -0.25174272060394287, 0.0376032218337059, 0.16800786554813385, 0.029141081497073174, -0.00411610584706068, 0.06922338902950287, -0.21001023054122925, 0.005221618339419365, 0.04703564569354057, -0.15873311460018158, 0.0245052557438612, 0.019776400178670883, -0.08626122772693634, 0.005275418981909752, -0.05563557520508766, 0.2596930265426636, 0.12927092611789703, -0.13332387804985046, -0.0984911099076271, 0.15403415262699127, -0.19944262504577637, -0.038366302847862244, 0.04867507144808769, -0.14589188992977142, -0.196795254945755, -0.24534067511558533, 0.0033454224467277527, 0.509202778339386, 0.16526567935943604, -0.11940522491931915, 0.012269087135791779, -0.06533613801002502, -0.01868535205721855, 0.08615625649690628, 0.14159421622753143, -0.08460146188735962, -0.05742775276303291, -0.06210118532180786, 0.02438504435122013, 0.17039448022842407, -0.0041877999901771545, -0.040923960506916046, 0.18128906190395355, -0.035025205463171005, 0.06716076284646988, 0.006606582552194595, -0.017237219959497452, -0.06101831793785095, -0.009221633896231651, -0.05808497965335846, 0.0038218097761273384, -0.009267509914934635, -0.025690957903862, 0.045496709644794464, 0.13246095180511475, -0.18063943088054657, 0.08635041117668152, -0.03768330439925194, -0.08587516844272614, 0.058212727308273315, 0.08291608840227127, -0.15995930135250092, -0.08590405434370041, 0.13356302678585052, -0.31859302520751953, 0.16955120861530304, 0.19128216803073883, 0.016352051869034767, 0.16768203675746918, 0.034409888088703156, 0.12993721663951874, -0.014319383539259434, -0.007085053250193596, -0.16503837704658508, -0.05894692987203598, 0.04191874712705612, -0.02982380986213684, 0.08035445213317871, -0.020221509039402008','data:image/jpeg;base64,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'),(25,'EDUARDO EDINSON','BOTELLO','GUADALUPE','75495287','','916986177','INSTRUCTOR','JEFE DE VENTAS',1,0,'1722463915311872689',NULL,NULL,'0.11377428, 0.036154519999999996, 0.061598509999999995, 0.07701179999999999, 0.020802499999999998, 0.04405328, 0.015636419999999998, 0.03805016, 0.08135977, 0.0623543, 0.06070979, 0.05453268, 0.06468944, 0.048002960000000004, 0.13479993999999998, 0.14356591, 0.12883077, 0.11678738, 0.09747007, 0.049042430000000005, 0.00537493, 0.00876346, 0.07439610999999999, 0.04561688, 0.08208634000000001, 0.03643891, 0.023266059999999998, 0.02241553, 0.022313859999999998, 0.04916679, 0.04428797, 0.04391485, 0.04635452, 0.0410432, 0.02840683, 0.022313859999999998, 0.02840683, 0.11542525999999999, 0.11504474999999999, 0.07775074,,, 0.11378247, 0.03622127, 0.061856470000000004, 0.07723165, 0.020862870000000002, 0.044194809999999994, 0.0154343, 0.037857709999999996, 0.08169144, 0.061698970000000006, 0.06057298, 0.05420761, 0.06484639, 0.04736609, 0.13450651, 0.14320714, 0.12846498, 0.11648042, 0.0972113, 0.04927052, 0.00532956, 0.00877518, 0.07422796, 0.04539832, 0.08203531, 0.036297020000000006, 0.02334519, 0.02242453, 0.02246194, 0.04917829, 0.04436602, 0.044013, 0.046425579999999994, 0.04118412, 0.027869119999999997, 0.02246194, 0.027869119999999997, 0.11541048999999999, 0.11511486, 0.07771563000000001,,, 0.11334520999999999, 0.03653967, 0.06194767, 0.07705308999999999, 0.02084316, 0.04417456, 0.015389110000000001, 0.03783753, 0.08149342, 0.061825809999999995, 0.06068699, 0.05436824, 0.06469113, 0.04770719, 0.13448245, 0.14320215, 0.12855777000000002, 0.11665114, 0.09728542, 0.04903119, 0.00525223, 0.00872801, 0.07423309, 0.0453285, 0.08198231, 0.03622904, 0.02334311, 0.022448509999999998, 0.02235373, 0.04943621, 0.04462459, 0.04437904, 0.0467891, 0.04098914, 0.028262440000000003, 0.02235373, 0.028262440000000003, 0.11513374, 0.11487909, 0.07694421,,, 0.11413945, 0.036502110000000004, 0.06193739, 0.07779561, 0.020724589999999998, 0.04409473, 0.01561919, 0.03815705, 0.08121796, 0.062459350000000004, 0.06057571, 0.05463655, 0.06438755, 0.048052790000000005, 0.1346168, 0.1435436, 0.12855422, 0.11654962999999999, 0.09726759, 0.04903031, 0.00540124, 0.00887738, 0.07429876, 0.045511220000000005, 0.08222441000000001, 0.036341450000000004, 0.02338146, 0.022538150000000003, 0.02241652, 0.04949651, 0.04467922, 0.04437533, 0.046816989999999996, 0.040866349999999996, 0.02826145, 0.02241652, 0.02826145, 0.11592313, 0.11561956999999999, 0.07776674,,, 0.11328518, 0.03673021, 0.06160795, 0.07736197, 0.020687650000000002, 0.043990020000000005, 0.01558455, 0.03812504, 0.08082271, 0.0625473, 0.06048339, 0.054605690000000005, 0.06398701, 0.04835571, 0.13454913999999998, 0.14323674, 0.12866501, 0.11675282, 0.09744823, 0.049385370000000005, 0.00527871, 0.008789580000000002, 0.07440471, 0.04541503, 0.08208069, 0.036267049999999995, 0.023312509999999998, 0.02254051, 0.022452839999999998, 0.04952914, 0.04471882, 0.04451309, 0.046929729999999996, 0.04042228, 0.028671489999999997, 0.022452839999999998, 0.028671489999999997, 0.11521903, 0.11483067, 0.07666067,,, 0.11326331999999999, 0.03658529, 0.06161956, 0.07717708000000001, 0.02066614, 0.043926969999999996, 0.015455410000000001, 0.03789262, 0.08141322, 0.06255106, 0.06041198, 0.05435271, 0.06465025, 0.048408349999999996, 0.13528319, 0.14382274, 0.12930525, 0.11728977, 0.09779464, 0.049262459999999994, 0.00524566, 0.00879488, 0.07460973, 0.04553024, 0.08179173, 0.03611743, 0.023269500000000002, 0.02243722, 0.0224309, 0.04928582, 0.04450958, 0.04423483, 0.04660223, 0.04110694, 0.02876115, 0.0224309, 0.02876115, 0.11516141, 0.11475833, 0.07680325,,, 0.11328663, 0.03651776, 0.06141039, 0.07721207, 0.02078279, 0.04408484, 0.01550431, 0.03799321, 0.08136481999999999, 0.0622605, 0.06072399999999999, 0.0546483, 0.06468778, 0.048151809999999996, 0.13492428, 0.14354771, 0.12911919, 0.11723414, 0.09784817, 0.04924627, 0.00530888, 0.008856049999999999, 0.07471026, 0.04565465, 0.08203996, 0.03628134, 0.023312740000000002, 0.02248894, 0.02238301, 0.049385570000000004, 0.04452496, 0.0441794, 0.046621209999999996, 0.04107733, 0.02852488, 0.02238301, 0.02852488, 0.11524013999999999, 0.1148473, 0.07688971','-0.06576680392026901, 0.12110026925802231, 0.017387475818395615, -0.08377052843570709, -0.08641685545444489, 0.026915716007351875, -0.11499088257551193, -0.05111600086092949, 0.12036168575286865, -0.031166965141892433, 0.20589740574359894, -0.03057584911584854, -0.2407960146665573, -0.03514459729194641, -0.017389796674251556, 0.13551102578639984, -0.17864453792572021, -0.1304076910018921, -0.02915143594145775, -0.08966389298439026, 0.002937720622867346, -0.0015880269929766655, 0.03715958073735237, 0.040676042437553406, -0.11151913553476334, -0.3620798587799072, -0.0682123675942421, -0.06391655653715134, 0.07406021654605865, -0.02982822246849537, -0.03130493685603142, 0.03216422349214554, -0.17412707209587097, -0.04855826497077942, 0.08249595016241074, 0.10219988226890564, 0.0006057246355339885, 0.012922621332108974, 0.12164044380187988, 0.019532915204763412, -0.07097958028316498, 0.021862339228391647, 0.016897577792406082, 0.29218000173568726, 0.1325223743915558, 0.15037603676319122, 0.10257694870233536, -0.09571698307991028, 0.03541133552789688, -0.22448256611824036, 0.14961953461170197, 0.19004155695438385, 0.046319738030433655, 0.04653085768222809, 0.06536370515823364, -0.1254013180732727, -0.013372480869293213, 0.20031102001667023, -0.12418486922979355, 0.1411706954240799, 0.093899205327034, 0.04611121118068695, -0.038571447134017944, -0.11143592745065689, 0.3051314949989319, 0.10109138488769531, -0.16234776377677917, -0.15737372636795044, 0.1645718812942505, -0.07841850072145462, -0.10970092564821243, 0.0026152292266488075, -0.1348080337047577, -0.134373277425766, -0.2971581220626831, 0.10286211967468262, 0.360657662153244, 0.1466762274503708, -0.20005939900875092, -0.000023478176444768906, -0.06319671124219894, 0.023686379194259644, 0.05984259024262428, 0.053112391382455826, -0.0991763323545456, -0.056031860411167145, -0.09375081211328506, -0.02268286421895027, 0.1857377588748932, 0.011829495429992676, -0.033429957926273346, 0.18899492919445038, -0.004266367293894291, 0.022995341569185257, 0.004059816710650921, 0.10400783270597458, -0.13874641060829163, -0.032845452427864075, -0.16473549604415894, -0.09247279912233353, 0.03478346765041351, -0.03203285485506058, -0.016638876870274544, 0.19282124936580658, -0.1630687713623047, 0.12457604706287384, -0.06962348520755768, -0.018878266215324402, 0.014755146577954292, 0.10337024182081223, -0.06885740160942078, -0.12995027005672455, 0.14285479485988617, -0.24497517943382263, 0.1624806523323059, 0.2363685518503189, 0.10777093470096588, 0.09956614673137665, 0.07953331619501114, 0.09583305567502975, 0.03918682783842087, 0.012913729064166546, -0.14739613234996796, -0.09899774938821793, -0.00316439988091588, -0.02524307370185852, -0.03690864145755768, 0.0595611073076725','data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAAAQABAAD/4gHYSUNDX1BST0ZJTEUAAQEAAAHIAAAAAAQwAABtbnRyUkdCIFhZWiAH4AABAAEAAAAAAABhY3NwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQAA9tYAAQAAAADTLQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAlkZXNjAAAA8AAAACRyWFlaAAABFAAAABRnWFlaAAABKAAAABRiWFlaAAABPAAAABR3dHB0AAABUAAAABRyVFJDAAABZAAAAChnVFJDAAABZAAAAChiVFJDAAABZAAAAChjcHJ0AAABjAAAADxtbHVjAAAAAAAAAAEAAAAMZW5VUwAAAAgAAAAcAHMAUgBHAEJYWVogAAAAAAAAb6IAADj1AAADkFhZWiAAAAAAAABimQAAt4UAABjaWFlaIAAAAAAAACSgAAAPhAAAts9YWVogAAAAAAAA9tYAAQAAAADTLXBhcmEAAAAAAAQAAAACZmYAAPKnAAANWQAAE9AAAApbAAAAAAAAAABtbHVjAAAAAAAAAAEAAAAMZW5VUwAAACAAAAAcAEcAbwBvAGcAbABlACAASQBuAGMALgAgADIAMAAxADb/2wBDAAMCAgICAgMCAgIDAwMDBAYEBAQEBAgGBgUGCQgKCgkICQkKDA8MCgsOCwkJDRENDg8QEBEQCgwSExIQEw8QEBD/2wBDAQMDAwQDBAgEBAgQCwkLEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBD/wAARCAAyADIDASIAAhEBAxEB/8QAHAAAAgIDAQEAAAAAAAAAAAAAAAYHCAIDBAUJ/8QANRAAAQIEAwYEBAUFAAAAAAAAAQIDAAQFEQYSIQcTIjFBYRQycZEIFYGhFjNCYqJSk6PB8P/EABkBAQEBAQEBAAAAAAAAAAAAAAUEAwIGAf/EACURAAEDBAEEAgMAAAAAAAAAAAEAAgMEERIhBRQxQVETIjNhcf/aAAwDAQACEQMRAD8AjamzL9TU/VJoXdmXVvOq5ArUoqUfcmFLEm0jCOH5pUrNVBLrw5hHElPa4hyTJuSeHXxIFayne7rMBmUnMQk6EgEix5xXfGlDqTdQbUw2xZxRLyG2QFJ18uYgknnrp6R9nAsroC9gGIT+jHchPM+OZQhSFcSSOv0jRLbV8HzrolH3Fy72bKVbs5b+seTR9nta/Bs1UngGn8t2WiLEi179riE2jYdxBOVXcNJSGlAAJUkZc2lyrTlz78oDkpY3OOel6E107GM+Jt7/AKV5/hpnHZiTrjKXy5LAyr7QBum6w4CoeoQn2ETWU6jrFcfhsra8P1tvB85LoK6swQlxJNkrYSpQSOxSpftFli2CdRFEABjFkVWhzZiXC19rDKP+MEbdz3VBGuKluqdyDkzSqSxTnAkvsspbcNyQVAWJF9bE6iI+xRT0omPmL6Mys17W8xiddq+GpLDNUlJumy6mpSdaKbFxS7OpNzqom1wpNtehiHsWT/hUt+Hli868vKEAXNu19OsIzR5NsqKKobuS3ddMxjygUukGXe3jylNobdSpstIsQL5FHna1tOX2hTYeYdd8TJpUGnAHGXCnKSCAde94WcVh5ydYLlKyhJuUuTaOLXqL8PpHVTKpPeIal3GCiVsEIKVhaCf2nnb1getblJpOUUhjZ9hoqw3w8yr05jinvuAq8El965/SC0pF/wCf3i1gTEG/C7Q0ii1DEb8s0VPuplpdZTxpCRddj0BzI5dU9oncDsIogZhGELyE4knJHjSxy9oIysf6YI7soclAO3CoS9Qwyww0+1vmpxDrYQoE6JWD172+sV9NQkph9SZyYSy42CNYZcbVtc1W6SwlYSyuVnhlB4TlVLJFv5W7GI2qsm1Uphxp1SkuAkBaTaEJ3BhsVxQlzocmpaxeqkIqaD4hcwb8WvePTw/NyFVqUpSKemxedQ2jMDwEm1z2EKNcw4uXfCvFOKSo/qVqIYcASsvTqpKzCLFe/Re56ZhAlSW3y9JynfK76W7r6IYMxzsaw1h+mYap1NrDDUo2GE76pN3dXYqUv8iwzKzEi/O9tLQ5y+0nZRNyo3dGqoWk5c3zNsZv8P8AqKRYjKhO0yYZmVC76W1ovwrSLrFx2se2sdFXmHJlAYVNPFCndE3sABc20tcade0RDk5NXA2uXcW03IJV1fxdgNXEmUngDqAaii9v7EEU3kNq0g3Iyzc2hzfpaQlyydM4Av8AeCNOsd6WPQD2lPE3ErDyjqRMvpuedtwo29wPaFCcJ8crXqYII9BVd0dxX4j/AFKGItZ4XjPDJPzyXTc23idPqIIIEqOxTkXhTNViSiTNzcKWR280E6pVhxHyuHn+0wQQL5V3hKSvMfWCCCLAsF//2Q=='),(26,'NEY MARGARITA','FARFAN','MARCHAN','75912564','GARDEN 360 - LOS TALLANES DEPARTSAMENTO #205 - TORRE 6','995500978','INGENIERA MECANICA ELECTRICA','Jefa de Distribución',1,1,'17229770047422968488',NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `especialistascomunitarios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galeriadefotos`
--

DROP TABLE IF EXISTS `galeriadefotos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `galeriadefotos` (
  `gal_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gal_titulo` varchar(245) NOT NULL DEFAULT '',
  `gal_resumen` text DEFAULT NULL,
  `gal_contenido` text DEFAULT NULL,
  `gal_imagen1` varchar(245) NOT NULL DEFAULT '',
  `gal_imagen2` varchar(245) NOT NULL DEFAULT '',
  `gal_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `gal_fecha` datetime DEFAULT NULL,
  PRIMARY KEY (`gal_codi`),
  FULLTEXT KEY `busqueda` (`gal_titulo`,`gal_resumen`,`gal_contenido`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galeriadefotos`
--

LOCK TABLES `galeriadefotos` WRITE;
/*!40000 ALTER TABLE `galeriadefotos` DISABLE KEYS */;
INSERT INTO `galeriadefotos` (`gal_codi`, `gal_titulo`, `gal_resumen`, `gal_contenido`, `gal_imagen1`, `gal_imagen2`, `gal_estado`, `gal_fecha`) VALUES (1,'GALERIA 1','DETALLE 1','<p>Detalle de <strong><em>galeriaAAAA :</em></strong></p><ul><li>Uno</li><li>Dos</li><li>Tres</li><li>Cuatro</li></ul>','','',1,'2022-10-03 12:17:05'),(2,'GALERIA 2','DETALLE 2','<p>CONTENIDO 2</p>','','',1,'2022-10-03 13:27:29');
/*!40000 ALTER TABLE `galeriadefotos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `guia_remision`
--

DROP TABLE IF EXISTS `guia_remision`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `guia_remision` (
  `gui_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gui_nro_comprobante` varchar(45) NOT NULL DEFAULT '',
  `tra_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `traemp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `gui_fecha_emision` date DEFAULT NULL,
  `gui_fecha_traslado` date DEFAULT NULL,
  `gui_punto_partida` varchar(245) NOT NULL DEFAULT '',
  `gui_punto_llegada` varchar(245) NOT NULL DEFAULT '',
  `gui_destinatario` varchar(245) NOT NULL DEFAULT '',
  `mot_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `opealm_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `gui_marca_placa` varchar(245) NOT NULL DEFAULT '',
  `gui_observacion` varchar(245) NOT NULL DEFAULT '',
  `gui_numero` varchar(45) NOT NULL DEFAULT '',
  `veh_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`gui_codi`),
  KEY `Index_gui_nro_comprobante` (`gui_nro_comprobante`),
  KEY `Index_gui_numero` (`gui_numero`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `guia_remision`
--

LOCK TABLES `guia_remision` WRITE;
/*!40000 ALTER TABLE `guia_remision` DISABLE KEYS */;
/*!40000 ALTER TABLE `guia_remision` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `guia_remision_motivo_traslado`
--

DROP TABLE IF EXISTS `guia_remision_motivo_traslado`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `guia_remision_motivo_traslado` (
  `guimottra_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `guimottra_nombre` varchar(145) NOT NULL DEFAULT '',
  `guimottra_codigo` varchar(45) NOT NULL DEFAULT '',
  `guimottra_estado` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`guimottra_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `guia_remision_motivo_traslado`
--

LOCK TABLES `guia_remision_motivo_traslado` WRITE;
/*!40000 ALTER TABLE `guia_remision_motivo_traslado` DISABLE KEYS */;
INSERT INTO `guia_remision_motivo_traslado` (`guimottra_codi`, `guimottra_nombre`, `guimottra_codigo`, `guimottra_estado`) VALUES (1,'Venta','01',1),(2,'Compra','02',1),(3,'Venta con entrega a terceros','03',1),(4,'Traslado entre establecimientos de la misma empresa','04',1),(5,'Consignación','05',1),(6,'Devolución','06',1),(7,'Recogo de bienes transformados','07',1),(8,'Importación','08',1),(9,'Exportación','09',1),(10,'Otros no comprendido en ningún código del presente catálogo','13',1),(11,'Venta sujeta a confirmación del comprador','14',1),(12,'Traslado de bienes para transformación','17',1),(13,'Traslado por emisor itinerante de comprobantes de pago','18',1);
/*!40000 ALTER TABLE `guia_remision_motivo_traslado` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `guia_remision_tipo`
--

DROP TABLE IF EXISTS `guia_remision_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `guia_remision_tipo` (
  `guitip_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `guitip_nombre` varchar(245) NOT NULL DEFAULT '',
  `guitip_codigo` varchar(45) NOT NULL DEFAULT '',
  `guitip_estado` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`guitip_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `guia_remision_tipo`
--

LOCK TABLES `guia_remision_tipo` WRITE;
/*!40000 ALTER TABLE `guia_remision_tipo` DISABLE KEYS */;
INSERT INTO `guia_remision_tipo` (`guitip_codi`, `guitip_nombre`, `guitip_codigo`, `guitip_estado`) VALUES (1,'Guía remisión remitente','',1),(2,'Guía remisión transportista','',1),(3,'Guía remisión por evento','',1);
/*!40000 ALTER TABLE `guia_remision_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `imagenes`
--

DROP TABLE IF EXISTS `imagenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `imagenes` (
  `ima_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ima_nombre` varchar(145) NOT NULL DEFAULT '',
  `ima_origen` int(10) unsigned NOT NULL DEFAULT 0,
  `ima_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `ima_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`ima_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `imagenes`
--

LOCK TABLES `imagenes` WRITE;
/*!40000 ALTER TABLE `imagenes` DISABLE KEYS */;
INSERT INTO `imagenes` (`ima_codi`, `ima_nombre`, `ima_origen`, `ima_estado`, `ima_codi_fk`) VALUES (1,'51321_WhatsApp Image 2024-05-20 at 13.05.35.jpeg',21,0,30),(2,'27861_IMG_8964.jpeg',21,0,31),(3,'48296_WhatsApp Image 2024-05-20 at 13.05.35.jpeg',21,0,32),(4,'67061_IMG_8964.jpeg',21,0,33),(5,'77949_D7DDC0E0-E971-4C38-BFA5-1EAFCD53B91F.jpeg',21,0,41),(6,'59460_CUT-60P.jpeg',21,0,26),(7,'70946_MMA200.jpeg',21,0,2),(8,'30585_MIG200.jpeg',21,0,11),(9,'10924_WhatsApp Image 2024-01-06 at 09.55.18 (1).jpeg',21,0,13),(10,'10312_MIG250 -ACDC.jpeg',21,0,15),(11,'25128_MIG350-MULTIVOLTAJE.jpeg',21,0,19),(12,'13846_WhatsApp Image 2024-06-21 at 15.12.50.jpeg',21,0,18),(13,'53719_MIG250.png',21,0,14),(14,'70598_cut100p.png',21,0,28),(15,'10186_cut40P.png',21,0,25),(16,'41915_cut80p.png',21,0,27),(17,'83851_AC-DC 200TIG.png',21,0,22),(18,'34568_TIG200.png',21,0,21),(19,'68622_TIG-315AC-DC.png',21,0,23),(20,'10806_MMA-400.png',21,0,7),(21,'59129_MMA-400.png',21,0,6),(22,'91190_MMA-350.png',21,0,5),(23,'621_MMA-280.png',21,0,4),(24,'19064_MMA240.png',21,0,3),(25,'25416_MMA-200.png',21,0,2),(26,'76337_MMA130.png',21,0,1),(27,'74242_MIG-258.png',21,0,16),(28,'85395_MIG305.png',21,0,17),(29,'37747_MIG-500f.png',21,0,20),(30,'15197_MIG120.png',21,0,8),(31,'87594_MOTOSOLDADORA.jpeg',21,0,29),(32,'97188_454582218_1022967156497558_1452104284090696287_n.jpg',21,0,45),(33,'68343_454720413_1022967179830889_5588517655570429809_n.jpg',21,0,45);
/*!40000 ALTER TABLE `imagenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `marcas`
--

DROP TABLE IF EXISTS `marcas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `marcas` (
  `mar_codi` int(11) NOT NULL AUTO_INCREMENT,
  `mar_nombre` varchar(45) NOT NULL DEFAULT '',
  `mar_estado` int(11) NOT NULL DEFAULT 1,
  `mar_abreviatura` varchar(45) DEFAULT NULL,
  `mar_usu_crea` varchar(45) DEFAULT NULL,
  `mar_usu_modifica` varchar(45) DEFAULT NULL,
  `mar_usu_activa` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`mar_codi`),
  UNIQUE KEY `Index_mar_nombre` (`mar_nombre`),
  KEY `Index_mar_estado` (`mar_estado`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `marcas`
--

LOCK TABLES `marcas` WRITE;
/*!40000 ALTER TABLE `marcas` DISABLE KEYS */;
INSERT INTO `marcas` (`mar_codi`, `mar_nombre`, `mar_estado`, `mar_abreviatura`, `mar_usu_crea`, `mar_usu_modifica`, `mar_usu_activa`) VALUES (1,'REDBO',1,'',NULL,NULL,NULL),(2,'ALIEN WELD',1,'',NULL,NULL,NULL),(3,'BULL WELDER',1,'',NULL,NULL,NULL),(4,'FRONIUS',1,'',NULL,NULL,NULL),(5,'KAMASA',1,'',NULL,NULL,NULL),(6,'LYON WELD',1,'',NULL,NULL,NULL),(7,'OTROS',1,'',NULL,NULL,NULL);
/*!40000 ALTER TABLE `marcas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `masterpack`
--

DROP TABLE IF EXISTS `masterpack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `masterpack` (
  `mp_codi` int(11) NOT NULL AUTO_INCREMENT,
  `mp_nombre` varchar(200) NOT NULL DEFAULT '',
  `mp_estado` int(11) NOT NULL DEFAULT 1,
  `mp_abreviatura` varchar(45) DEFAULT NULL,
  `mp_usu_crea` varchar(45) DEFAULT NULL,
  `mp_usu_modifica` varchar(45) DEFAULT NULL,
  `mp_usu_activa` varchar(45) DEFAULT NULL,
  `mp_cantidad` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`mp_codi`),
  UNIQUE KEY `Index_mp_nombre` (`mp_nombre`),
  KEY `Index_mp_estado` (`mp_estado`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `masterpack`
--

LOCK TABLES `masterpack` WRITE;
/*!40000 ALTER TABLE `masterpack` DISABLE KEYS */;
INSERT INTO `masterpack` (`mp_codi`, `mp_nombre`, `mp_estado`, `mp_abreviatura`, `mp_usu_crea`, `mp_usu_modifica`, `mp_usu_activa`, `mp_cantidad`) VALUES (1,'UNIDAD',1,'UNID',NULL,NULL,NULL,1);
/*!40000 ALTER TABLE `masterpack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `medios_pago`
--

DROP TABLE IF EXISTS `medios_pago`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `medios_pago` (
  `medpag_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `medpag_nombre` varchar(45) NOT NULL DEFAULT '',
  `medpag_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `medpag_abreviatura` varchar(45) DEFAULT NULL,
  `medpag_usu_crea` varchar(45) DEFAULT NULL,
  `medpag_usu_modifica` varchar(45) DEFAULT NULL,
  `medpag_usu_activa` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`medpag_codi`),
  UNIQUE KEY `Index_medpag_nombre` (`medpag_nombre`),
  KEY `Index_medpag_estado` (`medpag_estado`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `medios_pago`
--

LOCK TABLES `medios_pago` WRITE;
/*!40000 ALTER TABLE `medios_pago` DISABLE KEYS */;
INSERT INTO `medios_pago` (`medpag_codi`, `medpag_nombre`, `medpag_estado`, `medpag_abreviatura`, `medpag_usu_crea`, `medpag_usu_modifica`, `medpag_usu_activa`) VALUES (1,'EFECTIVO',1,'','etorres',NULL,NULL),(2,'CHEQUE',1,'','etorres','etorres',''),(3,'TRANSFERENCIA ELECTRONICA',1,'','etorres','SCARRASCO',NULL),(4,'TARJETA DE CREDITO',1,'A','etorres','SCARRASCO',NULL),(5,'CUENTA CORRIENTE',1,'','etorres',NULL,NULL),(6,'NOTA DE CREDITO',1,'N CREDITO','LSANCHEZ1',NULL,NULL),(7,'TARJETA DE DEBITO',1,'','etorres',NULL,NULL),(8,'PUNTOS ACUMULADOS',1,'','etorres',NULL,NULL),(9,'YAPE-PLIN',1,'YP',NULL,NULL,NULL);
/*!40000 ALTER TABLE `medios_pago` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `modulos`
--

DROP TABLE IF EXISTS `modulos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `modulos` (
  `mod_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mod_nombre` varchar(245) NOT NULL DEFAULT '',
  `mod_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `mod_descripcion` text DEFAULT NULL,
  `mod_origen_imagen` int(10) unsigned DEFAULT NULL,
  `mod_orden` int(10) unsigned DEFAULT NULL,
  `mod_crear` int(10) unsigned NOT NULL DEFAULT 1,
  `mod_modificar` int(10) unsigned NOT NULL DEFAULT 1,
  `mod_eliminar` int(10) unsigned NOT NULL DEFAULT 1,
  `mod_fotos` int(10) unsigned NOT NULL DEFAULT 1,
  `mod_activar` int(10) unsigned NOT NULL DEFAULT 1,
  `mod_estado2` int(10) unsigned NOT NULL DEFAULT 1,
  `modgru_codi_fk` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`mod_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `modulos`
--

LOCK TABLES `modulos` WRITE;
/*!40000 ALTER TABLE `modulos` DISABLE KEYS */;
INSERT INTO `modulos` (`mod_codi`, `mod_nombre`, `mod_estado`, `mod_descripcion`, `mod_origen_imagen`, `mod_orden`, `mod_crear`, `mod_modificar`, `mod_eliminar`, `mod_fotos`, `mod_activar`, `mod_estado2`, `modgru_codi_fk`) VALUES (1,'APERTURA Y CIERRE DE CAJA',1,NULL,1,1,1,1,1,1,1,1,1),(2,'COMPRAS',1,NULL,2,2,1,1,1,1,1,1,1),(3,'NOTA DE CREDITO (COMPRAS)',1,NULL,3,3,1,1,1,1,1,1,1),(4,'NOTA DE DEBITO (COMPRAS)',1,NULL,4,4,1,1,1,1,1,1,1),(5,'COTIZACIONES DE VENTAS',1,NULL,5,5,1,1,1,1,1,1,1),(6,'VENTAS',1,NULL,6,6,1,1,1,1,1,1,1),(7,'NOTA DE CREDITO (VENTAS)',1,NULL,7,7,1,1,1,1,1,1,1),(8,'NOTA DE DEBITO (VETAS)',1,NULL,8,8,1,1,1,1,1,1,1),(9,'INGRESOS A ALMACEN',1,NULL,9,9,1,1,1,1,1,1,1),(10,'SALIDAS DE ALMACEN',1,NULL,10,10,1,1,1,1,1,1,1),(11,'GUIA DE REMISION',1,NULL,11,11,1,1,1,1,1,1,1),(12,'CAJA',1,NULL,12,12,1,1,1,1,1,1,1),(13,'CLIENTES',1,NULL,13,13,1,1,1,1,1,1,2),(14,'PROVEEDORES',1,NULL,14,14,1,1,1,1,1,1,2),(15,'EMPLEADOS',1,NULL,15,15,1,1,1,1,1,1,2),(16,'CATEGORIAS DE PRODUCTOS',1,NULL,16,16,1,1,1,1,1,1,3),(17,'UNIDADES DE MEDIDA',1,NULL,17,17,1,1,1,1,1,1,3),(18,'MARCAS',1,NULL,18,18,1,1,1,1,1,1,3),(19,'PRESENTACIONES',1,NULL,19,19,1,1,1,0,0,1,3),(20,'MASTERPACK',1,NULL,20,20,1,1,1,1,1,1,3),(21,'CATALOGO DE PRODUCTOS',1,NULL,21,21,1,1,1,1,1,1,3),(22,'TIPO DE DOCUMENTOS',1,NULL,22,22,1,1,1,1,1,1,2),(23,'TIPO OPERACIONES CAJA',1,NULL,23,23,1,1,1,1,1,1,2),(24,'LISTA DE PRODUCTOS',1,NULL,24,24,0,0,0,0,0,1,4),(25,'ETIQUETAS DE PRODUCTOS',1,NULL,25,25,0,0,0,0,0,1,4),(26,'STOCK DE PRODUCTOS',1,NULL,26,26,0,0,0,0,0,1,4),(27,'PRODUCTOS MAS VENDIDOS',1,NULL,27,27,0,0,0,0,0,1,4),(28,'PRODUCTOS/VENTAS',1,NULL,28,28,0,0,0,0,0,1,4),(29,'PRODUCTOS/COMPRAS/VENTAS',0,NULL,29,29,0,0,0,0,0,1,4),(30,'VENTAS POR DIA',1,NULL,30,30,0,0,0,0,0,1,4),(31,'CONFIGURACIONES GENERALES',1,NULL,31,31,0,1,0,0,0,1,7),(32,'SUCURSALES',1,NULL,32,32,1,1,1,1,1,1,7),(33,'SERIES DE COMPROBANTES',1,NULL,33,33,1,1,1,1,1,1,7),(34,'VALIDACIONES COMPROBANTES',1,NULL,34,34,1,1,1,1,1,1,7),(35,'USUARIOS',1,'',35,35,1,1,1,1,1,1,7),(36,'TIPO OPERACIONES ALMACEN',1,NULL,36,36,1,1,1,1,1,1,2),(37,'DASHBOARD COMPRAS',1,NULL,37,37,0,0,0,0,0,1,5),(38,'DASHBOARD VENTAS',1,NULL,38,38,0,0,0,0,0,1,5),(39,'DASHBOARD ALMACEN',1,NULL,39,39,0,0,0,0,0,1,5),(40,'DASHBOARD CAJA',1,NULL,40,40,0,0,0,0,0,1,5),(41,'DASHBOARD USUARIOS',1,NULL,41,41,0,0,0,0,0,1,5),(42,'PRONOSTICOS',1,NULL,42,42,0,0,0,0,0,1,6),(43,'CHAT GPT',1,NULL,43,43,0,0,0,0,0,1,6),(44,'DETECCION FACIAL',1,NULL,44,44,0,0,0,0,0,1,6),(45,'DETECCION DE VOZ',1,NULL,45,45,0,0,0,0,0,1,6),(47,'MEDIOS DE PAGO',1,NULL,47,47,1,1,1,1,1,1,2),(48,'MOVIMIENTO ALMACEN',1,NULL,48,48,0,0,0,0,0,1,4),(49,'MOVIMIENTO DETALLADO',1,NULL,49,49,0,0,0,0,0,1,4),(50,'REPORTE DE COMPROBANTES',1,NULL,50,50,0,0,0,0,0,1,4),(51,'REPORTE DE VENTAS',0,NULL,51,51,0,0,0,0,0,1,4),(52,'PRODUCTOS/COMPRAS',1,'',52,52,0,0,0,0,0,1,4),(53,'REGISTRO DE PRECIOS',1,NULL,53,53,0,0,0,0,0,1,3);
/*!40000 ALTER TABLE `modulos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `modulos_grupos`
--

DROP TABLE IF EXISTS `modulos_grupos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `modulos_grupos` (
  `modgru_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `modgru_nombre` varchar(245) NOT NULL DEFAULT '',
  `modgru_estado` int(10) unsigned NOT NULL DEFAULT 0,
  `modgru_orden` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`modgru_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `modulos_grupos`
--

LOCK TABLES `modulos_grupos` WRITE;
/*!40000 ALTER TABLE `modulos_grupos` DISABLE KEYS */;
INSERT INTO `modulos_grupos` (`modgru_codi`, `modgru_nombre`, `modgru_estado`, `modgru_orden`) VALUES (1,'OPERACIONES',1,1),(2,'MANTENIMIENTO',1,2),(3,'PRODUCTOS',1,3),(4,'CONSULTAS Y REPORTES',1,4),(5,'DASHBOARD',1,5),(6,'HERRAMIENTAS INTELIGENTES',1,6),(7,'CONFIGURACIONES',1,7);
/*!40000 ALTER TABLE `modulos_grupos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nota_credito`
--

DROP TABLE IF EXISTS `nota_credito`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nota_credito` (
  `notcre_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `notcre_numero` varchar(45) NOT NULL DEFAULT '',
  `notcre_txt_generado` int(10) unsigned NOT NULL DEFAULT 0,
  `notcre_codigohast` varchar(245) DEFAULT NULL,
  `notcre_timbrexml` int(10) unsigned NOT NULL DEFAULT 0,
  `notcre_firma` text DEFAULT NULL,
  `notcre_timbreweb` int(10) unsigned NOT NULL DEFAULT 0,
  `ordped_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `notcre_fecha` date DEFAULT NULL,
  `notcre_serie` varchar(45) NOT NULL DEFAULT '',
  `notcre_fechahora` datetime DEFAULT NULL,
  `notcretip_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `notcre_detalle` text DEFAULT NULL,
  `notcre_descuento` float NOT NULL DEFAULT 0,
  `notcre_timbrerpta` int(10) unsigned NOT NULL DEFAULT 0,
  `notcre_detallerpta` text NOT NULL,
  `notcre_flg_ose` int(10) unsigned NOT NULL DEFAULT 0,
  `notcre_caj_numero` varchar(11) DEFAULT NULL,
  `notcre_usu_crea` varchar(45) DEFAULT NULL,
  `notcre_idtrans` varchar(145) DEFAULT NULL,
  `notcre_estado` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`notcre_codi`),
  UNIQUE KEY `Index_notcre_numero` (`notcre_numero`),
  KEY `Index_notcre_txt_generado` (`notcre_txt_generado`),
  KEY `Index_notcre_timbrexml` (`notcre_timbrexml`),
  KEY `Index_notcre_timbreweb` (`notcre_timbreweb`),
  KEY `Index_ordped_codi_fk` (`ordped_codi_fk`),
  KEY `Index_notcre_serie` (`notcre_serie`),
  KEY `Index_notcretip_codi_fk` (`notcretip_codi_fk`),
  KEY `Index_notcre_timbrerpta` (`notcre_timbrerpta`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nota_credito`
--

LOCK TABLES `nota_credito` WRITE;
/*!40000 ALTER TABLE `nota_credito` DISABLE KEYS */;
INSERT INTO `nota_credito` (`notcre_codi`, `notcre_numero`, `notcre_txt_generado`, `notcre_codigohast`, `notcre_timbrexml`, `notcre_firma`, `notcre_timbreweb`, `ordped_codi_fk`, `notcre_fecha`, `notcre_serie`, `notcre_fechahora`, `notcretip_codi_fk`, `notcre_detalle`, `notcre_descuento`, `notcre_timbrerpta`, `notcre_detallerpta`, `notcre_flg_ose`, `notcre_caj_numero`, `notcre_usu_crea`, `notcre_idtrans`, `notcre_estado`) VALUES (1,'B001-1',0,'+3YL9OYf6aOADS7lf9W53a4rTWQ=',1,'+3YL9OYf6aOADS7lf9W53a4rTWQ=Y5mb+uLJNBHUH8qfIYpy+LFsSkShEKZzC1WXD5Is6QnOnvZ176SkwBsMHsn3rNahrKMkCQ6RTd0eNdnwlM3+Dq268Vw+ng6L9UuovIhLgGNv8pvlTKWWrVqOXsfbqDUDpEB2OUHFmdqQC8JzuGE5DCekjCn4Y8fU3OYeCYjZI4VLwwSKTtt6uWVQaD47Jd18NQb+g9axTQkEkS99MTBULM0ii5TX+KQWEQ7AjFqYMTtN8UmI8FGwRlzOcx2Wr3b05fSCYywysBqjL29pioJzvRqoIvrJ+PXIDUGWf5ZWIAvye0WNupGIyt/o1nw8DGcbEq1xh/u7mZOY/6jqAWnfVw==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',0,1,'2024-09-19','6','2024-09-19 22:43:46',1,'',0,1,'',1,'C-0000001','ETORRES','17268038109826864525',1),(2,'F001-1',0,'TqVqCTV9E6c+wamdkfgPyURRxZY=',1,'TqVqCTV9E6c+wamdkfgPyURRxZY=JoDFX0g3hW8E7wmz5/kJOKNUoyeBo6Ou0BtuC7y2PNju2S9DAeLgtiO3lzC16IJPYDxvxaXwUJiFg8E3mRlLy4msjeo8ZdvRskbcLTBx7rlDJF6KRHsZUGQV9nMYX8ULblDEaDDQP5KOHyN6qv7LwduhYtBWJRSvPkn9Me3y/y6Ni8Od3aylMBPdWxIop6+7reWSeWnMAZ48P3QleD5VRoACKSvXTmy9ObC0JK5SPn76BL7o3VargnkEsInqU11p2+Jc3cRwrhAhsEanRlSZskDU5I4L5fagymy6O8JmLctAS3kVClwC4Cf81FPT3ENfnAN1tBXCmlNnmcjNN6vWUA==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',0,2,'2024-09-19','5','2024-09-19 22:44:28',1,'',0,1,'',1,'C-0000001','ETORRES','17268038426407678197',1);
/*!40000 ALTER TABLE `nota_credito` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nota_credito_almacen`
--

DROP TABLE IF EXISTS `nota_credito_almacen`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nota_credito_almacen` (
  `notcrealm_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `notcre_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `opealm_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `notcrealm_fechahora` datetime DEFAULT NULL,
  PRIMARY KEY (`notcrealm_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nota_credito_almacen`
--

LOCK TABLES `nota_credito_almacen` WRITE;
/*!40000 ALTER TABLE `nota_credito_almacen` DISABLE KEYS */;
INSERT INTO `nota_credito_almacen` (`notcrealm_codi`, `notcre_codi_fk`, `opealm_codi_fk`, `notcrealm_fechahora`) VALUES (1,1,3,'2024-09-19 22:49:22'),(2,2,4,'2024-09-19 22:50:18');
/*!40000 ALTER TABLE `nota_credito_almacen` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nota_credito_caja`
--

DROP TABLE IF EXISTS `nota_credito_caja`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nota_credito_caja` (
  `notcrecaj_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `notcre_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `opecaj_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `notcrecaj_fechahora` datetime DEFAULT NULL,
  PRIMARY KEY (`notcrecaj_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nota_credito_caja`
--

LOCK TABLES `nota_credito_caja` WRITE;
/*!40000 ALTER TABLE `nota_credito_caja` DISABLE KEYS */;
INSERT INTO `nota_credito_caja` (`notcrecaj_codi`, `notcre_codi_fk`, `opecaj_codi_fk`, `notcrecaj_fechahora`) VALUES (1,2,3,'2024-09-19 22:45:53'),(2,1,4,'2024-09-19 22:46:17');
/*!40000 ALTER TABLE `nota_credito_caja` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nota_credito_compra`
--

DROP TABLE IF EXISTS `nota_credito_compra`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nota_credito_compra` (
  `notcrecom_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `notcrecom_numero` varchar(45) NOT NULL DEFAULT '',
  `ordcom_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `notcrecom_fecha` date DEFAULT NULL,
  `notcrecom_serie` varchar(45) NOT NULL DEFAULT '',
  `notcrecom_fechahora` datetime DEFAULT NULL,
  `notcretip_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `notcrecom_detalle` text DEFAULT NULL,
  `notcrecom_descuento` float NOT NULL DEFAULT 0,
  `notcrecom_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `notcrecom_n` int(11) DEFAULT NULL,
  PRIMARY KEY (`notcrecom_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nota_credito_compra`
--

LOCK TABLES `nota_credito_compra` WRITE;
/*!40000 ALTER TABLE `nota_credito_compra` DISABLE KEYS */;
/*!40000 ALTER TABLE `nota_credito_compra` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nota_credito_detalle`
--

DROP TABLE IF EXISTS `nota_credito_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nota_credito_detalle` (
  `notcredet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `notcredet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `notcredet_precio` float NOT NULL DEFAULT 0,
  `notcredet_cantidad` float NOT NULL DEFAULT 0,
  `notcre_codi_fk` int(11) NOT NULL DEFAULT 0,
  `idtrans` varchar(45) DEFAULT NULL,
  `notcredet_observaciones` text DEFAULT NULL,
  `idtrans_nuevo` varchar(45) DEFAULT NULL,
  `notcredet_precio_catalogo` float NOT NULL DEFAULT 0,
  `notcredet_icbper_monto_unitario` float NOT NULL DEFAULT 0,
  `notcredet_cantidad_devolver` float NOT NULL DEFAULT 0,
  `notcredet_cantidad_devolver_temporal` float NOT NULL DEFAULT 0,
  `notcredet_igv_afectado` int(11) NOT NULL DEFAULT 0,
  `notcredet_precio_descuento` float NOT NULL DEFAULT 0,
  `notcredet_precio_descuento_temporal` float NOT NULL DEFAULT 0,
  PRIMARY KEY (`notcredet_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nota_credito_detalle`
--

LOCK TABLES `nota_credito_detalle` WRITE;
/*!40000 ALTER TABLE `nota_credito_detalle` DISABLE KEYS */;
INSERT INTO `nota_credito_detalle` (`notcredet_codi`, `notcredet_fechahora`, `prd_codi_fk`, `unimed_codi_fk`, `notcredet_precio`, `notcredet_cantidad`, `notcre_codi_fk`, `idtrans`, `notcredet_observaciones`, `idtrans_nuevo`, `notcredet_precio_catalogo`, `notcredet_icbper_monto_unitario`, `notcredet_cantidad_devolver`, `notcredet_cantidad_devolver_temporal`, `notcredet_igv_afectado`, `notcredet_precio_descuento`, `notcredet_precio_descuento_temporal`) VALUES (1,'2024-09-19 22:43:46',38,1,4,1,1,'17268038109826864525','',NULL,0,0,1,0,0,4,0),(2,'2024-09-19 22:44:28',35,1,8,1,2,'17268038426407678197','',NULL,0,0,1,0,0,8,0);
/*!40000 ALTER TABLE `nota_credito_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nota_credito_tipo`
--

DROP TABLE IF EXISTS `nota_credito_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nota_credito_tipo` (
  `notcretip_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `notcretip_codigo` varchar(5) NOT NULL DEFAULT '',
  `notcretip_nombre` varchar(245) NOT NULL DEFAULT '',
  `notcretip_estado` int(10) unsigned NOT NULL DEFAULT 0,
  `notcretip_eliminar_item` int(10) unsigned NOT NULL DEFAULT 0,
  `notcretip_adicionar_item` int(10) unsigned NOT NULL DEFAULT 0,
  `notcretip_modificar_cantidad` int(10) unsigned NOT NULL DEFAULT 0,
  `notcretip_modificar_precio` int(10) unsigned NOT NULL DEFAULT 0,
  `notcretip_suma_cantidad` int(10) unsigned NOT NULL DEFAULT 0,
  `notcretip_suma_precio` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`notcretip_codi`),
  UNIQUE KEY `Index_notcretip_codigo` (`notcretip_codigo`),
  UNIQUE KEY `Index_notcretip_nombre` (`notcretip_nombre`),
  KEY `Index_notcretip_estado` (`notcretip_estado`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nota_credito_tipo`
--

LOCK TABLES `nota_credito_tipo` WRITE;
/*!40000 ALTER TABLE `nota_credito_tipo` DISABLE KEYS */;
INSERT INTO `nota_credito_tipo` (`notcretip_codi`, `notcretip_codigo`, `notcretip_nombre`, `notcretip_estado`, `notcretip_eliminar_item`, `notcretip_adicionar_item`, `notcretip_modificar_cantidad`, `notcretip_modificar_precio`, `notcretip_suma_cantidad`, `notcretip_suma_precio`) VALUES (1,'01','ANULACIÓN DE OPERACIÓN',1,0,0,0,0,1,1),(2,'02','ANULACIÓN POR ERROR EN EL RUC',1,0,0,0,0,1,1),(3,'03','CORRECCIÓN POR ERROR EN LA DESCRIPCIÓN',0,0,0,0,0,0,0),(4,'04','DESCUENTO GLOBAL',0,0,0,0,0,0,0),(5,'05','DESCUENTO POR ITEM',1,0,0,0,1,0,1),(6,'06','DEVOLUCIÓN TOTAL',1,0,0,0,0,1,1),(7,'07','DEVOLUCIÓN POR ITEM',1,0,0,1,0,1,1),(8,'08','BONIFICACIÓN',0,0,0,0,0,0,0),(9,'09','DISMINUCIÓN EN EL VALOR',1,0,0,0,1,0,1),(10,'10','OTROS CONCEPTOS',0,0,0,0,0,0,0);
/*!40000 ALTER TABLE `nota_credito_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nota_debito`
--

DROP TABLE IF EXISTS `nota_debito`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nota_debito` (
  `notdeb_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `notdeb_numero` varchar(45) NOT NULL DEFAULT '',
  `notdeb_txt_generado` int(10) unsigned NOT NULL DEFAULT 0,
  `notdeb_codigohast` varchar(245) DEFAULT NULL,
  `notdeb_timbrexml` int(10) unsigned NOT NULL DEFAULT 0,
  `notdeb_firma` text DEFAULT NULL,
  `notdeb_timbreweb` int(10) unsigned NOT NULL DEFAULT 0,
  `ordped_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `notdeb_fecha` date DEFAULT NULL,
  `notdeb_serie` varchar(45) NOT NULL DEFAULT '',
  `notdeb_fechahora` datetime DEFAULT NULL,
  `notdebtip_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `notdeb_detalle` text DEFAULT NULL,
  `notdeb_descuento` float NOT NULL DEFAULT 0,
  `notdeb_timbrerpta` int(10) unsigned NOT NULL DEFAULT 0,
  `notdeb_detallerpta` text NOT NULL,
  `notdeb_flg_ose` int(10) unsigned NOT NULL DEFAULT 0,
  `notdeb_caj_numero` varchar(11) DEFAULT NULL,
  `notdeb_usu_crea` varchar(45) DEFAULT NULL,
  `notdeb_idtrans` varchar(145) DEFAULT NULL,
  `notdeb_estado` int(10) unsigned NOT NULL DEFAULT 0,
  `notdeb_monto_interes` decimal(10,0) NOT NULL DEFAULT 0,
  PRIMARY KEY (`notdeb_codi`),
  UNIQUE KEY `Index_notdeb_numero` (`notdeb_numero`),
  KEY `Index_notdeb_txt_generado` (`notdeb_txt_generado`),
  KEY `Index_notdeb_timbrexml` (`notdeb_timbrexml`),
  KEY `Index_notdeb_timbreweb` (`notdeb_timbreweb`),
  KEY `Index_ordped_codi_fk` (`ordped_codi_fk`),
  KEY `Index_notdeb_serie` (`notdeb_serie`),
  KEY `Index_notdebtip_codi_fk` (`notdebtip_codi_fk`),
  KEY `Index_notdeb_timbrerpta` (`notdeb_timbrerpta`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nota_debito`
--

LOCK TABLES `nota_debito` WRITE;
/*!40000 ALTER TABLE `nota_debito` DISABLE KEYS */;
/*!40000 ALTER TABLE `nota_debito` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nota_debito_caja`
--

DROP TABLE IF EXISTS `nota_debito_caja`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nota_debito_caja` (
  `notdebcaj_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `notdeb_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `opecaj_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `notdebcaj_fechahora` datetime DEFAULT NULL,
  PRIMARY KEY (`notdebcaj_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nota_debito_caja`
--

LOCK TABLES `nota_debito_caja` WRITE;
/*!40000 ALTER TABLE `nota_debito_caja` DISABLE KEYS */;
/*!40000 ALTER TABLE `nota_debito_caja` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nota_debito_detalle`
--

DROP TABLE IF EXISTS `nota_debito_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nota_debito_detalle` (
  `notdebdet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `notdebdet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `notdebdet_precio` float NOT NULL DEFAULT 0,
  `notdebdet_cantidad` float NOT NULL DEFAULT 0,
  `notdeb_codi_fk` int(11) NOT NULL DEFAULT 0,
  `idtrans` varchar(45) DEFAULT NULL,
  `notdebdet_observaciones` text DEFAULT NULL,
  `idtrans_nuevo` varchar(45) DEFAULT NULL,
  `notdebdet_precio_catalogo` float NOT NULL DEFAULT 0,
  `notdebdet_icbper_monto_unitario` float NOT NULL DEFAULT 0,
  `notdebdet_cantidad_devolver` float NOT NULL DEFAULT 0,
  `notdebdet_cantidad_devolver_temporal` float NOT NULL DEFAULT 0,
  `notdebdet_igv_afectado` int(11) NOT NULL DEFAULT 0,
  `notdebdet_precio_descuento` float NOT NULL DEFAULT 0,
  `notdebdet_precio_descuento_temporal` float NOT NULL DEFAULT 0,
  PRIMARY KEY (`notdebdet_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nota_debito_detalle`
--

LOCK TABLES `nota_debito_detalle` WRITE;
/*!40000 ALTER TABLE `nota_debito_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `nota_debito_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nota_debito_tipo`
--

DROP TABLE IF EXISTS `nota_debito_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nota_debito_tipo` (
  `notdebtip_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `notdebtip_codigo` varchar(45) NOT NULL DEFAULT '',
  `notdebtip_nombre` varchar(45) NOT NULL DEFAULT '',
  `notdebtip_estado` int(10) unsigned NOT NULL DEFAULT 0,
  `notdebtip_eliminar_item` int(10) unsigned NOT NULL DEFAULT 0,
  `notdebtip_adicionar_item` int(10) unsigned NOT NULL DEFAULT 0,
  `notdebtip_modificar_cantidad` int(10) unsigned NOT NULL DEFAULT 0,
  `notdebtip_modificar_precio` int(10) unsigned NOT NULL DEFAULT 0,
  `notdebtip_suma_cantidad` int(10) unsigned NOT NULL DEFAULT 0,
  `notdebtip_suma_precio` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`notdebtip_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nota_debito_tipo`
--

LOCK TABLES `nota_debito_tipo` WRITE;
/*!40000 ALTER TABLE `nota_debito_tipo` DISABLE KEYS */;
INSERT INTO `nota_debito_tipo` (`notdebtip_codi`, `notdebtip_codigo`, `notdebtip_nombre`, `notdebtip_estado`, `notdebtip_eliminar_item`, `notdebtip_adicionar_item`, `notdebtip_modificar_cantidad`, `notdebtip_modificar_precio`, `notdebtip_suma_cantidad`, `notdebtip_suma_precio`) VALUES (1,'01','INTERES POR MORA',0,0,0,0,0,0,0),(2,'02','AUMENTO EN EL VALOR',1,0,0,0,1,0,1),(3,'03','PENALIDADES OTROS CONCEPTOS',0,0,0,0,0,0,0),(4,'11','AJUSTES DE OPERACIONES DE EXPORTACION',0,0,0,0,0,0,0),(5,'12','AJUSTES AFECTOS A IVAP',0,0,0,0,0,0,0);
/*!40000 ALTER TABLE `nota_debito_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `operacion_almacen`
--

DROP TABLE IF EXISTS `operacion_almacen`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operacion_almacen` (
  `opealm_codi` int(11) NOT NULL AUTO_INCREMENT,
  `opealm_fechahora` datetime DEFAULT NULL,
  `opealm_fecha` date DEFAULT NULL,
  `opetip_codi_fk` int(11) NOT NULL DEFAULT 0,
  `per_codi_fk` int(11) DEFAULT NULL,
  `doctip_codi_fk` int(11) DEFAULT NULL,
  `opealm_anotaciones` text DEFAULT NULL,
  `opealm_numero` varchar(45) DEFAULT NULL,
  `idtrans` varchar(45) DEFAULT NULL,
  `opealm_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `doc_numero` varchar(45) DEFAULT NULL,
  `opealm_usu_crea` varchar(45) DEFAULT NULL,
  `opealm_usu_modifica` varchar(45) DEFAULT NULL,
  `opealm_usu_activa` varchar(45) DEFAULT NULL,
  `ordpedcom_numero` varchar(45) DEFAULT NULL,
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `emp_codi_destino` int(11) NOT NULL DEFAULT 0,
  `opealm_codi_origen` int(11) NOT NULL DEFAULT 0,
  `opealm_fecha_documento` date DEFAULT NULL,
  PRIMARY KEY (`opealm_codi`),
  UNIQUE KEY `Index_opealm_numero` (`opealm_numero`) USING BTREE,
  KEY `fk_operacion_almacen_operacion_tipo1_idx` (`opetip_codi_fk`),
  KEY `fk_operacion_almacen_personas1_idx` (`per_codi_fk`),
  KEY `fk_operacion_almacen_documento_tipo1_idx` (`doctip_codi_fk`),
  KEY `Index_idtrans` (`idtrans`),
  KEY `Index_opealm_estado` (`opealm_estado`),
  KEY `Index_doc_numero` (`doc_numero`),
  KEY `Index_ordpedcom_numero` (`ordpedcom_numero`),
  KEY `Index_emp_codi_fk` (`emp_codi_fk`),
  CONSTRAINT `fk_operacion_almacen_documento_tipo1` FOREIGN KEY (`doctip_codi_fk`) REFERENCES `documento_tipo` (`doctip_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_operacion_almacen_operacion_tipo1` FOREIGN KEY (`opetip_codi_fk`) REFERENCES `operacion_tipo` (`opetip_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_operacion_almacen_personas1` FOREIGN KEY (`per_codi_fk`) REFERENCES `personas` (`per_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `operacion_almacen`
--

LOCK TABLES `operacion_almacen` WRITE;
/*!40000 ALTER TABLE `operacion_almacen` DISABLE KEYS */;
INSERT INTO `operacion_almacen` (`opealm_codi`, `opealm_fechahora`, `opealm_fecha`, `opetip_codi_fk`, `per_codi_fk`, `doctip_codi_fk`, `opealm_anotaciones`, `opealm_numero`, `idtrans`, `opealm_estado`, `doc_numero`, `opealm_usu_crea`, `opealm_usu_modifica`, `opealm_usu_activa`, `ordpedcom_numero`, `emp_codi_fk`, `emp_codi_destino`, `opealm_codi_origen`, `opealm_fecha_documento`) VALUES (1,'2024-09-14 19:02:05','2024-09-14',4,39,2,'GENERADO AUNTOMATICAMENTE','0000001','17263585258619047394',1,'B001-1','ETORRES',NULL,NULL,'',1,0,0,NULL),(2,'2024-09-18 11:09:13','2024-09-18',4,45,1,'GENERADO AUNTOMATICAMENTE','0000002','17266757539243251964',1,'F001-1','ETORRES',NULL,NULL,'',1,0,0,NULL),(3,'2024-09-19 22:49:22','2024-09-19',57,39,5,'','0000003','17268041208683804091',1,'B001-1','ETORRES',NULL,NULL,NULL,1,0,0,'2024-09-19'),(4,'2024-09-19 22:50:18','2024-09-19',57,45,5,'','0000004','17268042109237179311',1,'F001-1','ETORRES',NULL,NULL,NULL,1,0,0,'2024-09-19'),(5,'2024-10-03 14:15:15','2024-10-02',9,46,1,'','0000005','17279823123607922020',1,'F002_00001480','EBOTELLO',NULL,NULL,NULL,1,0,0,'2024-10-02'),(6,'2024-10-03 14:19:13','2024-10-03',4,47,1,'GENERADO AUNTOMATICAMENTE','0000006','17279831535071738867',1,'F001-2','EBOTELLO',NULL,NULL,'',1,0,0,NULL);
/*!40000 ALTER TABLE `operacion_almacen` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `operacion_almacen_detalle`
--

DROP TABLE IF EXISTS `operacion_almacen_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operacion_almacen_detalle` (
  `opealmdet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `opealmdet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `opealmdet_cantidad` float DEFAULT 0,
  `opealm_codi_fk` int(11) DEFAULT NULL,
  `idtrans` varchar(45) DEFAULT NULL,
  `opealmdet_cantidad_disponible` float NOT NULL DEFAULT 0,
  `mp_codi_fk_alm` int(11) DEFAULT NULL,
  `opealmdet_fecha_expira` date DEFAULT NULL,
  `opealmdet_lote` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`opealmdet_codi`),
  KEY `fk_operacion_almacen_detalle_operacion_almacen1_idx` (`opealm_codi_fk`),
  KEY `fk_operacion_almacen_detalle_productos1_idx` (`prd_codi_fk`),
  KEY `Index_unimed_codi_fk` (`unimed_codi_fk`),
  KEY `Index_idtrans` (`idtrans`),
  CONSTRAINT `FK_operacion_almacen_detalle_unidad` FOREIGN KEY (`unimed_codi_fk`) REFERENCES `unidades_medida` (`unimed_codi`),
  CONSTRAINT `fk_operacion_almacen_detalle_operacion_almacen1` FOREIGN KEY (`opealm_codi_fk`) REFERENCES `operacion_almacen` (`opealm_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_operacion_almacen_detalle_productos1` FOREIGN KEY (`prd_codi_fk`) REFERENCES `productos` (`prd_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `operacion_almacen_detalle`
--

LOCK TABLES `operacion_almacen_detalle` WRITE;
/*!40000 ALTER TABLE `operacion_almacen_detalle` DISABLE KEYS */;
INSERT INTO `operacion_almacen_detalle` (`opealmdet_codi`, `opealmdet_fechahora`, `prd_codi_fk`, `unimed_codi_fk`, `opealmdet_cantidad`, `opealm_codi_fk`, `idtrans`, `opealmdet_cantidad_disponible`, `mp_codi_fk_alm`, `opealmdet_fecha_expira`, `opealmdet_lote`) VALUES (1,'2024-09-14 19:02:05',38,1,1,1,'17263585258619047394',0,NULL,NULL,NULL),(2,'2024-09-18 11:09:13',35,1,1,2,'17266757539243251964',0,NULL,NULL,NULL),(3,'2024-09-19 22:49:22',38,1,1,3,'17268041208683804091',0,NULL,'0000-00-00',''),(4,'2024-09-19 22:50:18',35,1,1,4,'17268042109237179311',0,NULL,'0000-00-00',''),(5,'2024-10-03 14:15:15',52,1,1,5,'17279823123607922020',0,NULL,'2024-10-03','00052-1'),(6,'2024-10-03 14:19:13',52,1,1,6,'17279831535071738867',0,NULL,NULL,NULL);
/*!40000 ALTER TABLE `operacion_almacen_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `operacion_caja`
--

DROP TABLE IF EXISTS `operacion_caja`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operacion_caja` (
  `opecaj_codi` int(11) NOT NULL AUTO_INCREMENT,
  `opecaj_fechahora` datetime DEFAULT NULL,
  `opecaj_fecha` date DEFAULT NULL,
  `opecaj_numero` varchar(45) DEFAULT NULL,
  `per_codi_fk` int(11) DEFAULT NULL,
  `opecajtip_codi_fk` int(11) NOT NULL DEFAULT 0,
  `opecaj_estado` int(11) NOT NULL DEFAULT 1,
  `opecaj_anulado` int(11) NOT NULL DEFAULT 0,
  `opecaj_monto` float NOT NULL DEFAULT 0,
  `opecaj_anotaciones` text DEFAULT NULL,
  `opecaj_usu_crea` varchar(45) DEFAULT NULL,
  `opecaj_usu_modifica` varchar(45) DEFAULT NULL,
  `opecaj_usu_activa` varchar(45) DEFAULT NULL,
  `idtrans` varchar(45) DEFAULT NULL,
  `medpag_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `caj_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `pre_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `cc_codi_fk` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`opecaj_codi`),
  KEY `fk_operacion_caja_personas1_idx` (`per_codi_fk`),
  KEY `Index_opecajtip_codi_fk` (`opecajtip_codi_fk`),
  KEY `Index_opecaj_estado` (`opecaj_estado`),
  KEY `Index_opecaj_anulado` (`opecaj_anulado`),
  KEY `Index_medpag_codi_fk` (`medpag_codi_fk`),
  KEY `Index_idtrans` (`idtrans`),
  KEY `Index_emp_codi_fk` (`emp_codi_fk`),
  KEY `Index_caj_codi_fk` (`caj_codi_fk`),
  CONSTRAINT `FK_operacion_caja_caja` FOREIGN KEY (`caj_codi_fk`) REFERENCES `caja` (`caj_codi`),
  CONSTRAINT `FK_operacion_caja_caja_tipo` FOREIGN KEY (`opecajtip_codi_fk`) REFERENCES `operacion_caja_tipo` (`opecajtip_codi`),
  CONSTRAINT `FK_operacion_caja_medio_pago` FOREIGN KEY (`medpag_codi_fk`) REFERENCES `medios_pago` (`medpag_codi`),
  CONSTRAINT `fk_operacion_caja_personas1` FOREIGN KEY (`per_codi_fk`) REFERENCES `personas` (`per_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `operacion_caja`
--

LOCK TABLES `operacion_caja` WRITE;
/*!40000 ALTER TABLE `operacion_caja` DISABLE KEYS */;
INSERT INTO `operacion_caja` (`opecaj_codi`, `opecaj_fechahora`, `opecaj_fecha`, `opecaj_numero`, `per_codi_fk`, `opecajtip_codi_fk`, `opecaj_estado`, `opecaj_anulado`, `opecaj_monto`, `opecaj_anotaciones`, `opecaj_usu_crea`, `opecaj_usu_modifica`, `opecaj_usu_activa`, `idtrans`, `medpag_codi_fk`, `caj_codi_fk`, `emp_codi_fk`, `pre_codi_fk`, `cc_codi_fk`) VALUES (1,'2024-09-14 19:02:05','2024-09-14','0000001',39,11,1,0,4,'GENERADO AUTOMATICAMENTE','ETORRES',NULL,NULL,'17263585255312666493',1,1,1,0,NULL),(2,'2024-09-18 11:09:13','2024-09-18','0000002',45,11,1,0,8,'GENERADO AUTOMATICAMENTE','ETORRES',NULL,NULL,'17266757531954105678',1,1,1,0,NULL),(3,'2024-09-19 22:45:53','2024-09-19','0000003',45,18,1,0,8,'','ETORRES',NULL,NULL,'1726803953606630700',1,1,1,0,0),(4,'2024-09-19 22:46:17','2024-09-19','0000004',39,18,1,0,4,'','ETORRES',NULL,NULL,'1726803977746601354',1,1,1,0,0),(5,'2024-10-03 14:19:13','2024-10-03','0000005',47,11,1,0,3400,'GENERADO AUTOMATICAMENTE','EBOTELLO',NULL,NULL,'17279831532584646919',1,2,1,0,NULL);
/*!40000 ALTER TABLE `operacion_caja` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `operacion_caja_tipo`
--

DROP TABLE IF EXISTS `operacion_caja_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operacion_caja_tipo` (
  `opecajtip_codi` int(11) NOT NULL AUTO_INCREMENT,
  `opecajtip_nombre` varchar(145) NOT NULL DEFAULT '',
  `opecajtip_tipo` char(10) NOT NULL DEFAULT 'E',
  `opecajtip_estado` int(11) NOT NULL DEFAULT 1,
  `opecajtip_abreviatura` varchar(45) DEFAULT NULL,
  `opecajtip_usu_crea` varchar(45) DEFAULT NULL,
  `opecajtip_usu_modifica` varchar(45) DEFAULT NULL,
  `opecajtip_usu_activa` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`opecajtip_codi`),
  UNIQUE KEY `Index_opecajtip_nombre` (`opecajtip_nombre`),
  KEY `Index_opecajtip_tipo` (`opecajtip_tipo`),
  KEY `Index_opecajtip_estado` (`opecajtip_estado`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `operacion_caja_tipo`
--

LOCK TABLES `operacion_caja_tipo` WRITE;
/*!40000 ALTER TABLE `operacion_caja_tipo` DISABLE KEYS */;
INSERT INTO `operacion_caja_tipo` (`opecajtip_codi`, `opecajtip_nombre`, `opecajtip_tipo`, `opecajtip_estado`, `opecajtip_abreviatura`, `opecajtip_usu_crea`, `opecajtip_usu_modifica`, `opecajtip_usu_activa`) VALUES (1,'PAGO DE SALARIOS','SALIDA',1,NULL,NULL,NULL,NULL),(2,'PAGO A PROVEEDORES','SALIDA',1,NULL,NULL,NULL,NULL),(3,'COBRANZAS','INGRESO',1,NULL,NULL,NULL,NULL),(4,'PAGO DE SERVICIOS','SALIDA',1,NULL,NULL,NULL,NULL),(5,'PRESTAMO DE TERCEROS','INGRESO',1,'',NULL,NULL,NULL),(7,'PRESTAMO A TERCEROS','SALIDA',1,'',NULL,NULL,NULL),(8,'OTROS INGRESOS','INGRESO',1,'',NULL,NULL,NULL),(9,'OTRAS SALIDAS','SALIDA',1,'',NULL,NULL,NULL),(10,'PAGO DE BONIFICACIONES','SALIDA',1,'',NULL,NULL,NULL),(11,'COBRO DE VENTA','INGRESO',0,'','etorres','etorres',NULL),(12,'PAGO DE COMPRA','SALIDA',1,'','etorres',NULL,NULL),(13,'INGRESO POR APERTURA DE CAJA','INGRESO',1,'','etorres',NULL,NULL),(14,'SALIDA POR CIERRE DE CAJA','SALIDA',1,'','etorres',NULL,NULL),(15,'SERVICIO DE TRANSPORTE ','SALIDA',1,'','etorres',NULL,NULL),(16,'DEPOSITO BANCARIO','SALIDA',1,'','etorres',NULL,NULL),(17,'PAGO DE DESESTIBA','SALIDA',1,'','etorres',NULL,NULL),(18,'PAGO DE NOTA DE CREDITO','SALIDA',1,'','etorres',NULL,NULL),(19,'EXCEDENTE CIERRE CAJA','INGRESO',1,'','etorres',NULL,NULL),(24,'COBRO DE NOTA DE DEBITO','INGRESO',1,'',NULL,NULL,NULL);
/*!40000 ALTER TABLE `operacion_caja_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `operacion_tipo`
--

DROP TABLE IF EXISTS `operacion_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operacion_tipo` (
  `opetip_codi` int(11) NOT NULL AUTO_INCREMENT,
  `opetip_nombre` varchar(100) DEFAULT NULL,
  `opetip_estado` int(11) NOT NULL DEFAULT 1,
  `opetip_tipo` char(10) NOT NULL DEFAULT 'S',
  `opetip_abreviatura` varchar(45) DEFAULT NULL,
  `opetip_usu_crea` varchar(45) DEFAULT NULL,
  `opetip_usu_modifica` varchar(45) DEFAULT NULL,
  `opetip_usu_activa` varchar(45) DEFAULT NULL,
  `mot_codi_fk_equivalente` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`opetip_codi`),
  UNIQUE KEY `Index_opetip_nombre` (`opetip_nombre`),
  KEY `Index_opetip_estado` (`opetip_estado`),
  KEY `Index_opetip_tipo` (`opetip_tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `operacion_tipo`
--

LOCK TABLES `operacion_tipo` WRITE;
/*!40000 ALTER TABLE `operacion_tipo` DISABLE KEYS */;
INSERT INTO `operacion_tipo` (`opetip_codi`, `opetip_nombre`, `opetip_estado`, `opetip_tipo`, `opetip_abreviatura`, `opetip_usu_crea`, `opetip_usu_modifica`, `opetip_usu_activa`, `mot_codi_fk_equivalente`) VALUES (1,'COMPRA',1,'INGRESO','',NULL,NULL,NULL,3),(2,'INGRESO POR TRASLADO',1,'INGRESO','',NULL,NULL,NULL,6),(3,'SALIDA POR TRASLADO',1,'SALIDA','',NULL,NULL,'etorres',6),(4,'VENTA',1,'SALIDA','',NULL,NULL,NULL,1),(5,'INGRESO POR REINGRESO',1,'INGRESO','',NULL,'MMORE',NULL,13),(6,'SALIDA POR DESCARTE',1,'SALIDA','',NULL,NULL,NULL,13),(7,'SALIDA POR CONVERSIÓN DE UNIDADES',1,'SALIDA','','etorres',NULL,NULL,13),(8,'INGRESO POR CONVERSIÓN DE UNIDADES',1,'INGRESO','','etorres',NULL,NULL,13),(9,'INVENTARIO INICIAL',1,'INGRESO','INV. INIC','ROSIMAR',NULL,NULL,13),(10,'SALIDA POR TRASLADO ENTRE ALMACENES',1,'SALIDA','','etorres',NULL,NULL,6),(11,'INGRESO POR TRASLADO ENTRE ALMACENES',1,'INGRESO','','etorres','etorres',NULL,6),(12,'SALIDA POR MERMA DE TIENDA',1,'SALIDA','','etorres','MMORE',NULL,0),(13,'INGRESO POR NIVELACION INVENTARIO',1,'INGRESO','','LZEA',NULL,NULL,0),(14,'SALIDA POR NIVELACION INVENTARIO',1,'SALIDA','','LZEA',NULL,NULL,0),(15,'SALIDA POR MERMA DE COMPRA',1,'SALIDA','','MMORE',NULL,NULL,0),(18,'SALIDA  PARA MIX DE VERDURAS',1,'SALIDA','','MMORE','MMORE',NULL,0),(19,'SALIDA PARA CONVERSION FRUTAS',1,'SALIDA','','MMORE',NULL,NULL,0),(20,'INGRESO CONVERSION FRUTAS',1,'INGRESO','','MMORE',NULL,NULL,0),(21,'INGRESO POR CONVERSION VERDURAS',1,'INGRESO','','MMORE',NULL,NULL,0),(22,'SALIDA PARA CONVERSION PACK´S',1,'SALIDA','','MMORE',NULL,NULL,0),(23,'INGRESO POR PACK´S',1,'INGRESO','','MMORE',NULL,NULL,0),(24,'SALIDA DE PRODUCTOS PARA CANASTA',1,'SALIDA','','MMORE',NULL,NULL,0),(25,'INGRESO POR PRODUCTOS DE CANASTA',1,'INGRESO','','MMORE',NULL,NULL,0),(26,'SALIDA POR CAMBIO DE PRODUCTO CLIENTE',1,'SALIDA','','MMORE',NULL,NULL,0),(27,'INGRESO POR CAMBIO DE PRODUCTO CLIENTE',1,'INGRESO','','MMORE',NULL,NULL,0),(28,'SALIDA NIVELACION DE INVENTARIO FIN DE AÑO',1,'SALIDA','','MMORE',NULL,NULL,0),(29,'INGRESO NIVELACION DE INVENTARIO FIN DE AÑO',1,'INGRESO','','MMORE',NULL,NULL,0),(30,'SALIDA PARA OFERTA',1,'SALIDA','','MMORE',NULL,NULL,0),(31,'INGRESO POR OFERTA',1,'INGRESO','','MMORE',NULL,NULL,0),(32,'SALIDA DEVOLUCION A PROVEEDOR',1,'SALIDA','','MMORE',NULL,NULL,0),(33,'SALIDA PRODUCTOS VENCIDOS',1,'SALIDA','','MMORE',NULL,NULL,0),(34,'SALIDA PRODUCTOS ENVASE AVERIADO',1,'SALIDA','','MMORE','MMORE',NULL,0),(35,'INGRESO POR DONACION',1,'INGRESO','','MMORE','MMORE',NULL,0),(36,'INGRESO PRODUCTOS ENVASE AVERIADO',1,'INGRESO','','MMORE','MMORE',NULL,0),(37,'SALIDA MERMA POR HURTO',1,'SALIDA','','MMORE',NULL,NULL,0),(38,'INGRESO POR CAMBIO DE PRODUCTO A PROVEEDOR',1,'INGRESO','','MMORE',NULL,NULL,0),(39,'SALIDA POR CAMBIO DE PRODUCTO A PROVEEDOR',1,'SALIDA','','MMORE',NULL,NULL,0),(40,'INGRESO POR CONSIGNACION',1,'INGRESO','','MMORE',NULL,NULL,0),(41,'SALIDA POR PRODUCTO VENCIDO',1,'SALIDA','','MMORE','MMORE',NULL,0),(42,'SALIDA POR CONVERSION DESCRIPCION DE IGV',1,'SALIDA','','MMORE2',NULL,NULL,0),(43,'INGRESO POR CONVERSION DESCRIPCION DE IGV',1,'INGRESO','','MMORE2',NULL,NULL,0),(44,'INGRESO MIX DE VERDURAS',1,'INGRESO','','MMORE',NULL,NULL,0),(45,'SALIDA DEVOL. PROVEEDOR PRODUCTO PROX VENCER',1,'SALIDA','','MMORE',NULL,NULL,0),(46,'SALIDA CONVERSION MIX SOPA',1,'SALIDA','','MMORE',NULL,NULL,0),(47,'INGRESO MIX SOPA',1,'INGRESO','','MMORE',NULL,NULL,0),(48,'SALIDA POR COMVERSION ',1,'SALIDA','','ACARRASCO',NULL,NULL,0),(49,'INGRESO POR COMVERSION ',1,'INGRESO','','ACARRASCO',NULL,NULL,0),(50,'SALIDA POR CONSUMO DE TIENDA',1,'SALIDA','','ACARRASCO',NULL,NULL,0),(51,'SALIDA POR PRODUCTO ROBADO',1,'SALIDA','','ACARRASCO','ACARRASCO',NULL,0),(55,'INGRESO POR DEVOLUCION',1,'INGRESO','',NULL,NULL,NULL,0),(56,'SALIDA POR VENTA A CONSIGNACION',1,'SALIDA','',NULL,NULL,NULL,0),(57,'INGRESO POR NOTA DE CREDITO DE VENTA',1,'INGRESO','',NULL,NULL,NULL,0);
/*!40000 ALTER TABLE `operacion_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orden_compra`
--

DROP TABLE IF EXISTS `orden_compra`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orden_compra` (
  `ordcom_codi` int(11) NOT NULL AUTO_INCREMENT,
  `ordcom_fechahora` datetime DEFAULT NULL,
  `ordcom_fecha` date DEFAULT NULL,
  `ordcom_numero` varchar(45) DEFAULT NULL,
  `per_codi_fk` int(11) NOT NULL DEFAULT 0,
  `pagtip_codi_fk` int(11) DEFAULT NULL,
  `ordcom_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `idtrans` varchar(45) DEFAULT NULL,
  `ordcom_anotaciones` text DEFAULT NULL,
  `ordcom_usu_crea` varchar(45) DEFAULT NULL,
  `ordcom_usu_modifica` varchar(45) DEFAULT NULL,
  `ordcom_usu_activa` varchar(45) DEFAULT NULL,
  `docpag_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `ordcom_docpagnum` varchar(45) DEFAULT NULL,
  `ordcom_igv_porcentaje` float NOT NULL DEFAULT 18,
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `req_codi_fk` int(10) unsigned DEFAULT NULL,
  `ordcom_fecha_vence` date DEFAULT NULL,
  `ordcom_percepcion` float NOT NULL DEFAULT 0,
  `ordcom_tipo` int(10) unsigned NOT NULL DEFAULT 1,
  `ordcom_cc_codi_fk` int(11) DEFAULT NULL,
  `ordcom_isc` float NOT NULL DEFAULT 0,
  PRIMARY KEY (`ordcom_codi`),
  UNIQUE KEY `Index_ordcom_numero` (`ordcom_numero`),
  KEY `fk_orden_pago_tipo1_idx` (`pagtip_codi_fk`),
  KEY `fk_orden_personas1_idx` (`per_codi_fk`),
  KEY `Index_ordcom_estado` (`ordcom_estado`),
  KEY `Index_idtrans` (`idtrans`),
  KEY `Index_docpag_codi_fk` (`docpag_codi_fk`),
  KEY `Index_ordcom_docpagnum` (`ordcom_docpagnum`),
  CONSTRAINT `FK_orden_compra_documento_pago` FOREIGN KEY (`docpag_codi_fk`) REFERENCES `documento_pago` (`docpag_codi`),
  CONSTRAINT `fk_orden_pago_tipo1` FOREIGN KEY (`pagtip_codi_fk`) REFERENCES `pago_tipo` (`pagtip_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_orden_personas1` FOREIGN KEY (`per_codi_fk`) REFERENCES `personas` (`per_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orden_compra`
--

LOCK TABLES `orden_compra` WRITE;
/*!40000 ALTER TABLE `orden_compra` DISABLE KEYS */;
/*!40000 ALTER TABLE `orden_compra` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orden_compra_almacen`
--

DROP TABLE IF EXISTS `orden_compra_almacen`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orden_compra_almacen` (
  `ordcomalm_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ordcom_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `opealm_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `ordcomalm_fechahora` datetime DEFAULT NULL,
  PRIMARY KEY (`ordcomalm_codi`),
  KEY `Index_ordcom_codi_fk` (`ordcom_codi_fk`),
  KEY `Index_opealm_codi_fk` (`opealm_codi_fk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orden_compra_almacen`
--

LOCK TABLES `orden_compra_almacen` WRITE;
/*!40000 ALTER TABLE `orden_compra_almacen` DISABLE KEYS */;
/*!40000 ALTER TABLE `orden_compra_almacen` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orden_compra_caja`
--

DROP TABLE IF EXISTS `orden_compra_caja`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orden_compra_caja` (
  `ordcomcaj_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ordcom_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `opecaj_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `ordcomcaj_fechahora` datetime DEFAULT NULL,
  PRIMARY KEY (`ordcomcaj_codi`),
  KEY `Index_opecaj_codi_fk` (`opecaj_codi_fk`),
  KEY `Index_ordcom_codi_fk` (`ordcom_codi_fk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orden_compra_caja`
--

LOCK TABLES `orden_compra_caja` WRITE;
/*!40000 ALTER TABLE `orden_compra_caja` DISABLE KEYS */;
/*!40000 ALTER TABLE `orden_compra_caja` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orden_compra_detalle`
--

DROP TABLE IF EXISTS `orden_compra_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orden_compra_detalle` (
  `ordcomdet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `ordcomdet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `ordcomdet_precio` float NOT NULL DEFAULT 0,
  `ordcomdet_cantidad` float NOT NULL DEFAULT 0,
  `ordcom_codi_fk` int(11) DEFAULT NULL,
  `idtrans` varchar(45) DEFAULT NULL,
  `ordcomdet_igv` float NOT NULL DEFAULT 0,
  `ordcomdet_isc` float NOT NULL DEFAULT 0,
  `ordcomdet_percepcion` float NOT NULL DEFAULT 0,
  `ordcomdet_igv_afectado` int(11) NOT NULL DEFAULT 0,
  `ordcomdet_isc_afectado` int(11) NOT NULL DEFAULT 0,
  `ordcomdet_cantidad_devolver` float NOT NULL DEFAULT 0,
  `ordcomdet_cantidad_devolver_temporal` float NOT NULL DEFAULT 0,
  `ordcomdet_precio_descuento` float NOT NULL DEFAULT 0,
  `ordcomdet_precio_descuento_temporal` float NOT NULL DEFAULT 0,
  `ordcomdet_cantidad_devolver2` float NOT NULL DEFAULT 0,
  `ordcomdet_cantidad_devolver_temporal2` float NOT NULL DEFAULT 0,
  `ordcomdet_precio_descuento2` float NOT NULL DEFAULT 0,
  `ordcomdet_precio_descuento_temporal2` float NOT NULL DEFAULT 0,
  `ordcomdet_cantidad_devolver3` float NOT NULL DEFAULT 0,
  `ordcomdet_cantidad_devolver_temporal3` float NOT NULL DEFAULT 0,
  `ordcomdet_precio_descuento3` float NOT NULL DEFAULT 0,
  `ordcomdet_precio_descuento_temporal3` float NOT NULL DEFAULT 0,
  PRIMARY KEY (`ordcomdet_codi`),
  KEY `fk_orden_compra_detalle_orden1_idx` (`ordcom_codi_fk`),
  KEY `Index_prd_codi_fk` (`prd_codi_fk`),
  KEY `Index_unimed_codi_fk` (`unimed_codi_fk`),
  KEY `Index_idtrans` (`idtrans`),
  CONSTRAINT `FK_orden_compra_detalle_productos` FOREIGN KEY (`prd_codi_fk`) REFERENCES `productos` (`prd_codi`),
  CONSTRAINT `FK_orden_compra_detalle_unidades` FOREIGN KEY (`unimed_codi_fk`) REFERENCES `unidades_medida` (`unimed_codi`),
  CONSTRAINT `fk_orden_compra_detalle_orden1` FOREIGN KEY (`ordcom_codi_fk`) REFERENCES `orden_compra` (`ordcom_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orden_compra_detalle`
--

LOCK TABLES `orden_compra_detalle` WRITE;
/*!40000 ALTER TABLE `orden_compra_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `orden_compra_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orden_pedido`
--

DROP TABLE IF EXISTS `orden_pedido`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orden_pedido` (
  `ordped_codi` int(11) NOT NULL AUTO_INCREMENT,
  `ordped_fechahora` datetime DEFAULT NULL,
  `ordped_fecha` date DEFAULT NULL,
  `ordped_numero` varchar(45) DEFAULT NULL,
  `per_codi_fk` int(11) NOT NULL DEFAULT 0,
  `doctip_codi_fk` int(11) NOT NULL,
  `pagtip_codi_fk` int(11) NOT NULL DEFAULT 0,
  `idtrans` varchar(45) DEFAULT NULL,
  `ordped_anotaciones` text DEFAULT NULL,
  `ordped_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `ordped_usu_crea` varchar(45) DEFAULT NULL,
  `ordped_usu_modifica` varchar(45) DEFAULT NULL,
  `ordped_usu_activa` varchar(45) DEFAULT NULL,
  `docpag_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `ordped_docpagnum` varchar(45) DEFAULT NULL,
  `cot_codi_fk` int(10) unsigned DEFAULT NULL,
  `ordped_igv_porcentaje` float NOT NULL DEFAULT 18,
  `ordped_fecha_documento` date DEFAULT NULL,
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `ordped_dias_credito` int(10) unsigned NOT NULL DEFAULT 0,
  `ordped_dias_credito_ampliacion` int(10) unsigned NOT NULL DEFAULT 0,
  `ordped_txt_generado` int(10) unsigned NOT NULL DEFAULT 0,
  `codigohast` varchar(245) NOT NULL DEFAULT '',
  `timbrexml` int(10) unsigned NOT NULL DEFAULT 0,
  `firma` text DEFAULT NULL,
  `timbreweb` int(10) unsigned NOT NULL DEFAULT 0,
  `ordped_facturacion_electronica` int(10) unsigned NOT NULL DEFAULT 0,
  `ordped_observacion` text DEFAULT NULL,
  `medpag_codi_fk` int(11) DEFAULT NULL,
  `timbrerpta` int(10) unsigned NOT NULL DEFAULT 0,
  `detallerpta` text NOT NULL,
  `flg_ose` int(10) unsigned NOT NULL DEFAULT 0,
  `ordped_caj_numero` varchar(11) DEFAULT NULL,
  `ordped_efectivo` float NOT NULL DEFAULT 0,
  `ordped_cambio` float NOT NULL DEFAULT 0,
  `comser_codi_fk` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`ordped_codi`),
  KEY `fk_orden_pedido_documento_tipo1_idx` (`doctip_codi_fk`),
  KEY `fk_orden_pedido_pago_tipo1_idx` (`pagtip_codi_fk`),
  KEY `fk_orden_pedido_personas1_idx` (`per_codi_fk`),
  KEY `Index_idtrans` (`idtrans`),
  KEY `Index_ordped_estado` (`ordped_estado`),
  KEY `Index_docpag_codi_fk` (`docpag_codi_fk`),
  KEY `Index_emp_codi_fk` (`emp_codi_fk`),
  KEY `Index_ordped_docpagnum` (`ordped_docpagnum`),
  KEY `Index_cot_codi_fk` (`cot_codi_fk`),
  KEY `Index_ordped_txt_generado` (`ordped_txt_generado`),
  KEY `Index_timbrexml` (`timbrexml`),
  KEY `Index_timbrerpta` (`timbrerpta`),
  KEY `ordped_numero` (`ordped_numero`),
  KEY `Index_ordped_numero` (`ordped_numero`) USING BTREE,
  CONSTRAINT `FK_orden_pedido_empresas` FOREIGN KEY (`emp_codi_fk`) REFERENCES `empresas` (`emp_codi`),
  CONSTRAINT `fk_orden_pedido_documento_tipo1` FOREIGN KEY (`doctip_codi_fk`) REFERENCES `documento_tipo` (`doctip_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_orden_pedido_pago_tipo1` FOREIGN KEY (`pagtip_codi_fk`) REFERENCES `pago_tipo` (`pagtip_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_orden_pedido_personas1` FOREIGN KEY (`per_codi_fk`) REFERENCES `personas` (`per_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orden_pedido`
--

LOCK TABLES `orden_pedido` WRITE;
/*!40000 ALTER TABLE `orden_pedido` DISABLE KEYS */;
INSERT INTO `orden_pedido` (`ordped_codi`, `ordped_fechahora`, `ordped_fecha`, `ordped_numero`, `per_codi_fk`, `doctip_codi_fk`, `pagtip_codi_fk`, `idtrans`, `ordped_anotaciones`, `ordped_estado`, `ordped_usu_crea`, `ordped_usu_modifica`, `ordped_usu_activa`, `docpag_codi_fk`, `ordped_docpagnum`, `cot_codi_fk`, `ordped_igv_porcentaje`, `ordped_fecha_documento`, `emp_codi_fk`, `ordped_dias_credito`, `ordped_dias_credito_ampliacion`, `ordped_txt_generado`, `codigohast`, `timbrexml`, `firma`, `timbreweb`, `ordped_facturacion_electronica`, `ordped_observacion`, `medpag_codi_fk`, `timbrerpta`, `detallerpta`, `flg_ose`, `ordped_caj_numero`, `ordped_efectivo`, `ordped_cambio`, `comser_codi_fk`) VALUES (1,'2024-09-17 19:02:05','2024-09-17','0000001',39,2,1,'1726358459479351866','',1,'ETORRES',NULL,NULL,2,'B001-1',0,18,'2024-09-17',1,0,0,0,'D9xZzPJKgeeQP2beAOEmabc6qoY=',1,'D9xZzPJKgeeQP2beAOEmabc6qoY=ZF1LxRA+9XRiM9MhPNG/THdCe/zwKR/dE6hWZFxAff0zeP44djTc4CUluFvuR2JPLtlt97BOfmTN3JTw4ucv56ROdh24/7NoeQMtBoxUPWkninBkXO2qy6vm+nnV/1hP1RSZsiG0sR1x4a5x0E7Bhrm4UYVDIM8Pr6W0pNf2woBNBHcQn+X6KT9CbJnKPVCDAaRoLM61zOw6UFWKtVWmDevgl0C9SmXOoOw9phSSv1cLM16Xa8foVzvich5AXAvZPulA3rf5tSrcMl6UCkGPhSsDSiGvQgBcFVSwpM6mZldZ/69CyE3tenyWrqOV+8RDSbqiZgNmSRQmoob9imwQiA==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',0,1,'',1,1,'',1,'C-0000001',0,0,2),(2,'2024-09-18 11:09:13','2024-09-18','0000002',45,2,1,'17266756579517931623','',1,'ETORRES',NULL,NULL,3,'F001-1',0,18,'2024-09-18',1,0,0,0,'s2fk77XO9lt0oKlAp3Jc01b4AYI=',1,'s2fk77XO9lt0oKlAp3Jc01b4AYI=UYnMo/PZu4wry4XC3DOvu8rp+yjbL/zS9UVfDwjLI5dbMAUy31loLbfzao0IhJUHK+qaDsEruPFb9zqmKi4ALNbpYYVFhaX2bOS0b0T3usLZcmAVHP3q5uOfEY8D4R5kpmKVvqmg2lvIrm+9jv9xDdJiTXrStRE15+VJlTt83tQmnV8+TQzkaIdw4OaypH7ifP+cDL4FJGWVP2gm4Rhbu3nogXbLPOBX86ww32Xok2sVLE23yjVO3uEFVCvj+DC34kCJrDlxiWESbs8FCchBvF1z2A6CKq+6+k1xfGmPc09Izbcfj62ER4iOJSpJlm4xMNKWtsYwVifIqS9M2wKNag==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',0,1,'',1,1,'',1,'C-0000001',0,0,1),(3,'2024-10-03 14:19:13','2024-10-03','0000003',47,2,1,'17279830198964283217','',1,'EBOTELLO',NULL,NULL,3,'F001-2',0,18,'2024-10-03',1,0,0,0,'gEHLUVqISq8BeK3UcZp5DnwyG0Q=',1,'gEHLUVqISq8BeK3UcZp5DnwyG0Q=jusYB9lzFjnrdauarhINadmktj7qPPWLa6cW5QOv3Mfkw6v5XJpmhc0TRTZhJJ6zVCm57y1edJrnHLIJmjJz77s4UTQCpC8CN6cNiuIIIk29Cef3jQBqBWMjjrX7XcvHbSJRB7lfqqGzBwdBbUDAUX7lQ9IUKDS5Rv1MgXiT6r3PgzkO2X1hK9zOw0PkWGA4d9voNXJBNhO0gy8x7rT57rN0gwFe7iEoLbMHBcAktTsvsfvRmNlStouPmLyz8FEN1nwjIEhiO8hDfS3ZkR0Jm5BWHztDp3KubqffjmRyFCJLaq6SeH8AMSEF8DLgaZ0wzZIDAIvW/7BsXJgjU/T/Eg==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',0,1,'',1,0,' - soap-env:Client.0111',1,'C-0000002',0,0,1);
/*!40000 ALTER TABLE `orden_pedido` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orden_pedido_almacen`
--

DROP TABLE IF EXISTS `orden_pedido_almacen`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orden_pedido_almacen` (
  `ordpedalm_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ordped_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `opealm_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `ordpedalm_fechahora` datetime DEFAULT NULL,
  PRIMARY KEY (`ordpedalm_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orden_pedido_almacen`
--

LOCK TABLES `orden_pedido_almacen` WRITE;
/*!40000 ALTER TABLE `orden_pedido_almacen` DISABLE KEYS */;
INSERT INTO `orden_pedido_almacen` (`ordpedalm_codi`, `ordped_codi_fk`, `opealm_codi_fk`, `ordpedalm_fechahora`) VALUES (1,1,1,'2024-09-14 19:02:05'),(2,2,2,'2024-09-18 11:09:13'),(3,3,6,'2024-10-03 14:19:13');
/*!40000 ALTER TABLE `orden_pedido_almacen` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orden_pedido_caja`
--

DROP TABLE IF EXISTS `orden_pedido_caja`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orden_pedido_caja` (
  `ordpedcaj_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ordped_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `opecaj_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `ordpedcaj_fechahora` datetime DEFAULT NULL,
  PRIMARY KEY (`ordpedcaj_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orden_pedido_caja`
--

LOCK TABLES `orden_pedido_caja` WRITE;
/*!40000 ALTER TABLE `orden_pedido_caja` DISABLE KEYS */;
INSERT INTO `orden_pedido_caja` (`ordpedcaj_codi`, `ordped_codi_fk`, `opecaj_codi_fk`, `ordpedcaj_fechahora`) VALUES (1,1,1,'2024-09-14 19:02:05'),(2,2,2,'2024-09-18 11:09:13'),(3,3,5,'2024-10-03 14:19:13');
/*!40000 ALTER TABLE `orden_pedido_caja` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orden_pedido_detalle`
--

DROP TABLE IF EXISTS `orden_pedido_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orden_pedido_detalle` (
  `ordpeddet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `ordpeddet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `ordpeddet_precio` float NOT NULL DEFAULT 0,
  `ordpeddet_cantidad` float NOT NULL DEFAULT 0,
  `ordped_codi_fk` int(11) NOT NULL DEFAULT 0,
  `idtrans` varchar(45) DEFAULT NULL,
  `ordpeddet_observaciones` text DEFAULT NULL,
  `idtrans_nuevo` varchar(45) DEFAULT NULL,
  `ordpeddet_precio_catalogo` float NOT NULL DEFAULT 0,
  `ordpeddet_icbper_monto_unitario` float NOT NULL DEFAULT 0,
  `ordpeddet_cantidad_devolver` float NOT NULL DEFAULT 0,
  `ordpeddet_cantidad_devolver_temporal` float NOT NULL DEFAULT 0,
  `ordpeddet_igv_afectado` int(11) NOT NULL DEFAULT 0,
  `ordpeddet_precio_descuento` float NOT NULL DEFAULT 0,
  `ordpeddet_precio_descuento_temporal` float NOT NULL DEFAULT 0,
  PRIMARY KEY (`ordpeddet_codi`),
  KEY `fk_orden_pedido_detalle_orden_pedido1_idx` (`ordped_codi_fk`),
  CONSTRAINT `fk_orden_pedido_detalle_orden_pedido1` FOREIGN KEY (`ordped_codi_fk`) REFERENCES `orden_pedido` (`ordped_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orden_pedido_detalle`
--

LOCK TABLES `orden_pedido_detalle` WRITE;
/*!40000 ALTER TABLE `orden_pedido_detalle` DISABLE KEYS */;
INSERT INTO `orden_pedido_detalle` (`ordpeddet_codi`, `ordpeddet_fechahora`, `prd_codi_fk`, `unimed_codi_fk`, `ordpeddet_precio`, `ordpeddet_cantidad`, `ordped_codi_fk`, `idtrans`, `ordpeddet_observaciones`, `idtrans_nuevo`, `ordpeddet_precio_catalogo`, `ordpeddet_icbper_monto_unitario`, `ordpeddet_cantidad_devolver`, `ordpeddet_cantidad_devolver_temporal`, `ordpeddet_igv_afectado`, `ordpeddet_precio_descuento`, `ordpeddet_precio_descuento_temporal`) VALUES (1,'2024-09-14 19:02:05',38,1,4,1,1,'1726358459479351866','',NULL,4,0,0,0,0,0,0),(2,'2024-09-18 11:09:13',35,1,8,1,2,'17266756579517931623','',NULL,8,0,0,0,0,0,0),(3,'2024-10-03 14:19:13',52,1,3400,1,3,'17279830198964283217','',NULL,3400,0,0,0,0,0,0);
/*!40000 ALTER TABLE `orden_pedido_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pago_tipo`
--

DROP TABLE IF EXISTS `pago_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pago_tipo` (
  `pagtip_codi` int(11) NOT NULL AUTO_INCREMENT,
  `pagtip_nombre` varchar(145) DEFAULT NULL,
  `pagtip_estado` int(11) DEFAULT NULL,
  `pagtip_caja_automatica` int(10) unsigned NOT NULL DEFAULT 0,
  `pagtip_almacen_automatico` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`pagtip_codi`),
  UNIQUE KEY `Index_pagtip_nombre` (`pagtip_nombre`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pago_tipo`
--

LOCK TABLES `pago_tipo` WRITE;
/*!40000 ALTER TABLE `pago_tipo` DISABLE KEYS */;
INSERT INTO `pago_tipo` (`pagtip_codi`, `pagtip_nombre`, `pagtip_estado`, `pagtip_caja_automatica`, `pagtip_almacen_automatico`) VALUES (1,'CONTADO',1,1,1),(2,'CREDITO',1,0,1),(3,'CONTRA ENTREGA',1,0,0),(4,'PAGO ADELANTADO',1,1,0),(5,'CONSIGNACION',1,0,0);
/*!40000 ALTER TABLE `pago_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personas`
--

DROP TABLE IF EXISTS `personas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `personas` (
  `per_codi` int(11) NOT NULL AUTO_INCREMENT,
  `per_nombre_comercial` varchar(200) DEFAULT NULL,
  `per_razon_social` varchar(200) DEFAULT NULL,
  `per_ruc` varchar(15) DEFAULT NULL,
  `per_nombre` varchar(200) DEFAULT NULL,
  `per_apellido` varchar(200) DEFAULT NULL,
  `per_email` varchar(50) DEFAULT NULL,
  `per_credito` int(11) NOT NULL DEFAULT 0,
  `pertip_codi_fk` int(11) DEFAULT NULL,
  `per_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `per_telefono1` varchar(100) DEFAULT NULL,
  `per_telefono2` varchar(100) DEFAULT NULL,
  `per_direccion1` text DEFAULT NULL,
  `per_direccion2` text DEFAULT NULL,
  `percar_codi_fk` int(10) unsigned DEFAULT NULL,
  `per_usu_crea` varchar(45) DEFAULT NULL,
  `per_usu_modifica` varchar(45) DEFAULT NULL,
  `per_usu_activa` varchar(45) DEFAULT NULL,
  `per_idtrans` varchar(45) DEFAULT NULL,
  `per_importe_credito` float NOT NULL DEFAULT 0,
  `per_importe_sobregiro` float NOT NULL DEFAULT 0,
  `per_codigo` varchar(8) NOT NULL DEFAULT '0',
  `per_ruc_dni_tipo` int(10) unsigned NOT NULL DEFAULT 0,
  `per_clave` varchar(45) DEFAULT NULL,
  `prctip_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`per_codi`),
  KEY `fk_personas_personas_tipo1_idx` (`pertip_codi_fk`),
  KEY `Index_per_nombre_comercial` (`per_nombre_comercial`),
  KEY `Index_per_razon_social` (`per_razon_social`),
  KEY `Index_per_ruc` (`per_ruc`),
  KEY `Index_per_nombre` (`per_nombre`),
  KEY `Index_per_apellido` (`per_apellido`),
  KEY `Index_per_credito` (`per_credito`),
  KEY `Index_per_ruc_dni_tipo` (`per_ruc_dni_tipo`),
  KEY `Index_per_idtrans` (`per_idtrans`),
  CONSTRAINT `fk_personas_personas_tipo1` FOREIGN KEY (`pertip_codi_fk`) REFERENCES `personas_tipo` (`pertip_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personas`
--

LOCK TABLES `personas` WRITE;
/*!40000 ALTER TABLE `personas` DISABLE KEYS */;
INSERT INTO `personas` (`per_codi`, `per_nombre_comercial`, `per_razon_social`, `per_ruc`, `per_nombre`, `per_apellido`, `per_email`, `per_credito`, `pertip_codi_fk`, `per_estado`, `per_telefono1`, `per_telefono2`, `per_direccion1`, `per_direccion2`, `percar_codi_fk`, `per_usu_crea`, `per_usu_modifica`, `per_usu_activa`, `per_idtrans`, `per_importe_credito`, `per_importe_sobregiro`, `per_codigo`, `per_ruc_dni_tipo`, `per_clave`, `prctip_codi_fk`) VALUES (39,'-VARIOS-','-VARIOS-','-','-','-','',0,NULL,1,'',NULL,'',NULL,NULL,NULL,NULL,NULL,'17176405281265645812',0,0,'00000039',1,NULL,0),(40,'IMPORTACION MAXMECH S.A.C.','IMPORTACION MAXMECH S.A.C.','20611728256','HERBERTH','ANDRADE','INFO@REDBOPERU.COM',0,NULL,1,'933234139',NULL,'AV. NICOLAS AYLLON NRO 2931 INT. B1-3  - EL AGUSTINO - LIMA - LIMA',NULL,NULL,NULL,NULL,NULL,'17229866996901515677',0,0,'00000040',6,NULL,0),(41,'REDBO PERU S.A.C.','REDBO PERU S.A.C.','20609315831','ANDRADE','HERBERTH','INFO@REDBOPERU.COM',0,NULL,1,'933234139',NULL,'AV. NICOLAS AYLLON NRO 2931 INT. B2-1 URB. PUENTE  - EL AGUSTINO - LIMA - LIMA',NULL,NULL,NULL,NULL,NULL,'17229868412758568889',0,0,'00000041',6,NULL,0),(42,'ALIENWELD PERU S.A.C.','ALIENWELD PERU S.A.C.','20611980745','ALIEN','REVILLA','VENTAS@SOLINDUSTRIAS.COM',0,NULL,1,'999224504',NULL,'JR. MARISCAL MILLER NRO 2418 INT. 2  - LINCE - LIMA - LIMA',NULL,NULL,NULL,NULL,NULL,'17229875953504597434',0,0,'00000042',6,NULL,0),(43,'MARCO NATANAEL YAMUNAQUE ARCELA','MARCO NATANAEL YAMUNAQUE ARCELA','72922627','MARCO NATANAEL','YAMUNAQUE ARCELA','',0,NULL,1,'912674946',NULL,'PIURA',NULL,NULL,NULL,NULL,NULL,'17232205614400096001',0,0,'00000043',1,NULL,0),(44,'BRANDON LUIS PANTALEON YOVERA','BRANDON LUIS PANTALEON YOVERA','72175384','','','',0,NULL,1,'',NULL,'',NULL,NULL,NULL,NULL,NULL,'17251457195391176621',0,0,'00000044',1,NULL,0),(45,'SAGAZ SISTEMAS Y MULTISERVICIOS S.A.C.','SAGAZ SISTEMAS Y MULTISERVICIOS S.A.C.','20606259183','','','',0,NULL,1,'',NULL,'CAL. LAS HIEDRAS NRO 355 URB. FEDERICO VILLAREAL  - CHICLAYO - CHICLAYO - LAMBAYEQUE',NULL,NULL,NULL,NULL,NULL,'17266757068976178697',0,0,'00000045',6,NULL,0),(46,'GRUPO INDUSTRIAL SOUTH PACIFIC S.A.C.','GRUPO INDUSTRIAL SOUTH PACIFIC S.A.C.','20605575308','','','',0,NULL,1,'940224713',NULL,'OTR. CARRETERA PANAMERICANA SU INT. 08 LOTE E OTR. MEGACENTRO LURIN KM. 29.5  - LURIN - LIMA - LIMA',NULL,NULL,NULL,NULL,NULL,'17279823904045498141',0,0,'00000046',6,NULL,0),(47,'BLAS ROJAS ALFREDO','BLAS ROJAS ALFREDO','10040038545','BLAS','BLAS ROJAS ALFREDO','',0,NULL,1,'930126031',NULL,'CERRO DE PASCO',NULL,NULL,NULL,NULL,NULL,'17279831016065117477',0,0,'00000047',6,NULL,0);
/*!40000 ALTER TABLE `personas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personas_tipo`
--

DROP TABLE IF EXISTS `personas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `personas_tipo` (
  `pertip_codi` int(11) NOT NULL AUTO_INCREMENT,
  `pertip_nombre` varchar(80) NOT NULL DEFAULT '',
  `pertip_estado` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`pertip_codi`),
  UNIQUE KEY `Index_pertip_nombre` (`pertip_nombre`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personas_tipo`
--

LOCK TABLES `personas_tipo` WRITE;
/*!40000 ALTER TABLE `personas_tipo` DISABLE KEYS */;
INSERT INTO `personas_tipo` (`pertip_codi`, `pertip_nombre`, `pertip_estado`) VALUES (1,'EMPLEADO',1),(2,'CLIENTE',1),(3,'PROVEEDOR',1);
/*!40000 ALTER TABLE `personas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `precios`
--

DROP TABLE IF EXISTS `precios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `precios` (
  `prc_codi` int(11) NOT NULL AUTO_INCREMENT,
  `prc_precio` float NOT NULL DEFAULT 0,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `prd_codi_fk` int(11) NOT NULL DEFAULT 0,
  `prctip_codi_fk` int(11) DEFAULT NULL,
  `prc_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `prc_defecto` int(10) unsigned NOT NULL DEFAULT 0,
  `prc_usu_crea` varchar(45) DEFAULT NULL,
  `prc_usu_modifica` varchar(45) DEFAULT NULL,
  `prc_usu_activa` varchar(45) DEFAULT NULL,
  `prc_costo` float NOT NULL DEFAULT 0,
  `prc_equivalente` int(10) unsigned NOT NULL DEFAULT 1,
  `emp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`prc_codi`),
  KEY `fk_precios_productos1_idx` (`prd_codi_fk`),
  KEY `fk_precios_unidades_medida1_idx` (`unimed_codi_fk`)
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `precios`
--

LOCK TABLES `precios` WRITE;
/*!40000 ALTER TABLE `precios` DISABLE KEYS */;
INSERT INTO `precios` (`prc_codi`, `prc_precio`, `unimed_codi_fk`, `prd_codi_fk`, `prctip_codi_fk`, `prc_estado`, `prc_defecto`, `prc_usu_crea`, `prc_usu_modifica`, `prc_usu_activa`, `prc_costo`, `prc_equivalente`, `emp_codi_fk`) VALUES (1,4000,1,28,2,1,0,NULL,NULL,NULL,0,1,1),(2,4200,1,28,2,1,0,NULL,NULL,NULL,0,1,1),(3,1850,1,25,2,1,0,NULL,NULL,NULL,0,1,1),(4,1950,1,25,2,1,0,NULL,NULL,NULL,0,1,1),(5,2600,1,26,2,1,0,NULL,NULL,NULL,0,1,1),(8,3600,1,27,2,1,0,NULL,NULL,NULL,0,1,1),(10,590,1,9,2,1,0,NULL,NULL,NULL,0,1,1),(11,690,1,8,2,1,0,NULL,NULL,NULL,0,1,1),(15,890,1,10,2,1,0,NULL,NULL,NULL,0,1,1),(16,1500,1,11,2,1,0,NULL,NULL,NULL,0,1,1),(17,1450,1,11,2,1,0,NULL,NULL,NULL,0,1,1),(19,2300,1,14,2,1,0,NULL,NULL,NULL,0,1,1),(20,4300,1,16,2,1,0,NULL,NULL,NULL,0,1,1),(21,4600,1,17,2,1,0,NULL,NULL,NULL,0,1,1),(22,5200,1,18,2,1,0,NULL,NULL,NULL,0,1,1),(23,6200,1,19,2,1,0,NULL,NULL,NULL,0,1,1),(24,10000,1,20,2,1,0,NULL,NULL,NULL,0,1,1),(25,1450,1,29,2,1,0,NULL,NULL,NULL,0,1,1),(26,5300,1,23,2,1,0,NULL,NULL,NULL,0,1,1),(27,1850,1,21,2,1,0,NULL,NULL,NULL,0,1,1),(29,2400,1,22,2,1,0,NULL,NULL,NULL,0,1,1),(30,2500,1,22,2,1,0,NULL,NULL,NULL,0,1,1),(32,2400,1,24,2,1,0,NULL,NULL,NULL,0,1,1),(34,3600,1,15,2,1,0,NULL,NULL,NULL,0,1,1),(35,3500,1,15,2,1,0,NULL,NULL,NULL,0,1,1),(36,3000,1,7,2,1,0,NULL,NULL,NULL,0,1,1),(37,2800,1,6,2,1,0,NULL,NULL,NULL,0,1,1),(38,2100,1,5,2,1,0,NULL,NULL,NULL,0,1,1),(39,720,1,2,2,1,0,NULL,NULL,NULL,0,1,1),(40,820,1,3,2,1,0,NULL,NULL,NULL,0,1,1),(41,980,1,4,2,1,0,NULL,NULL,NULL,0,1,1),(42,360,1,1,2,1,0,NULL,NULL,NULL,0,1,1),(43,2600,1,13,2,1,0,NULL,NULL,NULL,0,1,1),(45,1800,1,12,2,1,0,NULL,NULL,NULL,0,1,1),(46,85,1,30,2,1,0,NULL,NULL,NULL,0,1,1),(47,85,1,31,2,1,0,NULL,NULL,NULL,0,1,1),(48,125,1,32,2,1,0,NULL,NULL,NULL,0,1,1),(49,125,1,33,2,1,0,NULL,NULL,NULL,0,1,1),(50,48,1,43,2,1,0,NULL,NULL,NULL,0,1,1),(51,120,1,41,2,1,0,NULL,NULL,NULL,0,1,1),(52,15,1,37,2,1,0,NULL,NULL,NULL,0,1,1),(53,100,1,34,2,1,0,NULL,NULL,NULL,0,1,1),(54,7,1,40,2,1,0,NULL,NULL,NULL,0,1,1),(55,7,1,42,2,1,0,NULL,NULL,NULL,0,1,1),(56,4,1,38,2,1,0,NULL,NULL,NULL,0,1,1),(57,15,1,39,2,1,0,NULL,NULL,NULL,0,1,1),(58,18,1,44,2,1,0,NULL,NULL,NULL,0,1,1),(59,8,1,35,2,1,0,NULL,NULL,NULL,0,1,1),(60,18,1,36,2,1,0,NULL,NULL,NULL,0,1,1),(61,800,1,46,2,1,0,NULL,NULL,NULL,0,1,1),(62,2600,1,51,2,1,0,NULL,NULL,NULL,0,1,1),(63,1350,1,47,2,1,0,NULL,NULL,NULL,0,1,1),(64,5200,1,45,2,1,0,NULL,NULL,NULL,0,1,1),(65,5000,1,45,2,1,0,NULL,NULL,NULL,0,1,1),(68,1850,1,48,2,1,0,NULL,NULL,NULL,0,1,1),(69,3500,1,49,2,1,0,NULL,NULL,NULL,0,1,1),(70,2200,1,50,2,1,0,NULL,NULL,NULL,0,1,1),(71,2100,1,50,2,1,0,NULL,NULL,NULL,0,1,1),(72,3400,1,52,2,1,0,NULL,NULL,NULL,0,1,1);
/*!40000 ALTER TABLE `precios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `precios_insumos`
--

DROP TABLE IF EXISTS `precios_insumos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `precios_insumos` (
  `prcins_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `prc_codi_fk` varchar(45) NOT NULL DEFAULT '',
  `prd_codi_fk_insumo` int(10) unsigned NOT NULL DEFAULT 0,
  `prcins_cantidad` float NOT NULL DEFAULT 0,
  PRIMARY KEY (`prcins_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `precios_insumos`
--

LOCK TABLES `precios_insumos` WRITE;
/*!40000 ALTER TABLE `precios_insumos` DISABLE KEYS */;
/*!40000 ALTER TABLE `precios_insumos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `precios_tipo`
--

DROP TABLE IF EXISTS `precios_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `precios_tipo` (
  `prctip_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `prctip_nombre` varchar(100) NOT NULL DEFAULT '',
  `prctip_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `prctip_abreviatura` varchar(45) DEFAULT NULL,
  `prctip_usu_crea` varchar(45) DEFAULT NULL,
  `prctip_usu_modifica` varchar(45) DEFAULT NULL,
  `prctip_usu_activa` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`prctip_codi`),
  UNIQUE KEY `Index_prctip_nombre` (`prctip_nombre`),
  KEY `Index_prctip_estado` (`prctip_estado`),
  KEY `Index_prctip_abreviatura` (`prctip_abreviatura`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `precios_tipo`
--

LOCK TABLES `precios_tipo` WRITE;
/*!40000 ALTER TABLE `precios_tipo` DISABLE KEYS */;
INSERT INTO `precios_tipo` (`prctip_codi`, `prctip_nombre`, `prctip_estado`, `prctip_abreviatura`, `prctip_usu_crea`, `prctip_usu_modifica`, `prctip_usu_activa`) VALUES (2,'MINORISTA',1,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `precios_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `presentacion`
--

DROP TABLE IF EXISTS `presentacion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `presentacion` (
  `prs_codi` int(11) NOT NULL AUTO_INCREMENT,
  `prs_nombre` varchar(200) NOT NULL DEFAULT '',
  `prs_estado` int(11) NOT NULL DEFAULT 1,
  `prs_abreviatura` varchar(45) DEFAULT NULL,
  `prs_usu_crea` varchar(45) DEFAULT NULL,
  `prs_usu_modifica` varchar(45) DEFAULT NULL,
  `prs_usu_activa` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`prs_codi`),
  UNIQUE KEY `Index_prs_nombre` (`prs_nombre`),
  KEY `Index_prs_estado` (`prs_estado`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `presentacion`
--

LOCK TABLES `presentacion` WRITE;
/*!40000 ALTER TABLE `presentacion` DISABLE KEYS */;
INSERT INTO `presentacion` (`prs_codi`, `prs_nombre`, `prs_estado`, `prs_abreviatura`, `prs_usu_crea`, `prs_usu_modifica`, `prs_usu_activa`) VALUES (1,'UNIDAD',1,'UNI',NULL,NULL,NULL);
/*!40000 ALTER TABLE `presentacion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `productos`
--

DROP TABLE IF EXISTS `productos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `productos` (
  `prd_codi` int(11) NOT NULL AUTO_INCREMENT,
  `prd_nombre` varchar(200) NOT NULL DEFAULT '',
  `prd_abreviatura` varchar(45) DEFAULT NULL,
  `mar_codi_fk` int(11) NOT NULL DEFAULT 0,
  `prs_codi_fk` int(11) NOT NULL,
  `prdfam_codi_fk` int(11) NOT NULL DEFAULT 0,
  `prd_estado` int(11) NOT NULL DEFAULT 1,
  `prd_codigo` varchar(45) DEFAULT NULL,
  `prd_usu_crea` varchar(45) DEFAULT NULL,
  `prd_usu_modifica` varchar(45) DEFAULT NULL,
  `prd_usu_activa` varchar(45) DEFAULT NULL,
  `prd_preciocosto` float NOT NULL DEFAULT 0,
  `prd_unidad_minima` int(10) unsigned NOT NULL DEFAULT 0,
  `prd_stock_minimo` int(10) unsigned NOT NULL DEFAULT 0,
  `prd_peso` float NOT NULL DEFAULT 0,
  `id_fk` int(10) unsigned DEFAULT NULL,
  `prd_descripcion` text DEFAULT NULL,
  `prd_descuento_limite` float NOT NULL DEFAULT 0,
  `prd_catalogo_defecto` int(10) unsigned NOT NULL DEFAULT 0,
  `prd_id_trans` varchar(45) DEFAULT NULL,
  `mp_codi_fk` int(10) unsigned DEFAULT NULL,
  `prd_afecto_igv` int(11) NOT NULL DEFAULT 0,
  `prd_afecto_isc` int(11) DEFAULT 0,
  `prd_porcentaje_utilidad` int(10) unsigned NOT NULL DEFAULT 0,
  `prd_lote_correlativo` int(10) unsigned NOT NULL DEFAULT 1,
  `prd_margenminimo` float NOT NULL DEFAULT 0,
  PRIMARY KEY (`prd_codi`),
  UNIQUE KEY `Index_prd_nombre` (`prd_nombre`),
  KEY `fk_productos_presentacion_idx` (`prs_codi_fk`),
  KEY `fk_productos_marcas1_idx` (`mar_codi_fk`),
  KEY `fk_productos_productos_familia1_idx` (`prdfam_codi_fk`),
  KEY `Index_prd_abreviatura` (`prd_abreviatura`),
  KEY `Index_prd_estado` (`prd_estado`),
  KEY `Index_prd_codigo` (`prd_codigo`),
  CONSTRAINT `fk_productos_marcas1` FOREIGN KEY (`mar_codi_fk`) REFERENCES `marcas` (`mar_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_productos_presentacion` FOREIGN KEY (`prs_codi_fk`) REFERENCES `presentacion` (`prs_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_productos_productos_familia1` FOREIGN KEY (`prdfam_codi_fk`) REFERENCES `productos_familia` (`prdfam_codi`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `productos`
--

LOCK TABLES `productos` WRITE;
/*!40000 ALTER TABLE `productos` DISABLE KEYS */;
INSERT INTO `productos` (`prd_codi`, `prd_nombre`, `prd_abreviatura`, `mar_codi_fk`, `prs_codi_fk`, `prdfam_codi_fk`, `prd_estado`, `prd_codigo`, `prd_usu_crea`, `prd_usu_modifica`, `prd_usu_activa`, `prd_preciocosto`, `prd_unidad_minima`, `prd_stock_minimo`, `prd_peso`, `id_fk`, `prd_descripcion`, `prd_descuento_limite`, `prd_catalogo_defecto`, `prd_id_trans`, `mp_codi_fk`, `prd_afecto_igv`, `prd_afecto_isc`, `prd_porcentaje_utilidad`, `prd_lote_correlativo`, `prd_margenminimo`) VALUES (1,'EQUIPO DE SOLDAR MMA 130',NULL,1,1,1,1,'00001','','',NULL,200,1,0,0,NULL,NULL,0,0,'17229779488843479912',1,0,0,0,1,60),(2,'EQUIPO DE SOLDAR MMA PRO200',NULL,1,1,1,1,'00002','','',NULL,360,1,1,0,NULL,NULL,0,0,'17229781324533609761',1,0,0,0,1,60),(3,'EQUIPO DE SOLDAR MMA PRO240',NULL,1,1,1,1,'00003','','',NULL,420,1,0,0,NULL,NULL,0,0,'17229781947177820701',1,0,0,0,1,60),(4,'EQUIPO DE SOLDAR MMA PRO280',NULL,1,1,1,1,'00004','','',NULL,480,1,0,0,NULL,NULL,0,0,'17229783591167700550',1,0,0,0,1,60),(5,'EQUIPO DE SOLDAR MMA PRO350 - 3F',NULL,1,1,1,1,'00005','','',NULL,1150,1,0,0,NULL,NULL,0,0,'17229785461125940201',1,0,0,0,1,60),(6,'EQUIPO DE SOLDAR MMA PRO400 - 3F',NULL,1,1,1,1,'00006','','',NULL,1300,1,0,0,NULL,NULL,0,0,'17229786556109191826',1,0,0,0,1,60),(7,'EQUIPO DE SOLDAR MMA PRO500 - 3F',NULL,1,1,1,1,'00007','','',NULL,1650,1,0,0,NULL,NULL,0,0,'17229787311978808775',1,0,0,0,1,60),(8,'SOLDADORA MIG 120M PRO',NULL,1,1,2,1,'00008','','',NULL,400,1,0,0,NULL,NULL,0,0,'17229788818758180987',1,0,0,0,1,65),(9,'SOLDADORA MIG 120M',NULL,1,1,2,1,'00009','','',NULL,360,1,0,0,NULL,NULL,0,0,'17229789746064302619',1,0,0,0,1,50),(10,'SOLDADORA MIG 160',NULL,1,1,2,1,'00010','','',NULL,600,1,0,0,NULL,NULL,0,0,'17229790838656177773',1,0,0,0,1,45),(11,'SOLDADORA MIG 200',NULL,1,1,2,1,'00011','','',NULL,900,1,0,0,NULL,NULL,0,0,'17229791555428101620',1,0,0,0,1,60),(12,'SOLDADORA MIG PRO200P',NULL,1,1,2,1,'00012','','',NULL,950,1,0,0,NULL,NULL,0,0,'17229792655628402579',1,0,0,0,1,60),(13,'SOLDADORA MIG200 SRA (AC/DC)',NULL,1,1,2,1,'00013','','',NULL,1400,1,0,0,NULL,NULL,0,0,'17229793516748109489',1,0,0,0,1,60),(14,'SOLDADORA MIG 250',NULL,1,1,2,1,'00014','','',NULL,1400,1,0,0,NULL,NULL,0,0,'17229794083319174192',1,0,0,0,1,60),(15,'SOLDADORA MIG250 PRO (AC/DC)',NULL,1,1,2,1,'00015','','',NULL,1800,1,0,0,NULL,NULL,0,0,'17229794771499403461',1,0,0,0,1,60),(16,'SOLDADORA MIG 258',NULL,1,1,2,1,'00016','','',NULL,3000,1,0,0,NULL,NULL,0,0,'17229796029733235208',1,0,0,0,1,40),(17,'SOLDADORA MIG 305',NULL,1,1,2,1,'00017','','',NULL,3110,1,0,0,NULL,NULL,0,0,'17229796787077564236',1,0,0,0,1,45),(18,'SOLDADORA MIG 350 - 3F',NULL,1,1,2,1,'00018','','',NULL,3670,1,0,0,NULL,NULL,0,0,'17229797834572316860',1,0,0,0,1,40),(19,'SOLDADORA MIG 350 - MULTIVOLTAJE',NULL,1,1,2,1,'00019','','',NULL,4500,1,0,0,NULL,NULL,0,0,'17229798707885496270',1,0,0,0,1,35),(20,'SOLDADORA MIG 500F',NULL,1,1,2,1,'00020','','',NULL,8000,1,0,0,NULL,NULL,0,0,'17229799401870690',1,0,0,0,1,24),(21,'EQUIPO DE SOLDAR TIG 200P (DC)',NULL,1,1,3,1,'00021','','',NULL,1100,1,0,0,NULL,NULL,0,0,'1722979996441836849',1,0,0,0,1,60),(22,'EQUIPO DE SOLDAR TIG 200 (AC/DC)',NULL,1,1,3,1,'00022','','',NULL,1500,1,0,0,NULL,NULL,0,0,'17229800846171642515',1,0,0,0,1,60),(23,'EQUIPO DE SOLDAR TIG 315 (AC/DC) - 3F',NULL,1,1,3,1,'00023','','',NULL,3110,1,0,0,NULL,NULL,0,0,'17229801611829226060',1,0,0,0,1,60),(24,'PRO MULTIPROCESO MMCT-250 (4 EN 1)',NULL,1,1,4,1,'00024','','',NULL,1250,1,0,0,NULL,NULL,0,0,'1722980309458243788',1,0,0,0,1,60),(25,'CORTE POR PLASMA - CUT 40P',NULL,1,1,4,1,'00025','','',NULL,1100,1,0,0,NULL,NULL,0,0,'17229804095326719217',1,0,0,0,1,65),(26,'CORTE POR PLASMA - CUT 60P',NULL,1,1,4,1,'00026','','',NULL,1600,1,0,0,NULL,NULL,0,0,'17229804652816289823',1,0,0,0,1,55),(27,'CORTE POR PLASMA - CUT 80P (3F)',NULL,1,1,4,1,'00027','','',NULL,1900,1,0,0,NULL,NULL,0,0,'17229805244771335833',1,0,0,0,1,65),(28,'CORTE POR PLASMA  - CUT 100P',NULL,1,1,4,1,'00028','','',NULL,2210,1,0,0,NULL,NULL,0,0,'17229811063068385468',1,0,0,0,1,60),(29,'WG-200 (MOTOSOLDADORA)',NULL,1,1,1,1,'00029','','',NULL,750,1,0,0,NULL,NULL,0,0,'17229815788722131992',1,0,0,0,1,60),(30,'ALAMBRE SOLIDO - ER70S6 - 5KG (0.8MM)',NULL,1,1,7,1,'00030','','',NULL,55,1,0,0,NULL,NULL,0,0,'17230611139954966359',1,0,0,0,1,20),(31,'ALAMBRE SOLIDO - ER70S6 - 5KG (1.0MM)',NULL,1,1,7,1,'00031','',NULL,NULL,55,1,0,0,NULL,NULL,0,0,'17230612839383800254',1,0,0,0,1,20),(32,'ALAMBRE TUBULAR - E71T.GS - 5KG (0.8MM)',NULL,1,1,7,1,'00032','',NULL,NULL,55,1,0,0,NULL,NULL,0,0,'17230617021175787092',1,0,0,0,1,20),(33,'ALAMBRE TUBULAR- E71T-GS - 5KG (1.0MM)',NULL,1,1,7,1,'00033','',NULL,NULL,55,1,0,0,NULL,NULL,0,0,'17230617799245749762',1,0,0,0,1,20),(34,'ELECTRODOS DE TUNGSTENO -EWLA(1/16)',NULL,7,1,7,1,'00034','','',NULL,80,1,0,0,NULL,NULL,0,0,'17230619485804722086',1,0,0,0,1,20),(35,'PUNTA DE CONTACTO MIG 0.8MM',NULL,7,1,7,1,'00035','',NULL,NULL,5,1,0,0,NULL,NULL,0,0,'17230633664340429857',1,0,0,0,1,20),(36,'TOBERA GAS LENS',NULL,7,1,7,1,'00036','',NULL,NULL,9,1,0,0,NULL,NULL,0,0,'17230634492567503491',1,0,0,0,1,20),(37,'COLLETS, SUJETADOR (3/32)',NULL,7,1,7,1,'00037','',NULL,NULL,5,1,0,0,NULL,NULL,0,0,'17230635599173013235',1,0,0,0,1,20),(38,'DISCO DE CORTE - 4\"',NULL,5,1,7,1,'00038','',NULL,NULL,2,1,0,0,NULL,NULL,0,0,'17230636388383626043',1,0,0,0,1,50),(39,'DIFUSOR ESTANDAR',NULL,7,1,7,1,'00039','',NULL,NULL,8,1,0,0,NULL,NULL,0,0,'17230637377789930852',1,0,0,0,1,30),(40,'DISCOS FLAT GRANO#60',NULL,5,1,7,1,'00040','',NULL,NULL,3,1,0,0,NULL,NULL,0,0,'17230638585342693799',1,0,0,0,1,50),(41,'CARETAS FOTOSENSIBLES 2 SENSORES',NULL,1,1,7,1,'00041','',NULL,NULL,45,1,0,0,NULL,NULL,0,0,'1723064038713142398',1,0,0,0,1,100),(42,'DISCO FLAT - GRANO #100',NULL,5,1,7,1,'00042','',NULL,NULL,3,1,0,0,NULL,NULL,0,0,'17230644069166568190',1,0,0,0,1,100),(43,'BORNERAS ESTANDAR- TIPO MACHO',NULL,7,1,7,1,'00043','',NULL,NULL,25,1,0,0,NULL,NULL,0,0,'17230647565180931013',1,0,0,0,1,80),(44,'PINZA MAGNETICA PARA ACERO AL CARBONO',NULL,5,1,7,1,'00044','',NULL,NULL,8,1,0,0,NULL,NULL,0,0,'17230651529630146108',1,0,0,0,1,100),(45,'MAQUINA DE SOLDAR MIG250 (MULTIPROCESO)',NULL,2,1,2,1,'00045','',NULL,NULL,4000,1,0,0,NULL,NULL,0,0,'17231752811920976612',1,0,0,0,1,20),(46,'MAQUINA DE SOLDAR MIG120 (MULTIFUNCION)',NULL,2,1,2,1,'00046','','',NULL,490,1,0,0,NULL,NULL,0,0,'17231754172327984591',1,0,0,0,1,25),(47,'MAQUINA DE SOLDAR XR240 (MMA/TIG LIFT)',NULL,2,1,1,1,'00047','',NULL,NULL,730,1,0,0,NULL,NULL,0,0,'17231755261224098566',1,0,0,0,1,40),(48,'MAQUINA DE SOLDAR XR280 (MMA/TIG LIFT)',NULL,2,1,1,1,'00048','',NULL,NULL,1050,1,0,0,NULL,NULL,0,0,'17231755917922169537',1,0,0,0,1,40),(49,'MAQUINA DE SOLDAR XR320 (MMA/TIG LIFT)',NULL,2,1,1,1,'00049','',NULL,NULL,2500,1,0,0,NULL,NULL,0,0,'17231756549990007648',1,0,0,0,1,20),(50,'MAQUINA DE SOLDAR XT-2O0 (TIG HF/TIG LIFT/PULSADO)',NULL,2,1,3,1,'00050','',NULL,NULL,1300,1,0,0,NULL,NULL,0,0,'17231757368568945819',1,0,0,0,1,25),(51,'MAQUINA DE SOLDAR MIG200 (MULTIFUNCION)',NULL,2,1,2,1,'00051','',NULL,NULL,1400,1,0,0,NULL,NULL,0,0,'17231758645948354850',1,0,0,0,1,25),(52,'EQUIPO TIG 200AMP (AC/DC) - PARA SOLDAR ALUMINIO & ACEROS',NULL,3,1,3,1,'00052','',NULL,NULL,2040,1,0,0,NULL,NULL,0,0,'17279822281638797344',1,0,0,0,1,80);
/*!40000 ALTER TABLE `productos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `productos_codigos_proveedor`
--

DROP TABLE IF EXISTS `productos_codigos_proveedor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `productos_codigos_proveedor` (
  `prdcod_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `prd_codi_fk` int(10) unsigned DEFAULT NULL,
  `prdcod_codigo1` varchar(45) DEFAULT NULL,
  `prdcod_codigo2` varchar(45) DEFAULT NULL,
  `prdcod_codigo3` varchar(45) DEFAULT NULL,
  `prdcod_codigo4` varchar(45) DEFAULT NULL,
  `prdcod_codigo5` varchar(45) DEFAULT NULL,
  `prdcod_codigo6` varchar(45) DEFAULT NULL,
  `prdcod_codigo7` varchar(45) DEFAULT NULL,
  `prdcod_codigo8` varchar(45) DEFAULT NULL,
  `prdcod_codigo9` varchar(45) DEFAULT NULL,
  `prdcod_codigo10` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`prdcod_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `productos_codigos_proveedor`
--

LOCK TABLES `productos_codigos_proveedor` WRITE;
/*!40000 ALTER TABLE `productos_codigos_proveedor` DISABLE KEYS */;
/*!40000 ALTER TABLE `productos_codigos_proveedor` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `productos_familia`
--

DROP TABLE IF EXISTS `productos_familia`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `productos_familia` (
  `prdfam_codi` int(11) NOT NULL AUTO_INCREMENT,
  `prdfam_nombre` varchar(200) NOT NULL DEFAULT '',
  `prdfam_estado` int(11) NOT NULL DEFAULT 1,
  `prdfam_abreviatura` varchar(20) DEFAULT NULL,
  `prdfam_usu_crea` varchar(45) DEFAULT NULL,
  `prdfam_usu_modifica` varchar(45) DEFAULT NULL,
  `prdfam_usu_activa` varchar(45) DEFAULT NULL,
  `prdfam_muestra_detalle` int(11) NOT NULL DEFAULT 0,
  `prdfam_descripcion` text DEFAULT NULL,
  `prdfam_codi_fk_padre` int(10) unsigned NOT NULL DEFAULT 0,
  `prdfam_codigo` char(3) NOT NULL DEFAULT '',
  `prdfam_id_trans` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`prdfam_codi`),
  UNIQUE KEY `Index_prdfam_nombre` (`prdfam_nombre`) USING BTREE,
  KEY `Index_prdfam_estado` (`prdfam_estado`),
  KEY `Index_prdfam_codigo` (`prdfam_codigo`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `productos_familia`
--

LOCK TABLES `productos_familia` WRITE;
/*!40000 ALTER TABLE `productos_familia` DISABLE KEYS */;
INSERT INTO `productos_familia` (`prdfam_codi`, `prdfam_nombre`, `prdfam_estado`, `prdfam_abreviatura`, `prdfam_usu_crea`, `prdfam_usu_modifica`, `prdfam_usu_activa`, `prdfam_muestra_detalle`, `prdfam_descripcion`, `prdfam_codi_fk_padre`, `prdfam_codigo`, `prdfam_id_trans`) VALUES (1,'MMA-ELECTRODO',1,'',NULL,NULL,NULL,0,NULL,0,'001','17224644646340121506'),(2,'MIG-ALAMBRE-SOLIDO',1,'',NULL,NULL,NULL,0,NULL,0,'002','17224644878837685751'),(3,'TIG-TUNGSTENO',1,'',NULL,NULL,NULL,0,NULL,0,'003','17224645225578979734'),(4,'CORTE POR PLASMA',1,'',NULL,NULL,NULL,0,NULL,0,'004','17224645467041186725'),(5,'HERRAMIENTAS',1,'',NULL,NULL,NULL,0,NULL,0,'005','17224645931466448714'),(7,'ACCESORIOS',1,'',NULL,NULL,NULL,0,NULL,0,'007','172297656242807721');
/*!40000 ALTER TABLE `productos_familia` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `respuestas`
--

DROP TABLE IF EXISTS `respuestas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `respuestas` (
  `res_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `res_respuesta` text NOT NULL,
  `res_pregunta1` varchar(245) NOT NULL DEFAULT '',
  `res_pregunta2` varchar(245) NOT NULL DEFAULT '',
  `res_pregunta3` varchar(245) NOT NULL DEFAULT '',
  `res_estado` int(10) unsigned NOT NULL DEFAULT 0,
  `res_fecha` datetime DEFAULT NULL,
  PRIMARY KEY (`res_codi`),
  FULLTEXT KEY `busqueda` (`res_pregunta1`,`res_pregunta2`,`res_pregunta3`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `respuestas`
--

LOCK TABLES `respuestas` WRITE;
/*!40000 ALTER TABLE `respuestas` DISABLE KEYS */;
INSERT INTO `respuestas` (`res_codi`, `res_respuesta`, `res_pregunta1`, `res_pregunta2`, `res_pregunta3`, `res_estado`, `res_fecha`) VALUES (3,'<p>Nos puede llamar al 954618004...</p>','Número de contacto movil','Numero de telefono o celular','A donde lo puedo llamar',1,'2022-09-27 23:23:43'),(4,'Desarrollamos todo tipo de aplicaciones web y app','Que tipo de productos desarrollan?','Que trabajos hacen?','Que sistemas programan?',1,'2022-09-28 00:24:23'),(9,'Desarrollamos algoritmos de clasificación basados en redes neuronales.','python redes neuronales','Inteligencia artificial','minería de datos, big data',1,'2022-09-28 18:14:01'),(12,'Nosotros brindamos desarrollo y capacitación en lo que concierne a programación de software, análisis y desarrollo de sistemas.','NECESITO CAPACITACION, capacitaciones','desarrollo de sistemas','análisis de sistemas',1,'2022-09-28 21:37:19'),(13,'Nosotros brindamos desarrollo y capacitación en programación en Php. Contamos con excelentes profesionales en el rubro. Nos puede contactar al 954618004','Quiero aprender a programar en php','capacitación php','php',1,'2022-09-28 22:02:34'),(14,'Buen día, en que le puedo ayudar?','Buen día','Hola que tal','buenos días, buenas tardes, buenas noches',1,'2022-09-29 12:15:17'),(15,'Es un placer poder ayudarlo. Ya sabe que nos puede llamar al 954618004','Gracias','Thank, ','Muy amable',1,'2022-09-29 12:43:06'),(16,'Mi nombre es ALFA-NET y existo para resolver sus consultas.','Como te llamas?','Cual es tu nombre?','tu nombre',1,'2022-09-29 14:09:21'),(17,'Buen día, en que le puedo ayudar?','ALFA-NET','ALFA NET, ALFANET','alfa net, alfanet',1,'2022-09-29 14:13:54'),(24,'Que tenga un buen día','hasta luego, hasta pronto','chao chau bye','adios',1,'2022-09-29 16:46:00'),(26,'Estamos ubicados en la calle Las hiedras 355, urb. Federico Villarreal, Chiclayo','Cual es su dirección?','Donde puedo encontrarlo?','Su ubicación, su oficina, donde visitarlo, ubicarlo, encontralo, lugar, domicilio',1,'2022-09-30 21:35:57'),(42,'Mi nombre es ALFA-NET y existo para resolver sus consultas.','quien eres?','que eres','un robot',1,'2022-10-31 17:21:56'),(44,'Me complace el poder ayudarle','OK.','Esta bien','me parece perfecto',1,'2022-10-31 18:02:25'),(49,'Me complace el poder ayudarle','ok','OK','Ok',1,'2022-10-31 18:06:11'),(54,'<p>Me complace el poder ayudarle...</p>','correcto','perfecto','excelente',1,'2022-10-31 20:06:00'),(55,'Me complace el poder ayudarle','SI','si','Si',1,'2022-10-31 20:39:40'),(59,'','quisiera visitarlos','','',0,'2022-10-31 20:53:11'),(60,'','sus servicios','','',0,'2023-02-07 00:15:18'),(61,'<p>Puede visitar el siguiente sitio para mas informacion:</p><p><a target=\"_blank\" href=\"http://localhost/quirozmejia_web/nosotros#bot-anclaje\">http://localhost/quirozmejia_web/nosotros#bot-anclaje</a></p>','Mas informacion','quiero saber mas','saber mas',1,'2023-02-21 00:39:55'),(62,'','mas informacion','','',0,'2023-02-21 00:42:27');
/*!40000 ALTER TABLE `respuestas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `temporal_cotizacion_pedido_detalle`
--

DROP TABLE IF EXISTS `temporal_cotizacion_pedido_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `temporal_cotizacion_pedido_detalle` (
  `cotdet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `cotdet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `cotdet_precio` float NOT NULL DEFAULT 0,
  `cotdet_cantidad` float NOT NULL DEFAULT 0,
  `cot_codi_fk` int(11) NOT NULL DEFAULT 0,
  `idtrans` varchar(45) DEFAULT NULL,
  `cotdet_codi_fk` int(10) unsigned DEFAULT NULL,
  `idtrans_temporal` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`cotdet_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=108 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `temporal_cotizacion_pedido_detalle`
--

LOCK TABLES `temporal_cotizacion_pedido_detalle` WRITE;
/*!40000 ALTER TABLE `temporal_cotizacion_pedido_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `temporal_cotizacion_pedido_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `temporal_nota_credito_detalle`
--

DROP TABLE IF EXISTS `temporal_nota_credito_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `temporal_nota_credito_detalle` (
  `notcredet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `notcredet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `notcredet_precio` float NOT NULL DEFAULT 0,
  `notcredet_cantidad` float NOT NULL DEFAULT 0,
  `notcre_codi_fk` int(11) NOT NULL DEFAULT 0,
  `idtrans` varchar(45) DEFAULT NULL,
  `notcredet_codi_fk` int(10) unsigned DEFAULT NULL,
  `idtrans_temporal` varchar(45) DEFAULT NULL,
  `notcredet_observaciones` text DEFAULT NULL,
  `notcredet_usuario` varchar(145) DEFAULT NULL,
  `notcredet_fecha` date DEFAULT NULL,
  `notcredet_igv_afectado` int(10) unsigned DEFAULT NULL,
  `notcredet_precio_descuento` float NOT NULL DEFAULT 0,
  `notcredet_cantidad_devolver` float NOT NULL DEFAULT 0,
  PRIMARY KEY (`notcredet_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=826 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `temporal_nota_credito_detalle`
--

LOCK TABLES `temporal_nota_credito_detalle` WRITE;
/*!40000 ALTER TABLE `temporal_nota_credito_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `temporal_nota_credito_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `temporal_nota_debito_detalle`
--

DROP TABLE IF EXISTS `temporal_nota_debito_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `temporal_nota_debito_detalle` (
  `notdebdet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `notdebdet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `notdebdet_precio` float NOT NULL DEFAULT 0,
  `notdebdet_cantidad` float NOT NULL DEFAULT 0,
  `notdeb_codi_fk` int(11) NOT NULL DEFAULT 0,
  `idtrans` varchar(45) DEFAULT NULL,
  `notdebdet_codi_fk` int(10) unsigned DEFAULT NULL,
  `idtrans_temporal` varchar(45) DEFAULT NULL,
  `notdebdet_observaciones` text DEFAULT NULL,
  `notdebdet_usuario` varchar(145) DEFAULT NULL,
  `notdebdet_fecha` date DEFAULT NULL,
  `notdebdet_igv_afectado` int(10) unsigned DEFAULT NULL,
  `notdebdet_precio_descuento` float NOT NULL DEFAULT 0,
  `notdebdet_cantidad_devolver` float NOT NULL DEFAULT 0,
  PRIMARY KEY (`notdebdet_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=794 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `temporal_nota_debito_detalle`
--

LOCK TABLES `temporal_nota_debito_detalle` WRITE;
/*!40000 ALTER TABLE `temporal_nota_debito_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `temporal_nota_debito_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `temporal_operacion_almacen_detalle`
--

DROP TABLE IF EXISTS `temporal_operacion_almacen_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `temporal_operacion_almacen_detalle` (
  `opealmdet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `opealmdet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `opealmdet_cantidad` float DEFAULT 0,
  `opealm_codi_fk` int(11) DEFAULT NULL,
  `idtrans` varchar(45) DEFAULT NULL,
  `opealmdet_codi_fk` int(10) unsigned DEFAULT NULL,
  `opealmdet_cantidad_disponible` float NOT NULL DEFAULT 0,
  `idtrans_temporal` varchar(45) DEFAULT NULL,
  `mp_codi_fk_alm` int(11) DEFAULT NULL,
  `opealmdet_fecha_expira` date DEFAULT NULL,
  `opealmdet_lote` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`opealmdet_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=423 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `temporal_operacion_almacen_detalle`
--

LOCK TABLES `temporal_operacion_almacen_detalle` WRITE;
/*!40000 ALTER TABLE `temporal_operacion_almacen_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `temporal_operacion_almacen_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `temporal_orden_compra_detalle`
--

DROP TABLE IF EXISTS `temporal_orden_compra_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `temporal_orden_compra_detalle` (
  `ordcomdet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `ordcomdet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `ordcomdet_precio` float NOT NULL DEFAULT 0,
  `ordcomdet_cantidad` float NOT NULL DEFAULT 0,
  `ordcom_codi_fk` int(11) DEFAULT NULL,
  `idtrans` varchar(45) DEFAULT NULL,
  `ordcomdet_codi_fk` int(10) unsigned DEFAULT NULL,
  `idtrans_temporal` varchar(45) DEFAULT NULL,
  `ordcomdet_igv` float NOT NULL DEFAULT 0,
  `ordcomdet_isc` float NOT NULL DEFAULT 0,
  `ordcomdet_percepcion` float NOT NULL DEFAULT 0,
  `ordcomdet_igv_afectado` int(10) unsigned NOT NULL DEFAULT 0,
  `ordcomdet_isc_afectado` int(11) NOT NULL DEFAULT 0,
  `ordcomdet_cantidad_devolver` float NOT NULL DEFAULT 0,
  `ordcomdet_cantidad_devolver_temporal` float NOT NULL DEFAULT 0,
  `ordcomdet_precio_descuento` float NOT NULL DEFAULT 0,
  `ordcomdet_precio_descuento_temporal` float NOT NULL DEFAULT 0,
  `ordcomdet_cantidad_devolver2` float NOT NULL DEFAULT 0,
  `ordcomdet_cantidad_devolver_temporal2` float NOT NULL DEFAULT 0,
  `ordcomdet_precio_descuento2` float NOT NULL DEFAULT 0,
  `ordcomdet_precio_descuento_temporal2` float NOT NULL DEFAULT 0,
  `ordcomdet_cantidad_devolver3` float NOT NULL DEFAULT 0,
  `ordcomdet_cantidad_devolver_temporal3` float NOT NULL DEFAULT 0,
  `ordcomdet_precio_descuento3` float NOT NULL DEFAULT 0,
  `ordcomdet_precio_descuento_temporal3` float NOT NULL DEFAULT 0,
  PRIMARY KEY (`ordcomdet_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=1151 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `temporal_orden_compra_detalle`
--

LOCK TABLES `temporal_orden_compra_detalle` WRITE;
/*!40000 ALTER TABLE `temporal_orden_compra_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `temporal_orden_compra_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `temporal_orden_pedido_detalle`
--

DROP TABLE IF EXISTS `temporal_orden_pedido_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `temporal_orden_pedido_detalle` (
  `ordpeddet_codi` int(11) NOT NULL AUTO_INCREMENT,
  `ordpeddet_fechahora` datetime DEFAULT NULL,
  `prd_codi_fk` int(11) DEFAULT NULL,
  `unimed_codi_fk` int(11) DEFAULT NULL,
  `ordpeddet_precio` float NOT NULL DEFAULT 0,
  `ordpeddet_cantidad` float NOT NULL DEFAULT 0,
  `ordped_codi_fk` int(11) NOT NULL DEFAULT 0,
  `idtrans` varchar(45) DEFAULT NULL,
  `ordpeddet_codi_fk` int(10) unsigned DEFAULT NULL,
  `idtrans_temporal` varchar(45) DEFAULT NULL,
  `ordpeddet_observaciones` text DEFAULT NULL,
  `ordpeddet_usuario` varchar(145) DEFAULT NULL,
  `ordpeddet_fecha` date DEFAULT NULL,
  `ordpeddet_igv_afectado` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`ordpeddet_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=1851 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `temporal_orden_pedido_detalle`
--

LOCK TABLES `temporal_orden_pedido_detalle` WRITE;
/*!40000 ALTER TABLE `temporal_orden_pedido_detalle` DISABLE KEYS */;
INSERT INTO `temporal_orden_pedido_detalle` (`ordpeddet_codi`, `ordpeddet_fechahora`, `prd_codi_fk`, `unimed_codi_fk`, `ordpeddet_precio`, `ordpeddet_cantidad`, `ordped_codi_fk`, `idtrans`, `ordpeddet_codi_fk`, `idtrans_temporal`, `ordpeddet_observaciones`, `ordpeddet_usuario`, `ordpeddet_fecha`, `ordpeddet_igv_afectado`) VALUES (1850,'2024-10-03 14:22:25',52,1,3400,1,0,'17279830198964283217',3,'','',NULL,NULL,0);
/*!40000 ALTER TABLE `temporal_orden_pedido_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transportistas`
--

DROP TABLE IF EXISTS `transportistas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transportistas` (
  `tra_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tra_apellido_nombre` varchar(245) NOT NULL DEFAULT '',
  `tra_ruc_dni` varchar(200) NOT NULL DEFAULT '',
  `tra_direccion` varchar(145) NOT NULL DEFAULT '',
  `tra_telefono` varchar(145) NOT NULL DEFAULT '',
  `tra_licencia_conducir` varchar(145) NOT NULL DEFAULT '',
  `tra_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `tra_usu_crea` varchar(45) NOT NULL DEFAULT '',
  `tra_usu_modifica` varchar(45) NOT NULL DEFAULT '',
  `tra_usu_activa` varchar(45) NOT NULL DEFAULT '',
  `traemp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`tra_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transportistas`
--

LOCK TABLES `transportistas` WRITE;
/*!40000 ALTER TABLE `transportistas` DISABLE KEYS */;
/*!40000 ALTER TABLE `transportistas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transportistas_empresa`
--

DROP TABLE IF EXISTS `transportistas_empresa`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transportistas_empresa` (
  `traemp_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `traemp_nombre` varchar(245) NOT NULL DEFAULT '',
  `traemp_ruc_dni` varchar(20) NOT NULL DEFAULT '',
  `traemp_direccion` varchar(245) NOT NULL DEFAULT '',
  `traemp_telefono` varchar(100) NOT NULL DEFAULT '',
  `traemp_estado` int(10) unsigned NOT NULL DEFAULT 1,
  `traemp_usu_crea` varchar(45) NOT NULL DEFAULT '',
  `traemp_usu_modifica` varchar(45) NOT NULL DEFAULT '',
  `traemp_usu_activa` varchar(45) NOT NULL DEFAULT '',
  PRIMARY KEY (`traemp_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transportistas_empresa`
--

LOCK TABLES `transportistas_empresa` WRITE;
/*!40000 ALTER TABLE `transportistas_empresa` DISABLE KEYS */;
/*!40000 ALTER TABLE `transportistas_empresa` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ubdepartamento`
--

DROP TABLE IF EXISTS `ubdepartamento`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ubdepartamento` (
  `idDepa` int(5) NOT NULL DEFAULT 0,
  `departamento` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`idDepa`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ubdepartamento`
--

LOCK TABLES `ubdepartamento` WRITE;
/*!40000 ALTER TABLE `ubdepartamento` DISABLE KEYS */;
INSERT INTO `ubdepartamento` (`idDepa`, `departamento`) VALUES (1,'AMAZONAS'),(2,'ANCASH'),(3,'APURIMAC'),(4,'AREQUIPA'),(5,'AYACUCHO'),(6,'CAJAMARCA'),(7,'CALLAO'),(8,'CUSCO'),(9,'HUANCAVELICA'),(10,'HUANUCO'),(11,'ICA'),(12,'JUNIN'),(13,'LA LIBERTAD'),(14,'LAMBAYEQUE'),(15,'LIMA'),(16,'LORETO'),(17,'MADRE DE DIOS'),(18,'MOQUEGUA'),(19,'PASCO'),(20,'PIURA'),(21,'PUNO'),(22,'SAN MARTIN'),(23,'TACNA'),(24,'TUMBES'),(25,'UCAYALI');
/*!40000 ALTER TABLE `ubdepartamento` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ubdistrito`
--

DROP TABLE IF EXISTS `ubdistrito`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ubdistrito` (
  `idDist` int(5) NOT NULL DEFAULT 0,
  `distrito` varchar(50) DEFAULT NULL,
  `idProv` int(5) DEFAULT NULL,
  `latitud` float DEFAULT NULL,
  `longitud` float DEFAULT NULL,
  PRIMARY KEY (`idDist`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ubdistrito`
--

LOCK TABLES `ubdistrito` WRITE;
/*!40000 ALTER TABLE `ubdistrito` DISABLE KEYS */;
INSERT INTO `ubdistrito` (`idDist`, `distrito`, `idProv`, `latitud`, `longitud`) VALUES (1,'CHACHAPOYAS',1,-6.2294,-77.8728),(2,'ASUNCION',1,-6.0325,-77.7108),(3,'BALSAS',1,-6.8358,-78.0197),(4,'CHETO',1,-6.2556,-77.7008),(5,'CHILIQUIN',1,-6.0783,-77.7375),(6,'CHUQUIBAMBA',1,-6.935,-77.8542),(7,'GRANADA',1,-6.1064,-77.6286),(8,'HUANCAS',1,-6.1736,-77.8644),(9,'LA JALCA',1,-6.4847,-77.815),(10,'LEIMEBAMBA',1,-6.7075,-77.8039),(11,'LEVANTO',1,-6.3078,-77.8992),(12,'MAGDALENA',1,-6.3731,-77.9017),(13,'MARISCAL CASTILLA',1,-6.5944,-77.8086),(14,'MOLINOPAMPA',1,-6.2092,-77.6692),(15,'MONTEVIDEO',1,-6.6181,-77.8022),(16,'OLLEROS',1,-6.0239,-77.6764),(17,'QUINJALCA',1,-6.0914,-77.6786),(18,'SAN FRANCISCO DE DAGUAS',1,-6.2292,-77.74),(19,'SAN ISIDRO DE MAINO',1,-6.3372,-77.8806),(20,'SOLOCO',1,-6.2606,-77.7442),(21,'SONCHE',1,-5.6389,-78.5311),(22,'LA PECA',2,-5.6119,-78.4369),(23,'ARAMANGO',2,-5.4164,-78.4378),(24,'COPALLIN',2,-5.675,-78.4231),(25,'EL PARCO',2,-5.625,-78.4753),(26,'IMAZA',2,-5.1636,-78.2889),(27,'JUMBILLA',3,-5.9044,-77.7978),(28,'CHISQUILLA',3,-5.8975,-77.7861),(29,'CHURUJA',3,-6.0194,-77.9519),(30,'COROSHA',3,-5.8433,-77.8225),(31,'CUISPES',3,-5.9283,-77.9461),(32,'FLORIDA',3,-5.8261,-77.9694),(33,'JAZAN',3,-5.9414,-77.9772),(34,'RECTA',3,-5.9178,-77.7889),(35,'SAN CARLOS',3,-5.9661,-77.9453),(36,'SHIPASBAMBA',3,-5.9106,-77.9806),(37,'VALERA',3,-6.0428,-77.9192),(38,'YAMBRASBAMBA',3,-5.7353,-77.925),(39,'NIEVA',4,-4.5922,-77.8644),(40,'EL CENEPA',4,-4.4556,-78.1589),(41,'RIO SANTIAGO',4,-4.0158,-77.7608),(42,'LAMUD',5,-6.1392,-77.9522),(43,'CAMPORREDONDO',5,-6.2133,-78.32),(44,'COCABAMBA',5,-6.6142,-78.005),(45,'COLCAMAR',5,-6.2994,-77.9731),(46,'CONILA',5,-6.1592,-78.1419),(47,'INGUILPATA',5,-6.2394,-77.9539),(48,'LONGUITA',5,-6.4136,-77.9683),(49,'LONYA CHICO',5,-6.2297,-77.955),(50,'LUYA',5,-6.1642,-77.9442),(51,'LUYA VIEJO',5,-6.1275,-78.085),(52,'MARIA',5,-6.4289,-77.9608),(53,'OCALLI',5,-6.2353,-78.2664),(54,'OCUMAL',5,-6.2825,-78.2108),(55,'PISUQUIA',5,-6.4533,-78.0919),(56,'PROVIDENCIA',5,-6.2972,-78.2408),(57,'SAN CRISTOBAL',5,-6.1017,-77.9597),(58,'SAN FRANCISCO DEL YESO',5,-6.6469,-77.8117),(59,'SAN JERONIMO',5,-6.0597,-77.9744),(60,'SAN JUAN DE LOPECANCHA',5,-6.4964,-77.8619),(61,'SANTA CATALINA',5,-6.1136,-78.0608),(62,'SANTO TOMAS',5,-6.5725,-77.8658),(63,'TINGO',5,-6.3797,-77.9058),(64,'TRITA',5,-6.1519,-77.9808),(65,'SAN NICOLAS',6,-6.3953,-77.4822),(66,'CHIRIMOTO',6,-6.5231,-77.4425),(67,'COCHAMAL',6,-6.4075,-77.5853),(68,'HUAMBO',6,-6.4311,-77.5367),(69,'LIMABAMBA',6,-6.4981,-77.4989),(70,'LONGAR',6,-6.3858,-77.5467),(71,'MARISCAL BENAVIDES',6,-6.3861,-77.5044),(72,'MILPUC',6,-6.5,-77.4364),(73,'OMIA',6,-6.4678,-77.3956),(74,'SANTA ROSA',6,-6.4536,-77.4553),(75,'TOTORA',6,-6.4931,-77.4717),(76,'VISTA ALEGRE',6,-6.1508,-77.3039),(77,'BAGUA GRANDE',7,-5.7547,-78.4428),(78,'CAJARURO',7,-5.7364,-78.4267),(79,'CUMBA',7,-5.9356,-78.6636),(80,'EL MILAGRO',7,-5.6378,-78.5583),(81,'JAMALCA',7,-5.8942,-78.2378),(82,'LONYA GRANDE',7,-6.0964,-78.4225),(83,'YAMON',7,-6.0508,-78.5289),(84,'HUARAZ',8,-9.5297,-77.5292),(85,'COCHABAMBA',8,-9.495,-77.8594),(86,'COLCABAMBA',8,-9.5947,-77.8086),(87,'HUANCHAY',8,-9.7236,-77.8186),(88,'INDEPENDENCIA',8,-9.5144,-77.5325),(89,'JANGAS',8,-9.4006,-77.5775),(90,'LA LIBERTAD',8,-9.6331,-77.7414),(91,'OLLEROS',8,-9.6667,-77.4656),(92,'PAMPAS',8,-9.6553,-77.8261),(93,'PARIACOTO',8,-9.5594,-77.8906),(94,'PIRA',8,-9.5811,-77.7072),(95,'TARICA',8,-9.3936,-77.575),(96,'AIJA',9,-9.7803,-77.6106),(97,'CORIS',9,-9.8206,-77.7194),(98,'HUACLLAN',9,-9.7981,-77.6753),(99,'LA MERCED',9,-9.7356,-77.6161),(100,'SUCCHA',9,-9.8231,-77.6497),(101,'LLAMELLIN',10,-9.1008,-77.0169),(102,'ACZO',10,-9.1519,-76.9889),(103,'CHACCHO',10,-9.0597,-77.0583),(104,'CHINGAS',10,-9.1186,-76.9919),(105,'MIRGAS',10,-9.0786,-77.0925),(106,'SAN JUAN DE RONTOY',10,-9.1753,-77.0028),(107,'CHACAS',11,-9.1622,-77.3658),(108,'ACOCHACA',11,-9.1147,-77.3683),(109,'CHIQUIAN',12,-10.1519,-77.1564),(110,'ABELARDO PARDO LEZAMETA',12,-10.2992,-77.1464),(111,'ANTONIO RAYMONDI',12,-10.1572,-77.4706),(112,'AQUIA',12,-10.0744,-77.145),(113,'CAJACAY',12,-10.1553,-77.4397),(114,'CANIS',12,-10.3389,-77.1689),(115,'COLQUIOC',12,-10.3122,-77.6153),(116,'HUALLANCA',12,-9.8994,-76.9417),(117,'HUASTA',12,-10.1233,-77.1467),(118,'HUAYLLACAYAN',12,-10.245,-77.4347),(119,'LA PRIMAVERA',12,-10.3356,-77.1253),(120,'MANGAS',12,-10.3694,-77.1033),(121,'PACLLON',12,-10.2344,-77.0717),(122,'SAN MIGUEL DE CORPANQUI',12,-10.285,-77.1989),(123,'TICLLOS',12,-10.2531,-77.1908),(124,'CARHUAZ',13,-9.2814,-77.6467),(125,'ACOPAMPA',13,-9.2947,-77.6253),(126,'AMASHCA',13,-9.2392,-77.6467),(127,'ANTA',13,-9.3578,-77.5989),(128,'ATAQUERO',13,-9.2622,-77.6917),(129,'MARCARA',13,-9.3228,-77.6036),(130,'PARIAHUANCA',13,-9.3653,-77.5808),(131,'SAN MIGUEL DE ACO',13,-9.3683,-77.5644),(132,'SHILLA',13,-9.2317,-77.625),(133,'TINCO',13,-9.2708,-77.6775),(134,'YUNGAR',13,-9.3775,-77.5922),(135,'SAN LUIS',14,-9.0942,-77.3289),(136,'SAN NICOLAS',14,-8.9758,-77.1892),(137,'YAUYA',14,-8.9911,-77.2914),(138,'CASMA',15,-9.4758,-78.3064),(139,'BUENA VISTA ALTA',15,-9.4325,-78.2069),(140,'COMANDANTE NOEL',15,-9.4625,-78.3847),(141,'YAUTAN',15,-9.5114,-77.9964),(142,'CORONGO',16,-8.5708,-77.8989),(143,'ACO',16,-8.5231,-77.8778),(144,'BAMBAS',16,-8.6025,-77.9969),(145,'CUSCA',16,-8.5133,-77.8647),(146,'LA PAMPA',16,-8.6611,-77.9008),(147,'YANAC',16,-8.6186,-77.8647),(148,'YUPAN',16,-8.6144,-77.9686),(149,'HUARI',17,-9.3472,-77.1708),(150,'ANRA',17,-9.2347,-76.9264),(151,'CAJAY',17,-9.3258,-77.1575),(152,'CHAVIN DE HUANTAR',17,-9.5886,-77.1783),(153,'HUACACHI',17,-9.3156,-76.9386),(154,'HUACCHIS',17,-9.2006,-76.7869),(155,'HUACHIS',17,-9.41,-77.1),(156,'HUANTAR',17,-9.4519,-77.1767),(157,'MASIN',17,-9.3658,-77.0964),(158,'PAUCAS',17,-9.1525,-76.8994),(159,'PONTO',17,-9.3261,-77.0044),(160,'RAHUAPAMPA',17,-9.3592,-77.0786),(161,'RAPAYAN',17,-9.2025,-76.7594),(162,'SAN MARCOS',17,-9.5242,-77.1569),(163,'SAN PEDRO DE CHANA',17,-9.4031,-77.0111),(164,'UCO',17,-9.1883,-76.9283),(165,'HUARMEY',18,-10.0689,-78.1517),(166,'COCHAPETI',18,-9.9872,-77.6461),(167,'CULEBRAS',18,-9.9503,-78.2222),(168,'HUAYAN',18,-9.8753,-77.7083),(169,'MALVAS',18,-9.9297,-77.6578),(170,'CARAZ',26,-9.0486,-77.8047),(171,'HUALLANCA',26,-8.8189,-77.8631),(172,'HUATA',26,-9.0164,-77.8614),(173,'HUAYLAS',26,-8.8725,-77.8928),(174,'MATO',26,-8.9614,-77.8425),(175,'PAMPAROMAS',26,-9.0733,-77.9817),(176,'PUEBLO LIBRE',26,-9.11,-77.8019),(177,'SANTA CRUZ',26,-8.9519,-77.815),(178,'SANTO TORIBIO',26,-8.8644,-77.9147),(179,'YURACMARCA',26,-8.7375,-77.9039),(180,'PISCOBAMBA',27,-8.865,-77.3578),(181,'CASCA',27,-8.8556,-77.3986),(182,'ELEAZAR GUZMAN BARRON',27,-8.9022,-77.2439),(183,'FIDEL OLIVAS ESCUDERO',27,-8.8061,-77.2797),(184,'LLAMA',27,-8.915,-77.3014),(185,'LLUMPA',27,-8.9608,-77.3675),(186,'LUCMA',27,-8.9194,-77.4108),(187,'MUSGA',27,-8.9061,-77.3392),(188,'OCROS',21,-10.4033,-77.3967),(189,'ACAS',21,-10.4575,-77.3278),(190,'CAJAMARQUILLA',21,-10.3542,-77.1992),(191,'CARHUAPAMPA',21,-10.4975,-77.2428),(192,'COCHAS',21,-10.5367,-77.4228),(193,'CONGAS',21,-10.3375,-77.4428),(194,'LLIPA',21,-10.3925,-77.1908),(195,'SAN CRISTOBAL DE RAJAN',21,-10.3869,-77.2194),(196,'SAN PEDRO',21,-10.3719,-77.4872),(197,'SANTIAGO DE CHILCAS',21,-10.4386,-77.3658),(198,'CABANA',22,-8.3931,-78.0089),(199,'BOLOGNESI',22,-8.3506,-78.0506),(200,'CONCHUCOS',22,-8.2686,-77.8528),(201,'HUACASCHUQUE',22,-8.3064,-78.0047),(202,'HUANDOVAL',22,-8.3311,-77.9753),(203,'LACABAMBA',22,-8.2603,-77.8983),(204,'LLAPO',22,-8.5144,-78.0422),(205,'PALLASCA',22,-8.2531,-77.9994),(206,'PAMPAS',22,-8.1953,-77.8958),(207,'SANTA ROSA',22,-8.5278,-78.0675),(208,'TAUCA',22,-8.4703,-78.0378),(209,'POMABAMBA',23,-8.8211,-77.4603),(210,'HUAYLLAN',23,-8.8581,-77.4356),(211,'PAROBAMBA',23,-8.6958,-77.4297),(212,'QUINUABAMBA',23,-8.6972,-77.3983),(213,'RECUAY',24,-9.7217,-77.4564),(214,'CATAC',24,-9.8017,-77.4306),(215,'COTAPARACO',24,-9.9933,-77.5881),(216,'HUAYLLAPAMPA',24,-10.0556,-77.5367),(217,'LLACLLIN',24,-10.0692,-77.6217),(218,'MARCA',24,-10.0892,-77.4744),(219,'PAMPAS CHICO',24,-10.1147,-77.3981),(220,'PARARIN',24,-10.05,-77.6544),(221,'TAPACOCHA',24,-10.0103,-77.5692),(222,'TICAPAMPA',24,-9.7606,-77.4428),(223,'CHIMBOTE',25,-9.0417,-78.6078),(224,'CACERES DEL PERU',25,-9.0131,-78.1381),(225,'COISHCO',25,-9.0231,-78.6161),(226,'MACATE',25,-8.7603,-78.0614),(227,'MORO',25,-9.1389,-78.1833),(228,'NEPEÑA',25,-9.1728,-78.3608),(229,'SAMANCO',25,-9.2622,-78.4958),(230,'SANTA',25,-8.9878,-78.6131),(231,'NUEVO CHIMBOTE',25,-9.1286,-78.5308),(232,'SIHUAS',26,-8.5544,-77.6308),(233,'ACOBAMBA',26,-8.3261,-77.5819),(234,'ALFONSO UGARTE',26,-8.4561,-77.4267),(235,'CASHAPAMPA',26,-8.5611,-77.6531),(236,'CHINGALPO',26,-8.3386,-77.5975),(237,'HUAYLLABAMBA',26,-8.5347,-77.5669),(238,'QUICHES',26,-8.395,-77.4911),(239,'RAGASH',26,-8.5317,-77.6658),(240,'SAN JUAN',26,-8.6464,-77.5819),(241,'SICSIBAMBA',26,-8.6233,-77.5356),(242,'YUNGAY',27,-9.14,-77.7447),(243,'CASCAPARA',27,-9.2264,-77.7172),(244,'MANCOS',27,-9.19,-77.7122),(245,'MATACOTO',27,-9.1769,-77.7472),(246,'QUILLO',27,-9.3286,-78.0417),(247,'RANRAHIRCA',27,-9.1731,-77.7225),(248,'SHUPLUY',27,-9.2169,-77.6939),(249,'YANAMA',27,-9.0206,-77.4708),(250,'ABANCAY',28,-13.6289,-72.8861),(251,'CHACOCHE',28,-13.9411,-72.9911),(252,'CIRCA',28,-13.8783,-72.8758),(253,'CURAHUASI',28,-13.5414,-72.6961),(254,'HUANIPACA',28,-13.4922,-72.9333),(255,'LAMBRAMA',28,-13.8708,-72.7697),(256,'PICHIRHUA',28,-13.8608,-73.0733),(257,'SAN PEDRO DE CACHORA',28,-13.5142,-72.8142),(258,'TAMBURCO',28,-13.6222,-72.8733),(259,'ANDAHUAYLAS',29,-13.6561,-73.3897),(260,'ANDARAPA',29,-13.5281,-73.3658),(261,'CHIARA',29,-13.8672,-73.6689),(262,'HUANCARAMA',29,-13.6447,-73.0856),(263,'HUANCARAY',29,-13.7572,-73.5275),(264,'HUAYANA',29,-14.0508,-73.6094),(265,'KISHUARA',29,-13.6911,-73.1186),(266,'PACOBAMBA',29,-13.6153,-73.0839),(267,'PACUCHA',29,-13.6094,-73.3442),(268,'PAMPACHIRI',29,-14.1869,-73.5447),(269,'POMACOCHA',29,-14.0839,-73.5908),(270,'SAN ANTONIO DE CACHI',29,-13.7731,-73.6033),(271,'SAN JERONIMO',29,-13.6517,-73.3658),(272,'SAN MIGUEL DE CHACCRAMPA',29,-13.9611,-73.6078),(273,'SANTA MARIA DE CHICMO',29,-13.6575,-73.4939),(274,'TALAVERA',29,-13.6542,-73.4289),(275,'TUMAY HUARACA',29,-14.0528,-73.5658),(276,'TURPO',29,-13.7856,-73.4742),(277,'KAQUIABAMBA',29,-13.7342,-73.3506),(278,'ANTABAMBA',30,-14.3653,-72.8772),(279,'EL ORO',30,-14.2089,-73.0583),(280,'HUAQUIRCA',30,-14.3394,-72.895),(281,'JUAN ESPINOZA MEDRANO',30,-14.4283,-72.915),(282,'OROPESA',30,-14.2606,-72.5636),(283,'PACHACONAS',30,-14.2233,-73.0164),(284,'SABAINO',30,-14.3133,-72.9453),(285,'CHALHUANCA',31,-14.2944,-73.2447),(286,'CAPAYA',31,-14.1178,-73.3211),(287,'CARAYBAMBA',31,-14.3781,-73.1608),(288,'CHAPIMARCA',31,-13.975,-73.065),(289,'COLCABAMBA',31,-14.0064,-73.2542),(290,'COTARUSE',31,-14.4158,-73.205),(291,'HUAYLLO',31,-14.1331,-73.2678),(292,'JUSTO APU SAHUARAURA',31,-14.1481,-73.1739),(293,'LUCRE',31,-13.9497,-73.2261),(294,'POCOHUANCA',31,-14.2183,-73.0869),(295,'SAN JUAN DE CHACÑA',31,-13.9242,-73.1822),(296,'SAÑAYCA',31,-14.2044,-73.3469),(297,'SORAYA',31,-14.1647,-73.315),(298,'TAPAIRIHUA',31,-14.1414,-73.1403),(299,'TINTAY',31,-13.9594,-73.1853),(300,'TORAYA',31,-14.0531,-73.2939),(301,'YANACA',31,-14.2253,-73.16),(302,'TAMBOBAMBA',32,-13.9461,-72.1747),(303,'COTABAMBAS',32,-13.7456,-72.355),(304,'COYLLURQUI',32,-13.8369,-72.4322),(305,'HAQUIRA',32,-14.2142,-72.1889),(306,'MARA',32,-14.0867,-72.1019),(307,'CHALLHUAHUACHO',32,-14.1186,-72.2467),(308,'CHINCHEROS',33,-13.5183,-73.7228),(309,'ANCO_HUALLO',33,-13.5297,-73.6742),(310,'COCHARCAS',33,-13.6106,-73.7414),(311,'HUACCANA',33,-13.3881,-73.6892),(312,'OCOBAMBA',33,-13.4825,-73.5603),(313,'ONGOY',33,-13.4028,-73.6683),(314,'URANMARCA',33,-13.6722,-73.6694),(315,'RANRACANCHA',33,-13.435,-73.8219),(316,'CHUQUIBAMBILLA',34,-14.105,-72.7078),(317,'CURPAHUASI',34,-14.0633,-72.6708),(318,'GAMARRA',34,-13.8717,-72.5083),(319,'HUAYLLATI',34,-13.9281,-72.4844),(320,'MAMARA',34,-14.2286,-72.5908),(321,'MICAELA BASTIDAS',34,-14.1153,-72.6142),(322,'PATAYPAMPA',34,-14.1775,-72.6725),(323,'PROGRESO',34,-14.0722,-72.4767),(324,'SAN ANTONIO',34,-14.1694,-72.6233),(325,'SANTA ROSA',34,-14.1397,-72.6567),(326,'TURPAY',34,-14.2278,-72.6225),(327,'VILCABAMBA',34,-14.0778,-72.6247),(328,'VIRUNDO',34,-14.2503,-72.6811),(329,'CURASCO',34,-14.0619,-72.5678),(330,'AREQUIPA',35,-16.3933,-71.5289),(331,'ALTO SELVA ALEGRE',35,-16.38,-71.5211),(332,'CAYMA',35,-16.3625,-71.5442),(333,'CERRO COLORADO',35,-16.3764,-71.5608),(334,'CHARACATO',35,-16.4686,-71.4844),(335,'CHIGUATA',35,-16.4036,-71.3917),(336,'JACOBO HUNTER',35,-16.4414,-71.5586),(337,'LA JOYA',35,-16.4231,-71.8183),(338,'MARIANO MELGAR',35,-16.4072,-71.5056),(339,'MIRAFLORES',35,-16.3947,-71.5225),(340,'MOLLEBAYA',35,-16.4872,-71.4669),(341,'PAUCARPATA',35,-16.4328,-71.5047),(342,'POCSI',35,-16.5178,-71.3897),(343,'POLOBAYA',35,-16.5658,-71.3683),(344,'QUEQUEÑA',35,-16.5572,-71.4514),(345,'SABANDIA',35,-16.4569,-71.4947),(346,'SACHACA',35,-16.4244,-71.5664),(347,'SAN JUAN DE SIGUAS',35,-16.3461,-72.1283),(348,'SAN JUAN DE TARUCANI',35,-16.1836,-71.0619),(349,'SANTA ISABEL DE SIGUAS',35,-16.3208,-72.0989),(350,'SANTA RITA DE SIGUAS',35,-16.4936,-72.0947),(351,'SOCABAYA',35,-16.4675,-71.5286),(352,'TIABAYA',35,-16.4494,-71.5917),(353,'UCHUMAYO',35,-16.4253,-71.6725),(354,'VITOR',35,-16.4658,-71.9358),(355,'YANAHUARA',35,-16.3819,-71.5364),(356,'YARABAMBA',35,-16.5467,-71.4756),(357,'YURA',35,-16.2469,-71.7064),(358,'JOSE LUIS BUSTAMANTE Y RIVERO',35,-16.4267,-71.5239),(359,'CAMANA',36,-16.6247,-72.7114),(360,'JOSE MARIA QUIMPER',36,-16.6019,-72.7272),(361,'MARIANO NICOLAS VALCARCEL',36,-16.0314,-73.1744),(362,'MARISCAL CACERES',36,-16.6197,-72.7361),(363,'NICOLAS DE PIEROLA',36,-16.5731,-72.7158),(364,'OCOÑA',36,-16.4317,-73.105),(365,'QUILCA',36,-16.7169,-72.4256),(366,'SAMUEL PASTOR',36,-16.6136,-72.6992),(367,'CARAVELI',37,-15.7725,-73.3658),(368,'ACARI',37,-15.4356,-74.6164),(369,'ATICO',37,-16.2083,-73.6236),(370,'ATIQUIPA',37,-15.7961,-74.3636),(371,'BELLA UNION',37,-15.4506,-74.6583),(372,'CAHUACHO',37,-15.5028,-73.4797),(373,'CHALA',37,-15.8656,-74.2475),(374,'CHAPARRA',37,-15.8053,-73.9669),(375,'HUANUHUANU',37,-15.6589,-74.0914),(376,'JAQUI',37,-15.4792,-74.4436),(377,'LOMAS',37,-15.5697,-74.8514),(378,'QUICACHA',37,-15.625,-73.7983),(379,'YAUCA',37,-15.6619,-74.5272),(380,'APLAO',38,-16.0761,-72.4922),(381,'ANDAGUA',38,-15.4989,-72.3561),(382,'AYO',38,-15.6828,-72.2719),(383,'CHACHAS',38,-15.5014,-72.2706),(384,'CHILCAYMARCA',38,-15.2861,-72.3767),(385,'CHOCO',38,-15.5767,-72.1289),(386,'HUANCARQUI',38,-16.0961,-72.4722),(387,'MACHAGUAY',38,-15.6503,-72.5061),(388,'ORCOPAMPA',38,-15.2625,-72.3419),(389,'PAMPACOLCA',38,-15.7133,-72.5739),(390,'TIPAN',38,-15.7231,-72.5019),(391,'UÑON',38,-15.7286,-72.4322),(392,'URACA',38,-16.2239,-72.4697),(393,'VIRACO',38,-15.6583,-72.525),(394,'CHIVAY',39,-15.6403,-71.6036),(395,'ACHOMA',39,-15.66,-71.7036),(396,'CABANACONDE',39,-15.62,-71.9819),(397,'CALLALLI',39,-15.5064,-71.4447),(398,'CAYLLOMA',39,-15.1889,-71.7733),(399,'COPORAQUE',39,-15.6272,-71.6461),(400,'HUAMBO',39,-15.7294,-72.1097),(401,'HUANCA',39,-16.0336,-71.8781),(402,'ICHUPAMPA',39,-15.65,-71.6867),(403,'LARI',39,-15.6183,-71.7725),(404,'LLUTA',39,-16.0156,-72.0139),(405,'MACA',39,-15.6414,-71.7683),(406,'MADRIGAL',39,-15.6083,-71.8075),(407,'SAN ANTONIO DE CHUCA',39,-15.8389,-71.0906),(408,'SIBAYO',39,-15.4861,-71.4569),(409,'TAPAY',39,-15.5775,-71.9397),(410,'TISCO',39,-15.3469,-71.4464),(411,'TUTI',39,-15.5331,-71.5531),(412,'YANQUE',39,-15.6483,-71.6608),(413,'MAJES',39,-16.3533,-72.2472),(414,'CHUQUIBAMBA',40,-15.8394,-72.6517),(415,'ANDARAY',40,-15.7972,-72.8608),(416,'CAYARANI',40,-14.6719,-72.0219),(417,'CHICHAS',40,-15.5478,-72.9186),(418,'IRAY',40,-15.8536,-72.63),(419,'RIO GRANDE',40,-15.94,-73.1311),(420,'SALAMANCA',40,-15.5044,-72.8344),(421,'YANAQUIHUA',40,-15.7756,-72.8764),(422,'MOLLENDO',41,-17.0292,-72.0164),(423,'COCACHACRA',41,-17.0911,-71.7739),(424,'DEAN VALDIVIA',41,-17.145,-71.8267),(425,'ISLAY',41,-17.0008,-72.0975),(426,'MEJIA',41,-17.1011,-71.9075),(427,'PUNTA DE BOMBON',41,-17.1561,-71.7847),(428,'COTAHUASI',42,-15.2128,-72.8894),(429,'ALCA',42,-15.1342,-72.765),(430,'CHARCANA',42,-15.2406,-73.0706),(431,'HUAYNACOTAS',42,-15.1747,-72.8497),(432,'PAMPAMARCA',42,-15.1825,-72.9053),(433,'PUYCA',42,-15.0592,-72.6917),(434,'QUECHUALLA',42,-15.2739,-73.0222),(435,'SAYLA',42,-15.32,-73.2219),(436,'TAURIA',42,-15.3542,-73.2325),(437,'TOMEPAMPA',42,-15.1731,-72.8303),(438,'TORO',42,-15.2644,-72.9283),(439,'AYACUCHO',43,-13.1603,-74.2253),(440,'ACOCRO',43,-13.2186,-74.0419),(441,'ACOS VINCHOS',43,-13.1131,-74.1),(442,'CARMEN ALTO',43,-13.1794,-74.2206),(443,'CHIARA',43,-13.2728,-74.2058),(444,'OCROS',43,-13.3906,-73.9156),(445,'PACAYCASA',43,-13.0575,-74.2158),(446,'QUINUA',43,-13.0492,-74.1392),(447,'SAN JOSE DE TICLLAS',43,-13.1322,-74.3331),(448,'SAN JUAN BAUTISTA',43,-13.1667,-74.2236),(449,'SANTIAGO DE PISCHA',43,-13.0856,-74.3933),(450,'SOCOS',43,-13.215,-74.2894),(451,'TAMBILLO',43,-13.1947,-74.1106),(452,'VINCHOS',43,-13.2417,-74.3542),(453,'JESUS NAZARENO',43,-13.1628,-74.2139),(454,'CANGALLO',44,-13.6292,-74.1439),(455,'CHUSCHI',44,-13.585,-74.3517),(456,'LOS MOROCHUCOS',44,-13.5575,-74.195),(457,'MARIA PARADO DE BELLIDO',44,-13.6047,-74.2364),(458,'PARAS',44,-13.5525,-74.6278),(459,'TOTOS',44,-13.5675,-74.5228),(460,'SANCOS',45,-13.9197,-74.3342),(461,'CARAPO',45,-13.8375,-74.3156),(462,'SACSAMARCA',45,-13.9428,-74.3128),(463,'SANTIAGO DE LUCANAMARCA',45,-13.8439,-74.3722),(464,'HUANTA',46,-12.9394,-74.2481),(465,'AYAHUANCO',46,-12.5939,-74.3308),(466,'HUAMANGUILLA',46,-13.0111,-74.1731),(467,'IGUAIN',46,-12.9925,-74.2089),(468,'LURICOCHA',46,-12.8997,-74.2736),(469,'SANTILLANA',46,-12.7664,-74.2531),(470,'SIVIA',46,-12.5119,-73.8589),(471,'LLOCHEGUA',46,-12.7842,-74.2058),(472,'SAN MIGUEL',47,-13.0128,-73.9811),(473,'ANCO',47,-13.0603,-73.7069),(474,'AYNA',47,-12.6242,-73.7894),(475,'CHILCAS',47,-13.1711,-73.9064),(476,'CHUNGUI',47,-13.2222,-73.6217),(477,'LUIS CARRANZA',47,-13.2289,-73.8944),(478,'SANTA ROSA',47,-12.6878,-73.7358),(479,'TAMBO',47,-13.3808,-73.4361),(480,'PUQUIO',48,-14.6942,-74.1244),(481,'AUCARA',48,-14.2811,-73.9753),(482,'CABANA',48,-14.2883,-73.9672),(483,'CARMEN SALCEDO',48,-14.3878,-73.9619),(484,'CHAVIÑA',48,-14.9794,-73.8375),(485,'CHIPAO',48,-14.3658,-73.8761),(486,'HUAC-HUAS',48,-14.1317,-74.9422),(487,'LARAMATE',48,-14.2861,-74.8425),(488,'LEONCIO PRADO',48,-14.7289,-74.6703),(489,'LLAUTA',48,-14.2436,-74.9203),(490,'LUCANAS',48,-14.6225,-74.2331),(491,'OCAÑA',48,-14.3989,-74.8228),(492,'OTOCA',48,-14.49,-74.6867),(493,'SAISA',48,-14.9403,-74.4172),(494,'SAN CRISTOBAL',48,-14.7431,-74.2222),(495,'SAN JUAN',48,-14.6517,-74.1992),(496,'SAN PEDRO',48,-14.7669,-74.0978),(497,'SAN PEDRO DE PALCO',48,-14.4119,-74.6514),(498,'SANCOS',48,-15.0628,-73.9522),(499,'SANTA ANA DE HUAYCAHUACHO',48,-14.2264,-73.9567),(500,'SANTA LUCIA',48,-14.9783,-74.5239),(501,'CORACORA',49,-15.0169,-73.7814),(502,'CHUMPI',49,-15.0944,-73.7481),(503,'CORONEL CASTAÑEDA',49,-14.8072,-73.2822),(504,'PACAPAUSA',49,-14.9503,-73.3678),(505,'PULLO',49,-15.21,-73.8267),(506,'PUYUSCA',49,-15.2469,-73.5694),(507,'SAN FRANCISCO DE RAVACAYCO',49,-14.9969,-73.3511),(508,'UPAHUACHO',49,-14.9072,-73.3975),(509,'PAUSA',50,-15.2786,-73.3442),(510,'COLTA',50,-15.1628,-73.2939),(511,'CORCULLA',50,-15.2628,-73.2003),(512,'LAMPA',50,-15.185,-73.3492),(513,'MARCABAMBA',50,-15.1497,-73.3417),(514,'OYOLO',50,-15.18,-73.1853),(515,'PARARCA',50,-15.2175,-73.4647),(516,'SAN JAVIER DE ALPABAMBA',50,-15.0567,-73.3222),(517,'SAN JOSE DE USHUA',50,-15.225,-73.2267),(518,'SARA SARA',50,-15.2453,-73.4531),(519,'QUEROBAMBA',51,-14.0117,-73.8386),(520,'BELEN',51,-13.8089,-73.7575),(521,'CHALCOS',51,-13.8481,-73.7542),(522,'CHILCAYOC',51,-13.8831,-73.7272),(523,'HUACAÑA',51,-14.1722,-73.8864),(524,'MORCOLLA',51,-14.1086,-73.8719),(525,'PAICO',51,-14.0383,-73.6422),(526,'SAN PEDRO DE LARCAY',51,-14.1686,-73.5728),(527,'SAN SALVADOR DE QUIJE',51,-13.9683,-73.7347),(528,'SANTIAGO DE PAUCARAY',51,-14.0444,-73.6375),(529,'SORAS',51,-14.1144,-73.6044),(530,'HUANCAPI',52,-13.7522,-74.0667),(531,'ALCAMENCA',52,-13.6572,-74.1472),(532,'APONGO',52,-14.0133,-73.9322),(533,'ASQUIPATA',52,-14.0547,-73.9094),(534,'CANARIA',52,-13.9231,-73.9047),(535,'CAYARA',52,-13.7953,-73.9886),(536,'COLCA',52,-13.7125,-74.0339),(537,'HUAMANQUIQUIA',52,-13.7292,-74.2722),(538,'HUANCARAYLLA',52,-13.7189,-74.1025),(539,'HUAYA',52,-13.85,-73.9508),(540,'SARHUA',52,-13.6728,-74.3203),(541,'VILCANCHOS',52,-13.6114,-74.5325),(542,'VILCAS HUAMAN',53,-13.6525,-73.9539),(543,'ACCOMARCA',53,-13.8006,-73.9042),(544,'CARHUANCA',53,-13.7425,-73.7872),(545,'CONCEPCION',53,-13.5325,-73.8753),(546,'HUAMBALPA',53,-13.7503,-73.9317),(547,'INDEPENDENCIA',53,-13.8528,-73.8772),(548,'SAURAMA',53,-13.6956,-73.7594),(549,'VISCHONGO',53,-13.5892,-73.9953),(550,'CAJAMARCA',54,-7.1547,-78.5108),(551,'CAJAMARCA',54,-7.1547,-78.5108),(552,'ASUNCION',54,-7.3247,-78.5186),(553,'CHETILLA',54,-7.1469,-78.6733),(554,'COSPAN',54,-7.4272,-78.5422),(555,'ENCAÑADA',54,-7.0869,-78.3444),(556,'JESUS',54,-7.2486,-78.3792),(557,'LLACANORA',54,-7.1936,-78.4267),(558,'LOS BAÑOS DEL INCA',54,-7.1636,-78.4644),(559,'MAGDALENA',54,-7.2508,-78.6597),(560,'MATARA',54,-7.2547,-78.2597),(561,'NAMORA',54,-7.2028,-78.3247),(562,'SAN JUAN',54,-7.2917,-78.4975),(563,'CAJABAMBA',55,-7.6231,-78.0461),(564,'CACHACHI',55,-7.4489,-78.2689),(565,'CONDEBAMBA',55,-7.5736,-78.0697),(566,'SITACOCHA',55,-7.5194,-77.9694),(567,'CELENDIN',56,-6.8669,-78.1431),(568,'CHUMUCH',56,-6.6028,-78.2003),(569,'CORTEGANA',56,-6.5131,-78.3289),(570,'HUASMIN',56,-6.8375,-78.2447),(571,'JORGE CHAVEZ',56,-6.9411,-78.0917),(572,'JOSE GALVEZ',56,-6.9256,-78.1328),(573,'MIGUEL IGLESIAS',56,-6.6503,-78.2325),(574,'OXAMARCA',56,-7.0422,-78.0683),(575,'SOROCHUCO',56,-6.9119,-78.2553),(576,'SUCRE',56,-6.9428,-78.1353),(577,'UTCO',56,-6.8964,-78.0633),(578,'LA LIBERTAD DE PALLAN',56,-6.7239,-78.2825),(579,'CHOTA',57,-6.5597,-78.6469),(580,'ANGUIA',57,-6.3419,-78.6053),(581,'CHADIN',57,-6.4714,-78.4194),(582,'CHIGUIRIP',57,-6.4283,-78.7214),(583,'CHIMBAN',57,-6.2517,-78.4789),(584,'CHOROPAMPA',57,-6.3711,-78.4119),(585,'COCHABAMBA',57,-6.4739,-78.8858),(586,'CONCHAN',57,-6.4447,-78.6558),(587,'HUAMBOS',57,-6.4528,-78.9611),(588,'LAJAS',57,-6.5606,-78.7347),(589,'LLAMA',57,-6.5144,-79.1203),(590,'MIRACOSTA',57,-6.4044,-79.2836),(591,'PACCHA',57,-6.4975,-78.4236),(592,'PION',57,-6.1778,-78.4825),(593,'QUEROCOTO',57,-6.3597,-79.0344),(594,'SAN JUAN DE LICUPIS',57,-6.4242,-79.2422),(595,'TACABAMBA',57,-6.3928,-78.6114),(596,'TOCMOCHE',57,-6.4128,-79.3608),(597,'CHALAMARCA',57,-6.5031,-78.4797),(598,'CONTUMAZA',58,-7.3667,-78.8053),(599,'CHILETE',58,-7.2214,-78.8397),(600,'CUPISNIQUE',58,-7.3489,-79.0297),(601,'GUZMANGO',58,-7.3839,-78.8961),(602,'SAN BENITO',58,-7.3444,-78.8367),(603,'SANTA CRUZ DE TOLED',58,-7.3444,-78.8367),(604,'TANTARICA',58,-7.3006,-78.9331),(605,'YONAN',58,-7.2531,-79.1311),(606,'CUTERVO',59,-6.3772,-78.8181),(607,'CALLAYUC',59,-6.1811,-78.9106),(608,'CHOROS',59,-5.9,-78.6939),(609,'CUJILLO',59,-6.1069,-78.5739),(610,'LA RAMADA',59,-6.2533,-78.5756),(611,'PIMPINGOS',59,-6.0619,-78.7586),(612,'QUEROCOTILLO',59,-6.2736,-79.0378),(613,'SAN ANDRES DE CUTERVO',59,-6.2389,-78.7128),(614,'SAN JUAN DE CUTERVO',59,-6.1631,-78.5981),(615,'SAN LUIS DE LUCMA',59,-6.2939,-78.6036),(616,'SANTA CRUZ',59,-6.6772,-78.8186),(617,'SANTO DOMINGO DE LA CAPILLA',59,-6.2447,-78.8553),(618,'SANTO TOMAS',59,-6.1514,-78.6819),(619,'SOCOTA',59,-6.3153,-78.6994),(620,'TORIBIO CASANOVA',59,-6.0042,-78.6983),(621,'BAMBAMARCA',60,-6.6797,-78.5189),(622,'CHUGUR',60,-6.6708,-78.7383),(623,'HUALGAYOC',60,-6.7647,-78.6081),(624,'JAEN',61,-5.7089,-78.8092),(625,'BELLAVISTA',61,-5.6678,-78.6772),(626,'CHONTALI',61,-5.6461,-79.0883),(627,'COLASAY',61,-5.9786,-79.0686),(628,'HUABAL',61,-5.6125,-78.8997),(629,'LAS PIRIAS',61,-5.6272,-78.8528),(630,'POMAHUACA',61,-5.9314,-79.2294),(631,'PUCARA',61,-6.0414,-79.1283),(632,'SALLIQUE',61,-5.6581,-79.3153),(633,'SAN FELIPE',61,-5.7703,-79.3139),(634,'SAN JOSE DEL ALTO',61,-5.465,-79.0178),(635,'SANTA ROSA',61,-5.4342,-78.5667),(636,'SAN IGNACIO',62,-5.1461,-79.0047),(637,'CHIRINOS',62,-5.3058,-78.8983),(638,'HUARANGO',62,-5.2722,-78.7758),(639,'LA COIPA',62,-5.3928,-78.9064),(640,'NAMBALLE',62,-5.0042,-79.0872),(641,'SAN JOSE DE LOURDES',62,-5.1031,-78.9142),(642,'TABACONAS',62,-5.3161,-79.2833),(643,'PEDRO GALVEZ',63,-7.3358,-78.17),(644,'CHANCAY',63,-7.3881,-78.1233),(645,'EDUARDO VILLANUEVA',63,-7.4644,-78.13),(646,'GREGORIO PITA',63,-7.2736,-78.16),(647,'ICHOCAN',63,-7.3689,-78.1297),(648,'JOSE MANUEL QUIROZ',63,-7.3494,-78.0478),(649,'JOSE SABOGAL',63,-7.2511,-78.0367),(650,'SAN MIGUEL',64,-7,-78.85),(651,'SAN MIGUEL',64,-7,-78.85),(652,'BOLIVAR',64,-6.9769,-79.1781),(653,'CALQUIS',64,-6.9803,-78.85),(654,'CATILLUC',64,-6.8017,-78.7792),(655,'EL PRADO',64,-7.0336,-79.0108),(656,'LA FLORIDA',64,-6.8686,-79.1258),(657,'LLAPA',64,-6.9808,-78.8075),(658,'NANCHOC',64,-6.9594,-79.2425),(659,'NIEPOS',64,-6.9267,-79.13),(660,'SAN GREGORIO',64,-7.0569,-79.0953),(661,'SAN SILVESTRE DE COCHAN',64,-6.9775,-78.7739),(662,'TONGOD',64,-6.7575,-78.825),(663,'UNION AGUA BLANCA',64,-7.0467,-79.0606),(664,'SAN PABLO',65,-7.1186,-78.8233),(665,'SAN BERNARDINO',65,-7.1681,-78.8292),(666,'SAN LUIS',65,-7.1569,-78.8681),(667,'TUMBADEN',65,-7.0253,-78.7397),(668,'SANTA CRUZ',65,-6.6258,-78.9442),(669,'ANDABAMBA',65,-6.6628,-78.8169),(670,'CATACHE',65,-6.6736,-79.0328),(671,'CHANCAYBAÑOS',65,-6.5761,-78.8675),(672,'LA ESPERANZA',65,-6.5925,-78.8958),(673,'NINABAMBA',65,-6.6497,-78.7875),(674,'PULAN',65,-6.7389,-78.9203),(675,'SAUCEPAMPA',65,-6.6914,-78.9161),(676,'SEXI',65,-6.5642,-79.0514),(677,'UTICYACU',65,-6.6067,-78.7939),(678,'YAUYUCAN',65,-6.6772,-78.8186),(679,'CALLAO',66,-12.0631,-77.1469),(680,'BELLAVISTA',66,-12.0625,-77.1292),(681,'CARMEN DE LA LEGUA REYNOSO',66,-12.0394,-77.0903),(682,'LA PERLA',66,-12.0658,-77.1081),(683,'LA PUNTA',66,-12.0728,-77.1633),(684,'VENTANILLA',66,-11.855,-77.125),(685,'CUSCO',67,-13.5192,-71.9767),(686,'CCORCA',67,-13.5847,-72.0592),(687,'POROY',67,-13.4944,-72.0447),(688,'SAN JERONIMO',67,-13.5444,-71.8836),(689,'SAN SEBASTIAN',67,-13.5303,-71.9369),(690,'SANTIAGO',67,-13.5258,-71.9831),(691,'SAYLLA',67,-13.57,-71.8278),(692,'WANCHAQ',67,-13.5214,-71.9667),(693,'ACOMAYO',68,-13.9194,-71.6836),(694,'ACOPIA',68,-14.0575,-71.4933),(695,'ACOS',68,-13.9511,-71.7381),(696,'MOSOC LLACTA',68,-14.1203,-71.4731),(697,'POMACANCHI',68,-14.0336,-71.5742),(698,'RONDOCAN',68,-13.7794,-71.7819),(699,'SANGARARA',68,-13.9472,-71.6033),(700,'ANTA',69,-13.4578,-72.1475),(701,'ANCAHUASI',69,-13.4572,-72.3008),(702,'CACHIMAYO',69,-13.4778,-72.0689),(703,'CHINCHAYPUJIO',69,-13.6297,-72.2331),(704,'HUAROCONDO',69,-13.4158,-72.2075),(705,'LIMATAMBO',69,-13.4797,-72.4428),(706,'MOLLEPATA',69,-13.5092,-72.5278),(707,'PUCYURA',69,-13.4789,-72.1111),(708,'ZURITE',69,-13.4558,-72.2558),(709,'CALCA',70,-13.3211,-71.9556),(710,'COYA',70,-13.3864,-71.8983),(711,'LAMAY',70,-13.3644,-71.9208),(712,'LARES',70,-13.1042,-72.0447),(713,'PISAC',70,-13.4206,-71.8506),(714,'SAN SALVADOR',70,-13.4919,-71.7786),(715,'TARAY',70,-13.4278,-71.8669),(716,'YANATILE',70,-12.6817,-72.2772),(717,'YANAOCA',71,-14.2167,-71.4322),(718,'CHECCA',71,-14.4733,-71.3947),(719,'KUNTURKANKI',71,-14.5347,-71.3069),(720,'LANGUI',71,-14.4322,-71.2728),(721,'LAYO',71,-14.4942,-71.1556),(722,'PAMPAMARCA',71,-14.1475,-71.4603),(723,'QUEHUE',71,-14.3803,-71.4556),(724,'TUPAC AMARU',71,-14.1639,-71.4761),(725,'SICUANI',72,-14.2381,-71.2308),(726,'CHECACUPE',72,-14.0253,-71.4539),(727,'COMBAPATA',72,-14.1019,-71.43),(728,'MARANGANI',72,-14.3567,-71.1686),(729,'PITUMARCA',72,-13.9803,-71.4175),(730,'SAN PABLO',72,-14.2022,-71.315),(731,'SAN PEDRO',72,-14.1861,-71.3431),(732,'TINTA',72,-14.1453,-71.4072),(733,'SANTO TOMAS',73,-14.4533,-72.0822),(734,'CAPACMARCA',73,-14.0072,-72.0025),(735,'CHAMACA',73,-14.3025,-71.8522),(736,'COLQUEMARCA',73,-14.2853,-72.04),(737,'LIVITACA',73,-14.3128,-71.6897),(738,'LLUSCO',73,-14.3375,-72.1136),(739,'QUIÑOTA',73,-14.3111,-72.1386),(740,'VELILLE',73,-14.5086,-71.8811),(741,'ESPINAR',74,-14.7931,-71.4133),(742,'CONDOROMA',74,-15.3006,-71.1383),(743,'COPORAQUE',74,-14.8003,-71.5317),(744,'OCORURO',74,-15.0519,-71.1292),(745,'PALLPATA',74,-14.8903,-71.21),(746,'PICHIGUA',74,-14.6781,-71.4064),(747,'SUYCKUTAMBO',74,-15.0086,-71.6433),(748,'ALTO PICHIGUA',74,-14.7769,-71.2508),(749,'SANTA ANA',75,-12.8628,-72.6933),(750,'ECHARATE',75,-12.7681,-72.5761),(751,'HUAYOPATA',75,-13.0047,-72.5544),(752,'MARANURA',75,-12.9628,-72.6647),(753,'OCOBAMBA',75,-12.8717,-72.4472),(754,'QUELLOUNO',75,-12.62,-73.7892),(755,'KIMBIRI',75,0,0),(756,'SANTA TERESA',75,-13.1306,-72.5939),(757,'VILCABAMBA',75,-13.0631,-72.9344),(758,'PICHARI',75,-11.7203,-72.9464),(759,'PARURO',76,-13.7617,-71.8478),(760,'ACCHA',76,-13.9711,-71.8314),(761,'CCAPI',76,-13.8531,-72.0825),(762,'COLCHA',76,-13.8519,-71.8033),(763,'HUANOQUITE',76,-13.6819,-72.0181),(764,'OMACHA',76,-14.0694,-71.7381),(765,'PACCARITAMBO',76,-13.7564,-71.9567),(766,'PILLPINTO',76,-13.9536,-71.7606),(767,'YAURISQUE',76,-13.6653,-71.9206),(768,'PAUCARTAMBO',77,-13.3178,-71.5967),(769,'CAICAY',77,-13.5972,-71.6967),(770,'CHALLABAMBA',77,-13.215,-71.6486),(771,'COLQUEPATA',77,-13.3603,-71.6736),(772,'HUANCARANI',77,-13.5033,-71.6544),(773,'KOSÑIPATA',77,-12.9094,-71.4033),(774,'URCOS',78,-13.6878,-71.6253),(775,'ANDAHUAYLILLAS',78,-13.6733,-71.6778),(776,'CAMANTI',78,-13.2314,-70.7544),(777,'CCARHUAYO',78,-13.5953,-71.3997),(778,'CCATCA',78,-13.6053,-71.5636),(779,'CUSIPATA',78,-13.9069,-71.5025),(780,'HUARO',78,-13.6903,-71.6403),(781,'LUCRE',78,-13.6339,-71.7367),(782,'MARCAPATA',78,-13.5917,-70.975),(783,'OCONGATE',78,-13.6267,-71.3883),(784,'OROPESA',78,-13.5944,-71.7631),(785,'QUIQUIJANA',78,-13.8225,-71.5425),(786,'URUBAMBA',79,-13.3056,-72.1161),(787,'CHINCHERO',79,-13.3919,-72.0489),(788,'HUAYLLABAMBA',79,-13.3381,-72.065),(789,'MACHUPICCHU',79,-13.1542,-72.5256),(790,'MARAS',79,-13.3325,-72.1564),(791,'OLLANTAYTAMBO',79,-13.2589,-72.2633),(792,'YUCAY',79,-13.3217,-72.0839),(793,'HUANCAVELICA',80,-12.7869,-74.9714),(794,'ACOBAMBILLA',80,-12.6644,-75.3242),(795,'ACORIA',80,-12.6425,-74.8617),(796,'CONAYCA',80,-12.52,-75.0067),(797,'CUENCA',80,-12.4331,-75.0389),(798,'HUACHOCOLPA',80,-13.0319,-74.9469),(799,'HUAYLLAHUARA',80,-12.4092,-75.1783),(800,'IZCUCHACA',80,-12.5,-74.9978),(801,'LARIA',80,-12.5611,-75.0369),(802,'MANTA',80,-12.6206,-75.2111),(803,'MARISCAL CACERES',80,-12.5344,-74.9325),(804,'MOYA',80,-12.4233,-75.1539),(805,'NUEVO OCCORO',80,-12.595,-75.0197),(806,'PALCA',80,-12.6569,-74.9803),(807,'PILCHACA',80,-12.4014,-75.0839),(808,'VILCA',80,-12.4772,-75.1833),(809,'YAULI',80,-12.7692,-74.8508),(810,'ASCENSION',80,-12.7853,-74.9769),(811,'HUANDO',80,-12.5642,-74.9478),(812,'ACOBAMBA',81,-12.8431,-74.5692),(813,'ANDABAMBA',81,-12.6936,-74.6233),(814,'ANTA',81,-12.8122,-74.6383),(815,'CAJA',81,-12.9172,-74.4658),(816,'MARCAS',81,-12.8903,-74.3981),(817,'PAUCARA',81,-12.7297,-74.6664),(818,'POMACOCHA',81,-12.8739,-74.5317),(819,'ROSARIO',81,-12.7208,-74.5825),(820,'LIRCAY',82,-12.9828,-74.7183),(821,'ANCHONGA',82,-12.9131,-74.6914),(822,'CALLANMARCA',82,-12.8667,-74.6233),(823,'CCOCHACCASA',82,-12.9253,-74.7703),(824,'CHINCHO',82,-12.9728,-74.3672),(825,'CONGALLA',82,-12.9558,-74.4922),(826,'HUANCA-HUANCA',82,-12.9186,-74.61),(827,'HUAYLLAY GRANDE',82,-12.9428,-74.7017),(828,'JULCAMARCA',82,-13.0147,-74.4444),(829,'SAN ANTONIO DE ANTAPARCO',82,-13.0761,-74.4117),(830,'SANTO TOMAS DE PATA',82,-13.1131,-74.4189),(831,'SECCLLA',82,-13.0511,-74.4836),(832,'CASTROVIRREYNA',83,-13.2833,-75.3183),(833,'ARMA',83,-13.1264,-75.5419),(834,'AURAHUA',83,-13.0347,-75.5703),(835,'CAPILLAS',83,-13.2931,-75.5425),(836,'CHUPAMARCA',83,-13.0372,-75.6083),(837,'COCAS',83,-13.2758,-75.3728),(838,'HUACHOS',83,-13.2197,-75.5339),(839,'HUAMATAMBO',83,-13.0944,-75.6772),(840,'MOLLEPAMPA',83,-13.3114,-75.41),(841,'SAN JUAN',83,-13.2039,-75.6344),(842,'SANTA ANA',83,-13.0719,-75.1403),(843,'TANTARA',83,-13.0742,-75.6447),(844,'TICRAPO',83,-13.3825,-75.4325),(845,'CHURCAMPA',84,-12.7392,-74.3872),(846,'ANCO',84,-12.6825,-74.5872),(847,'CHINCHIHUASI',84,-12.5169,-74.5458),(848,'EL CARMEN',84,-12.7269,-74.4808),(849,'LA MERCED',84,-12.7881,-74.3586),(850,'LOCROJA',84,-12.7403,-74.4419),(851,'PAUCARBAMBA',84,-12.5539,-74.5319),(852,'SAN MIGUEL DE MAYOCC',84,-12.8058,-74.39),(853,'SAN PEDRO DE CORIS',84,-12.5781,-74.4117),(854,'PACHAMARCA',84,-12.5733,-74.6583),(855,'HUAYTARA',85,-13.6047,-75.3531),(856,'AYAVI',85,-13.7031,-75.3511),(857,'CORDOVA',85,-14.0408,-75.185),(858,'HUAYACUNDO ARMA',85,-13.5342,-75.3144),(859,'LARAMARCA',85,-13.9486,-75.0356),(860,'OCOYO',85,-14.0081,-75.0225),(861,'PILPICHACA',85,-13.3303,-74.9772),(862,'QUERCO',85,-13.9794,-74.9769),(863,'QUITO-ARMA',85,-13.5286,-75.3275),(864,'SAN ANTONIO DE CUSICANCHA',85,-13.5025,-75.2933),(865,'SAN FRANCISCO DE SANGAYAICO',85,-13.7953,-75.2492),(866,'SAN ISIDRO',85,-13.9564,-75.2381),(867,'SANTIAGO DE CHOCORVOS',85,-13.8253,-75.2575),(868,'SANTIAGO DE QUIRAHUARA',85,-14.0561,-74.9764),(869,'SANTO DOMINGO DE CAPILLAS',85,-13.7372,-75.2436),(870,'TAMBO',85,-13.6894,-75.275),(871,'PAMPAS',86,-12.3992,-74.8683),(872,'ACOSTAMBO',86,-12.3656,-75.055),(873,'ACRAQUIA',86,-12.4064,-74.9011),(874,'AHUAYCHA',86,-12.4078,-74.8911),(875,'COLCABAMBA',86,-12.4092,-74.6794),(876,'DANIEL HERNANDEZ',86,-12.3894,-74.8592),(877,'HUACHOCOLPA',86,-12.0483,-74.5947),(878,'HUARIBAMBA',86,-12.2797,-74.9383),(879,'ÑAHUIMPUQUIO',86,-12.3292,-75.0694),(880,'PAZOS',86,-12.2594,-75.0706),(881,'QUISHUAR',86,-12.2436,-74.7772),(882,'SALCABAMBA',86,-12.2017,-74.7806),(883,'SALCAHUASI',86,-12.1042,-74.7517),(884,'SAN MARCOS DE ROCCHAC',86,-12.0939,-74.8639),(885,'SURCUBAMBA',86,-12.1164,-74.6306),(886,'TINTAY PUNCU',86,-12.3142,-74.89),(887,'HUANUCO',87,-9.93,-76.2397),(888,'AMARILIS',87,-9.94,-76.2406),(889,'CHINCHAO',87,-9.8017,-76.0708),(890,'CHURUBAMBA',87,-9.8261,-76.1339),(891,'MARGOS',87,-10.0053,-76.5233),(892,'QUISQUI',87,-9.9047,-76.3925),(893,'SAN FRANCISCO DE CAYRAN',87,-9.9808,-76.2842),(894,'SAN PEDRO DE CHAULAN',87,-10.0564,-76.4856),(895,'SANTA MARIA DEL VALLE',87,-9.8625,-76.17),(896,'YARUMAYO',87,-10.0044,-76.4686),(897,'PILLCO MARCA',87,-9.7864,-75.9994),(898,'AMBO',88,-10.1292,-76.2044),(899,'CAYNA',88,-10.2725,-76.3883),(900,'COLPAS',88,-10.2683,-76.4153),(901,'CONCHAMARCA',88,-10.0358,-76.2169),(902,'HUACAR',88,-10.1594,-76.2367),(903,'SAN FRANCISCO',88,-10.3428,-76.2919),(904,'SAN RAFAEL',88,-10.3378,-76.1822),(905,'TOMAYQUICHUA',88,-10.0775,-76.2125),(906,'LA UNION',89,-9.8378,-76.8036),(907,'CHUQUIS',89,-9.6764,-76.7053),(908,'MARIAS',89,-9.6075,-76.7067),(909,'PACHAS',89,-9.7067,-76.7711),(910,'QUIVILLA',89,-9.6,-76.7258),(911,'RIPAN',89,-9.8286,-76.8031),(912,'SHUNQUI',89,-9.7311,-76.7833),(913,'SILLAPATA',89,-9.7572,-76.7747),(914,'YANAS',89,-9.7144,-76.7503),(915,'HUACAYBAMBA',90,-9.0381,-76.9525),(916,'CANCHABAMBA',90,-8.8847,-77.1231),(917,'COCHABAMBA',90,-9.0953,-76.8364),(918,'PINRA',90,-8.9247,-77.015),(919,'LLATA',91,-9.5497,-76.8186),(920,'ARANCAY',91,-9.1714,-76.7514),(921,'CHAVIN DE PARIARCA',91,-9.4231,-76.7714),(922,'JACAS GRANDE',91,-9.54,-76.7367),(923,'JIRCAN',91,-9.2469,-76.7192),(924,'MIRAFLORES',91,-9.4939,-76.8186),(925,'MONZON',91,-9.28,-76.3967),(926,'PUNCHAO',91,-9.4622,-76.8197),(927,'PUÑOS',91,-9.5006,-76.8839),(928,'SINGA',91,-9.3886,-76.8125),(929,'TANTAMAYO',91,-9.3925,-76.72),(930,'RUPA-RUPA',92,-9.1878,-75.9547),(931,'DANIEL ALOMIA ROBLES',92,0,0),(932,'HERMILIO VALDIZAN',92,-9.2056,-75.8358),(933,'JOSE CRESPO Y CASTILLO',92,-8.9322,-76.1161),(934,'LUYANDO',92,-9.2481,-75.9942),(935,'MARIANO DAMASO BERAUN',92,-9.0236,-76.0667),(936,'HUACRACHUCO',93,-8.6047,-77.1492),(937,'CHOLON',93,-8.6558,-76.8753),(938,'SAN BUENAVENTURA',93,-8.6528,-76.3147),(939,'PANAO',94,-9.8975,-75.9942),(940,'CHAGLLA',94,-9.8447,-75.9028),(941,'MOLINO',94,-9.9108,-76.0167),(942,'UMARI',94,-9.8642,-76.0444),(943,'PUERTO INCA',95,-9.3789,-74.9658),(944,'CODO DEL POZUZO',95,-9.67,-75.4625),(945,'HONORIA',95,-8.7694,-74.7092),(946,'TOURNAVISTA',95,-8.9344,-74.7014),(947,'YUYAPICHIS',95,-9.6283,-74.9747),(948,'JESUS',96,-10.0783,-76.6314),(949,'BAÑOS',96,-10.0764,-76.7356),(950,'JIVIA',96,-10.0233,-76.6803),(951,'QUEROPALCA',96,-10.1814,-76.8031),(952,'RONDOS',96,-9.9844,-76.6883),(953,'SAN FRANCISCO DE ASIS',96,-9.9764,-76.6769),(954,'SAN MIGUEL DE CAURI',96,-10.1425,-76.6256),(955,'CHAVINILLO',97,-9.8589,-76.6089),(956,'CAHUAC',97,-9.8528,-76.6306),(957,'CHACABAMBA',97,-9.9003,-76.6111),(958,'APARICIO POMARES',97,-9.7478,-76.6481),(959,'JACAS CHICO',97,-9.8864,-76.5031),(960,'OBAS',97,-9.7953,-76.6658),(961,'PAMPAMARCA',97,-9.7053,-76.7025),(962,'CHORAS',97,-9.9103,-76.6058),(963,'ICA',98,-14.0636,-75.7292),(964,'LA TINGUIÑA',98,-14.0333,-75.7106),(965,'LOS AQUIJES',98,-14.0964,-75.6906),(966,'OCUCAJE',98,-14.3467,-75.6722),(967,'PACHACUTEC',98,-14.1519,-75.6919),(968,'PARCONA',98,-14.0539,-75.6856),(969,'PUEBLO NUEVO',98,-14.1272,-75.7058),(970,'SALAS',98,-13.9858,-75.7722),(971,'SAN JOSE DE LOS MOLINOS',98,-13.9331,-75.6708),(972,'SAN JUAN BAUTISTA',98,-14.0114,-75.7353),(973,'SANTIAGO',98,-14.1858,-75.7144),(974,'SUBTANJALLA',98,-14.0186,-75.7581),(975,'TATE',98,-14.1558,-75.7081),(976,'YAUCA DEL ROSARIO',98,-14.0989,-75.4769),(977,'CHINCHA ALTA',99,-13.4183,-76.1325),(978,'ALTO LARAN',99,-13.4425,-76.0833),(979,'CHAVIN',99,-13.0764,-75.9131),(980,'CHINCHA BAJA',99,-13.4594,-76.1656),(981,'EL CARMEN',99,-13.4994,-76.0578),(982,'GROCIO PRADO',99,-13.3981,-76.1561),(983,'PUEBLO NUEVO',99,-13.4042,-76.1275),(984,'SAN JUAN DE YANAC',99,-13.2111,-75.7872),(985,'SAN PEDRO DE HUACARPANA',99,-13.0492,-75.6478),(986,'SUNAMPE',99,-13.4275,-76.1636),(987,'TAMBO DE MORA',99,-13.4606,-76.1767),(988,'NAZCA',100,-14.8269,-74.9372),(989,'CHANGUILLO',100,-14.6647,-75.2225),(990,'EL INGENIO',100,-14.6453,-75.0583),(991,'MARCONA',100,-15.3619,-75.1658),(992,'VISTA ALEGRE',100,-14.8458,-74.9439),(993,'PALPA',101,-14.5339,-75.185),(994,'LLIPATA',101,-14.5633,-75.2075),(995,'RIO GRANDE',101,-14.52,-75.2011),(996,'SANTA CRUZ',101,-14.4833,-75.2456),(997,'TIBILLO',101,-14.0939,-75.1717),(998,'PISCO',102,-13.71,-76.2017),(999,'HUANCANO',102,-13.6008,-75.6186),(1000,'HUMAY',102,-13.7228,-75.8867),(1001,'INDEPENDENCIA',102,-13.6939,-76.0247),(1002,'PARACAS',102,-13.8389,-76.2519),(1003,'SAN ANDRES',102,-13.7314,-76.2233),(1004,'SAN CLEMENTE',102,-13.6803,-76.1569),(1005,'TUPAC AMARU INCA',102,-13.7133,-76.1483),(1006,'HUANCAYO',103,-12.0708,-75.2089),(1007,'CARHUACALLANGA',103,-12.355,-75.2006),(1008,'CHACAPAMPA',103,-12.345,-75.2475),(1009,'CHICCHE',103,-12.2961,-75.2986),(1010,'CHILCA',103,-12.0867,-75.2083),(1011,'CHONGOS ALTO',103,-12.3117,-75.2892),(1012,'CHUPURO',103,-12.1556,-75.2456),(1013,'COLCA',103,-12.3175,-75.2222),(1014,'CULLHUAS',103,-12.2206,-75.1669),(1015,'EL TAMBO',103,-12.0503,-75.2214),(1016,'HUACRAPUQUIO',103,-12.1711,-75.2208),(1017,'HUALHUAS',103,-11.9714,-75.2508),(1018,'HUANCAN',103,-12.1067,-75.2167),(1019,'HUASICANCHA',103,-12.3322,-75.2819),(1020,'HUAYUCACHI',103,-12.1386,-75.2236),(1021,'INGENIO',103,-11.8906,-75.2664),(1022,'PARIAHUANCA',103,-11.9803,-74.8967),(1023,'PILCOMAYO',103,-12.0494,-75.2506),(1024,'PUCARA',103,-12.1725,-75.1456),(1025,'QUICHUAY',103,-11.8897,-75.2861),(1026,'QUILCAS',103,-11.9381,-75.2597),(1027,'SAN AGUSTIN',103,-11.9897,-75.2442),(1028,'SAN JERONIMO DE TUNAN',103,-11.9492,-75.2822),(1029,'SAÑO',103,-11.9589,-75.2586),(1030,'SAPALLANGA',103,-12.1414,-75.1581),(1031,'SICAYA',103,-12.0147,-75.28),(1032,'SANTO DOMINGO DE ACOBAMBA',103,-11.7689,-74.7953),(1033,'VIQUES',103,-12.1597,-75.2319),(1034,'CONCEPCION',104,-11.9189,-75.3125),(1035,'ACO',104,-11.9581,-75.3683),(1036,'ANDAMARCA',104,-11.7283,-74.8017),(1037,'CHAMBARA',104,-12.0272,-75.3753),(1038,'COCHAS',104,-11.66,-75.1022),(1039,'COMAS',104,-11.7178,-75.0817),(1040,'HEROINAS TOLEDO',104,-11.8356,-75.2908),(1041,'MANZANARES',104,-12.0161,-75.3458),(1042,'MARISCAL CASTILLA',104,-11.6192,-75.09),(1043,'MATAHUASI',104,-11.8939,-75.3442),(1044,'MITO',104,-11.9372,-75.3392),(1045,'NUEVE DE JULIO',104,-11.8978,-75.3181),(1046,'ORCOTUNA',104,-11.9672,-75.3075),(1047,'SAN JOSE DE QUERO',104,-12.0856,-75.5364),(1048,'SANTA ROSA DE OCOPA',104,-11.8772,-75.295),(1049,'CHANCHAMAYO',105,-11.0567,-75.3275),(1050,'PERENE',105,-10.9475,-75.2247),(1051,'PICHANAQUI',105,-10.9264,-74.8728),(1052,'SAN LUIS DE SHUARO',105,-10.8883,-75.2872),(1053,'SAN RAMON',105,-11.1206,-75.3531),(1054,'VITOC',105,-11.2103,-75.3347),(1055,'JAUJA',106,-11.7756,-75.5006),(1056,'ACOLLA',106,-11.7311,-75.5467),(1057,'APATA',106,-11.8553,-75.3544),(1058,'ATAURA',106,-11.8028,-75.4389),(1059,'CANCHAYLLO',106,-11.8022,-75.7181),(1060,'CURICACA',106,-11.7853,-75.675),(1061,'EL MANTARO',106,-11.8222,-75.3919),(1062,'HUAMALI',106,-11.8072,-75.4242),(1063,'HUARIPAMPA',106,-11.8078,-75.4711),(1064,'HUERTAS',106,-11.76,-75.4697),(1065,'JANJAILLO',106,-11.7644,-75.6103),(1066,'JULCAN',106,-11.7592,-75.4353),(1067,'LEONOR ORDOÑEZ',106,-11.8594,-75.4175),(1068,'LLOCLLAPAMPA',106,-11.8175,-75.6239),(1069,'MARCO',106,-11.7406,-75.5611),(1070,'MASMA',106,-11.7853,-75.4261),(1071,'MASMA CHICCHE',106,-11.7861,-75.3817),(1072,'MOLINOS',106,-11.7378,-75.4461),(1073,'MONOBAMBA',106,-11.3606,-75.3267),(1074,'MUQUI',106,-11.8333,-75.435),(1075,'MUQUIYAUYO',106,-11.8139,-75.4539),(1076,'PACA',106,-11.7092,-75.5183),(1077,'PACCHA',106,-11.8536,-75.5064),(1078,'PANCAN',106,-11.7489,-75.4861),(1079,'PARCO',106,-11.8011,-75.5428),(1080,'POMACANCHA',106,-11.7392,-75.6233),(1081,'RICRAN',106,-11.5394,-75.5272),(1082,'SAN LORENZO',106,-11.8464,-75.3817),(1083,'SAN PEDRO DE CHUNAN',106,-11.7256,-75.4864),(1084,'SAUSA',106,-11.7936,-75.4847),(1085,'SINCOS',106,-11.8914,-75.3869),(1086,'TUNAN MARCA',106,-11.7297,-75.5706),(1087,'YAULI',106,-11.715,-75.4719),(1088,'YAUYOS',106,-11.7808,-75.4997),(1089,'JUNIN',107,-11.1614,-75.9983),(1090,'CARHUAMAYO',107,-10.9228,-76.0578),(1091,'ONDORES',107,-11.0836,-76.1467),(1092,'ULCUMAYO',107,-10.9675,-75.8781),(1093,'SATIPO',108,-11.2539,-74.6361),(1094,'COVIRIALI',108,-11.2914,-74.6275),(1095,'LLAYLLA',108,-11.3811,-74.5903),(1096,'MAZAMARI',108,-11.325,-74.5303),(1097,'PAMPA HERMOSA',108,-11.4042,-74.7517),(1098,'PANGOA',108,-11.4283,-74.4889),(1099,'RIO NEGRO',108,-11.2089,-74.6594),(1100,'RIO TAMBO',108,-12.1861,-74.0272),(1101,'TARMA',109,-11.42,-75.6881),(1102,'ACOBAMBA',109,-11.3533,-75.6592),(1103,'HUARICOLCA',109,-11.5119,-75.6528),(1104,'HUASAHUASI',109,-11.265,-75.6503),(1105,'LA UNION',109,-11.3772,-75.7519),(1106,'PALCA',109,-11.3461,-75.5686),(1107,'PALCAMAYO',109,-11.2958,-75.7728),(1108,'SAN PEDRO DE CAJAS',109,-11.2492,-75.8628),(1109,'TAPO',109,-11.3903,-75.5639),(1110,'LA OROYA',110,-11.5219,-75.9078),(1111,'CHACAPALPA',110,-11.7328,-75.7556),(1112,'HUAY-HUAY',110,-11.7225,-75.905),(1113,'MARCAPOMACOCHA',110,-11.4067,-76.3361),(1114,'MOROCOCHA',110,-11.5872,-76.0633),(1115,'PACCHA',110,-11.4731,-75.9606),(1116,'SANTA BARBARA DE CARHUACAYAN',110,-11.2039,-76.2856),(1117,'SANTA ROSA DE SACCO',110,-11.5492,-75.9403),(1118,'SUITUCANCHA',110,-11.7875,-75.9364),(1119,'YAULI',110,-11.6658,-76.0858),(1120,'CHUPACA',111,-12.0578,-75.2894),(1121,'AHUAC',111,-12.0858,-75.3211),(1122,'CHONGOS BAJO',111,-12.1339,-75.2681),(1123,'HUACHAC',111,-12.0206,-75.3411),(1124,'HUAMANCACA CHICO',111,-12.0983,-75.2928),(1125,'SAN JUAN DE ISCOS',111,0,0),(1126,'SAN JUAN DE JARPA',111,-12.1264,-75.4356),(1127,'TRES DE DICIEMBRE',111,-12.1097,-75.2458),(1128,'YANACANCHA',111,-12.2011,-75.3867),(1129,'TRUJILLO',112,-8.1,-79.0306),(1130,'EL PORVENIR',112,-8.0881,-78.9978),(1131,'FLORENCIA DE MORA',112,-8.0828,-79.0233),(1132,'HUANCHACO',112,-8.08,-79.1217),(1133,'LA ESPERANZA',112,-8.0561,-79.0517),(1134,'LAREDO',112,-8.0897,-78.9603),(1135,'MOCHE',112,-8.1714,-79.0092),(1136,'POROTO',112,-8.0114,-78.7678),(1137,'SALAVERRY',112,-8.2244,-78.9761),(1138,'SIMBAL',112,-7.9767,-78.8133),(1139,'VICTOR LARCO HERRERA',112,-8.1364,-79.0433),(1140,'ASCOPE',113,-7.7136,-79.1072),(1141,'CHICAMA',113,-7.8425,-79.1442),(1142,'CHOCOPE',113,-7.7914,-79.2231),(1143,'MAGDALENA DE CAO',113,-7.8764,-79.2958),(1144,'PAIJAN',113,-7.7347,-79.3033),(1145,'RAZURI',113,-7.7022,-79.4378),(1146,'SANTIAGO DE CAO',113,-7.9578,-79.2436),(1147,'CASA GRANDE',113,-7.7453,-79.1881),(1148,'BOLIVAR',114,-7.1539,-77.7022),(1149,'BAMBAMARCA',114,-7.4397,-77.6931),(1150,'CONDORMARCA',114,-7.5467,-77.5997),(1151,'LONGOTEA',114,-7.0439,-77.8722),(1152,'UCHUMARCA',114,-7.0472,-77.8056),(1153,'UCUNCHA',114,-7.1653,-77.8592),(1154,'CHEPEN',115,-7.2275,-79.4294),(1155,'PACANGA',115,-7.1714,-79.4856),(1156,'PUEBLO NUEVO',115,-7.1825,-79.52),(1157,'JULCAN',116,-8.0428,-78.4864),(1158,'CALAMARCA',116,-8.17,-78.4122),(1159,'CARABAMBA',116,-8.1125,-78.6075),(1160,'HUASO',116,-8.2247,-78.4142),(1161,'OTUZCO',117,-7.9022,-78.5656),(1162,'AGALLPAMPA',117,-7.9819,-78.5467),(1163,'CHARAT',117,-7.8239,-78.4481),(1164,'HUARANCHAL',117,-7.6897,-78.4425),(1165,'LA CUESTA',117,-7.9189,-78.7047),(1166,'MACHE',117,-8.0292,-78.535),(1167,'PARANDAY',117,-7.885,-78.7094),(1168,'SALPO',117,-8.0031,-78.6042),(1169,'SINSICAP',117,-7.8517,-78.7542),(1170,'USQUIL',117,-7.8153,-78.4167),(1171,'SAN PEDRO DE LLOC',118,-7.4183,-79.5147),(1172,'GUADALUPE',118,-7.2436,-79.4703),(1173,'JEQUETEPEQUE',118,-7.3375,-79.5631),(1174,'PACASMAYO',118,-7.4011,-79.5722),(1175,'SAN JOSE',118,-7.35,-79.4553),(1176,'TAYABAMBA',119,-8.275,-77.2961),(1177,'BULDIBUYO',119,-8.1269,-77.3953),(1178,'CHILLIA',119,-8.1244,-77.515),(1179,'HUANCASPATA',119,-8.4575,-77.2983),(1180,'HUAYLILLAS',119,-8.1872,-77.3439),(1181,'HUAYO',119,-8.0044,-77.5922),(1182,'ONGON',119,-8.2078,-76.9828),(1183,'PARCOY',119,-8.0333,-77.4797),(1184,'PATAZ',119,-7.785,-77.5939),(1185,'PIAS',119,-7.8719,-77.5467),(1186,'SANTIAGO DE CHALLAS',119,-8.4381,-77.3206),(1187,'TAURIJA',119,-8.3078,-77.4236),(1188,'URPAY',119,-8.3478,-77.3894),(1189,'HUAMACHUCO',120,-7.8111,-78.0467),(1190,'CHUGAY',120,-7.7819,-77.8683),(1191,'COCHORCO',120,-7.8064,-77.7175),(1192,'CURGOS',120,-7.86,-77.9439),(1193,'MARCABAL',120,-7.7058,-78.0336),(1194,'SANAGORAN',120,-7.7861,-78.1419),(1195,'SARIN',120,-7.9114,-77.9061),(1196,'SARTIMBAMBA',120,-7.6992,-77.7436),(1197,'SANTIAGO DE CHUCO',121,-8.1453,-78.1736),(1198,'ANGASMARCA',121,-8.1328,-78.0558),(1199,'CACHICADAN',121,-8.0944,-78.1489),(1200,'MOLLEBAMBA',121,-8.1708,-77.9739),(1201,'MOLLEPATA',121,-8.1933,-77.9572),(1202,'QUIRUVILCA',121,-8.0019,-78.31),(1203,'SANTA CRUZ DE CHUCA',121,-8.1203,-78.1422),(1204,'SITABAMBA',121,-8.0222,-77.73),(1205,'GRAN CHIMU',122,0,0),(1206,'CASCAS',122,-7.4794,-78.8197),(1207,'LUCMA',122,-7.6406,-78.5522),(1208,'MARMOT',122,-7.6983,-78.6261),(1209,'SAYAPULLO',122,-7.5958,-78.465),(1210,'VIRU',123,-8.4144,-78.7528),(1211,'CHAO',123,-8.5406,-78.6789),(1212,'GUADALUPITO',123,-8.9517,-78.6247),(1213,'CHICLAYO',124,-6.7669,-79.8506),(1214,'CHONGOYAPE',124,-6.6431,-79.3853),(1215,'ETEN',124,-6.9069,-79.8625),(1216,'ETEN PUERTO',124,-6.9256,-79.8661),(1217,'JOSE LEONARDO ORTIZ',124,-6.7631,-79.8344),(1218,'LA VICTORIA',124,-6.7944,-79.8444),(1219,'LAGUNAS',124,-6.9911,-79.6228),(1220,'MONSEFU',124,-6.8781,-79.8725),(1221,'NUEVA ARICA',124,-6.8742,-79.3436),(1222,'OYOTUN',124,-6.8544,-79.3064),(1223,'PICSI',124,-6.7183,-79.7706),(1224,'PIMENTEL',124,-6.8353,-79.9358),(1225,'REQUE',124,-6.865,-79.8192),(1226,'SANTA ROSA',124,-6.8817,-79.9208),(1227,'SAÑA',124,-6.9181,-79.5833),(1228,'CAYALTI',124,-6.8917,-79.5622),(1229,'PATAPO',124,-6.7356,-79.6347),(1230,'POMALCA',124,-6.77,-79.7753),(1231,'PUCALA',124,-6.7819,-79.6122),(1232,'TUMAN',124,-6.7511,-79.7011),(1233,'FERREÑAFE',125,-6.6389,-79.7883),(1234,'CAÑARIS',125,-6.0461,-79.2653),(1235,'INCAHUASI',125,-6.2353,-79.3169),(1236,'MANUEL ANTONIO MESONES MURO',125,-6.645,-79.7389),(1237,'PITIPO',125,-6.5658,-79.7808),(1238,'PUEBLO NUEVO',125,-6.6403,-79.7961),(1239,'LAMBAYEQUE',126,-6.7069,-79.8953),(1240,'CHOCHOPE',126,-6.1578,-79.6478),(1241,'ILLIMO',126,-6.4739,-79.8547),(1242,'JAYANCA',126,-6.3928,-79.8228),(1243,'MOCHUMI',126,-6.5478,-79.865),(1244,'MORROPE',126,-6.5403,-80.0156),(1245,'MOTUPE',126,-6.1508,-79.7142),(1246,'OLMOS',126,-5.9878,-79.7475),(1247,'PACORA',126,-6.4286,-79.8389),(1248,'SALAS',126,-6.2747,-79.6072),(1249,'SAN JOSE',126,-6.7694,-79.9681),(1250,'TUCUME',126,-6.51,-79.8592),(1251,'LIMA',127,-12.0453,-77.0308),(1252,'ANCON',127,-11.7739,-77.1764),(1253,'ATE',127,-12.0264,-76.9214),(1254,'BARRANCO',127,-12.1492,-77.0217),(1255,'BREÑA',127,-12.0589,-77.0461),(1256,'CARABAYLLO',127,-11.8903,-77.0269),(1257,'CHACLACAYO',127,-11.9753,-76.7689),(1258,'CHORRILLOS',127,-12.1769,-77.0164),(1259,'CIENEGUILLA',127,-12.1203,-76.8142),(1260,'COMAS',127,-11.9572,-77.0494),(1261,'EL AGUSTINO',127,-12.0483,-77.0006),(1262,'INDEPENDENCIA',127,-11.9972,-77.0547),(1263,'JESUS MARIA',127,-12.0756,-77.0433),(1264,'LA MOLINA',127,-12.0781,-76.9167),(1265,'LA VICTORIA',127,-12.065,-77.0308),(1266,'LINCE',127,-12.0844,-77.0303),(1267,'LOS OLIVOS',127,-11.9914,-77.0708),(1268,'LURIGANCHO',127,-11.9358,-76.6972),(1269,'LURIN',127,-12.2747,-76.8703),(1270,'MAGDALENA DEL MAR',127,-12.0781,-77.0625),(1271,'MAGDALENA VIEJA',127,0,0),(1272,'MIRAFLORES',127,-12.1217,-77.0292),(1273,'PACHACAMAC',127,-12.1872,-76.8667),(1274,'PUCUSANA',127,-12.4817,-76.7975),(1275,'PUENTE PIEDRA',127,-11.8667,-77.0769),(1276,'PUNTA HERMOSA',127,-12.3336,-76.8242),(1277,'PUNTA NEGRA',127,-12.3653,-76.7956),(1278,'RIMAC',127,-12.0422,-77.0269),(1279,'SAN BARTOLO',127,-12.3892,-76.7808),(1280,'SAN BORJA',127,-12.1072,-76.9989),(1281,'SAN ISIDRO',127,-12.0978,-77.0272),(1282,'SAN JUAN DE LURIGANCHO',127,-12.0297,-77.01),(1283,'SAN JUAN DE MIRAFLORES',127,-12.1636,-76.9636),(1284,'SAN LUIS',127,-12.0756,-76.9936),(1285,'SAN MARTIN DE PORRES',127,-12.03,-77.0575),(1286,'SAN MIGUEL',127,-12.0922,-77.0794),(1287,'SANTA ANITA',127,-12.0439,-76.9714),(1288,'SANTA MARIA DEL MAR',127,-12.4019,-76.7733),(1289,'SANTA ROSA',127,-11.7872,-77.1569),(1290,'SANTIAGO DE SURCO',127,-12.145,-77.005),(1291,'SURQUILLO',127,-12.1186,-77.0217),(1292,'VILLA EL SALVADOR',127,-12.2133,-76.9372),(1293,'VILLA MARIA DEL TRIUNFO',127,-12.1625,-76.9436),(1294,'BARRANCA',128,-10.7533,-77.765),(1295,'PARAMONGA',128,-10.6747,-77.8181),(1296,'PATIVILCA',128,-10.6961,-77.7803),(1297,'SUPE',128,-10.7961,-77.7161),(1298,'SUPE PUERTO',128,-10.8017,-77.7447),(1299,'CAJATAMBO',129,-10.4731,-76.9931),(1300,'COPA',129,-10.3864,-77.0789),(1301,'GORGOR',129,-10.6211,-77.0414),(1302,'HUANCAPON',129,-10.5494,-77.1125),(1303,'MANAS',129,-10.5956,-77.1672),(1304,'CANTA',130,-11.4672,-76.6244),(1305,'ARAHUAY',130,-11.6214,-76.6703),(1306,'HUAMANTANGA',130,-11.4992,-76.7494),(1307,'HUAROS',130,-11.4067,-76.5758),(1308,'LACHAQUI',130,-11.5531,-76.6256),(1309,'SAN BUENAVENTURA',130,-11.4892,-76.6622),(1310,'SANTA ROSA DE QUIVES',130,-11.6953,-76.8461),(1311,'SAN VICENTE DE CAÑETE',131,-13.0778,-76.3878),(1312,'ASIA',131,-12.7792,-76.5567),(1313,'CALANGO',131,-12.5264,-76.5436),(1314,'CERRO AZUL',131,-13.025,-76.4789),(1315,'CHILCA',131,-12.5181,-76.7381),(1316,'COAYLLO',131,-12.7272,-76.4603),(1317,'IMPERIAL',131,-13.0606,-76.3528),(1318,'LUNAHUANA',131,-12.9706,-76.1511),(1319,'MALA',131,-12.6575,-76.6325),(1320,'NUEVO IMPERIAL',131,-13.0756,-76.3167),(1321,'PACARAN',131,-12.8661,-76.0542),(1322,'QUILMANA',131,-12.9494,-76.3828),(1323,'SAN ANTONIO',131,-12.6422,-76.6494),(1324,'SAN LUIS',131,-13.0511,-76.4311),(1325,'SANTA CRUZ DE FLORES',131,-12.6197,-76.6397),(1326,'ZUÑIGA',131,-12.8603,-76.0225),(1327,'HUARAL',132,-11.4953,-77.2069),(1328,'ATAVILLOS ALTO',132,-11.2342,-76.6558),(1329,'ATAVILLOS BAJO',132,-11.3519,-76.8256),(1330,'AUCALLAMA',132,-11.5594,-77.18),(1331,'CHANCAY',132,-11.5631,-77.2706),(1332,'IHUARI',132,-11.1886,-76.9519),(1333,'LAMPIAN',132,-11.2378,-76.8392),(1334,'PACARAOS',132,-11.1861,-76.6478),(1335,'SAN MIGUEL DE ACOS',132,-11.2739,-76.8219),(1336,'SANTA CRUZ DE ANDAMARCA',132,-11.1947,-76.6344),(1337,'SUMBILCA',132,-11.4067,-76.8197),(1338,'VEINTISIETE DE NOVIEMBRE',132,-11.1922,-76.7797),(1339,'MATUCANA',133,-11.845,-76.3861),(1340,'ANTIOQUIA',133,-12.0808,-76.5108),(1341,'CALLAHUANCA',133,-11.8264,-76.6189),(1342,'CARAMPOMA',133,-11.6564,-76.5164),(1343,'CHICLA',133,-11.7064,-76.2681),(1344,'CUENCA',133,-12.1322,-76.4353),(1345,'HUACHUPAMPA',133,-11.7211,-76.5886),(1346,'HUANZA',133,-11.6561,-76.5036),(1347,'HUAROCHIRI',133,-12.1361,-76.2319),(1348,'LAHUAYTAMBO',133,-12.0964,-76.3889),(1349,'LANGA',133,-12.1256,-76.4211),(1350,'LARAOS',133,-11.6644,-76.5394),(1351,'MARIATANA',133,-12.2372,-76.3261),(1352,'RICARDO PALMA',133,-11.9236,-76.665),(1353,'SAN ANDRES DE TUPICOCHA',133,-12.0022,-76.4747),(1354,'SAN ANTONIO',133,-11.7436,-76.65),(1355,'SAN BARTOLOME',133,-11.9119,-76.5292),(1356,'SAN DAMIAN',133,-12.0178,-76.3919),(1357,'SAN JUAN DE IRIS',133,-11.6831,-76.525),(1358,'SAN JUAN DE TANTARANCHE',133,-12.1136,-76.1825),(1359,'SAN LORENZO DE QUINTI',133,-12.1453,-76.2125),(1360,'SAN MATEO',133,-11.7592,-76.3006),(1361,'SAN MATEO OTAO',133,-11.8703,-76.5439),(1362,'SAN PEDRO DE CASTA',133,-11.7589,-76.5964),(1363,'SAN PEDRO DE HUANCAYRE',133,-12.1314,-76.2156),(1364,'SANGALLAYA',133,-12.1608,-76.2289),(1365,'SANTA CRUZ DE COCACHACRA',133,-11.9117,-76.5394),(1366,'SANTA EULALIA',133,-11.9017,-76.6639),(1367,'SANTIAGO DE ANCHUCAYA',133,-12.0956,-76.2306),(1368,'SANTIAGO DE TUNA',133,-11.9839,-76.5253),(1369,'SANTO DOMINGO DE LOS OLLEROS',133,-12.2189,-76.5142),(1370,'SURCO',133,-11.8825,-76.4361),(1371,'HUACHO',134,-11.1081,-77.6103),(1372,'AMBAR',134,-10.7561,-77.2719),(1373,'CALETA DE CARQUIN',134,-11.0917,-77.6283),(1374,'CHECRAS',134,-10.9181,-76.8256),(1375,'HUALMAY',134,-11.0967,-77.6131),(1376,'HUAURA',134,-11.0697,-77.5992),(1377,'LEONCIO PRADO',134,-11.0611,-76.9303),(1378,'PACCHO',134,-10.9575,-76.9333),(1379,'SANTA LEONOR',134,-10.9486,-76.745),(1380,'SANTA MARIA',134,-11.0967,-77.595),(1381,'SAYAN',134,-11.1353,-77.1936),(1382,'VEGUETA',134,-11.0233,-77.6439),(1383,'OYON',135,-10.6681,-76.7733),(1384,'ANDAJES',135,-10.7928,-76.9092),(1385,'CAUJUL',135,-10.8058,-76.9792),(1386,'COCHAMARCA',135,-10.8633,-77.1289),(1387,'NAVAN',135,-10.8378,-77.0144),(1388,'PACHANGARA',135,-10.8111,-76.875),(1389,'YAUYOS',136,-12.4597,-75.9183),(1390,'ALIS',136,-12.2811,-75.7864),(1391,'AYAUCA',136,-12.5911,-76.0369),(1392,'AYAVIRI',136,-12.3825,-76.1369),(1393,'AZANGARO',136,-13,-75.8372),(1394,'CACRA',136,-12.8125,-75.7831),(1395,'CARANIA',136,-12.3456,-75.8694),(1396,'CATAHUASI',136,-12.7994,-75.8914),(1397,'CHOCOS',136,-12.9144,-75.8628),(1398,'COCHAS',136,-12.2942,-76.1575),(1399,'COLONIA',136,-12.6339,-75.8903),(1400,'HONGOS',136,-12.8108,-75.7653),(1401,'HUAMPARA',136,-12.3603,-76.1672),(1402,'HUANCAYA',136,-12.2033,-75.7992),(1403,'HUANGASCAR',136,-12.8994,-75.8319),(1404,'HUANTAN',136,-12.4564,-75.8117),(1405,'HUAÑEC',136,-12.2939,-76.1386),(1406,'LARAOS',136,-12.3467,-75.7858),(1407,'LINCHA',136,-12.7997,-75.6667),(1408,'MADEAN',136,-12.9444,-75.7772),(1409,'MIRAFLORES',136,-12.2744,-75.8503),(1410,'OMAS',136,-12.5147,-76.2894),(1411,'PUTINZA',136,-12.6681,-75.9494),(1412,'QUINCHES',136,-12.3078,-76.1433),(1413,'QUINOCAY',136,-12.3622,-76.2264),(1414,'SAN JOAQUIN',136,-12.2839,-76.1469),(1415,'SAN PEDRO DE PILAS',136,-12.4544,-76.2269),(1416,'TANTA',136,-12.1222,-76.0133),(1417,'TAURIPAMPA',136,-12.6172,-76.1619),(1418,'TOMAS',136,-12.2378,-75.745),(1419,'TUPE',136,-12.7411,-75.8094),(1420,'VIÑAC',136,-12.9311,-75.78),(1421,'VITIS',136,-12.2239,-75.8081),(1422,'IQUITOS',137,-3.7481,-73.2442),(1423,'ALTO NANAY',137,-3.8883,-73.6975),(1424,'FERNANDO LORES',137,-4.0017,-73.1569),(1425,'INDIANA',137,-3.5003,-73.0411),(1426,'LAS AMAZONAS',137,-3.4231,-72.7644),(1427,'MAZAN',137,-3.4886,-73.0817),(1428,'NAPO',137,-2.4892,-73.6761),(1429,'PUNCHANA',137,-3.7286,-73.2419),(1430,'PUTUMAYO',137,-2.4081,-71.1767),(1431,'TORRES CAUSANA',137,-0.9706,-75.1742),(1432,'BELEN',137,-3.7692,-73.26),(1433,'SAN JUAN BAUTISTA',137,-3.7703,-73.2803),(1434,'YURIMAGUAS',138,-5.8842,-76.1281),(1435,'BALSAPUERTO',138,-5.8333,-76.5597),(1436,'BARRANCA',138,-4.8311,-76.555),(1437,'CAHUAPANAS',138,-5.2492,-77.0414),(1438,'JEBEROS',138,-5.2908,-76.2833),(1439,'LAGUNAS',138,-5.2239,-75.675),(1440,'MANSERICHE',138,-4.5636,-77.4172),(1441,'MORONA',138,-4.3264,-77.2161),(1442,'PASTAZA',138,-3.4756,-76.4336),(1443,'SANTA CRUZ',138,-5.5133,-75.8589),(1444,'TENIENTE CESAR LOPEZ ROJAS',138,-6.0256,-75.8742),(1445,'NAUTA',139,-4.5014,-73.5694),(1446,'PARINARI',139,-4.6317,-74.4631),(1447,'TIGRE',139,-3.4897,-74.7817),(1448,'TROMPETEROS',139,-3.805,-75.0606),(1449,'URARINAS',139,-4.5875,-74.7672),(1450,'RAMON CASTILLA',140,-3.9061,-70.5169),(1451,'PEBAS',140,-3.3203,-71.8619),(1452,'YAVARI',140,-4.3536,-70.0417),(1453,'SAN PABLO',140,-4.0203,-71.1031),(1454,'REQUENA',141,-5.0639,-73.8567),(1455,'ALTO TAPICHE',141,-6.0256,-74.0942),(1456,'CAPELO',141,-5.4053,-74.1578),(1457,'EMILIO SAN MARTIN',141,-5.7936,-74.2839),(1458,'MAQUIA',141,-5.7497,-74.5378),(1459,'PUINAHUA',141,-5.2556,-74.3456),(1460,'SAQUENA',141,-4.725,-73.5331),(1461,'SOPLIN',141,-6.0078,-73.6925),(1462,'TAPICHE',141,-5.6936,-74.1378),(1463,'JENARO HERRERA',141,-4.9036,-73.6706),(1464,'YAQUERANA',141,-5.1489,-72.8753),(1465,'CONTAMANA',142,-7.3506,-75.0097),(1466,'INAHUAYA',142,-7.1169,-75.2625),(1467,'PADRE MARQUEZ',142,-7.9467,-74.8408),(1468,'PAMPA HERMOSA',142,-7.1964,-75.2944),(1469,'SARAYACU',142,-6.3931,-75.1169),(1470,'VARGAS GUERRA',142,-6.9111,-75.1589),(1471,'TAMBOPATA',143,-12.5936,-69.1767),(1472,'INAMBARI',143,-13.1014,-70.3717),(1473,'LAS PIEDRAS',143,-12.2792,-69.1503),(1474,'LABERINTO',143,-12.7172,-69.5867),(1475,'MANU',144,-12.8372,-71.3653),(1476,'FITZCARRALD',144,-12.2653,-70.91),(1477,'MADRE DE DIOS',144,-12.6186,-70.3942),(1478,'HUEPETUHE',144,-12.9936,-70.5272),(1479,'IÑAPARI',145,-10.945,-69.5767),(1480,'IBERIA',145,-11.4108,-69.4869),(1481,'TAHUAMANU',145,-11.4547,-69.3214),(1482,'MOQUEGUA',146,-17.1942,-70.9333),(1483,'CARUMAS',146,-16.8092,-70.6947),(1484,'CUCHUMBAYA',146,-16.7508,-70.6861),(1485,'SAMEGUA',146,-17.1822,-70.9003),(1486,'SAN CRISTOBAL',146,-16.7392,-70.6833),(1487,'TORATA',146,-17.0767,-70.8442),(1488,'OMATE',147,-16.6736,-70.9706),(1489,'CHOJATA',147,-16.3883,-70.7303),(1490,'COALAQUE',147,-16.6489,-71.0217),(1491,'ICHUÑA',147,-16.1406,-70.5356),(1492,'LA CAPILLA',147,-16.7567,-71.1792),(1493,'LLOQUE',147,-16.3239,-70.7386),(1494,'MATALAQUE',147,-16.4811,-70.8267),(1495,'PUQUINA',147,-16.6253,-71.1839),(1496,'QUINISTAQUILLAS',147,-16.7489,-70.8803),(1497,'UBINAS',147,-16.3867,-70.8556),(1498,'YUNGA',147,-16.195,-70.6778),(1499,'ILO',148,-17.625,-71.3433),(1500,'EL ALGARROBAL',148,-17.6228,-71.2683),(1501,'PACOCHA',148,-17.6108,-71.3403),(1502,'CHAUPIMARCA',149,-10.6825,-76.2569),(1503,'HUACHON',149,-10.6364,-75.9511),(1504,'HUARIACA',149,-10.4392,-76.1917),(1505,'HUAYLLAY',149,-11.0019,-76.3647),(1506,'NINACACA',149,-10.8556,-76.1131),(1507,'PALLANCHACRA',149,-10.4153,-76.2356),(1508,'PAUCARTAMBO',149,-10.49,-76.1961),(1509,'SAN FCO.DE ASIS DE YARUSYACAN',149,0,0),(1510,'SIMON BOLIVAR',149,-10.6892,-76.3164),(1511,'TICLACAYAN',149,-10.535,-76.1642),(1512,'TINYAHUARCO',149,-10.7697,-76.2769),(1513,'VICCO',149,-10.8383,-76.2383),(1514,'YANACANCHA',149,-10.6633,-76.2531),(1515,'YANAHUANCA',150,-10.4914,-76.5164),(1516,'CHACAYAN',150,-10.4344,-76.4372),(1517,'GOYLLARISQUIZGA',150,-10.4731,-76.4083),(1518,'PAUCAR',150,-10.3711,-76.4433),(1519,'SAN PEDRO DE PILLAO',150,-10.4389,-76.4953),(1520,'SANTA ANA DE TUSI',150,-10.4725,-76.3536),(1521,'TAPUC',150,-10.4547,-76.4625),(1522,'VILCABAMBA',150,-10.4786,-76.4469),(1523,'OXAPAMPA',151,-10.575,-75.4047),(1524,'CHONTABAMBA',151,-10.6022,-75.4389),(1525,'HUANCABAMBA',151,-10.4261,-75.5239),(1526,'PALCAZU',151,-10.1842,-75.1481),(1527,'POZUZO',151,-10.0711,-75.5503),(1528,'PUERTO BERMUDEZ',151,-10.2992,-74.9372),(1529,'VILLA RICA',151,-9.8564,-75.0169),(1530,'PIURA',152,-5.1525,-80.6578),(1531,'CASTILLA',152,-5.2014,-80.6228),(1532,'CATACAOS',152,-5.2672,-80.6725),(1533,'CURA MORI',152,-5.3236,-80.6656),(1534,'EL TALLAN',152,-5.4092,-80.6811),(1535,'LA ARENA',152,-5.3431,-80.7036),(1536,'LA UNION',152,-5.3883,-80.7372),(1537,'LAS LOMAS',152,-4.65,-80.2392),(1538,'TAMBO GRANDE',152,-5.1792,-80.6781),(1539,'AYABACA',153,-4.6406,-79.7153),(1540,'FRIAS',153,-4.9317,-79.9475),(1541,'JILILI',153,-4.5847,-79.7972),(1542,'LAGUNAS',153,-4.7892,-79.845),(1543,'MONTERO',153,-4.6322,-79.8289),(1544,'PACAIPAMPA',153,-4.9956,-79.6678),(1545,'PAIMAS',153,-4.6275,-79.9456),(1546,'SAPILLICA',153,-4.7792,-79.9822),(1547,'SICCHEZ',153,-4.57,-79.7639),(1548,'SUYO',153,-4.5128,-80.0025),(1549,'HUANCABAMBA',154,-5.2386,-79.4503),(1550,'CANCHAQUE',154,-5.3758,-79.6056),(1551,'EL CARMEN DE LA FRONTERA',154,-5.1483,-79.4283),(1552,'HUARMACA',154,-5.5681,-79.5244),(1553,'LALAQUIZ',154,-5.2158,-79.68),(1554,'SAN MIGUEL DE EL FAIQUE',154,-5.4019,-79.6061),(1555,'SONDOR',154,-5.3156,-79.4097),(1556,'SONDORILLO',154,-5.3394,-79.4286),(1557,'CHULUCANAS',155,-5.0972,-80.1603),(1558,'BUENOS AIRES',155,-5.2669,-79.9669),(1559,'CHALACO',155,-5.0411,-79.7956),(1560,'LA MATANZA',155,-5.2136,-80.0906),(1561,'MORROPON',155,-5.1861,-79.9692),(1562,'SALITRAL',155,-5.3419,79.8336),(1563,'SAN JUAN DE BIGOTE',155,-5.3194,-79.7861),(1564,'SANTA CATALINA DE MOSSA',155,-5.1028,-79.885),(1565,'SANTO DOMINGO',155,-5.0294,-79.8758),(1566,'YAMANGO',155,-5.1808,-79.7511),(1567,'PAITA',156,-5.0931,-81.0994),(1568,'AMOTAPE',156,-4.8819,-81.0153),(1569,'ARENAL',156,-4.8836,-81.0264),(1570,'COLAN',156,-4.9006,-81.0564),(1571,'LA HUACA',156,-4.9103,-80.9614),(1572,'TAMARINDO',156,-4.8783,-80.9758),(1573,'VICHAYAL',156,-4.8642,-81.0731),(1574,'SULLANA',157,-4.8906,-80.6878),(1575,'BELLAVISTA',157,-4.89,-80.6803),(1576,'IGNACIO ESCUDERO',157,-4.8461,-80.8731),(1577,'LANCONES',157,-4.6328,-80.5456),(1578,'MARCAVELICA',157,-4.8817,-80.7036),(1579,'MIGUEL CHECA',157,-4.9003,-80.8147),(1580,'QUERECOTILLO',157,-4.8392,-80.6483),(1581,'SALITRAL',157,-4.8569,-80.6808),(1582,'PARIÑAS',158,-4.5794,-81.2694),(1583,'EL ALTO',158,-4.2686,-81.2214),(1584,'LA BREA',158,-4.6547,-81.3058),(1585,'LOBITOS',158,-4.4569,-81.285),(1586,'LOS ORGANOS',158,-4.1792,-81.1294),(1587,'MANCORA',158,-4.1069,-81.0539),(1588,'SECHURA',159,-5.5572,-80.8222),(1589,'BELLAVISTA DE LA UNION',159,-5.4403,-80.755),(1590,'BERNAL',159,-5.4589,-80.7419),(1591,'CRISTO NOS VALGA',159,-5.4931,-80.7411),(1592,'VICE',159,-5.4222,-80.7764),(1593,'RINCONADA LLICUAR',159,-5.4636,-80.7653),(1594,'PUNO',160,-15.8403,-70.0281),(1595,'ACORA',160,-15.9736,-69.7978),(1596,'AMANTANI',160,-15.6572,-69.7183),(1597,'ATUNCOLLA',160,-15.6883,-70.1439),(1598,'CAPACHICA',160,-15.6417,-69.8308),(1599,'CHUCUITO',160,-15.8947,-69.8894),(1600,'COATA',160,-15.5714,-69.9506),(1601,'HUATA',160,-15.615,-69.9714),(1602,'MAÑAZO',160,-15.8011,-70.3433),(1603,'PAUCARCOLLA',160,-15.7456,-70.0561),(1604,'PICHACANI',160,-16.15,-70.0633),(1605,'PLATERIA',160,-15.9483,-69.8333),(1606,'SAN ANTONIO',160,-16.1406,-70.3439),(1607,'TIQUILLACA',160,-15.7969,-70.1867),(1608,'VILQUE',160,-15.7667,-70.2589),(1609,'AZANGARO',161,-14.9081,-70.1956),(1610,'ACHAYA',161,-15.2847,-70.1611),(1611,'ARAPA',161,-15.1389,-70.11),(1612,'ASILLO',161,-14.7864,-70.3536),(1613,'CAMINACA',161,-15.3247,-70.0728),(1614,'CHUPA',161,-15.1058,-69.9872),(1615,'JOSE DOMINGO CHOQUEHUANCA',161,-15.0339,-70.3381),(1616,'MUÑANI',161,-14.7708,-69.9556),(1617,'POTONI',161,-14.39,-70.105),(1618,'SAMAN',161,-15.2919,-70.0172),(1619,'SAN ANTON',161,-14.5839,-70.3172),(1620,'SAN JOSE',161,-14.6803,-70.16),(1621,'SAN JUAN DE SALINAS',161,-14.9914,-70.1061),(1622,'SANTIAGO DE PUPUJA',161,-15.0528,-70.2781),(1623,'TIRAPATA',161,-14.955,-70.4028),(1624,'MACUSANI',162,-14.0686,-70.4311),(1625,'AJOYANI',162,-14.2294,-70.2236),(1626,'AYAPATA',162,-13.7767,-70.3228),(1627,'COASA',162,-13.9892,-70.0158),(1628,'CORANI',162,-13.8686,-70.6044),(1629,'CRUCERO',162,-14.3617,-70.0236),(1630,'ITUATA',162,-13.8764,-70.2139),(1631,'OLLACHEA',162,-13.7939,-70.4725),(1632,'SAN GABAN',162,-13.4383,-70.4028),(1633,'USICAYOS',162,-14.1253,-69.9675),(1634,'JULI',163,-16.2128,-69.4594),(1635,'DESAGUADERO',163,-16.5644,-69.0394),(1636,'HUACULLANI',163,-16.6306,-69.3219),(1637,'KELLUYO',163,-16.7269,-69.2503),(1638,'PISACOMA',163,-16.9086,-69.3714),(1639,'POMATA',163,-16.2736,-69.2928),(1640,'ZEPITA',163,-16.4969,-69.1033),(1641,'ILAVE',164,-16.0869,-69.6381),(1642,'CAPAZO',164,-17.1839,-69.7444),(1643,'PILCUYO',164,-16.1108,-69.5542),(1644,'SANTA ROSA',164,-16.7422,-69.7167),(1645,'CONDURIRI',164,-16.6219,-69.7086),(1646,'HUANCANE',165,-15.2008,-69.7678),(1647,'COJATA',165,-15.0153,-69.3656),(1648,'HUATASANI',165,-15.0594,-69.8019),(1649,'INCHUPALLA',165,-15.0097,-69.6828),(1650,'PUSI',165,-15.4419,-69.9297),(1651,'ROSASPATA',165,-15.2347,-69.5275),(1652,'TARACO',165,-15.2972,-69.9783),(1653,'VILQUE CHICO',165,-15.2139,-69.6892),(1654,'LAMPA',166,-15.3647,-70.3678),(1655,'CABANILLA',166,-15.6203,-70.3456),(1656,'CALAPUJA',166,-15.3106,-70.2217),(1657,'NICASIO',166,-15.2356,-70.2611),(1658,'OCUVIRI',166,-15.1139,-70.9092),(1659,'PALCA',166,-15.2369,-70.5981),(1660,'PARATIA',166,-15.4542,-70.5997),(1661,'PUCARA',166,-15.0417,-70.3678),(1662,'SANTA LUCIA',166,-15.6994,-70.6064),(1663,'VILAVILA',166,-15.1883,-70.66),(1664,'AYAVIRI',167,-14.8817,-70.5894),(1665,'ANTAUTA',167,-14.2997,-70.2922),(1666,'CUPI',167,-14.905,-70.8667),(1667,'LLALLI',167,-14.9481,-70.8806),(1668,'MACARI',167,-14.7717,-70.9033),(1669,'NUÑOA',167,-14.4761,-70.6364),(1670,'ORURILLO',167,-14.7278,-70.5122),(1671,'SANTA ROSA',167,-14.6075,-70.7878),(1672,'UMACHIRI',167,-14.8539,-70.7539),(1673,'MOHO',168,-15.3603,-69.4997),(1674,'CONIMA',168,-15.4578,-69.4378),(1675,'HUAYRAPATA',168,-15.3214,-69.3411),(1676,'TILALI',168,-15.515,-69.3481),(1677,'PUTINA',169,-14.9142,-69.8689),(1678,'ANANEA',169,-14.6786,-69.535),(1679,'PEDRO VILCA APAZA',169,-15.0636,-69.8817),(1680,'QUILCAPUNCU',169,-14.8936,-69.7303),(1681,'SINA',169,-14.4967,-69.2803),(1682,'JULIACA',170,-15.4839,-70.1333),(1683,'CABANA',170,-15.6492,-70.3219),(1684,'CABANILLAS',170,-15.6444,-70.3539),(1685,'CARACOTO',170,-15.4603,-70.1269),(1686,'SANDIA',171,-14.3222,-69.4664),(1687,'CUYOCUYO',171,-14.4703,-69.5372),(1688,'LIMBANI',171,-14.1497,-69.6906),(1689,'PATAMBUCO',171,-14.3617,-69.6194),(1690,'PHARA',171,-14.1519,-69.6653),(1691,'QUIACA',171,-14.4222,-69.345),(1692,'SAN JUAN DEL ORO',171,-14.2208,-69.1536),(1693,'YANAHUAYA',171,-14.2586,-69.1694),(1694,'ALTO INAMBARI',171,-14.1125,-69.0478),(1695,'YUNGUYO',172,-16.2267,-69.0956),(1696,'ANAPIA',172,-16.3139,-68.8528),(1697,'COPANI',172,-16.4,-69.0403),(1698,'CUTURAPI',172,-16.2706,-69.1769),(1699,'OLLARAYA',172,-16.2197,-68.9911),(1700,'TINICACHI',172,-16.1986,-68.9617),(1701,'UNICACHI',172,-16.2236,-68.9811),(1702,'MOYOBAMBA',173,-6.0347,-76.9742),(1703,'CALZADA',173,-6.0303,-77.0667),(1704,'HABANA',173,-6.0797,-77.0914),(1705,'JEPELACIO',173,-6.1081,-76.9153),(1706,'SORITOR',173,-6.1394,-77.1025),(1707,'YANTALO',173,-5.9744,-77.0208),(1708,'BELLAVISTA',174,-7.0522,-76.5897),(1709,'ALTO BIAVO',174,-7.2558,-76.4767),(1710,'BAJO BIAVO',174,-7.1017,-76.4719),(1711,'HUALLAGA',174,-7.1311,-76.6486),(1712,'SAN PABLO',174,-6.8097,-76.5747),(1713,'SAN RAFAEL',174,-7.0231,-76.4658),(1714,'SAN JOSE DE SISA',175,-6.6139,-76.6953),(1715,'AGUA BLANCA',175,-6.7253,-76.6953),(1716,'SAN MARTIN',175,-6.5144,-76.7406),(1717,'SANTA ROSA',175,-6.7464,-76.6236),(1718,'SHATOJA',175,-6.5283,-76.72),(1719,'SAPOSOA',176,-6.9367,-76.7722),(1720,'ALTO SAPOSOA',176,-6.7647,-76.8136),(1721,'EL ESLABON',176,-7.0217,-76.7233),(1722,'PISCOYACU',176,-6.9811,-76.7694),(1723,'SACANCHE',176,-7.07,-76.7136),(1724,'TINGO DE SAPOSOA',176,-7.0919,-76.6414),(1725,'LAMAS',177,-6.4239,-76.5233),(1726,'ALONSO DE ALVARADO',177,-6.3558,-76.7753),(1727,'BARRANQUITA',177,-6.2522,-76.0333),(1728,'CAYNARACHI',177,-6.3308,-76.2842),(1729,'CUÑUMBUQUI',177,-6.5106,-76.4817),(1730,'PINTO RECODO',177,-6.3792,-76.6044),(1731,'RUMISAPA',177,-6.4489,-76.4717),(1732,'SAN ROQUE DE CUMBAZA',177,-6.3856,-76.4386),(1733,'SHANAO',177,-6.4117,-76.5942),(1734,'TABALOSOS',177,-6.3894,-76.6342),(1735,'ZAPATERO',177,-6.5297,-76.4942),(1736,'JUANJUI',178,-7.1767,-76.7239),(1737,'CAMPANILLA',178,-7.4831,-76.6497),(1738,'HUICUNGO',178,-7.3169,-76.7772),(1739,'PACHIZA',178,-7.2981,-76.7733),(1740,'PAJARILLO',178,-7.1767,-76.6886),(1741,'PICOTA',179,-6.92,-76.3303),(1742,'BUENOS AIRES',179,-6.7917,-76.3278),(1743,'CASPISAPA',179,-6.9564,-76.4186),(1744,'PILLUANA',179,-6.7767,-76.2917),(1745,'PUCACACA',179,-6.8489,-76.3411),(1746,'SAN CRISTOBAL',179,-6.9919,-76.4178),(1747,'SAN HILARION',179,-7.0039,-76.4394),(1748,'SHAMBOYACU',179,-7.0242,-76.1328),(1749,'TINGO DE PONASA',179,-6.9361,-76.2539),(1750,'TRES UNIDOS',179,-6.8058,-76.2322),(1751,'RIOJA',180,-6.0625,-77.1683),(1752,'AWAJUN',180,-5.8161,-77.3828),(1753,'ELIAS SOPLIN VARGAS',180,-5.9872,-77.2781),(1754,'NUEVA CAJAMARCA',180,-5.9361,-77.3069),(1755,'PARDO MIGUEL',180,-5.7394,-77.5044),(1756,'POSIC',180,-6.0133,-77.1619),(1757,'SAN FERNANDO',180,-5.9019,-77.2694),(1758,'YORONGOS',180,-6.1386,-77.1442),(1759,'YURACYACU',180,-5.9311,-77.2264),(1760,'TARAPOTO',181,-6.4894,-76.3603),(1761,'ALBERTO LEVEAU',181,-6.6631,-76.2867),(1762,'CACATACHI',181,-6.4619,-76.4514),(1763,'CHAZUTA',181,-6.5736,-76.1378),(1764,'CHIPURANA',181,-6.3542,-75.7414),(1765,'EL PORVENIR',181,-6.2117,-75.8008),(1766,'HUIMBAYOC',181,-6.4178,-75.7681),(1767,'JUAN GUERRA',181,-6.5842,-76.3308),(1768,'LA BANDA DE SHILCAYO',181,-6.49,-76.3406),(1769,'MORALES',181,-6.4792,-76.3831),(1770,'PAPAPLAYA',181,-6.2453,-75.7906),(1771,'SAN ANTONIO',181,-6.4094,-76.4067),(1772,'SAUCE',181,-6.6906,-76.2167),(1773,'SHAPAJA',181,-6.5797,-76.2619),(1774,'TOCACHE',182,-8.1883,-76.5094),(1775,'NUEVO PROGRESO',182,-8.4506,-76.3264),(1776,'POLVORA',182,-7.9078,-76.6678),(1777,'SHUNTE',182,-8.3517,-76.7297),(1778,'UCHIZA',182,-8.4583,-76.4617),(1779,'TACNA',183,-18.0019,-70.2519),(1780,'ALTO DE LA ALIANZA',183,-17.9931,-70.2478),(1781,'CALANA',183,-17.9433,-70.1883),(1782,'CIUDAD NUEVA',183,-17.9819,-70.2381),(1783,'INCLAN',183,-17.7939,-70.4947),(1784,'PACHIA',183,-17.8964,-70.1539),(1785,'PALCA',183,-17.7783,-69.9597),(1786,'POCOLLAY',183,-17.9967,-70.2258),(1787,'SAMA',183,-18.2861,-70.4392),(1788,'CORONEL GREGORIO ALBARRACIN LANCHIPA',183,0,0),(1789,'CANDARAVE',184,-17.2681,-70.2503),(1790,'CAIRANI',184,-17.2853,-70.3636),(1791,'CAMILACA',184,-17.2425,-70.3881),(1792,'CURIBAYA',184,-17.3814,-70.3347),(1793,'HUANUARA',184,-17.3136,-70.3225),(1794,'QUILAHUANI',184,-17.3183,-70.2586),(1795,'LOCUMBA',185,-17.6139,-70.7628),(1796,'ILABAYA',185,-17.4181,-70.5131),(1797,'ITE',185,-17.8617,-70.9658),(1798,'TARATA',186,-17.475,-70.0319),(1799,'CHUCATAMANI',186,-17.4806,-70.1231),(1800,'ESTIQUE',186,-17.5419,-70.0183),(1801,'ESTIQUE-PAMPA',186,-17.5386,-70.0314),(1802,'SITAJARA',186,-17.3753,-70.1339),(1803,'SUSAPAYA',186,-17.3481,-70.1336),(1804,'TARUCACHI',186,-17.5258,-70.0317),(1805,'TICACO',186,-17.4472,-70.0467),(1806,'TUMBES',187,-3.5711,-80.4592),(1807,'CORRALES',187,-3.6014,-80.4806),(1808,'LA CRUZ',187,-3.6372,-80.59),(1809,'PAMPAS DE HOSPITAL',187,-3.6933,-80.4392),(1810,'SAN JACINTO',187,-3.6408,-80.4453),(1811,'SAN JUAN DE LA VIRGEN',187,-3.6278,-80.4336),(1812,'ZORRITOS',188,-3.6775,-80.6681),(1813,'CASITAS',188,-3.9506,-80.94),(1814,'ZARUMILLA',189,-3.5011,-80.2756),(1815,'AGUAS VERDES',189,-3.4817,-80.245),(1816,'MATAPALO',189,-3.6822,-80.1997),(1817,'PAPAYAL',189,-3.5714,-80.235),(1818,'CALLERIA',190,-8.3681,-74.5433),(1819,'CAMPOVERDE',190,-8.4719,-74.8053),(1820,'IPARIA',190,-9.3061,-74.4356),(1821,'MASISEA',190,-8.6047,-74.3061),(1822,'YARINACOCHA',190,-8.3556,-74.5758),(1823,'NUEVA REQUENA',190,-8.4003,-74.5414),(1824,'RAYMONDI',191,-10.7297,-73.7553),(1825,'SEPAHUA',191,-11.1372,-73.0456),(1826,'TAHUANIA',191,-10.0306,-73.9564),(1827,'YURUA',191,-9.5314,-72.76),(1828,'PADRE ABAD',192,-9.0336,-75.5075),(1829,'IRAZOLA',192,-8.8286,-75.2133),(1830,'CURIMANA',192,-8.8275,-75.0508),(1831,'PURUS',193,-9.7722,-70.7097);
/*!40000 ALTER TABLE `ubdistrito` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ubprovincia`
--

DROP TABLE IF EXISTS `ubprovincia`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ubprovincia` (
  `idProv` int(5) NOT NULL DEFAULT 0,
  `provincia` varchar(50) DEFAULT NULL,
  `idDepa` int(5) DEFAULT NULL,
  PRIMARY KEY (`idProv`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ubprovincia`
--

LOCK TABLES `ubprovincia` WRITE;
/*!40000 ALTER TABLE `ubprovincia` DISABLE KEYS */;
INSERT INTO `ubprovincia` (`idProv`, `provincia`, `idDepa`) VALUES (1,'CHACHAPOYAS ',1),(2,'BAGUA',1),(3,'BONGARA',1),(4,'CONDORCANQUI',1),(5,'LUYA',1),(6,'RODRIGUEZ DE MENDOZA',1),(7,'UTCUBAMBA',1),(8,'HUARAZ',2),(9,'AIJA',2),(10,'ANTONIO RAYMONDI',2),(11,'ASUNCION',2),(12,'BOLOGNESI',2),(13,'CARHUAZ',2),(14,'CARLOS FERMIN FITZCARRALD',2),(15,'CASMA',2),(16,'CORONGO',2),(17,'HUARI',2),(18,'HUARMEY',2),(19,'HUAYLAS',2),(20,'MARISCAL LUZURIAGA',2),(21,'OCROS',2),(22,'PALLASCA',2),(23,'POMABAMBA',2),(24,'RECUAY',2),(25,'SANTA',2),(26,'SIHUAS',2),(27,'YUNGAY',2),(28,'ABANCAY',3),(29,'ANDAHUAYLAS',3),(30,'ANTABAMBA',3),(31,'AYMARAES',3),(32,'COTABAMBAS',3),(33,'CHINCHEROS',3),(34,'GRAU',3),(35,'AREQUIPA',4),(36,'CAMANA',4),(37,'CARAVELI',4),(38,'CASTILLA',4),(39,'CAYLLOMA',4),(40,'CONDESUYOS',4),(41,'ISLAY',4),(42,'LA UNION',4),(43,'HUAMANGA',5),(44,'CANGALLO',5),(45,'HUANCA SANCOS',5),(46,'HUANTA',5),(47,'LA MAR',5),(48,'LUCANAS',5),(49,'PARINACOCHAS',5),(50,'PAUCAR DEL SARA SARA',5),(51,'SUCRE',5),(52,'VICTOR FAJARDO',5),(53,'VILCAS HUAMAN',5),(54,'CAJAMARCA',6),(55,'CAJABAMBA',6),(56,'CELENDIN',6),(57,'CHOTA ',6),(58,'CONTUMAZA',6),(59,'CUTERVO',6),(60,'HUALGAYOC',6),(61,'JAEN',6),(62,'SAN IGNACIO',6),(63,'SAN MARCOS',6),(64,'SAN PABLO',6),(65,'SANTA CRUZ',6),(66,'CALLAO',7),(67,'CUSCO',8),(68,'ACOMAYO',8),(69,'ANTA',8),(70,'CALCA',8),(71,'CANAS',8),(72,'CANCHIS',8),(73,'CHUMBIVILCAS',8),(74,'ESPINAR',8),(75,'LA CONVENCION',8),(76,'PARURO',8),(77,'PAUCARTAMBO',8),(78,'QUISPICANCHI',8),(79,'URUBAMBA',8),(80,'HUANCAVELICA',9),(81,'ACOBAMBA',9),(82,'ANGARAES',9),(83,'CASTROVIRREYNA',9),(84,'CHURCAMPA',9),(85,'HUAYTARA',9),(86,'TAYACAJA',9),(87,'HUANUCO',10),(88,'AMBO',10),(89,'DOS DE MAYO',10),(90,'HUACAYBAMBA',10),(91,'HUAMALIES',10),(92,'LEONCIO PRADO',10),(93,'MARAÑON',10),(94,'PACHITEA',10),(95,'PUERTO INCA',10),(96,'LAURICOCHA',10),(97,'YAROWILCA',10),(98,'ICA',11),(99,'CHINCHA',11),(100,'NAZCA',11),(101,'PALPA',11),(102,'PISCO',11),(103,'HUANCAYO',12),(104,'CONCEPCION',12),(105,'CHANCHAMAYO',12),(106,'JAUJA',12),(107,'JUNIN',12),(108,'SATIPO',12),(109,'TARMA',12),(110,'YAULI',12),(111,'CHUPACA',12),(112,'TRUJILLO',13),(113,'ASCOPE',13),(114,'BOLIVAR',13),(115,'CHEPEN',13),(116,'JULCAN',13),(117,'OTUZCO',13),(118,'PACASMAYO',13),(119,'PATAZ',13),(120,'SANCHEZ CARRION',13),(121,'SANTIAGO DE CHUCO',13),(122,'GRAN CHIMU',13),(123,'VIRU',13),(124,'CHICLAYO',14),(125,'FERREÑAFE',14),(126,'LAMBAYEQUE',14),(127,'LIMA',15),(128,'BARRANCA',15),(129,'CAJATAMBO',15),(130,'CANTA',15),(131,'CAÑETE',15),(132,'HUARAL',15),(133,'HUAROCHIRI',15),(134,'HUAURA',15),(135,'OYON',15),(136,'YAUYOS',15),(137,'MAYNAS',16),(138,'ALTO AMAZONAS',16),(139,'LORETO',16),(140,'MARISCAL RAMON CASTILLA',16),(141,'REQUENA',16),(142,'UCAYALI',16),(143,'TAMBOPATA',17),(144,'MANU',17),(145,'TAHUAMANU',17),(146,'MARISCAL NIETO',18),(147,'GENERAL SANCHEZ CERRO',18),(148,'ILO',18),(149,'PASCO',19),(150,'DANIEL ALCIDES CARRION',19),(151,'OXAPAMPA',19),(152,'PIURA',20),(153,'AYABACA',20),(154,'HUANCABAMBA',20),(155,'MORROPON',20),(156,'PAITA',20),(157,'SULLANA',20),(158,'TALARA',20),(159,'SECHURA',20),(160,'PUNO',21),(161,'AZANGARO',21),(162,'CARABAYA',21),(163,'CHUCUITO',21),(164,'EL COLLAO',21),(165,'HUANCANE',21),(166,'LAMPA',21),(167,'MELGAR',21),(168,'MOHO',21),(169,'SAN ANTONIO DE PUTINA',21),(170,'SAN ROMAN',21),(171,'SANDIA',21),(172,'YUNGUYO',21),(173,'MOYOBAMBA',22),(174,'BELLAVISTA',22),(175,'EL DORADO',22),(176,'HUALLAGA',22),(177,'LAMAS',22),(178,'MARISCAL CACERES',22),(179,'PICOTA',22),(180,'RIOJA',22),(181,'SAN MARTIN',22),(182,'TOCACHE',22),(183,'TACNA',23),(184,'CANDARAVE',23),(185,'JORGE BASADRE',23),(186,'TARATA',23),(187,'TUMBES',24),(188,'CONTRALMIRANTE VILLAR',24),(189,'ZARUMILLA',24),(190,'CORONEL PORTILLO',25),(191,'ATALAYA',25),(192,'PADRE ABAD',25),(193,'PURUS',25),(194,'PACUCHA',3);
/*!40000 ALTER TABLE `ubprovincia` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `unidades_medida`
--

DROP TABLE IF EXISTS `unidades_medida`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `unidades_medida` (
  `unimed_codi` int(11) NOT NULL AUTO_INCREMENT,
  `unimed_nombre` varchar(200) NOT NULL DEFAULT '',
  `unimed_estado` int(11) NOT NULL DEFAULT 1,
  `unimed_abreviatura` varchar(45) DEFAULT NULL,
  `unimed_usu_crea` varchar(45) DEFAULT NULL,
  `unimed_usu_modifica` varchar(45) DEFAULT NULL,
  `unimed_usu_activa` varchar(45) DEFAULT NULL,
  `unimed_sunat` varchar(245) DEFAULT NULL,
  `unimed_cantidad_unidad` float NOT NULL DEFAULT 1,
  PRIMARY KEY (`unimed_codi`),
  UNIQUE KEY `Index_unimed_nombre` (`unimed_nombre`),
  KEY `Index_unimed_estado` (`unimed_estado`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `unidades_medida`
--

LOCK TABLES `unidades_medida` WRITE;
/*!40000 ALTER TABLE `unidades_medida` DISABLE KEYS */;
INSERT INTO `unidades_medida` (`unimed_codi`, `unimed_nombre`, `unimed_estado`, `unimed_abreviatura`, `unimed_usu_crea`, `unimed_usu_modifica`, `unimed_usu_activa`, `unimed_sunat`, `unimed_cantidad_unidad`) VALUES (1,'UNIDAD',1,NULL,NULL,NULL,NULL,'NIU',1),(2,'DOCENA',1,NULL,NULL,NULL,NULL,'DZN',12),(3,'KILOGRAMO',1,NULL,NULL,NULL,NULL,'KGM',1),(4,'1/2 KILO',1,NULL,NULL,NULL,NULL,'KGM',0.5),(5,'1/4 KILO',1,NULL,NULL,NULL,NULL,'KGM',0.25),(6,'CAJA X 6',1,NULL,NULL,NULL,NULL,'NIU',6),(7,'5 KILOS',1,NULL,NULL,NULL,NULL,'KGM',5),(8,'50 KILOS',1,NULL,NULL,NULL,NULL,'KGM',50),(9,'1/2 UNIDAD',1,NULL,NULL,NULL,NULL,'NIU',0.5),(10,'1/4 UNIDAD',1,NULL,NULL,NULL,NULL,'NIU',0.25),(11,'1/8 UNIDAD',1,NULL,NULL,NULL,NULL,'NIU',0.125),(12,'LITRO',1,NULL,NULL,NULL,NULL,'LTR',1),(13,'1/2 LITRO',1,NULL,NULL,NULL,NULL,'LTR',0.5),(14,'2 LITROS',1,NULL,NULL,NULL,NULL,'LTR',2),(15,'1/2 DOCENA',1,NULL,NULL,NULL,NULL,'NIU',6),(22,'PACK-2',1,NULL,NULL,NULL,NULL,'NIU',2);
/*!40000 ALTER TABLE `unidades_medida` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `usuarios`
--

DROP TABLE IF EXISTS `usuarios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `usuarios` (
  `usu_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `usu_nombre` varchar(145) NOT NULL DEFAULT '',
  `usu_clave` varchar(245) NOT NULL DEFAULT '',
  `espcom_codi_fk` int(10) unsigned DEFAULT NULL,
  `emp_codi_fk` int(10) unsigned DEFAULT NULL,
  `usu_estado` int(10) unsigned NOT NULL DEFAULT 0,
  `usu_fechahora_registro` datetime DEFAULT NULL,
  `usu_fechahora_ultima` datetime DEFAULT NULL,
  `usu_token` varchar(245) DEFAULT NULL,
  `usu_tipo` int(10) unsigned DEFAULT NULL,
  `usu_usu_codi_crea` int(10) unsigned DEFAULT NULL,
  `usu_usu_codi_modifica` int(10) unsigned DEFAULT NULL,
  `usu_vectorfacial` text DEFAULT NULL,
  `usu_deteccionfacial` int(10) unsigned NOT NULL DEFAULT 0,
  `usu_editarpreciosenventas` int(10) unsigned NOT NULL DEFAULT 0,
  `usu_registrarcobranzasenventas` int(10) unsigned NOT NULL DEFAULT 0,
  `usu_veroperacionesdeotrosusuarios` int(10) unsigned NOT NULL DEFAULT 0,
  `usu_veroperacionesdeotrassucursales` int(10) unsigned NOT NULL DEFAULT 0,
  `usu_verpreciosdeotrassucursales` int(10) unsigned NOT NULL DEFAULT 0,
  `usu_verstockdeotrassucursales` int(10) unsigned NOT NULL DEFAULT 0,
  `usu_veroperacionesdeotrasfechas` int(10) unsigned NOT NULL DEFAULT 0,
  `usu_registrarsalidaalmacensenventas` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`usu_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `usuarios`
--

LOCK TABLES `usuarios` WRITE;
/*!40000 ALTER TABLE `usuarios` DISABLE KEYS */;
INSERT INTO `usuarios` (`usu_codi`, `usu_nombre`, `usu_clave`, `espcom_codi_fk`, `emp_codi_fk`, `usu_estado`, `usu_fechahora_registro`, `usu_fechahora_ultima`, `usu_token`, `usu_tipo`, `usu_usu_codi_crea`, `usu_usu_codi_modifica`, `usu_vectorfacial`, `usu_deteccionfacial`, `usu_editarpreciosenventas`, `usu_registrarcobranzasenventas`, `usu_veroperacionesdeotrosusuarios`, `usu_veroperacionesdeotrassucursales`, `usu_verpreciosdeotrassucursales`, `usu_verstockdeotrassucursales`, `usu_veroperacionesdeotrasfechas`, `usu_registrarsalidaalmacensenventas`) VALUES (2,'ETORRES','a43c27c2babefd68df8a694900f30a1c',3,1,1,NULL,NULL,'987654321',1,NULL,0,NULL,1,1,1,1,1,0,1,1,1),(9,'CTORRES','3f7caa3d471688b704b73e9a77b1107f',24,1,1,NULL,NULL,'17205797776690202869',1,2,NULL,NULL,1,0,0,0,0,0,0,0,0),(10,'EBOTELLO','3f7caa3d471688b704b73e9a77b1107f',25,1,1,NULL,NULL,'17224641078673275902',1,2,NULL,NULL,1,1,1,1,1,0,1,1,1),(11,'NFARFAN','3f7caa3d471688b704b73e9a77b1107f',26,1,1,NULL,NULL,'17229770732753588781',1,10,0,NULL,0,1,1,1,1,0,1,1,1);
/*!40000 ALTER TABLE `usuarios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `usuarios_modulos`
--

DROP TABLE IF EXISTS `usuarios_modulos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `usuarios_modulos` (
  `usumod_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `usu_codi_fk` int(10) unsigned DEFAULT NULL,
  `mod_codi_fk` int(10) unsigned DEFAULT NULL,
  `usumod_crear` int(10) unsigned NOT NULL DEFAULT 0,
  `usumod_modificar` int(10) unsigned NOT NULL DEFAULT 0,
  `usumod_eliminar` int(10) unsigned NOT NULL DEFAULT 0,
  `usumod_fotos` int(10) unsigned NOT NULL DEFAULT 0,
  `usumod_activar` int(10) unsigned NOT NULL DEFAULT 0,
  `usumod_estado` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`usumod_codi`)
) ENGINE=InnoDB AUTO_INCREMENT=388 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `usuarios_modulos`
--

LOCK TABLES `usuarios_modulos` WRITE;
/*!40000 ALTER TABLE `usuarios_modulos` DISABLE KEYS */;
INSERT INTO `usuarios_modulos` (`usumod_codi`, `usu_codi_fk`, `mod_codi_fk`, `usumod_crear`, `usumod_modificar`, `usumod_eliminar`, `usumod_fotos`, `usumod_activar`, `usumod_estado`) VALUES (1,2,35,1,1,1,1,1,1),(2,2,1,1,1,1,1,1,1),(3,2,2,1,1,1,1,1,1),(4,2,3,1,1,1,1,1,1),(5,2,4,1,1,1,1,1,1),(6,2,5,1,1,1,1,1,1),(7,2,6,1,1,1,1,1,1),(8,2,7,1,1,1,1,1,1),(9,2,8,1,1,1,1,1,1),(10,2,9,1,1,1,1,1,1),(11,2,10,1,1,1,1,1,1),(12,2,11,1,1,1,1,1,1),(13,2,12,1,1,1,1,1,1),(14,2,13,1,1,1,1,1,1),(15,2,14,1,1,1,1,1,1),(16,2,15,1,1,1,1,1,1),(17,2,16,1,1,1,1,1,1),(18,2,17,1,1,1,1,1,1),(19,2,18,1,1,1,1,1,1),(20,2,19,1,1,1,1,1,1),(21,2,20,1,1,1,1,1,1),(22,2,21,1,1,1,1,1,1),(23,2,22,1,1,1,1,1,1),(24,2,23,1,1,1,1,1,1),(25,2,24,1,1,1,1,1,1),(26,2,25,1,1,1,1,1,1),(27,2,26,1,1,1,1,1,1),(28,2,27,1,1,1,1,1,1),(29,2,28,1,1,1,1,1,1),(30,2,29,1,1,1,1,1,1),(31,2,30,1,1,1,1,1,1),(32,2,31,1,1,1,1,1,1),(33,2,32,1,1,1,1,1,1),(34,2,33,1,1,1,1,1,1),(35,2,34,1,1,1,1,1,1),(36,2,36,1,1,1,1,1,1),(73,2,37,0,1,0,0,0,1),(74,2,38,1,1,1,1,1,1),(75,2,39,1,1,1,1,1,1),(76,2,40,1,1,1,1,1,1),(77,2,41,1,1,1,1,1,1),(78,2,42,1,1,1,1,1,1),(79,2,43,1,1,1,1,1,1),(80,2,44,1,1,1,1,1,1),(81,2,45,1,1,1,1,1,1),(127,2,47,1,1,1,1,1,1),(128,2,48,1,1,1,1,1,1),(129,2,49,1,1,1,1,1,1),(130,2,50,1,1,1,1,1,1),(131,2,51,0,0,0,0,0,0),(232,9,1,1,1,1,1,1,1),(233,9,2,0,0,0,0,0,0),(234,9,3,0,0,0,0,0,0),(235,9,4,0,0,0,0,0,0),(236,9,5,0,0,0,0,0,0),(237,9,6,1,1,1,1,1,1),(238,9,7,0,0,0,0,0,0),(239,9,8,0,0,0,0,0,0),(240,9,9,0,0,0,0,0,0),(241,9,10,0,0,0,0,0,0),(242,9,11,0,0,0,0,0,0),(243,9,12,0,0,0,0,0,0),(244,9,13,0,0,0,0,0,0),(245,9,14,0,0,0,0,0,0),(246,9,15,0,0,0,0,0,0),(247,9,16,0,0,0,0,0,0),(248,9,17,0,0,0,0,0,0),(249,9,18,0,0,0,0,0,0),(250,9,19,0,0,0,0,0,0),(251,9,20,0,0,0,0,0,0),(252,9,21,0,0,0,0,0,0),(253,9,22,0,0,0,0,0,0),(254,9,23,0,0,0,0,0,0),(255,9,24,1,1,1,1,1,1),(256,9,25,0,0,0,0,0,0),(257,9,26,0,0,0,0,0,0),(258,9,27,0,0,0,0,0,0),(259,9,28,0,0,0,0,0,0),(260,9,29,0,0,0,0,0,0),(261,9,30,0,0,0,0,0,0),(262,9,31,0,0,0,0,0,0),(263,9,32,0,0,0,0,0,0),(264,9,33,0,0,0,0,0,0),(265,9,34,0,0,0,0,0,0),(266,9,35,0,0,0,0,0,0),(267,9,36,0,0,0,0,0,0),(268,9,37,0,0,0,0,0,0),(269,9,38,0,0,0,0,0,0),(270,9,39,0,0,0,0,0,0),(271,9,40,0,0,0,0,0,0),(272,9,41,0,0,0,0,0,0),(273,9,42,0,0,0,0,0,0),(274,9,43,0,0,0,0,0,0),(275,9,44,0,0,0,0,0,0),(276,9,45,0,0,0,0,0,0),(277,9,47,0,0,0,0,0,0),(278,9,48,0,0,0,0,0,0),(279,9,49,0,0,0,0,0,0),(280,9,50,0,0,0,0,0,0),(281,9,51,0,0,0,0,0,0),(282,2,52,1,1,1,1,1,1),(283,2,53,1,1,1,1,1,1),(284,10,1,1,1,1,1,1,1),(285,10,2,1,1,1,1,1,1),(286,10,3,1,1,1,1,1,1),(287,10,4,1,1,1,1,1,1),(288,10,5,1,1,1,1,1,1),(289,10,6,1,1,1,1,1,1),(290,10,7,1,1,1,1,1,1),(291,10,8,1,1,1,1,1,1),(292,10,9,1,1,1,1,1,1),(293,10,10,1,1,1,1,1,1),(294,10,11,1,1,1,1,1,1),(295,10,12,1,1,1,1,1,1),(296,10,13,1,1,1,1,1,1),(297,10,14,1,1,1,1,1,1),(298,10,15,1,1,1,1,1,1),(299,10,16,1,1,1,1,1,1),(300,10,17,1,1,1,1,1,1),(301,10,18,1,1,1,1,1,1),(302,10,19,1,1,1,1,1,1),(303,10,20,1,1,1,1,1,1),(304,10,21,1,1,1,1,1,1),(305,10,22,1,1,1,1,1,1),(306,10,23,1,1,1,1,1,1),(307,10,24,1,1,1,1,1,1),(308,10,25,1,1,1,1,1,1),(309,10,26,1,1,1,1,1,1),(310,10,27,1,1,1,1,1,1),(311,10,28,1,1,1,1,1,1),(312,10,29,0,0,0,0,0,0),(313,10,30,1,1,1,1,1,1),(314,10,31,1,1,1,1,1,1),(315,10,32,1,1,1,1,1,1),(316,10,33,1,1,1,1,1,1),(317,10,34,1,1,1,1,1,1),(318,10,35,1,1,1,1,1,1),(319,10,36,1,1,1,1,1,1),(320,10,37,1,1,1,1,1,1),(321,10,38,1,1,1,1,1,1),(322,10,39,1,1,1,1,1,1),(323,10,40,1,1,1,1,1,1),(324,10,41,1,1,1,1,1,1),(325,10,42,1,1,1,1,1,1),(326,10,43,1,1,1,1,1,1),(327,10,44,1,1,1,1,1,1),(328,10,45,1,1,1,1,1,1),(329,10,47,1,1,1,1,1,1),(330,10,48,1,1,1,1,1,1),(331,10,49,1,1,1,1,1,1),(332,10,50,1,1,1,1,1,1),(333,10,51,0,0,0,0,0,0),(334,10,52,1,1,1,1,1,1),(335,10,53,1,1,1,1,1,1),(336,11,1,1,1,1,1,1,1),(337,11,2,1,1,1,1,1,1),(338,11,3,1,1,1,1,1,1),(339,11,4,1,1,1,1,1,1),(340,11,5,1,1,1,1,1,1),(341,11,6,1,1,1,1,1,1),(342,11,7,1,1,1,1,1,1),(343,11,8,1,1,1,1,1,1),(344,11,9,1,1,1,1,1,1),(345,11,10,1,1,1,1,1,1),(346,11,11,1,1,1,1,1,1),(347,11,12,1,1,1,1,1,1),(348,11,13,1,1,1,1,1,1),(349,11,14,1,1,1,1,1,1),(350,11,15,1,1,1,1,1,1),(351,11,16,1,1,1,1,1,1),(352,11,17,1,1,1,1,1,1),(353,11,18,1,1,1,1,1,1),(354,11,19,1,1,1,1,1,1),(355,11,20,1,1,1,1,1,1),(356,11,21,1,1,1,1,1,1),(357,11,22,1,1,1,1,1,1),(358,11,23,1,1,1,1,1,1),(359,11,24,1,1,1,1,1,1),(360,11,25,1,1,1,1,1,1),(361,11,26,1,1,1,1,1,1),(362,11,27,1,1,1,1,1,1),(363,11,28,1,1,1,1,1,1),(364,11,29,0,0,0,0,0,0),(365,11,30,1,1,1,1,1,1),(366,11,31,1,1,1,1,1,1),(367,11,32,1,1,1,1,1,1),(368,11,33,1,1,1,1,1,1),(369,11,34,1,1,1,1,1,1),(370,11,35,1,1,1,1,1,1),(371,11,36,1,1,1,1,1,1),(372,11,37,1,1,1,1,1,1),(373,11,38,1,1,1,1,1,1),(374,11,39,1,1,1,1,1,1),(375,11,40,1,1,1,1,1,1),(376,11,41,1,1,1,1,1,1),(377,11,42,1,1,1,1,1,1),(378,11,43,1,1,1,1,1,1),(379,11,44,1,1,1,1,1,1),(380,11,45,1,1,1,1,1,1),(381,11,47,1,1,1,1,1,1),(382,11,48,1,1,1,1,1,1),(383,11,49,1,1,1,1,1,1),(384,11,50,1,1,1,1,1,1),(385,11,51,0,0,0,0,0,0),(386,11,52,1,1,1,1,1,1),(387,11,53,1,1,1,1,1,1);
/*!40000 ALTER TABLE `usuarios_modulos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `vehiculos`
--

DROP TABLE IF EXISTS `vehiculos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `vehiculos` (
  `veh_codi` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `veh_placa` varchar(200) NOT NULL DEFAULT '',
  `veh_marca` varchar(200) NOT NULL DEFAULT '',
  `veh_modelo` varchar(200) NOT NULL DEFAULT '',
  `veh_ano` varchar(145) NOT NULL DEFAULT '',
  `veh_color` varchar(145) NOT NULL DEFAULT '',
  `veh_peso_bruto` float NOT NULL DEFAULT 0,
  `veh_peso_neto` float NOT NULL DEFAULT 0,
  `veh_carga_util` float NOT NULL DEFAULT 0,
  `veh_largo` float NOT NULL DEFAULT 0,
  `veh_alto` float NOT NULL DEFAULT 0,
  `veh_ancho` float NOT NULL DEFAULT 0,
  `veh_usu_crea` varchar(45) NOT NULL DEFAULT '',
  `veh_usu_modifica` varchar(45) NOT NULL DEFAULT '',
  `veh_usu_activa` varchar(45) NOT NULL DEFAULT '',
  `veh_estado` int(10) unsigned NOT NULL DEFAULT 0,
  `traemp_codi_fk` int(10) unsigned NOT NULL DEFAULT 0,
  `veh_certificado` varchar(145) DEFAULT NULL,
  PRIMARY KEY (`veh_codi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `vehiculos`
--

LOCK TABLES `vehiculos` WRITE;
/*!40000 ALTER TABLE `vehiculos` DISABLE KEYS */;
/*!40000 ALTER TABLE `vehiculos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping events for database 'comercialaliazione'
--

--
-- Dumping routines for database 'comercialaliazione'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-10-04  7:07:33
