<?php

// Funcin mod, regresa el residuo de una divisin
function mod($dividendo, $divisor) {
    $resDiv = $dividendo / $divisor;
    $parteEnt = floor($resDiv); // Obtiene la parte Entera de resDiv
    $parteFrac = $resDiv - $parteEnt; // Obtiene la parte Fraccionaria de la divisin
    $modulo = round($parteFrac * $divisor);
    return $modulo;
}

// Funcin ObtenerParteEntDiv, regresa la parte entera de una divisin
function ObtenerParteEntDiv($dividendo, $divisor) {
    $resDiv = $dividendo / $divisor;
    $parteEntDiv = floor($resDiv);
    return $parteEntDiv;
}

// function string_literal_conversion es el ncleo del programa
// convierte nmeros a cadenas en espaol
function string_literal_conversion($number) {
    $centenas = ObtenerParteEntDiv($number, 100);
    $number = mod($number, 100);

    $decenas = ObtenerParteEntDiv($number, 10);
    $number = mod($number, 10);

    $unidades = ObtenerParteEntDiv($number, 1);
    $number = mod($number, 1);

    $string_hundreds = "";
    $string_tens = "";
    $string_units = "";

    // switch para centenas
    switch ($centenas) {
        case 1:
            $string_hundreds = "ciento ";
            break;
        case 2:
            $string_hundreds = "doscientos ";
            break;
        case 3:
            $string_hundreds = "trescientos ";
            break;
        case 4:
            $string_hundreds = "cuatrocientos ";
            break;
        case 5:
            $string_hundreds = "quinientos ";
            break;
        case 6:
            $string_hundreds = "seiscientos ";
            break;
        case 7:
            $string_hundreds = "setecientos ";
            break;
        case 8:
            $string_hundreds = "ochocientos ";
            break;
        case 9:
            $string_hundreds = "novecientos ";
            break;
    }

    // switch para decenas
    if ($decenas == 1) {
        switch ($unidades) {
            case 1:
                $string_tens = "once";
                break;
            case 2:
                $string_tens = "doce";
                break;
            case 3:
                $string_tens = "trece";
                break;
            case 4:
                $string_tens = "catorce";
                break;
            case 5:
                $string_tens = "quince";
                break;
            case 6:
                $string_tens = "dieciseis";
                break;
            case 7:
                $string_tens = "diecisiete";
                break;
            case 8:
                $string_tens = "dieciocho";
                break;
            case 9:
                $string_tens = "diecinueve";
                break;
        }
    } else {
        switch ($decenas) {
            case 2:
                $string_tens = "veinti";
                break;
            case 3:
                $string_tens = "treinta ";
                break;
            case 4:
                $string_tens = "cuarenta ";
                break;
            case 5:
                $string_tens = "cincuenta ";
                break;
            case 6:
                $string_tens = "sesenta ";
                break;
            case 7:
                $string_tens = "setenta ";
                break;
            case 8:
                $string_tens = "ochenta ";
                break;
            case 9:
                $string_tens = "noventa ";
                break;
        }
    }

    // switch para unidades
    switch ($unidades) {
        case 1:
            $string_units = "un";
            break;
        case 2:
            $string_units = "dos";
            break;
        case 3:
            $string_units = "tres";
            break;
        case 4:
            $string_units = "cuatro";
            break;
        case 5:
            $string_units = "cinco";
            break;
        case 6:
            $string_units = "seis";
            break;
        case 7:
            $string_units = "siete";
            break;
        case 8:
            $string_units = "ocho";
            break;
        case 9:
            $string_units = "nueve";
            break;
    }

    // Manejo de casos especiales
    if ($centenas == 1 && $decenas == 0 && $unidades == 0) {
        $string_hundreds = "cien ";
    }

    if ($decenas == 1 && $unidades == 0) {
        $string_tens = "diez ";
    }

    if ($decenas == 2 && $unidades == 0) {
        $string_tens = "veinte ";
    }

    if ($decenas >= 3 && $unidades >= 1) {
        $string_tens .= "y ";
    }

    $final_string = $string_hundreds . $string_tens . $string_units;

    return $final_string;
}

// Funcin para convertir nmero a letras completas con manejo de decimales
function convertirNumLetras($number) {
    $cent = explode(".", $number);
    $centavos = isset($cent[1]) ? $cent[1] : "00";
    $number = $cent[0];

    if ($number == 0 || $number == "") {
        return "cero";
    }

    $millones = ObtenerParteEntDiv($number, 1000000);
    $number = mod($number, 1000000);

    if ($millones != 0) {
        $descriptor = ($millones == 1) ? " milln " : " millones ";
    } else {
        $descriptor = "";
    }
    $millones_final_string = string_literal_conversion($millones) . $descriptor;

    $miles = ObtenerParteEntDiv($number, 1000);
    $number = mod($number, 1000);

    if ($miles != 1) {
        $thousands_final_string = string_literal_conversion($miles) . " mil ";
    } else {
        $thousands_final_string = " mil ";
    }

    if ($miles < 1) {
        $thousands_final_string = "";
    }

    $centenas = $number;
    $centenas_final_string = string_literal_conversion($centenas);

    $cad = $millones_final_string . $thousands_final_string . $centenas_final_string;
    $cad = mb_strtoupper($cad, 'UTF-8');

    if (strlen($centavos) > 2) {
        if ($centavos[2] >= 5) {
            $centavos = $centavos[0] . ($centavos[1] + 1);
        } else {
            $centavos = $centavos[0];
        }
    }

    if (strlen($centavos) == 1) {
        $centavos = $centavos . "0";
    }

    $moneda = " SOLES ";
	
	$cadenanumero = $cad . " Y " . $centavos ."/100" . $moneda;
	
	$cadenanumero = str_replace('ONCEUN','ONCE', $cadenanumero);	
	$cadenanumero = str_replace('DOCEDOS','DOCE', $cadenanumero);	
	$cadenanumero = str_replace('TRECETRES','TRECE', $cadenanumero);	
	$cadenanumero = str_replace('CATORCECUATRO','CATORCE', $cadenanumero);	
	$cadenanumero = str_replace('QUINCECINCO','QUINCE', $cadenanumero);	
	$cadenanumero = str_replace('DIECISEISSEIS','DIECISEIS', $cadenanumero);	
	$cadenanumero = str_replace('DIECISIETESIETE','DIECISIETE', $cadenanumero);	
	$cadenanumero = str_replace('DIECIOCHOOCHO','DIECIOCHO', $cadenanumero);	
	$cadenanumero = str_replace('DIECINUEVENUEVE','DIECINUEVE', $cadenanumero);	

    //return $cad . " Y " . $centavos . $moneda;
	return trim($cadenanumero);
}

// Ejemplo de uso:
//$numero = 1234567.89;
//$numero = 1421.89;
//echo convertirNumLetras($numero); // imprime "UN MILLN DOSCIENTOS TREINTA Y CUATRO MIL QUINIENTOS SESENTA Y SIETE Y 89/100 SOLES"
?>
