<?php

@include "numerosaletras.php";
@include "signature.php";
@include "../conexion.php";
@include("../constantes.php");
@include("funciones_facturador.php");

$xordped_codi = $_REQUEST['xordped_codi'];

function generarFacturaXML($factura) {
	// Crear el documento XML
	$xml = new DOMDocument('1.0', 'UTF-8');
	$xml->preserveWhiteSpace = false;
	$xml->formatOutput = true;
	$xml->encoding = 'utf-8';
	/*
	$doc = new DOMDocument();
	$doc->preserveWhiteSpace = TRUE;
	$doc->formatOutput = FALSE;
	$doc->encoding = 'utf-8';
	//$doc->encoding = 'ISO-8859-1';
	*/
	
	// Crear el elemento raz <Invoice>
	$invoice = $xml->createElementNS('urn:oasis:names:specification:ubl:schema:xsd:Invoice-2', 'Invoice');
	$invoice->setAttribute('xmlns:xsi', 'http://www.w3.org/2001/XMLSchema-instance'); 
	$invoice->setAttribute('xmlns:xsd', 'http://www.w3.org/2001/XMLSchema');
	$invoice->setAttribute('xmlns:cac', 'urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2');
	$invoice->setAttribute('xmlns:cbc', 'urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2');
	$invoice->setAttribute('xmlns:ccts', 'urn:un:unece:uncefact:documentation:2');							
	$invoice->setAttribute('xmlns:ds', 'http://www.w3.org/2000/09/xmldsig#');
	$invoice->setAttribute('xmlns:ext', 'urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2');
	$invoice->setAttribute('xmlns:qdt', 'urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2');
	$invoice->setAttribute('xmlns:udt', 'urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2');
				   
	$xml->appendChild($invoice);
	
	
	// Agregar los elementos hijos al elemento raz <Invoice>
	$extUBLExtensions = $xml->createElement('ext:UBLExtensions');
	$invoice->appendChild($extUBLExtensions);
	
	$extUBLExtension = $xml->createElement('ext:UBLExtension');
	$extUBLExtensions->appendChild($extUBLExtension);
	
	$extExtensionContent = $xml->createElement('ext:ExtensionContent');
	$extUBLExtension->appendChild($extExtensionContent);
	
	// Agregar otros elementos hijos al elemento raz <Invoice>
	$cbcUBLVersionID = $xml->createElement('cbc:UBLVersionID', '2.1');
	$invoice->appendChild($cbcUBLVersionID);
	
	$cbcCustomizationID = $xml->createElement('cbc:CustomizationID', '2.0');
	$cbcCustomizationID->setAttribute('schemeAgencyName', 'PE:SUNAT');
	$invoice->appendChild($cbcCustomizationID);
	
	$cbcProfileID = $xml->createElement('cbc:ProfileID', '0101');
	$cbcProfileID->setAttribute('schemeName', 'Tipo de Operacion');
	$cbcProfileID->setAttribute('schemeAgencyName', 'PE:SUNAT');
	$cbcProfileID->setAttribute('schemeURI', 'urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo51');
	$invoice->appendChild($cbcProfileID);
	
	//DATOS DEL COMPROBANTE
	$cbcID = $xml->createElement('cbc:ID', $factura['id']);
	$invoice->appendChild($cbcID);
	
	$cbcIssueDate = $xml->createElement('cbc:IssueDate', $factura['fechaEmision']); 
	$invoice->appendChild($cbcIssueDate);
	
	$cbcIssueTime = $xml->createElement('cbc:IssueTime', '00:00:00');
	$invoice->appendChild($cbcIssueTime);
	
	//$cbcDueDate = $xml->createElement('cbc:DueDate', $factura['fechaVencimiento']);
	//$invoice->appendChild($cbcDueDate);
	
	$cbcInvoiceTypeCode = $xml->createElement('cbc:InvoiceTypeCode', $factura['tipoComprobante']); 
	$cbcInvoiceTypeCode->setAttribute('listAgencyName', 'PE:SUNAT');
	$cbcInvoiceTypeCode->setAttribute('listName', 'Tipo de Documento');
	$cbcInvoiceTypeCode->setAttribute('listURI', 'urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo01');
	$cbcInvoiceTypeCode->setAttribute('listID', '0101');
	$cbcInvoiceTypeCode->setAttribute('name', 'Tipo de Operacion');
	$cbcInvoiceTypeCode->setAttribute('listSchemeURI', 'urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo51');
	$invoice->appendChild($cbcInvoiceTypeCode);
	
	$cbcNote = $xml->createElement('cbc:Note', $factura['totalLetras']); 
	$cbcNote->setAttribute('languageLocaleID', '1000');
	$invoice->appendChild($cbcNote);
	
	$cbcDocumentCurrencyCode = $xml->createElement('cbc:DocumentCurrencyCode', 'PEN');
	$cbcDocumentCurrencyCode->setAttribute('listID', 'ISO 4217 Alpha');
	$cbcDocumentCurrencyCode->setAttribute('listName', 'Currency');
	$cbcDocumentCurrencyCode->setAttribute('listAgencyName', 'United Nations Economic Commission for Europe');
	$invoice->appendChild($cbcDocumentCurrencyCode);
	
	$cbcLineCountNumeric = $xml->createElement('cbc:LineCountNumeric', count($factura['detalles']) );
	$invoice->appendChild($cbcLineCountNumeric);
	
	$cacSignature = $xml->createElement('cac:Signature');
	$invoice->appendChild($cacSignature);
	
		$cbcID = $xml->createElement('cbc:ID', $factura['id']);
		$cacSignature->appendChild($cbcID);
		
		$cacSignatoryParty = $xml->createElement('cac:SignatoryParty');
		$cacSignature->appendChild($cacSignatoryParty);
	
			$cacPartyIdentification = $xml->createElement('cac:PartyIdentification');
			$cacSignatoryParty->appendChild($cacPartyIdentification);
			
				$cbcID = $xml->createElement('cbc:ID', $factura['emisor']['ruc']);
				$cacPartyIdentification->appendChild($cbcID);
	
			$cacPartyName = $xml->createElement('cac:PartyName');
			$cacSignatoryParty->appendChild($cacPartyName);			
				
				$emisorNombreEscapado = htmlspecialchars($factura['emisor']['nombre'], ENT_XML1, 'UTF-8');
				$cbcName = $xml->createElement('cbc:Name', $emisorNombreEscapado);
				#$cbcName = $xml->createElement('cbc:Name', $factura['emisor']['nombre']);
				$cacPartyName->appendChild($cbcName);
	
	
		$cacDigitalSignatureAttachment = $xml->createElement('cac:DigitalSignatureAttachment');
		$cacSignature->appendChild($cacDigitalSignatureAttachment);
		
			$cacExternalReference = $xml->createElement('cac:ExternalReference');
			$cacDigitalSignatureAttachment->appendChild($cacExternalReference);
			
				$cbcURI = $xml->createElement('cbc:URI', '#'.$factura['id']);
				$cacExternalReference->appendChild($cbcURI);
	
	//DATOS DE LA EMPRESA
	$cacAccountingSupplierParty = $xml->createElement('cac:AccountingSupplierParty');
	$invoice->appendChild($cacAccountingSupplierParty);
	
		$cacParty = $xml->createElement('cac:Party');
		$cacAccountingSupplierParty->appendChild($cacParty);
	
			$cacPartyIdentification = $xml->createElement('cac:PartyIdentification');
			$cacParty->appendChild($cacPartyIdentification);
				
				$cbcID = $xml->createElement('cbc:ID', $factura['emisor']['ruc']);
				$cbcID->setAttribute('schemeID', $factura['emisor']['tipoDocumentoIdentidad']);
				$cbcID->setAttribute('schemeName', 'Documento de Identidad');
				$cbcID->setAttribute('schemeAgencyName', 'PE:SUNAT');
				$cbcID->setAttribute('schemeURI', 'urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06');
				$cacPartyIdentification->appendChild($cbcID);
	
				$cacPartyName = $xml->createElement('cac:PartyName');
				$cacParty->appendChild($cacPartyName);
				
					$emisorNombreEscapado = htmlspecialchars($factura['emisor']['nombre'], ENT_XML1, 'UTF-8');
					$cbcName = $xml->createElement('cbc:Name', $emisorNombreEscapado);
					#$cbcName = $xml->createElement('cbc:Name', $factura['emisor']['nombre']);
					$cacPartyName->appendChild($cbcName);
	
				$cacPartyTaxScheme = $xml->createElement('cac:PartyTaxScheme');
				$cacParty->appendChild($cacPartyTaxScheme);
				
					$emisorNombreEscapado = htmlspecialchars($factura['emisor']['nombre'], ENT_XML1, 'UTF-8');
					$cbcRegistrationName = $xml->createElement('cbc:RegistrationName', $emisorNombreEscapado);
					#$cbcRegistrationName = $xml->createElement('cbc:RegistrationName', $factura['emisor']['nombre']);
					$cacPartyTaxScheme->appendChild($cbcRegistrationName);
	
					$cbcCompanyID = $xml->createElement('cbc:CompanyID', $factura['emisor']['ruc']);
					$cbcCompanyID->setAttribute('schemeID', $factura['emisor']['tipoDocumentoIdentidad']);
					$cbcCompanyID->setAttribute('schemeName', 'SUNAT:Identificador de Documento de Identidad');
					$cbcCompanyID->setAttribute('schemeAgencyName', 'PE:SUNAT');
					$cbcCompanyID->setAttribute('schemeURI', 'urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06');
					$cacPartyTaxScheme->appendChild($cbcCompanyID);
	
					$cacTaxScheme = $xml->createElement('cac:TaxScheme');
					$cacPartyTaxScheme->appendChild($cacTaxScheme);
					
						$cbcID = $xml->createElement('cbc:ID', $factura['emisor']['ruc']);
						$cbcID->setAttribute('schemeID', $factura['emisor']['tipoDocumentoIdentidad']);
						$cbcID->setAttribute('schemeName', 'SUNAT:Identificador de Documento de Identidad');
						$cbcID->setAttribute('schemeAgencyName', 'PE:SUNAT');
						$cbcID->setAttribute('schemeURI', 'urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06');
						$cacTaxScheme->appendChild($cbcID);
	
				$cacPartyLegalEntity = $xml->createElement('cac:PartyLegalEntity');
				$cacParty->appendChild($cacPartyLegalEntity);
				
					$emisorNombreEscapado = htmlspecialchars($factura['emisor']['nombre'], ENT_XML1, 'UTF-8');
					$cbcRegistrationName = $xml->createElement('cbc:RegistrationName', $emisorNombreEscapado);
					#$cbcRegistrationName = $xml->createElement('cbc:RegistrationName', $factura['emisor']['nombre']);
					$cacPartyLegalEntity->appendChild($cbcRegistrationName);
	
					$cacRegistrationAddress = $xml->createElement('cac:RegistrationAddress');
					$cacPartyLegalEntity->appendChild($cacRegistrationAddress);
					
						$cbcID = $xml->createElement('cbc:ID');
						$cbcID->setAttribute('schemeName', 'Ubigeos');
						$cbcID->setAttribute('schemeAgencyName', 'PE:INEI');
						$cacRegistrationAddress->appendChild($cbcID);
						
						$cbcAddressTypeCode = $xml->createElement('cbc:AddressTypeCode', '0000');
						$cbcAddressTypeCode->setAttribute('listAgencyName', 'PE:SUNAT');
						$cbcAddressTypeCode->setAttribute('listName', 'Establecimientos anexos');
						$cacRegistrationAddress->appendChild($cbcAddressTypeCode);
						
						$cbcCityName = $xml->createElement('cbc:CityName', $factura['emisor']['departamento']);
						$cacRegistrationAddress->appendChild($cbcCityName);
						
						$cbcCountrySubentity = $xml->createElement('cbc:CountrySubentity', $factura['emisor']['provincia']);
						$cacRegistrationAddress->appendChild($cbcCountrySubentity);
						
						$cbcDistrict = $xml->createElement('cbc:District', $factura['emisor']['distrito']);
						$cacRegistrationAddress->appendChild($cbcDistrict);
	
						$cacAddressLine = $xml->createElement('cac:AddressLine');
						$cacRegistrationAddress->appendChild($cacAddressLine);
						
							$cbcLine = $xml->createElement('cbc:Line', $factura['emisor']['direccion']);
							$cacAddressLine->appendChild($cbcLine);
	
						$cacCountry = $xml->createElement('cac:Country');
						$cacRegistrationAddress->appendChild($cacCountry);
						
							$cbcIdentificationCode = $xml->createElement('cbc:IdentificationCode', 'PE');
							$cbcIdentificationCode->setAttribute('listID', 'ISO 3166-1');
							$cbcIdentificationCode->setAttribute('listAgencyName', 'United Nations Economic Commission for Europe');
							$cbcIdentificationCode->setAttribute('listName', 'Country');
							$cacCountry->appendChild($cbcIdentificationCode);
				
				$cacContact = $xml->createElement('cac:Contact');
				$cacParty->appendChild($cacContact);
				
					$cbcName = $xml->createElement('cbc:Name', '');
					$cacContact->appendChild($cbcName);
	
	
	//DATOS DEL CLIENTE
	$cacAccountingCustomerParty = $xml->createElement('cac:AccountingCustomerParty');
	$invoice->appendChild($cacAccountingCustomerParty);
	
		$cacParty = $xml->createElement('cac:Party');
		$cacAccountingCustomerParty->appendChild($cacParty);
	
			$cacPartyIdentification = $xml->createElement('cac:PartyIdentification');
			$cacParty->appendChild($cacPartyIdentification);
				
				$cbcID = $xml->createElement('cbc:ID', $factura['receptor']['ruc']);
				$cbcID->setAttribute('schemeID', $factura['receptor']['tipoDocumentoIdentidad']);
				$cbcID->setAttribute('schemeName', 'Documento de Identidad');
				$cbcID->setAttribute('schemeAgencyName', 'PE:SUNAT');
				$cbcID->setAttribute('schemeURI', 'urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06');
				$cacPartyIdentification->appendChild($cbcID);
	
				$cacPartyName = $xml->createElement('cac:PartyName');
				$cacParty->appendChild($cacPartyName);
				
					$receptorNombreEscapado = htmlspecialchars($factura['receptor']['nombre'], ENT_XML1, 'UTF-8');
					$cbcName = $xml->createElement('cbc:Name', $receptorNombreEscapado);
					#$cbcName = $xml->createElement('cbc:Name', $factura['receptor']['nombre']);
					$cacPartyName->appendChild($cbcName);
					
				$cacPartyTaxScheme = $xml->createElement('cac:PartyTaxScheme');
				$cacParty->appendChild($cacPartyTaxScheme);
				
					$receptorNombreEscapado = htmlspecialchars($factura['receptor']['nombre'], ENT_XML1, 'UTF-8');
					$cbcRegistrationName = $xml->createElement('cbc:RegistrationName', receptorNombreEscapado);				
					#$cbcRegistrationName = $xml->createElement('cbc:RegistrationName', $factura['receptor']['nombre']);
					$cacPartyTaxScheme->appendChild($cbcRegistrationName);
	
					$cbcCompanyID = $xml->createElement('cbc:CompanyID', $factura['receptor']['ruc']);
					$cbcCompanyID->setAttribute('schemeID', $factura['receptor']['tipoDocumentoIdentidad']);
					$cbcCompanyID->setAttribute('schemeName', 'SUNAT:Identificador de Documento de Identidad');
					$cbcCompanyID->setAttribute('schemeAgencyName', 'PE:SUNAT');
					$cbcCompanyID->setAttribute('schemeURI', 'urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06');
					$cacPartyTaxScheme->appendChild($cbcCompanyID);
	
					$cacTaxScheme = $xml->createElement('cac:TaxScheme');
					$cacPartyTaxScheme->appendChild($cacTaxScheme);
					
						$cbcID = $xml->createElement('cbc:ID', $factura['receptor']['ruc']);
						$cbcID->setAttribute('schemeID', $factura['receptor']['tipoDocumentoIdentidad']);
						$cbcID->setAttribute('schemeName', 'SUNAT:Identificador de Documento de Identidad');
						$cbcID->setAttribute('schemeAgencyName', 'PE:SUNAT');
						$cbcID->setAttribute('schemeURI', 'urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06');
						$cacTaxScheme->appendChild($cbcID);				
	
	
				$cacPartyLegalEntity = $xml->createElement('cac:PartyLegalEntity');
				$cacParty->appendChild($cacPartyLegalEntity);
				
					$receptorNombreEscapado = htmlspecialchars($factura['receptor']['nombre'], ENT_XML1, 'UTF-8');
					$cbcRegistrationName = $xml->createElement('cbc:RegistrationName', receptorNombreEscapado);
					#$cbcRegistrationName = $xml->createElement('cbc:RegistrationName', $factura['receptor']['nombre']);
					$cacPartyLegalEntity->appendChild($cbcRegistrationName);
	
					$cacRegistrationAddress = $xml->createElement('cac:RegistrationAddress');
					$cacPartyLegalEntity->appendChild($cacRegistrationAddress);
					
						$cbcID = $xml->createElement('cbc:ID');
						$cbcID->setAttribute('schemeName', 'Ubigeos');
						$cbcID->setAttribute('schemeAgencyName', 'PE:INEI');
						$cacRegistrationAddress->appendChild($cbcID);
						
						$cbcCityName = $xml->createElement('cbc:CityName', $factura['receptor']['departamento']);
						$cacRegistrationAddress->appendChild($cbcCityName);
						
						$cbcCountrySubentity = $xml->createElement('cbc:CountrySubentity', $factura['receptor']['provincia']);
						$cacRegistrationAddress->appendChild($cbcCountrySubentity);
						
						$cbcDistrict = $xml->createElement('cbc:District', $factura['receptor']['distrito']);
						$cacRegistrationAddress->appendChild($cbcDistrict);
	
						$cacAddressLine = $xml->createElement('cac:AddressLine');
						$cacRegistrationAddress->appendChild($cacAddressLine);
						
							$cbcLine = $xml->createElement('cbc:Line', $factura['receptor']['direccion']);
							$cacAddressLine->appendChild($cbcLine);
	
						$cacCountry = $xml->createElement('cac:Country');
						$cacRegistrationAddress->appendChild($cacCountry);
						
							$cbcIdentificationCode = $xml->createElement('cbc:IdentificationCode', 'PE');
							$cbcIdentificationCode->setAttribute('listID', 'ISO 3166-1');
							$cbcIdentificationCode->setAttribute('listAgencyName', 'United Nations Economic Commission for Europe');
							$cbcIdentificationCode->setAttribute('listName', 'Country');
							$cacCountry->appendChild($cbcIdentificationCode);
		
	if ($factura["tipoPago"] != 2) {
		//VENTA CONTADO
		$cacPaymentTerms = $xml->createElement('cac:PaymentTerms');
		$invoice->appendChild($cacPaymentTerms);
		
			$cbcID = $xml->createElement('cbc:ID', 'FormaPago');
			$cacPaymentTerms->appendChild($cbcID);
		
			$cbcPaymentMeansID = $xml->createElement('cbc:PaymentMeansID', 'Contado');
			$cacPaymentTerms->appendChild($cbcPaymentMeansID);
	}else{	
		//VENTA CREDITO	
		$cacPaymentTerms = $xml->createElement('cac:PaymentTerms');
		$invoice->appendChild($cacPaymentTerms);
		
			$cbcID = $xml->createElement('cbc:ID', 'FormaPago');
			$cacPaymentTerms->appendChild($cbcID);
		
			$cbcPaymentMeansID = $xml->createElement('cbc:PaymentMeansID', 'Credito');
			$cacPaymentTerms->appendChild($cbcPaymentMeansID);	
			
			$cbcAmount = $xml->createElement('cbc:Amount', $factura['total']);
			$cbcAmount->setAttribute('currencyID', 'PEN');
			$cacPaymentTerms->appendChild($cbcAmount);	
			
		$cacPaymentTerms = $xml->createElement('cac:PaymentTerms');
		$invoice->appendChild($cacPaymentTerms);
		
			$cbcID = $xml->createElement('cbc:ID', 'FormaPago');
			$cacPaymentTerms->appendChild($cbcID);
		
			$cbcPaymentMeansID = $xml->createElement('cbc:PaymentMeansID', 'Cuota001');
			$cacPaymentTerms->appendChild($cbcPaymentMeansID);	
			
			$cbcAmount = $xml->createElement('cbc:Amount', $factura['total']);
			$cbcAmount->setAttribute('currencyID', 'PEN');
			$cacPaymentTerms->appendChild($cbcAmount);		
			
			$cbcPaymentDueDate = $xml->createElement('cbc:PaymentDueDate', $factura['fechaVencimiento']);
			//$cbcPaymentDueDate->setAttribute('currencyID', 'PEN');
			$cacPaymentTerms->appendChild($cbcPaymentDueDate);		
			
	}	
		
	
	$cacTaxTotal = $xml->createElement('cac:TaxTotal');
	$invoice->appendChild($cacTaxTotal);
	
		$cbcTaxAmount = $xml->createElement('cbc:TaxAmount', $factura['montoIgv']);
		$cbcTaxAmount->setAttribute('currencyID', 'PEN');
		$cacTaxTotal->appendChild($cbcTaxAmount);
	
	//INICIO IGV Y EXONERADO
	//if($factura['montoAfectadoIgv'] > 0){
		$cacTaxSubtotal = $xml->createElement('cac:TaxSubtotal');
		$cacTaxTotal->appendChild($cacTaxSubtotal);
			
			$cbcTaxableAmount = $xml->createElement('cbc:TaxableAmount', $factura['montoAfectadoIgv']);
			$cbcTaxableAmount->setAttribute('currencyID', 'PEN');
			$cacTaxSubtotal->appendChild($cbcTaxableAmount);
			
			$cbcTaxAmount = $xml->createElement('cbc:TaxAmount', $factura['montoIgv']);
			$cbcTaxAmount->setAttribute('currencyID', 'PEN');
			$cacTaxSubtotal->appendChild($cbcTaxAmount);	
			
			$cacTaxCategory = $xml->createElement('cac:TaxCategory');
			$cacTaxSubtotal->appendChild($cacTaxCategory);		
	
				$cbcID = $xml->createElement('cbc:ID', 'S');
				$cbcID->setAttribute('schemeID', 'UN/ECE 5305');
				$cbcID->setAttribute('schemeName', 'Tax Category Identifier');
				$cbcID->setAttribute('schemeAgencyName', 'United Nations Economic Commission for Europe');
				$cacTaxCategory->appendChild($cbcID);	
				
				$cacTaxScheme = $xml->createElement('cac:TaxScheme');
				$cacTaxCategory->appendChild($cacTaxScheme);					
	
					$cbcID = $xml->createElement('cbc:ID', '1000');
					$cbcID->setAttribute('schemeID', 'UN/ECE 5153');
					$cbcID->setAttribute('schemeAgencyID', '6');
					$cacTaxScheme->appendChild($cbcID);
					
					$cbcName = $xml->createElement('cbc:Name', 'IGV');
					$cacTaxScheme->appendChild($cbcName);
					
					$cbcTaxTypeCode = $xml->createElement('cbc:TaxTypeCode', 'VAT');
					$cacTaxScheme->appendChild($cbcTaxTypeCode);							
	//}


	if($factura['montoExoneradoIgv'] > 0){
		$cacTaxSubtotal = $xml->createElement('cac:TaxSubtotal');
		$cacTaxTotal->appendChild($cacTaxSubtotal);
			
			$cbcTaxableAmount = $xml->createElement('cbc:TaxableAmount', $factura['montoExoneradoIgv']);
			$cbcTaxableAmount->setAttribute('currencyID', 'PEN');
			$cacTaxSubtotal->appendChild($cbcTaxableAmount);
			
			$cbcTaxAmount = $xml->createElement('cbc:TaxAmount', '0.00');
			$cbcTaxAmount->setAttribute('currencyID', 'PEN');
			$cacTaxSubtotal->appendChild($cbcTaxAmount);	
			
			$cacTaxCategory = $xml->createElement('cac:TaxCategory');
			$cacTaxSubtotal->appendChild($cacTaxCategory);		
	
				$cbcID = $xml->createElement('cbc:ID', 'E');
				$cbcID->setAttribute('schemeID', 'UN/ECE 5305');
				$cbcID->setAttribute('schemeName', 'Tax Category Identifier');
				$cbcID->setAttribute('schemeAgencyName', 'United Nations Economic Commission for Europe');
				$cacTaxCategory->appendChild($cbcID);	
				
				$cacTaxScheme = $xml->createElement('cac:TaxScheme');
				$cacTaxCategory->appendChild($cacTaxScheme);					
	
					$cbcID = $xml->createElement('cbc:ID', '9997');
					$cbcID->setAttribute('schemeID', 'UN/ECE 5153');
					$cbcID->setAttribute('schemeAgencyID', '6');
					$cacTaxScheme->appendChild($cbcID);
					
					$cbcName = $xml->createElement('cbc:Name', 'EXO');
					$cacTaxScheme->appendChild($cbcName);
					
					$cbcTaxTypeCode = $xml->createElement('cbc:TaxTypeCode', 'VAT');
					$cacTaxScheme->appendChild($cbcTaxTypeCode);							
	}
		//FIN IGV Y EXONERADO
	
	$cacLegalMonetaryTotal = $xml->createElement('cac:LegalMonetaryTotal');
	$invoice->appendChild($cacLegalMonetaryTotal);
	
		$cbcLineExtensionAmount = $xml->createElement('cbc:LineExtensionAmount', $factura['montoTotalMenosIgvYotrosImpuestos']);
		$cbcLineExtensionAmount->setAttribute('currencyID', 'PEN');
		$cacLegalMonetaryTotal->appendChild($cbcLineExtensionAmount);
		
		$cbcTaxInclusiveAmount = $xml->createElement('cbc:TaxInclusiveAmount', $factura['montoTotalAfectoIncluidoIgvYotrosImpuestos']);
		$cbcTaxInclusiveAmount->setAttribute('currencyID', 'PEN');
		$cacLegalMonetaryTotal->appendChild($cbcTaxInclusiveAmount);
		
		$cbcAllowanceTotalAmount = $xml->createElement('cbc:AllowanceTotalAmount', $factura['montoTotalDeLaBonificacin']);
		$cbcAllowanceTotalAmount->setAttribute('currencyID', 'PEN');
		$cacLegalMonetaryTotal->appendChild($cbcAllowanceTotalAmount);
		
		$cbcChargeTotalAmount = $xml->createElement('cbc:ChargeTotalAmount', $factura['montoTotalDeLosCargos']);
		$cbcChargeTotalAmount->setAttribute('currencyID', 'PEN');
		$cacLegalMonetaryTotal->appendChild($cbcChargeTotalAmount);
		
		$cbcPayableAmount = $xml->createElement('cbc:PayableAmount', $factura['montoTotalAPagar']);
		$cbcPayableAmount->setAttribute('currencyID', 'PEN');
		$cacLegalMonetaryTotal->appendChild($cbcPayableAmount);	
		
	
	//DATOS DEL ITEM (PRODUCTO VENDIDO)
	$nitem = 0;
	foreach ($factura['detalles'] as $detalle) {	
		$nitem = $nitem + 1;
		$cacInvoiceLine = $xml->createElement('cac:InvoiceLine');
		$invoice->appendChild($cacInvoiceLine);
		
			$cbcID = $xml->createElement('cbc:ID', $nitem);
			$cacInvoiceLine->appendChild($cbcID);
			
			$cbcInvoicedQuantity = $xml->createElement('cbc:InvoicedQuantity', $detalle['cantidad']);
			$cbcInvoicedQuantity->setAttribute('unitCode', $detalle['unidad']);
			$cbcInvoicedQuantity->setAttribute('unitCodeListID', 'UN/ECE rec 20');
			$cbcInvoicedQuantity->setAttribute('unitCodeListAgencyName', 'United Nations Economic Commission for Europe');
			$cacInvoiceLine->appendChild($cbcInvoicedQuantity);
			
			$cbcLineExtensionAmount = $xml->createElement('cbc:LineExtensionAmount', $detalle['monto_sin_igv']);
			$cbcLineExtensionAmount->setAttribute('currencyID', 'PEN');
			$cacInvoiceLine->appendChild($cbcLineExtensionAmount);
		
			$cacPricingReference = $xml->createElement('cac:PricingReference');
			$cacInvoiceLine->appendChild($cacPricingReference);
			
				$cacAlternativeConditionPrice = $xml->createElement('cac:AlternativeConditionPrice');
				$cacPricingReference->appendChild($cacAlternativeConditionPrice);	
		
					$cbcPriceAmount = $xml->createElement('cbc:PriceAmount', $detalle['precioUnitario']);
					$cbcPriceAmount->setAttribute('currencyID', 'PEN');
					$cacAlternativeConditionPrice->appendChild($cbcPriceAmount);
		
					$cbcPriceTypeCode = $xml->createElement('cbc:PriceTypeCode', '01');
					$cbcPriceTypeCode->setAttribute('listName', 'Tipo de Precio');
					$cbcPriceTypeCode->setAttribute('listAgencyName', 'PE:SUNAT');
					$cbcPriceTypeCode->setAttribute('listURI', 'urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo16');
					$cacAlternativeConditionPrice->appendChild($cbcPriceTypeCode);
		
		
	
		
			$cacTaxTotal = $xml->createElement('cac:TaxTotal');
			$cacInvoiceLine->appendChild($cacTaxTotal);
			
				$cbcTaxAmount = $xml->createElement('cbc:TaxAmount', $detalle['impuesto_item_total']);
				$cbcTaxAmount->setAttribute('currencyID', 'PEN');
				$cacTaxTotal->appendChild($cbcTaxAmount);
			
				$cacTaxSubtotal = $xml->createElement('cac:TaxSubtotal');
				$cacTaxTotal->appendChild($cacTaxSubtotal);
					
					$cbcTaxableAmount = $xml->createElement('cbc:TaxableAmount', $detalle['monto_base']);
					$cbcTaxableAmount->setAttribute('currencyID', 'PEN');
					$cacTaxSubtotal->appendChild($cbcTaxableAmount);
					
					$cbcTaxAmount = $xml->createElement('cbc:TaxAmount', $detalle['impuesto_item_igv']);
					$cbcTaxAmount->setAttribute('currencyID', 'PEN');
					$cacTaxSubtotal->appendChild($cbcTaxAmount);
								
					
					$cacTaxCategory = $xml->createElement('cac:TaxCategory');
					$cacTaxSubtotal->appendChild($cacTaxCategory);		
			
						$cbcID = $xml->createElement('cbc:ID', $detalle['categoriaIdentificacionImpuesto'] );
						$cbcID->setAttribute('schemeID', 'UN/ECE 5305');
						$cbcID->setAttribute('schemeName', 'Tax Category Identifier');
						$cbcID->setAttribute('schemeAgencyName', 'United Nations Economic Commission for Europe');
						$cacTaxCategory->appendChild($cbcID);	
						
						$cbcPercent = $xml->createElement('cbc:Percent', $factura['porcentajeIgv'] );
						$cacTaxCategory->appendChild($cbcPercent);
						
						$cbcTaxExemptionReasonCode = $xml->createElement('cbc:TaxExemptionReasonCode', $detalle['tipoAfectacionIgv']);
						$cbcTaxExemptionReasonCode->setAttribute('listName', 'SUNAT:Codigo de Tipo de Afectacion del IGV');
						$cbcTaxExemptionReasonCode->setAttribute('listAgencyName', 'PE:SUNAT');
						$cbcTaxExemptionReasonCode->setAttribute('listURI', 'urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo07');
						$cacTaxCategory->appendChild($cbcTaxExemptionReasonCode);	
										
						$cacTaxScheme = $xml->createElement('cac:TaxScheme');
						$cacTaxCategory->appendChild($cacTaxScheme);					
			
							$cbcID = $xml->createElement('cbc:ID', $detalle['codigoTipoTributo_1']);
							$cbcID->setAttribute('schemeID', 'UN/ECE 5153');
							$cbcID->setAttribute('schemeName', 'Tax Scheme Identifier');
							$cbcID->setAttribute('schemeAgencyName', 'United Nations Economic Commission for Europe');
							$cacTaxScheme->appendChild($cbcID);
							
							$cbcName = $xml->createElement('cbc:Name', $detalle['codigoTipoTributo_2']);
							$cacTaxScheme->appendChild($cbcName);
							
							$cbcTaxTypeCode = $xml->createElement('cbc:TaxTypeCode', $detalle['codigoTipoTributo_3']);
							$cacTaxScheme->appendChild($cbcTaxTypeCode);	
						
		
			$cacItem = $xml->createElement('cac:Item');
			$cacInvoiceLine->appendChild($cacItem);	
				$descripcionEscapada = htmlspecialchars($detalle['descripcion'], ENT_XML1, 'UTF-8');
				$cbcDescription = $xml->createElement('cbc:Description', $descripcionEscapada);
				#$cbcDescription = $xml->createElement('cbc:Description',  $detalle['descripcion']);
				$cacItem->appendChild($cbcDescription);	
			
				$cacSellersItemIdentification = $xml->createElement('cac:SellersItemIdentification');
				$cacItem->appendChild($cacSellersItemIdentification);		
				
					$cbcID = $xml->createElement('cbc:ID', $detalle['codigo']);
					$cacSellersItemIdentification->appendChild($cbcID);			
		
		
			$cacPrice = $xml->createElement('cac:Price');
			$cacInvoiceLine->appendChild($cacPrice);	
		
				$cbcPriceAmount = $xml->createElement('cbc:PriceAmount', $detalle['valorUnitarioPorItem'] );
				$cbcPriceAmount->setAttribute('currencyID', 'PEN');
				$cacPrice->appendChild($cbcPriceAmount);
	}	
			
	return $xml;
}	
	
	
function preGenerarFactura($xordped_codi,$conexion){
	$arr_detalle = array();
	$arr_detalle_acumulado = array();
	 
	$r_emisor = mysqli_query($conexion,"SELECT * FROM empresas_raiz e;");
	while($row_emisor = mysqli_fetch_array($r_emisor)){
		$nombre_emisor = $row_emisor['emprai_razon_social'];
		$ruc_emisor = $row_emisor['emprai_ruc'];
		$departamento_emisor = $row_emisor['emprai_departamento'];
		$provincia_emisor = $row_emisor['emprai_provincia'];
		$distrito_emisor = $row_emisor['emprai_distrito'];
		$direccion_emisor = $row_emisor['emprai_direccion'];
	}

	$r = mysqli_query($conexion,"SELECT o.*, p.*, dp.*, 
									SUM((ordpeddet_precio * ordpeddet_cantidad) + (ordpeddet_icbper_monto_unitario * ordpeddet_cantidad))  AS monto,
									SUM(ordpeddet_cantidad) AS cantidad_total
								FROM orden_pedido o
									INNER JOIN orden_pedido_detalle opd ON opd.ordped_codi_fk=o.ordped_codi
									INNER JOIN personas p ON p.per_codi=o.per_codi_fk
									INNER JOIN documento_pago dp ON dp.docpag_codi=o.docpag_codi_fk
								WHERE ordped_codi = $xordped_codi;");
	while($row = mysqli_fetch_array($r)){
		$xmonto_total_con_impuestos = $row['monto'];
		$xordped_docpagnum = $row['ordped_docpagnum'];
		$xordped_fecha = $row['ordped_fecha'];
		
		$xordped_dias_credito = $row['ordped_dias_credito'];					
		$xfecha_vencimiento = date("Y-m-d",strtotime($row['ordped_fecha']."+ $xordped_dias_credito days")); 
		
		$xcomtip_codigo_fk = $row['comtip_codigo_fk'];
		$xper_ruc_dni_tipo = $row['per_ruc_dni_tipo'];
		$ruc_receptor = $row['per_ruc'];
		$nombre_receptor = $row['per_razon_social'];
		$direccion_receptor = $row['per_direccion1'];
		$porcentajeIgv  = $row['ordped_igv_porcentaje'];
		$xpagtip_codi_fk  = $row['pagtip_codi_fk'];
		
		$monto_afectado = 0;
		$monto_exonerado = 0;
		$montoIgv = 0;
		
		$r_montos = mysqli_query($conexion,"SELECT ordpeddet_igv_afectado, 
												SUM((ordpeddet_precio * ordpeddet_cantidad) + (ordpeddet_icbper_monto_unitario * ordpeddet_cantidad))  AS monto
											FROM orden_pedido_detalle o
											WHERE ordped_codi_fk = $xordped_codi
											GROUP BY ordpeddet_igv_afectado
											ORDER BY ordpeddet_igv_afectado;");
		while($row_montos = mysqli_fetch_array($r_montos)){
			if($row_montos['ordpeddet_igv_afectado']==0){
				//$xTaxInclusiveAmount = number_format($row_montos['monto'],2,'.',''); 
				$monto_afectado = number_format($row_montos['monto'],2,'.',''); 
				$xporcentajeIgv = $porcentajeIgv / 100;
				$monto_afectado_sin_igv = $monto_afectado / (($porcentajeIgv / 100)+1);
				$montoIgv =  ($monto_afectado / (($porcentajeIgv / 100)+1)) * $xporcentajeIgv;
			}
			if($row_montos['ordpeddet_igv_afectado']==1){
				//$xTaxInclusiveAmount = number_format($row_montos['monto'],2,'.',''); 
				$monto_exonerado = number_format($row_montos['monto'],2,'.','');
			}
			$xTaxInclusiveAmount = $monto_afectado + $monto_exonerado;
		}
		
		$montoTotalMenosIgvYotrosImpuestos = $xmonto_total_con_impuestos - $montoIgv; 
		//$montoTotalMenosIgvYotrosImpuestos = $monto_afectado_sin_igv;
		
		$r_detalle = mysqli_query($conexion,"SELECT o.ordpeddet_codi, o.ordpeddet_igv_afectado, p.prd_codigo, p.prd_nombre, u.unimed_nombre, u.unimed_sunat,
											o.ordpeddet_precio, o.ordpeddet_cantidad, 
											(o.ordpeddet_precio * o.ordpeddet_cantidad) AS monto_item
											FROM orden_pedido_detalle o
												INNER JOIN productos p ON p.prd_codi=o.prd_codi_fk
												INNER JOIN unidades_medida u ON u.unimed_codi=o.unimed_codi_fk
											WHERE ordped_codi_fk = $xordped_codi
											ORDER BY o.ordpeddet_codi;");
		$k = 0;
		while($row_detalle = mysqli_fetch_array($r_detalle)){
						
			$xporcentajeIgv = $porcentajeIgv / 100;
			
			if($row_detalle['ordpeddet_igv_afectado']==0){			
				$xmonto_sin_igv = $row_detalle['monto_item'] / (($porcentajeIgv / 100)+1);
				$xmonto_con_igv = $row_detalle['monto_item'];				
				$ximpuesto_item_total = $xmonto_sin_igv * ($porcentajeIgv / 100); //incluye igv mas otros impuestos + icbper
				$ximpuesto_item_igv = $xmonto_sin_igv * ($porcentajeIgv / 100);
				$xtipoAfectacionIgv = '10';
				$xcategoriaIdentificacionImpuesto = 'S';
				$codigoTipoTributo_1 = '1000';
				$codigoTipoTributo_2 = 'IGV';
				$codigoTipoTributo_3 = 'VAT';
				$valorUnitarioPorItem = $row_detalle['ordpeddet_precio'] / (($porcentajeIgv / 100)+1);
			}else{
				$xmonto_sin_igv = $row_detalle['monto_item'];
				$xmonto_con_igv = $row_detalle['monto_item'];				
				$ximpuesto_item_total = 0;
				$ximpuesto_item_igv = 0;	
				$xtipoAfectacionIgv = '20';		
				$xcategoriaIdentificacionImpuesto = 'E';
				$codigoTipoTributo_1 = '9997';
				$codigoTipoTributo_2 = 'EXO';
				$codigoTipoTributo_3 = 'VAT';
				$valorUnitarioPorItem = $row_detalle['ordpeddet_precio'];
			}
			
			
			$arr_detalle[$k] = [
				'id' => $row_detalle['ordpeddet_codi'],
				'cantidad' => number_format($row_detalle['ordpeddet_cantidad'],10,'.','') ,
				'unidad' => $row_detalle['unimed_sunat'],
				'monto_sin_igv' => number_format($xmonto_sin_igv,2,'.',''), //(precioUnitario * cantidad) quitandole el igv
				'monto_con_igv' => number_format($xmonto_con_igv,2,'.',''),
				'precioUnitario' => number_format($row_detalle['ordpeddet_precio'],10,'.',''), //precio unitario incluido igv
				'impuesto_item_total' => number_format($ximpuesto_item_total,2,'.',''), //incluye igv mas otros impuestos
				'impuesto_item_igv' => number_format($ximpuesto_item_igv,2,'.',''), //solo igv
				'monto_base' => number_format($xmonto_sin_igv,2,'.',''), //monto sin igv
				'descripcion' => $row_detalle['prd_nombre'].' - '.$row_detalle['unimed_nombre'],
				'codigo' => $row_detalle['prd_codigo'],
				'tipoAfectacionIgv' => $xtipoAfectacionIgv, //10:Gravado, 20:Exonerado
				'categoriaIdentificacionImpuesto' => $xcategoriaIdentificacionImpuesto, //S:Gravado, E:Exonerado
				'codigoTipoTributo_1' => $codigoTipoTributo_1, // 1000:IGV, 9997:EXONERADO  (CATALOGO N 05)
				'codigoTipoTributo_2' => $codigoTipoTributo_2, // IGV:afecto a IGV, EXO:Exonerado  (CATALOGO N 05)
				'codigoTipoTributo_3' => $codigoTipoTributo_3, // VAT:IGV, VAT:EXONERADO  (CATALOGO N 05)
				'valorUnitarioPorItem' => number_format($valorUnitarioPorItem,10,'.','') // Precio unitario sin igv
			];
			
			$k = $k + 1;
		}		
	}


	// Datos de factura
	$factura = [
		'id' => $xordped_docpagnum,
		'fechaEmision' => $xordped_fecha,
		'tipoPago' => $xpagtip_codi_fk, // 2:credito, 1:contado
		'fechaVencimiento' => $xfecha_vencimiento,
		'tipoComprobante' => $xcomtip_codigo_fk,
		'total' => number_format($xmonto_total_con_impuestos,2,'.',''),
		//'totalLetras' => numtoletras( number_format($xmonto_total_con_impuestos,2,'.','') ),	
		'totalLetras' => convertirNumLetras(number_format($xmonto_total_con_impuestos,2,'.','')),	
		
		//'montoAfectadoIgv' => number_format($monto_afectado,2,'.',''), 
		'montoAfectadoIgv' => number_format($monto_afectado_sin_igv,2,'.',''),
		'montoExoneradoIgv' => number_format($monto_exonerado,2,'.',''), 
		'montoIgv' => number_format($montoIgv,2,'.',''), 
		'porcentajeIgv' => $porcentajeIgv, 
		'formaPago' => 'contado',
		'montoTotalMenosIgvYotrosImpuestos' => number_format($montoTotalMenosIgvYotrosImpuestos,2,'.',''),
		//'montoTotalAfectoIncluidoIgvYotrosImpuestos' => number_format($monto_afectado,2,'.',''), //No incluye monto exonerado
		'montoTotalAfectoIncluidoIgvYotrosImpuestos' => number_format($xTaxInclusiveAmount,2,'.',''),
		'montoTotalDeLaBonificacin' => '0.00',
		'montoTotalDeLosCargos' => '0.00',
		'montoTotalAPagar' => number_format($xmonto_total_con_impuestos,2,'.',''),
		
		'emisor' => [
			'tipoDocumentoIdentidad' => '6',  //(0:sindocumento, 1:dni, 6:ruc)
			'ruc' => $ruc_emisor, 
			'nombre' => $nombre_emisor,
			'departamento' => $departamento_emisor, 
			'provincia' => $provincia_emisor,
			'distrito' => $distrito_emisor,
			'direccion' => $direccion_emisor
		],
		'receptor' => [
			'tipoDocumentoIdentidad' => $xper_ruc_dni_tipo, //6:ruc, 1:dni
			'ruc' => $ruc_receptor,
			'nombre' => $nombre_receptor,
			'departamento' => '', 
			'provincia' => '',
			'distrito' => '',
			'direccion' => $direccion_receptor		
		],
		'detalles' => $arr_detalle
	];
	
	
	
	// Generando XML de la factura
	$xml = generarFacturaXML($factura);
	
	$nombreArchivo = $factura['emisor']['ruc'] . '-' . $factura['tipoComprobante'] . '-' .  $factura['id'].".xml";
	$nombreArchivoZip = $factura['emisor']['ruc'] . '-' . $factura['tipoComprobante'] . '-' .  $factura['id'].".zip";
	$ruta = "firma/";
	
	// Guardar el XML en un archivo
	$r = $xml->save($ruta.$nombreArchivo);
	if($r){	
		echo '<br>Archivo XML generado correctamente.';
	
		//================= FIRMAR XML ================
		
		$signature = new Signature();
		$flg_firma = "0";
		$ruta_firma = "certificado/".ARCHIVO_CERTIFICADO;
		$pass_firma = PIN_CERTIFICADO;
		
		$rutas = $ruta.$nombreArchivo;
		
		$resp_firma = $signature->signature_xml($flg_firma, $rutas, $ruta_firma, $pass_firma);
		
		if($resp_firma['respuesta'] == 'error') {
			return $resp_firma;
		}else{
			$xhash_cpe = $resp_firma['hash_cpe'];
			$xatributo = $resp_firma['atributo'];
			//$xatributo="";	

			echo "<br>hash_cpe: ".$xhash_cpe;
			
			$r_estdo_xml = mysqli_query($conexion,"UPDATE orden_pedido SET codigohast = '$xhash_cpe',
																			firma = '$xatributo',
																			timbrexml = '1'
																	WHERE ordped_codi = $xordped_codi");
			
			//=================ZIPEAR ================
			$zip = new ZipArchive();
			if ($zip->open($ruta.$nombreArchivoZip, ZipArchive::CREATE) === TRUE) {
				// Agrega el archivo XML al ZIP
				$zip->addFile($ruta.$nombreArchivo, basename($nombreArchivo));
				// Cierra el ZIP
				$zip->close();
				echo '<br>Archivo ZIP generado correctamente.';
				
				//@include("../procesos/funciones.php");
				if(verificar_conexion_a_webservice()==1){
					?>
					<script>
					parent.document.getElementById('frame_validar_xml').src = "facturadorenlinea/validar-boleta.php?xordped_codi=<?php echo $xordped_codi;?>";
					</script>
					<?php	
				}else{
					?>
					<script>
					alert("ADVERTENCIA: El sistema no puede conectarse a la Webservice de Sunat. Verifique su conexion a internet.");
					</script>
					<?php	
				}				
				
				// Enva el archivo ZIP a la SUNAT
				//enviarArchivoASunat($zipFileName);
				
				// Elimina el archivo ZIP despus de enviarlo
				//unlink($zipFileName);
			} else {
				echo '<br>Error al crear el archivo ZIP';
			}
			
		}
			
	}else{
		echo 'Error al generar xml.';
	}
	
	echo "<br>$xordped_codi";
}


preGenerarFactura($xordped_codi, $conexion);

?>


