
// --- CONFIGURACIÓN DEL CHATBOT ---
let audioEnabled = true;


const BACKEND_URL = 'http://localhost:3300'; // Asegúrate que coincida con la URL de tu servidor Node.js
//const BACKEND_URL = 'https://www.iepcunajardinmontessori.com/asistentemontessori'; // Asegúrate que coincida con la URL de tu servidor Node.js
//const BACKEND_URL = 'https://apps.fondep.gob.pe'; // Asegúrate que coincida con la URL de tu servidor Node.js
//const BACKEND_URL = 'http://localhost:1402'; // Asegúrate que coincida con la URL de tu servidor Node.js
//const BACKEND_URL = 'http://192.168.40.21:1402'; // Asegúrate que coincida con la URL de tu servidor Node.js
//const BACKEND_URL = 'http://localhost:3000'; // Asegúrate que coincida con la URL de tu servidor Node.js
//const BACKEND_URL = 'http://127.0.0.1:1402'; // Asegúrate que coincida con la URL de tu servidor Node.js
//const BACKEND_URL = 'http://192.168.40.21:1402'; // Asegúrate que coincida con la URL de tu servidor Node.js
//const BACKEND_URL = 'https://3713-2800-4b0-4431-a909-3c24-71d9-e07-3744.ngrok-free.app';
//const BACKEND_URL = 'https://www.iepcunajardinmontessori.com/asesorenla';


const chatMessages = document.getElementById('chatMessages');
const userInput = document.getElementById('userInput');
const xcontexto = document.getElementById('xcontexto');

const sendButton = document.getElementById('sendButton');
const voiceInputButton = document.getElementById('voiceInputButton');
const loadingSpinner = document.getElementById('loadingSpinner');
const recordingIndicator = document.getElementById('recordingIndicator');
const stopRecordingButton = document.getElementById('stopRecordingButton');

//let currentSlideIndex = 0;
let audioPlayer = new Audio(); // Crea una instancia de Audio


// --- LÓGICA DEL CHAT Y VOZ (IA) ---
let recognition;
let isRecording = false;

/*
function addMessage(text, sender, audioBase64 = null) {
	const messageDiv = document.createElement('div');
	messageDiv.classList.add('message', sender === 'user' ? 'user-message' : 'ai-message');
	messageDiv.textContent = text;
	chatMessages.appendChild(messageDiv);
	chatMessages.scrollTop = chatMessages.scrollHeight;

	//if (sender === 'ai' && audioBase64) {
	if (sender === 'ai' && audioBase64 && audioEnabled) {
		// Detener cualquier reproducción actual
		audioPlayer.pause();
		audioPlayer.currentTime = 0;

		// Reproducir el nuevo audio
		audioPlayer.src = `data:audio/mp3;base64,${audioBase64}`;
		audioPlayer.play().catch(e => console.error("Error al reproducir audio:", e));
	}
}
*/

function addMessage(text, sender, audioBase64 = null, messageId = null) {
	const messageDiv = document.createElement('div');
	messageDiv.classList.add('message', sender === 'user' ? 'user-message' : 'ai-message');
	messageDiv.textContent = text;

	if (messageId) {
		messageDiv.id = messageId;
	}

	chatMessages.appendChild(messageDiv);
	chatMessages.scrollTop = chatMessages.scrollHeight;
	
	/*
	if (sender === 'ai' && audioBase64 && audioEnabled) {
		audioPlayer.pause();
		audioPlayer.currentTime = 0;
		audioPlayer.src = `data:audio/mp3;base64,${audioBase64}`;
		audioPlayer.play().catch(e => console.error("Error al reproducir audio:", e));
	}
	*/
	
	// Usamos SpeechSynthesis API en lugar de audioBase64
	if (sender === 'ai' && audioEnabled) {
		const utterance = new SpeechSynthesisUtterance(text);
		utterance.lang = 'es-US'; // Puedes cambiarlo a 'es-PE', 'es-MX', 'es-ES', 'es-US' etc.
		utterance.rate = 1.2;     // Velocidad (más rápida que lo normal)
		utterance.pitch = 0.9;    // Tono (puedes probar con valores entre 0 y 2)				
		speechSynthesis.cancel(); // Detiene cualquier voz en curso
		speechSynthesis.speak(utterance);
		
		const voces3 = window.speechSynthesis.getVoices();
		const vozElegida3 = voces3.find(v => v.lang === 'es-US' && v.name.includes('Google'));
		if (vozElegida3) {
			utterance.voice = vozElegida3;
		}			
	}			
		
}		



// --- Generar o recuperar sessionId del localStorage ---
const SESSION_KEY = 'tutor_session_id';
let sessionId = localStorage.getItem(SESSION_KEY);
if (!sessionId) {
	sessionId = 'sess_' + Math.random().toString(36).substring(2, 12);
	localStorage.setItem(SESSION_KEY, sessionId);
}

async function sendMessage(prompt) {
	//alert("test");
	addMessage(prompt, 'user');
	userInput.value = '';
	sendButton.disabled = true;
	voiceInputButton.disabled = true;
	loadingSpinner.classList.add('visible');
	
	// Mensaje temporal de "pensando"
	const thinkingId = 'thinking-message';
	//addMessage('formulando respuesta...', 'ai', null, thinkingId);		
	
	setTimeout(() => {
		addMessage('formulando respuesta...', 'ai', null, thinkingId);	
	}, 600);			
	
		
	
	if (isRecording && recognition) {
		recognition.stop();
	}			

	try {
		const contexto = xcontexto.value.trim();
		const zcontexto = "***ESTA ES LA PREGUNTA REFERENTE A LA GESTIÓN DEL NEGOCIO:*** " + contexto;
		console.log(zcontexto);
		
		const response = await fetch(`${BACKEND_URL}/api/chat`, {
		//const response = await fetch(`${BACKEND_URL}/api/chatcetpro`, {
			method: 'POST',
			headers: { 'Content-Type': 'application/json' },
			body: JSON.stringify({
				message: prompt,
				sessionId: sessionId,
				contestType: 'ALIAZIONE',
				zcontexto: zcontexto
			})
		});

		if (!response.ok) {
			const errorText = await response.text();
			throw new Error(`HTTP error! status: ${response.status}, message: ${errorText}`);
		}

		const data = await response.json();
		
		// Elimina el mensaje de "Pensando..."
		const thinkingMsg = document.getElementById(thinkingId);
		if (thinkingMsg) thinkingMsg.remove();				

		if (data.textResponse) {
			addMessage(data.textResponse, 'ai', data.audioBase64);
			
			//if (isRecording && recognition) {
			//	recognition.stop();
			//}
		} else {
			addMessage("Lo siento, no pude obtener una respuesta de la IA. Por favor, inténtalo de nuevo.", 'ai');
		}

	} catch (error) {
		console.error("Error al comunicarse con la IA:", error.message);
		addMessage(`Error: No se pudo procesar tu mensaje. Detalles: ${error.message}`, 'ai');
	} finally {
		sendButton.disabled = false;
		voiceInputButton.disabled = false;
		loadingSpinner.classList.remove('visible');
	}
} 





sendButton.addEventListener('click', () => {

	//const contexto = xcontexto.value.trim();
	const prompt = userInput.value.trim();
	//const prompt = "***ESTA ES LA PREGUNTA REFERENTE A LA GESTIÓN DEL NEGOCIO:*** " + userInput.value.trim() + contexto;
	if (prompt) {
		sendMessage(prompt);
	}
});

userInput.addEventListener('keypress', (e) => {
	if (e.key === 'Enter' && !e.shiftKey) {
		e.preventDefault();
		
		//const contexto = xcontexto.value.trim();
		const prompt = userInput.value.trim();
		//const prompt = "***ESTA ES LA PREGUNTA REFERENTE A LA GESTIÓN DEL NEGOCIO:*** " + userInput.value.trim() + contexto;
		if (prompt) {
			sendMessage(prompt);
		}
	}
});

// Configuración de reconocimiento de voz (Speech-to-Text)
if ('webkitSpeechRecognition' in window) {
	recognition = new webkitSpeechRecognition();
	//recognition.continuous = false;
	recognition.continuous = true;
	recognition.interimResults = false;
	recognition.lang = 'es-ES'; // Idioma para el reconocimiento de voz

	recognition.onstart = () => {
		isRecording = true;
		recordingIndicator.classList.add('visible');
		//voiceInputButton.textContent = 'Grabando...';
		voiceInputButton.textContent = 'Escuchando...';
		voiceInputButton.disabled = true;
		userInput.disabled = true;
		sendButton.disabled = true;
		audioPlayer.pause(); // Detener reproducción si hay audio de la IA
	};

	recognition.onresult = (event) => {
		const transcript = event.results[0][0].transcript;
		userInput.value = transcript;
		sendMessage(transcript); // Envía el texto reconocido a la IA
	};

	recognition.onerror = (event) => {
		console.error('Error de reconocimiento de voz:', event.error);
		recordingIndicator.classList.remove('visible');
		isRecording = false;
		voiceInputButton.textContent = 'Capturar Voz';
		voiceInputButton.disabled = false;
		userInput.disabled = false;
		sendButton.disabled = false;
		if (event.error === 'no-speech') {
			addMessage('No se detectó voz. Por favor, inténtalo de nuevo.', 'ai');
		} else if (event.error === 'not-allowed') {
			addMessage('Permiso de micrófono denegado. Por favor, habilítalo en la configuración de tu navegador.', 'ai');
		} else {
			addMessage('Ocurrió un error en el reconocimiento de voz.', 'ai');
		}
	};

	
	recognition.onend = () => {
		isRecording = false;
		recordingIndicator.classList.remove('visible');
		voiceInputButton.textContent = 'Capturar Voz';
		voiceInputButton.disabled = false;
		stopRecordingButton.style.display = 'none';
		userInput.disabled = false;
		sendButton.disabled = false;
	};			
	

	voiceInputButton.addEventListener('click', () => {
		window.speechSynthesis.cancel();
		if (!isRecording) {
			recognition.start();
			stopRecordingButton.style.display = 'inline-block';
			voiceInputButton.disabled = true;
		}
	});			
	
	
	stopRecordingButton.addEventListener('click', () => {
		if (isRecording) {
			recognition.stop(); // Esto llama automáticamente a onend
		}
	});		
	
} else {
	// Deshabilitar botón de voz si el navegador no lo soporta
	voiceInputButton.disabled = true;
	voiceInputButton.textContent = 'Voz no soportada';
	addMessage('Tu navegador no soporta el reconocimiento de voz. Por favor, usa la entrada de texto.', 'ai');
}

document.addEventListener('DOMContentLoaded', () => {
	//showSlide(currentSlideIndex);
});



const toggleAudioBtn = document.getElementById('toggleAudioBtn');

toggleAudioBtn.addEventListener('click', () => {
	audioEnabled = !audioEnabled;

	if (audioEnabled) {
		//toggleAudioBtn.textContent = 'Audio ON';
		toggleAudioBtn.textContent = 'Voz de chatbot activada';
		toggleAudioBtn.style.backgroundColor = '#5c636a';
	} else {
		//toggleAudioBtn.textContent = 'Audio OFF';
		toggleAudioBtn.textContent = 'Voz de chatbot desactivada';
		toggleAudioBtn.style.backgroundColor = '#888';
		//audioPlayer.pause(); // Detener cualquier audio en curso de text-to-speech de Google cloud.
		window.speechSynthesis.cancel();  // Detener cualquier audio en curso de text-to-speech del navegador.
	}
});
	




//*****************************FORMULADOR DE PROYECTOS**********************************************************************************************************//

function delay(ms) {
	return new Promise(resolve => setTimeout(resolve, ms));
}

async function enviarForm(){

	//alert("enviando");
	/*
	const q1 = document.getElementById('q1').value.trim();
	const q2 = document.getElementById('q2').value.trim();
	const q3 = document.getElementById('q3').value.trim();
	const q4 = document.getElementById('q4').value.trim();
	const q5 = document.getElementById('q5').value.trim();
	const q6 = document.getElementById('q6').value.trim();
	
	if(q1=="" || q2=="" || q3=="" || q4=="" || q5=="" || q6==""){
		alert('Debes ingresar respuesta a todas las preguntas.');
		return;
	}
	*/
		
	const loadingOverlay = document.getElementById('loading-overlay');
	
	/*
	const generateBtn = document.getElementById('generate-btn');
	//const btnCerrarGenerador = document.getElementById('btn-cerrar-generador');
	const iframe = document.getElementById('descarga-frame');
	const btnCerrarGenerador = document.getElementById('btn-cerrar-generador');
	const btnCerrarFormulador = document.getElementById('cerrar-formulador-btn');
	*/

	try {

		loadingOverlay.style.display = 'block';
		//generateBtn.disabled = true;
		//btnCerrarGenerador.disabled = true;
		
		//alert("aqui 4");
		/*
		p1 = document.getElementById('prg1').innerText.trim();
		p2 = document.getElementById('prg2').innerText.trim();
		p3 = document.getElementById('prg3').innerText.trim();
		p4 = document.getElementById('prg4').innerText.trim();
		p5 = document.getElementById('prg5').innerText.trim();
		p6 = document.getElementById('prg6').innerText.trim();
		*/	
		
		//p1 = document.getElementById('userInput').innerText.trim();
		const p1 = document.getElementById('userInput').value.trim();
		const xxcontexto = document.getElementById('xcontexto').value.trim();
		
		//const xxcontexto = document.getElementById('xcontexto');
		
		//******** PARAMETROS QUE INDICAN EL CONCURSO Y ORIGEN DE DONDE SE ENVIAN LOS DATOS ********
		fpage_concurso = 'CETPRO2025';
		fpage_origen = 'LANDINGPAGE-CETPRO2025';
		//fpage_origen = 'INSCRIPCION-CETPRO2025';
				
		//await delay(1000); // Pausa de 2 segundos (2000 ms)


		//const response = await fetch(`${BACKEND_URL}/api/chat`, {

		//document.getElementById('pdfForm').submit();
		//const response = await fetch('http://localhost:3000/generador', {
		//////////////const response = await fetch(`${BACKEND_URL}/generador`, {
		//const response = await fetch('https://apps.fondep.gob.pe/generador', {
		const response = await fetch('http://localhost:1404/generador', {
		//const response = await fetch('http://192.168.40.21:1404/generador', {
			method: 'POST',
			headers: {
				'Content-Type': 'application/x-www-form-urlencoded',
			 },
			 /*
			 body: `p1=${encodeURIComponent(p1)}
					&p2=${encodeURIComponent(p2)}
					&p3=${encodeURIComponent(p3)}
					&p4=${encodeURIComponent(p4)}
					&p5=${encodeURIComponent(p5)}
					&p6=${encodeURIComponent(p6)}
					&q1=${encodeURIComponent(q1)}
					&q2=${encodeURIComponent(q2)}
					&q3=${encodeURIComponent(q3)}
					&q4=${encodeURIComponent(q4)}
					&q5=${encodeURIComponent(q5)}
					&q6=${encodeURIComponent(q6)}
					&fpage_concurso=${encodeURIComponent(fpage_concurso)}
					&fpage_origen=${encodeURIComponent(fpage_origen)}`
			*/	
			 body: `p1=${encodeURIComponent(p1)}
					&xxcontexto=${encodeURIComponent(xxcontexto)}
					&fpage_concurso=${encodeURIComponent(fpage_concurso)}
					&fpage_origen=${encodeURIComponent(fpage_origen)}`
						
		});
			
		if (!response.ok) throw new Error('Error al generar el PDF');
		
																		
		
		// ******** Inicio de Bloque que permite generar el pdf *********
		const blob = await response.blob();
		const url = URL.createObjectURL(blob);
		
		const a = document.createElement('a');
		a.href = url;
		a.download = 'reporte.pdf';
		a.click();
	
		URL.revokeObjectURL(url);	
		// ******** Fin de Bloque que permite generar el pdf *********
		
		
	} catch (error) {
		console.error("Error al generar el proyecto (frontend):", error);
		// Muestra el mensaje de error completo en el alert
		
		loadingOverlay.style.display = 'none';
		/*
		generateBtn.disabled = false;
		btnCerrarGenerador.disabled = false;
		btnCerrarFormulador.disabled = false;
		*/
		
		alert(`Ocurrió un error al generar el proyecto: ${error.message}. Por favor, inténtalo de nuevo. Revisa la consola del navegador para más detalles.`);
		
	} finally {
		
		loadingOverlay.style.display = 'none';
		/*
		generateBtn.disabled = false;
		btnCerrarGenerador.disabled = false;
		btnCerrarFormulador.disabled = false;
		*/
	}
	
}





//****EVENTOS DE LA MODAL***//
/*
function abrirModal(xmodal) {
  //document.getElementById('customModalAsistente').style.display = 'flex';
  document.getElementById(xmodal).style.display = 'flex';
}

function cerrarModal(xmodal) {
  //document.getElementById('customModalAsistente').style.display = 'none';
  document.getElementById(xmodal).style.display = 'none';
  window.speechSynthesis.cancel();
}
*/