document.getElementById('t_query').addEventListener('keydown', function(e) {
    if(e.keyCode === 13) {
     	enviar_pregunta();
    }
});


let n_div = 0;
function enviar_pregunta(){

	xpregunta = document.getElementById('t_query').value;
	
	if(xpregunta.trim()!=""){

		// Crear un nuevo div
		var nuevoDiv = document.createElement("div");
	
		// Asignar un ID al nuevo div (opcional)
		n_div = n_div + 1;
		idDiv = 'd_pregunta_' + n_div;
		nuevoDiv.id = idDiv;
	
		nuevoDiv.style.padding = "10px"; 
		//nuevoDiv.style.width = "90%"; 
		nuevoDiv.style.border = "1px solid #ccc";
		nuevoDiv.style.borderRadius = "10px";
		nuevoDiv.style.marginTop = "5px";
		
		nuevoDiv.style.color = "#000000"; 
		nuevoDiv.style.textAlign = "left";

		nuevoDiv.style.marginLeft = "90px";	
		nuevoDiv.style.marginRight = "10px";	
		nuevoDiv.style.backgroundColor = "#E2E2E2";
		nuevoDiv.innerHTML = "<B>T&uacute;: </B>"+ xpregunta; 

		// Obtener el div existente (padre) por su ID
		var contenedorPadre = document.getElementById("d_preguntas_respuestas");
	
		// Agregar el nuevo div al div existente (padre)
		contenedorPadre.appendChild(nuevoDiv);	
		
		document.getElementById('t_query').value = "";
		document.getElementById('t_query').focus();
		
		procesar_respuesta(xpregunta);
	}	
}



async function procesar_respuesta(xpregunta){
	//alert("debe responder");
	const response = await getCompletion(xpregunta);
  	//console.log(response);
	
	xrespuesta = response.choices[0].text;
	
	// Crear un nuevo div
	var nuevoDiv = document.createElement("div");

	// Asignar un ID al nuevo div (opcional)
	n_div = n_div + 1;
	idDiv = 'd_pregunta_' + n_div;
	nuevoDiv.id = idDiv;

	nuevoDiv.style.padding = "10px"; 
	//nuevoDiv.style.width = "90%"; 
	nuevoDiv.style.border = "1px solid #CCCCCC";
	nuevoDiv.style.borderRadius = "10px";
	nuevoDiv.style.marginTop = "5px";
	
	nuevoDiv.style.color = "#000000"; 
	nuevoDiv.style.textAlign = "left";
	
	nuevoDiv.style.marginRight = "90px";	
	nuevoDiv.style.marginLeft = "0px";	
	//nuevoDiv.style.backgroundColor = "#EEEA8E"; 
	nuevoDiv.style.backgroundColor = "#f8f9fa";
	nuevoDiv.innerHTML = "<B>Sistema: </B>"+ xrespuesta;
	
	hablar(xrespuesta);
		
	// Obtener el div existente (padre) por su ID
	var contenedorPadre = document.getElementById("d_preguntas_respuestas");

	// Agregar el nuevo div al div existente (padre)
	contenedorPadre.appendChild(nuevoDiv);	
	
	document.getElementById('t_query').value = "";
	document.getElementById('t_query').focus();	
}

//BIBLIOGRAFIA: https://www.juannicolas.eu/convertir-voz-a-texto-con-javascript/

//let n_div = 0;

//Configurar la gramtica de nuestro reconocimiento de voz
var SpeechRecognition = SpeechRecognition || webkitSpeechRecognition
var SpeechGrammarList = SpeechGrammarList || webkitSpeechGrammarList
var SpeechRecognitionEvent = SpeechRecognitionEvent || webkitSpeechRecognitionEvent

var recognition = new SpeechRecognition(); //<-- Reconocimiento de voz

//Establezcamos las opciones del reconocimiento
recognition.continuous = false;
recognition.lang = 'es-ES';
recognition.interimResults = false;
recognition.maxAlternatives = 1;

//Comenzando a escuchar con el reconocimiento de voz
//recognition.start();

//Recogiendo resultados
recognition.onspeechend = function() {
	recognition.stop();
}

recognition.onresult = function(event) {
	var color = event.results[0][0].transcript;
	var confianza = event.results[0][0].confidence;
	
	console.log('Confianza ' + confianza + ' % que dijo ' + color);
	document.getElementById('t_query').value = color;

	enviar_pregunta();
}

//Manejo de eventos y errores
recognition.onstart = function() {
	console.log("El sistema esta escuchando.");
}

recognition.onnomatch = function(event) {
	document.getElementById('d_escuchando').innerHTML = 'Por favor hable mas claro.';
}

recognition.onerror = function(event) {
	if(event.error == 'no-speech') {
		// No he escuchado nada. Mejora la calidad de la grabacin.
		document.getElementById('d_escuchando').innerHTML = 'ADVERTENCIA: No se escucha nada. Verifique su microfono.';
	} else {
		// Error gen
		document.getElementById('d_escuchando').innerHTML = 'ADVERTENCIA: Error generado.';
	}
}


async function reconocer_voz(){
	await recognition.start();	
}

/*
let captureVid;
let webcamElt;
let objDetMod;
let res;
let ts = 24;
*/

function draw() {
	reconocer_voz();
}	



//Funcin de conversin de texto en voz
function hablar(xmensaje){
	if('speechSynthesis' in window) {
	  	//El navegador es moderno. Todo ok!
	  	//alert('Todo Ok!');
	  	window.speechSynthesis.speak(
			new SpeechSynthesisUtterance(xmensaje)
	  	)
	}else{
		//El navegador es antiguo. Camino alternativo
		// Tal vez mostrar una versin reducida o un cartel de informacin
		alert('ADVERTENCIA: Su navegador no soporta speechSynthesis!');
	}  
}


/********************CONEXION CON OPEN AI*****************************/
const API_KEY = "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"; //OPENAI API_KEY

async function getCompletion(pregunta) {
  const response = await fetch('https://api.openai.com/v1/completions', {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
      Authorization: `Bearer ${API_KEY}`,
	  //Authorization: 'Bearer ${API_KEY}',
    },
    body: JSON.stringify({
     	//model: "text-davinci-003",
		model: "gpt-3.5-turbo-instruct",
		//model: "davinci-002",	

      	// prompt: "give a random example of programming language",
      	prompt: pregunta,
      	max_tokens: 350,
    }),
  });

  const data = await response.json();
  // console.log(data)
  return data;
}
	