<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>CapturaCodigoBarras</title>
  <style>
    body {
      margin: 0;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
    }
    #video-container {
      position: relative;
    }
    #preview {
      width: 480px;
      height: 380px;
    }
    #overlay {
      position: absolute;
      top: 50%;
      left: 0;
      width: 100%;
      height: 1px;
      background-color: red;
      transform: translateY(-50%);
      z-index: 10;
    }
  </style>
</head>
<body>
  <div id="video-container">
    <video id="preview" width="480" height="380"></video>
    <canvas id="overlay"></canvas>
  </div>

  <script src="js/quagga.min.js"></script>
  
  <script>
    document.addEventListener('DOMContentLoaded', function () {
      const video = document.getElementById('preview');
      const canvas = document.getElementById('overlay');
      const ctx = canvas.getContext('2d');

      navigator.mediaDevices.getUserMedia({ video: { facingMode: 'environment' } })
        .then(function (stream) {
          video.srcObject = stream;
          video.play();

          Quagga.init({
            inputStream: {
              name: "Live",
              type: "LiveStream",
              target: video,
              constraints: {
                width: { min: 480 },
                height: { min: 380 }
              }
            },
            decoder: {
              readers: ["ean_reader", "upc_reader", "code_128_reader"]
            }
          }, function (err) {
            if (err) {
              console.error('Error al inicializar Quagga: ', err);
              return;
            }
            console.log('QuaggaJS inicializado correctamente.');
            Quagga.start();
          });

          Quagga.onDetected(function (result) {
            // Colocar el codigo de barras en algun lugar (ejemplo: un input)
            parent.document.getElementById('xcodigo_barras').value = result.codeResult.code;

            // Realizar otras acciones necesarias
            parent.document.getElementById("btn_cerrar_capturarcodigo").click();
            parent.document.getElementById("btn_leer_codigo_barras2").click();
          });

          // Dibujar la linea horizontal en el canvas
          video.addEventListener('loadedmetadata', function () {
            canvas.width = video.videoWidth;
            canvas.height = video.videoHeight;

            ctx.strokeStyle = 'red'; // Color de la linea horizontal
            ctx.lineWidth = 2;
            ctx.beginPath();
            ctx.moveTo(0, video.videoHeight / 2);
            ctx.lineTo(video.videoWidth, video.videoHeight / 2);
            ctx.stroke();
          });
        })
        .catch(function (error) {
          console.error('Error al acceder a la c�mara: ', error);
        });
    });
  </script>
</body>
</html>
