function distanciaEuclidiana(x1, y1, x2, y2){
    d = Math.sqrt( Math.pow((x2 - x1), 2) + Math.pow((y2 - y1), 2));
	d = d.toFixed(5);		
	return d;
}


const video = document.getElementById('video');
 
function startVideo(){
	navigator.getUserMedia = (navigator.getUserMedia ||
		navigator.webkitGetUserMedia ||
		navigator.mozGetUserMedia ||
		navigator.msGetUserMedia);
	
	navigator.getUserMedia(
		{ video: {} },
		stream => video.srcObject = stream,
		err => console.log(err)
	)
}

//startVideo();

Promise.all([
	//faceapi.nets.tinyFaceDetector.loadFromUri('models'),
	//faceapi.nets.faceLandmark68Net.loadFromUri('models'),
	faceapi.nets.tinyFaceDetector.loadFromUri('models'),
	faceapi.nets.faceLandmark68Net.loadFromUri('models'),
	//faceapi.nets.faceRecognitionNet.loadFromUri('/sistemacomercial2024/models'),
	//faceapi.nets.faceExpressionNet.loadFromUri('/sistemacomercial2024/models'),
	//faceapi.nets.ageGenderNet.loadFromUri('/sistemacomercial2024/models')
]).then(startVideo);

//startVideo();


video.addEventListener('play', ()=> {
	const canvas = faceapi.createCanvasFromMedia(video);
	document.body.append(canvas);
	const displaySize = { width:video.width, height:video.height };
	faceapi.matchDimensions(canvas, displaySize);
	

	cadena = '';
	let de = [];
	setInterval(async()=>{
		const detections = await faceapi.detectAllFaces(video, new
		faceapi.TinyFaceDetectorOptions()).withFaceLandmarks();	
		const ls = detections[0].landmarks._positions;
		//console.log(ls);
		
		de[1] = distanciaEuclidiana(ls[27]._x, ls[27]._y, ls[8]._x, ls[8]._y); 
		de[2] = distanciaEuclidiana(ls[27]._x, ls[27]._y, ls[30]._x, ls[30]._y); 
		de[3] = distanciaEuclidiana(ls[27]._x, ls[27]._y, ls[51]._x, ls[51]._y); 
		de[4] = distanciaEuclidiana(ls[27]._x, ls[27]._y, ls[57]._x, ls[57]._y); 
		de[5] = distanciaEuclidiana(ls[27]._x, ls[27]._y, ls[39]._x, ls[39]._y); 
		de[6] = distanciaEuclidiana(ls[27]._x, ls[27]._y, ls[36]._x, ls[36]._y); 
		de[7] = distanciaEuclidiana(ls[27]._x, ls[27]._y, ls[42]._x, ls[42]._y); 
		de[8] = distanciaEuclidiana(ls[27]._x, ls[27]._y, ls[45]._x, ls[45]._y); 
		de[9] = distanciaEuclidiana(ls[27]._x, ls[27]._y, ls[0]._x, ls[0]._y); 
		de[10] = distanciaEuclidiana(ls[27]._x, ls[27]._y, ls[16]._x, ls[16]._y); 		
		de[11] = distanciaEuclidiana(ls[27]._x, ls[27]._y, ls[17]._x, ls[17]._y); 
		de[12] = distanciaEuclidiana(ls[27]._x, ls[27]._y, ls[26]._x, ls[26]._y); 
		de[13] = distanciaEuclidiana(ls[31]._x, ls[31]._y, ls[2]._x, ls[2]._y); 
		de[14] = distanciaEuclidiana(ls[35]._x, ls[35]._y, ls[14]._x, ls[14]._y); 
		de[15] = distanciaEuclidiana(ls[2]._x, ls[2]._y, ls[14]._x, ls[14]._y); 
		de[16] = distanciaEuclidiana(ls[0]._x, ls[0]._y, ls[16]._x, ls[16]._y); 
		de[17] = distanciaEuclidiana(ls[3]._x, ls[3]._y, ls[13]._x, ls[13]._y); 
		de[18] = distanciaEuclidiana(ls[4]._x, ls[4]._y, ls[12]._x, ls[12]._y); 
		de[19] = distanciaEuclidiana(ls[5]._x, ls[5]._y, ls[11]._x, ls[11]._y); 
		de[20] = distanciaEuclidiana(ls[48]._x, ls[48]._y, ls[54]._x, ls[54]._y); 
		de[21] = distanciaEuclidiana(ls[51]._x, ls[51]._y, ls[62]._x, ls[62]._y); 
		de[22] = distanciaEuclidiana(ls[66]._x, ls[66]._y, ls[57]._x, ls[57]._y); 
		de[23] = distanciaEuclidiana(ls[6]._x, ls[6]._y, ls[10]._x, ls[10]._y); 
		de[24] = distanciaEuclidiana(ls[7]._x, ls[7]._y, ls[9]._x, ls[9]._y); 
		de[25] = distanciaEuclidiana(ls[36]._x, ls[36]._y, ls[45]._x, ls[45]._y); 
		de[26] = distanciaEuclidiana(ls[39]._x, ls[39]._y, ls[42]._x, ls[42]._y); 
		de[27] = distanciaEuclidiana(ls[36]._x, ls[36]._y, ls[39]._x, ls[39]._y); 
		de[28] = distanciaEuclidiana(ls[42]._x, ls[42]._y, ls[45]._x, ls[45]._y); 
		de[29] = distanciaEuclidiana(ls[31]._x, ls[31]._y, ls[35]._x, ls[35]._y); 
		de[30] = distanciaEuclidiana(ls[41]._x, ls[41]._y, ls[31]._x, ls[31]._y); 
		de[31] = distanciaEuclidiana(ls[40]._x, ls[40]._y, ls[31]._x, ls[31]._y); 
		de[32] = distanciaEuclidiana(ls[47]._x, ls[47]._y, ls[35]._x, ls[35]._y); 
		de[33] = distanciaEuclidiana(ls[46]._x, ls[46]._y, ls[35]._x, ls[35]._y); 
		de[34] = distanciaEuclidiana(ls[48]._x, ls[48]._y, ls[4]._x, ls[4]._y); 
		de[35] = distanciaEuclidiana(ls[54]._x, ls[54]._y, ls[12]._x, ls[12]._y); 
		de[36] = distanciaEuclidiana(ls[31]._x, ls[31]._y, ls[35]._x, ls[35]._y); 
		de[37] = distanciaEuclidiana(ls[54]._x, ls[54]._y, ls[12]._x, ls[12]._y); 
		de[38] = distanciaEuclidiana(ls[39]._x, ls[39]._y, ls[8]._x, ls[8]._y); 
		de[39] = distanciaEuclidiana(ls[42]._x, ls[42]._y, ls[8]._x, ls[8]._y); 
		de[40] = distanciaEuclidiana(ls[30]._x, ls[30]._y, ls[8]._x, ls[8]._y); 

		cadena = "";
		for (let i = 1; i <= 40; i++) {
			//echo "<br>";
			if(i == 40){
				$separador = "";
			}else{
				$separador = ",";
			}			
			cadena = cadena + (de[i]/1000) + $separador;
			//console.log("distancia "+i+": ",de[i]);	
		}
		
		//Invocar funcion de reconocimiento facial
		parent.detectarFacial(cadena);
		//parent.document.getElementById('zvector').value = cadena;
		//console.log("cadena: ",cadena);	
		
		//const result = parent.net.run([cadena]);
		//console.log(result);			
		
		//faceapi.TinyFaceDetectorOptions()).withFaceLandmarks().withFaceExpressions();
		//console.log(detections);
		const resizedDetections = faceapi.resizeResults(detections,
		displaySize);
		
		canvas.getContext('2d').clearRect(0,0, canvas.width, canvas.height);
		faceapi.draw.drawDetections(canvas, resizedDetections);
		faceapi.draw.drawFaceLandmarks(canvas, resizedDetections);
		//faceapi.draw.drawFaceExpressions(canvas, resizedDetections);
	},400);
});
