<?php
$estado_session = session_status();
if($estado_session == PHP_SESSION_NONE){
    session_start();
}

date_default_timezone_set('America/Lima');
$script_tz = date_default_timezone_get();

@include "../verifica.php";

//include("../constantes.php");
@include("../conexion.php");


function posicion_calor($conexion, $xtar_codi){

	$arr_calor = array();

	$n_total = 0;
	$n_afavor = 0;
	$n_neutro = 0;
	$n_oposicion = 0;
	$r_actores = mysqli_query($conexion,"SELECT actpos_codi_fk, count(actpos_codi_fk) AS cantidad 
											FROM tareas_actores t
											WHERE tar_codi_fk=$xtar_codi
											GROUP BY actpos_codi_fk
											ORDER BY actpos_codi_fk;");
	while($row_actores = mysqli_fetch_array($r_actores)){
		if($row_actores['actpos_codi_fk']==1){
			$n_afavor = $row_actores['cantidad'];
		}
		if($row_actores['actpos_codi_fk']==2){
			$n_neutro = $row_actores['cantidad'];
		}		
		if($row_actores['actpos_codi_fk']==3){
			$n_oposicion = $row_actores['cantidad'];
		}	
	}
	
	$n_total = 	$n_afavor + $n_neutro + $n_oposicion;
	//echo $n_total."  ".$n_afavor."  ".$n_neutro."  ".$n_oposicion;
	
	if($n_total > 0){
		$xunidad_porcentual = 100 / $n_total;
	}else{
		$xunidad_porcentual = 0;
	}
	
	$porcentaje_afavor = round($n_afavor * $xunidad_porcentual,1);
	$porcentaje_neutro = round($n_neutro * $xunidad_porcentual,1);
	$porcentaje_oposicion = round($n_oposicion * $xunidad_porcentual,1);
	
	//echo "<br>";
	//echo $porcentaje_afavor."%  ".$porcentaje_neutro."%  ".$porcentaje_oposicion."%  ";
	
	$r_calor_afavor = mysqli_query($conexion,"SELECT actposcal_color 
									FROM actores_posicion_calor a 
									WHERE actposcal_estado = 1 
									AND actpos_codi_fk = 1 
									AND $porcentaje_afavor >= actposcal_valor_inicio 
									AND $porcentaje_afavor <= actposcal_valor_fin;");
	while($row_calor_afavor = mysqli_fetch_array($r_calor_afavor)){
		$color_afavor = $row_calor_afavor['actposcal_color'];
	}

	$r_calor_neutro = mysqli_query($conexion,"SELECT actposcal_color 
									FROM actores_posicion_calor a 
									WHERE actposcal_estado = 1 
									AND actpos_codi_fk = 2 
									AND $porcentaje_neutro >= actposcal_valor_inicio 
									AND $porcentaje_neutro <= actposcal_valor_fin;");
	while($row_calor_neutro = mysqli_fetch_array($r_calor_neutro)){
		$color_neutro = $row_calor_neutro['actposcal_color'];
	}
	
	$r_calor_oposicion = mysqli_query($conexion,"SELECT actposcal_color 
									FROM actores_posicion_calor a 
									WHERE actposcal_estado = 1 
									AND actpos_codi_fk = 3 
									AND $porcentaje_oposicion >= actposcal_valor_inicio 
									AND $porcentaje_oposicion <= actposcal_valor_fin;");
	while($row_calor_oposicion = mysqli_fetch_array($r_calor_oposicion)){
		$color_oposicion = $row_calor_oposicion['actposcal_color'];
	}
	
	
	$arr_calor[1]['porcentaje']= $porcentaje_afavor;
	$arr_calor[1]['color']= $color_afavor;
	
	$arr_calor[2]['porcentaje']= $porcentaje_neutro;
	$arr_calor[2]['color']= $color_neutro;
	
	$arr_calor[3]['porcentaje']= $porcentaje_oposicion;
	$arr_calor[3]['color']= $color_oposicion;
	
	return $arr_calor;	
}







function controlarPrivilegios($conexion, $xs_usu_codi, $xymod_codi, $xprivilegio){
	$xusumod_estado = 0;
	$xusumod_crear = 0;
	$xusumod_modificar = 0;
	$xusumod_eliminar = 0;
	$xusumod_fotos = 0;
	$xusumod_activar = 0;
	$r_verifica_privilegio = mysqli_query($conexion,"SELECT * 
													FROM usuarios_modulos u 
													WHERE usu_codi_fk = $xs_usu_codi 
													AND mod_codi_fk = $xymod_codi;");
	while($row_verifica_privilegio = mysqli_fetch_array($r_verifica_privilegio)){
		$xusumod_estado = $row_verifica_privilegio['usumod_estado'];
		$xusumod_crear = $row_verifica_privilegio['usumod_crear'];
		$xusumod_modificar = $row_verifica_privilegio['usumod_modificar'];
		$xusumod_eliminar = $row_verifica_privilegio['usumod_eliminar'];
		$xusumod_fotos = $row_verifica_privilegio['usumod_fotos'];
		$xusumod_activar = $row_verifica_privilegio['usumod_activar'];
		
	}
	
	if($xprivilegio=='estado' and $xusumod_estado != 1){
		?>
		<script language="javascript">
		location.href="inicio";
		alert('ADVERTENCIA: No tiene acceso. Solicitelo al administrador del sistema.');
		</script>			
		<?php
		exit;		
	}
	
	if($xprivilegio=='crear' and $xusumod_crear != 1){
		?>
		<script language="javascript">
		location.href="inicio";
		alert('ADVERTENCIA: No tiene acceso. Solicitelo al administrador del sistema.');
		</script>			
		<?php
		exit;		
	}
	
	if($xprivilegio=='modificar' and $xusumod_modificar != 1){
		?>
		<script language="javascript">
		location.href="inicio";
		alert('ADVERTENCIA: No tiene acceso. Solicitelo al administrador del sistema.');
		</script>			
		<?php
		exit;		
	}	
	
	if($xprivilegio=='eliminar' and $xusumod_eliminar != 1){
		?>
		<script language="javascript">
		location.href="inicio";
		alert('ADVERTENCIA: No tiene acceso. Solicitelo al administrador del sistema.');
		</script>			
		<?php
		exit;		
	}
	
	if($xprivilegio=='fotos' and $xusumod_crear != 1){
		?>
		<script language="javascript">
		location.href="inicio";
		alert('ADVERTENCIA: No tiene acceso. Solicitelo al administrador del sistema.');
		</script>			
		<?php
		exit;		
	}
	
	if($xprivilegio=='activar' and $xusumod_activar != 1){
		?>
		<script language="javascript">
		location.href="inicio";
		alert('ADVERTENCIA: No tiene acceso. Solicitelo al administrador del sistema.');
		</script>			
		<?php
		exit;		
	}
	
	
}





function controlarPrivilegiosMenu($conexion, $xs_usu_codi, $xymod_codi){
	$xusumod_estado = 0;
	$r_verifica_privilegio = mysqli_query($conexion,"SELECT * 
													FROM usuarios_modulos u 
													WHERE usu_codi_fk = $xs_usu_codi 
													AND mod_codi_fk = $xymod_codi;");
	while($row_verifica_privilegio = mysqli_fetch_array($r_verifica_privilegio)){
		$xusumod_estado = $row_verifica_privilegio['usumod_estado'];
	}
	return $xusumod_estado;		
	
}




function controlarPrivilegiosMenuAcciones($conexion, $xs_usu_codi, $xymod_codi, $xprivilegio){
	$xusumod_estado = 0;
	$xusumod_crear = 0;
	$xusumod_modificar = 0;
	$xusumod_eliminar = 0;
	$xusumod_fotos = 0;
	$xusumod_activar = 1;
	
	$xretorno = 1;
	$r_verifica_privilegio2 = mysqli_query($conexion,"SELECT * 
													FROM usuarios_modulos u 
													WHERE usu_codi_fk = $xs_usu_codi 
													AND mod_codi_fk = $xymod_codi;");
	while($row_verifica_privilegio2 = mysqli_fetch_array($r_verifica_privilegio2)){
		$xusumod_estado = $row_verifica_privilegio2['usumod_estado'];
		$xusumod_crear = $row_verifica_privilegio2['usumod_crear'];
		$xusumod_modificar = $row_verifica_privilegio2['usumod_modificar'];
		$xusumod_eliminar = $row_verifica_privilegio2['usumod_eliminar'];
		$xusumod_fotos = $row_verifica_privilegio2['usumod_fotos'];
		$xusumod_activar = $row_verifica_privilegio2['usumod_activar'];		
		
	}
	
	if($xprivilegio=='estado' and $xusumod_estado != 1){
		?>
		<script language="javascript">
		location.href="inicio";
		alert('ADVERTENCIA: No tiene acceso. Solicitelo al administrador del sistema.');
		</script>			
		<?php
		//exit;
		$xretorno = $xusumod_estado;		
	}
	
	if($xprivilegio=='crear' and $xusumod_crear != 1){
		?>
		<script language="javascript">
		alert('ADVERTENCIA: No tiene permiso para Crear registros. Solicitelo al administrador del sistema.');
		</script>			
		<?php
		//exit;	
		$xretorno = $xusumod_crear;			
	}
	
	if($xprivilegio=='modificar' and $xusumod_modificar != 1){
		?>
		<script language="javascript">
		alert('ADVERTENCIA: No tiene permiso para Modificar registros. Solicitelo al administrador del sistema.');
		</script>			
		<?php
		//exit;
		$xretorno = $xusumod_modificar;				
	}	
	
	if($xprivilegio=='eliminar' and $xusumod_eliminar != 1){
		?>
		<script language="javascript">
		alert('ADVERTENCIA: No tiene permiso para Eliminar registros. Solicitelo al administrador del sistema.');
		</script>			
		<?php
		//exit;
		$xretorno = $xusumod_eliminar;					
	}
	
	if($xprivilegio=='fotos' and $xusumod_fotos != 1){
		?>
		<script language="javascript">
		alert('ADVERTENCIA: No tiene permiso para adicionar fotos. Solicitelo al administrador del sistema.');
		</script>			
		<?php
		//exit;		
		$xretorno = $xusumod_fotos;		
	}
	
	if($xprivilegio=='activar' and $xusumod_activar != 1){
		?>
		<script language="javascript">
		alert('ADVERTENCIA: No tiene permiso para Activar o Desactivar registros. Solicitelo al administrador del sistema.');
		</script>			
		<?php
		//exit;		
		$xretorno = $xusumod_activar;		
	}

	return $xretorno;		
}



function controlarPrivilegiosGrupoModulo($conexion, $xs_usu_codi, $xymodgru_codi){
	$xretorno = 0;
	$r_verifica_privilegio_grupo = mysqli_query($conexion,"SELECT * FROM modulos m
													INNER JOIN usuarios_modulos u ON u.mod_codi_fk=m.mod_codi
													WHERE modgru_codi_fk = $xymodgru_codi
													AND usu_codi_fk = $xs_usu_codi
													AND usumod_estado = 1
													LIMIT 1;");
	if(mysqli_num_rows($r_verifica_privilegio_grupo) > 0){
		$xretorno = 1;
	}
	return $xretorno;
}


function obtenerSemanas($fechaInicio, $fechaFin) {
	$xfechaInicio = $fechaInicio;
	$xfechaFin = $fechaFin;
    $fechaInicio = new DateTime($fechaInicio);
    $fechaFin = new DateTime($fechaFin);
    $intervalo = new DateInterval('P1D'); // Intervalo de 1 da
    
    $periodo = new DatePeriod($fechaInicio, $intervalo, $fechaFin);
    
	$n = 0;
	$xlunes='';
	$xdomingo='';
	$semanas = array();
    foreach ($periodo as $fecha) {
		
        if ($fecha->format('N') == 7) { // Nmero del da de la semana (1=lunes, 7=domingo)
			$xdomingo = $fecha->format('Y-m-d');
			$xlunes = date("Y-m-d",strtotime ('-6 day', strtotime($xdomingo)) );
			$n = $n + 1;
			
			if($n==1){
				$xlunes = $xfechaInicio;
			}
			
			$semanas[$n]['lunes']=$xlunes;
			$semanas[$n]['domingo']=$xdomingo;
        }
    }
    
	if($xfechaFin > $xdomingo){
		$xlunes = date("Y-m-d",strtotime ('1 day', strtotime($xdomingo)) );	
	
		$semanas[$n+1]['lunes']=$xlunes;
		$semanas[$n+1]['domingo']=$xfechaFin;		
	}
	
    return $semanas;
}




function obtenerSemanas_2($fechaInicio, $fechaFin) {
	$xfechaInicio = $fechaInicio;
	$xfechaFin = $fechaFin;
    $fechaInicio = new DateTime($fechaInicio);
    $fechaFin = new DateTime($fechaFin);
    $intervalo = new DateInterval('P1D'); // Intervalo de 1 da
    
    $periodo = new DatePeriod($fechaInicio, $intervalo, $fechaFin);
    
	$n = 0;
	$xlunes='';
	$xdomingo='';
	$semanas = array();
    foreach ($periodo as $fecha) {
		
        if ($fecha->format('N') == 7) { // Nmero del da de la semana (1=lunes, 7=domingo)
			$xdomingo = $fecha->format('Y-m-d');
			$xlunes = date("Y-m-d",strtotime ('-6 day', strtotime($xdomingo)) );
			$n = $n + 1;
			
			if($n==1){
				$xlunes = $xfechaInicio;
			}
			
			$semanas[$n]['lunes']=$xlunes;
			$semanas[$n]['domingo']=$xdomingo;
			
			//echo "<br>";
			//echo $xlunes." - ".$xdomingo;
        }
    }
    
	if($xfechaFin > $xdomingo){
		$xlunes = date("Y-m-d",strtotime ('1 day', strtotime($xdomingo)) );	
	
		$semanas[$n+1]['lunes']=$xlunes;
		$semanas[$n+1]['domingo']=$xfechaFin;
		
		//echo "<br>";
		//echo $xlunes." - ".$xfechaFin;
		
				
	}
	
    return $semanas;
}



function calcular_amortizacion($xordcom_codi, $conexion){
	$xmonto = 0;
	$xamortizado = 0;
	$r_monto = mysqli_query($conexion,"SELECT SUM(ordcomdet_cantidad * ordcomdet_precio) as monto
										FROM orden_compra_detalle ocd
										WHERE ordcom_codi_fk = $xordcom_codi;");									
	while($row_monto = mysqli_fetch_array($r_monto)){
		$xmonto = $row_monto['monto'];
	}
	
	$r_amortizacion = mysqli_query($conexion,"SELECT SUM(opecaj_monto) as amortizado
										FROM operacion_caja oc
										INNER JOIN orden_compra_caja occ ON occ.opecaj_codi_fk=oc.opecaj_codi
										WHERE ordcom_codi_fk = $xordcom_codi
										AND opecaj_estado=1;");									
	while($row_amortizado = mysqli_fetch_array($r_amortizacion)){
		$xamortizado = $row_amortizado['amortizado'];
	}
	
	$xsaldo = $xmonto - $xamortizado;
	
	return $xsaldo;	
}


function definir_estado_de_almacen($xordcom_codi, $conexion){
	$arr_estado_almacen = array(); 
	$xcantidad_compra=0;
	$r_compra = mysqli_query($conexion,"SELECT ocd.ordcomdet_cantidad, um.unimed_cantidad_unidad, um.unimed_nombre, 
											SUM(ocd.ordcomdet_cantidad * um.unimed_cantidad_unidad) AS cantidad_compra
										FROM orden_compra_detalle ocd
										INNER JOIN unidades_medida um ON um.unimed_codi=ocd.unimed_codi_fk
											WHERE ocd.ordcom_codi_fk = $xordcom_codi;");
	while($row_compra = mysqli_fetch_array($r_compra)){
		$xcantidad_compra = $row_compra['cantidad_compra'];
	}
	
	$xcantidad_ingreso=0;
	$r_ingreso = mysqli_query($conexion,"SELECT oad.opealmdet_cantidad, um.unimed_cantidad_unidad, um.unimed_nombre, 
											SUM(oad.opealmdet_cantidad * um.unimed_cantidad_unidad) AS cantidad_ingreso
										FROM operacion_almacen_detalle oad
										INNER JOIN operacion_almacen oa ON oa.opealm_codi = oad.opealm_codi_fk
										INNER JOIN unidades_medida um ON um.unimed_codi=oad.unimed_codi_fk
										INNER JOIN orden_compra_almacen oca ON oca.opealm_codi_fk = oa.opealm_codi
											WHERE oa.opealm_estado=1
											AND oca.ordcom_codi_fk = $xordcom_codi;");
	while($row_ingreso = mysqli_fetch_array($r_ingreso)){
		$xcantidad_ingreso = $row_ingreso['cantidad_ingreso'];
	}
	
	$xcantidad_saldo = $xcantidad_compra - $xcantidad_ingreso;
	if($xcantidad_saldo == 0){	
		$arr_estado_almacen['estado'] = "COMPLETO";	
		$arr_estado_almacen['estado_label'] = "<B><div style='color:#66CC00;'>COMPLETO</div></B>";	
	}else{
		if($xcantidad_saldo > 0){
			$arr_estado_almacen['estado'] = "PENDIENTE";	
			$arr_estado_almacen['estado_label'] = "<B><div style='color:#FFCC00;'>PENDIENTE</div></B>";				
		}else{
			$arr_estado_almacen['estado'] = "INCONSISTENTE";	
			$arr_estado_almacen['estado_label'] = "<B><div style='color:#FF0000;'>INCONSISTENTE</div></B>";	
		}
	}
	
	return $arr_estado_almacen;
}




function calcular_amortizacion_ventas($xordped_codi, $conexion){
	$xmonto = 0;
	$xamortizado = 0;
	$r_monto = mysqli_query($conexion,"SELECT SUM(ordpeddet_cantidad * ordpeddet_precio) as monto
										FROM orden_pedido_detalle opd
										WHERE ordped_codi_fk = $xordped_codi;");									
	while($row_monto = mysqli_fetch_array($r_monto)){
		$xmonto = $row_monto['monto'];
	}
	
	$r_amortizacion = mysqli_query($conexion,"SELECT SUM(opecaj_monto) as amortizado
										FROM operacion_caja oc
										INNER JOIN orden_pedido_caja opc ON opc.opecaj_codi_fk=oc.opecaj_codi
										WHERE ordped_codi_fk = $xordped_codi
										AND opecaj_estado=1;");									
	while($row_amortizado = mysqli_fetch_array($r_amortizacion)){
		$xamortizado = $row_amortizado['amortizado'];
	}
	
	$xsaldo = $xmonto - $xamortizado;
	$xsaldo = number_format($xsaldo, 2, '.','');
	
	return $xsaldo;	
}



function definir_estado_de_almacen_ventas($xordped_codi, $conexion){
	$arr_estado_almacen = array(); 
	$xcantidad_venta=0;
	$r_venta = mysqli_query($conexion,"SELECT opd.ordpeddet_cantidad, um.unimed_cantidad_unidad, um.unimed_nombre, 
											SUM(opd.ordpeddet_cantidad * um.unimed_cantidad_unidad) AS cantidad_venta
										FROM orden_pedido_detalle opd 
										INNER JOIN unidades_medida um ON um.unimed_codi=opd.unimed_codi_fk
											WHERE opd.ordped_codi_fk = $xordped_codi;");
	while($row_venta = mysqli_fetch_array($r_venta)){
		$xcantidad_venta = $row_venta['cantidad_venta'];
	}
	
	$xcantidad_ingreso=0;
	$r_ingreso = mysqli_query($conexion,"SELECT oad.opealmdet_cantidad, um.unimed_cantidad_unidad, um.unimed_nombre, 
											SUM(oad.opealmdet_cantidad * um.unimed_cantidad_unidad) AS cantidad_ingreso
										FROM operacion_almacen_detalle oad
										INNER JOIN operacion_almacen oa ON oa.opealm_codi = oad.opealm_codi_fk
										INNER JOIN unidades_medida um ON um.unimed_codi=oad.unimed_codi_fk
										INNER JOIN orden_pedido_almacen opa ON opa.opealm_codi_fk = oa.opealm_codi
											WHERE oa.opealm_estado=1
											AND opa.ordped_codi_fk = $xordped_codi;");
	while($row_ingreso = mysqli_fetch_array($r_ingreso)){
		$xcantidad_ingreso = $row_ingreso['cantidad_ingreso'];
	}
	
	$xcantidad_saldo = $xcantidad_venta - $xcantidad_ingreso;
	if($xcantidad_saldo == 0){	
		$arr_estado_almacen['estado'] = "COMPLETO";	
		$arr_estado_almacen['estado_label'] = "<B><div style='color:#66CC00;'>COMPLETO</div></B>";	
	}else{
		if($xcantidad_saldo > 0){
			$arr_estado_almacen['estado'] = "PENDIENTE";	
			$arr_estado_almacen['estado_label'] = "<B><div style='color:#FFCC00;'>PENDIENTE</div></B>";				
		}else{
			$arr_estado_almacen['estado'] = "INCONSISTENTE";	
			$arr_estado_almacen['estado_label'] = "<B><div style='color:#FF0000;'>INCONSISTENTE</div></B>";	
		}
	}
	
	$cadena_almacenes = '';
	$r_almacenes = mysqli_query($conexion,"SELECT oa.opealm_numero
											FROM orden_pedido_almacen o
											INNER JOIN operacion_almacen oa ON oa.opealm_codi = o.opealm_codi_fk
											WHERE o.ordped_codi_fk = $xordped_codi
											ORDER BY oa.opealm_codi;");
	while($row_almacenes = mysqli_fetch_array($r_almacenes)){
		$xalmacenes = $row_almacenes['opealm_numero'];
		$cadena_almacenes = $cadena_almacenes.", ".$xalmacenes;
	}
	
	if(mysqli_num_rows($r_almacenes)>0){
		$arr_estado_almacen['almacen'] = "Nro. almacen: ".$cadena_almacenes;	
	}else{
		$arr_estado_almacen['almacen'] = "";
	}
											
	return $arr_estado_almacen;
}



function definir_estado_de_almacen_compras($xordcom_codi, $conexion){
	$arr_estado_almacen = array(); 
	$xcantidad_compra=0;
	$r_compra = mysqli_query($conexion,"SELECT ocd.ordcomdet_cantidad, um.unimed_cantidad_unidad, um.unimed_nombre, 
											SUM(ocd.ordcomdet_cantidad * um.unimed_cantidad_unidad) AS cantidad_compra
										FROM orden_compra_detalle ocd 
										INNER JOIN unidades_medida um ON um.unimed_codi=ocd.unimed_codi_fk
											WHERE ocd.ordcom_codi_fk = $xordcom_codi;");
	while($row_compra = mysqli_fetch_array($r_compra)){
		$xcantidad_compra = $row_compra['cantidad_compra'];
	}
	
	$xcantidad_ingreso=0;
	$r_ingreso = mysqli_query($conexion,"SELECT oad.opealmdet_cantidad, um.unimed_cantidad_unidad, um.unimed_nombre, 
											SUM(oad.opealmdet_cantidad * um.unimed_cantidad_unidad) AS cantidad_ingreso
										FROM operacion_almacen_detalle oad
										INNER JOIN operacion_almacen oa ON oa.opealm_codi = oad.opealm_codi_fk
										INNER JOIN unidades_medida um ON um.unimed_codi=oad.unimed_codi_fk
										INNER JOIN orden_compra_almacen oca ON oca.opealm_codi_fk = oa.opealm_codi
											WHERE oa.opealm_estado=1
											AND oca.ordcom_codi_fk = $xordcom_codi;");
	while($row_ingreso = mysqli_fetch_array($r_ingreso)){
		$xcantidad_ingreso = $row_ingreso['cantidad_ingreso'];
	}
	
	$xcantidad_saldo = $xcantidad_compra - $xcantidad_ingreso;
	if($xcantidad_saldo == 0){	
		$arr_estado_almacen['estado'] = "COMPLETO";	
		$arr_estado_almacen['estado_label'] = "<B><div style='color:#66CC00;'>COMPLETO</div></B>";	
	}else{
		if($xcantidad_saldo > 0){
			$arr_estado_almacen['estado'] = "PENDIENTE";	
			$arr_estado_almacen['estado_label'] = "<B><div style='color:#FFCC00;'>PENDIENTE</div></B>";				
		}else{
			$arr_estado_almacen['estado'] = "INCONSISTENTE";	
			$arr_estado_almacen['estado_label'] = "<B><div style='color:#FF0000;'>INCONSISTENTE</div></B>";	
		}
	}
	
	$cadena_almacenes = '';
	$r_almacenes = mysqli_query($conexion,"SELECT oa.opealm_numero
											FROM orden_compra_almacen o
											INNER JOIN operacion_almacen oa ON oa.opealm_codi = o.opealm_codi_fk
											WHERE o.ordcom_codi_fk = $xordcom_codi
											ORDER BY oa.opealm_codi;");
	while($row_almacenes = mysqli_fetch_array($r_almacenes)){
		$xalmacenes = $row_almacenes['opealm_numero'];
		$cadena_almacenes = $cadena_almacenes.", ".$xalmacenes;
	}
	
	if(mysqli_num_rows($r_almacenes)>0){
		$arr_estado_almacen['almacen'] = "Nro. almacen: ".$cadena_almacenes;	
	}else{
		$arr_estado_almacen['almacen'] = "";
	}
											
	return $arr_estado_almacen;
}



function calcular_amortizacion_notacreditoventas($xnotcre_codi, $conexion, $xmonto){
	$xmonto = 0;
	$xamortizado = 0;
	
	//echo "   xmonto: ".$xmonto;
	
	$r_monto = mysqli_query($conexion,"SELECT nct.*,  
											SUM((notcredet_precio * notcredet_cantidad) )  AS monto,  
											SUM((notcredet_precio_descuento * notcredet_cantidad) )  AS monto_descuento,  
											SUM((notcredet_precio * notcredet_cantidad_devolver) )  AS monto_devolver
										FROM nota_credito_detalle ncd
										INNER JOIN nota_credito nc ON nc.notcre_codi = ncd.notcre_codi_fk
										INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi=nc.notcretip_codi_fk
										WHERE ncd.notcre_codi_fk = $xnotcre_codi;");
	while($row_monto = mysqli_fetch_array($r_monto)){
		//$xmonto = $row_monto['monto'];
		
		$zmonto = $row_monto['monto'];
		$zmonto_descuento = $row_monto['monto_descuento'];
		$zmonto_devolver = $row_monto['monto_devolver'];
		
		if($row_monto['notcretip_modificar_precio']==1){
			$xmonto = $zmonto_descuento;
		}else{
			if($row_monto['notcretip_modificar_cantidad']==1){
				$xmonto = $zmonto_devolver;
			}else{
				$xmonto = $zmonto;
			}				
		}		
		
	}
	
	$r_amortizacion = mysqli_query($conexion,"SELECT SUM(opecaj_monto) as amortizado
										FROM operacion_caja oc
										INNER JOIN nota_credito_caja ncc ON ncc.opecaj_codi_fk=oc.opecaj_codi
										WHERE notcre_codi_fk = $xnotcre_codi
										AND opecaj_estado=1;");									
	while($row_amortizado = mysqli_fetch_array($r_amortizacion)){
		$xamortizado = $row_amortizado['amortizado'];
	}
	
	$xsaldo = $xmonto - $xamortizado;
	$xsaldo = number_format($xsaldo, 2, '.','');
	
	return $xsaldo;	
}





function definir_estado_de_almacen_notacredito($xnotcre_codi, $conexion){
	$arr_estado_almacen = array(); 
	$xcantidad_notacredito=0;
	$r_notacredito = mysqli_query($conexion,"SELECT ncd.notcredet_cantidad, um.unimed_cantidad_unidad, um.unimed_nombre, 
											SUM(ncd.notcredet_cantidad * um.unimed_cantidad_unidad) AS cantidad_notacredito
										FROM nota_credito_detalle ncd
										INNER JOIN unidades_medida um ON um.unimed_codi=ncd.unimed_codi_fk
											WHERE ncd.notcre_codi_fk = $xnotcre_codi;");
	while($row_notacredito = mysqli_fetch_array($r_notacredito)){
		$xcantidad_notacredito = $row_notacredito['cantidad_notacredito'];
	}
	
	$xcantidad_ingreso=0;
	$r_ingreso = mysqli_query($conexion,"SELECT oad.opealmdet_cantidad, um.unimed_cantidad_unidad, um.unimed_nombre, 
											SUM(oad.opealmdet_cantidad * um.unimed_cantidad_unidad) AS cantidad_ingreso
										FROM operacion_almacen_detalle oad
										INNER JOIN operacion_almacen oa ON oa.opealm_codi = oad.opealm_codi_fk
										INNER JOIN unidades_medida um ON um.unimed_codi=oad.unimed_codi_fk
										INNER JOIN nota_credito_almacen nca ON nca.opealm_codi_fk = oa.opealm_codi
											WHERE oa.opealm_estado=1
											AND nca.notcre_codi_fk = $xnotcre_codi;");
	while($row_ingreso = mysqli_fetch_array($r_ingreso)){
		$xcantidad_ingreso = $row_ingreso['cantidad_ingreso'];
	}
	
	$xcantidad_saldo = $xcantidad_notacredito - $xcantidad_ingreso;
	if($xcantidad_saldo == 0){	
		$arr_estado_almacen['estado'] = "COMPLETO";	
		$arr_estado_almacen['estado_label'] = "<B><div style='color:#66CC00;'>COMPLETO</div></B>";	
	}else{
		if($xcantidad_saldo > 0){
			$arr_estado_almacen['estado'] = "PENDIENTE";	
			$arr_estado_almacen['estado_label'] = "<B><div style='color:#FFCC00;'>PENDIENTE</div></B>";				
		}else{
			$arr_estado_almacen['estado'] = "INCONSISTENTE";	
			$arr_estado_almacen['estado_label'] = "<B><div style='color:#FF0000;'>INCONSISTENTE</div></B>";	
		}
	}
	
	return $arr_estado_almacen;
}





function calcular_amortizacion_notadebitoventas($xnotdeb_codi, $conexion, $xmonto){
	$xmonto = 0;
	$xamortizado = 0;
	
	$r_monto = mysqli_query($conexion,"SELECT ndt.*,
											SUM((notdebdet_precio * notdebdet_cantidad) )  AS monto,
											SUM((notdebdet_precio_descuento * notdebdet_cantidad) )  AS monto_descuento,  
											SUM((notdebdet_precio * notdebdet_cantidad_devolver) )  AS monto_devolver
										FROM nota_debito_detalle ndd
											INNER JOIN nota_debito nd ON nd.notdeb_codi = ndd.notdeb_codi_fk
											INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi=nd.notdebtip_codi_fk
										WHERE ndd.notdeb_codi_fk = $xnotdeb_codi;");
	while($row_monto = mysqli_fetch_array($r_monto)){
		//$xmonto = $row_monto['monto'];
		
		$zmonto = $row_monto['monto'];
		$zmonto_descuento = $row_monto['monto_descuento'];
		$zmonto_devolver = $row_monto['monto_devolver'];
		
		if($row_monto['notdebtip_modificar_precio']==1){
			$xmonto = $zmonto_descuento;
		}else{
			if($row_monto['notdebtip_modificar_cantidad']==1){
				$xmonto = $zmonto_devolver;
			}else{
				$xmonto = $zmonto;
			}				
		}		
		
	}
	
	$r_amortizacion = mysqli_query($conexion,"SELECT SUM(opecaj_monto) as amortizado
										FROM operacion_caja oc
										INNER JOIN nota_debito_caja ndc ON ndc.opecaj_codi_fk=oc.opecaj_codi
										WHERE notdeb_codi_fk = $xnotdeb_codi
										AND opecaj_estado=1;");									
	while($row_amortizado = mysqli_fetch_array($r_amortizacion)){
		$xamortizado = $row_amortizado['amortizado'];
	}
	
	$xsaldo = $xmonto - $xamortizado;
	$xsaldo = number_format($xsaldo, 2, '.','');
	
	return $xsaldo;	
}


function verificar_registros_vinculados($tabla, $campo, $parametro, $conexion){
	$r = mysqli_query($conexion,"SELECT 1 
								 FROM $tabla 
								 WHERE $campo = $parametro 
								 LIMIT 1;");
	return mysqli_num_rows($r);
}


function verificar_registros_existentes($tabla, $campo_1, $campo_2, $parametro_1, $parametro_2, $xaccion, $conexion){
	if($xaccion=='adicionar'){
		$r = mysqli_query($conexion,"SELECT 1 
								 FROM $tabla 
								 WHERE $campo_1 = '$parametro_1'
								 LIMIT 1;");
	}
	
	if($xaccion=='modificar'){
		$r = mysqli_query($conexion,"SELECT 1 
								 FROM $tabla 
								 WHERE $campo_1 = '$parametro_1' 
								 AND $campo_2 != '$parametro_2'
								 LIMIT 1;");
	}							 							 
	return mysqli_num_rows($r);
}

	
function cantidades_montos_creditos_debitos($xprd_codi, $xfecha_inicio, $xfecha_fin, $conexion, $xemp_criterio){
	$arr_creditos_debitos = array();	
	
	?>
	<script language="javascript">
	//alert("aqui");
	</script>
	<?php	
	
			
	//INICIO NOTA DE CREDITO
	$xcantidad_notacredito = 0;
	$xmonto_notacredito = 0;			
	
	$r_notacredito_cantidad = mysqli_query($conexion,"SELECT ncd.prd_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
											WHERE ncd.prd_codi_fk = $xprd_codi
												AND notcre_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_cantidad=1;");
	while($row_notacredito_cantidad = mysqli_fetch_array($r_notacredito_cantidad)){
		$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notacredito_precio = mysqli_query($conexion,"SELECT ncd.prd_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
											WHERE ncd.prd_codi_fk = $xprd_codi
												AND notcre_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_precio=1;");
	while($row_notacredito_precio = mysqli_fetch_array($r_notacredito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notacredito = $row_notacredito_precio['monto'] * -1;
	}										
	//FIN NOTA DE CREDITO




	//INICIO NOTA DE DEBITO
	$xcantidad_notadebito = 0;
	$xmonto_notadebito = 0;			
	
	$r_notadebito_cantidad = mysqli_query($conexion,"SELECT ndd.prd_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
											WHERE ndd.prd_codi_fk = $xprd_codi
												AND notdeb_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_cantidad=1;");
	while($row_notadebito_cantidad = mysqli_fetch_array($r_notadebito_cantidad)){
		$xcantidad_notadebito = $row_notadebito_cantidad['cantidad'];
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notadebito_precio = mysqli_query($conexion,"SELECT ndd.prd_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
											WHERE ndd.prd_codi_fk = $xprd_codi
												AND notdeb_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_precio=1;");
	while($row_notadebito_precio = mysqli_fetch_array($r_notadebito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notadebito = $row_notadebito_precio['monto'];
	}										
	//FIN NOTA DE DEBITO
	
	$arr_creditos_debitos['cantidad_notacredito'] = $xcantidad_notacredito;
	$arr_creditos_debitos['monto_notacredito'] = $xmonto_notacredito;
	$arr_creditos_debitos['cantidad_notadebito'] = $xcantidad_notadebito;
	$arr_creditos_debitos['monto_notadebito'] = $xmonto_notadebito;

	return $arr_creditos_debitos;
	
}




function cantidades_montos_creditos_debitos_categorias($xprdfam_codi, $xfecha_inicio, $xfecha_fin, $conexion, $xemp_criterio){
	$arr_creditos_debitos = array();		
			
	//INICIO NOTA DE CREDITO
	$xcantidad_notacredito = 0;
	$xmonto_notacredito = 0;			
	
	$r_notacredito_cantidad = mysqli_query($conexion,"SELECT ncd.prd_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
												INNER JOIN productos prd ON prd.prd_codi = ncd.prd_codi_fk
											WHERE prd.prdfam_codi_fk = $xprdfam_codi
												AND notcre_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_cantidad=1;");
	while($row_notacredito_cantidad = mysqli_fetch_array($r_notacredito_cantidad)){
		$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notacredito_precio = mysqli_query($conexion,"SELECT ncd.prd_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
												INNER JOIN productos prd ON prd.prd_codi = ncd.prd_codi_fk
											WHERE prd.prdfam_codi_fk = $xprdfam_codi
												AND notcre_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_precio=1;");
	while($row_notacredito_precio = mysqli_fetch_array($r_notacredito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notacredito = $row_notacredito_precio['monto'] * -1;
	}										
	//FIN NOTA DE CREDITO




	//INICIO NOTA DE DEBITO
	$xcantidad_notadebito = 0;
	$xmonto_notadebito = 0;			
	
	$r_notadebito_cantidad = mysqli_query($conexion,"SELECT ndd.prd_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
												INNER JOIN productos prd ON prd.prd_codi = ndd.prd_codi_fk
											WHERE prd.prdfam_codi_fk = $xprdfam_codi
												AND notdeb_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_cantidad=1;");
	while($row_notadebito_cantidad = mysqli_fetch_array($r_notadebito_cantidad)){
		$xcantidad_notadebito = $row_notadebito_cantidad['cantidad'];
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notadebito_precio = mysqli_query($conexion,"SELECT ndd.prd_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
												INNER JOIN productos prd ON prd.prd_codi = ndd.prd_codi_fk
											WHERE prd.prdfam_codi_fk = $xprdfam_codi
												AND notdeb_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_precio=1;");
	while($row_notadebito_precio = mysqli_fetch_array($r_notadebito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notadebito = $row_notadebito_precio['monto'];
	}										
	//FIN NOTA DE DEBITO
	
	$arr_creditos_debitos['cantidad_notacredito'] = $xcantidad_notacredito;
	$arr_creditos_debitos['monto_notacredito'] = $xmonto_notacredito;
	$arr_creditos_debitos['cantidad_notadebito'] = $xcantidad_notadebito;
	$arr_creditos_debitos['monto_notadebito'] = $xmonto_notadebito;

	return $arr_creditos_debitos;
	
}


function cantidades_montos_creditos_debitos_dia($xprd_codi, $xfecha_inicio, $xfecha_fin, $ddia, $conexion, $xemp_criterio){
	$arr_creditos_debitos = array();		
			
	//INICIO NOTA DE CREDITO
	$xcantidad_notacredito = 0;
	$xmonto_notacredito = 0;			
	
	$r_notacredito_cantidad = mysqli_query($conexion,"SELECT ncd.prd_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
											WHERE ncd.prd_codi_fk = $xprd_codi
												AND notcre_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_cantidad=1
												AND WEEKDAY(o.ordped_fechahora) = $ddia;");
	while($row_notacredito_cantidad = mysqli_fetch_array($r_notacredito_cantidad)){
		$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notacredito_precio = mysqli_query($conexion,"SELECT ncd.prd_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
											WHERE ncd.prd_codi_fk = $xprd_codi
												AND notcre_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_precio=1
												AND WEEKDAY(o.ordped_fechahora) = $ddia;");
	while($row_notacredito_precio = mysqli_fetch_array($r_notacredito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notacredito = $row_notacredito_precio['monto'] * -1;
	}										
	//FIN NOTA DE CREDITO




	//INICIO NOTA DE DEBITO
	$xcantidad_notadebito = 0;
	$xmonto_notadebito = 0;			
	
	$r_notadebito_cantidad = mysqli_query($conexion,"SELECT ndd.prd_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
											WHERE ndd.prd_codi_fk = $xprd_codi
												AND notdeb_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_cantidad=1
												AND WEEKDAY(o.ordped_fechahora) = $ddia;");
	while($row_notadebito_cantidad = mysqli_fetch_array($r_notadebito_cantidad)){
		$xcantidad_notadebito = $row_notadebito_cantidad['cantidad'];
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notadebito_precio = mysqli_query($conexion,"SELECT ndd.prd_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
											WHERE ndd.prd_codi_fk = $xprd_codi
												AND notdeb_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_precio=1
												AND WEEKDAY(o.ordped_fechahora) = $ddia;");
	while($row_notadebito_precio = mysqli_fetch_array($r_notadebito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notadebito = $row_notadebito_precio['monto'];
	}										
	//FIN NOTA DE DEBITO
	
	$arr_creditos_debitos['cantidad_notacredito'] = $xcantidad_notacredito;
	$arr_creditos_debitos['monto_notacredito'] = $xmonto_notacredito;
	$arr_creditos_debitos['cantidad_notadebito'] = $xcantidad_notadebito;
	$arr_creditos_debitos['monto_notadebito'] = $xmonto_notadebito;

	return $arr_creditos_debitos;
	
}



function cantidades_montos_creditos_debitos_hora($xprd_codi, $xfecha_inicio, $xfecha_fin, $hhora, $conexion, $xemp_criterio){
	$arr_creditos_debitos = array();		
			
	//INICIO NOTA DE CREDITO
	$xcantidad_notacredito = 0;
	$xmonto_notacredito = 0;			
	
	$r_notacredito_cantidad = mysqli_query($conexion,"SELECT ncd.prd_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
											WHERE ncd.prd_codi_fk = $xprd_codi
												AND notcre_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_cantidad=1
												AND HOUR(o.ordped_fechahora) = $hhora;");
	while($row_notacredito_cantidad = mysqli_fetch_array($r_notacredito_cantidad)){
		$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notacredito_precio = mysqli_query($conexion,"SELECT ncd.prd_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
											WHERE ncd.prd_codi_fk = $xprd_codi
												AND notcre_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_precio=1
												AND HOUR(o.ordped_fechahora) = $hhora;");
	while($row_notacredito_precio = mysqli_fetch_array($r_notacredito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notacredito = $row_notacredito_precio['monto'] * -1;
	}										
	//FIN NOTA DE CREDITO




	//INICIO NOTA DE DEBITO
	$xcantidad_notadebito = 0;
	$xmonto_notadebito = 0;			
	
	$r_notadebito_cantidad = mysqli_query($conexion,"SELECT ndd.prd_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
											WHERE ndd.prd_codi_fk = $xprd_codi
												AND notdeb_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_cantidad=1
												AND HOUR(o.ordped_fechahora) = $hhora;");
	while($row_notadebito_cantidad = mysqli_fetch_array($r_notadebito_cantidad)){
		$xcantidad_notadebito = $row_notadebito_cantidad['cantidad'];
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notadebito_precio = mysqli_query($conexion,"SELECT ndd.prd_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
											WHERE ndd.prd_codi_fk = $xprd_codi
												AND notdeb_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_precio=1
												AND HOUR(o.ordped_fechahora) = $hhora;");
	while($row_notadebito_precio = mysqli_fetch_array($r_notadebito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notadebito = $row_notadebito_precio['monto'];
	}										
	//FIN NOTA DE DEBITO
	
	$arr_creditos_debitos['cantidad_notacredito'] = $xcantidad_notacredito;
	$arr_creditos_debitos['monto_notacredito'] = $xmonto_notacredito;
	$arr_creditos_debitos['cantidad_notadebito'] = $xcantidad_notadebito;
	$arr_creditos_debitos['monto_notadebito'] = $xmonto_notadebito;

	return $arr_creditos_debitos;
	
}



function cantidades_montos_creditos_debitos_2____($xfecha_inicio, $xfecha_fin, $conexion){
	$arr_creditos_debitos = array();		
			
	//INICIO NOTA DE CREDITO
	$xcantidad_notacredito = 0;
	$xmonto_notacredito = 0;			
	
	$r_notacredito_cantidad = mysqli_query($conexion,"SELECT ncd.prd_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
											WHERE notcre_estado=1
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcretip_suma_cantidad=1;");
	while($row_notacredito_cantidad = mysqli_fetch_array($r_notacredito_cantidad)){
		$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notacredito_precio = mysqli_query($conexion,"SELECT ncd.prd_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
											WHERE notcre_estado=1
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcretip_suma_precio=1;");
	while($row_notacredito_precio = mysqli_fetch_array($r_notacredito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notacredito = $row_notacredito_precio['monto'] * -1;
	}										
	//FIN NOTA DE CREDITO




	//INICIO NOTA DE DEBITO
	$xcantidad_notadebito = 0;
	$xmonto_notadebito = 0;			
	
	$r_notadebito_cantidad = mysqli_query($conexion,"SELECT ndd.prd_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
											WHERE notdeb_estado=1
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebtip_suma_cantidad=1;");
	while($row_notadebito_cantidad = mysqli_fetch_array($r_notadebito_cantidad)){
		$xcantidad_notadebito = $row_notadebito_cantidad['cantidad'];
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notadebito_precio = mysqli_query($conexion,"SELECT ndd.prd_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
											WHERE notdeb_estado=1
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebtip_suma_precio=1;");
	while($row_notadebito_precio = mysqli_fetch_array($r_notadebito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notadebito = $row_notadebito_precio['monto'];
	}										
	//FIN NOTA DE DEBITO
	
	$arr_creditos_debitos['cantidad_notacredito'] = $xcantidad_notacredito;
	$arr_creditos_debitos['monto_notacredito'] = $xmonto_notacredito;
	$arr_creditos_debitos['cantidad_notadebito'] = $xcantidad_notadebito;
	$arr_creditos_debitos['monto_notadebito'] = $xmonto_notadebito;

	return $arr_creditos_debitos;
	
}





function cantidades_montos_creditos_debitos_2($xfecha_inicio, $xfecha_fin, $conexion, $xemp_criterio){
        
	$arr_creditos_debitos = array();		
			
	//INICIO NOTA DE CREDITO
	$xcantidad_notacredito = 0;
	$xmonto_notacredito = 0;			
	
	$r_notacredito_cantidad = mysqli_query($conexion,"SELECT ncd.prd_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
											WHERE notcre_estado=1
											    AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_cantidad=1;");
	while($row_notacredito_cantidad = mysqli_fetch_array($r_notacredito_cantidad)){
		$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notacredito_precio = mysqli_query($conexion,"SELECT ncd.prd_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
											WHERE notcre_estado=1
											    AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_precio=1;");
	while($row_notacredito_precio = mysqli_fetch_array($r_notacredito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notacredito = $row_notacredito_precio['monto'] * -1;
	}										
	//FIN NOTA DE CREDITO




	//INICIO NOTA DE DEBITO
	$xcantidad_notadebito = 0;
	$xmonto_notadebito = 0;			
	
	$r_notadebito_cantidad = mysqli_query($conexion,"SELECT ndd.prd_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
											WHERE notdeb_estado=1
											    AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_cantidad=1;");
	while($row_notadebito_cantidad = mysqli_fetch_array($r_notadebito_cantidad)){
		$xcantidad_notadebito = $row_notadebito_cantidad['cantidad'];
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notadebito_precio = mysqli_query($conexion,"SELECT ndd.prd_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
											WHERE notdeb_estado=1
											    AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_precio=1;");
	while($row_notadebito_precio = mysqli_fetch_array($r_notadebito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notadebito = $row_notadebito_precio['monto'];
	}										
	//FIN NOTA DE DEBITO
	
	$arr_creditos_debitos['cantidad_notacredito'] = $xcantidad_notacredito;
	$arr_creditos_debitos['monto_notacredito'] = $xmonto_notacredito;
	$arr_creditos_debitos['cantidad_notadebito'] = $xcantidad_notadebito;
	$arr_creditos_debitos['monto_notadebito'] = $xmonto_notadebito;

	return $arr_creditos_debitos;
	
}





function cantidades_montos_creditos_debitos_2_dia($xfecha_inicio, $xfecha_fin, $ddia, $conexion, $xemp_criterio){
	$arr_creditos_debitos = array();		
			
	//INICIO NOTA DE CREDITO
	$xcantidad_notacredito = 0;
	$xmonto_notacredito = 0;		
	
	$r_notacredito_cantidad = mysqli_query($conexion,"SELECT WEEKDAY(o.ordped_fechahora) AS dia,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
											WHERE notcre_estado=1
											    AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_cantidad=1
												AND WEEKDAY(o.ordped_fechahora) = $ddia
											GROUP BY dia;");
	while($row_notacredito_cantidad = mysqli_fetch_array($r_notacredito_cantidad)){
		$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										

	
	$r_notacredito_precio = mysqli_query($conexion,"SELECT WEEKDAY(o.ordped_fechahora) AS dia,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
											WHERE notcre_estado=1
											    AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_precio=1
												AND WEEKDAY(o.ordped_fechahora) = $ddia
											GROUP BY dia;");
	while($row_notacredito_precio = mysqli_fetch_array($r_notacredito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notacredito = $row_notacredito_precio['monto'] * -1;
	}										
	//FIN NOTA DE CREDITO




	//INICIO NOTA DE DEBITO
	$xcantidad_notadebito = 0;
	$xmonto_notadebito = 0;				
	
	$r_notadebito_cantidad = mysqli_query($conexion,"SELECT WEEKDAY(o.ordped_fechahora) AS dia,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
											WHERE notdeb_estado=1
											    AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_cantidad=1
												AND WEEKDAY(o.ordped_fechahora) = $ddia
											GROUP BY dia;");
	while($row_notadebito_cantidad = mysqli_fetch_array($r_notadebito_cantidad)){
		$xcantidad_notadebito = $row_notadebito_cantidad['cantidad'];
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										

	
	$r_notadebito_precio = mysqli_query($conexion,"SELECT WEEKDAY(o.ordped_fechahora) AS dia,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
											WHERE notdeb_estado=1
											    AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_precio=1
												AND WEEKDAY(o.ordped_fechahora) = $ddia
											GROUP BY dia;");
	while($row_notadebito_precio = mysqli_fetch_array($r_notadebito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notadebito = $row_notadebito_precio['monto'];
	}										
	//FIN NOTA DE DEBITO
	
	$arr_creditos_debitos['cantidad_notacredito'] = $xcantidad_notacredito;
	$arr_creditos_debitos['monto_notacredito'] = $xmonto_notacredito;
	$arr_creditos_debitos['cantidad_notadebito'] = $xcantidad_notadebito;
	$arr_creditos_debitos['monto_notadebito'] = $xmonto_notadebito;

	return $arr_creditos_debitos;
	
}



function cantidades_montos_creditos_debitos_2_hora($xfecha_inicio, $xfecha_fin, $hhora, $conexion, $xemp_criterio){
	$arr_creditos_debitos = array();		
			
	//INICIO NOTA DE CREDITO
	$xcantidad_notacredito = 0;
	$xmonto_notacredito = 0;			
	
	$r_notacredito_cantidad = mysqli_query($conexion,"SELECT ncd.prd_codi_fk, WEEKDAY(o.ordped_fechahora) AS dia,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
											WHERE notcre_estado=1
											    AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_cantidad=1
												AND HOUR(o.ordped_fechahora) = $hhora;");
	while($row_notacredito_cantidad = mysqli_fetch_array($r_notacredito_cantidad)){
		$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notacredito_precio = mysqli_query($conexion,"SELECT ncd.prd_codi_fk, WEEKDAY(o.ordped_fechahora) AS dia,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
											WHERE notcre_estado=1
											    AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_precio=1
												AND HOUR(o.ordped_fechahora) = $hhora;");
	while($row_notacredito_precio = mysqli_fetch_array($r_notacredito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notacredito = $row_notacredito_precio['monto'] * -1;
	}										
	//FIN NOTA DE CREDITO




	//INICIO NOTA DE DEBITO
	$xcantidad_notadebito = 0;
	$xmonto_notadebito = 0;			
	
	$r_notadebito_cantidad = mysqli_query($conexion,"SELECT ndd.prd_codi_fk, WEEKDAY(o.ordped_fechahora) AS dia,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
											WHERE notdeb_estado=1
											    AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_cantidad=1
												AND HOUR(o.ordped_fechahora) = $hhora;");
	while($row_notadebito_cantidad = mysqli_fetch_array($r_notadebito_cantidad)){
		$xcantidad_notadebito = $row_notadebito_cantidad['cantidad'];
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notadebito_precio = mysqli_query($conexion,"SELECT ndd.prd_codi_fk, WEEKDAY(o.ordped_fechahora) AS dia,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
											WHERE notdeb_estado=1
											    AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_precio=1
												AND HOUR(o.ordped_fechahora) = $hhora;");
	while($row_notadebito_precio = mysqli_fetch_array($r_notadebito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notadebito = $row_notadebito_precio['monto'];
	}										
	//FIN NOTA DE DEBITO
	
	$arr_creditos_debitos['cantidad_notacredito'] = $xcantidad_notacredito;
	$arr_creditos_debitos['monto_notacredito'] = $xmonto_notacredito;
	$arr_creditos_debitos['cantidad_notadebito'] = $xcantidad_notadebito;
	$arr_creditos_debitos['monto_notadebito'] = $xmonto_notadebito;

	return $arr_creditos_debitos;
	
}



function completar_cero_cantidades($xcantidad){
	if(strlen($xcantidad)==1){
		$xcantidad = "0".$xcantidad;
	}
		
	return $xcantidad;
}


function completar_cero_cantidades2($xcantidad){

	if(strlen($xcantidad)==1){
		$xcantidad = "00".$xcantidad;
	}

	if(strlen($xcantidad)==2){
		$xcantidad = "0".$xcantidad;
	}
		
	return $xcantidad;
}


function verificar_otros_atributos($campo, $parametro, $conexion){
	//SELECT 1 FROM usuarios u WHERE usu_editarpreciosenventas=1 AND usu_codi=2;
	$r = mysqli_query($conexion,"SELECT 1
								 FROM usuarios 
								 WHERE $campo = 1
								 AND usu_codi = $parametro 
								 LIMIT 1;");
	return mysqli_num_rows($r);
}






function cantidades_montos_creditos_debitos_clientes($xper_codi, $xfecha_inicio, $xfecha_fin, $conexion, $xemp_criterio){
	$arr_creditos_debitos = array();		
			
	//INICIO NOTA DE CREDITO
	$xcantidad_notacredito = 0;
	$xmonto_notacredito = 0;			
	
	$r_notacredito_cantidad = mysqli_query($conexion,"SELECT o.per_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
												INNER JOIN productos prd ON prd.prd_codi = ncd.prd_codi_fk
											WHERE o.per_codi_fk = $xper_codi
												AND notcre_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_cantidad=1;");
	while($row_notacredito_cantidad = mysqli_fetch_array($r_notacredito_cantidad)){
		$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notacredito_precio = mysqli_query($conexion,"SELECT o.per_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
												INNER JOIN productos prd ON prd.prd_codi = ncd.prd_codi_fk
											WHERE o.per_codi_fk = $xper_codi
												AND notcre_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_precio=1;");
	while($row_notacredito_precio = mysqli_fetch_array($r_notacredito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notacredito = $row_notacredito_precio['monto'] * -1;
	}										
	//FIN NOTA DE CREDITO




	//INICIO NOTA DE DEBITO
	$xcantidad_notadebito = 0;
	$xmonto_notadebito = 0;			
	
	$r_notadebito_cantidad = mysqli_query($conexion,"SELECT o.per_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
												INNER JOIN productos prd ON prd.prd_codi = ndd.prd_codi_fk
											WHERE o.per_codi_fk = $xper_codi
												AND notdeb_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_cantidad=1;");
	while($row_notadebito_cantidad = mysqli_fetch_array($r_notadebito_cantidad)){
		$xcantidad_notadebito = $row_notadebito_cantidad['cantidad'];
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notadebito_precio = mysqli_query($conexion,"SELECT o.per_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
												INNER JOIN productos prd ON prd.prd_codi = ndd.prd_codi_fk
											WHERE o.per_codi_fk = $xper_codi
												AND notdeb_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_precio=1;");
	while($row_notadebito_precio = mysqli_fetch_array($r_notadebito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notadebito = $row_notadebito_precio['monto'];
	}										
	//FIN NOTA DE DEBITO
	
	$arr_creditos_debitos['cantidad_notacredito'] = $xcantidad_notacredito;
	$arr_creditos_debitos['monto_notacredito'] = $xmonto_notacredito;
	$arr_creditos_debitos['cantidad_notadebito'] = $xcantidad_notadebito;
	$arr_creditos_debitos['monto_notadebito'] = $xmonto_notadebito;

	return $arr_creditos_debitos;
	
}





function cantidades_montos_creditos_debitos_productos_clientes($xprd_codi, $xfecha_inicio, $xfecha_fin, $conexion, $xemp_criterio, $xper_codi){
	$arr_creditos_debitos = array();	
	
	?>
	<script language="javascript">
	//alert("aqui");
	</script>
	<?php	
	
			
	//INICIO NOTA DE CREDITO
	$xcantidad_notacredito = 0;
	$xmonto_notacredito = 0;			
	
	$r_notacredito_cantidad = mysqli_query($conexion,"SELECT ncd.prd_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
											WHERE ncd.prd_codi_fk = $xprd_codi
												AND o.per_codi_fk=$xper_codi
												AND notcre_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_cantidad=1;");
	while($row_notacredito_cantidad = mysqli_fetch_array($r_notacredito_cantidad)){
		$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notacredito_precio = mysqli_query($conexion,"SELECT ncd.prd_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
											WHERE ncd.prd_codi_fk = $xprd_codi
												AND o.per_codi_fk=$xper_codi
												AND notcre_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_precio=1;");
	while($row_notacredito_precio = mysqli_fetch_array($r_notacredito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notacredito = $row_notacredito_precio['monto'] * -1;
	}										
	//FIN NOTA DE CREDITO




	//INICIO NOTA DE DEBITO
	$xcantidad_notadebito = 0;
	$xmonto_notadebito = 0;			
	
	$r_notadebito_cantidad = mysqli_query($conexion,"SELECT ndd.prd_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
											WHERE ndd.prd_codi_fk = $xprd_codi
												AND o.per_codi_fk=$xper_codi
												AND notdeb_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_cantidad=1;");
	while($row_notadebito_cantidad = mysqli_fetch_array($r_notadebito_cantidad)){
		$xcantidad_notadebito = $row_notadebito_cantidad['cantidad'];
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notadebito_precio = mysqli_query($conexion,"SELECT ndd.prd_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
											WHERE ndd.prd_codi_fk = $xprd_codi
												AND o.per_codi_fk=$xper_codi
												AND notdeb_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_precio=1;");
	while($row_notadebito_precio = mysqli_fetch_array($r_notadebito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notadebito = $row_notadebito_precio['monto'];
	}										
	//FIN NOTA DE DEBITO
	
	$arr_creditos_debitos['cantidad_notacredito'] = $xcantidad_notacredito;
	$arr_creditos_debitos['monto_notacredito'] = $xmonto_notacredito;
	$arr_creditos_debitos['cantidad_notadebito'] = $xcantidad_notadebito;
	$arr_creditos_debitos['monto_notadebito'] = $xmonto_notadebito;

	return $arr_creditos_debitos;
	
}



function cantidades_montos_creditos_debitos_2_flujodiario_producto($xfecha_inicio, $xfecha_fin, $conexion, $xemp_criterio, $xprd_codi){
         
	$arr_creditos_debitos = array();		
			
	//INICIO NOTA DE CREDITO
	$xcantidad_notacredito = 0;
	$xmonto_notacredito = 0;			
	
	$r_notacredito_cantidad = mysqli_query($conexion,"SELECT ncd.prd_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
											WHERE notcre_estado=1
											    AND o.emp_codi_fk=$xemp_criterio
												AND ncd.prd_codi_fk=$xprd_codi
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_cantidad=1;");
	while($row_notacredito_cantidad = mysqli_fetch_array($r_notacredito_cantidad)){
		$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notacredito_precio = mysqli_query($conexion,"SELECT ncd.prd_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
											WHERE notcre_estado=1
											    AND o.emp_codi_fk=$xemp_criterio
												AND ncd.prd_codi_fk=$xprd_codi
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_precio=1;");
	while($row_notacredito_precio = mysqli_fetch_array($r_notacredito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notacredito = $row_notacredito_precio['monto'] * -1;
	}										
	//FIN NOTA DE CREDITO




	//INICIO NOTA DE DEBITO
	$xcantidad_notadebito = 0;
	$xmonto_notadebito = 0;			
	
	$r_notadebito_cantidad = mysqli_query($conexion,"SELECT ndd.prd_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
											WHERE notdeb_estado=1
											    AND o.emp_codi_fk=$xemp_criterio
												AND ndd.prd_codi_fk=$xprd_codi
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_cantidad=1;");
	while($row_notadebito_cantidad = mysqli_fetch_array($r_notadebito_cantidad)){
		$xcantidad_notadebito = $row_notadebito_cantidad['cantidad'];
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notadebito_precio = mysqli_query($conexion,"SELECT ndd.prd_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
											WHERE notdeb_estado=1
											    AND o.emp_codi_fk=$xemp_criterio
												AND ndd.prd_codi_fk=$xprd_codi
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_precio=1;");
	while($row_notadebito_precio = mysqli_fetch_array($r_notadebito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notadebito = $row_notadebito_precio['monto'];
	}										
	//FIN NOTA DE DEBITO
	
	$arr_creditos_debitos['cantidad_notacredito'] = $xcantidad_notacredito;
	$arr_creditos_debitos['monto_notacredito'] = $xmonto_notacredito;
	$arr_creditos_debitos['cantidad_notadebito'] = $xcantidad_notadebito;
	$arr_creditos_debitos['monto_notadebito'] = $xmonto_notadebito;

	return $arr_creditos_debitos;
	
}





function cantidades_montos_creditos_debitos_clientes_total($xfecha_inicio, $xfecha_fin, $conexion, $xemp_criterio, $xper_codi){
	$arr_creditos_debitos = array();	
	
	?>
	<script language="javascript">
	//alert("aqui");
	</script>
	<?php	
	
			
	//INICIO NOTA DE CREDITO
	$xcantidad_notacredito = 0;
	$xmonto_notacredito = 0;			
	
	$r_notacredito_cantidad = mysqli_query($conexion,"SELECT ncd.prd_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
											WHERE o.per_codi_fk=$xper_codi
												AND notcre_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_cantidad=1;");
	while($row_notacredito_cantidad = mysqli_fetch_array($r_notacredito_cantidad)){
		$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notacredito_precio = mysqli_query($conexion,"SELECT ncd.prd_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
											WHERE o.per_codi_fk=$xper_codi
												AND notcre_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_precio=1;");
	while($row_notacredito_precio = mysqli_fetch_array($r_notacredito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notacredito = $row_notacredito_precio['monto'] * -1;
	}										
	//FIN NOTA DE CREDITO




	//INICIO NOTA DE DEBITO
	$xcantidad_notadebito = 0;
	$xmonto_notadebito = 0;			
	
	$r_notadebito_cantidad = mysqli_query($conexion,"SELECT ndd.prd_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
											WHERE o.per_codi_fk=$xper_codi
												AND notdeb_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_cantidad=1;");
	while($row_notadebito_cantidad = mysqli_fetch_array($r_notadebito_cantidad)){
		$xcantidad_notadebito = $row_notadebito_cantidad['cantidad'];
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notadebito_precio = mysqli_query($conexion,"SELECT ndd.prd_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
											WHERE o.per_codi_fk=$xper_codi
												AND notdeb_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_precio=1;");
	while($row_notadebito_precio = mysqli_fetch_array($r_notadebito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notadebito = $row_notadebito_precio['monto'];
	}										
	//FIN NOTA DE DEBITO
	
	$arr_creditos_debitos['cantidad_notacredito'] = $xcantidad_notacredito;
	$arr_creditos_debitos['monto_notacredito'] = $xmonto_notacredito;
	$arr_creditos_debitos['cantidad_notadebito'] = $xcantidad_notadebito;
	$arr_creditos_debitos['monto_notadebito'] = $xmonto_notadebito;

	return $arr_creditos_debitos;
	
}




function cantidades_montos_creditos_debitos_dia_cliente($xper_codi, $xfecha_inicio, $xfecha_fin, $ddia, $conexion, $xemp_criterio){
	$arr_creditos_debitos = array();		
			
	//INICIO NOTA DE CREDITO
	$xcantidad_notacredito = 0;
	$xmonto_notacredito = 0;			
	
	$r_notacredito_cantidad = mysqli_query($conexion,"SELECT ncd.prd_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
											WHERE o.per_codi_fk = $xper_codi
												AND notcre_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_cantidad=1
												AND WEEKDAY(o.ordped_fechahora) = $ddia;");
	while($row_notacredito_cantidad = mysqli_fetch_array($r_notacredito_cantidad)){
		$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notacredito_precio = mysqli_query($conexion,"SELECT ncd.prd_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
											WHERE o.per_codi_fk = $xper_codi
												AND notcre_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_precio=1
												AND WEEKDAY(o.ordped_fechahora) = $ddia;");
	while($row_notacredito_precio = mysqli_fetch_array($r_notacredito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notacredito = $row_notacredito_precio['monto'] * -1;
	}										
	//FIN NOTA DE CREDITO




	//INICIO NOTA DE DEBITO
	$xcantidad_notadebito = 0;
	$xmonto_notadebito = 0;			
	
	$r_notadebito_cantidad = mysqli_query($conexion,"SELECT ndd.prd_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
											WHERE o.per_codi_fk = $xper_codi
												AND notdeb_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_cantidad=1
												AND WEEKDAY(o.ordped_fechahora) = $ddia;");
	while($row_notadebito_cantidad = mysqli_fetch_array($r_notadebito_cantidad)){
		$xcantidad_notadebito = $row_notadebito_cantidad['cantidad'];
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notadebito_precio = mysqli_query($conexion,"SELECT ndd.prd_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
											WHERE o.per_codi_fk = $xper_codi
												AND notdeb_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_precio=1
												AND WEEKDAY(o.ordped_fechahora) = $ddia;");
	while($row_notadebito_precio = mysqli_fetch_array($r_notadebito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notadebito = $row_notadebito_precio['monto'];
	}										
	//FIN NOTA DE DEBITO
	
	$arr_creditos_debitos['cantidad_notacredito'] = $xcantidad_notacredito;
	$arr_creditos_debitos['monto_notacredito'] = $xmonto_notacredito;
	$arr_creditos_debitos['cantidad_notadebito'] = $xcantidad_notadebito;
	$arr_creditos_debitos['monto_notadebito'] = $xmonto_notadebito;

	return $arr_creditos_debitos;
	
}




function cantidades_montos_creditos_debitos_hora_cliente($xper_codi, $xfecha_inicio, $xfecha_fin, $hhora, $conexion, $xemp_criterio){
	$arr_creditos_debitos = array();		
			
	//INICIO NOTA DE CREDITO
	$xcantidad_notacredito = 0;
	$xmonto_notacredito = 0;			
	
	$r_notacredito_cantidad = mysqli_query($conexion,"SELECT ncd.prd_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
											WHERE o.per_codi_fk = $xper_codi
												AND notcre_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_cantidad=1
												AND HOUR(o.ordped_fechahora) = $hhora;");
	while($row_notacredito_cantidad = mysqli_fetch_array($r_notacredito_cantidad)){
		$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notacredito_precio = mysqli_query($conexion,"SELECT ncd.prd_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
											WHERE o.per_codi_fk = $xper_codi
												AND notcre_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_precio=1
												AND HOUR(o.ordped_fechahora) = $hhora;");
	while($row_notacredito_precio = mysqli_fetch_array($r_notacredito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notacredito = $row_notacredito_precio['monto'] * -1;
	}										
	//FIN NOTA DE CREDITO




	//INICIO NOTA DE DEBITO
	$xcantidad_notadebito = 0;
	$xmonto_notadebito = 0;			
	
	$r_notadebito_cantidad = mysqli_query($conexion,"SELECT ndd.prd_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
											WHERE o.per_codi_fk = $xper_codi
												AND notdeb_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_cantidad=1
												AND HOUR(o.ordped_fechahora) = $hhora;");
	while($row_notadebito_cantidad = mysqli_fetch_array($r_notadebito_cantidad)){
		$xcantidad_notadebito = $row_notadebito_cantidad['cantidad'];
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notadebito_precio = mysqli_query($conexion,"SELECT ndd.prd_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
											WHERE o.per_codi_fk = $xper_codi
												AND notdeb_estado=1
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_precio=1
												AND HOUR(o.ordped_fechahora) = $hhora;");
	while($row_notadebito_precio = mysqli_fetch_array($r_notadebito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notadebito = $row_notadebito_precio['monto'];
	}										
	//FIN NOTA DE DEBITO
	
	$arr_creditos_debitos['cantidad_notacredito'] = $xcantidad_notacredito;
	$arr_creditos_debitos['monto_notacredito'] = $xmonto_notacredito;
	$arr_creditos_debitos['cantidad_notadebito'] = $xcantidad_notadebito;
	$arr_creditos_debitos['monto_notadebito'] = $xmonto_notadebito;

	return $arr_creditos_debitos;
	
}




function cantidades_montos_creditos_debitos_clientes_ventas($xper_codi, $xfecha_inicio, $xfecha_fin, $conexion, $xemp_criterio, $xordped_codi){
	$arr_creditos_debitos = array();		
			
	//INICIO NOTA DE CREDITO
	$xcantidad_notacredito = 0;
	$xmonto_notacredito = 0;			
	
	$r_notacredito_cantidad = mysqli_query($conexion,"SELECT o.per_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
												INNER JOIN productos prd ON prd.prd_codi = ncd.prd_codi_fk
											WHERE o.per_codi_fk = $xper_codi
												AND notcre_estado=1
												AND o.ordped_codi = $xordped_codi
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_cantidad=1;");
	while($row_notacredito_cantidad = mysqli_fetch_array($r_notacredito_cantidad)){
		$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notacredito_precio = mysqli_query($conexion,"SELECT o.per_codi_fk,
												sum(notcredet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notcredet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notcredet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_credito nc ON nc.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk=nc.notcre_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ncd.unimed_codi_fk
												INNER JOIN nota_credito_tipo nct ON nct.notcretip_codi = nc.notcretip_codi_fk
												INNER JOIN productos prd ON prd.prd_codi = ncd.prd_codi_fk
											WHERE o.per_codi_fk = $xper_codi
												AND notcre_estado=1
												AND o.ordped_codi = $xordped_codi
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notcredet_cantidad_devolver!=0
												AND notcredet_precio_descuento!=0 
												AND notcretip_suma_precio=1;");
	while($row_notacredito_precio = mysqli_fetch_array($r_notacredito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notacredito = $row_notacredito_precio['monto'] * -1;
	}										
	//FIN NOTA DE CREDITO




	//INICIO NOTA DE DEBITO
	$xcantidad_notadebito = 0;
	$xmonto_notadebito = 0;			
	
	$r_notadebito_cantidad = mysqli_query($conexion,"SELECT o.per_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
												INNER JOIN productos prd ON prd.prd_codi = ndd.prd_codi_fk
											WHERE o.per_codi_fk = $xper_codi
												AND notdeb_estado = 1
												AND o.ordped_codi = $xordped_codi
												AND o.emp_codi_fk = $xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_cantidad=1;");
	while($row_notadebito_cantidad = mysqli_fetch_array($r_notadebito_cantidad)){
		$xcantidad_notadebito = $row_notadebito_cantidad['cantidad'];
		//$xmonto_notacredito = $row_notacredito['monto'] * -1;
	
	}										


	$r_notadebito_precio = mysqli_query($conexion,"SELECT o.per_codi_fk,
												sum(notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) as cantidad,
												sum((notdebdet_cantidad_devolver * u.unimed_cantidad_unidad) * 
												(notdebdet_precio_descuento / u.unimed_cantidad_unidad)) as monto
											FROM orden_pedido o
												INNER JOIN nota_debito nd ON nd.ordped_codi_fk=o.ordped_codi
												INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk=nd.notdeb_codi
												INNER JOIN unidades_medida u ON u.unimed_codi = ndd.unimed_codi_fk
												INNER JOIN nota_debito_tipo ndt ON ndt.notdebtip_codi = nd.notdebtip_codi_fk
												INNER JOIN productos prd ON prd.prd_codi = ndd.prd_codi_fk
											WHERE o.per_codi_fk = $xper_codi
												AND notdeb_estado=1
												AND o.ordped_codi = $xordped_codi
												AND o.emp_codi_fk=$xemp_criterio
												AND o.ordped_fecha<='$xfecha_fin'
												AND	o.ordped_fecha>='$xfecha_inicio'
												AND notdebdet_cantidad_devolver!=0
												AND notdebdet_precio_descuento!=0 
												AND notdebtip_suma_precio=1;");
	while($row_notadebito_precio = mysqli_fetch_array($r_notadebito_precio)){
		//$xcantidad_notacredito = $row_notacredito_cantidad['cantidad'] * -1;
		$xmonto_notadebito = $row_notadebito_precio['monto'];
	}										
	//FIN NOTA DE DEBITO
	
	$arr_creditos_debitos['cantidad_notacredito'] = $xcantidad_notacredito;
	$arr_creditos_debitos['monto_notacredito'] = $xmonto_notacredito;
	$arr_creditos_debitos['cantidad_notadebito'] = $xcantidad_notadebito;
	$arr_creditos_debitos['monto_notadebito'] = $xmonto_notadebito;

	return $arr_creditos_debitos;
	
}


function costo_promedio_ponderado($xprd_codi, $xfecha_inicio, $xfecha_fin, $xempresa_criterio, $conexion){
	$xcpp = 0;
	$r_cpp = mysqli_query($conexion,"SELECT ocd.prd_codi_fk, ROUND(SUM(ocd.ordcomdet_precio * ocd.ordcomdet_cantidad) / SUM(ocd.ordcomdet_cantidad), 2) AS precio_costo_ponderado
							FROM orden_compra_detalle ocd
							INNER JOIN orden_compra oc ON oc.ordcom_codi = ocd.ordcom_codi_fk
							WHERE ocd.prd_codi_fk = $xprd_codi
							AND ordcom_estado=1
							AND oc.emp_codi_fk = $xempresa_criterio
							AND oc.ordcom_fecha<='$xfecha_fin'
							AND	oc.ordcom_fecha>='$xfecha_inicio'
							GROUP BY ocd.prd_codi_fk;");
	while($row_cpp = mysqli_fetch_array($r_cpp)){
		$xcpp = $row_cpp['precio_costo_ponderado'];
	}		
	
	if($xcpp==0){
		$r_cpp = mysqli_query($conexion,"SELECT ordcom_fechahora, ocd.prd_codi_fk, ocd.ordcomdet_precio
										FROM orden_compra_detalle ocd
										INNER JOIN orden_compra oc ON oc.ordcom_codi = ocd.ordcom_codi_fk
										WHERE ocd.prd_codi_fk = $xprd_codi
										AND ordcom_estado=1
										AND oc.emp_codi_fk = $xempresa_criterio
										ORDER BY ordcom_fechahora DESC
										LIMIT 1;");
		while($row_cpp = mysqli_fetch_array($r_cpp)){
			$xcpp = $row_cpp['ordcomdet_precio'];
		}		
		
		if($xcpp==0){
			$r_cpp = mysqli_query($conexion,"SELECT prd_preciocosto 
											FROM productos p 
											WHERE prd_codi = $xprd_codi;");
			while($row_cpp = mysqli_fetch_array($r_cpp)){
				$xcpp = $row_cpp['prd_preciocosto'];
			}		
		
		}
	}
	
	return $xcpp;				
}


@$xper_codi = $_REQUEST['xper_codi'];
@$xaccion_funciones = $_REQUEST['xaccion_funciones'];
if($xaccion_funciones == 'verificar_cliente_credito'){
	//echo "VERIFICANDO";
	verificar_cliente_credito($xper_codi);
}


function verificar_cliente_credito($xper_codi){
	global $conexion;	
	$nprov = 0;
	$arr_veri_credito = array();
	$r = mysqli_query($conexion,"SELECT p.*,
								SUM((ordpeddet_precio * ordpeddet_cantidad) + (ordpeddet_icbper_monto_unitario * ordpeddet_cantidad))  AS monto  
								FROM personas p 
								LEFT JOIN orden_pedido o ON o.per_codi_fk = p.per_codi AND o.ordped_estado = 1
								LEFT JOIN orden_pedido_detalle opd ON opd.ordped_codi_fk=o.ordped_codi
								WHERE per_codi=$xper_codi
								GROUP BY per_codi
								ORDER BY per_nombre_comercial, per_nombre, per_apellido;");
	
	
								  
  	while($row = mysqli_fetch_array($r)){	
		$nprov = $nprov + 1;
		//echo $xano_inicio." - ".$xano_fin;
		$xper_codi = $row['per_codi'];
		
		
		$xper_credito = $row['per_credito'];
	
		if($xper_credito!=1){
		?>
			<script language="javascript">
			alert("El cliente seleccionado no cuenta con CREDITO aprobado.");
			</script>
		<?php
			exit;
		}
	
		$xlinea_credito = $row['per_importe_credito'];
		
		$xmonto = $row['monto'];
		
		$xmonto_caja = 0;
		$r_amortizado = mysqli_query($conexion,"SELECT SUM(opecaj_monto) AS monto_caja
												FROM orden_pedido_caja opc
													INNER JOIN operacion_caja oc ON oc.opecaj_codi=opc.opecaj_codi_fk
												WHERE oc.per_codi_fk = $xper_codi
													AND opecaj_estado = 1
												GROUP BY per_codi_fk;");
		while($row_amortizado = mysqli_fetch_array($r_amortizado)){
			$xmonto_caja = $row_amortizado['monto_caja'];
		}
		
		
		//INICIO NOTA DE CREDITO RELACIONADAS
		$r_nota_credito = mysqli_query($conexion,"SELECT per_codi_fk, SUM(notcredet_cantidad_devolver * notcredet_precio_descuento) AS monto_nota_credito
														FROM nota_credito n
															INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk = n.notcre_codi
															INNER JOIN orden_pedido op ON op.ordped_codi=n.ordped_codi_fk
														WHERE op.per_codi_fk = $xper_codi
														ORDER BY notcre_fecha;");
		
		$xmonto_pendiente_nota_credito = 0;
		$xmonto_nota_credito = 0;
		$xmonto_amortizado_nota_credito = 0; 
		while($row_nota_credito = mysqli_fetch_array($r_nota_credito)){
			
			$xmonto_nota_credito = $row_nota_credito['monto_nota_credito'] * -1;	
			
			$xmonto_amortizado_nota_credito = 0;	
			$r_amortizado_nota_credito = mysqli_query($conexion,"SELECT op.per_codi_fk, SUM(opecaj_monto) AS monto_amortizado
																FROM operacion_caja oc
																	INNER JOIN nota_credito_caja ncc ON ncc.opecaj_codi_fk = oc.opecaj_codi
																	INNER JOIN nota_credito nc ON nc.notcre_codi = ncc.notcre_codi_fk
																	INNER JOIN orden_pedido op ON op.ordped_codi = nc.ordped_codi_fk
																WHERE op.per_codi_fk = $xper_codi
																	AND oc.opecaj_estado = 1;");
			while($row_amortizado_nota_credito = mysqli_fetch_array($r_amortizado_nota_credito)){
				$xmonto_amortizado_nota_credito = number_format($row_amortizado_nota_credito['monto_amortizado'] * -1, 2,'.','');
			}
								
			$xmonto_pendiente_nota_credito = $xmonto_nota_credito - $xmonto_amortizado_nota_credito;					
		}				
		//FIN NOTA DE CREDITO RELACIONADAS
		
		
		
		//INICIO NOTA DE DEBITO RELACIONADAS
		$r_nota_debito = mysqli_query($conexion,"SELECT per_codi_fk, SUM(notdebdet_cantidad_devolver * notdebdet_precio_descuento) AS monto_nota_debito
														FROM nota_debito n
															INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk = n.notdeb_codi
															INNER JOIN orden_pedido op ON op.ordped_codi=n.ordped_codi_fk
														WHERE op.per_codi_fk = $xper_codi
														ORDER BY notdeb_fecha;");
		
		$xmonto_pendiente_nota_debito = 0;
		$xmonto_nota_debito = 0;
		$xmonto_amortizado_nota_debito = 0; 
		while($row_nota_debito = mysqli_fetch_array($r_nota_debito)){
			
			$xmonto_nota_debito = $row_nota_debito['monto_nota_debito'];	
			
			$xmonto_amortizado_nota_debito = 0;	
			$r_amortizado_nota_debito = mysqli_query($conexion,"SELECT op.per_codi_fk, SUM(opecaj_monto) AS monto_amortizado
																FROM operacion_caja oc
																	INNER JOIN nota_debito_caja ndc ON ndc.opecaj_codi_fk = oc.opecaj_codi
																	INNER JOIN nota_debito nd ON nd.notdeb_codi = ndc.notdeb_codi_fk
																	INNER JOIN orden_pedido op ON op.ordped_codi = nd.ordped_codi_fk
																WHERE op.per_codi_fk = $xper_codi
																	AND oc.opecaj_estado = 1;");
			while($row_amortizado_nota_debito = mysqli_fetch_array($r_amortizado_nota_debito)){
				$xmonto_amortizado_nota_debito = number_format($row_amortizado_nota_debito['monto_amortizado'], 2,'.','');
			}
								
			$xmonto_pendiente_nota_debito = $xmonto_nota_debito - $xmonto_amortizado_nota_debito;					
		}				
		//FIN NOTA DE DEBITO RELACIONADAS
		
		
		$xmonto_ventas = $xmonto + $xmonto_nota_credito + $xmonto_nota_debito;
		$xmonto_caja_cobrado = $xmonto_caja + $xmonto_amortizado_nota_credito + $xmonto_amortizado_nota_debito;
		
		$xsaldo_deudor = $xmonto_ventas - $xmonto_caja_cobrado;
		//$xsaldo_deudor = $xmonto - $xmonto_caja;
		$xcredito_disponible = $xlinea_credito - $xsaldo_deudor; 
		
		$arr_veri_credito['per_credito'] = $xper_credito;
		$arr_veri_credito['linea_credito'] = $xlinea_credito;
		$arr_veri_credito['credito_disponible'] = $xcredito_disponible;
		$arr_veri_credito['saldo_deudor'] = $xsaldo_deudor;

		if($xcredito_disponible<=0){
		?>
			<script language="javascript">
			alert("El cliente seleccionado no cuenta con CREDITO disponible.");
			</script>
		<?php
			exit;
		}

		
	}
		
}




function verificar_cliente_credito2($xper_codi){
	global $conexion;	
	$nprov = 0;
	$arr_veri_credito = array();
	$r = mysqli_query($conexion,"SELECT p.*,
								SUM((ordpeddet_precio * ordpeddet_cantidad) + (ordpeddet_icbper_monto_unitario * ordpeddet_cantidad))  AS monto  
								FROM personas p 
								LEFT JOIN orden_pedido o ON o.per_codi_fk = p.per_codi AND o.ordped_estado = 1
								LEFT JOIN orden_pedido_detalle opd ON opd.ordped_codi_fk=o.ordped_codi
								WHERE per_codi=$xper_codi
								GROUP BY per_codi
								ORDER BY per_nombre_comercial, per_nombre, per_apellido;");
	
	
								  
  	while($row = mysqli_fetch_array($r)){	
		$nprov = $nprov + 1;
		//echo $xano_inicio." - ".$xano_fin;
		$xper_codi = $row['per_codi'];
		
		
		$xper_credito = $row['per_credito'];
	
		if($xper_credito!=1){
			$arr_veri_credito['per_credito'] = $xper_credito;
			$arr_veri_credito['linea_credito'] = 0;
			$arr_veri_credito['credito_disponible'] = 0;
		
			return $arr_veri_credito;
			exit;
		}
	
		$xlinea_credito = $row['per_importe_credito'];
		
		$xmonto = $row['monto'];
		
		$xmonto_caja = 0;
		$r_amortizado = mysqli_query($conexion,"SELECT SUM(opecaj_monto) AS monto_caja
												FROM orden_pedido_caja opc
													INNER JOIN operacion_caja oc ON oc.opecaj_codi=opc.opecaj_codi_fk
												WHERE oc.per_codi_fk = $xper_codi
													AND opecaj_estado = 1
												GROUP BY per_codi_fk;");
		while($row_amortizado = mysqli_fetch_array($r_amortizado)){
			$xmonto_caja = $row_amortizado['monto_caja'];
		}
		
		
		//INICIO NOTA DE CREDITO RELACIONADAS
		$r_nota_credito = mysqli_query($conexion,"SELECT per_codi_fk, SUM(notcredet_cantidad_devolver * notcredet_precio_descuento) AS monto_nota_credito
														FROM nota_credito n
															INNER JOIN nota_credito_detalle ncd ON ncd.notcre_codi_fk = n.notcre_codi
															INNER JOIN orden_pedido op ON op.ordped_codi=n.ordped_codi_fk
														WHERE op.per_codi_fk = $xper_codi
														ORDER BY notcre_fecha;");
		
		$xmonto_pendiente_nota_credito = 0;
		$xmonto_nota_credito = 0;
		$xmonto_amortizado_nota_credito = 0; 
		while($row_nota_credito = mysqli_fetch_array($r_nota_credito)){
			
			$xmonto_nota_credito = $row_nota_credito['monto_nota_credito'] * -1;	
			
			$xmonto_amortizado_nota_credito = 0;	
			$r_amortizado_nota_credito = mysqli_query($conexion,"SELECT op.per_codi_fk, SUM(opecaj_monto) AS monto_amortizado
																FROM operacion_caja oc
																	INNER JOIN nota_credito_caja ncc ON ncc.opecaj_codi_fk = oc.opecaj_codi
																	INNER JOIN nota_credito nc ON nc.notcre_codi = ncc.notcre_codi_fk
																	INNER JOIN orden_pedido op ON op.ordped_codi = nc.ordped_codi_fk
																WHERE op.per_codi_fk = $xper_codi
																	AND oc.opecaj_estado = 1;");
			while($row_amortizado_nota_credito = mysqli_fetch_array($r_amortizado_nota_credito)){
				$xmonto_amortizado_nota_credito = number_format($row_amortizado_nota_credito['monto_amortizado'] * -1, 2,'.','');
			}
								
			$xmonto_pendiente_nota_credito = $xmonto_nota_credito - $xmonto_amortizado_nota_credito;					
		}				
		//FIN NOTA DE CREDITO RELACIONADAS
		
		
		
		//INICIO NOTA DE DEBITO RELACIONADAS
		$r_nota_debito = mysqli_query($conexion,"SELECT per_codi_fk, SUM(notdebdet_cantidad_devolver * notdebdet_precio_descuento) AS monto_nota_debito
														FROM nota_debito n
															INNER JOIN nota_debito_detalle ndd ON ndd.notdeb_codi_fk = n.notdeb_codi
															INNER JOIN orden_pedido op ON op.ordped_codi=n.ordped_codi_fk
														WHERE op.per_codi_fk = $xper_codi
														ORDER BY notdeb_fecha;");
		
		$xmonto_pendiente_nota_debito = 0;
		$xmonto_nota_debito = 0;
		$xmonto_amortizado_nota_debito = 0; 
		while($row_nota_debito = mysqli_fetch_array($r_nota_debito)){
			
			$xmonto_nota_debito = $row_nota_debito['monto_nota_debito'];	
			
			$xmonto_amortizado_nota_debito = 0;	
			$r_amortizado_nota_debito = mysqli_query($conexion,"SELECT op.per_codi_fk, SUM(opecaj_monto) AS monto_amortizado
																FROM operacion_caja oc
																	INNER JOIN nota_debito_caja ndc ON ndc.opecaj_codi_fk = oc.opecaj_codi
																	INNER JOIN nota_debito nd ON nd.notdeb_codi = ndc.notdeb_codi_fk
																	INNER JOIN orden_pedido op ON op.ordped_codi = nd.ordped_codi_fk
																WHERE op.per_codi_fk = $xper_codi
																	AND oc.opecaj_estado = 1;");
			while($row_amortizado_nota_debito = mysqli_fetch_array($r_amortizado_nota_debito)){
				$xmonto_amortizado_nota_debito = number_format($row_amortizado_nota_debito['monto_amortizado'], 2,'.','');
			}
								
			$xmonto_pendiente_nota_debito = $xmonto_nota_debito - $xmonto_amortizado_nota_debito;					
		}				
		//FIN NOTA DE DEBITO RELACIONADAS
		
		
		$xmonto_ventas = $xmonto + $xmonto_nota_credito + $xmonto_nota_debito;
		$xmonto_caja_cobrado = $xmonto_caja + $xmonto_amortizado_nota_credito + $xmonto_amortizado_nota_debito;
		
		$xsaldo_deudor = $xmonto_ventas - $xmonto_caja_cobrado;
		//$xsaldo_deudor = $xmonto - $xmonto_caja;
		$xcredito_disponible = $xlinea_credito - $xsaldo_deudor; 
		
		$arr_veri_credito['per_credito'] = $xper_credito;
		$arr_veri_credito['linea_credito'] = $xlinea_credito;
		$arr_veri_credito['credito_disponible'] = $xcredito_disponible;
		$arr_veri_credito['saldo_deudor'] = $xsaldo_deudor;
	
		return $arr_veri_credito;
			
		/*
		if($xcredito_disponible<=0){
		?>
			<script language="javascript">
			alert("El cliente seleccionado no cuenta con CREDITO disponible.");
			</script>
		<?php
			exit;
		}
		*/
		
	}
	
}





/*
SELECT * FROM orden_compra_detalle ocd
WHERE ocd.ordcom_codi_fk=22;

SELECT * FROM orden_compra_almacen oca
INNER JOIN operacion_almacen_detalle oad ON oad.opealm_codi_fk=oca.opealm_codi_fk
WHERE oca.ordcom_codi_fk=22;
*/

?>